//-----------------------------------------------------------------------------
// Game_Party
//
// The game object class for the party. 

Objects.Party = class Party {
  initialize() {
    this._steps = 0;
    this._actors = [];
  }

  getDataForSaveFile() {
    return Object.assign({}, this);
  }

  restoreData(data) {
    Utils.assignProperties(this, data);
  }

  exists() {
    return this._actors.length > 0;
  }

  size() {
    return this._actors.length;
    // return this.members().length;
  }

  isEmpty() {
    return this.size() === 0;
  }

  members() {
    return this.allMembers();
  }

  getCompanionName() {
    if (this.members().length < 2) return '';

    return this.members()[1].name();
  }

  hasCompanion() {
    return this.size() > 1;
  }

  isVillagerOnParty(villagerName) {
    if (!this.hasCompanion()) return false;

    const companion = this.companion();
    if (companion.name().toLowerCase() != villagerName.toLowerCase()) return false;

    return true;
  }

  allMembers() {
    return this._actors.map(id => {
      if ((typeof id) == 'number') {
        return $gameActors.actor(id);
      }

      return Managers.Creatures.getCreatureById(id);
    });
  }

  leader() {
    return this.members()[0];
  }

  companion() {
    return this.members()[1];
  }

  maxPartyMembers() {
    return 2;
  }

  setupStartingMembers() {
    // Managers.Player.changeActorData();
    
    this._actors = [];
    $dataSystem.partyMembers.forEach(function(actorId) {
      if ($gameActors.actor(actorId)) {
        this._actors.push(actorId);
      }
    }, this);
  }

  addActor(actorId) {
    if (!this._actors.contains(actorId)) {
      this._actors.push(actorId);
      $gamePlayer.refresh();
      $gameMap.requestRefresh();
    }
  }

  addVillager(villagerName) {
    const actorData = Managers.Villagers.getActorData(villagerName);

    return this.addActor(actorData.id);
  }

  removeActor(actorId) {
    if (this._actors.contains(actorId)) {
      this._actors.splice(this._actors.indexOf(actorId), 1);
      $gamePlayer.refresh();
      $gameMap.requestRefresh();
    }
  }

  removeVillager(villagerName) {
    const actorData = Managers.Villagers.getActorData(villagerName);

    return this.removeActor(actorData.id);
  }

  dropCompanion() {
    if (this.hasCompanion()) {
      this.removeVillager(this.companion()._name);
    }
  }

  steps() {
    return this._steps;
  }

  increaseSteps() {
    this._steps++;
  }

  onPlayerWalk() {
    this.members().forEach(actor => actor.onPlayerWalk());
  }

  charactersForSavefile() {
    return [ [$gamePlayer.characterName(), $gamePlayer.characterIndex()] ];
  }

  facesForSavefile() {
    return [];
  }

  setFollowerPosition(x, y, d) {
    $gamePlayer.setFollowerPosition(x, y, d);
  }
};
