//-----------------------------------------------------------------------------
// Game_Message
//
// The game object class for the state of the message window that displays text
// or selections, etc.

Objects.Message = class Message {
  constructor() {
    this.initialize(...arguments);
  }

  initialize() {
    this.clear();
  }

  clear() {
    this._texts = [];
    this._choices = [];
    this._faceName = '';
    this._faceIndex = 0;
    this._background = 0;
    this._positionType = 2;
    this._choiceDefaultType = 0;
    this._choiceCancelType = 0;
    this._choiceBackground = 0;
    this._choicePositionType = 2;
    this._numInputVariableId = 0;
    this._numInputMaxDigits = 0;
    this._numInputMaxValue = 0;
    this._scrollMode = false;
    this._scrollSpeed = 2;
    this._scrollNoFast = false;
    this._choiceCallback = null;
    this._messageTarget = null;
  }

  choices() {
    return this._choices;
  }

  faceName() {
    return this._faceName;
  }

  faceIndex() {
    return this._faceIndex;
  }

  background() {
    return this._background;
  }

  positionType() {
    return this._positionType;
  }

  choiceDefaultType() {
    return this._choiceDefaultType;
  }

  choiceCancelType() {
    return this._choiceCancelType;
  }

  choiceBackground() {
    return this._choiceBackground;
  }

  choicePositionType() {
    return this._choicePositionType;
  }

  numInputVariableId() {
    return this._numInputVariableId;
  }

  numInputMaxDigits() {
    return this._numInputMaxDigits;
  }

  numInputMaxValue() {
    return this._numInputMaxValue;
  }

  scrollMode() {
    return this._scrollMode;
  }

  scrollSpeed() {
    return this._scrollSpeed;
  }

  scrollNoFast() {
    return this._scrollNoFast;
  }

  getColorValue(colorName) {
    return Managers.Text.getColorValue(colorName);
  }

  add(text) {
    this._texts.push(text);
  }

  addText(text) {
    if ($gameSystem.wordWrap()) {
      text = `<WordWrap>${text}`;
    }
    this.add(text);
  }

  tAdd(text) {
    this.add(t(text));
  }

  setFaceImage(faceName, faceIndex) {
    this._faceName = faceName;
    this._faceIndex = faceIndex;
  }

  setBackground(background) {
    this._background = background;
  }

  setMessageTarget(target) {
    this._messageTarget = target;
  }

  getMessageTarget() {
    return this._messageTarget;
  }

  setPositionType(positionType) {
    this._positionType = positionType;
  }

  setChoices(choices, defaultType, cancelType) {
    const translatedChoices = [];
    for (let i = 0; i < choices.length; i++) {
      let translatedLine = t(choices[i]);
      translatedLine = Managers.CommonEvent.replaceVariables(translatedLine);
      translatedChoices.push(translatedLine);
    }

    this._choices = translatedChoices;
    this._choiceDefaultType = defaultType;
    this._choiceCancelType = cancelType;
  }

  setChoiceBackground(background) {
    this._choiceBackground = background;
  }

  setChoicePositionType(positionType) {
    this._choicePositionType = positionType;
  }

  setNumberInput(variableId, maxDigits) {
    this._numInputVariableId = variableId;
    this._numInputMaxDigits = maxDigits;
    this._numInputMaxValue = 10 ** maxDigits - 1;
  }

  setVariableInput(variableId, maxValue) {
    this._numInputVariableId = variableId;

    if (isNaN(Number(maxValue))) {
      maxValue = Variables[maxValue];
    }

    this._numInputMaxValue = maxValue;
    this._numInputMaxDigits = maxValue.toString().length;
  }

  setScroll(speed, noFast) {
    this._scrollMode = true;
    this._scrollSpeed = speed;
    this._scrollNoFast = noFast;
  }

  setChoiceCallback(callback) {
    this._choiceCallback = callback;
  }

  onChoice(n) {
    if (this._choiceCallback) {
      this._choiceCallback(n);
      this._choiceCallback = null;
    }
  }

  hasText() {
    return this._texts.length > 0;
  }

  isChoice() {
    return this._choices.length > 0;
  }

  isNumberInput() {
    return !!this._numInputVariableId;
  }

  isBusy() {
    return (this.hasText() || this.isChoice() || this.isNumberInput());
  }

  newPage() {
    if (this._texts.length > 0) {
      this._texts[this._texts.length - 1] += '\f';
    }
  }

  showChoices(choices, callback, cancelType) {
    if (cancelType === undefined || cancelType > choices.length) {
      cancelType = -2;
    }

    const defaultType = 0;
    const positionType = 2;
    const background = 0;

    $gameMessage.setChoices(choices, defaultType, cancelType);
    $gameMessage.setChoiceBackground(background);
    $gameMessage.setChoicePositionType(positionType);
    $gameMessage.setChoiceCallback(callback);
  }

  tShowChoices(choices, callback, cancelType) {
    const newChoices = [];
    for (let i = 0; i < choices.length; i++) {
      newChoices[i] = t(choices[i]);
    }

    this.showChoices(newChoices, callback, cancelType);
  }

  allText() {
    return this._texts.join('\n');
  }

  runAfterMessages(callback) {
    const intervalHandler = setInterval(() => {
      if ($gameMessage.isBusy()) return;

      clearInterval(intervalHandler);
      callback();
    }, 50);
  }
};