//-----------------------------------------------------------------------------
// Game_Follower
//
// The game object class for a follower. A follower is an allied character,
// other than the front character, displayed in the party.

Objects.Follower = class Follower extends Objects.ActorCharacter {
  initialize(memberIndex) {
    super.initialize();
    this._memberIndex = memberIndex;
    this.setThrough(true);
  }

  refresh() {
    const characterName = this.isVisible() ? this.actor().characterName() : '';
    const characterIndex = this.isVisible() ? this.actor().characterIndex() : 0;
    this.setImage(characterName, characterIndex);
  }

  actor() {
    return $gameParty.members()[this._memberIndex];
  }

  isVisible() {
    return this.actor() && $gamePlayer.followers().isVisible();
  }

  characterName() {
    if (Switches.hideParty || Switches.hideFollowers) {
      return '';
    }

    return super.characterName();
  }

  restoreSpeed() {
  }

  update() {
    super.update();
    this.setMoveSpeed($gamePlayer.realMoveSpeed());
    this.setOpacity($gamePlayer.opacity());
    this.setBlendMode($gamePlayer.blendMode());
    this.setWalkAnime($gamePlayer.hasWalkAnime());
    this.setStepAnime($gamePlayer.hasStepAnime());
    this.setDirectionFix($gamePlayer.isDirectionFixed());
  }

  followersDistance() {
    return 0.75;
  }

  chaseCharacter(character) {
    if (this.isMoving() && !this.isAboutToStop()) return;

    let ideal_x = character.x;
    let ideal_y = character.y;
      
    switch (character.direction()) {
      case Direction.DOWN:
        ideal_y -= this.followersDistance();
        break;
      case Direction.LEFT:
        ideal_x += this.followersDistance();
        break;
      case Direction.RIGHT:
        ideal_x -= this.followersDistance();
        break;
      case Direction.UP:
        ideal_y += this.followersDistance();
        break;
      default:
        break;
    }
    const sx = this.deltaXFrom(ideal_x);
    const sy = this.deltaYFrom(ideal_y);

    if (sx.abs() >= this.myDefaultStepSize() && sy.abs() >= this.myDefaultStepSize()) {
      this.moveDiagonally(sx > 0 ? Direction.LEFT : Direction.RIGHT, sy > 0 ? Direction.UP : Direction.DOWN);
    } else if (sx.abs() >= this.myDefaultStepSize()) {
      this.moveStraight(sx > 0 ? Direction.LEFT : Direction.RIGHT);
    } else if (sy.abs() >= this.myDefaultStepSize()) {
      this.moveStraight(sy > 0 ? Direction.UP : Direction.DOWN);
    }

    this.setMoveSpeed($gamePlayer.realMoveSpeed());
  }

  canBeActivatedByPlayer() {
    const d = $gamePlayer._direction;

    // Make sure the follower can be activated from the current position
    if (d == Direction.DOWN || d == Direction.UP) {

      //If the follower is to the left of the player
      if (this.realLeft < $gamePlayer.realLeft - 0.2) return false;
      // If the follower is to the right of the player
      if (this.realRight > $gamePlayer.realRight + 0.2) return false;

      if (d == Direction.UP) {
        // If the follower is lower than the player
        if (this.realBottom > $gamePlayer.realBottom) return false;
      } else {
        // If the follower is higher than the player
        if (this.realBottom < $gamePlayer.realBottom) return false;
      }
    } else {
      // If the follower is lower than the player
      if (this.realBottom > $gamePlayer.bottom + 0.5) return false;
      // If the follower is higher than the player
      if (this.realBottom < $gamePlayer.bottom - 0.2) return false;

      if (d == Direction.RIGHT) {
        //If the follower is to the left of the player
        if (this.realRight < $gamePlayer.realRight) return false;
      } else {
        //If the follower is to the right of the player
        if (this.realLeft > $gamePlayer.realLeft) return false;
      }
    }

    return true;
  }

  start(activatedByMouse = false) {
    if (!$gameParty.hasCompanion()) return false;

    const companion = $gameParty.companion();
    const name = companion.name();
    const lowerName = name.toLowerCase();

    const eventName = `${lowerName}_follower_event`;

    if (Managers.CommonEvent.eventExists(eventName)) {
      Managers.CommonEvent.playEvent(eventName);
      return true;
    }

    return false;
  }
};
