//-----------------------------------------------------------------------------
// Game_CommonEvent
//
// The game object class for a common event. It contains functionality for
// running parallel process events.

Objects.CommonEvent = class CommonEvent {
  constructor() {
    this.initialize(...arguments);
  }

  initialize(commonEventId) {
    this._commonEventId = commonEventId;
    this._executed = false;
    this.refresh();
  }

  event() {
    return $dataCommonEvents[this._commonEventId];
  }

  list() {
    return this.event().list;
  }

  refresh() {
    if (this.isActive()) {
      if (!this._interpreter) {
        this._interpreter = new Objects.Interpreter();
      }
    } else {
      this._interpreter = null;
    }
  }

  isActiveParallelEvent(event) {
    if (event === undefined) event = this.event();
    return event.trigger === 2 && (event.switchId === 0 || $gameSwitches.booleanValue(event.switchId));
  }

  isActiveAsyncCommonEvent(event) {
    if (event === undefined) event = this.event();
    return $gameTemp.isAsyncCommonEventReserved(event.id);
  }

  isActive() {
    const event = this.event();
    return this.isActiveParallelEvent(event) || this.isActiveAsyncCommonEvent(event);
  }

  update() {
    if (this._interpreter) {
      if (!this._interpreter.isRunning()) {
        const event = this.event();
        if (this.isActiveAsyncCommonEvent(event)) {
          if (this._executed) {
            this._executed = false;
            $gameTemp.removeAsyncCommonEventFromReservedList(event.id);
            this._interpreter = null;
            return;
          }

          this._interpreter.setup(this.list());
          this._executed = true;
        } else {
          this._interpreter.setup(this.list());
        }

      }
      this._interpreter.update();
    }
  }
};