//-----------------------------------------------------------------------------
// Objects.ActorHub
//
// The wrapper class for an actor array.

Objects.ActorHub = class ActorHub {
  constructor() {
    this.initialize(...arguments);
  }

  initialize() {
    this._data = [];
    this._nameIdRelations = {};
  }

  clear() {
    this._data = [];
    this._nameIdRelations = {};
  }

  actor(actorId) {
    if ($dataActors[actorId]) {
      if (!this._data[actorId]) {
        this._data[actorId] = new Objects.Actor(actorId);
      }
    }

    if (this._data[actorId]) {
      const actorData = this._data[actorId];
      this._nameIdRelations[actorData.name] = actorId;
      return actorData;
    } else {
      return null;
    }
  }

  addActor(actorClass, actorData) {
    const actorId = Math.max(this._data.length, $dataActors.length);

    this._data[actorId] = new actorClass(actorData, actorId);
    return this._data[actorId];
  }

  findActorId(actorName) {
    actorName = Managers.Villagers.getVillagerNameByAlias(actorName);

    if (this._nameIdRelations[actorName]) {
      return this._nameIdRelations[actorName];
    }
    
    const len = $dataActors.length;
    const lower = actorName.toLowerCase();

    for (let i = 0; i < len; i++) {
      const actor = $dataActors[i];
      if (!actor) continue;

      if (actor.name.toLowerCase() == lower) {
        this._nameIdRelations[actorName] = i;
        
        return i;
      }
    }

    return 0;
  }

  actorName(n) {
    const actor = n >= 1 ? $gameActors.actor(n) : null;
    return actor ? actor.name() : '';
  }
};
