//-----------------------------------------------------------------------------
// Objects.Actor
//
// The game object class for an actor.

Objects.Actor = class Actor {
  constructor() {
    this.initialize(...arguments);
  }

  initialize(actorId) {
    this.initMembers();
    this.setup(actorId);
  }

  initMembers() {
    this._actorId = 0;
    this._name = '';
    this._characterName = '';
    this._characterIndex = 0;
  }

  setup(actorId) {
    const actor = $dataActors[actorId];
    this._actorId = actorId;
    this._name = actor.name;
    this.hitboxX = actor.hitboxX;
    this.hitboxY = actor.hitboxY;
    this.hitboxWidth = actor.hitboxWidth;
    this.hitboxHeight = actor.hitboxHeight;
    this.offsetY = actor.offsetY;
    this.offsetX = actor.offsetX;
    this.scale = {x : actor.scaleX || 1, y : actor.scaleY || 1};
    this.initImages();
  }

  actorId() {
    return this._actorId;
  }

  actor() {
    return $dataActors[this._actorId];
  }

  name() {
    return this._name;
  }

  setName(name) {
    this._name = name;

    if (this._actorId === 1) {
      Managers.Player._name = name;
    }
  }

  characterName() {
    return this._characterName;
  }

  characterIndex() {
    return this._characterIndex;
  }

  initImages() {
    const actor = this.actor();
    this._characterName = actor.characterName.replace('{player}', Managers.Player.generatePlayerSpriteName());
    this._characterIndex = actor.characterIndex;
  }

  refresh() {
  }

  isActor() {
    return true;
  }

  index() {
    return $gameParty.members().indexOf(this);
  }

  setCharacterImage(characterName, characterIndex) {
    this._characterName = characterName;
    this._characterIndex = characterIndex;
  }

  onPlayerWalk() {
  }
};