const { Audio } = require('engine/managers/Audio');

//-----------------------------------------------------------------------------
// SoundManager
//
// The static class that plays sound effects defined in the database.

let lastBuzzerSound = null;

Managers.Sound = class Sound {
  constructor() {
    throw new Error('This is a static class');
  }

  static preloadImportantSounds() {
    this.loadSystemSound(0);
    this.loadSystemSound(1);
    this.loadSystemSound(2);
    this.loadSystemSound(3);
  }

  static loadSystemSound(n) {
    if ($dataSystem) {
      Audio.loadStaticSe($dataSystem.sounds[n]);
    }
  }

  static playSystemSound(n) {
    if ($dataSystem) {
      Audio.playStaticSe($dataSystem.sounds[n]);
    }
  }

  static playCursor() {
    this.playSystemSound(0);
  }

  static playCoin() {
    // Audio.playSe('Coin');
  }

  static playShop() {
    Audio.playSe('Shop');
  }

  static playOk() {
    Audio.playSe('Confirm2');  
  }

  static playCancel() {
    Audio.playSe('Cancel2');  
  }

  static playBuzzer() {
    if (lastBuzzerSound && (new Date() - lastBuzzerSound) < 500) return;

    lastBuzzerSound = new Date();
    Audio.playSe('Buzzer1');
  }

  static playEquip() {
    Audio.playSe('Equip');
  }

  static playSave() {
    Audio.playSe('FileSave');
  }

  static playLoad() {
    Audio.playSe('FileLoad');
  }

  static playDeleteFile() {
    Audio.playSe('FileErase');
  }

  static playDrag() {
    Audio.playSe('Drag');
  }

  static playRecovery() {
    this.playSystemSound(16);
  }

  static playUseItem() {
    this.playSystemSound(22);
  }

  static playOpenStorage() {
    Audio.playSe('OpenChest');
  }

  static playOpenShippingBin() {
    Audio.playSe('OpenShippingBin');
  }

  static playDoorOpen(distance) {
    Audio.playDynamicSe('Open5', distance);
  }

  static playDoorClose() {
    // Audio.playSe('Open5');
  }

  static playEat() {
    Audio.playSe('EatingApple');
  }

  static playDrink() {
    // Audio.playSe('EatingApple');
  }

  static playButtonPressed() {

  }

  static playButtonReleased() {

  }

  static playDropItem() {
    Audio.playSe('DropItem');
  }

  static playPickItem() {
    Audio.playSe('PickItem');
  }

  static playMessageSound() {
    Audio.playSe($gameSystem.getMessageSound());
  }

  static playBedEvent() {
    Audio.playMe('Musical1');
  }

  static playCow() {
    Audio.playSe('Cow');
  }

  static playHorse() {
    // Audio.playSe('Horse');
  }

  static playHammer() {
    Audio.playSe(`HitRock${ Math.randomInt(4) + 1 }`);
  }

  static playAxe() {
    Audio.playSe(`Axe${ Math.randomInt(4) + 1 }`);
  }

  static playHoe() {
    Audio.playSe(`Hoe${ Math.randomInt(4) + 1 }`);
  }

  static playSwing() {
    Audio.playSe(`Swing${ Math.randomInt(4) + 1 }`);
  }

  static playSickle() {
    Audio.playSe(`Sickle${ Math.randomInt(4) + 1 }`);
  }

  static playSeed() {
    Audio.playSe(`Seed${ Math.randomInt(3) + 1 }`);
  }

  static playWateringCan() {
    Audio.playSe(`WateringCan${ Math.randomInt(4) + 1 }`);
  }

  static playWateringCanFill() {
    Audio.playSe('Fill-WateringCan');
  }

  static playClippers() {
    Audio.playSe('Clippers');
  }

  static playCat() {
    Audio.playSe('Cat');
  }

  static playChicken() {
    const fileNames = ['Chicken', 'Chicken2'];
    const idx = Math.randomInt(fileNames.length);

    Audio.playSe(fileNames[idx]);
  }

  static playChick() {
  }

  static playKnock() {
    let count = 0;
    const intervalHandler = setInterval(() => {
      count++;
      if (count > 3) {
        clearInterval(intervalHandler);
        return;
      }

      Audio.playSe({
        name : 'Knock',
        pitch : Math.randomInt(20) + 80,
        volume : 150,
        pan: 0
      });
    }, 250);
  }

  static playSingleKnock() {
    Audio.playSe({
      name : 'Knock',
      pitch : Math.randomInt(20) + 80,
      volume : 150,
      pan: 0
    });
  }

  static playRandomChickenSound() {
    const fileNames = ['Chicken3', 'Chicken4', 'Chicken5', 'Chicken6', 'Chicken7', 'Chicken8', 'Chicken9', 'Chicken10'];
    const idx = Math.randomInt(fileNames.length);

    Audio.playSe(fileNames[idx]);
  }

  static playThunderSound() {
    // const pitch = 85 + Math.randomInt(101);
    // const volume = 75;

    // Audio.playStaticSe({
    //   name : 'Thunder9',
    //   pitch,
    //   volume,
    //   pan: 0
    // });
  }

  static playFootsteps(index) {
    // const name = `Footsteps${ index }`;
    const name = 'Footsteps2';

    Audio.playSe({
      name : name,
      pitch : Math.randomInt(30) + 70,
      volume : 200,
      pan: 0
    });
  }

  static playDog() {
    Audio.playSe('Dog');
  }

  static playTeleport() {
    Audio.playSe('Magic2');
  }

  static playTaskComplete() {
    Audio.playSe('TaskComplete');
  }

  static playWhistle() {
    Audio.playSe('Whistle');
  }

  static updateBgm() {
    $gameMap.autoplay();
  }
};
