const EventListener = require('engine/helpers/EventListener');

class Items extends EventListener {
  static onLoadItems() {
    this.expandIngredients();
  }

  static maxItems(item) {
    return 9999;
  }

  static findItem(itemId) {
    const contentItem = Managers.Content.findItem(itemId);
    if (contentItem) {
      return contentItem;
    }

    for (let i = 0; i < $dataItems.length; i++) {
      if ($dataItems[i].id === itemId) {
        return $dataItems[i];
      }
    }

    console.error(`item not found:${itemId}`);
    return undefined;
  }

  static applyDataModifiers(data) {
    const newData = MVC.shallowClone(data);

    return Managers.Content.applyItemDataModifiers(newData);
  }

  static tools(includeNulls) {
    return Managers.Tools.tools(includeNulls);
  }

  static getItemData(itemId, quick) {
    if (typeof itemId == "object") itemId = itemId.id;

    const len = $dataItems.length;
    for (let i = 0; i < len; i++) {
      if (!$dataItems[i]) continue;
      if ($dataItems[i].id == itemId) {
        if (quick) return $dataItems[i];

        return this.applyDataModifiers($dataItems[i]);
      }
    }

    const tools = this.tools();

    for (let j = 0; j < len; j++) {
      if (!tools[j]) continue;

      if (tools[j].id == itemId) {
        if (quick) return tools[j];
        return this.applyDataModifiers(tools[j]);
      }
    }

    const contentItem = Managers.Content.findItem(itemId);
    if (contentItem) {
      return this.applyDataModifiers(contentItem);
    }

    return false;
  }

  static expandItemIngredients(itemData) {
    if (!itemData.ingredients) return;

    const newList = [];

    for (let i = 0; i < itemData.ingredients.length; i++) {
      if (!itemData.ingredients[i]) continue;

      if (typeof itemData.ingredients[i] == 'string') {
        newList.push(itemData.ingredients[i]);
      } else {
        for (let j = 0; j < itemData.ingredients[i].amount; j++) {
          newList.push(itemData.ingredients[i].itemId);
        }
      }
    }

    itemData.ingredients = newList;
  }

  static expandIngredients() {
    const len = $dataItems.length;
    for (let i = 0; i < len; i++) {
      const itemData = $dataItems[i];
      if (itemData) {
        this.expandItemIngredients(itemData);
      }
    }
  }

  static itemIdCanBeStored(id) {
    if (Managers.Content.itemIdCanBeStored(id) === false) return false;

    return true;
  }

  static itemTypeIsStackable(itemType) {
    return itemType !== 'animal' && itemType !== 'unique';
  }

  static itemTypeCanBeStored(itemType) {
    return itemType !== 'animal';
  }

  static selectAmount(item, amount) {
    if (amount !== undefined) return amount;
    if (item.amount !== undefined) return item.amount;
    return 1;
  }

  static onInventoryChange() {
    Managers.Content.onInventoryChange();
    // #ToDo: fix this reference
    Engine.Inventory.requestHudRefresh();
  }
}

module.exports = {
  Items,
};
