Managers.Content = class Content {
  constructor() {
    throw new Error('This is a static class');
  }

  static registerContentClass(contentClass) {
    this.contentClasses.push(contentClass);

    for (const methodName in this.methodList) {
      if (contentClass[methodName]) {
        this.methodList[methodName].push(contentClass);
      }
    }

    if (!contentClass.contentId) {
      console.log('content class is missing contentId:', contentClass);
    }
  }

  static loopMethod(methodName, callback) {
    const classList = this.methodList[methodName];
    if (!classList) return;

    for (let i = 0; i < classList.length; i++) {
      callback(classList[i]);
    }
  }

  static findContentClass(contentId) {
    for (const contentClass of this.contentClasses) {
      if (contentClass.contentId && contentClass.contentId() == contentId) {
        return contentClass;
      }
    }

    return null;
  }

  static removeContentClassFromMethodList(methodName, contentId) {
    if (!this.methodList[methodName]) {
      return;
    }

    const contentClass = this.findContentClass(contentId);
    if (!contentClass) {
      return;
    }

    const index = this.methodList[methodName].indexOf(contentClass);
    if (index >= 0) {
      this.methodList[methodName][index] = null;
    }
  }

  static runMethod(methodName, params, returnIfBoolean, returnIfAnything, returnIfExact) {
    let classList = this.methodList[methodName];
    if (!classList) {
      classList = this.contentClasses;
    }

    for (let i = 0; i < classList.length; i++) {
      const fn = classList[i][methodName];
      if (typeof fn != 'function') continue;

      const result = classList[i][methodName](...params);

      if (returnIfBoolean !== undefined) {
        if (returnIfBoolean === true || returnIfBoolean === false) {
          if (result === returnIfBoolean) return result;
        } else if (returnIfBoolean == 'both') {
          if (result === true || result === false) return result;
        }
      }

      if (returnIfAnything) {
        if (result !== undefined && result !== null) {
          return result;
        }
      }

      if (returnIfExact !== undefined) {
        if (result === returnIfExact) return result;
      }
    }
  }

  static addMethod(methodName, createSimpleMethod, returnIfBoolean, returnIfAnything, returnIfExact) {
    this.methodList[methodName] = [];

    if (createSimpleMethod) {
      this[methodName] = (...args) => {
        return this.runMethod(methodName, args, returnIfBoolean, returnIfAnything, returnIfExact);
      };
    }
  }

  static update() {
    if ($gameSystem.isPlayingCutscene()) {
      return;
    }

    this.runMethod('update', arguments);
  }

  static getLetterList() {
    let allLetters = [];
    const params = arguments;

    this.loopMethod('getLetterList', classObj => {
      const newLetters = classObj.getLetterList(...params);
      if (!!newLetters && newLetters.length > 0) {
        console.log(...log('[New Letters]', newLetters));

        allLetters = allLetters.concat(newLetters);
      }
    });

    return allLetters;
  }

  static getCustomDatabaseSummaryLines() {
    let allLines = [];
    const params = arguments;

    this.loopMethod('getCustomDatabaseSummaryLines', classObj => {
      const newLines = classObj.getCustomDatabaseSummaryLines(...params);
      if (!!newLines && newLines.length > 0) {
        allLines = allLines.concat(newLines);
      }
    });

    return allLines;
  }

  static applyItemDataModifiers(data) {
    this.loopMethod('applyItemDataModifiers', classObj => {
      data = classObj.applyItemDataModifiers.call(classObj, data);
    });

    return data;
  }

  static canCheckInput() {
    const result = this.runMethod('canCheckInput', arguments, false);
    if (result === false) return false;
    return true;
  }
};

Managers.Content.contentClasses = [];
Managers.Content.methodList = {};

Managers.Content.addMethod('update');
Managers.Content.addMethod('parsePluginCommand', true, true);
Managers.Content.addMethod('parseConditionCommand', true, 'both');
Managers.Content.addMethod('getLetterList');
Managers.Content.addMethod('getCustomDatabaseSummaryLines');
Managers.Content.addMethod('applyItemDataModifiers');
Managers.Content.addMethod('canCheckInput');

Managers.Content.addMethod('setupMapEvents', true);
Managers.Content.addMethod('setupNewGame', true);
