function EventListener() {
  
}

(function($) {
  "use strict";

  $._events = [];

  $.on = function(eventName, callback) {
    if (this._events[eventName] === undefined) this._events[eventName] = [];

    this._events[eventName].push(callback);
  };

  $.un = function(eventName, callback) {
    if (this._events[eventName] === undefined) return;

    for (var i = 0; i < this._events[eventName].length; i++) {
      if (this._events[eventName][i] == callback) {
        this._events[eventName][i] = undefined;
        return;
      }
    }
  };

  $.executeCallback = function(callback, params) {
    if (callback === undefined) return;

    if (typeof(callback) == "function") {
      return callback(...params);
    }

    if (typeof(callback) == "number") {
      $gameTemp.reserveCommonEvent(callback);
      return true;
    }

    if (typeof(callback) == "string") {
      var id = parseInt(callback, 10);

      if (parseInt(callback, 10) == callback.trim()) {
        $gameTemp.reserveCommonEvent(parseInt(callback, 10));
        return true;
      } else if (callback.substr(0, 1) == 'S') {
        var data = callback.split(',');
        var value = 'TRUE';

        if (data.length >= 2) {
          value = data[1].toUppercase();
        }

        $gameSwitches.setValue(id, value !== 'FALSE' && value !== 'OFF');
        return true;
      }

      return MVC.safeEval(callback); // jshint ignore:line
    }
    
    console.error("Unknown callback type: ", callback);
    return undefined;
  };

  $.runEvent = function(eventName, params) {
    if (!Array.isArray(params)) {
      params = [];

      for (var x = 1; x < arguments.length; x++) {
        params.push(arguments[x]);
      }
    }

    if (this._events[eventName] === undefined) return;

    for (var i = 0; i < this._events[eventName].length; i++) {
      var callback = this._events[eventName][i];

      if (this.executeCallback(callback, params) === false) {
        break;
      }
    }
  };
})(EventListener);

module.exports = EventListener;