//-----------------------------------------------------------------------------
/**
 * The static class that handles resource loading.
 *
 * @class ResourceHandler
 */
function ResourceHandler() {
  throw new Error('This is a static class');
}

ResourceHandler._reloaders = [];
ResourceHandler._defaultRetryInterval = [500, 1000, 3000];

ResourceHandler.createLoader = function(url, retryMethod, resignMethod, retryInterval) {
  retryInterval = retryInterval || this._defaultRetryInterval;
  return function() {
    if (resignMethod) {
      resignMethod();
    }
  };
};

ResourceHandler.exists = function() {
  return this._reloaders.length > 0;
};

ResourceHandler.retry = function() {
  if (this._reloaders.length > 0) {
    Graphics.eraseLoadingError();
    Managers.Scenes.resume();
    this._reloaders.forEach(function(reloader) {
      reloader();
    });
    this._reloaders.length = 0;
  }
};