function RequestQueue(){
  this.initialize.apply(this, arguments);
}

RequestQueue.prototype.initialize = function(){
  this._queue = [];
};

RequestQueue.prototype.enqueue = function(key, value){
  this._queue.push({
    key: key,
    value: value,
  });
};

RequestQueue.prototype.update = function(){
  if(this._queue.length === 0) return;

  var i = 0;
  var canShift = true;
  while (i < this._queue.length) {
    if (!this._queue[i]) {
      this._queue.shift();
      continue;
    }

    if (this._queue[i].value.isRequestReady()) {
      if (canShift) {
        this._queue.shift();
        continue;
      }
    } else {
      canShift = false;
      this._queue[i].value.startRequest();
    }

    i++;
  }
};

RequestQueue.prototype.raisePriority = function(key){
  for(var n = 0; n < this._queue.length; n++){
    var item = this._queue[n];
    if(item.key === key){
      this._queue.splice(n, 1);
      this._queue.unshift(item);
      break;
    }
  }
};

RequestQueue.prototype.clear = function(){
  this._queue.splice(0);
};
