function ImageCache(){
  this.initialize.apply(this, arguments);
}

ImageCache.limit = 10 * 1000 * 1000;

ImageCache.prototype.initialize = function(){
  this._items = {};
};

ImageCache.prototype.add = function(key, value){
  this._items[key] = {
    bitmap: value,
    touch: Date.now(),
    key: key
  };
};

ImageCache.prototype.get = function(key){
  if(this._items[key]){
    var item = this._items[key];
    item.touch = Date.now();
    return item.bitmap;
  }

  return null;
};

ImageCache.prototype.free = function(key) {
  if (this._items[key]) {
    var data = this._items[key];

    if (data && data.bitmap) {
      if (data.bitmap._clearImgInstance) {
        data.bitmap._clearImgInstance();
      }

      data.bitmap.free(false);
    }

    delete this._items[key];
  }
};

ImageCache.prototype.isReady = function(){
  var items = this._items;
  return !Object.keys(items).some(function(key){
    return !items[key].bitmap.isRequestOnly() && !items[key].bitmap.isReady();
  });
};

ImageCache.prototype.getErrorBitmap = function(){
  var items = this._items;
  var bitmap = null;
  if(Object.keys(items).some(function(key){
    if(items[key].bitmap.isError()){
      bitmap = items[key].bitmap;
      return true;
    }
    return false;
  })) {
    return bitmap;
  }

  return null;
};