class BasePluginParser {
  constructor(interpreter) {
    this.interpreter = interpreter;
    this.args = [];
    this.command = '';
    this.name = '';
    this.line = '';
    this.currentIndex = 0;
    this.upperName = '';
  }

  hasMoreArgs(minNumber) {
    if (!minNumber) minNumber = 1;

    return this.args.length > this.currentIndex + (minNumber - 1);
  }

  skipArg() {
    this.currentIndex++;
  }

  nextArg(autoSkip) {
    const value = this.args[this.currentIndex] || '';
    if (autoSkip) {
      this.skipArg();
    }
    return value;
  }

  nameMaybeVariable() {
    if (this.upperName === 'VARIABLE') {
      const variableName = this.nextArg(true);
      return Variables[variableName];
    }

    return this.name;
  }

  nextArgMaybeVariable(autoSkip) {
    const value = this.args[this.currentIndex] || '';
    if (autoSkip) {
      this.skipArg();
    }

    if (value.toUpperCase() === 'VARIABLE') {
      const variableName = this.nextArg(autoSkip);
      return Variables[variableName];
    }

    return value;
  }

  nextArgAsFloat(autoSkip) {
    let value = this.nextArg(autoSkip);

    try {
      value = parseFloat(value, 10);
    }
    catch(exception) {
      value = 0;
    }

    return value;
  }

  nextArgAsFloatMaybeVariable(autoSkip) {
    let value = this.nextArg(autoSkip);

    if (value.toUpperCase() === 'VARIABLE') {
      const variableName = this.nextArg(autoSkip);
      value = Variables[variableName];

      if (typeof value === 'number') {
        return value;
      }
    }

    try {
      value = parseFloat(value, 10);
    }
    catch(exception) {
      value = 0;
    }

    return value;
  }

  nextArgAsBoolean(autoSkip) {
    return Utils.evaluatesToTrue(this.nextArg(autoSkip));
  }

  nextUpperArg(autoSkip) {
    return this.nextArg(autoSkip).toUpperCase();
  }

  remainingLineMaybeVariable() {
    if (this.nextUpperArg() === 'VARIABLE') {
      return this.nextArgMaybeVariable(true);
    }

    return this.remainingLine();
  }

  remainingLine() {
    let line = '';
    let idx = this.currentIndex;
    while (this.args.length > idx) {
      line += ' ' + this.args[idx];
      idx++;
    }

    return line.trim();
  }

  failure() {

  }
}

module.exports = BasePluginParser;