const externalRequire = window.require;
const watchList = new Set();

const OrangeSeason = (function(){
  var identation = 0;
  var lastFileName = false;
  var openedPaths = [];

  function increaseIdentation() {
    identation++;
  }

  function decreaseIdentation() {
    identation--;
  }

  function log(text, forceOutput) {
    var prefix = '';
    for (var i = 0; i < identation; i++) {
      prefix += '-';
    }

    if (prefix !== '') prefix += ' ';

    if (forceOutput || false) {
      console.log(...window.log(prefix + text));
    }
  }

  function fileRequested(fileName) {
    checkLastFileName();
  }

  function checkLastFileName() {
    if (lastFileName) {
      log(lastFileName);
      lastFileName = false;
      increaseIdentation();
    }
  }

  function fileStarted(fileName) {
    checkLastFileName();
    openedPaths.push(Wrapper.dirname(fileName));
    lastFileName = fileName;
  }

  function fileLoaded(fileName) {
    openedPaths.pop();
    if (lastFileName == fileName) {
      lastFileName = false;
      log(fileName);
    } else {
      decreaseIdentation();
    }
  }

  function fileFailed(fileName) {
    if (lastFileName == fileName) {
      lastFileName = false;
    } else {
      decreaseIdentation();
    }

    openedPaths.pop();
    log(fileName + ' [FAILED]', true);
  }

  const namespaces = {
    core : {},
    content : {},
    creatures : {},
    helpers : {},
    mods : {},
    managers : {},
    models : {},
    objects : {},
    plugins : {},
    scenes : {},
    sprites : {},
    tools : {},
    seeds : {},
    updates : {},
    windows : {},
    languages: {}
  };

  class OrangeSeason {
    static get Core() {
      return namespaces.core;
    }
    static get Content() {
      return namespaces.content;
    }
    static get Creatures() {
      return namespaces.creatures;
    }
    static get Helpers() {
      return namespaces.helpers;
    }
    static get Mods() {
      return namespaces.mods;
    }
    static get Managers() {
      return namespaces.managers;
    }
    static get Models() {
      return namespaces.models;
    }
    static get Objects() {
      return namespaces.objects;
    }
    static get Plugins() {
      return namespaces.plugins;
    }
    static get Scenes() {
      return namespaces.scenes;
    }
    static get Sprites() {
      return namespaces.sprites;
    }
    static get Tools() {
      return namespaces.tools;
    }
    static get Seeds() {
      return namespaces.seeds;
    }
    static get Updates() {
      return namespaces.updates;
    }
    static get Windows() {
      return namespaces.windows;
    }
    static get Languages() {
      return namespaces.languages;
    }

    static performEval(evalString, fileName) {
      window.eval(evalString); //jshint ignore:line
    }

    static loadFile(fileName) {
      const projectFolder = window.process ? Wrapper.dirname(process.mainModule.filename).replace('%20', ' ') : '';
      const jsFolder = Wrapper.joinFileNames(projectFolder, 'js');
      const fullPath = Wrapper.joinFileNames(jsFolder, fileName);
      const fileContent = Wrapper.readFileSync(fullPath);

      try {
        fileStarted(fileName);
        const evalString = OrangeSeason.suppressSourceUrl ? fileContent : "//@ sourceURL=" + fileName + "\n" + fileContent;

        module.exports = {};
        OrangeSeason.performEval(evalString, fileName);
        const result = module.exports || true;

        OrangeSeason.registerRequiredFile(fileName, result);
        fileLoaded(fileName);
        this.afterIncludeFile(result, fileName);
        return result;
      } catch(e) {
        fileFailed(fileName);
        console.log(e);
        console.error(e.message);
        return false;
      }
    }

    static includeFolder(folder, subFoldersToSkip) {
      var projectFolder = window.process ? Wrapper.dirname(process.mainModule.filename).replace('%20', ' ') : '';
      var jsFolder = Wrapper.joinFileNames(projectFolder, 'js');
      var requiredFolder = Wrapper.joinFileNames(jsFolder, folder);

      var allFiles = Wrapper.readdirSync(requiredFolder);

      for (var i = 0; i < allFiles.length; i++) {
        if (subFoldersToSkip && subFoldersToSkip.indexOf(allFiles[i]) >= 0) {
          continue;
        }

        var filePath = Wrapper.joinFileNames(requiredFolder, allFiles[i]);
        var relativePath = Wrapper.joinFileNames(folder, allFiles[i]);

        if (Wrapper.isDirectory(filePath)) {
          if (allFiles[i] == 'events') {
            Managers.EventScript.addExtraEventFolder(filePath, folder);
            continue;
          }

          if (!OrangeSeason.includeFolder(relativePath, subFoldersToSkip)) {
            return false;
          }
        } else {
          if (!OrangeSeason.include(relativePath)) {
            return false;
          }
        }
      }

      return true;
    }

    static registerRequiredFile(fileName, result = true) {
      if (!this.loadedFiles) {
        this.loadedFiles = {};
      }

      this.loadedFiles[fileName] = result;

      if (watchList.has(fileName)) {
        watchList.delete(fileName);
      }
    }

    static isFileIncluded(fileName) {
      if (!this.loadedFiles) return false;
      if (!this.loadedFiles[fileName]) return false;

      return true;
    }

    static require(fileName) {
      if (!fileName) return true;
      if (OrangeSeason.isFileIncluded(fileName)) {
        return this.loadedFiles[fileName] || true;
      }
      if (!fileName.toLowerCase().endsWith('js')) return true;

      fileRequested(fileName);
      return this.loadFile(fileName);
    }

    static afterIncludeFile(result, filePath) {
      if (!result) {
        return;
      }

      // Only process this for engine files
      if (!filePath.startsWith('engine')) {
        return;
      }

      // Skip lib files
      if (filePath.startsWith(Wrapper.joinFileNames('engine', 'libs'))) {
        return;
      }

      if (typeof result === 'object') {
        for (const key in result) {
          if (result.hasOwnProperty(key)) {
            window.Engine[key] = result[key];
          }
        }
        return;
      }

      if (typeof result === 'function') {
        if (filePath) {
          const fileName = Wrapper.basename(filePath);
          let dir = Wrapper.dirname(filePath);
          let route = [];
          route.push(fileName.replace(Wrapper.extname(fileName), ''));

          while (dir && dir !== 'engine') {
            route.push(Wrapper.basename(dir));
            dir = Wrapper.dirname(dir);
          }

          if (dir === 'engine') {
            let obj = window.Engine;
            for (let i = route.length -1; i > 0; i--) {
              const propName = route[i];
              if (!obj[propName]) {
                obj[propName] = {};
              }

              obj = obj[propName];
            }
            obj[route[0]] = result;
          }
        }
      }
    }

    static include(fileName) {
      if (!fileName) return true;
      if (OrangeSeason.isFileIncluded(fileName)) return true;
      if (!fileName.toLowerCase().endsWith('js')) return true;

      return this.loadFile(fileName);
    }

    static callExternalRequire(fileToRequire) {
      if (externalRequire) {
        return externalRequire(fileToRequire);
      }

      throw new Error(`Failed to require node_module: ${ fileToRequire }`);
    }

    static getBasePath() {
      return openedPaths[openedPaths.length - 1];
    }

    static modifyRelativePath(relativePath) {
      if (openedPaths.length) {
        const homePath = openedPaths[openedPaths.length - 1];
        relativePath = Wrapper.joinFileNames(homePath, relativePath);
      }

      return relativePath;
    }

    static addFileReference(fileReference) {
      let fileToRequire = fileReference;
      if (fileToRequire.startsWith('.')) {
        fileToRequire = OrangeSeason.modifyRelativePath(fileToRequire);
      }

      const fileParts = fileToRequire.split('/');
      const fileName = Wrapper.joinFileNames(...fileParts);
      const filePath = fileName.endsWith('.js') ? fileName : `${ fileName }.js`;

      if (OrangeSeason.isFileIncluded(filePath)) {
        return;
      }

      watchList.add(filePath);
    }

    static relativeRequire(fileToRequire) {
      const externalRequireList = [
        'fs',
        'path',
        'nw.gui',
        'nw',
        'child_process'
      ];

      if (externalRequireList.indexOf(fileToRequire) >= 0) {
        return OrangeSeason.callExternalRequire(fileToRequire);
      }
      if (fileToRequire.endsWith('greenworks')) {
        return OrangeSeason.callExternalRequire(fileToRequire);
      }

      // if the file path starts with a period, prepend the path of the file that required it
      if (fileToRequire.startsWith('.')) {
        fileToRequire = OrangeSeason.modifyRelativePath(fileToRequire);
      }

      const fileParts = fileToRequire.split('/');
      const fileName = Wrapper.joinFileNames(...fileParts);
      const filePath = fileName.endsWith('.js') ? fileName : `${ fileName }.js`;
      return OrangeSeason.require(filePath);
    }

    static startGame() {
      Managers.Config.load();
      Managers.Player.clear();

      Graphics.adjustScreenSize();
      Managers.Scenes.run(GameScenes.Boot);
    }

    static validateWatchList() {
      let anyFileMissing = false;

      for (const fileName of watchList) {
        if (OrangeSeason.isFileIncluded(fileName)) {
          watchList.delete(fileName);
          continue;
        }

        console.error('Missing file: ', fileName);
        anyFileMissing = true;
      }

      if (anyFileMissing) {
        throw new Error('Invalid File References');
      }
    }
  }

  return OrangeSeason;
})();

/* eslint no-unused-vars: 0 */
const Core = OrangeSeason.Core;
const Content = OrangeSeason.Content;
const Creatures = OrangeSeason.Creatures;
const Helpers = OrangeSeason.Helpers;
const Managers = OrangeSeason.Managers;
const Models = OrangeSeason.Models;
const Objects = OrangeSeason.Objects;
const GameScenes = OrangeSeason.Scenes;
const Sprites = OrangeSeason.Sprites;
const Tools = OrangeSeason.Tools;
const Seeds = OrangeSeason.Seeds;
const Updates = OrangeSeason.Updates;
const Windows = OrangeSeason.Windows;
const Languages = OrangeSeason.Languages;

window.require = OrangeSeason.relativeRequire;
window.reference = OrangeSeason.addFileReference;
window.Engine = {};
window.module = {
  exports: {}
};
