/*
 * Decompiled with CFR 0.152.
 */
package org.nullcraft.ncrules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class NcRules
extends JavaPlugin
implements Listener {
    public void onEnable() {
        this.saveDefaultConfig();
        this.setAllConfigWorldsRules();
        this.getLogger().info(this.getConfig().getString("lang.prefix").replace("&", "\u00a7") + "NcRules Active");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String[] subCommands = new String[]{"help", "reload", "list", "add"};
        if (args.length > 1) {
            return new ArrayList<String>();
        }
        if (args.length == 0) {
            return Arrays.asList(subCommands);
        }
        return Arrays.stream(subCommands).filter(s -> s.startsWith(args[0])).collect(Collectors.toList());
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (label.equalsIgnoreCase("ncrules") || label.equalsIgnoreCase("ncrs")) {
            if (args.length == 2) {
                if (sender.hasPermission("ncrules.add") & args[0].equalsIgnoreCase("add")) {
                    if (Bukkit.getWorld((String)args[1]) == null) {
                        sender.sendMessage(this.getConfig().getString("lang.prefix").replace("&", "\u00a7") + args[1] + this.getConfig().getString("lang.notexistworld").replace("&", "\u00a7"));
                        return true;
                    }
                    this.reloadConfig();
                    List worlds = this.getConfig().getStringList("enableworlds");
                    boolean haveworld = worlds.contains(args[1]);
                    if (!haveworld) {
                        worlds.add(args[1]);
                        this.getConfig().set("enableworlds", (Object)worlds);
                        this.saveConfig();
                        this.reloadConfig();
                        this.setConfigGameRules(args[1]);
                        sender.sendMessage(this.getConfig().getString("lang.prefix").replace("&", "\u00a7") + this.getConfig().getString("lang.addworlddone").replace("&", "\u00a7") + args[1]);
                        return true;
                    }
                    sender.sendMessage(this.getConfig().getString("lang.prefix").replace("&", "\u00a7") + args[1] + this.getConfig().getString("lang.existedworld").replace("&", "\u00a7"));
                    return true;
                }
                sender.sendMessage(this.getConfig().getString("lang.prefix").replace("&", "\u00a7") + this.getConfig().getString("lang.notpermissions").replace("&", "\u00a7"));
                return true;
            }
            if (args.length == 1) {
                if (sender.hasPermission("ncrules.help") & args[0].equalsIgnoreCase("help")) {
                    sender.sendMessage(this.getConfig().getString("lang.prefix").replace("&", "\u00a7") + this.getConfig().getString("lang.commands").replace("&", "\u00a7"));
                    sender.sendMessage(this.getConfig().getString("lang.commandhelp").replace("&", "\u00a7"));
                    sender.sendMessage(this.getConfig().getString("lang.commandreload").replace("&", "\u00a7"));
                    sender.sendMessage(this.getConfig().getString("lang.commandlist").replace("&", "\u00a7"));
                    sender.sendMessage(this.getConfig().getString("lang.commandadd").replace("&", "\u00a7"));
                    return true;
                }
                if (sender.hasPermission("ncrules.reload") & args[0].equalsIgnoreCase("reload")) {
                    this.reloadConfig();
                    sender.sendMessage(this.getConfig().getString("lang.prefix").replace("&", "\u00a7") + this.getConfig().getString("lang.reloaddone").replace("&", "\u00a7"));
                    this.setAllConfigWorldsRules();
                    return true;
                }
                if (sender.hasPermission("ncrules.list") & args[0].equalsIgnoreCase("list")) {
                    List worlds = this.getConfig().getStringList("enableworlds");
                    String allworlds = new String();
                    if (worlds != null) {
                        for (String s : worlds) {
                            allworlds = allworlds + s + ",";
                        }
                    }
                    sender.sendMessage(this.getConfig().getString("lang.prefix").replace("&", "\u00a7") + this.getConfig().getString("lang.activeworld").replace("&", "\u00a7") + allworlds);
                    return true;
                }
            }
            sender.sendMessage(this.getConfig().getString("lang.prefix").replace("&", "\u00a7") + this.getConfig().getString("lang.gethelp").replace("&", "\u00a7"));
            return true;
        }
        sender.sendMessage(this.getConfig().getString("lang.prefix").replace("&", "\u00a7") + this.getConfig().getString("lang.notpermissions").replace("&", "\u00a7"));
        return false;
    }

    public void setAllConfigWorldsRules() {
        List worlds = this.getConfig().getStringList("enableworlds");
        if (worlds != null) {
            for (String s : worlds) {
                this.setConfigGameRules(s);
                Bukkit.broadcastMessage((String)(this.getConfig().getString("lang.prefix").replace("&", "\u00a7") + this.getConfig().getString("lang.changedrules").replace("&", "\u00a7") + s + this.getConfig().getString("lang.changedworldrules").replace("&", "\u00a7")));
            }
        }
    }

    public void setConfigGameRules(String world) {
        Set rules = this.getConfig().getConfigurationSection("rules").getKeys(false);
        if (rules != null) {
            for (String s : rules) {
                Bukkit.getWorld((String)world).setGameRuleValue(s, this.getConfig().getString("rules." + s));
            }
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        if (this.getConfig().getBoolean("respawntitle.enabled")) {
            Player playname = e.getEntity();
            playname.sendTitle(this.getConfig().getString("respawntitle.title").replace("&", "\u00a7"), this.getConfig().getString("respawntitle.subtitle").replace("&", "\u00a7"), 10, 70, 20);
        }
    }

    public void onDisable() {
    }
}

