/*
 * Copyright 2006-2011 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.maxkey.authz.oauth2.provider.token;

import org.maxkey.authz.oauth2.provider.OAuth2Authentication;

/**
 * Strategy interface for extracting a unique key from an {@link OAuth2Authentication}.
 * 
 * @author Dave Syer
 * 
 */
public interface AuthenticationKeyGenerator {

	/**
	 * @param authentication an OAuth2Authentication
	 * @return a unique key identifying the authentication
	 */
	String extractKey(OAuth2Authentication authentication);

}
