/*
 * Copyright [2020] [MaxKey of copyright http://www.maxkey.top]
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 

package org.maxkey.constants;

public final class ConstantsTimeInterval {
    
    public static final Integer ONE_MINUTE = 60; // 1 minutes 
    
    public static final Integer ONE_HOUR = 60 * 60; // 1 hour
    
    public static final Integer ONE_DAY = 60 * 60 * 24; // 1 day

    public static final Integer ONE_WEEK = ONE_DAY * 7; // 1 week

    public static final Integer TWO_WEEK = ONE_DAY * 14; // 2 week

    public static final Integer ONE_MONTH = ONE_DAY * 30; // 1 month
    
    public static final Integer TWO_MONTH = ONE_DAY * 60; // 2 month
    
    /**
     * The number of seconds in one year (= 60 * 60 * 24 * 365).
     */
    public static final Integer ONE_YEAR = 60 * 60 * 24 * 365;
}
