﻿/////////////////////////////////////////////////////////////////////////
//
// MatchRate v1.3.3
//
// © Blastframe
// Author: Kevin C. Burke
//
// support@blastframe.com
//
////////////////////////////////////////////////////////////////////////

function matchRate(thisObj)
{
    var PRODUCT_NAME = "MatchRate";
    var VERSION_NUMBER = "1.3.3";
    var proj = app.project;
    var comp = proj.activeItem;
    var isEffect = false;
    var palette = (thisObj instanceof Panel) ? thisObj : new Window("palette", "MatchRate", undefined,
    {
        resizeable: true,
        orientation: 'column',
        alignChildren: ['fill', 'top']
    });
    palette.margins = 10;
    var staticTextDimensions = [0, 8, 200, 25];
    var percentButtonDimensions = [0, 0, 20, 20];
    var mainBtnGrp = palette.add('group', undefined, 'Main Button Group');
    var getRateBtn = mainBtnGrp.add('button', undefined, 'GET RATE');
    getRateBtn.graphics.font = "Tahoma-Bold:10";
    getRateBtn.alignment = ['fill', 'top'];
    getRateBtn.preferredSize = [100, 28];
    getRateBtn.onClick = getRate;
    var applyBtn = mainBtnGrp.add('button', undefined, 'APPLY RATE');
    applyBtn.graphics.font = "Tahoma-Bold:10";
    applyBtn.alignment = ['fill', 'top'];
    applyBtn.preferredSize = [100, 28];
    applyBtn.onClick = applyRate;
    applyBtn.alignment = ['fill', 'top'];
    applyBtn.enabled = false;
    var error1 = "Please select two keyframes of one property to get your rate.";
    var error1B = "Please select one keyframe for your target property.";
    var error2 = "Please select a target layer";
    var error3 = "Very sorry, but the new value is outside of the property's min/max values.";
    var error4 = "To apply a rate, please select one keyframe.";
    var error5 = "Please choose two property keyframes with different values.";
    var error6 = "Please choose a composition, then a property's keyframe(s).";
    var helpBtn = mainBtnGrp.add('button', undefined, '?');
    helpBtn.graphics.font = "Tahoma-Bold:10";
    helpBtn.alignment = ['fill', 'center'];
    helpBtn.preferredSize = [22, 28];
    helpBtn.onClick = helpWindow;
    var panel1 = palette.add("panel");
    panel1.width = 260;
    var sourceTextGroup = panel1.add('group', undefined, 'Source Text Group');
    sourceTextGroup.alignment = ['fill', 'top'];
    var sourceText = sourceTextGroup.add('statictext', undefined, 'Source : ');
    sourceText.graphics.font = "Tahoma-Bold:10";
    sourceText.enabled = false;
    sourceText.visible = false;
    var rate1 = panel1.add('group', undefined, 'rate1 group');
    var rate2 = panel1.add('group', undefined, 'rate2 group');
    var rate3 = panel1.add('group', undefined, 'rate3 group');
    var rate1Checkbox = rate1.add('checkbox', undefined, '');
    rate1Checkbox.enabled = false;
    rate1Checkbox.visible = false;
    rate1Checkbox.value = true;
    var rate1Text = rate1.add('statictext', staticTextDimensions, 'Please choose two keyframes');
    var rate2Checkbox = rate2.add('checkbox', undefined, '');
    rate2Checkbox.value = true;
    rate2Checkbox.visible = false;
    rate2Checkbox.enabled = false;
    var rate2Text = rate2.add('statictext', staticTextDimensions, '');
    var rate3Checkbox = rate3.add('checkbox', undefined, '');
    rate3Checkbox.value = true;
    rate3Checkbox.visible = false;
    rate3Checkbox.enabled = false;
    var rate3Text = rate3.add('statictext', staticTextDimensions, '');
    var percentageGroup = panel1.add('group', undefined, 'Percentage Button group');
    var decreaseBtn = percentageGroup.add('button', percentButtonDimensions, '-');
    var percentText = percentageGroup.add('edittext', [0, 0, 45, 20], '100%',
    {
        multiline: false,
        characters: 4,
        orientation: 'column',
        alignment: ['center', 'top'],
    });
    percentText.justify = 'center';
    var increaseBtn = percentageGroup.add('button', percentButtonDimensions, '+');
    increaseBtn.addEventListener("click", adjustPercentage);
    decreaseBtn.addEventListener("click", adjustPercentage);
    var applybuttonGrp = panel1.add('group', undefined, 'Button group');
    var invert = applybuttonGrp.add('button', undefined, 'Invert');
    invert.enabled = false;
    invert.onClick = invertValues;
    var clear = applybuttonGrp.add('button', undefined, 'Clear');
    clear.enabled = false;
    clear.onClick = clearValues;
    var panel2 = palette.add("panel");
    panel2.width = 260;
    var targetTextGroup = panel2.add('group', staticTextDimensions, 'Source Text Group');
    targetTextGroup.alignment = ['fill', 'top'];
    var targetText = targetTextGroup.add('statictext', undefined, 'Target : ');
    targetText.graphics.font = "Tahoma-Bold:10";
    targetText.enabled = false;
    targetText.justify = 'left';
    var valueCheckboxGroup = panel2.add('group', undefined, 'Value Checkbox group');
    var value1Checkbox = valueCheckboxGroup.add('checkbox', undefined, 'X');
    value1Checkbox.enabled = false;
    value1Checkbox.value = true;
    var value2Checkbox = valueCheckboxGroup.add('checkbox', undefined, 'Y');
    value2Checkbox.enabled = false;
    value2Checkbox.value = true;
    var value3Checkbox = valueCheckboxGroup.add('checkbox', undefined, 'Z');
    value3Checkbox.enabled = false;
    value3Checkbox.value = true;
    percentageGroup.visible = false;
    applybuttonGrp.visible = false;

    panel2.visible = false;
    if (palette instanceof Window)
    {
        palette.show();
    }
    else
    {
        palette.layout.layout(true);
    }
    palette.layout.resize();
    palette.onResizing = palette.onResize = function ()
    {
        this.layout.resize();
    }

    function getUserDataFolder()
    {
        //C:\Users\[username]\AppData\Roaming\
        var userDataFolder = Folder.userData;
        var myFolder = "/Blastframe/"+PRODUCT_NAME;
        var pFolder = Folder(userDataFolder.toString() + myFolder); 
        if (!pFolder.exists)
        {
            var checkFolder = pFolder.create();
            if (!checkFolder)
            {
                alert ("Error creating ");
                pFolder  = Folder.temp;
            }
        }
        return pFolder.toString();
    }

    function createResourceFile (filename, binaryString, resourceFolder)
    {
        var myFile = new File(resourceFolder+"/"+filename);
        if (!File(myFile).exists)
        {
            if (!(isSecurityPrefSet())) 
            {
                alert ("This script requires access to write files. Please check the \"Allow Scripts to Write Files and Access Network\" checkbox in Preferences > General");	
                try
                {
                    app.executeCommand(2359);
                }
                catch (e)
                {
                    alert(e);
                }
                if (!isSecurityPrefSet()) return null; 
            }
            myFile.encoding = "BINARY";
            myFile.open( "w" );
            myFile.write( binaryString );
            myFile.close();
        }
        return myFile;
    }

    function isSecurityPrefSet()
    {
        try
        {
            var securitySetting = app.preferences.getPrefAsLong("Main Pref Section","Pref_SCRIPTING_FILE_NETWORK_SECURITY");
            return (securitySetting == 1);
        }catch(e){
            return (securitySetting = 1);
        }
    }

    function helpWindow()
    {
        var w = new Window("dialog");
        var helpText = w.add("edittext", undefined, "MatchRate v"+VERSION_NUMBER+"\n=========\nMatchRate is an After Effects script for extending a layer property's animation at the same rate.\n\nInstructions\n\n1. Select two keyframes and click 'Get Rate.' The rate of the animation will load.\n2. Select the layer whose animation you want to change (it can be the same layer)\n3. Select the keyframe you want as the start of your new animation.\n4. Move the playhead to where you want the animation extended.\n5. Click 'Apply Rate' and the script write a new keyframe to the layer at the matched rate.", {multiline:true});
    	var blastframeImage="\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00P\x00\x00\x00\x1E\b\x06\x00\x00\x00\u00BBC\u0099\u00B1\x00\x00\x00\tpHYs\x00\x00\x0B\x12\x00\x00\x0B\x12\x01\u00D2\u00DD~\u00FC\x00\x00\x02UIDATh\u0081\u00ED\u0099\u00E1m\u00DB0\x10\u0085_\u008A\u00FC\u00B76\u00B0\x7F\u00E4\x7F\u00BC\u0081\u0095\t\u0092\r\u00E2\r\u00E2N\x10i\u0082\u00BA\x13\u00D4\u00DD\u00C0\u0099\u00A0\u00CE\x04U6\u00B0'\u00A84\u0081\x0B%\u00EF\u00E0\x17\u00D2R\u0090\u009C\u0080\x161?\u0080\u0090y<Q\u00BC\u00C7\u00E3\t\u0090\u00CF\u00F6\u00FB=\x12\x1F\u00E7K\u00D2\u00CEG\x12\u00D0I\x12\u00D0I\x12\u00D0I\x12\u00D0I\x12\u00D0I\x12\u00D0\u00C9{\x04\u00CC\x01\u00EC;\u00DA2\u00F2>\x11\u0086\u00CA\u00C0\u00BBS\x15q\u00C8#<\u008F,'\u00C0\u0090\x02\u008E\"\u00CB\u00C7\u00C8\u00D8B\u00F2\x0E\u00BB\u0087Ip\u00EF\u00B1\u00F9C\u009FW\f)\u00E0Cd\u0089\u00EBf\r`\n\u00A0`?\u008F\u00EE\x00\x16l\u00C6\r\u00EF\u00FB\x05\u00E0\x0FKEX\u008B7lj+\x02[\x1D\u009C\u0092\u00F6\u00D9k\u00E9O\u00E9\u00AF\"f\u00E2\x13>\u00B3\u009D\u00FFM\x01\u008F\x05\u00D8E_\r\u00DC\x01xd\u0096\u00DED\u00A3\u00AF\x17l\x02Z s\u00DE\u00F7\u0093m\x05\u00A0\u00E4|\x10\x1B\u00A4_R\f\u00A3\u00E4\u00F5\u0087\u00D8Z\x01.%\u00C6\u008C\u00FD\u0095\u00F47\u00B4i\x1C\u00A5\u00CEo\x02N\u00B8\u00D0B\u00DA\u0096\u00BB\u009E\u00B3M\u00A3p\x0F\x0B\u00BE\n\x16\x1C2\x060\u00A3\u00AD\u00CFoA\u00B1F\u0092\u0085\x15\u00AF\u00B7\u00BC\u00D6\u0092]`\u00C0*`\u00C5\u00B1Jl\u0085\u00F4\u00A7l3\x19S\u00AE9\u00DFR\u00C4\u00B3\u00D8k\u00C9\u00F6\u00E7\u00E7\u009F\u00CB\u008D[6\u00A3u\u00B8\u0088B\u008C\u00B9e{`\u00D0\u00DB\u00C8\u00E3e\u00E7\u00D6\u00F2\u00B6^G\x1E\u0087\u00EC\u00DB\u00C9\u00EF\u00A5d\u00F6\u009C\u00CF\u00C9\u00DE\u00C8\u00E2o\u00BC^\x05\u00B1\u00B5\u009B\u00D8PH\x13\u00FC\u0089B\u0086'\u00CD6\u00AB\u00E1f\u00DAi\u00B8dR\u00B5\u009CA\x04\f\u00C53\u00FA\u00B2%\u00E4Zv\u00B7\u008EF\x0F6-\u00CAs.~\u00CBE\u008E\u00C4\u00CF\u008E\u00BBe\x7F\x1B\u00F4}\u00CFI0\u00BER\u00A4*\x1Ay\u00C9\u00B6\t\x05jD\u0098BD\u00FD.\u0082n\u00B8\u00E9F#\u00F3\u00B6>\u009Bs\f\u00CB\u0098\u00A2\u0084\u00F5p\u00CC\u00E0w\x1C\u00B3\u0085\u00DBN?2\u00B0F\x02\u00B9g`k\u00EE\u00BC\x1D\u00A7\u00BEZ\x0B9\u00C2J\u00BB\x11\u00BF\u0099\u00D5&\u00CEJ^,3\u00D9\u00B8Z|\x16\u00C1<#9\u00FA\u00CF\x02\u00BE\u00E7\u008Bt.\u00E9\u00DBGy\u00A4\u00AEx\u00C9\u0098yUGv\u00FF3\u0086\u00CE@t\u00D47/\u00F5\u0091\u00AC\u00FA/\x18\u00FAc\u00C2SG\u00ED\u00F9\u00B4\f%`\u00C3\u00E2\u00DB\u00F7v\u00FC\u0094\u00A4\x7F\u00E5\u009C\u00A4\u00EF\u0081N\u0092\u0080N\u0092\u0080N\u0092\u0080N\u0092\u0080N\u0092\u0080N\u0092\u0080\x1E\x00\u00FC\x05\u00B6\u00A2\u009DysU\u008E\u0089\x00\x00\x00\x00IEND\u00AEB`\u0082";

        var helpButtonsGRP = w.add('group',undefined);
        helpButtonsGRP.alignment = ['fill','bottom'];
        var blastframeIcon = ScriptUI.newImage (createResourceFile ("blastframeImage.png", blastframeImage, getUserDataFolder()));
        var blastframeBTN =helpButtonsGRP.add('iconbutton',undefined,getUserDataFolder()+"/blastframeImage.png");
        blastframeBTN.alignment = ['left',' '];
        blastframeBTN.preferredSize = [100,30];
        blastframeBTN.helpTip = "Visit the author's web site, blastframe.com.";
        blastframeBTN.onClick = function()
        {
            var url = "http://blastframe.com";
            var os = system.osName;
            if (!os.length)
            {
                os = $.os;
            }
            var app_os =  ( os.indexOf("Win") != -1 )  ?  "Win" : "Mac";

            if ( app_os == "Win" )
            {
                system.callSystem("explorer " + url);
            }
            else
            {
                system.callSystem("open " + url);
            }
        };

        helpText.preferredSize = [600, 200];
        var closeBTN = helpButtonsGRP.add("button", undefined, "Close");
        closeBTN.alignment = ['right',' '];
        closeBTN.onClick = function ()
        {
            w.hide()
        };
        w.show();
    }

    function percentTextHandler(event)
    {
        percentText.active = false;
    }

    function adjustPercentage(e)
    {
        var textValue = parseInt(percentText.text);
        switch (e.target.text)
        {
            case "+":
                textValue += 10;
                break;
            case "-":
                textValue -= 10;
                break;
            default:
                break;
        }
        percentText.text = textValue.toString() + "%";
    }

    function verifyProperties(buttonName)
    {
        isEffect = false;
        if (proj.activeItem != null)
        {
            var comp = proj.activeItem;
        }
        else
        {
            alert(error6);
        }
        //see if first selected property is an Effect group
        for (var i = 0; i < comp.selectedProperties.length; i++)
        {
            if (comp.selectedProperties[i].parentProperty.name == "Effects")
            {
                isEffect = true;
            }
        }
        //if user selects multiple properties, deselect those without keyframes
        if (comp.selectedProperties.length > 1)
        {
            for (var j = 0; j < comp.selectedProperties.length; j++)
            {
                if (comp.selectedProperties[j].numKeys == 0)
                {
                    comp.selectedProperties[j].selected = false;
                }
            }
        }
        //if it is an effect, set the selected property to the Property object, not the Effects group
        if (isEffect)
        {
            property = comp.selectedProperties[1];
        }
        else
        {
            property = comp.selectedProperties[0];
        }
        //if no properties are selected or if more than two keyframes are selected, throw an error
        if (comp.selectedProperties.length === 0)
        {
            switch (buttonName)
            {
                case "getRate":
                    alert(error1);
                    break;
                case "applyRate":
                    alert(error1B);
                    break;
            }
        }
        else
        {
            layer = comp.selectedLayers[0];
            return true;
        }
    }

    function getRate()
    {
        proj = app.project;
        if (!verifyProperties("getRate"))
        {
            return;
        }
        propertyName = property.name;
        propertyValue = property.propertyValueType;
        if (property.selectedKeys.length !== 2)
        {
            alert(error1);
            return;
        }
        var v = 0;
        rateArray = [];
        key1Time = property.keyTime(property.selectedKeys[0]);
        key2Time = property.keyTime(property.selectedKeys[1]);
        key1Value = property.keyValue(property.selectedKeys[0]);
        key2Value = property.keyValue(property.selectedKeys[1]);
        keyTimeDiff = key2Time - key1Time;
        distance = [0, 0, 0];
        //if it's an effect, choose Property object
        if (isEffect)
        {
            v = 1;
        }
        if (comp.selectedProperties[v].value.length > 0)
        {
            for (var i = 0; i < comp.selectedProperties[v].value.length; i++)
            {
                distance[i] = key2Value[i] - key1Value[i];
                rateArray[i] = distance[i] / keyTimeDiff;
            }
        }
        else
        {
            distance[0] = key2Value - key1Value;
            rateArray[0] = distance[0] / keyTimeDiff;
        }
        if (rateArray[0] == 0 && rateArray[1] == 0 && rateArray[2] == 0)
        {
            alert(error5);
            return;
        }
        invert.enabled = true;
        applyBtn.enabled = true;
        clear.enabled = true;
        value1Checkbox.enabled = true;
        value2Checkbox.enabled = true;
        value3Checkbox.enabled = true;
        rate1Checkbox.visible = false;
        rate2Checkbox.visible = false;
        rate3Checkbox.visible = false;
        rate1Checkbox.enabled = false;
        rate2Checkbox.enabled = false;
        rate3Checkbox.enabled = false;
        targetText.enabled = true;
        sourceText.enabled = true;
        sourceText.visible = true;
        percentageGroup.visible = true;
        applybuttonGrp.visible = true;
        panel2.visible = true;
        updateValues();
    }

    function invertValues()
    {
        //invert each property value
        for (var i = 0; i < rateArray.length; i++)
        {
            rateArray[i] = rateArray[i] * -1;
        }
        updateValues();
    }

    function updateValues()
    {
        rate1Text.text = "";
        rate2Text.text = "";
        rate3Text.text = "";
        if (rateArray.length == 1)
        {
            rate1Text.text = propertyName + " : " + Math.round(rateArray[0] * 10) / 10 + "/sec";
            rate1Checkbox.visible = true;
            rate1Checkbox.enabled = false;
        }
        else
        {
            var spatial = [];
            if (property.isSpatial || property.name == "Scale")
            {
                spatial[0] = " (x) ";
                spatial[1] = " (y) ";
                spatial[2] = " (z) ";
                for (var i = 0; i < rateArray.length; i++)
                {
                    (eval("rate" + (i + 1) + "Checkbox")).enabled = true;
                    (eval("rate" + (i + 1) + "Checkbox")).visible = true;
                    var texty = eval("rate" + (i + 1) + "Text");
                    texty.text = propertyName + spatial[i] + " : " + Math.round(rateArray[i] * 10) / 10 + "/sec";
                }
            }
            else
            {
                for (var i = 0; i < rateArray.length; i++)
                {
                    (eval("rate" + (i + 1) + "Checkbox")).visible = true;
                    (eval("rate" + (i + 1) + "Checkbox")).enabled = true;
                    var texty = eval("rate" + (i + 1) + "Text");
                    texty.text = propertyName + " : " + Math.round(rateArray[i] * 10) / 10 + "/sec";
                }
            }
        }
    }

    function applyRate()
    {
        app.beginUndoGroup("Apply Rate");
        var newKeyDistance = [];
        var newKeyValue = [];
        var tempValue = null;
        var textValue = parseInt(percentText.text) / 100;
        if (!textValue)
        {
            alert("Please enter a number for the percentage.");
            return;
        };
        if (!verifyProperties("applyRate"))
        {
            return;
        }
        comp = proj.activeItem;
        var layer = comp.selectedLayers[0];
        if (comp.selectedProperties.length === 0)
        {
            alert(error4);
        }
        else
        {
            //if it's an effect, target the Property object.
            for (var i = 0; i < comp.selectedProperties.length; i++)
            {
                if (comp.selectedProperties[i].parentProperty.name == "Effects")
                {
                    isEffect = true;
                }
            }
            if (isEffect)
            {
                property = comp.selectedProperties[1];
            }
            else
            {
                property = comp.selectedProperties[0];
            }

            key1Time = property.keyTime(property.selectedKeys[0]);
            key1Value = property.keyValue(property.selectedKeys[0]);
            newTimeDifference = comp.time - key1Time;
            //rate source is 1D
            if (rateArray.length == 1)
            {
                //and target is 3D
                if (property.value instanceof Array)
                {
                    //$.writeln("case 1 - rate source is one dimensional and target is three dimensional");
                    for (var i = 0; i < property.value.length; i++)
                    {
                        if (eval("value" + (i + 1) + "Checkbox").value)
                        {
                            //if the checkbox is checked, set the value to the one dimensional value
                            newKeyDistance[i] = (newTimeDifference * rateArray[0]);
                        }
                        else
                        {
                            newKeyDistance[i] = 0;
                        }
                        newKeyValue[i] = (key1Value[i] + newKeyDistance[i]) * textValue;
                    }
                    property.setValueAtTime(comp.time, newKeyValue);
                }
                else
                {
                    //$.writeln("case 2 - source and target are one dimensional");
                    newKeyDistance = newTimeDifference * rateArray[0];
                    newKeyValue = (key1Value + newKeyDistance) * textValue;
                    if (property.hasMin || property.hasMax)
                    {
                        var minimum = 0;
                        var maximum = 999999;
                        if (property.hasMin)
                        {
                            minimum = property.minValue;
                        }
                        if (property.hasMax)
                        {
                            maximum = property.maxValue;
                        }
                        if (newKeyValue <= maximum && newKeyValue >= minimum)
                        {
                            property.setValueAtTime(comp.time, newKeyValue);
                        }
                        else
                        {
                            alert(error3);
                        }
                    }
                    else
                    {
                        property.setValueAtTime(comp.time, newKeyValue);
                    }
                }
            }
            else
            {
                if (property.value instanceof Array)
                {
                    numChecks = 0;
                    //$.writeln("case 3 - source and target value are multi-dimensional");
                    for (var k = 0; k < 3; k++)
                    {
                        if (eval("rate" + (k + 1) + "Checkbox").value == true)
                        {
                            numChecks++;
                        }
                    }
                    if (numChecks === 1);
                    {
                        for (var i = 0; i < 3; i++)
                        {
                            if (eval("rate" + (i + 1) + "Checkbox").value == true)
                            {
                                tempValue = rateArray[i];
                            }
                        }
                    }
                    for (var i = 0; i < rateArray.length; i++)
                    {
                        if (eval("value" + (i + 1) + "Checkbox").value)
                        {
                            if (numChecks === 1)
                            {
                                newKeyDistance[i] = (newTimeDifference * tempValue);
                            }
                            else
                            {
                                newKeyDistance[i] = (newTimeDifference * rateArray[i]);
                            }
                        }
                        else
                        {
                            newKeyDistance[i] = 0;
                        }
                        newKeyValue[i] = key1Value[i] + (newKeyDistance[i] * textValue);
                    }
                    //3D to 2D
                    for (var j = 0; j < newKeyValue.length; j++)
                    {
                        if (isNaN(newKeyValue[j]))
                        {
                            newKeyValue.splice(j, 1);
                        }
                    }
                    property.setValueAtTime(comp.time, newKeyValue);
                }
                else
                {
                    //$.writeln("case 4 - source is one dimensional, target is multi-dimensional");
                    for (var i = 0; i < rateArray.length; i++)
                    {
                        if (eval("rate" + (i + 1) + "Checkbox").value)
                        {
                            //if the checkbox is checked, set the value to the one dimensional value
                            newKeyDistance = (newTimeDifference * rateArray[i]);
                        }
                    }
                    newKeyValue = (key1Value + newKeyDistance) * textValue;
                    if (property.hasMin || property.hasMax)
                    {
                        if (newKeyValue <= property.maxValue && newKeyValue >= property.minValue)
                        {
                            property.setValueAtTime(comp.time, newKeyValue);
                        }
                        else
                        {
                            alert(error3);
                        }
                    }
                    else
                    {
                        property.setValueAtTime(comp.time, newKeyValue);
                    }
                }
            }
        }
        app.endUndoGroup();
    }

    function clearValues()
    {
        rate1Text.text = "Please choose two keyframes";
        rate2Text.text = "";
        rate3Text.text = "";
        rateArray = [];
        newKeyDistance = null;
        newKeyValue = null;
        invert.enabled = false;
        applyBtn.enabled = false;
        clear.enabled = false;
        value1Checkbox.value = true;
        value1Checkbox.enabled = false;
        value2Checkbox.value = true;
        value2Checkbox.enabled = false;
        value3Checkbox.value = true;
        value3Checkbox.enabled = false;
        rate1Checkbox.value = true;
        rate2Checkbox.value = true;
        rate3Checkbox.value = true;
        rate1Checkbox.visible = false;
        rate2Checkbox.visible = false;
        rate3Checkbox.visible = false;
        rate1Checkbox.enabled = true;
        rate2Checkbox.enabled = true;
        rate3Checkbox.enabled = true;
        sourceText.enabled = false;
        sourceText.visible = false;
        targetText.enabled = false;
        percentageGroup.visible = false;
        applybuttonGrp.visible = false;
        panel2.visible = false;
        percentText.text = "100%";
    }
}
matchRate(this)
