/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import us.deathmarine.luyten.TreeNodeUserObject;

public class TreeUtil {
    private JTree tree;

    public TreeUtil() {
    }

    public TreeUtil(JTree tree) {
        this.tree = tree;
    }

    public Set<String> getExpansionState() {
        HashSet<String> openedSet = new HashSet<String>();
        if (this.tree != null) {
            int rowCount = this.tree.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                TreePath path = this.tree.getPathForRow(i);
                if (!this.tree.isExpanded(path)) continue;
                String rowPathStr = this.getRowPathStr(path);
                openedSet.addAll(this.getAllParentPathsStr(rowPathStr));
            }
        }
        return openedSet;
    }

    private Set<String> getAllParentPathsStr(String rowPathStr) {
        HashSet<String> parents = new HashSet<String>();
        parents.add(rowPathStr);
        if (rowPathStr.contains("/")) {
            String[] pathElements = rowPathStr.split("/");
            String path = "";
            for (String pathElement : pathElements) {
                path = path + pathElement + "/";
                parents.add(path);
            }
        }
        return parents;
    }

    public void restoreExpanstionState(Set<String> expansionState) {
        if (this.tree != null && expansionState != null) {
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                TreePath path = this.tree.getPathForRow(i);
                if (!expansionState.contains(this.getRowPathStr(path))) continue;
                this.tree.expandRow(i);
            }
        }
    }

    private String getRowPathStr(TreePath trp) {
        String pathStr = "";
        if (trp.getPathCount() > 1) {
            for (int i = 1; i < trp.getPathCount(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)trp.getPathComponent(i);
                TreeNodeUserObject userObject = (TreeNodeUserObject)node.getUserObject();
                pathStr = pathStr + userObject.getOriginalName() + "/";
            }
        }
        return pathStr;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setTree(JTree tree) {
        this.tree = tree;
    }
}

