/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import com.strobel.assembler.InputTypeLoader;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.JarTypeLoader;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilationOptions;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.PlainTextOutput;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.RTextScrollPane;
import us.deathmarine.luyten.CellRenderer;
import us.deathmarine.luyten.Closer;
import us.deathmarine.luyten.ConfigSaver;
import us.deathmarine.luyten.FileEntryNotFoundException;
import us.deathmarine.luyten.FileIsBinaryException;
import us.deathmarine.luyten.FindBox;
import us.deathmarine.luyten.JarEntryFilter;
import us.deathmarine.luyten.Keymap;
import us.deathmarine.luyten.Luyten;
import us.deathmarine.luyten.LuytenPreferences;
import us.deathmarine.luyten.LuytenTypeLoader;
import us.deathmarine.luyten.MainWindow;
import us.deathmarine.luyten.OpenFile;
import us.deathmarine.luyten.RecentFiles;
import us.deathmarine.luyten.TooLargeFileException;
import us.deathmarine.luyten.TreeNodeUserObject;
import us.deathmarine.luyten.TreeUtil;

public class Model
extends JSplitPane {
    private static final long serialVersionUID = 6896857630400910200L;
    private static final long MAX_JAR_FILE_SIZE_BYTES = 10000000000L;
    private static final long MAX_UNPACKED_FILE_SIZE_BYTES = 10000000L;
    private static LuytenTypeLoader typeLoader = new LuytenTypeLoader();
    public static MetadataSystem metadataSystem = new MetadataSystem(typeLoader);
    private JTree tree;
    public JTabbedPane house;
    private File file;
    private DecompilerSettings settings;
    private DecompilationOptions decompilationOptions;
    private Theme theme;
    private MainWindow mainWindow;
    private JProgressBar bar;
    private JLabel label;
    private HashSet<OpenFile> hmap = new HashSet();
    private Set<String> treeExpansionState;
    private boolean open = false;
    private State state;
    private ConfigSaver configSaver;
    private LuytenPreferences luytenPrefs;

    public Model(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.bar = mainWindow.getBar();
        this.setLabel(mainWindow.getLabel());
        this.configSaver = ConfigSaver.getLoadedInstance();
        this.settings = this.configSaver.getDecompilerSettings();
        this.luytenPrefs = this.configSaver.getLuytenPreferences();
        try {
            String themeXml = this.luytenPrefs.getThemeXml();
            this.setTheme(Theme.load(this.getClass().getResourceAsStream("/org/fife/ui/rsyntaxtextarea/themes/" + themeXml)));
        }
        catch (Exception e1) {
            try {
                Luyten.showExceptionDialog("Exception!", e1);
                String themeXml = "eclipse.xml";
                this.luytenPrefs.setThemeXml(themeXml);
                this.setTheme(Theme.load(this.getClass().getResourceAsStream("/org/fife/ui/rsyntaxtextarea/themes/" + themeXml)));
            }
            catch (Exception e2) {
                Luyten.showExceptionDialog("Exception!", e2);
            }
        }
        this.tree = new JTree();
        this.tree.setModel(new DefaultTreeModel(null));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new CellRenderer());
        TreeListener tl = new TreeListener();
        this.tree.addMouseListener(tl);
        this.tree.addTreeExpansionListener(new FurtherExpandingTreeExpansionListener());
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    Model.this.openEntryByTreePath(Model.this.tree.getSelectionPath());
                }
            }
        });
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.setBorder(BorderFactory.createTitledBorder("Structure"));
        panel2.add(new JScrollPane(this.tree));
        this.house = new JTabbedPane();
        this.house.setTabLayoutPolicy(1);
        this.house.addChangeListener(new TabChangeListener());
        this.house.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    Model.this.closeOpenTab(Model.this.house.getSelectedIndex());
                }
            }
        });
        KeyStroke sfuncF4 = KeyStroke.getKeyStroke(115, Keymap.ctrlDownModifier(), false);
        mainWindow.getRootPane().getInputMap(2).put(sfuncF4, "CloseTab");
        mainWindow.getRootPane().getActionMap().put("CloseTab", new AbstractAction(){
            private static final long serialVersionUID = -885398399200419492L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Model.this.closeOpenTab(Model.this.house.getSelectedIndex());
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder("Code"));
        panel.add(this.house);
        this.setOrientation(1);
        this.setDividerLocation(250 % mainWindow.getWidth());
        this.setLeftComponent(panel2);
        this.setRightComponent(panel);
        this.decompilationOptions = new DecompilationOptions();
        this.decompilationOptions.setSettings(this.settings);
        this.decompilationOptions.setFullDecompilation(true);
    }

    public void showLegal(String legalStr) {
        this.show("Legal", legalStr);
    }

    public void show(String name, String contents) {
        OpenFile open = new OpenFile(name, "*/" + name, this.getTheme(), this.mainWindow);
        open.setContent(contents);
        this.hmap.add(open);
        this.addOrSwitchToTab(open);
    }

    private void addOrSwitchToTab(final OpenFile open) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    String title = open.name;
                    RTextScrollPane rTextScrollPane = open.scrollPane;
                    if (Model.this.house.indexOfTab(title) < 0) {
                        Model.this.house.addTab(title, rTextScrollPane);
                        Model.this.house.setSelectedIndex(Model.this.house.indexOfTab(title));
                        int index = Model.this.house.indexOfTab(title);
                        Tab ct = new Tab(title);
                        ct.getButton().addMouseListener(new CloseTab(title));
                        Model.this.house.setTabComponentAt(index, ct);
                    } else {
                        Model.this.house.setSelectedIndex(Model.this.house.indexOfTab(title));
                    }
                    open.onAddedToScreen();
                }
                catch (Exception e) {
                    Luyten.showExceptionDialog("Exception!", e);
                }
            }
        });
    }

    public void closeOpenTab(int index) {
        RTextScrollPane co = (RTextScrollPane)this.house.getComponentAt(index);
        RSyntaxTextArea pane = (RSyntaxTextArea)co.getViewport().getView();
        OpenFile open = null;
        for (OpenFile file : this.hmap) {
            if (!pane.equals(file.textArea)) continue;
            open = file;
        }
        if (open != null && this.hmap.contains(open)) {
            this.hmap.remove(open);
        }
        this.house.remove(co);
        if (open != null) {
            open.close();
        }
    }

    private String getName(String path) {
        if (path == null) {
            return "";
        }
        int i = path.lastIndexOf("/");
        if (i == -1) {
            i = path.lastIndexOf("\\");
        }
        if (i != -1) {
            return path.substring(i + 1);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openEntryByTreePath(TreePath trp) {
        String name = "";
        String path = "";
        try {
            this.bar.setVisible(true);
            if (trp.getPathCount() > 1) {
                for (int i = 1; i < trp.getPathCount(); ++i) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)trp.getPathComponent(i);
                    TreeNodeUserObject userObject = (TreeNodeUserObject)node.getUserObject();
                    if (i == trp.getPathCount() - 1) {
                        name = userObject.getOriginalName();
                        continue;
                    }
                    path = path + userObject.getOriginalName() + "/";
                }
                path = path + name;
                if (this.file.getName().endsWith(".jar") || this.file.getName().endsWith(".zip")) {
                    JarEntry entry;
                    if (this.state == null) {
                        JarFile jfile = new JarFile(this.file);
                        JarTypeLoader jarLoader = new JarTypeLoader(jfile);
                        typeLoader.getTypeLoaders().add(jarLoader);
                        this.state = new State(this.file.getCanonicalPath(), this.file, jfile, jarLoader);
                    }
                    if ((entry = this.state.jarFile.getJarEntry(path)) == null) {
                        throw new FileEntryNotFoundException();
                    }
                    if (entry.getSize() > 10000000L) {
                        throw new TooLargeFileException(entry.getSize());
                    }
                    String entryName = entry.getName();
                    if (entryName.endsWith(".class")) {
                        this.getLabel().setText("Extracting: " + name);
                        String internalName = StringUtilities.removeRight(entryName, ".class");
                        TypeReference type = metadataSystem.lookupType(internalName);
                        this.extractClassToTextPane(type, name, path, null);
                    } else {
                        this.getLabel().setText("Opening: " + name);
                        try (InputStream in = this.state.jarFile.getInputStream(entry);){
                            this.extractSimpleFileEntryToTextPane(in, name, path);
                        }
                    }
                }
            } else {
                name = this.file.getName();
                path = this.file.getPath().replaceAll("\\\\", "/");
                if (this.file.length() > 10000000L) {
                    throw new TooLargeFileException(this.file.length());
                }
                if (name.endsWith(".class")) {
                    this.getLabel().setText("Extracting: " + name);
                    TypeReference type = metadataSystem.lookupType(path);
                    this.extractClassToTextPane(type, name, path, null);
                } else {
                    this.getLabel().setText("Opening: " + name);
                    try (FileInputStream in = new FileInputStream(this.file);){
                        this.extractSimpleFileEntryToTextPane(in, name, path);
                    }
                }
            }
            this.getLabel().setText("Complete");
        }
        catch (FileEntryNotFoundException e) {
            this.getLabel().setText("File not found: " + name);
        }
        catch (FileIsBinaryException e) {
            this.getLabel().setText("Binary resource: " + name);
        }
        catch (TooLargeFileException e) {
            this.getLabel().setText("File is too large: " + name + " - size: " + e.getReadableFileSize());
        }
        catch (Exception e) {
            this.getLabel().setText("Cannot open: " + name);
            Luyten.showExceptionDialog("Unable to open file!", e);
        }
        finally {
            this.bar.setVisible(false);
        }
    }

    void extractClassToTextPane(TypeReference type, String tabTitle, String path, String navigatonLink) throws Exception {
        if (tabTitle == null || tabTitle.trim().length() < 1 || path == null) {
            throw new FileEntryNotFoundException();
        }
        OpenFile sameTitledOpen = null;
        for (OpenFile nextOpen : this.hmap) {
            if (!tabTitle.equals(nextOpen.name)) continue;
            sameTitledOpen = nextOpen;
            break;
        }
        if (sameTitledOpen != null && path.equals(sameTitledOpen.path) && type.equals(sameTitledOpen.getType()) && sameTitledOpen.isContentValid()) {
            sameTitledOpen.setInitialNavigationLink(navigatonLink);
            this.addOrSwitchToTab(sameTitledOpen);
            return;
        }
        TypeDefinition resolvedType = null;
        if (type == null || (resolvedType = type.resolve()) == null) {
            throw new Exception("Unable to resolve type.");
        }
        if (sameTitledOpen != null) {
            sameTitledOpen.path = path;
            sameTitledOpen.invalidateContent();
            sameTitledOpen.setDecompilerReferences(metadataSystem, this.settings, this.decompilationOptions);
            sameTitledOpen.setType(resolvedType);
            sameTitledOpen.setInitialNavigationLink(navigatonLink);
            sameTitledOpen.resetScrollPosition();
            sameTitledOpen.decompile();
            this.addOrSwitchToTab(sameTitledOpen);
        } else {
            OpenFile open = new OpenFile(tabTitle, path, this.getTheme(), this.mainWindow);
            open.setDecompilerReferences(metadataSystem, this.settings, this.decompilationOptions);
            open.setType(resolvedType);
            open.setInitialNavigationLink(navigatonLink);
            open.decompile();
            this.hmap.add(open);
            this.addOrSwitchToTab(open);
        }
    }

    public void extractSimpleFileEntryToTextPane(InputStream inputStream, String tabTitle, String path) throws Exception {
        boolean isTextFile;
        if (inputStream == null || tabTitle == null || tabTitle.trim().length() < 1 || path == null) {
            throw new FileEntryNotFoundException();
        }
        OpenFile sameTitledOpen = null;
        for (OpenFile nextOpen : this.hmap) {
            if (!tabTitle.equals(nextOpen.name)) continue;
            sameTitledOpen = nextOpen;
            break;
        }
        if (sameTitledOpen != null && path.equals(sameTitledOpen.path)) {
            this.addOrSwitchToTab(sameTitledOpen);
            return;
        }
        StringBuilder sb = new StringBuilder();
        long nonprintableCharactersCount = 0L;
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
                for (byte nextByte : line.getBytes()) {
                    if (nextByte > 0) continue;
                    ++nonprintableCharactersCount;
                }
            }
        }
        String extension = "." + tabTitle.replaceAll("^[^\\.]*$", "").replaceAll("[^\\.]*\\.", "");
        boolean bl = isTextFile = OpenFile.WELL_KNOWN_TEXT_FILE_EXTENSIONS.contains(extension) || nonprintableCharactersCount < (long)(sb.length() / 5);
        if (!isTextFile) {
            throw new FileIsBinaryException();
        }
        if (sameTitledOpen != null) {
            sameTitledOpen.path = path;
            sameTitledOpen.setDecompilerReferences(metadataSystem, this.settings, this.decompilationOptions);
            sameTitledOpen.resetScrollPosition();
            sameTitledOpen.setContent(sb.toString());
            this.addOrSwitchToTab(sameTitledOpen);
        } else {
            OpenFile open = new OpenFile(tabTitle, path, this.getTheme(), this.mainWindow);
            open.setDecompilerReferences(metadataSystem, this.settings, this.decompilationOptions);
            open.setContent(sb.toString());
            this.hmap.add(open);
            this.addOrSwitchToTab(open);
        }
    }

    public void updateOpenClasses() {
        for (OpenFile open : this.hmap) {
            if (open.getType() == null) continue;
            open.invalidateContent();
        }
        for (OpenFile open : this.hmap) {
            if (open.getType() == null || !this.isTabInForeground(open)) continue;
            this.updateOpenClass(open);
            break;
        }
    }

    private void updateOpenClass(final OpenFile open) {
        if (open.getType() == null) {
            return;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Model.this.bar.setVisible(true);
                    Model.this.getLabel().setText("Extracting: " + open.name);
                    open.invalidateContent();
                    open.decompile();
                    Model.this.getLabel().setText("Complete");
                }
                catch (Exception e) {
                    Model.this.getLabel().setText("Error, cannot update: " + open.name);
                }
                finally {
                    Model.this.bar.setVisible(false);
                }
            }
        }).start();
    }

    private boolean isTabInForeground(OpenFile open) {
        String title = open.name;
        int selectedIndex = this.house.getSelectedIndex();
        return selectedIndex >= 0 && selectedIndex == this.house.indexOfTab(title);
    }

    public DefaultMutableTreeNode loadNodesByNames(DefaultMutableTreeNode node, List<String> originalNames) {
        ArrayList<TreeNodeUserObject> args = new ArrayList<TreeNodeUserObject>();
        for (String originalName : originalNames) {
            args.add(new TreeNodeUserObject(originalName));
        }
        return this.loadNodesByUserObj(node, args);
    }

    public DefaultMutableTreeNode loadNodesByUserObj(DefaultMutableTreeNode node, List<TreeNodeUserObject> args) {
        if (args.size() > 0) {
            TreeNodeUserObject name = args.remove(0);
            DefaultMutableTreeNode nod = this.getChild(node, name);
            if (nod == null) {
                nod = new DefaultMutableTreeNode(name);
            }
            node.add(this.loadNodesByUserObj(nod, args));
        }
        return node;
    }

    public DefaultMutableTreeNode getChild(DefaultMutableTreeNode node, TreeNodeUserObject name) {
        Enumeration<TreeNode> entry = node.children();
        while (entry.hasMoreElements()) {
            DefaultMutableTreeNode nods = (DefaultMutableTreeNode)entry.nextElement();
            if (!((TreeNodeUserObject)nods.getUserObject()).getOriginalName().equals(name.getOriginalName())) continue;
            return nods;
        }
        return null;
    }

    public void loadFile(File file) {
        if (this.open) {
            this.closeFile();
        }
        this.file = file;
        RecentFiles.add(file.getAbsolutePath());
        this.mainWindow.mainMenuBar.updateRecentFiles();
        this.loadTree();
    }

    public void updateTree() {
        TreeUtil treeUtil = new TreeUtil(this.tree);
        this.treeExpansionState = treeUtil.getExpansionState();
        this.loadTree();
    }

    public void loadTree() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (Model.this.file == null) {
                        return;
                    }
                    Model.this.tree.setModel(new DefaultTreeModel(null));
                    if (Model.this.file.length() > 10000000000L) {
                        throw new TooLargeFileException(Model.this.file.length());
                    }
                    if (Model.this.file.getName().endsWith(".zip") || Model.this.file.getName().endsWith(".jar")) {
                        JarFile jfile = new JarFile(Model.this.file);
                        Model.this.getLabel().setText("Loading: " + jfile.getName());
                        Model.this.bar.setVisible(true);
                        JarEntryFilter jarEntryFilter = new JarEntryFilter(jfile);
                        List<String> mass = null;
                        mass = Model.this.luytenPrefs.isFilterOutInnerClassEntries() ? jarEntryFilter.getEntriesWithoutInnerClasses() : jarEntryFilter.getAllEntriesFromJar();
                        Model.this.buildTreeFromMass(mass);
                        if (Model.this.state == null) {
                            JarTypeLoader jarLoader = new JarTypeLoader(jfile);
                            typeLoader.getTypeLoaders().add(jarLoader);
                            Model.this.state = new State(Model.this.file.getCanonicalPath(), Model.this.file, jfile, jarLoader);
                        }
                        Model.this.open = true;
                        Model.this.getLabel().setText("Complete");
                    } else {
                        TreeNodeUserObject topNodeUserObject = new TreeNodeUserObject(Model.this.getName(Model.this.file.getName()));
                        final DefaultMutableTreeNode top = new DefaultMutableTreeNode(topNodeUserObject);
                        Model.this.tree.setModel(new DefaultTreeModel(top));
                        Model.this.settings.setTypeLoader(new InputTypeLoader());
                        Model.this.open = true;
                        Model.this.getLabel().setText("Complete");
                        new Thread(){

                            @Override
                            public void run() {
                                TreePath trp = new TreePath(top.getPath());
                                Model.this.openEntryByTreePath(trp);
                            }
                        }.start();
                    }
                    if (Model.this.treeExpansionState != null) {
                        try {
                            TreeUtil treeUtil = new TreeUtil(Model.this.tree);
                            treeUtil.restoreExpanstionState(Model.this.treeExpansionState);
                        }
                        catch (Exception e) {
                            Luyten.showExceptionDialog("Exception!", e);
                        }
                    }
                }
                catch (TooLargeFileException e) {
                    Model.this.getLabel().setText("File is too large: " + Model.this.file.getName() + " - size: " + e.getReadableFileSize());
                    Model.this.closeFile();
                }
                catch (Exception e1) {
                    Luyten.showExceptionDialog("Cannot open " + Model.this.file.getName() + "!", e1);
                    Model.this.getLabel().setText("Cannot open: " + Model.this.file.getName());
                    Model.this.closeFile();
                }
                finally {
                    Model.this.mainWindow.onFileLoadEnded(Model.this.file, Model.this.open);
                    Model.this.bar.setVisible(false);
                }
            }
        }).start();
    }

    private void buildTreeFromMass(List<String> mass) {
        if (this.luytenPrefs.isPackageExplorerStyle()) {
            this.buildFlatTreeFromMass(mass);
        } else {
            this.buildDirectoryTreeFromMass(mass);
        }
    }

    private void buildDirectoryTreeFromMass(List<String> mass) {
        TreeNodeUserObject topNodeUserObject = new TreeNodeUserObject(this.getName(this.file.getName()));
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(topNodeUserObject);
        ArrayList<String> sort = new ArrayList<String>();
        Collections.sort(mass, String.CASE_INSENSITIVE_ORDER);
        for (String m : mass) {
            if (!m.contains("META-INF") || sort.contains(m)) continue;
            sort.add(m);
        }
        HashSet<String> set = new HashSet<String>();
        for (String m : mass) {
            if (!m.contains("/")) continue;
            set.add(m.substring(0, m.lastIndexOf("/") + 1));
        }
        List<String> packs = Arrays.asList(set.toArray(new String[0]));
        Collections.sort(packs, String.CASE_INSENSITIVE_ORDER);
        Collections.sort(packs, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.split("/").length - o1.split("/").length;
            }
        });
        for (String pack : packs) {
            for (String m : mass) {
                if (m.contains("META-INF") || !m.contains(pack) || m.replace(pack, "").contains("/")) continue;
                sort.add(m);
            }
        }
        for (String m : mass) {
            if (m.contains("META-INF") || m.contains("/") || sort.contains(m)) continue;
            sort.add(m);
        }
        for (String pack : sort) {
            LinkedList<String> list = new LinkedList<String>(Arrays.asList(pack.split("/")));
            this.loadNodesByNames(top, list);
        }
        this.tree.setModel(new DefaultTreeModel(top));
    }

    private void buildFlatTreeFromMass(List<String> mass) {
        String packageRoot;
        ArrayList<String> list;
        TreeNodeUserObject topNodeUserObject = new TreeNodeUserObject(this.getName(this.file.getName()));
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(topNodeUserObject);
        TreeMap<String, TreeSet<String>> packages = new TreeMap<String, TreeSet<String>>();
        HashSet<String> classContainingPackageRoots = new HashSet<String>();
        Comparator<String> sortByFileExtensionsComparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int comp = o1.replaceAll("[^\\.]*\\.", "").compareTo(o2.replaceAll("[^\\.]*\\.", ""));
                if (comp != 0) {
                    return comp;
                }
                return o1.compareTo(o2);
            }
        };
        for (String entry : mass) {
            String packagePath = "";
            String packageRoot2 = "";
            if (entry.contains("/")) {
                packagePath = entry.replaceAll("/[^/]*$", "");
                packageRoot2 = entry.replaceAll("/.*$", "");
            }
            String packageEntry = entry.replace(packagePath + "/", "");
            if (!packages.containsKey(packagePath)) {
                packages.put(packagePath, new TreeSet<String>(sortByFileExtensionsComparator));
            }
            ((TreeSet)packages.get(packagePath)).add(packageEntry);
            if (entry.startsWith("META-INF") || packageRoot2.trim().length() <= 0 || !entry.matches(".*\\.(class|java|prop|properties)$")) continue;
            classContainingPackageRoots.add(packageRoot2);
        }
        for (String packagePath : packages.keySet()) {
            if (!packagePath.startsWith("META-INF")) continue;
            List<String> packagePathElements = Arrays.asList(packagePath.split("/"));
            for (String entry : (TreeSet)packages.get(packagePath)) {
                list = new ArrayList<String>(packagePathElements);
                list.add(entry);
                this.loadNodesByNames(top, list);
            }
        }
        for (String packagePath : packages.keySet()) {
            packageRoot = packagePath.replaceAll("/.*$", "");
            if (!classContainingPackageRoots.contains(packageRoot)) continue;
            for (String entry : (TreeSet)packages.get(packagePath)) {
                list = new ArrayList();
                list.add((String)((Object)new TreeNodeUserObject(packagePath, packagePath.replaceAll("/", "."))));
                list.add((String)((Object)new TreeNodeUserObject(entry)));
                this.loadNodesByUserObj(top, list);
            }
        }
        for (String packagePath : packages.keySet()) {
            packageRoot = packagePath.replaceAll("/.*$", "");
            if (classContainingPackageRoots.contains(packageRoot) || packagePath.startsWith("META-INF") || packagePath.length() <= 0) continue;
            List<String> packagePathElements = Arrays.asList(packagePath.split("/"));
            for (String entry : (TreeSet)packages.get(packagePath)) {
                ArrayList<String> list2 = new ArrayList<String>(packagePathElements);
                list2.add(entry);
                this.loadNodesByNames(top, list2);
            }
        }
        String packagePath = "";
        if (packages.containsKey(packagePath)) {
            for (String entry : (TreeSet)packages.get(packagePath)) {
                ArrayList<String> list3 = new ArrayList<String>();
                list3.add(entry);
                this.loadNodesByNames(top, list3);
            }
        }
        this.tree.setModel(new DefaultTreeModel(top));
    }

    public void closeFile() {
        for (OpenFile co : this.hmap) {
            int pos = this.house.indexOfTab(co.name);
            if (pos >= 0) {
                this.house.remove(pos);
            }
            co.close();
        }
        State oldState = this.state;
        this.state = null;
        if (oldState != null) {
            Closer.tryClose((AutoCloseable)oldState);
        }
        this.hmap.clear();
        this.tree.setModel(new DefaultTreeModel(null));
        metadataSystem = new MetadataSystem(typeLoader);
        this.file = null;
        this.treeExpansionState = null;
        this.open = false;
        this.mainWindow.onFileLoadEnded(this.file, this.open);
    }

    public void changeTheme(String xml) {
        InputStream in = this.getClass().getResourceAsStream("/org/fife/ui/rsyntaxtextarea/themes/" + xml);
        try {
            if (in != null) {
                this.setTheme(Theme.load(in));
                for (OpenFile f : this.hmap) {
                    this.getTheme().apply(f.textArea);
                }
            }
        }
        catch (Exception e1) {
            Luyten.showExceptionDialog("Exception!", e1);
        }
    }

    public File getOpenedFile() {
        File openedFile = null;
        if (this.file != null && this.open) {
            openedFile = this.file;
        }
        if (openedFile == null) {
            this.getLabel().setText("No open file");
        }
        return openedFile;
    }

    public String getCurrentTabTitle() {
        String tabTitle = null;
        try {
            int pos = this.house.getSelectedIndex();
            if (pos >= 0) {
                tabTitle = this.house.getTitleAt(pos);
            }
        }
        catch (Exception e1) {
            Luyten.showExceptionDialog("Exception!", e1);
        }
        if (tabTitle == null) {
            this.getLabel().setText("No open tab");
        }
        return tabTitle;
    }

    public RSyntaxTextArea getCurrentTextArea() {
        RSyntaxTextArea currentTextArea = null;
        try {
            int pos = this.house.getSelectedIndex();
            System.out.println(pos);
            if (pos >= 0) {
                RTextScrollPane co = (RTextScrollPane)this.house.getComponentAt(pos);
                currentTextArea = (RSyntaxTextArea)co.getViewport().getView();
            }
        }
        catch (Exception e1) {
            Luyten.showExceptionDialog("Exception!", e1);
        }
        if (currentTextArea == null) {
            this.getLabel().setText("No open tab");
        }
        return currentTextArea;
    }

    public void startWarmUpThread() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                    String internalName = FindBox.class.getName();
                    TypeReference type = metadataSystem.lookupType(internalName);
                    TypeDefinition resolvedType = null;
                    if (type == null || (resolvedType = type.resolve()) == null) {
                        return;
                    }
                    StringWriter stringwriter = new StringWriter();
                    PlainTextOutput plainTextOutput = new PlainTextOutput(stringwriter);
                    plainTextOutput.setUnicodeOutputEnabled(Model.this.decompilationOptions.getSettings().isUnicodeOutputEnabled());
                    Model.this.settings.getLanguage().decompileType(resolvedType, plainTextOutput, Model.this.decompilationOptions);
                    String decompiledSource = stringwriter.toString();
                    OpenFile open = new OpenFile(internalName, "*/" + internalName, Model.this.getTheme(), Model.this.mainWindow);
                    open.setContent(decompiledSource);
                    JTabbedPane pane = new JTabbedPane();
                    pane.setTabLayoutPolicy(1);
                    pane.addTab("title", open.scrollPane);
                    pane.setSelectedIndex(pane.indexOfTab("title"));
                }
                catch (Exception e) {
                    Luyten.showExceptionDialog("Exception!", e);
                }
            }
        }.start();
    }

    public void navigateTo(final String uniqueStr) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (uniqueStr == null) {
                    return;
                }
                String[] linkParts = uniqueStr.split("\\|");
                if (linkParts.length <= 1) {
                    return;
                }
                String destinationTypeStr = linkParts[1];
                try {
                    Model.this.bar.setVisible(true);
                    Model.this.getLabel().setText("Navigating: " + destinationTypeStr.replaceAll("/", "."));
                    TypeReference type = metadataSystem.lookupType(destinationTypeStr);
                    if (type == null) {
                        throw new RuntimeException("Cannot lookup type: " + destinationTypeStr);
                    }
                    TypeDefinition typeDef = type.resolve();
                    if (typeDef == null) {
                        throw new RuntimeException("Cannot resolve type: " + destinationTypeStr);
                    }
                    String tabTitle = typeDef.getName() + ".class";
                    Model.this.extractClassToTextPane(typeDef, tabTitle, destinationTypeStr, uniqueStr);
                    Model.this.getLabel().setText("Complete");
                }
                catch (Exception e) {
                    Model.this.getLabel().setText("Cannot navigate: " + destinationTypeStr.replaceAll("/", "."));
                    Luyten.showExceptionDialog("Cannot Navigate!", e);
                }
                finally {
                    Model.this.bar.setVisible(false);
                }
            }
        }).start();
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabel(JLabel label) {
        this.label = label;
    }

    public State getState() {
        return this.state;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    private class CloseTab
    extends MouseAdapter {
        String title;

        public CloseTab(String title) {
            this.title = title;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int index = Model.this.house.indexOfTab(this.title);
            Model.this.closeOpenTab(index);
        }
    }

    private class Tab
    extends JPanel {
        private static final long serialVersionUID = -514663009333644974L;
        private JLabel closeButton;
        private JLabel tabTitle;
        private String title;

        public Tab(String t) {
            super(new GridBagLayout());
            this.closeButton = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/icon_close.png"))));
            this.tabTitle = new JLabel();
            this.title = "";
            this.setOpaque(false);
            this.title = t;
            this.tabTitle = new JLabel(this.title);
            this.createTab();
        }

        public JLabel getButton() {
            return this.closeButton;
        }

        public void createTab() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            this.add((Component)this.tabTitle, gbc);
            ++gbc.gridx;
            gbc.insets = new Insets(0, 5, 0, 0);
            gbc.anchor = 13;
            this.add((Component)this.closeButton, gbc);
        }
    }

    final class State
    implements AutoCloseable {
        private final String key;
        private final File file;
        final JarFile jarFile;
        final ITypeLoader typeLoader;

        private State(String key, File file, JarFile jarFile, ITypeLoader typeLoader) {
            this.key = VerifyArgument.notNull(key, "key");
            this.file = VerifyArgument.notNull(file, "file");
            this.jarFile = jarFile;
            this.typeLoader = typeLoader;
        }

        @Override
        public void close() {
            if (this.typeLoader != null) {
                typeLoader.getTypeLoaders().remove(this.typeLoader);
            }
            Closer.tryClose((AutoCloseable)this.jarFile);
        }

        public File getFile() {
            return this.file;
        }

        public String getKey() {
            return this.key;
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int selectedIndex = Model.this.house.getSelectedIndex();
            if (selectedIndex < 0) {
                return;
            }
            for (OpenFile open : Model.this.hmap) {
                if (Model.this.house.indexOfTab(open.name) != selectedIndex || open.getType() == null || open.isContentValid()) continue;
                Model.this.updateOpenClass(open);
                break;
            }
        }
    }

    private class FurtherExpandingTreeExpansionListener
    implements TreeExpansionListener {
        private FurtherExpandingTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            TreePath treePath = event.getPath();
            Object expandedTreePathObject = treePath.getLastPathComponent();
            if (!(expandedTreePathObject instanceof TreeNode)) {
                return;
            }
            TreeNode expandedTreeNode = (TreeNode)expandedTreePathObject;
            if (expandedTreeNode.getChildCount() == 1) {
                TreeNode descendantTreeNode = expandedTreeNode.getChildAt(0);
                if (descendantTreeNode.isLeaf()) {
                    return;
                }
                TreePath nextTreePath = treePath.pathByAddingChild(descendantTreeNode);
                Model.this.tree.expandPath(nextTreePath);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }

    private class TreeListener
    extends MouseAdapter {
        private TreeListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            boolean isLeaf;
            boolean isClickCountMatches;
            boolean bl = isClickCountMatches = event.getClickCount() == 1 && Model.this.luytenPrefs.isSingleClickOpenEnabled() || event.getClickCount() == 2 && !Model.this.luytenPrefs.isSingleClickOpenEnabled();
            if (!isClickCountMatches) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(event)) {
                return;
            }
            final TreePath trp = Model.this.tree.getPathForLocation(event.getX(), event.getY());
            if (trp == null) {
                return;
            }
            Object lastPathComponent = trp.getLastPathComponent();
            boolean bl2 = isLeaf = lastPathComponent instanceof TreeNode && ((TreeNode)lastPathComponent).isLeaf();
            if (!isLeaf) {
                return;
            }
            new Thread(){

                @Override
                public void run() {
                    Model.this.openEntryByTreePath(trp);
                }
            }.start();
        }
    }
}

