/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarEntryFilter {
    private JarFile jfile;

    public JarEntryFilter() {
    }

    public JarEntryFilter(JarFile jfile) {
        this.jfile = jfile;
    }

    public List<String> getAllEntriesFromJar() {
        ArrayList<String> mass = new ArrayList<String>();
        Enumeration<JarEntry> entries = this.jfile.entries();
        while (entries.hasMoreElements()) {
            JarEntry e = entries.nextElement();
            if (e.isDirectory()) continue;
            mass.add(e.getName());
        }
        return mass;
    }

    public List<String> getEntriesWithoutInnerClasses() {
        ArrayList<String> mass = new ArrayList<String>();
        Enumeration<JarEntry> entries = this.jfile.entries();
        HashSet<String> possibleInnerClasses = new HashSet<String>();
        HashSet<String> baseClasses = new HashSet<String>();
        while (entries.hasMoreElements()) {
            String entryName;
            JarEntry e = entries.nextElement();
            if (e.isDirectory() || (entryName = e.getName()) == null || entryName.trim().length() <= 0) continue;
            if (!(entryName = entryName.trim()).endsWith(".class")) {
                mass.add(entryName);
                continue;
            }
            if (entryName.matches(".*[^(/|\\\\)]+\\$[^(/|\\\\)]+$")) {
                possibleInnerClasses.add(entryName);
                continue;
            }
            baseClasses.add(entryName);
            mass.add(entryName);
        }
        for (String inner : possibleInnerClasses) {
            String innerWithoutTail = inner.replaceAll("\\$[^(/|\\\\)]+\\.class$", "");
            if (baseClasses.contains(innerWithoutTail + ".class")) continue;
            mass.add(inner);
        }
        return mass;
    }

    public JarFile getJfile() {
        return this.jfile;
    }

    public void setJfile(JarFile jfile) {
        this.jfile = jfile;
    }
}

