/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MemberResolutionException;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.TargetInvocationException;
import com.strobel.reflection.Type;

final class Error {
    private Error() {
    }

    public static RuntimeException notGenericParameter(Type type) {
        return new UnsupportedOperationException(String.format("Type '%s' is not a generic parameter.", type.getFullName()));
    }

    public static RuntimeException notWildcard(Type type) {
        throw new UnsupportedOperationException(String.format("Type '%s' is not a wildcard or captured type.", type.getFullName()));
    }

    public static RuntimeException notBoundedType(Type type) {
        throw new UnsupportedOperationException(String.format("Type '%s' is not a bounded type.", type.getFullName()));
    }

    public static RuntimeException notGenericType(Type type) {
        return new UnsupportedOperationException(String.format("Type '%s' is not a generic type.", type.getFullName()));
    }

    public static RuntimeException notGenericMethod(MethodInfo method) {
        return new UnsupportedOperationException(String.format("Type '%s' is not a generic method.", method.getName()));
    }

    public static RuntimeException notGenericMethodDefinition(MethodInfo method) {
        return new UnsupportedOperationException(String.format("Type '%s' is not a generic method definition.", method.getName()));
    }

    public static RuntimeException noElementType(Type type) {
        return new UnsupportedOperationException(String.format("Type '%s' does not have an element type.", type.getFullName()));
    }

    public static RuntimeException notEnumType(Type type) {
        return new UnsupportedOperationException(String.format("Type '%s' is not an enum type.", type.getFullName()));
    }

    public static RuntimeException notArrayType(Type type) {
        return new UnsupportedOperationException(String.format("Type '%s' is not an array type.", type.getFullName()));
    }

    public static RuntimeException ambiguousMatch() {
        return new RuntimeException("Ambiguous match found.");
    }

    public static RuntimeException incorrectNumberOfTypeArguments() {
        return new UnsupportedOperationException("Incorrect number of type arguments provided.");
    }

    public static RuntimeException incorrectNumberOfTypeArguments(Type type) {
        return new UnsupportedOperationException(String.format("Incorrect number of type arguments provided for generic type '%s'.", type.getFullName()));
    }

    public static RuntimeException notGenericTypeDefinition(Type type) {
        return new UnsupportedOperationException(String.format("Type '%s' is not a generic type definition.", type.getFullName()));
    }

    public static RuntimeException notPrimitiveType(Class<?> type) {
        return new UnsupportedOperationException(String.format("Type '%s' is not a primitive type.", type.getName()));
    }

    public static RuntimeException typeParameterNotDefined(Type typeParameter) {
        return new UnsupportedOperationException(String.format("Generic parameter '%s' is not defined on this type.", typeParameter.getFullName()));
    }

    public static RuntimeException couldNotResolveMethod(Object signature) {
        return new RuntimeException(String.format("Could not resolve method '%s'.", signature));
    }

    public static RuntimeException couldNotResolveMember(MemberInfo member) {
        return new MemberResolutionException(member);
    }

    public static RuntimeException couldNotResolveType(Object signature) {
        return new RuntimeException(String.format("Could not resolve type '%s'.", signature));
    }

    public static RuntimeException couldNotResolveParameterType(Object signature) {
        return new RuntimeException(String.format("Could not resolve type for parameter '%s'.", signature));
    }

    public static RuntimeException typeArgumentsMustContainBoundType() {
        return new RuntimeException("Type arguments must bind at least one generic parameter.");
    }

    public static RuntimeException compoundTypeMayOnlyHaveOneClassBound() {
        return new RuntimeException("Compound types may only be bounded by one class, and it must be the first type in the bound list.  All other bounds must be interface types.");
    }

    public static RuntimeException compoundTypeMayNotHaveGenericParameterBound() {
        return new RuntimeException("Compound types may not be bounded by a generic parameter.");
    }

    public static RuntimeException typeCannotBeInstantiated(Type<?> t) {
        return new IllegalStateException(String.format("Type '%s' cannot be instantiated.", t));
    }

    public static RuntimeException typeInstantiationFailed(Type<?> t, Throwable cause) {
        return new IllegalStateException(String.format("Failed to instantiate type '%s'.", t), cause);
    }

    public static RuntimeException rawFieldBindingFailure(FieldInfo field) {
        return new IllegalStateException(String.format("Could not bind to runtime field '%s' on type '%s'.", field.getDescription(), field.getDeclaringType().toString()));
    }

    public static RuntimeException rawMethodBindingFailure(MethodBase method) {
        return new IllegalStateException(String.format("Could not bind to runtime method '%s' on type '%s'.", method.getDescription(), method.getDeclaringType().toString()));
    }

    public static RuntimeException targetInvocationException(Throwable cause) {
        return new TargetInvocationException(cause);
    }

    public static MemberResolutionException couldNotResolveMatchingConstructor() {
        return new MemberResolutionException("Could not find a constructor matching the provided arguments.");
    }

    public static RuntimeException invalidAncestorType(Type<?> ancestorType, Type<?> declaringType) {
        return new RuntimeException(String.format("Type '%s' is not an ancestor of type '%s'.", ancestorType.getFullName(), declaringType.getFullName()));
    }

    public static RuntimeException invalidSignatureTypeExpected(String signature, int position) {
        return new IllegalArgumentException(String.format("Invalid signature: type expected at position %d (%s).", position, signature));
    }

    public static RuntimeException invalidSignatureTopLevelGenericParameterUnexpected(String signature, int position) {
        return new IllegalArgumentException(String.format("Invalid signature: unexpected generic parameter at position %d.  (%s)", position, signature));
    }

    public static RuntimeException invalidSignatureNonGenericTypeTypeArguments(Type<?> type) {
        return new IllegalArgumentException(String.format("Invalid signature: unexpected type arguments specified for non-generic type '%s'.", type.getBriefDescription()));
    }

    public static RuntimeException invalidSignatureUnexpectedToken(String signature, int position) {
        return new IllegalArgumentException(String.format("Invalid signature: unexpected token at position %d.  (%s)", position, signature));
    }

    public static RuntimeException invalidSignatureUnexpectedEnd(String signature, int position) {
        return new IllegalArgumentException(String.format("Invalid signature: unexpected end of signature at position %d.  (%s)", position, signature));
    }

    public static RuntimeException invalidSignatureExpectedEndOfTypeArguments(String signature, int position) {
        return new IllegalArgumentException(String.format("Invalid signature: expected end of type argument list at position %d.  (%s)", position, signature));
    }

    public static RuntimeException invalidSignatureExpectedTypeArgument(String signature, int position) {
        return new IllegalArgumentException(String.format("Invalid signature: expected type argument at position %d.  (%s)", position, signature));
    }
}

