/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.collections.ImmutableList;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.ReadOnlyList;
import com.strobel.core.VerifyArgument;
import com.strobel.expressions.AssignBinaryExpression;
import com.strobel.expressions.BinaryExpression;
import com.strobel.expressions.Block2;
import com.strobel.expressions.Block3;
import com.strobel.expressions.Block4;
import com.strobel.expressions.Block5;
import com.strobel.expressions.BlockExpression;
import com.strobel.expressions.BlockN;
import com.strobel.expressions.CatchBlock;
import com.strobel.expressions.CoalesceConversionBinaryExpression;
import com.strobel.expressions.CompareMethodBasedLogicalBinaryExpression;
import com.strobel.expressions.ConcatExpression;
import com.strobel.expressions.ConditionalExpression;
import com.strobel.expressions.ConstantExpression;
import com.strobel.expressions.DebugViewWriter;
import com.strobel.expressions.DefaultValueExpression;
import com.strobel.expressions.EqualsMethodBasedLogicalBinaryExpression;
import com.strobel.expressions.Error;
import com.strobel.expressions.ExpressionList;
import com.strobel.expressions.ExpressionStringBuilder;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.FieldExpression;
import com.strobel.expressions.ForEachExpression;
import com.strobel.expressions.ForExpression;
import com.strobel.expressions.GotoExpression;
import com.strobel.expressions.GotoExpressionKind;
import com.strobel.expressions.InstanceMethodCallExpressionN;
import com.strobel.expressions.InvocationExpression;
import com.strobel.expressions.LabelExpression;
import com.strobel.expressions.LabelTarget;
import com.strobel.expressions.LambdaExpression;
import com.strobel.expressions.LogicalBinaryExpression;
import com.strobel.expressions.LoopExpression;
import com.strobel.expressions.MemberExpression;
import com.strobel.expressions.MethodBinaryExpression;
import com.strobel.expressions.MethodCallExpression;
import com.strobel.expressions.MethodCallExpressionN;
import com.strobel.expressions.NewArrayExpression;
import com.strobel.expressions.NewArrayInitExpression;
import com.strobel.expressions.NewExpression;
import com.strobel.expressions.OpAssignMethodConversionBinaryExpression;
import com.strobel.expressions.ParameterExpression;
import com.strobel.expressions.ParameterExpressionList;
import com.strobel.expressions.RuntimeVariablesExpression;
import com.strobel.expressions.Scope1;
import com.strobel.expressions.ScopeN;
import com.strobel.expressions.ScopeWithType;
import com.strobel.expressions.SelfExpression;
import com.strobel.expressions.SimpleBinaryExpression;
import com.strobel.expressions.SuperExpression;
import com.strobel.expressions.SwitchCase;
import com.strobel.expressions.SwitchExpression;
import com.strobel.expressions.TryExpression;
import com.strobel.expressions.TypeBinaryExpression;
import com.strobel.expressions.UnaryExpression;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.CallingConvention;
import com.strobel.reflection.ConstructorInfo;
import com.strobel.reflection.DynamicMethod;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MemberList;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.MethodList;
import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.Types;
import com.strobel.reflection.emit.ConstructorBuilder;
import com.strobel.reflection.emit.MethodBuilder;
import com.strobel.reflection.emit.SwitchOptions;
import com.strobel.util.ContractUtils;
import com.strobel.util.TypeUtils;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Expression {
    private static final Class UNMODIFIABLE_LIST_CLASS;
    private static final Set<BindingFlags> StaticMemberBindingFlags;
    private static final Set<BindingFlags> InstanceMemberBindingFlags;

    protected Expression() {
    }

    public ExpressionType getNodeType() {
        throw Error.extensionMustOverride("Expression.getNodeType()");
    }

    public Type<?> getType() {
        throw Error.extensionMustOverride("Expression.getType()");
    }

    public boolean canReduce() {
        return false;
    }

    public Expression reduce() {
        if (this.canReduce()) {
            throw Error.reducibleMustOverride("Expression.reduce()");
        }
        return this;
    }

    public final Expression reduceAndCheck() {
        if (!this.canReduce()) {
            throw Error.mustBeReducible();
        }
        Expression newNode = this.reduce();
        if (newNode == null || newNode == this) {
            throw Error.mustReduceToDifferent();
        }
        if (!this.getType().isAssignableFrom(newNode.getType())) {
            throw Error.reducedNotCompatible();
        }
        return newNode;
    }

    public final Expression reduceExtensions() {
        Expression node = this;
        while (node.getNodeType() == ExpressionType.Extension) {
            node = node.reduceAndCheck();
        }
        return node;
    }

    protected Expression accept(ExpressionVisitor visitor) {
        return visitor.visitExtension(this);
    }

    protected Expression visitChildren(ExpressionVisitor visitor) {
        if (!this.canReduce()) {
            throw Error.mustBeReducible();
        }
        return visitor.visit(this.reduceAndCheck());
    }

    public final String getDebugView() {
        StringBuilder sb = new StringBuilder();
        DebugViewWriter.writeTo(this, sb);
        return sb.toString();
    }

    public String toString() {
        return ExpressionStringBuilder.expressionToString(this);
    }

    public static Expression empty() {
        return new DefaultValueExpression(PrimitiveTypes.Void);
    }

    public static Expression self(Type<?> type) {
        return new SelfExpression(type);
    }

    public static Expression base(Type<?> type) {
        return new SuperExpression(type);
    }

    public static LabelTarget label() {
        return Expression.label(PrimitiveTypes.Void, null);
    }

    public static LabelTarget label(String name) {
        return Expression.label(PrimitiveTypes.Void, name);
    }

    public static LabelTarget label(Type type) {
        return Expression.label(type, null);
    }

    public static LabelTarget label(Type type, String name) {
        VerifyArgument.notNull(type, "type");
        return new LabelTarget(type, name);
    }

    public static LabelExpression label(LabelTarget target) {
        VerifyArgument.notNull(target, "target");
        if (target.getType() != PrimitiveTypes.Void) {
            return Expression.label(target, Expression.defaultValue(target.getType()));
        }
        return Expression.label(target, null);
    }

    public static LabelExpression label(LabelTarget target, Expression defaultValue) {
        Expression.validateGoto(target, defaultValue, "label", "defaultValue");
        return new LabelExpression(target, defaultValue);
    }

    public static GotoExpression makeBreak(LabelTarget target) {
        return Expression.makeGoto(GotoExpressionKind.Break, target, null, PrimitiveTypes.Void);
    }

    public static GotoExpression makeBreak(LabelTarget target, Expression value) {
        return Expression.makeGoto(GotoExpressionKind.Break, target, value, PrimitiveTypes.Void);
    }

    public static GotoExpression makeBreak(LabelTarget target, Type type) {
        return Expression.makeGoto(GotoExpressionKind.Break, target, null, type);
    }

    public static GotoExpression makeBreak(LabelTarget target, Expression value, Type type) {
        return Expression.makeGoto(GotoExpressionKind.Break, target, value, type);
    }

    public static GotoExpression makeContinue(LabelTarget target) {
        return Expression.makeGoto(GotoExpressionKind.Continue, target, null, PrimitiveTypes.Void);
    }

    public static GotoExpression makeContinue(LabelTarget target, Type type) {
        return Expression.makeGoto(GotoExpressionKind.Continue, target, null, type);
    }

    public static GotoExpression makeReturn(LabelTarget target) {
        return Expression.makeGoto(GotoExpressionKind.Return, target, null, PrimitiveTypes.Void);
    }

    public static GotoExpression makeReturn(LabelTarget target, Type type) {
        return Expression.makeGoto(GotoExpressionKind.Return, target, null, type);
    }

    public static GotoExpression makeReturn(LabelTarget target, Expression value) {
        return Expression.makeGoto(GotoExpressionKind.Return, target, value, PrimitiveTypes.Void);
    }

    public static GotoExpression makeReturn(LabelTarget target, Expression value, Type type) {
        return Expression.makeGoto(GotoExpressionKind.Return, target, value, type);
    }

    public static GotoExpression makeGoto(LabelTarget target) {
        return Expression.makeGoto(GotoExpressionKind.Goto, target, null, PrimitiveTypes.Void);
    }

    public static GotoExpression makeGoto(LabelTarget target, Type type) {
        return Expression.makeGoto(GotoExpressionKind.Goto, target, null, type);
    }

    public static GotoExpression makeGoto(LabelTarget target, Expression value) {
        return Expression.makeGoto(GotoExpressionKind.Goto, target, value, PrimitiveTypes.Void);
    }

    public static GotoExpression makeGoto(LabelTarget target, Expression value, Type type) {
        return Expression.makeGoto(GotoExpressionKind.Goto, target, value, type);
    }

    public static GotoExpression makeGoto(GotoExpressionKind kind, LabelTarget target, Expression value, Type type) {
        Expression.validateGoto(target, value, "target", "value");
        return new GotoExpression(kind, target, value, type);
    }

    public static LoopExpression loop(Expression body) {
        return Expression.loop(body, null, null);
    }

    public static LoopExpression loop(Expression body, LabelTarget breakTarget) {
        return Expression.loop(body, breakTarget, null);
    }

    public static LoopExpression loop(Expression body, LabelTarget breakTarget, LabelTarget continueLabel) {
        Expression.verifyCanRead(body, "body");
        if (continueLabel != null && continueLabel.getType() != PrimitiveTypes.Void) {
            throw Error.continueTargetMustBeVoid();
        }
        return new LoopExpression(body, breakTarget, continueLabel);
    }

    public static ForEachExpression forEach(ParameterExpression variable, Expression sequence, Expression body) {
        return Expression.forEach(variable, sequence, body, null, null);
    }

    public static ForEachExpression forEach(ParameterExpression variable, Expression sequence, Expression body, LabelTarget breakTarget) {
        return Expression.forEach(variable, sequence, body, breakTarget, null);
    }

    public static ForEachExpression forEach(ParameterExpression variable, Expression sequence, Expression body, LabelTarget breakTarget, LabelTarget continueTarget) {
        VerifyArgument.notNull(variable, "variable");
        Expression.verifyCanRead(sequence, "sequence");
        VerifyArgument.notNull(body, "body");
        if (continueTarget != null && continueTarget.getType() != PrimitiveTypes.Void) {
            throw Error.continueTargetMustBeVoid();
        }
        return new ForEachExpression(variable, sequence, body, breakTarget, continueTarget);
    }

    public static ForExpression makeFor(ParameterExpression variable, Expression initializer, Expression test, Expression step, Expression body) {
        return Expression.makeFor(variable, initializer, test, step, body, null, null);
    }

    public static ForExpression makeFor(ParameterExpression variable, Expression initializer, Expression test, Expression step, Expression body, LabelTarget breakTarget) {
        return Expression.makeFor(variable, initializer, test, step, body, breakTarget, null);
    }

    public static ForExpression makeFor(ParameterExpression variable, Expression initializer, Expression test, Expression step, Expression body, LabelTarget breakTarget, LabelTarget continueTarget) {
        VerifyArgument.notNull(variable, "variable");
        Expression.verifyCanRead(initializer, "initializer");
        Expression.verifyCanRead(test, "test");
        VerifyArgument.notNull(step, "step");
        Expression.verifyCanRead(body, "body");
        if (!variable.getType().isAssignableFrom(initializer.getType())) {
            throw Error.initializerMustBeAssignableToVariable();
        }
        if (!TypeUtils.hasIdentityPrimitiveOrBoxingConversion(test.getType(), PrimitiveTypes.Boolean)) {
            throw Error.testMustBeBooleanExpression();
        }
        if (continueTarget != null && continueTarget.getType() != PrimitiveTypes.Void) {
            throw Error.continueTargetMustBeVoid();
        }
        return new ForExpression(variable, initializer, test, step, body, breakTarget, continueTarget);
    }

    public static NewExpression makeNew(ConstructorInfo constructor) {
        return Expression.makeNew(constructor, ExpressionList.empty());
    }

    public static NewExpression makeNew(ConstructorInfo constructor, Expression ... parameters) {
        return Expression.makeNew(constructor, Expression.arrayToList((Expression[])parameters));
    }

    public static NewExpression makeNew(ConstructorInfo constructor, ExpressionList<? extends Expression> parameters) {
        VerifyArgument.notNull(constructor, "constructor");
        VerifyArgument.notNull(constructor.getDeclaringType(), "constructor.getDeclaringType()");
        ExpressionList<? extends Expression> arguments = Expression.validateArgumentTypes(constructor, ExpressionType.New, parameters);
        return new NewExpression(constructor, arguments);
    }

    public static NewArrayExpression newArrayInit(Type elementType, Expression ... initializers) {
        return Expression.newArrayInit(elementType, Expression.arrayToList((Expression[])initializers));
    }

    public static NewArrayExpression newArrayInit(Type elementType, ExpressionList<? extends Expression> initializers) {
        VerifyArgument.notNull(elementType, "elementType");
        VerifyArgument.noNullElements(initializers, "initializers");
        if (elementType.isEquivalentTo(PrimitiveTypes.Void)) {
            throw Error.argumentCannotBeOfTypeVoid();
        }
        int n = initializers.size();
        for (int i = 0; i < n; ++i) {
            Expression item = initializers.get(i);
            Expression.verifyCanRead(item, "initializers");
            if (TypeUtils.areReferenceAssignable(elementType, item.getType())) continue;
            throw Error.expressionTypeCannotInitializeArrayType(item.getType(), elementType);
        }
        return NewArrayInitExpression.make(ExpressionType.NewArrayInit, elementType.makeArrayType(), initializers);
    }

    public static NewArrayExpression newArrayBounds(Type elementType, Expression dimension) {
        VerifyArgument.notNull(elementType, "elementType");
        VerifyArgument.notNull(dimension, "dimension");
        Expression.verifyCanRead(dimension, "dimension");
        if (elementType.isEquivalentTo(PrimitiveTypes.Void)) {
            throw Error.argumentCannotBeOfTypeVoid();
        }
        if (!TypeUtils.isIntegral(dimension.getType())) {
            throw Error.argumentMustBeIntegral();
        }
        Expression convertedDimension = TypeUtils.getUnderlyingPrimitiveOrSelf(elementType) != PrimitiveTypes.Integer ? Expression.convert(dimension, PrimitiveTypes.Integer) : dimension;
        return NewArrayInitExpression.make(ExpressionType.NewArrayBounds, elementType.makeArrayType(), new ExpressionList(new Expression[]{convertedDimension}));
    }

    public static ConcatExpression concat(Expression first, Expression second) {
        Expression.verifyCanRead(first, "first");
        Expression.verifyCanRead(second, "second");
        return Expression.concat(new ExpressionList(new Expression[]{first, second}));
    }

    public static ConcatExpression concat(Expression first, Expression second, Expression ... operands) {
        VerifyArgument.notEmpty(operands, "operands");
        return Expression.concat(Expression.arrayToList((Expression[])ArrayUtilities.prepend(operands, first, second)));
    }

    public static ConcatExpression concat(ExpressionList<? extends Expression> operands) {
        VerifyArgument.noNullElements(operands, "operands");
        if (operands.size() < 2) {
            throw Error.concatRequiresAtLeastTwoOperands();
        }
        int n = operands.size();
        for (int i = 0; i < n; ++i) {
            Expression item = operands.get(i);
            Expression.verifyCanRead(item, "operands");
        }
        return new ConcatExpression(operands);
    }

    public static CatchBlock makeCatch(Type type, Expression body) {
        return Expression.makeCatch(type, null, body, null);
    }

    public static CatchBlock makeCatch(ParameterExpression variable, Expression body) {
        VerifyArgument.notNull(variable, "variable");
        return Expression.makeCatch(variable.getType(), variable, body, null);
    }

    public static CatchBlock makeCatch(Type type, Expression body, Expression filter) {
        return Expression.makeCatch(type, null, body, filter);
    }

    public static CatchBlock makeCatch(ParameterExpression variable, Expression body, Expression filter) {
        VerifyArgument.notNull(variable, "variable");
        return Expression.makeCatch(variable.getType(), variable, body, filter);
    }

    public static CatchBlock makeCatch(Type type, ParameterExpression variable, Expression body, Expression filter) {
        VerifyArgument.notNull(type, "type");
        if (variable != null && !TypeUtils.areEquivalent(variable.getType(), type)) {
            throw Error.catchVariableMustBeCompatibleWithCatchType(type, variable.getType());
        }
        Expression.verifyCanRead(body, "body");
        if (filter != null) {
            Expression.verifyCanRead(filter, "filter");
            if (!TypeUtils.hasIdentityPrimitiveOrBoxingConversion(filter.getType(), PrimitiveTypes.Boolean)) {
                throw Error.argumentMustBeBoolean();
            }
        }
        return new CatchBlock(type, variable, body, filter);
    }

    public static CatchBlock makeCatch(Type type, ParameterExpression variable, Expression body) {
        return Expression.makeCatch(type, variable, body, null);
    }

    public static TryExpression tryFinally(Expression body, Expression finallyBlock) {
        return Expression.makeTry(null, body, finallyBlock, new CatchBlock[0]);
    }

    public static TryExpression tryCatch(Expression body, CatchBlock ... handlers) {
        return Expression.makeTry(null, body, null, handlers);
    }

    public static TryExpression makeTry(Type type, Expression body, CatchBlock ... handlers) {
        return Expression.makeTry(type, body, null, handlers);
    }

    public static TryExpression tryCatchFinally(Expression body, Expression finallyBlock, CatchBlock ... handlers) {
        return Expression.makeTry(null, body, finallyBlock, handlers);
    }

    public static TryExpression makeTry(Type type, Expression body, Expression finallyBlock, CatchBlock ... handlers) {
        ReadOnlyList<CatchBlock> catchBlocks = handlers != null ? new ReadOnlyList<CatchBlock>(VerifyArgument.noNullElements(handlers, "handlers")) : ReadOnlyList.emptyList();
        return Expression.makeTry(type, body, catchBlocks, finallyBlock);
    }

    public static TryExpression makeTry(Type type, Expression body, ReadOnlyList<CatchBlock> catchBlocks, Expression finallyBlock) {
        Expression.verifyCanRead(body, "body");
        VerifyArgument.noNullElements(catchBlocks, "catchBlocks");
        Expression.validateTryAndCatchHaveSameType(type, body, catchBlocks);
        if (finallyBlock != null) {
            Expression.verifyCanRead(finallyBlock, "finallyBlock");
        } else if (catchBlocks.isEmpty()) {
            throw Error.tryMustHaveCatchOrFinally();
        }
        return new TryExpression(type != null ? type : body.getType(), body, catchBlocks, finallyBlock);
    }

    public static RuntimeVariablesExpression runtimeVariables(ParameterExpression ... variables) {
        return Expression.runtimeVariables(Expression.arrayToList(variables));
    }

    public static RuntimeVariablesExpression runtimeVariables(ParameterExpressionList variables) {
        VerifyArgument.noNullElements(variables, "variables");
        return new RuntimeVariablesExpression(variables);
    }

    public static ConditionalExpression condition(Expression test, Expression ifTrue, Expression ifFalse) {
        if (!TypeUtils.hasIdentityPrimitiveOrBoxingConversion(test.getType(), PrimitiveTypes.Boolean)) {
            throw Error.argumentMustBeBoolean();
        }
        if (!TypeUtils.hasIdentityPrimitiveOrBoxingConversion(ifTrue.getType(), ifFalse.getType())) {
            throw Error.argumentTypesMustMatch();
        }
        return Expression.condition(test, ifTrue, ifFalse, ifTrue.getType());
    }

    public static ConditionalExpression condition(Expression test, Expression ifTrue, Expression ifFalse, Type type) {
        Expression.verifyCanRead(test, "test");
        Expression.verifyCanRead(ifTrue, "ifTrue");
        Expression.verifyCanRead(ifFalse, "ifFalse");
        VerifyArgument.notNull(type, "type");
        if (!TypeUtils.hasIdentityPrimitiveOrBoxingConversion(test.getType(), PrimitiveTypes.Boolean)) {
            throw Error.argumentMustBeBoolean();
        }
        if (!(type == PrimitiveTypes.Void || TypeUtils.areReferenceAssignable(type, ifTrue.getType()) && TypeUtils.areReferenceAssignable(type, ifFalse.getType()))) {
            throw Error.argumentTypesMustMatch();
        }
        return ConditionalExpression.make(test, ifTrue, ifFalse, type);
    }

    public static ConditionalExpression ifThen(Expression test, Expression ifTrue) {
        return Expression.condition(test, ifTrue, Expression.empty(), PrimitiveTypes.Void);
    }

    public static ConditionalExpression ifThenElse(Expression test, Expression ifTrue, Expression ifFalse) {
        return Expression.condition(test, ifTrue, ifFalse, PrimitiveTypes.Void);
    }

    public static MemberExpression makeMemberAccess(Expression target, MemberInfo member) {
        VerifyArgument.notNull(member, "member");
        if (member instanceof FieldInfo) {
            return Expression.field(target, (FieldInfo)member);
        }
        throw Error.memberNotField(member);
    }

    public static MemberExpression field(Expression target, FieldInfo field) {
        VerifyArgument.notNull(field, "field");
        if (field.isStatic() ^ target == null) {
            throw field.isStatic() ? Error.targetRequiredForNonStaticFieldAccess(field) : Error.targetInvalidForStaticFieldAccess(field);
        }
        return new FieldExpression(target, field);
    }

    public static MemberExpression field(FieldInfo field) {
        return Expression.field(null, field);
    }

    public static MemberExpression field(Type<?> declaringType, String fieldName) {
        VerifyArgument.notNull(declaringType, "declaringType");
        VerifyArgument.notNull(fieldName, "fieldName");
        FieldInfo field = Expression.findField(declaringType, fieldName, StaticMemberBindingFlags);
        return new FieldExpression(null, field);
    }

    public static MemberExpression field(Expression target, String fieldName) {
        Expression.verifyCanRead(target, "target");
        VerifyArgument.notNull(fieldName, "fieldName");
        FieldInfo field = Expression.findField(target.getType(), fieldName, InstanceMemberBindingFlags);
        return new FieldExpression(target, field);
    }

    public static ConstantExpression constant(Object value) {
        Type<Object> type = value == null ? Types.Object : TypeUtils.getUnderlyingPrimitiveOrSelf(Type.of(value.getClass()));
        return ConstantExpression.make(value, type);
    }

    public static ConstantExpression constant(Object value, Type type) {
        VerifyArgument.notNull(type, "type");
        if (value == null && type.isPrimitive()) {
            throw Error.argumentTypesMustMatch();
        }
        if (value != null && !TypeUtils.getBoxedTypeOrSelf(type).getErasedClass().isInstance(value)) {
            throw Error.argumentTypesMustMatch();
        }
        return ConstantExpression.make(value, type);
    }

    public static ConstantExpression classConstant(Type<?> value) {
        VerifyArgument.notNull(value, "value");
        return ConstantExpression.make(value, Types.Class.makeGenericType(value));
    }

    public static ParameterExpressionList parameters(ParameterExpression ... parameters) {
        return new ParameterExpressionList(parameters);
    }

    public static ParameterExpressionList variables(ParameterExpression ... parameters) {
        return new ParameterExpressionList(parameters);
    }

    public static ParameterExpression parameter(Type type) {
        return Expression.parameter(type, null);
    }

    public static ParameterExpression variable(Type type) {
        return Expression.variable(type, null);
    }

    public static ParameterExpression parameter(Type type, String name) {
        VerifyArgument.notNull(type, "type");
        if (type == PrimitiveTypes.Void) {
            throw Error.argumentCannotBeOfTypeVoid();
        }
        return ParameterExpression.make(type, name);
    }

    public static ParameterExpression variable(Type type, String name) {
        VerifyArgument.notNull(type, "type");
        if (type == PrimitiveTypes.Void) {
            throw Error.argumentCannotBeOfTypeVoid();
        }
        return ParameterExpression.make(type, name);
    }

    public static UnaryExpression makeUnary(ExpressionType unaryType, Expression operand, Type type) {
        return Expression.makeUnary(unaryType, operand, type, null);
    }

    public static UnaryExpression makeUnary(ExpressionType unaryType, Expression operand, Type type, MethodInfo method) {
        switch (unaryType) {
            case Negate: {
                return Expression.negate(operand, method);
            }
            case Not: {
                return Expression.not(operand, method);
            }
            case IsFalse: {
                return Expression.isFalse(operand, method);
            }
            case IsTrue: {
                return Expression.isTrue(operand, method);
            }
            case OnesComplement: {
                return Expression.onesComplement(operand, method);
            }
            case ArrayLength: {
                return Expression.arrayLength(operand);
            }
            case Convert: {
                return Expression.convert(operand, type, method);
            }
            case Throw: {
                return Expression.makeThrow(operand, type);
            }
            case UnaryPlus: {
                return Expression.unaryPlus(operand, method);
            }
            case Unbox: {
                return Expression.unbox(operand, type);
            }
            case Increment: {
                return Expression.increment(operand, method);
            }
            case Decrement: {
                return Expression.decrement(operand, method);
            }
            case PreIncrementAssign: {
                return Expression.preIncrementAssign(operand, method);
            }
            case PostIncrementAssign: {
                return Expression.postIncrementAssign(operand, method);
            }
            case PreDecrementAssign: {
                return Expression.preDecrementAssign(operand, method);
            }
            case PostDecrementAssign: {
                return Expression.postDecrementAssign(operand, method);
            }
            case IsNull: {
                return Expression.isNull(operand);
            }
            case IsNotNull: {
                return Expression.isNotNull(operand);
            }
        }
        throw Error.unhandledUnary(unaryType);
    }

    public static UnaryExpression negate(Expression expression) {
        return Expression.negate(expression, null);
    }

    public static UnaryExpression negate(Expression expression, MethodInfo method) {
        Expression.verifyCanRead(expression, "expression");
        if (method == null) {
            if (TypeUtils.isArithmetic(expression.getType())) {
                return new UnaryExpression(ExpressionType.Negate, expression, expression.getType(), null);
            }
            return Expression.getMethodBasedUnaryOperatorOrThrow(ExpressionType.Negate, "negate", expression);
        }
        return Expression.getMethodBasedUnaryOperator(ExpressionType.Negate, expression, method);
    }

    public static UnaryExpression not(Expression expression) {
        return Expression.not(expression, null);
    }

    public static UnaryExpression not(Expression expression, MethodInfo method) {
        Expression.verifyCanRead(expression, "expression");
        if (method == null) {
            if (TypeUtils.isIntegralOrBoolean(expression.getType())) {
                return new UnaryExpression(ExpressionType.Not, expression, expression.getType(), null);
            }
            throw Error.unaryOperatorNotDefined(ExpressionType.Not, expression.getType());
        }
        return Expression.getMethodBasedUnaryOperator(ExpressionType.Not, expression, method);
    }

    public static UnaryExpression isFalse(Expression expression) {
        return Expression.isFalse(expression, null);
    }

    public static UnaryExpression isFalse(Expression expression, MethodInfo method) {
        Expression.verifyCanRead(expression, "expression");
        if (method == null) {
            if (TypeUtils.isBoolean(expression.getType())) {
                return new UnaryExpression(ExpressionType.IsFalse, expression, expression.getType(), null);
            }
            throw Error.unaryOperatorNotDefined(ExpressionType.IsFalse, expression.getType());
        }
        return Expression.getMethodBasedUnaryOperator(ExpressionType.IsFalse, expression, method);
    }

    public static UnaryExpression isTrue(Expression expression) {
        return Expression.isTrue(expression, null);
    }

    public static UnaryExpression isTrue(Expression expression, MethodInfo method) {
        Expression.verifyCanRead(expression, "expression");
        if (method == null) {
            if (TypeUtils.isBoolean(expression.getType())) {
                return new UnaryExpression(ExpressionType.IsTrue, expression, expression.getType(), null);
            }
            throw Error.unaryOperatorNotDefined(ExpressionType.IsTrue, expression.getType());
        }
        return Expression.getMethodBasedUnaryOperator(ExpressionType.IsTrue, expression, method);
    }

    public static UnaryExpression onesComplement(Expression expression) {
        return Expression.not(expression, null);
    }

    public static UnaryExpression onesComplement(Expression expression, MethodInfo method) {
        Expression.verifyCanRead(expression, "expression");
        if (method == null) {
            if (TypeUtils.isIntegral(expression.getType())) {
                return new UnaryExpression(ExpressionType.OnesComplement, expression, expression.getType(), null);
            }
            return Expression.getMethodBasedUnaryOperatorOrThrow(ExpressionType.OnesComplement, "not", expression);
        }
        return Expression.getMethodBasedUnaryOperator(ExpressionType.OnesComplement, expression, method);
    }

    public static UnaryExpression arrayLength(Expression array) {
        VerifyArgument.notNull(array, "array");
        if (!array.getType().isArray()) {
            throw Error.argumentMustBeArray();
        }
        return new UnaryExpression(ExpressionType.ArrayLength, array, PrimitiveTypes.Integer, null);
    }

    public static UnaryExpression convert(Expression expression, Type type) {
        return Expression.convert(expression, type, null);
    }

    public static UnaryExpression convert(Expression expression, Type type, MethodInfo method) {
        Expression.verifyCanRead(expression, "expression");
        if (method == null) {
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(expression.getType(), type) || TypeUtils.hasReferenceConversion(expression.getType(), type) || TypeUtils.isArithmetic(expression.getType()) && TypeUtils.isArithmetic(type)) {
                return new UnaryExpression(ExpressionType.Convert, expression, type, null);
            }
            return Expression.getMethodBasedCoercionOrThrow(ExpressionType.Convert, expression, type);
        }
        return Expression.getMethodBasedCoercionOperator(ExpressionType.Convert, expression, type, method);
    }

    public static UnaryExpression isNull(Expression expression) {
        Expression.verifyCanRead(expression, "expression");
        if (expression.getType().isPrimitive()) {
            throw Error.argumentMustBeReferenceType();
        }
        return new UnaryExpression(ExpressionType.IsNull, expression, PrimitiveTypes.Boolean, null);
    }

    public static UnaryExpression isNotNull(Expression expression) {
        Expression.verifyCanRead(expression, "expression");
        if (expression.getType().isPrimitive()) {
            throw Error.argumentMustBeReferenceType();
        }
        return new UnaryExpression(ExpressionType.IsNotNull, expression, PrimitiveTypes.Boolean, null);
    }

    public static UnaryExpression makeThrow(Expression expression) {
        return Expression.makeThrow(expression, PrimitiveTypes.Void);
    }

    public static UnaryExpression makeThrow(Expression value, Type type) {
        VerifyArgument.notNull(type, "type");
        if (value != null) {
            Expression.verifyCanRead(value, "value");
            if (!Types.Throwable.isAssignableFrom(value.getType())) {
                throw Error.argumentMustBeThrowable();
            }
        }
        return new UnaryExpression(ExpressionType.Throw, value, type, null);
    }

    public static UnaryExpression unaryPlus(Expression expression) {
        return Expression.unaryPlus(expression, null);
    }

    public static UnaryExpression unaryPlus(Expression expression, MethodInfo method) {
        Expression.verifyCanRead(expression, "expression");
        if (method == null) {
            if (TypeUtils.isArithmetic(expression.getType())) {
                return new UnaryExpression(ExpressionType.UnaryPlus, expression, expression.getType(), null);
            }
            throw Error.unaryOperatorNotDefined(ExpressionType.UnaryPlus, expression.getType());
        }
        return Expression.getMethodBasedUnaryOperator(ExpressionType.UnaryPlus, expression, method);
    }

    public static Expression box(Expression expression) {
        Expression.verifyCanRead(expression, "expression");
        Type<?> sourceType = expression.getType();
        if (!sourceType.isPrimitive()) {
            return expression;
        }
        return Expression.call(TypeUtils.getBoxMethod(sourceType), expression);
    }

    public static UnaryExpression unbox(Expression expression) {
        return Expression.unbox(VerifyArgument.notNull(expression, "expression"), TypeUtils.getUnderlyingPrimitiveOrSelf(expression.getType()));
    }

    public static UnaryExpression unbox(Expression expression, Type type) {
        Type<Object> boxedType;
        Expression.verifyCanRead(expression, "expression");
        VerifyArgument.notNull(type, "type");
        Type<?> sourceType = expression.getType();
        Expression operand = expression;
        if (sourceType == Types.Object && (boxedType = TypeUtils.isNumeric(type) && type != PrimitiveTypes.Character ? Types.Number : TypeUtils.getBoxedType(type)) != null) {
            operand = Expression.convert(operand, boxedType);
            sourceType = operand.getType();
        }
        if (sourceType.isPrimitive() || !type.isPrimitive()) {
            throw Error.invalidUnboxType();
        }
        MethodInfo unboxMethod = TypeUtils.getUnboxMethod(sourceType, type);
        if (unboxMethod == null) {
            throw Error.unboxNotDefined(expression.getType(), type);
        }
        return new UnaryExpression(ExpressionType.Unbox, operand, type, unboxMethod);
    }

    public static UnaryExpression increment(Expression expression) {
        return Expression.increment(expression, null);
    }

    public static UnaryExpression increment(Expression expression, MethodInfo method) {
        Expression.verifyCanRead(expression, "expression");
        if (method == null) {
            if (TypeUtils.isArithmetic(expression.getType())) {
                return new UnaryExpression(ExpressionType.Increment, expression, expression.getType(), null);
            }
            return Expression.getMethodBasedUnaryOperatorOrThrow(ExpressionType.Increment, "increment", expression);
        }
        return Expression.getMethodBasedUnaryOperator(ExpressionType.Increment, expression, method);
    }

    public static UnaryExpression decrement(Expression expression) {
        return Expression.negate(expression, null);
    }

    public static UnaryExpression decrement(Expression expression, MethodInfo method) {
        Expression.verifyCanRead(expression, "expression");
        if (method == null) {
            if (TypeUtils.isArithmetic(expression.getType())) {
                return new UnaryExpression(ExpressionType.Decrement, expression, expression.getType(), null);
            }
            return Expression.getMethodBasedUnaryOperatorOrThrow(ExpressionType.Decrement, "decrement", expression);
        }
        return Expression.getMethodBasedUnaryOperator(ExpressionType.Decrement, expression, method);
    }

    public static UnaryExpression preIncrementAssign(Expression expression) {
        return Expression.makeOpAssignUnary(ExpressionType.PreIncrementAssign, expression, null);
    }

    public static UnaryExpression preIncrementAssign(Expression expression, MethodInfo method) {
        return Expression.makeOpAssignUnary(ExpressionType.PreIncrementAssign, expression, method);
    }

    public static UnaryExpression postIncrementAssign(Expression expression) {
        return Expression.makeOpAssignUnary(ExpressionType.PostIncrementAssign, expression, null);
    }

    public static UnaryExpression postIncrementAssign(Expression expression, MethodInfo method) {
        return Expression.makeOpAssignUnary(ExpressionType.PostIncrementAssign, expression, method);
    }

    public static UnaryExpression preDecrementAssign(Expression expression) {
        return Expression.makeOpAssignUnary(ExpressionType.PreDecrementAssign, expression, null);
    }

    public static UnaryExpression preDecrementAssign(Expression expression, MethodInfo method) {
        return Expression.makeOpAssignUnary(ExpressionType.PreDecrementAssign, expression, method);
    }

    public static UnaryExpression postDecrementAssign(Expression expression) {
        return Expression.makeOpAssignUnary(ExpressionType.PostDecrementAssign, expression, null);
    }

    public static UnaryExpression postDecrementAssign(Expression expression, MethodInfo method) {
        return Expression.makeOpAssignUnary(ExpressionType.PostDecrementAssign, expression, method);
    }

    public static BlockExpression block(Expression arg0, Expression arg1) {
        Expression.verifyCanRead(arg0, "arg0");
        Expression.verifyCanRead(arg1, "arg1");
        return new Block2(arg0, arg1);
    }

    public static BlockExpression block(Expression arg0, Expression arg1, Expression arg2) {
        Expression.verifyCanRead(arg0, "arg0");
        Expression.verifyCanRead(arg1, "arg1");
        Expression.verifyCanRead(arg2, "arg2");
        return new Block3(arg0, arg1, arg2);
    }

    public static BlockExpression block(Expression arg0, Expression arg1, Expression arg2, Expression arg3) {
        Expression.verifyCanRead(arg0, "arg0");
        Expression.verifyCanRead(arg1, "arg1");
        Expression.verifyCanRead(arg2, "arg2");
        Expression.verifyCanRead(arg3, "arg3");
        return new Block4(arg0, arg1, arg2, arg3);
    }

    public static BlockExpression block(Expression arg0, Expression arg1, Expression arg2, Expression arg3, Expression arg4) {
        Expression.verifyCanRead(arg0, "arg0");
        Expression.verifyCanRead(arg1, "arg1");
        Expression.verifyCanRead(arg2, "arg2");
        Expression.verifyCanRead(arg3, "arg3");
        Expression.verifyCanRead(arg4, "arg4");
        return new Block5(arg0, arg1, arg2, arg3, arg4);
    }

    public static BlockExpression block(Expression ... expressions) {
        VerifyArgument.notEmpty(expressions, "expressions");
        VerifyArgument.noNullElements(expressions, "expressions");
        switch (expressions.length) {
            case 2: {
                return Expression.block(expressions[0], expressions[1]);
            }
            case 3: {
                return Expression.block(expressions[0], expressions[1], expressions[2]);
            }
            case 4: {
                return Expression.block(expressions[0], expressions[1], expressions[2], expressions[3]);
            }
            case 5: {
                return Expression.block(expressions[0], expressions[1], expressions[2], expressions[3], expressions[4]);
            }
        }
        VerifyArgument.notEmpty(expressions, "expressions");
        Expression.verifyCanRead(expressions, "expressions");
        return new BlockN(Expression.arrayToList((Expression[])expressions));
    }

    public static BlockExpression block(ExpressionList<? extends Expression> expressions) {
        return Expression.block(ParameterExpressionList.empty(), expressions);
    }

    public static BlockExpression block(ParameterExpression[] variables, Expression ... expressions) {
        VerifyArgument.notEmpty(expressions, "expressions");
        return Expression.block(Expression.arrayToList(variables), (ExpressionList<? extends Expression>)Expression.arrayToList((Expression[])expressions));
    }

    public static BlockExpression block(ParameterExpressionList variables, Expression ... expressions) {
        VerifyArgument.notEmpty(expressions, "expressions");
        return Expression.block(variables, (ExpressionList<? extends Expression>)Expression.arrayToList((Expression[])expressions));
    }

    public static BlockExpression block(ParameterExpressionList variables, ExpressionList<? extends Expression> expressions) {
        VerifyArgument.notEmpty(expressions, "expressions");
        VerifyArgument.noNullElements(expressions, "expressions");
        Expression.verifyCanRead(expressions, "expressions");
        return Expression.block(expressions.get(expressions.size() - 1).getType(), variables, expressions);
    }

    public static BlockExpression block(Type type, Expression ... expressions) {
        VerifyArgument.notEmpty(expressions, "expressions");
        return Expression.block(type, ParameterExpressionList.empty(), Expression.arrayToList((Expression[])expressions));
    }

    public static BlockExpression block(Type type, ExpressionList<? extends Expression> expressions) {
        VerifyArgument.notEmpty(expressions, "expressions");
        VerifyArgument.noNullElements(expressions, "expressions");
        return Expression.block(type, ParameterExpressionList.empty(), expressions);
    }

    public static BlockExpression block(Type type, ParameterExpression[] variables, Expression ... expressions) {
        VerifyArgument.notEmpty(expressions, "expressions");
        return Expression.block(type, Expression.arrayToList(variables), Expression.arrayToList((Expression[])expressions));
    }

    public static BlockExpression block(Type type, ParameterExpressionList variables, Expression ... expressions) {
        VerifyArgument.notEmpty(expressions, "expressions");
        return Expression.block(type, variables, Expression.arrayToList((Expression[])expressions));
    }

    public static BlockExpression block(Type type, ParameterExpressionList variables, ExpressionList<? extends Expression> expressions) {
        VerifyArgument.notNull(type, "type");
        VerifyArgument.notEmpty(expressions, "expressions");
        VerifyArgument.noNullElements(expressions, "expressions");
        Expression.verifyCanRead(expressions, "expressions");
        Expression.validateVariables(variables, "variables");
        Expression last = expressions.get(expressions.size() - 1);
        if (type != PrimitiveTypes.Void && !type.isAssignableFrom(last.getType())) {
            throw Error.argumentTypesMustMatch();
        }
        if (type != last.getType()) {
            return new ScopeWithType(variables, expressions, type);
        }
        if (expressions.size() == 1) {
            return new Scope1(variables, expressions.get(0));
        }
        return new ScopeN(variables, expressions);
    }

    public static BinaryExpression makeBinary(ExpressionType binaryType, Expression ... rest) {
        VerifyArgument.notNull(binaryType, "binaryType");
        VerifyArgument.notEmpty(rest, "rest");
        Expression.verifyCanRead(rest, "rest");
        if (rest.length < 2) {
            throw Error.twoOrMoreOperandsRequired();
        }
        return Expression.aggregateBinary(binaryType, ImmutableList.from(rest));
    }

    public static BinaryExpression makeBinary(ExpressionType binaryType, Expression first, Expression ... rest) {
        VerifyArgument.notNull(binaryType, "binaryType");
        Expression.verifyCanRead(first, "first");
        VerifyArgument.notEmpty(rest, "rest");
        Expression.verifyCanRead(rest, "rest");
        return Expression.aggregateBinary(binaryType, ImmutableList.of(first, rest));
    }

    public static BinaryExpression makeBinary(ExpressionType binaryType, Expression left, Expression right) {
        return Expression.makeBinary(binaryType, left, right, null, null);
    }

    public static BinaryExpression makeBinary(ExpressionType binaryType, Expression left, Expression right, MethodInfo method) {
        return Expression.makeBinary(binaryType, left, right, method, null);
    }

    public static BinaryExpression makeBinary(ExpressionType binaryType, Expression left, Expression right, MethodInfo method, LambdaExpression<?> conversion) {
        switch (binaryType) {
            case Add: {
                return Expression.add(left, right, method);
            }
            case Coalesce: {
                return Expression.coalesce(left, right, conversion);
            }
            case Subtract: {
                return Expression.subtract(left, right, method);
            }
            case Multiply: {
                return Expression.multiply(left, right, method);
            }
            case Divide: {
                return Expression.divide(left, right, method);
            }
            case Modulo: {
                return Expression.modulo(left, right, method);
            }
            case And: {
                return Expression.and(left, right, method);
            }
            case AndAlso: {
                return Expression.andAlso(left, right, method);
            }
            case Or: {
                return Expression.or(left, right, method);
            }
            case OrElse: {
                return Expression.orElse(left, right, method);
            }
            case LessThan: {
                return Expression.lessThan(left, right, method);
            }
            case LessThanOrEqual: {
                return Expression.lessThanOrEqual(left, right, method);
            }
            case GreaterThan: {
                return Expression.greaterThan(left, right, method);
            }
            case GreaterThanOrEqual: {
                return Expression.greaterThanOrEqual(left, right, method);
            }
            case Equal: {
                return Expression.equal(left, right, method);
            }
            case NotEqual: {
                return Expression.notEqual(left, right, method);
            }
            case ExclusiveOr: {
                return Expression.exclusiveOr(left, right, method);
            }
            case ArrayIndex: {
                return Expression.arrayIndex(left, right);
            }
            case RightShift: {
                return Expression.rightShift(left, right, method);
            }
            case UnsignedRightShift: {
                return Expression.unsignedRightShift(left, right, method);
            }
            case LeftShift: {
                return Expression.leftShift(left, right, method);
            }
            case Assign: {
                return Expression.assign(left, right);
            }
            case AddAssign: {
                return Expression.addAssign(left, right, method, conversion);
            }
            case AndAssign: {
                return Expression.andAssign(left, right, method, conversion);
            }
            case DivideAssign: {
                return Expression.divideAssign(left, right, method, conversion);
            }
            case ExclusiveOrAssign: {
                return Expression.exclusiveOrAssign(left, right, method, conversion);
            }
            case LeftShiftAssign: {
                return Expression.leftShiftAssign(left, right, method, conversion);
            }
            case ModuloAssign: {
                return Expression.moduloAssign(left, right, method, conversion);
            }
            case MultiplyAssign: {
                return Expression.multiplyAssign(left, right, method, conversion);
            }
            case OrAssign: {
                return Expression.orAssign(left, right, method, conversion);
            }
            case RightShiftAssign: {
                return Expression.rightShiftAssign(left, right, method, conversion);
            }
            case UnsignedRightShiftAssign: {
                return Expression.unsignedRightShiftAssign(left, right, method, conversion);
            }
            case SubtractAssign: {
                return Expression.subtractAssign(left, right, method, conversion);
            }
            case ReferenceEqual: {
                return Expression.referenceEqual(left, right);
            }
            case ReferenceNotEqual: {
                return Expression.referenceNotEqual(left, right);
            }
        }
        throw Error.unhandledBinary(binaryType);
    }

    public static BinaryExpression add(Expression left, Expression right) {
        return Expression.add(left, right, null);
    }

    public static BinaryExpression add(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            Type<?> rightType;
            Type<?> leftType = left.getType();
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType = right.getType()) && TypeUtils.isArithmetic(leftType)) {
                return new SimpleBinaryExpression(ExpressionType.Add, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedBinaryOperatorOrThrow(ExpressionType.Add, "add", left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.Add, left, right, method);
    }

    public static BinaryExpression coalesce(Expression left, Expression right) {
        return Expression.coalesce(left, right, null);
    }

    public static BinaryExpression coalesce(Expression left, Expression right, LambdaExpression<?> conversion) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (conversion == null) {
            Type resultType = Expression.validateCoalesceArgumentTypes(left.getType(), right.getType());
            return new SimpleBinaryExpression(ExpressionType.Coalesce, left, right, resultType);
        }
        if (left.getType().isPrimitive()) {
            throw Error.coalesceUsedOnNonNullableType();
        }
        Type<?> delegateType = conversion.getType();
        MethodInfo method = Expression.getInvokeMethod(conversion);
        if (method.getReturnType() == PrimitiveTypes.Void) {
            throw Error.operatorMethodMustNotReturnVoid(method);
        }
        ParameterList parameters = method.getParameters();
        assert (parameters.size() == conversion.getParameters().size());
        if (parameters.size() != 1) {
            throw Error.incorrectNumberOfMethodCallArguments(method);
        }
        if (!TypeUtils.areEquivalent(method.getReturnType(), right.getType())) {
            throw Error.operandTypesDoNotMatchParameters(ExpressionType.Coalesce, method);
        }
        if (!Expression.parameterIsAssignable(((ParameterInfo)parameters.get(0)).getParameterType(), TypeUtils.getUnderlyingPrimitiveOrSelf(left.getType())) && !Expression.parameterIsAssignable(((ParameterInfo)parameters.get(0)).getParameterType(), left.getType())) {
            throw Error.operandTypesDoNotMatchParameters(ExpressionType.Coalesce, method);
        }
        return new CoalesceConversionBinaryExpression(left, right, conversion);
    }

    public static BinaryExpression subtract(Expression left, Expression right) {
        return Expression.subtract(left, right, null);
    }

    public static BinaryExpression subtract(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            Type<?> rightType;
            Type<?> leftType = left.getType();
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType = right.getType()) && TypeUtils.isArithmetic(leftType)) {
                return new SimpleBinaryExpression(ExpressionType.Subtract, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedBinaryOperatorOrThrow(ExpressionType.Subtract, "subtract", left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.Subtract, left, right, method);
    }

    public static BinaryExpression multiply(Expression left, Expression right) {
        return Expression.multiply(left, right, null);
    }

    public static BinaryExpression multiply(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            Type<?> leftType = left.getType();
            Type<?> rightType = right.getType();
            if (TypeUtils.isArithmetic(leftType) && TypeUtils.isArithmetic(rightType)) {
                return new SimpleBinaryExpression(ExpressionType.Multiply, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedBinaryOperatorOrThrow(ExpressionType.Multiply, "multiply", left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.Multiply, left, right, method);
    }

    public static BinaryExpression divide(Expression left, Expression right) {
        return Expression.divide(left, right, null);
    }

    public static BinaryExpression divide(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            Type<?> rightType;
            Type<?> leftType = left.getType();
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType = right.getType()) && TypeUtils.isArithmetic(leftType)) {
                return new SimpleBinaryExpression(ExpressionType.Divide, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedBinaryOperatorOrThrow(ExpressionType.Divide, "divide", left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.Divide, left, right, method);
    }

    public static BinaryExpression modulo(Expression left, Expression right) {
        return Expression.modulo(left, right, null);
    }

    public static BinaryExpression modulo(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            Type<?> rightType;
            Type<?> leftType = left.getType();
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType = right.getType()) && TypeUtils.isArithmetic(leftType)) {
                return new SimpleBinaryExpression(ExpressionType.Modulo, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedBinaryOperatorOrThrow(ExpressionType.Modulo, "mod", left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.Modulo, left, right, method);
    }

    public static BinaryExpression leftShift(Expression left, Expression right) {
        return Expression.leftShift(left, right, null);
    }

    public static BinaryExpression leftShift(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            Type<?> leftType = left.getType();
            Type<?> rightType = right.getType();
            if (TypeUtils.isArithmetic(leftType) && TypeUtils.isIntegral(rightType)) {
                return new SimpleBinaryExpression(ExpressionType.LeftShift, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedBinaryOperatorOrThrow(ExpressionType.LeftShift, "shiftLeft", left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.LeftShift, left, right, method);
    }

    public static BinaryExpression rightShift(Expression left, Expression right) {
        return Expression.rightShift(left, right, null);
    }

    public static BinaryExpression rightShift(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            Type<?> leftType = left.getType();
            Type<?> rightType = right.getType();
            if (TypeUtils.isArithmetic(leftType) && TypeUtils.isIntegral(rightType)) {
                return new SimpleBinaryExpression(ExpressionType.RightShift, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedBinaryOperatorOrThrow(ExpressionType.RightShift, "shiftRight", left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.RightShift, left, right, method);
    }

    public static BinaryExpression unsignedRightShift(Expression left, Expression right) {
        return Expression.unsignedRightShift(left, right, null);
    }

    public static BinaryExpression unsignedRightShift(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            Type<?> leftType = left.getType();
            Type<?> rightType = right.getType();
            if (TypeUtils.isArithmetic(leftType) && TypeUtils.isIntegral(rightType)) {
                return new SimpleBinaryExpression(ExpressionType.RightShift, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            throw Error.binaryOperatorNotDefined(ExpressionType.UnsignedRightShift, left.getType(), right.getType());
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.RightShift, left, right, method);
    }

    public static BinaryExpression and(Expression left, Expression right) {
        return Expression.and(left, right, null);
    }

    public static BinaryExpression and(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            Type<?> rightType;
            Type<?> leftType = left.getType();
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType = right.getType()) && TypeUtils.isIntegralOrBoolean(leftType)) {
                return new SimpleBinaryExpression(ExpressionType.And, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedBinaryOperatorOrThrow(ExpressionType.And, "and", left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.And, left, right, method);
    }

    public static BinaryExpression or(Expression left, Expression right) {
        return Expression.or(left, right, null);
    }

    public static BinaryExpression or(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            Type<?> rightType;
            Type<?> leftType = left.getType();
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType = right.getType()) && TypeUtils.isIntegralOrBoolean(leftType)) {
                return new SimpleBinaryExpression(ExpressionType.Or, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedBinaryOperatorOrThrow(ExpressionType.Or, "or", left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.Or, left, right, method);
    }

    public static BinaryExpression exclusiveOr(Expression left, Expression right) {
        return Expression.exclusiveOr(left, right, null);
    }

    public static BinaryExpression exclusiveOr(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            Type<?> rightType;
            Type<?> leftType = left.getType();
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType = right.getType()) && TypeUtils.isIntegralOrBoolean(leftType)) {
                return new SimpleBinaryExpression(ExpressionType.ExclusiveOr, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedBinaryOperatorOrThrow(ExpressionType.ExclusiveOr, "xor", left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.ExclusiveOr, left, right, method);
    }

    public static BinaryExpression andAlso(Expression left, Expression right) {
        return Expression.andAlso(left, right, null);
    }

    public static BinaryExpression andAlso(Expression first, Expression ... rest) {
        Expression.verifyCanRead(first, "first");
        VerifyArgument.notEmpty(rest, "rest");
        Expression.verifyCanRead(rest, "rest");
        return Expression.aggregateBinary(ExpressionType.AndAlso, ImmutableList.of(first, rest));
    }

    public static BinaryExpression andAlso(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (method == null) {
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType) && TypeUtils.hasIdentityPrimitiveOrBoxingConversion(left.getType(), PrimitiveTypes.Boolean)) {
                return new SimpleBinaryExpression(ExpressionType.AndAlso, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            throw Error.binaryOperatorNotDefined(ExpressionType.AndAlso, leftType, rightType);
        }
        throw Error.binaryOperatorNotDefined(ExpressionType.AndAlso, leftType, rightType);
    }

    public static BinaryExpression orElse(Expression left, Expression right) {
        return Expression.orElse(left, right, null);
    }

    public static BinaryExpression orElse(Expression first, Expression ... rest) {
        Expression.verifyCanRead(first, "first");
        VerifyArgument.notEmpty(rest, "rest");
        Expression.verifyCanRead(rest, "rest");
        return Expression.aggregateBinary(ExpressionType.OrElse, ImmutableList.of(first, rest));
    }

    public static BinaryExpression orElse(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (method == null) {
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType) && TypeUtils.hasIdentityPrimitiveOrBoxingConversion(left.getType(), PrimitiveTypes.Boolean)) {
                return new SimpleBinaryExpression(ExpressionType.OrElse, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            throw Error.binaryOperatorNotDefined(ExpressionType.OrElse, leftType, rightType);
        }
        throw Error.binaryOperatorNotDefined(ExpressionType.OrElse, leftType, rightType);
    }

    public static BinaryExpression lessThan(Expression left, Expression right) {
        return Expression.lessThan(left, right, null);
    }

    public static BinaryExpression lessThan(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            return Expression.getComparisonOperator(ExpressionType.LessThan, left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.LessThan, left, right, method);
    }

    public static BinaryExpression lessThanOrEqual(Expression left, Expression right) {
        return Expression.lessThanOrEqual(left, right, null);
    }

    public static BinaryExpression lessThanOrEqual(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            return Expression.getComparisonOperator(ExpressionType.LessThanOrEqual, left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.LessThanOrEqual, left, right, method);
    }

    public static BinaryExpression greaterThan(Expression left, Expression right) {
        return Expression.greaterThan(left, right, null);
    }

    public static BinaryExpression greaterThan(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            return Expression.getComparisonOperator(ExpressionType.GreaterThan, left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.GreaterThan, left, right, method);
    }

    public static BinaryExpression greaterThanOrEqual(Expression left, Expression right) {
        return Expression.greaterThanOrEqual(left, right, null);
    }

    public static BinaryExpression greaterThanOrEqual(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            return Expression.getComparisonOperator(ExpressionType.GreaterThanOrEqual, left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.GreaterThanOrEqual, left, right, method);
    }

    public static BinaryExpression equal(Expression left, Expression right) {
        return Expression.equal(left, right, null);
    }

    public static BinaryExpression equal(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            return Expression.getEqualityComparisonOperator(ExpressionType.Equal, "equals", left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.Equal, left, right, method);
    }

    public static BinaryExpression notEqual(Expression left, Expression right) {
        return Expression.notEqual(left, right, null);
    }

    public static BinaryExpression notEqual(Expression left, Expression right, MethodInfo method) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (method == null) {
            return Expression.getEqualityComparisonOperator(ExpressionType.NotEqual, null, left, right);
        }
        return Expression.getMethodBasedBinaryOperator(ExpressionType.NotEqual, left, right, method);
    }

    public static BinaryExpression referenceEqual(Expression left, Expression right) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (TypeUtils.hasReferenceEquality(left.getType(), right.getType())) {
            return new LogicalBinaryExpression(ExpressionType.ReferenceEqual, left, right);
        }
        throw Error.referenceEqualityNotDefined(left.getType(), right.getType());
    }

    public static BinaryExpression referenceNotEqual(Expression left, Expression right) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanRead(right, "right");
        if (TypeUtils.hasReferenceEquality(left.getType(), right.getType())) {
            return new LogicalBinaryExpression(ExpressionType.ReferenceNotEqual, left, right);
        }
        throw Error.referenceEqualityNotDefined(left.getType(), right.getType());
    }

    public static BinaryExpression arrayIndex(Expression array, Expression index) {
        Expression.verifyCanRead(array, "array");
        Expression.verifyCanRead(index, "index");
        if (!TypeUtils.hasIdentityPrimitiveOrBoxingConversion(index.getType(), PrimitiveTypes.Integer)) {
            throw Error.argumentMustBeArrayIndexType();
        }
        Type<?> arrayType = array.getType();
        if (!arrayType.isArray()) {
            throw Error.argumentMustBeArray();
        }
        return new SimpleBinaryExpression(ExpressionType.ArrayIndex, array, index, arrayType.getElementType());
    }

    public static BinaryExpression assign(Expression left, Expression right) {
        Expression.verifyCanWrite(left, "left");
        Expression.verifyCanRead(right, "right");
        if (!left.getType().isAssignableFrom(right.getType())) {
            throw Error.expressionTypeDoesNotMatchAssignment(left.getType(), right.getType());
        }
        return new AssignBinaryExpression(left, right);
    }

    public static BinaryExpression addAssign(Expression left, Expression right) {
        return Expression.addAssign(left, right, null, null);
    }

    public static BinaryExpression addAssign(Expression left, Expression right, MethodInfo method) {
        return Expression.addAssign(left, right, method, null);
    }

    public static BinaryExpression addAssign(Expression left, Expression right, MethodInfo method, LambdaExpression<?> conversion) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanWrite(left, "left");
        Expression.verifyCanRead(right, "right");
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (method == null) {
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType) && TypeUtils.isArithmetic(leftType)) {
                if (conversion != null) {
                    throw Error.conversionIsNotSupportedForArithmeticTypes();
                }
                return new SimpleBinaryExpression(ExpressionType.AddAssign, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedAssignOperatorOrThrow(ExpressionType.AddAssign, "add", left, right, conversion);
        }
        return Expression.getMethodBasedAssignOperator(ExpressionType.AddAssign, left, right, method, conversion);
    }

    public static BinaryExpression subtractAssign(Expression left, Expression right) {
        return Expression.subtractAssign(left, right, null, null);
    }

    public static BinaryExpression subtractAssign(Expression left, Expression right, MethodInfo method) {
        return Expression.subtractAssign(left, right, method, null);
    }

    public static BinaryExpression subtractAssign(Expression left, Expression right, MethodInfo method, LambdaExpression<?> conversion) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanWrite(left, "left");
        Expression.verifyCanRead(right, "right");
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (method == null) {
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType) && TypeUtils.isArithmetic(leftType)) {
                if (conversion != null) {
                    throw Error.conversionIsNotSupportedForArithmeticTypes();
                }
                return new SimpleBinaryExpression(ExpressionType.SubtractAssign, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedAssignOperatorOrThrow(ExpressionType.SubtractAssign, "subtract", left, right, conversion);
        }
        return Expression.getMethodBasedAssignOperator(ExpressionType.SubtractAssign, left, right, method, conversion);
    }

    public static BinaryExpression multiplyAssign(Expression left, Expression right) {
        return Expression.multiplyAssign(left, right, null, null);
    }

    public static BinaryExpression multiplyAssign(Expression left, Expression right, MethodInfo method) {
        return Expression.multiplyAssign(left, right, method, null);
    }

    public static BinaryExpression multiplyAssign(Expression left, Expression right, MethodInfo method, LambdaExpression<?> conversion) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanWrite(left, "left");
        Expression.verifyCanRead(right, "right");
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (method == null) {
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType) && TypeUtils.isArithmetic(leftType)) {
                if (conversion != null) {
                    throw Error.conversionIsNotSupportedForArithmeticTypes();
                }
                return new SimpleBinaryExpression(ExpressionType.MultiplyAssign, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedAssignOperatorOrThrow(ExpressionType.MultiplyAssign, "multiply", left, right, conversion);
        }
        return Expression.getMethodBasedAssignOperator(ExpressionType.MultiplyAssign, left, right, method, conversion);
    }

    public static BinaryExpression divideAssign(Expression left, Expression right) {
        return Expression.divideAssign(left, right, null, null);
    }

    public static BinaryExpression divideAssign(Expression left, Expression right, MethodInfo method) {
        return Expression.divideAssign(left, right, method, null);
    }

    public static BinaryExpression divideAssign(Expression left, Expression right, MethodInfo method, LambdaExpression<?> conversion) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanWrite(left, "left");
        Expression.verifyCanRead(right, "right");
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (method == null) {
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType) && TypeUtils.isArithmetic(leftType)) {
                if (conversion != null) {
                    throw Error.conversionIsNotSupportedForArithmeticTypes();
                }
                return new SimpleBinaryExpression(ExpressionType.DivideAssign, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedAssignOperatorOrThrow(ExpressionType.DivideAssign, "divide", left, right, conversion);
        }
        return Expression.getMethodBasedAssignOperator(ExpressionType.DivideAssign, left, right, method, conversion);
    }

    public static BinaryExpression moduloAssign(Expression left, Expression right) {
        return Expression.moduloAssign(left, right, null, null);
    }

    public static BinaryExpression moduloAssign(Expression left, Expression right, MethodInfo method) {
        return Expression.moduloAssign(left, right, method, null);
    }

    public static BinaryExpression moduloAssign(Expression left, Expression right, MethodInfo method, LambdaExpression<?> conversion) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanWrite(left, "left");
        Expression.verifyCanRead(right, "right");
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (method == null) {
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType) && TypeUtils.isArithmetic(leftType)) {
                if (conversion != null) {
                    throw Error.conversionIsNotSupportedForArithmeticTypes();
                }
                return new SimpleBinaryExpression(ExpressionType.ModuloAssign, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedAssignOperatorOrThrow(ExpressionType.ModuloAssign, "modulo", left, right, conversion);
        }
        return Expression.getMethodBasedAssignOperator(ExpressionType.ModuloAssign, left, right, method, conversion);
    }

    public static BinaryExpression leftShiftAssign(Expression left, Expression right) {
        return Expression.leftShiftAssign(left, right, null, null);
    }

    public static BinaryExpression leftShiftAssign(Expression left, Expression right, MethodInfo method) {
        return Expression.leftShiftAssign(left, right, method, null);
    }

    public static BinaryExpression leftShiftAssign(Expression left, Expression right, MethodInfo method, LambdaExpression<?> conversion) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanWrite(left, "left");
        Expression.verifyCanRead(right, "right");
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (method == null) {
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType) && TypeUtils.isArithmetic(leftType)) {
                if (conversion != null) {
                    throw Error.conversionIsNotSupportedForArithmeticTypes();
                }
                return new SimpleBinaryExpression(ExpressionType.LeftShiftAssign, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedAssignOperatorOrThrow(ExpressionType.LeftShiftAssign, "shiftLeft", left, right, conversion);
        }
        return Expression.getMethodBasedAssignOperator(ExpressionType.LeftShiftAssign, left, right, method, conversion);
    }

    public static BinaryExpression rightShiftAssign(Expression left, Expression right) {
        return Expression.rightShiftAssign(left, right, null, null);
    }

    public static BinaryExpression rightShiftAssign(Expression left, Expression right, MethodInfo method) {
        return Expression.rightShiftAssign(left, right, method, null);
    }

    public static BinaryExpression rightShiftAssign(Expression left, Expression right, MethodInfo method, LambdaExpression<?> conversion) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanWrite(left, "left");
        Expression.verifyCanRead(right, "right");
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (method == null) {
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType) && TypeUtils.isArithmetic(leftType)) {
                if (conversion != null) {
                    throw Error.conversionIsNotSupportedForArithmeticTypes();
                }
                return new SimpleBinaryExpression(ExpressionType.RightShiftAssign, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedAssignOperatorOrThrow(ExpressionType.RightShiftAssign, "rightShift", left, right, conversion);
        }
        return Expression.getMethodBasedAssignOperator(ExpressionType.RightShiftAssign, left, right, method, conversion);
    }

    public static BinaryExpression unsignedRightShiftAssign(Expression left, Expression right) {
        return Expression.unsignedRightShiftAssign(left, right, null, null);
    }

    public static BinaryExpression unsignedRightShiftAssign(Expression left, Expression right, MethodInfo method) {
        return Expression.unsignedRightShiftAssign(left, right, method, null);
    }

    public static BinaryExpression unsignedRightShiftAssign(Expression left, Expression right, MethodInfo method, LambdaExpression<?> conversion) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanWrite(left, "left");
        Expression.verifyCanRead(right, "right");
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (method == null) {
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType) && TypeUtils.isArithmetic(leftType)) {
                if (conversion != null) {
                    throw Error.conversionIsNotSupportedForArithmeticTypes();
                }
                return new SimpleBinaryExpression(ExpressionType.UnsignedRightShiftAssign, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            throw Error.binaryOperatorNotDefined(ExpressionType.UnsignedRightShiftAssign, left.getType(), right.getType());
        }
        return Expression.getMethodBasedAssignOperator(ExpressionType.UnsignedRightShiftAssign, left, right, method, conversion);
    }

    public static BinaryExpression orAssign(Expression left, Expression right) {
        return Expression.orAssign(left, right, null, null);
    }

    public static BinaryExpression orAssign(Expression left, Expression right, MethodInfo method) {
        return Expression.orAssign(left, right, method, null);
    }

    public static BinaryExpression orAssign(Expression left, Expression right, MethodInfo method, LambdaExpression<?> conversion) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanWrite(left, "left");
        Expression.verifyCanRead(right, "right");
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (method == null) {
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType) && TypeUtils.isIntegralOrBoolean(leftType)) {
                if (conversion != null) {
                    throw Error.conversionIsNotSupportedForArithmeticTypes();
                }
                return new SimpleBinaryExpression(ExpressionType.OrAssign, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedAssignOperatorOrThrow(ExpressionType.OrAssign, "or", left, right, conversion);
        }
        return Expression.getMethodBasedAssignOperator(ExpressionType.OrAssign, left, right, method, conversion);
    }

    public static BinaryExpression andAssign(Expression left, Expression right) {
        return Expression.andAssign(left, right, null, null);
    }

    public static BinaryExpression andAssign(Expression left, Expression right, MethodInfo method) {
        return Expression.andAssign(left, right, method, null);
    }

    public static BinaryExpression andAssign(Expression left, Expression right, MethodInfo method, LambdaExpression<?> conversion) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanWrite(left, "left");
        Expression.verifyCanRead(right, "right");
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (method == null) {
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType) && TypeUtils.isIntegralOrBoolean(leftType)) {
                if (conversion != null) {
                    throw Error.conversionIsNotSupportedForArithmeticTypes();
                }
                return new SimpleBinaryExpression(ExpressionType.AndAssign, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedAssignOperatorOrThrow(ExpressionType.AndAssign, "and", left, right, conversion);
        }
        return Expression.getMethodBasedAssignOperator(ExpressionType.AndAssign, left, right, method, conversion);
    }

    public static BinaryExpression exclusiveOrAssign(Expression left, Expression right) {
        return Expression.exclusiveOrAssign(left, right, null, null);
    }

    public static BinaryExpression exclusiveOrAssign(Expression left, Expression right, MethodInfo method) {
        return Expression.exclusiveOrAssign(left, right, method, null);
    }

    public static BinaryExpression exclusiveOrAssign(Expression left, Expression right, MethodInfo method, LambdaExpression<?> conversion) {
        Expression.verifyCanRead(left, "left");
        Expression.verifyCanWrite(left, "left");
        Expression.verifyCanRead(right, "right");
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (method == null) {
            if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType) && TypeUtils.isIntegralOrBoolean(leftType)) {
                if (conversion != null) {
                    throw Error.conversionIsNotSupportedForArithmeticTypes();
                }
                return new SimpleBinaryExpression(ExpressionType.ExclusiveOrAssign, left, right, Expression.performBinaryNumericPromotion(leftType, rightType));
            }
            return Expression.getMethodBasedAssignOperatorOrThrow(ExpressionType.ExclusiveOrAssign, "xor", left, right, conversion);
        }
        return Expression.getMethodBasedAssignOperator(ExpressionType.ExclusiveOrAssign, left, right, method, conversion);
    }

    public static TypeBinaryExpression instanceOf(Expression expression, Type type) {
        Expression.verifyCanRead(expression, "expression");
        VerifyArgument.notNull(type, "type");
        Expression.verifyTypeBinaryExpressionOperand(expression, type);
        return new TypeBinaryExpression(expression, type, ExpressionType.InstanceOf);
    }

    public static TypeBinaryExpression typeEqual(Expression expression, Type type) {
        Expression.verifyCanRead(expression, "expression");
        VerifyArgument.notNull(type, "type");
        Expression.verifyTypeBinaryExpressionOperand(expression, type);
        return new TypeBinaryExpression(expression, type, ExpressionType.TypeEqual);
    }

    public static LambdaExpression<?> lambda(String name, Expression body, ParameterExpression ... parameters) {
        return Expression.lambda(null, name, body, false, Expression.arrayToList(parameters));
    }

    public static LambdaExpression<?> lambda(Expression body, ParameterExpression ... parameters) {
        return Expression.lambda(null, null, body, false, Expression.arrayToList(parameters));
    }

    public static LambdaExpression<?> lambda(Expression body, boolean tailCall, ParameterExpression ... parameters) {
        return Expression.lambda(null, null, body, tailCall, Expression.arrayToList(parameters));
    }

    public static LambdaExpression<?> lambda(String name, Expression body, boolean tailCall, ParameterExpression ... parameters) {
        return Expression.lambda(null, name, body, false, Expression.arrayToList(parameters));
    }

    public static LambdaExpression<?> lambda(Expression body, ParameterExpressionList parameters) {
        return Expression.lambda(null, null, body, false, parameters);
    }

    public static LambdaExpression<?> lambda(Expression body, boolean tailCall, ParameterExpressionList parameters) {
        return Expression.lambda(null, null, body, tailCall, parameters);
    }

    public static <T> LambdaExpression<T> lambda(Type<?> interfaceType, String name, Expression body, ParameterExpression ... parameters) {
        return Expression.lambda(interfaceType, name, body, false, Expression.arrayToList(parameters));
    }

    public static <T> LambdaExpression<T> lambda(Type<?> interfaceType, Expression body, ParameterExpression ... parameters) {
        return Expression.lambda(interfaceType, null, body, false, Expression.arrayToList(parameters));
    }

    public static <T> LambdaExpression<T> lambda(Type<?> interfaceType, Expression body, boolean tailCall, ParameterExpression ... parameters) {
        return Expression.lambda(interfaceType, null, body, tailCall, Expression.arrayToList(parameters));
    }

    public static <T> LambdaExpression<T> lambda(Type<?> interfaceType, String name, Expression body, boolean tailCall, ParameterExpression ... parameters) {
        return Expression.lambda(interfaceType, name, body, false, Expression.arrayToList(parameters));
    }

    public static <T> LambdaExpression<T> lambda(Type<?> interfaceType, Expression body, ParameterExpressionList parameters) {
        return Expression.lambda(interfaceType, null, body, false, parameters);
    }

    public static <T> LambdaExpression<T> lambda(Type<?> interfaceType, Expression body, boolean tailCall, ParameterExpressionList parameters) {
        return Expression.lambda(interfaceType, null, body, tailCall, parameters);
    }

    public static <T> LambdaExpression<T> lambda(Type<?> interfaceType, String name, Expression body, boolean tailCall, ParameterExpressionList parameters) {
        VerifyArgument.notNull(body, "body");
        VerifyArgument.noNullElements(parameters, "parameters");
        if (interfaceType != null) {
            Expression.validateLambdaArgs(interfaceType, body, parameters);
        }
        return new LambdaExpression(interfaceType, name, body, tailCall, parameters);
    }

    public static InvocationExpression invoke(Expression expression, Expression ... arguments) {
        VerifyArgument.noNullElements(arguments, "arguments");
        return Expression.invoke(expression, new ExpressionList(arguments));
    }

    public static InvocationExpression invoke(Expression expression, ExpressionList<? extends Expression> arguments) {
        Expression.verifyCanRead(expression, "expression");
        MethodInfo method = Expression.getInvokeMethod(expression);
        return new InvocationExpression(expression, arguments, method.getReturnType());
    }

    public static MethodCallExpression call(MethodInfo method, Expression ... arguments) {
        return Expression.call(null, method, Expression.arrayToList((Expression[])arguments));
    }

    public static MethodCallExpression call(MethodInfo method, ExpressionList<? extends Expression> arguments) {
        return Expression.call(null, method, arguments);
    }

    public static MethodCallExpression call(Expression target, MethodInfo method, Expression ... arguments) {
        return Expression.call(target, method, Expression.arrayToList((Expression[])arguments));
    }

    public static MethodCallExpression call(Expression target, MethodInfo method, ExpressionList<? extends Expression> arguments) {
        Expression actualTarget;
        VerifyArgument.notNull(method, "method");
        if (target == null && method instanceof DynamicMethod) {
            MethodHandle handle = ((DynamicMethod)method).getHandle();
            if (handle == null) {
                throw Error.dynamicMethodCallRequiresTargetOrMethodHandle();
            }
            actualTarget = Expression.constant(handle, Types.MethodHandle);
        } else {
            actualTarget = target;
        }
        Expression.validateStaticOrInstanceMethod(actualTarget, method);
        ExpressionList<? extends Expression> argumentList = Expression.validateArgumentTypes(method, ExpressionType.Call, arguments);
        if (actualTarget == null) {
            return new MethodCallExpressionN(method, argumentList);
        }
        return new InstanceMethodCallExpressionN(method, actualTarget, arguments);
    }

    public static MethodCallExpression call(Expression target, String methodName, Expression ... arguments) {
        return Expression.call(target, methodName, TypeList.empty(), (ExpressionList<? extends Expression>)Expression.arrayToList((Expression[])arguments));
    }

    public static MethodCallExpression call(Expression target, String methodName, TypeList typeArguments, Expression ... arguments) {
        return Expression.call(target, methodName, typeArguments, (ExpressionList<? extends Expression>)Expression.arrayToList((Expression[])arguments));
    }

    public static MethodCallExpression call(Expression target, String methodName, TypeList typeArguments, ExpressionList<? extends Expression> arguments) {
        VerifyArgument.notNull(target, "target");
        VerifyArgument.notNull(methodName, "methodName");
        MethodInfo resolvedMethod = Expression.findMethod(target.getType(), methodName, typeArguments, arguments, InstanceMemberBindingFlags);
        return Expression.call(target, resolvedMethod, Expression.adaptArguments(resolvedMethod, arguments));
    }

    public static MethodCallExpression call(Type declaringType, String methodName, Expression ... arguments) {
        return Expression.call(declaringType, methodName, TypeList.empty(), (ExpressionList<? extends Expression>)Expression.arrayToList((Expression[])arguments));
    }

    public static MethodCallExpression call(Type declaringType, String methodName, TypeList typeArguments, Expression ... arguments) {
        return Expression.call(declaringType, methodName, typeArguments, (ExpressionList<? extends Expression>)Expression.arrayToList((Expression[])arguments));
    }

    public static MethodCallExpression call(Type declaringType, String methodName, TypeList typeArguments, ExpressionList<? extends Expression> arguments) {
        VerifyArgument.notNull(declaringType, "declaringType");
        VerifyArgument.notNull(methodName, "methodName");
        MethodInfo resolvedMethod = Expression.findMethod(declaringType, methodName, typeArguments, arguments, StaticMemberBindingFlags);
        return Expression.call(resolvedMethod, Expression.adaptArguments(resolvedMethod, arguments));
    }

    private static ExpressionList<? extends Expression> adaptArguments(MethodInfo method, ExpressionList<? extends Expression> arguments) {
        if (method.getCallingConvention() == CallingConvention.VarArgs) {
            boolean needArray;
            TypeList pt = method.getParameters().getParameterTypes();
            int varArgArrayPosition = pt.size() - 1;
            Type varArgArrayType = (Type)pt.get(varArgArrayPosition);
            boolean bl = needArray = arguments.size() != pt.size() || !TypeUtils.areEquivalent(varArgArrayType, arguments.get(arguments.size() - 1).getType());
            if (needArray) {
                Expression[] newArguments = new Expression[pt.size()];
                for (int i = 0; i < varArgArrayPosition; ++i) {
                    newArguments[i] = arguments.get(i);
                }
                ExpressionList<Expression> arrayInitList = ExpressionList.empty();
                int n = arguments.size();
                for (int i = varArgArrayPosition; i < n; ++i) {
                    arrayInitList = arrayInitList.add(arguments.get(i));
                }
                newArguments[varArgArrayPosition] = Expression.newArrayInit(varArgArrayType.getElementType(), arrayInitList);
                return new ExpressionList(newArguments);
            }
        }
        return arguments;
    }

    public static DefaultValueExpression defaultValue(Type type) {
        VerifyArgument.notNull(type, "type");
        return new DefaultValueExpression(type);
    }

    public static SwitchCase switchCase(Expression body, Expression ... testValues) {
        return Expression.switchCase(body, Expression.arrayToList((Expression[])testValues));
    }

    public static SwitchCase switchCase(Expression body, ExpressionList<? extends Expression> testValues) {
        Expression.verifyCanRead(body, "body");
        Expression.verifyCanRead(testValues, "testValues");
        VerifyArgument.notEmpty(testValues, "testValues");
        return new SwitchCase(body, testValues);
    }

    public static SwitchExpression makeSwitch(Expression switchValue, SwitchCase ... cases) {
        return Expression.makeSwitch(switchValue, SwitchOptions.Default, null, null, Expression.arrayToReadOnlyList(cases));
    }

    public static SwitchExpression makeSwitch(Expression switchValue, SwitchOptions options, SwitchCase ... cases) {
        return Expression.makeSwitch(switchValue, options, null, null, Expression.arrayToReadOnlyList(cases));
    }

    public static SwitchExpression makeSwitch(Expression switchValue, Expression defaultBody, SwitchCase ... cases) {
        return Expression.makeSwitch(switchValue, SwitchOptions.Default, defaultBody, null, Expression.arrayToReadOnlyList(cases));
    }

    public static SwitchExpression makeSwitch(Expression switchValue, SwitchOptions options, Expression defaultBody, SwitchCase ... cases) {
        return Expression.makeSwitch(switchValue, options, defaultBody, null, Expression.arrayToReadOnlyList(cases));
    }

    public static SwitchExpression makeSwitch(Expression switchValue, Expression defaultBody, MethodInfo comparison, SwitchCase ... cases) {
        return Expression.makeSwitch(switchValue, SwitchOptions.Default, defaultBody, comparison, Expression.arrayToReadOnlyList(cases));
    }

    public static SwitchExpression makeSwitch(Type type, Expression switchValue, Expression defaultBody, SwitchCase ... cases) {
        return Expression.makeSwitch(type, switchValue, SwitchOptions.Default, defaultBody, null, Expression.arrayToReadOnlyList(cases));
    }

    public static SwitchExpression makeSwitch(Expression switchValue, SwitchOptions options, Expression defaultBody, MethodInfo comparison, SwitchCase ... cases) {
        return Expression.makeSwitch(switchValue, options, defaultBody, comparison, Expression.arrayToReadOnlyList(cases));
    }

    public static SwitchExpression makeSwitch(Type type, Expression switchValue, SwitchOptions options, Expression defaultBody, SwitchCase ... cases) {
        return Expression.makeSwitch(type, switchValue, options, defaultBody, null, Expression.arrayToReadOnlyList(cases));
    }

    public static SwitchExpression makeSwitch(Type type, Expression switchValue, Expression defaultBody, MethodInfo comparison, SwitchCase ... cases) {
        return Expression.makeSwitch(type, switchValue, SwitchOptions.Default, defaultBody, comparison, Expression.arrayToReadOnlyList(cases));
    }

    public static SwitchExpression makeSwitch(Type type, Expression switchValue, SwitchOptions options, Expression defaultBody, MethodInfo comparison, SwitchCase ... cases) {
        return Expression.makeSwitch(type, switchValue, options, defaultBody, comparison, Expression.arrayToReadOnlyList(cases));
    }

    public static SwitchExpression makeSwitch(Expression switchValue, Expression defaultBody, MethodInfo comparison, ReadOnlyList<SwitchCase> cases) {
        return Expression.makeSwitch(null, switchValue, SwitchOptions.Default, defaultBody, comparison, cases);
    }

    public static SwitchExpression makeSwitch(Expression switchValue, SwitchOptions options, Expression defaultBody, MethodInfo comparison, ReadOnlyList<SwitchCase> cases) {
        return Expression.makeSwitch(null, switchValue, options, defaultBody, comparison, cases);
    }

    public static SwitchExpression makeSwitch(Type type, Expression switchValue, SwitchOptions options, Expression defaultBody, MethodInfo comparison, ReadOnlyList<SwitchCase> cases) {
        MethodInfo actualComparison;
        Type<?> resultType;
        Expression.verifyCanRead(switchValue, "switchValue");
        if (switchValue.getType() == PrimitiveTypes.Void) {
            throw Error.argumentCannotBeOfTypeVoid();
        }
        VerifyArgument.notEmpty(cases, "cases");
        VerifyArgument.noNullElements(cases, "cases");
        boolean customType = type != null;
        Type<?> type2 = resultType = type != null ? type : cases.get(0).getBody().getType();
        if (comparison != null) {
            ParameterList parameters = comparison.getParameters();
            if (parameters.size() != 2) {
                throw Error.incorrectNumberOfMethodCallArguments(comparison);
            }
            ParameterInfo leftArg = (ParameterInfo)parameters.get(0);
            ParameterInfo rightArg = (ParameterInfo)parameters.get(1);
            int n = cases.size();
            for (int i = 0; i < n; ++i) {
                SwitchCase c = cases.get(i);
                Expression.validateSwitchCaseType(c.getBody(), customType, resultType, "cases");
                ExpressionList<? extends Expression> testValues = c.getTestValues();
                int m = testValues.size();
                for (int j = 0; j < m; ++j) {
                    Type<?> rightOperandType = testValues.get(j).getType();
                    if (Expression.parameterIsAssignable(rightArg.getParameterType(), rightOperandType)) continue;
                    throw Error.testValueTypeDoesNotMatchComparisonMethodParameter(rightOperandType, rightArg.getParameterType());
                }
            }
            actualComparison = comparison;
        } else {
            Expression firstTestValue = cases.get(0).getTestValues().get(0);
            int n = cases.size();
            for (int i = 0; i < n; ++i) {
                SwitchCase c = cases.get(i);
                Expression.validateSwitchCaseType(c.getBody(), customType, resultType, "cases");
                ExpressionList<? extends Expression> testValues = c.getTestValues();
                int m = testValues.size();
                for (int j = 0; j < m; ++j) {
                    if (TypeUtils.areReferenceAssignable(firstTestValue.getType(), testValues.get(j).getType())) continue;
                    throw Error.allTestValuesMustHaveTheSameType();
                }
            }
            BinaryExpression equal = Expression.equal(switchValue, firstTestValue, null);
            actualComparison = equal.getMethod();
        }
        if (defaultBody == null) {
            if (resultType != PrimitiveTypes.Void) {
                throw Error.defaultBodyMustBeSupplied();
            }
        } else {
            Expression.validateSwitchCaseType(defaultBody, customType, resultType, "defaultBody");
        }
        if (comparison != null && TypeUtils.hasIdentityPrimitiveOrBoxingConversion(comparison.getReturnType(), PrimitiveTypes.Boolean)) {
            throw Error.equalityMustReturnBoolean(comparison);
        }
        return new SwitchExpression(resultType, switchValue, defaultBody, actualComparison, cases, options);
    }

    static <T extends Expression> ExpressionList<T> arrayToList(T[] expressions) {
        if (expressions == null || expressions.length == 0) {
            return ExpressionList.empty();
        }
        VerifyArgument.noNullElements(expressions, "expressions");
        return new ExpressionList(expressions);
    }

    static <T> ReadOnlyList<T> arrayToReadOnlyList(T[] items) {
        if (items == null || items.length == 0) {
            return ReadOnlyList.emptyList();
        }
        VerifyArgument.noNullElements(items, "items");
        return new ReadOnlyList<T>(items);
    }

    static ParameterExpressionList arrayToList(ParameterExpression[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return ParameterExpressionList.empty();
        }
        VerifyArgument.noNullElements(parameters, "parameters");
        return new ParameterExpressionList(parameters);
    }

    private static void verifyCanRead(Expression expression, String parameterName) {
        VerifyArgument.notNull(expression, parameterName);
    }

    /*
     * WARNING - void declaration
     */
    private static void verifyCanRead(Iterable<? extends Expression> items, String parameterName) {
        if (items == null) {
            return;
        }
        if (items instanceof List) {
            void var3_4;
            List list = (List)items;
            boolean bl = false;
            int count = list.size();
            while (var3_4 < count) {
                Expression.verifyCanRead((Expression)list.get((int)var3_4), parameterName);
                ++var3_4;
            }
        }
        for (Expression expression : items) {
            Expression.verifyCanRead(expression, parameterName);
        }
    }

    private static void verifyCanRead(Expression[] items, String parameterName) {
        if (items == null) {
            return;
        }
        for (Expression item : items) {
            Expression.verifyCanRead(item, parameterName);
        }
    }

    private static void verifyCanWrite(Expression expression, String parameterName) {
        VerifyArgument.notNull(expression, "expression");
        boolean canWrite = false;
        switch (expression.getNodeType()) {
            case MemberAccess: {
                MemberExpression memberExpression = (MemberExpression)expression;
                if (!(memberExpression.getMember() instanceof FieldInfo)) break;
                FieldInfo field = (FieldInfo)memberExpression.getMember();
                canWrite = !field.isEnumConstant();
                break;
            }
            case Parameter: {
                canWrite = true;
            }
        }
        if (!canWrite) {
            throw Error.expressionMustBeWriteable(parameterName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void verifyCanWrite(Iterable<? extends Expression> items, String parameterName) {
        if (items == null) {
            return;
        }
        if (items instanceof List) {
            void var3_4;
            List list = (List)items;
            boolean bl = false;
            int count = list.size();
            while (var3_4 < count) {
                Expression.verifyCanWrite((Expression)list.get((int)var3_4), parameterName);
                ++var3_4;
            }
        }
        for (Expression expression : items) {
            Expression.verifyCanWrite(expression, parameterName);
        }
    }

    static void validateVariables(ParameterExpressionList varList, String collectionName) {
        if (varList.isEmpty()) {
            return;
        }
        int count = varList.size();
        HashSet<ParameterExpression> set = new HashSet<ParameterExpression>(count);
        for (int i = 0; i < count; ++i) {
            ParameterExpression v = (ParameterExpression)varList.get(i);
            if (v == null) {
                throw new IllegalArgumentException(String.format("%s[%s] is null.", collectionName, i));
            }
            if (set.contains(v)) {
                throw Error.duplicateVariable(v);
            }
            set.add(v);
        }
    }

    private static UnaryExpression getMethodBasedUnaryOperator(ExpressionType unaryType, Expression operand, MethodInfo method) {
        Expression.validateOperator(method);
        ParameterList parameters = method.getParameters();
        if (parameters.size() != 0) {
            throw Error.incorrectNumberOfMethodCallArguments(method);
        }
        Type<?> returnType = method.getReturnType();
        if (TypeUtils.areReferenceAssignable(operand.getType(), returnType)) {
            return new UnaryExpression(unaryType, operand, returnType, method);
        }
        if (TypeUtils.isAutoUnboxed(operand.getType()) && TypeUtils.areReferenceAssignable(TypeUtils.getUnderlyingPrimitive(operand.getType()), returnType)) {
            return new UnaryExpression(unaryType, operand, returnType, method);
        }
        throw Error.methodBasedOperatorMustHaveValidReturnType(unaryType, method);
    }

    private static UnaryExpression getMethodBasedUnaryOperatorOrThrow(ExpressionType unaryType, String methodName, Expression operand) {
        UnaryExpression u = Expression.getMethodBasedUnaryOperator(unaryType, methodName, operand);
        if (u != null) {
            Expression.validateOperator(u.getMethod());
            return u;
        }
        throw Error.unaryOperatorNotDefined(unaryType, operand.getType());
    }

    private static UnaryExpression getMethodBasedUnaryOperatorOrThrow(ExpressionType unaryType, Expression operand, String ... methodNames) {
        for (String methodName : methodNames) {
            UnaryExpression u = Expression.getMethodBasedUnaryOperator(unaryType, methodName, operand);
            if (u == null) continue;
            Expression.validateOperator(u.getMethod());
            return u;
        }
        throw Error.unaryOperatorNotDefined(unaryType, operand.getType());
    }

    private static UnaryExpression getMethodBasedUnaryOperator(ExpressionType unaryType, String methodName, Expression operand) {
        Type<?> operandType = operand.getType();
        assert (!operandType.isPrimitive());
        MethodInfo method = operandType.getMethod(methodName, new Type[0]);
        return new UnaryExpression(unaryType, operand, method.getReturnType(), method);
    }

    private static void validateOperator(MethodInfo method) {
        assert (method != null);
        if (method.isStatic()) {
            throw Error.operatorMethodMustNotBeStatic(method);
        }
        Type<?> returnType = method.getReturnType();
        if (returnType == PrimitiveTypes.Void) {
            throw Error.operatorMethodMustNotReturnVoid(method);
        }
        ParameterList parameters = method.getParameters();
        if (parameters.size() != 0) {
            throw Error.operatorMethodParametersMustMatchReturnValue(method);
        }
        if (!TypeUtils.areReferenceAssignable(method.getDeclaringType(), returnType)) {
            throw Error.methodBasedOperatorMustHaveValidReturnType(method);
        }
    }

    private static UnaryExpression getMethodBasedCoercionOrThrow(ExpressionType coercionType, Expression expression, Type convertToType) {
        UnaryExpression u = Expression.getMethodBasedCoercion(coercionType, expression, convertToType);
        if (u != null) {
            return u;
        }
        throw Error.coercionOperatorNotDefined(expression.getType(), convertToType);
    }

    private static UnaryExpression getMethodBasedCoercion(ExpressionType coercionType, Expression expression, Type convertToType) {
        MethodInfo method = TypeUtils.getCoercionMethod(expression.getType(), convertToType);
        if (method != null) {
            return new UnaryExpression(coercionType, expression, convertToType, method);
        }
        return null;
    }

    private static UnaryExpression getMethodBasedCoercionOperator(ExpressionType unaryType, Expression operand, Type convertToType, MethodInfo method) {
        assert (method != null);
        Expression.validateOperator(method);
        ParameterList parameters = method.getParameters();
        if (parameters.size() != 0) {
            throw Error.incorrectNumberOfMethodCallArguments(method);
        }
        Type<?> returnType = method.getReturnType();
        if (TypeUtils.areReferenceAssignable(convertToType, returnType)) {
            return new UnaryExpression(unaryType, operand, returnType, method);
        }
        if (TypeUtils.isAutoUnboxed(convertToType) && returnType.isPrimitive() && TypeUtils.areEquivalent(returnType, TypeUtils.getUnderlyingPrimitive(convertToType))) {
            return new UnaryExpression(unaryType, operand, convertToType, method);
        }
        throw Error.methodBasedOperatorMustHaveValidReturnType(unaryType, method);
    }

    private static UnaryExpression makeOpAssignUnary(ExpressionType kind, Expression expression, MethodInfo method) {
        UnaryExpression result;
        Expression.verifyCanRead(expression, "expression");
        Expression.verifyCanWrite(expression, "expression");
        if (method == null) {
            if (TypeUtils.isArithmetic(expression.getType())) {
                return new UnaryExpression(kind, expression, expression.getType(), null);
            }
            String methodName = kind == ExpressionType.PreIncrementAssign || kind == ExpressionType.PostIncrementAssign ? "increment" : "decrement";
            result = Expression.getMethodBasedUnaryOperatorOrThrow(kind, methodName, expression);
        } else {
            result = Expression.getMethodBasedUnaryOperator(kind, expression, method);
        }
        if (!TypeUtils.areReferenceAssignable(expression.getType(), result.getType())) {
            throw Error.methodBasedOperatorMustHaveValidReturnType(kind, method);
        }
        return result;
    }

    static boolean parameterIsAssignable(Type parameterType, Type argumentType) {
        return argumentType.isPrimitive() && parameterType == Types.Object || parameterType.isAssignableFrom(argumentType);
    }

    static MethodInfo getMethodValidated(Type type, String name, Set<BindingFlags> bindingFlags, CallingConvention callingConvention, Type ... parameterTypes) {
        MethodInfo method = type.getMethod(name, bindingFlags, callingConvention, parameterTypes);
        return Expression.methodArgumentsMatch(method, parameterTypes) ? method : null;
    }

    static boolean methodArgumentsMatch(MethodInfo method, Type ... argumentTypes) {
        if (method == null || argumentTypes == null) {
            return false;
        }
        ParameterList parameters = method.getParameters();
        int parameterCount = parameters.size();
        if (parameterCount != argumentTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterCount; ++i) {
            if (Expression.parameterIsAssignable(((ParameterInfo)parameters.get(i)).getParameterType(), argumentTypes[i])) continue;
            return false;
        }
        return true;
    }

    static <T> List<T> ensureUnmodifiable(List<T> list) {
        if (UNMODIFIABLE_LIST_CLASS.isInstance(list)) {
            return list;
        }
        return Collections.unmodifiableList(list);
    }

    static <T extends Expression> T returnObject(Class<T> clazz, Object objectOrCollection) {
        if (clazz.isInstance(objectOrCollection)) {
            return (T)((Expression)objectOrCollection);
        }
        return ((ExpressionList)objectOrCollection).get(0);
    }

    private static BinaryExpression aggregateBinary(ExpressionType binaryType, ImmutableList<Expression> operands) {
        if (operands.size() == 2) {
            return Expression.makeBinary(binaryType, (Expression)operands.head, (Expression)operands.tail.head);
        }
        return Expression.makeBinary(binaryType, (Expression)operands.head, (Expression)Expression.aggregateBinary(binaryType, operands.tail));
    }

    private static void verifyTypeBinaryExpressionOperand(Expression expression, Type type) {
        if (type.isPrimitive()) {
            throw Error.primitiveCannotBeTypeBinaryType();
        }
    }

    static MethodInfo getInvokeMethod(Expression expression) {
        return Expression.getInvokeMethod(expression.getType(), true);
    }

    static MethodInfo getInvokeMethod(Type interfaceType, boolean throwOnError) {
        if (!interfaceType.isInterface()) {
            if (throwOnError) {
                throw Error.expressionTypeNotInvokable(interfaceType);
            }
            return null;
        }
        MethodList methods = interfaceType.getMethods();
        MethodInfo invokeMethod = null;
        for (MethodInfo method : methods) {
            if (method.isDefault() || method.isStatic()) continue;
            if (invokeMethod != null) {
                invokeMethod = null;
                break;
            }
            invokeMethod = method;
        }
        if (invokeMethod == null && throwOnError) {
            throw Error.expressionTypeNotInvokable(interfaceType);
        }
        return invokeMethod;
    }

    private static BinaryExpression getEqualityComparisonOperator(ExpressionType binaryType, String opName, Expression left, Expression right) {
        Type<?> rightType;
        Type<?> leftType = left.getType();
        if (TypeUtils.hasBuiltInEqualityOperator(leftType, rightType = right.getType())) {
            if (leftType.isEnum() || rightType.isEnum()) {
                return new LogicalBinaryExpression(binaryType, left, right);
            }
            return new LogicalBinaryExpression(binaryType, leftType.isPrimitive() ? left : Expression.unbox(left), rightType.isPrimitive() ? right : Expression.unbox(right));
        }
        if (Expression.isNullComparison(left, right)) {
            return new LogicalBinaryExpression(binaryType, left, right);
        }
        BinaryExpression b = Expression.getMethodBasedBinaryOperator(binaryType, opName, left, right);
        if (b != null) {
            return b;
        }
        throw Error.binaryOperatorNotDefined(binaryType, leftType, rightType);
    }

    private static MethodInfo getBinaryOperatorMethod(ExpressionType binaryType, Type leftType, Type rightType, String name) {
        MethodInfo method = Expression.getMethodValidated(leftType, name, BindingFlags.PublicInstance, CallingConvention.Standard, rightType);
        if (method != null || TypeUtils.areEquivalent(leftType, rightType)) {
            return method;
        }
        return Expression.getMethodValidated(rightType, name, BindingFlags.PublicInstance, CallingConvention.Standard, leftType);
    }

    private static MethodInfo getBinaryOperatorStaticMethod(ExpressionType binaryType, Type leftType, Type rightType, String name) {
        MethodInfo method = Expression.getMethodValidated(leftType, name, BindingFlags.PublicStatic, CallingConvention.Standard, leftType, rightType);
        if (method != null || TypeUtils.areEquivalent(leftType, rightType)) {
            return method;
        }
        return Expression.getMethodValidated(rightType, name, BindingFlags.PublicStatic, CallingConvention.Standard, leftType, rightType);
    }

    private static BinaryExpression getMethodBasedBinaryOperator(ExpressionType binaryType, String name, Expression left, Expression right) {
        switch (binaryType) {
            case Equal: 
            case NotEqual: {
                return Expression.getEqualsMethodBasedBinaryOperator(binaryType, left, right);
            }
        }
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (name != null) {
            Type<?> boxedRightType;
            Type<?> unboxedRightType;
            MethodInfo method = Expression.getBinaryOperatorStaticMethod(binaryType, leftType, rightType, name);
            if (method != null) {
                return new MethodBinaryExpression(binaryType, left, right, method.getReturnType(), method);
            }
            method = Expression.getBinaryOperatorMethod(binaryType, leftType, rightType, name);
            if (method != null) {
                return new MethodBinaryExpression(binaryType, left, right, method.getReturnType(), method);
            }
            if (TypeUtils.isAutoUnboxed(rightType) ? (method = Expression.getBinaryOperatorMethod(binaryType, leftType, unboxedRightType = TypeUtils.getUnderlyingPrimitive(rightType), name)) != null : rightType.isPrimitive() && TypeUtils.isAutoUnboxed(rightType) && (method = Expression.getBinaryOperatorMethod(binaryType, leftType, boxedRightType = TypeUtils.getBoxedType(rightType), name)) != null) {
                return new MethodBinaryExpression(binaryType, left, right, method.getReturnType(), method);
            }
        }
        switch (binaryType) {
            case LessThan: 
            case LessThanOrEqual: 
            case GreaterThan: 
            case GreaterThanOrEqual: {
                return Expression.getCompareMethodBasedBinaryOperator(binaryType, left, right);
            }
        }
        return null;
    }

    private static BinaryExpression getCompareMethodBasedBinaryOperator(ExpressionType binaryType, Expression left, Expression right) {
        MethodInfo method;
        Type comparable;
        Type<?> rightType;
        Type<?> leftType = left.getType();
        if (TypeUtils.areEquivalent(leftType, rightType = right.getType()) && leftType.implementsInterface(comparable = Types.Comparable.makeGenericType(leftType)) && (method = Expression.getMethodValidated(Types.Comparer, "compare", BindingFlags.PublicStatic, CallingConvention.Standard, Types.Comparable, Types.Comparable)) != null) {
            method = method.makeGenericMethod(leftType);
            return new CompareMethodBasedLogicalBinaryExpression(binaryType, left, right, method);
        }
        if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(leftType, rightType) && (method = Expression.getMethodValidated(Types.Comparer, "compare", BindingFlags.PublicStatic, CallingConvention.Standard, Types.Object, Types.Object)) != null) {
            return new CompareMethodBasedLogicalBinaryExpression(binaryType, left, right, method);
        }
        return null;
    }

    private static BinaryExpression getEqualsMethodBasedBinaryOperator(ExpressionType binaryType, Expression left, Expression right) {
        return new EqualsMethodBasedLogicalBinaryExpression(binaryType, left, right, null);
    }

    private static BinaryExpression getMethodBasedBinaryOperator(ExpressionType binaryType, Expression left, Expression right, MethodInfo method) {
        assert (method != null);
        if (method.isStatic()) {
            return Expression.getStaticMethodBasedBinaryOperator(binaryType, left, right, method);
        }
        ParameterList parameters = method.getParameters();
        if (parameters.size() != 1) {
            throw Error.incorrectNumberOfMethodCallArguments(method);
        }
        Type<?> returnType = method.getReturnType();
        Type<?> parameterType = ((ParameterInfo)parameters.get(0)).getParameterType();
        Type<?> rightType = right.getType();
        if (Expression.parameterIsAssignable(((ParameterInfo)parameters.get(0)).getParameterType(), rightType)) {
            return new MethodBinaryExpression(binaryType, left, right, returnType, method);
        }
        throw Error.methodBasedOperatorMustHaveValidReturnType(binaryType, method);
    }

    private static BinaryExpression getStaticMethodBasedBinaryOperator(ExpressionType binaryType, Expression left, Expression right, MethodInfo method) {
        assert (method != null);
        ParameterList parameters = method.getParameters();
        if (parameters.size() != 2) {
            throw Error.incorrectNumberOfMethodCallArguments(method);
        }
        Type<?> returnType = method.getReturnType();
        Type<?> leftParameterType = ((ParameterInfo)parameters.get(0)).getParameterType();
        Type<?> rightParameterType = ((ParameterInfo)parameters.get(1)).getParameterType();
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (Expression.parameterIsAssignable(((ParameterInfo)parameters.get(0)).getParameterType(), leftType) && Expression.parameterIsAssignable(((ParameterInfo)parameters.get(1)).getParameterType(), rightType)) {
            return new MethodBinaryExpression(binaryType, left, right, returnType, method);
        }
        throw Error.methodBasedOperatorMustHaveValidReturnType(binaryType, method);
    }

    private static BinaryExpression getMethodBasedBinaryOperatorOrThrow(ExpressionType binaryType, String name, Expression left, Expression right) {
        BinaryExpression b = Expression.getMethodBasedBinaryOperator(binaryType, name, left, right);
        if (b != null) {
            return b;
        }
        throw Error.binaryOperatorNotDefined(binaryType, left.getType(), right.getType());
    }

    private static BinaryExpression getMethodBasedAssignOperator(ExpressionType binaryType, String name, Expression left, Expression right, LambdaExpression<?> conversion) {
        MethodInfo method = Expression.getBinaryOperatorMethod(binaryType, left.getType(), right.getType(), name);
        if (method != null) {
            return new MethodBinaryExpression(binaryType, left, right, method.getReturnType(), method);
        }
        return null;
    }

    private static BinaryExpression getMethodBasedAssignOperatorOrThrow(ExpressionType binaryType, String name, Expression left, Expression right, LambdaExpression<?> conversion) {
        BinaryExpression b = Expression.getMethodBasedBinaryOperatorOrThrow(binaryType, name, left, right);
        if (conversion == null) {
            if (!TypeUtils.areReferenceAssignable(left.getType(), right.getType())) {
                throw Error.methodBasedOperatorMustHaveValidReturnType(binaryType, b.getMethod());
            }
        } else {
            Expression.validateOpAssignConversionLambda(conversion, b.getLeft(), b.getMethod(), b.getNodeType());
            b = new OpAssignMethodConversionBinaryExpression(b.getNodeType(), b.getLeft(), b.getRight(), b.getLeft().getType(), b.getMethod(), conversion);
        }
        return b;
    }

    private static BinaryExpression getMethodBasedAssignOperator(ExpressionType binaryType, Expression left, Expression right, MethodInfo method, LambdaExpression<?> conversion) {
        BinaryExpression b = Expression.getMethodBasedBinaryOperator(binaryType, left, right, method);
        if (conversion == null) {
            if (!TypeUtils.areReferenceAssignable(left.getType(), right.getType())) {
                throw Error.methodBasedOperatorMustHaveValidReturnType(binaryType, b.getMethod());
            }
        } else {
            Expression.validateOpAssignConversionLambda(conversion, b.getLeft(), b.getMethod(), b.getNodeType());
            b = new OpAssignMethodConversionBinaryExpression(b.getNodeType(), b.getLeft(), b.getRight(), b.getLeft().getType(), b.getMethod(), conversion);
        }
        return b;
    }

    private static void validateOpAssignConversionLambda(LambdaExpression<?> conversion, Expression left, MethodInfo method, ExpressionType nodeType) {
        Type<?> interfaceType = conversion.getType();
        MethodInfo invokeMethod = Expression.getInvokeMethod(conversion);
        ParameterList parameters = invokeMethod.getParameters();
        if (parameters.size() != 1) {
            throw Error.incorrectNumberOfMethodCallArguments(invokeMethod);
        }
        if (!TypeUtils.hasIdentityPrimitiveOrBoxingConversion(invokeMethod.getReturnType(), left.getType())) {
            throw Error.operandTypesDoNotMatchParameters(nodeType, invokeMethod);
        }
        if (method != null && !TypeUtils.hasIdentityPrimitiveOrBoxingConversion(((ParameterInfo)parameters.get(0)).getParameterType(), method.getReturnType())) {
            throw Error.overloadOperatorTypeDoesNotMatchConversionType(nodeType, method);
        }
    }

    private static BinaryExpression getComparisonOperator(ExpressionType binaryType, Expression left, Expression right) {
        if (TypeUtils.isArithmetic(left.getType()) && (TypeUtils.isArithmetic(right.getType()) || TypeUtils.hasIdentityPrimitiveOrBoxingConversion(left.getType(), right.getType()))) {
            return new LogicalBinaryExpression(binaryType, left, right);
        }
        BinaryExpression b = Expression.getCompareMethodBasedBinaryOperator(binaryType, left, right);
        if (b != null) {
            return b;
        }
        throw Error.binaryOperatorNotDefined(binaryType, left.getType(), right.getType());
    }

    private static boolean isNullConstant(Expression e) {
        return e instanceof ConstantExpression && ((ConstantExpression)e).getValue() == null || e instanceof DefaultValueExpression && !e.getType().isPrimitive();
    }

    private static boolean isNullComparison(Expression left, Expression right) {
        return Expression.isNullConstant(left) && !Expression.isNullConstant(right) && !right.getType().isPrimitive() || Expression.isNullConstant(right) && !Expression.isNullConstant(left) && !left.getType().isPrimitive();
    }

    private static void validateStaticOrInstanceMethod(Expression instance, MethodInfo method) {
        if (method.isStatic()) {
            if (instance != null) {
                throw Error.targetInvalidForStaticMethodCall(method);
            }
        } else {
            if (instance == null) {
                throw Error.targetRequiredForNonStaticMethodCall(method);
            }
            Expression.verifyCanRead(instance, "instance");
            Expression.validateCallTargetType(instance.getType(), method);
        }
    }

    private static void validateCallTargetType(Type targetType, MethodInfo method) {
        if (!TypeUtils.isValidInvocationTargetType(method, targetType)) {
            throw Error.targetAndMethodTypeMismatch(method, targetType);
        }
    }

    private static <T extends Expression> ExpressionList<T> validateArgumentTypes(MethodBase method, ExpressionType nodeKind, ExpressionList<T> arguments) {
        assert (nodeKind == ExpressionType.Invoke || nodeKind == ExpressionType.Call || nodeKind == ExpressionType.New);
        TypeList parameterTypes = method instanceof MethodBuilder ? ((MethodBuilder)method).getParameterTypes() : (method instanceof ConstructorBuilder ? ((ConstructorBuilder)method).getMethodBuilder().getParameterTypes() : method.getParameters().getParameterTypes());
        Expression.validateArgumentCount(method, nodeKind, arguments.size(), parameterTypes);
        Expression[] newArgs = null;
        int n = parameterTypes.size();
        for (int i = 0; i < n; ++i) {
            Type parameterType = (Type)parameterTypes.get(i);
            T arg = Expression.validateOneArgument(method, nodeKind, arguments.get(i), parameterType);
            if (arg == arguments.get(i)) continue;
            if (newArgs == null) {
                newArgs = arguments.toArray();
            }
            newArgs[i] = arg;
        }
        if (newArgs != null) {
            return arguments.newInstance(newArgs);
        }
        return arguments;
    }

    private static <T extends Expression> T validateOneArgument(MethodBase method, ExpressionType nodeKind, T arg, Type parameterType) {
        Expression.verifyCanRead(arg, "arguments");
        Type<?> argType = arg.getType();
        if (!parameterType.isAssignableFrom(argType)) {
            switch (nodeKind) {
                case New: {
                    throw Error.expressionTypeDoesNotMatchConstructorParameter(argType, parameterType);
                }
                case Invoke: {
                    throw Error.expressionTypeDoesNotMatchParameter(argType, parameterType);
                }
                case Call: {
                    throw Error.expressionTypeDoesNotMatchMethodParameter(argType, parameterType, method);
                }
            }
            throw ContractUtils.unreachable();
        }
        return arg;
    }

    private static void validateArgumentCount(MethodBase method, ExpressionType nodeKind, int count, TypeList parameterTypes) {
        if (parameterTypes.size() == count) {
            return;
        }
        switch (nodeKind) {
            case New: {
                throw Error.incorrectNumberOfConstructorArguments();
            }
            case Invoke: {
                throw Error.incorrectNumberOfLambdaArguments();
            }
            case Call: {
                throw Error.incorrectNumberOfMethodCallArguments(method);
            }
        }
        throw ContractUtils.unreachable();
    }

    private static <T> void validateLambdaArgs(Type<T> interfaceType, Expression body, ParameterExpressionList parameters) {
        Type<?> returnType;
        VerifyArgument.notNull(interfaceType, "interfaceType");
        Expression.verifyCanRead(body, "body");
        MethodInfo invokeMethod = Expression.getInvokeMethod(interfaceType, false);
        if (invokeMethod == null) {
            throw Error.lambdaTypeMustBeSingleMethodInterface();
        }
        ParameterList methodParameters = invokeMethod.getParameters();
        if (methodParameters.size() > 0) {
            if (parameters.size() != methodParameters.size()) {
                throw Error.incorrectNumberOfLambdaArguments();
            }
            HashSet<ParameterExpression> set = new HashSet<ParameterExpression>(parameters.size());
            int n = methodParameters.size();
            for (int i = 0; i < n; ++i) {
                ParameterExpression pex = (ParameterExpression)parameters.get(i);
                ParameterInfo pi = (ParameterInfo)methodParameters.get(i);
                Expression.verifyCanRead(pex, "parameters");
                Type<?> pType = pi.getParameterType();
                if (!(TypeUtils.areEquivalent(pex.getType(), pType) || pType.isGenericParameter() && pType.isAssignableFrom(pex.getType()))) {
                    throw Error.parameterExpressionNotValidForDelegate(pex.getType(), pType);
                }
                if (set.contains(pex)) {
                    throw Error.duplicateVariable(pex);
                }
                set.add(pex);
            }
        } else if (parameters.size() > 0) {
            throw Error.incorrectNumberOfLambdaDeclarationParameters();
        }
        if ((returnType = invokeMethod.getReturnType()) != PrimitiveTypes.Void && !TypeUtils.areEquivalent(returnType, body.getType()) && !returnType.isAssignableFrom(body.getType())) {
            throw Error.expressionTypeDoesNotMatchReturn(body.getType(), returnType);
        }
    }

    private static void validateGoto(LabelTarget target, Expression value, String targetParameter, String valueParameter) {
        VerifyArgument.notNull(target, targetParameter);
        if (value == null && target.getType() != PrimitiveTypes.Void) {
            throw Error.labelMustBeVoidOrHaveExpression();
        }
    }

    private static void validateGotoType(Type expectedType, Expression value, String valueParameter) {
        Expression.verifyCanRead(value, valueParameter);
        if (expectedType != PrimitiveTypes.Void && !TypeUtils.areReferenceAssignable(expectedType, value.getType())) {
            throw Error.expressionTypeDoesNotMatchLabel(value.getType(), expectedType);
        }
    }

    private static void validateTryAndCatchHaveSameType(Type type, Expression tryBody, ReadOnlyList<CatchBlock> handlers) {
        block7: {
            block6: {
                if (type == null) break block6;
                if (type == PrimitiveTypes.Void) break block7;
                if (!TypeUtils.areReferenceAssignable(type, tryBody.getType())) {
                    throw Error.argumentTypesMustMatch();
                }
                int n = handlers.size();
                for (int i = 0; i < n; ++i) {
                    CatchBlock cb = handlers.get(i);
                    if (TypeUtils.areReferenceAssignable(type, cb.getBody().getType())) continue;
                    throw Error.argumentTypesMustMatch();
                }
                break block7;
            }
            if (tryBody == null || tryBody.getType() == PrimitiveTypes.Void) {
                int n = handlers.size();
                for (int i = 0; i < n; ++i) {
                    Expression catchBody = handlers.get(i).getBody();
                    if (catchBody == null || catchBody.getType() == PrimitiveTypes.Void) continue;
                    throw Error.bodyOfCatchMustHaveSameTypeAsBodyOfTry();
                }
            } else {
                Type<?> tryType = tryBody.getType();
                int n = handlers.size();
                for (int i = 0; i < n; ++i) {
                    Expression catchBody = handlers.get(i).getBody();
                    if (catchBody != null && TypeUtils.areEquivalent(catchBody.getType(), tryType)) continue;
                    throw Error.bodyOfCatchMustHaveSameTypeAsBodyOfTry();
                }
            }
        }
    }

    private static void validateSwitchCaseType(Expression caseBody, boolean customType, Type resultType, String parameterName) {
        if (customType) {
            if (resultType != PrimitiveTypes.Void && !TypeUtils.areReferenceAssignable(resultType, caseBody.getType())) {
                throw Error.argumentTypesMustMatch();
            }
        } else if (!TypeUtils.hasIdentityPrimitiveOrBoxingConversion(resultType, caseBody.getType())) {
            throw Error.allCaseBodiesMustHaveSameType();
        }
    }

    private static FieldInfo findField(Type declaringType, String fieldName, Set<BindingFlags> flags) {
        MemberList<MemberInfo> members = declaringType.findMembers(MemberType.fieldsOnly(), flags, Type.FilterNameIgnoreCase, fieldName);
        if (members == null || members.size() == 0) {
            throw Error.fieldDoesNotExistOnType(fieldName, declaringType);
        }
        return (FieldInfo)members.get(0);
    }

    private static MethodInfo findMethod(Type type, String methodName, TypeList typeArguments, ExpressionList<? extends Expression> arguments, Set<BindingFlags> flags) {
        MemberList<MemberInfo> members = type.findMembers(MemberType.methodsOnly(), flags, Type.FilterNameIgnoreCase, methodName);
        if (members == null || members.size() == 0) {
            throw Error.methodDoesNotExistOnType(methodName, type);
        }
        ArrayList<MethodInfo> candidates = new ArrayList<MethodInfo>(members.size());
        int n = members.size();
        for (int i = 0; i < n; ++i) {
            MethodInfo appliedMethod = Expression.applyTypeArgs((MethodInfo)members.get(i), typeArguments);
            if (appliedMethod == null) continue;
            candidates.add(appliedMethod);
        }
        Type[] parameterTypes = new Type[arguments.size()];
        int n2 = arguments.size();
        for (int i = 0; i < n2; ++i) {
            parameterTypes[i] = arguments.get(i).getType();
        }
        MethodInfo result = (MethodInfo)Type.DefaultBinder.selectMethod(flags, candidates.toArray(new MethodBase[candidates.size()]), parameterTypes);
        if (result == null) {
            throw Error.methodWithArgsDoesNotExistOnType(methodName, type);
        }
        return result;
    }

    private static int findBestMethod(MemberList<?> methods, TypeList typeArgs, ExpressionList<? extends Expression> arguments) {
        int count = 0;
        int bestMethodIndex = -1;
        MemberInfo bestMethod = null;
        int n = methods.size();
        for (int i = 0; i < n; ++i) {
            MethodInfo method = Expression.applyTypeArgs((MethodInfo)methods.get(i), typeArgs);
            if (method == null || !Expression.isCompatible(method, arguments)) continue;
            if (bestMethod == null || !bestMethod.isPublic() && method.isPublic()) {
                bestMethodIndex = i;
                bestMethod = method;
                count = 1;
                continue;
            }
            if (bestMethod.isPublic() != method.isPublic()) continue;
            ++count;
        }
        if (count > 1) {
            return -2;
        }
        return bestMethodIndex;
    }

    private static boolean isCompatible(MethodBase m, ExpressionList<? extends Expression> arguments) {
        VerifyArgument.noNullElements(arguments, "arguments");
        ParameterList parameters = m.getParameters();
        if (parameters.size() != arguments.size()) {
            return false;
        }
        int n = arguments.size();
        for (int i = 0; i < n; ++i) {
            Expression argument = arguments.get(i);
            Type<?> argumentType = argument.getType();
            Type<?> parameterType = ((ParameterInfo)parameters.get(i)).getParameterType();
            if (TypeUtils.areReferenceAssignable(parameterType, argumentType) || TypeUtils.isSameOrSubType(Type.of(LambdaExpression.class), parameterType) && parameterType.isAssignableFrom(argument.getType())) continue;
            return false;
        }
        return true;
    }

    private static MethodInfo applyTypeArgs(MethodInfo m, TypeList typeArgs) {
        TypeList genericParameters;
        if (typeArgs == null || typeArgs.size() == 0) {
            if (!m.isGenericMethodDefinition()) {
                return m;
            }
        } else if (m.isGenericMethodDefinition() && (genericParameters = m.getGenericMethodParameters()).size() == typeArgs.size()) {
            int n = genericParameters.size();
            for (int i = 0; i < n; ++i) {
                if (((Type)genericParameters.get(i)).isAssignableFrom((Type)typeArgs.get(i))) continue;
                return null;
            }
            return m.makeGenericMethod(typeArgs);
        }
        return null;
    }

    static Type<?> performBinaryNumericPromotion(Type leftType, Type rightType) {
        if (leftType == PrimitiveTypes.Double || rightType == PrimitiveTypes.Double) {
            return PrimitiveTypes.Double;
        }
        if (leftType == PrimitiveTypes.Float || rightType == PrimitiveTypes.Float) {
            return PrimitiveTypes.Float;
        }
        if (leftType == PrimitiveTypes.Long || rightType == PrimitiveTypes.Long) {
            return PrimitiveTypes.Long;
        }
        if (TypeUtils.isArithmetic(leftType) || TypeUtils.isArithmetic(rightType)) {
            return PrimitiveTypes.Integer;
        }
        return leftType;
    }

    private static Type validateCoalesceArgumentTypes(Type left, Type right) {
        Type<?> leftStripped = TypeUtils.getUnderlyingPrimitive(left);
        if (left.isPrimitive()) {
            throw Error.coalesceUsedOnNonNullableType();
        }
        if (TypeUtils.isAutoUnboxed(left) && TypeUtils.hasReferenceConversion(right, leftStripped)) {
            return leftStripped;
        }
        if (TypeUtils.hasReferenceConversion(right, left)) {
            return left;
        }
        if (TypeUtils.isAutoUnboxed(left) && TypeUtils.hasReferenceConversion(leftStripped, right)) {
            return right;
        }
        throw Error.argumentTypesMustMatch();
    }

    static {
        Class<?>[] declaredClasses;
        Class<?> unmodifiableListClass = null;
        for (Class<?> clazz : declaredClasses = Collections.class.getDeclaredClasses()) {
            if (!clazz.getName().equals("UnmodifiableCollection")) continue;
            unmodifiableListClass = clazz;
            break;
        }
        UNMODIFIABLE_LIST_CLASS = unmodifiableListClass;
        StaticMemberBindingFlags = BindingFlags.set(BindingFlags.Static, BindingFlags.Public, BindingFlags.NonPublic, BindingFlags.FlattenHierarchy);
        InstanceMemberBindingFlags = BindingFlags.set(BindingFlags.Instance, BindingFlags.Public, BindingFlags.NonPublic, BindingFlags.FlattenHierarchy);
    }
}

