﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.maint, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="maint">
<head runat="server">
    <title>系统维护</title><meta http-equiv="X-UA-Compatible" content="IE=edge" /><meta name="viewport" content="width=device-width,initial-scale=1">
</head>
<body>
    <form id="form1" runat="server">
    <asp:ScriptManager ID="s1" runat="server" AsyncPostBackTimeout="900" EnablePageMethods="true" OnAsyncPostBackError="AsyncError">
        <CompositeScript Path="js/msajax.js" ScriptMode="Release">
            <Scripts>
                <asp:ScriptReference Name="WebForms.js" Assembly="System.Web" /><asp:ScriptReference Name="MicrosoftAjax.js" /><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" />
            </Scripts>
        </CompositeScript>
    </asp:ScriptManager>
    <div id="tabs" class="ui-tabs noborder">
        <ul>
            <li><a href="#clear">系统清理</a></li>
            <li><a href="#bak">备份和还原</a></li>
            <li><a href="#dev">系统开发</a></li>
            <li><a href="#other">其它</a></li>
        </ul>
        <div id="clear">
            <div id="loading1" class="hide loading mtop_l"><div class="loadbar"><div></div><div></div><div></div><div></div><div></div></div></div>
            <div id="options">
                <ul>
                    <li>清理： <asp:CheckBox ID="cbCleanFiles" runat="server" Text="垃圾文件" /></li>
                    <li>　　　 <asp:CheckBox ID="cbLog" runat="server" Text="日志文件" /></li>
                    <li>　　　 <asp:CheckBox ID="cbDelThumbs" runat="server" Text="缩略图缓存" /></li>
                    <li class="middle">　　　 <asp:CheckBox ID="cbDelInactiveAnonys" runat="server" Checked="true" Text="匿名用户" /><i title="说明" onclick="What('anonyUser')" class="what"></i></li>
                </ul>
                <div class="center mtop_x">
                    <asp:Button ID="btnExe" runat="server" OnClick="ExeClean" OnClientClick="return doClean();" CssClass="btn" Text="开始清理" />　　
                </div>
            </div>
        </div>
        <div id="bak">
            <div id="loading2" class="hide loading mtop_l"><div class="loadbar"><div></div><div></div><div></div><div></div><div></div></div></div>
            <asp:UpdatePanel ID="upBackup" UpdateMode="conditional" RenderMode="Block" class="vbottom" runat="server">
            <ContentTemplate>
                <asp:Button ID="btnBackup" ToolTip="生成并下载系统备份文件" OnClick="BackupAll" OnClientClick="setUpg(true,'loading2','upBackup');" CssClass="btn" runat="server" Text="备份" />&nbsp;
                <input type="button" value="自动备份…" class="btn" onclick="ShowPop('ab_popup');" />
                <label class="btn" title="选择备份文件来还原系统">还原<input id="fileToUpload" name="fileToUpload" type="file" onchange="return ajaxFileUpload();" /></label>
                <input type="button" runat="server" id="btnRestoreDb" visible="false" value="还原数据库" class="btn" onclick="return askRestore();" onserverclick="OnlyRestoreDB" />
                <input type="button" onclick="return showHelp('manualBakRes');" value="手工备份/还原" class="btn" />
            </ContentTemplate>
                <Triggers><asp:AsyncPostBackTrigger ControlID="btnDb" EventName="Click" /></Triggers>
            </asp:UpdatePanel>
        </div>
        <div id="dev">
            <div id="btns4">
                <asp:Button ID="btnJs" runat="server" OnClick="ShowPluginJs" Text="编辑外挂脚本" CssClass="btn" />
                <asp:Button ID="btnCss" runat="server" OnClick="ShowPluginCss" Text="编辑外挂样式" CssClass="btn" />
                <asp:Button ID="btnApi" runat="server" OnClick="ShowApiDemo" Text="编辑API演示页面" CssClass="btn" />
                <input type="button" onclick="return toPopup('codes.aspx', 520);" value="模板代码表" class="btn" />
                <input runat="server" id="btnResource" type="button" onclick="window.open('https://landian.cc/content.aspx?p=resource');" value="在线资源下载" class="btn" />
            </div>
        </div>
        <div id="other">
            <div id="loading3" class="hide loading mtop_l"><div class="loadbar"><div></div><div></div><div></div><div></div><div></div></div></div>
            <div id="btns3">
            <asp:Button ID="btnRestartApp" OnClick="RestartApp" runat="server" CssClass="btn" OnClientClick="setUpg(true,'loading3','btns3');" Text="重新启动系统" />
            <asp:Button ID="btnCloseSys" OnClick="CloseSystem" runat="server" Text="关闭系统" CssClass="btn" ToolTip="停止系统的运行。&#13;注：关闭后只能通过移除系统的 app_offline.htm 文件来恢复运行" OnClientClick="return confirm('关闭系统后只能通过移除系统的 app_offline.htm 文件来恢复运行！\n确定要关闭系统吗？');" />
            <asp:Button ID="btnSwitchDatabase" runat="server" OnClick="SwitchDatabase" OnClientClick="return confirm('这相当于切换到另一套独立的系统，当前的用户和数据不会迁移。\n\n确定要切换数据库吗？');" CssClass="btn" Text="切换数据库" />
            <asp:Button ID="btnDbZip" runat="server" OnClick="ZipDatabase" OnClientClick="return toZipDb();" CssClass="btn" Text="压缩数据库" />
            <asp:Button ID="viewSysLog" runat="server" Text="查看系统日志" CssClass="btn" />
            <asp:Button ID="btnDb" ToolTip="点击下载系统数据库及调试信息" OnClick="BackupDB" OnClientClick="setUpg(true,'loading3','btns3');" CssClass="btn" runat="server" Text="下载调试数据" />
            </div>
        </div>
    </div>
    <ims:Pop runat="server" ID="ab" Width="420" OnOkClick="SaveAutoBackup" OnOkClientClick="return preSave();" HideOnOkClientClick="false" HelpSubject="autoBackup">
        <ContentTemplate>
            <asp:CheckBox runat="server" ID="cbAutoBackup" onclick="autoBackupToggled();" Text="启用自动备份" />
            <div class="sepline2"></div>
            <div style="padding-left:15px">
            存储位置： <asp:TextBox runat="server" ID="tbTarget" Width="75%" ToolTip="输入服务器上的备份文件存储路径，或网络共享文件夹路径"></asp:TextBox><br />
            备份时机： <asp:TextBox runat="server" ID="tbStart" Width="115" onfocus="WdatePicker({el:this,dateFmt:'yyyy-MM-dd HH:mm'});"></asp:TextBox> 起，每 <asp:TextBox runat="server" ID="tbFqcy" Width="24" Text="1"></asp:TextBox> <asp:DropDownList runat="server" ID="ddlTimeUnit"></asp:DropDownList> 一次
            <div class="sepline2"></div>
            <asp:CheckBox runat="server" ID="cbDbOnly" Text="仅备份数据库" /><br />
            <asp:CheckBox runat="server" ID="cbKeep" Text="仅保留最近" /><asp:DropDownList runat="server" ID="ddlKeep">
                    <asp:ListItem Value="1">1</asp:ListItem>
                    <asp:ListItem Value="2">2</asp:ListItem>
                    <asp:ListItem Value="3">3</asp:ListItem>
                    <asp:ListItem Selected="True" Value="5">5</asp:ListItem>
                    <asp:ListItem Value="10">10</asp:ListItem>
                    <asp:ListItem Value="20">20</asp:ListItem>
                    <asp:ListItem Value="50">50</asp:ListItem>
                    <asp:ListItem Value="100">100</asp:ListItem>
                    <asp:ListItem Value="500">500</asp:ListItem>
                </asp:DropDownList> 个备份　<a href="###" onclick="__doPostBack('lbShowBaks', '');">查看备份文件</a>
            </div>
            <div class="sepline2 mtop_l"></div>
            <div class="gray infoico">服务器 <asp:Label runat="server" ID="account"></asp:Label> 帐户须对存储位置有"修改"权限。</div>
        </ContentTemplate>
    </ims:Pop>
    <ims:Pop runat="server" ID="baks" ShowOkButton="false" CanelButtonText="关闭" Width="520">
        <ContentTemplate>
            <div runat="server" id="msg"></div>
            <div id="container" runat="server">
                <table class="hr fixedLayout">
                    <tr><td runat="server" id="fileCount">文件</td><td style="width:85px">时间</td><td class="opr" style="width:64px">操作</td></tr>
                    <asp:Repeater runat="server" ID="rptBaks" OnItemCommand="BakItemCommand">
                        <ItemTemplate>
                            <tr>
                                <td class="ell"><%# Eval("Name") %></td>
                                <td class="ell"><%# ims.Time.getShortTimeText(((System.IO.FileInfo)Container.DataItem).LastWriteTime) %></td>
                                <td class="opr">
                                    <asp:LinkButton ID="ibDel" OnClientClick="return confirm('确定删除该文件吗？');" CommandArgument='<%# Eval("FullName") %>' ToolTip="删除" CssClass="f-bin red fb2" CommandName="del" runat="server"></asp:LinkButton>
                                    <asp:LinkButton ID="ibRes" CommandArgument='<%# Eval("FullName") %>' ToolTip="还原" CssClass="f-reply1 lightgreen fb3" CommandName="restore" runat="server"></asp:LinkButton>
                                    <asp:LinkButton ID="ibDown" CommandArgument='<%# Eval("FullName") %>' ToolTip="下载" CssClass="f-dl blue fb3" CommandName="download" runat="server"></asp:LinkButton>
                                </td>
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                </table>
            </div>
        </ContentTemplate>
    </ims:Pop>
    <ims:Pop runat="server" ID="js" Title="编辑外挂脚本" Width="585" OnOkClick="SaveJs" OnOkClientClick="UpdateEditorElement();" HideOnOkClientClick="false" OkButtonText="保存" CanelButtonText="关闭" HelpSubject="jsplugin">
        <ContentTemplate>
            <asp:TextBox runat="server" TextMode="MultiLine" Rows="12" ID="tbJs"></asp:TextBox>
            <div class="note">外挂脚本用于对系统进行一些特殊处理，其基于jQuery框架，每个页面都会载入运行。</div>
        </ContentTemplate>
    </ims:Pop>
    <ims:Pop runat="server" ID="css" Title="编辑外挂样式" Width="585" OnOkClick="SaveCss" OnOkClientClick="UpdateEditorElement();" HideOnOkClientClick="false" OkButtonText="保存" CanelButtonText="关闭" HelpSubject="cssplugin">
        <ContentTemplate>
            <asp:TextBox runat="server" TextMode="MultiLine" Rows="12" ID="tbCss"></asp:TextBox>
            <div class="note">外挂样式用于对系统进行自定义样式设置，每个页面都会载入。</div>
        </ContentTemplate>
    </ims:Pop>
    <ims:Pop runat="server" ID="apidemo" Title="编辑API演示页面" Width="640" OnOkClick="SaveApiDemo" CustomButtonA_OnClick="window.open('api_demo.htm');" CustomButtonA_Text="打开API演示页面" OnOkClientClick="UpdateEditorElement();" OkButtonText="保存" HelpSubject="api">
        <ContentTemplate>
            <asp:TextBox runat="server" TextMode="MultiLine" Rows="15" ID="tbApiDemo"></asp:TextBox>
        </ContentTemplate>
    </ims:Pop>
    <asp:LinkButton runat="server" ID="lbShowBaks" CssClass="hide" OnClick="ShowBaks"></asp:LinkButton>
    <script src="js/comm.js"></script><script src="js/maint.js"></script>
    </form>
</body>
</html>