﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.guide, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="guide">
<head runat="server">
    <title>向导</title><meta http-equiv="X-UA-Compatible" content="IE=edge" /><meta name="viewport" content="width=device-width,initial-scale=1">
</head>
<body style="margin:1.5em 2.5em 2em">
    <form id="form1" runat="server">
        <asp:ScriptManager runat="server" ID="s1" OnAsyncPostBackError="AsyncError">
            <CompositeScript Path="js/msajax.js" ScriptMode="Release">
                <Scripts>
                    <asp:ScriptReference Name="WebForms.js" Assembly="System.Web" /><asp:ScriptReference Name="MicrosoftAjax.js" /><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" />
                </Scripts>
            </CompositeScript>
        </asp:ScriptManager>
        <div id="tabs" class="ui-tabs noborder">
            <ul id="ulNav">
                <li runat="server" id="liWelcome"><a href="#welcome">欢迎</a></li>
                <li runat="server" id="liTemplet"><a href="#templet">建立模板</a></li>
                <li><a href="#input">录入</a></li>
                <li><a href="#view">浏览</a></li>
                <li><a href="#search">搜索</a></li>
                <li runat="server" id="liPower"><a href="#userpower">权限管理</a></li>
                <li runat="server" id="liAdv"><a href="#advanced">高级</a></li>
            </ul>
            <div id="welcome" runat="server">
                <p class="mbottom_m">这是一个灵活的管理软件自定义平台，通过您简单的设计，可实现各种数据信息管理、工作流管理等。您可通过以下途径快速入门：</p>
                <ul>
                    <li>三分钟入门： <a href="#" onclick="return showHelp('three');">图文版</a><span runat="server" id="crAbout1">、<a href="https://landian.cc/content.aspx?p=demo&sidebar=0" target="_blank">视频版</a></span>；</li>
                    <li runat="server" id="crAbout2"><a href="https://landian.cc/demo" target="_blank">查看在线演示</a>；</li>
                    <li runat="server" id="crAbout3"><a href="https://landian.cc" target="_blank">进入官方网站，获取技术支持</a>；</li>
                    <li>跟随本向导，开始建立你自己的管理系统！</li>
                </ul>
                <br />
                <div class="zoneTitle"><i class="infoico"></i>提示</div>
                <ul>
                    <li>任何时候，可点击左侧的"实时帮助"，查看当前操作相关的帮助信息；</li>
                    <li>关于如何从其它电脑访问等问题，请看<a href="#" onclick="return showHelp('faq');">常见问题解答</a>。</li>
                </ul>
            </div>
            <div id="templet" runat="server">
                <p>打开<asp:HyperLink ID="HyperLink5" NavigateUrl="templets.aspx" runat="server">设计中心</asp:HyperLink>，右键 - 添加模板，输入名称并自动进入模板设计界面后，逐个添加需要的字段，并选择适当的数据类型和选项。</p>
                <br />
                <div class="zoneTitle"><i class="infoico"></i>术语</div>
                <ul>
                    <li><b>模板</b>任何要管理的事物都是以模板为基础的。模板定义了其各种属性，如名称、规格、重量等，它们被称为"字段"。系统所管理的数据都依存于特定的模板，其中的每一条信息称为一条"记录"。</li>
                </ul>
                <div runat="server" id="importTemplets">
                    <br />
                    <div class="zoneTitle"><i class="infoico"></i>提示</div>
                    <ul>
                        <li>您也可以导入系统预置的模板来观摩或应用：
                        <asp:UpdatePanel runat="server" ID="up" RenderMode="Inline">
                            <ContentTemplate>
                                <asp:DropDownList AutoPostBack="true" OnSelectedIndexChanged="ApplySolution" runat="server" ID="ddlTemplets"></asp:DropDownList>
                            </ContentTemplate>
                        </asp:UpdatePanel>
                        </li>
                    </ul>
                </div>
                <br />
                <div class="zoneTitle"><i class="f-link blue"></i>参考</div>
                <p><a href="#" onclick="return showHelp('templets');">关于模板</a>&nbsp;&nbsp;&nbsp;<a href="#" onclick="return showHelp('templet');">模板设计</a></p>
            </div>
            <div id="input">
                <p class="mbottom_m">建立模板后，即可录入数据：</p>
                <ul>
                    <li>从左侧栏顶部导航区 <i class="f-add green"></i>标签下点击要录入的项；</li>
                    <li>或进入"<%= ims.Sys.DataCenterText %>"，在模板上点右键 - 添加。</li>
                </ul>
                <br />
                <div class="zoneTitle"><i class="infoico"></i>提示</div>
                <ul>
                    <li>可通过Excel导入数据：在录入页面，右击"导入Excel"，可下载Excel表单文件，再在其中录入数据后，点击"导入Excel"，选定该文件导入；</li>
                    <li>也可以点击"导入"，来载入某条相似的记录再作修改，以提高效率。</li>
                </ul>
            </div>
            <div id="view">
                <p class="mbottom_m">录入后，即可浏览数据：</p>
                <ul>
                    <li>从左侧栏顶部导航区 <i class="f-sanjiao skyblue"></i>标签下点击要浏览的项；</li>
                    <li>或进入"<%= ims.Sys.DataCenterText %>"，点击要浏览的项。</li>
                    <li>或从左侧栏打开目录，浏览存放于该目录的数据。</li>
                </ul>
                <br />
                <div class="zoneTitle"><i class="infoico"></i>术语</div>
                <ul>
                    <li><b>目录</b>目录是一种对数据分类存放的组织形式。同一模板的记录可能分布在不同目录中，或不放到任何目录中。</li>
                    <li><b>视图</b>视图，是数据的一种表现形式，不同的视图可以不同形式来展现同一批数据。</li>
                </ul>
                <br />
                <div class="zoneTitle"><i class="infoico"></i>提示</div>
                <ul>
                    <li>可在模板设置中指定默认目录、默认视图、默认排序方式等；</li>
                    <li>系统会缓存最近一次浏览的数据，可随时切换不同视图来查看。</li>
                </ul>
            </div>
            <div id="search">
                <p class="mbottom_m">可以通过以下方式搜索数据：</p>
                <ul>
                    <li>在顶栏点击"搜索"图标，或从右侧搜索框搜索；</li>
                    <li>从左侧栏导航区 <i class="f-sou green"></i>标签下点击要搜索的项；</li>
                    <li>进入"<%= ims.Sys.DataCenterText %>"，在模板上点右键 - 搜索。</li>
                </ul>
                <br />
                <div class="zoneTitle"><i class="infoico"></i>提示</div>
                <ul>
                    <li>在搜索页面，可将设置好的搜索条件保存为快捷方式或过滤器，以后可直接打开；</li>
                    <li>快捷方式仅本人可见，过滤器所有用户可见。</li>
                </ul>
                <br />
                <div class="zoneTitle"><i class="f-link blue"></i>相关链接</div>
                <p><a href="dataHome.aspx">搜索</a>&nbsp;&nbsp;&nbsp;<a href="advSearch.aspx">高级搜索</a>&nbsp;&nbsp;&nbsp;<a href="templets.aspx?mode=data"><%= ims.Sys.DataCenterText %></a></p>
            </div>
            <div id="userpower" runat="server">
                <p>用户的权限由其角色决定。根据用户类别建立相应的角色，再为角色设置权限，最后设置用户的角色，就完成了权限设置。</p>
                <br />
                <div class="zoneTitle"><i class="infoico"></i>术语</div>
                <ul>
                    <li><b>用户</b>指系统的一个登录帐户。用户可以由管理员添加，也可以通过注册页面自行注册。</li>
                    <li><b>角色</b>角色，是具有相同权限的一组或一类用户的统称，如公司领导、员工、供应商等。</li>
                </ul>
                <br />
                <div class="zoneTitle"><i class="infoico"></i>提示</div>
                <ul>
                    <li>模板建立后，只有创建者或管理员有权限。要让其他人可添加或浏览数据，需要为角色授权（设计中心，模板右键 - 权限）；</li>
                    <li>浏览权限和数据保密级别是相对应的，分别有0～10共11个级别。用户看不到保密级别高于浏览权限级别的内容，除非有编辑权限。</li>
                </ul>
                <br />
                <div class="zoneTitle"><i class="f-link blue"></i>相关链接</div>
                <p><a href="users.aspx">用户管理</a>&nbsp;&nbsp;&nbsp;<a href="roles.aspx">角色管理</a>&nbsp;&nbsp;&nbsp;<a href="#" onclick="return showHelp('power');">更多帮助</a></p>
            </div>
            <div id="advanced" runat="server">
                <ul>
                    <li><b>输入提示功能</b>设置了输入提示的字段，输入时会从指定数据源产生候选列表；还可实现像超市收银台那样输入编码自动填充名称。</li>
                    <li><b>查询类型字段</b>查询类型的字段，在录入数据时不会出现，它是在浏览时自动按预设条件取值的。</li>
                    <li><b>建立主从关系的模板</b>如订单与订单明细，就是一对主从模板，一个订单会对应多条商品明细记录。建立主从关系后，可以更方便地管理数据。</li>
                    <li><b>自定义版式</b>录入和浏览数据时的各个视图页面，都可以按自己的想法自定义界面版式。</li>
                    <li><b>自定义操作</b>可添加一个按钮，点击时对表单数据执行预定的修改动作（如改变状态）。</li>
                    <li><b>生成</b>利用现有数据，轻松生成新的数据。</li>
                    <li><b>工作流</b>通过为模板创建流程，可以规范业务处理逻辑、顺序和权限。参考：<a href="#" onclick="return showHelp('flow',true);">流程设计</a>。</li>
                    <li><b>微信接入</b>可设置接入企业微信或微信公众号，从而通过微信查询数据或上传照片。</li>
                    <li><b>拖动排版、右键操作、就地编辑、回车保存等特性</b>在使用中会逐渐了解。</li>
                </ul>
                <br />
                <div class="zoneTitle"><i class="infoico"></i>提示</div>
                <ul>
                    <li>建议阅读：<a href="#" onclick="return showHelp('faq');">常见问题解答</a>。</li>
                </ul>
            </div>
        </div>

        <div class="center mtop_x">
            <input type="button" class="btn" value="上一步" style="display:none" onclick="SkipTo(false);" id="btnPre" />
            <input type="button" class="btn" value="下一步" onclick="SkipTo(true);" id="btnNext" />
            <input type="button" class="btn hide" value="开始设计" onclick="location = 'templets.aspx';" id="btnStart" />
        </div>
    <script src="js/comm.js"></script>
    <script>
        $(function () {
            $('#tabs').tabs({ activate: SwitchTo }).fadeIn(250);
            var prm = Sys.WebForms.PageRequestManager.getInstance();
            prm.add_initializeRequest(function () { $("#ddlTemplets").prop("disabled", true); });
            prm.add_endRequest(function () { $("#ddlTemplets").prop("disabled", false); });
        });
        function SkipTo(toNext) {
            var curIndex = $('#tabs').tabs("option", "active");
            curIndex = toNext ? Math.min($("#ulNav li").length - 1, curIndex + 1) : Math.max(0, curIndex - 1);
            SwitchTo(curIndex);
            scrollToTop();
        }
        function SwitchTo(curIndex) {
            if (!isNaN(curIndex)) {
                $('#tabs').tabs("option", "active", curIndex);
            } else {
                curIndex = $('#tabs').tabs("option", "active");
            }
            $("#btnPre").css("display", curIndex > 0 ? "" : "none");
            $("#btnNext").css("display", curIndex < $("#ulNav li").length - 1 ? "" : "none");
            $("#btnStart").toggleClass("hide", !$("#advanced").is(":visible"));
        }
    </script>
    </form>
</body>
</html>