﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.chart, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="chart">
<head runat="server"><title></title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" /><meta name="viewport" content="width=device-width,initial-scale=1">
    <script src="js/comm.js"></script><script src="js/echart.js"></script><script src="js/chart.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <asp:ScriptManager ID="sm" runat="server" AsyncPostBackTimeout="250" OnAsyncPostBackError="AsyncError">
        <CompositeScript Path="js/msajax.js" ScriptMode="Release">
            <Scripts>
                <asp:ScriptReference Name="WebForms.js" Assembly="System.Web" /><asp:ScriptReference Name="MicrosoftAjax.js" /><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" />
            </Scripts>
        </CompositeScript>
    </asp:ScriptManager>
    <asp:HiddenField runat="server" ID="sorted" />
    <div id="echart"></div>
    <asp:UpdatePanel ID="upSetting" runat="server" OnPreRender="AddInitScript" UpdateMode="Conditional">
        <ContentTemplate>
            <fieldset runat="server" id="setzone"><legend>类型：<asp:DropDownList runat="server" ID="ddlType">
                <asp:ListItem Value="bar">柱状图</asp:ListItem>
                <asp:ListItem Value="line">折线图</asp:ListItem>
                <asp:ListItem Value="pie">环形图</asp:ListItem>
                <asp:ListItem Value="funnel">漏斗图</asp:ListItem>
                <asp:ListItem Value="scatter">散点图</asp:ListItem>
	            </asp:DropDownList></legend>
                <div class="optzone">
                    <div class="inlineBlock mr" title="设置对数据如何分组（分组后才能统计各组的值）">
                        分组：<asp:DropDownList Runat="server" ToolTip="指定按什么字段来分组统计" ID="ddlXs"></asp:DropDownList>
                        <span id="seps"><asp:DropDownList runat="server" ID="ddlGroupby"><asp:ListItem Selected="True" Value="All">按所有值分组</asp:ListItem><asp:ListItem Value="Auto">自动分组</asp:ListItem><asp:ListItem Value="Specified">手动分组</asp:ListItem></asp:DropDownList>
                        <asp:DropDownList runat="server" ID="ddlTimeSpan"></asp:DropDownList>
                        <asp:TextBox ID="SepValues" Width="200" runat="server"></asp:TextBox></span>
                    </div>
                    <div class="inlineBlock" id="divys">
                        统计：<asp:CheckBoxList runat="server" ID="cblYs" ToolTip="拖动调序" RepeatLayout="Flow" RepeatDirection="Horizontal"></asp:CheckBoxList><span class="bold" id="ell">…</span>
                    </div>
                    <div class="mtop_s">
                       计算：<asp:DropDownList Runat="server" ID="ddlStatMode" CssClass="mr">
                        <asp:ListItem Value="sum">合计</asp:ListItem>
                        <asp:ListItem Value="avg">平均值</asp:ListItem>
                        <asp:ListItem Value="max">最大值</asp:ListItem>
                        <asp:ListItem Value="min">最小值</asp:ListItem>
                        <asp:ListItem Value="var">方差</asp:ListItem>
                        <asp:ListItem Value="stdev">标准偏差</asp:ListItem>
                        <asp:ListItem Value="count">计数</asp:ListItem>
                        </asp:DropDownList>
                        排序：<asp:DropDownList Runat="server" ID="ddlSortMode">
                        <asp:ListItem Value="">无</asp:ListItem>
                        <asp:ListItem Value="ASC">升序</asp:ListItem>
                        <asp:ListItem Selected="True" Value="DESC">降序</asp:ListItem>
                        <asp:ListItem Value="_ASC">类目升序</asp:ListItem>
                        <asp:ListItem Value="_DESC">类目降序</asp:ListItem>
                        </asp:DropDownList>
                    </div>
                </div>
            </fieldset>
        </ContentTemplate>
    </asp:UpdatePanel>
    <asp:UpdatePanel ID="upBtnArea" runat="server" UpdateMode="Conditional" ChildrenAsTriggers="false" class="center mtop_x">
        <ContentTemplate>
	        <asp:Button ID="btnBuild" runat="server" Text="生成图表" OnClick="Build" OnClientClick="toBuild();" CssClass="btn" />
            <input type="button" runat="server" ID="btnManage" onclick="return showEleMenu('#btnManage','#chartList');" value="图表操作" onserverclick="ManageCharts" class="btn" />
            <input type="button" runat="server" id="btnExport" onclick="return toExportAs('#echart');" value="导出" class="btn" />
	        <input type="button" runat="server" id="btnPrint" class="btn pconly" onclick="toPrint(event);" value="打印" />
        </ContentTemplate>
    </asp:UpdatePanel>

    <ims:Pop runat="server" ID="m" ShowOkButton="false" HideOnOkClientClick="false" CanelButtonText="关闭" HelpSubject="chartManage" Title="管理图表">
        <ContentTemplate>
            <div runat="server" id="allCharts">
                <table class="normal center">
                    <tr><th>图表</th><th style="width:32px">默认</th><th style="width:32px">更名</th><th style="width:32px">删除</th></tr>
                    <asp:PlaceHolder runat="server" ID="phCharts"></asp:PlaceHolder>
                </table>
            </div>
            <fieldset class="mtop_n mbottom_s"><legend>默认图表规则</legend>
                <div class="padbox">
                    <ol runat="server" id="olRules" class="olRules"></ol>
                    <div class="right"><a href="#" id="aAddRule" runat="server" onserverclick="ToAddRule">添加规则</a></div>
                </div>
            </fieldset>
            <asp:CheckBox runat="server" ID="cbDisChange" Text="禁止普通用户切换图表" onclick="switchChange();" />
        </ContentTemplate>
    </ims:Pop>
    <ims:Pop runat="server" ID="rule" OnClientUpdated="setTimeout(initRule,0);" Width="410" OnOkClick="SaveRule" HideOnOkClientClick="false">
        <ContentTemplate>
            <table class="fixedLayout">
                <tr><td class="ruleKey">指定角色：</td><td><asp:TextBox runat="server" ID="tbRoles" TextMode="MultiLine" Rows="3" Width="98%" acfid="RoleName" chars=";；、,，" ToolTip="输入角色名。多项之间以逗号、分号或顿号分隔"></asp:TextBox></td></tr>
                <tr><td class="ruleKey">默认图表：</td><td><asp:DropDownList runat="server" ID="ddlAll"></asp:DropDownList></td></tr>
            </table>
        </ContentTemplate>
    </ims:Pop>
    <asp:UpdatePanel ID="chartList" runat="server" UpdateMode="Conditional" class="menu" />
    </form>
</body>
</html>