#pragma once
#include <vector>
#include "ZJIMDef.h"

// Ĳӿڶ

// 
typedef struct tagEIMSysMgrPluginInfo
{
	TCHAR			szPluginGuid[33];
	TCHAR			szPluginName[32];
	TCHAR			szPluginDesc[256];
	TCHAR			szPluginComp[32];
	TCHAR			szPluginUrl[64];
}EIMSysMgrPluginInfo, *LPEIMSysMgrPluginInfo;

typedef BOOL (*SYSMGR_PLUGININITIALIZE)(EIMSysMgrPluginInfo& stPluginInfo);
typedef BOOL (*SYSMGR_PLUGINUNINITIALIZE)();
typedef BOOL (*SYSMGR_PLUGINMSG)(UINT message, WPARAM wParam, LPARAM lParam);

#define SysMgr_PluginInitialize_Func_Name			_T("SysMgr_PluginInitialize")
#define SysMgr_PluginUninitialize_Func_Name			_T("SysMgr_PluginUninitialize")
#define SysMgr_PluginMsg_Func_Name					_T("SysMgr_PluginMsg")


#define SysMgrHostMsg_ShowView			0x01
#define SysMgrHostMsg_HideView			0x02
#define SysMgrHostMsg_OnSize			0x03


typedef struct tagEIMStaffBriefInfo
{
	CString		m_strStaffID;		// ԱID
	CString		m_strName;			// 
	CString		m_strSignature;		// ǩ
	IMUserSex	m_emSex;			// Ա

	tagEIMStaffBriefInfo()
		: m_emSex(IM_USex_Unknown)
	{
	}

	~tagEIMStaffBriefInfo() {}

	tagEIMStaffBriefInfo(const tagEIMStaffBriefInfo& stParam)
	{
		operator = (stParam);
	}

	tagEIMStaffBriefInfo& operator = (const tagEIMStaffBriefInfo& stParam)
	{
		m_strStaffID		= stParam.m_strStaffID;
		m_strName			= stParam.m_strName;
		m_strSignature		= stParam.m_strSignature;
		m_emSex				= stParam.m_emSex;
		return *this;
	}

}EIMStaffBriefInfo, *LPEIMStaffBriefInfo;


struct IEIMSysMgrHostService
{
	virtual BOOL GetCompanyName(CString& strCompanyName) = 0;
	virtual BOOL GetStaffInfos(std::vector<LPEIMStaffBriefInfo>& vecStaffInfos) = 0;
};


// API for plugins.
__declspec(dllexport) IEIMSysMgrHostService* EIMGetSysMgrHostService();