﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.OrderAdmin, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="OrderAdmin">
<head runat="server">
    <title>订单管理</title><meta http-equiv="X-UA-Compatible" content="IE=edge" /><meta name="viewport" content="width=device-width,initial-scale=1">
</head>
<body>
    <form id="form1" runat="server">
        <asp:HiddenField ID="curOrderID" runat="server" />
        <asp:ScriptManager ID="s1" runat="server" OnAsyncPostBackError="AsyncError">
            <CompositeScript Path="js/msajax.js" ScriptMode="Release">
                <Scripts>
                    <asp:ScriptReference Name="WebForms.js" Assembly="System.Web" /><asp:ScriptReference Name="MicrosoftAjax.js" /><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" />
                </Scripts>
            </CompositeScript>
        </asp:ScriptManager>
        <div class="leftTitle" runat="server" id="pageTitle">订单管理</div>
		<div class="clear" id="box">
            <ul id="zone1">
	            <li><asp:CheckBox ID="cbOrderID" runat="server" Text="订单号：" /><asp:TextBox ID="tbOrderID" runat="server" Width="185"></asp:TextBox></li>
	            <li><asp:CheckBox ID="cbSubmiter" runat="server" Text="下单人：" /><asp:TextBox ID="tbSubmiter" runat="server" Width="185"></asp:TextBox></li>
                <li><asp:CheckBox ID="cbOthers" runat="server" Text="订单其它信息包含：" /><asp:TextBox ID="tbKey" runat="server" Width="123"></asp:TextBox></li>
            </ul>
            <ul id="zone2">
	            <li><asp:CheckBox ID="cbSubmitTime" runat="server" Text="下单时间：" /><asp:TextBox ID="tbTime1" runat="server"></asp:TextBox>～<asp:TextBox ID="tbTime2" runat="server"></asp:TextBox></li>
	            <li><asp:CheckBox ID="cbTotalPrice" runat="server" Text="订单金额：" /><asp:TextBox ID="tbTotalPrice1" runat="server"></asp:TextBox>～<asp:TextBox ID="tbTotalPrice2" runat="server"></asp:TextBox></li>
	            <li><asp:CheckBox ID="cbStatus" runat="server" Text="订单状态：" /><asp:DropDownList ID="ddlStatus" runat="server"></asp:DropDownList></li>
            </ul>
		</div>
        <div id="divBtn" class="center mtop_n">
            <asp:Button runat="server" ID="ibSearch" Text="搜索订单" OnClick="DoSearch" CssClass="btn" />
        </div>
        
        <asp:UpdatePanel ID="mainup" runat="server" RenderMode="Inline" ChildrenAsTriggers="true" UpdateMode="Conditional">
        <ContentTemplate>
        <div runat="server" id="OrderList">
        <div class="mtop_x mbottom_s sm">
        <asp:GridView ID="GvOrders" runat="server" ShowHeader="true" DataKeyNames="ID" AutoGenerateColumns="False" GridLines="none" AllowPaging="false"
        PageSize="15" AllowSorting="true" CssClass="normal" RowStyle-HorizontalAlign="center" OnRowDataBound="GvRowBound" OnRowDeleting="GvRowDeleting"
        OnDataBound="GvDataBound" OnSorting="GvSorting">
        <Columns>
            <asp:TemplateField HeaderText="订单号" ItemStyle-HorizontalAlign="left" HeaderStyle-Width="5.3em">
                <ItemTemplate><a href="#" onclick="return ShowDetail('<%# Eval("ID") %>');"><%# Eval("ID") %></a></ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField HeaderText="订单金额" DataField="TotalPrice" DataFormatString="{0:F2}" HtmlEncode="False" SortExpression="TotalPrice" HeaderStyle-Width="5.5em" />
            <asp:TemplateField HeaderText="下单人" HeaderStyle-Wrap="false" ItemStyle-CssClass="hide2" HeaderStyle-CssClass="hide2" HeaderStyle-Width="5.2em">
                <ItemTemplate><%# ims.Users.getDisplayName(Eval("Submiter") as string) %></ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="送货地址" ItemStyle-HorizontalAlign="Left" ItemStyle-CssClass="hide1 ell" HeaderStyle-CssClass="hide1">
                <ItemTemplate><%# Eval("Address") %></ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="下单时间" SortExpression="SubmitTime" ItemStyle-HorizontalAlign="Center" HeaderStyle-Width="5.7em">
                <ItemTemplate><span title="<%# ((DateTime)Eval("SubmitTime")).ToString() %>"><%# ((DateTime)Eval("SubmitTime")).ToString("yyyy-MM-dd") %></span></ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField  HeaderText="状态" HeaderStyle-Width="4.8em" />
            <asp:TemplateField HeaderText="操作记录" HeaderStyle-Width="4.1em">
                <ItemTemplate><a href="#" onclick="return ShowLogs('<%# Eval("ID") %>');">查看</a></ItemTemplate>
            </asp:TemplateField>
            <asp:CommandField ButtonType="Link" ShowDeleteButton="true" HeaderText="删除" HeaderStyle-Width="2.1em" DeleteText="删除" />
            <asp:TemplateField HeaderText="操作" HeaderStyle-Width="2.1em" Visible="false">
                <ItemTemplate>
                    <asp:LinkButton ID="lbCanel" runat="server" OnClick="CanelOrder" OnClientClick="return confirm('确定取消该订单吗？');">取消</asp:LinkButton>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
        </asp:GridView>
        </div>
        <div runat="server" id="divPager">
        <table><tr>
            <td>
                <asp:LinkButton ID="lbFirst" runat="server" CommandArgument="First" CommandName="Page" OnClick="jumpToPage" Text="首页"></asp:LinkButton>&nbsp;
                <asp:LinkButton ID="lbPrev" runat="server" CommandArgument="Prev" CommandName="Page" OnClick="jumpToPage" Text="上页"></asp:LinkButton>&nbsp;
                <asp:LinkButton ID="lbNext" runat="server" CommandArgument="Next" CommandName="Page" OnClick="jumpToPage" Text="下页"></asp:LinkButton>&nbsp;
                <asp:LinkButton ID="lbLast" runat="server" CommandArgument="Last" CommandName="Page" OnClick="jumpToPage" Text="末页"></asp:LinkButton>
            </td>
            <td class="right vmiddle">
                <span ID="count" runat="server" class="gray"></span>&nbsp;
                <asp:DropDownList runat="server" id="ddlPager" AutoPostBack="True" OnSelectedIndexChanged="jumpToPage" />
            </td>
        </tr></table>
        </div>
        </div>
        <div class="footBtnArea msgarea" runat="server" id="promNoOrders">暂无订单</div>
        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="ibSearch" EventName="Click" />
        </Triggers>
        </asp:UpdatePanel>
        
    <input id="btnInitDetail" type="button" value="" runat="server" onserverclick="ShowDetail" class="hide" />
    <ims:Pop runat="server" ID="popDetail" Width="600" OnOkClick="SaveOrder" CustomButtonB_Text="打印" CanelButtonText="关闭" CustomButtonB_OnClick="toPrint(event);" CustomButtonA_Text="导出" CustomButtonA_OnClick="toExportAs('#popDetail_Body',800,$('#popDetail_popup .head .title').text());">
    <ContentTemplate>
        <table class="normal">
        <asp:Repeater ID="rptOrderItems" runat="server" OnItemDataBound="rptOrderItems_ItemBound">
        <HeaderTemplate><tr><th style="width:2.1em">序号</th><th>商品</th><th style="width:60px">单价(<%= (string)ViewState["OrderUnit"] %>)</th><th style="width:40px">数量</th><th style="width:60px">金额(<%= (string)ViewState["OrderUnit"] %>)</th><th class="hide2">备注</th></tr></HeaderTemplate>
        <ItemTemplate>
        <tr runat="server" id="ItemTr"><td runat="server" class="center"></td><td runat="server"></td><td runat="server" class="center"></td><td runat="server" class="center"></td><td runat="server" class="center"></td><td runat="server" class="hide2"></td></tr>
        </ItemTemplate>
        </asp:Repeater>
        </table>
        <div runat="server" id="phPriceCompute" class="detail"></div>
        <div class="sepline2"></div>
        <div class="detail">
            付款方式：<asp:Label ID="lblPayWay" runat="server"></asp:Label><br />
            需要发票：<asp:Label ID="lblNeedInvoice" runat="server"></asp:Label><br />
            <div runat="server" id="InvoiceTitle">发票抬头：<asp:Label ID="lblInvoiceTitle" runat="server"></asp:Label></div>
            送货方式：<asp:Label ID="lblSendWay" runat="server"></asp:Label><br />
            送货地址：<asp:Label ID="lblAddress" runat="server"></asp:Label><br />
            　联系人：<asp:Label ID="lblContact" runat="server"></asp:Label><br />
            联系电话：<asp:Label ID="lblPhone" runat="server"></asp:Label><br />
            联系邮箱：<asp:Label ID="lblEmail" runat="server"></asp:Label><br />
            　下单人：<asp:Label ID="lblSubmiter" runat="server"></asp:Label><br />
            <div runat="server" id="divCustomComment">客户备注：<asp:Label runat="server" id="customComment" /></div>
            <div class="sepline2"></div>
        </div>
        <div class="detail">
            管理员备注：<asp:Label runat="server" ID="adminMsg"></asp:Label><br />
            <asp:TextBox ID="tbAdminComment" runat="server" TextMode="MultiLine" Rows="4" Width="99%"></asp:TextBox>
            订单状态：<asp:DropDownList ID="ddlCurOrderStatus" runat="server"></asp:DropDownList><br />
        </div>
    </ContentTemplate>
    </ims:Pop>
    
    <input id="btnShowLogs" type="button" value="" runat="server" onserverclick="ShowLogs" class="hide" />        
    <ims:Pop runat="server" ID="popLogs" ShowOkButton="false" CanelButtonText="确定">
    <ContentTemplate>
        <div runat="server" id="logsContent"></div>
    </ContentTemplate>
    </ims:Pop>
    
    <script src="js/comm.js"></script><script src="js/OrderAdmin.js"></script>
    </form>
</body>
</html>
