﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.help, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html>
<head runat="server">
    <title>系统帮助</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" /><meta name="viewport" content="width=device-width,initial-scale=1">
    <link href="App_Themes/Default/base.css" type="text/css" rel="stylesheet" />
    <style type="text/css" runat="server" id="css">
        *{font-size:13px;line-height:1.6}
        html,body,#form1{height:100%}
        pre{font-family:微软雅黑}
	    body{background:#f9f9f9;overflow:hidden;color:#333;margin:0}
        #header td{padding:3px 3px 1px;height:19px}
        #header td *{vertical-align:bottom;text-decoration:none}
	    #mainDiv{height:86%;overflow:auto;background:#fff;border-top:#ddd 1px solid;border-bottom:#ddd 1px solid;padding:0 3px 0 2px}
        #mainDiv > div{margin-bottom:6px}
	    #helpTitle{font-weight:bold;color:#009799;padding-left:3px}
        #helpTitle:before{content:"\e647";margin-right:3px}
        #header td:last-child{text-align:right;padding:3px 4px 2px 0}
        #header td:last-child button{margin-left:2px}
        #currentUrl{word-break:break-all;word-wrap:break-word}
        #moreoptions td{vertical-align:top}
        .block_title{color:#444;font-size:14px;font-weight:bold;padding-bottom:2px;margin:15px 1em 6px;border-bottom:1px #c8cad3 solid}
        .blockContent{margin:0 1em 0 2em}
	    p{text-indent:2em;margin:3px 0 6px;color:#333}
        p.noindent{text-indent:0}
        .v_top *{vertical-align:top}
	    dl{margin-left:6px}
        dt{font-weight:bold;font-size:14px;color:#046fd2;margin:8px 0 1px}
        dt:before{content:"\e675";transform:scale(.7);display:inline-block;margin-right:2px;margin-left:-2px}
        dd dt{color:#095}
        dd dt:before{display:none}
        dd{color:#222;line-height:1.6;}
	    dd ul{margin-left:16px;list-style-type:none}
	    dd ul.decoration li{list-style-type:disc;margin-bottom:4px;margin-left:24px}
	    dd li img{vertical-align:middle}
	    dd.related{padding-left:16px}
	    dd.related a{margin-right:0.5em}
	    dd dl{margin-left:16px}
	    dd dl.listdefine dt{list-style-type:square;padding-left:16px;background:url(images/li.png) no-repeat 0 50%;color:#1a6;font-weight:normal}
	    dd dl.listdefine dd{margin-left:12px;}
	    dd dl.define dt{color:#1a6;font-weight:bold;margin-right:0.5em;background:none;padding:0}
	    dd dl.inlinedefine dt{font-weight:bold;background:none;padding:0;display:inline;font-size:16px;color:#f14c04;margin-right:4px}
	    dd dl.inlinedefine dd{display:inline;margin:0}
        .ulm li{margin-bottom:0.75em !important}
	    .key{font-weight:bold}
	    .term{font-weight:bold;margin-right:12px;color:#0a1}
        .comment{color:#0a1}
	    .pictComment{color:#e20;margin-bottom:0.5em;text-align:center}
        .code{font-size:12px;color:#26188d;white-space:pre-wrap;word-wrap:break-word;word-break:break-all;font-family:Consolas;line-height:1.5 !important}
        .rem,.remline{color:#188D26;font-family:Consolas;font-size:12px}
        .rem{margin-left:4px}
        .code a{color:#057793;font-family:Consolas}
        p.pcode{margin:3px 0 0}
        dd > .code{margin-left:25.3px}
        .path{display:none;margin:4px 1px 3px 6px;padding:1px 1px 2px 22px;border:1px #fd6 dotted;background:#fffaf0 url(images/info.gif) no-repeat 3px 4px;border-radius:4px}
        #findbox{display:inline-block;margin-right:3px;background:#ececec;height:22px;padding:0 4px 0 9px;border-radius:11px}
        @media (max-width:480px) {
            #findbox{display:none}
        }
        #tbKey{background:transparent;border:0;width:80px;height:100%;padding:0;font-size:.957rem;margin:0}
        #btnFind{color:#24bf81;transform:scale(1.2);display:inline-block}
        #mainDiv > .searchItem .btitle{margin:3em 8px 0}
        #mainDiv > .searchItem:first-child .btitle{margin-top:1em}
        #resultNav{margin-left:8px}
        #resultNav a{margin-right:0.6em}
        .keyword{background:#ff0;color:#000}
	</style>
</head>
<body>
    <form id="form1" runat="server">
    <asp:ScriptManager ID="s1" runat="server" OnAsyncPostBackError="AsyncError">
        <CompositeScript Path="js/msajax.js" ScriptMode="Release">
            <Scripts>
                <asp:ScriptReference Name="WebForms.js" Assembly="System.Web" /><asp:ScriptReference Name="MicrosoftAjax.js" /><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" />
            </Scripts>
        </CompositeScript>
    </asp:ScriptManager>
		<table id="header">
			<tr>
			    <td><span ID="helpTitle" runat="server"></span></td>
			    <td>
                    <div id="findbox"><input id="tbKey" runat="server" type="text" placeholder="关键字" onkeydown="return enterTo(event,'btnFind');" /><i class="f-sou pointer" id="btnFind" onclick="toFind();" title="搜索"></i></div>
                    <button type="button" onclick="location='?subject=index';" runat="server" id="aHome" class="btn smest rd f-home">首页</button>
                    <button type="button" onclick="history.back();" id="aBack" class="btn smest rd f-arrowl">后退</button>
                    <button type="button" runat="server" id="fullWindow" class="btn smest rd f-fenfa">全屏</button>
			    </td>
			</tr>
        </table>
        <div id="mainDiv" runat="server">
        <div id="resultNav" runat="server" visible="false"></div>
		<asp:Panel ID="index" runat="server" Visible="False">
			<dl class="mbottom_l"><dt>系统说明</dt>
				<dd runat="server" id="briefing">
                    <p>这是一个灵活的管理软件自定义平台，可<a href="?subject=three">三分钟入门</a>，自由定制各种数据信息管理和流程管理功能，进行在线录入、查询、管理和沟通，建立起"低成本高效率、操作简单、随需应变"的在线管理系统。</p>
				    <p>软件以<a href="?subject=templets">模板</a>为基础，以各种视图和版式提供了多种数据展现形式，以及直观灵活的统计分析功能；可随时备份或恢复数据、导入或导出Excel；提供"信息中心"栏目，用于发布通知、文档、新闻，或作为论坛使用；"事务中心"模块，让待办事项一目了然；"消息、短信、微信、邮件、评论、提醒"等功能，使内部沟通协作方便高效；拖拽排版、输入提示等细节特性，给你贴心的使用体验；更有自动发送报表/图表、自动定时流程、自动结转、自动备份等自动化功能；通过简单的权限设置，一切尽在掌握。</p>
				    <p>系统可安装在单机、局域网或互联网云服务器/虚拟主机上，随时随地用电脑或手机操作，兼容多种设备、多种数据库和主流浏览器，具备条码/二维码、微信公众号接入、来电弹屏、Web API接口等诸多实用功能。</p>
                    <p style="text-align:right;padding-right:6px"><a runat="server" id="helpDesign" href="?subject=three">如何设计模板？</a>　<a runat="server" id="sysAbout" class="landian" href="https://landian.cc" target="_blank">检查新版本</a></p>
                </dd>
				<dt>技术特性</dt>
				<dd>
				    <p class="write" runat="server">安装运行环境：Windows系列操作系统，安装.Net 4.5或更高版本；</p>
                    <p class="write" runat="server">支持的数据库：Access、SQL Server 2005～2017/Express；</p>
                    <p>支持的浏览器：IE11、Firefox、Chrome、Edge等主流浏览器；推荐：<a href="https://www.360.cn" target="_blank">360极速</a>、<a href="http://www.firefox.com.cn" target="_blank">Firefox</a>、<a href="http://down.tech.sina.com.cn/content/40975.html" target="_blank">Chrome</a>；</p>
                    <p>客户端分辨率：推荐 1024×768 以上显示分辨率；</p>
                    <p class="landian">软件官方网站：<a href="https://landian.cc" target="_blank">https://landian.cc</a>。</p>
                </dd>
                <dt class="write" runat="server">主要术语</dt>
                <dd class="write" runat="server">
                    <dl class="define">
                        <dt id="anchor_define">模板</dt>
                        <dd>
                            <p>任何要管理的事物都是以模板为基础的。模板定义了其各种属性，如名称、规格、重量之类，这些属性被称为“字段”。</p>
                            <p>系统所管理的数据都是依存于特定模板的，其中的每一条信息称为一条“记录”。如下图所示：<br /><img src="images/help/glossary.png" /></p>
                        </dd>
                        <dt>目录</dt>
                        <dd>
                            <p>类似于Windows的文件夹，目录是对文件或数据的一种分类组织形式。一个模板的记录可以分布在不同目录中，或不放到任何目录。它是系统虚拟的结构，与电脑中的文件夹无关。</p>
                        </dd>
                        <dt>视图</dt>
                        <dd><p>视图，是数据的一种表现形式，不同的视图以不同形式来展现同一批数据。浏览数据时通常以默认视图展现，可随时切换其他视图。</p></dd>
                    </dl>
                </dd>
                <dt class="write" runat="server">系统应用基本流程：<span style="font-weight:normal"><a href="#" onclick="to('templets.aspx');">设计模板</a> - <a href="#" onclick="to('select.aspx');">录入数据</a> - <a href="#" onclick="to('templets.aspx?mode=data');">浏览和数据管理</a></span></dt>
                <dt>如何使用帮助</dt>
                <dd>
                    <p>随时可点击左侧栏的"实时帮助"，或操作界面的问号图标、帮助按钮来查看相关指导信息。</p>
                    <p runat="server" id="pPopHelp">
                        初次使用本系统时，会自动弹出与当前操作相关的气泡式操作指南，这些信息最多会显示两次。
                        <asp:UpdatePanel runat="server" ID="up1" UpdateMode="Conditional" RenderMode="Inline">
                            <ContentTemplate>
                                <asp:LinkButton runat="server" ID="resetPopHelp" OnClick="ResetPopHelp" Text="点击此处将已显示次数归零"></asp:LinkButton>&nbsp;
                                <asp:LinkButton runat="server" ID="switchPopHelp" OnClick="SwitchPopHelp"></asp:LinkButton>
                            </ContentTemplate>
                        </asp:UpdatePanel>
                    </p>
                </dd>
				<dt runat="server" id="dtRelated">相关主题</dt>
				<dd class="related" runat="server" id="ddRelated">
                    <a href="?subject=indexnav">索引</a>
                    <a runat="server" class="admin" href="?subject=three">三分钟入门</a>
                    <a href="?subject=faq">常见问题解答</a>
                    <a runat="server" class="admin" href="?subject=power&showpath=1">用户及权限</a>
                    <a runat="server" class="admin" href="?subject=admin&showpath=1">系统设置</a>
				    <a href="#" onclick="to('guide.aspx');" runat="server" class="write" id="guide">操作向导</a>
				    <a href="#" onclick="to('adminHome.aspx?tab=about');" runat="server" id="about" class="admin">关于本系统</a>
                </dd>
			</dl>
        </asp:Panel>

        <asp:Panel ID="indexNav" Visible="false" runat="server">
            <div class="block_title">开始了解</div>
            <div class="blockContent">
                <a href="?subject=index">简介、技术特性、主要术语、如何使用帮助</a>、 <a href="?subject=three">三分钟入门</a>、<a href="#" onclick="to('guide.aspx');">向导</a>、<a href="?subject=faq">常见问题解答</a>
            </div>
            <div class="block_title">系统设计</div>
            <div class="blockContent">
                <a href="?subject=templets">设计中心</a>、<a href="?subject=templet">模板设计</a>、<a href="?subject=masterSlave">模板关系</a>、<a href="?subject=flow">流程设计</a>、<a href="?subject=templetattrs">模板设置</a>、<a href="?subject=generator">生成</a>、<a href="?subject=carryover">结转</a>、<a href="?subject=customopera">自定义操作</a>、<a href="?subject=findtemplet">查找模板</a>、<a href="?subject=power">用户、角色及权限</a>、<a href="?subject=users">用户管理</a>、<a href="?subject=roles">角色管理</a>、<a href="?subject=admin">系统设置</a>、<a href="?subject=HomeLayout">自定义首页</a>、<a href="?subject=sidebar">自定义左侧栏</a>、<a href="?subject=jsplugin">外挂脚本</a>、<a href="?subject=cssplugin">外挂样式</a>、<a href="?subject=cssclass">常用样式类</a>
            </div>
            <div class="block_title">系统应用</div>
            <div class="blockContent">
                <a href="?subject=dataadmin"><%= ims.Sys.DataCenterText %></a>、<a href="?subject=dir">目录</a>、<a href="?subject=edit">数据录入</a>〔<a href="?subject=EditScan">扫码输入</a>〕、<a href="?subject=rows">多行录入模式</a>〔<a href="?subject=RowsScan">扫码输入</a>〕、<a href="?subject=editlayout">录入界面版式管理</a>、<a href="?subject=thumb">缩略视图</a>、<a href="?subject=table">表格视图</a>、<a href="?subject=condformat">表格视图条件格式</a>、<a href="?subject=summary">概要视图</a>、<a href="?subject=detail">详情视图</a>、<a href="?subject=detaillayout">详细视图排版</a>、<a href="?subject=chart">图表视图</a>、<a href="?subject=report">报表视图</a>、<a href="?subject=datahome">搜索-快捷方式-收藏</a>、<a href="?subject=filters">过滤器</a>、<a href="?subject=fastfilter">数据筛选</a>、<a href="?subject=advsearch">高级搜索</a>、<a href="?subject=searchLayout">搜索版式</a>、<a href="?subject=infoEdit"><%= ims.Sys.InfoType %>发布</a>、<a href="?subject=preview">文件预览</a>、<a href="?subject=plan">计划任务</a>
            </div>
            <div class="block_title">其它主题</div>
            <div class="blockContent">
                <a href="?subject=api">API接口</a>、<a href="?subject=weixin">微信接入设置</a>、<a href="?subject=hotline">来电弹屏</a>、<a href="?subject=maint">系统维护</a>、<a href="?subject=autoBackup">系统自动备份</a>、<a href="?subject=manualBakRes">手工备份/还原系统</a>、<a href="?subject=editor">编辑器</a>、<a href="?subject=eshopsetting">电子商务选项设置</a>、<a href="?subject=cart">购物车</a>、<a href="?subject=orderadmin">订单管理</a>、<a href="?subject=myorder">我的订单</a>、<a href="?subject=access">Access数据库常用函数</a>、<a href="?subject=sqlserver">SQL Server数据库常用函数</a>、<a href="?subject=iconfont">字体图标</a>
            </div>                        
        </asp:Panel>
					
        <asp:Panel ID="HomeLayout" Visible="false" runat="server">
            <div class="path">操作路径： 首页，点击右上角 <i class="f-setting"></i>图标</div>
            <dl>
                <dt>如何为首页添加新的版块？</dt>
                <dd>
                    <p>点击右上方的 <i class="f-setting"></i>图标，弹出“设置我的首页”对话框后，以下按钮可用于添加版块：</p>
                    <ul>
                        <li><span class="term">添加自定义版块</span>添加一个自定义内容的版块，其中可添加录入、浏览、搜索等链接元素，或任意的内容；</li>
                        <li><span class="term">添加RSS版块</span>添加一个RSS订阅版块，以显示指定的RSS源的最新内容；</li>
                        <li><span class="term">添加网页版块</span>添加一个嵌入指定网页内容的版块。</li>
                        <li><span class="term">添加图表/报表</span>添加一个指定数据源的图表或报表。</li>
                    </ul>
                </dd>
                <dt>如何隐藏或显示版块？</dt>
                <dd>
                    <p>鼠标移到任一个版块左上方，版块图标会变成 <span class="red">✗</span> ，点击即可隐藏该版块；隐藏的版块可在“设置我的首页”对话框的“可用的版块”中看到，点击其右侧的 <i class="f-add green"></i>图标可将其添加到页面中显示出来。</p>
                </dd>
                <dt>如何编辑或删除版块？</dt>
                <dd><p>系统预置版块只能隐藏，不能编辑或删除；自己添加的版块可以在“设置我的首页”对话框的“可用的版块”中，点击其右侧的编辑或删除图标进行相应操作。</p></dd>
                <dt>如何调整页面区域布局和各版块位置？</dt>
                <dd><p>在“设置我的首页”对话框中，点击“切换页面布局”，可选择新的区域布局形式；在页面上拖动版块标题可将版块移动到另一区域，或区域中的另一位置。以上操作的结果，系统将自动记忆存储。</p></dd>
                <dt>什么是RSS？</dt>
                <dd><p>RSS是一种网站内容聚合格式，一些新闻或博客等类型的站点，会将他们更新的内容生成为一个描述文件，即RSS源。首页添加的RSS版块，就相当于是订阅这些RSS所提供的内容。</p></dd>
                <dt>如何为不同角色设置不同的默认版式？</dt>
                <dd>
                    <p>在“设置首页”对话框中，点“保存为…”按钮可将当前版式命名保存下来。注意：任何时候，对首页的版块拖动或添加、编辑等操作，都会自动保存于当前的版式，因此要新设计一个首页版式时，建议先保存为新版式，再作编辑调整，以免影响原版式。</p>
                    <p>点“管理版式”按钮，可对所有的命名版式设为系统默认、更名、编辑、删除等操作，点击版式名称可将其设为某些角色的默认首页版式。也可在“角色的默认版式”处查看或设置角色的默认版式。</p>
                </dd>
                <dt>提示</dt>
                <dd>
                    <p>
                        如果在版式管理中勾选“禁止普通用户自定义左侧栏”，则非系统管理员只能使用由管理员指定的默认版式。当用户属于多个角色时，可临时取消该选项，让用户可以自己选择要使用哪个角色的版式。
                    </p>
                </dd>
                <dt>技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>通过添加网页版块，可以使用系统中的页面地址作为网址，来直接在版块中显示系统中的数据或页面。如“view.aspx?tid=1”，可显示ID为1的模板的数据。</li>
                        <li>如何获得系统内部的页面地址？在系统中找到进入该目标页面的链接，点鼠标右键，复制快捷方式，将得到的地址中，取最后一个“/”后面的部分；或在页面中点右键，查看源代码，取form元素的action值。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="admin" runat="server" Visible="False">
        <div class="path">操作路径： 点顶部“系统管理”图标，再点“系统设置”图标</div>
        <dl>
            <dt>部分设置选项说明：</dt>
            <dd>
                <ul>
                    <li><span class="term">单位名称</span>使用本系统的公司或机构的全称或简称。</li>
                    <li><span class="term">系统名称</span>对该软件系统的自定义的名称。</li>
                    <li><span class="term">系统互联网访问地址</span>从互联网访问本系统所使用的网址。该地址将用于从邮件的链接中访问系统，以及在线预览Office文档等情况。若没有配置外网访问，请留空。</li>
                    <li><span class="term">允许用户注册</span>设置是否允许用户通过注册页面自行注册。</li>
                    <li><span class="term">允许找回密码</span>若选中，则用户在遗忘密码后可通过找回密码功能来获得系统用电子邮件发送的随机新密码。</li>
                    <li><span class="term">允许重复登录</span>设置是否允许同一个用户帐户同时在不同电脑或浏览器上登录并操作。列入“公共帐户”角色的不受此限制。</li>
                    <li><span class="term">允许匿名访问</span>设置是否允许在不登录的情况下以匿名用户身份访问系统，并进行授权范围内的操作。</li>
                    <li><span class="term">用户登录方式</span>设置当用户登录时是从用户列表中选择自己的用户名，还是在文本框中输入用户名。如果用户数量多于100，则忽略此设置而强行采用输入用户名的方式。</li>
                    <li><span class="term">新用户默认角色</span>指定新创建或注册的用户默认属于哪个<asp:HyperLink ID="HyperLink4" runat="server" NavigateUrl="help.aspx?subject=roles">角色</asp:HyperLink>。</li>
                    <li><span class="term">禁止自动弹出气泡式帮助</span>勾选以禁用针对新用户的弹出式操作指导。</li>
                    <li><span class="term">在线编辑器模式</span>指定在数据录入或编辑时，<asp:HyperLink ID="HyperLink5" runat="server" NavigateUrl="help.aspx?subject=editor">编辑器</asp:HyperLink>的工作模式。不同模式间的区别在于可用的工具按钮的数量不同。</li>
                    <li><span class="term">插入图片或链接时，允许浏览和选取现有文件</span>在编辑器中插入超链接或图片时，默认只有系统管理员可以点击“浏览服务器”按钮，来选择之前已上传的文件。该选项设置是否允许非管理员用户也可以这样操作。</li>
                    <li><span class="term">限制上传图片尺寸</span>设置上传图片的最大允许尺寸，以像素为单位。当所上传的图片的宽度或高度大于该尺寸时，程序会自动同比例缩小到该尺寸。设为0表示禁止上传图片。</li>
                    <li><span class="term">限制上传文件大小</span>设置允许上传的文件大小（不影响系统还原/更新/导入等上传），设为0表示禁止上传文件。</li>
                    <li><span class="term">允许上传的文件类型</span>在这里设置允许在编辑数据时在“文件”类型字段中上传的文件的扩展名列表。只有具有列出的扩展名之一的文件才能上传。扩展名不带句点符号，以逗号作为分隔。留空表示不限制上传的文件类型，由于理论上这会存在安全漏洞，所以应该仅在完全信任录入人员的情况下设置为空。</li>
                </ul>
            </dd>
            <dt>功能选项说明：</dt>
            <dd>
                <ul>
                    <li><span class="term">启用工作流功能</span>可以设计和应用工作流，实现对事物的流程化管理。详见：<a href="?subject=flow">流程设计</a>。</li>
                    <li><span class="term">启用目录权限控制</span>勾选该项，则可以对目录的创建、删除等权限进行设置和控制，否则，只要用户可以添加记录，就可以操作目录。</li>
                    <li><span class="term">启用电子商务功能</span>启用后，用户在浏览商品时可将其加入购物车并提交订单，管理员可查看和管理订单。勾选该项后，还需对商品类模板设置启用电子商务功能。</li>
                    <li><span class="term">启用短信发送功能</span>勾选该项，可以在系统中设置短信账号用于发送手机短信。</li>
                    <li><span class="term">启用来电弹屏功能</span>勾选该项，可以在系统中设置并连接相应的硬件设备，实现当客户来电话时弹出该客户信息的功能。详见：<a href="?subject=hotline">来电弹屏</a>。</li>
                    <li><span class="term">启用微信功能</span>勾选该项，则可以使用系统的企业微信相关功能，详见：<a href="?subject=weixin">微信接入设置</a>。</li>
                    <li><span class="term">启用消息功能</span>勾选该项，则可以使用系统内部消息功能，用户之间可收发消息。</li>
                    <li><span class="term">启用收藏功能</span>如果启用，则用户可以将感兴趣的信息加入到自己的收藏夹中。</li>
                </ul>
            </dd>
            <dt>用户信息选项说明：</dt>
            <dd><p>切换到“用户信息”标签，可分别设置每个项目是否启用，以及是否为必填项。只有启用了的项目，才会在用户注册及其个人信息维护页面显示出来供填写。</p></dd>
            <dt>邮件发送设置说明：</dt>
            <dd>
                <p>在这里设置用于发送邮件所必须的一些信息。“发件邮箱地址”及“发送者的名称”分别填写发送邮件所用的邮箱及发送方的名称，其余选项可向该邮箱的服务提供商咨询，或查阅其在线文档中关于SMTP设置的部份。请参考：<a href="http://service.mail.qq.com/cgi-bin/help?subtype=1&&id=28&&no=369" target="_blank">QQ邮箱设置</a>、<a href="http://help.mail.163.com/faqDetail.do?code=d7a5dc8471cd0c0e8b4b8f4f8e49998b374173cfe9171305fa1ce630d7f67ac22dc0e9af8168582a" target="_blank">网易邮箱设置</a></p>
                <p>注：若使用QQ邮箱或网易邮箱等，请确保邮箱设置中开启了SMTP服务；如果在邮箱中设置了使用授权码登录第三方客户端，则应使用授权码作为密码。</p>
            </dd>
            <dt>相关主题</dt>
			<dd class="related"><a href="?subject=moreSetting">更多设置项</a></dd>
        </dl>
        </asp:Panel>
                    
        <asp:Panel ID="eshopsetting" Visible="false" runat="server">
            <div class="path">操作路径： 系统管理 &rsaquo; 系统设置 &rsaquo; 功能选项，勾选“启用电子商务功能”，点“电子商务选项设置”</div>
            <dl>
                <dt>“订单计费规则说明”标签页</dt>
                <dd><p>在这里填写对订单计费规则的说明。这些规则通常包括一些优惠及促销方面的措施，例如，“购物满100元，返现10元”、“在5.1～5.7期间购物免运费”之类。</p></dd>
                <dt>“订单计费规则管理”标签页</dt>
                <dd><p>在这里添加或维护订单的计费规则。订单计费规则是指在订单正常计价之后，对订单总金额的一些调整规则。</p></dd>
                <dt>“送货方式管理”标签页</dt>
                <dd><p>在这里添加或删除可用的送货方式。例如，邮政平邮、快递之类。</p></dd>
                <dt>“付款方式管理”标签页</dt>
                <dd><p>在这里添加或删除可用的付款方式。例如，邮政汇款、银行转帐之类。</p></dd>
                <dt>“邮件通知设置”标签页</dt>
                <dd><p>在这里设置当一个订单提交之后，是否给系统管理人员或客户本人发送邮件通知，以及邮件的内容模板。</p></dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="views" Visible="false" runat="server">
            <dl>
                <dt>定义</dt>
                <dd>
                    <p>视图，是数据的一种表现形式，不同的视图以不同形式来展现同一批数据。</p>
                </dd>
                <dt>说明</dt>
                <dd>
                    <ul class="decoration">
                        <li>浏览或搜索数据时，通常以默认视图展现。可以随时切换视图，以不同形式查看这批数据。</li>
                        <li>视图只负责呈现数据，不负责数据来源。每次打开某个视图，查看的都是最近一次打开或搜索的数据。</li>
                        <li>可以在左侧栏自定义版块添加链接，以指定视图打开指定数据。</li>
                        <li>可以在模板设置中设置默认视图。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="maint" Visible="false" runat="server">
            <div class="path">操作路径： 点顶部“系统管理”图标，再点“系统维护”图标</div>
            <dl>
                <dt>系统清理</dt>
                <dd><p>执行选定的系统清理工作。其中，勾选“缩略图缓存”，将删除缓存的缩略图文件，以迫使在需要显示缩略图时进行重新生成。通常不需要执行此项清理工作；勾选“匿名用户”，将删除所有未登录系统的情况下访问系统所产生的用户个性化数据，包括：收藏夹、界面风格设置等等。</p></dd>
                <dt>备份和还原</dt>
                <dd>
                    <p><span class="term">备份</span>点击“备份”按钮，系统会将整个系统所有数据和文件打包为一个压缩文件供下载保存。</p>
                    <p><span class="term">自动备份</span>点击“自动备份”按钮，可设置按指定周期自动将系统备份到指定的位置。</p>
                    <p><span class="term">还原</span>点击“还原”按钮，指定备份文件，系统会将其上传并还原到系统。</p>
                    <p runat="server" id="sqlRestore1"><span class="term">还原数据库</span>如需单独还原 SQL Server 数据库，可将其备份文件置于服务器上系统的App_Data文件夹下，这样本页面会出现“还原数据库”按钮，点击可将其还原到系统中（不影响其它文件）。</p>
                    <p><span class="red">说明：</span>如果系统中图片和文件太多，备份或还原功能可能会超时而失败，可在服务器上手工操作，直接将安装目录进行备份或还原<span runat="server" id="sqlRestore2">，同时将SQL Server数据库进行备份或还原</span>。</p>
                    <p runat="server" id="sqlRestore3"><span class="red">技巧：</span>在“其它操作”标签页中点“下载调试数据”，可获得系统数据库的备份文件；将数据库备份文件(两个.bak文件)置于App_Data下，然后通过“还原数据库”功能可单独还原 SQL Server 数据库。</p>
                </dd>
                <dt>系统开发</dt>
                <dd>
                    <p><span class="term">编辑外挂脚本</span>外挂脚本是一个Javascript脚本文件，用于对系统功能进行一些特殊处理。它会被每个页面加载运行。它不会被系统升级所覆盖。<a href="?subject=jsplugin">详细</a></p>
                    <p><span class="term">编辑外挂样式</span>外挂样式是一个CSS样式文件，用于对系统界面样式进行一些特殊处理。它会被每个页面加载应用。它不会被系统升级所覆盖。<a href="?subject=cssplugin">详细</a></p>
                </dd>
                <dt>其它</dt>
                <dd>
                    <dl class="listdefine">
                        <dt>关闭系统</dt>
                        <dd><p>停止系统的运行。关闭系统之后，对任何访问请求，将会提示“系统维护中…”，直到在服务器上移除系统根目录下的app_offline.htm文件，才会恢复运行。</p></dd>
                        <dt>重新启动系统</dt>
                        <dd><p>重新启动系统的运行环境，类似于服务器重新启动的效果，可回收系统占用的内存和缓存空间。</p></dd>
                        <dt>切换数据库</dt>
                        <dd><p>将当前系统切换到其它的数据库。这意味着将切换到以另一套数据库为基础的完全独立的系统，将会导致当前所有用户、设置等完全失效。如果以后再切换回当前数据库，系统会恢复到当前的状态。尽管这在技术上是可行的，但仍然建议从一而终地使用同一个数据库。另外需要说明的是，注册码是保存在数据库中的，并且不同数据库对应的注册码是不同的。</p></dd>
                        <dt>压缩数据库</dt>
                        <dd><p>清理数据库占用的无用空间。不建议频繁使用该功能。</p></dd>
                        <dt>下载调试数据</dt>
                        <dd><p>调试数据包含了系统的数据库文件及相关信息，用于软件开发商调试解决软件故障。该功能也可用来单独备份数据库文件。</p></dd>
                    </dl>
                </dd>
            </dl>
        </asp:Panel>
                    
        <asp:Panel ID="power" Visible="false" runat="server">
            <div class="path">操作路径： 系统管理 &rsaquo; 角色管理/用户管理，可设置用户的角色及角色的系统级权限</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>用户，包括管理员建立的用户和自行注册的用户（如果允许注册）。角色，是一类用户的统称，如公司领导、员工、供应商、客户等。权限是设置给角色的，用户归属于某个角色就拥有了这个角色的权限。</p>
                </dd>
                <dt>系统权限</dt>
                <dd>
                    <ul class="decoration">
                        <li><span class="term">系统管理</span>最高的权限，可执行系统设置、用户和角色管理等在内的各种操作，不受下面的权限规则所限；</li>
                        <li><span class="term">用户管理</span>可管理用户、机构和角色，但不允许改变系统管理权限现状；</li>
                        <li><span class="term">创建模板</span>可在设计中心添加模板；</li>
                        <li><span class="term">订单管理</span>如果启用了电子商务功能，可进行订单管理。</li>
                    </ul>
                    <p>与数据相关的权限是在模板上独立设置的，所以即使两个角色的系统权限相同，也不一定应该合并为一个角色。</p>
                </dd>
                <dt>沟通权限</dt>
                <dd>
                    <ul class="decoration">
                        <li runat="server" id="aboutInfoPower"><span class="term"><%= ims.Sys.InfoCenterText %></span>指定对<%= ims.Sys.InfoCenterText %>的权限。“浏览权限级别”用以控制只能浏览保密级别不高于该级别的<%= ims.Sys.InfoType %>；勾选“评论”则允许发表评论；勾选“管理”则允许进行删除等管理操作。</li>
                        <li><span class="term">邮件权限</span>指定发送电子邮件的权限。</li>
                        <li runat="server" id="aboutSmsPower"><span class="term">短信权限</span>指定发送手机短信的权限。</li>
                        <li runat="server" id="aboutMsgPower"><span class="term">消息权限</span>指定发送系统消息的权限。</li>
                    </ul>
                </dd>
				<dt>模板权限</dt>
                <dd>
                    <div class="path">操作路径： 设计中心，模板图标上点右键 - 权限。</div>
                    <p>在模板的权限设置对话框中，可分别设定每个角色对该模板的权限：</p>
                        <ul class="decoration">
                            <li><span class="term">浏览权限</span>即查看该模板类型的数据的权限。具体又分为0～10共11个级别，这些级别是与数据的保密级别对应的，只有浏览权限大于或等于保密级别，才能查看。
                                在此基础上，还可以勾选“仅允许浏览符合条件的记录”，来进一步限定可浏览的范围。
                            </li>
                            <li><span class="term">编辑权限</span>指定是否允许录入或编辑此模板类型的数据，以及对模板中哪些字段有编辑权限。</li>
                            <li><span class="term">评论权限</span>查看、发表和删除评论的权限。</li>
                        </ul>
                    <p>注1：如果有系统管理权，或者在权限设置中勾选了“完全控制”，则可对模板和数据进行任何操作，如修改模板设计、备份和清除数据等。以下说明均不考虑这两种情况。</p>
                    <p>注2：如果对一条记录有编辑权限，则无条件地具有浏览权限。如果浏览权限级别低于字段的保密级别，则浏览时无法看到该字段内容，但对该字段有编辑权限则例外。</p>
                    <p>注3：模板在创建后默认仅管理员和其创建者有完全控制权，其它用户没有任何权限，直到明确指定了他们所属角色的权限。</p>
                </dd>
                <dt>权限引用</dt>
                <dd>
                    <p>引用某模板的权限设置，意味着用户对当前模板和指定的模板具有相同的权限。但引用的权限将忽略涉及具体字段的选项。若源模板允许编辑部分字段，则将允许编辑所有字段；若浏览或编辑条件涉及具体的字段（非“创建人”等属性字段），将忽略之。</p>
                </dd>
                <dt>模板权限示意图</dt>
                <dd style="padding-left:1em;color:red;font-weight:bold">
                    <div>设置用户角色：</div>
                    <img src="images/help/power.png" />
                    <div>设置角色权限：</div>
                    <img src="images/help/power_1.png" />
                    <div>权限控制效果：</div>
                    <img src="images/help/power_2.png" />
                </dd>
                <dt runat="server" id="dtFlowPower">流程权限</dt>
                <dd runat="server" id="ddFlowPower">
                    <div class="path">操作路径： 设计中心，模板上点右键 - 设置 - 流程，点击创建流程或修改流程的链接</div>
                    <p>流程权限在流程设计中指定。流程“开始”步骤指定的“处理者”，才能发起该流程。</p>
                </dd>
                <dt runat="server" id="dtDirPower">目录权限</dt>
                <dd runat="server" id="ddDirPower">
                    <div class="path">操作路径： 从左侧栏打开目录，再在右边子目录上点右键 - 权限（或空白处右键 - 权限，设置当前目录）</div>
                    <p>在系统设置中“启用目录权限控制”的前提下，可以按以下规则对与目录相关的操作进行权限控制。若未启用该选项，则只有可以添加记录者能进行目录相关的操作。</p>
                    <p>与目录相关的权限，包括：浏览权限、写入权限、完全控制权限。要在目录中添加记录或子目录，需要写入权限；要对目录设定权限，或删除、重命名该目录，需要完全控制权限。</p>
                    <p>目录权限其实只是控制用户是否可在其中添加数据或建立子目录而已，至于对目录中的数据有什么权限，是由这些数据的模板权限来决定的。</p>
                    <p>在根目录下新建的一级目录，除系统管理员外默认只有目录创建者有权限，其它人是没有权限的；在一级目录下建立的子目录，默认继承了其父目录的权限设置。</p>
                </dd>
				<dt>如何对某些人隐藏某个字段？</dt>
				<dd><p>如果希望让部份用户看不到某个字段的内容，可以在模板设计中修改这个字段的保密级别，适当调高一些，如调至五级；再将这些用户归属到一个特定的角色，并设置该角色对该模板的浏览权限级别低于这个字段的保密级别，如四级。这样，这些用户将看不到该字段的内容——除非具有对这个字段的编辑权限（编辑权限优先于浏览权限）。</p></dd>
				<dt>相关主题</dt>
				<dd class="related"><a href="?subject=users">用户管理</a><a href="?subject=roles">角色管理</a><a href="?subject=templets">模板管理</a></dd>
            </dl>
        </asp:Panel>
                    
        <asp:Panel ID="users" Visible="false" runat="server">
            <div class="path">操作路径： 系统管理 &rsaquo; 用户管理</div>
            <dl>
                <dt>相关术语</dt>
                <dd>
                    <p><span class="term">机构</span>就是指像部门、科室、小组、分公司等这样的组织单元。</p>
                    <p><span class="term">分管的机构</span>指机构中非负责人用户所直接管辖的下级机构。例如部门经理的助理，其不是负责人，但仍可能管理部分下级机构。</p>
                </dd>
                <dt>如何建立组织机构？</dt>
                <dd>
                    <p>在页面右侧主窗口中点右键，可以添加下级机构，就像在Windows中建立文件夹一样，可以建立起无限层次的组织机构树。</p>
                    <p>应根据实际的组织结构来建立组织机构树，并在每个机构中添加相应的用户，以及用户是否负责人，是否分管了下级机构等属性。</p>
                </dd>
                <dt>如何添加用户？</dt>
                <dd><p>在右侧空白区域点击右键，从弹出菜单中选择“添加新用户”，输入用户名即可。如果系统中尚未设置默认用户信息，则必须先设置之后才能建立用户。默认用户信息包括用户初始密码等内容。</p></dd>
                <dt>如何删除用户？</dt>
                <dd><p>右键点击要删除的用户，选择“删除”即可。</p></dd>
                <dt>如何移动用户或机构到另一个机构中？</dt>
                <dd><p>右键点击要移动的用户或机构，选择“剪切”，再打开目标机构，右键，粘贴；也可以将某个用户或机构用鼠标直接拖入某个子机构中。</p></dd>
                <dt>如何设定用户角色？</dt>
                <dd><p>右键点击要设置的用户，选择“属性”，在弹出的对话框中“角色”处勾选要设置的角色，点击确定即可。</p></dd>
                <dt>用户管辖级别的确定</dt>
                <dd>
                    <p>机构中的的普通成员，虽然与负责人位于同一机构，但他们是负责人的下级；</p>
                    <p>下级机构的负责人，是否作为本机构的直接成员，取决于系统设置中的设置。</p>
                </dd>
                <dt>说明</dt>
                <dd>
                    <p>默认情况下，不允许一个帐户在不同地方重复登录（先登录的会被强制注销），但可以建立一个名为“公共帐户”的角色，设为该角色的用户，可以重复登录且不允许修改密码。</p>
                </dd>
				<dt>相关主题</dt>
				<dd class="related"><a href="?subject=roles">角色管理</a><a href="?subject=power&showpath=1">用户、角色及权限</a></dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="roles" Visible="false" runat="server">
            <div class="path">操作路径： 系统管理 &rsaquo; 角色管理</div>
            <dl>
                <dt>如何添加角色？</dt>
                <dd><p>在空白区域点击右键，在弹出菜单中选择“添加新角色”，输入角色名即可。</p></dd>
                <dt>如何删除角色？</dt>
                <dd><p>右键点击要删除的角色，选择“删除”即可。仅在没有任何用户属于该角色的情况下，方可删除角色。</p></dd>
                <dt>如何为角色设定权限？</dt>
                <dd>
                    <p>点击要设置的角色，在弹出的对话框中即可设置角色的权限。具体请参考<a href="?subject=power&showpath=1">用户、角色及权限</a>。</p>
                </dd>
				<dt>相关主题</dt>
				<dd class="related"><a href="?subject=users">用户管理</a><a href="?subject=power&showpath=1">用户、角色及权限</a></dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="advsearch" Visible="false" runat="server">
            <div class="path">操作路径： 鼠标移到导航区“<%= ims.Sys.DataCenterText %>”处，点“搜索”；或点顶部“搜索”图标，再点下面“高级搜索”链接；或在左侧栏导航区，鼠标移到 <img src="images/find.png" /> 标签下，点击要搜索的项</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>在高级搜索中，最多可设定五个条件，每一个条件需要指定字段、匹配模式及匹配的值。例如，搜索成年人，可依次设置：年龄、大于、18。每一个条件都通过其上方的"并且"或"或者"，来与之前的条件（它们组合后作为一个整体）相组合。如：颜色为蓝点，或者颜色为红色，并且价格大于100元，表示搜索这两种颜色的价格高于100元的记录。</p>
                </dd>
                <dt>在条件中使用变量或字段</dt>
                <dd>
                    <p>可在条件中使用字段或变量代码（可在提示处查询）。例如，设置“部门”等于“$UserUnit$”，表示匹配部门字段为当前用户直属机构的记录。</p>
                    <p>提示：要获取非直属机构名称，可用“$UserUnit2$”这样的代码，表示取用户直系第二层次机构的名称（组织机构根节点的层次为0）。</p>
                </dd>
                <dt>日期时间字段搜索示例</dt>
                <dd>
                    <ul class="decoration">
                        <li><span class="term">在【上】【月】</span>搜索上个自然月内的记录</li>
                        <li><span class="term">在【未来】【2】【周】</span>从此时此刻开始的接下来2周时间内</li>
                        <li><span class="term">在【过去】【2】【月】</span>从此时此刻开始倒推两个月的这段时间内</li>
                        <li><span class="term">在【之前】【2】【月】</span>本月之前的两个自然月内</li>
                        <li><span class="term">等于【2017年5月】</span>2017年5月的记录</li>
                        <li><span class="term">等于【2016】</span>2016年的记录</li>
                        <li><span class="term">介于【2017年12月1日 2017年12月5日】</span>匹配“2017-12-1 0:00:00 至 2017-12-5 23:59:59”的记录</li>
                        <li><span class="term">止于【2017年7月】</span>匹配截止到 2017-7-31 23:59:59 的记录</li>
                        <li><span class="term">大于【发货时间】</span>搜索晚于发货时间（此处应填写发货时间字段的代码）的记录</li>
                    </ul>
                    <p>注：1、日期时间字段，遵循"2017年5月等于2017年；2017年包含2017年5月"这样的逻辑；</p>
                    <p>　　2、"在过去…"和"在未来…"，是以此时此刻为界，"在之前…"和"在之后…"是以当前周期为界。假设此时为 2019年5月16日12:30:00，则"在过去2月"表示从 2019年3月16日12:30:00 到 2019年5月16日12:30:00；"在之前2月"表示从 2019年3月1日0:00:00 到 2019年4月30日23:59:59。</p>
                </dd>
                <dt>搜索示例</dt>
                <dd>
                    <p>假定要在一个"通讯录"中搜索姓"张"或姓"王"的成年人，那么可以如下设置：</p>
                    <p>条件一（"姓名"始于"张"）<span class="key">或者</span> 条件二（"姓名"始于"王"）<span class="key">并且</span> 条件三（"年龄"大于"18"）。</p>
                </dd>
                <dt>保存搜索设置</dt>
                <dd>
                    <p>如果有权限，可点“保存”按钮，将当前的条件设置保存为公共的过滤器，或私有的快捷方式，或保存为版式（详见：<a href="?subject=searchLayout">搜索版式</a>）。</p>
                </dd>
                <dt>说明</dt>
                <dd>
                    <ul class="decoration">
                        <li><span class="term">无关键字搜索</span>如果不输入关键字，表示搜索该字段内容为空的记录。</li>
                        <li><span class="term">日期字段搜索</span>对于日期时间类型字段，可使用“在上（月/周/季/年/日）”之类的模式进行快速搜索。</li>
                        <li><span class="term">"介于"模式</span>使用“介于”模式，表示搜索指定字段介于这两个值之间（并包含这两个值）的记录。</li>
                        <li><span class="term">"始于"、"止于"模式</span>对于日期时间和数字类型，"始于"、"止于"可理解为大于等于和小于等于（如“生日”始于1980，表示搜索1980年1月1日后出生的人员）；对其它类型，则表示以指定的关键字开头或结尾（如“姓名”始于“李”，表示搜索所有姓李的人员）。</li>
                        <li><span class="term">"包含/不包含"模式下，多选列表/用户名/机构名字段、允许多项输入的输入提示字段的匹配规则：</span><br />
                            在顶栏右侧搜索，或点击“搜索”图标搜索，将执行模糊匹配。如"abc，def"，将认为包含"ab"；<br />
                            在高级搜索或其它条件设置中，将执行完整匹配。如"abc，def"，将认为不包含"ab"，但包含"abc"。在这种情况下，可<span class="red">在关键字前添加下划线"_"来指示进行模糊匹配</span>。
                        </li>
                    </ul>
                </dd>

            </dl>
        </asp:Panel>

        <asp:Panel runat="server" ID="searchLayout" Visible="false">
            <div class="path">操作路径： 进入高级搜索，设置条件并点"保存" - "保存为版式"</div>
            <dl>
                <dt>什么是搜索版式？</dt>
                <dd>
                    <p>搜索版式，是将搜索设置的条件保存下来，并指定其中一个或多个条件由搜索时指定（其余条件采用当前的设置）。在使用该版式搜索时，只显示需要用户指定的条件，并在执行搜索时将其应用到预设的模式中进行搜索。</p>
                    <p>搜索版式，相当于是一个确定了占位条件的过滤器，只不过占位条件是在搜索时指定的，这就比过滤器多了灵活性而少了便捷性。</p>
                    <p>例如，版式中设置了两个条件：审核状态为“是”，并且日期在某个时间段，保存版式时若将第二个条件勾选为搜索时指定，那么在搜索时，只会让用户指定起止日期，搜索结果就是这个时段内所有已审核的记录。</p>
                    <p>关于搜索版式的默认版式设置、删除等操作，请参考：<a href="?subject=searchLayoutManage">版式管理</a></p>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="search" Visible="false" runat="server">
            <div class="path">操作路径： 点击顶部搜索图标，打开后点击底部的"快搜"</div>
            <dl>
                <dt>什么是快搜？</dt>
                <dd>
                    <p>快搜，是使用预设的过滤器或搜索版式进行快速搜索，可直接呈现搜索结果的图表、报表或指定视图。</p>
                </dd>
                <dt>说明</dt>
                <dd>
                    <ul class="decoration">
                        <li>建议先进入高级搜索，预设条件并保存为过滤器或搜索版式，以便在快搜页面直接使用它们。</li>
                        <li>管理员可点"生成链接"按钮，得到预设了视图或过滤器/搜索栏的页面链接，从而将链接添加到适当的地方，方便使用。</li>
                    </ul>
                </dd>
				<dt>相关主题</dt>
				<dd class="related"><a href="?subject=filters">过滤器</a><a href="?subject=advsearch">高级搜索</a></dd>
            </dl>
        </asp:Panel>
        <asp:Panel runat="server" ID="searchLayoutManage" Visible="false">
            <div class="path">操作路径： 进入高级搜索，点"版式"按钮，选"管理版式"</div>
            <dl>
                <dt>如何进行版式管理？</dt>
                <dd>
                    <p>在"管理版式"对话框中，可对已有的版式进行设为默认、更名和删除等操作；以及添加、编辑或删除默认版式规则。</p>
                </dd>
                <dt>什么是默认版式规则？</dt>
                <dd><p>默认版式规则，可以为不同角色指定不同的默认搜索版式。</p></dd>
                <dt>说明</dt>
                <dd>
                        <ul class="decoration">
                        <li>默认版式规则优先于设为默认的版式；用户手工选择的版式则优先于任何默认版式设置。</li>
                        <li>默认版式规则中，越靠后面，优先级越高。</li>
                        <li>如果勾选了“禁止普通用户切换版式”选项，则对该模板没有完全控制权限者，将不会显示版式切换按钮。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="filters" Visible="false" runat="server">
            <div class="path">操作路径： <%= ims.Sys.DataCenterText %>，模板上点右键 - 过滤器</div>
            <dl>
                <dt>什么是过滤器？</dt>
                <dd><p>过滤器隶属于特定的模板，是对基于该模板的记录进行筛选的一组条件逻辑。设置过滤器的方法和效果均与针对该模板的高级搜索一致，只不过它将这种高级搜索的条件设置进行了命名并保存下来而已。</p></dd>
                <dt>如何设置过滤器？</dt>
                <dd><p>设置过滤器条件的方法与在<asp:HyperLink ID="HyperLink17" runat="server" NavigateUrl="help.aspx?subject=advsearch">高级搜索</asp:HyperLink>
                    中设置搜索条件完全相同。在设置完成后需要输入一个名称来保存该过滤器。选项“对访问者隐藏该过滤器”勾选后，在模板的右键菜单项”打开“中将看不到该过滤器。</p></dd>
                <dt>在条件中使用变量</dt>
                <dd><p>在条件中填写的变量，执行搜索时会替换为当时情况下合适的值。比如，设置条件“[创建人]”等于“$UserName$”，并保存为过滤器，那么当某个用户打开该过滤器时，将只能看到由他自己添加的记录。</p></dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="datahome" Visible="false" runat="server">
            <div class="path">操作路径： 点顶部“搜索”图标</div>
            <dl>
                <dt>如何搜索？</dt>
                <dd>
                    <p>在搜索框上方设定搜索范围后，输入关键字并回车或点击“搜索”按钮，即可执行搜索。搜索设置会自动记忆。请熟悉以下的搜索规则和技巧：</p>
                    <ul class="decoration">
                        <li><span class="term">指定搜索范围</span>指定一个具体的搜索范围，不但搜索更准确快速，而且会有自动完成功能给予辅助。</li>
                        <li><span class="term">无关键字搜索</span>如果不输入关键字直接点搜索按钮，那么：若搜索范围指定为“<%= ims.Sys.DataCenterText %>”或“<%= ims.Sys.InfoCenterText %>”，将会进入<%= ims.Sys.DataCenterText %>或<%= ims.Sys.InfoCenterText %>；若指定了某个模板，则会打开这个模板的数据；若同时还指定了字段，关键字留空则表示搜索该字段内容为空的记录。</li>
                        <li><span class="term">多关键字搜索</span>如果搜索范围为“<%= ims.Sys.DataCenterText %>”或某个模板，输入以空格分隔的多个关键字，如“A B”，则当搜索模式为“包含”模式，表示包含A或B；若是“包含全部”模式，表示既包含A又包含B；若是“不包含”，表示既不包含A也不包含B；若是含有“等于”二字的模式，则不按空格拆分，而作为一个整体进行匹配。</li>
                        <li><span class="term">日期字段搜索</span>对于日期时间类型字段（遵循“2017年5月等于2017年；2017年包含2017年5月”这样的逻辑），关键字"2017-2-8"匹配当天24小时内这一时间段，"2017-2"匹配整月，"2017"匹配整年。如，可以输入"2017-2"来搜索2月份的订单。可点击输入框上面的日历图标选择日期，或从提示列表（其中包含当天、当月第一天等特殊日期）中选择。如需指定精确的时间，可按“<span class="red">2017-03-21 12:53:00</span>”这种格式输入。</li>
                        <li><span class="term">是/否型字段搜索</span>对于“是/否”类型字段，可以输入"是"，"Yes"，"1"，"True"搜索肯定状态的记录；"否"，"No"，"0"，"False"搜索否定状态的记录。</li>
                        <li><span class="term">"介于"模式</span>使用“介于”模式，可输入以空格分隔的两个关键字，表示搜索指定字段介于这两个值之间的记录。如，可输入“18 50”来搜索年龄在18到50岁的人员；输入“2015 2017”来搜索2015年初到2017年底之间签订的合同。</li>
                        <li><span class="term">"始于"、"止于"模式</span>对于日期时间和数字类型，"始于"、"止于"可理解为大于等于和小于等于（如“生日”始于1980，表示搜索1980年1月1日后出生的人员）；对其它类型，则表示以指定的关键字开头或结尾（如“姓名”始于“李”，表示搜索所有姓李的人员）。</li>
                        <li><span class="term">限定目录</span>若勾选“限定目录”，则仅在指定的目录中搜索符合条件的记录。</li>
                        <li><span class="term">"包含/不包含"模式下，多选列表/用户名/机构名字段、允许多项输入的输入提示字段的匹配规则：</span><br />
                            在顶栏右侧搜索，或点击“搜索”图标搜索，将执行模糊匹配。如"abc，def"，将认为包含"ab"；<br />
                            在高级搜索或其它条件设置中，将执行完整匹配。如"abc，def"，将认为不包含"ab"，但包含"abc"。在这种情况下，可<span class="red">在关键字前添加下划线"_"来指示进行模糊匹配</span>。
                        </li>
                    </ul>
                </dd>
                <dt>快捷方式相关</dt>
                <dd>
                    <ul class="decoration">
                        <li>直接点击快捷方式名称，可打开该快捷方式。</li>
                        <li>快捷方式的不同图标，表明了快捷方式的类型。如，目录、特定模板、筛选条件等。</li>
                        <li>点击快捷方式右边的删除图标，可删除该快捷方式。</li>
                    </ul>
                    <p>说明：快捷方式保存的是当时的浏览条件，其结果可能会随数据的更改或权限的变化而不同。</p>
                </dd>
                <dt>收藏夹相关</dt>
                <dd>
                    <ul class="decoration">
                        <li>直接点击收藏夹中的任一项，可以打开其详细内容页面。</li>
                        <li>可以一次性选中多项，再点击“打开选中项”来查看，或点击“删除选中项”来从收藏夹中删除。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="chart" Visible="false" runat="server">
            <div class="path">操作路径： 鼠标移到左侧导航区“切换视图”（或显示为“最近浏览的数据”）处，点“图表视图”</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>图表视图，是对当前浏览的一批记录的图表表现方式，能对事物的同一属性按给定指标直观地反映出统计结果。</p>
                </dd>
                <dt>示例</dt>
                <dd>
                    <p>假设要以图表方式表现出所有员工不同学历的工资水平，可以这样设置图表选项：</p>
                    <p>图表类型：柱状图；分组字段：学历；统计指标：月薪；统计方法：平均值；排序方式：降序。</p>
                </dd>
                <dt>管理图表</dt>
                <dd><p>点击"图表管理"按钮，可对已保存的图表进行更名、删除，设为默认图表等操作。详见：<a href="?subject=chartManage">版式管理</a></p></dd>
                <dt>技巧</dt>
                <dd>
                    <dl class="listdefine">
                        <dt>多个统计字段时，可否调整顺序？</dt>
                        <dd>有多个可统计字段时，可用鼠标拖动调整字段顺序，从而调整它们在图表中的顺序。图表的排序设置"升序"或"降序"，是根据第一个统计字段来排序的。</dd>
                        <dt>如何自己指定分组区间？</dt>
                        <dd>如果按数字或日期时间字段分组，会出现“分组方法”选项，可指定按每个值分组、自动分组（对日期时间字段，还可选择按年或按月等自动分组方式），或手动分组。如果选择手动分组，可以在后面的文本框中输入作为分隔点的值。例如，要以五年为一个单位来统计销售收入情况，假设所有数据是介于1997～2008年之间的，那么可以输入“2000-1-1,2005-1-1”，表示将2000年1月1日以前的作为一段，到2005年1月1日之间的作为一段，最后的作为一段。</dd>
                        <dt>如何保存生成的图表？</dt>
                        <dd>点"导出"按钮，选择一种图片格式，即可将图表保存为图片文件。</dd>
                    </dl>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="cart" Visible="false" runat="server">
            <div class="path">操作路径： 首页，点“我的购物车”图标</div>
            <dl>
                <dt>概述</dt>
                <dd><p>购物车中以表格形式列出了已选购而尚未提交订单的商品。在这里可以修改商品的订购数量、删除某种或全部商品。以匿名方式所选购的商品同样会保存在购物车中，在提交订单时可以登录自己的帐户，或直接以匿名方式提交订单。提交之后，购物车将自动被清空。</p></dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="DesignProtect" Visible="false" runat="server">
            <div class="path">操作路径： 系统管理 &raquo; 系统设置，在"杂项"下点"模板保护设置"</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>模板保护，用于对指定的模板用指定的密码进行保护，以防止未经授权的修改或导出模板/备份数据等操作。</p>
                    <p>设置保护后，如果没有正确的密码，即使是系统管理员，也不能修改该设置，不能进入该模板的设计页面，不能导出保护的模板，也不能备份这些模板的数据。</p>
                    <p>在登录后只需在以上任一需要验证密码之处验证通过，则在退出系统之前无需再次验证。</p>
                </dd>
                <dt>注意！</dt>
                <dd>
                    <p>所设置的保护密码，请一定记好。一旦遗忘，没有任何找回该密码的渠道。因此，也请慎重使用该功能！</p>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="weixin" Visible="false" runat="server">
            <div class="path">操作路径： 系统管理 &raquo; 系统设置 &raquo; 功能选项，勾选"启用微信功能"，点"微信功能设置"</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>微信公众平台包括<a href="http://kf.qq.com/faq/120911VrYVrA150918fMZ77R.html" target="_blank">服务号</a>、<a href="http://kf.qq.com/faq/120911VrYVrA15091832Qzqq.html" target="_blank">订阅号</a>和<a href="https://work.weixin.qq.com" target="_blank">企业微信</a>等，主要用于企业或组织面向公众提供信息发布、通知、响应用户查询请求等。了解更多：<a href="http://baike.baidu.com/view/9212662.htm" target="_blank">微信公众平台</a>、<a href="https://kf.qq.com/faq/170815aUZjeQ170815mU7bI7.html" target="_blank">几种公众平台对比和区别</a>。</p>
                    <p>由于需要与微信服务器双向交互，本系统必须能够访问互联网，且能被互联网访问，并设置了正确的"互联网访问地址"，才能接入。</p>
                </dd>
                <dt>企业微信、服务号/订阅号，该如何选择？</dt>
                <dd>
                    <p>企业微信没有发送消息数量的限制，用户绑定是通过将企业微信通讯录中的帐号设置到用户的“微信帐号”来实现，适用于企业内部；服务号/订阅号由用户关注后自行绑定或注册帐户，发送消息给用户有数量限制，适合于面向客户或公众。二者的数据查询功能是一样的。</p>
                </dd>
                <dt>企业微信接入步骤</dt>
                <dd>
                    <p>1. <a href="https://work.weixin.qq.com/wework_admin/register_wx" target="_blank">注册企业微信</a>。</p>
                    <p>2. <a href="https://work.weixin.qq.com/wework_admin/loginpage_wx" target="_blank">登录企业微信</a>，点上方"通讯录"，添加机构和成员，同时邀请被添加的成员加入。</p>
                    <p>3. 点击上方"我的企业"，记下CorpID值。</p>
                    <p>4. 点击上方"企业应用"，"添加应用"，输入名称等信息，点"创建应用"，记下应用的AgentId和Secret，再点"接收消息"处的"设置"，填入URL（即本系统weixin.aspx页面的互联网地址<span runat="server" id="wxUrl"></span>），并随机获取Token和EncodingAESKey，暂勿保存。</p>
                    <p>5. 在本系统启用微信功能，在微信设置界面，点"添加应用"，输入名称和前两步得到的CorpID、AgentId、Secret、Token和EncodingAESKey，点确定。再回到上一步的企业微信界面，点保存，完成配置。</p>
                    <p>最后，在系统中设置角色的微信功能权限、用户的微信帐号（企业微信通讯录中的帐号，非微信号），就可以在系统的提醒或通知中使用微信方式了，也可以直接给用户发送微信消息。</p>
                </dd>
                <dt>服务号/订阅号接入步骤</dt>
                <dd>
                    <p>1. <a href="https://mp.weixin.qq.com/cgi-bin/registermidpage?action=index" target="_blank">注册服务号/订阅号</a>。</p>
                    <p>2. <a href="https://mp.weixin.qq.com/" target="_blank">登录服务号/订阅号</a>，点右上方帐号图标，帐号详情，找到"原始ID"，复制备用。</p>
                    <p>3. 在左侧菜单栏，点"开发"下的"基本配置"，将开发者ID(AppID)复制备用，生成开发者密码(AppSecret)复制备用。</p>
                    <p>4. 在"服务器配置"处，点"修改配置"，在 URL 处填入本系统 weixin.aspx 页面的互联网地址<span runat="server" id="wxUrl2"></span>，Token 处填入一个自己的密码，EncodingAESKey处，点"随机生成"，"消息加解密方式"选"安全模式"。</p>
                    <p>5. 在本系统启用微信功能，在微信设置界面，点"添加应用"，输入名称并选择应用类型，再分别填入前两步得到的AppID、Account（即第 2 步中的原始ID）、AppSecret、Token 和 EncodingAESKey，点确定。再回到上一步的服务器配置界面，点提交，成功后，点"启用"。</p>
                    <p>最后，就可以关注该公众号，输入任意内容，测试是否正常响应。</p>
                    <p>启用服务器配置后，自定义菜单就被停用了。要用自定义菜单，可以这样来重新启用：先停用服务器配置，再开启并设置菜单，再重新启用服务器配置，再点左侧的"添加功能插件"，点"自定义菜单"，开启。</p>
                </dd>
                <dt>接收微信客户端发来的图片、语音和视频等文件</dt>
                <dd>
                    <p>在微信功能设置的“选项”标签页中，可勾选“接收微信客户端发来的文件，存入目录”，这样，用户就可以随时使用微信发送图片、语音或视频给企业微信/公众号，系统将自动存入指定目录。</p>
                </dd>
                <dt>微信客户端如何查询数据？</dt>
                <dd>
                    <p>微信客户端可发送"Q"开始查询操作，输入"?"了解查询语法。如，输入"2.5 重庆"，查询表2中字段5包含"重庆"的记录。如果关键字不是数字，也可省略空格，如：2.5重庆。</p>
                </dd>
                <dt>通过微信消息发布<%= ims.Sys.InfoType %></dt>
                <dd>
                    <p>在微信中按"<span class="red"># 标题(换行)内容</span>"的格式发送消息，即可在系统中发布<%= ims.Sys.InfoType %>。如：</p>
                    <p style="color:#080;text-indent:0;padding-left:2em"># 会议通知<br />下午14:30，在第二会议室召开方案评审会议…</p>
                    <p>若需指定发布的栏目，可在标题中加上"<span class="red">{栏目}</span>"，如：<span class="green"># {通知}会议通知</span></p>
                    <p>发布内容支持 <a href="https://www.jianshu.com/p/191d1e21f7ed" target="_blank">Markdown 语法</a>，以简单的标记呈现丰富的样式。</p>
                </dd>
                <dt>说明</dt>
                <dd>
                    <ul class="decoration">
                        <li>若有多个微信应用，则微信应用后台设置中的URL需要加上应用的ID值作为参数，如：http://xxx.com/weixin.aspx?app=Aedk。</li>
                        <li>若有多个微信应用，在系统中发送微信消息时，将使用默认的应用。服务号/订阅号发送消息有诸多限制（详见下文），不建议用于主动发送消息。</li>
                        <li>若要在微信客户端打开菜单链接时能自动登录，对于企业微信，需在后台设置可信域名，即“接收消息”设置中URL的域名；对于已认证的服务号，需在后台点右上方帐号图标-功能设置，设置业务域名和网页授权域名，与系统的互联网访问地址的域名一致。</li>
                        <li>在企业微信通讯录中添加成员时，建议将成员帐号设为与微信号一致，以简化管理并避免混淆。</li>
                        <li>在微信客户端发送图片时，建议选中"原图"，以免图片被自动缩小。</li>
                    </ul>
                </dd>
                <dt>常见问题</dt>
                <dd>
                    <dl class="decoration">
                        <dt>企业微信发送消息出错</dt>
                        <dd><p>微信功能需要外网可访问系统，因此首先要确保在微信后台配置的回调地址是可以从外网访问的；其次，本系统中用户的"微信"一项，要填写企业微信通讯录中的成员帐号，而不是微信号（二者可能相同也可能不同）。</p></dd>
                        <dt>微信中收不到企业微信消息</dt>
                        <dd><p>如果安装了企业微信客户端，它将接管来自企业微信的消息。可在其"设置-新消息通知-仅在企业微信中接收消息"，关闭相关选项，个人微信就能收到消息了。</p></dd>
                        <dt>服务号/订阅号发送消息出错，或收不到</dt>
                        <dd>
                            <p>服务号/订阅号向用户发送消息，有以下条件和规则：</p>
                            <ul class="decoration">
                                <li>经过认证的公众号，才有权限发送消息；</li>
                                <li>需在公众号后台的"开发"-"基本配置"-"IP白名单"处，将本系统服务器IP地址加入白名单；</li>
                                <li>每月最多发送 100 次消息，且对于每个用户，服务号每月仅可发送4条，订阅号每天仅可发送1条，超出后，即使显示发送成功，用户也收不到；</li>
                                <li>未关注公众号的、被加入黑名单的、关注但未绑定账户的，不会收到消息；</li>
                                <li>发送消息后会有所延迟，可以过几分钟再检查。</li>
                            </ul>
                        </dd>
                        <dt>redirect_uri参数错误</dt>
                        <dd><p>这通常出现于从微信收到的消息中打开链接时。需要在企业微信的应用中"网页授权及JS-SDK"处设置可信域名，且可信域名必须已备案。</p></dd>
                        <dt>redirect_uri需使用应用可信域名</dt>
                        <dd><p>需要在企业微信的应用中设置可信域名，并且要和本系统设置的“系统互联网访问地址”中的域名一致。</p></dd>
                        <dt>redirect_uri域名与后台配置不一致</dt>
                        <dd><p>需要在服务号/订阅号中设置网页授权域名，并且要和本系统设置的“系统互联网访问地址”中的域名一致。域名要求已备案，不支持IP地址和端口号。</p></dd>
                    </dl>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel runat="server" ID="hotline" Visible="false">
            <div class="path">操作路径： 系统管理 &raquo; 系统设置 &raquo; 功能选项，勾选"启用来电弹屏功能"，点"来电弹屏设置"</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>来电弹屏，是指有电话拨入时，系统自动弹出该来电号码相应的客户信息，及其历史来电记录。使用该功能，需要单独购买功能授权和相应的USB录音盒及配套软件，在正确设置并连接硬件设备后，有权限的人员在登录系统后即具有来电弹屏功能。</p>
                </dd>
                <dt>如何启用和设置来电弹屏？</dt>
                <dd>
                    <p>系统管理员登录后，进入系统管理 &raquo; 系统设置 &raquo; 功能选项，勾选"启用来电弹屏功能"，保存设置。然后点击"来电弹屏设置"，指定当客户来电时，电话号码与到客户信息表中的哪个字段匹配（从而在来电时弹出该客户信息页面），以及与来电历史记录表中的哪个字段匹配（从而提取该号码的历史来电记录）、录音文件保存在哪个字段。最后指定允许来电弹屏功能的角色。</p>
                    <p>若有必要，可只指定客户信息表或来电历史记录表；录音文件字段也可选择“无”从而不予录音。</p>
                </dd>
                <dt>操作员在客户端如何使用来电弹屏功能？</dt>
                <dd>
                    <p>一、连接USB录音盒。先将USB线连接录音盒和电脑，电话进线拔下来插入录音盒LINE口，附带的电话线连接录音盒PHONE口和电话机；</p>
                    <p>二、<a href="https://landian.cc/download/callingpop.rar" target="_blank">下载软件包</a>，安装设备驱动和服务程序；</p>
                    <p>三、允许来电弹屏的用户，在登录后，即可在客户来电时，弹出页面显示该客户的相关信息并记录本次来电。</p>
                </dd>
                <dt>如何拨打电话？</dt>
                <dd>
                    <p>可以通过连接的电话机手工拨号；或在系统中首页点击“拨打电话”图标，输入电话号码后自动拨打。</p>
                </dd>
                <dt>注意</dt>
                <dd>
                    <p>由于设备是在响铃第二声才会发送弹屏信号，因此有电话拨入时，请在弹出窗口之后再接电话。</p>
                </dd>
                <dt>来电时没反应/不能拨出电话？请检查：</dt>
                <dd>
                    <ul class="decoration">
                        <li>系统设置中是否已启用来电弹屏功能</li>
                        <li>当前用户是否属于有操作权限的角色</li>
                        <li>设备是否已正确连接</li>
                        <li>配套软件 setup_agent.exe 是否已安装</li>
                        <li>软件的服务 123_web_msg_proxy 是否已启动</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="detaillayout" Visible="false" runat="server">
            <div class="path">操作路径： 详情视图下，点下面的“版式”按钮。如果弹出菜单，点“版式管理”</div>
            <dl runat="server" id="tableLayout">
                <dt>如何进行表格版式排版？</dt>
                <dd>
                    <p>详细内容页面的默认版面是程序自动生成的，通常需要以手工方式调整版面来使得版面更为美观。</p>
                    <p>表格式排版的版面分为A、B、C三个区，A区和B区是并列显示的，C区则在底部通栏显示（常用于放置内容较多的字段）。可以用鼠标拖动字段名称来调整其所在的区域或在区域中的顺序；拖动“➜|”标记可调整列的宽度。调整好之后点击“确定”按钮来将排版结果保存下来，在之后浏览相同模板的记录时，将会按所设置的版面来显示。最好在A、B两个区域中放置相同数量的字段，否则在显示时会出现空的单元格，影响美观。</p>
                    <p>不需要显示的字段，可拖入“回收站”区域。</p>
                </dd>
            </dl>
            <dl runat="server" id="freeLayout">
                <dt>如何进行自由排版？</dt>
                <dd>
                    <p>使用自由排版，可以像在Word中那样按自己想要的样式编排内容和格式，其中可插入字段标记或变量标记，这些标记在浏览时会被替换为其对应的值。</p>
                    <p>字段的标记代码可以在右下方“代码速查”处查询。</p>
                    <p>技巧1：如果想将编辑器中的版面初始化为之前所保存的表格版式，只需清空编辑器并输入命令“Reset”，点击“确定”即可；也可输入命令“Auto”来自动生成版式。</p>
                    <p>技巧2：可在编辑器中点 <img src="images/tabs.gif" /> 插入多标签页(选项卡)来分区组织内容、插入分页符控制打印分页。<asp:HyperLink ID="HyperLink27" NavigateUrl="help.aspx?subject=editor" runat="server">详细</asp:HyperLink></p>
                </dd>
                <dt id="query">用自由排版来显示关联记录</dt>
                <dd>
                    <p>自由排版时，可在左下方定义查询（用于获取相关的数据），并用以下方式在版式中插入代码来显示查询结果（假设查询为$D0）：</p>
                    <ul class="decoration">
                        <li><span class="term">$D0.Table</span>以表格形式显示查询结果（可用 <span class='red'>$D0.Report.Clear</span> 形式指定不应用条件格式）；</li>
                        <li><span class="term">$D0.Report</span>以报表形式展示查询结果（可用 <span class='red'>$D0.Report.报表名</span> 形式指定使用哪个报表设置）；</li>
                        <li><span class="term">$D0.Chart</span>以图表形式展示查询结果（可用 <span class='red'>$D0.Chart.图表名</span> 形式指定使用哪个图表设置）；</li>
                        <li>插入一个表格，并在表格标题行的下一行每个单元格中引用该查询，如"$D0.[F923D].R"，这样将为每条查询结果生成一行(可用 <span class='red'>$D0.No</span> 显示序号)；</li>
                        <li>用形如 <span class="red">$D0.[F923D]</span> 的代码，显示查询结果中字段"F923D"的值。默认只显示第一条记录，可添加".R"以显示所有值，如"$D0.[F923D].R"；</li>
                        <li>用形如 <span class="red">$D0.[F923D].Sum</span> 的代码，显示查询结果中指定字段的统计值。Sum 可替换为：</li>
                    </ul>
                    <ul style="margin-left:40px">
                        <li><span class="term">Sum</span>合计</li>
                        <li><span class="term">Avg</span>平均值</li>
                        <li><span class="term">Max</span>最大值</li>
                        <li><span class="term">Min</span>最小值</li>
                        <li><span class="term">Var</span>方差</li>
                        <li><span class="term">Stdev</span>标准偏差</li>
                        <li><span class="term">Count</span>计数</li>
                    </ul>
                </dd>
                <dt>如何使自由排版的页面支持就地编辑？</dt>
                <dd>
                    <p>表格版式的页面，在浏览时可以双击单元格进行就地编辑，自由排版要实现这种功能，需如下处理：</p>
                    <p style="text-indent:0;padding-left:2em">
                        在编辑框中点“源码”按钮切换到源代码视图，找到字段代码所在的HTML元素，如：<br />
                        <span class="green">&lt;td&gt;姓名&lt;/td&gt;&lt;td&gt;[F929105C6q12837]&lt;/td&gt;</span><br />
                        <span>在起始标签中添加fid属性，如：</span><br />
                        <span class="green">&lt;td&gt;姓名&lt;/td&gt;&lt;td <span class="red">fid="35"</span>&gt;[F929105C6q12837]&lt;/td&gt;</span><br />
                        <span>这儿的“35”是指字段的ID号，就是“代码速查”处显示在字段名后面括号中的数字。</span><br />
                        <span>这样保存后，浏览时就可以双击所显示的字段值来编辑了。</span>
                        </p>
                    <p>提示：不论字段代码放在什么地方，都可以通过在包含它的HTML标记中添加fid属性支持就地编辑。以“$D0.Table”这种表格形式显示的关联记录，系统会自动添加就地编辑功能。</p>
                </dd>
                <dt>字段的特殊显示格式</dt>
                <dd>
                    <p>默认情况下，版式中的字段代码在浏览时将按正常方式呈现它的值。但有些字段也可以在查询代码时，选择以下特殊格式：</p>
                    <ul class="decoration">
                        <li><span class="term">条形码/二维码</span>将字段值显示为条形码或二维码（详见下一节）；</li>
                        <li><span class="term">大写数字</span>如，4520将显示为“肆仟伍佰贰拾”；</li>
                        <li><span class="term">原始图片</span>按原始尺寸显示图片（而不是缩略图）；</li>
                        <li><span class="term">横排选项</span>将单选列表或多选列表字段的所有选项都显示出来，横向排列；</li>
                        <li><span class="term">竖排选项</span>将单选列表或多选列表字段的所有选项都显示出来，竖向排列。</li>
                    </ul>
                </dd>
                <dt>关于条形码和二维码</dt>
                <dd>
                    <p>条形码（一维）和二维码统称为条码，是按照一定的规则编码产生的用以表达一组信息的图形标识符，是广泛应用于商业、邮政、物流等领域的一种自动识别技术，具有输入快、成本低、可靠性强等优点。以下介绍几种主要的条码类型：</p>
                    <ul class="decoration">
                        <li><span class="term">EAN码</span> 是国际通用的符号体系，表达一组固定长度的数字，主要应用于商品标识；</li>
                        <li><span class="term">CODE 39/128码</span> 为目前国内企业内部自定义码制，可编码不定长的数字和字母；</li>
                        <li><span class="term">QR Code（二维码）</span> QR Code是最常见的一种二维码，其信息容量大、可靠性高、可快速识别、保密防伪性强，可表示字母、数字和汉字。</li>
                    </ul>
                    <p>注：不同的条码类型有不同的规则要求，不符合规则的文本将不会产生条码图形，或者会被程序自动纠正（如"1234567890123"，采用EAN-13编码，最后一位会被修改为8）。</p>
                    <p style="text-align:right"><a href="https://baike.baidu.com/item/%E6%9D%A1%E5%BD%A2%E7%A0%81" target="_blank">了解关于条码的更多知识…</a></p>
                </dd>
                <dt>管理版式</dt>
                <dd><p>点击"管理版式"按钮，可对现有的版式进行更名、编辑、删除，设为默认版式等操作。详见：<a href="?subject=detailLayoutManage">版式管理</a></p></dd>
                <dt>技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>系统对详情页限制了宽度，若想取消限制，可在<a href="?subject=cssplugin">外挂样式</a>中添加一行：<span class="red">#detail body{max-width:100%}</span>，或在版式源码前面添加一行：<span class="red">&lt;div style="width:1500px"&gt;</span>，在最后添加一行：<span class="red">&lt;/div&gt;</span></li>
                        <li>若希望有些内容在浏览时隐藏，仅打印出来可见，可以使用"forPrint"样式类。如（源码）：<br /><span class="red">&lt;p class="forPrint"&gt;这一段打印出来才能看到！&lt;/p&gt;</span></li>
                        <li>反之，若希望浏览时可见，打印时隐藏，可以使用"forScreen"样式类。如（源码）：<br /><span class="red">&lt;p class="forScreen"&gt;这一段不会打印出来！&lt;/p&gt;</span></li>
                        <li>以 $D0.Table 形式分页显示查询结果时，若希望每页产生固定的表头/表脚，请在版式中添加表头/表脚模板，设置其样式类为 paging-header 或 paging-footer。如：<span class='red'>&lt;p class="paging-header"&gt;...&lt;/p&gt;</span></li>
                        <li>更多有用的样式类，请查看<a href="?subject=cssclass">常用样式类</a>。</li>
                    </ul>
                </dd>
				<dt>相关主题</dt>
				<dd class="related"><a href="?subject=editor">编辑器</a><a href="?subject=cssclass">常用样式类</a></dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="cssclass" Visible="false" runat="server">
            <dl>
                <dt>常用样式类</dt>
                <dd>
                    <ul class="decoration">
                        <li><span class="term">hide</span>隐藏</li>
                        <li><span class="term">forPrint</span>仅打印出来可见</li>
                        <li><span class="term">forScreen</span>仅屏幕上可见，打印出来不可见</li>
                        <li><span class="term">indent</span>首行缩进两个字</li>
                        <li><span class="term">pageTitle</span>居中的较大字号的标题</li>
                        <li><span class="term">highlight</span>高亮显示，带圆角边框和背景</li>
                        <li><span class="term">bluebox</span>带边框的浅蓝色区域</li>
                        <li><span class="term">left</span>靠左显示</li>
                        <li><span class="term">center</span>水平居中显示</li>
                        <li><span class="term">right</span>靠右显示</li>
                        <li><span class="term">larger</span>字号增大10%</li>
                        <li><span class="term">large</span>字号增大33%</li>
                        <li><span class="term">mtop_s</span>距上方3像素</li>
                        <li><span class="term">mtop_n</span>距上方12像素</li>
                        <li><span class="term">mtop_l</span>距上方24像素</li>
                        <li><span class="term">mbottom_s</span>距下方3像素</li>
                        <li><span class="term">mbottom_n</span>距下方12像素</li>
                        <li><span class="term">mbottom_l</span>距下方24像素</li>
                        <li><span class="term">btn</span>按钮样式</li>
                        <li><span class="term">corner</span>具有圆角</li>
                        <li><span class="term">textshadow</span>有阴影的文字</li>
                        <li><span class="term">ell</span>将显示不完的字符以省略号显示（仅对指定了宽度的元素有效）</li>
                        <li><span class="term">noselect</span>文字不可选中</li>
                        <li><span class="term">reset</span>重置为系统默认基础样式</li>
                    </ul>
                </dd>
                <dt>用于表格的样式类</dt>
                <dd>
                    <ul class="decoration">
                        <li><span class="term">normal</span>表格框线显示为细线条</li>
                        <li><span class="term">hr</span>仅显示每行的下边框线</li>
                        <li><span class="term">grayline</span>灰色表格框线</li>
                        <li><span class="term">blackline</span>黑色表格框线</li>
                        <li><span class="term">noline</span>无表格框线</li>
                        <li><span class="term">seprow</span>表格隔行变色</li>
                        <li><span class="term">rowhover</span>鼠标移过行时变色</li>
                        <li><span class="term">noell</span>显示溢出内容（默认情况下，图片或内容较长的字段会隐藏单元格显示不完的内容）</li>
                    </ul>
                </dd>
                <dt>样式类组合使用</dt>
                <dd>
                    <p>对同一元素可以使用多个样式类，中间用空格隔开。示例（源码）：</p>
                    <p class="red">&lt;div class="center textshadow"&gt;这些文字将居中显示，并有阴影&lt;/div&gt;</p>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="dir" Visible="false" runat="server">
            <div class="path">操作路径： 左侧栏，在“目录”区，可点击打开某个目录。如果没有显示目录区，可能是由于对根目录没有浏览权限，或自定义左侧栏时隐藏了目录区</div>
            <p>注：随权限的不同，以下所涉及到的某些菜单项可能不会在右键菜单中显示。</p>
            <dl>
                <dt>什么是目录？</dt>
                <dd><p>目录是一种对数据记录进行分类查看的组织形式。数据本身是存储于<%= ims.Sys.DataCenterText %>的数据表中的，无论归属到哪个目录，都可以从这个表或其它非目录方式打开查看（只要有权限）。模板设置中可以设置数据是否关联到目录，在<%= ims.Sys.DataCenterText %>或表格视图，可以将数据从原来的目录移动到指定的目录（但并不会从数据表中移除）。</p></dd>
                <dt>如何创建一个目录？</dt>
                <dd><p>右键点击目录中的空白区域，点“新建目录”，输入目录名并回车即可。</p></dd>
                <dt>如何打开一个目录？</dt>
                <dd><p>有三种方式：一是直接单击要打开的目录；二是在目录上点右键，在弹出菜单中选“打开”；三是从左侧栏的目录树中找到并单击要打开的目录名。</p></dd>
                <dt>如何为目录设置权限？</dt>
                <dd><p>在启用了目录权限控制的情况下，系统管理员或对目录有完全控制权限的人可以设置目录权限。设置方法是：右键点击要设置的目录，在菜单中选“权限”，然后在弹出的对话框中分别为每个角色设置其对该目录的权限。关于角色和目录权限，请参考<a href="?subject=power&showpath=1" runat="server">用户、角色及权限</a>。</p></dd>
                <dt>目录权限与模板权限有什么关系？</dt>
                <dd><p>目录权限只是用来控制是否允许在其中添加记录或子目录的，至于对目录中已经存在的记录有什么权限，是由模板权限决定的。</p></dd>
                <dt>如何在目录中添加记录？</dt>
                <dd><p>右键点击目录中的空白区域，点“新建”，选择模板后，即可进入数据录入页面。也可直接在“新建”的下级菜单中选择一个模板来添加记录。</p></dd>
                <dt>如何对目录中的内容进行排序？</dt>
                <dd><p>
                    右键点击目录中的空白区域，在“排序”的下级菜单中点击要用作排序依据的字段即可。如果再次用同一字段来排序，则会以相反的顺序排序。在“排序”的下级菜单项中，带有图标 <i class="f-asc greenish"></i>或 <i class="f-desc greenish"></i>的项是当前的排序依据项，前一个图标表示顺序排序，后一个图标表示逆序排序。</p></dd>
                <dt>小技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>若有权限，可将文件拖入目录窗口自动上传，或点击空白处按Ctrl+V粘贴截图/图片。</li>
                        <li>若有权限，可将对象拖拽到目录上，将其移入该目录。</li>
                        <li>在需要翻页浏览时，可使用键盘快捷操作。方向键→或PageDown键翻到下一页；方向键←或PageUp翻到上一页；Home键到第一页；End键到最后一页。</li>
                        <li>直接单击缩略图可打开其详细信息页面；单击缩略图中间的悬泘图标，可查看其较大尺寸的图片，并进入幻灯显示状态。</li>
                        <li>可以拖动目录来调整其位置和顺序，系统管理员权限的用户的这种调整结果将作为系统默认的顺序，而其它用户的调整则仅应用于其本人。</li>
                    </ul>
                </dd>
				<dt>相关主题</dt>
				<dd class="related"><a href="?subject=preview">文件预览</a></dd>
            </dl>
        </asp:Panel>
                    
        <asp:Panel ID="edit" Visible="false" runat="server">
            <div class="path">操作路径： 鼠标移到左侧栏导航区“<%= ims.Sys.DataCenterText %>”处，点“添加”；或鼠标移到导航区 <i class="f-add green"></i>标签处，点要添加的项；或打开“<%= ims.Sys.DataCenterText %>”，在模板上点右键 - 添加；或详情视图下，点“编辑”按钮；或表格视图下，在数据行的操作菜单中点“编辑”</div>
            <dl>
                <dt>如何进行编辑？</dt>
                <dd>
                    <p>标注了红色星号<span style="color:Red">*</span>的字段是必填项。录入完毕之后，点击“保存”按钮保存数据，或点击“另存”按钮，将当前表单作为一条新的记录进行保存。可以在保存前指定“保存后”的动作（此选择会自动记忆）。</p>
                </dd>
                <dt>如何对编辑界面排版？</dt>
                <dd>
                    <p>点击下面的“版式”按钮，会弹出菜单，可管理版式或切换到其它版式。点击“版式管理”，可添加或修改版式，或设置默认版式。</p>
                    <p>如果当前使用的是经典版式，则可直接拖动字段名称来调整位置进行排版，调整的结果将自动保存下来。</p>
                </dd>
                <dt>技巧和说明</dt>
                <dd>
                    <ul class="decoration">
                        <li>经典版式中，可以使用键盘上下方向键来将光标移到上一行或下一行。在文本框中输入完毕后按回车键，将执行保存动作。</li>
                        <li>可点击右上角“导入”链接，来选择一条记录导入到表单中，再作适当修改后保存，以减轻录入工作量。</li>
                        <li>在输入链接类型字段值时，可将链接文字部份留空，这样在显示时将以链接地址来代替链接文字。</li>
                        <li>关于编辑器的使用，请参考“<a href="?subject=editor">编辑器</a>”。</li>
                        <li>关于批量导入，请参考“<a href="?subject=dataadmin#import">如何通过Excel批量导入或更新数据？</a>”。</li>
                        <li>关于扫码输入，请参考“<a href="?subject=EditScan">扫码输入</a>”。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="rows" Visible="false" runat="server">
            <div class="path">操作路径： 编辑页面点“版式”按钮 - 多行录入。也可点“版式管理”，将“多行录入”设为默认版式</div>
            <dl>
                <dt>如何排版？</dt>
                <dd>
                    <p>鼠标拖动列可调整其顺序；拖动列边界线可调整列宽度。调整结果会自动记忆。</p>
                    <p>也可点“版式”按钮，切换为其它版式进入数据录入。</p>
                </dd>
                <dt>表格基本操作</dt>
                <dd>
                    <ul class="decoration">
                        <li>单击左下角"*"单元格可增加一行，右键点击可增加多行，或粘贴所复制的行；</li>
                        <li>单击行的序号单元格可选中该行，按住Ctrl键单击可实现多选，按住Shift键或用鼠标拖动可选择一个范围；</li>
                        <li>右键单击序号单元格可弹出操作菜单，实现复制、剪切、删除、清空、粘贴等操作；</li>
                        <li>可使用方向键或Tab键在单元格之间跳转；回车键或向下方向键跳转到下一行（长度设置超过50或启用了编辑器的除外），若当前是最后一行，则新增一行。</li>
                    </ul>
                </dd>
                <dt>扫码输入</dt>
                <dd>
                    <p>详见：<a href="?subject=RowsScan">扫码输入</a></p>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="editlayout" Visible="false" runat="server">
            <div class="path">操作路径： 编辑页面点“版式”按钮 - 版式管理</div>
            <dl>
                <dt>如何编排表单版式？</dt>
                <dd>
                    <p>在左侧编辑框内，可以输入任意内容，类似于在Word中排版的方式。在需要放置字段或子表单编辑控件的地方，从右侧拖入即可。有两种排版模式：</p>
                    <p><span class="term">编辑模式</span>可输入和修改文字、图片、表格等内容；</p>
                    <p><span class="term">拖拽模式</span>可用鼠标拖动元素来调整其位置或尺寸，或设置字段的显示方式（勾选以"块元素"显示；反之按"行内元素"显示），及子表单的初始行数。</p>
                </dd>
                <dt>如何重置编辑控件的宽度和高度？</dt>
                <dd>
                    <p>直接拖入版式区的字段或子表单控件，是自动确定宽度和高度的。在调整了宽度或高度后，如果想恢复默认尺寸，可在拖拽模式下将其拖入右侧候选区再重新拖回版式区。</p>
                </dd>
                <dt>使用表格进行排版</dt>
                <dd>
                    <p>可在编辑模式下插入表格，并将字段或子表单控件拖入表格适当位置。在表格中右键，从“表格属性”对话框可设置表格样式。建议设置为：边框:0；间距:1，样式类：</p>
                    <ul class="decoration">
                        <li>(无)：不显示边框线</li>
                        <li>normal：表格框线显示为细线条</li>
                        <li>hr：仅显示每行的下边框线</li>
                        <li>grayline：灰色表格框线</li>
                        <li>blackline：黑色表格框线</li>
                    </ul>
                    <p>提示： 将表格宽度设为百分比值，如100%，将按其所在位置宽度自动确定表格宽度；要确定各列宽度，应设置该列第一行的单元格宽度，此时建议至少留一列不设宽度，这样该列将自动占据剩余空间，而不会导致表格总宽度超出所在位置。</p>
                </dd>
                <dt>管理版式</dt>
                <dd><p>点击"管理版式"按钮，可对现有的版式进行更名、编辑、删除，设为默认版式等操作。详见：<a href="?subject=editLayoutManage">版式管理</a></p></dd>
                <dt>设置保存后的动作</dt>
                <dd>
                    <p>指定在用户填写表单时，保存后执行什么动作。可指定“由操作者决定”（操作时选择并自动记忆），或跳转到某个页面等。跳转的目标页面地址，可使用外部网址或系统内部页面地址。在首页“小工具”中可获取内部页面地址。</p>
                </dd>
                <dt>技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>双击版式区域，可快捷切换排版模式；编辑模式下，从右侧拖动字段将自动进入拖拽模式。</li>
                        <li>要调整字段的位置或大小，可分别尝试在拖拽模式、编辑模式，以及编辑模式的源码视图三种状态下处理。</li>
                        <li>如果希望子表单编辑区显示边框，可将其放置在一个单行单列的表格中，利用表格的边框作为它的边框。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="orderadmin" Visible="false" runat="server">
            <div class="path">操作路径： 首页，点“订单管理”图标</div>
            <dl>
                <dt>如何搜索订单？</dt>
                <dd>
                    <p>在订单搜索选项中，有“订单号”等六个搜索条件可供选择。勾选并设置一个或多个条件后，点击搜索图标即可执行订单搜索。如果不勾选任何条件，则表示列出全部订单。注：“订单号”和“下单人”两个条件均不支持模糊搜索，即必须指定准确的订单号或下单人。</p>
                </dd>
                <dt>如何处理订单？</dt>
                <dd>
                    <p>点击订单号，可以查看该订单的详细信息；点击“删除”可以删除订单；点击“查看”可以看到该订单的处理记录；将鼠标移到订单的下单时间上，可以查看包含了时间部份的准确下单时间。</p>
                    <p>在订单的详细信息对话框中，可以在“管理员备注”中填写对该订单的处理说明，供下单人了解。如，商品缺货，可以在此注明。在该窗口中还可以修改订单的状态。</p>
                    <p>说明：点击列标题“订单金额”或“下单时间”可以按该列的值进行升序或降序排序。</p>
                </dd>
            </dl>
        </asp:Panel>
                    
        <asp:Panel ID="myorder" Visible="false" runat="server">
            <div class="path">操作路径： 首页，点“我的订单”图标</div>
            <dl>
                <dt>如何查看自己的订单？</dt>
                <dd>
                    <p>在进入该页面后，默认会列出自己所提交的所有订单，也可以通过在“订单搜索”中勾选并设置一个或多个条件来搜索特定的订单。</p>
                    <p>在订单列表中，点击订单号可以查看该订单的详细信息。对于待审核的订单，可以执行“取消订单”操作。</p>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="transfer" Visible="false" runat="server">
            <div class="path">操作路径： <%= ims.Sys.TransCenterText %>，在流程列表点转办图标</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>在流程运行过程中，对流程模板有完全控制权限的用户，可以随时为某个步骤设置转办，来改变处理人。</p>
                </dd>
                <dt>技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>要添加处理人，可将“处理人”输入框留空，并指定“转办”目标用户即可；</li>
                        <li>要更换全部处理人，可将“处理人”输入框填写“*”，并指定“转办”目标用户；</li>
                        <li>要去除处理人，输入“处理人”并将“转办”目标用户输入框留空即可。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="templet" Visible="false" runat="server">
            <div class="path">操作路径： 设计中心，空白处右键 - 添加模板；或点击打开已有模板，即进入模板设计界面</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>模板设计，就是根据管理需求，确定要纳入管理的对象的各个属性。就像建立通讯录，需要先确定它要包含姓名、电话、地址等哪些内容一样。这些要管理的属性，被称为“字段”，包括文本、数字、日期时间、单选或多选列表、图片和文件等类型。为了数据的录入和管理更方便，还可以指定这些字段的一些细节特性，如默认值、是否必须填写等。</p>
                </dd>
                <dt>数据类型</dt>
                <dd>
                    <dl class="inlinedefine">
                        <dt>文本：</dt>
                        <dd>普通的文本数据。如，姓名、地址。
                            <table class="normal">
		                        <tr>
			                        <th style="width:59%">输入界面示意：</th>
			                        <th style="width:41%">显示效果：</th>
		                        </tr>
		                        <tr>
			                        <td class="center"><img src="images/help/text.png" /></td>
			                        <td class="center"><img src="images/help/text_1.png" /></td>
		                        </tr>
                            </table>
                        </dd>
                        <dt>数字：</dt>
                        <dd>只允许输入数字值。如，年龄、身高。
                            <table class="normal">
		                        <tr>
                                    <th style="width:43%">字段设置示例：</th>
			                        <th style="width:31%">输入界面示意：</th>
			                        <th style="width:26%">显示效果：</th>
		                        </tr>
		                        <tr>
			                        <td class="center" style="padding:0"><img src="images/help/numeric_2.png" /></td>
			                        <td class="center"><img src="images/help/numeric.png" /></td>
			                        <td class="center"><img src="images/help/numeric_1.png" /></td>
		                        </tr>
                                <tr><td colspan="3" class="comment">说明：数字值只能保证15位有效位。</td></tr>
                            </table>
                        </dd>
                        <dt>日期时间：</dt>
                        <dd>只允许输入日期和时间类型的值。如，生日。
                            <table class="normal">
		                        <tr>
			                        <th style="width:59%">输入界面示意：</th>
			                        <th style="width:41%">显示效果：</th>
		                        </tr>
		                        <tr>
			                        <td class="center"><img src="images/help/datetime.png" /></td>
			                        <td class="center"><img src="images/help/datetime_1.png" /></td>
		                        </tr>
                                <tr><td colspan="2" class="comment">说明：日期时间字段的"不允许重复值"按所指定的格式检查重复，如“年-月”格式，则一个月只能有一条记录。</td></tr>
                            </table>
                        </dd>
                        <dt>单选列表：</dt>
                        <dd>从指定的多个选项中选择一项。该类型通常用于数据值都是某些已知的值之一的情况，如省份、联系人类别（好友、同事等）。需要在字段中预先设定好待选项。
                            <table class="normal">
		                        <tr>
			                        <th style="width:59%">输入界面示意：</th>
			                        <th style="width:41%">显示效果：</th>
		                        </tr>
		                        <tr>
			                        <td class="center"><img src="images/help/singlelist.png" /></td>
			                        <td class="center"><img src="images/help/singlelist_1.png" /></td>
		                        </tr>
                            </table>
                        </dd>
                        <dt>多选列表：</dt>
                        <dd>从指定的多个选项中选择一项或多项。该类型通常用于数据值都是某些已知的值的其中一部份的情况，如兴趣爱好。需要在字段中预先设定好待选项。
                            <table class="normal">
		                        <tr>
			                        <th style="width:59%">输入界面示意：</th>
			                        <th style="width:41%">显示效果：</th>
		                        </tr>
		                        <tr>
			                        <td class="center"><img src="images/help/multiplelist.png" /></td>
			                        <td class="center"><img src="images/help/multiplelist_1.png" /></td>
		                        </tr>
                            </table>
                        </dd>
                        <dt>是/否：</dt>
                        <dd>只有肯定和否定两种情况之一。如，考试是否通过、婚否。
                            <table class="normal">
		                        <tr>
			                        <th style="width:59%">输入界面示意：</th>
			                        <th style="width:41%">显示效果：</th>
		                        </tr>
		                        <tr>
			                        <td class="center"><img src="images/help/yesno.png" /></td>
			                        <td class="center"><img src="images/help/yesno_1.png" /></td>
		                        </tr>
                            </table>
                        </dd>
                        <dt>公式：</dt>
                        <dd>对同一模板中的其它一个或多个字段进行某种计算来得到值。如，提成额＝销售额×0.15。
                            <table class="normal">
		                        <tr>
			                        <th style="width:59%">字段设置示例：</th>
			                        <th style="width:41%">显示效果：</th>
		                        </tr>
		                        <tr>
			                        <td class="center" style="background:#f4f7fb"><img src="images/help/formula.png" /></td>
			                        <td class="center"><img src="images/help/formula_1.png" /></td>
		                        </tr>
                                <tr><td colspan="2" class="comment">说明：公式字段不会出现在数据输入界面，它的值是在浏览时动态计算得到的。公式字段常用于对同一条记录中的一个或多个字段进行计算取值；而查询字段常用于对一批记录的同一个字段进行取值。</td></tr>
                            </table>
                        </dd>
                        <dt id="queryfield">查询：</dt>
                        <dd>从指定模板中根据指定条件和方法进行查询计算来得到值。如下图示意，订单模板中的“订单金额”字段，是从订单商品明细模板中根据订单编号来计算该编号下所有商品的金额合计。
                            <table class="normal">
		                        <tr>
			                        <th style="width:51%">字段设置示例：</th>
			                        <th style="width:49%">查询逻辑示意：</th>
		                        </tr>
		                        <tr>
			                        <td class="center" style="padding:0;background:#f4f7fb"><img src="images/help/query_1.png" /></td>
			                        <td class="center"><img src="images/help/query_2.png" /></td>
		                        </tr>
                                <tr><td colspan="2" class="comment">说明：查询字段不会出现在数据输入界面，它的值是在浏览时动态计算得到的，并随数据源变化而变化（若不希望这样，就应使用文本等类型，配合“输入提示”的“自动填充”功能，在录入时取值）。查询字段常用于对一批记录的同一个字段进行取值；而公式字段常用于对同一条记录中的一个或多个字段进行计算取值。</td></tr>
                            </table>
                        </dd>
                        <dt>图片：</dt>
                        <dd>用于存放图片。如，模板“人事档案”中的“照片”字段。支持以下图片格式：jpg，gif，png，bmp，tif，emf，wmf，ico。
                            <table class="normal">
		                        <tr>
			                        <th style="width:59%">输入界面示意：</th>
			                        <th style="width:41%">显示效果：</th>
		                        </tr>
		                        <tr>
			                        <td class="center"><img src="images/help/photo.png" /></td>
			                        <td class="center"><img src="images/help/photo_1.png" /></td>
		                        </tr>
                            </table>
                        </dd>
                        <dt>文件：</dt>
                        <dd>用于存放文件。如，产品说明书。支持的文件类型取决于系统设置中“允许上传的文件类型”。
                            <table class="normal">
		                        <tr>
			                        <th style="width:55%">输入界面示意：</th>
			                        <th style="width:45%">显示效果：</th>
		                        </tr>
		                        <tr>
			                        <td class="center"><img src="images/help/file.png" /></td>
			                        <td class="center"><img src="images/help/file_1.png" /></td>
		                        </tr>
                            </table>
                        </dd>
                        <dt>链接：</dt>
                        <dd>用于设置内部链接或外部链接。如，模板“供应商”中的“网站”字段。内部链接是指链接到系统内部某个页面的链接，其地址如：dir.aspx?id=1，表示链接到ID为1的目录。
                            <table class="normal">
		                        <tr>
			                        <th style="width:55%">输入界面示意：</th>
			                        <th style="width:45%">显示效果：</th>
		                        </tr>
		                        <tr>
			                        <td class="center"><img src="images/help/hyperlink.png" /></td>
			                        <td class="center"><img src="images/help/hyperlink_1.png" /></td>
		                        </tr>
                            </table>
                        </dd>
                        <dt>自动编号：</dt>
                        <dd>用于自动生成一个编号。在录入数据时，系统会自动根据编号规则来生成编号，而不用手工输入。通常用于确保每条记录有个唯一的编号，并可通过该编号与其它模板间建立起某种关联。
                            <table class="normal">
		                        <tr>
			                        <th style="width:55%">字段设置示例：</th>
			                        <th style="width:45%">显示效果：</th>
		                        </tr>
		                        <tr>
			                        <td class="center" style="background:#f4f7fb"><img src="images/help/autonumber.png" /></td>
			                        <td class="center"><img src="images/help/autonumber_1.png" /></td>
		                        </tr>
                            </table>
                        </dd>
                        <dt>特殊文本：</dt>
                        <dd>用于记录电话号码、邮箱地址、QQ号等特殊的文本类型。这种类型的字段值在录入时会有相应的验证，防止输入不符合规则的数据，在浏览时会呈现为链接，点击可执行发送手机短信、邮件、QQ消息等相应的任务。
                            <table class="normal">
		                        <tr>
			                        <th style="width:55%">输入界面示意：</th>
			                        <th style="width:45%">显示效果：</th>
		                        </tr>
		                        <tr>
			                        <td class="center"><img src="images/help/specialtext.png" /></td>
			                        <td class="center"><img src="images/help/specialtext_1.png" /></td>
		                        </tr>
                            </table>
                        </dd>
                        <dt>变量：</dt>
                        <dd>变量类型的字段，在录入时不会出现，它的值是在保存时由系统自动根据当时的情况来确定的。比如，当时录入人员的用户名、时间之类。
                            <table class="normal">
		                        <tr>
			                        <th style="width:55%">字段设置示例：</th>
			                        <th style="width:45%">显示效果：</th>
		                        </tr>
		                        <tr>
			                        <td class="center" style="background:#f4f7fb"><img src="images/help/variable.png" /></td>
			                        <td class="center"><img src="images/help/variable_1.png" /></td>
		                        </tr>
                            </table>
                        </dd>
                    </dl>
                </dd>
                <dt style="margin-top:2em">如何添加一个字段？</dt>
                <dd>
                    <p>点击“添加字段”，输入字段名称，选择好数据类型并设置其它选项后，点击“确定”即可。可用的选项根据数据类型的不同而不同，分别解释如下：</p>
                    <dl class="inlinedefine">
                        <dt>默认值</dt>
                        <dd>
                            指定字段的默认值。在添加记录时，默认值会作为该字段的初始值。如，人事档案的“健康状况”默认值可设为“健康”。 默认值也可使用以下变量：<br />
                            <ul class="decoration">
                                <li><span class="term">$UserName$</span>操作者用户名</li>
                                <li><span class="term">$UserRealName$</span>操作者真实姓名</li>
                                <li><span class="term">$UserUnit$</span>操作者所属机构</li>
                                <li><span class="term">$UserUnit2$</span>操作者所属组织机构第 2 层（机构根节点的层次为0）的机构名称，依此类推</li>
                                <li><span class="term">$UserIP$</span>操作者的IP地址</li>
                                <li><span class="term">$Now$</span>当时时间</li>
                            </ul>
                            <p>日期时间类型字段，还可以用数据库日期函数表达默认值，如(SQLServer语法)：DateAdd(yy,1,getDate())，将当前时间加一年。</p>
                        </dd>
                        <dt>保密级别</dt>
                        <dd>设定该字段的保密级别（数字越大，保密级别越高）。除了权限较高的管理人员外，只有浏览权限级别不低于指定的保密级别的人员才能查看该字段的内容。
                            <table class="normal">
		                        <tr>
			                        <th style="width:33%">字段设置示例：</th>
			                        <th style="width:67%">权限设置示例：</th>
		                        </tr>
		                        <tr style="background:#f4f7fb">
			                        <td class="center"><img src="images/help/seclevel.png" /></td>
			                        <td class="center"><img src="images/help/seclevel_1.png" /></td>
		                        </tr>
                                <tr><td colspan="2" class="comment">说明：按此示例的设置，员工角色的用户将看不到这个字段的内容。</td></tr>
                            </table>
                        </dd>
                        <dt>必填字段</dt>
                        <dd>设定在编辑时，是否必须为该字段指定一个值。如，人事档案的“姓名”字段通常应设为必填字段，而“特长”字段则相反，应该是可填可不填。<br /></dd>
                        <dt>不允许重复值</dt>
                        <dd>设定是否允许使用该模板的记录在该字段中存在相同的值。如，“学号”字段应勾选该选项，而“成绩”字段则不应该勾选。<br /></dd>
                        <dt>内容长度</dt>
                        <dd>指定该字段最多允许输入多少个字（中英文不论）。“0”或留空表示不限字数。建议设置为这个字段最大可能的内容长度值。这个值也决定了编辑界面生成的输入框的大小。<br /></dd>
                        <dt>使用编辑器</dt>
                        <dd>设定在编辑时是否使用<asp:HyperLink ID="HyperLink19" runat="server" NavigateUrl="help.aspx?subject=editor">编辑器</asp:HyperLink>，以便支持设置字体、颜色，插入图片等功能。
                            <table class="normal">
                                <tr><th>输入界面示意：</th></tr>
		                        <tr>
			                        <td><img src="images/help/editor.png" /></td>
		                        </tr>
                                <tr><th>显示效果：</th></tr>
		                        <tr>
			                        <td class="center"><img src="images/help/editor_1.png" /></td>
		                        </tr>
                            </table>
                        </dd>
                        <dt id="fieldlink">链接</dt>
                        <dd>如果勾选并设置了该选项，在浏览时该字段的文本将显示为一个链接，点击这个链接将显示符合所指定条件的记录。如，在“产品”模板的“产品代码”字段设置链接：
                            <p>链接到：产品投诉记录，（产品投诉记录的）产品代码等于当前（产品模板的）“产品代码”。</p>
                            <table class="normal">
                                <tr><th>字段设置示例：</th></tr>
		                        <tr>
			                        <td class="center"><img src="images/help/innerlink.png" /></td>
		                        </tr>
                                <tr><th>链接效果示意：</th></tr>
		                        <tr>
			                        <td class="center"><img src="images/help/innerlink_1.png" /></td>
		                        </tr>
                            </table>
                        </dd>
                        <dt id="ac">输入提示</dt>
                        <dd>设定在编辑时该字段是否具有输入提示（自动完成）功能。如，可以为“供货记录”模板的“供应商”字段设置输入提示功能，其“数据来源”设置为“供应商”，取前20项“公司名称”，这样，在录入供货记录时，在供应商字段中会用下拉列表列出与当前输入字符相关的供应商名称供选择。
                            <table class="normal">
		                        <tr>
			                        <th style="width:58%">字段设置示例：</th>
			                        <th style="width:42%">输入效果示意：</th>
		                        </tr>
		                        <tr>
			                        <td style="padding:0;background:#f4f7fb"><img src="images/help/autocomplete.png" /></td>
			                        <td style="padding:0"><img src="images/help/autocomplete_1.png" /></td>
		                        </tr>
		                        <tr>
			                        <th>字段设置示例：</th>
			                        <th>输入效果示意：</th>
		                        </tr>
		                        <tr>
			                        <td style="padding:0;background:#f4f7fb"><img src="images/help/autocomplete_2.png" /></td>
			                        <td style="padding:0"><img src="images/help/autocomplete_3.png" /><div style="padding:4px">说明：此处输入产品代码，系统就会自动填入名称。</div></td>
		                        </tr>
                            </table>
                            注：1、输入提示的取值会受到操作者对数据源浏览权限的限制；<br />
                            　　2、自动填充，即自动按设置来取值并填入。这只是一种辅助输入手段，可能受一些因素影响而取值失败，取值仅供参考。<br />
                        </dd>
                        <dt>数值格式</dt>
                        <dd>设定数值类型的字段的显示格式。可设置数量单位、百分比显示、千分位显示等等。<br /></dd>
                        <dt>时间格式</dt>
                        <dd>为日期时间类型数据的显示格式。<br /></dd>
                        <dt>选项设置</dt>
                        <dd>为单选列表或多选列表类型预设待选项。在编辑记录时，可以从这些待选项中选择合适的项。<br /></dd>
                        <dt>公式</dt>
                        <dd>为公式类型字段设置公式。在公式中，可用“[字段编号]”的形式引用模板中的其它字段，字段编号可从“可引用字段”列表中选择。<br /></dd>
                        <dt>查询设置</dt>
                        <dd>为查询类型字段进行设置。设置过程可概括为：对指定模板类型的满足指定条件的数据，按指定的方法来获得一个值，这个值就作为此查询字段的值。如，模板“人事档案”中的查询类型字段“平均工资”，可设置为：
                            <p>查询：工资发放记录；条件：（工资发放记录的）姓名“等于”当前（人事档案的）姓名；取值：对“工资”计算“平均值”。</p>
                        </dd>
                        <dt>编号规则设置</dt>
                        <dd>为自动编号类型的字段设置编号规则。可使用前缀、随机字符串、时间、顺序号和后缀（可以只勾选其中的一项或几项）来构成一个编号。其中，时间部分可使用类似“yyyyMMddHHmmss”的格式字符，在生成编号时将用当时的时间按照指定的格式生成字符串，yyyy表示四位数的年份，MM表示两位数的月份，dd表示两位数的日期，HHmmss依次表示24小时制的时、分、秒（各两位）。
                            <p>举例：编号规则设为：前缀“P”，时间格式“yyMMdd”，顺序号为3位，初始值和递增值都为1，那么如果当时时间为2018年9月10日，前面已经添加了10条记录，则新生成的编号将是：P20180910011。重置周期，用于指定按周期重置顺序号。</p>
                        </dd>
                        <dt>输入规范</dt>
                        <dd>用一个<a href="http://msdn.microsoft.com/zh-cn/library/ae5bf541(v=vs.90).aspx" target="_blank">正则表达式</a>，来限制输入的数据，确保其符合要求。如"<span class="red">^\w{6,8}$</span>"表示要求六到八位的字母或数字。对于数字字段，还可这样限制输入的数值范围：
                            <p><span class="red">1,99</span>：输入的数值X必须在1≤X≤99这个范围；</p>
                            <p><span class="red">10,</span>：输入的数字必须大于等于10。</p>
                        </dd>
                        <dt>输入说明</dt>
                        <dd>填写一段说明文字，在输入时，鼠标悬浮在输入元素上，会显示该说明，从而指导或提示用户。<br /></dd>
                        <dt>隐藏</dt>
                        <dd>指定该字段是否在浏览时不可见。无论是否隐藏，在模板设计时，以及录入数据时，都是可见的（如果有权限）。模板的标识字段不受此设置的影响。</dd>
                    </dl>
                </dd>
                <dt>关于公式和查询字段</dt>
                <dd>
                    <p>要对同一记录的多个字段进行计算，应使用公式字段；要对多条记录的同一个字段进行计算，应使用查询字段。公式和查询字段并不保存数据，而是在需要时实时计算取值，所以这两种字段不会出现在数据输入界面。</p>
                </dd>
                <dt>小技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>可拖动字段名调整字段的上下顺序；双击字段所在行编辑该字段。</li>
                        <li>多选列表的默认值可用“|”来分隔多个项；链接类型的默认值可用“链接地址|链接文字”的格式来填写，如果只需要为链接地址或链接文字设置默认值，可将另一部份留空即可，如“|我的链接”。</li>
                        <li>对未启用编辑器的文本字段，如果需要在录入时可以对内容进行换行，请把“内容长度”设为大于50的数字。</li>
                        <li>公式类型字段的公式中，可以使用SQL语句中的函数，如，仅当已收到货款的情况下，才有提成，可设置为：iif([22], [10]*0.1, 0)，其中[22]为“已到款”字段，[10]为“总金额”字段，意为如果已到款就提总金额的10%，否则为0。注意：该语法仅适用于Access数据库。更多的SQL函数，请参考相应数据库文档。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel runat="server" ID="detailLayoutManage" Visible="false">
            <div class="path">操作路径： 详情视图，进入版式管理，点"管理版式"</div>
            <dl>
                <dt>如何进行版式管理？</dt>
                <dd>
                    <p>在"管理版式"对话框中，可对已有的版式进行设为默认、更名、编辑和删除等操作；以及添加、编辑或删除默认版式规则。</p>
                </dd>
                <dt>什么是默认版式规则？</dt>
                <dd>
                    <p>有时候，我们希望让同一条记录在不同条件下，或对于不同的人，使用不同的版式来显示。这就需要设置默认版式规则，它用于确定在哪种情况下默认使用哪种版式。</p>
                    <p>例如，一个“报价单/订单”模板，可设置默认版式为"报价单版式"，然后添加一条默认版式规则，指定当"状态"字段为报价之后的其它状态时，使用"订单版式"。</p>
                </dd>
                <dt>说明</dt>
                <dd>
                        <ul class="decoration">
                        <li>默认版式规则优先于设为默认的版式；用户浏览时手工选择的版式则优先于任何默认版式设置。</li>
                        <li>默认版式规则中，越靠后面，优先级越高。</li>
                        <li>如果勾选了“禁止普通用户切换版式”选项，则对该模板没有完全控制权限者，浏览时将不会显示版式切换按钮（除非流程中给定了版式管理权限）。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel runat="server" ID="editLayoutManage" Visible="false">
            <div class="path">操作路径： 数据录入页面，进入版式管理，点"管理版式"</div>
            <dl>
                <dt>如何进行版式管理？</dt>
                <dd>
                    <p>在"管理版式"对话框中，可对已有的版式进行设为默认、更名、编辑和删除等操作；以及添加、编辑或删除默认版式规则。</p>
                </dd>
                <dt>什么是默认版式规则？</dt>
                <dd><p>默认版式规则，可以为不同角色指定不同的默认表单版式。</p></dd>
                <dt>说明</dt>
                <dd>
                    <ul class="decoration">
                        <li>默认版式规则优先于设为默认的版式；用户手工选择的版式则优先于任何默认版式设置。</li>
                        <li>默认版式规则中，越靠后面，优先级越高。</li>
                        <li>如果勾选了“禁止普通用户切换版式”选项，则对该模板没有完全控制权限者，将不会显示版式切换按钮。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel runat="server" ID="tableLayoutManage" Visible="false">
            <div class="path">操作路径： 打开数据后，切换到表格视图，点"管理版式"</div>
            <dl>
                <dt>如何进行版式管理？</dt>
                <dd>
                    <p>在"管理版式"对话框中，可对已有的版式进行设为默认、更名和删除等操作；以及添加、编辑或删除默认版式规则。</p>
                </dd>
                <dt>什么是默认版式规则？</dt>
                <dd><p>默认版式规则，可以为不同角色指定不同的默认表格版式。</p></dd>
                <dt>说明</dt>
                <dd>
                        <ul class="decoration">
                        <li>默认版式规则优先于设为默认的版式；用户手工选择的版式则优先于任何默认版式设置。</li>
                        <li>默认版式规则中，越靠后面，优先级越高。</li>
                        <li>如果勾选了“禁止普通用户切换版式”选项，则对该模板没有完全控制权限者，将不会显示版式切换按钮。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel runat="server" ID="chartManage" Visible="false">
            <div class="path">操作路径： 打开数据后，切换到图表视图，点"图表管理"</div>
            <dl>
                <dt>如何管理图表？</dt>
                <dd>
                    <p>在"管理图表"对话框中，可对已有图表设为默认、更名和删除等操作；以及添加、编辑或删除默认图表规则。</p>
                </dd>
                <dt>什么是默认图表规则？</dt>
                <dd><p>默认图表规则，可以为不同角色指定不同的默认图表。</p></dd>
                <dt>说明</dt>
                <dd>
                        <ul class="decoration">
                        <li>默认图表规则优先于设为默认的图表；用户手工选择的图表则优先于任何默认图表设置。</li>
                        <li>默认图表规则中，越靠后面，优先级越高。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel runat="server" ID="reportManage" Visible="false">
            <div class="path">操作路径： 打开数据后，切换到报表视图，点"报表操作"-"报表管理"</div>
            <dl>
                <dt>如何管理报表？</dt>
                <dd>
                    <p>在"管理报表"对话框中，可对已有报表设为默认、更名和删除等操作；以及添加、编辑或删除默认报表规则。</p>
                </dd>
                <dt>什么是默认报表规则？</dt>
                <dd><p>默认报表规则，可以为不同角色指定不同的默认报表。</p></dd>
                <dt>说明</dt>
                <dd>
                        <ul class="decoration">
                        <li>默认报表规则优先于设为默认的报表；用户手工选择的报表则优先于任何默认报表设置。</li>
                        <li>默认报表规则中，越靠后面，优先级越高。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="templetAttrs" Visible="false" runat="server">
            <div class="path">操作路径： 设计中心，模板上点右键 - 设置</div>
            <dl>
                <dt>常规</dt>
                <dd>
                    <p><span class="term">默认视图</span>指定浏览该模板类型的数据时默认使用哪种视图。如，对于“商品”模板，可设置默认视图为“缩略视图”。</p>
                    <p><span class="term">默认排序方式</span>指定浏览该模板类型的数据时，数据的默认排序方式。</p>
                    <p><span class="term">默认保存目录</span>指定在录入数据时，默认的“保存目录”是哪个目录。通常，如果模板用于管理诸如“商品”之类的实体，可将其关联到目录，便于使用目录进行分类管理和浏览；如果是管理“商品进出库记录”之类的流水账数据，则可设为“不关联目录”（这种情况下，任意目录中都看不到这些记录，只能在直接打开或搜索该模板数据时，以及从实体记录页面链接而来才能看到）。</p>
                    <p><span class="term">标识字段</span>用于设置作为每条记录的代表属性（就像人的姓名）的字段。设置后，在缩略图下方等处将显示该字段的值。</p>
                    <p><span class="term">概要字段</span>指定构成记录概要信息的字段。通常用于缩略图上鼠标悬浮显示。</p>
                    <p><span class="term">组合唯一字段</span>指多个字段组合起来唯一地标识一条记录。组合的值不允许出现重复。如，不同城市之间可能有相同的电话号码，但加上区号后，就不会重复了。区号和电话号码，就是组合唯一字段。</p>
                    <p><span class="term">数据有效性验证</span>勾选并设置验证条件后，录入或编辑的数据必须符合预设的条件才认为有效，否则不予保存。</p>
                    <p><span class="term">启用数据结转</span>勾选并设置后，可以定期将数据记录和/或其统计结果结转到其它模板数据表。详见：<a href="?subject=carryover">结转</a></p>
                </dd>
                <dt>关系</dt>
                <dd>
                    <p>在该标签页中，可查看和管理该模板与其它模板之间的关联关系。比如，对于“学生”模板与“学生成绩表”模板，可将后者设为前者的子模板，并通过“学号”字段进行关联。详见：<a href="?subject=masterSlave">模板关系</a>。</p>
                    <p><span class="term">父模板</span>此处列出该模板的父模板及其关联关系。</p>
                    <p><span class="term">子模板</span>此处列出该模板的子模板及其关联关系。可点击 <i class="f-del red"></i>图标删除对应的关联关系。</p>
                    <p><span class="term">添加子模板</span>此处可将某一模板设为当前模板的子模板。“关联”设置是指相互间通过哪个字段进行关联，如“订单”模板和“订单商品明细”模板之间，可通过订单编号来关联（即，某个订单所订购的商品清单，就是在“订单商品明细”中的订单编号等于其编号的那些记录）。</p>
                    <p><span class="term">关联选项</span></p>
                    <ul class="decoration">
                        <li><span class="key">同步更新关联字段</span>　若选中，则在上例中修改订单的编号时，“订单商品明细”中它所对应的那些记录的订单编号也会作相应的变更；</li>
                        <li><span class="key">同步删除关联记录</span>　若选中，则在删除某条记录时，子模板中相关联的记录也同时自动删除，如删除一个订单，它对应的订单商品明细记录也会同时删除；</li>
                        <li><span class="key">同步添加关联记录</span>　仅适用于一对一关系。如“员工”与“配偶信息登记表”，添加员工时，可同时添加一条配偶信息。同步添加的记录具有关联字段值，若设置了“生成”映射，还会带入映射的字段值。</li>
                        <li><span class="key">必须填写关联记录</span>　用于指定在录入主表单时，必须添加至少一行子模板记录（如果有相应的输入界面）。</li>
                        <li><span class="key">满足条件时锁定关联记录</span>　用于指定当主表单记录满足某种条件时，禁止添加、编辑或删除它关联的子模板记录。</li>
                    </ul>
                    <p><span class="term">“同步”操作有什么用？</span></p>
                    <ul class="decoration">
                        <li>对于设置了“同步删除关联记录”的关系，如订单模板和订单商品明细模板，“同步”操作可以从后者删除已经不存在的订单的明细记录；</li>
                        <li>对于设置了“同步添加关联记录”的关系，如员工信息模板和员工配偶信息模板（属一对一关系），“同步”操作可参照前者每条记录，检查后者是否存在相对应的记录，没有的则自动添加，以确保每条员工记录都有一条对应的员工配偶记录。</li>
                    </ul>
                    <p><span class="term">说明</span></p>
                    <ul class="decoration">
                        <li>关联字段的要求：必填字段、长度不超过255、不使用编辑器。主模板的关联字段还要求“不允许重复值”。满足这些条件的字段才会出现在关联设置中。</li>
                        <li>像订单与订单商品明细表的关系是“一对多”的关系；像员工与员工配偶信息表的关系是“一对一”关系。通常，一对一关系才应该选中“同步添加关联记录”。</li>
                        <li>同步功能具有很高的优先权，会忽略重复性控制和数据保护约束，并且只要对子模板有任意编辑权限即可，即使对这些关联记录没有浏览或编辑权限。</li>
                        <li>同步删除关联记录时，受到数据保护“禁止删除”的，以及被其它父模板“满足条件时锁定关联记录”的，将不会删除。</li>
                    </ul>
                    <p><span class="term">参考：</span><a href="?subject=masterSlave">模板关系</a></p>
                </dd>
                <dt>流程</dt>
                <dd>
                    <p>在该标签页，可为该模板创建一个流程，或修改已有流程的设计。创建流程后，<span class="red">流程“开始”步骤指定的“处理者”将可以在<%= ims.Sys.TransCenterText %>发起该流程</span>。</p>
                    <p>为模板设计了流程之后，默认情况下将不能从<%= ims.Sys.DataCenterText %>等页面查看或编辑数据，而只能在流程中处理。但是，这可以通过<span class="red">模板权限中的“流程外操作表单数据”选项</span>来修改。</p>
                    <p>注意：在发起流程时，将保存当时的流程设计版本，并一直按这个版本的设计来运行。<span class="red">后续对流程设计的修改，不会影响已发起的流程</span>。</p>
                </dd>
                <dt>数据保护</dt>
                <dd>
                    <p>该标签页用于设置对数据的保护选项，以便必要情况下禁止对数据的编辑或删除等操作。指定为“例外”的角色，则不受这些设置的影响。</p>
                </dd>
                <dt>提醒</dt>
                <dd>
                    <p>提醒，是在满足某种条件时，通过指定的方式对指定的用户进行通知。添加提醒时，可指定提醒的方式、条件、对象和时机。</p>
                </dd>
				<dt>相关主题</dt>
				<dd class="related"><a href="?subject=flow">流程设计</a><a href="?subject=generator">生成</a><a href="?subject=customopera">自定义操作</a><a href="?subject=carryover">数据结转</a></dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="generator" Visible="false" runat="server">
            <div class="path">操作路径： 设计中心，模板上点右键 - 设置 - 生成</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>生成，即利用现有数据来产生新的数据，例如，用员工信息生成员工职称评定申请表，或选择产品生成报价单。</p>
                    <p>生成方法的设置，就是指定源数据与本模板之间的字段对应关系，从而在浏览源数据时，可以选择记录来提取这些内容生成新的数据。</p>
                    <p>设置后，在源数据表格视图，可以从某一行右键菜单中生成，将自动提取映射的字段内容进入编辑状态，完善表单后保存为新记录； 也可以从“批量操作”对话框中点生成按钮，用选中的记录来生成。如果目标模板有父模板，则后者对应的生成按钮，可以打开父表单录入页面，选中的源记录将生成为其子表单记录，如下所示：</p>
                    <p><img src="images/help/generate.png" /></p>
                </dd>
                <dt>应用示例</dt>
                <dd>
                    <ul class="ulm">
                        <li><span class="term">例一</span>有<span class="red">员工信息表</span>和<span class="red">员工职称评定申请表</span>，在后者设置生成方法，将员工基本信息字段添加映射。生成时，可以为单个员工生成申请表，在填写其余内容后保存并打印；也可以批量生成一批员工的申请表，使用概要视图（设为使用详情视图格式）批量打印后发给员工自己填写其余内容。</li>
                        <li><span class="term">例二</span>有<span class="red">产品</span>、<span class="red">报价单</span>及其子表<span class="red">报价产品明细</span>，在报价产品明细表上设置生成，将产品表的名称、规格等字段映射到对应字段。这样，在浏览产品时，选择一批产品，点“生成报价单”，就生成为报价单明细记录了，只需填写报价单表单并保存即可(如上述截图所示)。也可以在批量操作对话框中将选择的产品添加到已有的某个报价单。</li>
                        <li><span class="term">例三</span>有<span class="red">报价单</span>及其子表<span class="red">报价产品明细</span>、<span class="red">订单</span>及其子表<span class="red">订单产品明细</span>，设置“报价单→订单、报价产品明细→订单产品明细”的生成映射，就可以在浏览报价单时方便地将其生成为订单。</li>
                        <li><span class="term">例四</span>有<span class="red">值周安排</span>表，设置从本模板生成（不添加字段映射），可以在浏览时，选择几行来生成新的一周值周安排（相当于复制记录）。</li>
                        <li><span class="term">例五</span>有<span class="red">报价单</span>及其子表<span class="red">报价产品明细</span>，分别设置从本模板复制记录。这样，就可以用某个现有的报价单来生成新的报价单（相当于分别复制原报价单及其明细记录）。</li>
                    </ul>
                </dd>
                <dt>选项</dt>
                <dd>
                    <ul class="ulm">
                        <li><span class="term">浏览源数据时，允许…</span>用于控制显示哪些生成按钮或菜单项（有父模板的可显示生成父表单的按钮，用于弹出父表单编辑界面，而所选的源数据则生成为其子表单记录）。</li>
                        <li><span class="term">生成为编辑状态</span>从菜单或链接生成时，是将源数据提取并填充到目标表单供完善后保存。但从“批量操作”中生成目标记录时是直接生成，不会进入编辑状态。勾选该项后，批量操作对话框中只会出现生成父表单的按钮。</li>
                        <li><span class="term">生成后删除源数据</span>勾选后，生成操作完成后将删除所用到的源数据记录。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="customopera" Visible="false" runat="server">
            <div class="path">操作路径： 设计中心，模板上点右键 - 设置 - 自定义操作</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>自定义操作，用于定义一个命令，在数据浏览界面呈现为一个按钮，点击时将执行预定的动作。比如，添加一个"审核"操作，点击时将记录的"审核状态"字段设为"已审核"。</p>
                </dd>
                <dt>说明</dt>
                <dd>
                    <ul class="decoration">
                        <li>为字段设定的值，可使用变量。在执行操作时，变量会替换为相应的值。如：<span class="red">$UserName$于$Now$确认</span>。</li>
                        <li>为字段设定的值，可以使用字段代码，并可使用公式语法对字段进行运算或函数处理。如，将字段[F73K]设为：<span class="red">[F73K]+1</span>，将实现数值递增。</li>
                        <li><span class="red">一旦使用了字段代码，系统即视为公式</span>，应遵循公式语法。如：<span class="red">'$UserName$ 确认成本：' + [F9SU]</span>。</li>
                        <li>若使用公式语法，自定义操作会忽略字段的输入规范；单选/多选列表、链接类型字段，不支持使用公式语法。</li>
                        <li>代码对应的字段若没有值，则对于数值类型将视为0，对于文本类型将视为空文本。</li>
                        <li>自定义操作会受制于数据保护设置，但优先于权限设置。即，只要没有将数据保护设为“禁止编辑”，就可以操作，无论是否有编辑权限。</li>
                        <li>自定义操作会忽略字段输入提示的“只接受数据源范围内的值”选项。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="templets" Visible="false" runat="server">
            <div class="path">操作路径： 点左侧栏导航区“设计中心”</div>
            <p>注：随权限的不同，以下所涉及到的某些菜单项可能不会在右键菜单中显示。</p>
            <dl>
                <dt>什么是模板？</dt>
                <dd>
                    <p>任何要管理的事物都是以模板为基础的。模板定义了其各种属性，如名称、规格、重量之类，这些属性被称为“字段”。模板通常用于可用相同指标来描述的一类事物，如产品档案、产品出入库记录等。</p>
                    <p>系统所管理的数据都是依存于特定的模板的，其中的每一条信息称为一条“记录”，对多条记录也统称为“数据”。</p>
                    <p>对于要管理的信息，是应当用一个模板来管理，还是多个不同模板来管理，可参照如下原则：如果能在较高的层次上抽象出事物的共同属性，且能满足管理需求，那么应使用同一个模板来管理，否则应建立不同的模板。例如，牛和马，如果需要管理身高、体重、数量等属性，那么可用同一模板；如果要具体到区分是奶牛还是水牛这一层次，就应该单独为“牛”建立一个模板。</p>
                </dd>
                <dt>如何创建一个模板？</dt>
                <dd><p>在空白区域点击右键，选择“添加模板”，输入模板名称并回车，即可建立一个空的模板，并自动进入该模板的设计界面。</p></dd>
                <dt>如何设置模板的权限？</dt>
                <dd><p>在模板上点击右键，选“权限”，在弹出的对话框中，分别为不同角色设置适当的权限，之后点击“确定”即可。请参考：<a href="?subject=power&showpath=1" runat="server">用户、角色及权限</a>。</p></dd>
                <dt>如何导入或导出模板？</dt>
                <dd><p>
                    在要导出的模板上点击右键，选“导出”，或勾选要导出的模板，然后在空白处点右键，选“导出选中模板”，将会弹出文件下载对话框，点击“保存”即可将模板下载到本地电脑的指定位置；在页面空白处点右键，选“导入模板”，在弹出的对话框中点击“浏览”找到所需要导入的模板文件后，点击“导入”即可将该文件中包含的模板导入到系统中。</p></dd>
                <dt>如何设置模板的标识字段？</dt>
                <dd><p>标识字段是指作为标识的属性，如，人的姓名、产品的名称等，通常可以理解为就是作为对象的名称的字段，其作用主要在于可以直观地让人知道这个对象是哪一个对象。标识字段会在缩略视图中作为名称显示出来。在模板上点击右键 - 设置，即可设置标识字段。</p></dd>
                <dt>什么是默认目录，如何设置？</dt>
                <dd><p>默认目录是指在添加记录时，该记录默认将保存到哪个目录。如果设置为“不关联目录”，则表明此模板类型的数据不需要放到某个目录中，也不能从任何目录中看到这些记录，这通常用于管理动态数据的模板，如各种流水帐记录、设备检修记录之类。</p></dd>
                <dt>数据录入人员是否可以管理他人录入的数据？</dt>
                <dd><p>这取决于对其权限设置中，是否选中了“禁止编辑或删除他人添加的记录”选项。</p></dd>
                <dt>如何建立模板关系？</dt>
                <dd>
                    <p>很多情况下，需要将管理对象用多个模板来分别管理其某个方面，例如对于“工程”项目，除了管理工程基本信息外，还有工程施工记录、工程收付款记录等等，这就需要将其分别用不同的模板来管理（因为一个工程可能会有多条施工记录等），并通过诸如项目名称或项目编号来关联起来，以便在录入或浏览时更容易处理相关的信息。</p>
                    <p>再如，订单模板与相应的订单商品明细模板，也是这样的一种主从关系，一个订单会对应有多条商品明细记录。建立主从关系的步骤如下：</p>
                    <p>进入设计中心，在主模板上点右键，选“设置”，在弹出的对话框中切换到“关系”标签页，在下面的“添加子模板”处选择作为子模板的模板，并设置关联字段。如，（订单商品明细的）订单编号关联到当前“订单编号”，其实质相当于是，某个订单的商品明细记录，就是订单商品明细中订单编号等于这个订单的编号的那些记录。</p>
                    <p>选项“同步更新关联字段”如果选中，则在上例中修改订单的编号时，“订单商品明细”中它所对应的那些记录的订单编号也会作相应的变更；“同步删除关联记录”选项用于在删除某条记录时，子模板中相关联的记录也同时自动删除，如删除一个订单，它对应的订单商品明细记录也会同时删除。</p>
                    <p>设置好关联和选项后，点击下面的“添加”按钮即可建立起该主从关系。这将为今后的录入、浏览和管理数据提供方便。</p>
                </dd>
                <dt>小技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>用鼠标拖动图标可以调整模板或文件夹的顺序，并自动记忆这种顺序。对于有系统管理权限的用户，这种调整结果是作为系统默认顺序的；非系统管理权限的用户，在默认顺序的基础上，可以自己调整顺序，但这种调整不会影响其他人。</li>
                        <li>点模板图标右下角的复选框勾选后，可以在空白处点右键，对所选的多个模板进行导出或备份操作。双击空白处可以全选或全不选所有模板。</li>
                    </ul>
                </dd>
                <dt>相关主题</dt>
                <dd class="related">
                    <a href="?subject=templet">模板设计</a>
                </dd>
            </dl>
        </asp:Panel>
                    
        <asp:Panel ID="dataadmin" Visible="false" runat="server">
            <div class="path">操作路径： 点左侧栏导航区“<%= ims.Sys.DataCenterText %>”</div>
            <p>注：随权限的不同，以下所涉及到的某些菜单项可能不会在右键菜单中显示。</p>
            <dl>
                <dt>如何添加和管理过滤器？</dt>
                <dd><p>在模板上点击右键，选“过滤器”，在打开的页面中即可查看、添加、编辑或删除过滤器。要查看过滤器的应用结果，可在模板的右键菜单的“打开”项子菜单中，点击要打开的过滤器。</p></dd>
                <dt>如何批量更新数据？</dt>
                <dd>
                    <p>在模板上点击右键，选“数据管理”，在弹出的对话框中“批量更新”处选择要更新的字段，并设置更新的值后，点击右下方的“更新”按钮，即可一次性更新所有基于该模板的记录。</p>
                </dd>
                <dt>如何备份数据？</dt>
                <dd><p>在要备份的模板上点击右键，选“数据管理”，在弹出的对话框中点击“备份”按钮，即可将模板以及基于该模板的数据以压缩包的形式下载到本地电脑的指定位置。</p></dd>
                <dt>如何备份多个模板的数据？</dt>
                <dd><p>勾选要备份的模板，然后在页面空白处点右键，选“备份选中数据”，即可将所选模板的所有相关数据以压缩包的形式下载到本地电脑的指定位置</p></dd>
                <dt>如何恢复数据？</dt>
                <dd><p>在页面空白处点右键，选“从备份中恢复”，在弹出的对话框中点击“浏览”找到所需要恢复的备份文件后，点击“恢复”即可。恢复的记录全部被放置在根目录（如果不是设置为“不关联目录”的话），可从右键菜单－“数据管理”－“移到指定目录”来将记录移动到合适的目录。</p></dd>
                <dt>如何导出Excel数据？</dt>
                <dd>
                    <p>在要导出的模板上点右键，选“数据管理”，在弹出的对话框中，点击“导出到Excel”即可将所有数据导出到一个Excel文件。如果有相关的图片或文件，则导出的将是一个包含了这些文件及Excel文件的ZIP格式压缩文件。</p>
                    <p>注：导出的Excel文件采用XML格式，因此Microsoft Office必须在XP以上版本才能打开和编辑。</p>
                </dd>
                <dt id="import">如何通过Excel批量导入或更新数据？</dt>
                <dd>
                    <p>在要导出的模板上点右键，选“数据管理”，在弹出的对话框中，点击“下载Excel表单”可以导出一个只有标题行的Excel文件，可用它来录入符合格式要求的数据；点击“从Excel导入”，可将已编辑好的符合格式要求的Excel文件或ZIP压缩文件导入进来。须注意的是：</p>
                    <ul class="decoration">
                        <li>要导入的Excel表中，与图片或文件类型字段对应的列中，输入文件名（不含路径），多个文件之间用“|”或逗号、顿号分隔，文件名中不能包含这几个用作分隔符的字符。Excel文件要放在“Excel”文件夹中，相关的文件放在“Files”文件夹中，再将二者打包为.zip压缩文件即可用于导入。</li>
                        <li>公式、查询类型的字段，以及除保密级别外的其它通用属性（如更新人、更新时间、目录）不能从Excel导入，将会被忽略。</li>
                        <li>导入时，仅处理工作簿中的第一个工作表，而忽略其它的工作表（如果有）。</li>
                        <li>模板中定义的必填字段和不允许重复的字段，必须在表中存在并遵循相应的规则，否则无法导入数据。</li>
                        <li>用于导入的工作表数据，不允许有合并单元格的情况。</li>
                        <li>执行导入时，系统根据Excel表中各列与模板中的字段名的对应关系来处理数据；如果是用于更新，将根据ID列或第一个不允许重复值的列来匹配原始记录。</li>
                    </ul>
                </dd>
                <dt>如何批量更新所有自动填充字段？</dt>
                <dd>
                    <p>在模板上点右键，选"数据管理"，在弹出的对话框中"批量更新"处选择"-自动填充字段-"，点击右下方的"更新"按钮，即可重新自动填充所有未"禁止修改"的自动填充字段。</p>
                    <p>注意：因数据保护、模板关系锁定、条件字段未填写等原因，更新的范围和正确性可能不符合预期，请慎重操作并及时检查数据。</p>
                </dd>
                <dt>小技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>用鼠标拖动图标可以调整模板或文件夹的顺序，并自动记忆这种顺序。对于有系统管理权限的用户，这种调整结果是作为系统默认顺序的；非系统管理权限的用户，在默认顺序的基础上，可以自己调整顺序，但这种调整不会影响其他人。</li>
                        <li>点模板图标右下角的复选框勾选后，可以在空白处点右键，对所选的多个模板进行导出或备份操作。双击空白处可以全选或全不选所有模板。</li>
                    </ul>
                </dd>
                <dt>相关主题</dt>
                <dd class="related">
                    <a href="?subject=fastfilter">筛选</a>
                    <a href="?subject=filters">过滤器</a>
                </dd>
            </dl>
        </asp:Panel>
                    
        <asp:Panel ID="table" Visible="false" runat="server">
            <div class="path">操作路径： 鼠标移到左侧导航区“切换视图”（或显示为“最近浏览的数据”）处，点“表格视图”。默认视图设为“表格视图”的模板，直接打开数据即进入表格视图</div>
            <dl>
                <dt>如何只显示需要查看的字段？</dt>
                <dd><p>点击“更多”按钮，选“显示/隐藏列”，可选择需要显示的字段。</p></dd>
                <dt>如何调整表格？</dt>
                <dd><p>在表格的标题行中，将鼠标移到列标题单元格，可拖动调整列顺序；将鼠标移到列边界线上，可拖动调整列宽度；在表格右下角，可设置每页显示数量。</p></dd>
                <dt>如何按某个字段来排序？</dt>
                <dd><p>点击列标题链接，即可按该列排序。再次点击同一列的标题链接，则进行相反的排序。</p></dd>
                <dt>如何对表格中的某一行执行编辑或删除等操作？</dt>
                <dd><p>在要执行操作的行点右键，或单击 <i class="f-up r1"></i>图标，可弹出操作菜单；双击行可就地编辑（或执行设定的其它操作），按住Ctrl键再双击可就地打开。</p></dd>
                <dt>如何对表格中的数据进行批量操作？</dt>
                <dd><p>点击“批量操作”按钮，可对当前勾选的行，或当前所有记录，进行批量更新、删除、导出Excel等操作。</p></dd>
                <dt>如何对表格中的数据进行简单的统计？</dt>
                <dd><p>表格左下方的下拉列表中，有“合计”、“平均值”等基本的统计功能，选择某一个统计功能后，会在可统计的列显示统计结果。此操作是针对当前所有数据，而不仅仅是当前页所显示的数据。</p></dd>
                <dt>如何保存表格的显示设置？</dt>
                <dd><p>如果有权限，会在表格下方看到一个“版式”按钮，点击可执行保存当前版式、切换版式、管理版式等操作。表格的版式设置包括：表格样式、列的顺序、宽度、可见性，及页脚统计功能等。请参考：<a href="?subject=tableLayoutManage">版式管理</a></p></dd>
                <dt>小技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>在要操作的行空白处点右键，会弹出操作菜单；双击行，可执行指定操作（打开、就地编辑等）。</li>
                        <li>在就地编辑时，可在任一输入元素上直接回车提交保存。</li>
                        <li>表格视图中导出Excel功能只会导出当前所显示的列，因此可临时隐藏图片和文件类型的列之后再导出，从而避免因包含文件而体积较大难以下载。</li>
                        <li>多条件组合筛选时，可直接设置筛选条件，系统会自动选中该条件；设置好条件之后，可直接在输入元素上回车执行筛选。</li>
                        <li>单元格内容较多时，可能会显示不完，这时可将鼠标移上，会悬浮显示完整内容；或点“更多”按钮，勾选“显示溢出内容”。</li>
                    </ul>
                </dd>
                <dt>相关主题</dt>
                <dd class="related">
                    <a href="?subject=CondFormat">条件格式</a>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="report" Visible="false" runat="server">
            <div class="path">操作路径： 鼠标移到左侧导航区“切换视图”（或显示为“最近浏览的数据”）处，点“报表视图”。默认视图设为“报表视图”的模板，直接打开数据即进入报表视图</div>
            <dl>
                <dt>如何设置报表？</dt>
                <dd>
                    <p>点击“报表设置”按钮，弹出设置窗口后，设置以下内容：</p>
                    <ul class="decoration">
                        <li><span class="term">根据什么来分组统计？</span>选择一个字段，报表将按该字段对记录进行分组，并分别计算各组的统计值。如果分组字段为数字类型或日期时间类型，还可以使用自动分段或手工指定段点值进行分组，如指定为“100,500”，将对该字段按小于100、100到500（不含500）、大于等于500三个组进行分组统计。还可以设置子分组（即组内再进行分组，可设置最多五级分组），并可分别指定组的排序方式。</li>
                        <li><span class="term">报表要显示哪些内容？</span>勾选要显示在报表中的字段。还可以设置一些选项，决定是否显示报表标题、各组的明细记录等。</li>
                        <li><span class="term">统计方法</span>设置对各个分组的各个统计字段的统计方法。如，求和、求平均值。</li>
                        <li><span class="term">明细排序</span>指定最小一级分组中，明细记录的排序方式。</li>
                        <li><span class="term">报表标题</span>设置显示在报表上方的标题。留空则自动生成，若想不显示标题，可填入空格。</li>
                        <li><span class="term">报表脚注</span>设置显示在报表下面的内容，比如审核人、打印时间、报表的说明等。可使用全角空格占位，支持使用变量，如 $UserRealName$ 表示操作人名称，$Now$ 表示当时时间。</li>
                    </ul>
                </dd>
                <dt>是否可调整报表各列的顺序和宽度？</dt>
                <dd><p>可将鼠标移到报表标题行的列边界线处，拖动来调整列的宽度。目前暂不支持调整列顺序，但由于报表设置中的字段顺序是与表格视图同步的，因此可在表格视图中调整列顺序后再设置并保存报表设置。</p></dd>
                <dt>如何将报表设置保存下来？</dt>
                <dd><p>如果有权限，将会看到“管理报表”按钮，点击打开对话框后，可将当前的报表设置（及列的宽度调整结果）命名保存下来，以后打开该模板数据的报表视图时，就可以选择该报表。</p></dd>
                <dt>分段分组的组边界值如何包含？</dt>
                <dd><p>数字或日期时间类型的字段，可以设置自动分段分组或手动指定段点值进行分组，这种情况下，除了最大的一组外，每组均包含左边界值，不包含右边界值。如12～100，100～500，500～678，这三组中，第一组不包含100，第二组包含100但不包含500，第三组则包含了500和678这两个边界值。</p></dd>
                <dt>跨表统计</dt>
                <dd><p>通过在模板关系中添加组合，可以在报表中组合其它相关表的数据来进行统计分析。详见：<a href="?subject=unionquery">组合</a></p></dd>
            </dl>
        </asp:Panel>
 
        <asp:Panel ID="unionquery" Visible="false" runat="server">
            <div class="path">操作路径： 设计中心，模板上点右键 - 设置 - 关系，添加组合</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>组合，用于将相关表的关联数据组合到当前表中，从而实现跨表统计和分析。如，将订单数据组合到客户的报表中，查看客户的订单统计。</p>
                    <p>设置组合后，报表视图中可使用组合的字段参与统计。</p>
                </dd>
                <dt>注意</dt>
                <dd>
                    <p>在报表中使用组合的字段时，对组合的表会忽略权限和数据保护限制，并且如果是一对多关系，一条记录与它匹配的N条记录组合将产生N行。例如，产品表组合了库存表，后者包含同一产品不同颜色的出入库记录，那么组合颜色字段后，若某产品存在3种颜色，就将会产生3行明细记录，这3行中只有组合的字段是不同的。如下图所示：</p>
                    <p><img src="images/help/union.png" /></p>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="thumb" Visible="false" runat="server">
            <div class="path">操作路径： 鼠标移到左侧导航区“切换视图”（或显示为“最近浏览的数据”）处，点“缩略视图”。默认视图设为“缩略视图”的模板，直接打开数据即进入缩略视图</div>
            <dl>
                <dt>如何修改一条记录的名称？</dt>
                <dd><p>在要更名的记录上点击右键，选“重命名”，输入新的名称即可。该操作实际上是修改了记录的标识字段的值。</p></dd>
                <dt>如何进行排序？</dt>
                <dd><p>右键点击空白区域，在“排序”的下级菜单中点击要用作排序依据的字段即可。如果再次用同一字段来排序，则会以相反的顺序排序。在“排序”的下级菜单项中，带有图标 <i class="f-asc greenish"></i>或 <i class="f-desc greenish"></i>的项是当前的排序依据项，前一个图标表示顺序排序，后一个图标表示逆序排序。</p></dd>
                <dt>小技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>在需要翻页浏览时，可以使用键盘进行快捷操作。方向键→或PageDown键可翻到下一页；方向键←或PageUp可翻到上一页；Home键到第一页；End键到最后一页。</li>
                        <li>直接单击缩略图可打开其详细信息页面；单击缩略图中间的悬泘图标，可查看其较大尺寸的图片，并进入幻灯显示状态。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="detail" Visible="false" runat="server">
            <div class="path">操作路径： 鼠标移到左侧导航区“切换视图”（或显示为“最近浏览的数据”）处，点“详情视图”。默认视图设为“详情视图”的模板，直接打开数据即进入详情视图</div>
            <dl>
                <dt>如何打印页面？</dt>
                <dd><p>在打印之前，请先从浏览器的“文件”菜单进入“页面设置”，设置好页面边距及页眉页脚等信息后再点击页面上的“打印”按钮。</p></dd>
                <dt>打印出来看不到缩略图？</dt>
                <dd><p>这需要设置浏览器：打开“文件”菜单，在“页面设置”中勾选“打印背景颜色与图像”。如果没有该选项，请打开“工具”菜单下面的“Internet选项”，切换到“高级”，选中“打印背景颜色与图像”，点击“确定”。之后再重新打印即可。</p></dd>
                <dt>小技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>如果有编辑权限，可以双击单元格，就地编辑对应的字段。</li>
                        <li>如果是在一批记录中浏览详情视图，可使用键盘进行跳转：方向键→或PageDown键可翻到下一页；方向键←或PageUp可翻到上一页；Home键到第一页；End键到最后一页。</li>
                        <li>导出页面时，如果弹出迅雷下载且下载失败，请设置迅雷，取消“监视浏览器”选项。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="jsplugin" Visible="false" runat="server">
            <div class="path">操作路径： 系统管理 &rsaquo; 系统维护 &rsaquo; 系统开发，点“编辑外挂脚本”</div>
            <dl>
                <dt>什么是外挂脚本？</dt>
                <dd>
                    <p>外挂脚本是一个 Javascript 脚本文件（js/plugin.js），用于对系统进行一些特殊处理。它会被系统的每个页面加载运行；它不会被系统升级所覆盖。</p>
                    <p>系统采用了 jQuery v3.6 脚本框架，因此可在外挂脚本中使用 jQuery。</p>
                    <p>请参考：<a href="https://www.runoob.com/js/js-tutorial.html" target="_blank">JavaScript 教程</a>、<a href="https://www.runoob.com/jquery/jquery-tutorial.html" target="_blank">jQuery 教程</a></p>
                </dd>
                <dt>示例代码</dt>
                <dd>
<pre>
    <span class="green">//页面加载后执行</span>
    $(function () {
        <span class="green">//若是ID为8的模板数据录入页面</span>
        if (getPage() == "edit.aspx" && getUrlParam("tid") == 8) {
            var items = {
                "是": "f72, f75", <span class="green">//用户选择"是"时，控制ID为f72、f75的元素可见性</span>
                "否": "f73"
            };
            BindToggle("C8", items); <span class="green">//使ID为C8的输入元素，输入不同值时隐藏不同元素</span>
            BindToggle("C8", items, true); <span class="green">//ID为C8的元素，输入不同值时显示不同元素</span>
            BindRequired("f9"); <span class="green">//ID为f9的元素如果可见，则要求必填</span>
        }
        <span class="green">//ID为8的模板详情页，就地编辑某字段后，弹出另一字段就地编辑</span>
        if ($("html").is("#detail.tid8")) {
            <span class="green">//fid为1的字段编辑后弹出fid为2的字段就地编辑；字段2编辑后再编辑字段3</span>
            window.updateWith = {"1": "2", "2": "3"};
        }
    });
</pre>
                </dd>
                <dt>jQuery 极简入门</dt>
                <dd>
                    <p>使用 jQuery 处理页面元素，通常有两个步骤：</p>
                    <p><span class="term">1. 定位要处理的元素</span>jQuery 使用"选择器"语法来定位元素。可在页面元素上右键，检查元素，来查看元素及上下文 HTML 结构，如：</p>
                    <pre class="red">
        &lt;div id="box"&gt;
            &lt;p id="tip" class="msg"&gt;这里是一个段落&lt;/p&gt;
        &lt;/div&gt;</pre>
                    <p>要匹配中间段落元素，可用 <span class="red">p</span>、<span class="red">#tip</span>、<span class="red">.msg</span> 等选择器。为避免匹配其它的段落，可加以限定，如：<span class="red">#box p</span></p>
                    <p><span class="term">2. 利用选择器处理元素</span>如，隐藏元素：<span class="red">$("#tip").hide();</span></p>
                </dd>
                <dt>部分Javascript/jQuery函数/方法</dt>
                <dd>
                    <ul class="decoration">
                        <li><span class="term">getPage()</span>获取当前页面文件名</li>
                        <li><span class="term">getUser()</span>获取当前操作者用户名</li>
                        <li><span class="term">showMsgPop(msg)</span>在右下角弹出气泡消息</li>
                        <li><span class="term">user(userName)</span>弹出给指定用户发送消息/短信/邮件的界面</li>
                        <li><span class="term">toCopy(src)</span>复制指定元素的内容。参数可以是jQuery对象或选择器，或Dom元素</li>
                        <li><span class="term">toPopup(url)</span>弹出显示指定的页面/网址</li>
                        <li><span class="term">toPrompt(title, onok)</span>提示用户输入。参数：title，对话框标题；onok，点击确定按钮时执行的方法</li>
                        <li><span class="term">toExportAs(selector, width, pageTitle, exclude)</span>弹出导出对话框。参数依次为：要导出的元素或jQuery选择器、文档宽度、标题、要排除的元素或jQuery选择器</li>
                        <li><span class="term">$(selector).hide()</span>隐藏元素</li>
                        <li><span class="term">$(selector).show()</span>显示元素</li>
                        <li><span class="term">$(selector).printIt()</span>打印元素。示例：<span class="red">$("#msg").printIt({pageTitle: "通知", exclude: "div.footer"});</span>，打印id为msg的元素（排除其中class为footer的div元素）</li>
                        <li><span class="term">$(selector).qrcode()</span>生成二维码。示例：<span class="red">$("#mydiv").qrcode({width:100, height:100, text:"http://baidu.com", background:"#ffffff", foreground:"#112244" });</span></li>
                        <li><span class="term">addWaterMark(text)</span>为页面添加水印文字</li>
                        <li><span class="term">autoFont(selector)</span>使指定元素的文字自动缩小以适配宽度</li>
                        <li>获取变量值： $.get("get.aspx", { action: "getVar", "var": "UserUnit" }, function(res){ alert(res); });</li>
                        <li>要求文本框必须输入了条件字段才产生输入提示：$(selector).attr("condrequired", "1");</li>
                    </ul>
                </dd>
                <dt>调用API接口</dt>
                <dd>
                    <p>若系统启用了 API 接口，可使用脚本直接调用接口，来执行获取或处理数据等操作。详见：<a href="?subject=api">API 接口</a></p>
                </dd>
                <dt>可选变量</dt>
                <dd>
                    <p>可在脚本最前面添加以下变量以实现相应控制：</p>
                    <ul class="decoration">
                        <li>var syncFinder = true; <span class="green">//顶栏搜索框与当前打开的数据同步切换</span></li>
                    </ul>
                </dd>
                <dt>技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>通常，可按F12键打开浏览器的开发者工具栏，查看页面元素的ID等信息。</li>
                        <li>注意：脚本中的逗号引号等，要用英文半角符号（除非是文本）；引号中的引号要转义处理。</li>
                        <li>编辑时，可按快捷键Ctrl+S保存。</li>
                        <li>表格视图、详情视图、图表视图、报表视图和录入页面的html元素具有形如"tid123"的样式类，其数字部分为模板ID。脚本中可据此进行针对性处理，如：<span class="red">if ($("html").is("#table.tid3")) { ... }</span></li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="cssplugin" Visible="false" runat="server">
            <div class="path">操作路径： 系统管理 &rsaquo; 系统维护 &rsaquo; 系统开发，点“编辑外挂样式”</div>
            <dl>
                <dt>什么是外挂样式？</dt>
                <dd>
                    <p>外挂样式是一个CSS样式文件（App_Themes/plugin.css），用于对系统界面样式进行一些特殊处理。它会被系统的每个页面加载。它不会被系统升级所覆盖。 请参考：<a href="https://www.runoob.com/css/css-tutorial.html" target="_blank">CSS 教程</a></p>
                </dd>
                <dt>要点</dt>
                <dd>
                    <ul class="decoration">
                        <li>外挂样式会在每个页面加载，所以针对特定页面的样式，需在前面加上页面限定，如<span class="red">#edit p{color: gray}</span>，前面的"#edit "即限定了该样式仅应用于这个页面，它对应于页面源代码中<span class="red">&lt;html id="edit"&gt;</span>这一行的id值。</li>
                        <li>为避免与内置样式冲突，建议为自定义的样式类名称添加一个前缀，如：my_btn。</li>
                        <li>CSS中用<span class="red">/* ... */</span>的形式对代码进行注释，注释掉的代码不会生效。</li>
                    </ul>
                </dd>
                <dt>示例</dt>
                <dd>
                    <ul class="decoration">
                        <li><span class="term">修改顶栏底色</span><span class="red">#topbar #navbar{background:#003d5b !important}</span></li>
                        <li><span class="term">修改默认按钮颜色</span><span class="red">.btn{background:#6d7282}</span></li>
                        <li><span class="term">让打印时链接呈黑色</span><span class="red">@media print{a{color:#000!important}}</span></li>
                        <li><span class="term">让详情页面宽度最大化</span><span class="red">#detail body{max-width:100%}</span></li>
                        <li><span class="term">修改模板图标</span><span class="red">#templets .t8 div:before{content:"\e67c";color:#1fc3ff}</span><br />/* 8为模板ID，"\e67c"为<a href="font_demo.html?tab=unicode" target="_blank">选择图标</a>时得到的图标代码"&amp;#xe67c;"变换而来 */</li>
                    </ul>
                </dd>
                <dt>CSS 极简入门</dt>
                <dd>
                    <p>使用 CSS 处理页面元素样式，要用选择器来匹配目标元素，并设置其样式。可以在页面元素上右键，检查元素，来查看元素及上下文 HTML 结构，如：</p>
                    <pre class="red">
        &lt;div id="box"&gt;
            &lt;p id="tip" class="msg"&gt;这里是一个段落&lt;/p&gt;
        &lt;/div&gt;</pre>
                    <p>要处理中间段落元素，可用 <span class="red">p</span>、<span class="red">#tip</span>、<span class="red">.msg</span> 等选择器。为避免选中其它的段落，可加以限定，如：<span class="red">#box p</span></p>
                    <p>确定了选择器，就可以为它写样式规则了，如隐藏：<span class="red">#tip{display:none}</span>，或设置颜色：<span class="red">#tip{color: red}</span></p>
                </dd>
                <dt>技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>通常，可按F12键打开浏览器的开发者工具栏，查看页面元素的ID等信息。或在元素上右键 - "检查元素"。</li>
                        <li>注意：代码中的冒号分号等，要用英文半角符号。</li>
                        <li>编辑时，可按快捷键Ctrl+S保存。</li>
                        <li>表格视图、详情视图、图表视图、报表视图和录入页面的html元素具有形如"tid123"的样式类，其数字部分为模板ID。外挂样式中可据此限定样式应用范围，如：<span class="red">#detail.tid3 body{max-width:100%}</span></li>
                    </ul>
                </dd>
				<dt>相关主题</dt>
				<dd class="related">
                    <a href="?subject=cssclass">系统常用样式类</a> <a href="?subject=iconfont">字体图标</a>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="summary" Visible="false" runat="server">
            <div class="path">操作路径： 鼠标移到左侧导航区“切换视图”（或显示为“最近浏览的数据”）处，点“概要视图”。默认视图设为“概要视图”的模板，直接打开数据即进入概要视图</div>
            <dl>
                <dt>如何设置概要视图的显示格式？</dt>
                <dd>
                    <p>如果您有权限，那么当鼠标移到每一项的概要信息上面时，会在右边出现一个图标，点击就可以设置该模板数据的显示版式。</p>
                    <p>使用“自由排版”，可以实现非常灵活的版式。可以点击编辑器右下方的两个图标，用链接格式或详情视图版式初始化编辑器，再在此基础上作修改调整。</p>
                    <p>在“自由排版”的编辑器中，可通过插入字段代码来在指定的位置显示该字段的值，浏览时，这些代码会被替换为字段的实际值，这和详情视图的自由排版方式是相同的。</p>
                </dd>
                <dt>小技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>可使用键盘进行翻页浏览：方向键→或PageDown键可翻到下一页；方向键←或PageUp可翻到上一页；Home键到第一页；End键到最后一页。</li>
                        <li>选择“详情视图”的“默认版式”格式，每个人打开时会用自己的默认版式来显示，这与详情视图是同步的，受默认版式规则的影响。</li>
                        <li>使用详情视图版式，在打印时，每一项后面会分页，从而实现详情页面的批量打印效果。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="editor" Visible="false" runat="server">
            <dl>
                <dt>编辑器介绍</dt>
                <dd><p>编辑器是一个在使用上类似于Word的在线文字编辑工具，它与普通的文本输入框最大的区别在于，它能够设置文本的格式和样式，并插入图片、链接（文件）等多种元素，以”所见即所得“的方式进行编辑。</p></dd>
                <dt>编辑器使用要点</dt>
                <dd>
                    <ul class="decoration">
                        <li>如果还不熟悉编辑器的使用，请先将鼠标分别移到各个工具按钮上，通过其鼠标悬浮提示来了解它们的作用；分别在编辑区选中和未选中文本的情况下，点击鼠标右键来查看当前状态下可使用的快捷菜单。</li>
                        <li>在输入文本时，直接回车将会另起一段，如果只是想要换行，请按住Shift键再按回车键。</li>
                        <li>编辑器中的段落默认没有首行缩进。如果需要让段落首行缩进两个字符，请选中段落后，点“样式”下拉列表中的“段落首行缩进”。</li>
                        <li>如果需要控制打印时的分页，可使用工具栏的插入分页符按钮在适当位置插入分页符。</li>
                        <li>点击工具栏中 <img src="images/link.gif" align="absmiddle" /> 按钮可插入附件。</li>
                        <li>点击工具栏中 <img src="images/tabs.gif" /> 按钮，可插入多标签页（选项卡）组件。要添加或删除一组标签页，建议切换到源码模式来编辑，如下图。将绿框的两行分别复制并对应修改红线标注处即可添加一组：<br />
                            <img src="images/help/addtab.png" style="border:2px #f14c04 solid" /><br />
                            可将第一行的"ui-tabs"替换为"ui-tabs noborder"，显示为无外框样式。
                        </li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
                    
        <asp:Panel ID="fastfilter" Visible="false" runat="server">
            <div class="path">操作路径： <%= ims.Sys.DataCenterText %>，模板上点右键 - 筛选；或表格视图下，点“筛选”按钮</div>
            <dl>
                <dt>如何根据单一条件筛选？</dt>
                <dd><p>在每一个带复选框的条件之后，有一个 <i class="f-play greenish"></i>图标，点击即可按该条件进行筛选（无须勾选前面的复选框）。</p></dd>
                <dt>如何根据多个条件组合筛选？</dt>
                <dd>
                    <p>勾选要组合应用的条件前面的复选框，设置好这些条件之后，点击“确定”按钮即可按这些条件执行筛选。</p>
                </dd>
                <dt>说明</dt>
                <dd>
                    <p>对于数字/日期时间类型字段，可以指定起始值和/或截止值来作为条件，例如，指定起始数值100，不指定截止数值，则表示筛选所有该字段值大于或等于100的记录；</p>
                    <p>如果要搜索为空的字段，将条件输入框留空即可。</p>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="infoEdit" Visible="false" runat="server">
            <div class="path">操作路径： 点顶部“<%= ims.Sys.InfoCenterText %>”图标，再点右上方“发布”图标；或鼠标移到左侧栏导航区“<%= ims.Sys.InfoCenterText %>”处，点“发布<%= ims.Sys.InfoType %>”</div>
            <dl>
                <dt>术语</dt>
                <dd>
                    <p><span class="term">摘要</span>用于概述主要内容的一段文字。摘要内容将显示在“<%= ims.Sys.InfoCenterText %>”的<%= ims.Sys.InfoType %>列表中，方便浏览时了解大致的内容。</p>
                    <p><span class="term">标签</span>标签是一种开放式分类方式，可将自己发布的内容加上一个或多个标签，以便浏览者能方便地找到所关注的有关联的内容。</p>
                    <p><span class="term">保密级别</span>用于确定所发布内容的保密程度，只有浏览权限级别不低于该保密级别的用户，才能浏览。如果设为“仅本人可见”，则其他任何人无论浏览权限高低，都看不到此内容。</p>
                    <p><span class="term">置顶</span>置顶，就是将所发布的内容显示在<%= ims.Sys.InfoType %>列表的前面。无论浏览时选择何种排序方式，置顶的<%= ims.Sys.InfoType %>都会排列在未置顶的前面。</p>
                </dd>
				<dt>相关主题</dt>
				<dd class="related">
                    <asp:HyperLink ID="HyperLink26" NavigateUrl="help.aspx?subject=editor" runat="server">编辑器</asp:HyperLink>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="CondFormat" Visible="false" runat="server">
            <div class="path">操作路径： 表格视图下，点“更多…”按钮 - 条件格式</div>
            <dl>
                <dd>
                    <p><span class="term">什么是条件格式？</span>所谓条件格式，是指为满足指定条件的记录使用指定的格式进行显示。条件格式设置后将会自动保存下来，所有人员在浏览时都会应用此设置。</p>
                    <p><span class="term">如何设置条件格式？</span>勾选条件格式下的“启用”复选框，点“条件”后面的“设置”，来设置需要用特殊样式进行显示的条件，再指定“格式”中的的背景色、前景色等选项。如果勾选了“置顶”，则满足条件的记录将在最前面列出来（该选项在各个视图中都有效）。</p>
                    <p><span class="term">注意：</span>"置顶"可能对性能造成明显影响，应慎用。</p>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="carryover" Visible="false" runat="server">
            <div class="path">操作路径： 设计中心，模板右键，设置 - 设置结转方法</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>结转，就是将日常流水式的数据定期转移到另外的表中封存备查，以便于核算、封存数据，并减少当前表中的数据量。例如，员工计件工资，按月度结转，可以将统计数据结转到工资发放表，将明细记录结转到历史数据表。</p>
                    <p><span class="term">结转统计结果</span>将待结转数据进行统计，把统计结果作为一条记录添加到指定的模板数据表中。需设置要统计的字段和计算方法，以及对应到目标表中的字段。</p>
                    <p><span class="term">结转源数据</span>将待结转的记录按所设定的字段映射关系逐一生成到指定的目标模板数据表中。</p>
                </dd>
                <dt>操作权限</dt>
                <dd>
                    <p>用户需满足以下权限要求，才能执行结转：</p>
                    <ul class="decoration">
                        <li>对待结转模板有浏览权限，且未被数据保护设置“禁止浏览”;</li>
                        <li>对结转目标模板有添加记录权限，且未被数据保护设置“禁止添加记录”；</li>
                        <li>如果指定了“结转后删除源数据”，则对待结转模板要有数据管理权限（允许添加记录且未“禁止编辑或删除他人添加的记录”），且未被数据保护设置“禁止删除”。</li>
                    </ul>
                </dd>
                <dt>同步结转</dt>
                <dd>
                    <p>同步结转，即同时自动结转其它模板的数据。对于子模板，将结转关联数据，非子模板则由结转条件决定。因此，如果子模板设置了结转条件，或非子模板未设置条件，将不能被设置为同步结转。</p>
                    <p>被设置为同步结转的，不能单独执行结转操作，除非它也设置了同步结转其它模板。</p>
                    <p>父子关系的一对模板，如果都设置了结转，建议在主模板上设置同步结转子模板数据，以保持数据同步性和完整性。</p>
                </dd>
                <dt>说明</dt>
                <dd>
                    <ul class="decoration">
                        <li>若指定了结转时机，则仅在所指定的时段内可以执行结转，否则随时可以结转。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="sidebar" Visible="false" runat="server">
            <div class="path">操作路径： 首页 &rsaquo; 个性化 &rsaquo; 自定义左侧栏；或，在左侧栏右上角点"+"图标</div>
            <dl>
                <dt>如何自定义左侧栏？</dt>
                <dd>
                    <p>可用鼠标将版块从预览区拖到候选区来隐藏之，或从候选区拖入预览区来显示之。还可添加/删除版块，或拖动调整版块的位置。操作结果会实时保存，也可另存为命名的版式。</p>
                    <p><span class="term">如何添加新版块</span>在候选区下，点“添加版块”按钮，输入新版块的名称，并点击“添加元素”来添加内容到新版块的内容区，然后点“添加”即可。在添加版块对话框，可点“添加搜索版块”，来添加预设的搜索版式。</p>
                    <p><span class="term">如何编辑树形结构</span>在版块中添加树形结构后，将鼠标移上结点元素，将显示操作按钮（添加子节点、修改、删除）；拖动结点可调整其位置或层次；节点的开合状态将保存为初始状态。</p>
                    <p><span class="term">如果编辑或删除版块</span>对于自定义版块，可点标题旁边的“+”图标来编辑，或点“X”图标来删除。搜索版块未提供编辑功能，只能删除后重新添加。</p>
                    <p runat="server" id="_selectLayout"><span class="term">选择要应用的版式</span>点击“选择版式”按钮，可选择使用自己设定的左侧栏，或者管理员为角色预设的默认左侧栏。任何时候，可点“保存”按钮，将当前显示的版式保存为自己的版式。</p>
                    <p runat="server" id="_manageLayout"><span class="term">如何管理版式</span>任何时候，可点“保存为…”按钮，将当前的版式命名保存；点“管理版式”按钮，可将已有的版式设为系统默认版式、改名、编辑、删除，或（点击版式名）设为角色的默认版式。</p>
                </dd>
                <dt>提示</dt>
                <dd>
                    <p>
                        如果在版式管理中勾选“禁止普通用户自定义左侧栏”，则非管理员只能使用管理员指定的默认版式。
                    </p>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="selectUser" Visible="false" runat="server">
            <div class="path">操作路径： 在输入用户名的文本框中双击</div>
            <dl>
                <dt>如何选择用户？</dt>
                <dd>
                    <p>方法一：在左侧点击选中要添加的用户或机构，再点击“>>”按钮。如果选中的是一个用户，会将该用户添加到右侧列表中；如果选中的是一个机构，则会将该机构下所有直属用户添加到右侧列表中。</p>
                    <p>方法二：直接双击要添加的用户或机构。</p>
                </dd>
                <dt>如何从已选取的用户列表中移除用户？</dt>
                <dd>
                    <p>方法一：在右侧列表中选中要移除的一个或多个用户，再点击“<<”按钮即可移除。可用鼠标拖动选取多项，或按住Ctrl或Shift键来选取多项。</p>
                    <p>方法二：直接双击要移除的用户名。</p>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="EditScan" Visible="false" runat="server">
            <div class="path">操作路径： 进入添加记录页面 &rsaquo; "版式"按钮 &rsaquo; 管理版式 &rsaquo; 设置扫码输入</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>扫码输入，指使用扫码设备，扫描条形码或二维码，将其识别并输入到文本框中。扫码输入本质上相当于用键盘输入并添加了一个回车键（这是扫码设备通常默认的处理方式，建议不要更改）。</p>
                </dd>
                <dt>如何设置扫码输入？</dt>
                <dd>
                    <p>只需指定扫码得到的内容要输入到哪个字段，录入时该字段输入框将默认聚焦，使用扫码设备扫描条码或二维码，即可将其内容输入到该文本框中。</p>
                    <p>如果指定了“扫码后自动保存”，则扫码输入后，系统会尝试保存表单，否则将跳转到下一个输入框。</p>
                </dd>
                <dt>技巧</dt>
                <dd>
                    <p>如果想连续扫码并自动保存，请勾选“扫码后自动保存”，并将“保存后动作”设为“新建”，这样可实现扫码一次保存为一条记录；也可切换到“多行录入”版式，并设置其扫码输入功能，可实现扫码一次自动添加一行，类似超市收银台的操作体验（详见：<a href="?subject=RowsScan">多行录入版式扫码输入</a>）。</p>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="RowsScan" Visible="false" runat="server">
            <div class="path">操作路径： 进入添加记录页面，切换到"多行录入"版式 &rsaquo; 点"版式"按钮 &rsaquo; 扫码设置</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>多行录入页面的扫码功能，以超市收银台作为典型应用场景，设置后可实现连续扫码输入，一次添加一行，如果扫描到相同的编码，则将已存在的行的数量加1。如果操作过程中需临时手工输入，可以点扫码框左边的条码图标，临时禁用扫码框自动聚焦效果。</p>
                </dd>
                <dt>几个设置选项：</dt>
                <dd>
                    <ul class="decoration">
                        <li><span class="term">扫码输入</span>指定要绑定扫码输入功能的字段；</li>
                        <li><span class="term">数量字段</span>指定计数用的字段。指定后，才能实时计算总数或总金额；</li>
                        <li><span class="term">单价字段</span>指定作为单价的字段。指定后，才能实时计算总金额；</li>
                        <li><span class="term">默认启用扫码输入 </span>指定是否在页面载入后自动启用扫码输入功能。</li>
                    </ul>
                </dd>
                <dt>技巧</dt>
                <dd>
                    <ul class="decoration">
                        <li>即使不使用扫码设备，设置扫码输入功能也有一定用途，比如，可以直接在扫码框手工输入编码并回车，这和扫码输入的效果是类似的，可实现连续输入，并可利用字段的输入提示功能。</li>
                        <li>对于像收银台或出库这样的应用场景，可以使用一对主从关系的模板，主模板只需“编码(自动编号）、时间（变量"当时时间"）、操作员（变量"操作者用户名"）、总金额（查询，从子表中计算总金额）”这样一些无需输入的字段，然后在子模板多行录入页面设置扫码功能，在主表单录入页面将保存后动作设为“新建”，即可实现连续扫码的操作体验。也可将保存后动作设为“浏览”，以便于打印单据。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="FindTemplet" Visible="false" runat="server">
            <div class="path">操作路径： 进入设计中心或<%= ims.Sys.DataCenterText %>，空白处点右键，查找</div>
            <dl>
                <dt>如何查找模板？</dt>
                <dd>
                    <p>输入关键字并回车或点“查找”按钮，即可列出名称包含该关键字的模板。可输入模板名称第一个字的拼音首字母快速查找。</p>
                </dd>
                <dt>说明</dt>
                <dd>
                    <ul class="decoration">
                        <li>该功能将从所有模板中查找，不论其位于哪个文件夹下；</li>
                        <li>关键字留空执行查找，将列出所有模板。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="moreSetting" Visible="false" runat="server">
            <div class="path">操作路径： 用记事本打开本系统程序目录中的Web.config</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>在本系统服务器上，用记事本打开安装目录中的 web.config 文件，可以添加一些平时较少用到的设置项。要添加一项设置，请在 <span class="red">&lt;appSettings&gt;</span> 这一行下添加如下一行：</p>
                    <p class="red">&lt;add key="Name" value="Value" /&gt;</p>
                    <p>其中，Name为设置项名称，Value为该项设置的值。</p>
                </dd>
                <dt>可用的设置项</dt>
                <dd>
                    <table id="moreoptions" class="normal" style="margin-left:2em;width:624px">
		                <tr>
			                <th style="width:132px">设置项</th>
			                <th style="width:180px">描述</th>
			                <th>可用的值</th>
			                <th>默认值</th>
		                </tr>
		                <tr>
			                <td>PasswordExpireDays</td>
			                <td>密码有效期</td>
			                <td>正整数（表示天数）</td>
			                <td>0（无有效期限制）</td>
		                </tr>
		                <tr>
			                <td>PasswordResetAs</td>
			                <td>重置密码方式</td>
			                <td>default：默认密码<br />random：随机密码</td>
			                <td>random</td>
		                </tr>
		                <tr>
			                <td>FullSearch</td>
			                <td>是否允许直接搜索数据中心<br />注：数据量较大时，搜索整个数据中心可能导致系统卡顿</td>
			                <td>true：允许<br />false：不允许<br />auto：自动</td>
			                <td>true</td>
		                </tr>
		                <tr>
			                <td>SmsContentLog</td>
			                <td>短信日志是否记录短信内容</td>
			                <td>true：记录<br />false：不记录</td>
			                <td>false</td>
		                </tr>
		                <tr>
			                <td>SynDelNoProtect</td>
			                <td>子模板记录被同步删除时，是否忽略数据保护</td>
			                <td>true：忽略<br />false：不忽略</td>
			                <td>false</td>
		                </tr>
		                <tr>
			                <td>DiyActionNoProtect</td>
			                <td>执行自定义操作时，是否忽略数据保护</td>
			                <td>true：忽略<br />false：不忽略</td>
			                <td>false</td>
		                </tr>
                    </table>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="masterSlave" Visible="false" runat="server">
            <div class="path">操作路径： 进入设计中心，空白处右键 - 添加主从模板</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>以订单管理为例，它涉及到订单的基本信息和订单中的商品清单，我们也许会考虑用一个订单模板来管理，但实际上应该分为“订单”和“订单明细”两个模板，才便于对商品明细的录入和统计，这二者就是主从（父子）关系，它们通过订单号关联起来。如下图所示：</p>
                    <div><img src="images/help/relation.png" /></div>
                    <p>建立起了这种模板关系之后，在订单录入和浏览时，就可以方便地对其相关的商品明细进行增删操作了，也可以在详情页面通过查询来获取并显示这些明细数据。</p>
                    <p>类似的例子还有：产品与产品投诉记录、病人与病历记录等。</p>
                </dd>
                <dt>如何建立主从模板？</dt>
                <dd>
                    <p>方法一（适于在现有模板间建立关系）：分别建立主模板和子模板，并在主模板的“设置/关系”处添加子模板关系。</p>
                    <p>方法二（适于新建主从关系模板）：在设计中心右键菜单中点“添加主从模板”，可以一次性建立起主模板和子模板，以及它们的关联字段，并自动建立起模板关系、版式和查询定义。如果输入多个子模板名称（逗号分隔），还可以同时创建多个子模板。</p>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="autoBackup" Visible="false" runat="server">
            <div class="path">操作路径： 系统管理 &rsaquo; 系统维护 &rsaquo; 系统备份和还原，点击“自动备份…”按钮</div>
            <dl>
                <dt>关于自动备份的几点说明</dt>
                <dd>
                    <ul class="decoration">
                        <li>指定备份文件存储位置时，可指定服务器电脑上的某个文件夹，或“\\abc\backup\”格式的网络共享文件夹路径。存储位置不能存放其它文件，否则可能被系统删除；</li>
                        <li>须确保运行本系统的帐户对存储位置有“修改”或“完全控制”权限；</li>
                        <li>将自动备份的开始时间设为小于当前时间，将立即触发自动备份功能；</li>
                        <li>可查看系统运行日志，来了解备份计划的执行情况；</li>
                        <li>如果系统因进程回收等原因停止运行，将无法自动备份；</li>
                        <li>建议使用百度网盘等云盘的自动备份功能将存储位置设为自动备份（到云盘），从而实现异地备份，进一步保障数据安全。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="flow" Visible="false" runat="server">
            <div class="path">操作路径： 设计中心，模板上点右键 - 设置，切换到“流程”标签，点“创建流程”</div>
            <dl>
                <dt>流程设计概述</dt>
                <dd>
                    <p>流程设计，是一个把工作业务处理逻辑和顺序以图形化方式进行表达的过程。它基于预设的表单模板，规定了发起和参与流程的人员、权限、处理时间，以及该过程中的信息沟通等内容。</p>
                </dd>
                <dt>术语</dt>
                <dd>
                    <p><span class="term">步骤</span>流程中的每一个处理环节，就是一个步骤，在设计中也叫“节点”。</p>
                    <p><span class="term">交办人</span>提交流程事项给本步骤的人，亦即上一个步骤的最终处理人（他让流程流转到本步骤）。</p>
                </dd>
                <dt>步骤类型</dt>
                <dd>
                    <p><span class="term">审批/确认</span>这种步骤有肯定和否定两种处理结果，通常意味着同意或不同意。</p>
                    <p><span class="term">事务处理</span>这种步骤就是一项工作任务，执行人可以报告完成进度或已经完成。</p>
                </dd>
                <dt>操作要点</dt>
                <dd>
                    <ul class="decoration">
                        <li>在任一步骤节点上点右键，可添加或指定其下一步骤；</li>
                        <li>点击步骤节点，可对该步骤进行设置；</li>
                        <li>点击步骤连接线，可设置该流转路径的流转条件。</li>
                    </ul>
                </dd>
                <dt>提示</dt>
                <dd>
                    <ul class="decoration">
                        <li><span class="red">被"开始"节点指定为处理者的人员，才能发起该流程。</span></li>
                        <li>提交流程时，会保存当时的流程设计版本，并应用于整个流程。<span class="red">对流程设计的修改，不影响运行中的流程。</span></li>
                        <li>对于"审批/确认"类型步骤，无论处理结果是肯定还是否定，都意味着完成了该步骤的处理。如果需要在否定操作时走不同路径，需在设计时明确指定，或使用“拒绝时否决流程”选项。</li>
                        <li>节点权限中设置的表单编辑权限，仅在流转到当前步骤时有效；对流程的删除、评论等权限则随时有效。</li>
                        <li>如果流程需要填写子模板表单，则当子模板设置为引用流程表单模板权限时，按流程设计中的权限规定控制，否则按子模板的权限设置控制。</li>
                        <li>各步骤"通知"设置中的"流程参与人"，未包含流程发起人。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="preview" Visible="false" runat="server">
            <dl>
                <dt>文件预览支持的格式和条件</dt>
                <dd>
                    <ul class="decoration">
                        <li>图片格式：.jpg、.jpeg、.gif、.png、.bmp</li>
                        <li>文本格式：.txt、.htm、.xml</li>
                        <li>音视频格式：.mp3、.mp4、.m4a、.m4v、.oga、.ogv、.ogg、.webm、.wav。部分格式需浏览器支持HTML5，并支持文件的编码类型</li>
                        <li>Office文档：.docx、.doc、.xlsx、.xls、.pptx、.ppt、.docm、.xlsb、.ppsx、.pps等。要求有互联网连接，且可以从互联网访问系统；Word 和 PowerPoint 文档须小于10MB；Excel 须小于5MB</li>
                        <li>PDF格式：主流浏览器支持</li>
                        <!--<li>CAD格式：.dwg、.dwf、.dxf。IE、360/QQ等浏览器安装控件后支持（免费控件，有水印）。</li>-->
                        <li>其它格式：暂不支持，只能下载后打开查看</li>
                    </ul>
                </dd>
                <dt>Office文档无法预览？</dt>
                <dd>
                    <p>在满足上述条件的情况下，如果Office文档还是无法预览：</p>
                    <ul class="decoration">
                        <li>若主机地址为IP地址形式，请使用域名形式的地址；</li>
                        <li>若地址中包含端口号，可能会预览失败，请考虑改为默认的80端口；</li>
                        <li>需确保系统设置中“系统互联网访问地址”设置正确；</li>
                        <li>若系统安装在内网，可能会因路由器安全规则阻止而失败；</li>
                        <li>如果使用“Google预览”失败，可能是受国内网络屏蔽的影响，建议使用Chrome或360极速浏览器并安装“谷歌访问助手”插件。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="manualUpdate" Visible="false" runat="server">
            <dl>
                <dd>
                    <p>从官方网站下载更新包，在服务器上将其解压覆盖到系统安装目录即可。覆盖之前，最好将原有的 web.config 文件复制出来，当更新后需要重新配置数据库连接或修改某些配置项时，可从中查看原来的设置。如果从临近的版本升级，通常可直接使用原有的 web.config 文件。</p>
                    <p>如果版本跨度太大，可能需要联系技术支持帮助完成升级。</p>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="plan" Visible="false" runat="server">
            <div class="path">操作路径： 进入<%= ims.Sys.TransCenterText %>，在"我发起的流程"标签下，点击"计划任务"按钮</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>计划任务，用于按指定的时间周期自动重新发起指定的流程。</p>
                </dd>
                <dt>如何添加计划任务？</dt>
                <dd>
                    <p>点击"计划任务"按钮，在"添加计划"处，选择或输入自己发起的某个流程，点"添加"按钮。添加到列表后，再点编辑图标，可修改计划的时间周期等设置。</p>
                </dd>
                <dt>说明</dt>
                <dd>
                    <ul class="decoration">
                        <li>系统自动重发的流程，会采用原有流程设计版本，及原有的数据表单（但自动编号/变量类型字段会更新）。</li>
                        <li>计划任务执行达到预定次数后，会自动删除。</li>
                        <li>若计划任务执行失败，可在系统日志中查看原因。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="manualBakRes" Visible="false" runat="server">
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>若系统中上传的文件或图片太多，使用系统的备份或还原功能可能会因执行超时而失败，这就需要进行手工操作。</p>
                </dd>
                <dt>手工备份</dt>
                <dd>
                    <p runat="server" id="accBak">进入服务器系统安装目录，将所有内容打包为一个压缩文件，复制到安全的地方保存即可。</p>
                    <p runat="server" id="sqlBak">先在“系统维护”中执行“下载调试数据”，生成的文件无需下载和保存，该操作目的是将数据库生成备份文件。然后进入服务器系统安装目录，将所有内容打包为一个压缩文件，复制到安全的地方保存即可。</p>
                </dd>
                <dt>手工还原</dt>
                <dd>
                    <p runat="server" id="accRes">进入服务器系统安装目录，删除所有现存文件，再将备份文件解压到这里即可。</p>
                    <p runat="server" id="sqlRes">进入服务器系统安装目录，用记事本打开 web.config 文件备用，然后删除所有现存文件，再将备份文件解压到这里，用记事本打开 web.config 文件，将"&lt;connectionStrings&gt;"与"&lt;/connectionStrings&gt;"这两行之间的内容，用之前打开的文件中同样位置处的内容来替换，保存。最后，登录系统，在“系统维护”的“系统备份和还原”标签页，点“还原数据库”，等待完成即可。</p>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="faq" Visible="false" runat="server">
            <dl>
                <dt>如何通过网络访问本系统？</dt>
                <dd>
                    <p style="margin:0">在同一网络中的客户端电脑上（无需安装该软件），可使用浏览器通过以下地址来访问：</p>
                    <ul style="margin:1px 0 3px 2em" runat="server" id="urls"></ul>
                    <p>可<a onclick="down('shortcut.url');" href="javascript:void(0);" target="_self">点此下载快捷方式</a>保存到桌面。若主机是自动获取IP地址，则上述地址会经常变化，导致客户端无法访问，因此请设置一个固定的IP地址。</p>
                    <div runat="server">
                        <p>要允许其它电脑通过网络访问，需给主机防火墙开放<%= Request.Url.Port %>端口。<span runat="server" id="cmdprompt">可在“开始-运行”框中执行以下命令开启：</span>
                        <span runat="server" class="red pointer" id="cmdtext" title="点击复制该命令"></span>
                        </p>
                        <p>若系统安装在内网，要从互联网访问，通常还需设置内网路由器端口映射，并使用花生壳等动态域名软件。</p>
                    </div>
                </dd>
                <dt runat="server" class="admin">如何将该软件安装在网站上，从而可以从互联网访问？</dt>
                <dd runat="server" class="admin">
                    <p>这需要购买一个云服务器来安装（详询技术支持），或购买一个支持Asp.net 4.0的网站空间（虚拟主机），将软件安装目录上传到其根目录下，并在后台管理中将该目录设为虚拟目录，网站的Asp.net版本设为V4.0。访问地址须加上目录路径，如：http://xxx.com/ims/ 。若将安装目录下的内容直接放置在网站根目录下，则无需设置虚拟目录，直接用绑定的域名即可访问。</p>
                </dd>
                <dt>一些基本技巧</dt>
                <dd>
                    <ol style="margin-left:2em;list-style-type:square">
                        <li>可以<a href="#" onclick="to('sidebar.aspx?layout=');">自定义左侧栏</a>，加入常用的操作链接或搜索版块；</li>
                        <li>可以在首页右上角点设置图标来自定义首页，添加图表、报表、看板或其它版块；</li>
                        <li>首页“个性化”中可设置进入系统后默认打开的页面。如，可设置为登录后直接显示库存预警的产品；</li>
                        <li>尝试点击鼠标右键进行操作——如目录、<%= ims.Sys.DataCenterText %>等处；</li>
                        <li>尝试用鼠标拖动元素调整位置——如设计中心调整模板顺序、表格视图调整列顺序等；</li>
                        <li>很多页面可以调整显示版式——如详情视图、概要视图、数据录入等；</li>
                        <li>很多地方可以输入完毕后直接回车提交——如编辑、搜索、筛选等处。例：表格视图就地编辑时，修改后直接回车即可保存；</li>
                        <li>选择用户或机构时，可直接输入、从提示列表选择，或双击文本框弹出窗口选择，可输入逗号、分号或顿号来输入多项；</li>
                        <li>当系统弹出气泡提示时，应仔细看看；操作中有疑问时，尝试点击就近的问号图标、帮助按钮或右键菜单，或左侧的"实时帮助"。</li>
                    </ol>
                </dd>
                <dt runat="server" class="admin">如何在网站中嵌入本系统？</dt>
                <dd runat="server" class="admin"><p>可在网页中以iframe的方式嵌入。示例代码如下：</p>
                    <p runat="server" class="red" id="iframecode"></p>
                    <p class="pCurrentUrl">下面是当前页面 <select id="urlMode" onchange="showPageUrl();"><option value="Full">完整窗口模式</option><option value="Only">仅内容页面</option></select> 的地址：</p>
                    <p class="pCurrentUrl"><a href="#" id="currentUrl" target="_blank"></a></p>
                    <p class="pCurrentUrl">若想使用完整窗口模式嵌入后隐藏左侧栏，可在的地址后追加参数：nobar=1。</p>
                </dd>
                <dt runat="server" class="admin">添加的新用户的密码是什么？</dt>
                <dd runat="server" class="admin"><p>由管理员添加的用户的密码默认是“<asp:Literal runat="server" ID="lInitPwd"></asp:Literal>”。可以在用户管理页面点击“设置默认用户信息”，来修改默认密码，以及其它内容的默认值，之后再添加的用户将自动使用这些默认的用户信息。在新用户使用默认密码登录后，可以自己修改包括密码在内的所有个人信息。</p></dd>
                <dt runat="server" class="design">为什么在缩略视图中看不到缩略图？</dt>
                <dd runat="server" class="design"><p>进入设计中心，在模板上点右键，设置，指定“缩略图字段”为需要显示的图片字段即可。</p></dd>
                <dt runat="server" class="design">为什么在模板中添加字段后，录入或浏览时看不到该字段？</dt>
                <dd runat="server" class="design"><p>如果录入或浏览时的版式是自定义版式，而不是系统自动生成的版式（即录入时的"经典版式"、浏览时的"表格版式"），那么新增的字段不会自动出现在版式中，需要进入版式编辑页面手动添加。</p></dd>
                <dt>系统操作或显示异常？</dt>
                <dd><p>
                    有两种可能：一是由于系统升级后浏览器未清空缓存，则清除浏览历史中“缓存的文件或图片”即可（不要勾选“保留收藏夹网站数据”，清除的时间段设为“全部”）；二是由于浏览器安全设置，解决方法：打开“工具”菜单，点“Internet 选项”，切换到“安全”标签，选择“受信任的站点”，点“站点”按钮，在弹出的对话框中，取消左下方的复选框，再点“添加”按钮，将当前系统的地址加入浏览器的信任站点列表，若仍不能解决，尝试把信任站点的安全级别设为最低。</p></dd>
                <dt runat="server" class="design">保密级别是什么意思，如何应用？</dt>
                <dd runat="server" class="design">
                    <p>数据的保密级别和用户的浏览权限是相对应的，分别有0～10共11个级别。用户只能查看保密级别不高于其浏览权限级别的内容（有编辑权限或完全控制权限除外）。比如，某用户对某模板的浏览权限为5级，那么他只能看到该模板的保密级别为0～5的记录，而高于5级的记录，以及不高于5级的记录中保密级别高于5级的字段，都无权浏览。</p>
                </dd>
                <dt runat="server" class="admin">如何启用电子商务功能？</dt>
                <dd runat="server" class="admin"><p>首先，需要在系统设置的“功能选项”中勾选“启用电子商务功能”，再在要作为商品进行销售的模板的设置中勾选“启用电子商务功能”，并设置作为商品价格的字段。这样，客户在浏览时，就可以将其加入购物车并在线下单了。</p></dd>
                <dt>导出或备份的文件，迅雷下载失败？</dt>
                <dd>
                    <p>这种情况下，可打开迅雷设置界面，在“高级设置”-“监视对象”下，取消“监视浏览器”选项，从而避免使用迅雷下载。</p>
                </dd>
                <dt>如何批量更新某字段的值？</dt>
                <dd><p>进入“<%= ims.Sys.DataCenterText %>”，在该模板上点右键，选“数据管理”，在“批量更新”处选择要更新的字段，并输入新的值，最后点“更新”按钮即可更新所有记录。如果只想更新一部分记录，可勾选“仅更新符合条件的记录”，并设置好条件之后再点“更新”。也可以进入表格视图，筛选或勾选出需要更新的记录后，点“批量操作”进行批量更新。</p></dd>
                <dt runat="server" class="design">如何在录入某个字段时自动列出以前输入过的内容供选择？</dt>
                <dd runat="server" class="design"><p>进入模板的设计界面，将该字段勾选“输入提示”选项，并设置数据来源为本模板的本字段。</p></dd>
                <dt runat="server" class="design">如何实现多级分类联动的输入提示？</dt>
                <dd runat="server" class="design">
                    <p>假设有大类、子类两级，则先建立分类模板并添加这两个字段，录入分类数据，如：A,a1；A,a2；A,a3；B,b1；B,b2；B,b3...。然后在要使用分类的模板中，大类字段勾选“输入提示”并设置数据来源为分类表，取前20项大类；子类字段也类似，但需要在“筛选”处<span class="red">设置条件为“大类等于当前大类”</span>（如下图）。这样，在录入子类时，会根据所选择的大类来提示其中的子类列表。</p>
                    <p><img src="images/help/acsetting.png" /></p>
                    <p class="landian">提示：可<a href="https://landian.cc/content.aspx?p=resource" target="_blank">下载“省市县三级联动示例”</a>，恢复到系统中查看效果及其设置。</p>
                </dd>
                <dt runat="server" class="design">如何实现输入编号，自动取得对应的名称等属性？</dt>
                <dd runat="server" class="design"><p>为每个需要自动取值的字段，在“输入提示”设置中指定筛选条件为“编号等于当前编号”，并“取值”为编号最小的“第一项”名称（或其它字段），勾选“自动填充”。录入时，在输入编号后，这些字段将会自动获取到其对应的值。</p></dd>
                <dt>如何能够快速打开类似“本周到期的合同”这类记录？</dt>
                <dd><p>进入“<%= ims.Sys.DataCenterText %>”，在模板上点右键，选“筛选”，在筛选条件中，将类似“到期日期”这种字段设置为“本周”，然后点击窗口下方的“保存为快捷方式”，输入名称后保存即可。这样，以后就可以直接从快捷方式中打开了。也可以将条件设置为过滤器，并添加到左侧栏。</p></dd>
                <dt runat="server" class="design">怎样设置让用户只能看到自己录入的数据？</dt>
                <dd runat="server" class="design"><p>进入设计中心，在模板上点右键，权限，为用户所属的角色设置浏览权限为适当的级别后，勾选“仅允许浏览符合条件的记录”，条件设置为“创建人”等于“$UserName$”。如果需要给予编辑权限，则再勾选“禁止编辑或删除他人添加的记录”。</p></dd>
                <dt runat="server" class="design">模板之间如何产生关联，有哪些关联性？</dt>
                <dd runat="server" class="design">
                    <ul class="decoration" style="margin-left:0">
                        <li><span class="term">主从关系</span>主从关系的建立，会使系统在自动生成版式等方面提供便利，使得它们的数据录入和显示可以在同一界面实现。<a href="?subject=masterSlave">更多…</a></li>
                        <li><span class="term">版式中的自定义查询</span>通过在详情视图版式中定义查询，可获取其它模板的相关数据，将查询代码插入到版式中可显示查询结果。<a href="?subject=freeLayout#query">更多…</a></li>
                        <li><span class="term">查询字段</span>查询字段可在运行时从任意模板取单个值或统计值。<a href="?subject=templet#queryfield">更多…</a></li>
                        <li><span class="term">字段的输入提示</span>输入提示可在输入时从任意模板取值，产生列表供选择。<a href="?subject=templet#ac">更多…</a></li>
                        <li><span class="term">字段链接</span>可为字段设置链接，使得在浏览时可点击打开符合预设条件的数据。<a href="?subject=templet#fieldlink">更多…</a></li>
                    </ul>
                </dd>
                <dt runat="server" class="design">如何建立主从关系的模板？</dt>
                <dd runat="server" class="design">
                    <p>例如，订单模板与相应的订单商品明细模板，就是一种主从关系，一个订单会对应有多条商品明细记录。建立主从关系的步骤如下：</p>
                    <p>进入设计中心，在主模板上点右键，选"设置"，在弹出的对话框中切换到"关系"标签页，在下面的"添加子模板"处选择作为子模板的模板，并设置关联字段。如，（订单商品明细的）订单编号关联到当前"订单编号"，其实质相当于是，某个订单的商品明细记录，就是订单商品明细中订单编号等于这个订单的编号的那些记录。</p>
                    <p>选项"同步更新关联字段"如果选中，则在上例中修改订单的编号时，"订单商品明细"中它所对应的那些记录的订单编号也会作相应的变更；"同步删除关联记录"选项用于在删除某条记录时，子模板中相关联的记录也同时自动删除，如删除一个订单，它对应的订单商品明细记录也会同时删除；"同步添加关联记录"选项用于在添加主模板记录时自动在一对一关系的子模板中添加一条关联的记录。</p>
                    <p>设置好关联和选项后，点下面的"添加"按钮即可建立起关系。这将为今后的录入、浏览和管理数据提供方便。</p>
                    <p>也可以在设计中心，空白处右键，添加主从模板，一次性建立起主模板和（一个或多个）子模板。</p>
                    <p>说明：像订单与订单商品明细表的关系是“一对多”的关系；像员工与员工配偶信息表的关系是“一对一”关系。通常，只有一对一关系，才应该选中“同步添加关联记录”。</p>
                </dd>
                <dt>如何复制记录？</dt>
                <dd>
                    <p>复制记录有以下方法：</p>
                    <ul class="decoration">
                        <li>缩略视图，右键复制并粘贴；</li>
                        <li>添加记录时，点右上角“导入”选择源记录导入并保存；编辑记录时，点“另存”按钮存为一条新的记录；</li>
                        <li>将源记录导出为Excel文件，再重新导入追加数据；</li>
                        <li>在模板设置对话框“生成”标签页设置生成方法，指定源数据为本模板。浏览时，在表格视图可勾选源记录，点“批量操作”，生成。该方法对有子模板的情况会自动复制子模板关联记录，并且可在单条记录上右键生成，实现编辑后再生成的效果。</li>
                    </ul>
                </dd>
                <dt>如何将数据复制到另一个模板？</dt>
                <dd>
                    <p>可考虑以下方法，从A模板复制数据到B模板：</p>
                    <ul class="decoration">
                        <li>将B模板设为A模板的子模板（勾选"同步添加关联记录"），执行同步操作。该方法只能复制关联字段；</li>
                        <li>在B模板上设置生成方法，指定数据源为A，添加好字段映射，然后打开A的表格视图，批量操作，生成为B，即可将全部或选中的记录复制到B；</li>
                        <li>在A模板上设置结转方法，勾选"将源数据结转到B"并添加字段映射，然后打开A的表格视图，执行结转。</li>
                    </ul>
                </dd>
                <dt>如何为自动编号类型字段重置起始编号？</dt>
                <dd><p>在记录删除后添加新的记录时，不会重复使用已删除记录的编号。只有当从“数据管理”对话框中清空所有记录时，自动编号的起始值才会重置，在有数据记录的情况下，想要从头开始编号，只能通过在模板设计界面中删除这个自动编号字段后重新建立一个相同规则的字段来实现，但这样会导致已存在的记录被重新编号，如果存在与其它模板中的记录的关联，将会使这种关联关系发生错乱。</p></dd>
                <dt>如何快捷地上传图片或文件？</dt>
                <dd>
                    <p>对于大多数现代浏览器，在文件上传区域，除了可以点击上传图标来选择一个或多个文件上传，还可以：</p>
                    <ul class="decoration">
                        <li>拖拽文件到该区域；</li>
                        <li>截图，然后点击该区域，按Ctrl+V键粘贴；</li>
                        <li>从网页或Word等软件中复制图片，然后点击该区域，按Ctrl+V键粘贴；</li>
                        <li>对于图片链接地址，若来自同域或允许跨域访问的网站，也可以复制并粘贴该地址来上传图片。</li>
                    </ul>
                </dd>
                <dt>如何批量导入图片或文件？</dt>
                <dd>
                    <p>如果某个模板包含有图片或文件类型的字段并且已经上传了至少一个文件，那么导出Excel时将会得到一个zip格式的压缩文件，其中包含了Excel和Files两个文件夹，分别用于放置Excel表和所涉及的文件。</p>
                    <p>要批量导入，也是按这同样的文件夹结构来放置Excel和对应的文件，文件的名称和Excel表中对应字段中填写的名称(多个文件名用逗号分隔)相对应。在Excel数据录入完成且将相应文件放置到Files文件夹中后，将这两个文件夹选中并打包为zip格式压缩包，再在数据中心-模板图标右键菜单-数据管理-导入Excel，选择这个压缩文件即可开始导入。</p>
                </dd>
                <dt>导出Excel时，能否不导出图片或文件字段所包含的文件？</dt>
                <dd><p>表格视图的“导出到Excel”功能，会只导出当前所显示的列的内容，因此，可以先隐藏图片和文件类型的字段，再执行导出操作。</p></dd>
                <dt>为什么系统的访问地址经常变化？</dt>
                <dd><p>这是由于安装本软件的电脑没有设置固定IP地址，而是“自动获取IP地址”。解决方法是：从控制面板中打开网络连接，在本地连接上点右键，属性，双击“TCP/IPv4”这一行，选中“使用下面的IP地址”，并依次填写IP地址、网关等设置。具体应设置的值，可在开始-运行中输入cmd打开命令提示符窗口，执行“ipconfig /all”来查看“本地连接”相关参数。</p></dd>
                <dt runat="server" class="design">如何解决“存在无效的公式或查询字段…无法确定Double值”或“遇到被零除错误”的问题？</dt>
                <dd runat="server" class="design">
                    <p>这通常是由于某个公式字段中作为分母的字段未填写数值（或查询字段未取到值）或数值为0造成的。分母为空或为0会导致公式计算时出错。解决方法有二：</p>
                    <p>一、将分母字段为空或为0的改为一个非0值。进入“<%= ims.Sys.DataCenterText %>”，在模板上点右键，选“数据管理”，在“批量更新”处选择作为分母的字段，填入一个非0值（比如1），再设置左下方的更新条件为该字段等于空（不填写条件值，留空）或等于0，最后点“更新”按钮即可。</p>
                    <p>二、将公式改为：<span class="red">iif(IsNull([xxx]) or [xxx] = 0, null, [yyy]/[xxx])</span>（该示例为Access语法），或：<span class="red">Case When [xxx] is null or [xxx] = 0 Then null Else [yyy]/[xxx] End</span>（SQL Server语法）。</p>
                    <p>以上公式的含义为：如果字段代码为[xxx]的字段（即作为分母的字段）为空或为0，则为空值（null），否则按正常的公式进行除法运算。</p>
                    <p>此外，也可考虑把作为分母的字段设为“必填字段”，以避免产生空值造成错误。</p>
                </dd>
                <dt runat="server" class="design">打开数据很慢，怎么办？</dt>
                <dd runat="server" class="design">
                    <ul class="decoration">
                        <li id="queryForAccess" runat="server">切换为使用SQL Server数据库；</li>
                        <li>尽可能减少模板中的公式和查询类型字段；</li>
                        <li>尝试减少每页显示数量；</li>
                        <li>表格视图中，可隐藏暂时不需要查看的字段，或分为几个版式，分别显示部分字段；</li>
                        <li>表格视图如果设置了“置顶”的条件格式，取消“置顶”选项试试；</li>
                        <li>不使用查询字段，而是在详情视图使用自由排版来定义查询并显示查询结果；</li>
                        <li>不使用查询类型，而用文本等类型，配合输入提示的“自动填充”功能，在录入时取值并保存下来（可用批量更新功能刷新值）；</li>
                        <li>不使用查询字段，而是在关联字段上设置链接，浏览时点击链接来查看原本想用查询字段来显示的数据；</li>
                        <li>考虑将模板拆分，以减少单个模板中的查询字段数量。这种情况下，可将拆分出来的模板建立一对一关系（勾选“同步添加关联记录”），通过某个唯一性字段进行关联，还可以在子模板中设置生成方法，建立起与主模板间的字段映射，从而自动生成子模板记录中这些字段的值；</li>
                        <li>浏览器推荐使用Firefox、Chrome或360极速模式，并确保网速畅通（可对比直接在服务器上操作的速度，以直观判断网速影响）。</li>
                    </ul>
                </dd>
                <dt runat="server" class="design">查询字段和输入提示的“自动填充”功能有何区别？</dt>
                <dd runat="server" class="design">
                    <p>查询字段是在浏览时执行查询计算来取值，因此其值会随源数据的变化而变化；输入提示功能是用于在录入时辅助输入，自动填充的结果保存后不受源数据变化的影响（可用批量更新功能刷新值）。</p>
                </dd>
                <dt runat="server" class="design">巧用输入提示功能</dt>
                <dd runat="server" class="design">
                    <p>"允许多项输入"选项：可用指定分隔符来分隔多项值，并持续产生提示列表。如果在查询字段（或自由排版中定义的查询）的查询条件中对该字段使用"包含/不包含/包含于/不包含于"模式，则将按完整的某一项值来匹配，如"abc，def"，不会认为包含"ab"。这个特点，某些情况下可用来保存一对多的对应关系，从而不必使用子模板。</p>
                    <p>"只接受数据源范围内的值"选项：有时，希望用户只能从输入提示列表中选择值，而不允许输入其它无效的值，就可以使用这个选项，达到类似单选列表的效果，确保输入值的有效性。勾选了该项，则必须输入条件字段才会产生提示列表。</p>
                </dd>
                <dt>如何在首页显示图表/报表/目录等内容？</dt>
                <dd>
                    <p>在首页点击右上角的 <i class="f-setting"></i>图标，可添加图表/报表、自定义版块、网页版块等。利用添加网页版块的功能，可以将系统中的某个页面添加到首页：</p>
                    <p>在“添加网页版块”对话框中，点右下方的“获取内部页面地址”，选择一个页面后，点“添加”按钮，即可将得到的地址填充到“网址”输入框中，勾选“尝试自适应高度”和“隐藏滚动条”选项后，点确定按钮即可。</p>
                </dd>
                <dt>如何实现批量打印？</dt>
                <dd><p>可使用概要视图来实现批量打印。切换到概要视图后，点击任一项右边的悬浮图标，自定义显示格式，选择详情视图某个版式。这样，在打印时，会自动在每一项后面分页。</p></dd>
                <dt runat="server" class="admin">如何禁止用户修改密码？如何允许帐户重复登录？</dt>
                <dd runat="server" class="admin">
                    <p>如果系统设置中未勾选“允许重复登录”，那么就不允许一个用户帐户在不同地方重复登录（先登录的会被强制注销），但可以建立一个名为“公共帐户”的角色，归属到该角色的用户，可以重复登录且不允许修改密码。</p>
                </dd>
                <dt>如何将一列中包含的值，分别生成为另一模板中的记录？</dt>
                <dd><p>可以在源数据模板上设置结转功能，将该字段设为统计分组字段，映射到目标模板中对应的字段，即可对源数据执行结转操作，快速将源字段中的值去除重复后，分别生成为目标模板记录。</p></dd>
                <dt>如何实现扫码通知？</dt>
                <dd>
                    <p><span class="term">实现目标</span>当他人用手机扫描二维码时，指定人员可以收到通知。例如，某民宿房东为避免深夜客人敲门影响他人，张贴了一个二维码，客人扫码后，房东即收到微信消息，给客人开门。</p>
                    <p><span class="term">实现步骤</span></p>
                    <ol style="margin-left:43px">
                        <li>创建模板，加入时间(变量"当时时间")等字段；</li>
                        <li>为模板设置权限，允许匿名用户添加记录。如果指定允许填写的字段，则用户扫码打开后可以填写，否则扫码将直接提交；</li>
                        <li>为模板设置提醒，指定提醒方式(消息/邮件/短信/微信)、提醒对象、提醒时机(添加数据时)等；</li>
                        <li>在首页-个性化，生成二维码，获取该模板添加记录的地址，生成为二维码；</li>
                        <li>打印并在适当场所(或网络上)张贴二维码。</li>
                    </ol>
                </dd>
                <dt>如何取得某字段不重复值的数量？</dt>
                <dd>
                    <p>思路一：</p>
                    <ol style="margin-left:43px">
                        <li>用查询字段X，取该字段值等于本字段值的记录数量；</li>
                        <li>用公式字段Y = 1/X；</li>
                        <li>用查询字段Z，对Y进行合计，即得到结果。</li>
                    </ol>
                    <p>思路二：</p>
                    <ol style="margin-left:43px">
                        <li>用查询字段X，取该字段值等于本字段值，且ID小于等于当前ID的记录数量；</li>
                        <li>用查询字段Y，取X=1的记录数量，即为结果。</li>
                    </ol>
                </dd>
                <dt>如何实现出库数量不能超过库存量这样的验证？</dt>
                <dd>
                    <p>模板设置中可以设置"数据有效性验证"，即只有满足指定条件才允许保存。因此从逻辑上说，只要设置"出库数量"小于等于"当前库存量"即可。</p>
                    <p>但是，由于通常是将库存量设计为查询字段，动态取值的，其值受到出库数量的影响，所以在保存一条商品的出库记录，系统执行验证时，得到的库存量已经是减去了本次的出库量了，从而达不到预期的效果。</p>
                    <p>这种情况下，就需要添加一个公式字段对其修正，将查询的库存量加上本次出库量，才是本次出库之前的库存量，再将数据有效性验证条件改为"出库数量"小于等于这个公式字段，就可以了。</p>
                </dd>
                <dt>关于公式和查询字段</dt>
                <dd>
                    <p>要对同一记录的多个字段进行计算，应使用公式字段；要对多条记录的同一个字段进行计算，应使用查询字段。公式和查询字段并不保存数据，而是在需要时实时计算取值，所以这两种字段不会出现在数据输入界面。</p>
                </dd>
                <dt>用公式字段从身份证号提取生日</dt>
                <dd>
                    <p runat="server" id="gsSql">公式写法：substring(身份证号,7,4)+'-'+substring(身份证号,11,2)+'-'+substring(身份证号,13,2)。记得把"身份证号"改为身份证号字段的代码，公式结果类型设为"日期时间"。</p>
                    <p runat="server" id="gsAcc">公式写法：mid(身份证号,7,4)+'-'+mid(身份证号,11,2)+'-'+mid(身份证号,13,2)。记得把"身份证号"改为身份证号字段的代码，公式结果类型设为"日期时间"。</p>
                </dd>
                <dt>如何用公式字段实现自定义按钮？</dt>
                <dd>
                    <p runat="server" id="btnAcc">公式示例：<span class="red">'&lt;input type="button" class="btn small" value="查看" onclick="return toPopup(''table.aspx?tid=6&fid=8&value=' & [23] & ''');" /&gt;'</span></p>
                    <p runat="server" id="cmtAcc">公式目的是拼接出按钮的HTML代码。toPopup是一个预定义javascript函数，用于以弹窗打开指定地址的页面；<span class="green">table.aspx?tid=6&fid=8&value=x</span> 这样的地址可打开指定模板中指定字段为指定值的记录，这里希望用字段[23]的值替代x，所以用&符号拼接起来；地址前后的单引号与公式外围的单引号冲突，所以要用两个单引号表示。注意：公式结果类型要设为"文本"。</p>
                    <p runat="server" id="btnSql">公式示例：<span class="red">'&lt;input type="button" class="btn small" value="查看" onclick="return toPopup(''table.aspx?tid=6&fid=8&value=' + cast([23] as varchar(20)) + ''');" /&gt;'</span></p>
                    <p runat="server" id="cmtSql">公式目的是拼接出按钮的HTML代码。toPopup是一个预定义javascript函数，用于以弹窗打开指定地址的页面；<span class="green">table.aspx?tid=6&fid=8&value=x</span> 这样的地址可打开指定模板中指定字段为指定值的记录，这里希望用数字字段[23]的值替代x，所以用sql函数cast将其转换为字符串，并用"+"拼接起来；地址前后的单引号与公式外围的单引号冲突，所以要用两个单引号表示。注意：公式结果类型要设为"文本"。</p>
                </dd>
                <dt>用链接参数执行搜索</dt>
                <dd>
                    <p>可为 view.aspx 页面指定参数来执行搜索。该方法可用于左侧栏自定义链接、首页网页版块、公式字段动态生成链接等。各参数如下：</p>
                    <ul class="decoration">
                        <li><span class="term">tid</span>搜索目标模板ID</li>
                        <li><span class="term">filter</span>过滤器名称</li>
                        <li><span class="term">fid</span>要搜索的字段ID</li>
                        <li><span class="term">value</span>搜索关键字。请参考：<a href="?subject=datahome">搜索关键字应用技巧</a></li>
                        <li><span class="term">symbol</span>条件匹配模式，配合fid和value使用。如：等于、包含等</li>
                        <li><span class="term">f+字段ID</span>筛选该字段为指定值的记录，如f28=china。该参数可使用最多5个，并可配合filter参数使用</li>
                        <li><span class="term">view</span>展现搜索结果的视图。表格视图、详情视图、缩略视图、概要视图、图表视图、报表视图分别为：Table、Detail、Thumbnail、Overview、Chart、Report</li>
                    </ul>
                    <p>参数值若包含中文或特殊字符，需进行URL编码。可<a href="http://www.bejson.com/enc/urlencode" target="_blank">在线URL编码</a>，或用jQuery方法 <span class="red">$.url.encode(text)</span> 来编码。下面是一些链接示例：</p>
                    <ul class="decoration">
                        <li><span class="red">view.aspx?tid=6&fid=8&value=abc</span> 搜索指定表中指定字段等于值的记录</li>
                        <li><span class="red">view.aspx?tid=6&fid=8&value=60&symbol=%e5%a4%a7%e4%ba%8e</span> 搜索指定表中指定字段大于指定值的记录，symbol的值是经过URL编码的字符</li>
                        <li><span class="red">view.aspx?tid=6&filter=ok&view=chart</span> 搜索指定表中满足指定过滤器的记录，并用图表视图显示</li>
                        <li><span class="red">view.aspx?tid=6&f28=china&f29=beijing</span> 搜索指定表中ID为28的字段等于china、ID为29的字段等于beijing的记录</li>
                    </ul>
                    <p>也可对六个视图的页面（table.aspx，detail.aspx，thumb.aspx，summary.aspx，chart.aspx，report.aspx）使用以上参数执行搜索。如：</p>
                    <ul class="decoration">
                        <li><span class="red">table.aspx?tid=6&f28=china</span> 搜索指定表中指定字段等于指定值的记录，用表格视图显示。</li>
                    </ul>
                </dd>
                <dt>用链接参数指定表单字段初始值</dt>
                <dd>
                    <p>可为录入页面 edit.aspx 添加参数来赋予字段初始值。如：edit.aspx?tid=2&f36=tony，表示将ID为36的字段初始值设为 tony。</p>
                </dd>
                <dt>用链接生成条形码/二维码</dt>
                <dd>
                    <p>生成条形码/二维码的链接地址示例：<span class="red">barcode.ashx?type=code128&size=smaller&text=xyz</span>，其中，type参数指定格式：</p>
                    <ul class="decoration">
                        <li><span class="term">qrcode</span>二维码（以下均为条形码格式）</li>
                        <li><span class="term">code128</span>CODE 128</li>
                        <li><span class="term">code39</span>CODE 39</li>
                        <li><span class="term">code39ext</span>CODE 39 Extended</li>
                        <li><span class="term">ean13</span>EAN-13</li>
                        <li><span class="term">ean8</span>EAN-8</li>
                        <li><span class="term">upca</span>UPC-A</li>
                        <li><span class="term">upce</span>UPC-E</li>
                        <li><span class="term">codabar</span>Codabar</li>
                        <li><span class="term">jan13</span>JAN-13</li>
                        <li><span class="term">bookland</span>BOOKLAND</li>
                        <li><span class="term">isbn</span>ISBN</li>
                        <li><span class="term">postnet</span>PostNet</li>
                        <li><span class="term">sta2of5</span>Standard 2 of 5</li>
                        <li><span class="term">ind2of5</span>Industrial 2 of 5</li>
                        <li><span class="term">int2of5</span>Interleaved 2 of 5</li>
                        <li><span class="term">usd8</span>USD 8</li>
                        <li><span class="term">ucc12</span>UCC 12</li>
                        <li><span class="term">ucc13</span>UCC 13</li>
                        <li><span class="term">code11</span>CODE 11</li>
                        <li><span class="term">code128a</span>CODE 128-A</li>
                        <li><span class="term">code128b</span>CODE 128-B</li>
                        <li><span class="term">code128c</span>CODE 128-C</li>
                        <li><span class="term">logmars</span>LOGMARS</li>
                        <li><span class="term">upc2ext</span>UPC 2 Digit Ext</li>
                        <li><span class="term">upc5ext</span>UPC 5 Digit Ext</li>
                        <li><span class="term">telepen</span>TELEPEN</li>
                        <li><span class="term">mod_plessey</span>Modified_Plessey</li>
                        <li><span class="term">msi_mod10</span>MSI Mod10</li>
                        <li><span class="term">msi_mod11</span>MSI Mod11</li>
                        <li><span class="term">msi_2mod10</span>MSI-2 Mod10</li>
                    </ul>
                    <p>size参数指定图形大小：</p>
                    <ul class="decoration">
                        <li><span class="term">small</span>小</li>
                        <li><span class="term">smaller</span>较小</li>
                        <li><span class="term">medium</span>适中</li>
                        <li><span class="term">larger</span>较大</li>
                        <li><span class="term">large</span>大</li>
                    </ul>
                    <p>text参数指定要生成条形码/二维码的文本内容，如果包含除字母和数字外的其它字符，需要作<a href="http://www.jsons.cn/urlencode/" target="_blank">URL编码</a>。</p>
                    <p>说明：不同的条形码格式有不同的规则要求，不符合规则的内容无法生成；对于二维码，可添加参数ratio对图形大小作进一步缩放，如：&ratio=2。</p>
                </dd>
                <dt>如何控制图片显示大小？</dt>
                <dd>
                    <p>在详情视图或概要视图的自定义版式中，将图片字段代码（选"原始图片"格式）插入到一个单元格或其它元素中，再设置所在元素的宽度，即可控制图片宽度。</p>
                </dd>
                <dt>如何让单元格中省略显示的内容直接显示出来？</dt>
                <dd>
                    <p>表格视图，可点“更多”按钮，勾选“显示溢出内容”；详情视图，可在版式中切换到源码状态，为其上级元素添加样式类noell，如：<span class="red">&lt;div class="noell"&gt;$D0.Table&lt;/div&gt;</span>。</p>
                </dd>
                <dt>安全提示</dt>
                <dd>
                    <p>在确保服务器安全性的前提下，为了尽可能保障系统数据的安全性，请注意以下要点：</p>
                    <ul class="decoration">
                        <li>定期备份系统，或设置<a href="?subject=autoBackup">自动备份</a>；</li>
                        <li>建议<a href="https://support.microsoft.com/zh-cn/help/324069/how-to-set-up-an-https-service-in-iis" target="_blank">在服务器上部署 SSL</a>。</li>
                    </ul>
                </dd>
                <dt>你知道吗？</dt>
                <dd>
                    <ul class="decoration">
                        <li>可在高级搜索处保存版式，并自定义左侧栏将其添加为搜索版块，方便搜索；</li>
                        <li>可为模板设置自定义操作，来实现简单的审核功能，或灵活的批量更新（因其支持公式语法）；</li>
                        <li>上传文件/图片，可尝试从电脑拖动一个或多个文件来上传，或点击上传区域后按Ctrl+V粘贴屏幕截图；</li>
                        <li>有输入提示功能的文本框中，可输入第一个字的拼音首字母来快捷筛选。如，找姓张的人员，可按z；</li>
                        <li>在多行录入页面，想实时显示表格中数据合计，可设置扫码输入功能来实现（即使不需要扫码）；</li>
                        <li>可以在首页添加看板版块，来显示重要的统计数据。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>

        <asp:Panel ID="access" Visible="false" runat="server">
            <dl>
            <dt>日期函数</dt>
            <dd><ul>
                <li><span class="term">Now()</span>返回当前时间(完整时间，包括年月日时分秒)</li>
                <li><span class="term">Date()</span>返回当前日期</li>
                <li><span class="term">Time()</span>返回当前时间(除去年/月/日的部份)</li>
                <li><span class="term">Year(date)</span>返回日期的年份</li>
                <li><span class="term">Month(date)</span>返回日期的月份</li>
                <li><span class="term">Day(date)</span>返回日期的d部份,等同于DatePart使用d参数</li>
                <li><span class="term">CDate(exp)</span>将字符串转化成为日期。如：CDate("2018/4/5")</li>
                <li><span class="term">DateAdd(datepart, number, date)</span>将指定日期加上一段时间。如：DateAdd("d",1,Date())，将当前日期加上1天，其中d可以换为yyyy、m等</li>
                <li><span class="term">DateDiff(datepart, date1, date2)</span>判断两个日期之间的间隔。如：DateDiff("d","2018-5-1",生日)，其中d可以换为yyyy、m等</li>
                <li><span class="term">DatePart(datepart, date)</span>返回日期的某个部份。如：DatePart("d","2018-5-1")返回1，即1号，d也可换为yyyy、m等</li>
                <li><span class="term">IsDate(exp)</span>判断是否是日期值,是日期返回-1，否则返回0</li>
                <li><span class="term">Weekday(date)</span>返回代表一星期中某天的整数(星期天为1,星期一为2...)。如：Weekday(Now())</li>
            </ul></dd>
            <dt>文本函数</dt>
            <dd><ul>
                <li><span class="term">Format(exp, format)</span>格式化字符串。如：Format(now(),'yyyy-mm-dd')返回类似于"2018-04-03"，Format(3/9,"0.00")返回0.33</li>
                <li><span class="term">UCase(exp)</span>将字符串转换为大写形式</li>
                <li><span class="term">LCase(exp)</span>将字符串转换为小写形式</li>
                <li><span class="term">Left(exp, length)</span>取字符串左边指定数字的字符</li>
                <li><span class="term">Mid(string, start, length)</span>取得子字符串。如：Mid("abc",1,2)返回“ab”</li>
                <li><span class="term">Right(exp, length)</span>取字符串右边指定数字的字符</li>
                <li><span class="term">Trim(exp)</span>去掉字符串两端的空格</li>
                <li><span class="term">LTrim(exp)</span>去掉左边的空格</li>
                <li><span class="term">RTrim(exp)</span>去掉右边的空格</li>
                <li><span class="term">InStr(string1, string2)</span>查询子串在字符串中的位置。如：Instr("abc","a")返回1，Instr("abc","f")返回0</li>
                <li><span class="term">StrComp(string1, string2)</span>比较两个字符串是否内容一致(不区分大小写)。如：StrComp("abc","ABC")返回0，StrComp("abc","123")返回-1</li>
                <li><span class="term">Space(exp)</span>产生空格。如：Space(4)返回4个空格</li>
            </ul></dd>
            <dt>算术函数</dt>
            <dd><ul>
                <li><span class="term">Abs(exp)</span>返回绝对值</li>
                <li><span class="term">Int(exp)</span>将数字向下取整到最接近的整数</li>
                <li><span class="term">Rnd()</span>返回一个0到1之间的随机数值</li>
                <li><span class="term">Sgn(exp)</span>返回数字的正负符号(正数返回1,负数返回-1,0值返回0)</li>
                <li><span class="term">Sqr(exp)</span>返回平方根值</li>
            </ul></dd>
            <dt>聚集函数</dt>
            <dd><ul>
                <li><span class="term">Sum</span>计算字段的合计值</li>
                <li><span class="term">Avg</span>取字段平均值</li>
                <li><span class="term">Count</span>统计记录条数</li>
                <li><span class="term">Max</span>取字段最大值</li>
                <li><span class="term">Min</span>取字段最小值</li>
            </ul></dd>
            <dt>其它函数</dt>
            <dd><ul>
                <li><span class="term">IIF(exp1, exp2, exp3)</span>根据表达式返回特定的值。如：IIF(2>1, "正确", "错误")，返回"正确"</li>
                <li><span class="term">Choose(exp1, exp2, ...)</span>根据第一参数，返回后面字符串组的值。Choose(1,"a","b","c")返回a，将1改成2后返回b（第一个参数也可以是一个字段）</li>
                <li><span class="term">IsNull(exp)</span>检测是否为null值，是null值返回-1，非null值返回0</li>
                <li><span class="term">IsNumeric(exp)</span>检测是否为数字,是数字返回-1，否则返回0</li>
            </ul></dd>
            <dt>说明</dt>
            <dd><ul style="margin-left:0" class="decoration">
                <li>公式中判断空值的表达式：<span class="red">x is null</span>。对于文本、特殊文本、单选/多选列表、链接等类型字段，由于其本质都是文本，所以还需判断空字符串，即：<span class="red">x is null or x = ''</span>，判断非空，则可以用：<span class="red">x > ''</span></li>
                <li>公式中引用数字字段运算时，如果该字段为空(null)值，则任何数字与其运算，结果都为null。为此，程序会将null值当作0处理，以符合常人思维。但如果公式中使用了IsNull函数，或"is null"条件，则认为用户已自行考虑null值，不再特殊处理。</li>
                <li>公式中表示是/否值：<span class="red">true</span>表示"是"，<span class="red">false</span>表示"否"。如：<span class="red">iif(x > 0, true, false)</span></li>
                <li>用公式生成按钮示例：<span class="red">'&lt;input type="button" class="btn" value="查看" onclick="return toPopup(''table.aspx?tid=6&fid=8&value=' & [23] & ''');" /&gt;'</span></li>
            </ul></dd>
            </dl>
            <div style="text-align:right;margin:2em 0.5em 6px 0"><a href="http://www.w3school.com.cn/sql/sql_functions.asp" target="_blank">更多函数介绍</a></div>
        </asp:Panel>
                                        
        <asp:Panel ID="sqlserver" Visible="false" runat="server">
            <dl>
            <dt>日期函数</dt>
            <dd><ul>
                <li><span class="term">Getdate()</span>返回当前日期</li>
                <li><span class="term">Year(date)</span>返回日期的年份</li>
                <li><span class="term">Month(date)</span>返回日期的月份</li>
                <li><span class="term">Day(date)</span>返回日期的d部份,等同于DatePart使用d参数</li>
                <li><span class="term">DateAdd(datepart, number, date)</span>将指定日期加上某个日期。如：DateAdd(dd, 1, Getdate())，将当前日期加上1天,其中dd可以换为yy、mm等</li>
                <li><span class="term">DateDiff(datepart, date1, date2)</span>判断两个日期之间的间隔。如：DateDiff(dd, '2018-5-1', Getdate())返回2018-5-1到今天差多少天,其中dd可以换为yy、mm等</li>
                <li><span class="term">DatePart(datepart, date)</span>返回日期的某个部份。如：DatePart(dd, '2018-5-1')返回1,即1号，dd也可以换为yy、mm等</li>
                <li><span class="term">IsDate(exp)</span>判断是否是日期值，是日期返回1，否则返回0</li>
                <li><span class="term"><a href="http://www.w3school.com.cn/sql/func_convert.asp" target="_blank">Convert()</a></span>可用不同格式显示日期/时间。如获取"201812"形式的年月：Convert(char(6), Getdate(), 112)</li>
                <li style="text-align:right"><a href="http://www.w3school.com.cn/sql/sql_dates.asp" target="_blank">更多日期函数介绍</a>&nbsp;</li>
            </ul></dd>
            <dt>文本函数</dt>
            <dd><ul>
                <li><span class="term">Upper(exp)</span>将字符串转换为大写形式</li>
                <li><span class="term">Lower(exp)</span>将字符串转换为小写形式</li>
                <li><span class="term">Left(exp, length)</span>取字符串左边指定数字的字符</li>
                <li><span class="term">Right(exp, length)</span>取字符串右边指定数字的字符</li>
                <li><span class="term">LTrim(exp)</span>去掉左边的空格</li>
                <li><span class="term">RTrim(exp)</span>去掉右边的空格</li>
                <li><span class="term">Space(exp)</span>产生空格。如：Space(4)返回4个空格</li>
                <li><span class="term">Substring(exp, start, length)</span>返回从字符串左边第start个字符起length个字符的部分</li>
                <li><span class="term">Replace(exp1, exp2, exp3)</span>用exp3替换在exp1中的子串exp2</li>
                <li><span class="term">Patindex(exp1, exp2)</span>返回字符串exp1在exp2中出现的开始位置</li>
            </ul></dd>
            <dt>算术函数</dt>
            <dd><ul>
                <li><span class="term">Abs(exp)</span>返回绝对值</li>
                <li><span class="term">Round(exp, length)</span>返回数字表达式并四舍五入为指定的精度</li>
                <li><span class="term">Sign(exp)</span>返回给定表达式的正 (+1)、零 (0) 或负 (-1) 号</li>
                <li><span class="term">Ceiling(exp)</span>回大于或等于所给数字表达式的最小整数</li>
                <li><span class="term">Floor(exp)</span>返回小于或等于所给数字表达式的最大整数</li>
            </ul></dd>
            <dt>聚集函数</dt>
            <dd><ul>
                <li><span class="term">Sum</span>计算字段的合计值</li>
                <li><span class="term">Avg</span>取字段平均值</li>
                <li><span class="term">Count</span>统计记录条数</li>
                <li><span class="term">Max</span>取字段最大值</li>
                <li><span class="term">Min</span>取字段最小值</li>
            </ul></dd>
            <dt>其它函数</dt>
            <dd><ul>
                <li><span class="term">IsNull(exp, replacement)</span>如果给定表达式计算为null，则返回指定的替换值，否则返回表达式结果</li>
                <li><span class="term">IsNumeric(exp)</span>检测是否为数字,是数字返回1，否则返回0</li>
                <li><span class="term">Case When ... Then ... Else ... End</span>根据不同情况来取不同的值。</li>
                <li>例一：case when score >= 90 then '优秀' when score >= 60 then '合格' else '差' end</li>
                <li>例二：case level when 1 then '菜鸟' when 2 then '大虾' when 3 then '砖家' end</li>
                <li>例三：case when province in ('北京','天津','上海','重庆') then '直辖市' else '非直辖市' end</li>
            </ul></dd>
            <dt>说明</dt>
            <dd><ul style="margin-left:0" class="decoration">
                <li>公式中判断空值的表达式：<span class="red">x is null</span>。对于文本、特殊文本、单选/多选列表、链接等类型字段，由于其本质都是文本，所以还需判断空字符串，即：<span class="red">x is null or x = ''</span>，判断非空，则可以用：<span class="red">x > ''</span></li>
                <li>公式中引用数字字段运算时，如果该字段为空(null)值，则任何数字与其运算，结果都为null。为此，程序会将null值当作0处理，以符合常人思维。但如果公式中使用了IsNull函数，或"is null"条件，则认为用户已自行考虑null值，不再特殊处理。</li>
                <li>公式中表示是/否值：<span class="red">1</span> 表示"是"，<span class="red">0</span> 表示"否"。如：<span class="red">case when x is null then 0 else 1 end</span></li>
                <li>用公式生成按钮示例：<span class="red">'&lt;input type="button" class="btn" value="查看" onclick="return toPopup(''table.aspx?tid=6&fid=8&value=' + cast([23] as varchar(20)) + ''');" /&gt;'</span></li>
            </ul></dd>
            </dl>
            <div style="text-align:right;margin:2em 0.5em 6px 0"><a href="http://www.w3school.com.cn/sql/sql_functions.asp" target="_blank">更多函数介绍</a></div>
        </asp:Panel>
        <asp:Panel runat="server"  ID="batchUser" Visible="false">
            <div class="path">操作路径： 系统管理 - 用户管理，点击左侧“用户导入导出”</div>
            <dl>
                <dt>操作要点</dt>
                <dd>
                    <ul class="decoration">
                        <li>要导入用户，请下载Excel表单来录入用户信息，保存后，点“导入用户”按钮，选定该文件即可导入；</li>
                        <li>用于导入的Excel表中，最少可只保留“用户名”列，其它列均可删除。没有提供的列，导入时系统将采用默认值（默认值可在“设置默认用户信息”处修改）；</li>
                        <li>可指定用户的机构和角色，如果指定了一个系统中不存在的角色，导入时系统将自动创建该角色。</li>
                        <li>从性能考虑，建议将Excel表另存为.xls或.xlsx格式后再用于导入。</li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="iconfont" Visible="false" runat="server">
            <dl>
                <dt>概述</dt>
                <dd><p>不同于传统的.gif或.jpg等格式的图标，字体图标是一种矢量格式，可以无损缩放，并可通过CSS设置其大小和颜色等。
                    本系统的字体图标，取材于<a href="https://www.iconfont.cn/" target="_blank">阿里巴巴矢量图标库</a>，<a href="font_demo.html" target="_blank">点击此处查看图标及其代码</a>。</p>
                </dd>
                <dt>用法</dt>
                <dd>
                    <p>通过对一个HTML元素设定图标对应的 class，即可显示图标，如 <span class="red">&lt;i class="f-good"&gt;&lt;/i&gt;</span>：</p>
                    <p><i class="f-good" style="font-size:15px"></i></p>
                    <p>也可使用图标的 unicode 代码，如 <span class="red">&lt;span class="ims"&gt;&amp;#xe653;&lt;/span&gt;</span>：</p>
                    <p><span class="ims">&#xe653;</span></p>
                    <p>可以设置CSS样式，如 <span class="red">&lt;i class="f-drive" style="font-size:36px; color:orange"&gt;&lt;/i&gt;</span>：</p>
                    <p><i class="f-drive" style="font-size:36px;color:orange"></i></p>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel runat="server"  ID="api" Visible="false">
            <div class="path">操作路径： 系统管理 - 系统设置 - 功能选项，勾选“启用API接口”，点“API设置”</div>
            <dl>
                <dt>概述</dt>
                <dd>
                    <p>本系统提供 Web API，用于各种客户端通过HTTP请求来获取、修改、添加或删除数据信息。客户端通过URL定位资源，用HTTP方法（get-获取，post-新建，put-更新，delete-删除）描述操作。系统返回JSON格式数据。</p>
                    <p>客户端开发，推荐使用该 <a href="js/apiHelper.js" target="_blank" title="请点右键，目标另存为，下载保存">Javascript 工具库</a>，并参考 <a href="api_demo.htm" onclick="return toOpen(this.href, 800, 660);">API 演示</a> 及其源码。API演示和下文示例均基于该库，使用 jQuery 语法。</p>
                </dd>
                <dt>目录</dt>
                <dd class="related">
                    <p class="noindent">
                        <span class="term">主题</span>
                        <a href="#api_set">设置</a>
                        <a href="#api_promise">约定</a>
                        <a href="#api_base">API接口调用概览</a>
                        <a href="#api_errcode">错误代码</a>
                        <a href="#api_jscode">Javascript 参考代码</a>
                        <a href="#api_ment">其它说明</a>
                    </p>
                    <p class="noindent">
                        <span class="term">身份验证</span>
                        <a href="#api_login">登录</a>
                        <a href="#api_autologin">自动登录</a>
                        <a href="#api_me">取当前用户</a>
                        <a href="#api_updateme">修改个人信息</a>
                        <a href="#api_changepwd">修改密码</a>
                        <a href="#api_retoken">刷新令牌</a>
                        <a href="#api_logout">退出</a>
                    </p>
                    <p class="noindent">
                        <span class="term">数据操作</span>
                        <a href="#api_getone">获取一条记录</a>
                        <a href="#api_delone">删除一条记录</a>
                        <a href="#api_records">获取一批记录</a>
                        <a href="#api_delids">删除一批记录</a>
                        <a href="#api_add">添加记录</a>
                        <a href="#api_update">更新记录</a>
                        <a href="#api_batchupdate">更新一批记录</a>
                        <a href="#api_query">获取记录的关联查询结果</a>
                        <a href="#api_comments">获取评论</a>                    
                        <a href="#api_delcomment">删除评论</a>
                        <a href="#api_addcomment">发表评论</a>
                    </p>
                    <p class="noindent">
                        <span class="term">消息操作</span>
                        <a href="#api_msg">获取一条消息</a>
                        <a href="#api_delmsg">删除一条消息</a>
                        <a href="#api_msgs">获取一批消息</a>
                        <a href="#api_delmsgs">删除一批消息</a>
                        <a href="#api_sendmsg">发送消息</a>
                    </p>
                    <p class="noindent">
                        <span class="term">信息操作</span>
                        <a href="#api_info">获取一条信息</a>
                        <a href="#api_delinfo">删除一条信息</a>
                        <a href="#api_infos">获取一批信息</a>
                        <a href="#api_sendinfo">发布信息</a>
                        <a href="#api_editinfo">修改信息</a>
                        <a href="#api_infocomments">获取评论</a>
                        <a href="#api_delinfocomment">删除评论</a>
                        <a href="#api_addinfocomment">发表评论</a>
                    </p>
                    <p class="noindent">
                        <span class="term">事务处理</span>
                        <a href="#api_tasks">获取待办/已办事项</a>
                        <a href="#api_task">获取指定事项</a>
                        <a href="#api_dotask">处理待办事项</a>
                        <a href="#api_backtask">退回待办事项</a>
                    </p>
                    <p class="noindent">
                        <span class="term">用户操作</span>
                        <a href="#api_users">取用户列表</a>
                        <a href="#api_user">取指定用户</a>
                        <a href="#api_deluser">删除用户</a>
                        <a href="#api_adduser">注册用户</a>
                    </p>
                    <p class="noindent">
                        <span class="term">其它</span>
                        <a href="#api_templets">取模板列表</a>
                        <a href="#api_templet">取一个模板</a>
                        <a href="#api_fields">取字段列表</a>
                        <a href="#api_field">取一个字段</a>
                        <a href="#api_ac">输入提示</a>
                        <a href="#api_count">取记录数量</a>
                        <a href="#api_vars">获取变量</a>
                        <a href="#api_upload">文件上传</a>
                    </p>
                </dd>
                <dt id="api_set">设置</dt>
                <dd>
                    <p>在系统设置“功能选项”处勾选启用API接口后，需要设置：</p>
                    <p><span class="term">Key</span>用于客户端发送请求时对相关参数进行签名，服务器使用其对参数和签名进行验证。该值对接口安全性起辅助作用，应尽量保密。</p>
                    <p><span class="term">允许以下域调用API</span>默认只允许同域的程序代码调用API接口，若要允许跨域调用（如从 abc.com 调用），需指定调用方的域名，多个域用逗号分隔。留空表示不允许跨域调用，星号“*”表示允许任意域调用。</p>
                </dd>
                <dt id="api_promise">约定</dt>
                <dd>
                    <ul class="decoration">
                        <li>为简略起见，下文将主要以示例代码介绍API请求和响应数据，相关参数和说明请看注释。</li>
                        <li>为了介绍各参数或数据结构，示例中列出了请求的全部参数，和响应数据的全部属性。实际使用中应该只使用所需要的参数，并在访问响应数据的某些属性时，先检测其是否存在。</li>
                        <li>示例中会尽量省略重复的代码，例如对请求结果的处理代码。</li>
                        <li>示例代码中假定系统地址为http://host，假定客户端使用现代浏览器(不支持IE9以下版本)。</li>
                    </ul>
                </dd>
                <dt id="api_base">API接口调用概览</dt>
                <dd>
                    <pre class="code">
$.ajax({<span class="rem">//发起异步请求</span>
    url: "http://host/api/4/11",<span class="rem">//请求的接口地址</span>
    type: "get",<span class="rem">//请求方式（get-获取，post-新建，put-更新，delete-删除）</span>
    headers: getHeaders(),<span class="rem">//请求头。getHeaders函数见：<a href="#api_jscode">Javascript 参考代码</a></span>
    data: {...}<span class="rem">//请求参数。若不提供，可选参数视为未指定或取默认值，有必需参数则会报错</span>
}).done(function (res) {<span class="rem">//请求完成。res为返回结果，其结构见各接口说明</span>
    if (res.errcode == 0) {
        <span class="remline">//请求成功，展示数据...</span>
        if (res.token) {<span class="rem">//这些情况会有token：登录、刷新token、系统自动返回新token（使token滑动过期）</span>
            <span class="remline">//token的数据结构参见登录接口响应示例</span>
            $.cookie("token", res.token.token, { expires: 30 });<span class="rem">//将得到的token存入cookie，指定30天有效期</span>
        }
    } else {
        <span class="remline">//服务器处理失败，显示消息...</span>
    }
}).fail(function () {<span class="rem">//请求失败</span>
    <span class="rem">//显示错误消息...</span>
});</pre>
                    <p class="pcode">操作失败时返回数据示例：</p>
                    <pre class="code">
{
    "errcode": 103,<span class="rem">//错误代码。详见：<a href="#api_errcode">错误代码</a></span>
    "message": "没有权限"<span class="rem">//错误消息</span>
}</pre>
                </dd>
                <dt id="api_login">登录</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/login",<span class="rem">//接口：api/login</span>
    type: "post",<span class="rem">//使用post方法</span>
    headers: getHeaders(),
    data: {
        username: "tester",<span class="rem">//用户名或用户实名(必需)</span>
        password: "123456"<span class="rem">//密码(必需)</span>
    }
}).done(function (res) {<span class="rem">//请求完成后的处理。下文将省略此部分</span>
    if (res.errcode == 0) {<span class="rem">//登录成功</span>
        $.cookie("token", res.token.token, { expires: 30 });<span class="rem">//将得到的token存入cookie，指定30天有效期</span>
    } else {
        alert(res.message);
    }
}).fail(function (jqXHR, textStatus, errMsg) {<span class="rem">//请求失败后的处理。下文将省略此部分</span>
    alert(errMsg);
});</pre>
                    <p class="pcode">响应结果(即done事件中的res)示例：</p>
                    <pre class="code">
{
   "errcode": 0,<span class="rem">//请求成功</span>
   "token": {<span class="rem">//访问令牌数据</span>
      "expires": 86400,<span class="rem">//令牌过期时间(秒)</span>
      "token": "eyJ0eXAiOiJKV1QiL..."<span class="rem">//访问令牌</span>
   }
}                    </pre>
                    <p><span class="term">说明</span>登录成功后，需将返回结果中的令牌存储起来，后续请求需携带它以表明身份。在过期前应调用刷新令牌接口获取新令牌，以免让用户重新登录。</p>
                </dd>
                <dt id="api_autologin">自动登录</dt>
                <dd>
                    <p><span class="term">方法和原理</span>先确定一个保密字符串Key，例如"mykey123"，然后建立一个以此命名的空文件，扩展名为.pair，即mykey123.pair，放在本系统的App_Data文件夹下。按如下方式登录：</p>
                    <pre class="code">
$.ajax({
    url: "http://host/api/login",<span class="rem">//接口：api/login</span>
    type: "post",
    headers: getHeaders(),
    data: {
        username: "tester",<span class="rem">//用户名或用户实名(必需)</span>
        password: "2B7F2D43CD518375C7047E6F2624B490",<span class="rem">//编码(必需)。算法：将用户名加上Key字符串后计算MD5值，如：md5("tester" + "mykey123")</span>
        pwdencoded: true<span class="rem">//表明密码是经过编码的(必需)</span>
    }
});</pre>
                    <p><span class="term">说明</span>响应的数据结构与登录时相同；应注意确保.pair文件的安全和保密；此方法安全性不高（用户可能使用相同的参数来登录接口），请慎用。</p>
                </dd>
                <dt id="api_me">取当前用户</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/me",<span class="rem">//接口：api/me</span>
    type: "get",
    headers: getHeaders()
});</pre>
                    <p><span class="term">说明</span>响应的数据结构和"<a href="#api_user">取指定用户</a>"相同。</p>
                </dd>
                <dt id="api_updateme">修改个人信息</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/me",<span class="rem">//接口：api/me</span>
    type: "put",
    headers: getHeaders(),
    data: {
        email: "954366878@qq.com",
        <span class="remline">//省略其它字段...</span>
    }
});</pre>
                    <p><span class="term">说明</span>各参数字段请参见"<a href="#api_adduser">注册用户</a>"接口。未提供的字段将保持不变。</p>
                </dd>
                <dt id="api_changepwd">修改密码</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/me",<span class="rem">//接口：api/me</span>
    type: "patch",<span class="rem">//使用patch方法</span>
    headers: getHeaders(),
    data: {
        oldpwd: "myoldpwd",<span class="rem">//原密码(必需)</span>
        newpwd: "mynewpwd"<span class="rem">//新密码(必需)</span>
    }
});</pre>
                </dd>
                <dt id="api_retoken">刷新令牌</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/retoken",<span class="rem">//接口：api/retoken</span>
    type: "post",
    headers: getHeaders()<span class="rem">//请求头携带旧的token</span>
});</pre>
                    <p><span class="term">说明</span>请求成功后的响应数据结构及处理方法与登录接口相同。</p>
                </dd>
                <dt id="api_logout">退出</dt>
                <dd>
                    <pre class="code">
$("#logout").on("click", function () {<span class="rem">//为退出按钮绑定点击事件处理</span>
    $.removeCookie("token");<span class="rem">//删除cookie即可</span>
    alert("已退出登录！");
});</pre>
                    <p><span class="term">说明</span>退出登录无须调用接口，删除所保存的token即可。</p>
                </dd>
                <dt id="api_getone">获取一条记录</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/1/12",<span class="rem">//接口：api/{模板ID}/{记录ID}</span>
    type: "get",
    headers: getHeaders()
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {<span class="rem">//记录数据</span>
      "id": 12,<span class="rem">//记录ID</span>
      "fields": {<span class="rem">//各字段的值</span>
         "18": "开心果",<span class="rem">//ID为18的字段，其值为“开心果”</span>
         "6": "48元",
         "5": [<span class="rem">//文件、图片、超链接类型数据，都使用该数据结构</span>
            {
               "url": "http://host/UploadPicts/Access/F1404L.jpg",<span class="rem">//链接地址</span>
               "text": "开心果"<span class="rem">//名称或文本</span>
            }
         ],
         <span class="remline">//省略其它字段...</span>
      },
      "creator": "admin",<span class="rem">//创建者</span>
      "modifier": "admin",<span class="rem">//最后修改者</span>
      "modified": "2018-10-15 14:51",<span class="rem">//最近修改时间</span>
      "seclevel": 0,<span class="rem">//保密级别</span>
      "deletable": true,<span class="rem">//当前用户是否有权删除该记录</span>
      "editable": true<span class="rem">//当前用户是否有权编辑该记录</span>
   }
}</pre>
                    <p><span class="term">说明</span>无权查看的或值为null的字段，不会出现在响应数据中。</p>
                </dd>
                <dt id="api_delone">删除一条记录</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/1/12",<span class="rem">//接口：api/{模板ID}/{记录ID}</span>
    type: "delete",<span class="rem">//使用delete方法</span>
    headers: getHeaders()
});</pre>
                <dt id="api_records">获取一批记录</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/4",<span class="rem">//接口：api/{模板ID}</span>
    type: "get",
    headers: getHeaders(),
    data: {
        filter: "VIP客户",<span class="rem">//过滤器(可选)。可用"12-28"形式指定ID范围，用"12,38,153"形式指定ID序列。指定了filter，将忽略search和key参数</span>
        search: "客户名称搜索",<span class="rem">//搜索版式名称(可选)</span>
        key: "北京",<span class="rem">//搜索关键字(可选)。将在搜索版式中置入；要为版式中多个输入框指定关键字，以"|"分隔</span>
        fields: "24,29,178",<span class="rem">//要获取的字段ID序列(可选)。默认值：表格视图默认版式显示的字段</span>
        page: 2,<span class="rem">//页码(可选)。从0起计，默认值：0</span>
        pagesize: 20<span class="rem">//每页数量(可选)。默认值：表格视图默认版式的每页数量</span>
    }
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": [
      {
         "id": 66,
         "fields": {
            "24": "天津东南实业集团有限公司",
            "29": "张颖",
            <span class="remline">//省略其它字段...</span>
         },
         "editable": true,
         "deletable": true
      },
      <span class="remline">//省略其它记录...</span>
   ],
   "paging": {<span class="rem">//分页数据。下文将省略</span>
      "page": 2,<span class="rem">//当前页码(第3页)</span>
      "pages": 5,<span class="rem">//总页数</span>
      "pagesize": 15,<span class="rem">//每页数量</span>
      "total": 72,<span class="rem">//总记录数</span>
      "prev": "http://host/api/4?page=1",<span class="rem">//上一页地址</span>
      "next": "http://host/api/4?page=3",<span class="rem">//下一页地址</span>
      "first": "http://host/api/4?page=0",<span class="rem">//第一页地址</span>
      "last": "http://host/api/4?page=4"<span class="rem">//最后一页地址</span>
   }
}</pre>
                    <p><span class="term">说明</span>响应数据只包含表格视图本人默认版式中显示的字段。</p>
                </dd>
                <dt id="api_delids">删除一批记录</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/1",<span class="rem">//接口：api/{模板ID}</span>
    type: "delete",
    headers: getHeaders(),
    data: { 
       ids: "7,9,10"<span class="rem">//要删除的记录ID序列(必需)</span>
    }
});</pre>
                </dd>
                <dt id="api_add">添加记录</dt>
                <dd>
                    <pre class="code">
<span class="remline">//建立数据对象。要添加多条记录，请使用对象数组：[{...}, {...}, {...}]</span>
var data = {
    "24": "五洲信托",<span class="rem">//字段24的值：五洲信托。注：文本、特殊文本、单选/多选列表、变量等类型，都用文本值</span>
    "35": true,<span class="rem">//是/否类型，true表示"是"，false表示"否"</span>
    "28": "http://wuzhoux.com|五洲信托",<span class="rem">//链接类型，以"|"分隔链接地址和文字</span>
    "37": "|合作伙伴|代理商|",<span class="rem">//多选列表类型，以"|"分隔多个项</span>
    "41": "2018-03-26",<span class="rem">//日期时间类型，用文本值表示</span>
    "98": 322,<span class="rem">//数字类型，直接用数字</span>
    <span class="remline">//省略其它字段...</span>
};
<span class="remline">//发送请求，调用接口添加数据</span>
$.ajax({
    url: "http://host/api/4",<span class="rem">//接口：api/{模板ID}</span>
    type: "post",<span class="rem">//使用post方法</span>
    headers: getHeaders(),
    data: JSON.stringify(data)<span class="rem">//将数据对象转换为字符串</span>
});</pre>
                    <p class="pcode">单条记录响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "id": 6,<span class="rem">//新记录ID</span>
      "url": "http://host/api/4/6"<span class="rem">//新记录的地址</span>
   }
}</pre>
                    <p class="pcode">多条记录响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "id": [7, 8, 9],
      "url": "http://host/api/4?filter=7-9"
   }
}</pre>
                    <p><span class="term">说明</span>添加和更新数据时，暂不支持图片和文件类型字段。</p>
                </dd>
                <dt id="api_update">更新记录</dt>
                <dd>
                    <pre class="code">
var data = {
    "24": "五洲信托有限公司",
    "29": "李四",
    "36": "lisi@163.com",
    <span class="remline">//省略其它字段...</span>
};
$.ajax({
    url: "http://host/api/4/6",<span class="rem">//接口：api/{模板ID}/{记录ID}</span>
    type: "put",<span class="rem">//使用put方法</span>
    headers: getHeaders(),
    data: JSON.stringify(data)
});</pre>
                    <p><span class="term">说明</span>响应的数据结构和添加记录时相同。</p>
                </dd>
                <dt id="api_batchupdate">更新一批记录</dt>
                <dd>
                    <pre class="code">
var data = [
    { id: 2, "29": "rose" },<span class="rem">//指定id，则更新该id对应的记录</span>
    { key: 24, value: "abc公司", "29": "tony" },<span class="rem">//指定唯一性字段key及其值value，则更新其匹配的记录</span>
    { key: 24, value: "xyz公司", addifno: true, "29": "frank" },<span class="rem">//同时指定了addifno为true，表示更新匹配的记录，若没有匹配则添加为新记录</span>
    { "29": "linda", "36": "linda@163.com" }<span class="rem">//既未指定id，也未指定唯一性字段值，则添加为新记录</span>
];
$.ajax({
    url: "http://host/api/4",<span class="rem">//接口：api/{模板ID}</span>
    type: "put",<span class="rem">//使用put方法</span>
    headers: getHeaders(),
    data: JSON.stringify(data)
});</pre>
                    <p><span class="term">说明</span>参数名id、key、value、addifno必须小写。响应的数据结构和添加记录时相同。</p>
                </dd>
                <dt id="api_query">获取记录的关联查询结果</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/2/7/qs/1",<span class="rem">//接口：api/{模板ID}/{记录ID}/qs/{查询标记号}。此处为取查询$D1的结果</span>
    type: "get",
    headers: getHeaders()
});</pre>
                    <p><span class="term">说明</span>响应的数据结构与获取一批记录时相同。</p>
                </dd>
                <dt id="api_comments">获取记录评论</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/1/6/comments",<span class="rem">//接口：api/{模板ID}/{记录ID}/comments</span>
    type: "get",
    headers: getHeaders(),
    data: {
        page: 0,<span class="rem">//页码(可选)。从0起计，默认值：0</span>
        pagesize: 30<span class="rem">//每页数量(可选)。默认值：15</span>
    }
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": [
      {
         "id": 23,<span class="rem">//评论的ID</span>
         "content": "&lt;p&gt;物美价廉！&lt;/p&gt;",<span class="rem">//评论内容(HTML格式)</span>
         "author": "admin",<span class="rem">//作者</span>
         "time": "2018-03-21 15:21:57",<span class="rem">//发表时间</span>
         "modified": "2018-03-21 15:24:35"<span class="rem">//修改时间</span>
      },
      <span class="remline">//省略其它评论...</span>
   ],
   "paging":<span class="rem">//此处省略...</span>
}</pre>
                    <p><span class="term">说明</span>要获取某条评论，使用接口：api/{模板ID}/{记录ID}/comments/{评论ID}，无需data参数。</p>
                </dd>
                <dt id="api_delcomment">删除指定记录的指定评论</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/1/6/comments/23",<span class="rem">//接口：api/{模板ID}/{记录ID}/comments/{评论ID}</span>
    type: "delete",
    headers: getHeaders()
});</pre>
                </dd>
                <dt id="api_addcomment">针对某条记录发表评论</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/1/6/comments",<span class="rem">//接口：api/{模板ID}/{记录ID}/comments</span>
    type: "post",
    headers: getHeaders(),
    data: { 
       content: "不错，很喜欢！"<span class="rem">//评论内容(必需，支持HTML)</span>
    }
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "id": 24,<span class="rem">//新评论ID</span>
      "url": "http://host/api/1/6/comments/24"<span class="rem">//新评论的地址</span>
   }
}</pre>
                </dd>
                <dt id="api_msg">获取一条消息</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/messages/18",<span class="rem">//接口：api/messages/{消息ID}</span>
    type: "get",
    headers: getHeaders()
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "id": 18,<span class="rem">//消息ID</span>
      "sender": "tester",<span class="rem">//发件人</span>
      "time": "2018-03-22 10:17:42",<span class="rem">//发送时间</span>
      "subject": "下午五点前提交报告",<span class="rem">//主题</span>
      "content": "&lt;p&gt;请下午五点前提交本次审核报告。&lt;p&gt;",<span class="rem">//内容</span>
      "attachment": [<span class="rem">//附件</span>
         {
            "url": "http://host/InfoAttach/Access/FA42MS.docx",
            "text": "审核计划"
         }
      ]
   }
}</pre>
                </dd>
                <dt id="api_delmsg">删除一条消息</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/messages/18",<span class="rem">//接口：api/messages/{消息ID}</span>
    type: "delete",
    headers: getHeaders()
});</pre>
                </dd>
                <dt id="api_msgs">获取一批消息</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/messages",<span class="rem">//接口：api/messages</span>
    type: "get",
    headers: getHeaders(),
    data: { 
       type: "Unread",<span class="rem">//消息类型(可选)。默认值：Unread</span>
       page: 0,<span class="rem">//页码(可选)。从0起计，默认值：0</span>
       pagesize: 15<span class="rem">//每页数量(可选)。默认值：本人消息列表设置的每页数量</span>
    }
});</pre>
                    <p class="pcode">消息类型 type：</p>
                    <ul class="decoration">
                        <li><span class="term">Unread</span>未读消息</li>
                        <li><span class="term">Read</span>已读消息</li>
                        <li><span class="term">Received</span>所有收到的消息</li>
                        <li><span class="term">Sendbox</span>发出的消息</li>
                    </ul>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": [<span class="rem">//消息对象数组</span>
      {
         "id": 18,
         "sender": "tester",
         "subject": "下午五点前提交报告",
         <span class="remline">//省略其它字段...</span>
      },
      <span class="remline">//省略其它消息...</span>
   ],
   "paging":<span class="rem">//此处省略...</span>
}</pre>
                </dd>
                <dt id="api_delmsgs">删除一批消息</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/messages",<span class="rem">//接口：api/messages</span>
    type: "delete",
    headers: getHeaders(),
    data: { 
       ids: "12,13,16",<span class="rem">//要删除的消息ID序列(必需)</span>
       insendbox: true<span class="rem">//要删除的是否发件箱中的消息(可选)。默认值：false</span>
    }
});</pre>
                </dd>
                <dt id="api_sendmsg">发送消息</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/messages",<span class="rem">//接口：api/messages</span>
    type: "post",
    headers: getHeaders(),
    data: { 
       subject: "会议通知",<span class="rem">//主题(必需)</span>
       content: "明天10:30分在小会议室开会讨论促销计划。",<span class="rem">//内容(必需，支持HTML)</span>
       to: "admin,tester"<span class="rem">//收件人(必需)</span>
    }
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "id": 66,<span class="rem">//新消息ID</span>
      "url": "http://host/api/messages/66"<span class="rem">//新消息地址</span>
   }
}</pre>
                </dd>
                <dt id="api_info">获取一条信息</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/infos/88",<span class="rem">//接口：api/infos/{信息ID}</span>
    type: "get",
    headers: getHeaders()
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "id": 88,<span class="rem">//信息ID</span>
      "title": "防止个人信息泄露的4个步骤",<span class="rem">//标题</span>
      "summary": "如何保护自己的个人信息…",<span class="rem">//摘要</span>
      "content": "&lt;p&gt;近日，据美国《纽约时报》报道，Facebook上超5000万用户数据被…&lt;/p&gt;",<span class="rem">//内容</span>
      "category": "新闻",<span class="rem">//所属栏目</span>
      "sticky": true,<span class="rem">//是否置顶</span>
      "fresh": false,<span class="rem">//是否未读</span>
      "comments": 5,<span class="rem">//评论数量</span>
      "readtimes": 1,<span class="rem">//浏览人次数</span>
      "seclevel": 0,<span class="rem">//保密级别</span>
      "commentable": true,<span class="rem">//当前用户是否可评论</span>
      "deletable": true,<span class="rem">//当前用户是否可删除</span>
      "editable": true,<span class="rem">//当前用户是否可编辑</span>
      "attachment": [<span class="rem">//附件</span>
         {
            "url": "http://host/Access/FLN3613.doc",
            "text": "原文"
         }
      ],
      "tags": "news,privacy",<span class="rem">//标签</span>
      "author": "admin",<span class="rem">//作者</span>
      "time": "2018-03-22 13:33:29",<span class="rem">//发布时间</span>
      "modified": "2018-03-24 10:31:20"<span class="rem">//修改时间</span>
   }
}</pre>
                </dd>
                <dt id="api_delinfo">删除一条信息</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/infos/88",<span class="rem">//接口：api/infos/{信息ID}</span>
    type: "delete",
    headers: getHeaders()
});</pre>
                </dd>
                <dt id="api_infos">获取一批信息</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/infos",<span class="rem">//接口：api/infos</span>
    type: "get",
    headers: getHeaders(),
    data: { 
       range: "Category",<span class="rem">//筛选模式(可选)。默认值：All</span>
       argument: "新闻",<span class="rem">//与筛选模式匹配的参数(若range为Category或Tag，则该参数必需)</span>
       orderby: "ClickTimes",<span class="rem">//排序依据(可选)。默认值：PublishTime</span>
       page: 0,<span class="rem">//页码(可选)。从0起计，默认值：0</span>
       pagesize: 15<span class="rem">//每页数量(可选)。默认值：本人信息中心设置的每页数量</span>
    }
});</pre>
                    <p class="pcode">筛选模式 range：</p>
                    <ul class="decoration">
                        <li><span class="term">All</span>全部</li>
                        <li><span class="term">Tag</span>具有指定标签的信息。由argument指定标签</li>
                        <li><span class="term">Own</span>当前用户本人发布的信息</li>
                        <li><span class="term">Private</span>当前用户的私人记录</li>
                        <li><span class="term">CommentBy</span>当前用户评论过的信息</li>
                        <li><span class="term">Today</span>今天发布的信息</li>
                        <li><span class="term">Yesterday</span>昨天发布的信息</li>
                        <li><span class="term">Search</span>搜索(从标题)结果。由argument指定关键字</li>
                        <li><span class="term">Category</span>指定栏目的信息。由argument指定栏目名称</li>
                    </ul>
                    <p class="pcode">排序依据 orderby：</p>
                    <ul class="decoration">
                        <li><span class="term">PublishTime</span>发布时间</li>
                        <li><span class="term">ClickTimes</span>浏览人次数</li>
                        <li><span class="term">LastCommentTime</span>最后评论时间</li>
                        <li><span class="term">CommentCount</span>评论数量</li>
                        <li><span class="term">EditTime</span>修改时间</li>
                    </ul>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": [
      {
         "id": 88,
         "title": "防止个人信息泄露的4个步骤",
         <span class="remline">//省略其它字段...</span>
      },
      <span class="remline">//省略其它信息...</span>
   ],
   "paging":<span class="rem">//此处省略...</span>
}</pre>
                </dd>
                <dt id="api_sendinfo">发布信息</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/infos",<span class="rem">//接口：api/infos</span>
    type: "post",
    headers: getHeaders(),
    data: { 
       title: "如何避免“春节综合症”？",<span class="rem">//标题(必需)</span>
       content: "春节长假结束，回到工作岗位，你却感觉身体无法回归了…",<span class="rem">//内容(必需)</span>
       summary: "不少人感觉，长假过后仿佛得了怪病…",<span class="rem">//摘要(可选)</span>
       category: "资讯/健康",<span class="rem">//栏目(可选)</span>
       sticky: true,<span class="rem">//是否置顶(可选)。默认值：false</span>
       tags: "news",<span class="rem">//标签(可选)</span>
       commentable: true,<span class="rem">//是否允许评论(可选)。默认值：false</span>
       seclevel: 0,<span class="rem">//保密级别(可选)。默认值：0</span>
       toweixin: true<span class="rem">//是否发送到微信(可选)。默认值：false</span>
    }
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "id": 92,<span class="rem">//新信息ID</span>
      "url": "http://host/api/infos/92"<span class="rem">//新信息地址</span>
   }
}</pre>
                </dd>
                <dt id="api_editinfo">修改信息</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/infos/83",<span class="rem">//接口：api/infos/{信息ID}</span>
    type: "put",
    headers: getHeaders(),
    data: { 
       content: "以下是修改后的内容…",<span class="rem">//内容(必需)</span>
       <span class="remline">//省略其它参数...</span>
    }
});</pre>
                    <p><span class="term">说明</span>响应的数据结构和发布信息时相同。</p>
                </dd>
                <dt id="api_infocomments">获取信息评论</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/infos/26/comments",<span class="rem">//接口：api/infos/{信息ID}/comments</span>
    type: "get",
    headers: getHeaders(),
    data: {
        page: 0,<span class="rem">//页码(可选)。从0起计，默认值：0</span>
        pagesize: 30<span class="rem">//每页数量(可选)。默认值：15</span>
    }
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": [
      {
         "id": 66,<span class="rem">//评论的ID</span>
         "content": "&lt;p&gt;好文，赞！&lt;/p&gt;",<span class="rem">//评论内容(HTML格式)</span>
         "author": "tester",<span class="rem">//作者</span>
         "time": "2018-02-21 10:21:20",<span class="rem">//发表时间</span>
         "modified": "2018-03-15 15:12:18"<span class="rem">//修改时间</span>
      },
      <span class="remline">//省略其它评论...</span>
   ],
   "paging":<span class="rem">//此处省略...</span>
}</pre>
                    <p><span class="term">说明</span>要获取某条评论，使用接口：api/infos/{信息ID}/comments/{评论ID}，无需data参数。</p>
                </dd>
                <dt id="api_delinfocomment">删除指定信息的指定评论</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/infos/26/comments/122",<span class="rem">//接口：api/infos/{信息ID}/comments/{评论ID}</span>
    type: "delete",
    headers: getHeaders()
});</pre>
                </dd>
                <dt id="api_addinfocomment">针对某条信息发表评论</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/infos/26/comments",<span class="rem">//接口：api/infos/{信息ID}/comments</span>
    type: "post",
    headers: getHeaders(),
    data: { 
       content: "很好！"<span class="rem">//评论内容(必需，支持HTML)</span>
    }
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "id": 124,<span class="rem">//新评论ID</span>
      "url": "http://host/api/infos/26/comments/124"<span class="rem">//新评论的地址</span>
   }
}</pre>
                </dd>
                <dt id="api_tasks">获取待办/已办事项</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/tasks",<span class="rem">//接口：api/tasks</span>
    type: "get",
    headers: getHeaders(),
    data: { 
       type: "Pending",<span class="rem">//事项类型(可选)。默认值：Pending</span>
       sort: "StartTime",<span class="rem">//排序依据(可选)。默认值：事务中心同类事项的排序字段</span>
       sortdirection: "Ascending",<span class="rem">//排序方向(可选)。默认值：Descending</span>
       state: "Rejected",<span class="rem">//用于筛选的任务状态(可选)</span>
       overdue: true,<span class="rem">//用于筛选的"是否超期"(可选)</span>
       key: "确认",<span class="rem">//用于从事项主题中搜索的关键字(可选)</span>
       timetype: "FinishTime",<span class="rem">//用于时段筛选的时间类型(可选)</span>
       fromtime: "2018-03-01",<span class="rem">//用于时段筛选的起始时间(可选)</span>
       totime: "2018-04-01",<span class="rem">//用于时段筛选的截止时间(可选)</span>
       usertype: "Creator",<span class="rem">//用于根据人员筛选的人员类型(可选)</span>
       users: "admin,tester",<span class="rem">//用于根据人员筛选的人员用户名(可选，若指定了usertype则必需)</span>
       page: 0,<span class="rem">//页码(可选)。从0起计，默认值：0</span>
       pagesize: 15<span class="rem">//每页数量(可选)。默认值：本人事务中心设置的每页数量</span>
    }
});</pre>
                    <p class="pcode">事项类型 type：</p>
                    <ul class="decoration">
                        <li><span class="term">Pending</span>待办事项</li>
                        <li><span class="term">Finished</span>已办事项</li>
                    </ul>
                    <p class="pcode">排序依据 sort：</p>
                    <ul class="decoration">
                        <li><span class="term">State</span>状态</li>
                        <li><span class="term">Subject</span>主题</li>
                        <li><span class="term">FlowCreator</span>流程发起人</li>
                        <li><span class="term">Handover</span>任务交办人</li>
                        <li><span class="term">StartTime</span>任务开始时间</li>
                        <li><span class="term">EndTime</span>计划完成时间</li>
                        <li><span class="term">ProcessTime</span>任务处理时间</li>
                        <li><span class="term">FlowState</span>流程状态</li>
                    </ul>
                    <p class="pcode">排序方向 sortdirection：</p>
                    <ul class="decoration">
                        <li><span class="term">Ascending</span>由小到大</li>
                        <li><span class="term">Descending</span>由大到小</li>
                    </ul>
                    <p class="pcode">任务状态 state：</p>
                    <ul class="decoration">
                        <li><span class="term">Received</span>已收到</li>
                        <li><span class="term">Partially</span>部分完成</li>
                        <li><span class="term">Passed</span>通过(审核/确认)</li>
                        <li><span class="term">Rejected</span>被拒</li>
                        <li><span class="term">Completed</span>完成(事务处理)</li>
                        <li><span class="term">Back</span>退回</li>
                        <li><span class="term">Veto</span>否决</li>
                        <li><span class="term">Abort</span>中止(由于流程结束)</li>
                    </ul>
                    <p class="pcode">筛选时间类型 timetype：</p>
                    <ul class="decoration">
                        <li><span class="term">StartTime</span>开始时间</li>
                        <li><span class="term">EndTime</span>计划完成时间</li>
                        <li><span class="term">FinishTime</span>实际完成时间</li>
                    </ul>
                    <p class="pcode">筛选用户类型 usertype：</p>
                    <ul class="decoration">
                        <li><span class="term">Creator</span>流程发起人</li>
                        <li><span class="term">Handover</span>任务交办人</li>
                        <li><span class="term">FlowParticipant</span>流程参与者</li>
                        <li><span class="term">TaskParticipant</span>任务参与者</li>
                    </ul>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": [
      {
         "id": 37,<span class="rem">//任务ID</span>
         "overdue": false,<span class="rem">//是否超期</span>
         "users": 2,<span class="rem">//执行人数</span>
         "type": "Approve",<span class="rem">//任务类型</span>
         "state": "Received",<span class="rem">//任务状态</span>
         "name": "任务处理",<span class="rem">//当前步骤的名称</span>
         "start": "2018-03-23 10:36:08",<span class="rem">//任务开始时间</span>
         "end": "2018-03-24 10:00:00",<span class="rem">//计划完成时间。若未指定，则无该项</span>
         "finished": 2018-03-23 18:20:12",<span class="rem">//实际完成时间。若未完成，则无该项</span>
         "handover": "admin",<span class="rem">//交办人</span>
         "passed": 0,<span class="rem">//已处理通过的人数</span>
         "rejected": 0,<span class="rem">//已拒绝的人数</span>
         "progress": 0,<span class="rem">//事务处理类任务当前已完成的百分比</span>
         "record": {<span class="rem">//流程表单记录</span>
            "rid": 19,<span class="rem">//模板ID</span>
            "tid": 13<span class="rem">//记录ID</span>
         },
         "flow": {<span class="rem">//流程信息</span>
            "id": 19,<span class="rem">//流程ID</span>
            "state": "Running",<span class="rem">//流程状态</span>
            "overdue": false,<span class="rem">//是否超期</span>
            "creator": "admin",<span class="rem">//流程发起人</span>
            "subject": "质量体系内审"<span class="rem">//流程主题</span>
         }
      },
      <span class="remline">//省略其它事项...</span>
   ],
   "paging":<span class="rem">//此处省略...</span>
}</pre>
                    <p class="pcode">任务类型 type：</p>
                    <ul class="decoration">
                        <li><span class="term">Transaction</span>事务处理</li>
                        <li><span class="term">Approve</span>审批/确认</li>
                    </ul>
                    <p class="pcode">流程状态 flow.state：</p>
                    <ul class="decoration">
                        <li><span class="term">Running</span>运行中</li>
                        <li><span class="term">Paused</span>暂停</li>
                        <li><span class="term">Veto</span>已否决</li>
                        <li><span class="term">Finished</span>完成</li>
                    </ul>
                </dd>
                <dt id="api_task">获取指定事项</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/tasks/132",<span class="rem">//接口：api/tasks/{任务ID}</span>
    type: "get",
    headers: getHeaders()
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "id": 48,
      "overdue": false,
      <span class="remline">//省略其它字段...</span>
      "more": {<span class="rem">//仅在获取单一事项时会返回该属性</span>
         "needcomment": true,<span class="rem">//是否必须填写处理意见</span>
         "remarks": "请将相关资料作为附件！",<span class="rem">//步骤说明</span>
         "identities": {<span class="rem">//用户当前可用的身份</span>
            "tester|32|False": "行政部直属成员",
            "tester|36|True": "销售部负责人"
         },
         "nextsteps": {<span class="rem">//下一步可选步骤</span>
            "n2ds5": "部门审核",<span class="rem">//步骤ID: 步骤名称</span>
            "n768d": "财务评估"
         },
         "button_pass": "同意",<span class="rem">//表示拒绝的处理按钮的文字</span>
         "button_reject": "拒绝",<span class="rem">//表示通过或完成的处理按钮的文字</span>
         "backtargets": {<span class="rem">//供退回时选择的目标节点</span>
            "7": "开始 【3月23日10:36/tester】",<span class="rem">//目标节点ID: 目标节点描述</span>
            "12": "部门审核 【3月23日15:26/frank】"
         }
      }
   }
}</pre>
                </dd>
                <dt id="api_dotask">处理待办事项</dt>
                <dd>
                    <pre class="code">
function processTask(taskid, data) {<span class="rem">//定义处理函数</span>
    $.ajax({
        url: "http://host/api/tasks/" + taskid,<span class="rem">//接口：api/tasks/{任务ID}</span>
        type: "put",<span class="rem">//使用put方法</span>
        headers: getHeaders(),
        data: data
    }).done(function (res) {
        if (res.errcode == 0) {
            showMsg("处理成功！");
        } else if (res.errcode == 106) {<span class="rem">//表示需补充处理人员和/或处理时限参数。此时的响应数据见下文</span>
            if (res.required.nextexers) {
                <span class="rem">//此时需要用户指定各步骤的处理人员。此处假设已获取用户输入</span>
                data.nextexers = "n2ds5:admin,tester|n768d:frank";<span class="rem">//下一步处理者(必需)。格式：步骤ID:用户名|步骤ID:用户名</span>
            }
            if (res.required.timelimits) {<span class="rem">//</span>
                <span class="rem">//此时需要用户指定各步骤的处理时限。此处假设已获取用户输入</span>
                data.timelimits = "n2ds5:2018-03-25|n768d:2018-03-28";<span class="rem">//下一步处理时限(必需)。格式：步骤ID:时间|步骤ID:时间</span>
            }
            <span class="remline">//补充参数后再次提交处理</span>
            processTask(taskid, data);
        } else {
            showMsg(res.message);
        }
    }).fail(function (jqXHR, textStatus, errMsg) {
        showMsg(errMsg);
    });
}
<span class="remline">//调用函数，处理指定事项</span>
processTask(15, {
    action: "Pass",<span class="rem">//处理动作(可选)。默认值：Complete(事务处理)/Pass(审核/确认)</span>
    identity: "tester|32|false",<span class="rem">//处理者所用身份(可选)。默认值：用户默认身份</span>
    comment: "请做好跟踪和记录",<span class="rem">//处理意见(若步骤设置“必须填写处理意见”则必需)</span>
    nextsteps: "n2ds5,n768d"<span class="rem">//下一步步骤(若步骤设置“由处理人从多个分支中选择下一步骤”则必需)</span>
});
</pre>
                    <p class="pcode">响应结果(要求补充参数)示例：</p>
                    <pre class="code">
{
   "errcode": 106,<span class="rem">//表示需补充参数</span>
   "required": {<span class="rem">//指明需要补充的参数</span>
      "nextexers": {<span class="rem">//需指定处理者的后续步骤</span>
         "n2ds5": "部门审核",<span class="rem">//步骤ID: 步骤名称</span>
         "n768d": "财务评估"
      },
      "timelimits": {<span class="rem">//需指定处理时限的后续步骤</span>
         "n2ds5": "部门审核"
      }
   },
   "message": "请指定后续步骤的处理者和/或处理时限！"
}</pre>
                    <p class="pcode">响应结果(处理成功)示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "message": "操作成功！已提交：部门审核、财务评估"
}</pre>
                </dd>
                <dt id="api_backtask">退回待办事项</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/tasks/132",<span class="rem">//接口：api/tasks/{任务ID}</span>
    type: "delete",<span class="rem">//使用delete方法</span>
    headers: getHeaders(),
    data: { 
       backtarget: 16,<span class="rem">//退回到的目标节点ID(必需)</span>
       mode: "TimeBack",<span class="rem">//回退模式(可选)。默认值：MinAffect</span>
       comment: "请补充资料后重新提交。",<span class="rem">//回退说明(可选，支持HTML)</span>
    }
});</pre>
                </dd>
                <dt id="api_users">取用户列表</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/users",<span class="rem">//接口：api/users</span>
    type: "get",
    headers: getHeaders(),
    data: { 
       key: "zhang",<span class="rem">//用户名关键字(可选)。指定该参数，则将搜索用户名包含此关键字的用户</span>
       page: 0,<span class="rem">//页码(可选)。从0起计，默认值：0</span>
       pagesize: 30<span class="rem">//每页数量(可选)。默认值：15</span>
    }
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": [
      {
         "name": "admin",
         "email": "landian_tester@sina.com",
         <span class="remline">//完整属性列表参见“取指定用户”响应结果，此处省略...</span>
      },
      <span class="remline">//省略其它用户...</span>
   ],
   "paging":<span class="rem">//此处省略...</span>
}</pre>
                </dd>
                <dt id="api_user">取指定用户</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/users/admin",<span class="rem">//接口：api/users/{用户名或用户实名}</span>
    type: "get",
    headers: getHeaders()
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "name": "admin",<span class="rem">//用户名</span>
      "realname": "张成明",<span class="rem">//真实姓名</span>
      "role": "系统管理员,员工",<span class="rem">//所属角色</span>
      "sex": "男",<span class="rem">//性别</span>
      "email": "landian_tester@sina.com",<span class="rem">//邮箱</span>
      "phone": "13812345678",<span class="rem">//电话</span>
      "address": "大成路18号",<span class="rem">//地址</span>
      "unit": "行政部",<span class="rem">//所属机构</span>
      "zipcode": "430110",<span class="rem">//邮编</span>
      "created": "2018-03-19 11:23:27"<span class="rem">//创建时间</span>
   }
}</pre>
                </dd>
                <dt id="api_deluser">删除用户</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/users/tester",<span class="rem">//接口：api/users/{用户名或用户实名}</span>
    type: "delete",
    headers: getHeaders()
});</pre>
                </dd>
                <dt id="api_adduser">注册用户</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/users",<span class="rem">//接口：api/users</span>
    type: "post",
    headers: getHeaders(),
    data: { 
       name: "aimee",<span class="rem">//用户名(必须)</span>
       unitid: 8,//<span class="rem">所属机构ID(可选)。默认值：0</span>
       password: "Bz6w22p",<span class="rem">//密码(必需)</span>
       question: "我的小学名称？",<span class="rem">//密码问题(必需)</span>
       answer: "杨家村小学",<span class="rem">//密码答案(必需)</span>
       email: "yanwzxin@163.com",<span class="rem">//邮箱(是否必需取决于设置)</span>
       sex: "女",<span class="rem">//性别(可选)。默认值：男</span>
       realname: "赵慧兰",<span class="rem">//真实姓名(是否必需取决于设置)</span>
       phone: "02085601130",<span class="rem">//电话(是否必需取决于设置)</span>
       address: "中山路32号",<span class="rem">//地址(是否必需取决于设置)</span>
       zipcode: "310221",<span class="rem">//邮编(是否必需取决于设置)</span>
       weixin: "wenyan2235"<span class="rem">//微信帐号(是否必需取决于设置)</span>
    }
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "id": "aimee",
      "url": "http://host/api/users/aimee"
   }
}</pre>
                </dd>
                <dt id="api_templets">取模板列表</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/templets",<span class="rem">//接口：api/templets</span>
    type: "get",
    headers: getHeaders(),
    data: { 
       full: false<span class="rem">//是否获取完整信息(可选)。默认值：false</span>
    }
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "4": "客户",<span class="rem">//模板ID: 模板名称</span>
      "1": "产品",
      "2": "报价单",
      <span class="remline">//省略其它项...</span>
   }
}</pre>
                </dd>
                <dt id="api_templet">取一个模板</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/templets/4",<span class="rem">//接口：api/templets/{模板ID}</span>
    type: "get",
    headers: getHeaders()
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "id": 4,<span class="rem">//模板ID</span>
      "name": "客户",<span class="rem">//模板名</span>
      "identifier": 24,<span class="rem">//模板标识字段ID</span>
      "default_seclevel": 0,<span class="rem">//默认保密级别</span>
      "default_view": "Table",<span class="rem">//默认的数据视图</span>
      "default_sort_field": "FX1j49",<span class="rem">//默认排序字段的字段代码</span>
      "default_sort_direction": "Descending"<span class="rem">//默认排序方向</span>
   }
}</pre>
                    <p class="pcode">数据视图：</p>
                    <ul class="decoration">
                        <li><span class="term">Table</span>表格视图</li>
                        <li><span class="term">Thumbnail</span>缩略视图</li>
                        <li><span class="term">Detail</span>详情视图</li>
                        <li><span class="term">Overview</span>概要视图</li>
                        <li><span class="term">Chart</span>图表视图</li>
                        <li><span class="term">Report</span>报表视图</li>
                    </ul>
                </dd>
                <dt id="api_fields">取字段列表</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/4/fields",<span class="rem">//接口：api/{模板ID}/fields</span>
    type: "get",
    headers: getHeaders(),
    data: { 
       full: false<span class="rem">//是否获取完整信息(可选)。默认值：false</span>
    }
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "24": "客户名称",<span class="rem">//字段ID: 字段名</span>
      "29": "联系人",
      "50": "客户评级",
      <span class="remline">//省略其它项...</span>
   }
}</pre>
                </dd>
                <dt id="api_field">取一个字段</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/4/fields/29",<span class="rem">//接口：api/{模板ID}/fields/{字段ID}</span>
    type: "get",
    headers: getHeaders()
});</pre>
                    <p class="pcode">响应结果(非真实结果，展示了所有属性)示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "id": 29,<span class="rem">//字段ID</span>
      "name": "联系人",<span class="rem">//字段名</span>
      "type": "Text",<span class="rem">//字段类型</span>
      "code": "F1492p8",<span class="rem">//字段代码</span>
      "length": 10,<span class="rem">//字段长度</span>
      "editor": false,<span class="rem">//是否启用编辑器(即支持HTML内容)</span>
      "required": false,<span class="rem">//是否必填字段</span>
      "uniqued": false,<span class="rem">//是否不允许重复</span>
      "options": [<span class="rem">//选项(仅单选/多选列表类型有该属性)</span>
         "VIP客户",
         "潜在客户",
         "合作伙伴"
      ],
      "formula": "[135]*1.3",<span class="rem">//公式字段的公式</span>
      "timetype": "DateOnly",<span class="rem">//日期时间格式</span>
      "defaultvalue": "now",<span class="rem">//默认值</span>
      "note": "输入联系人名称，不超过10字符",<span class="rem">//字段输入说明</span>
      "regex": "\w{2,10}",<span class="rem">//字段输入规范(正则表达式)</span>
      "hidden": false,<span class="rem">//是否隐藏</span>
      "seclevel": 0,<span class="rem">//保密级别</span>
      "templet": 4<span class="rem">//所属模板ID</span>
   }
}</pre>
                    <p class="pcode">数据类型 type：</p>
                    <ul class="decoration">
                        <li><span class="term">Text</span>文本</li>
                        <li><span class="term">Numeric</span>数字</li>
                        <li><span class="term">DateTime</span>日期时间</li>
                        <li><span class="term">SingleList</span>单选列表</li>
                        <li><span class="term">MultipleList</span>多选列表</li>
                        <li><span class="term">YesNo</span>是/否</li>
                        <li><span class="term">Formula</span>公式</li>
                        <li><span class="term">Query</span>查询</li>
                        <li><span class="term">Photo</span>图片</li>
                        <li><span class="term">File</span>文件</li>
                        <li><span class="term">HyperLink</span>链接</li>
                        <li><span class="term">AutoNumber</span>自动编号</li>
                        <li><span class="term">SpecialText</span>特殊文本</li>
                        <li><span class="term">Variable</span>变量</li>
                    </ul>
                    <p class="pcode">特殊文本类型：</p>
                    <ul class="decoration">
                        <li><span class="term">EMail</span>电子邮箱</li>
                        <li><span class="term">MobilePhone</span>电话号码</li>
                        <li><span class="term">UserName</span>用户名</li>
                        <li><span class="term">UnitName</span>机构名</li>
                        <li><span class="term">QQ</span>QQ号码</li>
                        <li><span class="term">MSN</span>MSN帐号</li>
                        <li><span class="term">Skype</span>Skype帐号</li>
                        <li><span class="term">Ali</span>淘宝帐号</li>
                        <li><span class="term">AliChina</span>阿里巴巴帐号</li>
                    </ul>
                    <p class="pcode">变量类型：</p>
                    <ul class="decoration">
                        <li><span class="term">UserName</span>用户名</li>
                        <li><span class="term">UserRealName</span>用户实名</li>
                        <li><span class="term">UserUnit</span>用户所属机构</li>
                        <li><span class="term">UserIP</span>用户IP地址</li>
                        <li><span class="term">Now</span>当时时间</li>
                    </ul>
                    <p class="pcode">公式结果类型：</p>
                    <ul class="decoration">
                        <li><span class="term">Double</span>数字</li>
                        <li><span class="term">DateTime</span>日期时间</li>
                        <li><span class="term">Boolean</span>是/否</li>
                        <li><span class="term">String</span>文本</li>
                    </ul>
                </dd>
                <dt id="api_ac">输入提示</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/list/1/2",<span class="rem">//接口：api/list/{模板ID}/{字段ID}</span>
    type: "get",
    headers: getHeaders(),
    data: { 
       key: "果",<span class="rem">//用户当前输入(可选)</span>
       count: 20<span class="rem">//最大结果项数(可选)。默认值：30；设为0表示取所有项</span>
    }
});</pre>
                    <p class="pcode">其它输入提示接口：</p>
                    <ul class="decoration">
                        <li><span class="term">模板</span>api/list/templets</li>
                        <li><span class="term">用户名</span>api/list/users</li>
                        <li><span class="term">角色</span>api/list/roles</li>
                        <li><span class="term">机构</span>api/list/units</li>
                        <li><span class="term">信息(标题)</span>api/list/infos</li>
                        <li><span class="term">信息标签</span>api/list/tags</li>
                    </ul>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": [
      "果仁巧克力",
      "开心果",
      "苹果汁"
   ]
}</pre>
                </dd>
                <dt id="api_count">取记录数量</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/4/count",<span class="rem">//接口：api/{模板ID}/count</span>
    type: "get",
    headers: getHeaders(),
    data: { 
       filter: "VIP客户"<span class="rem">//过滤器(可选)</span>
    }
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": 162
}</pre>
                </dd>
                <dt id="api_vars">获取变量</dt>
                <dd>
                    <pre class="code">
$.ajax({
    url: "http://host/api/vars",<span class="rem">//接口：api/vars</span>
    type: "get",
    headers: getHeaders()
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
   "errcode": 0,
   "data": {
      "UserName": "admin",<span class="rem">//当前用户名</span>
      "UserRealName": "admin",<span class="rem">//当前用户实名</span>
      "UserUnit": "行政部",<span class="rem">//当前用户所在机构</span>
      "UserIP": "127.0.0.1",<span class="rem">//当前用户IP地址</span>
      "Now": "2020-01-03 18:57:01",<span class="rem">//当前时间</span>
      "Roles": ["系统管理员"]<span class="rem">//当前用户的角色</span>
   }
}</pre>
                </dd>
                <dt id="api_upload">文件上传</dt>
                <dd>
                    <pre class="code">
var formData = new FormData();
$.each(document.getElementById('f').files, function (i, file) {<span class="rem">//假设文件控件ID为f</span>
    formData.append(file.name, file);
});
$.ajax({
    url: "http://host/api/uload/file",<span class="rem">//接口：api/uload/{上传类型，file 或 photo}</span>
    type: "post",
    data: formData,
    processData: false,
    contentType: false,
    headers: getHeaders()
});</pre>
                    <p class="pcode">响应结果示例：</p>
                    <pre class="code">
{
  "errcode": 0,
  "data": {
    "files": [{"name": "截图", "file": "FV79MY.png"}, {"name": "合同", "file": "FLX4F5.doc"}],
    "msg": "test.exe，无效的文件类型！"
  }
}</pre>
                    <p class="pcode"><a href="js/apiHelper.js" target="_blank">Javascript 工具库</a>提供了辅助函数，可按如下示例上传并转换为字段值：</p>
                    <pre class="code">
&lt;input type="file" id="f" multiple="multiple" onchange="doUpload(this);" /&gt;
function doUpload(ctl) {
    uploadFile('http://host/api/upload', ctl,
        function (res) {<span class="rem">//上传成功回调函数</span>
            if (res.errcode == 0) {
                if (res.data.msg) alert(res.data.msg);
                var fieldValue = asValue(res.data.files);<span class="rem">//将上传的文件转换为字段值</span>
                console.log(fieldValue);
            } else {
                console.log(res.message);
            }
        },
        function (loaded, total) {<span class="rem">//上传进度回调函数</span>
            if (total) {
                var percent = Math.floor(100 * loaded / total);
                console.log(percent + "% (" + toSize(loaded) + "/" + toSize(total) + ")");
            }
        },
        function (msg) {<span class="rem">//上传出错回调函数</span>
            console.log(msg);
        }
    );
}</pre>
                    <p><span class="term">说明</span>对于图片字段，应使用接口 api/uload/photo。</p>
                </dd>
                <dt id="api_errcode">错误代码</dt>
                <dd>
                    <ul class="decoration" id="errcodes" runat="server">
                    </ul>
                </dd>
                <dt id="api_jscode">Javascript 参考代码</dt>
                <dd>
                    <p class="pcode">getHeaders 函数，用于生成调用接口的请求头：</p>
                    <pre class="code">
function getHeaders() {
    var token = $.cookie("token");<span class="rem">//登录时得到的令牌</span>
    var key = "LFHvD7B8W3og";<span class="rem">//API提供方设置的密钥，用以生成签名供服务器验证请求</span>
    var timestamp = Math.round(new Date().getTime() / 1000);<span class="rem">//时间戳</span>
    var nonce = randomString(12);<span class="rem">//随机数</span>
    return {
        "Authorization": token ? ("Bearer " + token) : "",
        "timestamp": timestamp,
        "nonce": nonce,
        "sign": md5(timestamp + nonce + key)<span class="rem">//签名</span>
    };
}</pre>
                    <p class="pcode">判断变量是否为数组：</p>
                    <pre class="code">
var a = [], b = {};
console.log(Array.isArray(a));<span class="rem">//true</span>
console.log(Array.isArray(b));<span class="rem">//false</span>
</pre>
                    <p class="pcode">遍历对象的属性和值：</p>
                    <pre class="code">
var obj = { "name": "tony", "age": 24 };
for (var key in obj) console.log(key + ":" + obj[key]);
</pre>
                </dd>
                <dt id="api_ment">其它说明：</dt>
                <dd>
                    <ul class="decoration">
                        <li>确保系统运行于IIS集成模式，经典模式可能导致接口调用失败。</li>
                        <li>本系统中的页面，可直接（以当前登录身份）调用 API 接口。</li>
                        <li>建议为本系统配置使用HTTPS协议，以提高数据传输安全性。<a href="https://www.west.cn/faq/list.asp?unid=1215" target="_blank">了解更多…</a></li>
                    </ul>
                </dd>
            </dl>
        </asp:Panel>
        <asp:Panel ID="three" Visible="false" runat="server">
            <dl>
                <dt>三分钟入门</dt>
                <dd class="mbottom_l">
                    <p>系统的管理功能是基于模板来实现的，模板规定了要管理哪些内容，如联系人，有姓名、电话、地址等字段。下面通过一个实例，来看看如何创建模板并进行管理。</p>
                    <p>假设，一个服装经销商，要管理服装的基本信息及其进销存数据，那么，先进入"设计中心"，在空白处点右键"添加模板"，输入模板名称"服装"：</p>
                    <p class="v_top"><img src="images/help/addTemplet1.png" align="absBottom" />　→　<img src="images/help/addTemplet2.png" align="absBottom" /></p><br />
                    <p>然后会自动进入设计界面，点"添加字段"，输入字段名称"商品代号"，点确定，就添加了一个字段；接着继续添加名称、品牌、尺码、图片、类别等字段，就完成了模板的设计。</p>
                    <p><img src="images/help/design.png" /></p><br />
                    <p>接着，创建模板"进销存记录"，添加商品代号、出入库数量（出库时填负数）、时间等字段。</p>
                    <p>后面的事情就更简单了。要添加服装？可从左侧栏导航区进入，或从数据中心模板右键菜单来添加：</p>
                    <p class="v_top"><img src="images/help/addData.png" />　　<img src="images/help/dataAdmin.png" /></p><br />
                    <p><img src="images/help/edit.png" /></p><br />
                    <p>要浏览或搜索数据？可以从左侧栏导航区，或数据中心右键菜单中操作。下图是浏览时的缩略视图（可在左侧栏切换表格视图、报表视图等）：</p>
                    <p><img src="images/help/viewObj.png" /></p>
                    <p>现在，您已经入门了。不过，为了管理起来更轻松愉快，我们还可以作些改进：</p>
                </dd>
                <dt>五分钟提高</dt>
                <dd>
                    <ul class="decoration" style="margin-left:0">
                        <li>为进销存记录的"商品代号"字段添加"输入提示"功能，以便录入时可从已有的商品代号中选择而不用输入：
                            <div><img src="images/help/advance.png" /></div>
                        </li>
                        <li>为服装模板添加"库存量"字段，数据类型为"查询"。这样，在浏览服装时，就可以看到其实时库存：
                            <div><img src="images/help/query.png" /></div>
                        </li>
                        <li>进入设计中心，在模板上点右键 - 设置，设置默认视图、默认目录等选项：
                            <div><img src="images/help/attribute.png" /></div>
                        </li>
                        <li>
                            如果要让其他人管理或查看数据，需设置权限。权限是设置给角色（即不同的用户组）的，用户设为哪个角色就具有哪个角色的权限。建立角色和用户后，在设计中心，模板右键 - 权限，可选择角色并指定权限：
                            <div><img src="images/help/templetPower.png" /></div>
                        </li>
                    </ul>
                    <p>至此，用户就可以用电脑或手机登录操作了。当然，您可以继续发挥DIY精神，来增加和优化设计。至于系统中的版式、统计图表、自定义操作、流程、提醒、微信接入、自动化功能等更多精彩，您应该很快就能体验了。</p>
                    <p>现在，就<a href="#" onclick="to('templets.aspx');">进入设计中心</a>大胆尝试吧！</p>
                </dd>
            </dl>
        </asp:Panel>
        </div>
	    <script src="js/comm.js"></script><script src="js/help.js"></script>
    </form>
</body>
</html>