--[[
 *******************************************************************************
 * Utility functions
 *******************************************************************************
--]]

function showVarsAsHTML()
  local Result = "";
  for k,v in pairs(Vars) do Result = Result .. "<B>" .. k .. "</B>=" .. v .. "<BR>" end
  return Result;
end

function appendIfExists(aValue, aSuffix)
  if (aValue ~= "") then
    return aValue .. aSuffix;
  else
    return ""
  end
end

function divideIfExists(aSize, aDividend) 
  if (aSize ~= "") then
    return (aSize / aDividend) .. " k"
  else
    return ""
  end
end

function bitRate(aBitRate)
  return divideIfExists(aBitRate, 1000);
end

function audioFrequency(aFreq)
  return divideIfExists(aFreq, 1000);
end

function timeString(aTime)
  local RemTime = 1 * aTime;
  local Seconds = RemTime % 60;
  local Result = string.format("%i ", Seconds);
  if (Seconds == 1) then
    Result = Result .. expand("Generic.Second");
  else
    Result = Result .. expand("Generic.Seconds");
  end
  local Minutes = 1 * string.format("%i", RemTime / 60);
  if (Minutes > 0) then
	  if (Minutes == 1) then
	    Result = Minutes .. " " .. expand("Generic.Minute") .. " " .. Result;
	  else
	    Result = Minutes .. " " .. expand("Generic.Minutes") .. " " .. Result;
	  end
	end
  return Result;
end

function sizeString(aSize)
  local Size = 1 * aSize;
  local Suffixes = { "B", "kB", "MB", "GB", "TB", "PB" };
  local Index = 1;
  while ((Size > 1000) and (Index < 6)) do
    Index = Index + 1;
    Size = Size / 1000;
  end
  local n1, n2 = math.modf(Size * 10);
  return (n1 / 10) .. " " .. Suffixes[Index];
end

function listOrDefault(aValue, aList)
  for i in string.gmatch(aList, "%S+") do
    if i == (aValue .. "") then
      return aValue
    end
  end
  return "Default"
end


--[[
 *******************************************************************************
 * Storage device functions
 *******************************************************************************
--]]

function logicalStorageDeviceLine1()
  return "Not Implemented";
end

function logicalStorageDeviceLine2()
  if (Vars.Ready == "true") then
  	return sizeString(Vars.BlockSize * Vars.BlockCount);
 	else
 		return "Not Ready";
 	end
end



function physicalStorageDeviceLine1()
  local Result = "";
  if (Vars.HardwareVendor ~= "") then
    Result = Result .. Vars.HardwareVendor .. " ";
  end
  if (Vars.HardwareModel ~= "") then
    Result = Result .. Vars.HardwareModel .. " ";
  end
  if (Vars.HardwareSerial ~= "") then
    Result = Result .. Vars.HardwareSerial .. " ";
  end
  return Result;
end

function physicalStorageDeviceLine2()
  if (Vars.Ready == "true") then
  	return sizeString(Vars.BlockSize * Vars.BlockCount);
 	else
 		return "Not Ready";
 	end
end


function storageDeviceLine1()
  if (Vars.DeviceClass == "dcLogicalDevice") then
  	return logicalStorageDeviceLine1();
  else
  	return physicalStorageDeviceLine1();
  end
end

function storageDeviceLine2()
  if (Vars.DeviceClass == "dcLogicalDevice") then
  	return logicalStorageDeviceLine2();
  else
  	return physicalStorageDeviceLine2();
  end
end


function physicalStorageDeviceInfo() 
  return showVarsAsHTML();
end

function logicalStorageDeviceInfo() 
  return showVarsAsHTML();
end

function storageDeviceInfo() 
  if (Vars.DeviceClass == "dcLogicalDevice") then
  	return logicalStorageDeviceInfo();
  else
  	return physicalStorageDeviceInfo();
  end
end


