/*
 * Decompiled with CFR 0.152.
 */
package layaair.game.device;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class DevID {
    protected Context m_Context;

    public DevID(Context context) {
        this.m_Context = context;
    }

    public String GetAnUniqueID() {
        String string = this.GetDevSerial();
        if (string != null && string.length() > 0) {
            return string;
        }
        string = this.GetWifiMac();
        if (string != null && string.length() > 0) {
            return string.replace(":", "");
        }
        string = this.GetAndroidID();
        if (string != null && string.length() > 0) {
            return string;
        }
        return this.GetMyUniqueID();
    }

    public String GetIMEI() {
        String string = "phone";
        string = (TelephonyManager)this.m_Context.getSystemService(string);
        String string2 = "UnKnow";
        if (string != null) {
            try {
                string2 = string.getDeviceId();
            }
            catch (Exception exception) {
                Log.e((String)"LayaBox", (String)exception.toString());
            }
            catch (Throwable throwable) {
                Log.e((String)"LayaBox", (String)throwable.toString());
            }
        }
        return string2;
    }

    public String GetIMSI() {
        String string = "phone";
        if ((string = (TelephonyManager)this.m_Context.getSystemService(string)) != null) {
            String string2 = null;
            try {
                string2 = string.getSubscriberId();
            }
            catch (SecurityException securityException) {
                Log.e((String)"LayaBox", (String)securityException.toString());
            }
            return string2;
        }
        return null;
    }

    public static String getIMSI_1() {
        String string = DevID.runCommand("service call iphonesubinfo 3");
        string = DevID.getNumberFromParcel(string);
        Log.d((String)"laya", (String)("IMSI_1:" + string));
        return string;
    }

    public static String getIMSI_2() {
        String string = DevID.runCommand("service call iphonesubinfo2 3");
        string = DevID.getNumberFromParcel(string);
        Log.d((String)"laya", (String)("IMSI_2:" + string));
        return string;
    }

    public static String runCommand(String object) {
        try {
            int n2;
            object = Runtime.getRuntime().exec((String)object);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
            char[] cArray = new char[2048];
            StringBuilder stringBuilder = new StringBuilder();
            while ((n2 = bufferedReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n2);
            }
            bufferedReader.close();
            ((Process)object).waitFor();
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            Log.e((String)"apipas", (String)("IOException:" + iOException.getMessage()));
            return null;
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"apipas", (String)("InterruptedException:" + interruptedException.getMessage()));
            return null;
        }
    }

    public static String getNumberFromParcel(String stringArray) {
        String string = "";
        if (stringArray != null && stringArray.length() > 0) {
            String[] stringArray2 = stringArray.split("\n");
            stringArray = stringArray2;
            stringArray = stringArray2;
            int n2 = stringArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String[] stringArray3 = stringArray[i2];
                if (stringArray3 == null || stringArray3.length() == 0 || (stringArray3 = stringArray3.split("'")).length <= 1) continue;
                string = string + stringArray3[1].replace(".", "");
            }
        } else {
            return "NA";
        }
        return string;
    }

    public String GetWifiMac() {
        String string = DevID.getMac();
        return string;
    }

    private static String parseByte(byte by) {
        String string = "00" + Integer.toHexString(by) + ":";
        return string.substring(string.length() - 3);
    }

    @SuppressLint(value={"NewApi"})
    public static final String getMac() {
        Object object;
        byte[] byArray = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            object = NetworkInterface.getNetworkInterfaces();
            block2: while (object.hasMoreElements()) {
                NetworkInterface networkInterface = (NetworkInterface)object.nextElement();
                Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress = enumeration.nextElement();
                    if (inetAddress.isAnyLocalAddress() || !(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                    if (inetAddress.isSiteLocalAddress()) {
                        byArray = networkInterface.getHardwareAddress();
                        continue;
                    }
                    if (inetAddress.isLinkLocalAddress()) continue;
                    byArray = networkInterface.getHardwareAddress();
                    continue block2;
                }
            }
        }
        catch (SocketException socketException) {
            object = socketException;
            socketException.printStackTrace();
        }
        if (byArray != null) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                stringBuffer.append(DevID.parseByte((byte)byArray[i2]));
            }
            return stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        return null;
    }

    public String GetDevSerial() {
        return "";
    }

    public String GetAndroidID() {
        return Settings.Secure.getString((ContentResolver)this.m_Context.getContentResolver(), (String)"android_id");
    }

    public String GetMyUniqueID() {
        return "UNKNOWN";
    }

    public String GenARandomID() {
        return "";
    }

    public String GetPhoneModelAndSDK() {
        return Build.MODEL;
    }

    public String GetOSVersion() {
        return Build.VERSION.RELEASE;
    }

    public int[] GetResolutionArray() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)this.m_Context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return new int[]{displayMetrics.widthPixels, displayMetrics.heightPixels, displayMetrics.densityDpi};
    }
}

