/*
 * Decompiled with CFR 0.152.
 */
package layaair.game.utility;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.os.Build;
import android.os.Debug;
import android.os.Process;
import android.util.Log;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class ProcessInfo {
    static long mnLastTotalCpu = 0L;
    static long mnLastAppCpu = 0L;
    static String TAG = "PROCESSINFO";
    static ActivityManager sAM = null;
    static long mWorkCpuTm = 0L;
    static long mLastWorkCpuTm = 0L;

    public static void init(ActivityManager activityManager) {
        sAM = activityManager;
    }

    public static void uninit() {
        sAM = null;
    }

    public static long getTotalMemoryOld() {
        Object object = "/proc/meminfo";
        try {
            String[] stringArray;
            object = new FileReader((String)object);
            BufferedReader bufferedReader = new BufferedReader((Reader)object, 8192);
            object = bufferedReader.readLine();
            String[] stringArray2 = stringArray = ((String)object).split("\\s+");
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray2[i2];
                Log.i((String)object, (String)(string + "\t"));
            }
            long l2 = Integer.valueOf(stringArray[1]).intValue();
            bufferedReader.close();
            return l2;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @SuppressLint(value={"NewApi"})
    public static float getTotalMem() {
        if (Build.VERSION.SDK_INT < 16) {
            return ProcessInfo.getTotalMemoryOld();
        }
        if (sAM == null) {
            return 0.0f;
        }
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        sAM.getMemoryInfo(memoryInfo);
        float f2 = (float)memoryInfo.totalMem / 1024.0f;
        Log.i((String)"", (String)("total:" + f2));
        return f2;
    }

    public static float getAvalidMem() {
        if (sAM == null) {
            return 0.0f;
        }
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        sAM.getMemoryInfo(memoryInfo);
        float f2 = (float)memoryInfo.availMem / 1024.0f;
        return f2;
    }

    public static float getUsedMem() {
        if (sAM == null) {
            return 0.0f;
        }
        int n2 = Process.myPid();
        Debug.MemoryInfo[] memoryInfoArray = sAM.getProcessMemoryInfo(new int[]{n2});
        float f2 = memoryInfoArray[0].getTotalPrivateDirty();
        Log.d((String)TAG, (String)("\u5360\u7528\u5185\u5b58\uff1a" + f2));
        return f2;
    }

    public static int GetFPS() {
        return 0;
    }

    public static float getProcessCpuRate1() {
        float f2;
        long l2 = ProcessInfo.getTotalCpuTime();
        long l3 = ProcessInfo.getAppCpuTime();
        long l4 = l3 - mnLastAppCpu;
        long l5 = l2 - mnLastTotalCpu;
        float f3 = (float)((double)l4 / (double)l5);
        if (f2 > 1.0f) {
            Log.e((String)"", (String)("app:" + l4 + ",total:" + l5));
        }
        mnLastAppCpu = l3;
        mnLastTotalCpu = l2;
        return f3;
    }

    public static float getProcessCpuRate() {
        long l2 = ProcessInfo.getTotalCpuTime();
        long l3 = mWorkCpuTm - mLastWorkCpuTm;
        long l4 = l2 - mnLastTotalCpu;
        float f2 = (float)((double)l3 / (double)l4);
        mLastWorkCpuTm = mWorkCpuTm;
        mnLastTotalCpu = l2;
        return f2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean supportNeon() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/cpuinfo")), 1000);
            String string = bufferedReader.readLine();
            while (true) {
                if (string == null) {
                    bufferedReader.close();
                    return false;
                }
                if (string.startsWith("Features")) {
                    if (!string.contains("neon")) return false;
                    return true;
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        return false;
    }

    public static long getTotalCpuTime() {
        Object object;
        String[] stringArray = null;
        try {
            object = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/stat")), 1000);
            String string = ((BufferedReader)object).readLine();
            ((BufferedReader)object).close();
            stringArray = string.split(" ");
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
        }
        long l2 = Long.parseLong((String)stringArray[2]) + Long.parseLong((String)stringArray[3]) + Long.parseLong((String)stringArray[4]) + Long.parseLong(stringArray[7]) + Long.parseLong(stringArray[8]);
        long l3 = Long.parseLong(stringArray[6]) + Long.parseLong(stringArray[5]);
        mWorkCpuTm = l2;
        return l2 + l3;
    }

    public static long getAppCpuTime() {
        String[] stringArray = null;
        try {
            int n2 = Process.myPid();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/" + n2 + "/stat")), 1000);
            String string = bufferedReader.readLine();
            bufferedReader.close();
            stringArray = string.split(" ");
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        long l2 = Long.parseLong((String)stringArray[13]) + Long.parseLong((String)stringArray[14]) + Long.parseLong((String)stringArray[15]) + Long.parseLong((String)stringArray[16]);
        return l2;
    }
}

