
(function(window,document,Laya){
	var __un=Laya.un,__uns=Laya.uns,__static=Laya.static,__class=Laya.class,__getset=Laya.getset,__newvec=Laya.__newvec;

	var AnimationContent=laya.ani.AnimationContent,AnimationPlayer=laya.ani.AnimationPlayer,AnimationState=laya.ani.AnimationState;
	var AnimationTemplet=laya.ani.AnimationTemplet,Arith=laya.maths.Arith,AtlasResourceManager=laya.webgl.atlas.AtlasResourceManager;
	var BaseShader=laya.webgl.shader.BaseShader,Browser=laya.utils.Browser,Buffer=laya.webgl.utils.Buffer,Byte=laya.utils.Byte;
	var CacheAbleSkinMesh=laya.ani.bone.canvasmesh.CacheAbleSkinMesh,ClassUtils=laya.utils.ClassUtils,Config=Laya.Config;
	var Event=laya.events.Event,EventDispatcher=laya.events.EventDispatcher,Handler=laya.utils.Handler,Loader=laya.net.Loader;
	var LoaderManager=laya.net.LoaderManager,MathUtil=laya.maths.MathUtil,Node=laya.display.Node,Render=laya.renders.Render;
	var RenderContext=laya.renders.RenderContext,RenderSprite=laya.renders.RenderSprite,RenderState2D=laya.webgl.utils.RenderState2D;
	var Resource=laya.resource.Resource,RunDriver=laya.utils.RunDriver,Shader=laya.webgl.shader.Shader,ShaderCompile=laya.webgl.utils.ShaderCompile;
	var Sprite=laya.display.Sprite,Stat=laya.utils.Stat,StringKey=laya.utils.StringKey,Style=laya.display.css.Style;
	var Texture=laya.resource.Texture,URL=laya.net.URL,Utils=laya.utils.Utils,WebGL=laya.webgl.WebGL,WebGLContext=laya.webgl.WebGLContext;
	var WebGLContext2D=laya.webgl.canvas.WebGLContext2D;
Laya.interface('laya.d3.core.IClone');
Laya.interface('laya.d3.graphics.IVertex');
Laya.interface('laya.d3.core.render.IUpdate');
Laya.interface('laya.d3.core.scene.ITreeNode');
Laya.interface('laya.d3.core.render.IRenderable');
/**
*@private
*/
//class laya.d3.animation.AnimationClipParser01
var AnimationClipParser01=(function(){
	function AnimationClipParser01(){}
	__class(AnimationClipParser01,'laya.d3.animation.AnimationClipParser01');
	AnimationClipParser01.READ_DATA=function(){
		AnimationClipParser01._DATA.offset=AnimationClipParser01._reader.getUint32();
		AnimationClipParser01._DATA.size=AnimationClipParser01._reader.getUint32();
	}

	AnimationClipParser01.READ_BLOCK=function(){
		var count=AnimationClipParser01._BLOCK.count=AnimationClipParser01._reader.getUint16();
		var blockStarts=AnimationClipParser01._BLOCK.blockStarts=[];
		var blockLengths=AnimationClipParser01._BLOCK.blockLengths=[];
		for (var i=0;i < count;i++){
			blockStarts.push(AnimationClipParser01._reader.getUint32());
			blockLengths.push(AnimationClipParser01._reader.getUint32());
		}
	}

	AnimationClipParser01.READ_STRINGS=function(){
		var offset=AnimationClipParser01._reader.getUint32();
		var count=AnimationClipParser01._reader.getUint16();
		var prePos=AnimationClipParser01._reader.pos;
		AnimationClipParser01._reader.pos=offset+AnimationClipParser01._DATA.offset;
		for (var i=0;i < count;i++)
		AnimationClipParser01._strings[i]=AnimationClipParser01._reader.readUTFString();
		AnimationClipParser01._reader.pos=prePos;
	}

	AnimationClipParser01.parse=function(clip,reader){
		AnimationClipParser01._animationClip=clip;
		AnimationClipParser01._reader=reader;
		var arrayBuffer=reader.__getBuffer();
		AnimationClipParser01.READ_DATA();
		AnimationClipParser01.READ_BLOCK();
		AnimationClipParser01.READ_STRINGS();
		for (var i=0,n=AnimationClipParser01._BLOCK.count;i < n;i++){
			var index=reader.getUint16();
			var blockName=AnimationClipParser01._strings[index];
			var fn=AnimationClipParser01["READ_"+blockName];
			if (fn==null)
				throw new Error("model file err,no this function:"+index+" "+blockName);
			else
			fn.call();
		}
	}

	AnimationClipParser01.READ_ANIMATIONS=function(){
		var i=0,j=0;
		var node;
		var reader=AnimationClipParser01._reader;
		var buffer=reader.__getBuffer();
		var lengthTypes=[];
		var lenghthTypeCount=reader.getUint8();
		lengthTypes.length=lenghthTypeCount;
		for (i=0;i < lenghthTypeCount;i++)
		lengthTypes[i]=reader.getUint16();
		var startTimeTypes=[];
		var startTimeTypeCount=reader.getUint16();
		startTimeTypes.length=startTimeTypeCount;
		for (i=0;i < startTimeTypeCount;i++)
		startTimeTypes[i]=reader.getFloat32();
		var clip=AnimationClipParser01._animationClip;
		clip.name=AnimationClipParser01._strings[reader.getUint16()];
		var clipDur=clip._duration=reader.getFloat32();
		clip.islooping=!!reader.getByte();
		clip._frameRate=reader.getInt16();
		var nodeCount=reader.getInt16();
		var nodes=clip._nodes=new Array;
		nodes.length=nodeCount;
		var publicDatas=clip._publicClipDatas=[];
		publicDatas.length=nodeCount;
		var nodesMap=clip._nodesMap={};
		var cachePropertyToNodeIndex=0,unCachePropertyToNodeIndex=0;
		for (i=0;i < nodeCount;i++){
			node=nodes[i]=new KeyframeNode();
			var pathLength=reader.getUint16();
			var path=node.path=[];
			path.length=pathLength;
			for (j=0;j < pathLength;j++)
			path[j]=AnimationClipParser01._strings[reader.getUint16()];
			var nodePath=path.join("/");
			var mapArray=nodesMap[nodePath];
			(mapArray)|| (nodesMap[nodePath]=mapArray=[]);
			mapArray.push(node);
			var componentTypeStrIndex=reader.getInt16();
			(componentTypeStrIndex!==-1)&& (node.componentType=AnimationClipParser01._strings[componentTypeStrIndex]);
			var propertyNameID=AnimationNode._propertyIndexDic[AnimationClipParser01._strings[reader.getUint16()]];
			if (propertyNameID !=null){
				var isTransformProperty=propertyNameID < 4;
				var cacheProperty=!isTransformProperty || (isTransformProperty && path[0]==="");
				node._cacheProperty=cacheProperty;
				if (cacheProperty)
					cachePropertyToNodeIndex++;
				else
				unCachePropertyToNodeIndex++;
				node.propertyNameID=propertyNameID;
				}else {
				throw new Error("AnimationClipParser01:unknown property name.");
			};
			var dataLength=lengthTypes[reader.getUint8()];
			node.keyFrameWidth=dataLength / 4;
			var keyFrames=node.keyFrames=[];
			var keyframeCount=keyFrames.length=reader.getUint16();
			var lastKeyFrame=null;
			var startTime=NaN;
			for (j=0;j < keyframeCount;j++){
				var keyFrame=keyFrames[j]=new Keyframe();
				startTime=keyFrame.startTime=startTimeTypes[reader.getUint16()];
				var offset=reader.pos;
				keyFrame.inTangent=new Float32Array(buffer.slice(offset,offset+dataLength));
				reader.pos+=dataLength;
				offset=reader.pos;
				keyFrame.outTangent=new Float32Array(buffer.slice(offset,offset+dataLength));
				reader.pos+=dataLength;
				offset=reader.pos;
				keyFrame.data=new Float32Array(buffer.slice(offset,offset+dataLength));
				reader.pos+=dataLength;
				if (lastKeyFrame){
					lastKeyFrame.next=keyFrame;
					lastKeyFrame.duration=startTime-lastKeyFrame.startTime;
				}
				lastKeyFrame=keyFrame;
			}
			keyFrame.next=null;
			keyFrame.duration=clipDur-startTime;
		};
		var nodeToCachePropertyMap=clip._nodeToCachePropertyMap=new Int32Array(nodeCount);
		var cachePropertyToNodeMap=clip._cachePropertyMap=new Int32Array(cachePropertyToNodeIndex);
		var unCachePropertyToNodeMap=clip._unCachePropertyMap=new Int32Array(unCachePropertyToNodeIndex);
		cachePropertyToNodeIndex=unCachePropertyToNodeIndex=0;
		for (i=0;i < nodeCount;i++){
			node=nodes[i];
			if (node._cacheProperty){
				nodeToCachePropertyMap[i]=cachePropertyToNodeIndex;
				cachePropertyToNodeMap[cachePropertyToNodeIndex++]=i;
				}else {
				unCachePropertyToNodeMap[unCachePropertyToNodeIndex++]=i;
			}
		}
	}

	AnimationClipParser01._animationClip=null;
	AnimationClipParser01._reader=null;
	AnimationClipParser01._strings=[];
	__static(AnimationClipParser01,
	['_BLOCK',function(){return this._BLOCK={count:0};},'_DATA',function(){return this._DATA={offset:0,size:0};}
	]);
	return AnimationClipParser01;
})()


/**
*@private
*/
//class laya.d3.animation.AnimationClipParser02
var AnimationClipParser02=(function(){
	function AnimationClipParser02(){}
	__class(AnimationClipParser02,'laya.d3.animation.AnimationClipParser02');
	AnimationClipParser02.READ_DATA=function(){
		AnimationClipParser02._DATA.offset=AnimationClipParser02._reader.getUint32();
		AnimationClipParser02._DATA.size=AnimationClipParser02._reader.getUint32();
	}

	AnimationClipParser02.READ_BLOCK=function(){
		var count=AnimationClipParser02._BLOCK.count=AnimationClipParser02._reader.getUint16();
		var blockStarts=AnimationClipParser02._BLOCK.blockStarts=[];
		var blockLengths=AnimationClipParser02._BLOCK.blockLengths=[];
		for (var i=0;i < count;i++){
			blockStarts.push(AnimationClipParser02._reader.getUint32());
			blockLengths.push(AnimationClipParser02._reader.getUint32());
		}
	}

	AnimationClipParser02.READ_STRINGS=function(){
		var offset=AnimationClipParser02._reader.getUint32();
		var count=AnimationClipParser02._reader.getUint16();
		var prePos=AnimationClipParser02._reader.pos;
		AnimationClipParser02._reader.pos=offset+AnimationClipParser02._DATA.offset;
		for (var i=0;i < count;i++)
		AnimationClipParser02._strings[i]=AnimationClipParser02._reader.readUTFString();
		AnimationClipParser02._reader.pos=prePos;
	}

	AnimationClipParser02.parse=function(clip,reader){
		AnimationClipParser02._animationClip=clip;
		AnimationClipParser02._reader=reader;
		var arrayBuffer=reader.__getBuffer();
		AnimationClipParser02.READ_DATA();
		AnimationClipParser02.READ_BLOCK();
		AnimationClipParser02.READ_STRINGS();
		for (var i=0,n=AnimationClipParser02._BLOCK.count;i < n;i++){
			var index=reader.getUint16();
			var blockName=AnimationClipParser02._strings[index];
			var fn=AnimationClipParser02["READ_"+blockName];
			if (fn==null)
				throw new Error("model file err,no this function:"+index+" "+blockName);
			else
			fn.call();
		}
	}

	AnimationClipParser02.READ_ANIMATIONS=function(){
		var i=0,j=0;
		var node;
		var reader=AnimationClipParser02._reader;
		var buffer=reader.__getBuffer();
		var lengthTypes=[];
		var lenghthTypeCount=reader.getUint8();
		lengthTypes.length=lenghthTypeCount;
		for (i=0;i < lenghthTypeCount;i++)
		lengthTypes[i]=reader.getUint16();
		var startTimeTypes=[];
		var startTimeTypeCount=reader.getUint16();
		startTimeTypes.length=startTimeTypeCount;
		for (i=0;i < startTimeTypeCount;i++)
		startTimeTypes[i]=reader.getFloat32();
		var clip=AnimationClipParser02._animationClip;
		clip.name=AnimationClipParser02._strings[reader.getUint16()];
		var clipDur=clip._duration=reader.getFloat32();
		clip.islooping=!!reader.getByte();
		clip._frameRate=reader.getInt16();
		var nodeCount=reader.getInt16();
		var nodes=clip._nodes=new Array;
		nodes.length=nodeCount;
		var publicDatas=clip._publicClipDatas=[];
		publicDatas.length=nodeCount;
		var nodesMap=clip._nodesMap={};
		var cachePropertyToNodeIndex=0,unCachePropertyToNodeIndex=0;
		for (i=0;i < nodeCount;i++){
			node=nodes[i]=new KeyframeNode();
			var pathLength=reader.getUint16();
			var path=node.path=[];
			path.length=pathLength;
			for (j=0;j < pathLength;j++)
			path[j]=AnimationClipParser02._strings[reader.getUint16()];
			var nodePath=path.join("/");
			var mapArray=nodesMap[nodePath];
			(mapArray)|| (nodesMap[nodePath]=mapArray=[]);
			mapArray.push(node);
			var componentTypeStrIndex=reader.getInt16();
			(componentTypeStrIndex!==-1)&& (node.componentType=AnimationClipParser02._strings[componentTypeStrIndex]);
			var propertyNameID=AnimationNode._propertyIndexDic[AnimationClipParser02._strings[reader.getUint16()]];
			if (propertyNameID !=null){
				var isTransformProperty=propertyNameID < 4;
				var cacheProperty=!isTransformProperty || (isTransformProperty && path[0]==="");
				node._cacheProperty=cacheProperty;
				if (cacheProperty)
					cachePropertyToNodeIndex++;
				else
				unCachePropertyToNodeIndex++;
				node.propertyNameID=propertyNameID;
				}else {
				throw new Error("AnimationClipParser02:unknown property name.");
			};
			var dataLength=lengthTypes[reader.getUint8()];
			node.keyFrameWidth=dataLength / 4;
			var keyFrames=node.keyFrames=[];
			var keyframeCount=keyFrames.length=reader.getUint16();
			var lastKeyFrame=null;
			var startTime=NaN;
			for (j=0;j < keyframeCount;j++){
				var keyFrame=keyFrames[j]=new Keyframe();
				startTime=keyFrame.startTime=startTimeTypes[reader.getUint16()];
				var offset=reader.pos;
				keyFrame.inTangent=new Float32Array(buffer.slice(offset,offset+dataLength));
				reader.pos+=dataLength;
				offset=reader.pos;
				keyFrame.outTangent=new Float32Array(buffer.slice(offset,offset+dataLength));
				reader.pos+=dataLength;
				offset=reader.pos;
				keyFrame.data=new Float32Array(buffer.slice(offset,offset+dataLength));
				reader.pos+=dataLength;
				if (lastKeyFrame){
					lastKeyFrame.next=keyFrame;
					lastKeyFrame.duration=startTime-lastKeyFrame.startTime;
				}
				lastKeyFrame=keyFrame;
			}
			keyFrame.next=null;
			keyFrame.duration=clipDur-startTime;
		};
		var eventCount=reader.getUint16();
		for (i=0;i < eventCount;i++){
			var event=new AnimationEvent();
			event.time=reader.getFloat32();
			event.eventName=AnimationClipParser02._strings[reader.getUint16()];
			var params;
			var paramCount=reader.getUint16();
			(paramCount > 0)&& (event.params=params=[]);
			for (j=0;j < paramCount;j++){
				var type=reader.getByte();
				switch (type){
					case 0:
						params.push(!!reader.getByte());
						break ;
					case 1:
						params.push(reader.getInt32());
						break ;
					case 2:
						params.push(reader.getFloat32());
						break ;
					case 3:
						params.push(AnimationClipParser02._strings[reader.getUint16()]);
						break ;
					default :
						throw new Error("unknown type.");
					}
			}
			clip.addEvent(event);
		};
		var nodeToCachePropertyMap=clip._nodeToCachePropertyMap=new Int32Array(nodeCount);
		var cachePropertyToNodeMap=clip._cachePropertyMap=new Int32Array(cachePropertyToNodeIndex);
		var unCachePropertyToNodeMap=clip._unCachePropertyMap=new Int32Array(unCachePropertyToNodeIndex);
		cachePropertyToNodeIndex=unCachePropertyToNodeIndex=0;
		for (i=0;i < nodeCount;i++){
			node=nodes[i];
			if (node._cacheProperty){
				nodeToCachePropertyMap[i]=cachePropertyToNodeIndex;
				cachePropertyToNodeMap[cachePropertyToNodeIndex++]=i;
				}else {
				unCachePropertyToNodeMap[unCachePropertyToNodeIndex++]=i;
			}
		}
	}

	AnimationClipParser02._animationClip=null;
	AnimationClipParser02._reader=null;
	AnimationClipParser02._strings=[];
	__static(AnimationClipParser02,
	['_BLOCK',function(){return this._BLOCK={count:0};},'_DATA',function(){return this._DATA={offset:0,size:0};}
	]);
	return AnimationClipParser02;
})()


/**
*<code>AnimationEvent</code> 类用于实现动画事件。
*/
//class laya.d3.animation.AnimationEvent
var AnimationEvent=(function(){
	function AnimationEvent(){
		/**事件触发时间。*/
		this.time=NaN;
		/**事件触发名称。*/
		this.eventName=null;
		/**事件触发参数。*/
		this.params=null;
	}

	__class(AnimationEvent,'laya.d3.animation.AnimationEvent');
	return AnimationEvent;
})()


/**
*<code>BoneNode</code> 类用于实现骨骼节点。
*/
//class laya.d3.animation.AnimationNode
var AnimationNode=(function(){
	function AnimationNode(){
		/**@private */
		//this._childs=null;
		/**@private */
		//this._parent=null;
		/**@private [只读]*/
		//this.transform=null;
		/**节点名称。 */
		//this.name=null;
		this._childs=[];
		this.transform=new AnimationTransform3D(this);
	}

	__class(AnimationNode,'laya.d3.animation.AnimationNode');
	var __proto=AnimationNode.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*添加子节点。
	*@param child 子节点。
	*/
	__proto.addChild=function(child){
		child._parent=this;
		child.transform.setParent(this.transform);
		this._childs.push(child);
	}

	/**
	*移除子节点。
	*@param child 子节点。
	*/
	__proto.removeChild=function(child){
		var index=this._childs.indexOf(child);
		(index!==-1)&& (this._childs.splice(index,1));
	}

	/**
	*根据名字获取子节点。
	*@param name 名字。
	*/
	__proto.getChildByName=function(name){
		for (var i=0,n=this._childs.length;i < n;i++){
			var child=this._childs[i];
			if (child.name===name)
				return child;
		}
		return null;
	}

	/**
	*根据索引获取子节点。
	*@param index 索引。
	*/
	__proto.getChildByIndex=function(index){
		return this._childs[index];
	}

	/**
	*获取子节点的个数。
	*/
	__proto.getChildCount=function(){
		return this._childs.length;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destNode=destObject;
		destNode.name=this.name;
		for (var i=0,n=this._childs.length;i < n;i++){
			var child=this._childs[i];
			var destChild=child.clone();
			destNode.addChild(destChild);
			var transform=child.transform;
			var destTransform=destChild.transform;
			destTransform.setLocalPosition(transform.getLocalPosition());
			destTransform.setLocalRotation(transform.getLocalRotation());
			destTransform.setLocalScale(transform.getLocalScale());
			destTransform._localRotationEuler=transform._localRotationEuler;
			destTransform._setWorldMatrixIgnoreUpdate(transform.getWorldMatrix());
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	AnimationNode.__init__=function(){
		AnimationNode.registerAnimationNodeProperty("localPosition",AnimationNode._getLocalPosition,AnimationNode._setLocalPosition);
		AnimationNode.registerAnimationNodeProperty("localRotation",AnimationNode._getLocalRotation,AnimationNode._setLocalRotation);
		AnimationNode.registerAnimationNodeProperty("localScale",AnimationNode._getLocalScale,AnimationNode._setLocalScale);
		AnimationNode.registerAnimationNodeProperty("localRotationEuler",AnimationNode._getLocalRotationEuler,AnimationNode._setLocalRotationEuler);
		AnimationNode.registerAnimationNodeProperty("particleRender.sharedMaterial.tintColor",AnimationNode._getParticleRenderSharedMaterialTintColor,AnimationNode._setParticleRenderSharedMaterialTintColor);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.tilingOffset",AnimationNode._getMeshRenderSharedMaterialTilingOffset,AnimationNode._setMeshRenderSharedMaterialTilingOffset);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.albedoColor",AnimationNode._getMeshRenderSharedMaterialAlbedo,AnimationNode._setMeshRenderSharedMaterialAlbedo);
		AnimationNode.registerAnimationNodeProperty("skinnedMeshRender.sharedMaterial.tilingOffset",AnimationNode._getSkinnedMeshRenderSharedMaterialTilingOffset,AnimationNode._setSkinnedMeshRenderSharedMaterialTilingOffset);
		AnimationNode.registerAnimationNodeProperty("skinnedMeshRender.sharedMaterial.albedoColor",AnimationNode._getSkinnedMeshRenderSharedMaterialAlbedo,AnimationNode._setSkinnedMeshRenderSharedMaterialAlbedo);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.albedo",AnimationNode._getMeshRenderSharedMaterialAlbedo,AnimationNode._setMeshRenderSharedMaterialAlbedo);
		AnimationNode.registerAnimationNodeProperty("skinnedMeshRender.sharedMaterial.albedo",AnimationNode._getSkinnedMeshRenderSharedMaterialAlbedo,AnimationNode._setSkinnedMeshRenderSharedMaterialAlbedo);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.intensity",AnimationNode._getMeshRenderSharedMaterialIntensity,AnimationNode._setMeshRenderSharedMaterialIntensity);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.alpha",AnimationNode._getMeshRenderSharedMaterialAlpha,AnimationNode._setMeshRenderSharedMaterialAlpha);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.alphaColor",AnimationNode._getMeshRenderSharedMaterialAlphaColor,AnimationNode._setMeshRenderSharedMaterialAlphaColor);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.baseColor",AnimationNode._getMeshRenderSharedMaterialBaseColor,AnimationNode._setMeshRenderSharedMaterialBaseColor);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.dissolve",AnimationNode._getMeshRenderSharedMaterialDissolve,AnimationNode._setMeshRenderSharedMaterialDissolve);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.dissolveSpeed",AnimationNode._getMeshRenderSharedMaterialDissolveSpeed,AnimationNode._setMeshRenderSharedMaterialDissolveSpeed);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.mMultiplier",AnimationNode._getMeshRenderSharedMaterialMMultiplier,AnimationNode._setMeshRenderSharedMaterialMMultiplier);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.baseScrollSpeedX",AnimationNode._getMeshRenderSharedMaterialBaseScrollSpeedX,AnimationNode._setMeshRenderSharedMaterialBaseScrollSpeedX);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.baseScrollSpeedY",AnimationNode._getMeshRenderSharedMaterialBaseScrollSpeedY,AnimationNode._setMeshRenderSharedMaterialBaseScrollSpeedY);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.secondScrollSpeedX",AnimationNode._getMeshRenderSharedMaterialSecondScrollSpeedX,AnimationNode._setMeshRenderSharedMaterialSecondScrollSpeedX);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.secondScrollSpeedY",AnimationNode._getMeshRenderSharedMaterialSecondScrollSpeedY,AnimationNode._setMeshRenderSharedMaterialSecondScrollSpeedY);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.detailTilingOffset",AnimationNode._getMeshRenderSharedMaterialDetailTilingOffset,AnimationNode._setMeshRenderSharedMaterialDetailTilingOffset);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.dissolveTilingOffset",AnimationNode._getMeshRenderSharedMaterialDissolveTilingOffset,AnimationNode._setMeshRenderSharedMaterialDissolveTilingOffset);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.maskTilingOffset",AnimationNode._getMeshRenderSharedMaterialMaskTilingOffset,AnimationNode._setMeshRenderSharedMaterialMaskTilingOffset);
	}

	AnimationNode.registerAnimationNodeProperty=function(propertyName,getFunc,setFunc){
		if (AnimationNode._propertyIndexDic[propertyName]){
			throw new Error("AnimationNode: this propertyName has registered.");
			}else {
			AnimationNode._propertyIndexDic[propertyName]=AnimationNode._propertyIDCounter;
			AnimationNode._propertyGetFuncs[AnimationNode._propertyIDCounter]=getFunc;
			AnimationNode._propertySetFuncs[AnimationNode._propertyIDCounter]=setFunc;
			AnimationNode._propertyIDCounter++;
		}
	}

	AnimationNode._getLocalPosition=function(animationNode,sprite3D){
		if (animationNode)
			return animationNode.transform.getLocalPosition();
		else
		return sprite3D._transform.localPosition.elements;
	}

	AnimationNode._setLocalPosition=function(animationNode,sprite3D,value){
		if (animationNode){
			animationNode.transform.setLocalPosition(value);
			}else {
			var spriteTransform=sprite3D._transform;
			var localPosition=spriteTransform.localPosition;
			localPosition.elements=value;
			spriteTransform.localPosition=localPosition;
		}
	}

	AnimationNode._getLocalRotation=function(animationNode,sprite3D){
		if (animationNode)
			return animationNode.transform.getLocalRotation();
		else
		return sprite3D._transform.localRotation.elements;
	}

	AnimationNode._setLocalRotation=function(animationNode,sprite3D,value){
		if (animationNode){
			animationNode.transform.setLocalRotation(value);
			}else {
			var spriteTransform=sprite3D._transform;
			var localRotation=spriteTransform.localRotation;
			localRotation.elements=value;
			spriteTransform.localRotation=localRotation;
		}
	}

	AnimationNode._getLocalScale=function(animationNode,sprite3D){
		if (animationNode)
			return animationNode.transform.getLocalScale();
		else
		return sprite3D._transform.localScale.elements;
	}

	AnimationNode._setLocalScale=function(animationNode,sprite3D,value){
		if (animationNode){
			animationNode.transform.setLocalScale(value);
			}else {
			var spriteTransform=sprite3D._transform;
			var localScale=spriteTransform.localScale;
			localScale.elements=value;
			spriteTransform.localScale=localScale;
		}
	}

	AnimationNode._getLocalRotationEuler=function(animationNode,sprite3D){
		if (animationNode)
			return animationNode.transform.getLocalRotationEuler();
		else
		return sprite3D._transform.localRotationEuler.elements;
	}

	AnimationNode._setLocalRotationEuler=function(animationNode,sprite3D,value){
		if (animationNode){
			animationNode.transform.setLocalRotationEuler(value);
			}else {
			var spriteTransform=sprite3D._transform;
			var localRotationEuler=spriteTransform.localRotationEuler;
			localRotationEuler.elements=value;
			spriteTransform.localRotationEuler=localRotationEuler;
		}
	}

	AnimationNode._getMeshRenderSharedMaterialTilingOffset=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.tilingOffset.elements;
			}else
			return null;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.tilingOffset.elements;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialTilingOffset=function(animationNode,sprite3D,value){
		var material,tilingOffset;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				tilingOffset=material.tilingOffset;
				tilingOffset.elements=value;
				material.tilingOffset=tilingOffset;
			}
			}else {
			material=(sprite3D).meshRender.material;
			tilingOffset=material.tilingOffset;
			tilingOffset.elements=value;
			material.tilingOffset=tilingOffset;
		}
	}

	AnimationNode._getMeshRenderSharedMaterialAlbedo=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.albedoColor.elements;
			}else
			return null;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.albedoColor.elements;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialAlbedo=function(animationNode,sprite3D,value){
		var material,albedo;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				albedo=material.albedoColor;
				albedo.elements=value;
				material.albedoColor=albedo;
			}
			}else {
			material=(sprite3D).meshRender.material;
			albedo=material.albedoColor;
			albedo.elements=value;
			material.albedoColor=albedo;
		}
	}

	AnimationNode._getSkinnedMeshRenderSharedMaterialTilingOffset=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).skinnedMeshRender.sharedMaterial;
				return material.tilingOffset.elements;
			}else
			return null;
			}else {
			material=(sprite3D).skinnedMeshRender.sharedMaterial;
			return material.tilingOffset.elements;
		}
	}

	AnimationNode._setSkinnedMeshRenderSharedMaterialTilingOffset=function(animationNode,sprite3D,value){
		var material,tilingOffset;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).skinnedMeshRender.material;
				tilingOffset=material.tilingOffset;
				tilingOffset.elements=value;
				material.tilingOffset=tilingOffset;
			}
			}else {
			material=(sprite3D).skinnedMeshRender.material;
			tilingOffset=material.tilingOffset;
			tilingOffset.elements=value;
			material.tilingOffset=tilingOffset;
		}
	}

	AnimationNode._getSkinnedMeshRenderSharedMaterialAlbedo=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).skinnedMeshRender.sharedMaterial;
				return material.albedoColor.elements;
				}else {
				return null;
			}
			}else {
			material=(sprite3D).skinnedMeshRender.sharedMaterial;
			return material.albedoColor.elements;
		}
	}

	AnimationNode._setSkinnedMeshRenderSharedMaterialAlbedo=function(animationNode,sprite3D,value){
		var material,albedo;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).skinnedMeshRender.material;
				albedo=material.albedoColor;
				albedo.elements=value;
				material.albedoColor=albedo;
			}
			}else {
			material=(sprite3D).skinnedMeshRender.material;
			albedo=material.albedoColor;
			albedo.elements=value;
			material.albedoColor=albedo;
		}
	}

	AnimationNode._getParticleRenderSharedMaterialTintColor=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).particleRender.sharedMaterial;
				return material.tintColor.elements;
			}else
			return null;
			}else {
			material=(sprite3D).particleRender.sharedMaterial;
			return material.tintColor.elements;
		}
	}

	AnimationNode._setParticleRenderSharedMaterialTintColor=function(animationNode,sprite3D,value){
		var material,tintColor;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).particleRender.material;
				tintColor=material.tintColor;
				tintColor.elements=value;
				material.tintColor=tintColor;
			}
			}else {
			material=(sprite3D).particleRender.material;
			tintColor=material.tintColor;
			tintColor.elements=value;
			material.tintColor=tintColor;
		}
	}

	AnimationNode._getMeshRenderSharedMaterialAlphaColor=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.alphaColor.elements;
			}else
			return null;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.alphaColor.elements;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialAlphaColor=function(animationNode,sprite3D,value){
		var material,alphaColor;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				alphaColor=material.alphaColor;
				alphaColor.elements=value;
				material.alphaColor=alphaColor;
			}
			}else {
			material=(sprite3D).meshRender.material;
			alphaColor=material.alphaColor;
			alphaColor.elements=value;
			material.alphaColor=alphaColor;
		}
	}

	AnimationNode._getMeshRenderSharedMaterialBaseColor=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.baseColor.elements;
			}else
			return null;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.baseColor.elements;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialBaseColor=function(animationNode,sprite3D,value){
		var material,baseColor;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				baseColor=material.baseColor;
				baseColor.elements=value;
				material.baseColor=baseColor;
			}
			}else {
			material=(sprite3D).meshRender.material;
			baseColor=material.baseColor;
			baseColor.elements=value;
			material.baseColor=baseColor;
		}
	}

	AnimationNode._getMeshRenderSharedMaterialDissolve=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.dissolve;
			}else
			return 0.0;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.dissolve;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialDissolve=function(animationNode,sprite3D,value){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				material.dissolve=value[0];
			}
			}else {
			material=(sprite3D).meshRender.material;
			material.dissolve=value[0];
		}
	}

	AnimationNode._getMeshRenderSharedMaterialDissolveSpeed=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.dissolveSpeed;
			}else
			return 0.0;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.dissolveSpeed;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialDissolveSpeed=function(animationNode,sprite3D,value){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				material.dissolveSpeed=value[0];
			}
			}else {
			material=(sprite3D).meshRender.material;
			material.dissolveSpeed=value[0];
		}
	}

	AnimationNode._getMeshRenderSharedMaterialMMultiplier=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.mMultiplier;
			}else
			return 0.0;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.mMultiplier;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialMMultiplier=function(animationNode,sprite3D,value){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				material.mMultiplier=value[0];
			}
			}else {
			material=(sprite3D).meshRender.material;
			material.mMultiplier=value[0];
		}
	}

	AnimationNode._getMeshRenderSharedMaterialBaseScrollSpeedX=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.baseScrollSpeedX;
			}else
			return 0.0;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.baseScrollSpeedX;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialBaseScrollSpeedX=function(animationNode,sprite3D,value){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				material.baseScrollSpeedX=value[0];
			}
			}else {
			material=(sprite3D).meshRender.material;
			material.baseScrollSpeedX=value[0];
		}
	}

	AnimationNode._getMeshRenderSharedMaterialBaseScrollSpeedY=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.baseScrollSpeedY;
			}else
			return 0.0;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.baseScrollSpeedY;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialBaseScrollSpeedY=function(animationNode,sprite3D,value){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				material.baseScrollSpeedY=value[0];
			}
			}else {
			material=(sprite3D).meshRender.material;
			material.baseScrollSpeedY=value[0];
		}
	}

	AnimationNode._getMeshRenderSharedMaterialSecondScrollSpeedX=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.secondScrollSpeedX;
			}else
			return 0.0;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.secondScrollSpeedX;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialSecondScrollSpeedX=function(animationNode,sprite3D,value){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				material.secondScrollSpeedX=value[0];
			}
			}else {
			material=(sprite3D).meshRender.material;
			material.secondScrollSpeedX=value[0];
		}
	}

	AnimationNode._getMeshRenderSharedMaterialSecondScrollSpeedY=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.secondScrollSpeedY;
			}else
			return 0.0;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.secondScrollSpeedY;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialSecondScrollSpeedY=function(animationNode,sprite3D,value){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				material.secondScrollSpeedY=value[0];
			}
			}else {
			material=(sprite3D).meshRender.material;
			material.secondScrollSpeedY=value[0];
		}
	}

	AnimationNode._getMeshRenderSharedMaterialAlpha=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.alpha;
			}else
			return 0.0;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.alpha;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialAlpha=function(animationNode,sprite3D,value){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				material.alpha=value[0];
			}
			}else {
			material=(sprite3D).meshRender.material;
			material.alpha=value[0];
		}
	}

	AnimationNode._getMeshRenderSharedMaterialIntensity=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.intensity;
			}else
			return 0.0;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.intensity;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialIntensity=function(animationNode,sprite3D,value){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				material.intensity=value[0];
			}
			}else {
			material=(sprite3D).meshRender.material;
			material.intensity=value[0];
		}
	}

	AnimationNode._getMeshRenderSharedMaterialDetailTilingOffset=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.detailTilingOffset.elements;
			}else
			return null;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.detailTilingOffset.elements;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialDetailTilingOffset=function(animationNode,sprite3D,value){
		var material,detailTilingOffset;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				detailTilingOffset=material.detailTilingOffset;
				detailTilingOffset.elements=value;
				material.detailTilingOffset=detailTilingOffset;
			}
			}else {
			material=(sprite3D).meshRender.material;
			detailTilingOffset=material.detailTilingOffset;
			detailTilingOffset.elements=value;
			material.detailTilingOffset=detailTilingOffset;
		}
	}

	AnimationNode._getMeshRenderSharedMaterialDissolveTilingOffset=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.dissolveTilingOffset.elements;
			}else
			return null;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.dissolveTilingOffset.elements;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialDissolveTilingOffset=function(animationNode,sprite3D,value){
		var material,dissolveTilingOffset;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				dissolveTilingOffset=material.dissolveTilingOffset;
				dissolveTilingOffset.elements=value;
				material.dissolveTilingOffset=dissolveTilingOffset;
			}
			}else {
			material=(sprite3D).meshRender.material;
			dissolveTilingOffset=material.dissolveTilingOffset;
			dissolveTilingOffset.elements=value;
			material.dissolveTilingOffset=dissolveTilingOffset;
		}
	}

	AnimationNode._getMeshRenderSharedMaterialMaskTilingOffset=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.maskTilingOffset.elements;
			}else
			return null;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.maskTilingOffset.elements;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialMaskTilingOffset=function(animationNode,sprite3D,value){
		var material,maskTilingOffset;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				maskTilingOffset=material.maskTilingOffset;
				maskTilingOffset.elements=value;
				material.maskTilingOffset=maskTilingOffset;
			}
			}else {
			material=(sprite3D).meshRender.material;
			maskTilingOffset=material.maskTilingOffset;
			maskTilingOffset.elements=value;
			material.maskTilingOffset=maskTilingOffset;
		}
	}

	AnimationNode._propertyIDCounter=0;
	AnimationNode._propertyIndexDic={};
	AnimationNode._propertySetFuncs=[];
	AnimationNode._propertyGetFuncs=[];
	return AnimationNode;
})()


/**
*@private
*/
//class laya.d3.animation.Keyframe
var Keyframe=(function(){
	function Keyframe(){
		this.startTime=NaN;
		this.inTangent=null;
		this.outTangent=null;
		this.data=null;
		this.duration=NaN;
		this.next=null;
	}

	__class(Keyframe,'laya.d3.animation.Keyframe');
	return Keyframe;
})()


/**
*@private
*/
//class laya.d3.animation.KeyframeNode
var KeyframeNode=(function(){
	function KeyframeNode(){
		this._cacheProperty=false;
		this.path=null;
		this.componentType=null;
		//TODO:是否去掉
		this.propertyNameID=0;
		this.keyFrameWidth=0;
		this.defaultData=null;
		this.keyFrames=null;
	}

	__class(KeyframeNode,'laya.d3.animation.KeyframeNode');
	return KeyframeNode;
})()


/**
*<code>SplineCurvePositionVelocity</code> 类用于通过顶点和速度创建闪光插值。
*/
//class laya.d3.core.glitter.SplineCurvePositionVelocity
var SplineCurvePositionVelocity=(function(){
	function SplineCurvePositionVelocity(){
		this._tempVector30=new Vector3();
		this._tempVector31=new Vector3();
		this._tempVector32=new Vector3();
		this._a=new Vector3();
		this._b=new Vector3();
		this._c=new Vector3();
		this._d=new Vector3();
	}

	__class(SplineCurvePositionVelocity,'laya.d3.core.glitter.SplineCurvePositionVelocity');
	var __proto=SplineCurvePositionVelocity.prototype;
	/**
	*初始化插值所需信息。
	*@param position0 顶点0的位置。
	*@param velocity0 顶点0的速度。
	*@param position1 顶点1的位置。
	*@param velocity1 顶点1的速度。
	*/
	__proto.Init=function(position0,velocity0,position1,velocity1){
		position0.cloneTo(this._d);
		velocity0.cloneTo(this._c);
		Vector3.scale(position0,2.0,this._a);
		Vector3.scale(position1,2.0,this._tempVector30);
		Vector3.subtract(this._a,this._tempVector30,this._a);
		Vector3.add(this._a,velocity0,this._a);
		Vector3.add(this._a,velocity1,this._a);
		Vector3.scale(position1,3.0,this._b);
		Vector3.scale(position0,3.0,this._tempVector30);
		Vector3.subtract(this._b,this._tempVector30,this._b);
		Vector3.subtract(this._b,velocity1,this._b);
		Vector3.scale(velocity0,2.0,this._tempVector30);
		Vector3.subtract(this._b,this._tempVector30,this._b);
	}

	/**
	*初始化插值所需信息。
	*@param t 插值比例
	*@param out 输出结果
	*/
	__proto.Slerp=function(t,out){
		Vector3.scale(this._a,t *t *t,this._tempVector30);
		Vector3.scale(this._b,t *t,this._tempVector31);
		Vector3.scale(this._c,t,this._tempVector32);
		Vector3.add(this._tempVector30,this._tempVector31,out);
		Vector3.add(out,this._tempVector32,out);
		Vector3.add(out,this._d,out);
	}

	return SplineCurvePositionVelocity;
})()


/**
*<code>HeightMap</code> 类用于实现高度图数据。
*/
//class laya.d3.core.HeightMap
var HeightMap=(function(){
	function HeightMap(width,height,minHeight,maxHeight){
		/**@private */
		this._datas=null;
		/**@private */
		this._w=0;
		/**@private */
		this._h=0;
		/**@private */
		this._minHeight=NaN;
		/**@private */
		this._maxHeight=NaN;
		this._datas=[];
		this._w=width;
		this._h=height;
		this._minHeight=minHeight;
		this._maxHeight=maxHeight;
	}

	__class(HeightMap,'laya.d3.core.HeightMap');
	var __proto=HeightMap.prototype;
	/**@private */
	__proto._inBounds=function(row,col){
		return row >=0 && row < this._h && col >=0 && col < this._w;
	}

	/**
	*获取高度。
	*@param row 列数。
	*@param col 行数。
	*@return 高度。
	*/
	__proto.getHeight=function(row,col){
		if (this._inBounds(row,col))
			return this._datas[row][col];
		else
		return NaN;
	}

	/**
	*获取宽度。
	*@return value 宽度。
	*/
	__getset(0,__proto,'width',function(){
		return this._w;
	});

	/**
	*获取高度。
	*@return value 高度。
	*/
	__getset(0,__proto,'height',function(){
		return this._h;
	});

	/**
	*最大高度。
	*@return value 最大高度。
	*/
	__getset(0,__proto,'maxHeight',function(){
		return this._maxHeight;
	});

	/**
	*最大高度。
	*@return value 最大高度。
	*/
	__getset(0,__proto,'minHeight',function(){
		return this._minHeight;
	});

	HeightMap.creatFromMesh=function(mesh,width,height,outCellSize){
		var vertices=[];
		var indexs=[];
		var submesheCount=mesh.getSubMeshCount();
		for (var i=0;i < submesheCount;i++){
			var subMesh=mesh.getSubMesh(i);
			var vertexBuffer=subMesh._getVertexBuffer();
			var verts=vertexBuffer.getData();
			var subMeshVertices=[];
			for (var j=0;j < verts.length;j+=vertexBuffer.vertexDeclaration.vertexStride / 4){
				var position=new Vector3(verts[j+0],verts[j+1],verts[j+2]);
				subMeshVertices.push(position);
			}
			vertices.push(subMeshVertices);
			var ib=subMesh._getIndexBuffer();
			indexs.push(ib.getData());
		};
		var boundingBox=mesh.boundingBox;
		var minX=boundingBox.min.x;
		var minZ=boundingBox.min.z;
		var maxX=boundingBox.max.x;
		var maxZ=boundingBox.max.z;
		var minY=boundingBox.min.y;
		var maxY=boundingBox.max.y;
		var widthSize=maxX-minX;
		var heightSize=maxZ-minZ;
		var cellWidth=outCellSize.elements[0]=widthSize / (width-1);
		var cellHeight=outCellSize.elements[1]=heightSize / (height-1);
		var heightMap=new HeightMap(width,height,minY,maxY);
		var ray=HeightMap._tempRay;
		var rayDirE=ray.direction.elements;
		rayDirE[0]=0;
		rayDirE[1]=-1;
		rayDirE[2]=0;
		var heightOffset=0.1;
		var rayY=maxY+heightOffset;
		ray.origin.elements[1]=rayY;
		for (var h=0;h < height;h++){
			var posZ=minZ+h *cellHeight;
			heightMap._datas[h]=[];
			for (var w=0;w < width;w++){
				var posX=minX+w *cellWidth;
				var rayOriE=ray.origin.elements;
				rayOriE[0]=posX;
				rayOriE[2]=posZ;
				var closestIntersection=HeightMap._getPosition(ray,vertices,indexs);
				heightMap._datas[h][w]=(closestIntersection===Number.MAX_VALUE)? NaN :rayY-closestIntersection;
			}
		}
		return heightMap;
	}

	HeightMap.createFromImage=function(texture,minHeight,maxHeight){
		var textureWidth=texture.width;
		var textureHeight=texture.height;
		var heightMap=new HeightMap(textureWidth,textureHeight,minHeight,maxHeight);
		var compressionRatio=(maxHeight-minHeight)/ 254;
		var pixelsInfo=texture.getPixels();
		var index=0;
		for (var h=0;h <textureHeight;h++){
			var colDatas=heightMap._datas[h]=[];
			for (var w=0;w < textureWidth;w++){
				var r=pixelsInfo[index++];
				var g=pixelsInfo[index++];
				var b=pixelsInfo[index++];
				var a=pixelsInfo[index++];
				if (r==255 && g==255 && b==255 && a==255)
					colDatas[w]=NaN;
				else {
					colDatas[w]=(r+g+b)/ 3 *compressionRatio+minHeight;
				}
			}
		}
		return heightMap;
	}

	HeightMap._getPosition=function(ray,vertices,indexs){
		var closestIntersection=Number.MAX_VALUE;
		for (var i=0;i < vertices.length;i++){
			var subMeshVertices=vertices[i];
			var subMeshIndexes=indexs[i];
			for (var j=0;j < subMeshIndexes.length;j+=3){
				var vertex1=subMeshVertices[subMeshIndexes[j+0]];
				var vertex2=subMeshVertices[subMeshIndexes[j+1]];
				var vertex3=subMeshVertices[subMeshIndexes[j+2]];
				var intersection=Picker.rayIntersectsTriangle(ray,vertex1,vertex2,vertex3);
				if (!isNaN(intersection)&& intersection < closestIntersection){
					closestIntersection=intersection;
				}
			}
		}
		return closestIntersection;
	}

	__static(HeightMap,
	['_tempRay',function(){return this._tempRay=new Ray(new Vector3(),new Vector3());}
	]);
	return HeightMap;
})()


/**
*<code>Layer</code> 类用于实现层。
*/
//class laya.d3.core.Layer
var Layer=(function(){
	function Layer(){
		/**@private 编号。*/
		//this._number=0;
		/**@private 蒙版值。*/
		//this._mask=0;
		/**@private 是否显示。*/
		//this._visible=false;
		/**@private 只读,不允许修改。*/
		//this._nonRigidbodyOffset=0;
		/**@private 只读,不允许修改。*/
		//this._colliders=null;
		/**名字。*/
		//this.name=null;
		this._visible=true;
		this._nonRigidbodyOffset=0;
		this._colliders=[];
	}

	__class(Layer,'laya.d3.core.Layer');
	var __proto=Layer.prototype;
	/**
	*@private
	*/
	__proto._binarySearchIndex=function(){
		var start=0;
		var end=Layer._collsionTestList.length-1;
		var mid=0;
		while (start <=end){
			mid=Math.floor((start+end)/ 2);
			var midValue=Layer._collsionTestList[mid];
			if (midValue==this._number)
				return mid;
			else if (midValue > this._number)
			end=mid-1;
			else
			start=mid+1;
		}
		return start;
	}

	/**
	*@private
	*/
	__proto._addCollider=function(collider){
		(this._colliders.length===0)&& (Layer._collsionTestList.splice(this._binarySearchIndex(),0,this._number));
		if (collider._isRigidbody){
			this._colliders.unshift(collider);
			this._nonRigidbodyOffset++;
			}else {
			this._colliders.push(collider);
		}
	}

	/**
	*@private
	*/
	__proto._removeCollider=function(collider){
		var index=this._colliders.indexOf(collider);
		if (index < this._nonRigidbodyOffset)
			this._nonRigidbodyOffset--;
		this._colliders.splice(index,1);
		(this._colliders.length===0)&& (Layer._collsionTestList.splice(Layer._collsionTestList.indexOf(this._number),1));
	}

	/**
	*获取编号。
	*@return 编号。
	*/
	__getset(0,__proto,'number',function(){
		return this._number;
	});

	/**
	*设置是否显示。
	*@param value 是否显示。
	*/
	/**
	*获取是否显示。
	*@return 是否显示。
	*/
	__getset(0,__proto,'visible',function(){
		return this._visible;
		},function(value){
		this._visible=value;
		if (value)
			Layer._visibleLayers=Layer._visibleLayers | this.mask;
		else
		Layer._visibleLayers=Layer._visibleLayers & ~this.mask;
	});

	/**
	*获取蒙版值。
	*@return 蒙版值。
	*/
	__getset(0,__proto,'mask',function(){
		return this._mask;
	});

	/**
	*设置Layer显示层。
	*@param value 显示层。
	*/
	/**
	*获取Layer显示层。
	*@return 显示层。
	*/
	__getset(1,Layer,'visibleLayers',function(){
		return Layer._visibleLayers;
		},function(value){
		Layer._visibleLayers=value;
		for (var i=0,n=Layer._layerList.length;i < n;i++){
			var layer=Layer._layerList[i];
			layer._visible=(layer._mask & Layer._visibleLayers)!==0;
		}
	});

	Layer.__init__=function(){
		Layer._layerList.length=31;
		for (var i=0;i < 31;i++){
			var layer=new Layer();
			Layer._layerList[i]=layer;
			if (i===0){
				layer.name="Default Layer";
				layer.visible=true;
				}else {
				layer.name="Layer-"+i;
				layer.visible=false;
			}
			layer._number=i;
			layer._mask=Math.pow(2,i);
		}
		Layer.currentCreationLayer=Layer._layerList[0];
	}

	Layer.getLayerByNumber=function(number){
		if (number < 0 || number > 30)
			throw new Error("无法返回指定Layer，该number超出范围！");
		return Layer._layerList[number];
	}

	Layer.getLayerByName=function(name){
		for (var i=0;i < 31;i++){
			if (Layer._layerList[i].name===name)
				return Layer._layerList[i];
		}
		throw new Error("无法返回指定Layer,该name不存在");
	}

	Layer.isVisible=function(mask){
		return (mask & Layer._currentCameraCullingMask & Layer._visibleLayers)!=0;
	}

	Layer._layerList=[];
	Layer._visibleLayers=2147483647;
	Layer._collsionTestList=[];
	Layer._currentCameraCullingMask=2147483647;
	Layer.maxCount=31;
	Layer.currentCreationLayer=null;
	return Layer;
})()


/**
*<code>Burst</code> 类用于粒子的爆裂描述。
*/
//class laya.d3.core.particleShuriKen.module.Burst
var Burst=(function(){
	function Burst(time,minCount,maxCount){
		/**@private 爆裂时间,单位为秒。*/
		this._time=NaN;
		/**@private 爆裂的最小数量。*/
		this._minCount=0;
		/**@private 爆裂的最大数量。*/
		this._maxCount=0;
		this._time=time;
		this._minCount=minCount;
		this._maxCount=maxCount;
	}

	__class(Burst,'laya.d3.core.particleShuriKen.module.Burst');
	var __proto=Burst.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destBurst=destObject;
		destBurst._time=this._time
		destBurst._minCount=this._minCount;
		destBurst._maxCount=this._maxCount;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destBurst=/*__JS__ */new this.constructor();
		this.cloneTo(destBurst);
		return destBurst;
	}

	/**
	*获取爆裂时间,单位为秒。
	*@return 爆裂时间,单位为秒。
	*/
	__getset(0,__proto,'time',function(){
		return this._time;
	});

	/**
	*获取爆裂的最小数量。
	*@return 爆裂的最小数量。
	*/
	__getset(0,__proto,'minCount',function(){
		return this._minCount;
	});

	/**
	*获取爆裂的最大数量。
	*@return 爆裂的最大数量。
	*/
	__getset(0,__proto,'maxCount',function(){
		return this._maxCount;
	});

	return Burst;
})()


/**
*<code>ColorOverLifetime</code> 类用于粒子的生命周期颜色。
*/
//class laya.d3.core.particleShuriKen.module.ColorOverLifetime
var ColorOverLifetime=(function(){
	function ColorOverLifetime(color){
		/**@private */
		this._color=null;
		/**是否启用。*/
		this.enbale=false;
		this._color=color;
	}

	__class(ColorOverLifetime,'laya.d3.core.particleShuriKen.module.ColorOverLifetime');
	var __proto=ColorOverLifetime.prototype;
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destColorOverLifetime=destObject;
		this._color.cloneTo(destColorOverLifetime._color);
		destColorOverLifetime.enbale=this.enbale;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destColor;
		switch (this._color.type){
			case 0:
				destColor=GradientColor.createByConstant(this._color.constant.clone());
				break ;
			case 1:
				destColor=GradientColor.createByGradient(this._color.gradient.clone());
				break ;
			case 2:
				destColor=GradientColor.createByRandomTwoConstant(this._color.constantMin.clone(),this._color.constantMax.clone());
				break ;
			case 3:
				destColor=GradientColor.createByRandomTwoGradient(this._color.gradientMin.clone(),this._color.gradientMax.clone());
				break ;
			};
		var destColorOverLifetime=/*__JS__ */new this.constructor(destColor);
		destColorOverLifetime.enbale=this.enbale;
		return destColorOverLifetime;
	}

	/**
	*获取颜色。
	*/
	__getset(0,__proto,'color',function(){
		return this._color;
	});

	return ColorOverLifetime;
})()


/**
*<code>Emission</code> 类用于粒子发射器。
*/
//class laya.d3.core.particleShuriKen.module.Emission
var Emission=(function(){
	function Emission(){
		/**@private */
		this._destroyed=false;
		/**@private 粒子发射速率,每秒发射的个数。*/
		this._emissionRate=0;
		/**@private 粒子的爆裂,不允许修改。*/
		this._bursts=null;
		/**是否启用。*/
		this.enbale=false;
		this._destroyed=false;
		this.emissionRate=10;
		this._bursts=[];
	}

	__class(Emission,'laya.d3.core.particleShuriKen.module.Emission');
	var __proto=Emission.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true,"laya.resource.IDestroy":true})
	/**
	*@private
	*/
	__proto._destroy=function(){
		this._bursts=null;
		this._destroyed=true;
	}

	/**
	*获取粒子爆裂个数。
	*@return 粒子爆裂个数。
	*/
	__proto.getBurstsCount=function(){
		return this._bursts.length;
	}

	/**
	*通过索引获取粒子爆裂。
	*@param index 爆裂索引。
	*@return 粒子爆裂。
	*/
	__proto.getBurstByIndex=function(index){
		return this._bursts[index];
	}

	/**
	*增加粒子爆裂。
	*@param burst 爆裂。
	*/
	__proto.addBurst=function(burst){
		var burstsCount=this._bursts.length;
		if (burstsCount > 0)
			for (var i=0;i < burstsCount;i++){
			if (this._bursts[i].time > burst.time)
				this._bursts.splice(i,0,burst);
		}
		this._bursts.push(burst);
	}

	/**
	*移除粒子爆裂。
	*@param burst 爆裂。
	*/
	__proto.removeBurst=function(burst){
		var index=this._bursts.indexOf(burst);
		if (index!==-1){
			this._bursts.splice(index,1);
		}
	}

	/**
	*通过索引移除粒子爆裂。
	*@param index 爆裂索引。
	*/
	__proto.removeBurstByIndex=function(index){
		this._bursts.splice(index,1);
	}

	/**
	*清空粒子爆裂。
	*/
	__proto.clearBurst=function(){
		this._bursts.length=0;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destEmission=destObject;
		var destBursts=destEmission._bursts;
		destBursts.length=this._bursts.length;
		for (var i=0,n=this._bursts.length;i < n;i++){
			var destBurst=destBursts[i];
			if (destBurst)
				this._bursts[i].cloneTo(destBurst);
			else
			destBursts[i]=this._bursts[i].clone();
		}
		destEmission._emissionRate=this._emissionRate;
		destEmission.enbale=this.enbale;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destEmission=/*__JS__ */new this.constructor();
		this.cloneTo(destEmission);
		return destEmission;
	}

	/**
	*获取是否已销毁。
	*@return 是否已销毁。
	*/
	__getset(0,__proto,'destroyed',function(){
		return this._destroyed;
	});

	/**
	*设置粒子发射速率。
	*@param emissionRate 粒子发射速率 (个/秒)。
	*/
	/**
	*获取粒子发射速率。
	*@return 粒子发射速率 (个/秒)。
	*/
	__getset(0,__proto,'emissionRate',function(){
		return this._emissionRate;
		},function(value){
		if (value < 0)
			throw new Error("ParticleBaseShape:emissionRate value must large or equal than 0.");
		this._emissionRate=value;
	});

	return Emission;
})()


/**
*<code>FrameOverTime</code> 类用于创建时间帧。
*/
//class laya.d3.core.particleShuriKen.module.FrameOverTime
var FrameOverTime=(function(){
	function FrameOverTime(){
		/**@private */
		this._type=0;
		/**@private */
		this._constant=0;
		/**@private */
		this._overTime=null;
		/**@private */
		this._constantMin=0;
		/**@private */
		this._constantMax=0;
		/**@private */
		this._overTimeMin=null;
		/**@private */
		this._overTimeMax=null;
	}

	__class(FrameOverTime,'laya.d3.core.particleShuriKen.module.FrameOverTime');
	var __proto=FrameOverTime.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destFrameOverTime=destObject;
		destFrameOverTime._type=this._type;
		destFrameOverTime._constant=this._constant;
		this._overTime.cloneTo(destFrameOverTime._overTime);
		destFrameOverTime._constantMin=this._constantMin;
		destFrameOverTime._constantMax=this._constantMax;
		this._overTimeMin.cloneTo(destFrameOverTime._overTimeMin);
		this._overTimeMax.cloneTo(destFrameOverTime._overTimeMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destFrameOverTime=/*__JS__ */new this.constructor();
		this.cloneTo(destFrameOverTime);
		return destFrameOverTime;
	}

	/**
	*时间帧。
	*/
	__getset(0,__proto,'frameOverTimeData',function(){
		return this._overTime;
	});

	/**
	*固定帧。
	*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*生命周期旋转类型,0常量模式，1曲线模式，2随机双常量模式，3随机双曲线模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*最小时间帧。
	*/
	__getset(0,__proto,'frameOverTimeDataMin',function(){
		return this._overTimeMin;
	});

	/**
	*最小固定帧。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*最大时间帧。
	*/
	__getset(0,__proto,'frameOverTimeDataMax',function(){
		return this._overTimeMax;
	});

	/**
	*最大固定帧。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	FrameOverTime.createByConstant=function(constant){
		var rotationOverLifetime=new FrameOverTime();
		rotationOverLifetime._type=0;
		rotationOverLifetime._constant=constant;
		return rotationOverLifetime;
	}

	FrameOverTime.createByOverTime=function(overTime){
		var rotationOverLifetime=new FrameOverTime();
		rotationOverLifetime._type=1;
		rotationOverLifetime._overTime=overTime;
		return rotationOverLifetime;
	}

	FrameOverTime.createByRandomTwoConstant=function(constantMin,constantMax){
		var rotationOverLifetime=new FrameOverTime();
		rotationOverLifetime._type=2;
		rotationOverLifetime._constantMin=constantMin;
		rotationOverLifetime._constantMax=constantMax;
		return rotationOverLifetime;
	}

	FrameOverTime.createByRandomTwoOverTime=function(gradientFrameMin,gradientFrameMax){
		var rotationOverLifetime=new FrameOverTime();
		rotationOverLifetime._type=3;
		rotationOverLifetime._overTimeMin=gradientFrameMin;
		rotationOverLifetime._overTimeMax=gradientFrameMax;
		return rotationOverLifetime;
	}

	return FrameOverTime;
})()


/**
*<code>GradientRotation</code> 类用于创建渐变角速度。
*/
//class laya.d3.core.particleShuriKen.module.GradientAngularVelocity
var GradientAngularVelocity=(function(){
	function GradientAngularVelocity(){
		/**@private */
		this._type=0;
		/**@private */
		this._separateAxes=false;
		/**@private */
		this._constant=NaN;
		/**@private */
		this._constantSeparate=null;
		/**@private */
		this._gradient=null;
		/**@private */
		this._gradientX=null;
		/**@private */
		this._gradientY=null;
		/**@private */
		this._gradientZ=null;
		/**@private */
		this._gradientW=null;
		/**@private */
		this._constantMin=NaN;
		/**@private */
		this._constantMax=NaN;
		/**@private */
		this._constantMinSeparate=null;
		/**@private */
		this._constantMaxSeparate=null;
		/**@private */
		this._gradientMin=null;
		/**@private */
		this._gradientMax=null;
		/**@private */
		this._gradientXMin=null;
		/**@private */
		this._gradientXMax=null;
		/**@private */
		this._gradientYMin=null;
		/**@private */
		this._gradientYMax=null;
		/**@private */
		this._gradientZMin=null;
		/**@private */
		this._gradientZMax=null;
		/**@private */
		this._gradientWMin=null;
		/**@private */
		this._gradientWMax=null;
	}

	__class(GradientAngularVelocity,'laya.d3.core.particleShuriKen.module.GradientAngularVelocity');
	var __proto=GradientAngularVelocity.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientAngularVelocity=destObject;
		destGradientAngularVelocity._type=this._type;
		destGradientAngularVelocity._separateAxes=this._separateAxes;
		destGradientAngularVelocity._constant=this._constant;
		this._constantSeparate.cloneTo(destGradientAngularVelocity._constantSeparate);
		this._gradient.cloneTo(destGradientAngularVelocity._gradient);
		this._gradientX.cloneTo(destGradientAngularVelocity._gradientX);
		this._gradientY.cloneTo(destGradientAngularVelocity._gradientY);
		this._gradientZ.cloneTo(destGradientAngularVelocity._gradientZ);
		destGradientAngularVelocity._constantMin=this._constantMin;
		destGradientAngularVelocity._constantMax=this._constantMax;
		this._constantMinSeparate.cloneTo(destGradientAngularVelocity._constantMinSeparate);
		this._constantMaxSeparate.cloneTo(destGradientAngularVelocity._constantMaxSeparate);
		this._gradientMin.cloneTo(destGradientAngularVelocity._gradientMin);
		this._gradientMax.cloneTo(destGradientAngularVelocity._gradientMax);
		this._gradientXMin.cloneTo(destGradientAngularVelocity._gradientXMin);
		this._gradientXMax.cloneTo(destGradientAngularVelocity._gradientXMax);
		this._gradientYMin.cloneTo(destGradientAngularVelocity._gradientYMin);
		this._gradientYMax.cloneTo(destGradientAngularVelocity._gradientYMax);
		this._gradientZMin.cloneTo(destGradientAngularVelocity._gradientZMin);
		this._gradientZMax.cloneTo(destGradientAngularVelocity._gradientZMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientAngularVelocity=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientAngularVelocity);
		return destGradientAngularVelocity;
	}

	/**
	*渐变角速度Z。
	*/
	__getset(0,__proto,'gradientZ',function(){
		return this._gradientZ;
	});

	/**
	*固定角速度。
	*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*渐变角速度。
	*/
	__getset(0,__proto,'gradient',function(){
		return this._gradient;
	});

	/**
	*是否分轴。
	*/
	__getset(0,__proto,'separateAxes',function(){
		return this._separateAxes;
	});

	/**
	*生命周期角速度类型,0常量模式，1曲线模式，2随机双常量模式，3随机双曲线模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*分轴固定角速度。
	*/
	__getset(0,__proto,'constantSeparate',function(){
		return this._constantSeparate;
	});

	/**
	*渐变角角速度X。
	*/
	__getset(0,__proto,'gradientX',function(){
		return this._gradientX;
	});

	/**
	*渐变角速度Y。
	*/
	__getset(0,__proto,'gradientY',function(){
		return this._gradientY;
	});

	/**
	*渐变角速度Z。
	*/
	__getset(0,__proto,'gradientW',function(){
		return this._gradientW;
	});

	/**
	*最小渐变角速度。
	*/
	__getset(0,__proto,'gradientMin',function(){
		return this._gradientMin;
	});

	/**
	*最小随机双固定角速度。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*最大渐变角速度。
	*/
	__getset(0,__proto,'gradientMax',function(){
		return this._gradientMax;
	});

	/**
	*最大随机双固定角速度。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	/**
	*最小渐变角速度Z。
	*/
	__getset(0,__proto,'gradientWMin',function(){
		return this._gradientWMin;
	});

	/**
	*最小分轴随机双固定角速度。
	*/
	__getset(0,__proto,'constantMinSeparate',function(){
		return this._constantMinSeparate;
	});

	/**
	*最大分轴随机双固定角速度。
	*/
	__getset(0,__proto,'constantMaxSeparate',function(){
		return this._constantMaxSeparate;
	});

	/**
	*最小渐变角速度X。
	*/
	__getset(0,__proto,'gradientXMin',function(){
		return this._gradientXMin;
	});

	/**
	*最大渐变角速度X。
	*/
	__getset(0,__proto,'gradientXMax',function(){
		return this._gradientXMax;
	});

	/**
	*最大渐变角速度Z。
	*/
	__getset(0,__proto,'gradientWMax',function(){
		return this._gradientWMax;
	});

	/**
	*最小渐变角速度Y。
	*/
	__getset(0,__proto,'gradientYMin',function(){
		return this._gradientYMin;
	});

	/**
	*最大渐变角速度Y。
	*/
	__getset(0,__proto,'gradientYMax',function(){
		return this._gradientYMax;
	});

	/**
	*最小渐变角速度Z。
	*/
	__getset(0,__proto,'gradientZMin',function(){
		return this._gradientZMin;
	});

	/**
	*最大渐变角速度Z。
	*/
	__getset(0,__proto,'gradientZMax',function(){
		return this._gradientZMax;
	});

	GradientAngularVelocity.createByConstant=function(constant){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=0;
		gradientAngularVelocity._separateAxes=false;
		gradientAngularVelocity._constant=constant;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByConstantSeparate=function(separateConstant){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=0;
		gradientAngularVelocity._separateAxes=true;
		gradientAngularVelocity._constantSeparate=separateConstant;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByGradient=function(gradient){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=1;
		gradientAngularVelocity._separateAxes=false;
		gradientAngularVelocity._gradient=gradient;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByGradientSeparate=function(gradientX,gradientY,gradientZ,gradientW){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=1;
		gradientAngularVelocity._separateAxes=true;
		gradientAngularVelocity._gradientX=gradientX;
		gradientAngularVelocity._gradientY=gradientY;
		gradientAngularVelocity._gradientZ=gradientZ;
		gradientAngularVelocity._gradientW=gradientW;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByRandomTwoConstant=function(constantMin,constantMax){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=2;
		gradientAngularVelocity._separateAxes=false;
		gradientAngularVelocity._constantMin=constantMin;
		gradientAngularVelocity._constantMax=constantMax;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByRandomTwoConstantSeparate=function(separateConstantMin,separateConstantMax){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=2;
		gradientAngularVelocity._separateAxes=true;
		gradientAngularVelocity._constantMinSeparate=separateConstantMin;
		gradientAngularVelocity._constantMaxSeparate=separateConstantMax;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByRandomTwoGradient=function(gradientMin,gradientMax){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=3;
		gradientAngularVelocity._separateAxes=false;
		gradientAngularVelocity._gradientMin=gradientMin;
		gradientAngularVelocity._gradientMax=gradientMax;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByRandomTwoGradientSeparate=function(gradientXMin,gradientXMax,gradientYMin,gradientYMax,gradientZMin,gradientZMax,gradientWMin,gradientWMax){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=3;
		gradientAngularVelocity._separateAxes=true;
		gradientAngularVelocity._gradientXMin=gradientXMin;
		gradientAngularVelocity._gradientXMax=gradientXMax;
		gradientAngularVelocity._gradientYMin=gradientYMin;
		gradientAngularVelocity._gradientYMax=gradientYMax;
		gradientAngularVelocity._gradientZMin=gradientZMin;
		gradientAngularVelocity._gradientZMax=gradientZMax;
		gradientAngularVelocity._gradientWMin=gradientWMin;
		gradientAngularVelocity._gradientWMax=gradientWMax;
		return gradientAngularVelocity;
	}

	return GradientAngularVelocity;
})()


/**
*<code>GradientColor</code> 类用于创建渐变颜色。
*/
//class laya.d3.core.particleShuriKen.module.GradientColor
var GradientColor=(function(){
	function GradientColor(){
		/**@private */
		this._type=0;
		/**@private */
		this._constant=null;
		/**@private */
		this._constantMin=null;
		/**@private */
		this._constantMax=null;
		/**@private */
		this._gradient=null;
		/**@private */
		this._gradientMin=null;
		/**@private */
		this._gradientMax=null;
	}

	__class(GradientColor,'laya.d3.core.particleShuriKen.module.GradientColor');
	var __proto=GradientColor.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientColor=destObject;
		destGradientColor._type=this._type;
		this._constant.cloneTo(destGradientColor._constant);
		this._constantMin.cloneTo(destGradientColor._constantMin);
		this._constantMax.cloneTo(destGradientColor._constantMax);
		this._gradient.cloneTo(destGradientColor._gradient);
		this._gradientMin.cloneTo(destGradientColor._gradientMin);
		this._gradientMax.cloneTo(destGradientColor._gradientMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientColor=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientColor);
		return destGradientColor;
	}

	/**
	*渐变颜色。
	*/
	__getset(0,__proto,'gradient',function(){
		return this._gradient;
	});

	/**
	*固定颜色。
	*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*生命周期颜色类型,0为固定颜色模式,1渐变模式,2为随机双固定颜色模式,3随机双渐变模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*最小渐变颜色。
	*/
	__getset(0,__proto,'gradientMin',function(){
		return this._gradientMin;
	});

	/**
	*最小固定颜色。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*最大渐变颜色。
	*/
	__getset(0,__proto,'gradientMax',function(){
		return this._gradientMax;
	});

	/**
	*最大固定颜色。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	GradientColor.createByConstant=function(constant){
		var gradientColor=new GradientColor();
		gradientColor._type=0;
		gradientColor._constant=constant;
		return gradientColor;
	}

	GradientColor.createByGradient=function(gradient){
		var gradientColor=new GradientColor();
		gradientColor._type=1;
		gradientColor._gradient=gradient;
		return gradientColor;
	}

	GradientColor.createByRandomTwoConstant=function(minConstant,maxConstant){
		var gradientColor=new GradientColor();
		gradientColor._type=2;
		gradientColor._constantMin=minConstant;
		gradientColor._constantMax=maxConstant;
		return gradientColor;
	}

	GradientColor.createByRandomTwoGradient=function(minGradient,maxGradient){
		var gradientColor=new GradientColor();
		gradientColor._type=3;
		gradientColor._gradientMin=minGradient;
		gradientColor._gradientMax=maxGradient;
		return gradientColor;
	}

	return GradientColor;
})()


/**
*<code>GradientDataColor</code> 类用于创建颜色渐变。
*/
//class laya.d3.core.particleShuriKen.module.GradientDataColor
var GradientDataColor=(function(){
	function GradientDataColor(){
		/**@private */
		this._alphaCurrentLength=0;
		/**@private */
		this._rgbCurrentLength=0;
		/**@private 开发者禁止修改。*/
		this._alphaElements=null;
		/**@private 开发者禁止修改。*/
		this._rgbElements=null;
		this._alphaElements=new Float32Array(8);
		this._rgbElements=new Float32Array(16);
	}

	__class(GradientDataColor,'laya.d3.core.particleShuriKen.module.GradientDataColor');
	var __proto=GradientDataColor.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*增加Alpha渐变。
	*@param key 生命周期，范围为0到1。
	*@param value rgb值。
	*/
	__proto.addAlpha=function(key,value){
		if (this._alphaCurrentLength < 8){
			if ((this._alphaCurrentLength===6)&& ((key!==1))){
				key=1;
				console.log("GradientDataColor warning:the forth key is  be force set to 1.");
			}
			this._alphaElements[this._alphaCurrentLength++]=key;
			this._alphaElements[this._alphaCurrentLength++]=value;
			}else {
			console.log("GradientDataColor warning:data count must lessEqual than 4");
		}
	}

	/**
	*增加RGB渐变。
	*@param key 生命周期，范围为0到1。
	*@param value RGB值。
	*/
	__proto.addRGB=function(key,value){
		if (this._rgbCurrentLength < 16){
			if ((this._rgbCurrentLength===12)&& ((key!==1))){
				key=1;
				console.log("GradientDataColor warning:the forth key is  be force set to 1.");
			}
			this._rgbElements[this._rgbCurrentLength++]=key;
			this._rgbElements[this._rgbCurrentLength++]=value.x;
			this._rgbElements[this._rgbCurrentLength++]=value.y;
			this._rgbElements[this._rgbCurrentLength++]=value.z;
			}else {
			console.log("GradientDataColor warning:data count must lessEqual than 4");
		}
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientDataColor=destObject;
		var i=0,n=0;
		destGradientDataColor._alphaCurrentLength=this._alphaCurrentLength;
		var destAlphaElements=destGradientDataColor._alphaElements;
		destAlphaElements.length=this._alphaElements.length;
		for (i=0,n=this._alphaElements.length;i < n;i++)
		destAlphaElements[i]=this._alphaElements[i];
		destGradientDataColor._rgbCurrentLength=this._rgbCurrentLength;
		var destRGBElements=destGradientDataColor._rgbElements;
		destRGBElements.length=this._rgbElements.length;
		for (i=0,n=this._rgbElements.length;i < n;i++)
		destRGBElements[i]=this._rgbElements[i];
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientDataColor=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientDataColor);
		return destGradientDataColor;
	}

	/**渐变Alpha数量。*/
	__getset(0,__proto,'alphaGradientCount',function(){
		return this._alphaCurrentLength / 2;
	});

	/**渐变RGB数量。*/
	__getset(0,__proto,'rgbGradientCount',function(){
		return this._rgbCurrentLength / 4;
	});

	return GradientDataColor;
})()


/**
*<code>GradientDataInt</code> 类用于创建整形渐变。
*/
//class laya.d3.core.particleShuriKen.module.GradientDataInt
var GradientDataInt=(function(){
	function GradientDataInt(){
		/**@private */
		this._currentLength=0;
		/**@private 开发者禁止修改。*/
		this._elements=null;
		this._elements=new Float32Array(8);
	}

	__class(GradientDataInt,'laya.d3.core.particleShuriKen.module.GradientDataInt');
	var __proto=GradientDataInt.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*增加整形渐变。
	*@param key 生命周期，范围为0到1。
	*@param value 整形值。
	*/
	__proto.add=function(key,value){
		if (this._currentLength < 8){
			if ((this._currentLength===6)&& ((key!==1))){
				key=1;
				console.log("Warning:the forth key is  be force set to 1.");
			}
			this._elements[this._currentLength++]=key;
			this._elements[this._currentLength++]=value;
			}else {
			console.log("Warning:data count must lessEqual than 4");
		}
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientDataInt=destObject;
		destGradientDataInt._currentLength=this._currentLength;
		var destElements=destGradientDataInt._elements;
		destElements.length=this._elements.length;
		for (var i=0,n=this._elements.length;i < n;i++){
			destElements[i]=this._elements[i];
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientDataInt=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientDataInt);
		return destGradientDataInt;
	}

	/**整形渐变数量。*/
	__getset(0,__proto,'gradientCount',function(){
		return this._currentLength / 2;
	});

	return GradientDataInt;
})()


/**
*<code>GradientDataNumber</code> 类用于创建浮点渐变。
*/
//class laya.d3.core.particleShuriKen.module.GradientDataNumber
var GradientDataNumber=(function(){
	function GradientDataNumber(){
		/**@private */
		this._currentLength=0;
		/**@private 开发者禁止修改。*/
		this._elements=null;
		this._elements=new Float32Array(8);
	}

	__class(GradientDataNumber,'laya.d3.core.particleShuriKen.module.GradientDataNumber');
	var __proto=GradientDataNumber.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*增加浮点渐变。
	*@param key 生命周期，范围为0到1。
	*@param value 浮点值。
	*/
	__proto.add=function(key,value){
		if (this._currentLength < 8){
			if ((this._currentLength===6)&& ((key!==1))){
				key=1;
				console.log("GradientDataNumber warning:the forth key is  be force set to 1.");
			}
			this._elements[this._currentLength++]=key;
			this._elements[this._currentLength++]=value;
			}else {
			console.log("GradientDataNumber warning:data count must lessEqual than 4");
		}
	}

	/**
	*通过索引获取键。
	*@param index 索引。
	*@return value 键。
	*/
	__proto.getKeyByIndex=function(index){
		return this._elements[index *2];
	}

	/**
	*通过索引获取值。
	*@param index 索引。
	*@return value 值。
	*/
	__proto.getValueByIndex=function(index){
		return this._elements[index *2+1];
	}

	/**
	*获取平均值。
	*/
	__proto.getAverageValue=function(){
		var total=0;
		for (var i=0,n=this._currentLength-2;i < n;i+=2){
			var subValue=this._elements[i+1];
			subValue+=this._elements[i+3];
			subValue=subValue *(this._elements[i+2]-this._elements[i]);
		}
		return total / 2;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientDataNumber=destObject;
		destGradientDataNumber._currentLength=this._currentLength;
		var destElements=destGradientDataNumber._elements;
		destElements.length=this._elements.length;
		for (var i=0,n=this._elements.length;i < n;i++)
		destElements[i]=this._elements[i];
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientDataNumber=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientDataNumber);
		return destGradientDataNumber;
	}

	/**渐变浮点数量。*/
	__getset(0,__proto,'gradientCount',function(){
		return this._currentLength / 2;
	});

	return GradientDataNumber;
})()


/**
*<code>GradientDataVector2</code> 类用于创建二维向量渐变。
*/
//class laya.d3.core.particleShuriKen.module.GradientDataVector2
var GradientDataVector2=(function(){
	function GradientDataVector2(){
		/**@private */
		this._currentLength=0;
		/**@private 开发者禁止修改。*/
		this._elements=null;
		this._elements=new Float32Array(12);
	}

	__class(GradientDataVector2,'laya.d3.core.particleShuriKen.module.GradientDataVector2');
	var __proto=GradientDataVector2.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*增加二维向量渐变。
	*@param key 生命周期，范围为0到1。
	*@param value 二维向量值。
	*/
	__proto.add=function(key,value){
		if (this._currentLength < 8){
			if ((this._currentLength===6)&& ((key!==1))){
				key=1;
				console.log("GradientDataVector2 warning:the forth key is  be force set to 1.");
			}
			this._elements[this._currentLength++]=key;
			this._elements[this._currentLength++]=value.x;
			this._elements[this._currentLength++]=value.y;
			}else {
			console.log("GradientDataVector2 warning:data count must lessEqual than 4");
		}
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientDataVector2=destObject;
		destGradientDataVector2._currentLength=this._currentLength;
		var destElements=destGradientDataVector2._elements;
		destElements.length=this._elements.length;
		for (var i=0,n=this._elements.length;i < n;i++){
			destElements[i]=this._elements[i];
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientDataVector2=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientDataVector2);
		return destGradientDataVector2;
	}

	/**二维向量渐变数量。*/
	__getset(0,__proto,'gradientCount',function(){
		return this._currentLength / 3;
	});

	return GradientDataVector2;
})()


/**
*<code>GradientSize</code> 类用于创建渐变尺寸。
*/
//class laya.d3.core.particleShuriKen.module.GradientSize
var GradientSize=(function(){
	function GradientSize(){
		/**@private */
		this._type=0;
		/**@private */
		this._separateAxes=false;
		/**@private */
		this._gradient=null;
		/**@private */
		this._gradientX=null;
		/**@private */
		this._gradientY=null;
		/**@private */
		this._gradientZ=null;
		/**@private */
		this._constantMin=NaN;
		/**@private */
		this._constantMax=NaN;
		/**@private */
		this._constantMinSeparate=null;
		/**@private */
		this._constantMaxSeparate=null;
		/**@private */
		this._gradientMin=null;
		/**@private */
		this._gradientMax=null;
		/**@private */
		this._gradientXMin=null;
		/**@private */
		this._gradientXMax=null;
		/**@private */
		this._gradientYMin=null;
		/**@private */
		this._gradientYMax=null;
		/**@private */
		this._gradientZMin=null;
		/**@private */
		this._gradientZMax=null;
	}

	__class(GradientSize,'laya.d3.core.particleShuriKen.module.GradientSize');
	var __proto=GradientSize.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*获取最大尺寸。
	*/
	__proto.getMaxSizeInGradient=function(){
		var i=0,n=0;
		var maxSize=-Number.MAX_VALUE;
		switch (this._type){
			case 0:
				if (this._separateAxes){
					for (i=0,n=this._gradientX.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientX.getValueByIndex(i));
					for (i=0,n=this._gradientY.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientY.getValueByIndex(i));
					}else {
					for (i=0,n=this._gradient.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradient.getValueByIndex(i));
				}
				break ;
			case 1:
				if (this._separateAxes){
					maxSize=Math.max(this._constantMinSeparate.x,this._constantMaxSeparate.x);
					maxSize=Math.max(maxSize,this._constantMinSeparate.y);
					maxSize=Math.max(maxSize,this._constantMaxSeparate.y);
					}else {
					maxSize=Math.max(this._constantMin,this._constantMax);
				}
				break ;
			case 2:
				if (this._separateAxes){
					for (i=0,n=this._gradientXMin.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientXMin.getValueByIndex(i));
					for (i=0,n=this._gradientXMax.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientXMax.getValueByIndex(i));
					for (i=0,n=this._gradientYMin.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientYMin.getValueByIndex(i));
					for (i=0,n=this._gradientZMax.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientZMax.getValueByIndex(i));
					}else {
					for (i=0,n=this._gradientMin.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientMin.getValueByIndex(i));
					for (i=0,n=this._gradientMax.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientMax.getValueByIndex(i));
				}
				break ;
			}
		return maxSize;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientSize=destObject;
		destGradientSize._type=this._type;
		destGradientSize._separateAxes=this._separateAxes;
		this._gradient.cloneTo(destGradientSize._gradient);
		this._gradientX.cloneTo(destGradientSize._gradientX);
		this._gradientY.cloneTo(destGradientSize._gradientY);
		this._gradientZ.cloneTo(destGradientSize._gradientZ);
		destGradientSize._constantMin=this._constantMin;
		destGradientSize._constantMax=this._constantMax;
		this._constantMinSeparate.cloneTo(destGradientSize._constantMinSeparate);
		this._constantMaxSeparate.cloneTo(destGradientSize._constantMaxSeparate);
		this._gradientMin.cloneTo(destGradientSize._gradientMin);
		this._gradientMax.cloneTo(destGradientSize._gradientMax);
		this._gradientXMin.cloneTo(destGradientSize._gradientXMin);
		this._gradientXMax.cloneTo(destGradientSize._gradientXMax);
		this._gradientYMin.cloneTo(destGradientSize._gradientYMin);
		this._gradientYMax.cloneTo(destGradientSize._gradientYMax);
		this._gradientZMin.cloneTo(destGradientSize._gradientZMin);
		this._gradientZMax.cloneTo(destGradientSize._gradientZMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientSize=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientSize);
		return destGradientSize;
	}

	/**
	*渐变尺寸Z。
	*/
	__getset(0,__proto,'gradientZ',function(){
		return this._gradientZ;
	});

	/**
	*渐变尺寸。
	*/
	__getset(0,__proto,'gradient',function(){
		return this._gradient;
	});

	/**
	*是否分轴。
	*/
	__getset(0,__proto,'separateAxes',function(){
		return this._separateAxes;
	});

	/**
	*生命周期尺寸类型，0曲线模式，1随机双常量模式，2随机双曲线模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*渐变最小尺寸。
	*/
	__getset(0,__proto,'gradientMin',function(){
		return this._gradientMin;
	});

	/**
	*最小随机双固定尺寸。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*渐变尺寸X。
	*/
	__getset(0,__proto,'gradientX',function(){
		return this._gradientX;
	});

	/**
	*渐变尺寸Y。
	*/
	__getset(0,__proto,'gradientY',function(){
		return this._gradientY;
	});

	/**
	*渐变最大尺寸。
	*/
	__getset(0,__proto,'gradientMax',function(){
		return this._gradientMax;
	});

	/**
	*最大随机双固定尺寸。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	/**
	*最小分轴随机双固定尺寸。
	*/
	__getset(0,__proto,'constantMinSeparate',function(){
		return this._constantMinSeparate;
	});

	/**
	*最小分轴随机双固定尺寸。
	*/
	__getset(0,__proto,'constantMaxSeparate',function(){
		return this._constantMaxSeparate;
	});

	/**
	*渐变最小尺寸X。
	*/
	__getset(0,__proto,'gradientXMin',function(){
		return this._gradientXMin;
	});

	/**
	*渐变最大尺寸X。
	*/
	__getset(0,__proto,'gradientXMax',function(){
		return this._gradientXMax;
	});

	/**
	*渐变最小尺寸Y。
	*/
	__getset(0,__proto,'gradientYMin',function(){
		return this._gradientYMin;
	});

	/**
	*渐变最大尺寸Y。
	*/
	__getset(0,__proto,'gradientYMax',function(){
		return this._gradientYMax;
	});

	/**
	*渐变最小尺寸Z。
	*/
	__getset(0,__proto,'gradientZMin',function(){
		return this._gradientZMin;
	});

	/**
	*渐变最大尺寸Z。
	*/
	__getset(0,__proto,'gradientZMax',function(){
		return this._gradientZMax;
	});

	GradientSize.createByGradient=function(gradient){
		var gradientSize=new GradientSize();
		gradientSize._type=0;
		gradientSize._separateAxes=false;
		gradientSize._gradient=gradient;
		return gradientSize;
	}

	GradientSize.createByGradientSeparate=function(gradientX,gradientY,gradientZ){
		var gradientSize=new GradientSize();
		gradientSize._type=0;
		gradientSize._separateAxes=true;
		gradientSize._gradientX=gradientX;
		gradientSize._gradientY=gradientY;
		gradientSize._gradientZ=gradientZ;
		return gradientSize;
	}

	GradientSize.createByRandomTwoConstant=function(constantMin,constantMax){
		var gradientSize=new GradientSize();
		gradientSize._type=1;
		gradientSize._separateAxes=false;
		gradientSize._constantMin=constantMin;
		gradientSize._constantMax=constantMax;
		return gradientSize;
	}

	GradientSize.createByRandomTwoConstantSeparate=function(constantMinSeparate,constantMaxSeparate){
		var gradientSize=new GradientSize();
		gradientSize._type=1;
		gradientSize._separateAxes=true;
		gradientSize._constantMinSeparate=constantMinSeparate;
		gradientSize._constantMaxSeparate=constantMaxSeparate;
		return gradientSize;
	}

	GradientSize.createByRandomTwoGradient=function(gradientMin,gradientMax){
		var gradientSize=new GradientSize();
		gradientSize._type=2;
		gradientSize._separateAxes=false;
		gradientSize._gradientMin=gradientMin;
		gradientSize._gradientMax=gradientMax;
		return gradientSize;
	}

	GradientSize.createByRandomTwoGradientSeparate=function(gradientXMin,gradientXMax,gradientYMin,gradientYMax,gradientZMin,gradientZMax){
		var gradientSize=new GradientSize();
		gradientSize._type=2;
		gradientSize._separateAxes=true;
		gradientSize._gradientXMin=gradientXMin;
		gradientSize._gradientXMax=gradientXMax;
		gradientSize._gradientYMin=gradientYMin;
		gradientSize._gradientYMax=gradientYMax;
		gradientSize._gradientZMin=gradientZMin;
		gradientSize._gradientZMax=gradientZMax;
		return gradientSize;
	}

	return GradientSize;
})()


/**
*<code>GradientVelocity</code> 类用于创建渐变速度。
*/
//class laya.d3.core.particleShuriKen.module.GradientVelocity
var GradientVelocity=(function(){
	function GradientVelocity(){
		/**@private */
		this._type=0;
		/**@private */
		this._constant=null;
		/**@private */
		this._gradientX=null;
		/**@private */
		this._gradientY=null;
		/**@private */
		this._gradientZ=null;
		/**@private */
		this._constantMin=null;
		/**@private */
		this._constantMax=null;
		/**@private */
		this._gradientXMin=null;
		/**@private */
		this._gradientXMax=null;
		/**@private */
		this._gradientYMin=null;
		/**@private */
		this._gradientYMax=null;
		/**@private */
		this._gradientZMin=null;
		/**@private */
		this._gradientZMax=null;
	}

	__class(GradientVelocity,'laya.d3.core.particleShuriKen.module.GradientVelocity');
	var __proto=GradientVelocity.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientVelocity=destObject;
		destGradientVelocity._type=this._type;
		this._constant.cloneTo(destGradientVelocity._constant);
		this._gradientX.cloneTo(destGradientVelocity._gradientX);
		this._gradientY.cloneTo(destGradientVelocity._gradientY);
		this._gradientZ.cloneTo(destGradientVelocity._gradientZ);
		this._constantMin.cloneTo(destGradientVelocity._constantMin);
		this._constantMax.cloneTo(destGradientVelocity._constantMax);
		this._gradientXMin.cloneTo(destGradientVelocity._gradientXMin);
		this._gradientXMax.cloneTo(destGradientVelocity._gradientXMax);
		this._gradientYMin.cloneTo(destGradientVelocity._gradientYMin);
		this._gradientYMax.cloneTo(destGradientVelocity._gradientYMax);
		this._gradientZMin.cloneTo(destGradientVelocity._gradientZMin);
		this._gradientZMax.cloneTo(destGradientVelocity._gradientZMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientVelocity=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientVelocity);
		return destGradientVelocity;
	}

	/**
	*渐变速度Z。
	*/
	__getset(0,__proto,'gradientZ',function(){
		return this._gradientZ;
	});

	/**固定速度。*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*生命周期速度类型，0常量模式，1曲线模式，2随机双常量模式，3随机双曲线模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*渐变最大速度X。
	*/
	__getset(0,__proto,'gradientXMax',function(){
		return this._gradientXMax;
	});

	/**最小固定速度。*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*渐变速度X。
	*/
	__getset(0,__proto,'gradientX',function(){
		return this._gradientX;
	});

	/**
	*渐变速度Y。
	*/
	__getset(0,__proto,'gradientY',function(){
		return this._gradientY;
	});

	/**
	*渐变最小速度X。
	*/
	__getset(0,__proto,'gradientXMin',function(){
		return this._gradientXMin;
	});

	/**最大固定速度。*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	/**
	*渐变最小速度Y。
	*/
	__getset(0,__proto,'gradientYMin',function(){
		return this._gradientYMin;
	});

	/**
	*渐变最大速度Y。
	*/
	__getset(0,__proto,'gradientYMax',function(){
		return this._gradientYMax;
	});

	/**
	*渐变最小速度Z。
	*/
	__getset(0,__proto,'gradientZMin',function(){
		return this._gradientZMin;
	});

	/**
	*渐变最大速度Z。
	*/
	__getset(0,__proto,'gradientZMax',function(){
		return this._gradientZMax;
	});

	GradientVelocity.createByConstant=function(constant){
		var gradientVelocity=new GradientVelocity();
		gradientVelocity._type=0;
		gradientVelocity._constant=constant;
		return gradientVelocity;
	}

	GradientVelocity.createByGradient=function(gradientX,gradientY,gradientZ){
		var gradientVelocity=new GradientVelocity();
		gradientVelocity._type=1;
		gradientVelocity._gradientX=gradientX;
		gradientVelocity._gradientY=gradientY;
		gradientVelocity._gradientZ=gradientZ;
		return gradientVelocity;
	}

	GradientVelocity.createByRandomTwoConstant=function(constantMin,constantMax){
		var gradientVelocity=new GradientVelocity();
		gradientVelocity._type=2;
		gradientVelocity._constantMin=constantMin;
		gradientVelocity._constantMax=constantMax;
		return gradientVelocity;
	}

	GradientVelocity.createByRandomTwoGradient=function(gradientXMin,gradientXMax,gradientYMin,gradientYMax,gradientZMin,gradientZMax){
		var gradientVelocity=new GradientVelocity();
		gradientVelocity._type=3;
		gradientVelocity._gradientXMin=gradientXMin;
		gradientVelocity._gradientXMax=gradientXMax;
		gradientVelocity._gradientYMin=gradientYMin;
		gradientVelocity._gradientYMax=gradientYMax;
		gradientVelocity._gradientZMin=gradientZMin;
		gradientVelocity._gradientZMax=gradientZMax;
		return gradientVelocity;
	}

	return GradientVelocity;
})()


/**
*<code>RotationOverLifetime</code> 类用于粒子的生命周期旋转。
*/
//class laya.d3.core.particleShuriKen.module.RotationOverLifetime
var RotationOverLifetime=(function(){
	function RotationOverLifetime(angularVelocity){
		/**@private */
		this._angularVelocity=null;
		/**是否启用*/
		this.enbale=false;
		this._angularVelocity=angularVelocity;
	}

	__class(RotationOverLifetime,'laya.d3.core.particleShuriKen.module.RotationOverLifetime');
	var __proto=RotationOverLifetime.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destRotationOverLifetime=destObject;
		this._angularVelocity.cloneTo(destRotationOverLifetime._angularVelocity);
		destRotationOverLifetime.enbale=this.enbale;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destAngularVelocity;
		switch (this._angularVelocity.type){
			case 0:
				if (this._angularVelocity.separateAxes)
					destAngularVelocity=GradientAngularVelocity.createByConstantSeparate(this._angularVelocity.constantSeparate.clone());
				else
				destAngularVelocity=GradientAngularVelocity.createByConstant(this._angularVelocity.constant);
				break ;
			case 1:
				if (this._angularVelocity.separateAxes)
					destAngularVelocity=GradientAngularVelocity.createByGradientSeparate(this._angularVelocity.gradientX.clone(),this._angularVelocity.gradientY.clone(),this._angularVelocity.gradientZ.clone(),this._angularVelocity.gradientW.clone());
				else
				destAngularVelocity=GradientAngularVelocity.createByGradient(this._angularVelocity.gradient.clone());
				break ;
			case 2:
				if (this._angularVelocity.separateAxes)
					destAngularVelocity=GradientAngularVelocity.createByRandomTwoConstantSeparate(this._angularVelocity.constantMinSeparate.clone(),this._angularVelocity.constantMaxSeparate.clone());
				else
				destAngularVelocity=GradientAngularVelocity.createByRandomTwoConstant(this._angularVelocity.constantMin,this._angularVelocity.constantMax);
				break ;
			case 3:
				if (this._angularVelocity.separateAxes)
					destAngularVelocity=GradientAngularVelocity.createByRandomTwoGradientSeparate(this._angularVelocity.gradientXMin.clone(),this._angularVelocity.gradientYMin.clone(),this._angularVelocity.gradientZMin.clone(),this._angularVelocity.gradientWMin.clone(),this._angularVelocity.gradientXMax.clone(),this._angularVelocity.gradientYMax.clone(),this._angularVelocity.gradientZMax.clone(),this._angularVelocity.gradientWMax.clone());
				else
				destAngularVelocity=GradientAngularVelocity.createByRandomTwoGradient(this._angularVelocity.gradientMin.clone(),this._angularVelocity.gradientMax.clone());
				break ;
			};
		var destRotationOverLifetime=/*__JS__ */new this.constructor(destAngularVelocity);
		destRotationOverLifetime.enbale=this.enbale;
		return destRotationOverLifetime;
	}

	/**
	*获取角速度。
	*/
	__getset(0,__proto,'angularVelocity',function(){
		return this._angularVelocity;
	});

	return RotationOverLifetime;
})()


/**
*<code>BaseShape</code> 类用于粒子形状。
*/
//class laya.d3.core.particleShuriKen.module.shape.BaseShape
var BaseShape=(function(){
	function BaseShape(){
		/**是否启用。*/
		this.enable=false;
		/**随机方向。*/
		this.randomDirection=false;
	}

	__class(BaseShape,'laya.d3.core.particleShuriKen.module.shape.BaseShape');
	var __proto=BaseShape.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**@private */
	__proto._getShapeBoundBox=function(boundBox){
		throw new Error("BaseShape: must override it.");
	}

	/**@private */
	__proto._getSpeedBoundBox=function(boundBox){
		throw new Error("BaseShape: must override it.");
	}

	/**
	*用于生成粒子初始位置和方向。
	*@param position 粒子位置。
	*@param direction 粒子方向。
	*/
	__proto.generatePositionAndDirection=function(position,direction,rand,randomSeeds){
		throw new Error("BaseShape: must override it.");
	}

	/**
	*@private
	*/
	__proto._calculateProceduralBounds=function(boundBox,emitterPosScale,minMaxBounds){
		this._getShapeBoundBox(boundBox);
		var min=boundBox.min;
		var max=boundBox.max;
		Vector3.multiply(min,emitterPosScale,min);
		Vector3.multiply(max,emitterPosScale,max);
		var speedBounds=new BoundBox(new Vector3(),new Vector3());
		if (this.randomDirection){
			speedBounds.min=new Vector3(-1,-1,-1);
			speedBounds.max=new Vector3(1,1,1);
		}
		else{
			this._getSpeedBoundBox(speedBounds);
		};
		var maxSpeedBound=new BoundBox(new Vector3(),new Vector3());
		var maxSpeedMin=maxSpeedBound.min;
		var maxSpeedMax=maxSpeedBound.max;
		Vector3.scale(speedBounds.min,minMaxBounds.y,maxSpeedMin);
		Vector3.scale(speedBounds.max,minMaxBounds.y,maxSpeedMax);
		Vector3.add(boundBox.min,maxSpeedMin,maxSpeedMin);
		Vector3.add(boundBox.max,maxSpeedMax,maxSpeedMax);
		Vector3.min(boundBox.min,maxSpeedMin,boundBox.min);
		Vector3.max(boundBox.max,maxSpeedMin,boundBox.max);
		var minSpeedBound=new BoundBox(new Vector3(),new Vector3());
		var minSpeedMin=minSpeedBound.min;
		var minSpeedMax=minSpeedBound.max;
		Vector3.scale(speedBounds.min,minMaxBounds.x,minSpeedMin);
		Vector3.scale(speedBounds.max,minMaxBounds.x,minSpeedMax);
		Vector3.min(minSpeedBound.min,minSpeedMax,maxSpeedMin);
		Vector3.max(minSpeedBound.min,minSpeedMax,maxSpeedMax);
		Vector3.min(boundBox.min,maxSpeedMin,boundBox.min);
		Vector3.max(boundBox.max,maxSpeedMin,boundBox.max);
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destShape=destObject;
		destShape.enable=this.enable;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destShape=/*__JS__ */new this.constructor();
		this.cloneTo(destShape);
		return destShape;
	}

	return BaseShape;
})()


/**
*...
*@author ...
*/
//class laya.d3.core.particleShuriKen.module.shape.ShapeUtils
var ShapeUtils=(function(){
	function ShapeUtils(){}
	__class(ShapeUtils,'laya.d3.core.particleShuriKen.module.shape.ShapeUtils');
	ShapeUtils._randomPointUnitArcCircle=function(arc,out,rand){
		var outE=out.elements;
		var angle=NaN;
		if (rand)
			angle=rand.getFloat()*arc;
		else
		angle=Math.random()*arc;
		outE[0]=Math.cos(angle);
		outE[1]=Math.sin(angle);
	}

	ShapeUtils._randomPointInsideUnitArcCircle=function(arc,out,rand){
		var outE=out.elements;
		ShapeUtils._randomPointUnitArcCircle(arc,out,rand);
		var range=NaN;
		if (rand)
			range=Math.pow(rand.getFloat(),1.0 / 2.0);
		else
		range=Math.pow(Math.random(),1.0 / 2.0);
		outE[0]=outE[0] *range;
		outE[1]=outE[1] *range;
	}

	ShapeUtils._randomPointUnitCircle=function(out,rand){
		var outE=out.elements;
		var angle=NaN;
		if (rand)
			angle=rand.getFloat()*Math.PI *2;
		else
		angle=Math.random()*Math.PI *2;
		outE[0]=Math.cos(angle);
		outE[1]=Math.sin(angle);
	}

	ShapeUtils._randomPointInsideUnitCircle=function(out,rand){
		var outE=out.elements;
		ShapeUtils._randomPointUnitCircle(out);
		var range=NaN;
		if (rand)
			range=Math.pow(rand.getFloat(),1.0 / 2.0);
		else
		range=Math.pow(Math.random(),1.0 / 2.0);
		outE[0]=outE[0] *range;
		outE[1]=outE[1] *range;
	}

	ShapeUtils._randomPointUnitSphere=function(out,rand){
		var outE=out.elements;
		var z=NaN;
		var a=NaN;
		if (rand){
			z=outE[2]=rand.getFloat()*2-1.0;
			a=rand.getFloat()*Math.PI *2;
			}else {
			z=outE[2]=Math.random()*2-1.0;
			a=Math.random()*Math.PI *2;
		};
		var r=Math.sqrt(1.0-z *z);
		outE[0]=r *Math.cos(a);
		outE[1]=r *Math.sin(a);
	}

	ShapeUtils._randomPointInsideUnitSphere=function(out,rand){
		var outE=out.elements;
		ShapeUtils._randomPointUnitSphere(out);
		var range=NaN;
		if (rand)
			range=Math.pow(rand.getFloat(),1.0 / 3.0);
		else
		range=Math.pow(Math.random(),1.0 / 3.0);
		outE[0]=outE[0] *range;
		outE[1]=outE[1] *range;
		outE[2]=outE[2] *range;
	}

	ShapeUtils._randomPointInsideHalfUnitBox=function(out,rand){
		var outE=out.elements;
		if (rand){
			outE[0]=(rand.getFloat()-0.5);
			outE[1]=(rand.getFloat()-0.5);
			outE[2]=(rand.getFloat()-0.5);
			}else {
			outE[0]=(Math.random()-0.5);
			outE[1]=(Math.random()-0.5);
			outE[2]=(Math.random()-0.5);
		}
	}

	return ShapeUtils;
})()


/**
*<code>SizeOverLifetime</code> 类用于粒子的生命周期尺寸。
*/
//class laya.d3.core.particleShuriKen.module.SizeOverLifetime
var SizeOverLifetime=(function(){
	function SizeOverLifetime(size){
		/**@private */
		this._size=null;
		/**是否启用*/
		this.enbale=false;
		this._size=size;
	}

	__class(SizeOverLifetime,'laya.d3.core.particleShuriKen.module.SizeOverLifetime');
	var __proto=SizeOverLifetime.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destSizeOverLifetime=destObject;
		this._size.cloneTo(destSizeOverLifetime._size);
		destSizeOverLifetime.enbale=this.enbale;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destSize;
		switch (this._size.type){
			case 0:
				if (this._size.separateAxes)
					destSize=GradientSize.createByGradientSeparate(this._size.gradientX.clone(),this._size.gradientY.clone(),this._size.gradientZ.clone());
				else
				destSize=GradientSize.createByGradient(this._size.gradient.clone());
				break ;
			case 1:
				if (this._size.separateAxes)
					destSize=GradientSize.createByRandomTwoConstantSeparate(this._size.constantMinSeparate.clone(),this._size.constantMaxSeparate.clone());
				else
				destSize=GradientSize.createByRandomTwoConstant(this._size.constantMin,this._size.constantMax);
				break ;
			case 2:
				if (this._size.separateAxes)
					destSize=GradientSize.createByRandomTwoGradientSeparate(this._size.gradientXMin.clone(),this._size.gradientYMin.clone(),this._size.gradientZMin.clone(),this._size.gradientXMax.clone(),this._size.gradientYMax.clone(),this._size.gradientZMax.clone());
				else
				destSize=GradientSize.createByRandomTwoGradient(this._size.gradientMin.clone(),this._size.gradientMax.clone());
				break ;
			};
		var destSizeOverLifetime=/*__JS__ */new this.constructor(destSize);
		destSizeOverLifetime.enbale=this.enbale;
		return destSizeOverLifetime;
	}

	/**
	*获取尺寸。
	*/
	__getset(0,__proto,'size',function(){
		return this._size;
	});

	return SizeOverLifetime;
})()


/**
*<code>StartFrame</code> 类用于创建开始帧。
*/
//class laya.d3.core.particleShuriKen.module.StartFrame
var StartFrame=(function(){
	function StartFrame(){
		/**@private */
		this._type=0;
		/**@private */
		this._constant=NaN;
		/**@private */
		this._constantMin=NaN;
		/**@private */
		this._constantMax=NaN;
	}

	__class(StartFrame,'laya.d3.core.particleShuriKen.module.StartFrame');
	var __proto=StartFrame.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destStartFrame=destObject;
		destStartFrame._type=this._type;
		destStartFrame._constant=this._constant;
		destStartFrame._constantMin=this._constantMin;
		destStartFrame._constantMax=this._constantMax;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destStartFrame=/*__JS__ */new this.constructor();
		this.cloneTo(destStartFrame);
		return destStartFrame;
	}

	/**
	*固定帧。
	*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*开始帧类型,0常量模式，1随机双常量模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*最小固定帧。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*最大固定帧。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	StartFrame.createByConstant=function(constant){
		var rotationOverLifetime=new StartFrame();
		rotationOverLifetime._type=0;
		rotationOverLifetime._constant=constant;
		return rotationOverLifetime;
	}

	StartFrame.createByRandomTwoConstant=function(constantMin,constantMax){
		var rotationOverLifetime=new StartFrame();
		rotationOverLifetime._type=1;
		rotationOverLifetime._constantMin=constantMin;
		rotationOverLifetime._constantMax=constantMax;
		return rotationOverLifetime;
	}

	return StartFrame;
})()


/**
*<code>TextureSheetAnimation</code> 类用于创建粒子帧动画。
*/
//class laya.d3.core.particleShuriKen.module.TextureSheetAnimation
var TextureSheetAnimation=(function(){
	function TextureSheetAnimation(frame,startFrame){
		/**@private */
		this._frame=null;
		/**@private */
		this._startFrame=null;
		/**纹理平铺。*/
		this.tiles=null;
		/**类型,0为whole sheet、1为singal row。*/
		this.type=0;
		/**是否随机行，type为1时有效。*/
		this.randomRow=false;
		/**行索引,type为1时有效。*/
		this.rowIndex=0;
		/**循环次数。*/
		this.cycles=0;
		/**UV通道类型,0为Noting,1为Everything,待补充,暂不支持。*/
		this.enableUVChannels=0;
		/**是否启用*/
		this.enable=false;
		this.tiles=new Vector2(1,1);
		this.type=0;
		this.randomRow=true;
		this.rowIndex=0;
		this.cycles=1;
		this.enableUVChannels=1;
		this._frame=frame;
		this._startFrame=startFrame;
	}

	__class(TextureSheetAnimation,'laya.d3.core.particleShuriKen.module.TextureSheetAnimation');
	var __proto=TextureSheetAnimation.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destTextureSheetAnimation=destObject;
		this.tiles.cloneTo(destTextureSheetAnimation.tiles);
		destTextureSheetAnimation.type=this.type;
		destTextureSheetAnimation.randomRow=this.randomRow;
		this._frame.cloneTo(destTextureSheetAnimation._frame);
		this._startFrame.cloneTo(destTextureSheetAnimation._startFrame);
		destTextureSheetAnimation.cycles=this.cycles;
		destTextureSheetAnimation.enableUVChannels=this.enableUVChannels;
		destTextureSheetAnimation.enable=this.enable;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destFrame;
		switch (this._frame.type){
			case 0:
				destFrame=FrameOverTime.createByConstant(this._frame.constant);
				break ;
			case 1:
				destFrame=FrameOverTime.createByOverTime(this._frame.frameOverTimeData.clone());
				break ;
			case 2:
				destFrame=FrameOverTime.createByRandomTwoConstant(this._frame.constantMin,this._frame.constantMax);
				break ;
			case 3:
				destFrame=FrameOverTime.createByRandomTwoOverTime(this._frame.frameOverTimeDataMin.clone(),this._frame.frameOverTimeDataMax.clone());
				break ;
			};
		var destStartFrame;
		switch (this._startFrame.type){
			case 0:
				destStartFrame=StartFrame.createByConstant(this._startFrame.constant);
				break ;
			case 1:
				destStartFrame=StartFrame.createByRandomTwoConstant(this._startFrame.constantMin,this._startFrame.constantMax);
				break ;
			};
		var destTextureSheetAnimation=/*__JS__ */new this.constructor(destFrame,destStartFrame);
		this.tiles.cloneTo(destTextureSheetAnimation.tiles);
		destTextureSheetAnimation.type=this.type;
		destTextureSheetAnimation.randomRow=this.randomRow;
		destTextureSheetAnimation.cycles=this.cycles;
		destTextureSheetAnimation.enableUVChannels=this.enableUVChannels;
		destTextureSheetAnimation.enable=this.enable;
		return destTextureSheetAnimation;
	}

	/**获取时间帧率。*/
	__getset(0,__proto,'frame',function(){
		return this._frame;
	});

	/**获取开始帧率。*/
	__getset(0,__proto,'startFrame',function(){
		return this._startFrame;
	});

	return TextureSheetAnimation;
})()


/**
*<code>VelocityOverLifetime</code> 类用于粒子的生命周期速度。
*/
//class laya.d3.core.particleShuriKen.module.VelocityOverLifetime
var VelocityOverLifetime=(function(){
	function VelocityOverLifetime(velocity){
		/**@private */
		this._velocity=null;
		/**是否启用*/
		this.enbale=false;
		/**速度空间,0为local,1为world。*/
		this.space=0;
		this._velocity=velocity;
	}

	__class(VelocityOverLifetime,'laya.d3.core.particleShuriKen.module.VelocityOverLifetime');
	var __proto=VelocityOverLifetime.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destVelocityOverLifetime=destObject;
		this._velocity.cloneTo(destVelocityOverLifetime._velocity);
		destVelocityOverLifetime.enbale=this.enbale;
		destVelocityOverLifetime.space=this.space;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destVelocity;
		switch(this._velocity.type){
			case 0:
				destVelocity=GradientVelocity.createByConstant(this._velocity.constant.clone());
				break ;
			case 1:
				destVelocity=GradientVelocity.createByGradient(this._velocity.gradientX.clone(),this._velocity.gradientY.clone(),this._velocity.gradientZ.clone());
				break ;
			case 2:
				destVelocity=GradientVelocity.createByRandomTwoConstant(this._velocity.constantMin.clone(),this._velocity.constantMax.clone());
				break ;
			case 3:
				destVelocity=GradientVelocity.createByRandomTwoGradient(this._velocity.gradientXMin.clone(),this._velocity.gradientYMin.clone(),this._velocity.gradientZMin.clone(),this._velocity.gradientXMax.clone(),this._velocity.gradientYMax.clone(),this._velocity.gradientZMax.clone());
				break ;
			};
		var destVelocityOverLifetime=/*__JS__ */new this.constructor(destVelocity);
		destVelocityOverLifetime.enbale=this.enbale;
		destVelocityOverLifetime.space=this.space;
		return destVelocityOverLifetime;
	}

	/**
	*获取尺寸。
	*/
	__getset(0,__proto,'velocity',function(){
		return this._velocity;
	});

	return VelocityOverLifetime;
})()


/**
*@private
*/
//class laya.d3.core.particleShuriKen.ShurikenParticleData
var ShurikenParticleData=(function(){
	function ShurikenParticleData(){}
	__class(ShurikenParticleData,'laya.d3.core.particleShuriKen.ShurikenParticleData');
	ShurikenParticleData._getStartLifetimeFromGradient=function(startLifeTimeGradient,emissionTime){
		for (var i=1,n=startLifeTimeGradient.gradientCount;i < n;i++){
			var key=startLifeTimeGradient.getKeyByIndex(i);
			if (key >=emissionTime){
				var lastKey=startLifeTimeGradient.getKeyByIndex(i-1);
				var age=(emissionTime-lastKey)/ (key-lastKey);
				return MathUtil.lerp(startLifeTimeGradient.getValueByIndex(i-1),startLifeTimeGradient.getValueByIndex(i),age)
			}
		}
		throw new Error("ShurikenParticleData: can't get value foam startLifeTimeGradient.");
	}

	ShurikenParticleData._randomInvertRoationArray=function(rotatonE,outE,randomizeRotationDirection,rand,randomSeeds){
		var randDic=NaN;
		if (rand){
			rand.seed=randomSeeds[6];
			randDic=rand.getFloat();
			randomSeeds[6]=rand.seed;
			}else {
			randDic=Math.random();
		}
		if (randDic < randomizeRotationDirection){
			outE[0]=-rotatonE[0];
			outE[1]=-rotatonE[1];
			outE[2]=-rotatonE[2];
			}else {
			outE[0]=rotatonE[0];
			outE[1]=rotatonE[1];
			outE[2]=rotatonE[2];
		}
	}

	ShurikenParticleData._randomInvertRoation=function(rotaton,randomizeRotationDirection,rand,randomSeeds){
		var randDic=NaN;
		if (rand){
			rand.seed=randomSeeds[6];
			randDic=rand.getFloat();
			randomSeeds[6]=rand.seed;
			}else {
			randDic=Math.random();
		}
		if (randDic < randomizeRotationDirection)
			rotaton=-rotaton;
		return rotaton;
	}

	ShurikenParticleData.create=function(particleSystem,particleRender,transform){
		var autoRandomSeed=particleSystem.autoRandomSeed;
		var rand=particleSystem._rand;
		var randomSeeds=particleSystem._randomSeeds;
		switch (particleSystem.startColorType){
			case 0:;
				var constantStartColorE=particleSystem.startColorConstant.elements;
				ShurikenParticleData.startColor[0]=constantStartColorE[0];
				ShurikenParticleData.startColor[1]=constantStartColorE[1];
				ShurikenParticleData.startColor[2]=constantStartColorE[2];
				ShurikenParticleData.startColor[3]=constantStartColorE[3];
				break ;
			case 2:
				if (autoRandomSeed){
					MathUtil.lerpVector4(particleSystem.startColorConstantMin.elements,particleSystem.startColorConstantMax.elements,Math.random(),ShurikenParticleData.startColor);
					}else {
					rand.seed=randomSeeds[3];
					MathUtil.lerpVector4(particleSystem.startColorConstantMin.elements,particleSystem.startColorConstantMax.elements,rand.getFloat(),ShurikenParticleData.startColor);
					randomSeeds[3]=rand.seed;
				}
				break ;
			};
		var colorOverLifetime=particleSystem.colorOverLifetime;
		if (colorOverLifetime && colorOverLifetime.enbale){
			var color=colorOverLifetime.color;
			switch (color.type){
				case 0:
					ShurikenParticleData.startColor[0]=ShurikenParticleData.startColor[0] *color.constant.x;
					ShurikenParticleData.startColor[1]=ShurikenParticleData.startColor[1] *color.constant.y;
					ShurikenParticleData.startColor[2]=ShurikenParticleData.startColor[2] *color.constant.z;
					ShurikenParticleData.startColor[3]=ShurikenParticleData.startColor[3] *color.constant.w;
					break ;
				case 2:;
					var colorRandom=NaN;
					if (autoRandomSeed){
						colorRandom=Math.random();
						}else {
						rand.seed=randomSeeds[10];
						colorRandom=rand.getFloat();
						randomSeeds[10]=rand.seed;
					};
					var minConstantColor=color.constantMin;
					var maxConstantColor=color.constantMax;
					ShurikenParticleData.startColor[0]=ShurikenParticleData.startColor[0] *MathUtil.lerp(minConstantColor.x,maxConstantColor.x,colorRandom);
					ShurikenParticleData.startColor[1]=ShurikenParticleData.startColor[1] *MathUtil.lerp(minConstantColor.y,maxConstantColor.y,colorRandom);
					ShurikenParticleData.startColor[2]=ShurikenParticleData.startColor[2] *MathUtil.lerp(minConstantColor.z,maxConstantColor.z,colorRandom);
					ShurikenParticleData.startColor[3]=ShurikenParticleData.startColor[3] *MathUtil.lerp(minConstantColor.w,maxConstantColor.w,colorRandom);
					break ;
				}
		};
		var particleSize=ShurikenParticleData.startSize;
		switch (particleSystem.startSizeType){
			case 0:
				if (particleSystem.threeDStartSize){
					var startSizeConstantSeparate=particleSystem.startSizeConstantSeparate;
					particleSize[0]=startSizeConstantSeparate.x;
					particleSize[1]=startSizeConstantSeparate.y;
					particleSize[2]=startSizeConstantSeparate.z;
					}else {
					particleSize[0]=particleSize[1]=particleSize[2]=particleSystem.startSizeConstant;
				}
				break ;
			case 2:
				if (particleSystem.threeDStartSize){
					var startSizeConstantMinSeparate=particleSystem.startSizeConstantMinSeparate;
					var startSizeConstantMaxSeparate=particleSystem.startSizeConstantMaxSeparate;
					if (autoRandomSeed){
						particleSize[0]=MathUtil.lerp(startSizeConstantMinSeparate.x,startSizeConstantMaxSeparate.x,Math.random());
						particleSize[1]=MathUtil.lerp(startSizeConstantMinSeparate.y,startSizeConstantMaxSeparate.y,Math.random());
						particleSize[2]=MathUtil.lerp(startSizeConstantMinSeparate.z,startSizeConstantMaxSeparate.z,Math.random());
						}else {
						rand.seed=randomSeeds[4];
						particleSize[0]=MathUtil.lerp(startSizeConstantMinSeparate.x,startSizeConstantMaxSeparate.x,rand.getFloat());
						particleSize[1]=MathUtil.lerp(startSizeConstantMinSeparate.y,startSizeConstantMaxSeparate.y,rand.getFloat());
						particleSize[2]=MathUtil.lerp(startSizeConstantMinSeparate.z,startSizeConstantMaxSeparate.z,rand.getFloat());
						randomSeeds[4]=rand.seed;
					}
					}else {
					if (autoRandomSeed){
						particleSize[0]=particleSize[1]=particleSize[2]=MathUtil.lerp(particleSystem.startSizeConstantMin,particleSystem.startSizeConstantMax,Math.random());
						}else {
						rand.seed=randomSeeds[4];
						particleSize[0]=particleSize[1]=particleSize[2]=MathUtil.lerp(particleSystem.startSizeConstantMin,particleSystem.startSizeConstantMax,rand.getFloat());
						randomSeeds[4]=rand.seed;
					}
				}
				break ;
			};
		var sizeOverLifetime=particleSystem.sizeOverLifetime;
		if (sizeOverLifetime && sizeOverLifetime.enbale && sizeOverLifetime.size.type===1){
			var size=sizeOverLifetime.size;
			if (size.separateAxes){
				if (autoRandomSeed){
					particleSize[0]=particleSize[0] *MathUtil.lerp(size.constantMinSeparate.x,size.constantMaxSeparate.x,Math.random());
					particleSize[1]=particleSize[1] *MathUtil.lerp(size.constantMinSeparate.y,size.constantMaxSeparate.y,Math.random());
					particleSize[2]=particleSize[2] *MathUtil.lerp(size.constantMinSeparate.z,size.constantMaxSeparate.z,Math.random());
					}else {
					rand.seed=randomSeeds[11];
					particleSize[0]=particleSize[0] *MathUtil.lerp(size.constantMinSeparate.x,size.constantMaxSeparate.x,rand.getFloat());
					particleSize[1]=particleSize[1] *MathUtil.lerp(size.constantMinSeparate.y,size.constantMaxSeparate.y,rand.getFloat());
					particleSize[2]=particleSize[2] *MathUtil.lerp(size.constantMinSeparate.z,size.constantMaxSeparate.z,rand.getFloat());
					randomSeeds[11]=rand.seed;
				}
				}else {
				var randomSize=NaN;
				if (autoRandomSeed){
					randomSize=MathUtil.lerp(size.constantMin,size.constantMax,Math.random());
					}else {
					rand.seed=randomSeeds[11];
					randomSize=MathUtil.lerp(size.constantMin,size.constantMax,rand.getFloat());
					randomSeeds[11]=rand.seed;
				}
				particleSize[0]=particleSize[0] *randomSize;
				particleSize[1]=particleSize[1] *randomSize;
				particleSize[2]=particleSize[2] *randomSize;
			}
		};
		var renderMode=particleRender.renderMode;
		if (renderMode!==1){
			switch (particleSystem.startRotationType){
				case 0:
					if (particleSystem.threeDStartRotation){
						var startRotationConstantSeparate=particleSystem.startRotationConstantSeparate;
						var randomRotationE=ShurikenParticleData._tempVector30.elements;
						ShurikenParticleData._randomInvertRoationArray(startRotationConstantSeparate.elements,randomRotationE,particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
						ShurikenParticleData.startRotation[0]=randomRotationE[0];
						ShurikenParticleData.startRotation[1]=randomRotationE[1];
						if (renderMode!==4)
							ShurikenParticleData.startRotation[2]=-randomRotationE[2];
						else
						ShurikenParticleData.startRotation[2]=randomRotationE[2];
						}else {
						ShurikenParticleData.startRotation[0]=ShurikenParticleData._randomInvertRoation(particleSystem.startRotationConstant,particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
					}
					break ;
				case 2:
					if (particleSystem.threeDStartRotation){
						var startRotationConstantMinSeparate=particleSystem.startRotationConstantMinSeparate;
						var startRotationConstantMaxSeparate=particleSystem.startRotationConstantMaxSeparate;
						var lerpRoationE=ShurikenParticleData._tempVector30.elements;
						if (autoRandomSeed){
							lerpRoationE[0]=MathUtil.lerp(startRotationConstantMinSeparate.x,startRotationConstantMaxSeparate.x,Math.random());
							lerpRoationE[1]=MathUtil.lerp(startRotationConstantMinSeparate.y,startRotationConstantMaxSeparate.y,Math.random());
							lerpRoationE[2]=MathUtil.lerp(startRotationConstantMinSeparate.z,startRotationConstantMaxSeparate.z,Math.random());
							}else {
							rand.seed=randomSeeds[5];
							lerpRoationE[0]=MathUtil.lerp(startRotationConstantMinSeparate.x,startRotationConstantMaxSeparate.x,rand.getFloat());
							lerpRoationE[1]=MathUtil.lerp(startRotationConstantMinSeparate.y,startRotationConstantMaxSeparate.y,rand.getFloat());
							lerpRoationE[2]=MathUtil.lerp(startRotationConstantMinSeparate.z,startRotationConstantMaxSeparate.z,rand.getFloat());
							randomSeeds[5]=rand.seed;
						}
						ShurikenParticleData._randomInvertRoationArray(lerpRoationE,lerpRoationE,particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
						ShurikenParticleData.startRotation[0]=lerpRoationE[0];
						ShurikenParticleData.startRotation[1]=lerpRoationE[1];
						if (renderMode!==4)
							ShurikenParticleData.startRotation[2]=-lerpRoationE[2];
						else
						ShurikenParticleData.startRotation[2]=lerpRoationE[2];
						}else {
						if (autoRandomSeed){
							ShurikenParticleData.startRotation[0]=ShurikenParticleData._randomInvertRoation(MathUtil.lerp(particleSystem.startRotationConstantMin,particleSystem.startRotationConstantMax,Math.random()),particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
							}else {
							rand.seed=randomSeeds[5];
							ShurikenParticleData.startRotation[0]=ShurikenParticleData._randomInvertRoation(MathUtil.lerp(particleSystem.startRotationConstantMin,particleSystem.startRotationConstantMax,rand.getFloat()),particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
							randomSeeds[5]=rand.seed;
						}
					}
					break ;
				}
		}
		switch (particleSystem.startLifetimeType){
			case 0:
				ShurikenParticleData.startLifeTime=particleSystem.startLifetimeConstant;
				break ;
			case 1:
				ShurikenParticleData.startLifeTime=ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradient,particleSystem.emissionTime);
				break ;
			case 2:
				if (autoRandomSeed){
					ShurikenParticleData.startLifeTime=MathUtil.lerp(particleSystem.startLifetimeConstantMin,particleSystem.startLifetimeConstantMax,Math.random());
					}else {
					rand.seed=randomSeeds[7];
					ShurikenParticleData.startLifeTime=MathUtil.lerp(particleSystem.startLifetimeConstantMin,particleSystem.startLifetimeConstantMax,rand.getFloat());
					randomSeeds[7]=rand.seed;
				}
				break ;
			case 3:;
				var emissionTime=particleSystem.emissionTime;
				if (autoRandomSeed){
					ShurikenParticleData.startLifeTime=MathUtil.lerp(ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradientMin,emissionTime),ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradientMax,emissionTime),Math.random());
					}else {
					rand.seed=randomSeeds[7];
					ShurikenParticleData.startLifeTime=MathUtil.lerp(ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradientMin,emissionTime),ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradientMax,emissionTime),rand.getFloat());
					randomSeeds[7]=rand.seed;
				}
				break ;
			}
		switch (particleSystem.startSpeedType){
			case 0:
				ShurikenParticleData.startSpeed=particleSystem.startSpeedConstant;
				break ;
			case 2:
				if (autoRandomSeed){
					ShurikenParticleData.startSpeed=MathUtil.lerp(particleSystem.startSpeedConstantMin,particleSystem.startSpeedConstantMax,Math.random());
					}else {
					rand.seed=randomSeeds[8];
					ShurikenParticleData.startSpeed=MathUtil.lerp(particleSystem.startSpeedConstantMin,particleSystem.startSpeedConstantMax,rand.getFloat());
					randomSeeds[8]=rand.seed;
				}
				break ;
			};
		var textureSheetAnimation=particleSystem.textureSheetAnimation;
		var enableSheetAnimation=textureSheetAnimation && textureSheetAnimation.enable;
		if (enableSheetAnimation){
			var title=textureSheetAnimation.tiles;
			var titleX=title.x,titleY=title.y;
			var subU=1.0 / titleX,subV=1.0 / titleY;
			var startFrameCount=0;
			var startFrame=textureSheetAnimation.startFrame;
			switch (startFrame.type){
				case 0:
					startFrameCount=startFrame.constant;
					break ;
				case 1:
					if (autoRandomSeed){
						startFrameCount=MathUtil.lerp(startFrame.constantMin,startFrame.constantMax,Math.random());
						}else {
						rand.seed=randomSeeds[14];
						startFrameCount=MathUtil.lerp(startFrame.constantMin,startFrame.constantMax,rand.getFloat());
						randomSeeds[14]=rand.seed;
					}
					break ;
				};
			var frame=textureSheetAnimation.frame;
			switch (frame.type){
				case 0:
					startFrameCount+=frame.constant;
					break ;
				case 2:
					if (autoRandomSeed){
						startFrameCount+=MathUtil.lerp(frame.constantMin,frame.constantMax,Math.random());
						}else {
						rand.seed=randomSeeds[15];
						startFrameCount+=MathUtil.lerp(frame.constantMin,frame.constantMax,rand.getFloat());
						randomSeeds[15]=rand.seed;
					}
					break ;
				};
			var startRow=0;
			switch (textureSheetAnimation.type){
				case 0:
					startRow=Math.floor(startFrameCount / titleX);
					break ;
				case 1:
					if (textureSheetAnimation.randomRow){
						if (autoRandomSeed){
							startRow=Math.floor(Math.random()*titleY);
							}else {
							rand.seed=randomSeeds[13];
							startRow=Math.floor(rand.getFloat()*titleY);
							randomSeeds[13]=rand.seed;
						}
						}else {
						startRow=textureSheetAnimation.rowIndex;
					}
					break ;
				};
			var startCol=Math.floor(startFrameCount % titleX);
			ShurikenParticleData.startUVInfo=ShurikenParticleData.startUVInfo;
			ShurikenParticleData.startUVInfo[0]=subU;
			ShurikenParticleData.startUVInfo[1]=subV;
			ShurikenParticleData.startUVInfo[2]=startCol *subU;
			ShurikenParticleData.startUVInfo[3]=startRow *subV;
			}else {
			ShurikenParticleData.startUVInfo=ShurikenParticleData.startUVInfo;
			ShurikenParticleData.startUVInfo[0]=1.0;
			ShurikenParticleData.startUVInfo[1]=1.0;
			ShurikenParticleData.startUVInfo[2]=0.0;
			ShurikenParticleData.startUVInfo[3]=0.0;
		}
		switch (particleSystem.simulationSpace){
			case 0:;
				var positionE=transform.position.elements;
				ShurikenParticleData.simulationWorldPostion[0]=positionE[0];
				ShurikenParticleData.simulationWorldPostion[1]=positionE[1];
				ShurikenParticleData.simulationWorldPostion[2]=positionE[2];
				var rotationE=transform.rotation.elements;
				ShurikenParticleData.simulationWorldRotation[0]=rotationE[0];
				ShurikenParticleData.simulationWorldRotation[1]=rotationE[1];
				ShurikenParticleData.simulationWorldRotation[2]=rotationE[2];
				ShurikenParticleData.simulationWorldRotation[3]=rotationE[3];
				break ;
			case 1:
				break ;
			default :
				throw new Error("ShurikenParticleMaterial: SimulationSpace value is invalid.");
				break ;
			}
	}

	ShurikenParticleData.startLifeTime=NaN;
	ShurikenParticleData.startSpeed=NaN;
	__static(ShurikenParticleData,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempQuaternion',function(){return this._tempQuaternion=new Quaternion();},'startColor',function(){return this.startColor=new Float32Array(4);},'startSize',function(){return this.startSize=new Float32Array(3);},'startRotation',function(){return this.startRotation=new Float32Array(3);},'startUVInfo',function(){return this.startUVInfo=new Float32Array(4);},'simulationWorldPostion',function(){return this.simulationWorldPostion=new Float32Array(3);},'simulationWorldRotation',function(){return this.simulationWorldRotation=new Float32Array(4);}
	]);
	return ShurikenParticleData;
})()


/**
*@private
*<code>PhasorSpriter3D</code> 类用于创建矢量笔刷。
*/
//class laya.d3.core.PhasorSpriter3D
var PhasorSpriter3D=(function(){
	function PhasorSpriter3D(){
		this._tempInt0=0;
		this._tempInt1=0;
		this._tempUint0=0;
		this._tempUint1=0;
		this._tempUint2=0;
		this._tempUint3=0;
		this._tempUint4=0;
		this._tempUint5=0;
		this._tempUint6=0;
		this._tempUint7=0;
		this._tempNumver0=NaN;
		this._tempNumver1=NaN;
		this._tempNumver2=NaN;
		this._tempNumver3=NaN;
		this._floatSizePerVer=7;
		//顶点结构为Position(3个float)+Color(4个float)
		this._defaultBufferSize=600 *this._floatSizePerVer;
		this._vb=null;
		this._posInVBData=0;
		this._ib=null;
		this._posInIBData=0;
		this._primitiveType=NaN;
		this._hasBegun=false;
		this._numVertsPerPrimitive=0;
		this._camera=null;
		this._sharderNameID=0;
		this._shader=null;
		/**@private */
		this._shaderCompile=null;
		this._vbData=new Float32Array(this._defaultBufferSize);
		this._ibData=new Uint16Array(this._defaultBufferSize);
		this._spriteShaderValue=new ValusArray();
		;
		this._vb=VertexBuffer3D.create(PhasorSpriter3D._vertexDeclaration,this._defaultBufferSize / this._floatSizePerVer,/*laya.webgl.WebGLContext.DYNAMIC_DRAW*/0x88E8);
		this._ib=IndexBuffer3D.create(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",this._defaultBufferSize,/*laya.webgl.WebGLContext.DYNAMIC_DRAW*/0x88E8);
		this._sharderNameID=Shader3D.nameKey.getID("LINE");
		this._shaderCompile=ShaderCompile3D._preCompileShader[this._sharderNameID];
	}

	__class(PhasorSpriter3D,'laya.d3.core.PhasorSpriter3D');
	var __proto=PhasorSpriter3D.prototype;
	__proto.line=function(startPosition,startColor,endPosition,endColor){
		if (!this._hasBegun || this._primitiveType!==/*laya.webgl.WebGLContext.LINES*/0x0001)
			this.drawLinesException();
		if (this._posInVBData+2 *this._floatSizePerVer > this._vbData.length || this._posInIBData+2 > this._ibData.length)
			this.flush();
		this._tempUint0=this._posInVBData / this._floatSizePerVer;
		this.addVertex(startPosition.x,startPosition.y,startPosition.z,startColor.x,startColor.y,startColor.z,startColor.w);
		this.addVertex(endPosition.x,endPosition.y,endPosition.z,endColor.x,endColor.y,endColor.z,endColor.w);
		this.addIndexes(this._tempUint0,this._tempUint0+1);
		return this;
	}

	__proto.circle=function(radius,numberOfPoints,r,g,b,a){
		if (!this._hasBegun || (this._primitiveType!==/*laya.webgl.WebGLContext.LINES*/0x0001))
			this.drawLinesException();
		this._tempUint0=numberOfPoints *2;
		if (this._posInVBData+this._tempUint0 *this._floatSizePerVer > this._vbData.length || this._posInIBData+2 *this._tempUint0 > this._ibData.length)
			this.flush();
		this._tempUint1=this._posInVBData / this._floatSizePerVer;
		for (this._tempNumver0=0,this._tempInt0=0;this._tempNumver0 < 3.1416 *2;this._tempNumver0=this._tempNumver0+(3.1416 / numberOfPoints),this._tempInt0++){
			this.addVertex(Math.sin(this._tempNumver0)*radius,Math.cos(this._tempNumver0)*radius,0,r,g,b,a);
			if (this._tempInt0===0){
				this.addIndexes(this._tempUint1);
				}else if (this._tempInt0===this._tempUint0-1){
				this._tempUint2=this._tempUint1+this._tempInt0;
				this.addIndexes(this._tempUint2,this._tempUint2,this._tempUint1);
				}else {
				this._tempUint2=this._tempUint1+this._tempInt0;
				this.addIndexes(this._tempUint2,this._tempUint2);
			}
		}
		return this;
	}

	__proto.plane=function(positionX,positionY,positionZ,width,height,r,g,b,a){
		if (!this._hasBegun || this._primitiveType!==/*laya.webgl.WebGLContext.TRIANGLES*/0x0004)
			this.drawTrianglesException();
		if (this._posInVBData+4 *this._floatSizePerVer > this._vbData.length || this._posInIBData+6 > this._ibData.length)
			this.flush();
		this._tempNumver0=width / 2;
		this._tempNumver1=height / 2;
		this._tempUint0=this._posInVBData / this._floatSizePerVer;
		this.addVertex(positionX-this._tempNumver0,positionY+this._tempNumver1,positionZ,r,g,b,a);
		this.addVertex(positionX+this._tempNumver0,positionY+this._tempNumver1,positionZ,r,g,b,a);
		this.addVertex(positionX-this._tempNumver0,positionY-this._tempNumver1,positionZ,r,g,b,a);
		this.addVertex(positionX+this._tempNumver0,positionY-this._tempNumver1,positionZ,r,g,b,a);
		this._tempUint1=this._tempUint0+1;
		this._tempUint2=this._tempUint0+2;
		this.addIndexes(this._tempUint0,this._tempUint1,this._tempUint2,this._tempUint2,this._tempUint1,this._tempUint0+3);
		return this;
	}

	__proto.box=function(positionX,positionY,positionZ,width,height,depth,r,g,b,a){
		if (!this._hasBegun || this._primitiveType!==/*laya.webgl.WebGLContext.TRIANGLES*/0x0004)
			this.drawTrianglesException();
		if (this._posInVBData+8 *this._floatSizePerVer > this._vbData.length || this._posInIBData+36 > this._ibData.length)
			this.flush();
		this._tempNumver0=width / 2;
		this._tempNumver1=height / 2;
		this._tempNumver2=depth / 2;
		this._tempUint0=this._posInVBData / this._floatSizePerVer;
		this.addVertex(positionX-this._tempNumver0,positionY+this._tempNumver1,positionZ+this._tempNumver2,r,g,b,a);
		this.addVertex(positionX+this._tempNumver0,positionY+this._tempNumver1,positionZ+this._tempNumver2,r,g,b,a);
		this.addVertex(positionX-this._tempNumver0,positionY-this._tempNumver1,positionZ+this._tempNumver2,r,g,b,a);
		this.addVertex(positionX+this._tempNumver0,positionY-this._tempNumver1,positionZ+this._tempNumver2,r,g,b,a);
		this.addVertex(positionX+this._tempNumver0,positionY+this._tempNumver1,positionZ-this._tempNumver2,r,g,b,a);
		this.addVertex(positionX-this._tempNumver0,positionY+this._tempNumver1,positionZ-this._tempNumver2,r,g,b,a);
		this.addVertex(positionX+this._tempNumver0,positionY-this._tempNumver1,positionZ-this._tempNumver2,r,g,b,a);
		this.addVertex(positionX-this._tempNumver0,positionY-this._tempNumver1,positionZ-this._tempNumver2,r,g,b,a);
		this._tempUint1=this._tempUint0+1;
		this._tempUint2=this._tempUint0+2;
		this._tempUint3=this._tempUint0+3;
		this._tempUint4=this._tempUint0+4;
		this._tempUint5=this._tempUint0+5;
		this._tempUint6=this._tempUint0+6;
		this._tempUint7=this._tempUint0+7;
		this.addIndexes(this._tempUint0,this._tempUint1,this._tempUint2,this._tempUint2,this._tempUint1,this._tempUint3,
		this._tempUint4,this._tempUint5,this._tempUint6,this._tempUint6,this._tempUint5,this._tempUint7,
		this._tempUint5,this._tempUint0,this._tempUint7,this._tempUint7,this._tempUint0,this._tempUint2,
		this._tempUint1,this._tempUint4,this._tempUint3,this._tempUint3,this._tempUint4,this._tempUint6,
		this._tempUint5,this._tempUint4,this._tempUint0,this._tempUint0,this._tempUint4,this._tempUint1,
		this._tempUint2,this._tempUint3,this._tempUint7,this._tempUint7,this._tempUint3,this._tempUint6);
		return this;
	}

	__proto.cone=function(radius,length,Slices,r,g,b,a){
		if (!this._hasBegun || this._primitiveType!==/*laya.webgl.WebGLContext.TRIANGLES*/0x0004)
			this.drawTrianglesException();
		if (this._posInVBData+(2 *Slices+2)*this._floatSizePerVer > this._vbData.length || this._posInIBData+6 *Slices > this._ibData.length)
			this.flush();
		this._tempUint0=this._posInVBData;
		this._tempUint1=this._posInVBData / this._floatSizePerVer;
		this._tempNumver0=Math.PI *2 / Slices;
		this.addVertexIndex(0,length,0,r,g,b,a,this._tempUint0);
		this.addVertexIndex(0,0,0,r,g,b,a,this._tempUint0+this._floatSizePerVer);
		this._tempInt0=2;
		this._tempNumver1=0;
		for (this._tempInt1=0;this._tempInt1 < Slices;this._tempInt1++){
			this._tempNumver2=Math.cos(this._tempNumver1);
			this._tempNumver3=Math.sin(this._tempNumver1);
			this.addVertexIndex(radius *this._tempNumver2,0,radius *this._tempNumver3,r,g,b,a,this._tempUint0+this._tempInt0 *this._floatSizePerVer);
			this.addIndexes(this._tempUint1,this._tempUint1+this._tempInt0);
			if (this._tempInt1==Slices-1)
				this.addIndexes(this._tempUint1+2);
			else
			this.addIndexes(this._tempUint1+this._tempInt0+1);
			this.addVertexIndex(radius *this._tempNumver2,0,radius *this._tempNumver3,r,g,b,a,this._tempUint0+(this._tempInt0+Slices)*this._floatSizePerVer);
			this.addIndexes(this._tempUint1+1);
			if (this._tempInt1==Slices-1)
				this.addIndexes(this._tempUint1+Slices+2);
			else
			this.addIndexes(this._tempUint1+this._tempInt0+Slices+1);
			this.addIndexes(this._tempUint1+this._tempInt0+Slices);
			this._tempInt0++;
			this._tempNumver1+=this._tempNumver0;
		}
		return this;
	}

	__proto.boundingBoxLine=function(minX,minY,minZ,maxX,maxY,maxZ,r,g,b,a){
		if (!this._hasBegun || this._primitiveType!==/*laya.webgl.WebGLContext.LINES*/0x0001)
			this.drawLinesException();
		if (this._posInVBData+8 *this._floatSizePerVer > this._vbData.length || this._posInIBData+48 > this._ibData.length)
			this.flush();
		this._tempUint0=this._posInVBData / this._floatSizePerVer;
		this.addVertex(minX,maxY,maxZ,r,g,b,a);
		this.addVertex(maxX,maxY,maxZ,r,g,b,a);
		this.addVertex(minX,minY,maxZ,r,g,b,a);
		this.addVertex(maxX,minY,maxZ,r,g,b,a);
		this.addVertex(maxX,maxY,minZ,r,g,b,a);
		this.addVertex(minX,maxY,minZ,r,g,b,a);
		this.addVertex(maxX,minY,minZ,r,g,b,a);
		this.addVertex(minX,minY,minZ,r,g,b,a);
		this._tempUint1=this._tempUint0+1;
		this._tempUint2=this._tempUint0+2;
		this._tempUint3=this._tempUint0+3;
		this._tempUint4=this._tempUint0+4;
		this._tempUint5=this._tempUint0+5;
		this._tempUint6=this._tempUint0+6;
		this._tempUint7=this._tempUint0+7;
		this.addIndexes(this._tempUint0,this._tempUint1,this._tempUint1,this._tempUint3,this._tempUint3,this._tempUint2,this._tempUint2,this._tempUint0,
		this._tempUint4,this._tempUint5,this._tempUint5,this._tempUint7,this._tempUint7,this._tempUint6,this._tempUint6,this._tempUint4,
		this._tempUint5,this._tempUint0,this._tempUint0,this._tempUint2,this._tempUint2,this._tempUint7,this._tempUint7,this._tempUint5,
		this._tempUint1,this._tempUint4,this._tempUint4,this._tempUint6,this._tempUint6,this._tempUint3,this._tempUint3,this._tempUint1,
		this._tempUint5,this._tempUint4,this._tempUint4,this._tempUint1,this._tempUint1,this._tempUint0,this._tempUint0,this._tempUint5,
		this._tempUint2,this._tempUint3,this._tempUint3,this._tempUint6,this._tempUint6,this._tempUint7,this._tempUint7,this._tempUint2);
		return this;
	}

	__proto.addVertex=function(x,y,z,r,g,b,a){
		if (!this._hasBegun)
			this.addVertexIndexException();
		this._vbData[this._posInVBData]=x,this._vbData[this._posInVBData+1]=y,this._vbData[this._posInVBData+2]=z;
		this._vbData[this._posInVBData+3]=r,this._vbData[this._posInVBData+4]=g,this._vbData[this._posInVBData+5]=b,this._vbData[this._posInVBData+6]=a;
		this._posInVBData+=this._floatSizePerVer;
		return this;
	}

	__proto.addVertexIndex=function(x,y,z,r,g,b,a,index){
		if (!this._hasBegun)
			this.addVertexIndexException();
		this._vbData[index]=x,this._vbData[index+1]=y,this._vbData[index+2]=z;
		this._vbData[index+3]=r,this._vbData[index+4]=g,this._vbData[index+5]=b,this._vbData[index+6]=a;
		index+=this._floatSizePerVer;
		if (index > this._posInVBData)
			this._posInVBData=index;
		return this;
	}

	__proto.addIndexes=function(__indexes){
		var indexes=arguments;
		if (!this._hasBegun)
			this.addVertexIndexException();
		for (var i=0;i < indexes.length;i++){
			this._ibData[this._posInIBData]=indexes[i];
			this._posInIBData++;
		}
		return this;
	}

	__proto.begin=function(primitive,camera){
		if (this._hasBegun)
			this.beginException0();
		if (primitive!==/*laya.webgl.WebGLContext.LINES*/0x0001 && primitive!==/*laya.webgl.WebGLContext.TRIANGLES*/0x0004)
			this.beginException1();
		this._primitiveType=primitive;
		this._camera=camera;
		this._hasBegun=true;
		return this;
	}

	__proto.end=function(){
		if (!this._hasBegun)
			this.endException();
		this.flush();
		this._hasBegun=false;
		return this;
	}

	__proto.flush=function(){
		if (this._posInVBData===0)
			return;
		this._ib.setData(this._ibData);
		this._vb.setData(this._vbData);
		this._vb._bind();
		this._ib._bind();
		this._shader=this._shaderCompile.withCompile(0,0,0);
		this._shader.bind();
		this._shader.uploadAttributes(PhasorSpriter3D._vertexDeclaration.shaderValues.data,null);
		this._spriteShaderValue.setValue(/*laya.d3.core.Sprite3D.MVPMATRIX*/1,(this._camera).projectionViewMatrix.elements);
		this._shader.uploadSpriteUniforms(this._spriteShaderValue.data);
		Stat.drawCall++;
		WebGL.mainContext.drawElements(this._primitiveType,this._posInIBData,/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,0);
		this._posInIBData=0;
		this._posInVBData=0;
	}

	__proto.addVertexIndexException=function(){
		throw new Error("请先调用begin()函数");
	}

	__proto.beginException0=function(){
		throw new Error("调用begin()前请确保已成功调用end()！");
	}

	__proto.beginException1=function(){
		throw new Error("只支持“LINES”和“TRIANGLES”两种基元！");
	}

	__proto.endException=function(){
		throw new Error("调用end()前请确保已成功调用begin()！");
	}

	__proto.drawLinesException=function(){
		throw new Error("您必须确保在此之前已调用begin()且使用“LINES”基元！");
	}

	__proto.drawTrianglesException=function(){
		throw new Error("您必须确保在此之前已调用begin()且使用“TRIANGLES”基元！");
	}

	__static(PhasorSpriter3D,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(28,[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1)]);}
	]);
	return PhasorSpriter3D;
})()


/**
*@private
*<code>RenderElement</code> 类用于实现渲染物体。
*/
//class laya.d3.core.render.RenderElement
var RenderElement=(function(){
	function RenderElement(){
		/**@private */
		this._id=0;
		/**@private 类型0为默认，2为DynamicBatch。*/
		this._type=0;
		/**@private 排序ID。*/
		this._mainSortID=0;
		/**@private */
		this._render=null;
		/**@private 所属Sprite3D精灵。*/
		this._sprite3D=null;
		/**@private 渲染所用材质。*/
		this._material=null;
		/**@private 渲染元素。*/
		this._renderObj=null;
		/**@private */
		this._staticBatch=null;
		//...............临时...........................
		this._tempBatchIndexStart=0;
		//TODO:
		this._tempBatchIndexEnd=0;
		/**@private */
		this._canDynamicBatch=false;
		/**当前ShaderValue。*/
		this._shaderValue=null;
		this._onPreRenderFunction=null;
		this._id=++RenderElement._uniqueIDCounter;
		this._canDynamicBatch=true;
		this._shaderValue=new ValusArray();
	}

	__class(RenderElement,'laya.d3.core.render.RenderElement');
	var __proto=RenderElement.prototype;
	/**
	*@private
	*/
	__proto.getDynamicBatchBakedVertexs=function(index){
		var byteSizeInFloat=4;
		var vb=this._renderObj._getVertexBuffer(index);
		var bakedVertexes=vb.getData().slice();
		var vertexDeclaration=vb.vertexDeclaration;
		var positionOffset=vertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.VertexElementUsage.POSITION0*/0).offset / byteSizeInFloat;
		var normalOffset=vertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3).offset / byteSizeInFloat;
		var transform=this._sprite3D.transform;
		var worldMatrix=transform.worldMatrix;
		var rotation=transform.rotation;
		var vertexFloatCount=vertexDeclaration.vertexStride / byteSizeInFloat;
		for (var i=0,n=bakedVertexes.length;i < n;i+=vertexFloatCount){
			var posOffset=i+positionOffset;
			var norOffset=i+normalOffset;
			Utils3D.transformVector3ArrayToVector3ArrayCoordinate(bakedVertexes,posOffset,worldMatrix,bakedVertexes,posOffset);
			Utils3D.transformVector3ArrayByQuat(bakedVertexes,norOffset,rotation,bakedVertexes,norOffset);
		}
		return bakedVertexes;
	}

	/**
	*@private
	*/
	__proto.getBakedIndices=function(){
		return this._renderObj._getIndexBuffer().getData();
	}

	/**
	*@private
	*/
	__proto._destroy=function(){
		(this._staticBatch)&& (this._staticBatch._manager._garbageCollection(this));
	}

	/**
	*获取唯一标识ID,通常用于识别。
	*/
	__getset(0,__proto,'id',function(){
		return this._id;
	});

	__getset(0,__proto,'renderObj',function(){
		return this._renderObj;
		},function(value){
		if (this._renderObj!==value){
			this._renderObj=value;
		}
	});

	RenderElement._uniqueIDCounter=0;
	return RenderElement;
})()


/**
*@private
*<code>RenderQuene</code> 类用于实现渲染队列。
*/
//class laya.d3.core.render.RenderQueue
var RenderQueue=(function(){
	function RenderQueue(scene){
		/**@private */
		this._id=0;
		/**@private */
		this._needSort=false;
		/**@private */
		this._renderElements=null;
		/**@private */
		this._renderableRenderObjects=null;
		/**@private */
		this._dynamicBatchCombineRenderElements=null;
		/**@private */
		this._finalElements=null;
		/**@private */
		this._scene=null;
		this._id=++RenderQueue._uniqueIDCounter;
		this._needSort=false;
		this._scene=scene;
		this._renderElements=[];
		this._renderableRenderObjects=[];
		this._dynamicBatchCombineRenderElements=[];
	}

	__class(RenderQueue,'laya.d3.core.render.RenderQueue');
	var __proto=RenderQueue.prototype;
	__proto._sortOpaqueFunc=function(a,b){
		if (a._render && b._render){
			var renderQueue=a._material.renderQueue-b._material.renderQueue;
			if (renderQueue===0){
				return a._render._distanceForSort-b._render._distanceForSort;
				}else {
				return renderQueue
			}
			}else {
			return 0;
		}
	}

	__proto._sortAlphaFunc=function(a,b){
		if (a._render && b._render){
			var renderQueue=a._material.renderQueue-b._material.renderQueue;
			if (renderQueue===0){
				return b._render._distanceForSort-a._render._distanceForSort;
				}else {
				return renderQueue;
			}
		}else
		return 0;
	}

	/**
	*@private
	*/
	__proto._begainRenderElement=function(state,renderObj,material){
		if (renderObj._beforeRender(state)){
			return true;
		}
		return false;
	}

	/**
	*@private
	*/
	__proto._sortAlpha=function(cameraPos){
		RenderQueue._cameraPosition=cameraPos;
		this._finalElements.sort(this._sortAlphaFunc);
	}

	/**
	*@private
	*/
	__proto._sortOpaque=function(cameraPos){
		RenderQueue._cameraPosition=cameraPos;
		this._finalElements.sort(this._sortOpaqueFunc);
	}

	/**
	*@private
	*准备渲染队列。
	*@param state 渲染状态。
	*/
	__proto._preRender=function(state){
		this._finalElements=this._renderElements.concat(this._dynamicBatchCombineRenderElements);
	}

	/**
	*@private
	*渲染队列。
	*@param state 渲染状态。
	*/
	__proto._render=function(state,isTarget){
		var loopCount=Stat.loopCount;
		var scene=this._scene;
		var camera=state.camera;
		var cameraID=camera.id;
		var vbs;
		var vertexBuffer,vertexDeclaration,shader;
		var forceUploadParams=false;
		var lastStateMaterial,lastStateOwner;
		for (var i=0,n=this._finalElements.length;i < n;i++){
			var renderElement=this._finalElements[i];
			var renderObj,material,owner;
			if (renderElement._onPreRenderFunction !=null){
				renderElement._onPreRenderFunction.call(renderElement._sprite3D,state);
			}
			if (renderElement._type===0){
				state.owner=owner=renderElement._sprite3D;
				state.renderElement=renderElement;
				owner._preRenderUpdateComponents(state);
				renderObj=renderElement.renderObj,material=renderElement._material;
				if (this._begainRenderElement(state,renderObj,material)){
					vbs=renderObj._getVertexBuffers();
					vertexBuffer=renderObj._getVertexBuffer(0);
					vertexDeclaration=vertexBuffer.vertexDeclaration;
					shader=state._shader=material._getShader(scene._shaderDefineValue,vertexDeclaration.shaderDefineValue,owner._shaderDefineValue);
					forceUploadParams=shader.bind()|| (loopCount!==shader._uploadLoopCount);
					if (vbs){
						if (shader._uploadVertexBuffer!==vbs || forceUploadParams){
							for (var j=0;j < vbs.length;j++){
								var vb=vbs[j];
								shader.uploadAttributesX(vb.vertexDeclaration.shaderValues.data,vb);
							}
							shader._uploadVertexBuffer=vbs;
						}
						}else {
						if (shader._uploadVertexBuffer!==vertexBuffer || forceUploadParams){
							shader.uploadAttributes(vertexDeclaration.shaderValues.data,null);
							shader._uploadVertexBuffer=vertexBuffer;
						}
					}
					if (shader._uploadScene!==scene || forceUploadParams){
						shader.uploadSceneUniforms(scene._shaderValues.data);
						shader._uploadScene=scene;
					}
					if (camera!==shader._uploadCamera || shader._uploadSprite3D!==owner || forceUploadParams){
						shader.uploadSpriteUniforms(owner._shaderValues.data);
						shader._uploadSprite3D=owner;
					}
					if (camera!==shader._uploadCamera || forceUploadParams){
						shader.uploadCameraUniforms(camera._shaderValues.data);
						shader._uploadCamera=camera;
					}
					if (shader._uploadMaterial!==material || forceUploadParams){
						material._upload();
						shader._uploadMaterial=material;
					}
					if (lastStateMaterial!==material){
						material._setRenderStateBlendDepth();
						material._setRenderStateFrontFace(isTarget,owner.transform);
						lastStateMaterial=material;
						lastStateOwner=owner;
						}else {
						if (lastStateOwner!==owner){
							material._setRenderStateFrontFace(isTarget,owner.transform);
							lastStateOwner=owner;
						}
					}
					renderObj._render(state);
					shader._uploadLoopCount=loopCount;
				}
				owner._postRenderUpdateComponents(state);
				}else if (renderElement._type===2){
				var dynamicBatch=renderElement.renderObj;
				state.owner=owner=renderElement._sprite3D;
				state.renderElement=renderElement;
				state._batchIndexStart=renderElement._tempBatchIndexStart;
				state._batchIndexEnd=renderElement._tempBatchIndexEnd;
				renderObj=renderElement.renderObj,material=renderElement._material;
				if (this._begainRenderElement(state,renderObj,material)){
					vertexBuffer=renderObj._getVertexBuffer(0);
					vertexDeclaration=vertexBuffer.vertexDeclaration;
					shader=state._shader=material._getShader(scene._shaderDefineValue,vertexDeclaration.shaderDefineValue,owner._shaderDefineValue);
					forceUploadParams=shader.bind()|| (loopCount!==shader._uploadLoopCount);
					if (shader._uploadVertexBuffer!==vertexBuffer || forceUploadParams){
						shader.uploadAttributes(vertexDeclaration.shaderValues.data,null);
						shader._uploadVertexBuffer=vertexBuffer;
					}
					if (shader._uploadScene!==scene || forceUploadParams){
						shader.uploadSceneUniforms(scene._shaderValues.data);
						shader._uploadScene=scene;
					}
					if (camera!==shader._uploadCamera || shader._uploadSprite3D!==owner || forceUploadParams){
						shader.uploadSpriteUniforms(owner._shaderValues.data);
						shader._uploadSprite3D=owner;
					}
					if (camera!==shader._uploadCamera || forceUploadParams){
						shader.uploadCameraUniforms(camera._shaderValues.data);
						shader._uploadCamera=camera;
					}
					if (shader._uploadMaterial!==material || forceUploadParams){
						material._upload();
						shader._uploadMaterial=material;
					}
					if (lastStateMaterial!==material){
						material._setRenderStateBlendDepth();
						material._setRenderStateFrontFace(isTarget,owner.transform);
						lastStateMaterial=material;
						lastStateOwner=owner;
						}else {
						if (lastStateOwner!==owner){
							material._setRenderStateFrontFace(isTarget,owner.transform);
							lastStateOwner=owner;
						}
					}
					renderObj._render(state);
					shader._uploadLoopCount=loopCount;
				}
			}
		}
	}

	/**
	*@private
	*渲染队列。
	*@param state 渲染状态。
	*/
	__proto._renderShadow=function(state,isOnePSSM){
		var loopCount=Stat.loopCount;
		var scene=this._scene;
		var camera=state.camera;
		var vertexBuffer,vertexDeclaration,shader;
		var forceUploadParams=false;
		var lastStateMaterial,lastStateOwner;
		for (var i=0,n=this._finalElements.length;i < n;i++){
			var renderElement=this._finalElements[i];
			var renderObj,material,owner;
			if (renderElement._type===0){
				state.owner=owner=renderElement._sprite3D;
				if (!isOnePSSM && (owner._projectionViewWorldUpdateCamera!==camera || owner._projectionViewWorldUpdateLoopCount!==Stat.loopCount)){
					owner._render._renderUpdate(state._projectionViewMatrix);
					owner._projectionViewWorldUpdateLoopCount=Stat.loopCount;
					owner._projectionViewWorldUpdateCamera=camera;
				}
				state.renderElement=renderElement;
				owner._preRenderUpdateComponents(state);
				renderObj=renderElement.renderObj,material=renderElement._material;
				if (this._begainRenderElement(state,renderObj,null)){
					vertexBuffer=renderObj._getVertexBuffer(0);
					vertexDeclaration=vertexBuffer.vertexDeclaration;
					shader=state._shader=material._getShader(scene._shaderDefineValue,vertexDeclaration.shaderDefineValue,owner._shaderDefineValue);
					forceUploadParams=shader.bind()|| (loopCount!==shader._uploadLoopCount);
					if (shader._uploadVertexBuffer!==vertexBuffer || forceUploadParams){
						shader.uploadAttributes(vertexDeclaration.shaderValues.data,null);
						shader._uploadVertexBuffer=vertexBuffer;
					}
					if (camera!==shader._uploadCamera || shader._uploadSprite3D!==owner || forceUploadParams){
						shader.uploadSpriteUniforms(owner._shaderValues.data);
						shader._uploadSprite3D=owner;
					}
					if (camera!==shader._uploadCamera || forceUploadParams){
						shader.uploadCameraUniforms(camera._shaderValues.data);
						shader._uploadCamera=camera;
					}
					if (shader._uploadMaterial!==material || forceUploadParams){
						material._upload();
						shader._uploadMaterial=material;
					}
					if (shader._uploadRenderElement!==renderElement || forceUploadParams){}
						if (lastStateMaterial!==material){
						material._setRenderStateFrontFace(false,owner.transform);
						lastStateMaterial=material;
						lastStateOwner=owner;
						}else {
						if (lastStateOwner!==owner){
							material._setRenderStateFrontFace(false,owner.transform);
							lastStateOwner=owner;
						}
					}
					renderObj._render(state);
					shader._uploadLoopCount=loopCount;
				}
				owner._postRenderUpdateComponents(state);
			}
		}
	}

	/**
	*清空队列中的渲染物体。
	*/
	__proto._clearRenderElements=function(){
		this._dynamicBatchCombineRenderElements.length=0;
		this._renderElements.length=0;
		this._needSort=true;
	}

	/**
	*添加渲染物体。
	*@param renderObj 渲染物体。
	*/
	__proto._addRenderElement=function(renderElement){
		this._renderElements.push(renderElement);
		this._needSort=true;
	}

	/**
	*添加动态批处理。
	*@param renderObj 动态批处理。
	*/
	__proto._addDynamicBatchElement=function(dynamicBatchElement){
		this._dynamicBatchCombineRenderElements.push(dynamicBatchElement);
	}

	/**
	*获取唯一标识ID(通常用于优化或识别)。
	*/
	__getset(0,__proto,'id',function(){
		return this._id;
	});

	RenderQueue._uniqueIDCounter=0;
	RenderQueue._cameraPosition=null;
	return RenderQueue;
})()


/**
*<code>RenderState</code> 类用于实现渲染状态。
*/
//class laya.d3.core.render.RenderState
var RenderState=(function(){
	function RenderState(){
		/**@private */
		this._staticBatch=null;
		/**@private */
		this._batchIndexStart=0;
		/**@private */
		this._batchIndexEnd=0;
		/**@private */
		this._viewMatrix=null;
		/**@private */
		this._projectionMatrix=null;
		/**@private */
		this._projectionViewMatrix=null;
		/**@private */
		this._viewport=null;
		/**@private */
		this._shader=null;
		/**距上一帧间隔时间。*/
		this.elapsedTime=NaN;
		/**当前场景。*/
		this.scene=null;
		/**当前渲染3D精灵。*/
		this.owner=null;
		/**当前渲染物体。*/
		this.renderElement=null;
		/**当前摄像机。*/
		this.camera=null;
	}

	__class(RenderState,'laya.d3.core.render.RenderState');
	RenderState.clientWidth=0;
	RenderState.clientHeight=0;
	return RenderState;
})()


//class laya.d3.core.scene.OctreeNode
var OctreeNode=(function(){
	function OctreeNode(scene,currentDepth){
		this._exactBox=null;
		this._relaxBox=null;
		this._scene=null;
		this._parent=null;
		this._currentDepth=0;
		this._boundingSphere=new BoundSphere(new Vector3(),0);
		this._corners=/*new vector.<>*/[new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3()];
		this._boundingBoxCenter=new Vector3();
		this._children=__newvec(8);
		this._objects=[];
		this._tempBoundBoxCorners=/*new vector.<>*/[new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3()];
		this._scene=scene;
		this._currentDepth=currentDepth;
	}

	__class(OctreeNode,'laya.d3.core.scene.OctreeNode');
	var __proto=OctreeNode.prototype;
	Laya.imps(__proto,{"laya.d3.core.scene.ITreeNode":true})
	__proto.init=function(center,treeSize){
		var min=new Vector3();
		var max=new Vector3();
		Vector3.scale(treeSize,-0.5,min);
		Vector3.scale(treeSize,0.5,max);
		Vector3.add(min,center,min);
		Vector3.add(max,center,max);
		this.exactBox=new BoundBox(min,max);
		this.relaxBox=new BoundBox(min,max);
	}

	__proto.addTreeNode=function(render){
		if (Collision.boxContainsBox(this._relaxBox,render.boundingBox)===/*laya.d3.math.ContainmentType.Contains*/1)
			this.addNodeDown(render,0);
		else
		this.addObject(render);
	}

	__proto.addChild=function(index){
		var child=this._children[index];
		if (child==null){
			child=new OctreeNode(this._scene,this._currentDepth+1);
			this._children[index]=child;
			child._parent=this;
			Vector3.subtract(this._exactBox.max,this._exactBox.min,OctreeNode.tempSize);
			Vector3.multiply(OctreeNode.tempSize,OctreeNode._octreeSplit[index],OctreeNode.tempCenter);
			Vector3.add(this._exactBox.min,OctreeNode.tempCenter,OctreeNode.tempCenter);
			Vector3.scale(OctreeNode.tempSize,0.25,OctreeNode.tempSize);
			var min=new Vector3();
			var max=new Vector3();
			Vector3.subtract(OctreeNode.tempCenter,OctreeNode.tempSize,min);
			Vector3.add(OctreeNode.tempCenter,OctreeNode.tempSize,max);
			child.exactBox=new BoundBox(min,max);
			Vector3.scale(OctreeNode.tempSize,OctreeNode.relax,OctreeNode.tempSize);
			var relaxMin=new Vector3();
			var relaxMax=new Vector3();
			Vector3.subtract(OctreeNode.tempCenter,OctreeNode.tempSize,relaxMin);
			Vector3.add(OctreeNode.tempCenter,OctreeNode.tempSize,relaxMax);
			child.relaxBox=new BoundBox(relaxMin,relaxMax);
		}
		return child;
	}

	__proto.addObject=function(object){
		object._treeNode=this;
		this._objects.push(object);
	}

	__proto.removeObject=function(object){
		if (object._treeNode !=this){
			console.log("OctreeNode::removeObject error");
			return false;
		};
		var index=this._objects.indexOf(object);
		if (index!==-1){
			this._objects.splice(index,1);
			return true;
		}
		return false;
	}

	__proto.clearObject=function(){
		this._objects.length=0;
	}

	__proto.addNodeUp=function(render,depth){
		if (this._parent && (Collision.boxContainsBox(this._exactBox,render.boundingBox)!==/*laya.d3.math.ContainmentType.Contains*/1)){
			this._parent.addNodeUp(render,depth-1);
		}else
		this.addNodeDown(render,depth);
	}

	__proto.addNodeDown=function(render,depth){
		if (depth < this._scene.treeLevel){
			var childIndex=this.inChildIndex(render.boundingBoxCenter);
			var child=this.addChild(childIndex);
			if (Collision.boxContainsBox(child._relaxBox,render.boundingBox)===/*laya.d3.math.ContainmentType.Contains*/1){
				child.addNodeDown(render,++depth);
			}else
			this.addObject(render);
			}else {
			this.addObject(render);
		}
	}

	__proto.inChildIndex=function(objectCenter){
		var z=objectCenter.z < this._boundingBoxCenter.z ? 0 :1;
		var y=objectCenter.y < this._boundingBoxCenter.y ? 0 :1;
		var x=objectCenter.x < this._boundingBoxCenter.x ? 0 :1;
		return z *4+y *2+x;
	}

	__proto.updateObject=function(render){
		if (Collision.boxContainsBox(this._relaxBox,render.boundingBox)===/*laya.d3.math.ContainmentType.Contains*/1){
			this.removeObject(render);
			render._treeNode=null;
			this.addNodeDown(render,this._currentDepth);
			}else if (this._parent){
			this.removeObject(render);
			render._treeNode=null;
			this._parent.addNodeUp(render,this._currentDepth-1);
		}
	}

	__proto.cullingObjects=function(boundFrustum,testVisible,flags,cameraPosition,projectionView){
		var i=0,j=0,n=0,m=0;
		var dynamicBatchManager=this._scene._dynamicBatchManager;
		for (i=0,n=this._objects.length;i < n;i++){
			var render=this._objects[i];
			if (Layer.isVisible(render._owner.layer.mask)&& render.enable){
				if (testVisible){
					Stat.treeSpriteCollision+=1;
					if (boundFrustum.containsBoundSphere(render.boundingSphere)===/*laya.d3.math.ContainmentType.Disjoint*/0)
						continue ;
				}
				render._renderUpdate(projectionView);
				render._distanceForSort=Vector3.distance(render.boundingSphere.center,cameraPosition)+render.sortingFudge;
				var renderElements=render._renderElements;
				for (j=0,m=renderElements.length;j < m;j++){
					var renderElement=renderElements[j];
					var staticBatch=renderElement._staticBatch;
					if (staticBatch && (staticBatch._material===renderElement._material)){
						staticBatch._addBatchRenderElement(renderElement);
						}else {
						var renderObj=renderElement.renderObj;
						if ((renderObj.triangleCount < /*laya.d3.graphics.DynamicBatch.maxCombineTriangleCount*/10)&& (renderObj._vertexBufferCount===1)&& (renderObj._getIndexBuffer())&& (renderElement._material.renderQueue < 2)&& renderElement._canDynamicBatch && (!render._owner.isStatic))
							dynamicBatchManager._addPrepareRenderElement(renderElement);
						else
						this._scene.getRenderQueue(renderElement._material.renderQueue)._addRenderElement(renderElement);
					}
				}
			}
		}
		for (i=0;i < 8;i++){
			var child=this._children[i];
			if (child==null)
				continue ;
			var testVisibleChild=testVisible;
			if (testVisible){
				var type=boundFrustum.containsBoundBox(child._relaxBox);
				Stat.treeNodeCollision+=1;
				if (type===/*laya.d3.math.ContainmentType.Disjoint*/0)
					continue ;
				testVisibleChild=(type===/*laya.d3.math.ContainmentType.Intersects*/2);
			}
			child.cullingObjects(boundFrustum,testVisibleChild,flags,cameraPosition,projectionView);
		}
	}

	/**
	*@private
	*/
	__proto.cullingShadowObjects=function(lightBoundFrustum,splitShadowQueues,testVisible,flags,scene){
		var i=0,j=0,n=0,m=0;
		var dynamicBatchManager=this._scene._dynamicBatchManager;
		for (i=0,n=this._objects.length;i < n;i++){
			var baseRender=this._objects[i];
			if (baseRender.castShadow && Layer.isVisible(baseRender._owner.layer.mask)&& baseRender.enable){
				if (testVisible && lightBoundFrustum[0].containsBoundSphere(baseRender.boundingSphere)===/*laya.d3.math.ContainmentType.Disjoint*/0)
					continue ;
				for (var k=1,kNum=lightBoundFrustum.length;k < kNum;k++){
					var shadowQueue=splitShadowQueues[k-1];
					if (lightBoundFrustum[k].containsBoundSphere(baseRender.boundingSphere)!==/*laya.d3.math.ContainmentType.Disjoint*/0){
						var renderElements=baseRender._renderElements;
						for (j=0,m=renderElements.length;j < m;j++)
						shadowQueue._addRenderElement(renderElements[j]);
					}
				}
			}
		}
		for (i=0;i < 8;i++){
			var child=this._children[i];
			if (child==null)
				continue ;
			var testVisibleChild=testVisible;
			if (testVisible){
				var type=lightBoundFrustum[0].containsBoundBox(child._relaxBox);
				if (type===/*laya.d3.math.ContainmentType.Disjoint*/0)
					continue ;
				testVisibleChild=(type===/*laya.d3.math.ContainmentType.Intersects*/2);
			}
			child.cullingShadowObjects(lightBoundFrustum,splitShadowQueues,testVisibleChild,flags,scene);
		}
	}

	/**
	*@private
	*/
	__proto.cullingShadowObjectsOnePSSM=function(lightBoundFrustum,splitShadowQueues,lightViewProjectMatrix,testVisible,flags,scene){
		var shadowQueue=splitShadowQueues[0];
		var i=0,j=0,n=0,m=0;
		for (i=0,n=this._objects.length;i < n;i++){
			var baseRender=this._objects[i];
			if (baseRender.castShadow && Layer.isVisible(baseRender._owner.layer.mask)&& baseRender.enable){
				if (testVisible && lightBoundFrustum.containsBoundSphere(baseRender.boundingSphere)===/*laya.d3.math.ContainmentType.Disjoint*/0)
					continue ;
				baseRender._renderUpdate(lightViewProjectMatrix);
				var renderElements=baseRender._renderElements;
				for (j=0,m=renderElements.length;j < m;j++)
				shadowQueue._addRenderElement(renderElements[j]);
			}
		}
		for (i=0;i < 8;i++){
			var child=this._children[i];
			if (child==null)
				continue ;
			var testVisibleChild=testVisible;
			if (testVisible){
				var type=lightBoundFrustum.containsBoundBox(child._relaxBox);
				if (type===/*laya.d3.math.ContainmentType.Disjoint*/0)
					continue ;
				testVisibleChild=(type===/*laya.d3.math.ContainmentType.Intersects*/2);
			}
			child.cullingShadowObjectsOnePSSM(lightBoundFrustum,splitShadowQueues,lightViewProjectMatrix,testVisibleChild,flags,scene);
		}
	}

	__proto.renderBoudingBox=function(linePhasor){
		this._renderBoudingBox(linePhasor);
		for (var i=0;i < 8;++i){
			var pChild=this._children[i];
			if (pChild){
				pChild.renderBoudingBox(linePhasor);
			}
		}
	}

	__proto.buildAllChild=function(depth){
		if (depth < this._scene.treeLevel){
			for (var i=0;i < 8;i++){
				var child=this.addChild(i);
				child.buildAllChild(depth+1);
			}
		}
	}

	__proto._renderBoudingBox=function(linePhasor){}
	__getset(0,__proto,'exactBox',function(){
		return this._exactBox;
		},function(value){
		this._exactBox=value;
		Vector3.add(value.min,value.max,this._boundingBoxCenter);
		Vector3.scale(this._boundingBoxCenter,0.5,this._boundingBoxCenter);
	});

	__getset(0,__proto,'relaxBox',function(){
		return this._relaxBox;
		},function(value){
		this._relaxBox=value;
		value.getCorners(this._corners);
		BoundSphere.createfromPoints(this._corners,this._boundingSphere);
	});

	OctreeNode.debugMode=false;
	OctreeNode.relax=1.15;
	OctreeNode.CHILDNUM=8;
	__static(OctreeNode,
	['tempVector0',function(){return this.tempVector0=new Vector3();},'tempSize',function(){return this.tempSize=new Vector3();},'tempCenter',function(){return this.tempCenter=new Vector3();},'_octreeSplit',function(){return this._octreeSplit=[new Vector3(0.250,0.250,0.250),new Vector3(0.750,0.250,0.250),new Vector3(0.250,0.750,0.250),new Vector3(0.750,0.750,0.250),new Vector3(0.250,0.250,0.750),new Vector3(0.750,0.250,0.750),new Vector3(0.250,0.750,0.750),new Vector3(0.750,0.750,0.750)];}
	]);
	return OctreeNode;
})()


/**
*...
*@author ...
*/
//class laya.d3.core.scene.SceneManager
var SceneManager=(function(){
	function SceneManager(){}
	__class(SceneManager,'laya.d3.core.scene.SceneManager');
	return SceneManager;
})()


//class laya.d3.core.trail.module.Color
var Color$1=(function(){
	function Color(r,g,b,a){
		this._r=NaN;
		this._g=NaN;
		this._b=NaN;
		this._a=NaN;
		(r===void 0)&& (r=1);
		(g===void 0)&& (g=1);
		(b===void 0)&& (b=1);
		(a===void 0)&& (a=1);
		this._r=r;
		this._g=g;
		this._b=b;
		this._a=a;
	}

	__class(Color,'laya.d3.core.trail.module.Color',null,'Color$1');
	var __proto=Color.prototype;
	__proto.cloneTo=function(destObject){
		destObject._r=this._r;
		destObject._g=this._g;
		destObject._b=this._b;
		destObject._a=this._a;
	}

	__static(Color,
	['RED',function(){return this.RED=new Color(1,0,0,1);},'GREEN',function(){return this.GREEN=new Color(0,1,0,1);},'BLUE',function(){return this.BLUE=new Color(0,0,1,1);},'CYAN',function(){return this.CYAN=new Color(0,1,1,1);},'YELLOW',function(){return this.YELLOW=new Color(1,0.92,0.016,1);},'MAGENTA',function(){return this.MAGENTA=new Color(1,0,1,1);},'GRAY',function(){return this.GRAY=new Color(0.5,0.5,0.5,1);},'WHITE',function(){return this.WHITE=new Color(1,1,1,1);},'BLACK',function(){return this.BLACK=new Color(0,0,0,1);}
	]);
	return Color;
})()


//class laya.d3.core.trail.module.Gradient
var Gradient=(function(){
	function Gradient(){
		/**
		*梯度模式
		*/
		this._mode=0;
		/**
		*颜色值关键帧数据,最大长度为10
		*/
		this._colorKeys=null;
		/**
		*透明度关键帧数据,最大长度为10
		*/
		this._alphaKeys=null;
		this.index=0;
		this._colorKeyData=new Float32Array(40);
		this._alphaKeyData=new Float32Array(20);
		this._colorKeys=[];
		this._alphaKeys=[];
	}

	__class(Gradient,'laya.d3.core.trail.module.Gradient');
	var __proto=Gradient.prototype;
	/**
	*设置渐变，使用一组颜色关键帧数据和透明度关键帧数据。
	*@param colorKeys 渐变的颜色值关键帧数据(最大长度为10)。
	*@param alphaKeys 渐变的透明度关键帧数据(最大长度为10)。
	*/
	__proto.setKeys=function(colorKeys,alphaKeys){
		this._colorKeys=colorKeys;
		this.index=0;
		var gradientColorKey;
		for (var i=0;i < colorKeys.length;i++){
			gradientColorKey=colorKeys[i];
			var color=gradientColorKey.color;
			this._colorKeyData[this.index++]=color._r;
			this._colorKeyData[this.index++]=color._g;
			this._colorKeyData[this.index++]=color._b;
			this._colorKeyData[this.index++]=gradientColorKey.time;
		}
		this._alphaKeys=alphaKeys;
		this.index=0;
		var gradientAlphaKey;
		for (var j=0;j < alphaKeys.length;j++){
			gradientAlphaKey=alphaKeys[j];
			this._alphaKeyData[this.index++]=gradientAlphaKey.alpha;
			this._alphaKeyData[this.index++]=gradientAlphaKey.time;
		}
	}

	__proto.cloneTo=function(destObject){
		var i=0,j=0;
		var cks=this.colorKeys;
		var _cks=[];
		for (i=0,j=cks.length;i < j;i++){
			var _ck=new GradientColorKey();
			cks[i].cloneTo(_ck);
			_cks.push(_ck);
		};
		var aks=this.alphaKeys;
		var _aks=[];
		for (i=0,j=aks.length;i < j;i++){
			var _ak=new GradientAlphaKey();
			aks[i].cloneTo(_ak);
			_aks.push(_ak);
		}
		destObject.setKeys(_cks,_aks);
	}

	/**
	*设置梯度模式。
	*@param value 梯度模式。
	*/
	/**
	*获取梯度模式。
	*@return 梯度模式。
	*/
	__getset(0,__proto,'mode',function(){
		return this._mode;
		},function(value){
		this._mode=value;
	});

	/**
	*设置颜色值关键帧数据
	*/
	/**
	*获取颜色值关键帧数据
	*/
	__getset(0,__proto,'colorKeys',function(){
		return this._colorKeys;
		},function(values){
		this._colorKeys=values;
		this.index=0;
		for (var i=0;i < values.length;i++){
			var value=values[i];
			var color=value.color;
			this._colorKeyData[this.index++]=color._r;
			this._colorKeyData[this.index++]=color._g;
			this._colorKeyData[this.index++]=color._b;
			this._colorKeyData[this.index++]=value.time;
		}
	});

	/**
	*设置透明度关键帧数据
	*/
	/**
	*获取透明度关键帧数据
	*/
	__getset(0,__proto,'alphaKeys',function(){
		return this._alphaKeys;
		},function(values){
		this._alphaKeys=values;
		this.index=0;
		for (var i=0;i < values.length;i++){
			var value=values[i];
			this._alphaKeyData[this.index++]=value.alpha;
			this._alphaKeyData[this.index++]=value.time;
		}
	});

	return Gradient;
})()


//class laya.d3.core.trail.module.GradientAlphaKey
var GradientAlphaKey=(function(){
	function GradientAlphaKey(alpha,time){
		this._alpha=NaN;
		this._time=NaN;
		(alpha===void 0)&& (alpha=0);
		(time===void 0)&& (time=0);
		this._alpha=alpha;
		this._time=time;
	}

	__class(GradientAlphaKey,'laya.d3.core.trail.module.GradientAlphaKey');
	var __proto=GradientAlphaKey.prototype;
	__proto.cloneTo=function(destObject){
		destObject.alpha=this.alpha;
		destObject.time=this.time;
	}

	/**
	*设置透明度。
	*@param value 透明度。
	*/
	/**
	*获取透明度。
	*@return 透明度。
	*/
	__getset(0,__proto,'alpha',function(){
		return this._alpha;
		},function(value){
		this._alpha=value;
	});

	/**
	*设置时间。
	*@param value 时间。
	*/
	/**
	*获取时间。
	*@return 时间。
	*/
	__getset(0,__proto,'time',function(){
		return this._time;
		},function(value){
		this._time=value;
	});

	return GradientAlphaKey;
})()


//class laya.d3.core.trail.module.GradientColorKey
var GradientColorKey=(function(){
	function GradientColorKey(color,time){
		this._color=null;
		this._time=NaN;
		(time===void 0)&& (time=0);
		this._color=color||new Color$1();
		this._time=time;
	}

	__class(GradientColorKey,'laya.d3.core.trail.module.GradientColorKey');
	var __proto=GradientColorKey.prototype;
	__proto.cloneTo=function(destObject){
		this.color.cloneTo(destObject.color);
		destObject.time=this.time;
	}

	/**
	*设置颜色值。
	*@param value 颜色值。
	*/
	/**
	*获取颜色值。
	*@return 颜色值。
	*/
	__getset(0,__proto,'color',function(){
		return this._color;
		},function(value){
		this._color=value;
	});

	/**
	*设置时间。
	*@param value 时间。
	*/
	/**
	*获取时间。
	*@return 时间。
	*/
	__getset(0,__proto,'time',function(){
		return this._time;
		},function(value){
		this._time=value;
	});

	return GradientColorKey;
})()


/**
*...
*@author ...
*/
//class laya.d3.core.trail.module.GradientMode
var GradientMode=(function(){
	function GradientMode(){}
	__class(GradientMode,'laya.d3.core.trail.module.GradientMode');
	GradientMode.Blend=0;
	GradientMode.Fixed=1;
	return GradientMode;
})()


/**
*...
*@author ...
*/
//class laya.d3.core.trail.module.TextureMode
var TextureMode=(function(){
	function TextureMode(){}
	__class(TextureMode,'laya.d3.core.trail.module.TextureMode');
	TextureMode.Stretch=0;
	TextureMode.Tile=1;
	return TextureMode;
})()


//class laya.d3.core.trail.module.TrailKeyFrame
var TrailKeyFrame=(function(){
	function TrailKeyFrame(){
		this.time=NaN;
		this.inTangent=NaN;
		this.outTangent=NaN;
		this.value=NaN;
	}

	__class(TrailKeyFrame,'laya.d3.core.trail.module.TrailKeyFrame');
	var __proto=TrailKeyFrame.prototype;
	__proto.cloneTo=function(destObject){
		destObject.time=this.time;
		destObject.inTangent=this.inTangent;
		destObject.outTangent=this.outTangent;
		destObject.value=this.value;
	}

	return TrailKeyFrame;
})()


/**
*...
*@author ...
*/
//class laya.d3.core.trail.TrailRenderElement
var TrailRenderElement=(function(){
	function TrailRenderElement(owner){
		this._id=0;
		this._owner=null;
		this._camera=null;
		this._vertexBuffers=null;
		//固定顶点个数
		this._verticesCount=0;
		//虚拟顶点个数
		this._virtualVerticesCount=0;
		this._maxVerticesCount=256;
		this._vertices1=null;
		this._vertexBuffer1=null;
		this._floatCountPerVertices1=8;
		this._verticesIndex1=0;
		this._everyAddVerticeCount1=0;
		this._delLength=0;
		this._vertices2=null;
		this._vertexBuffer2=null;
		this._floatCountPerVertices2=1;
		this._everyGroupVertexBirthTime=null;
		this._VerticesToTailLength=null;
		this._everyVertexToPreVertexDistance=null;
		this._pointe=null;
		this._pointAtoBVector3e=null;
		this._isStart=false;
		this._isFinish=false;
		this._isDead=false;
		this._curtime=NaN;
		this._curDisappearIndex=0;
		this._lastPosition=new Vector3();
		this._curPosition=new Vector3();
		this._delVector3=new Vector3();
		this._lastFixedVertexPosition=new Vector3();
		this._pointAtoBVector3=new Vector3();
		this._pointA=new Vector3();
		this._pointB=new Vector3();
		this._owner=owner;
		this._id=TrailRenderElement.renderElementCount++;
		if (this._id==0){
			owner._owner.transform.position.cloneTo(this._lastPosition);
			}else {
			owner._curSubTrailFinishPosition.cloneTo(this._lastPosition);
		}
		this._everyGroupVertexBirthTime=[];
		this._VerticesToTailLength=new Float32Array(this._maxVerticesCount);
		this._everyVertexToPreVertexDistance=new Float32Array(this._maxVerticesCount);
		this._vertices1=new Float32Array(this._maxVerticesCount *this._floatCountPerVertices1);
		this._vertices2=new Float32Array(this._maxVerticesCount *this._floatCountPerVertices2);
		this._vertexBuffer1=new VertexBuffer3D(VertexTrail.vertexDeclaration1,this._maxVerticesCount,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
		this._vertexBuffer2=new VertexBuffer3D(VertexTrail.vertexDeclaration2,this._maxVerticesCount,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
		this._vertexBuffers=[];
		this._vertexBuffers.push(this._vertexBuffer1);
		this._vertexBuffers.push(this._vertexBuffer2);
	}

	__class(TrailRenderElement,'laya.d3.core.trail.TrailRenderElement');
	var __proto=TrailRenderElement.prototype;
	Laya.imps(__proto,{"laya.d3.core.render.IRenderable":true})
	/**
	*@private
	*更新Trail数据
	*/
	__proto._updateTrail=function(){
		this._everyAddVerticeCount1=0;
		if (!this._isStart){
			this._addTrailByFirstPosition(this._lastPosition,this._curPosition);
		}
		this._addTrailByNextPosition(this._curPosition);
		this._vertexBuffer1.setData(this._vertices1,this._verticesIndex1,this._verticesIndex1,this._everyAddVerticeCount1);
		this._verticesIndex1+=this._everyAddVerticeCount1;
		this._curPosition.cloneTo(this._lastPosition);
		if (this._virtualVerticesCount==2){
			this._verticesIndex1-=this._floatCountPerVertices1 *2;
		}
	}

	/**
	*@private
	*通过起始位置添加TrailRenderElement起始数据
	*@param firstPosition 起始位置
	*@param secondPosition 第二次位置
	*/
	__proto._addTrailByFirstPosition=function(firstPosition,secondPosition){
		Vector3.subtract(secondPosition,firstPosition,this._delVector3);
		Vector3.cross(this._delVector3,this._camera.forward,this._pointAtoBVector3);
		Vector3.normalize(this._pointAtoBVector3,this._pointAtoBVector3);
		Vector3.scale(this._pointAtoBVector3,this._owner.widthMultiplier / 2,this._pointAtoBVector3);
		this._updateVerticesByPosition(firstPosition);
		firstPosition.cloneTo(this._lastFixedVertexPosition);
		this._verticesCount+=2;
		this._curtime=this._owner._hasLifeSubTrail ? this._owner._curSubTrailFinishCurTime :this._owner._curtime;
		this._everyGroupVertexBirthTime.push(this._curtime);
		this._isStart=true;
		this._owner._hasLifeSubTrail=true;
	}

	/**
	*@private
	*通过位置更新TrailRenderElement数据
	*@param position 位置
	*/
	__proto._addTrailByNextPosition=function(position){
		Vector3.subtract(position,this._lastFixedVertexPosition,this._delVector3);
		Vector3.cross(this._delVector3,this._camera.forward,this._pointAtoBVector3);
		Vector3.normalize(this._pointAtoBVector3,this._pointAtoBVector3);
		Vector3.scale(this._pointAtoBVector3,this._owner.widthMultiplier / 2,this._pointAtoBVector3);
		this._delLength=Vector3.scalarLength(this._delVector3);
		if (this._delLength-this._owner.minVertexDistance >=MathUtils3D.zeroTolerance){
			this._owner._trailTotalLength+=this._delLength;
			this._owner._trailSupplementLength=0;
			this._updateVerticesByPosition(position);
			position.cloneTo(this._lastFixedVertexPosition);
			this._verticesCount+=2;
			this._virtualVerticesCount=0;
			this._everyGroupVertexBirthTime.push(this._owner._curtime);
			if (this._verticesCount==this._maxVerticesCount){
				this._onTrailRenderElementFinish();
			}
		}
		else {
			this._owner._trailSupplementLength=this._delLength;
			this._updateVerticesByPosition(position);
			this._virtualVerticesCount=2;
		}
	}

	/**
	*@private
	*通过位置更新顶点数据
	*@param position 位置
	*/
	__proto._updateVerticesByPosition=function(position){
		this._pointe=position.elements;
		this._pointAtoBVector3e=this._pointAtoBVector3.elements;
		this._curtime=this._owner._curtime;
		if (this._owner._hasLifeSubTrail && this._isStart==false){
			this._pointe=this._owner._curSubTrailFinishPosition.elements;
			this._pointAtoBVector3e=this._owner._curSubTrailFinishDirection.elements;
			this._curtime=this._owner._curSubTrailFinishCurTime;
		}
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=this._pointe[0];
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=this._pointe[1];
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=this._pointe[2];
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=-this._pointAtoBVector3e[0];
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=-this._pointAtoBVector3e[1];
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=-this._pointAtoBVector3e[2];
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=this._curtime;
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=1.0;
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=this._pointe[0];
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=this._pointe[1];
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=this._pointe[2];
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=this._pointAtoBVector3e[0];
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=this._pointAtoBVector3e[1];
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=this._pointAtoBVector3e[2];
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=this._curtime;
		this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=0.0;
		this._VerticesToTailLength[this._verticesCount / 2]=this._owner._trailTotalLength+this._owner._trailSupplementLength;
		if (this._owner._trailSupplementLength==0){
			this._everyVertexToPreVertexDistance[this._verticesCount / 2]=this._delLength;
			}else {
			this._everyVertexToPreVertexDistance[this._verticesCount / 2]=this._isStart ? this._owner._trailSupplementLength :0;
		}
	}

	/**
	*更新VertexBuffer2数据
	*/
	__proto._updateVertexBuffer2=function(){
		var _uvIndex=0;
		var _uvX=0.0;
		var i=0,j=0;
		for (i=0,j=(this._verticesCount+this._virtualVerticesCount)/ 2;i < j;i++){
			if (this._owner.textureMode==/*laya.d3.core.trail.module.TextureMode.Stretch*/0){
				_uvX=(this._VerticesToTailLength[i]-this._owner._trailDeadLength)/ (this._owner._trailTotalLength+this._owner._trailSupplementLength-this._owner._trailDeadLength);
				}else {
				_uvX=this._owner._trailTotalLength+this._owner._trailSupplementLength-this._VerticesToTailLength[i];
			}
			this._vertices2[_uvIndex++]=1.0-_uvX;
			this._vertices2[_uvIndex++]=1.0-_uvX;
		}
		this._vertexBuffer2.setData(this._vertices2,0,0,this._verticesCount+this._virtualVerticesCount);
	}

	/**
	*trailRenderElement完成时调用
	*@param finishedPosition
	*/
	__proto._onTrailRenderElementFinish=function(){
		this._lastFixedVertexPosition.cloneTo(this._owner._curSubTrailFinishPosition);
		this._pointAtoBVector3.cloneTo(this._owner._curSubTrailFinishDirection);
		this._owner._curSubTrailFinishCurTime=this._owner._curtime;
		this._isFinish=true;
	}

	/**
	*@private
	*/
	__proto._updateDisappear=function(){
		var i=0,j=0;
		for (i=this._curDisappearIndex,j=(this._verticesCount+this._virtualVerticesCount)/ 2;i < j;i++){
			if (this._owner._curtime-this._everyGroupVertexBirthTime[i] >=this._owner.time+MathUtils3D.zeroTolerance){
				this._curDisappearIndex++;
				this._owner._trailDeadLength+=this._everyVertexToPreVertexDistance[this._curDisappearIndex];
				if (this._curDisappearIndex >=(this._verticesCount+this._virtualVerticesCount)/ 2){
					this._isDead=true;
				}
			}
		}
	}

	/**
	*渲染前调用
	*@param state 渲染状态
	*@return 是否渲染
	*/
	__proto._beforeRender=function(state){
		this._camera=state.camera;
		if (this._camera==null)
			return false;
		this._owner._owner.transform.position.cloneTo(this._curPosition);
		if (!this._isDead){
			if (this._verticesCount < this._maxVerticesCount){
				if (!this._owner._isStart){
					this._owner._owner.transform.position.cloneTo(this._lastPosition);
					this._owner._isStart=true;
				}
				if (!Vector3.equals(this._lastPosition,this._curPosition)){
					this._updateTrail();
				}
				}else {
				if (this._isFinish){
					this._isFinish=false;
					this._owner._curSubTrailFinished=true;
				}
			}
			if (this._verticesCount > 0){
				this._updateVertexBuffer2();
				this._updateDisappear();
				return true;
			}
		}
		return false;
	}

	/**
	*渲染时调用
	*@param state 渲染状态
	*/
	__proto._render=function(state){
		if (this._isDead)
			return;
		WebGL.mainContext.drawArrays(/*laya.webgl.WebGLContext.TRIANGLE_STRIP*/0x0005,this._curDisappearIndex *2,this._verticesCount+this._virtualVerticesCount-this._curDisappearIndex *2);
		Stat.drawCall++;
		Stat.trianglesFaces+=(this._verticesCount+this._virtualVerticesCount-this._curDisappearIndex *2-2);
	}

	/**
	*获取vertexBuffer
	*@param index vertexBuffer索引
	*@return vertexBuffer
	*/
	__proto._getVertexBuffer=function(index){
		(index===void 0)&& (index=0);
		if (index===0)
			return this._vertexBuffer1;
		else if (index===1)
		return this._vertexBuffer2;
		else
		return null;
	}

	/**
	*获取vertexBuffer数组
	*@return vertexBuffer数组
	*/
	__proto._getVertexBuffers=function(){
		return this._vertexBuffers;
	}

	/**
	*获取顶点索引缓冲
	*@return 顶点索引缓冲
	*/
	__proto._getIndexBuffer=function(){
		return null;
	}

	/**
	*重新激活该renderElement
	*/
	__proto.reActivate=function(){
		this._id=laya.d3.core.trail.TrailRenderElement.renderElementCount++;
		this._isStart=false;
		this._isFinish=false;
		this._isDead=false;
		this._verticesCount=0;
		this._virtualVerticesCount=0;
		this._verticesIndex1=0;
		this._delLength=0;
		this._curDisappearIndex=0;
		this._everyGroupVertexBirthTime=[];
		this._owner._curSubTrailFinishPosition.cloneTo(this._lastPosition);
	}

	/**
	*@private
	*/
	__proto._destroy=function(){
		this._vertexBuffer1.dispose();
		this._vertexBuffer2.dispose();
		this._vertices1=null;
		this._vertexBuffer1=null;
		this._vertices2=null;
		this._vertexBuffer2=null;
		this._vertexBuffers=null;
		this._everyGroupVertexBirthTime=null;
		this._VerticesToTailLength=null;
		this._everyVertexToPreVertexDistance=null;
		this._lastPosition=null;
		this._curPosition=null;
		this._delVector3=null;
		this._lastFixedVertexPosition=null;
		this._pointAtoBVector3=null;
		this._pointe=null;
		this._pointAtoBVector3e=null;
		this._pointA=null;
		this._pointB=null;
	}

	/**
	*获取vertexBuffer数量
	*@return vertexBuffer数量
	*/
	__getset(0,__proto,'_vertexBufferCount',function(){
		return this._vertexBuffers.length;
	});

	/**
	*获取三角面数量
	*@return 三角面数量
	*/
	__getset(0,__proto,'triangleCount',function(){
		return 0;
	});

	TrailRenderElement.renderElementCount=0;
	return TrailRenderElement;
})()


/**
*<code>VertexTrail</code> 类用于创建拖尾顶点结构。
*/
//class laya.d3.core.trail.VertexTrail
var VertexTrail=(function(){
	function VertexTrail(){}
	__class(VertexTrail,'laya.d3.core.trail.VertexTrail');
	var __proto=VertexTrail.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexTrail._vertexDeclaration1;
	});

	__getset(1,VertexTrail,'vertexDeclaration1',function(){
		return VertexTrail._vertexDeclaration1;
	});

	__getset(1,VertexTrail,'vertexDeclaration2',function(){
		return VertexTrail._vertexDeclaration2;
	});

	__static(VertexTrail,
	['_vertexDeclaration1',function(){return this._vertexDeclaration1=new VertexDeclaration(32,
		[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.OFFSETVECTOR*/41),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Single*/"single",/*laya.d3.graphics.VertexElementUsage.TIME0*/33),
		new VertexElement(28,/*laya.d3.graphics.VertexElementFormat.Single*/"single",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0Y*/40)]);},'_vertexDeclaration2',function(){return this._vertexDeclaration2=new VertexDeclaration(4,
		[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Single*/"single",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0X*/38)]);}
	]);
	return VertexTrail;
})()


/**
*...
*@author
*/
//class laya.d3.extension.domino.DominoKeyFrame
var DominoKeyFrame=(function(){
	function DominoKeyFrame(){
		this.position=Vector3.ZERO;
		this.rotation=Quaternion.DEFAULT;
		this.scale=new Vector3(0.3,0.6,0.1);
	}

	__class(DominoKeyFrame,'laya.d3.extension.domino.DominoKeyFrame');
	return DominoKeyFrame;
})()


/**
*...
*@author
*/
//class laya.d3.extension.domino.DominoRenderElement
var DominoRenderElement=(function(){
	function DominoRenderElement(owner){
		this._owner=null;
		this.id=0;
		this._curDominoCount=0;
		this._perDominoVertexCount=24;
		this._perDominoIndiceCount=36;
		this._vertexBuffers=null;
		this._vertices1=null;
		this._vertexBuffer1=null;
		this._floatCountPerVertices1=4;
		this._verticesIndex1=0;
		this._everyAddVerticeCount1=0;
		this._vertices2=null;
		this._vertexBuffer2=null;
		this._floatCountPerVertices2=6;
		this._verticesIndex2=0;
		this._everyAddVerticeCount2=0;
		this._everyUpdateVerticeCount2=0;
		this._indices=null;
		this._indexBuffer=null;
		this._indicesIndex=0;
		this._everyAddindiceCount=0;
		this._index=0;
		this._color=new Vector4(Math.random(),Math.random(),Math.random(),1);
		this._topColor=this._color;
		this._buttomColor=this._color;
		this._leftColor=this._color;
		this._rightColor=this._color;
		this._frontColor=this._color;
		this._backColor=this._color;
		this._localMatrix=new Matrix4x4();
		this._localPostion=new Vector3();
		this._localNormal=new Vector3();
		this._owner=owner;
		this.id=DominoRenderElement.renderElementCount++;
		var _maxVertexCount=this._owner.DominoRenderElementMaxDominoCount *this._perDominoVertexCount;
		this._vertices1=new Float32Array(_maxVertexCount *this._floatCountPerVertices1);
		this._vertices2=new Float32Array(_maxVertexCount *this._floatCountPerVertices2);
		this._vertexBuffer1=new VertexBuffer3D(DominoVertex.vertexDeclaration1,_maxVertexCount,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
		this._vertexBuffer2=new VertexBuffer3D(DominoVertex.vertexDeclaration2,_maxVertexCount,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
		this._vertexBuffers=[];
		this._vertexBuffers.push(this._vertexBuffer1);
		this._vertexBuffers.push(this._vertexBuffer2);
		var _maxIndiceCount=this._owner.DominoRenderElementMaxDominoCount *this._perDominoIndiceCount;
		this._indices=new Uint16Array(_maxIndiceCount);
		this._indexBuffer=new IndexBuffer3D(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",_maxIndiceCount,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
	}

	__class(DominoRenderElement,'laya.d3.extension.domino.DominoRenderElement');
	var __proto=DominoRenderElement.prototype;
	Laya.imps(__proto,{"laya.d3.core.render.IRenderable":true})
	__proto.addDomino=function(position,rotation,scale){
		(position===void 0)&& (position=Vector3.ZERO);
		(rotation===void 0)&& (rotation=Quaternion.DEFAULT);
		(scale===void 0)&& (scale=Vector3.ONE);
		this._curDominoCount++;
		this._owner.dominoCount++;
		this._owner.dominoPosition.push(position);
		this.addDataForVertexBuffer1();
		this.addDataForVertexBuffer2(position,rotation,scale);
		this.addDataForIndexBuffer();
	}

	__proto.updateDomino=function(index,position,rotation,scale){
		(position===void 0)&& (position=Vector3.ZERO);
		(rotation===void 0)&& (rotation=Quaternion.DEFAULT);
		(scale===void 0)&& (scale=Vector3.ONE);
		this._everyUpdateVerticeCount2=0;
		var offset=this._perDominoVertexCount *this._floatCountPerVertices2 *index;
		var positions=DominoFilter._positions;
		var positione,positionX=NaN,positionY=NaN,positionZ=NaN;
		var normals=DominoFilter._normals;
		var normale,normalX=NaN,normalY=NaN,normalZ=NaN;
		var i=0,length=positions.length;
		Matrix4x4.createAffineTransformation(position,rotation,scale,this._localMatrix);
		for (i=0;i < length;i++){
			Vector3.transformCoordinate(positions[i],this._localMatrix,this._localPostion);
			positione=this._localPostion.elements;
			positionX=positione[0];
			positionY=positione[1];
			positionZ=positione[2];
			this._vertices2[offset+this._everyUpdateVerticeCount2++]=positionX;
			this._vertices2[offset+this._everyUpdateVerticeCount2++]=positionY;
			this._vertices2[offset+this._everyUpdateVerticeCount2++]=positionZ;
			Vector3.TransformNormal(normals[i],this._localMatrix,this._localNormal);
			normale=this._localNormal.elements;
			normalX=normale[0];
			normalY=normale[1];
			normalZ=normale[2];
			this._vertices2[offset+this._everyUpdateVerticeCount2++]=normalX;
			this._vertices2[offset+this._everyUpdateVerticeCount2++]=normalY;
			this._vertices2[offset+this._everyUpdateVerticeCount2++]=normalZ;
		}
		this._vertexBuffer2.setData(this._vertices2,offset,offset,this._everyUpdateVerticeCount2);
	}

	__proto.updateDominos=function(startIndex,count,keyFrames){
		this._everyUpdateVerticeCount2=0;
		var offset=this._perDominoVertexCount *this._floatCountPerVertices2 *startIndex;
		var positions=DominoFilter._positions;
		var positione,positionX=NaN,positionY=NaN,positionZ=NaN;
		var normals=DominoFilter._normals;
		var normale,normalX=NaN,normalY=NaN,normalZ=NaN;
		var i=0,j=0,length=positions.length;
		var keyFrame;
		for (i=0;i < count;i++){
			keyFrame=keyFrames[i];
			Matrix4x4.createAffineTransformation(keyFrame.position,keyFrame.rotation,keyFrame.scale,this._localMatrix);
			for (j=0;j < length;j++){
				Vector3.transformCoordinate(positions[j],this._localMatrix,this._localPostion);
				positione=this._localPostion.elements;
				positionX=positione[0];
				positionY=positione[1];
				positionZ=positione[2];
				this._vertices2[offset+this._everyUpdateVerticeCount2++]=positionX;
				this._vertices2[offset+this._everyUpdateVerticeCount2++]=positionY;
				this._vertices2[offset+this._everyUpdateVerticeCount2++]=positionZ;
				Vector3.TransformNormal(normals[j],this._localMatrix,this._localNormal);
				normale=this._localNormal.elements;
				normalX=normale[0];
				normalY=normale[1];
				normalZ=normale[2];
				this._vertices2[offset+this._everyUpdateVerticeCount2++]=normalX;
				this._vertices2[offset+this._everyUpdateVerticeCount2++]=normalY;
				this._vertices2[offset+this._everyUpdateVerticeCount2++]=normalZ;
			}
		}
		this._vertexBuffer2.setData(this._vertices2,offset,offset,this._everyUpdateVerticeCount2);
	}

	__proto.addDataForVertexBuffer1=function(){
		this._everyAddVerticeCount1=0;
		this.addDataForVertices1(this._topColor);
		this.addDataForVertices1(this._buttomColor);
		this.addDataForVertices1(this._leftColor);
		this.addDataForVertices1(this._rightColor);
		this.addDataForVertices1(this._frontColor);
		this.addDataForVertices1(this._backColor);
		this._vertexBuffer1.setData(this._vertices1,this._verticesIndex1,this._verticesIndex1,this._everyAddVerticeCount1);
		this._verticesIndex1+=this._everyAddVerticeCount1;
	}

	__proto.addDataForVertexBuffer2=function(position,rotation,scale){
		(position===void 0)&& (position=Vector3.ZERO);
		(rotation===void 0)&& (rotation=Quaternion.DEFAULT);
		(scale===void 0)&& (scale=Vector3.ONE);
		this._everyAddVerticeCount2=0;
		var positions=DominoFilter._positions;
		var positione,positionX=NaN,positionY=NaN,positionZ=NaN;
		var normals=DominoFilter._normals;
		var normale,normalX=NaN,normalY=NaN,normalZ=NaN;
		var i=0,j=0,length=positions.length;
		Matrix4x4.createAffineTransformation(position,rotation,scale,this._localMatrix);
		for (i=0;i < length;i++){
			Vector3.transformCoordinate(positions[i],this._localMatrix,this._localPostion);
			positione=this._localPostion.elements;
			positionX=positione[0];
			positionY=positione[1];
			positionZ=positione[2];
			this._vertices2[this._verticesIndex2+this._everyAddVerticeCount2++]=positionX;
			this._vertices2[this._verticesIndex2+this._everyAddVerticeCount2++]=positionY;
			this._vertices2[this._verticesIndex2+this._everyAddVerticeCount2++]=positionZ;
			Vector3.TransformNormal(normals[i],this._localMatrix,this._localNormal);
			normale=this._localNormal.elements;
			normalX=normale[0];
			normalY=normale[1];
			normalZ=normale[2];
			this._vertices2[this._verticesIndex2+this._everyAddVerticeCount2++]=normalX;
			this._vertices2[this._verticesIndex2+this._everyAddVerticeCount2++]=normalY;
			this._vertices2[this._verticesIndex2+this._everyAddVerticeCount2++]=normalZ;
		}
		this._vertexBuffer2.setData(this._vertices2,this._verticesIndex2,this._verticesIndex2,this._everyAddVerticeCount2);
		this._verticesIndex2+=this._everyAddVerticeCount2;
	}

	__proto.addDataForIndexBuffer=function(){
		this._everyAddindiceCount=0;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+0;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+1;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+2;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+2;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+3;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+0;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+4;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+7;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+6;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+6;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+5;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+4;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+8;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+9;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+10;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+10;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+11;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+8;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+12;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+15;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+14;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+14;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+13;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+12;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+16;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+17;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+18;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+18;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+19;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+16;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+20;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+23;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+22;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+22;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+21;
		this._indices[this._indicesIndex+this._everyAddindiceCount++]=this._index+20;
		this._indexBuffer.setData(this._indices,this._indicesIndex,this._indicesIndex,this._everyAddindiceCount);
		this._indicesIndex+=this._everyAddindiceCount;
		this._index+=this._perDominoVertexCount;
	}

	__proto.addDataForVertices1=function(color){
		var colore=color.elements;
		var colorX=colore[0];
		var colorY=colore[1];
		var colorZ=colore[2];
		var colorW=colore[3];
		for (var i=0;i < 4;i++){
			this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=colorX;
			this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=colorY;
			this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=colorZ;
			this._vertices1[this._verticesIndex1+this._everyAddVerticeCount1++]=colorW;
		}
	}

	__proto._beforeRender=function(state){
		this._indexBuffer._bind();
		return true;
	}

	__proto._render=function(state){
		WebGL.mainContext.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,this._indicesIndex,/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,0);
		Stat.drawCall++;
		Stat.trianglesFaces+=this._indicesIndex / 3;
	}

	__proto._getIndexBuffer=function(){
		return this._indexBuffer;
	}

	__proto._getVertexBuffer=function(index){
		(index===void 0)&& (index=0);
		if (index===0)
			return this._vertexBuffer1;
		else if (index===1)
		return this._vertexBuffer2;
		else
		return null;
	}

	__proto._getVertexBuffers=function(){
		return this._vertexBuffers;
	}

	__proto._getIndexBuffer=function(){
		return null;
	}

	__getset(0,__proto,'_vertexBufferCount',function(){
		return this._vertexBuffers.length;
	});

	__getset(0,__proto,'triangleCount',function(){
		return this._indicesIndex / 3;
	});

	DominoRenderElement.renderElementCount=0;
	return DominoRenderElement;
})()


/**
*<code>DominoVertex</code> 类用于创建多米诺顶点结构。
*/
//class laya.d3.extension.domino.DominoVertex
var DominoVertex=(function(){
	function DominoVertex(){}
	__class(DominoVertex,'laya.d3.extension.domino.DominoVertex');
	var __proto=DominoVertex.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'vertexDeclaration',function(){
		return DominoVertex._vertexDeclaration1;
	});

	__getset(1,DominoVertex,'vertexDeclaration1',function(){
		return DominoVertex._vertexDeclaration1;
	});

	__getset(1,DominoVertex,'vertexDeclaration2',function(){
		return DominoVertex._vertexDeclaration2;
	});

	__static(DominoVertex,
	['_vertexDeclaration1',function(){return this._vertexDeclaration1=new VertexDeclaration(16,
		[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1)]);},'_vertexDeclaration2',function(){return this._vertexDeclaration2=new VertexDeclaration(24,
		[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3)]);}
	]);
	return DominoVertex;
})()


/**
*...
*@author
*/
//class laya.d3.extension.lineRender.LineVertex
var LineVertex=(function(){
	function LineVertex(){}
	__class(LineVertex,'laya.d3.extension.lineRender.LineVertex');
	var __proto=LineVertex.prototype;
	__getset(0,__proto,'vertexDeclaration',function(){
		return LineVertex._vertexDeclaration1;
	});

	__getset(1,LineVertex,'vertexDeclaration1',function(){
		return LineVertex._vertexDeclaration1;
	});

	__getset(1,LineVertex,'vertexDeclaration2',function(){
		return LineVertex._vertexDeclaration2;
	});

	__getset(1,LineVertex,'vertexDeclaration3',function(){
		return LineVertex._vertexDeclaration3;
	});

	__static(LineVertex,
	['_vertexDeclaration1',function(){return this._vertexDeclaration1=new VertexDeclaration(16,
		[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Single*/"single",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0Y*/40)]);},'_vertexDeclaration2',function(){return this._vertexDeclaration2=new VertexDeclaration(12,
		[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.OFFSETVECTOR*/41)]);},'_vertexDeclaration3',function(){return this._vertexDeclaration3=new VertexDeclaration(8,
		[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Single*/"single",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0X*/38),
		new VertexElement(4,/*laya.d3.graphics.VertexElementFormat.Single*/"single",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0X1*/39)]);}
	]);
	return LineVertex;
})()


/**
*@private
*<code>DynamicBatch</code> 类用于动态批处理。
*/
//class laya.d3.graphics.DynamicBatch
var DynamicBatch=(function(){
	function DynamicBatch(vertexDeclaration){
		this._vertexDeclaration=null;
		this._vertexDatas=null;
		this._indexDatas=null;
		this._vertexBuffer=null;
		this._indexBuffer=null;
		this._currentCombineVertexCount=0;
		this._currentCombineIndexCount=0;
		this._combineRenderElements=null;
		this._materials=null;
		this._materialToRenderElementsOffsets=null;
		this._merageElements=null;
		this._combineRenderElementPool=null;
		this._combineRenderElementPoolIndex=0;
		this._currentCombineVertexCount=0;
		this._currentCombineIndexCount=0;
		this._combineRenderElements=[];
		this._materialToRenderElementsOffsets=[];
		this._materials=[];
		this._merageElements=[];
		this._combineRenderElementPool=[];
		this._combineRenderElementPoolIndex=0;
		this._vertexDeclaration=vertexDeclaration;
	}

	__class(DynamicBatch,'laya.d3.graphics.DynamicBatch');
	var __proto=DynamicBatch.prototype;
	Laya.imps(__proto,{"laya.d3.core.render.IRenderable":true})
	__proto._getVertexBuffer=function(index){
		(index===void 0)&& (index=0);
		if (index===0)
			return this._vertexBuffer;
		else
		return null;
	}

	__proto._getIndexBuffer=function(){
		return this._indexBuffer;
	}

	__proto._getCombineRenderElementFromPool=function(view,projection,projectionView){
		var renderElement=this._combineRenderElementPool[this._combineRenderElementPoolIndex++];
		if (!renderElement){
			this._combineRenderElementPool[this._combineRenderElementPoolIndex-1]=renderElement=new RenderElement();
			renderElement._sprite3D=new MeshSprite3D();
		}
		renderElement._sprite3D._render._renderUpdate(projectionView);
		return renderElement;
	}

	__proto._getRenderElement=function(view,projection,projectionView){
		if (!this._vertexDatas){
			this._vertexDatas=new Float32Array(this._vertexDeclaration.vertexStride / 4 *DynamicBatch.maxVertexCount);
			this._indexDatas=new Uint16Array(DynamicBatch.maxIndexCount);
			this._vertexBuffer=VertexBuffer3D.create(this._vertexDeclaration,DynamicBatch.maxVertexCount,/*laya.webgl.WebGLContext.DYNAMIC_DRAW*/0x88E8);
			this._indexBuffer=IndexBuffer3D.create(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",DynamicBatch.maxIndexCount,/*laya.webgl.WebGLContext.DYNAMIC_DRAW*/0x88E8);
		}
		this._merageElements.length=0;
		var curMerVerCount=0;
		var curIndexCount=0;
		for (var i=0,n=this._combineRenderElements.length;i < n;i++){
			var renderElement=this._combineRenderElements[i];
			var subVertexDatas=renderElement.getDynamicBatchBakedVertexs(0);
			var subIndexDatas=renderElement.getBakedIndices();
			var isInvert=renderElement._sprite3D.transform._isFrontFaceInvert;
			var indexOffset=curMerVerCount / (this._vertexDeclaration.vertexStride / 4);
			var indexStart=curIndexCount;
			var indexEnd=indexStart+subIndexDatas.length;
			renderElement._tempBatchIndexStart=indexStart;
			renderElement._tempBatchIndexEnd=indexEnd;
			this._indexDatas.set(subIndexDatas,curIndexCount);
			var k=0;
			if (isInvert){
				for (k=indexStart;k < indexEnd;k+=3){
					this._indexDatas[k]=indexOffset+this._indexDatas[k];
					var index1=this._indexDatas[k+1];
					var index2=this._indexDatas[k+2];
					this._indexDatas[k+1]=indexOffset+index2;
					this._indexDatas[k+2]=indexOffset+index1;
				}
				}else {
				for (k=indexStart;k < indexEnd;k+=3){
					this._indexDatas[k]=indexOffset+this._indexDatas[k];
					this._indexDatas[k+1]=indexOffset+this._indexDatas[k+1];
					this._indexDatas[k+2]=indexOffset+this._indexDatas[k+2];
				}
			}
			curIndexCount+=subIndexDatas.length;
			this._vertexDatas.set(subVertexDatas,curMerVerCount);
			curMerVerCount+=subVertexDatas.length;
		}
		this._vertexBuffer.setData(this._vertexDatas);
		this._indexBuffer.setData(this._indexDatas);
		this._combineRenderElementPoolIndex=0;
		for (i=0,n=this._materials.length;i < n;i++){
			var merageElement=this._getCombineRenderElementFromPool(view,projection,projectionView);
			merageElement._type=2;
			merageElement._staticBatch=null;
			merageElement.renderObj=this;
			var renderElementStartIndex=this._combineRenderElements[this._materialToRenderElementsOffsets[i]]._tempBatchIndexStart;
			var renderElementEndIndex=(i+1===this._materialToRenderElementsOffsets.length)? curIndexCount :this._combineRenderElements[this._materialToRenderElementsOffsets[i+1]]._tempBatchIndexStart;
			merageElement._tempBatchIndexStart=renderElementStartIndex;
			merageElement._tempBatchIndexEnd=renderElementEndIndex;
			merageElement._material=this._materials[i];
			this._merageElements.push(merageElement);
		}
	}

	__proto._addCombineRenderObjTest=function(renderElement){
		var renderObj=renderElement.renderObj;
		var indexCount=this._currentCombineIndexCount+renderObj._getIndexBuffer().indexCount;
		var vertexCount=this._currentCombineVertexCount+renderObj._getVertexBuffer().vertexCount;
		if (vertexCount > DynamicBatch.maxVertexCount || indexCount > DynamicBatch.maxIndexCount){
			return false;
		}
		return true;
	}

	__proto._addCombineRenderObj=function(renderElement){
		var renderObj=renderElement.renderObj;
		this._combineRenderElements.push(renderElement);
		this._currentCombineIndexCount=this._currentCombineIndexCount+renderObj._getIndexBuffer().indexCount;
		this._currentCombineVertexCount=this._currentCombineVertexCount+renderObj._getVertexBuffer().vertexCount;
	}

	__proto._addCombineMaterial=function(material){
		this._materials.push(material);
	}

	__proto._addMaterialToRenderElementOffset=function(offset){
		this._materialToRenderElementsOffsets.push(offset);
	}

	__proto._clearRenderElements=function(){
		this._combineRenderElements.length=0;
		this._materials.length=0;
		this._materialToRenderElementsOffsets.length=0;
		this._currentCombineVertexCount=0;
		this._currentCombineIndexCount=0;
	}

	__proto._addToRenderQueue=function(scene,view,projection,projectionView){
		this._getRenderElement(view,projection,projectionView);
		for (var i=0,n=this._materials.length;i < n;i++)
		scene.getRenderQueue(this._materials[i].renderQueue)._addDynamicBatchElement(this._merageElements[i]);
	}

	__proto._beforeRender=function(state){
		this._vertexBuffer._bind();
		this._indexBuffer._bind();
		return true;
	}

	__proto._render=function(state){
		var indexCount=state._batchIndexEnd-state._batchIndexStart;
		WebGL.mainContext.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,indexCount,/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,state._batchIndexStart *2);
		Stat.drawCall++;
		Stat.trianglesFaces+=indexCount / 3;
	}

	/**
	*@private
	*/
	__proto._getVertexBuffers=function(){
		return null;
	}

	__getset(0,__proto,'_vertexBufferCount',function(){
		return 1;
	});

	__getset(0,__proto,'triangleCount',function(){
		return this._indexBuffer.indexCount / 3;
	});

	__getset(0,__proto,'combineRenderElementsCount',function(){
		return this._combineRenderElements.length;
	});

	DynamicBatch.maxVertexCount=20000;
	DynamicBatch.maxIndexCount=40000;
	DynamicBatch.maxCombineTriangleCount=10;
	return DynamicBatch;
})()


/**
*@private
*<code>DynamicBatchManager</code> 类用于管理动态批处理。
*/
//class laya.d3.graphics.DynamicBatchManager
var DynamicBatchManager=(function(){
	function DynamicBatchManager(){
		this._dynamicBatches=null;
		this._prepareDynamicBatchCombineElements=null;
		this._dynamicBatches={};
		this._prepareDynamicBatchCombineElements=[];
	}

	__class(DynamicBatchManager,'laya.d3.graphics.DynamicBatchManager');
	var __proto=DynamicBatchManager.prototype;
	__proto.getDynamicBatch=function(_vertexDeclaration,number){
		var dynamicBatch;
		var key=_vertexDeclaration.id.toString()+number;
		if (!this._dynamicBatches[key]){
			this._dynamicBatches[key]=dynamicBatch=new DynamicBatch(_vertexDeclaration);
			}else {
			dynamicBatch=this._dynamicBatches[key];
		}
		return dynamicBatch;
	}

	/**需手动调用*/
	__proto._garbageCollection=function(){
		for (var key in this._dynamicBatches)
		if (this._dynamicBatches[key].combineRenderElementsCount===0)
			delete this._dynamicBatches[key];
	}

	__proto._addPrepareRenderElement=function(renderElement){
		this._prepareDynamicBatchCombineElements.push(renderElement);
	}

	/**@private */
	__proto._finishCombineDynamicBatch=function(scene){
		this._prepareDynamicBatchCombineElements.sort(DynamicBatchManager._sortPrepareDynamicBatch);
		var lastMaterial;
		var lastVertexDeclaration;
		var lastRenderElement;
		var lastBatchNumber=-1;
		var lastCanMerage=true;
		var curMaterial;
		var curRenderElement;
		var curDynamicBatch;
		var curbatchNumber=0;
		var laterAddMaterial;
		var laterAddRenderElement;
		var laterAddMatToElementOffset=-1;
		for (var i=0,n=this._prepareDynamicBatchCombineElements.length;i < n;i++){
			curRenderElement=this._prepareDynamicBatchCombineElements[i];
			var curDeclaration=curRenderElement.renderObj._getVertexBuffer(0).vertexDeclaration;
			var declarationChanged=(lastVertexDeclaration!==curDeclaration);
			declarationChanged && (curbatchNumber=0,lastVertexDeclaration=curDeclaration);
			var batchNumbrChanged=(curbatchNumber!==lastBatchNumber);
			batchNumbrChanged && (lastBatchNumber=curbatchNumber);
			if ((declarationChanged)|| batchNumbrChanged){
				curDynamicBatch=this.getDynamicBatch(curDeclaration,curbatchNumber);
				lastMaterial=null;
			}
			if (lastCanMerage){
				if (curDynamicBatch._addCombineRenderObjTest(curRenderElement)){
					curMaterial=curRenderElement._material;
					if (lastMaterial!==curMaterial){
						if (laterAddMaterial){
							scene.getRenderQueue(laterAddRenderElement._material.renderQueue)._addRenderElement(laterAddRenderElement);
							laterAddMaterial=null;
							laterAddRenderElement=null;
							laterAddMatToElementOffset=-1;
						}
						laterAddMaterial=curMaterial;
						laterAddMatToElementOffset=curDynamicBatch.combineRenderElementsCount;
						laterAddRenderElement=curRenderElement;
						lastMaterial=curMaterial;
						}else {
						if (laterAddMaterial){
							var lastRenderObj=laterAddRenderElement.renderObj;
							var curRenderObj=curRenderElement.renderObj;
							if (((lastRenderObj._getVertexBuffer().vertexCount+curRenderObj._getVertexBuffer().vertexCount)> DynamicBatch.maxVertexCount)|| ((lastRenderObj._getIndexBuffer().indexCount+curRenderObj._getIndexBuffer().indexCount)> DynamicBatch.maxIndexCount)){
								scene.getRenderQueue(laterAddRenderElement._material.renderQueue)._addRenderElement(laterAddRenderElement);
								laterAddMaterial=curMaterial;
								laterAddMatToElementOffset=curDynamicBatch.combineRenderElementsCount;
								laterAddRenderElement=curRenderElement;
								}else {
								curDynamicBatch._addCombineMaterial(laterAddMaterial);
								curDynamicBatch._addMaterialToRenderElementOffset(laterAddMatToElementOffset);
								curDynamicBatch._addCombineRenderObj(laterAddRenderElement);
								laterAddMaterial=null;
								laterAddRenderElement=null;
								laterAddMatToElementOffset=-1;
								curDynamicBatch._addCombineRenderObj(curRenderElement);
							}
							}else {
							curDynamicBatch._addCombineRenderObj(curRenderElement);
						}
					}
					lastCanMerage=true;
					}else {
					if (laterAddMaterial){
						scene.getRenderQueue(laterAddRenderElement._material.renderQueue)._addRenderElement(laterAddRenderElement);
						laterAddMaterial=null;
						laterAddRenderElement=null;
						laterAddMatToElementOffset=-1;
					}
					curbatchNumber++;
					lastCanMerage=false;
				}
				}else {
				lastRenderElement=this._prepareDynamicBatchCombineElements[i-1];
				curDynamicBatch._addMaterialToRenderElementOffset(curDynamicBatch.combineRenderElementsCount);
				lastMaterial=lastRenderElement._material;
				curDynamicBatch._addCombineMaterial(lastMaterial);
				curDynamicBatch._addCombineRenderObj(lastRenderElement);
				lastCanMerage=true;
				curMaterial=curRenderElement._material;
				if (lastMaterial!==curMaterial){
					laterAddMaterial=curMaterial;
					laterAddMatToElementOffset=curDynamicBatch.combineRenderElementsCount;
					laterAddRenderElement=curRenderElement;
					}else {
					curDynamicBatch._addCombineRenderObj(curRenderElement);
				}
				lastMaterial=curMaterial;
			}
		}
		if (laterAddMaterial){
			scene.getRenderQueue(laterAddRenderElement._material.renderQueue)._addRenderElement(laterAddRenderElement);
			laterAddMaterial=null;
			laterAddRenderElement=null;
			laterAddMatToElementOffset=-1;
		}
		this._prepareDynamicBatchCombineElements.length=0;
	}

	__proto._clearRenderElements=function(){
		for (var key in this._dynamicBatches)
		this._dynamicBatches[key]._clearRenderElements();
	}

	__proto._addToRenderQueue=function(scene,view,projection,projectionView){
		for (var key in this._dynamicBatches){
			var dynamicBatch=this._dynamicBatches[key];
			(dynamicBatch.combineRenderElementsCount > 0)&& (dynamicBatch._addToRenderQueue(scene,view,projection,projectionView));
		}
	}

	__proto.dispose=function(){
		this._dynamicBatches=null;
	}

	DynamicBatchManager._sortPrepareDynamicBatch=function(a,b){
		return a._mainSortID-b._mainSortID;
	}

	return DynamicBatchManager;
})()


/**
*@private
*/
//class laya.d3.graphics.FrustumCulling
var FrustumCulling=(function(){
	function FrustumCulling(){}
	__class(FrustumCulling,'laya.d3.graphics.FrustumCulling');
	FrustumCulling.renderShadowObjectCulling=function(scene,lightFrustum,shadowQueues,lightViewProjectMatrix,nPSSMNum){
		var i=0,j=0,n=0,m=0;
		for (i=0,n=shadowQueues.length;i < n;i++){
			var quene=shadowQueues[i];
			(quene)&& (quene._clearRenderElements());
		};
		var frustumCullingObjects=scene._cullingRenders;
		var baseRender,shadowQueue,renderElements;
		if (nPSSMNum > 1){
			for (i=0,n=scene._cullingRendersLength;i < n;i++){
				baseRender=frustumCullingObjects[i];
				if (baseRender.castShadow && Layer.isVisible(baseRender._owner.layer.mask)&& baseRender.enable){
					for (var k=1,kNum=lightFrustum.length;k < kNum;k++){
						shadowQueue=shadowQueues[k-1];
						if (lightFrustum[k].containsBoundSphere(baseRender.boundingSphere)!==/*laya.d3.math.ContainmentType.Disjoint*/0){
							renderElements=baseRender._renderElements;
							for (j=0,m=renderElements.length;j < m;j++)
							shadowQueue._addRenderElement(renderElements[j]);
						}
					}
				}
			}
			}else {
			for (i=0,n=scene._cullingRendersLength;i < n;i++){
				baseRender=frustumCullingObjects[i];
				if (baseRender.castShadow && Layer.isVisible(baseRender._owner.layer.mask)&& baseRender.enable){
					if (lightFrustum[0].containsBoundSphere(baseRender.boundingSphere)!==/*laya.d3.math.ContainmentType.Disjoint*/0){
						baseRender._renderUpdate(lightViewProjectMatrix);
						shadowQueue=shadowQueues[0];
						renderElements=baseRender._renderElements;
						for (j=0,m=renderElements.length;j < m;j++)
						shadowQueue._addRenderElement(renderElements[j]);
					}
				}
			}
		}
	}

	FrustumCulling.renderShadowObjectCullingOctree=function(scene,lightFrustum,quenesResult,lightViewProjectMatrix,nPSSMNum){
		for (var i=0,n=quenesResult.length;i < n;i++){
			var quene=quenesResult[i];
			(quene)&& (quene._clearRenderElements());
		}
		if (nPSSMNum > 1){
			scene.treeRoot.cullingShadowObjects(lightFrustum,quenesResult,true,0,scene);
			}else {
			scene.treeRoot.cullingShadowObjectsOnePSSM(lightFrustum[0],quenesResult,lightViewProjectMatrix,true,0,scene);
		}
	}

	FrustumCulling.renderObjectCulling=function(boundFrustum,scene,camera,view,projection,projectionView){
		var i=0,n=0,j=0,m=0;
		var queues=scene._quenes;
		var dynamicBatchManager=scene._dynamicBatchManager;
		var frustumCullingObjects=scene._cullingRenders;
		for (i=0,n=queues.length;i < n;i++){
			var queue=queues[i];
			(queue)&& (queue._clearRenderElements());
		};
		var staticBatchManagers=StaticBatchManager._staticBatchManagers;
		for (i=0,n=staticBatchManagers.length;i < n;i++)
		staticBatchManagers[i]._clearRenderElements();
		dynamicBatchManager._clearRenderElements();
		var cameraPosition=camera.transform.position;
		for (i=0,n=scene._cullingRendersLength;i < n;i++){
			var baseRender=frustumCullingObjects[i];
			if (Layer.isVisible(baseRender._owner.layer.mask)&& baseRender.enable && (boundFrustum.containsBoundSphere(baseRender.boundingSphere)!==/*laya.d3.math.ContainmentType.Disjoint*/0)){
				if (baseRender._renderUpdate(projectionView)){
					baseRender._distanceForSort=Vector3.distance(baseRender.boundingSphere.center,cameraPosition)+baseRender.sortingFudge;
					var renderElements=baseRender._renderElements;
					for (j=0,m=renderElements.length;j < m;j++){
						var renderElement=renderElements[j];
						var staticBatch=renderElement._staticBatch;
						if (staticBatch && (staticBatch._material===renderElement._material)){
							staticBatch._addBatchRenderElement(renderElement);
							}else {
							var renderObj=renderElement.renderObj;
							if ((renderObj.triangleCount < /*laya.d3.graphics.DynamicBatch.maxCombineTriangleCount*/10)&& (renderObj._vertexBufferCount===1)&& (renderObj._getIndexBuffer())&& (renderElement._material.renderQueue < 2)&& renderElement._canDynamicBatch && (!baseRender._owner.isStatic))
								dynamicBatchManager._addPrepareRenderElement(renderElement);
							else
							scene.getRenderQueue(renderElement._material.renderQueue)._addRenderElement(renderElement);
						}
					}
				}
			}
		}
		for (i=0,n=staticBatchManagers.length;i < n;i++)
		staticBatchManagers[i]._addToRenderQueue(scene,view,projection,projectionView);
		dynamicBatchManager._finishCombineDynamicBatch(scene);
		dynamicBatchManager._addToRenderQueue(scene,view,projection,projectionView);
	}

	FrustumCulling.renderObjectCullingOctree=function(boundFrustum,scene,camera,view,projection,projectionView){
		var i=0,n=0;
		var queues=scene._quenes;
		var dynamicBatchManager=scene._dynamicBatchManager;
		for (i=0,n=queues.length;i < n;i++){
			var queue=queues[i];
			(queue)&& (queue._clearRenderElements());
		};
		var staticBatchManagers=StaticBatchManager._staticBatchManagers;
		for (i=0,n=staticBatchManagers.length;i < n;i++)
		staticBatchManagers[i]._clearRenderElements();
		dynamicBatchManager._clearRenderElements();
		scene._cullingRenders.length=0;
		scene.treeRoot.cullingObjects(boundFrustum,true,0,camera.transform.position,projectionView);
		for (i=0,n=staticBatchManagers.length;i < n;i++)
		staticBatchManagers[i]._addToRenderQueue(scene,view,projection,projectionView);
		dynamicBatchManager._finishCombineDynamicBatch(scene);
		dynamicBatchManager._addToRenderQueue(scene,view,projection,projectionView);
	}

	FrustumCulling.renderObjectCullingNoBoundFrustum=function(scene,camera,view,projection,projectionView){
		var i=0,n=0,j=0,m=0;
		var queues=scene._quenes;
		var dynamicBatchManager=scene._dynamicBatchManager;
		var frustumCullingObjects=scene._cullingRenders;
		for (i=0,n=queues.length;i < n;i++){
			var queue=queues[i];
			(queue)&& (queue._clearRenderElements());
		};
		var staticBatchManagers=StaticBatchManager._staticBatchManagers;
		for (i=0,n=staticBatchManagers.length;i < n;i++)
		staticBatchManagers[i]._clearRenderElements();
		dynamicBatchManager._clearRenderElements();
		var cameraPosition=camera.transform.position;
		for (i=0,n=scene._cullingRendersLength;i < n;i++){
			var baseRender=frustumCullingObjects[i];
			if (Layer.isVisible(baseRender._owner.layer.mask)&& baseRender.enable){
				baseRender._renderUpdate(projectionView);
				baseRender._distanceForSort=Vector3.distance(baseRender.boundingSphere.center,cameraPosition)+baseRender.sortingFudge;
				var renderElements=baseRender._renderElements;
				for (j=0,m=renderElements.length;j < m;j++){
					var renderElement=renderElements[j];
					var staticBatch=renderElement._staticBatch;
					if (staticBatch && (staticBatch._material===renderElement._material)){
						staticBatch._addBatchRenderElement(renderElement);
						}else {
						var renderObj=renderElement.renderObj;
						if ((renderObj.triangleCount < /*laya.d3.graphics.DynamicBatch.maxCombineTriangleCount*/10)&& (renderObj._vertexBufferCount===1)&& (renderObj._getIndexBuffer())&& (renderElement._material.renderQueue < 2)&& renderElement._canDynamicBatch && (!baseRender._owner.isStatic))
							dynamicBatchManager._addPrepareRenderElement(renderElement);
						else
						scene.getRenderQueue(renderElement._material.renderQueue)._addRenderElement(renderElement);
					}
				}
			}
		}
		for (i=0,n=staticBatchManagers.length;i < n;i++)
		staticBatchManagers[i]._addToRenderQueue(scene,view,projection,projectionView);
		dynamicBatchManager._finishCombineDynamicBatch(scene);
		dynamicBatchManager._addToRenderQueue(scene,view,projection,projectionView);
	}

	return FrustumCulling;
})()


/**
*@private
*<code>StaticBatchManager</code> 类用于静态批处理管理的父类。
*/
//class laya.d3.graphics.StaticBatchManager
var StaticBatchManager=(function(){
	function StaticBatchManager(){
		/**@private */
		this._initBatchRenderElements=null;
		/**@private */
		this._staticBatches=null;
		this._initBatchRenderElements=[];
		this._staticBatches={};
	}

	__class(StaticBatchManager,'laya.d3.graphics.StaticBatchManager');
	var __proto=StaticBatchManager.prototype;
	/**
	*@private
	*/
	__proto._finishInit=function(){
		for (var key in this._staticBatches)
		this._staticBatches[key]._finishInit();
		this._initBatchRenderElements.length=0;
	}

	/**
	*@private
	*/
	__proto._initStaticBatchs=function(rootSprite){
		throw new Error("StaticBatchManager:must override this function.");
	}

	/**
	*@private
	*/
	__proto._addInitBatchSprite=function(renderableSprite3D){
		var renderElements=renderableSprite3D._render._renderElements;
		for (var i=0,n=renderElements.length;i < n;i++)
		this._initBatchRenderElements.push(renderElements[i]);
	}

	/**
	*@private
	*/
	__proto._clearRenderElements=function(){
		for (var key in this._staticBatches)
		this._staticBatches[key]._clearRenderElements();
	}

	/**
	*@private
	*/
	__proto._garbageCollection=function(renderElement){
		var staticBatch=renderElement._staticBatch;
		var initBatchRenderElements=staticBatch._initBatchRenderElements;
		var index=initBatchRenderElements.indexOf(renderElement);
		initBatchRenderElements.splice(index,1);
		if (initBatchRenderElements.length===0){
			staticBatch.dispose();
			delete this._staticBatches[staticBatch._key];
		}
	}

	/**
	*@private
	*/
	__proto._addToRenderQueue=function(scene,view,projection,projectionView){
		for (var key in this._staticBatches){
			var staticBatch=this._staticBatches[key];
			if (staticBatch._batchRenderElements.length > 0)
				staticBatch._updateToRenderQueue(scene,projectionView);
		}
	}

	__proto.dispose=function(){
		this._staticBatches=null;
	}

	StaticBatchManager._addToStaticBatchQueue=function(sprite3D){
		if ((sprite3D instanceof laya.d3.core.RenderableSprite3D ))
			(sprite3D)._addToInitStaticBatchManager();
		for (var i=0,n=sprite3D.numChildren;i < n;i++)
		StaticBatchManager._addToStaticBatchQueue(sprite3D._childs [i]);
	}

	StaticBatchManager.combine=function(staticBatchRoot,renderableSprite3Ds){
		var i=0,n=0,staticBatchManager;
		if (renderableSprite3Ds){
			for (i=0,n=renderableSprite3Ds.length;i < n;i++){
				var renderableSprite3D=renderableSprite3Ds[i];
				renderableSprite3D._addToInitStaticBatchManager();
			}
			}else {
			if (staticBatchRoot)
				StaticBatchManager._addToStaticBatchQueue(staticBatchRoot);
		}
		for (i=0,n=StaticBatchManager._staticBatchManagers.length;i < n;i++){
			staticBatchManager=StaticBatchManager._staticBatchManagers[i];
			staticBatchManager._initStaticBatchs(staticBatchRoot);
			staticBatchManager._finishInit();
		}
	}

	StaticBatchManager._staticBatchManagers=[];
	return StaticBatchManager;
})()


/**
*<code>StaticBatch</code> 类用于静态合并的父类,该类为抽象类。
*/
//class laya.d3.graphics.StaticBatch
var StaticBatch=(function(){
	function StaticBatch(key,manager,rootOwner){
		/**@private */
		this._combineRenderElementPoolIndex=0;
		/**@private */
		this._combineRenderElementPool=null;
		/**@private */
		this._initBatchRenderElements=null;
		/**@private */
		this._batchRenderElements=null;
		/**@private */
		this._material=null;
		/**@private */
		this._rootOwner=null;
		/**@private */
		this._key=null;
		/**@private */
		this._manager=null;
		this._key=key;
		this._manager=manager;
		this._combineRenderElementPoolIndex=0;
		this._combineRenderElementPool=[];
		this._initBatchRenderElements=[];
		this._batchRenderElements=[];
		this._rootOwner=rootOwner;
	}

	__class(StaticBatch,'laya.d3.graphics.StaticBatch');
	var __proto=StaticBatch.prototype;
	Laya.imps(__proto,{"laya.d3.core.render.IRenderable":true,"laya.resource.IDispose":true})
	/**
	*@private
	*/
	__proto._binarySearch=function(renderElement){
		var start=0;
		var end=this._batchRenderElements.length-1;
		var mid=0;
		while (start <=end){
			mid=Math.floor((start+end)/ 2);
			if (this._compareBatchRenderElement(this._batchRenderElements[mid],renderElement))
				end=mid-1;
			else
			start=mid+1;
		}
		return start;
	}

	/**
	*@private
	*/
	__proto._compareBatchRenderElement=function(a,b){
		throw new Error("StaticBatch:must override this function.");
	}

	/**
	*@private
	*/
	__proto._getVertexDecLightMap=function(vertexDeclaration){
		if (vertexDeclaration===VertexPositionNormalTextureSkinSTangent.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1SkinSTangent.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalTextureSkin.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1Skin.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalColorTextureSTangent.vertexDeclaration){
			return VertexPositionNormalColorTexture0Texture1STangent.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNTBTexture.vertexDeclaration){
			return null;
			}else if (vertexDeclaration===VertexPositionNormalColorTexture.vertexDeclaration){
			return VertexPositionNormalColorTexture0Texture1.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalTextureSTangent.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1STangent.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalTexture.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1.vertexDeclaration;
		}
		if (vertexDeclaration===VertexPositionNormalTextureSkinTangent.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1SkinTangent.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalTextureSkin.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1Skin.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalColorTextureTangent.vertexDeclaration){
			return VertexPositionNormalColorTexture0Texture1Tangent.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNTBTexture.vertexDeclaration){
			return null;
			}else if (vertexDeclaration===VertexPositionNormalColorTexture.vertexDeclaration){
			return VertexPositionNormalColorTexture0Texture1.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalTextureTangent.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1Tangent.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalTexture.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1.vertexDeclaration;
			}else {
			return vertexDeclaration;
		}
	}

	/**
	*@private
	*/
	__proto._getCombineRenderElementFromPool=function(){
		throw new Error("StaticBatch:must override this function.");
	}

	/**
	*@private
	*/
	__proto._addBatchRenderElement=function(renderElement){
		this._batchRenderElements.splice(this._binarySearch(renderElement),0,renderElement);
	}

	/**
	*@private
	*/
	__proto._updateToRenderQueue=function(scene,projectionView){
		this._combineRenderElementPoolIndex=0;
		this._getRenderElement(scene.getRenderQueue(this._material.renderQueue)._renderElements,scene,projectionView);
	}

	/**
	*@private
	*/
	__proto._getRenderElement=function(mergeElements,scene,projectionView){
		throw new Error("StaticBatch:must override this function.");
	}

	/**
	*@private
	*/
	__proto._finishInit=function(){
		throw new Error("StaticBatch:must override this function.");
	}

	/**
	*@private
	*/
	__proto._clearRenderElements=function(){
		this._batchRenderElements.length=0;
	}

	/**
	*@private
	*/
	__proto.dispose=function(){}
	//..................临时.................................
	__proto._getVertexBuffer=function(index){
		(index===void 0)&& (index=0);
		return null;
	}

	__proto._getIndexBuffer=function(){
		return null;
	}

	__proto._beforeRender=function(state){
		return true;
	}

	__proto._render=function(state){}
	/**
	*@private
	*/
	__proto._getVertexBuffers=function(){
		return null;
	}

	//..................临时.................................
	__getset(0,__proto,'_vertexBufferCount',function(){
		return 1;
	});

	__getset(0,__proto,'triangleCount',function(){
		return 0;
	});

	StaticBatch.combine=function(staticBatchRoot){
		console.log("StaticBatch: discard property,please use StaticBatchManager.combine() function instead.");
		StaticBatchManager.combine(staticBatchRoot);
	}

	StaticBatch.maxBatchVertexCount=65535;
	return StaticBatch;
})()


/**
*...
*@author ...
*/
//class laya.d3.graphics.VertexDeclaration
var VertexDeclaration=(function(){
	function VertexDeclaration(vertexStride,vertexElements){
		this._id=0;
		this._shaderValues=null;
		this._shaderDefineValue=0;
		//private var _shaderAttribute:*;
		this._vertexStride=0;
		this._vertexElements=null;
		this._vertexElementsDic=null;
		this._id=++VertexDeclaration._uniqueIDCounter;
		if (this._id > VertexDeclaration.maxVertexDeclaration)
			throw new Error("VertexDeclaration: VertexDeclaration count should not large than ",VertexDeclaration.maxVertexDeclaration);
		this._shaderValues=new ValusArray();
		this._vertexElementsDic={};
		this._vertexStride=vertexStride;
		this._vertexElements=vertexElements;
		for (var i=0;i < vertexElements.length;i++){
			var vertexElement=vertexElements[i];
			var attributeName=vertexElement.elementUsage;
			this._vertexElementsDic[attributeName]=vertexElement;
			var value=[VertexDeclaration._getTypeSize(vertexElement.elementFormat)/ 4,/*laya.webgl.WebGLContext.FLOAT*/0x1406,false,this._vertexStride,vertexElement.offset];
			this._shaderValues.setValue(attributeName,value);
			switch (attributeName){
				case /*laya.d3.graphics.VertexElementUsage.COLOR0*/1:
					this._addShaderDefine(ShaderCompile3D.SHADERDEFINE_COLOR);
					break
				case /*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2:
					this._addShaderDefine(ShaderCompile3D.SHADERDEFINE_UV0);
					break ;
				case /*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15:
					this._addShaderDefine(ShaderCompile3D.SHADERDEFINE_UV1);
					break ;
				}
		}
	}

	__class(VertexDeclaration,'laya.d3.graphics.VertexDeclaration');
	var __proto=VertexDeclaration.prototype;
	/**
	*增加Shader宏定义。
	*@param value 宏定义。
	*/
	__proto._addShaderDefine=function(value){
		this._shaderDefineValue |=value;
	}

	/**
	*移除Shader宏定义。
	*@param value 宏定义。
	*/
	__proto._removeShaderDefine=function(value){
		this._shaderDefineValue &=~value;
	}

	__proto.getVertexElements=function(){
		return this._vertexElements.slice();
	}

	__proto.getVertexElementByUsage=function(usage){
		return this._vertexElementsDic[usage];
	}

	__proto.unBinding=function(){}
	__getset(0,__proto,'shaderDefineValue',function(){
		return this._shaderDefineValue;
	});

	/**
	*获取唯一标识ID(通常用于优化或识别)。
	*@return 唯一标识ID
	*/
	__getset(0,__proto,'id',function(){
		return this._id;
	});

	__getset(0,__proto,'vertexStride',function(){
		return this._vertexStride;
	});

	__getset(0,__proto,'shaderValues',function(){
		return this._shaderValues;
	});

	VertexDeclaration._getTypeSize=function(format){
		switch (format){
			case /*laya.d3.graphics.VertexElementFormat.Single*/"single":
				return 4;
			case /*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2":
				return 8;
			case /*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3":
				return 12;
			case /*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4":
				return 16;
			case /*laya.d3.graphics.VertexElementFormat.Color*/"color":
				return 4;
			case /*laya.d3.graphics.VertexElementFormat.Byte4*/"byte4":
				return 4;
			case /*laya.d3.graphics.VertexElementFormat.Short2*/"short2":
				return 4;
			case /*laya.d3.graphics.VertexElementFormat.Short4*/"short4":
				return 8;
			case /*laya.d3.graphics.VertexElementFormat.NormalizedShort2*/"normalizedshort2":
				return 4;
			case /*laya.d3.graphics.VertexElementFormat.NormalizedShort4*/"normalizedshort4":
				return 8;
			case /*laya.d3.graphics.VertexElementFormat.HalfVector2*/"halfvector2":
				return 4;
			case /*laya.d3.graphics.VertexElementFormat.HalfVector4*/"halfvector4":
				return 8;
			}
		return 0;
	}

	VertexDeclaration.getVertexStride=function(vertexElements){
		var curStride=0;
		for (var i=0;i < vertexElements.Length;i++){
			var element=vertexElements[i];
			var stride=element.offset+VertexDeclaration._getTypeSize(element.elementFormat);
			if (curStride < stride){
				curStride=stride;
			}
		}
		return curStride;
	}

	VertexDeclaration._maxVertexDeclarationBit=1000;
	VertexDeclaration._uniqueIDCounter=1;
	__static(VertexDeclaration,
	['maxVertexDeclaration',function(){return this.maxVertexDeclaration=2147483647-Math.floor(2147483647 / 1000)*1000;}
	]);
	return VertexDeclaration;
})()


/**
*<code>VertexElement</code> 类用于创建顶点结构分配。
*/
//class laya.d3.graphics.VertexElement
var VertexElement=(function(){
	function VertexElement(offset,elementFormat,elementUsage){
		this.offset=0;
		this.elementFormat=null;
		this.elementUsage=0;
		this.offset=offset;
		this.elementFormat=elementFormat;
		this.elementUsage=elementUsage;
	}

	__class(VertexElement,'laya.d3.graphics.VertexElement');
	return VertexElement;
})()


/**
*...
*@author ...
*/
//class laya.d3.graphics.VertexElementFormat
var VertexElementFormat=(function(){
	function VertexElementFormat(){}
	__class(VertexElementFormat,'laya.d3.graphics.VertexElementFormat');
	VertexElementFormat.Single="single";
	VertexElementFormat.Vector2="vector2";
	VertexElementFormat.Vector3="vector3";
	VertexElementFormat.Vector4="vector4";
	VertexElementFormat.Color="color";
	VertexElementFormat.Byte4="byte4";
	VertexElementFormat.Short2="short2";
	VertexElementFormat.Short4="short4";
	VertexElementFormat.NormalizedShort2="normalizedshort2";
	VertexElementFormat.NormalizedShort4="normalizedshort4";
	VertexElementFormat.HalfVector2="halfvector2";
	VertexElementFormat.HalfVector4="halfvector4";
	return VertexElementFormat;
})()


/**
*...
*@author ...
*/
//class laya.d3.graphics.VertexElementUsage
var VertexElementUsage=(function(){
	function VertexElementUsage(){}
	__class(VertexElementUsage,'laya.d3.graphics.VertexElementUsage');
	VertexElementUsage.POSITION0=0;
	VertexElementUsage.COLOR0=1;
	VertexElementUsage.TEXTURECOORDINATE0=2;
	VertexElementUsage.NORMAL0=3;
	VertexElementUsage.BINORMAL0=4;
	VertexElementUsage.TANGENT0=5;
	VertexElementUsage.BLENDINDICES0=6;
	VertexElementUsage.BLENDWEIGHT0=7;
	VertexElementUsage.DEPTH0=8;
	VertexElementUsage.FOG0=9;
	VertexElementUsage.POINTSIZE0=10;
	VertexElementUsage.SAMPLE0=11;
	VertexElementUsage.TESSELLATEFACTOR0=12;
	VertexElementUsage.COLOR1=13;
	VertexElementUsage.NEXTTEXTURECOORDINATE0=14;
	VertexElementUsage.TEXTURECOORDINATE1=15;
	VertexElementUsage.NEXTTEXTURECOORDINATE1=16;
	VertexElementUsage.CORNERTEXTURECOORDINATE0=17;
	VertexElementUsage.VELOCITY0=18;
	VertexElementUsage.STARTCOLOR0=19;
	VertexElementUsage.STARTSIZE=20;
	VertexElementUsage.AGEADDSCALE0=21;
	VertexElementUsage.STARTROTATION=22;
	VertexElementUsage.ENDCOLOR0=23;
	VertexElementUsage.STARTLIFETIME=24;
	VertexElementUsage.TIME0=33;
	VertexElementUsage.SHAPEPOSITIONSTARTLIFETIME=30;
	VertexElementUsage.DIRECTIONTIME=32;
	VertexElementUsage.SIZEROTATION0=27;
	VertexElementUsage.RADIUS0=28;
	VertexElementUsage.RADIAN0=29;
	VertexElementUsage.STARTSPEED=31;
	VertexElementUsage.RANDOM0=34;
	VertexElementUsage.RANDOM1=35;
	VertexElementUsage.SIMULATIONWORLDPOSTION=36;
	VertexElementUsage.SIMULATIONWORLDROTATION=37;
	VertexElementUsage.TEXTURECOORDINATE0X=38;
	VertexElementUsage.TEXTURECOORDINATE0X1=39;
	VertexElementUsage.TEXTURECOORDINATE0Y=40;
	VertexElementUsage.OFFSETVECTOR=41;
	return VertexElementUsage;
})()


/**
*<code>VertexPositionNormalColorTangent</code> 类用于创建粒子顶点结构。
*/
//class laya.d3.graphics.VertexGlitter
var VertexGlitter=(function(){
	function VertexGlitter(position,textureCoordinate,time){
		this._position=null;
		this._textureCoordinate0=null;
		this._time=NaN;
		this._position=position;
		this._textureCoordinate0=textureCoordinate;
		this._time=time;
	}

	__class(VertexGlitter,'laya.d3.graphics.VertexGlitter');
	var __proto=VertexGlitter.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'time',function(){
		return this._time;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexGlitter._vertexDeclaration;
	});

	__getset(1,VertexGlitter,'vertexDeclaration',function(){
		return VertexGlitter._vertexDeclaration;
	});

	__static(VertexGlitter,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(24,
		[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(20,/*laya.d3.graphics.VertexElementFormat.Single*/"single",/*laya.d3.graphics.VertexElementUsage.TIME0*/33)]);}
	]);
	return VertexGlitter;
})()


/**
*<code>VertexPositionNormalColorTangent</code> 类用于创建粒子顶点结构。
*/
//class laya.d3.graphics.VertexParticle
var VertexParticle=(function(){
	function VertexParticle(cornerTextureCoordinate,position,velocity,startColor,endColor,sizeRotation,radius,radian,ageAddScale,time){
		this._cornerTextureCoordinate=null;
		this._position=null;
		this._velocity=null;
		this._startColor=null;
		this._endColor=null;
		this._sizeRotation=null;
		this._radius=null;
		this._radian=null;
		this._ageAddScale=NaN;
		this._time=NaN;
		this._cornerTextureCoordinate=cornerTextureCoordinate;
		this._position=position;
		this._velocity=velocity;
		this._startColor=startColor;
		this._endColor=endColor;
		this._sizeRotation=sizeRotation;
		this._radius=radius;
		this._radian=radian;
		this._ageAddScale=ageAddScale;
		this._time=time;
	}

	__class(VertexParticle,'laya.d3.graphics.VertexParticle');
	var __proto=VertexParticle.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'endColor',function(){
		return this._endColor;
	});

	__getset(0,__proto,'cornerTextureCoordinate',function(){
		return this._cornerTextureCoordinate;
	});

	__getset(0,__proto,'sizeRotation',function(){
		return this._sizeRotation;
	});

	__getset(0,__proto,'velocity',function(){
		return this._velocity;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'startColor',function(){
		return this._startColor;
	});

	__getset(0,__proto,'radius',function(){
		return this._radius;
	});

	__getset(0,__proto,'radian',function(){
		return this._radian;
	});

	__getset(0,__proto,'ageAddScale',function(){
		return this._ageAddScale;
	});

	__getset(0,__proto,'time',function(){
		return this._time;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexParticle._vertexDeclaration;
	});

	__getset(1,VertexParticle,'vertexDeclaration',function(){
		return VertexParticle._vertexDeclaration;
	});

	__static(VertexParticle,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(116,
		[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.CORNERTEXTURECOORDINATE0*/17),
		new VertexElement(16,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(28,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.VELOCITY0*/18),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.STARTCOLOR0*/19),
		new VertexElement(56,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.ENDCOLOR0*/23),
		new VertexElement(72,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.SIZEROTATION0*/27),
		new VertexElement(84,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.RADIUS0*/28),
		new VertexElement(92,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.RADIAN0*/29),
		new VertexElement(108,/*laya.d3.graphics.VertexElementFormat.Single*/"single",/*laya.d3.graphics.VertexElementUsage.STARTLIFETIME*/24),
		new VertexElement(112,/*laya.d3.graphics.VertexElementFormat.Single*/"single",/*laya.d3.graphics.VertexElementUsage.TIME0*/33)]);}
	]);
	return VertexParticle;
})()


//class laya.d3.graphics.VertexPosition
var VertexPosition=(function(){
	function VertexPosition(position){
		this._position=null;
		this._position=position;
	}

	__class(VertexPosition,'laya.d3.graphics.VertexPosition');
	var __proto=VertexPosition.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPosition._vertexDeclaration;
	});

	/*INTERFACE laya.d3.graphics.IVertex */
	__getset(1,VertexPosition,'vertexDeclaration',function(){
		return VertexPosition._vertexDeclaration;
	});

	__static(VertexPosition,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(12,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0)]);}
	]);
	return VertexPosition;
})()


//class laya.d3.graphics.VertexPositionNormal
var VertexPositionNormal=(function(){
	function VertexPositionNormal(position,normal){
		this._position=null;
		this._normal=null;
		this._position=position;
		this._normal=normal;
	}

	__class(VertexPositionNormal,'laya.d3.graphics.VertexPositionNormal');
	var __proto=VertexPositionNormal.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormal._vertexDeclaration;
	});

	/*INTERFACE laya.d3.graphics.IVertex */
	__getset(1,VertexPositionNormal,'vertexDeclaration',function(){
		return VertexPositionNormal._vertexDeclaration;
	});

	__static(VertexPositionNormal,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(24,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3)]);}
	]);
	return VertexPositionNormal;
})()


/**
*<code>VertexPositionNormalColor</code> 类用于创建位置、法线、颜色顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColor
var VertexPositionNormalColor=(function(){
	function VertexPositionNormalColor(position,normal,color){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
	}

	__class(VertexPositionNormalColor,'laya.d3.graphics.VertexPositionNormalColor');
	var __proto=VertexPositionNormalColor.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColor._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColor,'vertexDeclaration',function(){
		return VertexPositionNormalColor._vertexDeclaration;
	});

	__static(VertexPositionNormalColor,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(40,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1)]);}
	]);
	return VertexPositionNormalColor;
})()


/**
*<code>VertexPositionNormalColorSkin</code> 类用于创建位置、法线、颜色、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorSkin
var VertexPositionNormalColorSkin=(function(){
	function VertexPositionNormalColorSkin(position,normal,color,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorSkin,'laya.d3.graphics.VertexPositionNormalColorSkin');
	var __proto=VertexPositionNormalColorSkin.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorSkin._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorSkin,'vertexDeclaration',function(){
		return VertexPositionNormalColorSkin._vertexDeclaration;
	});

	__static(VertexPositionNormalColorSkin,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(72,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(56,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6)]);}
	]);
	return VertexPositionNormalColorSkin;
})()


/**
*<code>VertexPositionNormalColorSkin</code> 类用于创建位置、法线、颜色、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorSkinSTangent
var VertexPositionNormalColorSkinSTangent=(function(){
	function VertexPositionNormalColorSkinSTangent(position,normal,color,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorSkinSTangent,'laya.d3.graphics.VertexPositionNormalColorSkinSTangent');
	var __proto=VertexPositionNormalColorSkinSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorSkinSTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorSkinSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorSkinSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorSkinSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(88,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(56,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6),
		new VertexElement(72,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalColorSkinSTangent;
})()


/**
*<code>VertexPositionNormalColorSkin</code> 类用于创建位置、法线、颜色、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorSkinTangent
var VertexPositionNormalColorSkinTangent=(function(){
	function VertexPositionNormalColorSkinTangent(position,normal,color,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorSkinTangent,'laya.d3.graphics.VertexPositionNormalColorSkinTangent');
	var __proto=VertexPositionNormalColorSkinTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorSkinTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorSkinTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorSkinTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorSkinTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(84,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(56,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6),
		new VertexElement(72,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalColorSkinTangent;
})()


/**
*<code>VertexPositionNormalColorTangent</code> 类用于创建位置、法线、颜色、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorSTangent
var VertexPositionNormalColorSTangent=(function(){
	function VertexPositionNormalColorSTangent(position,normal,color,tangent){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalColorSTangent,'laya.d3.graphics.VertexPositionNormalColorSTangent');
	var __proto=VertexPositionNormalColorSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorSTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(56,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalColorSTangent;
})()


/**
*<code>VertexPositionNormalColorTangent</code> 类用于创建位置、法线、颜色、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTangent
var VertexPositionNormalColorTangent=(function(){
	function VertexPositionNormalColorTangent(position,normal,color,tangent){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalColorTangent,'laya.d3.graphics.VertexPositionNormalColorTangent');
	var __proto=VertexPositionNormalColorTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(52,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalColorTangent;
})()


/**
*<code>VertexPositionNormalColorTexture</code> 类用于创建位置、法线、颜色、纹理顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTexture
var VertexPositionNormalColorTexture=(function(){
	function VertexPositionNormalColorTexture(position,normal,color,textureCoordinate){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate=textureCoordinate;
	}

	__class(VertexPositionNormalColorTexture,'laya.d3.graphics.VertexPositionNormalColorTexture');
	var __proto=VertexPositionNormalColorTexture.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorTexture,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTexture,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(48,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2)]);}
	]);
	return VertexPositionNormalColorTexture;
})()


/**
*<code>VertexPositionNormalColorTexture</code> 类用于创建位置、法线、颜色、纹理顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTexture0Texture1
var VertexPositionNormalColorTexture0Texture1=(function(){
	function VertexPositionNormalColorTexture0Texture1(position,normal,color,textureCoordinate0,textureCoordinate1){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
	}

	__class(VertexPositionNormalColorTexture0Texture1,'laya.d3.graphics.VertexPositionNormalColorTexture0Texture1');
	var __proto=VertexPositionNormalColorTexture0Texture1.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(1,VertexPositionNormalColorTexture0Texture1,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTexture0Texture1,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(56,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15)]);}
	]);
	return VertexPositionNormalColorTexture0Texture1;
})()


/**
*<code>VertexPositionNormalColorTextureSkin</code> 类用于创建位置、法线、颜色、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTexture0Texture1Skin
var VertexPositionNormalColorTexture0Texture1Skin=(function(){
	function VertexPositionNormalColorTexture0Texture1Skin(position,normal,color,textureCoordinate0,textureCoordinate1,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorTexture0Texture1Skin,'laya.d3.graphics.VertexPositionNormalColorTexture0Texture1Skin');
	var __proto=VertexPositionNormalColorTexture0Texture1Skin.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1Skin._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(1,VertexPositionNormalColorTexture0Texture1Skin,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1Skin._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTexture0Texture1Skin,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(88,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15),
		new VertexElement(56,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(72,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6)]);}
	]);
	return VertexPositionNormalColorTexture0Texture1Skin;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTexture0Texture1SkinSTangent
var VertexPositionNormalColorTexture0Texture1SkinSTangent=(function(){
	function VertexPositionNormalColorTexture0Texture1SkinSTangent(position,normal,color,textureCoordinate0,textureCoordinate1,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorTexture0Texture1SkinSTangent,'laya.d3.graphics.VertexPositionNormalColorTexture0Texture1SkinSTangent');
	var __proto=VertexPositionNormalColorTexture0Texture1SkinSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1SkinSTangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(1,VertexPositionNormalColorTexture0Texture1SkinSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1SkinSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTexture0Texture1SkinSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(104,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15),
		new VertexElement(56,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(72,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6),
		new VertexElement(88,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalColorTexture0Texture1SkinSTangent;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTexture0Texture1SkinTangent
var VertexPositionNormalColorTexture0Texture1SkinTangent=(function(){
	function VertexPositionNormalColorTexture0Texture1SkinTangent(){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
	}

	__class(VertexPositionNormalColorTexture0Texture1SkinTangent,'laya.d3.graphics.VertexPositionNormalColorTexture0Texture1SkinTangent');
	var __proto=VertexPositionNormalColorTexture0Texture1SkinTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__proto.VertexPositionNormalColorTexture0SkinTangent=function(position,normal,color,textureCoordinate0,textureCoordinate1,tangent,blendIndex,blendWeight){
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1SkinTangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(1,VertexPositionNormalColorTexture0Texture1SkinTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1SkinTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTexture0Texture1SkinTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(100,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15),
		new VertexElement(56,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(72,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6),
		new VertexElement(88,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalColorTexture0Texture1SkinTangent;
})()


/**
*<code>VertexPositionNormalColorTextureTangent</code> 类用于创建位置、法线、颜色、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTexture0Texture1STangent
var VertexPositionNormalColorTexture0Texture1STangent=(function(){
	function VertexPositionNormalColorTexture0Texture1STangent(position,normal,color,textureCoordinate0,textureCoordinate1,tangent){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalColorTexture0Texture1STangent,'laya.d3.graphics.VertexPositionNormalColorTexture0Texture1STangent');
	var __proto=VertexPositionNormalColorTexture0Texture1STangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1STangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(1,VertexPositionNormalColorTexture0Texture1STangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1STangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTexture0Texture1STangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(72,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15),
		new VertexElement(56,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalColorTexture0Texture1STangent;
})()


/**
*<code>VertexPositionNormalColorTextureTangent</code> 类用于创建位置、法线、颜色、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTexture0Texture1Tangent
var VertexPositionNormalColorTexture0Texture1Tangent=(function(){
	function VertexPositionNormalColorTexture0Texture1Tangent(){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._tangent=null;
	}

	__class(VertexPositionNormalColorTexture0Texture1Tangent,'laya.d3.graphics.VertexPositionNormalColorTexture0Texture1Tangent');
	var __proto=VertexPositionNormalColorTexture0Texture1Tangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__proto.VertexPositionNormalColorTexture0Tangent=function(position,normal,color,textureCoordinate0,textureCoordinate1,tangent){
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
	}

	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1Tangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(1,VertexPositionNormalColorTexture0Texture1Tangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1Tangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTexture0Texture1Tangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(68,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15),
		new VertexElement(56,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalColorTexture0Texture1Tangent;
})()


/**
*<code>VertexPositionNormalColorTextureSkin</code> 类用于创建位置、法线、颜色、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTextureSkin
var VertexPositionNormalColorTextureSkin=(function(){
	function VertexPositionNormalColorTextureSkin(position,normal,color,textureCoordinate,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate=textureCoordinate;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorTextureSkin,'laya.d3.graphics.VertexPositionNormalColorTextureSkin');
	var __proto=VertexPositionNormalColorTextureSkin.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSkin._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorTextureSkin,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSkin._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTextureSkin,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(80,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(64,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6)]);}
	]);
	return VertexPositionNormalColorTextureSkin;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTextureSkinSTangent
var VertexPositionNormalColorTextureSkinSTangent=(function(){
	function VertexPositionNormalColorTextureSkinSTangent(position,normal,color,textureCoordinate,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorTextureSkinSTangent,'laya.d3.graphics.VertexPositionNormalColorTextureSkinSTangent');
	var __proto=VertexPositionNormalColorTextureSkinSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSkinSTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorTextureSkinSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSkinSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTextureSkinSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(96,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(64,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6),
		new VertexElement(80,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalColorTextureSkinSTangent;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTextureSkinTangent
var VertexPositionNormalColorTextureSkinTangent=(function(){
	function VertexPositionNormalColorTextureSkinTangent(position,normal,color,textureCoordinate,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorTextureSkinTangent,'laya.d3.graphics.VertexPositionNormalColorTextureSkinTangent');
	var __proto=VertexPositionNormalColorTextureSkinTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSkinTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorTextureSkinTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSkinTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTextureSkinTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(92,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(64,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6),
		new VertexElement(80,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalColorTextureSkinTangent;
})()


/**
*<code>VertexPositionNormalColorTextureTangent</code> 类用于创建位置、法线、颜色、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTextureSTangent
var VertexPositionNormalColorTextureSTangent=(function(){
	function VertexPositionNormalColorTextureSTangent(position,normal,color,textureCoordinate,tangent){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalColorTextureSTangent,'laya.d3.graphics.VertexPositionNormalColorTextureSTangent');
	var __proto=VertexPositionNormalColorTextureSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorTextureSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTextureSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(64,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalColorTextureSTangent;
})()


/**
*<code>VertexPositionNormalColorTextureTangent</code> 类用于创建位置、法线、颜色、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTextureTangent
var VertexPositionNormalColorTextureTangent=(function(){
	function VertexPositionNormalColorTextureTangent(position,normal,color,textureCoordinate,tangent){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalColorTextureTangent,'laya.d3.graphics.VertexPositionNormalColorTextureTangent');
	var __proto=VertexPositionNormalColorTextureTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorTextureTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTextureTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(60,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalColorTextureTangent;
})()


//class laya.d3.graphics.VertexPositionNormalSTangent
var VertexPositionNormalSTangent=(function(){
	function VertexPositionNormalSTangent(position,normal,tangent){
		this._position=null;
		this._normal=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalSTangent,'laya.d3.graphics.VertexPositionNormalSTangent');
	var __proto=VertexPositionNormalSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalSTangent._vertexDeclaration;
	});

	/*INTERFACE laya.d3.graphics.IVertex */
	__getset(1,VertexPositionNormalSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(40,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalSTangent;
})()


//class laya.d3.graphics.VertexPositionNormalTangent
var VertexPositionNormalTangent=(function(){
	function VertexPositionNormalTangent(position,normal,tangent){
		this._position=null;
		this._normal=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalTangent,'laya.d3.graphics.VertexPositionNormalTangent');
	var __proto=VertexPositionNormalTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTangent._vertexDeclaration;
	});

	/*INTERFACE laya.d3.graphics.IVertex */
	__getset(1,VertexPositionNormalTangent,'vertexDeclaration',function(){
		return VertexPositionNormalTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(36,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalTangent;
})()


/**
*<code>VertexPositionNormalTexture</code> 类用于创建位置、法线、纹理顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTexture
var VertexPositionNormalTexture=(function(){
	function VertexPositionNormalTexture(position,normal,textureCoordinate){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
	}

	__class(VertexPositionNormalTexture,'laya.d3.graphics.VertexPositionNormalTexture');
	var __proto=VertexPositionNormalTexture.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTexture._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalTexture,'vertexDeclaration',function(){
		return VertexPositionNormalTexture._vertexDeclaration;
	});

	__static(VertexPositionNormalTexture,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(32,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2)]);}
	]);
	return VertexPositionNormalTexture;
})()


/**
*<code>VertexPositionNormalTexture</code> 类用于创建位置、法线、纹理顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTexture0Texture1
var VertexPositionNormalTexture0Texture1=(function(){
	function VertexPositionNormalTexture0Texture1(position,normal,textureCoordinate0,textureCoordinate1){
		this._position=null;
		this._normal=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
	}

	__class(VertexPositionNormalTexture0Texture1,'laya.d3.graphics.VertexPositionNormalTexture0Texture1');
	var __proto=VertexPositionNormalTexture0Texture1.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(1,VertexPositionNormalTexture0Texture1,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1._vertexDeclaration;
	});

	__static(VertexPositionNormalTexture0Texture1,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(40,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15)]);}
	]);
	return VertexPositionNormalTexture0Texture1;
})()


/**
*<code>VertexPositionNormalColorTextureSkin</code> 类用于创建位置、法线、颜色、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTexture0Texture1Skin
var VertexPositionNormalTexture0Texture1Skin=(function(){
	function VertexPositionNormalTexture0Texture1Skin(position,normal,textureCoordinate0,textureCoordinate1,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalTexture0Texture1Skin,'laya.d3.graphics.VertexPositionNormalTexture0Texture1Skin');
	var __proto=VertexPositionNormalTexture0Texture1Skin.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1Skin._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(1,VertexPositionNormalTexture0Texture1Skin,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1Skin._vertexDeclaration;
	});

	__static(VertexPositionNormalTexture0Texture1Skin,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(72,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(56,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6)]);}
	]);
	return VertexPositionNormalTexture0Texture1Skin;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTexture0Texture1SkinSTangent
var VertexPositionNormalTexture0Texture1SkinSTangent=(function(){
	function VertexPositionNormalTexture0Texture1SkinSTangent(position,normal,textureCoordinate0,textureCoordinate1,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalTexture0Texture1SkinSTangent,'laya.d3.graphics.VertexPositionNormalTexture0Texture1SkinSTangent');
	var __proto=VertexPositionNormalTexture0Texture1SkinSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1SkinSTangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(1,VertexPositionNormalTexture0Texture1SkinSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1SkinSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTexture0Texture1SkinSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(88,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(56,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6),
		new VertexElement(72,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalTexture0Texture1SkinSTangent;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTexture0Texture1SkinTangent
var VertexPositionNormalTexture0Texture1SkinTangent=(function(){
	function VertexPositionNormalTexture0Texture1SkinTangent(){
		this._position=null;
		this._normal=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
	}

	__class(VertexPositionNormalTexture0Texture1SkinTangent,'laya.d3.graphics.VertexPositionNormalTexture0Texture1SkinTangent');
	var __proto=VertexPositionNormalTexture0Texture1SkinTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__proto.VertexPositionNormalTexture0SkinTangent=function(position,normal,textureCoordinate0,textureCoordinate1,tangent,blendIndex,blendWeight){
		this._position=position;
		this._normal=normal;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1SkinTangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(1,VertexPositionNormalTexture0Texture1SkinTangent,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1SkinTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTexture0Texture1SkinTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(84,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(56,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6),
		new VertexElement(72,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalTexture0Texture1SkinTangent;
})()


/**
*<code>VertexPositionNormalTextureTangent</code> 类用于创建位置、法线、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTexture0Texture1STangent
var VertexPositionNormalTexture0Texture1STangent=(function(){
	function VertexPositionNormalTexture0Texture1STangent(position,normal,textureCoordinate0,textureCoordinate1,tangent){
		this._position=null;
		this._normal=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalTexture0Texture1STangent,'laya.d3.graphics.VertexPositionNormalTexture0Texture1STangent');
	var __proto=VertexPositionNormalTexture0Texture1STangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1STangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(1,VertexPositionNormalTexture0Texture1STangent,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1STangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTexture0Texture1STangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(56,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalTexture0Texture1STangent;
})()


/**
*<code>VertexPositionNormalTextureTangent</code> 类用于创建位置、法线、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTexture0Texture1Tangent
var VertexPositionNormalTexture0Texture1Tangent=(function(){
	function VertexPositionNormalTexture0Texture1Tangent(){
		this._position=null;
		this._normal=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._tangent=null;
	}

	__class(VertexPositionNormalTexture0Texture1Tangent,'laya.d3.graphics.VertexPositionNormalTexture0Texture1Tangent');
	var __proto=VertexPositionNormalTexture0Texture1Tangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__proto.VertexPositionNormalTexture0Tangent=function(position,normal,textureCoordinate0,textureCoordinate1,tangent){
		this._position=position;
		this._normal=normal;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
	}

	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1Tangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(1,VertexPositionNormalTexture0Texture1Tangent,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1Tangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTexture0Texture1Tangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(52,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15),
		new VertexElement(40,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalTexture0Texture1Tangent;
})()


/**
*<code>VertexPositionNormalColorTextureSkin</code> 类用于创建位置、法线、颜色、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTextureSkin
var VertexPositionNormalTextureSkin=(function(){
	function VertexPositionNormalTextureSkin(position,normal,textureCoordinate,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalTextureSkin,'laya.d3.graphics.VertexPositionNormalTextureSkin');
	var __proto=VertexPositionNormalTextureSkin.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSkin._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalTextureSkin,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSkin._vertexDeclaration;
	});

	__static(VertexPositionNormalTextureSkin,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(64,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6)]);}
	]);
	return VertexPositionNormalTextureSkin;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTextureSkinSTangent
var VertexPositionNormalTextureSkinSTangent=(function(){
	function VertexPositionNormalTextureSkinSTangent(position,normal,textureCoordinate,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalTextureSkinSTangent,'laya.d3.graphics.VertexPositionNormalTextureSkinSTangent');
	var __proto=VertexPositionNormalTextureSkinSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSkinSTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalTextureSkinSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSkinSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTextureSkinSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(80,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6),
		new VertexElement(64,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalTextureSkinSTangent;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTextureSkinTangent
var VertexPositionNormalTextureSkinTangent=(function(){
	function VertexPositionNormalTextureSkinTangent(position,normal,textureCoordinate,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalTextureSkinTangent,'laya.d3.graphics.VertexPositionNormalTextureSkinTangent');
	var __proto=VertexPositionNormalTextureSkinTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSkinTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalTextureSkinTangent,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSkinTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTextureSkinTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(76,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6),
		new VertexElement(64,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalTextureSkinTangent;
})()


/**
*<code>VertexPositionNormalTextureTangent</code> 类用于创建位置、法线、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTextureSTangent
var VertexPositionNormalTextureSTangent=(function(){
	function VertexPositionNormalTextureSTangent(position,normal,textureCoordinate,tangent){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalTextureSTangent,'laya.d3.graphics.VertexPositionNormalTextureSTangent');
	var __proto=VertexPositionNormalTextureSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalTextureSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTextureSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(48,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalTextureSTangent;
})()


/**
*<code>VertexPositionNormalTextureTangent</code> 类用于创建位置、法线、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTextureTangent
var VertexPositionNormalTextureTangent=(function(){
	function VertexPositionNormalTextureTangent(position,normal,textureCoordinate,tangent){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalTextureTangent,'laya.d3.graphics.VertexPositionNormalTextureTangent');
	var __proto=VertexPositionNormalTextureTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTextureTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalTextureTangent,'vertexDeclaration',function(){
		return VertexPositionNormalTextureTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTextureTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(44,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5)]);}
	]);
	return VertexPositionNormalTextureTangent;
})()


/**
*<code>VertexPositionNormalTexture</code> 类用于创建位置、法线、纹理顶点结构。
*/
//class laya.d3.graphics.VertexPositionNTBTexture
var VertexPositionNTBTexture=(function(){
	function VertexPositionNTBTexture(position,normal,textureCoordinate){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
	}

	__class(VertexPositionNTBTexture,'laya.d3.graphics.VertexPositionNTBTexture');
	var __proto=VertexPositionNTBTexture.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNTBTexture._vertexDeclaration;
	});

	__getset(1,VertexPositionNTBTexture,'vertexDeclaration',function(){
		return VertexPositionNTBTexture._vertexDeclaration;
	});

	__static(VertexPositionNTBTexture,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(56,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5),
		new VertexElement(36,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.BINORMAL0*/4),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2)]);}
	]);
	return VertexPositionNTBTexture;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNTBTexture0Texture1Skin
var VertexPositionNTBTexture0Texture1Skin=(function(){
	function VertexPositionNTBTexture0Texture1Skin(position,normal,binormal,textureCoordinate0,textureCoordinate1,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this.binormal=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
		binormal=binormal;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNTBTexture0Texture1Skin,'laya.d3.graphics.VertexPositionNTBTexture0Texture1Skin');
	var __proto=VertexPositionNTBTexture0Texture1Skin.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNTBTexture0Texture1Skin._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(1,VertexPositionNTBTexture0Texture1Skin,'vertexDeclaration',function(){
		return VertexPositionNTBTexture0Texture1Skin._vertexDeclaration;
	});

	__static(VertexPositionNTBTexture0Texture1Skin,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(96,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5),
		new VertexElement(36,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.BINORMAL0*/4),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(56,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15),
		new VertexElement(64,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(80,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6)]);}
	]);
	return VertexPositionNTBTexture0Texture1Skin;
})()


/**
*<code>VertexPositionNormalTexture</code> 类用于创建位置、法线、纹理顶点结构。
*/
//class laya.d3.graphics.VertexPositionNTBTextureSkin
var VertexPositionNTBTextureSkin=(function(){
	function VertexPositionNTBTextureSkin(position,normal,textureCoordinate){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
	}

	__class(VertexPositionNTBTextureSkin,'laya.d3.graphics.VertexPositionNTBTextureSkin');
	var __proto=VertexPositionNTBTextureSkin.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNTBTextureSkin._vertexDeclaration;
	});

	__getset(1,VertexPositionNTBTextureSkin,'vertexDeclaration',function(){
		return VertexPositionNTBTextureSkin._vertexDeclaration;
	});

	__static(VertexPositionNTBTextureSkin,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(88,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5),
		new VertexElement(36,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.BINORMAL0*/4),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(56,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7),
		new VertexElement(72,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6)]);}
	]);
	return VertexPositionNTBTextureSkin;
})()


/**
*<code>VertexPositionTerrain</code> 类用于创建位置、法线、纹理1、纹理2顶点结构。
*/
//class laya.d3.graphics.VertexPositionTerrain
var VertexPositionTerrain=(function(){
	function VertexPositionTerrain(position,normal,textureCoord0,textureCoord1){
		this._position=null;
		this._normal=null;
		this._textureCoord0=null;
		this._textureCoord1=null;
		this._position=position;
		this._normal=normal;
		this._textureCoord0=textureCoord0;
		this._textureCoord1=textureCoord1;
	}

	__class(VertexPositionTerrain,'laya.d3.graphics.VertexPositionTerrain');
	var __proto=VertexPositionTerrain.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoord0',function(){
		return this._textureCoord0;
	});

	__getset(0,__proto,'textureCoord1',function(){
		return this._textureCoord1;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionTerrain._vertexDeclaration;
	});

	__getset(1,VertexPositionTerrain,'vertexDeclaration',function(){
		return VertexPositionTerrain._vertexDeclaration;
	});

	__static(VertexPositionTerrain,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(40,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15)]);}
	]);
	return VertexPositionTerrain;
})()


/**
*<code>VertexPositionNormalTexture</code> 类用于创建位置、纹理顶点结构。
*/
//class laya.d3.graphics.VertexPositionTexture0
var VertexPositionTexture0=(function(){
	function VertexPositionTexture0(position,textureCoordinate0){
		this._position=null;
		this._textureCoordinate0=null;
		this._position=position;
		this._textureCoordinate0=textureCoordinate0;
	}

	__class(VertexPositionTexture0,'laya.d3.graphics.VertexPositionTexture0');
	var __proto=VertexPositionTexture0.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionTexture0._vertexDeclaration;
	});

	__getset(1,VertexPositionTexture0,'vertexDeclaration',function(){
		return VertexPositionTexture0._vertexDeclaration;
	});

	__static(VertexPositionTexture0,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(20,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2)]);}
	]);
	return VertexPositionTexture0;
})()


/**
*<code>VertexShurikenParticle</code> 类用于创建粒子顶点结构。
*/
//class laya.d3.graphics.VertexShurikenParticleBillboard
var VertexShurikenParticleBillboard=(function(){
	function VertexShurikenParticleBillboard(cornerTextureCoordinate,positionStartLifeTime,velocity,startColor,startSize,startRotation0,startRotation1,startRotation2,ageAddScale,time,startSpeed,randoms0,randoms1,simulationWorldPostion){
		/**@private */
		this._cornerTextureCoordinate=null;
		/**@private */
		this._positionStartLifeTime=null;
		/**@private */
		this._velocity=null;
		/**@private */
		this._startColor=null;
		/**@private */
		this._startSize=null;
		/**@private */
		this._startRotation0=null;
		/**@private */
		this._startRotation1=null;
		/**@private */
		this._startRotation2=null;
		/**@private */
		this._startLifeTime=NaN;
		/**@private */
		this._time=NaN;
		/**@private */
		this._startSpeed=NaN;
		/**@private */
		this._randoms0=null;
		/**@private */
		this._randoms1=null;
		/**@private */
		this._simulationWorldPostion=null;
		this._cornerTextureCoordinate=cornerTextureCoordinate;
		this._positionStartLifeTime=positionStartLifeTime;
		this._velocity=velocity;
		this._startColor=startColor;
		this._startSize=startSize;
		this._startRotation0=startRotation0;
		this._startRotation1=startRotation1;
		this._startRotation2=startRotation2;
		this._startLifeTime=ageAddScale;
		this._time=time;
		this._startSpeed=startSpeed;
		this._randoms0=this.random0;
		this._randoms1=this.random1;
		this._simulationWorldPostion=simulationWorldPostion;
	}

	__class(VertexShurikenParticleBillboard,'laya.d3.graphics.VertexShurikenParticleBillboard');
	var __proto=VertexShurikenParticleBillboard.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'cornerTextureCoordinate',function(){
		return this._cornerTextureCoordinate;
	});

	__getset(0,__proto,'random1',function(){
		return this._randoms1;
	});

	__getset(0,__proto,'startRotation2',function(){
		return this._startRotation2;
	});

	__getset(0,__proto,'positionStartLifeTime',function(){
		return this._positionStartLifeTime;
	});

	__getset(0,__proto,'velocity',function(){
		return this._velocity;
	});

	__getset(0,__proto,'random0',function(){
		return this._randoms0;
	});

	__getset(0,__proto,'startSize',function(){
		return this._startSize;
	});

	__getset(0,__proto,'startColor',function(){
		return this._startColor;
	});

	__getset(0,__proto,'startRotation0',function(){
		return this._startRotation0;
	});

	__getset(0,__proto,'startRotation1',function(){
		return this._startRotation1;
	});

	__getset(0,__proto,'startLifeTime',function(){
		return this._startLifeTime;
	});

	__getset(0,__proto,'time',function(){
		return this._time;
	});

	__getset(0,__proto,'startSpeed',function(){
		return this._startSpeed;
	});

	__getset(0,__proto,'simulationWorldPostion',function(){
		return this._simulationWorldPostion;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexShurikenParticleBillboard._vertexDeclaration;
	});

	__getset(1,VertexShurikenParticleBillboard,'vertexDeclaration',function(){
		return VertexShurikenParticleBillboard._vertexDeclaration;
	});

	__static(VertexShurikenParticleBillboard,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(152,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.CORNERTEXTURECOORDINATE0*/17),
		new VertexElement(16,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.SHAPEPOSITIONSTARTLIFETIME*/30),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.DIRECTIONTIME*/32),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.STARTCOLOR0*/19),
		new VertexElement(64,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.STARTSIZE*/20),
		new VertexElement(76,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.STARTROTATION*/22),
		new VertexElement(88,/*laya.d3.graphics.VertexElementFormat.Single*/"single",/*laya.d3.graphics.VertexElementUsage.STARTSPEED*/31),
		new VertexElement(92,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.RANDOM0*/34),
		new VertexElement(108,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.RANDOM1*/35),
		new VertexElement(124,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.SIMULATIONWORLDPOSTION*/36),
		new VertexElement(136,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.SIMULATIONWORLDROTATION*/37)]);}
	]);
	return VertexShurikenParticleBillboard;
})()


/**
*<code>VertexShurikenParticle</code> 类用于创建粒子顶点结构。
*/
//class laya.d3.graphics.VertexShurikenParticleMesh
var VertexShurikenParticleMesh=(function(){
	function VertexShurikenParticleMesh(cornerTextureCoordinate,positionStartLifeTime,velocity,startColor,startSize,startRotation0,startRotation1,startRotation2,ageAddScale,time,startSpeed,randoms0,randoms1,simulationWorldPostion){
		/**@private */
		this._cornerTextureCoordinate=null;
		/**@private */
		this._positionStartLifeTime=null;
		/**@private */
		this._velocity=null;
		/**@private */
		this._startColor=null;
		/**@private */
		this._startSize=null;
		/**@private */
		this._startRotation0=null;
		/**@private */
		this._startRotation1=null;
		/**@private */
		this._startRotation2=null;
		/**@private */
		this._startLifeTime=NaN;
		/**@private */
		this._time=NaN;
		/**@private */
		this._startSpeed=NaN;
		/**@private */
		this._randoms0=null;
		/**@private */
		this._randoms1=null;
		/**@private */
		this._simulationWorldPostion=null;
		this._cornerTextureCoordinate=cornerTextureCoordinate;
		this._positionStartLifeTime=positionStartLifeTime;
		this._velocity=velocity;
		this._startColor=startColor;
		this._startSize=startSize;
		this._startRotation0=startRotation0;
		this._startRotation1=startRotation1;
		this._startRotation2=startRotation2;
		this._startLifeTime=ageAddScale;
		this._time=time;
		this._startSpeed=startSpeed;
		this._randoms0=this.random0;
		this._randoms1=this.random1;
		this._simulationWorldPostion=simulationWorldPostion;
	}

	__class(VertexShurikenParticleMesh,'laya.d3.graphics.VertexShurikenParticleMesh');
	var __proto=VertexShurikenParticleMesh.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'cornerTextureCoordinate',function(){
		return this._cornerTextureCoordinate;
	});

	__getset(0,__proto,'velocity',function(){
		return this._velocity;
	});

	__getset(0,__proto,'position',function(){
		return this._positionStartLifeTime;
	});

	__getset(0,__proto,'random0',function(){
		return this._randoms0;
	});

	__getset(0,__proto,'startSize',function(){
		return this._startSize;
	});

	__getset(0,__proto,'startColor',function(){
		return this._startColor;
	});

	__getset(0,__proto,'startRotation0',function(){
		return this._startRotation0;
	});

	__getset(0,__proto,'startRotation1',function(){
		return this._startRotation1;
	});

	__getset(0,__proto,'random1',function(){
		return this._randoms1;
	});

	__getset(0,__proto,'startRotation2',function(){
		return this._startRotation2;
	});

	__getset(0,__proto,'startLifeTime',function(){
		return this._startLifeTime;
	});

	__getset(0,__proto,'time',function(){
		return this._time;
	});

	__getset(0,__proto,'startSpeed',function(){
		return this._startSpeed;
	});

	__getset(0,__proto,'simulationWorldPostion',function(){
		return this._simulationWorldPostion;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexShurikenParticleMesh._vertexDeclaration;
	});

	__getset(1,VertexShurikenParticleMesh,'vertexDeclaration',function(){
		return VertexShurikenParticleMesh._vertexDeclaration;
	});

	__static(VertexShurikenParticleMesh,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(172,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.COLOR0*/1),
		new VertexElement(28,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2),
		new VertexElement(36,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.SHAPEPOSITIONSTARTLIFETIME*/30),
		new VertexElement(52,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.DIRECTIONTIME*/32),
		new VertexElement(68,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.STARTCOLOR0*/19),
		new VertexElement(84,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.STARTSIZE*/20),
		new VertexElement(96,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.STARTROTATION*/22),
		new VertexElement(108,/*laya.d3.graphics.VertexElementFormat.Single*/"single",/*laya.d3.graphics.VertexElementUsage.STARTSPEED*/31),
		new VertexElement(112,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.RANDOM0*/34),
		new VertexElement(128,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.RANDOM1*/35),
		new VertexElement(144,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.SIMULATIONWORLDPOSTION*/36),
		new VertexElement(156,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.VertexElementUsage.SIMULATIONWORLDROTATION*/37)]);}
	]);
	return VertexShurikenParticleMesh;
})()


/**
*@private
*<code>LoadModel</code> 类用于模型加载。
*/
//class laya.d3.loaders.LoadModelV01
var LoadModelV01=(function(){
	function LoadModelV01(readData,version,mesh,materials,subMeshes,materialMap){
		/**@private */
		this._version=null;
		/**@private */
		this._strings=['BLOCK','DATA',"STRINGS"];
		/**@private */
		this._materials=null;
		/**@private */
		this._subMeshes=null;
		/**@private */
		this._materialMap=null;
		/**@private */
		this._readData=null;
		/**@private */
		this._mesh=null;
		/**@private */
		this._BLOCK={count:0};
		/**@private */
		this._DATA={offset:0,size:0};
		/**@private */
		this._STRINGS={offset:0,size:0};
		/**@private */
		this._shaderAttributes=null;
		this._mesh=mesh;
		this._materials=materials;
		this._subMeshes=subMeshes;
		this._materialMap=materialMap;
		this._version=version;
		this._onLoaded(readData);
	}

	__class(LoadModelV01,'laya.d3.loaders.LoadModelV01');
	var __proto=LoadModelV01.prototype;
	/**
	*@private
	*/
	__proto._onLoaded=function(readData){
		this._readData=readData;
		this.READ_BLOCK();
		for (var i=0;i < this._BLOCK.count;i++){
			var index=this._readData.getUint16();
			var blockName=this._strings[index];
			var fn=this["READ_"+blockName];
			if (fn==null)throw new Error("model file err,no this function:"+index+" "+blockName);
			if (!fn.call(this))break ;
		}
		return this._mesh;
	}

	__proto.onError=function(){}
	/**
	*@private
	*/
	__proto._readString=function(){
		return this._strings[this._readData.getUint16()];
	}

	__proto.READ_BLOCK=function(){
		var n=this._readData.getUint16();
		this._BLOCK.count=this._readData.getUint16();
		return true;
	}

	__proto.READ_DATA=function(){
		this._DATA.offset=this._readData.getUint32();
		this._DATA.size=this._readData.getUint32();
		return true;
	}

	__proto.READ_STRINGS=function(){
		this._STRINGS.offset=this._readData.getUint16();
		this._STRINGS.size=this._readData.getUint16();
		var ofs=this._readData.pos;
		this._readData.pos=this._STRINGS.offset+this._DATA.offset;
		for (var i=0;i < this._STRINGS.size;i++){
			this._strings[i]=this._readData.readUTFString();
		}
		this._readData.pos=ofs;
		return true;
	}

	__proto.READ_MATERIAL=function(){
		var i=0,n=0;
		var index=this._readData.getUint16();
		var shaderName=this._readString();
		var url=this._readString();
		if (url!=="null")
			this._materials[index]=Loader.getRes(this._materialMap[url]);
		else
		this._materials[index]=new BaseMaterial();
		return true;
	}

	__proto.READ_MESH=function(){
		var name=this._readString();
		switch (this._version){
			case "LAYAMODEL:01":
				console.log("Warning: The (.lm) file is converted by old fbxTools,please reConverted it use  lastest fbxTools version,later we will remove the  support of old version (.lm) support.");
				break ;
			case "LAYASKINANI:01":
			case "LAYAMODEL:02":;
				var arrayBuffer=this._readData.__getBuffer();
				var i=0,n=0;
				var bindPoseStart=this._readData.getUint32();
				var binPoseLength=this._readData.getUint32();
				var bindPoseDatas=new Float32Array(arrayBuffer.slice(bindPoseStart+this._DATA.offset,bindPoseStart+this._DATA.offset+binPoseLength));
				var inverseGlobalBindPoseStart=this._readData.getUint32();
				var inverseGlobalBinPoseLength=this._readData.getUint32();
				var invGloBindPoseDatas=new Float32Array(arrayBuffer.slice(inverseGlobalBindPoseStart+this._DATA.offset,inverseGlobalBindPoseStart+this._DATA.offset+inverseGlobalBinPoseLength));
				this.mesh._inverseBindPoses=[];
				for (i=0,n=invGloBindPoseDatas.length;i < n;i+=16){
					var inverseGlobalBindPose=new Matrix4x4(invGloBindPoseDatas[i+0],invGloBindPoseDatas[i+1],invGloBindPoseDatas[i+2],invGloBindPoseDatas[i+3],invGloBindPoseDatas[i+4],invGloBindPoseDatas[i+5],invGloBindPoseDatas[i+6],invGloBindPoseDatas[i+7],invGloBindPoseDatas[i+8],invGloBindPoseDatas[i+9],invGloBindPoseDatas[i+10],invGloBindPoseDatas[i+11],invGloBindPoseDatas[i+12],invGloBindPoseDatas[i+13],invGloBindPoseDatas[i+14],invGloBindPoseDatas[i+15]);
					this.mesh._inverseBindPoses.push(inverseGlobalBindPose);
				}
				break ;
			default :
				throw new Error("LoadModel:unknown version.");
			}
		return true;
	}

	__proto.READ_SUBMESH=function(){
		var className=this._readString();
		var material=this._readData.getUint8();
		var bufferAttribute=this._readString();
		this._shaderAttributes=bufferAttribute.match(LoadModelV01._attrReg);
		var ibofs=this._readData.getUint32();
		var ibsize=this._readData.getUint32();
		var vbIndicesofs=this._readData.getUint32();
		var vbIndicessize=this._readData.getUint32();
		var vbofs=this._readData.getUint32();
		var vbsize=this._readData.getUint32();
		var boneDicofs=this._readData.getUint32();
		var boneDicsize=this._readData.getUint32();
		var arrayBuffer=this._readData.__getBuffer();
		var submesh=new SubMesh(this._mesh);
		var vertexDeclaration=this._getVertexDeclaration();
		var vb=VertexBuffer3D.create(vertexDeclaration,vbsize / vertexDeclaration.vertexStride,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
		var vbStart=vbofs+this._DATA.offset;
		var vbArrayBuffer=arrayBuffer.slice(vbStart,vbStart+vbsize);
		vb.setData(new Float32Array(vbArrayBuffer));
		submesh._vertexBuffer=vb;
		var vertexElements=vb.vertexDeclaration.getVertexElements();
		for (var i=0;i < vertexElements.length;i++)
		submesh._bufferUsage[(vertexElements [i]).elementUsage]=vb;
		var ib=IndexBuffer3D.create(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",ibsize / 2,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
		var ibStart=ibofs+this._DATA.offset;
		var ibArrayBuffer=arrayBuffer.slice(ibStart,ibStart+ibsize);
		ib.setData(new Uint16Array(ibArrayBuffer));
		submesh._indexBuffer=ib;
		var boneDicArrayBuffer=arrayBuffer.slice(boneDicofs+this._DATA.offset,boneDicofs+this._DATA.offset+boneDicsize);
		submesh._boneIndicesList[0]=new Uint8Array(boneDicArrayBuffer);
		this._subMeshes.push(submesh);
		return true;
	}

	__proto.READ_DATAAREA=function(){
		return false;
	}

	__proto._getVertexDeclaration=function(){
		var position=false,normal=false,color=false,texcoord0=false,texcoord1=false,tangent=false,blendWeight=false,blendIndex=false;
		var binormal=false;
		for (var i=0;i < this._shaderAttributes.length;i+=8){
			switch (this._shaderAttributes[i]){
				case "POSITION":
					position=true;
					break ;
				case "NORMAL":
					normal=true;
					break ;
				case "COLOR":
					color=true;
					break ;
				case "UV":
					texcoord0=true;
					break ;
				case "UV1":
					texcoord1=true;
					break ;
				case "BLENDWEIGHT":
					blendWeight=true;
					break ;
				case "BLENDINDICES":
					blendIndex=true;
					break ;
				case "TANGENT":
					tangent=true;
					break ;
				case "BINORMAL":
					binormal=true;
					break ;
				}
		};
		var vertexDeclaration;
		if (position && normal && color && texcoord0 && texcoord1 && blendWeight && blendIndex && tangent)
			vertexDeclaration=VertexPositionNormalColorTexture0Texture1SkinTangent.vertexDeclaration;
		else if (position && normal && color && texcoord0 && texcoord1 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalColorTexture0Texture1Skin.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1 && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalTexture0Texture1SkinTangent.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalTexture0Texture1Skin.vertexDeclaration;
		else if (position && normal && color && texcoord0 && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalColorTextureSkinTangent.vertexDeclaration;
		else if (position && normal && color && texcoord0 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalColorTextureSkin.vertexDeclaration;
		else if (position && normal && tangent && binormal && texcoord0 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNTBTextureSkin.vertexDeclaration;
		else if (position && normal && texcoord0 && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalTextureSkinTangent.vertexDeclaration;
		else if (position && normal && texcoord0 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalTextureSkin.vertexDeclaration;
		else if (position && normal && color && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalColorSkinTangent.vertexDeclaration;
		else if (position && normal && color && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalColorSkin.vertexDeclaration;
		else if (position && normal && color && texcoord0 && texcoord1 && tangent)
		vertexDeclaration=VertexPositionNormalColorTexture0Texture1Tangent.vertexDeclaration;
		else if (position && normal && color && texcoord0 && texcoord1)
		vertexDeclaration=VertexPositionNormalColorTexture0Texture1.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1 && tangent)
		vertexDeclaration=VertexPositionNormalTexture0Texture1Tangent.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1)
		vertexDeclaration=VertexPositionNormalTexture0Texture1.vertexDeclaration;
		else if (position && normal && color && texcoord0 && tangent)
		vertexDeclaration=VertexPositionNormalColorTextureTangent.vertexDeclaration;
		else if (position && normal && texcoord0 && tangent && binormal)
		vertexDeclaration=VertexPositionNTBTexture.vertexDeclaration;
		else if (position && normal && color && texcoord0)
		vertexDeclaration=VertexPositionNormalColorTexture.vertexDeclaration;
		else if (position && normal && texcoord0 && tangent)
		vertexDeclaration=VertexPositionNormalTextureTangent.vertexDeclaration;
		else if (position && normal && texcoord0)
		vertexDeclaration=VertexPositionNormalTexture.vertexDeclaration;
		else if (position && normal && color && tangent)
		vertexDeclaration=VertexPositionNormalColorTangent.vertexDeclaration;
		else if (position && normal && color)
		vertexDeclaration=VertexPositionNormalColor.vertexDeclaration;
		return vertexDeclaration;
	}

	__getset(0,__proto,'mesh',function(){
		return this._mesh;
	});

	LoadModelV01._attrReg=new RegExp("(\\w+)|([:,;])","g");
	return LoadModelV01;
})()


/**
*@private
*<code>LoadModel</code> 类用于模型加载。
*/
//class laya.d3.loaders.LoadModelV02
var LoadModelV02=(function(){
	function LoadModelV02(){}
	__class(LoadModelV02,'laya.d3.loaders.LoadModelV02');
	LoadModelV02.parse=function(readData,version,mesh,materials,subMeshes,materialMap){
		LoadModelV02._mesh=mesh;
		LoadModelV02._materials=materials;
		LoadModelV02._subMeshes=subMeshes;
		LoadModelV02._materialMap=materialMap;
		LoadModelV02._version=version;
		LoadModelV02._readData=readData;
		LoadModelV02.READ_DATA();
		LoadModelV02.READ_BLOCK();
		LoadModelV02.READ_STRINGS();
		for (var i=0,n=LoadModelV02._BLOCK.count;i < n;i++){
			LoadModelV02._readData.pos=LoadModelV02._BLOCK.blockStarts[i];
			var index=LoadModelV02._readData.getUint16();
			var blockName=LoadModelV02._strings[index];
			var fn=LoadModelV02["READ_"+blockName];
			if (fn==null)
				throw new Error("model file err,no this function:"+index+" "+blockName);
			else
			fn.call();
		}
		LoadModelV02._strings.length=0;
		LoadModelV02._readData=null;
		LoadModelV02._version=null;
		LoadModelV02._mesh=null;
		LoadModelV02._materials=null;
		LoadModelV02._subMeshes=null;
		LoadModelV02._materialMap=null;
	}

	LoadModelV02._readString=function(){
		return LoadModelV02._strings[LoadModelV02._readData.getUint16()];
	}

	LoadModelV02.READ_DATA=function(){
		LoadModelV02._DATA.offset=LoadModelV02._readData.getUint32();
		LoadModelV02._DATA.size=LoadModelV02._readData.getUint32();
	}

	LoadModelV02.READ_BLOCK=function(){
		var count=LoadModelV02._BLOCK.count=LoadModelV02._readData.getUint16();
		var blockStarts=LoadModelV02._BLOCK.blockStarts=[];
		var blockLengths=LoadModelV02._BLOCK.blockLengths=[];
		for (var i=0;i < count;i++){
			blockStarts.push(LoadModelV02._readData.getUint32());
			blockLengths.push(LoadModelV02._readData.getUint32());
		}
	}

	LoadModelV02.READ_STRINGS=function(){
		var offset=LoadModelV02._readData.getUint32();
		var count=LoadModelV02._readData.getUint16();
		var prePos=LoadModelV02._readData.pos;
		LoadModelV02._readData.pos=offset+LoadModelV02._DATA.offset;
		for (var i=0;i < count;i++)
		LoadModelV02._strings[i]=LoadModelV02._readData.readUTFString();
		LoadModelV02._readData.pos=prePos;
	}

	LoadModelV02.READ_MATERIAL=function(){
		var i=0,n=0;
		var clasName=LoadModelV02._readString();
		var shaderName=LoadModelV02._readString();
		var url=LoadModelV02._readString();
		if (url!=="")
			LoadModelV02._materials.push(Loader.getRes(LoadModelV02._materialMap[url]));
		return true;
	}

	LoadModelV02.READ_MESH=function(){
		var name=LoadModelV02._readString();
		var arrayBuffer=LoadModelV02._readData.__getBuffer();
		var i=0,n=0;
		var vertexBufferCount=LoadModelV02._readData.getInt16();
		var offset=LoadModelV02._DATA.offset;
		for (i=0;i < vertexBufferCount;i++){
			var vbStart=offset+LoadModelV02._readData.getUint32();
			var vbLength=LoadModelV02._readData.getUint32();
			var vbDatas=new Float32Array(arrayBuffer.slice(vbStart,vbStart+vbLength));
			var bufferAttribute=LoadModelV02._readString();
			var shaderAttributes=bufferAttribute.match(LoadModelV02._attrReg);
			var vertexDeclaration=LoadModelV02._getVertexDeclaration(shaderAttributes);
			var vertexBuffer=VertexBuffer3D.create(vertexDeclaration,(vbDatas.length *4)/ vertexDeclaration.vertexStride,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
			vertexBuffer.setData(vbDatas);
			LoadModelV02._mesh._vertexBuffers.push(vertexBuffer);
		};
		var ibStart=offset+LoadModelV02._readData.getUint32();
		var ibLength=LoadModelV02._readData.getUint32();
		var ibDatas=new Uint16Array(arrayBuffer.slice(ibStart,ibStart+ibLength));
		var indexBuffer=IndexBuffer3D.create(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",ibLength / 2,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
		indexBuffer.setData(ibDatas);
		LoadModelV02._mesh._indexBuffer=indexBuffer;
		var boneNames=LoadModelV02._mesh._boneNames=[];
		var boneCount=LoadModelV02._readData.getUint16();
		boneNames.length=boneCount;
		for (i=0;i < boneCount;i++)
		boneNames[i]=LoadModelV02._strings[LoadModelV02._readData.getUint16()];
		var bindPoseStart=LoadModelV02._readData.getUint32();
		var binPoseLength=LoadModelV02._readData.getUint32();
		var bindPoseDatas=new Float32Array(arrayBuffer.slice(offset+bindPoseStart,offset+bindPoseStart+binPoseLength));
		var inverseGlobalBindPoseStart=LoadModelV02._readData.getUint32();
		var inverseGlobalBinPoseLength=LoadModelV02._readData.getUint32();
		var invGloBindPoseDatas=new Float32Array(arrayBuffer.slice(offset+inverseGlobalBindPoseStart,offset+inverseGlobalBindPoseStart+inverseGlobalBinPoseLength));
		LoadModelV02._mesh._inverseBindPoses=[];
		for (i=0,n=invGloBindPoseDatas.length;i < n;i+=16){
			var inverseGlobalBindPose=new Matrix4x4(invGloBindPoseDatas[i+0],invGloBindPoseDatas[i+1],invGloBindPoseDatas[i+2],invGloBindPoseDatas[i+3],invGloBindPoseDatas[i+4],invGloBindPoseDatas[i+5],invGloBindPoseDatas[i+6],invGloBindPoseDatas[i+7],invGloBindPoseDatas[i+8],invGloBindPoseDatas[i+9],invGloBindPoseDatas[i+10],invGloBindPoseDatas[i+11],invGloBindPoseDatas[i+12],invGloBindPoseDatas[i+13],invGloBindPoseDatas[i+14],invGloBindPoseDatas[i+15]);
			LoadModelV02._mesh._inverseBindPoses.push(inverseGlobalBindPose);
		}
		LoadModelV02._mesh._skinnedDatas=new Float32Array(invGloBindPoseDatas.length*16);
		return true;
	}

	LoadModelV02.READ_SUBMESH=function(){
		var arrayBuffer=LoadModelV02._readData.__getBuffer();
		var submesh=new SubMesh(LoadModelV02._mesh);
		var vbIndex=LoadModelV02._readData.getInt16();
		var vbStart=LoadModelV02._readData.getUint32();
		var vbLength=LoadModelV02._readData.getUint32();
		submesh._vertexBuffer=LoadModelV02._mesh._vertexBuffers[vbIndex];
		submesh._vertexStart=vbStart;
		submesh._vertexCount=vbLength;
		var ibStart=LoadModelV02._readData.getUint32();
		var ibCount=LoadModelV02._readData.getUint32();
		var indexBuffer=LoadModelV02._mesh._indexBuffer;
		submesh._indexBuffer=indexBuffer;
		submesh._indexStart=ibStart;
		submesh._indexCount=ibCount;
		submesh._indices=new Uint16Array(indexBuffer.getData().buffer,ibStart *2,ibCount);
		var offset=LoadModelV02._DATA.offset;
		var subIndexBufferStart=submesh._subIndexBufferStart;
		var subIndexBufferCount=submesh._subIndexBufferCount;
		var boneIndicesList=submesh._boneIndicesList;
		var drawCount=LoadModelV02._readData.getUint16();
		subIndexBufferStart.length=drawCount;
		subIndexBufferCount.length=drawCount;
		boneIndicesList.length=drawCount;
		for (var i=0;i < drawCount;i++){
			subIndexBufferStart[i]=LoadModelV02._readData.getUint32();
			subIndexBufferCount[i]=LoadModelV02._readData.getUint32();
			var boneDicofs=LoadModelV02._readData.getUint32();
			var boneDicsize=LoadModelV02._readData.getUint32();
			submesh._boneIndicesList[i]=new Uint8Array(arrayBuffer.slice(offset+boneDicofs,offset+boneDicofs+boneDicsize));
		}
		LoadModelV02._subMeshes.push(submesh);
		return true;
	}

	LoadModelV02._getVertexDeclaration=function(shaderAttributes){
		var position=false,normal=false,color=false,texcoord0=false,texcoord1=false,tangent=false,blendWeight=false,blendIndex=false;
		var binormal=false;
		for (var i=0;i < shaderAttributes.length;i++){
			switch (shaderAttributes[i]){
				case "POSITION":
					position=true;
					break ;
				case "NORMAL":
					normal=true;
					break ;
				case "COLOR":
					color=true;
					break ;
				case "UV":
					texcoord0=true;
					break ;
				case "UV1":
					texcoord1=true;
					break ;
				case "BLENDWEIGHT":
					blendWeight=true;
					break ;
				case "BLENDINDICES":
					blendIndex=true;
					break ;
				case "TANGENT":
					tangent=true;
					break ;
				case "BINORMAL":
					binormal=true;
					break ;
				}
		};
		var vertexDeclaration;
		if (position && normal && color && texcoord0 && texcoord1 && blendWeight && blendIndex && tangent)
			vertexDeclaration=VertexPositionNormalColorTexture0Texture1SkinTangent.vertexDeclaration;
		else if (position && normal && color && texcoord0 && texcoord1 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalColorTexture0Texture1Skin.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1 && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalTexture0Texture1SkinTangent.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalTexture0Texture1Skin.vertexDeclaration;
		else if (position && normal && color && texcoord0 && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalColorTextureSkinTangent.vertexDeclaration;
		else if (position && normal && color && texcoord0 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalColorTextureSkin.vertexDeclaration;
		else if (position && normal && texcoord0 && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalTextureSkinTangent.vertexDeclaration;
		else if (position && normal && texcoord0 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalTextureSkin.vertexDeclaration;
		else if (position && normal && color && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalColorSkinTangent.vertexDeclaration;
		else if (position && normal && color && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalColorSkin.vertexDeclaration;
		else if (position && normal && color && texcoord0 && texcoord1 && tangent)
		vertexDeclaration=VertexPositionNormalColorTexture0Texture1Tangent.vertexDeclaration;
		else if (position && normal && color && texcoord0 && texcoord1)
		vertexDeclaration=VertexPositionNormalColorTexture0Texture1.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1 && tangent)
		vertexDeclaration=VertexPositionNormalTexture0Texture1Tangent.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1)
		vertexDeclaration=VertexPositionNormalTexture0Texture1.vertexDeclaration;
		else if (position && normal && color && texcoord0 && tangent)
		vertexDeclaration=VertexPositionNormalColorTextureTangent.vertexDeclaration;
		else if (position && normal && texcoord0 && tangent && binormal)
		vertexDeclaration=VertexPositionNTBTexture.vertexDeclaration;
		else if (position && normal && color && texcoord0)
		vertexDeclaration=VertexPositionNormalColorTexture.vertexDeclaration;
		else if (position && normal && texcoord0 && tangent)
		vertexDeclaration=VertexPositionNormalTextureTangent.vertexDeclaration;
		else if (position && normal && texcoord0)
		vertexDeclaration=VertexPositionNormalTexture.vertexDeclaration;
		else if (position && normal && color && tangent)
		vertexDeclaration=VertexPositionNormalColorTangent.vertexDeclaration;
		else if (position && normal && color)
		vertexDeclaration=VertexPositionNormalColor.vertexDeclaration;
		return vertexDeclaration;
	}

	LoadModelV02._attrReg=new RegExp("(\\w+)|([:,;])","g");
	LoadModelV02._strings=[];
	LoadModelV02._readData=null;
	LoadModelV02._version=null;
	LoadModelV02._mesh=null;
	LoadModelV02._materials=null;
	LoadModelV02._subMeshes=null;
	LoadModelV02._materialMap=null;
	__static(LoadModelV02,
	['_BLOCK',function(){return this._BLOCK={count:0};},'_DATA',function(){return this._DATA={offset:0,size:0};}
	]);
	return LoadModelV02;
})()


/**
*@private
*<code>LoadModel</code> 类用于模型加载。
*/
//class laya.d3.loaders.LoadModelV03
var LoadModelV03=(function(){
	function LoadModelV03(){}
	__class(LoadModelV03,'laya.d3.loaders.LoadModelV03');
	LoadModelV03.parse=function(readData,version,mesh,subMeshes,materialMap){
		LoadModelV03._mesh=mesh;
		LoadModelV03._subMeshes=subMeshes;
		LoadModelV03._materialMap=materialMap;
		LoadModelV03._version=version;
		LoadModelV03._readData=readData;
		LoadModelV03.READ_DATA();
		LoadModelV03.READ_BLOCK();
		LoadModelV03.READ_STRINGS();
		for (var i=0,n=LoadModelV03._BLOCK.count;i < n;i++){
			LoadModelV03._readData.pos=LoadModelV03._BLOCK.blockStarts[i];
			var index=LoadModelV03._readData.getUint16();
			var blockName=LoadModelV03._strings[index];
			var fn=LoadModelV03["READ_"+blockName];
			if (fn==null)
				throw new Error("model file err,no this function:"+index+" "+blockName);
			else
			fn.call();
		}
		LoadModelV03._strings.length=0;
		LoadModelV03._readData=null;
		LoadModelV03._version=null;
		LoadModelV03._mesh=null;
		LoadModelV03._subMeshes=null;
		LoadModelV03._materialMap=null;
	}

	LoadModelV03._readString=function(){
		return LoadModelV03._strings[LoadModelV03._readData.getUint16()];
	}

	LoadModelV03.READ_DATA=function(){
		LoadModelV03._DATA.offset=LoadModelV03._readData.getUint32();
		LoadModelV03._DATA.size=LoadModelV03._readData.getUint32();
	}

	LoadModelV03.READ_BLOCK=function(){
		var count=LoadModelV03._BLOCK.count=LoadModelV03._readData.getUint16();
		var blockStarts=LoadModelV03._BLOCK.blockStarts=[];
		var blockLengths=LoadModelV03._BLOCK.blockLengths=[];
		for (var i=0;i < count;i++){
			blockStarts.push(LoadModelV03._readData.getUint32());
			blockLengths.push(LoadModelV03._readData.getUint32());
		}
	}

	LoadModelV03.READ_STRINGS=function(){
		var offset=LoadModelV03._readData.getUint32();
		var count=LoadModelV03._readData.getUint16();
		var prePos=LoadModelV03._readData.pos;
		LoadModelV03._readData.pos=offset+LoadModelV03._DATA.offset;
		for (var i=0;i < count;i++)
		LoadModelV03._strings[i]=LoadModelV03._readData.readUTFString();
		LoadModelV03._readData.pos=prePos;
	}

	LoadModelV03.READ_MESH=function(){
		var name=LoadModelV03._readString();
		var arrayBuffer=LoadModelV03._readData.__getBuffer();
		var i=0,n=0;
		var vertexBufferCount=LoadModelV03._readData.getInt16();
		var offset=LoadModelV03._DATA.offset;
		for (i=0;i < vertexBufferCount;i++){
			var vbStart=offset+LoadModelV03._readData.getUint32();
			var vbLength=LoadModelV03._readData.getUint32();
			var vbDatas=new Float32Array(arrayBuffer.slice(vbStart,vbStart+vbLength));
			var bufferAttribute=LoadModelV03._readString();
			var vertexDeclaration;
			switch(LoadModelV03._version){
				case "LAYAMODEL:03":
					vertexDeclaration=LoadModelV03._vertexDeclarationMap_Discard[bufferAttribute];
					break ;
				case "LAYAMODEL:0301":
					vertexDeclaration=LoadModelV03._vertexDeclarationMap[bufferAttribute];
					break ;
				default :
					throw new Error("LoadModelV03: unknown version.");
				}
			if (!vertexDeclaration)
				throw new Error("LoadModelV03: unknown vertexDeclaration.");
			var vertexBuffer=VertexBuffer3D.create(vertexDeclaration,(vbDatas.length *4)/ vertexDeclaration.vertexStride,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
			vertexBuffer.setData(vbDatas);
			LoadModelV03._mesh._vertexBuffers.push(vertexBuffer);
		};
		var ibStart=offset+LoadModelV03._readData.getUint32();
		var ibLength=LoadModelV03._readData.getUint32();
		var ibDatas=new Uint16Array(arrayBuffer.slice(ibStart,ibStart+ibLength));
		var indexBuffer=IndexBuffer3D.create(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",ibLength / 2,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
		indexBuffer.setData(ibDatas);
		LoadModelV03._mesh._indexBuffer=indexBuffer;
		var boneNames=LoadModelV03._mesh._boneNames=[];
		var boneCount=LoadModelV03._readData.getUint16();
		boneNames.length=boneCount;
		for (i=0;i < boneCount;i++)
		boneNames[i]=LoadModelV03._strings[LoadModelV03._readData.getUint16()];
		LoadModelV03._readData.pos+=8;
		var inverseGlobalBindPoseStart=LoadModelV03._readData.getUint32();
		var inverseGlobalBinPoseLength=LoadModelV03._readData.getUint32();
		var invGloBindPoseDatas=new Float32Array(arrayBuffer.slice(offset+inverseGlobalBindPoseStart,offset+inverseGlobalBindPoseStart+inverseGlobalBinPoseLength));
		LoadModelV03._mesh._inverseBindPoses=[];
		for (i=0,n=invGloBindPoseDatas.length;i < n;i+=16){
			var inverseGlobalBindPose=new Matrix4x4(invGloBindPoseDatas[i+0],invGloBindPoseDatas[i+1],invGloBindPoseDatas[i+2],invGloBindPoseDatas[i+3],invGloBindPoseDatas[i+4],invGloBindPoseDatas[i+5],invGloBindPoseDatas[i+6],invGloBindPoseDatas[i+7],invGloBindPoseDatas[i+8],invGloBindPoseDatas[i+9],invGloBindPoseDatas[i+10],invGloBindPoseDatas[i+11],invGloBindPoseDatas[i+12],invGloBindPoseDatas[i+13],invGloBindPoseDatas[i+14],invGloBindPoseDatas[i+15]);
			LoadModelV03._mesh._inverseBindPoses.push(inverseGlobalBindPose);
		}
		LoadModelV03._mesh._skinnedDatas=new Float32Array(invGloBindPoseDatas.length*16);
		return true;
	}

	LoadModelV03.READ_SUBMESH=function(){
		var arrayBuffer=LoadModelV03._readData.__getBuffer();
		var submesh=new SubMesh(LoadModelV03._mesh);
		var vbIndex=LoadModelV03._readData.getInt16();
		var vbStart=LoadModelV03._readData.getUint32();
		var vbLength=LoadModelV03._readData.getUint32();
		submesh._vertexBuffer=LoadModelV03._mesh._vertexBuffers[vbIndex];
		submesh._vertexStart=vbStart;
		submesh._vertexCount=vbLength;
		var ibStart=LoadModelV03._readData.getUint32();
		var ibCount=LoadModelV03._readData.getUint32();
		var indexBuffer=LoadModelV03._mesh._indexBuffer;
		submesh._indexBuffer=indexBuffer;
		submesh._indexStart=ibStart;
		submesh._indexCount=ibCount;
		submesh._indices=new Uint16Array(indexBuffer.getData().buffer,ibStart *2,ibCount);
		var offset=LoadModelV03._DATA.offset;
		var subIndexBufferStart=submesh._subIndexBufferStart;
		var subIndexBufferCount=submesh._subIndexBufferCount;
		var boneIndicesList=submesh._boneIndicesList;
		var drawCount=LoadModelV03._readData.getUint16();
		subIndexBufferStart.length=drawCount;
		subIndexBufferCount.length=drawCount;
		boneIndicesList.length=drawCount;
		for (var i=0;i < drawCount;i++){
			subIndexBufferStart[i]=LoadModelV03._readData.getUint32();
			subIndexBufferCount[i]=LoadModelV03._readData.getUint32();
			var boneDicofs=LoadModelV03._readData.getUint32();
			var boneDicsize=LoadModelV03._readData.getUint32();
			boneIndicesList[i]=new Uint8Array(arrayBuffer.slice(offset+boneDicofs,offset+boneDicofs+boneDicsize));
		}
		LoadModelV03._subMeshes.push(submesh);
		return true;
	}

	LoadModelV03._strings=[];
	LoadModelV03._readData=null;
	LoadModelV03._version=null;
	LoadModelV03._mesh=null;
	LoadModelV03._subMeshes=null;
	LoadModelV03._materialMap=null;
	__static(LoadModelV03,
	['_vertexDeclarationMap_Discard',function(){return this._vertexDeclarationMap_Discard={
			"POSITION,NORMAL,COLOR,UV,UV1,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalColorTexture0Texture1SkinTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,UV1,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalColorTexture0Texture1Skin.vertexDeclaration,
			"POSITION,NORMAL,TANGENT,BINORMAL,UV,UV1,BLENDWEIGHT,BLENDINDICES,":VertexPositionNTBTexture0Texture1Skin.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalTexture0Texture1SkinTangent.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalTexture0Texture1Skin.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalColorTextureSkinTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalColorTextureSkin.vertexDeclaration,
			"POSITION,NORMAL,UV,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalTextureSkinTangent.vertexDeclaration,
			"POSITION,NORMAL,UV,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalTextureSkin.vertexDeclaration,
			"POSITION,NORMAL,COLOR,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalColorSkinTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalColorSkin.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,UV1,TANGENT":VertexPositionNormalColorTexture0Texture1Tangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,UV1":VertexPositionNormalColorTexture0Texture1.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1,TANGENT":VertexPositionNormalTexture0Texture1Tangent.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1":VertexPositionNormalTexture0Texture1.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,TANGENT":VertexPositionNormalColorTextureTangent.vertexDeclaration,
			"POSITION,NORMAL,UV,TANGENT,BINORMAL":VertexPositionNTBTexture.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV":VertexPositionNormalColorTexture.vertexDeclaration,
			"POSITION,NORMAL,UV,TANGENT":VertexPositionNormalTextureTangent.vertexDeclaration,
			"POSITION,NORMAL,UV":VertexPositionNormalTexture.vertexDeclaration,
			"POSITION,NORMAL,COLOR,TANGENT":VertexPositionNormalColorTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR":VertexPositionNormalColor.vertexDeclaration,
			"POSITION,NORMAL,TANGENT":VertexPositionNormalTangent.vertexDeclaration,
			"POSITION,NORMAL":VertexPositionNormal.vertexDeclaration,
			"POSITION,UV":VertexPositionTexture0.vertexDeclaration,
			"POSITION":VertexPosition.vertexDeclaration};},'_vertexDeclarationMap',function(){return this._vertexDeclarationMap={
			"POSITION,NORMAL,COLOR,UV,UV1,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalColorTexture0Texture1SkinSTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,UV1,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalColorTexture0Texture1Skin.vertexDeclaration,
			"POSITION,NORMAL,TANGENT,BINORMAL,UV,UV1,BLENDWEIGHT,BLENDINDICES,":VertexPositionNTBTexture0Texture1Skin.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalTexture0Texture1SkinSTangent.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalTexture0Texture1Skin.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalColorTextureSkinSTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalColorTextureSkin.vertexDeclaration,
			"POSITION,NORMAL,UV,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalTextureSkinSTangent.vertexDeclaration,
			"POSITION,NORMAL,UV,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalTextureSkin.vertexDeclaration,
			"POSITION,NORMAL,COLOR,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalColorSkinSTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalColorSkin.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,UV1,TANGENT":VertexPositionNormalColorTexture0Texture1STangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,UV1":VertexPositionNormalColorTexture0Texture1.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1,TANGENT":VertexPositionNormalTexture0Texture1STangent.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1":VertexPositionNormalTexture0Texture1.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,TANGENT":VertexPositionNormalColorTextureSTangent.vertexDeclaration,
			"POSITION,NORMAL,UV,TANGENT,BINORMAL":VertexPositionNTBTexture.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV":VertexPositionNormalColorTexture.vertexDeclaration,
			"POSITION,NORMAL,UV,TANGENT":VertexPositionNormalTextureSTangent.vertexDeclaration,
			"POSITION,NORMAL,UV":VertexPositionNormalTexture.vertexDeclaration,
			"POSITION,NORMAL,COLOR,TANGENT":VertexPositionNormalColorSTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR":VertexPositionNormalColor.vertexDeclaration,
			"POSITION,NORMAL,TANGENT":VertexPositionNormalSTangent.vertexDeclaration,
			"POSITION,NORMAL":VertexPositionNormal.vertexDeclaration,
			"POSITION,UV":VertexPositionTexture0.vertexDeclaration,
			"POSITION":VertexPosition.vertexDeclaration};},'_BLOCK',function(){return this._BLOCK={count:0};},'_DATA',function(){return this._DATA={offset:0,size:0};}
	]);
	return LoadModelV03;
})()


/**
*...
*@author ...
*/
//class laya.d3.loaders.MeshReader
var MeshReader=(function(){
	function MeshReader(){}
	__class(MeshReader,'laya.d3.loaders.MeshReader');
	MeshReader.read=function(data,mesh,materials,subMeshes,materialMap){
		var readData=new Byte(data);
		readData.pos=0;
		var version=readData.readUTFString();
		switch (version){
			case "LAYAMODEL:01":
			case "LAYASKINANI:01":
				MeshReader._readVersion01(readData,version,mesh,materials,subMeshes,materialMap);
				break ;
			case "LAYAMODEL:02":
				LoadModelV02.parse(readData,version,mesh,materials,subMeshes,materialMap);
				break ;
			case "LAYAMODEL:03":
			case "LAYAMODEL:0301":
				LoadModelV03.parse(readData,version,mesh,subMeshes,materialMap);
				break ;
			default :
				throw new Error("MeshReader: unknown mesh version.");
			}
		mesh._setSubMeshes(subMeshes);
	}

	MeshReader._readVersion01=function(readData,version,mesh,materials,subMeshes,materialMap){
		new LoadModelV01(readData,version,mesh,materials,subMeshes,materialMap);
	}

	return MeshReader;
})()


/**
*<code>BoundBox</code> 类用于创建包围盒。
*/
//class laya.d3.math.BoundBox
var BoundBox=(function(){
	function BoundBox(min,max){
		/**最小顶点。*/
		this.min=null;
		/**最大顶点。*/
		this.max=null;
		this.min=min;
		this.max=max;
	}

	__class(BoundBox,'laya.d3.math.BoundBox');
	var __proto=BoundBox.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*获取包围盒的8个角顶点。
	*@param corners 返回顶点的输出队列。
	*/
	__proto.getCorners=function(corners){
		corners.length=8;
		var mine=this.min.elements;
		var maxe=this.max.elements;
		var minX=mine[0];
		var minY=mine[1];
		var minZ=mine[2];
		var maxX=maxe[0];
		var maxY=maxe[1];
		var maxZ=maxe[2];
		corners[0]=new Vector3(minX,maxY,maxZ);
		corners[1]=new Vector3(maxX,maxY,maxZ);
		corners[2]=new Vector3(maxX,minY,maxZ);
		corners[3]=new Vector3(minX,minY,maxZ);
		corners[4]=new Vector3(minX,maxY,minZ);
		corners[5]=new Vector3(maxX,maxY,minZ);
		corners[6]=new Vector3(maxX,minY,minZ);
		corners[7]=new Vector3(minX,minY,minZ);
	}

	__proto.toDefault=function(){
		this.min.toDefault();
		this.max.toDefault();
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var dest=destObject;
		this.min.cloneTo(dest.min);
		this.max.cloneTo(dest.max);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor(new Vector3(),new Vector3());
		this.cloneTo(dest);
		return dest;
	}

	BoundBox.createfromPoints=function(points,out){
		if (points==null)
			throw new Error("points");
		var min=out.min;
		var max=out.max;
		var minE=min.elements;
		minE[0]=Number.MAX_VALUE;
		minE[1]=Number.MAX_VALUE;
		minE[2]=Number.MAX_VALUE;
		var maxE=max.elements;
		maxE[0]=-Number.MAX_VALUE;
		maxE[1]=-Number.MAX_VALUE;
		maxE[2]=-Number.MAX_VALUE;
		for (var i=0,n=points.length;i < n;++i){
			Vector3.min(min,points[i],min);
			Vector3.max(max,points[i],max);
		}
	}

	BoundBox.merge=function(box1,box2,out){
		Vector3.min(box1.min,box2.min,out.min);
		Vector3.max(box1.max,box2.max,out.max);
	}

	return BoundBox;
})()


/**
*<code>BoundFrustum</code> 类用于创建锥截体。
*/
//class laya.d3.math.BoundFrustum
var BoundFrustum=(function(){
	function BoundFrustum(matrix){
		/**4x4矩阵*/
		this._matrix=null;
		/**近平面*/
		this._near=null;
		/**远平面*/
		this._far=null;
		/**左平面*/
		this._left=null;
		/**右平面*/
		this._right=null;
		/**顶平面*/
		this._top=null;
		/**底平面*/
		this._bottom=null;
		this._matrix=matrix;
		this._near=new Plane(new Vector3());
		this._far=new Plane(new Vector3());
		this._left=new Plane(new Vector3());
		this._right=new Plane(new Vector3());
		this._top=new Plane(new Vector3());
		this._bottom=new Plane(new Vector3());
		BoundFrustum._getPlanesFromMatrix(this._matrix,this._near,this._far,this._left,this._right,this._top,this._bottom);
	}

	__class(BoundFrustum,'laya.d3.math.BoundFrustum');
	var __proto=BoundFrustum.prototype;
	/**
	*判断是否与其他锥截体相等。
	*@param other 锥截体。
	*/
	__proto.equalsBoundFrustum=function(other){
		return this._matrix.equalsOtherMatrix(other.matrix)
	}

	/**
	*判断是否与其他对象相等。
	*@param obj 对象。
	*/
	__proto.equalsObj=function(obj){
		if ((obj instanceof laya.d3.math.BoundFrustum )){
			var bf=obj;
			return this.equalsBoundFrustum(bf);
		}
		return false;
	}

	/**
	*获取锥截体的任意一平面。
	*0:近平面
	*1:远平面
	*2:左平面
	*3:右平面
	*4:顶平面
	*5:底平面
	*@param index 索引。
	*/
	__proto.getPlane=function(index){
		switch (index){
			case 0:
				return this._near;
			case 1:
				return this._far;
			case 2:
				return this._left;
			case 3:
				return this._right;
			case 4:
				return this._top;
			case 5:
				return this._bottom;
			default :
				return null;
			}
	}

	/**
	*锥截体的8个顶点。
	*@param corners 返回顶点的输出队列。
	*/
	__proto.getCorners=function(corners){
		BoundFrustum._get3PlaneInterPoint(this._near,this._bottom,this._right).cloneTo(corners[0]);
		BoundFrustum._get3PlaneInterPoint(this._near,this._top,this._right).cloneTo(corners[1]);
		BoundFrustum._get3PlaneInterPoint(this._near,this._top,this._left).cloneTo(corners[2]);
		BoundFrustum._get3PlaneInterPoint(this._near,this._bottom,this._left).cloneTo(corners[3]);
		BoundFrustum._get3PlaneInterPoint(this._far,this._bottom,this._right).cloneTo(corners[4]);
		BoundFrustum._get3PlaneInterPoint(this._far,this._top,this._right).cloneTo(corners[5]);
		BoundFrustum._get3PlaneInterPoint(this._far,this._top,this._left).cloneTo(corners[6]);
		BoundFrustum._get3PlaneInterPoint(this._far,this._bottom,this._left).cloneTo(corners[7]);
	}

	/**
	*与点的位置关系。返回-1,包涵;0,相交;1,不相交
	*@param point 点。
	*/
	__proto.containsPoint=function(point){
		var result=Plane.PlaneIntersectionType_Front;
		var planeResult=Plane.PlaneIntersectionType_Front;
		for (var i=0;i < 6;i++){
			switch (i){
				case 0:
					planeResult=Collision.intersectsPlaneAndPoint(this._near,point);
					break ;
				case 1:
					planeResult=Collision.intersectsPlaneAndPoint(this._far,point);
					break ;
				case 2:
					planeResult=Collision.intersectsPlaneAndPoint(this._left,point);
					break ;
				case 3:
					planeResult=Collision.intersectsPlaneAndPoint(this._right,point);
					break ;
				case 4:
					planeResult=Collision.intersectsPlaneAndPoint(this._top,point);
					break ;
				case 5:
					planeResult=Collision.intersectsPlaneAndPoint(this._bottom,point);
					break ;
				}
			switch (planeResult){
				case Plane.PlaneIntersectionType_Back:
					return /*laya.d3.math.ContainmentType.Disjoint*/0;
				case Plane.PlaneIntersectionType_Intersecting:
					result=Plane.PlaneIntersectionType_Intersecting;
					break ;
				}
		}
		switch (result){
			case Plane.PlaneIntersectionType_Intersecting:
				return /*laya.d3.math.ContainmentType.Intersects*/2;
			default :
				return /*laya.d3.math.ContainmentType.Contains*/1;
			}
	}

	/**
	*与包围盒的位置关系。返回-1,包涵;0,相交;1,不相交
	*@param box 包围盒。
	*/
	__proto.containsBoundBox=function(box){
		var p=BoundFrustum._tempV30,n=BoundFrustum._tempV31;
		var plane;
		var result=/*laya.d3.math.ContainmentType.Contains*/1;
		for (var i=0;i < 6;i++){
			plane=this.getPlane(i);
			this._getBoxToPlanePVertexNVertex(box,plane.normal,p,n);
			if (Collision.intersectsPlaneAndPoint(plane,p)===Plane.PlaneIntersectionType_Back)
				return /*laya.d3.math.ContainmentType.Disjoint*/0;
			if (Collision.intersectsPlaneAndPoint(plane,n)===Plane.PlaneIntersectionType_Back)
				result=/*laya.d3.math.ContainmentType.Intersects*/2;
		}
		return result;
	}

	/**
	*与包围球的位置关系。返回-1,包涵;0,相交;1,不相交
	*@param sphere 包围球。
	*/
	__proto.containsBoundSphere=function(sphere){
		var result=Plane.PlaneIntersectionType_Front;
		var planeResult=Plane.PlaneIntersectionType_Front;
		for (var i=0;i < 6;i++){
			switch (i){
				case 0:
					planeResult=Collision.intersectsPlaneAndSphere(this._near,sphere);
					break ;
				case 1:
					planeResult=Collision.intersectsPlaneAndSphere(this._far,sphere);
					break ;
				case 2:
					planeResult=Collision.intersectsPlaneAndSphere(this._left,sphere);
					break ;
				case 3:
					planeResult=Collision.intersectsPlaneAndSphere(this._right,sphere);
					break ;
				case 4:
					planeResult=Collision.intersectsPlaneAndSphere(this._top,sphere);
					break ;
				case 5:
					planeResult=Collision.intersectsPlaneAndSphere(this._bottom,sphere);
					break ;
				}
			switch (planeResult){
				case Plane.PlaneIntersectionType_Back:
					return /*laya.d3.math.ContainmentType.Disjoint*/0;
				case Plane.PlaneIntersectionType_Intersecting:
					result=Plane.PlaneIntersectionType_Intersecting;
					break ;
				}
		}
		switch (result){
			case Plane.PlaneIntersectionType_Intersecting:
				return /*laya.d3.math.ContainmentType.Intersects*/2;
			default :
				return /*laya.d3.math.ContainmentType.Contains*/1;
			}
	}

	/**
	*@private
	*/
	__proto._getBoxToPlanePVertexNVertex=function(box,planeNormal,outP,outN){
		var boxMin=box.min;
		var boxMinE=boxMin.elements;
		var boxMax=box.max;
		var boxMaxE=boxMax.elements;
		var planeNorE=planeNormal.elements;
		var planeNorEX=planeNorE[0];
		var planeNorEY=planeNorE[1];
		var planeNorEZ=planeNorE[2];
		boxMin.cloneTo(outP);;
		var outPE=outP.elements;
		if (planeNorEX >=0)
			outPE[0]=boxMaxE[0];
		if (planeNorEY >=0)
			outPE[1]=boxMaxE[1];
		if (planeNorEZ >=0)
			outPE[2]=boxMaxE[2];
		boxMax.cloneTo(outN);
		var outNE=outN.elements;
		if (planeNorEX >=0)
			outNE[0]=boxMinE[0];
		if (planeNorEY >=0)
			outNE[1]=boxMinE[1];
		if (planeNorEZ >=0)
			outNE[2]=boxMinE[2];
	}

	/**
	*获取顶平面。
	*@return 顶平面。
	*/
	__getset(0,__proto,'top',function(){
		return this._top;
	});

	/**
	*设置描述矩阵。
	*@param matrix 描述矩阵。
	*/
	/**
	*获取描述矩阵。
	*@return 描述矩阵。
	*/
	__getset(0,__proto,'matrix',function(){
		return this._matrix;
		},function(matrix){
		this._matrix=matrix;
		BoundFrustum._getPlanesFromMatrix(this._matrix,this._near,this._far,this._left,this._right,this._top,this._bottom);
	});

	/**
	*获取近平面。
	*@return 近平面。
	*/
	__getset(0,__proto,'near',function(){
		return this._near;
	});

	/**
	*获取远平面。
	*@return 远平面。
	*/
	__getset(0,__proto,'far',function(){
		return this._far;
	});

	/**
	*获取左平面。
	*@return 左平面。
	*/
	__getset(0,__proto,'left',function(){
		return this._left;
	});

	/**
	*获取右平面。
	*@return 右平面。
	*/
	__getset(0,__proto,'right',function(){
		return this._right;
	});

	/**
	*获取底平面。
	*@return 底平面。
	*/
	__getset(0,__proto,'bottom',function(){
		return this._bottom;
	});

	BoundFrustum._getPlanesFromMatrix=function(m,np,fp,lp,rp,tp,bp){
		var matrixE=m.elements;
		var m11=matrixE[0];
		var m12=matrixE[1];
		var m13=matrixE[2];
		var m14=matrixE[3];
		var m21=matrixE[4];
		var m22=matrixE[5];
		var m23=matrixE[6];
		var m24=matrixE[7];
		var m31=matrixE[8];
		var m32=matrixE[9];
		var m33=matrixE[10];
		var m34=matrixE[11];
		var m41=matrixE[12];
		var m42=matrixE[13];
		var m43=matrixE[14];
		var m44=matrixE[15];
		var nearNorE=np.normal.elements;
		nearNorE[0]=m14+m13;
		nearNorE[1]=m24+m23;
		nearNorE[2]=m34+m33;
		np.distance=m44+m43;
		np.normalize();
		var farNorE=fp.normal.elements;
		farNorE[0]=m14-m13;
		farNorE[1]=m24-m23;
		farNorE[2]=m34-m33;
		fp.distance=m44-m43;
		fp.normalize();
		var leftNorE=lp.normal.elements;
		leftNorE[0]=m14+m11;
		leftNorE[1]=m24+m21;
		leftNorE[2]=m34+m31;
		lp.distance=m44+m41;
		lp.normalize();
		var rightNorE=rp.normal.elements;
		rightNorE[0]=m14-m11;
		rightNorE[1]=m24-m21;
		rightNorE[2]=m34-m31;
		rp.distance=m44-m41;
		rp.normalize();
		var topNorE=tp.normal.elements;
		topNorE[0]=m14-m12;
		topNorE[1]=m24-m22;
		topNorE[2]=m34-m32;
		tp.distance=m44-m42;
		tp.normalize();
		var bottomNorE=bp.normal.elements;
		bottomNorE[0]=m14+m12;
		bottomNorE[1]=m24+m22;
		bottomNorE[2]=m34+m32;
		bp.distance=m44+m42;
		bp.normalize();
	}

	BoundFrustum._get3PlaneInterPoint=function(p1,p2,p3){
		var p1Nor=p1.normal;
		var p2Nor=p2.normal;
		var p3Nor=p3.normal;
		Vector3.cross(p2Nor,p3Nor,BoundFrustum._tempV30);
		Vector3.cross(p3Nor,p1Nor,BoundFrustum._tempV31);
		Vector3.cross(p1Nor,p2Nor,BoundFrustum._tempV32);
		var a=Vector3.dot(p1Nor,BoundFrustum._tempV30);
		var b=Vector3.dot(p2Nor,BoundFrustum._tempV31);
		var c=Vector3.dot(p3Nor,BoundFrustum._tempV32);
		Vector3.scale(BoundFrustum._tempV30,-p1.distance / a,BoundFrustum._tempV33);
		Vector3.scale(BoundFrustum._tempV31,-p2.distance / b,BoundFrustum._tempV34);
		Vector3.scale(BoundFrustum._tempV32,-p3.distance / c,BoundFrustum._tempV35);
		Vector3.add(BoundFrustum._tempV33,BoundFrustum._tempV34,BoundFrustum._tempV36);
		Vector3.add(BoundFrustum._tempV35,BoundFrustum._tempV36,BoundFrustum._tempV37);
		var v=BoundFrustum._tempV37;
		return v;
	}

	__static(BoundFrustum,
	['_tempV30',function(){return this._tempV30=new Vector3();},'_tempV31',function(){return this._tempV31=new Vector3();},'_tempV32',function(){return this._tempV32=new Vector3();},'_tempV33',function(){return this._tempV33=new Vector3();},'_tempV34',function(){return this._tempV34=new Vector3();},'_tempV35',function(){return this._tempV35=new Vector3();},'_tempV36',function(){return this._tempV36=new Vector3();},'_tempV37',function(){return this._tempV37=new Vector3();}
	]);
	return BoundFrustum;
})()


/**
*<code>BoundSphere</code> 类用于创建包围球。
*/
//class laya.d3.math.BoundSphere
var BoundSphere=(function(){
	function BoundSphere(center,radius){
		/**包围球的中心。*/
		this.center=null;
		/**包围球的半径。*/
		this.radius=NaN;
		this.center=center;
		this.radius=radius;
	}

	__class(BoundSphere,'laya.d3.math.BoundSphere');
	var __proto=BoundSphere.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	__proto.toDefault=function(){
		this.center.toDefault();
		this.radius=0;
	}

	/**
	*判断射线是否与碰撞球交叉，并返回交叉距离。
	*@param ray 射线。
	*@return 距离交叉点的距离，-1表示不交叉。
	*/
	__proto.intersectsRayDistance=function(ray){
		return Collision.intersectsRayAndSphereRD(ray,this);
	}

	/**
	*判断射线是否与碰撞球交叉，并返回交叉点。
	*@param ray 射线。
	*@param outPoint 交叉点。
	*@return 距离交叉点的距离，-1表示不交叉。
	*/
	__proto.intersectsRayPoint=function(ray,outPoint){
		return Collision.intersectsRayAndSphereRP(ray,this,outPoint);
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var dest=destObject;
		this.center.cloneTo(dest.center);
		dest.radius=this.radius;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor(new Vector3(),new Vector3());
		this.cloneTo(dest);
		return dest;
	}

	BoundSphere.createFromSubPoints=function(points,start,count,out){
		if (points==null){
			throw new Error("points");
		}
		if (start < 0 || start >=points.length){
			throw new Error("start"+start+"Must be in the range [0, "+(points.length-1)+"]");
		}
		if (count < 0 || (start+count)> points.length){
			throw new Error("count"+count+"Must be in the range <= "+points.length+"}");
		};
		var upperEnd=start+count;
		var center=BoundSphere._tempVector3;
		center.elements[0]=0;
		center.elements[1]=0;
		center.elements[2]=0;
		for (var i=start;i < upperEnd;++i){
			Vector3.add(points[i],center,center);
		};
		var outCenter=out.center;
		Vector3.scale(center,1 / count,outCenter);
		var radius=0.0;
		for (i=start;i < upperEnd;++i){
			var distance=Vector3.distanceSquared(outCenter,points[i]);
			if (distance > radius)
				radius=distance;
		}
		out.radius=Math.sqrt(radius);
	}

	BoundSphere.createfromPoints=function(points,out){
		if (points==null){
			throw new Error("points");
		}
		BoundSphere.createFromSubPoints(points,0,points.length,out);
	}

	__static(BoundSphere,
	['_tempVector3',function(){return this._tempVector3=new Vector3();}
	]);
	return BoundSphere;
})()


/**
*<code>Collision</code> 类用于检测碰撞。
*/
//class laya.d3.math.Collision
var Collision=(function(){
	/**
	*创建一个 <code>Collision</code> 实例。
	*/
	function Collision(){}
	__class(Collision,'laya.d3.math.Collision');
	Collision.distancePlaneToPoint=function(plane,point){
		var dot=Vector3.dot(plane.normal,point);
		return dot-plane.distance;
	}

	Collision.distanceBoxToPoint=function(box,point){
		var boxMine=box.min.elements;
		var boxMineX=boxMine[0];
		var boxMineY=boxMine[1];
		var boxMineZ=boxMine[2];
		var boxMaxe=box.max.elements;
		var boxMaxeX=boxMaxe[0];
		var boxMaxeY=boxMaxe[1];
		var boxMaxeZ=boxMaxe[2];
		var pointe=point.elements;
		var pointeX=pointe[0];
		var pointeY=pointe[1];
		var pointeZ=pointe[2];
		var distance=0;
		if (pointeX < boxMineX)
			distance+=(boxMineX-pointeX)*(boxMineX-pointeX);
		if (pointeX > boxMaxeX)
			distance+=(boxMaxeX-pointeX)*(boxMaxeX-pointeX);
		if (pointeY < boxMineY)
			distance+=(boxMineY-pointeY)*(boxMineY-pointeY);
		if (pointeY > boxMaxeY)
			distance+=(boxMaxeY-pointeY)*(boxMaxeY-pointeY);
		if (pointeZ < boxMineZ)
			distance+=(boxMineZ-pointeZ)*(boxMineZ-pointeZ);
		if (pointeZ > boxMaxeZ)
			distance+=(boxMaxeZ-pointeZ)*(boxMaxeZ-pointeZ);
		return Math.sqrt(distance);
	}

	Collision.distanceBoxToBox=function(box1,box2){
		var box1Mine=box1.min.elements;
		var box1MineX=box1Mine[0];
		var box1MineY=box1Mine[1];
		var box1MineZ=box1Mine[2];
		var box1Maxe=box1.max.elements;
		var box1MaxeX=box1Maxe[0];
		var box1MaxeY=box1Maxe[1];
		var box1MaxeZ=box1Maxe[2];
		var box2Mine=box2.min.elements;
		var box2MineX=box2Mine[0];
		var box2MineY=box2Mine[1];
		var box2MineZ=box2Mine[2];
		var box2Maxe=box2.max.elements;
		var box2MaxeX=box2Maxe[0];
		var box2MaxeY=box2Maxe[1];
		var box2MaxeZ=box2Maxe[2];
		var distance=0;
		var delta=NaN;
		if (box1MineX > box2MaxeX){
			delta=box1MineX-box2MaxeX;
			distance+=delta *delta;
			}else if (box2MineX > box1MaxeX){
			delta=box2MineX-box1MaxeX;
			distance+=delta *delta;
		}
		if (box1MineY > box2MaxeY){
			delta=box1MineY-box2MaxeY;
			distance+=delta *delta;
			}else if (box2MineY > box1MaxeY){
			delta=box2MineY-box1MaxeY;
			distance+=delta *delta;
		}
		if (box1MineZ > box2MaxeZ){
			delta=box1MineZ-box2MaxeZ;
			distance+=delta *delta;
			}else if (box2MineZ > box1MaxeZ){
			delta=box2MineZ-box1MaxeZ;
			distance+=delta *delta;
		}
		return Math.sqrt(distance);
	}

	Collision.distanceSphereToPoint=function(sphere,point){
		var distance=Math.sqrt(Vector3.distanceSquared(sphere.center,point));
		distance-=sphere.radius;
		return Math.max(distance,0);
	}

	Collision.distanceSphereToSphere=function(sphere1,sphere2){
		var distance=Math.sqrt(Vector3.distanceSquared(sphere1.center,sphere2.center));
		distance-=sphere1.radius+sphere2.radius;
		return Math.max(distance,0);
	}

	Collision.intersectsRayAndTriangleRD=function(ray,vertex1,vertex2,vertex3,out){
		var rayO=ray.origin;
		var rayOe=rayO.elements;
		var rayOeX=rayOe[0];
		var rayOeY=rayOe[1];
		var rayOeZ=rayOe[2];
		var rayD=ray.direction;
		var rayDe=rayD.elements;
		var rayDeX=rayDe[0];
		var rayDeY=rayDe[1];
		var rayDeZ=rayDe[2];
		var v1e=vertex1.elements;
		var v1eX=v1e[0];
		var v1eY=v1e[1];
		var v1eZ=v1e[2];
		var v2e=vertex2.elements;
		var v2eX=v2e[0];
		var v2eY=v2e[1];
		var v2eZ=v2e[2];
		var v3e=vertex3.elements;
		var v3eX=v3e[0];
		var v3eY=v3e[1];
		var v3eZ=v3e[2];
		var _tempV30e=Collision._tempV30.elements;
		var _tempV30eX=_tempV30e[0];
		var _tempV30eY=_tempV30e[1];
		var _tempV30eZ=_tempV30e[2];
		_tempV30eX=v2eX-v1eX;
		_tempV30eY=v2eY-v1eY;
		_tempV30eZ=v2eZ-v1eZ;
		var _tempV31e=Collision._tempV31.elements;
		var _tempV31eX=_tempV31e[0];
		var _tempV31eY=_tempV31e[1];
		var _tempV31eZ=_tempV31e[2];
		_tempV31eX=v3eX-v1eX;
		_tempV31eY=v3eY-v1eY;
		_tempV31eZ=v3eZ-v1eZ;
		var _tempV32e=Collision._tempV32.elements;
		var _tempV32eX=_tempV32e[0];
		var _tempV32eY=_tempV32e[1];
		var _tempV32eZ=_tempV32e[2];
		_tempV32eX=(rayDeY *_tempV31eZ)-(rayDeZ *_tempV31eY);
		_tempV32eY=(rayDeZ *_tempV31eX)-(rayDeX *_tempV31eZ);
		_tempV32eZ=(rayDeX *_tempV31eY)-(rayDeY *_tempV31eX);
		var determinant=(_tempV30eX *_tempV32eX)+(_tempV30eY *_tempV32eY)+(_tempV30eZ *_tempV32eZ);
		if (MathUtils3D.isZero(determinant)){
			out=0;
			return false;
		};
		var inversedeterminant=1 / determinant;
		var _tempV33e=Collision._tempV33.elements;
		var _tempV33eX=_tempV33e[0];
		var _tempV33eY=_tempV33e[1];
		var _tempV33eZ=_tempV33e[2];
		_tempV33eX=rayOeX-v1eX;
		_tempV33eY=rayOeY-v1eY;
		_tempV33eZ=rayOeZ-v1eZ;
		var triangleU=(_tempV33eX *_tempV32eX)+(_tempV33eY *_tempV32eY)+(_tempV33eZ *_tempV32eZ);
		triangleU *=inversedeterminant;
		if (triangleU < 0 || triangleU > 1){
			out=0;
			return false;
		};
		var _tempV34e=Collision._tempV34.elements;
		var _tempV34eX=_tempV34e[0];
		var _tempV34eY=_tempV34e[1];
		var _tempV34eZ=_tempV34e[2];
		_tempV34eX=(_tempV33eY *_tempV30eZ)-(_tempV33eZ *_tempV30eY);
		_tempV34eY=(_tempV33eZ *_tempV30eX)-(_tempV33eX *_tempV30eZ);
		_tempV34eZ=(_tempV33eX *_tempV30eY)-(_tempV33eY *_tempV30eX);
		var triangleV=((rayDeX *_tempV34eX)+(rayDeY *_tempV34eY))+(rayDeZ *_tempV34eZ);
		triangleV *=inversedeterminant;
		if (triangleV < 0 || triangleU+triangleV > 1){
			out=0;
			return false;
		};
		var raydistance=(_tempV31eX *_tempV34eX)+(_tempV31eY *_tempV34eY)+(_tempV31eZ *_tempV34eZ);
		raydistance *=inversedeterminant;
		if (raydistance < 0){
			out=0;
			return false;
		}
		out=raydistance;
		return true;
	}

	Collision.intersectsRayAndTriangleRP=function(ray,vertex1,vertex2,vertex3,out){
		var distance=NaN;
		if (!Collision.intersectsRayAndTriangleRD(ray,vertex1,vertex2,vertex3,distance)){
			out=Vector3.ZERO;
			return false;
		}
		Vector3.scale(ray.direction,distance,Collision._tempV30);
		Vector3.add(ray.origin,Collision._tempV30,out);
		return true;
	}

	Collision.intersectsRayAndPoint=function(ray,point){
		Vector3.subtract(ray.origin,point,Collision._tempV30);
		var b=Vector3.dot(Collision._tempV30,ray.direction);
		var c=Vector3.dot(Collision._tempV30,Collision._tempV30)-MathUtils3D.zeroTolerance;
		if (c > 0 && b > 0)
			return false;
		var discriminant=b *b-c;
		if (discriminant < 0)
			return false;
		return true;
	}

	Collision.intersectsRayAndRay=function(ray1,ray2,out){
		var ray1o=ray1.origin;
		var ray1oe=ray1o.elements;
		var ray1oeX=ray1oe[0];
		var ray1oeY=ray1oe[1];
		var ray1oeZ=ray1oe[2];
		var ray1d=ray1.direction;
		var ray1de=ray1d.elements;
		var ray1deX=ray1de[0];
		var ray1deY=ray1de[1];
		var ray1deZ=ray1de[2];
		var ray2o=ray2.origin;
		var ray2oe=ray2o.elements;
		var ray2oeX=ray2oe[0];
		var ray2oeY=ray2oe[1];
		var ray2oeZ=ray2oe[2];
		var ray2d=ray2.direction;
		var ray2de=ray2d.elements;
		var ray2deX=ray2de[0];
		var ray2deY=ray2de[1];
		var ray2deZ=ray2de[2];
		Vector3.cross(ray1d,ray2d,Collision._tempV30);
		var tempV3e=Collision._tempV30.elements;
		var denominator=Vector3.scalarLengthSquared(Collision._tempV30);
		if (MathUtils3D.isZero(denominator)){
			if (MathUtils3D.nearEqual(ray2oeX,ray1oeX)&& MathUtils3D.nearEqual(ray2oeY,ray1oeY)&& MathUtils3D.nearEqual(ray2oeZ,ray1oeZ)){
				Vector3.ZERO.cloneTo(out);
				return true;
			}
		};
		var m11=ray2oeX-ray1oeX;
		var m12=ray2oeY-ray1oeY;
		var m13=ray2oeZ-ray1oeZ;
		var m21=ray2deX;
		var m22=ray2deY;
		var m23=ray2deZ;
		var m31=tempV3e[0];
		var m32=tempV3e[1];
		var m33=tempV3e[2];
		var dets=m11 *m22 *m33+m12 *m23 *m31+m13 *m21 *m32-m11 *m23 *m32-m12 *m21 *m33-m13 *m22 *m31;
		m21=ray1deX;
		m22=ray1deY;
		m23=ray1deZ;
		var dett=m11 *m22 *m33+m12 *m23 *m31+m13 *m21 *m32-m11 *m23 *m32-m12 *m21 *m33-m13 *m22 *m31;
		var s=dets / denominator;
		var t=dett / denominator;
		Vector3.scale(ray1d,s,Collision._tempV30);
		Vector3.scale(ray2d,t,Collision._tempV31);
		Vector3.add(ray1o,Collision._tempV30,Collision._tempV32);
		Vector3.add(ray2o,Collision._tempV31,Collision._tempV33);
		var point1e=Collision._tempV32.elements;
		var point2e=Collision._tempV33.elements;
		if (!MathUtils3D.nearEqual(point2e[0],point1e[0])|| !MathUtils3D.nearEqual(point2e[1],point1e[1])|| !MathUtils3D.nearEqual(point2e[2],point1e[2])){
			Vector3.ZERO.cloneTo(out);
			return false;
		}
		Collision._tempV32.cloneTo(out);
		return true;
	}

	Collision.intersectsPlaneAndTriangle=function(plane,vertex1,vertex2,vertex3){
		var test1=Collision.intersectsPlaneAndPoint(plane,vertex1);
		var test2=Collision.intersectsPlaneAndPoint(plane,vertex2);
		var test3=Collision.intersectsPlaneAndPoint(plane,vertex3);
		if (test1==Plane.PlaneIntersectionType_Front && test2==Plane.PlaneIntersectionType_Front && test3==Plane.PlaneIntersectionType_Front)
			return Plane.PlaneIntersectionType_Front;
		if (test1==Plane.PlaneIntersectionType_Back && test2==Plane.PlaneIntersectionType_Back && test3==Plane.PlaneIntersectionType_Back)
			return Plane.PlaneIntersectionType_Back;
		return Plane.PlaneIntersectionType_Intersecting;
	}

	Collision.intersectsRayAndPlaneRD=function(ray,plane,out){
		var planeNor=plane.normal;
		var direction=Vector3.dot(planeNor,ray.direction);
		if (MathUtils3D.isZero(direction)){
			out=0;
			return false;
		};
		var position=Vector3.dot(planeNor,ray.origin);
		out=(-plane.distance-position)/ direction;
		if (out < 0){
			out=0;
			return false;
		}
		return true;
	}

	Collision.intersectsRayAndPlaneRP=function(ray,plane,out){
		var distance=NaN;
		if (!Collision.intersectsRayAndPlaneRD(ray,plane,distance)){
			out=Vector3.ZERO;
			return false;
		}
		Vector3.scale(ray.direction,distance,Collision._tempV30);
		Vector3.add(ray.origin,Collision._tempV30,Collision._tempV31);
		out=Collision._tempV31;
		return true;
	}

	Collision.intersectsRayAndBoxRD=function(ray,box){
		var rayoe=ray.origin.elements;
		var rayoeX=rayoe[0];
		var rayoeY=rayoe[1];
		var rayoeZ=rayoe[2];
		var rayde=ray.direction.elements;
		var raydeX=rayde[0];
		var raydeY=rayde[1];
		var raydeZ=rayde[2];
		var boxMine=box.min.elements;
		var boxMineX=boxMine[0];
		var boxMineY=boxMine[1];
		var boxMineZ=boxMine[2];
		var boxMaxe=box.max.elements;
		var boxMaxeX=boxMaxe[0];
		var boxMaxeY=boxMaxe[1];
		var boxMaxeZ=boxMaxe[2];
		var out=0;
		var tmax=MathUtils3D.MaxValue;
		if (MathUtils3D.isZero(raydeX)){
			if (rayoeX < boxMineX || rayoeX > boxMaxeX){
				return-1;
			}
			}else {
			var inverse=1 / raydeX;
			var t1=(boxMineX-rayoeX)*inverse;
			var t2=(boxMaxeX-rayoeX)*inverse;
			if (t1 > t2){
				var temp=t1;
				t1=t2;
				t2=temp;
			}
			out=Math.max(t1,out);
			tmax=Math.min(t2,tmax);
			if (out > tmax){
				return-1;
			}
		}
		if (MathUtils3D.isZero(raydeY)){
			if (rayoeY < boxMineY || rayoeY > boxMaxeY){
				return-1;
			}
			}else {
			var inverse1=1 / raydeY;
			var t3=(boxMineY-rayoeY)*inverse1;
			var t4=(boxMaxeY-rayoeY)*inverse1;
			if (t3 > t4){
				var temp1=t3;
				t3=t4;
				t4=temp1;
			}
			out=Math.max(t3,out);
			tmax=Math.min(t4,tmax);
			if (out > tmax){
				return-1;
			}
		}
		if (MathUtils3D.isZero(raydeZ)){
			if (rayoeZ < boxMineZ || rayoeZ > boxMaxeZ){
				return-1;
			}
			}else {
			var inverse2=1 / raydeZ;
			var t5=(boxMineZ-rayoeZ)*inverse2;
			var t6=(boxMaxeZ-rayoeZ)*inverse2;
			if (t5 > t6){
				var temp2=t5;
				t5=t6;
				t6=temp2;
			}
			out=Math.max(t5,out);
			tmax=Math.min(t6,tmax);
			if (out > tmax){
				return-1;
			}
		}
		return out;
	}

	Collision.intersectsRayAndBoxRP=function(ray,box,out){
		var distance=Collision.intersectsRayAndBoxRD(ray,box);
		if (distance===-1){
			Vector3.ZERO.cloneTo(out);
			return distance;
		}
		Vector3.scale(ray.direction,distance,Collision._tempV30);
		Vector3.add(ray.origin,Collision._tempV30,Collision._tempV31);
		Collision._tempV31.cloneTo(out);
		return distance;
	}

	Collision.intersectsRayAndSphereRD=function(ray,sphere){
		var sphereR=sphere.radius;
		Vector3.subtract(ray.origin,sphere.center,Collision._tempV30);
		var b=Vector3.dot(Collision._tempV30,ray.direction);
		var c=Vector3.dot(Collision._tempV30,Collision._tempV30)-(sphereR *sphereR);
		if (c > 0 && b > 0){
			return-1;
		};
		var discriminant=b *b-c;
		if (discriminant < 0){
			return-1;
		};
		var distance=-b-Math.sqrt(discriminant);
		if (distance < 0)
			distance=0;
		return distance;
	}

	Collision.intersectsRayAndSphereRP=function(ray,sphere,out){
		var distance=Collision.intersectsRayAndSphereRD(ray,sphere);
		if (distance===-1){
			Vector3.ZERO.cloneTo(out);
			return distance;
		}
		Vector3.scale(ray.direction,distance,Collision._tempV30);
		Vector3.add(ray.origin,Collision._tempV30,Collision._tempV31);
		Collision._tempV31.cloneTo(out);
		return distance;
	}

	Collision.intersectsSphereAndTriangle=function(sphere,vertex1,vertex2,vertex3){
		var sphereC=sphere.center;
		var sphereR=sphere.radius;
		Collision.closestPointPointTriangle(sphereC,vertex1,vertex2,vertex3,Collision._tempV30);
		Vector3.subtract(Collision._tempV30,sphereC,Collision._tempV31);
		var dot=Vector3.dot(Collision._tempV31,Collision._tempV31);
		return dot <=sphereR *sphereR;
	}

	Collision.intersectsPlaneAndPoint=function(plane,point){
		var distance=Vector3.dot(plane.normal,point)+plane.distance;
		if (distance > 0)
			return Plane.PlaneIntersectionType_Front;
		if (distance < 0)
			return Plane.PlaneIntersectionType_Back;
		return Plane.PlaneIntersectionType_Intersecting;
	}

	Collision.intersectsPlaneAndPlane=function(plane1,plane2){
		Vector3.cross(plane1.normal,plane2.normal,Collision._tempV30);
		var denominator=Vector3.dot(Collision._tempV30,Collision._tempV30);
		if (MathUtils3D.isZero(denominator))
			return false;
		return true;
	}

	Collision.intersectsPlaneAndPlaneRL=function(plane1,plane2,line){
		var plane1nor=plane1.normal;
		var plane2nor=plane2.normal;
		Vector3.cross(plane1nor,plane2nor,Collision._tempV34);
		var denominator=Vector3.dot(Collision._tempV34,Collision._tempV34);
		if (MathUtils3D.isZero(denominator))
			return false;
		Vector3.scale(plane2nor,plane1.distance,Collision._tempV30);
		Vector3.scale(plane1nor,plane2.distance,Collision._tempV31);
		Vector3.subtract(Collision._tempV30,Collision._tempV31,Collision._tempV32);
		Vector3.cross(Collision._tempV32,Collision._tempV34,Collision._tempV33);
		Vector3.normalize(Collision._tempV34,Collision._tempV34);
		line=new Ray(Collision._tempV33,Collision._tempV34);
		return true;
	}

	Collision.intersectsPlaneAndBox=function(plane,box){
		var planeD=plane.distance;
		var planeNor=plane.normal;
		var planeNore=planeNor.elements;
		var planeNoreX=planeNore[0];
		var planeNoreY=planeNore[1];
		var planeNoreZ=planeNore[2];
		var boxMine=box.min.elements;
		var boxMineX=boxMine[0];
		var boxMineY=boxMine[1];
		var boxMineZ=boxMine[2];
		var boxMaxe=box.max.elements;
		var boxMaxeX=boxMaxe[0];
		var boxMaxeY=boxMaxe[1];
		var boxMaxeZ=boxMaxe[2];
		Collision._tempV30.elements[0]=(planeNoreX > 0)? boxMineX :boxMaxeX;
		Collision._tempV30.elements[1]=(planeNoreY > 0)? boxMineY :boxMaxeY;
		Collision._tempV30.elements[2]=(planeNoreZ > 0)? boxMineZ :boxMaxeZ;
		Collision._tempV31.elements[0]=(planeNoreX > 0)? boxMaxeX :boxMineX;
		Collision._tempV31.elements[1]=(planeNoreY > 0)? boxMaxeY :boxMineY;
		Collision._tempV31.elements[2]=(planeNoreZ > 0)? boxMaxeZ :boxMineZ;
		var distance=Vector3.dot(planeNor,Collision._tempV30);
		if (distance+planeD > 0)
			return Plane.PlaneIntersectionType_Front;
		distance=Vector3.dot(planeNor,Collision._tempV31);
		if (distance+planeD < 0)
			return Plane.PlaneIntersectionType_Back;
		return Plane.PlaneIntersectionType_Intersecting;
	}

	Collision.intersectsPlaneAndSphere=function(plane,sphere){
		var sphereR=sphere.radius;
		var distance=Vector3.dot(plane.normal,sphere.center)+plane.distance;
		if (distance > sphereR)
			return Plane.PlaneIntersectionType_Front;
		if (distance <-sphereR)
			return Plane.PlaneIntersectionType_Back;
		return Plane.PlaneIntersectionType_Intersecting;
	}

	Collision.intersectsBoxAndBox=function(box1,box2){
		var box1Mine=box1.min.elements;
		var box1Maxe=box1.max.elements;
		var box2Mine=box2.min.elements;
		var box2Maxe=box2.max.elements;
		if (box1Mine[0] > box2Maxe[0] || box2Mine[0] > box1Maxe[0])
			return false;
		if (box1Mine[1] > box2Maxe[1] || box2Mine[1] > box1Maxe[1])
			return false;
		if (box1Mine[2] > box2Maxe[2] || box2Mine[2] > box1Maxe[2])
			return false;
		return true;
	}

	Collision.intersectsBoxAndSphere=function(box,sphere){
		var sphereC=sphere.center;
		var sphereR=sphere.radius;
		Vector3.Clamp(sphereC,box.min,box.max,Collision._tempV30);
		var distance=Vector3.distanceSquared(sphereC,Collision._tempV30);
		return distance <=sphereR *sphereR;
	}

	Collision.intersectsSphereAndSphere=function(sphere1,sphere2){
		var radiisum=sphere1.radius+sphere2.radius;
		return Vector3.distanceSquared(sphere1.center,sphere2.center)<=radiisum *radiisum;
	}

	Collision.boxContainsPoint=function(box,point){
		var boxMine=box.min.elements;
		var boxMaxe=box.max.elements;
		var pointe=point.elements;
		if (boxMine[0] <=pointe[0] && boxMaxe[0] >=pointe[0] && boxMine[1] <=pointe[1] && boxMaxe[1] >=pointe[1] && boxMine[2] <=pointe[2] && boxMaxe[2] >=pointe[2])
			return /*laya.d3.math.ContainmentType.Contains*/1;
		return /*laya.d3.math.ContainmentType.Disjoint*/0;
	}

	Collision.boxContainsBox=function(box1,box2){
		var box1Mine=box1.min.elements;
		var box1MineX=box1Mine[0];
		var box1MineY=box1Mine[1];
		var box1MineZ=box1Mine[2];
		var box1Maxe=box1.max.elements;
		var box1MaxeX=box1Maxe[0];
		var box1MaxeY=box1Maxe[1];
		var box1MaxeZ=box1Maxe[2];
		var box2Mine=box2.min.elements;
		var box2MineX=box2Mine[0];
		var box2MineY=box2Mine[1];
		var box2MineZ=box2Mine[2];
		var box2Maxe=box2.max.elements;
		var box2MaxeX=box2Maxe[0];
		var box2MaxeY=box2Maxe[1];
		var box2MaxeZ=box2Maxe[2];
		if (box1MaxeX < box2MineX || box1MineX > box2MaxeX)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (box1MaxeY < box2MineY || box1MineY > box2MaxeY)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (box1MaxeZ < box2MineZ || box1MineZ > box2MaxeZ)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (box1MineX <=box2MineX && box2MaxeX <=box2MaxeX && box1MineY <=box2MineY && box2MaxeY <=box1MaxeY && box1MineZ <=box2MineZ && box2MaxeZ <=box1MaxeZ){
			return /*laya.d3.math.ContainmentType.Contains*/1;
		}
		return /*laya.d3.math.ContainmentType.Intersects*/2;
	}

	Collision.boxContainsSphere=function(box,sphere){
		var boxMin=box.min;
		var boxMine=boxMin.elements;
		var boxMineX=boxMine[0];
		var boxMineY=boxMine[1];
		var boxMineZ=boxMine[2];
		var boxMax=box.max;
		var boxMaxe=boxMax.elements;
		var boxMaxeX=boxMaxe[0];
		var boxMaxeY=boxMaxe[1];
		var boxMaxeZ=boxMaxe[2];
		var sphereC=sphere.center;
		var sphereCe=sphereC.elements;
		var sphereCeX=sphereCe[0];
		var sphereCeY=sphereCe[1];
		var sphereCeZ=sphereCe[2];
		var sphereR=sphere.radius;
		Vector3.Clamp(sphereC,boxMin,boxMax,Collision._tempV30);
		var distance=Vector3.distanceSquared(sphereC,Collision._tempV30);
		if (distance > sphereR *sphereR)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if ((((boxMineX+sphereR <=sphereCeX)&& (sphereCeX <=boxMaxeX-sphereR))&& ((boxMaxeX-boxMineX > sphereR)&&
			(boxMineY+sphereR <=sphereCeY)))&& (((sphereCeY <=boxMaxeY-sphereR)&& (boxMaxeY-boxMineY > sphereR))&&
		(((boxMineZ+sphereR <=sphereCeZ)&& (sphereCeZ <=boxMaxeZ-sphereR))&& (boxMaxeZ-boxMineZ > sphereR))))
		return /*laya.d3.math.ContainmentType.Contains*/1;
		return /*laya.d3.math.ContainmentType.Intersects*/2;
	}

	Collision.sphereContainsPoint=function(sphere,point){
		if (Vector3.distanceSquared(point,sphere.center)<=sphere.radius *sphere.radius)
			return /*laya.d3.math.ContainmentType.Contains*/1;
		return /*laya.d3.math.ContainmentType.Disjoint*/0;
	}

	Collision.sphereContainsTriangle=function(sphere,vertex1,vertex2,vertex3){
		var test1=Collision.sphereContainsPoint(sphere,vertex1);
		var test2=Collision.sphereContainsPoint(sphere,vertex2);
		var test3=Collision.sphereContainsPoint(sphere,vertex3);
		if (test1==/*laya.d3.math.ContainmentType.Contains*/1 && test2==/*laya.d3.math.ContainmentType.Contains*/1 && test3==/*laya.d3.math.ContainmentType.Contains*/1)
			return /*laya.d3.math.ContainmentType.Contains*/1;
		if (Collision.intersectsSphereAndTriangle(sphere,vertex1,vertex2,vertex3))
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		return /*laya.d3.math.ContainmentType.Disjoint*/0;
	}

	Collision.sphereContainsBox=function(sphere,box){
		var sphereC=sphere.center;
		var sphereCe=sphereC.elements;
		var sphereCeX=sphereCe[0];
		var sphereCeY=sphereCe[1];
		var sphereCeZ=sphereCe[2];
		var sphereR=sphere.radius;
		var boxMin=box.min;
		var boxMine=boxMin.elements;
		var boxMineX=boxMine[0];
		var boxMineY=boxMine[1];
		var boxMineZ=boxMine[2];
		var boxMax=box.max;
		var boxMaxe=boxMax.elements;
		var boxMaxeX=boxMaxe[0];
		var boxMaxeY=boxMaxe[1];
		var boxMaxeZ=boxMaxe[2];
		var _tempV30e=Collision._tempV30.elements;
		var _tempV30eX=_tempV30e[0];
		var _tempV30eY=_tempV30e[1];
		var _tempV30eZ=_tempV30e[2];
		if (!Collision.intersectsBoxAndSphere(box,sphere))
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		var radiusSquared=sphereR *sphereR;
		_tempV30eX=sphereCeX-boxMineX;
		_tempV30eY=sphereCeY-boxMaxeY;
		_tempV30eZ=sphereCeZ-boxMaxeZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		_tempV30eX=sphereCeX-boxMaxeX;
		_tempV30eY=sphereCeY-boxMaxeY;
		_tempV30eZ=sphereCeZ-boxMaxeZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		_tempV30eX=sphereCeX-boxMaxeX;
		_tempV30eY=sphereCeY-boxMineY;
		_tempV30eZ=sphereCeZ-boxMaxeZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		_tempV30eX=sphereCeX-boxMineX;
		_tempV30eY=sphereCeY-boxMineY;
		_tempV30eZ=sphereCeZ-boxMaxeZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		_tempV30eX=sphereCeX-boxMineX;
		_tempV30eY=sphereCeY-boxMaxeY;
		_tempV30eZ=sphereCeZ-boxMineZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		_tempV30eX=sphereCeX-boxMaxeX;
		_tempV30eY=sphereCeY-boxMaxeY;
		_tempV30eZ=sphereCeZ-boxMineZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		_tempV30eX=sphereCeX-boxMaxeX;
		_tempV30eY=sphereCeY-boxMineY;
		_tempV30eZ=sphereCeZ-boxMineZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		_tempV30eX=sphereCeX-boxMineX;
		_tempV30eY=sphereCeY-boxMineY;
		_tempV30eZ=sphereCeZ-boxMineZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		return /*laya.d3.math.ContainmentType.Contains*/1;
	}

	Collision.sphereContainsSphere=function(sphere1,sphere2){
		var sphere1R=sphere1.radius;
		var sphere2R=sphere2.radius;
		var distance=Vector3.distance(sphere1.center,sphere2.center);
		if (sphere1R+sphere2R < distance)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (sphere1R-sphere2R < distance)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		return /*laya.d3.math.ContainmentType.Contains*/1;
	}

	Collision.closestPointPointTriangle=function(point,vertex1,vertex2,vertex3,out){
		Vector3.subtract(vertex2,vertex1,Collision._tempV30);
		Vector3.subtract(vertex3,vertex1,Collision._tempV31);
		Vector3.subtract(point,vertex1,Collision._tempV32);
		Vector3.subtract(point,vertex2,Collision._tempV33);
		Vector3.subtract(point,vertex3,Collision._tempV34);
		var d1=Vector3.dot(Collision._tempV30,Collision._tempV32);
		var d2=Vector3.dot(Collision._tempV31,Collision._tempV32);
		var d3=Vector3.dot(Collision._tempV30,Collision._tempV33);
		var d4=Vector3.dot(Collision._tempV31,Collision._tempV33);
		var d5=Vector3.dot(Collision._tempV30,Collision._tempV34);
		var d6=Vector3.dot(Collision._tempV31,Collision._tempV34);
		if (d1 <=0 && d2 <=0){
			vertex1.cloneTo(out);
			return;
		}
		if (d3 >=0 && d4 <=d3){
			vertex2.cloneTo(out);
			return;
		};
		var vc=d1 *d4-d3 *d2;
		if (vc <=0 && d1 >=0 && d3 <=0){
			var v=d1 / (d1-d3);
			Vector3.scale(Collision._tempV30,v,out);
			Vector3.add(vertex1,out,out);
			return;
		}
		if (d6 >=0 && d5 <=d6){
			vertex3.cloneTo(out);
			return;
		};
		var vb=d5 *d2-d1 *d6;
		if (vb <=0 && d2 >=0 && d6 <=0){
			var w=d2 / (d2-d6);
			Vector3.scale(Collision._tempV31,w,out);
			Vector3.add(vertex1,out,out);
			return;
		};
		var va=d3 *d6-d5 *d4;
		if (va <=0 && (d4-d3)>=0 && (d5-d6)>=0){
			var w3=(d4-d3)/ ((d4-d3)+(d5-d6));
			Vector3.subtract(vertex3,vertex2,out);
			Vector3.scale(out,w3,out);
			Vector3.add(vertex2,out,out);
			return;
		};
		var denom=1 / (va+vb+vc);
		var v2=vb *denom;
		var w2=vc *denom;
		Vector3.scale(Collision._tempV30,v2,Collision._tempV35);
		Vector3.scale(Collision._tempV31,w2,Collision._tempV36);
		Vector3.add(Collision._tempV35,Collision._tempV36,out);
		Vector3.add(vertex1,out,out);
	}

	Collision.closestPointPlanePoint=function(plane,point,out){
		var planeN=plane.normal;
		var t=Vector3.dot(planeN,point)-plane.distance;
		Vector3.scale(planeN,t,Collision._tempV30);
		Vector3.subtract(point,Collision._tempV30,out);
	}

	Collision.closestPointBoxPoint=function(box,point,out){
		Vector3.max(point,box.min,Collision._tempV30);
		Vector3.min(Collision._tempV30,box.max,out);
	}

	Collision.closestPointSpherePoint=function(sphere,point,out){
		var sphereC=sphere.center;
		Vector3.subtract(point,sphereC,out);
		Vector3.normalize(out,out);
		Vector3.scale(out,sphere.radius,out);
		Vector3.add(out,sphereC,out);
	}

	Collision.closestPointSphereSphere=function(sphere1,sphere2,out){
		var sphere1C=sphere1.center;
		Vector3.subtract(sphere2.center,sphere1C,out);
		Vector3.normalize(out,out);
		Vector3.scale(out,sphere1.radius,out);
		Vector3.add(out,sphere1C,out);
	}

	__static(Collision,
	['_tempV30',function(){return this._tempV30=new Vector3();},'_tempV31',function(){return this._tempV31=new Vector3();},'_tempV32',function(){return this._tempV32=new Vector3();},'_tempV33',function(){return this._tempV33=new Vector3();},'_tempV34',function(){return this._tempV34=new Vector3();},'_tempV35',function(){return this._tempV35=new Vector3();},'_tempV36',function(){return this._tempV36=new Vector3();}
	]);
	return Collision;
})()


/**
*<code>ContainmentType</code> 类用于定义空间物体位置关系。
*/
//class laya.d3.math.ContainmentType
var ContainmentType=(function(){
	function ContainmentType(){}
	__class(ContainmentType,'laya.d3.math.ContainmentType');
	ContainmentType.Disjoint=0;
	ContainmentType.Contains=1;
	ContainmentType.Intersects=2;
	return ContainmentType;
})()


/**
*<code>MathUtils</code> 类用于创建数学工具。
*/
//class laya.d3.math.MathUtils3D
var MathUtils3D=(function(){
	/**
	*创建一个 <code>MathUtils</code> 实例。
	*/
	function MathUtils3D(){}
	__class(MathUtils3D,'laya.d3.math.MathUtils3D');
	MathUtils3D.isZero=function(v){
		return Math.abs(v)< MathUtils3D.zeroTolerance;
	}

	MathUtils3D.nearEqual=function(n1,n2){
		if (MathUtils3D.isZero(n1-n2))
			return true;
		return false;
	}

	MathUtils3D.fastInvSqrt=function(value){
		if (MathUtils3D.isZero(value))
			return value;
		return 1.0 / Math.sqrt(value);
	}

	__static(MathUtils3D,
	['zeroTolerance',function(){return this.zeroTolerance=1e-6;},'MaxValue',function(){return this.MaxValue=3.40282347e+38;},'MinValue',function(){return this.MinValue=-3.40282347e+38;}
	]);
	return MathUtils3D;
})()


/**
*<code>Matrix3x3</code> 类用于创建3x3矩阵。
*/
//class laya.d3.math.Matrix3x3
var Matrix3x3=(function(){
	function Matrix3x3(){
		/**矩阵元素数组*/
		//this.elements=null;
		var e=this.elements=new Float32Array(9);
		e[0]=1;
		e[1]=0;
		e[2]=0;
		e[3]=0;
		e[4]=1;
		e[5]=0;
		e[6]=0;
		e[7]=0;
		e[8]=1;
	}

	__class(Matrix3x3,'laya.d3.math.Matrix3x3');
	var __proto=Matrix3x3.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*计算3x3矩阵的行列式
	*@return 矩阵的行列式
	*/
	__proto.determinant=function(){
		var f=this.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		return a00 *(a22 *a11-a12 *a21)+a01 *(-a22 *a10+a12 *a20)+a02 *(a21 *a10-a11 *a20);
	}

	/**
	*通过一个二维向量转换3x3矩阵
	*@param tra 转换向量
	*@param out 输出矩阵
	*/
	__proto.translate=function(trans,out){
		var e=out.elements;
		var f=this.elements;
		var g=trans.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		var x=g[0],y=g[1];
		e[0]=a00;
		e[1]=a01;
		e[2]=a02;
		e[3]=a10;
		e[4]=a11;
		e[5]=a12;
		e[6]=x *a00+y *a10+a20;
		e[7]=x *a01+y *a11+a21;
		e[8]=x *a02+y *a12+a22;
	}

	/**
	*根据指定角度旋转3x3矩阵
	*@param rad 旋转角度
	*@param out 输出矩阵
	*/
	__proto.rotate=function(rad,out){
		var e=out.elements;
		var f=this.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		var s=Math.sin(rad);
		var c=Math.cos(rad);
		e[0]=c *a00+s *a10;
		e[1]=c *a01+s *a11;
		e[2]=c *a02+s *a12;
		e[3]=c *a10-s *a00;
		e[4]=c *a11-s *a01;
		e[5]=c *a12-s *a02;
		e[6]=a20;
		e[7]=a21;
		e[8]=a22;
	}

	/**
	*根据制定缩放3x3矩阵
	*@param scale 缩放值
	*@param out 输出矩阵
	*/
	__proto.scale=function(scale,out){
		var e=out.elements;
		var f=this.elements;
		var g=scale.elements;
		var x=g[0],y=g[1];
		e[0]=x *f[0];
		e[1]=x *f[1];
		e[2]=x *f[2];
		e[3]=y *f[3];
		e[4]=y *f[4];
		e[5]=y *f[5];
		e[6]=f[6];
		e[7]=f[7];
		e[8]=f[8];
	}

	/**
	*计算3x3矩阵的逆矩阵
	*@param out 输出的逆矩阵
	*/
	__proto.invert=function(out){
		var e=out.elements;
		var f=this.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		var b01=a22 *a11-a12 *a21;
		var b11=-a22 *a10+a12 *a20;
		var b21=a21 *a10-a11 *a20;
		var det=a00 *b01+a01 *b11+a02 *b21;
		if (!det){
			out=null;
		}
		det=1.0 / det;
		e[0]=b01 *det;
		e[1]=(-a22 *a01+a02 *a21)*det;
		e[2]=(a12 *a01-a02 *a11)*det;
		e[3]=b11 *det;
		e[4]=(a22 *a00-a02 *a20)*det;
		e[5]=(-a12 *a00+a02 *a10)*det;
		e[6]=b21 *det;
		e[7]=(-a21 *a00+a01 *a20)*det;
		e[8]=(a11 *a00-a01 *a10)*det;
	}

	/**
	*计算3x3矩阵的转置矩阵
	*@param out 输出矩阵
	*/
	__proto.transpose=function(out){
		var e=out.elements;
		var f=this.elements;
		if (out===this){
			var a01=f[1],a02=f[2],a12=f[5];
			e[1]=f[3];
			e[2]=f[6];
			e[3]=a01;
			e[5]=f[7];
			e[6]=a02;
			e[7]=a12;
			}else {
			e[0]=f[0];
			e[1]=f[3];
			e[2]=f[6];
			e[3]=f[1];
			e[4]=f[4];
			e[5]=f[7];
			e[6]=f[2];
			e[7]=f[5];
			e[8]=f[8];
		}
	}

	/**设置已有的矩阵为单位矩阵*/
	__proto.identity=function(){
		var e=this.elements;
		e[0]=1;
		e[1]=0;
		e[2]=0;
		e[3]=0;
		e[4]=1;
		e[5]=0;
		e[6]=0;
		e[7]=0;
		e[8]=1;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var i,s,d;
		s=this.elements;
		d=destObject.elements;
		if (s===d){
			return;
		}
		for (i=0;i < 9;++i){
			d[i]=s[i];
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	Matrix3x3.createFromTranslation=function(trans,out){
		var e=out.elements;
		var g=trans.elements;
		out[0]=1;
		out[1]=0;
		out[2]=0;
		out[3]=0;
		out[4]=1;
		out[5]=0;
		out[6]=g[0];
		out[7]=g[1];
		out[8]=1;
	}

	Matrix3x3.createFromRotation=function(rad,out){
		var e=out.elements;
		var s=Math.sin(rad),c=Math.cos(rad);
		e[0]=c;
		e[1]=s;
		e[2]=0;
		e[3]=-s;
		e[4]=c;
		e[5]=0;
		e[6]=0;
		e[7]=0;
		e[8]=1;
	}

	Matrix3x3.createFromScaling=function(scale,out){
		var e=out.elements;
		var g=scale.elements;
		e[0]=g[0];
		e[1]=0;
		e[2]=0;
		e[3]=0;
		e[4]=g[1];
		e[5]=0;
		e[6]=0;
		e[7]=0;
		e[8]=1;
	}

	Matrix3x3.createFromMatrix4x4=function(sou,out){
		out[0]=sou[0];
		out[1]=sou[1];
		out[2]=sou[2];
		out[3]=sou[4];
		out[4]=sou[5];
		out[5]=sou[6];
		out[6]=sou[8];
		out[7]=sou[9];
		out[8]=sou[10];
	}

	Matrix3x3.multiply=function(left,right,out){
		var e=out.elements;
		var f=left.elements;
		var g=right.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		var b00=g[0],b01=g[1],b02=g[2];
		var b10=g[3],b11=g[4],b12=g[5];
		var b20=g[6],b21=g[7],b22=g[8];
		e[0]=b00 *a00+b01 *a10+b02 *a20;
		e[1]=b00 *a01+b01 *a11+b02 *a21;
		e[2]=b00 *a02+b01 *a12+b02 *a22;
		e[3]=b10 *a00+b11 *a10+b12 *a20;
		e[4]=b10 *a01+b11 *a11+b12 *a21;
		e[5]=b10 *a02+b11 *a12+b12 *a22;
		e[6]=b20 *a00+b21 *a10+b22 *a20;
		e[7]=b20 *a01+b21 *a11+b22 *a21;
		e[8]=b20 *a02+b21 *a12+b22 *a22;
	}

	Matrix3x3.lookAt=function(eye,target,up,out){
		Vector3.subtract(eye,target,Matrix3x3._tempV30);
		Vector3.normalize(Matrix3x3._tempV30,Matrix3x3._tempV30);
		Vector3.cross(up,Matrix3x3._tempV30,Matrix3x3._tempV31);
		Vector3.normalize(Matrix3x3._tempV31,Matrix3x3._tempV31);
		Vector3.cross(Matrix3x3._tempV30,Matrix3x3._tempV31,Matrix3x3._tempV32);
		var v0e=Matrix3x3._tempV30.elements;
		var v1e=Matrix3x3._tempV31.elements;
		var v2e=Matrix3x3._tempV32.elements;
		var me=out.elements;
		me[0]=v1e[0];
		me[3]=v1e[1];
		me[6]=v1e[2];
		me[1]=v2e[0];
		me[4]=v2e[1];
		me[7]=v2e[2];
		me[2]=v0e[0];
		me[5]=v0e[1];
		me[8]=v0e[2];
	}

	Matrix3x3.DEFAULT=new Matrix3x3();
	__static(Matrix3x3,
	['_tempV30',function(){return this._tempV30=new Vector3();},'_tempV31',function(){return this._tempV31=new Vector3();},'_tempV32',function(){return this._tempV32=new Vector3();}
	]);
	return Matrix3x3;
})()


/**
*<code>Matrix4x4</code> 类用于创建4x4矩阵。
*/
//class laya.d3.math.Matrix4x4
var Matrix4x4=(function(){
	function Matrix4x4(m11,m12,m13,m14,m21,m22,m23,m24,m31,m32,m33,m34,m41,m42,m43,m44){
		/**矩阵元素数组*/
		//this.elements=null;
		(m11===void 0)&& (m11=1);
		(m12===void 0)&& (m12=0);
		(m13===void 0)&& (m13=0);
		(m14===void 0)&& (m14=0);
		(m21===void 0)&& (m21=0);
		(m22===void 0)&& (m22=1);
		(m23===void 0)&& (m23=0);
		(m24===void 0)&& (m24=0);
		(m31===void 0)&& (m31=0);
		(m32===void 0)&& (m32=0);
		(m33===void 0)&& (m33=1);
		(m34===void 0)&& (m34=0);
		(m41===void 0)&& (m41=0);
		(m42===void 0)&& (m42=0);
		(m43===void 0)&& (m43=0);
		(m44===void 0)&& (m44=1);
		var e=this.elements=new Float32Array(16);
		e[0]=m11;
		e[1]=m12;
		e[2]=m13;
		e[3]=m14;
		e[4]=m21;
		e[5]=m22;
		e[6]=m23;
		e[7]=m24;
		e[8]=m31;
		e[9]=m32;
		e[10]=m33;
		e[11]=m34;
		e[12]=m41;
		e[13]=m42;
		e[14]=m43;
		e[15]=m44;
	}

	__class(Matrix4x4,'laya.d3.math.Matrix4x4');
	var __proto=Matrix4x4.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	__proto.getElementByRowColumn=function(row,column){
		if (row < 0 || row > 3)
			throw new Error("row","Rows and columns for matrices run from 0 to 3, inclusive.");
		if (column < 0 || column > 3)
			throw new Error("column","Rows and columns for matrices run from 0 to 3, inclusive.");
		return this.elements[(row *4)+column];
	}

	__proto.setElementByRowColumn=function(row,column,value){
		if (row < 0 || row > 3)
			throw new Error("row","Rows and columns for matrices run from 0 to 3, inclusive.");
		if (column < 0 || column > 3)
			throw new Error("column","Rows and columns for matrices run from 0 to 3, inclusive.");
		this.elements[(row *4)+column]=value;
	}

	/**
	*判断两个4x4矩阵的值是否相等。
	*@param other 4x4矩阵
	*/
	__proto.equalsOtherMatrix=function(other){
		var e=this.elements;
		var oe=other.elements;
		return (MathUtils3D.nearEqual(e[0],oe[0])&& MathUtils3D.nearEqual(e[1],oe[1])&& MathUtils3D.nearEqual(e[2],oe[2])&& MathUtils3D.nearEqual(e[3],oe[3])&& MathUtils3D.nearEqual(e[4],oe[4])&& MathUtils3D.nearEqual(e[5],oe[5])&& MathUtils3D.nearEqual(e[6],oe[6])&& MathUtils3D.nearEqual(e[7],oe[7])&& MathUtils3D.nearEqual(e[8],oe[8])&& MathUtils3D.nearEqual(e[9],oe[9])&& MathUtils3D.nearEqual(e[10],oe[10])&& MathUtils3D.nearEqual(e[11],oe[11])&& MathUtils3D.nearEqual(e[12],oe[12])&& MathUtils3D.nearEqual(e[13],oe[13])&& MathUtils3D.nearEqual(e[14],oe[14])&& MathUtils3D.nearEqual(e[15],oe[15]));
	}

	/**
	*分解矩阵为平移向量、旋转四元数、缩放向量。
	*@param translation 平移向量。
	*@param rotation 旋转四元数。
	*@param scale 缩放向量。
	*@return 是否分解成功。
	*/
	__proto.decomposeTransRotScale=function(translation,rotation,scale){
		var rotationMatrix=Matrix4x4._tempMatrix4x4;
		if (this.decomposeTransRotMatScale(translation,rotationMatrix,scale)){
			Quaternion.createFromMatrix4x4(rotationMatrix,rotation);
			return true;
			}else {
			rotation.identity();
			return false;
		}
	}

	/**
	*分解矩阵为平移向量、旋转矩阵、缩放向量。
	*@param translation 平移向量。
	*@param rotationMatrix 旋转矩阵。
	*@param scale 缩放向量。
	*@return 是否分解成功。
	*/
	__proto.decomposeTransRotMatScale=function(translation,rotationMatrix,scale){
		var e=this.elements;
		var te=translation.elements;
		var re=rotationMatrix.elements;
		var se=scale.elements;
		te[0]=e[12];
		te[1]=e[13];
		te[2]=e[14];
		var m11=e[0],m12=e[1],m13=e[2];
		var m21=e[4],m22=e[5],m23=e[6];
		var m31=e[8],m32=e[9],m33=e[10];
		var sX=se[0]=Math.sqrt((m11 *m11)+(m12 *m12)+(m13 *m13));
		var sY=se[1]=Math.sqrt((m21 *m21)+(m22 *m22)+(m23 *m23));
		var sZ=se[2]=Math.sqrt((m31 *m31)+(m32 *m32)+(m33 *m33));
		if (MathUtils3D.isZero(sX)|| MathUtils3D.isZero(sY)|| MathUtils3D.isZero(sZ)){
			re[1]=re[2]=re[3]=re[4]=re[6]=re[7]=re[8]=re[9]=re[11]=re[12]=re[13]=re[14]=0;
			re[0]=re[5]=re[10]=re[15]=1;
			return false;
		};
		var at=Matrix4x4._tempVector0;
		var atE=at.elements;
		atE[0]=m31 / sZ;
		atE[1]=m32 / sZ;
		atE[2]=m33 / sZ;
		var tempRight=Matrix4x4._tempVector1;
		var tempRightE=tempRight.elements;
		tempRightE[0]=m11 / sX;
		tempRightE[1]=m12 / sX;
		tempRightE[2]=m13 / sX;
		var up=Matrix4x4._tempVector2;
		Vector3.cross(at,tempRight,up);
		var right=Matrix4x4._tempVector1;
		Vector3.cross(up,at,right);
		re[3]=re[7]=re[11]=re[12]=re[13]=re[14]=0;
		re[15]=1;
		re[0]=right.x;
		re[1]=right.y;
		re[2]=right.z;
		re[4]=up.x;
		re[5]=up.y;
		re[6]=up.z;
		re[8]=at.x;
		re[9]=at.y;
		re[10]=at.z;
		((re[0] *m11+re[1] *m12+re[2] *m13)< 0.0)&& (se[0]=-sX);
		((re[4] *m21+re[5] *m22+re[6] *m23)< 0.0)&& (se[1]=-sY);
		((re[8] *m31+re[9] *m32+re[10] *m33)< 0.0)&& (se[2]=-sZ);
		return true;
	}

	/**
	*分解旋转矩阵的旋转为YawPitchRoll欧拉角。
	*@param out float yaw
	*@param out float pitch
	*@param out float roll
	*@return
	*/
	__proto.decomposeYawPitchRoll=function(yawPitchRoll){
		var yawPitchRollE=yawPitchRoll.elements;
		var pitch=Math.asin(-this.elements[9]);
		yawPitchRollE[1]=pitch;
		var test=Math.cos(pitch);
		if (test > MathUtils3D.zeroTolerance){
			yawPitchRollE[2]=Math.atan2(this.elements[1],this.elements[5]);
			yawPitchRollE[0]=Math.atan2(this.elements[8],this.elements[10]);
			}else {
			yawPitchRollE[2]=Math.atan2(-this.elements[4],this.elements[0]);
			yawPitchRollE[0]=0.0;
		}
	}

	/**归一化矩阵 */
	__proto.normalize=function(){
		var v=this.elements;
		var c=v[0],d=v[1],e=v[2],g=Math.sqrt(c *c+d *d+e *e);
		if (g){
			if (g==1)
				return;
			}else {
			v[0]=0;
			v[1]=0;
			v[2]=0;
			return;
		}
		g=1 / g;
		v[0]=c *g;
		v[1]=d *g;
		v[2]=e *g;
	}

	/**计算矩阵的转置矩阵*/
	__proto.transpose=function(){
		var e,t;
		e=this.elements;
		t=e[1];
		e[1]=e[4];
		e[4]=t;
		t=e[2];
		e[2]=e[8];
		e[8]=t;
		t=e[3];
		e[3]=e[12];
		e[12]=t;
		t=e[6];
		e[6]=e[9];
		e[9]=t;
		t=e[7];
		e[7]=e[13];
		e[13]=t;
		t=e[11];
		e[11]=e[14];
		e[14]=t;
		return this;
	}

	/**
	*计算一个矩阵的逆矩阵
	*@param out 输出矩阵
	*/
	__proto.invert=function(out){
		var ae=this.elements;
		var oe=out.elements;
		var a00=ae[0],a01=ae[1],a02=ae[2],a03=ae[3],a10=ae[4],a11=ae[5],a12=ae[6],a13=ae[7],a20=ae[8],a21=ae[9],a22=ae[10],a23=ae[11],a30=ae[12],a31=ae[13],a32=ae[14],a33=ae[15],
		b00=a00 *a11-a01 *a10,b01=a00 *a12-a02 *a10,b02=a00 *a13-a03 *a10,b03=a01 *a12-a02 *a11,b04=a01 *a13-a03 *a11,b05=a02 *a13-a03 *a12,b06=a20 *a31-a21 *a30,b07=a20 *a32-a22 *a30,b08=a20 *a33-a23 *a30,b09=a21 *a32-a22 *a31,b10=a21 *a33-a23 *a31,b11=a22 *a33-a23 *a32,
		det=b00 *b11-b01 *b10+b02 *b09+b03 *b08-b04 *b07+b05 *b06;
		if (Math.abs(det)===0.0){
			return;
		}
		det=1.0 / det;
		oe[0]=(a11 *b11-a12 *b10+a13 *b09)*det;
		oe[1]=(a02 *b10-a01 *b11-a03 *b09)*det;
		oe[2]=(a31 *b05-a32 *b04+a33 *b03)*det;
		oe[3]=(a22 *b04-a21 *b05-a23 *b03)*det;
		oe[4]=(a12 *b08-a10 *b11-a13 *b07)*det;
		oe[5]=(a00 *b11-a02 *b08+a03 *b07)*det;
		oe[6]=(a32 *b02-a30 *b05-a33 *b01)*det;
		oe[7]=(a20 *b05-a22 *b02+a23 *b01)*det;
		oe[8]=(a10 *b10-a11 *b08+a13 *b06)*det;
		oe[9]=(a01 *b08-a00 *b10-a03 *b06)*det;
		oe[10]=(a30 *b04-a31 *b02+a33 *b00)*det;
		oe[11]=(a21 *b02-a20 *b04-a23 *b00)*det;
		oe[12]=(a11 *b07-a10 *b09-a12 *b06)*det;
		oe[13]=(a00 *b09-a01 *b07+a02 *b06)*det;
		oe[14]=(a31 *b01-a30 *b03-a32 *b00)*det;
		oe[15]=(a20 *b03-a21 *b01+a22 *b00)*det;
	}

	/**设置矩阵为单位矩阵*/
	__proto.identity=function(){
		var e=this.elements;
		e[1]=e[2]=e[3]=e[4]=e[6]=e[7]=e[8]=e[9]=e[11]=e[12]=e[13]=e[14]=0;
		e[0]=e[5]=e[10]=e[15]=1;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var i,s,d;
		s=this.elements;
		d=destObject.elements;
		if (s===d){
			return;
		}
		for (i=0;i < 16;++i){
			d[i]=s[i];
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	/**
	*获取平移向量。
	*@param out 平移向量。
	*/
	__proto.getTranslationVector=function(out){
		var me=this.elements;
		var te=out.elements;
		te[0]=me[12];
		te[1]=me[13];
		te[2]=me[14];
	}

	/**
	*设置平移向量。
	*@param translate 平移向量。
	*/
	__proto.setTranslationVector=function(translate){
		var me=this.elements;
		var ve=translate.elements;
		me[12]=ve[0];
		me[13]=ve[1];
		me[14]=ve[2];
	}

	/**
	*获取前向量。
	*@param out 前向量。
	*/
	__proto.getForward=function(out){
		var me=this.elements;
		var te=out.elements;
		te[0]=-me[8];
		te[1]=-me[9];
		te[2]=-me[10];
	}

	/**
	*设置前向量。
	*@param forward 前向量。
	*/
	__proto.setForward=function(forward){
		var me=this.elements;
		var ve=forward.elements;
		me[8]=-ve[0];
		me[9]=-ve[1];
		me[10]=-ve[2];
	}

	Matrix4x4.createRotationX=function(rad,out){
		var oe=out.elements;
		var s=Math.sin(rad),c=Math.cos(rad);
		oe[1]=oe[2]=oe[3]=oe[4]=oe[7]=oe[8]=oe[11]=oe[12]=oe[13]=oe[14]=0;
		oe[0]=oe[15]=1;
		oe[5]=oe[10]=c;
		oe[6]=s;
		oe[9]=-s;
	}

	Matrix4x4.createRotationY=function(rad,out){
		var oe=out.elements;
		var s=Math.sin(rad),c=Math.cos(rad);
		oe[1]=oe[3]=oe[4]=oe[6]=oe[7]=oe[9]=oe[11]=oe[12]=oe[13]=oe[14]=0;
		oe[5]=oe[15]=1;
		oe[0]=oe[10]=c;
		oe[2]=-s;
		oe[8]=s;
	}

	Matrix4x4.createRotationZ=function(rad,out){
		var oe=out.elements;
		var s=Math.sin(rad),c=Math.cos(rad);
		oe[2]=oe[3]=oe[6]=oe[7]=oe[8]=oe[9]=oe[11]=oe[12]=oe[13]=oe[14]=0;
		oe[10]=oe[15]=1;
		oe[0]=oe[5]=c;
		oe[1]=s;
		oe[4]=-s;
	}

	Matrix4x4.createRotationYawPitchRoll=function(yaw,pitch,roll,result){
		Quaternion.createFromYawPitchRoll(yaw,pitch,roll,Matrix4x4._tempQuaternion);
		Matrix4x4.createRotationQuaternion(Matrix4x4._tempQuaternion,result);
	}

	Matrix4x4.createRotationAxis=function(axis,angle,result){
		var axisE=axis.elements;
		var x=axisE[0];
		var y=axisE[1];
		var z=axisE[2];
		var cos=Math.cos(angle);
		var sin=Math.sin(angle);
		var xx=x *x;
		var yy=y *y;
		var zz=z *z;
		var xy=x *y;
		var xz=x *z;
		var yz=y *z;
		var resultE=result.elements;
		resultE[3]=resultE[7]=resultE[11]=resultE[12]=resultE[13]=resultE[14]=0;
		resultE[15]=1.0;
		resultE[0]=xx+(cos *(1.0-xx));
		resultE[1]=(xy-(cos *xy))+(sin *z);
		resultE[2]=(xz-(cos *xz))-(sin *y);
		resultE[4]=(xy-(cos *xy))-(sin *z);
		resultE[5]=yy+(cos *(1.0-yy));
		resultE[6]=(yz-(cos *yz))+(sin *x);
		resultE[8]=(xz-(cos *xz))+(sin *y);
		resultE[9]=(yz-(cos *yz))-(sin *x);
		resultE[10]=zz+(cos *(1.0-zz));
	}

	Matrix4x4.createRotationQuaternion=function(rotation,result){
		var rotationE=rotation.elements;
		var resultE=result.elements;
		var rotationX=rotationE[0];
		var rotationY=rotationE[1];
		var rotationZ=rotationE[2];
		var rotationW=rotationE[3];
		var xx=rotationX *rotationX;
		var yy=rotationY *rotationY;
		var zz=rotationZ *rotationZ;
		var xy=rotationX *rotationY;
		var zw=rotationZ *rotationW;
		var zx=rotationZ *rotationX;
		var yw=rotationY *rotationW;
		var yz=rotationY *rotationZ;
		var xw=rotationX *rotationW;
		resultE[3]=resultE[7]=resultE[11]=resultE[12]=resultE[13]=resultE[14]=0;
		resultE[15]=1.0;
		resultE[0]=1.0-(2.0 *(yy+zz));
		resultE[1]=2.0 *(xy+zw);
		resultE[2]=2.0 *(zx-yw);
		resultE[4]=2.0 *(xy-zw);
		resultE[5]=1.0-(2.0 *(zz+xx));
		resultE[6]=2.0 *(yz+xw);
		resultE[8]=2.0 *(zx+yw);
		resultE[9]=2.0 *(yz-xw);
		resultE[10]=1.0-(2.0 *(yy+xx));
	}

	Matrix4x4.createTranslate=function(trans,out){
		var te=trans.elements;
		var oe=out.elements;
		oe[4]=oe[8]=oe[1]=oe[9]=oe[2]=oe[6]=oe[3]=oe[7]=oe[11]=0;
		oe[0]=oe[5]=oe[10]=oe[15]=1;
		oe[12]=te[0];
		oe[13]=te[1];
		oe[14]=te[2];
	}

	Matrix4x4.createScaling=function(scale,out){
		var se=scale.elements;
		var oe=out.elements;
		oe[0]=se[0];
		oe[5]=se[1];
		oe[10]=se[2];
		oe[1]=oe[4]=oe[8]=oe[12]=oe[9]=oe[13]=oe[2]=oe[6]=oe[14]=oe[3]=oe[7]=oe[11]=0;
		oe[15]=1;
	}

	Matrix4x4.multiply=function(left,right,out){
		var i,e,a,b,ai0,ai1,ai2,ai3;
		e=out.elements;
		a=left.elements;
		b=right.elements;
		if (e===b){
			b=new Float32Array(16);
			for (i=0;i < 16;++i){
				b[i]=e[i];
			}
		}
		for (i=0;i < 4;i++){
			ai0=a[i];
			ai1=a[i+4];
			ai2=a[i+8];
			ai3=a[i+12];
			e[i]=ai0 *b[0]+ai1 *b[1]+ai2 *b[2]+ai3 *b[3];
			e[i+4]=ai0 *b[4]+ai1 *b[5]+ai2 *b[6]+ai3 *b[7];
			e[i+8]=ai0 *b[8]+ai1 *b[9]+ai2 *b[10]+ai3 *b[11];
			e[i+12]=ai0 *b[12]+ai1 *b[13]+ai2 *b[14]+ai3 *b[15];
		}
	}

	Matrix4x4.createFromQuaternion=function(rotation,out){
		var e=out.elements;
		var q=rotation.elements;
		var x=q[0],y=q[1],z=q[2],w=q[3];
		var x2=x+x;
		var y2=y+y;
		var z2=z+z;
		var xx=x *x2;
		var yx=y *x2;
		var yy=y *y2;
		var zx=z *x2;
		var zy=z *y2;
		var zz=z *z2;
		var wx=w *x2;
		var wy=w *y2;
		var wz=w *z2;
		e[0]=1-yy-zz;
		e[1]=yx+wz;
		e[2]=zx-wy;
		e[3]=0;
		e[4]=yx-wz;
		e[5]=1-xx-zz;
		e[6]=zy+wx;
		e[7]=0;
		e[8]=zx+wy;
		e[9]=zy-wx;
		e[10]=1-xx-yy;
		e[11]=0;
		e[12]=0;
		e[13]=0;
		e[14]=0;
		e[15]=1;
	}

	Matrix4x4.createAffineTransformation=function(trans,rot,scale,out){
		var te=trans.elements;
		var re=rot.elements;
		var se=scale.elements;
		var oe=out.elements;
		var x=re[0],y=re[1],z=re[2],w=re[3],x2=x+x,y2=y+y,z2=z+z;
		var xx=x *x2,xy=x *y2,xz=x *z2,yy=y *y2,yz=y *z2,zz=z *z2;
		var wx=w *x2,wy=w *y2,wz=w *z2,sx=se[0],sy=se[1],sz=se[2];
		oe[0]=(1-(yy+zz))*sx;
		oe[1]=(xy+wz)*sx;
		oe[2]=(xz-wy)*sx;
		oe[3]=0;
		oe[4]=(xy-wz)*sy;
		oe[5]=(1-(xx+zz))*sy;
		oe[6]=(yz+wx)*sy;
		oe[7]=0;
		oe[8]=(xz+wy)*sz;
		oe[9]=(yz-wx)*sz;
		oe[10]=(1-(xx+yy))*sz;
		oe[11]=0;
		oe[12]=te[0];
		oe[13]=te[1];
		oe[14]=te[2];
		oe[15]=1;
	}

	Matrix4x4.createLookAt=function(eye,target,up,out){
		var oE=out.elements;
		var xaxis=Matrix4x4._tempVector0;
		var yaxis=Matrix4x4._tempVector1;
		var zaxis=Matrix4x4._tempVector2;
		Vector3.subtract(eye,target,zaxis);
		Vector3.normalize(zaxis,zaxis);
		Vector3.cross(up,zaxis,xaxis);
		Vector3.normalize(xaxis,xaxis);
		Vector3.cross(zaxis,xaxis,yaxis);
		out.identity();
		oE[0]=xaxis.x;
		oE[4]=xaxis.y;
		oE[8]=xaxis.z;
		oE[1]=yaxis.x;
		oE[5]=yaxis.y;
		oE[9]=yaxis.z;
		oE[2]=zaxis.x;
		oE[6]=zaxis.y;
		oE[10]=zaxis.z;
		oE[12]=-Vector3.dot(xaxis,eye);
		oE[13]=-Vector3.dot(yaxis,eye);
		oE[14]=-Vector3.dot(zaxis,eye);
	}

	Matrix4x4.createPerspective=function(fov,aspect,near,far,out){
		var oe=out.elements;
		var f=1.0 / Math.tan(fov / 2),nf=1 / (near-far);
		oe[0]=f / aspect;
		oe[5]=f;
		oe[10]=(far+near)*nf;
		oe[11]=-1;
		oe[14]=(2 *far *near)*nf;
		oe[1]=oe[2]=oe[3]=oe[4]=oe[6]=oe[7]=oe[8]=oe[9]=oe[12]=oe[13]=oe[15]=0;
	}

	Matrix4x4.createOrthoOffCenterRH=function(left,right,bottom,top,near,far,out){
		var oe=out.elements;
		var lr=1 / (left-right);
		var bt=1 / (bottom-top);
		var nf=1 / (near-far);
		oe[1]=oe[2]=oe[3]=oe[4]=oe[6]=oe[7]=oe[8]=oe[9]=oe[11]=0;
		oe[15]=1;
		oe[0]=-2 *lr;
		oe[5]=-2 *bt;
		oe[10]=2 *nf;
		oe[12]=(left+right)*lr;
		oe[13]=(top+bottom)*bt;
		oe[14]=(far+near)*nf;
	}

	Matrix4x4.translation=function(v3,out){
		var ve=v3.elements;
		var oe=out.elements;
		oe[0]=oe[5]=oe[10]=oe[15]=1;
		oe[12]=ve[0];
		oe[13]=ve[1];
		oe[14]=ve[2];
	}

	__static(Matrix4x4,
	['_tempMatrix4x4',function(){return this._tempMatrix4x4=new Matrix4x4();},'_tempVector0',function(){return this._tempVector0=new Vector3();},'_tempVector1',function(){return this._tempVector1=new Vector3();},'_tempVector2',function(){return this._tempVector2=new Vector3();},'_tempQuaternion',function(){return this._tempQuaternion=new Quaternion();},'DEFAULT',function(){return this.DEFAULT=new Matrix4x4();},'ZERO',function(){return this.ZERO=new Matrix4x4(
		0,0,0,0,
		0,0,0,0,
		0,0,0,0,
		0,0,0,0);}
	]);
	return Matrix4x4;
})()


/**
*<code>OrientedBoundBox</code> 类用于创建OBB包围盒。
*/
//class laya.d3.math.OrientedBoundBox
var OrientedBoundBox=(function(){
	function OrientedBoundBox(extents,transformation){
		/**每个轴长度的一半*/
		this.extents=null;
		/**这个矩阵表示包围盒的位置和缩放,它的平移向量表示该包围盒的中心*/
		this.transformation=null;
		this.extents=extents;
		this.transformation=transformation;
	}

	__class(OrientedBoundBox,'laya.d3.math.OrientedBoundBox');
	var __proto=OrientedBoundBox.prototype;
	/**
	*获取OBB包围盒的8个顶点。
	*@param corners 返回顶点的输出队列。
	*/
	__proto.getCorners=function(corners){
		var xve=OrientedBoundBox._tempV30.elements;
		var yve=OrientedBoundBox._tempV31.elements;
		var zve=OrientedBoundBox._tempV32.elements;
		var extentsE=this.extents.elements;
		xve[0]=extentsE[0];
		xve[1]=xve[2]=0;
		yve[1]=extentsE[1];
		yve[0]=yve[2]=0;
		zve[2]=extentsE[2];
		zve[0]=zve[1]=0;
		Vector3.TransformNormal(OrientedBoundBox._tempV30,this.transformation,OrientedBoundBox._tempV30);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV31);
		Vector3.TransformNormal(OrientedBoundBox._tempV32,this.transformation,OrientedBoundBox._tempV32);
		var center=OrientedBoundBox._tempV33;
		this.transformation.getTranslationVector(center);
		corners.length=8;
		Vector3.add(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[0]);
		Vector3.add(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[1]);
		Vector3.subtract(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[2]);
		Vector3.subtract(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[3]);
		Vector3.add(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[4]);
		Vector3.add(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[5]);
		Vector3.subtract(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[6]);
		Vector3.subtract(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[7]);
	}

	/**
	*变换该包围盒的矩阵信息。
	*@param mat 矩阵
	*/
	__proto.transform=function(mat){
		Matrix4x4.multiply(this.transformation,mat,this.transformation);
	}

	/**
	*缩放该包围盒
	*@param scaling 各轴的缩放比。
	*/
	__proto.scale=function(scaling){
		Vector3.multiply(this.extents,scaling,this.extents);
	}

	/**
	*平移该包围盒。
	*@param translation 平移参数
	*/
	__proto.translate=function(translation){
		this.transformation.getTranslationVector(OrientedBoundBox._tempV30);
		Vector3.add(OrientedBoundBox._tempV30,translation,OrientedBoundBox._tempV31);
		this.transformation.setTranslationVector(OrientedBoundBox._tempV31);
	}

	/**
	*该包围盒的尺寸。
	*@param out 输出
	*/
	__proto.Size=function(out){
		Vector3.scale(this.extents,2,out);
	}

	/**
	*该包围盒需要考虑的尺寸
	*@param out 输出
	*/
	__proto.getSize=function(out){
		var extentsE=this.extents.elements;
		OrientedBoundBox._tempV30.x=extentsE[0];
		OrientedBoundBox._tempV31.y=extentsE[1];
		OrientedBoundBox._tempV32.z=extentsE[2];
		Vector3.TransformNormal(OrientedBoundBox._tempV30,this.transformation,OrientedBoundBox._tempV30);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV31);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV32);
		var oe=out.elements;
		oe[0]=Vector3.scalarLength(OrientedBoundBox._tempV30);
		oe[1]=Vector3.scalarLength(OrientedBoundBox._tempV31);
		oe[2]=Vector3.scalarLength(OrientedBoundBox._tempV32);
	}

	/**
	*该包围盒需要考虑尺寸的平方
	*@param out 输出
	*/
	__proto.getSizeSquared=function(out){
		var extentsE=this.extents.elements;
		OrientedBoundBox._tempV30.x=extentsE[0];
		OrientedBoundBox._tempV31.y=extentsE[1];
		OrientedBoundBox._tempV32.z=extentsE[2];
		Vector3.TransformNormal(OrientedBoundBox._tempV30,this.transformation,OrientedBoundBox._tempV30);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV31);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV32);
		var oe=out.elements;
		oe[0]=Vector3.scalarLengthSquared(OrientedBoundBox._tempV30);
		oe[1]=Vector3.scalarLengthSquared(OrientedBoundBox._tempV31);
		oe[2]=Vector3.scalarLengthSquared(OrientedBoundBox._tempV32);
	}

	/**
	*该包围盒的几何中心
	*/
	__proto.getCenter=function(center){
		this.transformation.getTranslationVector(center);
	}

	/**
	*该包围盒是否包含空间中一点
	*@param point 点
	*@return 返回位置关系
	*/
	__proto.containsPoint=function(point){
		var extentsE=this.extents.elements;
		var extentsEX=extentsE[0];
		var extentsEY=extentsE[1];
		var extentsEZ=extentsE[2];
		this.transformation.invert(OrientedBoundBox._tempM0);
		Vector3.transformCoordinate(point,OrientedBoundBox._tempM0,OrientedBoundBox._tempV30);
		var _tempV30e=OrientedBoundBox._tempV30.elements;
		var _tempV30ex=Math.abs(_tempV30e[0]);
		var _tempV30ey=Math.abs(_tempV30e[1]);
		var _tempV30ez=Math.abs(_tempV30e[2]);
		if (MathUtils3D.nearEqual(_tempV30ex,extentsEX)&& MathUtils3D.nearEqual(_tempV30ey,extentsEY)&& MathUtils3D.nearEqual(_tempV30ez,extentsEZ))
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		if (_tempV30ex < extentsEX && _tempV30ey < extentsEY && _tempV30ez < extentsEZ)
			return /*laya.d3.math.ContainmentType.Contains*/1;
		else
		return /*laya.d3.math.ContainmentType.Disjoint*/0;
	}

	/**
	*该包围盒是否包含空间中多点
	*@param point 点
	*@return 返回位置关系
	*/
	__proto.containsPoints=function(points){
		var extentse=this.extents.elements;
		var extentsex=extentse[0];
		var extentsey=extentse[1];
		var extentsez=extentse[2];
		this.transformation.invert(OrientedBoundBox._tempM0);
		var containsAll=true;
		var containsAny=false;
		for (var i=0;i < points.length;i++){
			Vector3.transformCoordinate(points[i],OrientedBoundBox._tempM0,OrientedBoundBox._tempV30);
			var _tempV30e=OrientedBoundBox._tempV30.elements;
			var _tempV30ex=Math.abs(_tempV30e[0]);
			var _tempV30ey=Math.abs(_tempV30e[1]);
			var _tempV30ez=Math.abs(_tempV30e[2]);
			if (MathUtils3D.nearEqual(_tempV30ex,extentsex)&& MathUtils3D.nearEqual(_tempV30ey,extentsey)&& MathUtils3D.nearEqual(_tempV30ez,extentsez))
				containsAny=true;
			if (_tempV30ex < extentsex && _tempV30ey < extentsey && _tempV30ez < extentsez)
				containsAny=true;
			else
			containsAll=false;
		}
		if (containsAll)
			return /*laya.d3.math.ContainmentType.Contains*/1;
		else if (containsAny)
		return /*laya.d3.math.ContainmentType.Intersects*/2;
		else
		return /*laya.d3.math.ContainmentType.Disjoint*/0;
	}

	/**
	*该包围盒是否包含空间中一包围球
	*@param sphere 包围球
	*@param ignoreScale 是否考虑该包围盒的缩放
	*@return 返回位置关系
	*/
	__proto.containsSphere=function(sphere,ignoreScale){
		(ignoreScale===void 0)&& (ignoreScale=false);
		var extentsE=this.extents.elements;
		var extentsEX=extentsE[0];
		var extentsEY=extentsE[1];
		var extentsEZ=extentsE[2];
		var sphereR=sphere.radius;
		this.transformation.invert(OrientedBoundBox._tempM0);
		Vector3.transformCoordinate(sphere.center,OrientedBoundBox._tempM0,OrientedBoundBox._tempV30);
		var locRadius=NaN;
		if (ignoreScale){
			locRadius=sphereR;
			}else {
			Vector3.scale(Vector3.UnitX,sphereR,OrientedBoundBox._tempV31);
			Vector3.TransformNormal(OrientedBoundBox._tempV31,OrientedBoundBox._tempM0,OrientedBoundBox._tempV31);
			locRadius=Vector3.scalarLength(OrientedBoundBox._tempV31);
		}
		Vector3.scale(this.extents,-1,OrientedBoundBox._tempV32);
		Vector3.Clamp(OrientedBoundBox._tempV30,OrientedBoundBox._tempV32,this.extents,OrientedBoundBox._tempV33);
		var distance=Vector3.distanceSquared(OrientedBoundBox._tempV30,OrientedBoundBox._tempV33);
		if (distance > locRadius *locRadius)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		var tempV30e=OrientedBoundBox._tempV30.elements;
		var tempV30ex=tempV30e[0];
		var tempV30ey=tempV30e[1];
		var tempV30ez=tempV30e[2];
		var tempV32e=OrientedBoundBox._tempV32.elements;
		var tempV32ex=tempV32e[0];
		var tempV32ey=tempV32e[1];
		var tempV32ez=tempV32e[2];
		if ((((tempV32ex+locRadius <=tempV30ex)&& (tempV30ex <=extentsEX-locRadius))&& ((extentsEX-tempV32ex > locRadius)&& (tempV32ey+locRadius <=tempV30ey)))&& (((tempV30ey <=extentsEY-locRadius)&& (extentsEY-tempV32ey > locRadius))&& (((tempV32ez+locRadius <=tempV30ez)&& (tempV30ez <=extentsEZ-locRadius))&& (extentsEZ-tempV32ez > locRadius)))){
			return /*laya.d3.math.ContainmentType.Contains*/1;
		}
		return /*laya.d3.math.ContainmentType.Intersects*/2;
	}

	/**
	*For accuracy,The transformation matrix for both <see cref="OrientedBoundingBox"/> must not have any scaling applied to it.
	*Anyway,scaling using Scale method will keep this method accurate.
	*该包围盒是否包含空间中另一OBB包围盒
	*@param obb OBB包围盒
	*@return 返回位置关系
	*/
	__proto.containsOrientedBoundBox=function(obb){
		var i=0,k=0;
		obb.getCorners(OrientedBoundBox._corners);
		var cornersCheck=this.containsPoints(OrientedBoundBox._corners);
		if (cornersCheck !=/*laya.d3.math.ContainmentType.Disjoint*/0)
			return cornersCheck;
		var sizeAe=this.extents.elements;
		obb.extents.cloneTo(OrientedBoundBox._tempV35);
		var sizeBe=OrientedBoundBox._tempV35.elements;
		OrientedBoundBox._getRows(this.transformation,OrientedBoundBox._rows1);
		OrientedBoundBox._getRows(obb.transformation,OrientedBoundBox._rows2);
		var extentA=NaN,extentB=NaN,separation=NaN,dotNumber=NaN;
		for (i=0;i < 4;i++){
			for (k=0;k < 4;k++){
				if (i==3 || k==3){
					OrientedBoundBox._tempM0.setElementByRowColumn(i,k,0);
					OrientedBoundBox._tempM1.setElementByRowColumn(i,k,0);
					}else {
					dotNumber=Vector3.dot(OrientedBoundBox._rows1[i],OrientedBoundBox._rows2[k]);
					OrientedBoundBox._tempM0.setElementByRowColumn(i,k,dotNumber);
					OrientedBoundBox._tempM1.setElementByRowColumn(i,k,Math.abs(dotNumber));
				}
			}
		}
		obb.getCenter(OrientedBoundBox._tempV34);
		this.getCenter(OrientedBoundBox._tempV36);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV36,OrientedBoundBox._tempV30);
		var vsepAe=OrientedBoundBox._tempV31.elements;
		vsepAe[0]=Vector3.dot(OrientedBoundBox._tempV30,OrientedBoundBox._rows1[0]);
		vsepAe[1]=Vector3.dot(OrientedBoundBox._tempV30,OrientedBoundBox._rows1[1]);
		vsepAe[2]=Vector3.dot(OrientedBoundBox._tempV30,OrientedBoundBox._rows1[2]);
		var _tempV32e=OrientedBoundBox._tempV32.elements;
		var _tempV33e=OrientedBoundBox._tempV33.elements;
		for (i=0;i < 3;i++){
			_tempV32e[0]=OrientedBoundBox._tempM1.getElementByRowColumn(i,0);
			_tempV32e[1]=OrientedBoundBox._tempM1.getElementByRowColumn(i,1);
			_tempV32e[2]=OrientedBoundBox._tempM1.getElementByRowColumn(i,2);
			extentA=sizeAe[i];
			extentB=Vector3.dot(OrientedBoundBox._tempV35,OrientedBoundBox._tempV32);
			separation=Math.abs(vsepAe[i]);
			if (separation > extentA+extentB)
				return /*laya.d3.math.ContainmentType.Disjoint*/0;
		}
		for (k=0;k < 3;k++){
			_tempV32e[0]=OrientedBoundBox._tempM1.getElementByRowColumn(0,k);
			_tempV32e[1]=OrientedBoundBox._tempM1.getElementByRowColumn(1,k);
			_tempV32e[2]=OrientedBoundBox._tempM1.getElementByRowColumn(2,k);
			_tempV33e[0]=OrientedBoundBox._tempM0.getElementByRowColumn(0,k);
			_tempV33e[1]=OrientedBoundBox._tempM0.getElementByRowColumn(1,k);
			_tempV33e[2]=OrientedBoundBox._tempM0.getElementByRowColumn(2,k);
			extentA=Vector3.dot(this.extents,OrientedBoundBox._tempV32);
			extentB=sizeBe[k];
			separation=Math.abs(Vector3.dot(OrientedBoundBox._tempV31,OrientedBoundBox._tempV33));
			if (separation > extentA+extentB)
				return /*laya.d3.math.ContainmentType.Disjoint*/0;
		}
		for (i=0;i < 3;i++){
			for (k=0;k < 3;k++){
				var i1=(i+1)% 3,i2=(i+2)% 3;
				var k1=(k+1)% 3,k2=(k+2)% 3;
				extentA=sizeAe[i1] *OrientedBoundBox._tempM1.getElementByRowColumn(i2,k)+sizeAe[i2] *OrientedBoundBox._tempM1.getElementByRowColumn(i1,k);
				extentB=sizeBe[k1] *OrientedBoundBox._tempM1.getElementByRowColumn(i,k2)+sizeBe[k2] *OrientedBoundBox._tempM1.getElementByRowColumn(i,k1);
				separation=Math.abs(vsepAe[i2] *OrientedBoundBox._tempM0.getElementByRowColumn(i1,k)-vsepAe[i1] *OrientedBoundBox._tempM0.getElementByRowColumn(i2,k));
				if (separation > extentA+extentB)
					return /*laya.d3.math.ContainmentType.Disjoint*/0;
			}
		}
		return /*laya.d3.math.ContainmentType.Intersects*/2;
	}

	/**
	*该包围盒是否包含空间中一条线
	*@param point1 点1
	*@param point2 点2
	*@return 返回位置关系
	*/
	__proto.containsLine=function(point1,point2){
		OrientedBoundBox._corners[0]=point1;
		OrientedBoundBox._corners[1]=point2;
		var cornersCheck=this.containsPoints(OrientedBoundBox._corners);
		if (cornersCheck !=/*laya.d3.math.ContainmentType.Disjoint*/0)
			return cornersCheck;
		var extentsE=this.extents.elements;
		var extentsX=extentsE[0];
		var extentsY=extentsE[1];
		var extentsZ=extentsE[2];
		this.transformation.invert(OrientedBoundBox._tempM0);
		Vector3.transformCoordinate(point1,OrientedBoundBox._tempM0,OrientedBoundBox._tempV30);
		Vector3.transformCoordinate(point2,OrientedBoundBox._tempM0,OrientedBoundBox._tempV31);
		Vector3.add(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV32);
		Vector3.scale(OrientedBoundBox._tempV32,0.5,OrientedBoundBox._tempV32);
		Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV32,OrientedBoundBox._tempV33);
		var _tempV33e=OrientedBoundBox._tempV33.elements;
		var _tempV33X=_tempV33e[0];
		var _tempV33Y=_tempV33e[1];
		var _tempV33Z=_tempV33e[2];
		var _tempV34e=OrientedBoundBox._tempV34.elements;
		var _tempV34X=_tempV34e[0]=Math.abs(_tempV33e[0]);
		var _tempV34Y=_tempV34e[1]=Math.abs(_tempV33e[1]);
		var _tempV34Z=_tempV34e[2]=Math.abs(_tempV33e[2]);
		var _tempV32e=OrientedBoundBox._tempV32.elements;
		var _tempV32X=_tempV32e[0];
		var _tempV32Y=_tempV32e[1];
		var _tempV32Z=_tempV32e[2];
		if (Math.abs(_tempV32X)> extentsX+_tempV34X)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (Math.abs(_tempV32Y)> extentsY+_tempV34Y)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (Math.abs(_tempV32Z)> extentsZ+_tempV34Z)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (Math.abs(_tempV32Y *_tempV33Z-_tempV32Z *_tempV33Y)> (extentsY *_tempV34Z+extentsZ *_tempV34Y))
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (Math.abs(_tempV32X *_tempV33Z-_tempV32Z *_tempV33X)> (extentsX *_tempV34Z+extentsZ *_tempV34X))
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (Math.abs(_tempV32X *_tempV33Y-_tempV32Y *_tempV33X)> (extentsX *_tempV34Y+extentsY *_tempV34X))
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		return /*laya.d3.math.ContainmentType.Intersects*/2;
	}

	/**
	*该包围盒是否包含空间中另一OBB包围盒
	*@param box 包围盒
	*@return 返回位置关系
	*/
	__proto.containsBoundBox=function(box){
		var i=0,k=0;
		var min=box.min;
		var max=box.max;
		box.getCorners(OrientedBoundBox._corners);
		var cornersCheck=this.containsPoints(OrientedBoundBox._corners);
		if (cornersCheck !=/*laya.d3.math.ContainmentType.Disjoint*/0)
			return cornersCheck;
		Vector3.subtract(max,min,OrientedBoundBox._tempV30);
		Vector3.scale(OrientedBoundBox._tempV30,0.5,OrientedBoundBox._tempV30);
		Vector3.add(min,OrientedBoundBox._tempV30,OrientedBoundBox._tempV30);
		Vector3.subtract(max,OrientedBoundBox._tempV30,OrientedBoundBox._tempV31);
		var sizeAe=this.extents.elements;
		var sizeBe=OrientedBoundBox._tempV31.elements;
		OrientedBoundBox._getRows(this.transformation,OrientedBoundBox._rows1);
		this.transformation.invert(OrientedBoundBox._tempM0);
		var extentA=NaN,extentB=NaN,separation=NaN,dotNumber=NaN;
		for (i=0;i < 3;i++){
			for (k=0;k < 3;k++){
				OrientedBoundBox._tempM1.setElementByRowColumn(i,k,Math.abs(OrientedBoundBox._tempM0.getElementByRowColumn(i,k)));
			}
		}
		this.getCenter(OrientedBoundBox._tempV35);
		Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV35,OrientedBoundBox._tempV32);
		var vsepAe=OrientedBoundBox._tempV31.elements;
		vsepAe[0]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[0]);
		vsepAe[1]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[1]);
		vsepAe[2]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[2]);
		var _tempV33e=OrientedBoundBox._tempV33.elements;
		var _tempV34e=OrientedBoundBox._tempV34.elements;
		for (i=0;i < 3;i++){
			_tempV33e[0]=OrientedBoundBox._tempM1.getElementByRowColumn(i,0);
			_tempV33e[1]=OrientedBoundBox._tempM1.getElementByRowColumn(i,1);
			_tempV33e[2]=OrientedBoundBox._tempM1.getElementByRowColumn(i,2);
			extentA=sizeAe[i];
			extentB=Vector3.dot(OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
			separation=Math.abs(vsepAe[i]);
			if (separation > extentA+extentB)
				return /*laya.d3.math.ContainmentType.Disjoint*/0;
		}
		for (k=0;k < 3;k++){
			_tempV33e[0]=OrientedBoundBox._tempM1.getElementByRowColumn(0,k);
			_tempV33e[1]=OrientedBoundBox._tempM1.getElementByRowColumn(1,k);
			_tempV33e[2]=OrientedBoundBox._tempM1.getElementByRowColumn(2,k);
			_tempV34e[0]=OrientedBoundBox._tempM0.getElementByRowColumn(0,k);
			_tempV34e[1]=OrientedBoundBox._tempM0.getElementByRowColumn(1,k);
			_tempV34e[2]=OrientedBoundBox._tempM0.getElementByRowColumn(2,k);
			extentA=Vector3.dot(this.extents,OrientedBoundBox._tempV33);
			extentB=sizeBe[k];
			separation=Math.abs(Vector3.dot(OrientedBoundBox._tempV31,OrientedBoundBox._tempV34));
			if (separation > extentA+extentB)
				return /*laya.d3.math.ContainmentType.Disjoint*/0;
		}
		for (i=0;i < 3;i++){
			for (k=0;k < 3;k++){
				var i1=(i+1)% 3,i2=(i+2)% 3;
				var k1=(k+1)% 3,k2=(k+2)% 3;
				extentA=sizeAe[i1] *OrientedBoundBox._tempM1.getElementByRowColumn(i2,k)+sizeAe[i2] *OrientedBoundBox._tempM1.getElementByRowColumn(i1,k);
				extentB=sizeBe[k1] *OrientedBoundBox._tempM1.getElementByRowColumn(i,k2)+sizeBe[k2] *OrientedBoundBox._tempM1.getElementByRowColumn(i,k1);
				separation=Math.abs(vsepAe[i2] *OrientedBoundBox._tempM0.getElementByRowColumn(i1,k)-vsepAe[i1] *OrientedBoundBox._tempM0.getElementByRowColumn(i2,k));
				if (separation > extentA+extentB)
					return /*laya.d3.math.ContainmentType.Disjoint*/0;
			}
		}
		return /*laya.d3.math.ContainmentType.Intersects*/2;
	}

	/**
	*该包围盒是否与空间中另一射线相交
	*@param ray
	*@param out
	*@return
	*/
	__proto.intersectsRay=function(ray,out){
		Vector3.scale(this.extents,-1,OrientedBoundBox._tempV30);
		this.transformation.invert(OrientedBoundBox._tempM0);
		Vector3.TransformNormal(ray.direction,OrientedBoundBox._tempM0,OrientedBoundBox._ray.direction);
		Vector3.transformCoordinate(ray.origin,OrientedBoundBox._tempM0,OrientedBoundBox._ray.origin);
		OrientedBoundBox._boxBound1.min=OrientedBoundBox._tempV30;
		OrientedBoundBox._boxBound1.max=this.extents;
		var intersects=Collision.intersectsRayAndBoxRP(OrientedBoundBox._ray,OrientedBoundBox._boxBound1,out);
		if (intersects!==-1)
			Vector3.transformCoordinate(out,this.transformation,out);
		return intersects;
	}

	__proto._getLocalCorners=function(corners){
		corners.length=8;
		var extentsE=this.extents.elements;
		OrientedBoundBox._tempV30.x=extentsE[0];
		OrientedBoundBox._tempV31.y=extentsE[1];
		OrientedBoundBox._tempV32.z=extentsE[2];
		Vector3.add(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
		Vector3.add(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[0]);
		Vector3.add(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
		Vector3.subtract(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[1]);
		Vector3.subtract(OrientedBoundBox._tempV31,OrientedBoundBox._tempV30,OrientedBoundBox._tempV33);
		Vector3.subtract(OrientedBoundBox._tempV33,OrientedBoundBox._tempV30,corners[2]);
		Vector3.subtract(OrientedBoundBox._tempV31,OrientedBoundBox._tempV30,OrientedBoundBox._tempV33);
		Vector3.add(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[3]);
		Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
		Vector3.add(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[4]);
		Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
		Vector3.subtract(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[5]);
		Vector3.scale(corners[0],-1,corners[6]);
		Vector3.subtract(OrientedBoundBox._tempV32,OrientedBoundBox._tempV30,OrientedBoundBox._tempV33);
		Vector3.subtract(OrientedBoundBox._tempV33,OrientedBoundBox._tempV31,corners[7]);
	}

	/**
	*判断两个包围盒是否相等
	*@param obb obb包围盒
	*@return Boolean
	*/
	__proto.equals=function(obb){
		return this.extents==obb.extents && this.transformation==obb.transformation;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var dest=destObject;
		this.extents.cloneTo(dest.extents);
		this.transformation.cloneTo(dest.transformation);
	}

	OrientedBoundBox.createByBoundBox=function(box,out){
		var min=box.min;
		var max=box.max;
		Vector3.subtract(max,min,OrientedBoundBox._tempV30);
		Vector3.scale(OrientedBoundBox._tempV30,0.5,OrientedBoundBox._tempV30);
		Vector3.add(min,OrientedBoundBox._tempV30,OrientedBoundBox._tempV31);
		Vector3.subtract(max,OrientedBoundBox._tempV31,OrientedBoundBox._tempV32);
		Matrix4x4.translation(OrientedBoundBox._tempV31,OrientedBoundBox._tempM0);
		var extents=OrientedBoundBox._tempV32.clone();
		var transformation=OrientedBoundBox._tempM0.clone();
		out.extents=extents;
		out.transformation=transformation;
	}

	OrientedBoundBox.createByMinAndMaxVertex=function(min,max){
		Vector3.subtract(max,min,OrientedBoundBox._tempV30);
		Vector3.scale(OrientedBoundBox._tempV30,0.5,OrientedBoundBox._tempV30);
		Vector3.add(min,OrientedBoundBox._tempV30,OrientedBoundBox._tempV31);
		Vector3.subtract(max,OrientedBoundBox._tempV31,OrientedBoundBox._tempV32);
		Matrix4x4.translation(OrientedBoundBox._tempV31,OrientedBoundBox._tempM0);
		var obb=new OrientedBoundBox(OrientedBoundBox._tempV32,OrientedBoundBox._tempM0);
		return obb;
	}

	OrientedBoundBox._getRows=function(mat,out){
		out.length=3;
		var mate=mat.elements;
		var row0e=out[0].elements;
		row0e[0]=mate[0];
		row0e[1]=mate[1];
		row0e[2]=mate[2];
		var row1e=out[1].elements;
		row1e[0]=mate[4];
		row1e[1]=mate[5];
		row1e[2]=mate[6];
		var row2e=out[2].elements;
		row2e[0]=mate[8];
		row2e[1]=mate[9];
		row2e[2]=mate[10];
	}

	OrientedBoundBox.getObbtoObbMatrix4x4=function(a,b,noMatrixScaleApplied,out){
		var at=a.transformation;
		var bt=b.transformation;
		if (noMatrixScaleApplied){
			OrientedBoundBox._getRows(at,OrientedBoundBox._rows1);
			OrientedBoundBox._getRows(bt,OrientedBoundBox._rows2);
			for (var i=0;i < 3;i++){
				for (var k=0;k < 3;k++){
					out.setElementByRowColumn(i,k,Vector3.dot(OrientedBoundBox._rows2[i],OrientedBoundBox._rows1[k]));
				}
			}
			b.getCenter(OrientedBoundBox._tempV30);
			a.getCenter(OrientedBoundBox._tempV31);
			Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV32);
			var AtoBMe=out.elements;
			AtoBMe[12]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[0]);
			AtoBMe[13]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[1]);
			AtoBMe[14]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[2]);
			AtoBMe[15]=1;
			}else {
			at.invert(OrientedBoundBox._tempM0);
			Matrix4x4.multiply(bt,OrientedBoundBox._tempM0,out);
		}
	}

	OrientedBoundBox.merge=function(a,b,noMatrixScaleApplied){
		var ae=a.extents;
		var at=a.transformation;
		OrientedBoundBox.getObbtoObbMatrix4x4(a,b,noMatrixScaleApplied,OrientedBoundBox._tempM0);
		b._getLocalCorners(OrientedBoundBox._corners);
		Vector3.transformCoordinate(OrientedBoundBox._corners[0],OrientedBoundBox._tempM0,OrientedBoundBox._corners[0]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[1],OrientedBoundBox._tempM0,OrientedBoundBox._corners[1]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[2],OrientedBoundBox._tempM0,OrientedBoundBox._corners[2]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[3],OrientedBoundBox._tempM0,OrientedBoundBox._corners[3]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[4],OrientedBoundBox._tempM0,OrientedBoundBox._corners[4]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[5],OrientedBoundBox._tempM0,OrientedBoundBox._corners[5]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[6],OrientedBoundBox._tempM0,OrientedBoundBox._corners[6]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[7],OrientedBoundBox._tempM0,OrientedBoundBox._corners[7]);
		Vector3.scale(ae,-1,OrientedBoundBox._boxBound1.min);
		ae.cloneTo(OrientedBoundBox._boxBound1.max);
		BoundBox.createfromPoints(OrientedBoundBox._corners,OrientedBoundBox._boxBound2);
		BoundBox.merge(OrientedBoundBox._boxBound2,OrientedBoundBox._boxBound1,OrientedBoundBox._boxBound3);
		var box3Min=OrientedBoundBox._boxBound3.min;
		var box3Max=OrientedBoundBox._boxBound3.max;
		Vector3.subtract(box3Max,box3Min,OrientedBoundBox._tempV30);
		Vector3.scale(OrientedBoundBox._tempV30,0.5,OrientedBoundBox._tempV30);
		Vector3.add(box3Min,OrientedBoundBox._tempV30,OrientedBoundBox._tempV32);
		Vector3.subtract(box3Max,OrientedBoundBox._tempV32,ae);
		Vector3.transformCoordinate(OrientedBoundBox._tempV32,at,OrientedBoundBox._tempV33);
	}

	__static(OrientedBoundBox,
	['_tempV30',function(){return this._tempV30=new Vector3();},'_tempV31',function(){return this._tempV31=new Vector3();},'_tempV32',function(){return this._tempV32=new Vector3();},'_tempV33',function(){return this._tempV33=new Vector3();},'_tempV34',function(){return this._tempV34=new Vector3();},'_tempV35',function(){return this._tempV35=new Vector3();},'_tempV36',function(){return this._tempV36=new Vector3();},'_tempM0',function(){return this._tempM0=new Matrix4x4();},'_tempM1',function(){return this._tempM1=new Matrix4x4();},'_corners',function(){return this._corners=/*new vector.<>*/[new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3()];},'_rows1',function(){return this._rows1=/*new vector.<>*/[new Vector3(),new Vector3(),new Vector3()];},'_rows2',function(){return this._rows2=/*new vector.<>*/[new Vector3(),new Vector3(),new Vector3()];},'_ray',function(){return this._ray=new Ray(new Vector3(),new Vector3());},'_boxBound1',function(){return this._boxBound1=new BoundBox(new Vector3(),new Vector3());},'_boxBound2',function(){return this._boxBound2=new BoundBox(new Vector3(),new Vector3());},'_boxBound3',function(){return this._boxBound3=new BoundBox(new Vector3(),new Vector3());}
	]);
	return OrientedBoundBox;
})()


/**
*<code>Plane</code> 类用于创建平面。
*/
//class laya.d3.math.Plane
var Plane=(function(){
	function Plane(normal,d){
		/**平面的向量*/
		this.normal=null;
		/**平面到坐标系原点的距离*/
		this.distance=NaN;
		(d===void 0)&& (d=0);
		this.normal=normal;
		this.distance=d;
	}

	__class(Plane,'laya.d3.math.Plane');
	var __proto=Plane.prototype;
	/**
	*更改平面法线向量的系数，使之成单位长度。
	*/
	__proto.normalize=function(){
		var normalE=this.normal.elements;
		var normalEX=normalE[0];
		var normalEY=normalE[1];
		var normalEZ=normalE[2];
		var magnitude=1 / Math.sqrt(normalEX *normalEX+normalEY *normalEY+normalEZ *normalEZ);
		normalE[0]=normalEX *magnitude;
		normalE[1]=normalEY *magnitude;
		normalE[2]=normalEZ *magnitude;
		this.distance *=magnitude;
	}

	Plane.createPlaneBy3P=function(point1,point2,point3){
		var point1e=point1.elements;
		var point2e=point2.elements;
		var point3e=point3.elements;
		var x1=point2e[0]-point1e[0];
		var y1=point2e[1]-point1e[1];
		var z1=point2e[2]-point1e[2];
		var x2=point3e[0]-point1e[0];
		var y2=point3e[1]-point1e[1];
		var z2=point3e[2]-point1e[2];
		var yz=(y1 *z2)-(z1 *y2);
		var xz=(z1 *x2)-(x1 *z2);
		var xy=(x1 *y2)-(y1 *x2);
		var invPyth=1 / (Math.sqrt((yz *yz)+(xz *xz)+(xy *xy)));
		var x=yz *invPyth;
		var y=xz *invPyth;
		var z=xy *invPyth;
		var TEMPVec3e=Plane._TEMPVec3.elements;
		TEMPVec3e[0]=x;
		TEMPVec3e[1]=y;
		TEMPVec3e[2]=z;
		var d=-((x *point1e[0])+(y *point1e[1])+(z *point1e[2]));
		var plane=new Plane(Plane._TEMPVec3,d);
		return plane;
	}

	Plane.PlaneIntersectionType_Back=0;
	Plane.PlaneIntersectionType_Front=1;
	Plane.PlaneIntersectionType_Intersecting=2;
	__static(Plane,
	['_TEMPVec3',function(){return this._TEMPVec3=new Vector3();}
	]);
	return Plane;
})()


/**
*<code>Quaternion</code> 类用于创建四元数。
*/
//class laya.d3.math.Quaternion
var Quaternion=(function(){
	function Quaternion(x,y,z,w){
		this.elements=new Float32Array(4);
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(z===void 0)&& (z=0);
		(w===void 0)&& (w=1);
		this.elements[0]=x;
		this.elements[1]=y;
		this.elements[2]=z;
		this.elements[3]=w;
	}

	__class(Quaternion,'laya.d3.math.Quaternion');
	var __proto=Quaternion.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*根据缩放值缩放四元数
	*@param scale 缩放值
	*@param out 输出四元数
	*/
	__proto.scaling=function(scaling,out){
		var e=out.elements;
		var f=this.elements;
		e[0]=f[0] *scaling;
		e[1]=f[1] *scaling;
		e[2]=f[2] *scaling;
		e[3]=f[3] *scaling;
	}

	/**
	*归一化四元数
	*@param out 输出四元数
	*/
	__proto.normalize=function(out){
		var e=out.elements;
		var f=this.elements;
		var x=f[0],y=f[1],z=f[2],w=f[3];
		var len=x *x+y *y+z *z+w *w;
		if (len > 0){
			len=1 / Math.sqrt(len);
			e[0]=x *len;
			e[1]=y *len;
			e[2]=z *len;
			e[3]=w *len;
		}
	}

	/**
	*计算四元数的长度
	*@return 长度
	*/
	__proto.length=function(){
		var f=this.elements;
		var x=f[0],y=f[1],z=f[2],w=f[3];
		return Math.sqrt(x *x+y *y+z *z+w *w);
	}

	/**
	*根据绕X轴的角度旋转四元数
	*@param rad 角度
	*@param out 输出四元数
	*/
	__proto.rotateX=function(rad,out){
		var e=out.elements;
		var f=this.elements;
		rad *=0.5;
		var ax=f[0],ay=f[1],az=f[2],aw=f[3];
		var bx=Math.sin(rad),bw=Math.cos(rad);
		e[0]=ax *bw+aw *bx;
		e[1]=ay *bw+az *bx;
		e[2]=az *bw-ay *bx;
		e[3]=aw *bw-ax *bx;
	}

	/**
	*根据绕Y轴的制定角度旋转四元数
	*@param rad 角度
	*@param out 输出四元数
	*/
	__proto.rotateY=function(rad,out){
		var e=out.elements;
		var f=this.elements;
		rad *=0.5;
		var ax=f[0],ay=f[1],az=f[2],aw=f[3],by=Math.sin(rad),bw=Math.cos(rad);
		e[0]=ax *bw-az *by;
		e[1]=ay *bw+aw *by;
		e[2]=az *bw+ax *by;
		e[3]=aw *bw-ay *by;
	}

	/**
	*根据绕Z轴的制定角度旋转四元数
	*@param rad 角度
	*@param out 输出四元数
	*/
	__proto.rotateZ=function(rad,out){
		var e=out.elements;
		var f=this.elements;
		rad *=0.5;
		var ax=f[0],ay=f[1],az=f[2],aw=f[3],bz=Math.sin(rad),bw=Math.cos(rad);
		e[0]=ax *bw+ay *bz;
		e[1]=ay *bw-ax *bz;
		e[2]=az *bw+aw *bz;
		e[3]=aw *bw-az *bz;
	}

	/**
	*分解四元数到欧拉角（顺序为Yaw、Pitch、Roll），参考自http://xboxforums.create.msdn.com/forums/p/4574/23988.aspx#23988,问题绕X轴翻转超过±90度时有，会产生瞬间反转
	*@param quaternion 源四元数
	*@param out 欧拉角值
	*/
	__proto.getYawPitchRoll=function(out){
		Vector3.transformQuat(Vector3.ForwardRH,this,Quaternion.TEMPVector31);
		Vector3.transformQuat(Vector3.Up,this,Quaternion.TEMPVector32);
		var upe=Quaternion.TEMPVector32.elements;
		Quaternion.angleTo(Vector3.ZERO,Quaternion.TEMPVector31,Quaternion.TEMPVector33);
		var anglee=Quaternion.TEMPVector33.elements;
		if (anglee[0]==Math.PI / 2){
			anglee[1]=Quaternion.arcTanAngle(upe[2],upe[0]);
			anglee[2]=0;
			}else if (anglee[0]==-Math.PI / 2){
			anglee[1]=Quaternion.arcTanAngle(-upe[2],-upe[0]);
			anglee[2]=0;
			}else {
			Matrix4x4.createRotationY(-anglee[1],Quaternion.TEMPMatrix0);
			Matrix4x4.createRotationX(-anglee[0],Quaternion.TEMPMatrix1);
			Vector3.transformCoordinate(Quaternion.TEMPVector32,Quaternion.TEMPMatrix0,Quaternion.TEMPVector32);
			Vector3.transformCoordinate(Quaternion.TEMPVector32,Quaternion.TEMPMatrix1,Quaternion.TEMPVector32);
			anglee[2]=Quaternion.arcTanAngle(upe[1],-upe[0]);
		}
		if (anglee[1] <=-Math.PI)
			anglee[1]=Math.PI;
		if (anglee[2] <=-Math.PI)
			anglee[2]=Math.PI;
		if (anglee[1] >=Math.PI && anglee[2] >=Math.PI){
			anglee[1]=0;
			anglee[2]=0;
			anglee[0]=Math.PI-anglee[0];
		};
		var oe=out.elements;
		oe[0]=anglee[1];
		oe[1]=anglee[0];
		oe[2]=anglee[2];
	}

	/**
	*求四元数的逆
	*@param out 输出四元数
	*/
	__proto.invert=function(out){
		var e=out.elements;
		var f=this.elements;
		var a0=f[0],a1=f[1],a2=f[2],a3=f[3];
		var dot=a0 *a0+a1 *a1+a2 *a2+a3 *a3;
		var invDot=dot ? 1.0 / dot :0;
		e[0]=-a0 *invDot;
		e[1]=-a1 *invDot;
		e[2]=-a2 *invDot;
		e[3]=a3 *invDot;
	}

	/**
	*设置四元数为单位算数
	*@param out 输出四元数
	*/
	__proto.identity=function(){
		var e=this.elements;
		e[0]=0;
		e[1]=0;
		e[2]=0;
		e[3]=1;
	}

	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.elements[0]=array[offset+0];
		this.elements[1]=array[offset+1];
		this.elements[2]=array[offset+2];
		this.elements[3]=array[offset+3];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var i,s,d;
		s=this.elements;
		d=destObject.elements;
		if (s===d){
			return;
		}
		for (i=0;i < 4;++i){
			d[i]=s[i];
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	__proto.equals=function(b){
		var ae=this.elements;
		var be=b.elements;
		return MathUtils3D.nearEqual(ae[0],be[0])&& MathUtils3D.nearEqual(ae[1],be[1])&& MathUtils3D.nearEqual(ae[2],be[2])&& MathUtils3D.nearEqual(ae[3],be[3]);
	}

	/**
	*计算长度的平方。
	*@return 长度的平方。
	*/
	__proto.lengthSquared=function(){
		var x=this.elements[0];
		var y=this.elements[1];
		var z=this.elements[2];
		var w=this.elements[3];
		return (x *x)+(y *y)+(z *z)+(w *w);
	}

	/**
	*获取四元数的x值
	*/
	__getset(0,__proto,'x',function(){
		return this.elements[0];
	});

	/**
	*获取四元数的y值
	*/
	__getset(0,__proto,'y',function(){
		return this.elements[1];
	});

	/**
	*获取四元数的z值
	*/
	__getset(0,__proto,'z',function(){
		return this.elements[2];
	});

	/**
	*获取四元数的w值
	*/
	__getset(0,__proto,'w',function(){
		return this.elements[3];
	});

	Quaternion.createFromYawPitchRoll=function(yaw,pitch,roll,out){
		var halfRoll=roll *0.5;
		var halfPitch=pitch *0.5;
		var halfYaw=yaw *0.5;
		var sinRoll=Math.sin(halfRoll);
		var cosRoll=Math.cos(halfRoll);
		var sinPitch=Math.sin(halfPitch);
		var cosPitch=Math.cos(halfPitch);
		var sinYaw=Math.sin(halfYaw);
		var cosYaw=Math.cos(halfYaw);
		var oe=out.elements;
		oe[0]=(cosYaw *sinPitch *cosRoll)+(sinYaw *cosPitch *sinRoll);
		oe[1]=(sinYaw *cosPitch *cosRoll)-(cosYaw *sinPitch *sinRoll);
		oe[2]=(cosYaw *cosPitch *sinRoll)-(sinYaw *sinPitch *cosRoll);
		oe[3]=(cosYaw *cosPitch *cosRoll)+(sinYaw *sinPitch *sinRoll);
	}

	Quaternion.multiply=function(left,right,out){
		var le=left.elements;
		var re=right.elements;
		var oe=out.elements;
		var lx=le[0];
		var ly=le[1];
		var lz=le[2];
		var lw=le[3];
		var rx=re[0];
		var ry=re[1];
		var rz=re[2];
		var rw=re[3];
		var a=(ly *rz-lz *ry);
		var b=(lz *rx-lx *rz);
		var c=(lx *ry-ly *rx);
		var d=(lx *rx+ly *ry+lz *rz);
		oe[0]=(lx *rw+rx *lw)+a;
		oe[1]=(ly *rw+ry *lw)+b;
		oe[2]=(lz *rw+rz *lw)+c;
		oe[3]=lw *rw-d;
	}

	Quaternion.arcTanAngle=function(x,y){
		if (x==0){
			if (y==1)
				return Math.PI / 2;
			return-Math.PI / 2;
		}
		if (x > 0)
			return Math.atan(y / x);
		if (x < 0){
			if (y > 0)
				return Math.atan(y / x)+Math.PI;
			return Math.atan(y / x)-Math.PI;
		}
		return 0;
	}

	Quaternion.angleTo=function(from,location,angle){
		Vector3.subtract(location,from,Quaternion.TEMPVector30);
		Vector3.normalize(Quaternion.TEMPVector30,Quaternion.TEMPVector30);
		angle.elements[0]=Math.asin(Quaternion.TEMPVector30.y);
		angle.elements[1]=Quaternion.arcTanAngle(-Quaternion.TEMPVector30.z,-Quaternion.TEMPVector30.x);
	}

	Quaternion.createFromAxisAngle=function(axis,rad,out){
		var e=out.elements;
		var f=axis.elements;
		rad=rad *0.5;
		var s=Math.sin(rad);
		e[0]=s *f[0];
		e[1]=s *f[1];
		e[2]=s *f[2];
		e[3]=Math.cos(rad);
	}

	Quaternion.createFromMatrix3x3=function(sou,out){
		var e=out.elements;
		var f=sou.elements;
		var fTrace=f[0]+f[4]+f[8];
		var fRoot;
		if (fTrace > 0.0){
			fRoot=Math.sqrt(fTrace+1.0);
			e[3]=0.5 *fRoot;
			fRoot=0.5 / fRoot;
			e[0]=(f[5]-f[7])*fRoot;
			e[1]=(f[6]-f[2])*fRoot;
			e[2]=(f[1]-f[3])*fRoot;
			}else {
			var i=0;
			if (f[4] > f[0])
				i=1;
			if (f[8] > f[i *3+i])
				i=2;
			var j=(i+1)% 3;
			var k=(i+2)% 3;
			fRoot=Math.sqrt(f[i *3+i]-f[j *3+j]-f[k *3+k]+1.0);
			e[i]=0.5 *fRoot;
			fRoot=0.5 / fRoot;
			e[3]=(f[j *3+k]-f[k *3+j])*fRoot;
			e[j]=(f[j *3+i]+f[i *3+j])*fRoot;
			e[k]=(f[k *3+i]+f[i *3+k])*fRoot;
		}
		return;
	}

	Quaternion.createFromMatrix4x4=function(mat,out){
		var me=mat.elements;
		var oe=out.elements;
		var sqrt;
		var half;
		var scale=me[0]+me[5]+me[10];
		if (scale > 0.0){
			sqrt=Math.sqrt(scale+1.0);
			oe[3]=sqrt *0.5;
			sqrt=0.5 / sqrt;
			oe[0]=(me[6]-me[9])*sqrt;
			oe[1]=(me[8]-me[2])*sqrt;
			oe[2]=(me[1]-me[4])*sqrt;
			}else if ((me[0] >=me[5])&& (me[0] >=me[10])){
			sqrt=Math.sqrt(1.0+me[0]-me[5]-me[10]);
			half=0.5 / sqrt;
			oe[0]=0.5 *sqrt;
			oe[1]=(me[1]+me[4])*half;
			oe[2]=(me[2]+me[8])*half;
			oe[3]=(me[6]-me[9])*half;
			}else if (me[5] > me[10]){
			sqrt=Math.sqrt(1.0+me[5]-me[0]-me[10]);
			half=0.5 / sqrt;
			oe[0]=(me[4]+me[1])*half;
			oe[1]=0.5 *sqrt;
			oe[2]=(me[9]+me[6])*half;
			oe[3]=(me[8]-me[2])*half;
			}else {
			sqrt=Math.sqrt(1.0+me[10]-me[0]-me[5]);
			half=0.5 / sqrt;
			oe[0]=(me[8]+me[2])*half;
			oe[1]=(me[9]+me[6])*half;
			oe[2]=0.5 *sqrt;
			oe[3]=(me[1]-me[4])*half;
		}
	}

	Quaternion.slerp=function(left,right,t,out){
		var a=left.elements;
		var b=right.elements;
		var oe=out.elements;
		var ax=a[0],ay=a[1],az=a[2],aw=a[3],bx=b[0],by=b[1],bz=b[2],bw=b[3];
		var omega,cosom,sinom,scale0,scale1;
		cosom=ax *bx+ay *by+az *bz+aw *bw;
		if (cosom < 0.0){
			cosom=-cosom;
			bx=-bx;
			by=-by;
			bz=-bz;
			bw=-bw;
		}
		if ((1.0-cosom)> 0.000001){
			omega=Math.acos(cosom);
			sinom=Math.sin(omega);
			scale0=Math.sin((1.0-t)*omega)/ sinom;
			scale1=Math.sin(t *omega)/ sinom;
			}else {
			scale0=1.0-t;
			scale1=t;
		}
		oe[0]=scale0 *ax+scale1 *bx;
		oe[1]=scale0 *ay+scale1 *by;
		oe[2]=scale0 *az+scale1 *bz;
		oe[3]=scale0 *aw+scale1 *bw;
		return oe;
	}

	Quaternion.lerp=function(left,right,t,out){
		var e=out.elements;
		var f=left.elements;
		var g=right.elements;
		var ax=f[0],ay=f[1],az=f[2],aw=f[3];
		e[0]=ax+t *(g[0]-ax);
		e[1]=ay+t *(g[1]-ay);
		e[2]=az+t *(g[2]-az);
		e[3]=aw+t *(g[3]-aw);
	}

	Quaternion.add=function(left,right,out){
		var e=out.elements;
		var f=left.elements;
		var g=right.elements;
		e[0]=f[0]+g[0];
		e[1]=f[1]+g[1];
		e[2]=f[2]+g[2];
		e[3]=f[3]+g[3];
	}

	Quaternion.dot=function(left,right){
		var f=left.elements;
		var g=right.elements;
		return f[0] *g[0]+f[1] *g[1]+f[2] *g[2]+f[3] *g[3];
	}

	Quaternion.rotationLookAt=function(forward,up,out){
		Quaternion.lookAt(Vector3.ZERO,forward,up,out);
	}

	Quaternion.lookAt=function(eye,target,up,out){
		Matrix3x3.lookAt(eye,target,up,Quaternion._tempMatrix3x3);
		Quaternion.rotationMatrix(Quaternion._tempMatrix3x3,out);
	}

	Quaternion.invert=function(value,out){
		var vE=value.elements;
		var oE=out.elements;
		var lengthSq=value.lengthSquared();
		if (!MathUtils3D.isZero(lengthSq)){
			lengthSq=1.0 / lengthSq;
			oE[0]=-vE[0] *lengthSq;
			oE[1]=-vE[1] *lengthSq;
			oE[2]=-vE[2] *lengthSq;
			oE[3]=vE[3] *lengthSq;
		}
	}

	Quaternion.rotationMatrix=function(matrix3x3,out){
		var me=matrix3x3.elements;
		var m11=me[0];
		var m12=me[1];
		var m13=me[2];
		var m21=me[3];
		var m22=me[4];
		var m23=me[5];
		var m31=me[6];
		var m32=me[7];
		var m33=me[8];
		var oe=out.elements;
		var sqrt=NaN,half=NaN;
		var scale=m11+m22+m33;
		if (scale > 0){
			sqrt=Math.sqrt(scale+1);
			oe[3]=sqrt *0.5;
			sqrt=0.5 / sqrt;
			oe[0]=(m23-m32)*sqrt;
			oe[1]=(m31-m13)*sqrt;
			oe[2]=(m12-m21)*sqrt;
			}else if ((m11 >=m22)&& (m11 >=m33)){
			sqrt=Math.sqrt(1+m11-m22-m33);
			half=0.5 / sqrt;
			oe[0]=0.5 *sqrt;
			oe[1]=(m12+m21)*half;
			oe[2]=(m13+m31)*half;
			oe[3]=(m23-m32)*half;
			}else if (m22 > m33){
			sqrt=Math.sqrt(1+m22-m11-m33);
			half=0.5 / sqrt;
			oe[0]=(m21+m12)*half;
			oe[1]=0.5 *sqrt;
			oe[2]=(m32+m23)*half;
			oe[3]=(m31-m13)*half;
			}else {
			sqrt=Math.sqrt(1+m33-m11-m22);
			half=0.5 / sqrt;
			oe[0]=(m31+m13)*half;
			oe[1]=(m32+m23)*half;
			oe[2]=0.5 *sqrt;
			oe[3]=(m12-m21)*half;
		}
	}

	Quaternion.DEFAULT=new Quaternion();
	__static(Quaternion,
	['TEMPVector30',function(){return this.TEMPVector30=new Vector3();},'TEMPVector31',function(){return this.TEMPVector31=new Vector3();},'TEMPVector32',function(){return this.TEMPVector32=new Vector3();},'TEMPVector33',function(){return this.TEMPVector33=new Vector3();},'TEMPMatrix0',function(){return this.TEMPMatrix0=new Matrix4x4();},'TEMPMatrix1',function(){return this.TEMPMatrix1=new Matrix4x4();},'_tempMatrix3x3',function(){return this._tempMatrix3x3=new Matrix3x3();},'NAN',function(){return this.NAN=new Quaternion(NaN,NaN,NaN,NaN);}
	]);
	return Quaternion;
})()


/**
*<code>Rand</code> 类用于通过32位无符号整型随机种子创建随机数。
*/
//class laya.d3.math.Rand
var Rand=(function(){
	function Rand(seed){
		this._temp=new Uint32Array(1);
		this.seeds=new Uint32Array(4);
		this.seeds[0]=seed;
		this.seeds[1]=this.seeds[0] *0x6C078965+1;
		this.seeds[2]=this.seeds[1] *0x6C078965+1;
		this.seeds[3]=this.seeds[2] *0x6C078965+1;
	}

	__class(Rand,'laya.d3.math.Rand');
	var __proto=Rand.prototype;
	/**
	*获取无符号32位整形随机数。
	*@return 无符号32位整形随机数。
	*/
	__proto.getUint=function(){
		this._temp[0]=this.seeds[0] ^ (this.seeds[0] << 11);
		this.seeds[0]=this.seeds[1];
		this.seeds[1]=this.seeds[2];
		this.seeds[2]=this.seeds[3];
		this.seeds[3]=(this.seeds[3] ^ (this.seeds[3] >>> 19))^ (this._temp[0] ^ (this._temp[0] >>> 8));
		return this.seeds[3];
	}

	/**
	*获取0到1之间的浮点随机数。
	*@return 0到1之间的浮点随机数。
	*/
	__proto.getFloat=function(){
		this.getUint();
		return (this.seeds[3] & 0x007FFFFF)*(1.0 / 8388607.0);
	}

	/**
	*获取-1到1之间的浮点随机数。
	*@return-1到1之间的浮点随机数。
	*/
	__proto.getSignedFloat=function(){
		return this.getFloat()*2.0-1.0;
	}

	/**
	*设置随机种子。
	*@param seed 随机种子。
	*/
	/**
	*获取随机种子。
	*@return 随机种子。
	*/
	__getset(0,__proto,'seed',function(){
		return this.seeds[0];
		},function(seed){
		this.seeds[0]=seed;
		this.seeds[1]=this.seeds[0] *0x6C078965+1;
		this.seeds[2]=this.seeds[1] *0x6C078965+1;
		this.seeds[3]=this.seeds[2] *0x6C078965+1;
	});

	Rand.getFloatFromInt=function(v){
		return (v & 0x007FFFFF)*(1.0 / 8388607.0)
	}

	Rand.getByteFromInt=function(v){
		return (v & 0x007FFFFF)>>> 15;
	}

	return Rand;
})()


/**
*<code>Rand</code> 类用于通过128位整型种子创建随机数,算法来自:https://github.com/AndreasMadsen/xorshift。
*/
//class laya.d3.math.RandX
var RandX=(function(){
	function RandX(seed){
		/**@private */
		this._state0U=NaN;
		/**@private */
		this._state0L=NaN;
		/**@private */
		this._state1U=NaN;
		/**@private */
		this._state1L=NaN;
		if (!((seed instanceof Array))|| seed.length!==4)
			throw new Error('Rand:Seed must be an array with 4 numbers');
		this._state0U=seed[0] | 0;
		this._state0L=seed[1] | 0;
		this._state1U=seed[2] | 0;
		this._state1L=seed[3] | 0;
	}

	__class(RandX,'laya.d3.math.RandX');
	var __proto=RandX.prototype;
	/**
	*通过2x32位的数组，返回64位的随机数。
	*@return 64位的随机数。
	*/
	__proto.randomint=function(){
		var s1U=this._state0U,s1L=this._state0L;
		var s0U=this._state1U,s0L=this._state1L;
		var sumL=(s0L >>> 0)+(s1L >>> 0);
		var resU=(s0U+s1U+(sumL / 2 >>> 31))>>> 0;
		var resL=sumL >>> 0;
		this._state0U=s0U;
		this._state0L=s0L;
		var t1U=0,t1L=0;
		var t2U=0,t2L=0;
		var a1=23;
		var m1=0xFFFFFFFF << (32-a1);
		t1U=(s1U << a1)| ((s1L & m1)>>> (32-a1));
		t1L=s1L << a1;
		s1U=s1U ^ t1U;
		s1L=s1L ^ t1L;
		t1U=s1U ^ s0U;
		t1L=s1L ^ s0L;
		var a2=18;
		var m2=0xFFFFFFFF >>> (32-a2);
		t2U=s1U >>> a2;
		t2L=(s1L >>> a2)| ((s1U & m2)<< (32-a2));
		t1U=t1U ^ t2U;
		t1L=t1L ^ t2L;
		var a3=5;
		var m3=0xFFFFFFFF >>> (32-a3);
		t2U=s0U >>> a3;
		t2L=(s0L >>> a3)| ((s0U & m3)<< (32-a3));
		t1U=t1U ^ t2U;
		t1L=t1L ^ t2L;
		this._state1U=t1U;
		this._state1L=t1L;
		return [resU,resL];
	}

	/**
	*返回[0,1)之间的随机数。
	*@return
	*/
	__proto.random=function(){
		var t2=this.randomint();
		var t2U=t2[0];
		var t2L=t2[1];
		var eU=0x3FF << (52-32);
		var eL=0;
		var a1=12;
		var m1=0xFFFFFFFF >>> (32-a1);
		var sU=t2U >>> a1;
		var sL=(t2L >>> a1)| ((t2U & m1)<< (32-a1));
		var xU=eU | sU;
		var xL=eL | sL;
		RandX._CONVERTION_BUFFER.setUint32(0,xU,false);
		RandX._CONVERTION_BUFFER.setUint32(4,xL,false);
		var d=/*__JS__ */Rand._CONVERTION_BUFFER.getFloat64(0,false);
		return d-1;
	}

	__static(RandX,
	['_CONVERTION_BUFFER',function(){return this._CONVERTION_BUFFER=new DataView(new ArrayBuffer(8));},'defaultRand',function(){return this.defaultRand=/*__JS__ */new Rand([0,Date.now()/ 65536,0,Date.now()% 65536]);}
	]);
	return RandX;
})()


/**
*<code>Ray</code> 类用于创建射线。
*/
//class laya.d3.math.Ray
var Ray=(function(){
	function Ray(origin,direction){
		/**原点*/
		this.origin=null;
		/**方向*/
		this.direction=null;
		this.origin=origin;
		this.direction=direction;
	}

	__class(Ray,'laya.d3.math.Ray');
	return Ray;
})()


/**
*<code>Vector2</code> 类用于创建二维向量。
*/
//class laya.d3.math.Vector2
var Vector2=(function(){
	function Vector2(x,y){
		this.elements=new Float32Array(2);
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		var v=this.elements;
		v[0]=x;
		v[1]=y;
	}

	__class(Vector2,'laya.d3.math.Vector2');
	var __proto=Vector2.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.elements[0]=array[offset+0];
		this.elements[1]=array[offset+1];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destVector2=destObject;
		var destE=destVector2.elements;
		var s=this.elements;
		destE[0]=s[0];
		destE[1]=s[1];
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destVector2=/*__JS__ */new this.constructor();
		this.cloneTo(destVector2);
		return destVector2;
	}

	/**
	*设置X轴坐标。
	*@param value X轴坐标。
	*/
	/**
	*获取X轴坐标。
	*@return X轴坐标。
	*/
	__getset(0,__proto,'x',function(){
		return this.elements[0];
		},function(value){
		this.elements[0]=value;
	});

	/**
	*设置Y轴坐标。
	*@param value Y轴坐标。
	*/
	/**
	*获取Y轴坐标。
	*@return Y轴坐标。
	*/
	__getset(0,__proto,'y',function(){
		return this.elements[1];
		},function(value){
		this.elements[1]=value;
	});

	Vector2.scale=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		e[0]=f[0] *b;
		e[1]=f[1] *b;
	}

	__static(Vector2,
	['ZERO',function(){return this.ZERO=new Vector2(0.0,0.0);},'ONE',function(){return this.ONE=new Vector2(1.0,1.0);}
	]);
	return Vector2;
})()


/**
*<code>Vector3</code> 类用于创建三维向量。
*/
//class laya.d3.math.Vector3
var Vector3=(function(){
	function Vector3(x,y,z){
		this.elements=new Float32Array(3);
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(z===void 0)&& (z=0);
		var v=this.elements;
		v[0]=x;
		v[1]=y;
		v[2]=z;
	}

	__class(Vector3,'laya.d3.math.Vector3');
	var __proto=Vector3.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.elements[0]=array[offset+0];
		this.elements[1]=array[offset+1];
		this.elements[2]=array[offset+2];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destVector3=destObject;
		var destE=destVector3.elements;
		var s=this.elements;
		destE[0]=s[0];
		destE[1]=s[1];
		destE[2]=s[2];
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destVector3=/*__JS__ */new this.constructor();
		this.cloneTo(destVector3);
		return destVector3;
	}

	__proto.toDefault=function(){
		this.elements[0]=0;
		this.elements[1]=0;
		this.elements[2]=0;
	}

	/**
	*设置X轴坐标。
	*@param value X轴坐标。
	*/
	/**
	*获取X轴坐标。
	*@return X轴坐标。
	*/
	__getset(0,__proto,'x',function(){
		return this.elements[0];
		},function(value){
		this.elements[0]=value;
	});

	/**
	*设置Y轴坐标。
	*@param value Y轴坐标。
	*/
	/**
	*获取Y轴坐标。
	*@return Y轴坐标。
	*/
	__getset(0,__proto,'y',function(){
		return this.elements[1];
		},function(value){
		this.elements[1]=value;
	});

	/**
	*设置Z轴坐标。
	*@param value Z轴坐标。
	*/
	/**
	*获取Z轴坐标。
	*@return Z轴坐标。
	*/
	__getset(0,__proto,'z',function(){
		return this.elements[2];
		},function(value){
		this.elements[2]=value;
	});

	Vector3.distanceSquared=function(value1,value2){
		var value1e=value1.elements;
		var value2e=value2.elements;
		var x=value1e[0]-value2e[0];
		var y=value1e[1]-value2e[1];
		var z=value1e[2]-value2e[2];
		return (x *x)+(y *y)+(z *z);
	}

	Vector3.distance=function(value1,value2){
		var value1e=value1.elements;
		var value2e=value2.elements;
		var x=value1e[0]-value2e[0];
		var y=value1e[1]-value2e[1];
		var z=value1e[2]-value2e[2];
		return Math.sqrt((x *x)+(y *y)+(z *z));
	}

	Vector3.min=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=Math.min(f[0],g[0]);
		e[1]=Math.min(f[1],g[1]);
		e[2]=Math.min(f[2],g[2]);
	}

	Vector3.max=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=Math.max(f[0],g[0]);
		e[1]=Math.max(f[1],g[1]);
		e[2]=Math.max(f[2],g[2]);
	}

	Vector3.transformQuat=function(source,rotation,out){
		var destination=out.elements;
		var se=source.elements;
		var re=rotation.elements;
		var x=se[0],y=se[1],z=se[2],qx=re[0],qy=re[1],qz=re[2],qw=re[3],
		ix=qw *x+qy *z-qz *y,iy=qw *y+qz *x-qx *z,iz=qw *z+qx *y-qy *x,iw=-qx *x-qy *y-qz *z;
		destination[0]=ix *qw+iw *-qx+iy *-qz-iz *-qy;
		destination[1]=iy *qw+iw *-qy+iz *-qx-ix *-qz;
		destination[2]=iz *qw+iw *-qz+ix *-qy-iy *-qx;
	}

	Vector3.scalarLength=function(a){
		var f=a.elements;
		var x=f[0],y=f[1],z=f[2];
		return Math.sqrt(x *x+y *y+z *z);
	}

	Vector3.scalarLengthSquared=function(a){
		var f=a.elements;
		var x=f[0],y=f[1],z=f[2];
		return x *x+y *y+z *z;
	}

	Vector3.normalize=function(s,out){
		var se=s.elements;
		var oe=out.elements;
		var x=se[0],y=se[1],z=se[2];
		var len=x *x+y *y+z *z;
		if (len > 0){
			len=1 / Math.sqrt(len);
			oe[0]=se[0] *len;
			oe[1]=se[1] *len;
			oe[2]=se[2] *len;
		}
	}

	Vector3.multiply=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=f[0] *g[0];
		e[1]=f[1] *g[1];
		e[2]=f[2] *g[2];
	}

	Vector3.scale=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		e[0]=f[0] *b;
		e[1]=f[1] *b;
		e[2]=f[2] *b;
	}

	Vector3.lerp=function(a,b,t,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements;
		var ax=f[0],ay=f[1],az=f[2];
		e[0]=ax+t *(g[0]-ax);
		e[1]=ay+t *(g[1]-ay);
		e[2]=az+t *(g[2]-az);
	}

	Vector3.transformV3ToV3=function(vector,transform,result){
		var intermediate=Vector3._tempVector4;
		Vector3.transformV3ToV4(vector,transform,intermediate);
		var intermediateElem=intermediate.elements;
		var resultElem=result.elements;
		resultElem[0]=intermediateElem[0];
		resultElem[1]=intermediateElem[1];
		resultElem[2]=intermediateElem[2];
	}

	Vector3.transformV3ToV4=function(vector,transform,result){
		var vectorElem=vector.elements;
		var vectorX=vectorElem[0];
		var vectorY=vectorElem[1];
		var vectorZ=vectorElem[2];
		var transformElem=transform.elements;
		var resultElem=result.elements;
		resultElem[0]=(vectorX *transformElem[0])+(vectorY *transformElem[4])+(vectorZ *transformElem[8])+transformElem[12];
		resultElem[1]=(vectorX *transformElem[1])+(vectorY *transformElem[5])+(vectorZ *transformElem[9])+transformElem[13];
		resultElem[2]=(vectorX *transformElem[2])+(vectorY *transformElem[6])+(vectorZ *transformElem[10])+transformElem[14];
		resultElem[3]=(vectorX *transformElem[3])+(vectorY *transformElem[7])+(vectorZ *transformElem[11])+transformElem[15];
	}

	Vector3.TransformNormal=function(normal,transform,result){
		var normalElem=normal.elements;
		var normalX=normalElem[0];
		var normalY=normalElem[1];
		var normalZ=normalElem[2];
		var transformElem=transform.elements;
		var resultElem=result.elements;
		resultElem[0]=(normalX *transformElem[0])+(normalY *transformElem[4])+(normalZ *transformElem[8]);
		resultElem[1]=(normalX *transformElem[1])+(normalY *transformElem[5])+(normalZ *transformElem[9]);
		resultElem[2]=(normalX *transformElem[2])+(normalY *transformElem[6])+(normalZ *transformElem[10]);
	}

	Vector3.transformCoordinate=function(coordinate,transform,result){
		var vectorElem=Vector3._tempVector4.elements;
		var coordinateElem=coordinate.elements;
		var coordinateX=coordinateElem[0];
		var coordinateY=coordinateElem[1];
		var coordinateZ=coordinateElem[2];
		var transformElem=transform.elements;
		vectorElem[0]=(coordinateX *transformElem[0])+(coordinateY *transformElem[4])+(coordinateZ *transformElem[8])+transformElem[12];
		vectorElem[1]=(coordinateX *transformElem[1])+(coordinateY *transformElem[5])+(coordinateZ *transformElem[9])+transformElem[13];
		vectorElem[2]=(coordinateX *transformElem[2])+(coordinateY *transformElem[6])+(coordinateZ *transformElem[10])+transformElem[14];
		vectorElem[3]=1.0 / ((coordinateX *transformElem[3])+(coordinateY *transformElem[7])+(coordinateZ *transformElem[11])+transformElem[15]);
		var resultElem=result.elements;
		resultElem[0]=vectorElem[0] *vectorElem[3];
		resultElem[1]=vectorElem[1] *vectorElem[3];
		resultElem[2]=vectorElem[2] *vectorElem[3];
	}

	Vector3.Clamp=function(value,min,max,out){
		var valuee=value.elements;
		var x=valuee[0];
		var y=valuee[1];
		var z=valuee[2];
		var mine=min.elements;
		var mineX=mine[0];
		var mineY=mine[1];
		var mineZ=mine[2];
		var maxe=max.elements;
		var maxeX=maxe[0];
		var maxeY=maxe[1];
		var maxeZ=maxe[2];
		var oute=out.elements;
		x=(x > maxeX)? maxeX :x;
		x=(x < mineX)? mineX :x;
		y=(y > maxeY)? maxeY :y;
		y=(y < mineY)? mineY :y;
		z=(z > maxeZ)? maxeZ :z;
		z=(z < mineZ)? mineZ :z;
		oute[0]=x;
		oute[1]=y;
		oute[2]=z;
	}

	Vector3.add=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=f[0]+g[0];
		e[1]=f[1]+g[1];
		e[2]=f[2]+g[2];
	}

	Vector3.subtract=function(a,b,o){
		var oe=o.elements;
		var ae=a.elements;
		var be=b.elements;
		oe[0]=ae[0]-be[0];
		oe[1]=ae[1]-be[1];
		oe[2]=ae[2]-be[2];
	}

	Vector3.cross=function(a,b,o){
		var ae=a.elements;
		var be=b.elements;
		var oe=o.elements;
		var ax=ae[0],ay=ae[1],az=ae[2],bx=be[0],by=be[1],bz=be[2];
		oe[0]=ay *bz-az *by;
		oe[1]=az *bx-ax *bz;
		oe[2]=ax *by-ay *bx;
	}

	Vector3.dot=function(a,b){
		var ae=a.elements;
		var be=b.elements;
		var r=(ae[0] *be[0])+(ae[1] *be[1])+(ae[2] *be[2]);
		return r;
	}

	Vector3.equals=function(a,b){
		var ae=a.elements;
		var be=b.elements;
		return MathUtils3D.nearEqual(Math.abs(ae[0]),Math.abs(be[0]))&& MathUtils3D.nearEqual(Math.abs(ae[1]),Math.abs(be[1]))&& MathUtils3D.nearEqual(Math.abs(ae[2]),Math.abs(be[2]));
	}

	Vector3.ZERO=new Vector3(0.0,0.0,0.0);
	Vector3.ONE=new Vector3(1.0,1.0,1.0);
	Vector3.NegativeUnitX=new Vector3(-1,0,0);
	Vector3.UnitX=new Vector3(1,0,0);
	Vector3.UnitY=new Vector3(0,1,0);
	Vector3.UnitZ=new Vector3(0,0,1);
	Vector3.ForwardRH=new Vector3(0,0,-1);
	Vector3.ForwardLH=new Vector3(0,0,1);
	Vector3.Up=new Vector3(0,1,0);
	Vector3.NAN=new Vector3(NaN,NaN,NaN);
	__static(Vector3,
	['_tempVector4',function(){return this._tempVector4=new Vector4();}
	]);
	return Vector3;
})()


/**
*<code>Vector4</code> 类用于创建四维向量。
*/
//class laya.d3.math.Vector4
var Vector4=(function(){
	function Vector4(x,y,z,w){
		this.elements=new Float32Array(4);
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(z===void 0)&& (z=0);
		(w===void 0)&& (w=0);
		var v=this.elements;
		v[0]=x;
		v[1]=y;
		v[2]=z;
		v[3]=w;
	}

	__class(Vector4,'laya.d3.math.Vector4');
	var __proto=Vector4.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.elements[0]=array[offset+0];
		this.elements[1]=array[offset+1];
		this.elements[2]=array[offset+2];
		this.elements[3]=array[offset+3];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destVector4=destObject;
		var destE=destVector4.elements;
		var s=this.elements;
		destE[0]=s[0];
		destE[1]=s[1];
		destE[2]=s[2];
		destE[3]=s[3];
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destVector4=/*__JS__ */new this.constructor();
		this.cloneTo(destVector4);
		return destVector4;
	}

	/**
	*求四维向量的长度。
	*@return 长度。
	*/
	__proto.length=function(){
		return Math.sqrt(this.x *this.x+this.y *this.y+this.z *this.z+this.w *this.w);
	}

	/**
	*求四维向量长度的平方。
	*@return 长度的平方。
	*/
	__proto.lengthSquared=function(){
		return this.x *this.x+this.y *this.y+this.z *this.z+this.w *this.w;
	}

	/**
	*设置X轴坐标。
	*@param value X轴坐标。
	*/
	/**
	*获取X轴坐标。
	*@return X轴坐标。
	*/
	__getset(0,__proto,'x',function(){
		return this.elements[0];
		},function(value){
		this.elements[0]=value;
	});

	/**
	*设置Y轴坐标。
	*@param value Y轴坐标。
	*/
	/**
	*获取Y轴坐标。
	*@return Y轴坐标。
	*/
	__getset(0,__proto,'y',function(){
		return this.elements[1];
		},function(value){
		this.elements[1]=value;
	});

	/**
	*设置Z轴坐标。
	*@param value Z轴坐标。
	*/
	/**
	*获取Z轴坐标。
	*@return Z轴坐标。
	*/
	__getset(0,__proto,'z',function(){
		return this.elements[2];
		},function(value){
		this.elements[2]=value;
	});

	/**
	*设置W轴坐标。
	*@param value W轴坐标。
	*/
	/**
	*获取W轴坐标。
	*@return W轴坐标。
	*/
	__getset(0,__proto,'w',function(){
		return this.elements[3];
		},function(value){
		this.elements[3]=value;
	});

	Vector4.lerp=function(a,b,t,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements;
		var ax=f[0],ay=f[1],az=f[2],aw=f[3];
		e[0]=ax+t *(g[0]-ax);
		e[1]=ay+t *(g[1]-ay);
		e[2]=az+t *(g[2]-az);
		e[3]=aw+t *(g[3]-aw);
	}

	Vector4.transformByM4x4=function(vector4,m4x4,out){
		var ve=vector4.elements;
		var vx=ve[0];
		var vy=ve[1];
		var vz=ve[2];
		var vw=ve[3];
		var me=m4x4.elements;
		var oe=out.elements;
		oe[0]=vx *me[0]+vy *me[4]+vz *me[8]+vw *me[12];
		oe[1]=vx *me[1]+vy *me[5]+vz *me[9]+vw *me[13];
		oe[2]=vx *me[2]+vy *me[6]+vz *me[10]+vw *me[14];
		oe[3]=vx *me[3]+vy *me[7]+vz *me[11]+vw *me[15];
	}

	Vector4.equals=function(a,b){
		var ae=a.elements;
		var be=b.elements;
		return MathUtils3D.nearEqual(Math.abs(ae[0]),Math.abs(be[0]))&& MathUtils3D.nearEqual(Math.abs(ae[1]),Math.abs(be[1]))&& MathUtils3D.nearEqual(Math.abs(ae[2]),Math.abs(be[2]))&& MathUtils3D.nearEqual(Math.abs(ae[3]),Math.abs(be[3]));
	}

	Vector4.normalize=function(s,out){
		var se=s.elements;
		var oe=out.elements;
		var len=/*if err,please use iflash.method.xmlLength()*/s.length();
		if (len > 0){
			oe[0]=se[0] *len;
			oe[1]=se[1] *len;
			oe[2]=se[2] *len;
			oe[3]=se[3] *len;
		}
	}

	Vector4.add=function(a,b,out){
		var oe=out.elements;
		var ae=a.elements;
		var be=b.elements;
		oe[0]=ae[0]+be[0];
		oe[1]=ae[1]+be[1];
		oe[2]=ae[2]+be[2];
		oe[3]=ae[3]+be[3];
	}

	Vector4.subtract=function(a,b,out){
		var oe=out.elements;
		var ae=a.elements;
		var be=b.elements;
		oe[0]=ae[0]-be[0];
		oe[1]=ae[1]-be[1];
		oe[2]=ae[2]-be[2];
		oe[3]=ae[3]-be[3];
	}

	Vector4.multiply=function(a,b,out){
		var oe=out.elements;
		var ae=a.elements;
		var be=b.elements;
		oe[0]=ae[0] *be[0];
		oe[1]=ae[1] *be[1];
		oe[2]=ae[2] *be[2];
		oe[3]=ae[3] *be[3];
	}

	Vector4.scale=function(a,b,out){
		var oe=out.elements;
		var ae=a.elements;
		oe[0]=ae[0] *b;
		oe[1]=ae[1] *b;
		oe[2]=ae[2] *b;
		oe[3]=ae[3] *b;
	}

	Vector4.Clamp=function(value,min,max,out){
		var valuee=value.elements;
		var x=valuee[0];
		var y=valuee[1];
		var z=valuee[2];
		var w=valuee[3];
		var mine=min.elements;
		var mineX=mine[0];
		var mineY=mine[1];
		var mineZ=mine[2];
		var mineW=mine[3];
		var maxe=max.elements;
		var maxeX=maxe[0];
		var maxeY=maxe[1];
		var maxeZ=maxe[2];
		var maxeW=maxe[3];
		var oute=out.elements;
		x=(x > maxeX)? maxeX :x;
		x=(x < mineX)? mineX :x;
		y=(y > maxeY)? maxeY :y;
		y=(y < mineY)? mineY :y;
		z=(z > maxeZ)? maxeZ :z;
		z=(z < mineZ)? mineZ :z;
		w=(w > maxeW)? maxeW :w;
		w=(w < mineW)? mineW :w;
		oute[0]=x;
		oute[1]=y;
		oute[2]=z;
		oute[3]=w;
	}

	Vector4.distanceSquared=function(value1,value2){
		var value1e=value1.elements;
		var value2e=value2.elements;
		var x=value1e[0]-value2e[0];
		var y=value1e[1]-value2e[1];
		var z=value1e[2]-value2e[2];
		var w=value1e[3]-value2e[3];
		return (x *x)+(y *y)+(z *z)+(w *w);
	}

	Vector4.distance=function(value1,value2){
		var value1e=value1.elements;
		var value2e=value2.elements;
		var x=value1e[0]-value2e[0];
		var y=value1e[1]-value2e[1];
		var z=value1e[2]-value2e[2];
		var w=value1e[3]-value2e[3];
		return Math.sqrt((x *x)+(y *y)+(z *z)+(w *w));
	}

	Vector4.dot=function(a,b){
		var ae=a.elements;
		var be=b.elements;
		var r=(ae[0] *be[0])+(ae[1] *be[1])+(ae[2] *be[2])+(ae[3] *be[3]);
		return r;
	}

	Vector4.min=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=Math.min(f[0],g[0]);
		e[1]=Math.min(f[1],g[1]);
		e[2]=Math.min(f[2],g[2]);
		e[3]=Math.min(f[3],g[3]);
	}

	Vector4.max=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=Math.max(f[0],g[0]);
		e[1]=Math.max(f[1],g[1]);
		e[2]=Math.max(f[2],g[2]);
		e[3]=Math.max(f[3],g[3]);
	}

	__static(Vector4,
	['ZERO',function(){return this.ZERO=new Vector4();},'ONE',function(){return this.ONE=new Vector4(1.0,1.0,1.0,1.0);},'UnitX',function(){return this.UnitX=new Vector4(1.0,0.0,0.0,0.0);},'UnitY',function(){return this.UnitY=new Vector4(0.0,1.0,0.0,0.0);},'UnitZ',function(){return this.UnitZ=new Vector4(0.0,0.0,1.0,0.0);},'UnitW',function(){return this.UnitW=new Vector4(0.0,0.0,0.0,1.0);}
	]);
	return Vector4;
})()


/**
*<code>Viewport</code> 类用于创建视口。
*/
//class laya.d3.math.Viewport
var Viewport=(function(){
	function Viewport(x,y,width,height){
		/**X轴坐标*/
		//this.x=NaN;
		/**Y轴坐标*/
		//this.y=NaN;
		/**宽度*/
		//this.width=NaN;
		/**高度*/
		//this.height=NaN;
		/**最小深度*/
		//this.minDepth=NaN;
		/**最大深度*/
		//this.maxDepth=NaN;
		this.minDepth=0.0;
		this.maxDepth=1.0;
		this.x=x;
		this.y=y;
		this.width=width;
		this.height=height;
	}

	__class(Viewport,'laya.d3.math.Viewport');
	var __proto=Viewport.prototype;
	/**
	*变换一个三维向量。
	*@param source 源三维向量。
	*@param matrix 变换矩阵。
	*@param vector 输出三维向量。
	*/
	__proto.project=function(source,matrix,out){
		Vector3.transformV3ToV3(source,matrix,out);
		var sourceEleme=source.elements;
		var matrixEleme=matrix.elements;
		var outEleme=out.elements;
		var a=(((sourceEleme[0] *matrixEleme[3])+(sourceEleme[1] *matrixEleme[7]))+(sourceEleme[2] *matrixEleme[11]))+matrixEleme[15];
		if (a!==1.0){
			outEleme[0]=outEleme[0] / a;
			outEleme[1]=outEleme[1] / a;
			outEleme[2]=outEleme[2] / a;
		}
		outEleme[0]=(((outEleme[0]+1.0)*0.5)*this.width)+this.x;
		outEleme[1]=(((-outEleme[1]+1.0)*0.5)*this.height)+this.y;
		outEleme[2]=(outEleme[2] *(this.maxDepth-this.minDepth))+this.minDepth;
	}

	/**
	*反变换一个三维向量。
	*@param source 源三维向量。
	*@param matrix 变换矩阵。
	*@param vector 输出三维向量。
	*/
	__proto.unprojectFromMat=function(source,matrix,out){
		var sourceEleme=source.elements;
		var matrixEleme=matrix.elements;
		var outEleme=out.elements;
		outEleme[0]=(((sourceEleme[0]-this.x)/ (this.width))*2.0)-1.0;
		outEleme[1]=-((((sourceEleme[1]-this.y)/ (this.height))*2.0)-1.0);
		var halfDepth=(this.maxDepth-this.minDepth)/ 2;
		outEleme[2]=(sourceEleme[2]-this.minDepth-halfDepth)/ halfDepth;
		var a=(((outEleme[0] *matrixEleme[3])+(outEleme[1] *matrixEleme[7]))+(outEleme[2] *matrixEleme[11]))+matrixEleme[15];
		Vector3.transformV3ToV3(out,matrix,out);
		if (a!==1.0){
			outEleme[0]=outEleme[0] / a;
			outEleme[1]=outEleme[1] / a;
			outEleme[2]=outEleme[2] / a;
		}
	}

	/**
	*反变换一个三维向量。
	*@param source 源三维向量。
	*@param projection 透视投影矩阵。
	*@param view 视图矩阵。
	*@param world 世界矩阵,可设置为null。
	*@param out 输出向量。
	*/
	__proto.unprojectFromWVP=function(source,projection,view,world,out){
		Matrix4x4.multiply(projection,view,Viewport._tempMatrix4x4);
		(world)&& (Matrix4x4.multiply(Viewport._tempMatrix4x4,world,Viewport._tempMatrix4x4));
		Viewport._tempMatrix4x4.invert(Viewport._tempMatrix4x4);
		this.unprojectFromMat(source,Viewport._tempMatrix4x4,out);
	}

	__static(Viewport,
	['_tempMatrix4x4',function(){return this._tempMatrix4x4=new Matrix4x4();}
	]);
	return Viewport;
})()


/**
*<code>Sky</code> 类用于创建天空的父类，抽象类不允许实例。
*/
//class laya.d3.resource.models.Sky
var Sky=(function(){
	function Sky(){
		/**@private */
		//this.__ownerCamera=null;
		/**@private 透明混合度。 */
		this._alphaBlending=1.0;
		/**@private 颜色强度。 */
		this._colorIntensity=1.0;
		/**@private */
		//this._vertexBuffer=null;
		/**@private */
		//this._indexBuffer=null;
		/**@private */
		//this._sharderNameID=0;
		/**@private */
		//this._shader=null;
		/**@private */
		//this._shaderValue=null;
		/**@private */
		//this._shaderCompile=null;
		/**@private */
		//this._environmentDiffuse=null;
		/**@private */
		//this._environmentSpecular=null;
		;
		this._shaderValue=new ValusArray();
	}

	__class(Sky,'laya.d3.resource.models.Sky');
	var __proto=Sky.prototype;
	/**
	*@private
	*/
	__proto._setEnvironmentDiffuse=function(){
		if (this._environmentDiffuse.loaded){
			this.__ownerCamera._shaderValues.setValue(/*laya.d3.core.BaseCamera.ENVIRONMENTDIFFUSE*/7,this._environmentDiffuse);
			}else {
			this._environmentDiffuse.on(/*laya.events.Event.LOADED*/"loaded",this,this._environmentDiffuseLoaded);
		}
	}

	/**
	*@private
	*/
	__proto._setEnvironmentSpecular=function(){
		if (this._environmentSpecular.loaded){
			var si=this._environmentSpecular['simLodInfo'];
			if (si && (si instanceof Float32Array))
				this.__ownerCamera._shaderValues.setValue(/*laya.d3.core.BaseCamera.SIMLODINFO*/9,si);
			this.__ownerCamera._shaderValues.setValue(/*laya.d3.core.BaseCamera.ENVIRONMENTSPECULAR*/8,this._environmentSpecular);
			}else {
			this._environmentSpecular.on(/*laya.events.Event.LOADED*/"loaded",this,this._environmentSpecularLoaded);
		}
	}

	/**
	*@private
	*/
	__proto._environmentDiffuseLoaded=function(){
		this.__ownerCamera._shaderValues.setValue(/*laya.d3.core.BaseCamera.ENVIRONMENTDIFFUSE*/7,this._environmentDiffuse);
	}

	/**
	*@private
	*/
	__proto._environmentSpecularLoaded=function(){
		var si=this._environmentSpecular['simLodInfo'];
		if (si && (si instanceof Float32Array))
			this.__ownerCamera._shaderValues.setValue(/*laya.d3.core.BaseCamera.SIMLODINFO*/9,si);
		this.__ownerCamera._shaderValues.setValue(/*laya.d3.core.BaseCamera.ENVIRONMENTSPECULAR*/8,this._environmentSpecular);
	}

	/**
	*@private
	*/
	__proto._render=function(state){}
	/**
	*销毁天空。
	*/
	__proto.destroy=function(){
		this.__ownerCamera=null;
	}

	/**
	*@private
	*/
	__getset(0,__proto,'_ownerCamera',null,function(value){
		this.__ownerCamera=value;
		(this._environmentDiffuse)&& (this._setEnvironmentDiffuse());
		(this._environmentSpecular)&& (this._setEnvironmentSpecular());
	});

	/**
	*设置透明混合度。
	*@param value 透明混合度。
	*/
	/**
	*获取透明混合度。
	*@return 透明混合度。
	*/
	__getset(0,__proto,'alphaBlending',function(){
		return this._alphaBlending;
		},function(value){
		this._alphaBlending=value;
		if (this._alphaBlending < 0)
			this._alphaBlending=0;
		if (this._alphaBlending > 1)
			this._alphaBlending=1;
	});

	__getset(0,__proto,'envDiffuseSHBlue',null,function(value){
		this.__ownerCamera._shaderValues.setValue(/*laya.d3.core.BaseCamera.DIFFUSEIRRADMATB*/12,value);
	});

	/**
	*设置颜色强度。
	*@param value 颜色强度。
	*/
	/**
	*获取颜色强度。
	*@return 颜色强度。
	*/
	__getset(0,__proto,'colorIntensity',function(){
		return this._colorIntensity;
		},function(value){
		this._colorIntensity=value;
		if (this._colorIntensity < 0)
			this._colorIntensity=0;
	});

	__getset(0,__proto,'envDiffuseSHGreen',null,function(value){
		this.__ownerCamera._shaderValues.setValue(/*laya.d3.core.BaseCamera.DIFFUSEIRRADMATG*/11,value);
	});

	__getset(0,__proto,'envDiffuseSHRed',null,function(value){
		this.__ownerCamera._shaderValues.setValue(/*laya.d3.core.BaseCamera.DIFFUSEIRRADMATR*/10,value);
	});

	/**
	*设置环境漫反射贴图。
	*@param value 环境漫反射贴图。
	*/
	/**
	*获取环境漫反射贴图。
	*@return 环境漫反射贴图。
	*/
	__getset(0,__proto,'environmentDiffuse',function(){
		return this._environmentDiffuse;
		},function(value){
		value.minFifter=/*laya.webgl.WebGLContext.NEAREST*/0x2600;
		this._environmentDiffuse=value;
		(this.__ownerCamera)&& (this._setEnvironmentDiffuse());
	});

	/**
	*设置环境高光贴图。
	*@param value 环境高光贴图。
	*/
	/**
	*获取环境高光贴图。
	*@return 环境高光贴图。
	*/
	__getset(0,__proto,'environmentSpecular',function(){
		return this._environmentSpecular;
		},function(value){
		this._environmentSpecular=value;
		(this.__ownerCamera)&& (this._setEnvironmentSpecular());
	});

	Sky.MVPMATRIX=0;
	Sky.INTENSITY=1;
	Sky.ALPHABLENDING=2;
	Sky.DIFFUSETEXTURE=3;
	return Sky;
})()


/**
*<code>SubMesh</code> 类用于创建子网格数据模板。
*/
//class laya.d3.resource.models.SubMesh
var SubMesh=(function(){
	function SubMesh(mesh){
		/**@private */
		this._mesh=null;
		/**@private */
		this._boneIndicesList=null;
		/**@private */
		this._subIndexBufferStart=null;
		/**@private */
		this._subIndexBufferCount=null;
		/**@private */
		this._skinAnimationDatas=null;
		/**@private */
		this._bufferUsage=null;
		/**@private */
		this._indexInMesh=0;
		/**@private */
		this._vertexBuffer=null;
		/**@private */
		this._vertexStart=0;
		/**@private */
		this._vertexCount=0;
		/**@private */
		this._indexBuffer=null;
		/**@private */
		this._indexStart=0;
		/**@private */
		this._indexCount=0;
		/**@private */
		this._indices=null;
		this._bufferUsage={};
		this._mesh=mesh;
		this._boneIndicesList=[];
		this._subIndexBufferStart=[];
		this._subIndexBufferCount=[];
	}

	__class(SubMesh,'laya.d3.resource.models.SubMesh');
	var __proto=SubMesh.prototype;
	Laya.imps(__proto,{"laya.d3.core.render.IRenderable":true,"laya.resource.IDispose":true})
	/**
	*@private
	*/
	__proto._getVertexBuffer=function(index){
		(index===void 0)&& (index=0);
		if (index===0)
			return this._vertexBuffer;
		else
		return null;
	}

	/**
	*@private
	*/
	__proto._getIndexBuffer=function(){
		return this._indexBuffer;
	}

	/**
	*@private
	*/
	__proto._getStaticBatchBakedVertexs=function(batchOwnerTransform,owner){
		var byteSizeInFloat=4;
		var vertexBuffer=this._vertexBuffer;
		var vertexDeclaration=vertexBuffer.vertexDeclaration;
		var positionOffset=vertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.VertexElementUsage.POSITION0*/0).offset / byteSizeInFloat;
		var normalOffset=vertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3).offset / byteSizeInFloat;
		var lightmapScaleOffset=owner.meshRender.lightmapScaleOffset;
		var i=0,n=0,bakedVertexes,bakedVertexFloatCount=0,lightingMapTexcoordOffset=0,uv1Element;
		var uv0Offset=0,oriVertexFloatCount=0;
		if (lightmapScaleOffset){
			uv1Element=vertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15);
			if (uv1Element){
				bakedVertexFloatCount=vertexDeclaration.vertexStride / byteSizeInFloat;
				if (this._vertexCount > 0)
					bakedVertexes=vertexBuffer.getData().slice(this._vertexStart *bakedVertexFloatCount,(this._vertexStart+this._vertexCount)*bakedVertexFloatCount);
				else
				bakedVertexes=vertexBuffer.getData().slice();
				lightingMapTexcoordOffset=uv1Element.offset / byteSizeInFloat;
				}else {
				oriVertexFloatCount=vertexDeclaration.vertexStride / byteSizeInFloat;
				bakedVertexFloatCount=oriVertexFloatCount+2;
				if (this._vertexCount)
					bakedVertexes=new Float32Array(this._vertexCount *(vertexBuffer.vertexDeclaration.vertexStride / byteSizeInFloat+2));
				else
				bakedVertexes=new Float32Array(vertexBuffer.vertexCount *(vertexBuffer.vertexDeclaration.vertexStride / byteSizeInFloat+2));
				uv0Offset=vertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2).offset / byteSizeInFloat;
				lightingMapTexcoordOffset=uv0Offset+2;
				var oriVertexes=vertexBuffer.getData();
				for (i=0,n=oriVertexes.length / oriVertexFloatCount;i < n;i++){
					var oriVertexOffset=0;
					if (this._vertexCount > 0)
						oriVertexOffset=(this._vertexStart+i)*oriVertexFloatCount;
					else
					oriVertexOffset=i *oriVertexFloatCount;
					var bakedVertexOffset=i *bakedVertexFloatCount;
					var j=0;
					for (j=0;j < lightingMapTexcoordOffset;j++)
					bakedVertexes[bakedVertexOffset+j]=oriVertexes[oriVertexOffset+j];
					for (j=lightingMapTexcoordOffset;j < oriVertexFloatCount;j++)
					bakedVertexes[bakedVertexOffset+j+2]=oriVertexes[oriVertexOffset+j];
				}
			}
			}else {
			bakedVertexFloatCount=vertexDeclaration.vertexStride / byteSizeInFloat;
			if (this._vertexCount)
				bakedVertexes=vertexBuffer.getData().slice(this._vertexStart *bakedVertexFloatCount,(this._vertexStart+this._vertexCount)*bakedVertexFloatCount);
			else
			bakedVertexes=vertexBuffer.getData().slice();
		}
		if (batchOwnerTransform){
			var rootMat=batchOwnerTransform.worldMatrix;
			var rootInvertMat=SubMesh._tempMatrix4x40;
			rootMat.invert(rootInvertMat);
			var result=SubMesh._tempMatrix4x41;
			var transform=owner.transform.worldMatrix;
			Matrix4x4.multiply(rootInvertMat,transform,result);
			}else {
			result=owner.transform.worldMatrix;
		};
		var rotation=SubMesh._tempQuaternion0;
		result.decomposeTransRotScale(SubMesh._tempVector30,rotation,SubMesh._tempVector31);
		for (i=0,n=bakedVertexes.length / bakedVertexFloatCount;i < n;i++){
			var posOffset=i *bakedVertexFloatCount+positionOffset;
			var norOffset=i *bakedVertexFloatCount+normalOffset;
			Utils3D.transformVector3ArrayToVector3ArrayCoordinate(bakedVertexes,posOffset,result,bakedVertexes,posOffset);
			Utils3D.transformVector3ArrayByQuat(bakedVertexes,norOffset,rotation,bakedVertexes,norOffset);
			if (lightmapScaleOffset){
				var lightingMapTexOffset=i *bakedVertexFloatCount+lightingMapTexcoordOffset;
				if (uv1Element){
					Utils3D.transformLightingMapTexcoordByUV1Array(bakedVertexes,lightingMapTexOffset,lightmapScaleOffset,bakedVertexes,lightingMapTexOffset);
					}else {
					var tex0Offset=i *oriVertexFloatCount+uv0Offset;
					Utils3D.transformLightingMapTexcoordByUV0Array(oriVertexes,tex0Offset,lightmapScaleOffset,bakedVertexes,lightingMapTexOffset);
				}
			}
		}
		return bakedVertexes;
	}

	/**
	*@private
	*/
	__proto._getVertexBuffers=function(){
		return null;
	}

	/**
	*@private
	*/
	__proto._beforeRender=function(state){
		this._vertexBuffer._bind();
		this._indexBuffer._bind();
		return true;
	}

	/**
	*@private
	*渲染。
	*@param state 渲染状态。
	*/
	__proto._render=function(state){
		var skinAnimationDatas;
		var indexCount=0;
		var renderElement=state.renderElement;
		if (this._indexCount > 1){
			var boneIndicesListCount=this._boneIndicesList.length;
			if (boneIndicesListCount > 1){
				for (var i=0;i < boneIndicesListCount;i++){
					skinAnimationDatas=renderElement._skinAnimationDatas || this._skinAnimationDatas;
					if (skinAnimationDatas){
						renderElement._shaderValue.setValue(/*laya.d3.core.SkinnedMeshSprite3D.BONES*/0,skinAnimationDatas[i]);
						state._shader.uploadRenderElementUniforms(renderElement._shaderValue.data);
					}
					WebGL.mainContext.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,this._subIndexBufferCount[i],/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,this._subIndexBufferStart[i] *2);
				}
				Stat.drawCall+=boneIndicesListCount;
				}else {
				skinAnimationDatas=renderElement._skinAnimationDatas || this._skinAnimationDatas;
				if (skinAnimationDatas){
					renderElement._shaderValue.setValue(/*laya.d3.core.SkinnedMeshSprite3D.BONES*/0,skinAnimationDatas[0]);
					state._shader.uploadRenderElementUniforms(renderElement._shaderValue.data);
				}
				WebGL.mainContext.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,this._indexCount,/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,this._indexStart *2);
				Stat.drawCall++;
			}
			indexCount=this._indexCount;
			}else {
			indexCount=this._indexBuffer.indexCount;
			skinAnimationDatas=renderElement._skinAnimationDatas || this._skinAnimationDatas;
			if (skinAnimationDatas){
				renderElement._shaderValue.setValue(/*laya.d3.core.SkinnedMeshSprite3D.BONES*/0,skinAnimationDatas[0]);
				state._shader.uploadRenderElementUniforms(renderElement._shaderValue.data);
			}
			WebGL.mainContext.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,indexCount,/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,0);
			Stat.drawCall++;
		}
		Stat.trianglesFaces+=indexCount / 3;
	}

	/**
	*@private
	*/
	__proto.getIndices=function(){
		if (this._indexCount > 0)
			return this._indices;
		else
		return this._indexBuffer.getData();
	}

	/**
	*<p>彻底清理资源。</p>
	*<p><b>注意：</b>会强制解锁清理。</p>
	*/
	__proto.dispose=function(){
		this._indexBuffer.destroy();
		this._vertexBuffer.destroy();
		this._mesh=null;
		this._boneIndicesList=null;
		this._subIndexBufferStart=null;
		this._subIndexBufferCount=null;
		this._skinAnimationDatas=null;
		this._bufferUsage=null;
		this._vertexBuffer=null;
		this._indexBuffer=null;
	}

	/**
	*@private
	*/
	__getset(0,__proto,'_vertexBufferCount',function(){
		return 1;
	});

	/**
	*@private
	*/
	__getset(0,__proto,'triangleCount',function(){
		return this._indexBuffer.indexCount / 3;
	});

	__static(SubMesh,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempVector31',function(){return this._tempVector31=new Vector3();},'_tempQuaternion0',function(){return this._tempQuaternion0=new Quaternion();},'_tempMatrix4x40',function(){return this._tempMatrix4x40=new Matrix4x4();},'_tempMatrix4x41',function(){return this._tempMatrix4x41=new Matrix4x4();}
	]);
	return SubMesh;
})()


/**
*@private
*/
//class laya.d3.shader.ShaderDefines
var ShaderDefines$1=(function(){
	function ShaderDefines(shaderdefines){
		/**@private [只读]*/
		this.defineCounter=0;
		/**@private [只读]*/
		this.defines=null;
		if (shaderdefines){
			this.defineCounter=shaderdefines.defineCounter;
			this.defines=shaderdefines.defines.slice();
			}else {
			this.defineCounter=0;
			this.defines=[];
		}
	}

	__class(ShaderDefines,'laya.d3.shader.ShaderDefines',null,'ShaderDefines$1');
	var __proto=ShaderDefines.prototype;
	/**
	*@private
	*/
	__proto.registerDefine=function(name){
		var value=Math.pow(2,this.defineCounter++);
		this.defines[value]=name;
		return value;
	}

	return ShaderDefines;
})()


/**
*@private
*<code>ShaderInit</code> 类用于初始化内置Shader。
*/
//class laya.d3.shader.ShaderInit3D
var ShaderInit3D=(function(){
	/**
	*创建一个 <code>ShaderInit</code> 实例。
	*/
	function ShaderInit3D(){}
	__class(ShaderInit3D,'laya.d3.shader.ShaderInit3D');
	ShaderInit3D.__init__=function(){
		ShaderCompile3D._globalRegDefine("HIGHPRECISION",ShaderCompile3D.SHADERDEFINE_HIGHPRECISION);
		ShaderCompile3D._globalRegDefine("FOG",ShaderCompile3D.SHADERDEFINE_FOG);
		ShaderCompile3D._globalRegDefine("DIRECTIONLIGHT",ShaderCompile3D.SHADERDEFINE_DIRECTIONLIGHT);
		ShaderCompile3D._globalRegDefine("POINTLIGHT",ShaderCompile3D.SHADERDEFINE_POINTLIGHT);
		ShaderCompile3D._globalRegDefine("SPOTLIGHT",ShaderCompile3D.SHADERDEFINE_SPOTLIGHT);
		ShaderCompile3D._globalRegDefine("UV",ShaderCompile3D.SHADERDEFINE_UV0);
		ShaderCompile3D._globalRegDefine("COLOR",ShaderCompile3D.SHADERDEFINE_COLOR);
		ShaderCompile3D._globalRegDefine("UV1",ShaderCompile3D.SHADERDEFINE_UV1);
		ShaderCompile3D._globalRegDefine("CASTSHADOW",ParallelSplitShadowMap.SHADERDEFINE_CAST_SHADOW);
		ShaderCompile3D._globalRegDefine("SHADOWMAP_PSSM1",ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM1);
		ShaderCompile3D._globalRegDefine("SHADOWMAP_PSSM2",ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM2);
		ShaderCompile3D._globalRegDefine("SHADOWMAP_PSSM3",ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM3);
		ShaderCompile3D._globalRegDefine("SHADOWMAP_PCF_NO",ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF_NO);
		ShaderCompile3D._globalRegDefine("SHADOWMAP_PCF1",ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF1);
		ShaderCompile3D._globalRegDefine("SHADOWMAP_PCF2",ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF2);
		ShaderCompile3D._globalRegDefine("SHADOWMAP_PCF3",ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF3);
		ShaderCompile3D._globalRegDefine("DEPTHFOG",ShaderCompile3D.SAHDERDEFINE_DEPTHFOG);
		Shader3D.addInclude("LightHelper.glsl","\nstruct DirectionLight\n{\n vec3 Direction;\n vec3 Diffuse;\n};\n\nstruct PointLight\n{\n vec3 Diffuse;\n vec3 Attenuation;\n vec3 Position;\n float Range;\n};\n\nstruct SpotLight\n{\n vec3 Diffuse;\n vec3 Attenuation;\n vec3 Position;\n vec3 Direction;\n float Spot;\n float Range;\n};\n\n\nvec3 NormalSampleToWorldSpace(vec3 normalMapSample, vec3 unitNormal, vec3 tangent)\n{\n	vec3 normalT = 2.0*normalMapSample - 1.0;\n\n	// Build orthonormal basis.\n	vec3 N = normalize(unitNormal);\n	vec3 T = normalize(tangent- dot(tangent, N)*N);\n	vec3 B = cross(T, N);\n\n	mat3 TBN = mat3(T, B, N);\n\n	// Transform from tangent space to world space.\n	vec3 bumpedNormal = TBN*normalT;\n\n	return bumpedNormal;\n}\n\n\nvoid  computeDirectionLight(in vec3 matDif,in vec3 matAmb,in vec4 matSpe,in DirectionLight dirLight,in vec3 ambinentColor,in vec3 normal,in vec3 toEye,out vec3 dif,out vec3 amb,out vec3 spec)\n{\n	dif=vec3(0.0);//不初始化在IOS中闪烁，PC中不会闪烁\n	amb=vec3(0.0);\n	spec=vec3(0.0);\n	vec3 lightVec=-normalize(dirLight.Direction);\n	\n	amb=matAmb*ambinentColor;\n	\n	float  diffuseFactor=dot(lightVec, normal);\n	\n	if(diffuseFactor>0.0)\n	{\n	   vec3 v = reflect(-lightVec, normal);\n	   float specFactor = pow(max(dot(v, toEye), 0.0), matSpe.w);\n	   \n	   dif = diffuseFactor * matDif * dirLight.Diffuse;\n	   spec = specFactor * matSpe.rgb;\n	}\n	\n}\n\nvoid computePointLight(in vec3 matDif,in vec3 matAmb,in vec4 matSpe,in PointLight poiLight,in vec3 ambinentColor, in vec3 pos,in vec3 normal,in vec3 toEye,out vec3 dif,out vec3 amb,out vec3 spec)\n{\n	dif=vec3(0.0);\n	amb=vec3(0.0);\n	spec=vec3(0.0);\n	vec3 lightVec = poiLight.Position - pos;\n		\n	float d = length(lightVec);\n	\n	if( d > poiLight.Range )\n		return;\n		\n	lightVec /= d; \n	\n	amb = matAmb*ambinentColor;	\n\n	float diffuseFactor = dot(lightVec, normal);\n\n	if( diffuseFactor > 0.0 )\n	{\n		vec3 v= reflect(-lightVec, normal);\n		float specFactor = pow(max(dot(v, toEye), 0.0), matSpe.w);\n					\n		dif = diffuseFactor * matDif * poiLight.Diffuse;\n		spec = specFactor * matSpe.rgb;\n	}\n\n	float attenuate = 1.0 / dot(poiLight.Attenuation, vec3(1.0, d, d*d));\n\n	dif *= attenuate;\n	spec*= attenuate;\n}\n\nvoid ComputeSpotLight(in vec3 matDif,in vec3 matAmb,in vec4 matSpe,in SpotLight spoLight,in vec3 ambinentColor,in vec3 pos, in vec3 normal,in vec3 toEye,out vec3 dif,out vec3 amb,out vec3 spec)\n{\n	amb = vec3(0.0);\n	dif =vec3(0.0);\n	spec= vec3(0.0);\n	vec3 lightVec = spoLight.Position - pos;\n		\n	float d = length(lightVec);\n	\n	if( d > spoLight.Range)\n		return;\n		\n	lightVec /= d; \n	\n	amb = matAmb*ambinentColor;	\n\n	float diffuseFactor = dot(lightVec, normal);\n\n	if(diffuseFactor > 0.0)\n	{\n		vec3 v= reflect(-lightVec, normal);\n		float specFactor = pow(max(dot(v, toEye), 0.0), matSpe.w);\n					\n		dif = diffuseFactor * matDif * spoLight.Diffuse;\n		spec = specFactor * matSpe.rgb;\n	}\n	\n	float spot = pow(max(dot(-lightVec, normalize(spoLight.Direction)), 0.0), spoLight.Spot);\n\n	float attenuate = spot/dot(spoLight.Attenuation, vec3(1.0, d, d*d));\n\n	amb *= spot;\n	dif *= attenuate;\n	spec*= attenuate;\n}\n\n");
		Shader3D.addInclude("Lighting.glsl","\nstruct DirectionLight\n{\n	vec3 Color;\n	vec3 Direction;\n};\n\nstruct PointLight\n{\n	vec3 Color;\n	vec3 Position;\n	float Range;\n};\n\nstruct SpotLight\n{\n	vec3 Color;\n	vec3 Position;\n	vec3 Direction;\n	float Spot;\n	float Range;\n};\n\n// U3D中使用衰减纹理,此函数模拟并非正确\n//float U3DAttenuation(in vec3 L,in float invLightRadius)\n//{\n//	float fRatio = clamp(length(L) * invLightRadius,0.0,1.0);\n//	fRatio *= fRatio;\n//	return 1.0 / (1.0 + 25.0 * fRatio)* clamp(4.0*(1.0 - fRatio),0.0,1.0); //fade to black as if 4 pixel texture\n//} \n\n// Same as Just Cause 2 and Crysis 2 (you can read GPU Pro 1 book for more information)\nfloat BasicAttenuation(in vec3 L,in float invLightRadius)\n{\n	vec3 distance = L * invLightRadius;\n	float attenuation = clamp(1.0 - dot(distance, distance),0.0,1.0); // Equals float attenuation = saturate(1.0f - dot(L, L) / (lightRadius *  lightRadius)); 	\n	return attenuation * attenuation;\n} \n\n// Inspired on http://fools.slindev.com/viewtopic.php?f=11&t=21&view=unread#unread	\nfloat NaturalAttenuation(in vec3 L,in float invLightRadius)\n{\n	float attenuationFactor = 30.0;\n	vec3 distance = L * invLightRadius;\n	float attenuation = dot(distance, distance); // Equals float attenuation = dot(L, L) / (lightRadius *  lightRadius);\n	attenuation = 1.0 / (attenuation * attenuationFactor + 1.0);\n	// Second we move down the function therewith it reaches zero at abscissa 1:\n	attenuationFactor = 1.0 / (attenuationFactor + 1.0); //attenuationFactor contains now the value we have to subtract\n	attenuation = max(attenuation - attenuationFactor, 0.0); // The max fixes a bug.\n	// Finally we expand the equation along the y-axis so that it starts with a function value of 1 again.\n	attenuation /= 1.0 - attenuationFactor;\n	return attenuation;\n} \n\nvoid LayaAirBlinnPhongLight (in vec3 specColor,in float specColorIntensity,in vec3 normal,in vec3 gloss, in vec3 viewDir,in vec3 lightColor, in vec3 lightVec,out vec3 diffuseColor,out vec3 specularColor)\n{\n    mediump vec3 h = normalize(viewDir-lightVec);\n    lowp float ln = max (0.0, dot (-lightVec,normal));\n    float nh = max (0.0, dot (h,normal));\n	diffuseColor=lightColor * ln;\n	specularColor=lightColor *specColor*pow (nh, specColorIntensity*128.0) * gloss;\n}\n\nvoid LayaAirBlinnPhongDiectionLight (in vec3 specColor,in float specColorIntensity,in vec3 normal,in vec3 gloss, in vec3 viewDir, in DirectionLight light,out vec3 diffuseColor,out vec3 specularColor)\n{\n	vec3 lightVec=normalize(light.Direction);\n	LayaAirBlinnPhongLight(specColor,specColorIntensity,normal,gloss,viewDir,light.Color,lightVec,diffuseColor,specularColor);\n}\n\nvoid LayaAirBlinnPhongPointLight (in vec3 pos,in vec3 specColor,in float specColorIntensity,in vec3 normal,in vec3 gloss, in vec3 viewDir, in PointLight light,out vec3 diffuseColor,out vec3 specularColor)\n{\n	vec3 lightVec =  pos-light.Position;\n	//if( length(lightVec) > light.Range )\n	//	return;\n	LayaAirBlinnPhongLight(specColor,specColorIntensity,normal,gloss,viewDir,light.Color,lightVec/length(lightVec),diffuseColor,specularColor);\n	float attenuate = BasicAttenuation(lightVec, 1.0/light.Range);\n	diffuseColor *= attenuate;\n	specularColor*= attenuate;\n}\n\nvoid LayaAirBlinnPhongSpotLight (in vec3 pos,in vec3 specColor,in float specColorIntensity,in vec3 normal,in vec3 gloss, in vec3 viewDir, in SpotLight light,out vec3 diffuseColor,out vec3 specularColor)\n{\n	vec3 lightVec =  pos-light.Position;\n	//if( length(lightVec) > light.Range )\n	//	return;\n	vec3 normalLightVec=lightVec/length(lightVec);\n	LayaAirBlinnPhongLight(specColor,specColorIntensity,normal,gloss,viewDir,light.Color,normalLightVec,diffuseColor,specularColor);\n	float spot = pow(max(dot(normalLightVec, normalize(light.Direction)), 0.0), light.Spot);\n	float attenuate = spot*BasicAttenuation(lightVec, 1.0/light.Range);\n	diffuseColor *= attenuate;\n	specularColor*= attenuate;\n}\n\nvec3 NormalSampleToWorldSpace(vec3 normalMapSample, vec3 unitNormal, vec3 tangent,vec3 binormal)\n{\n	vec3 normalT =vec3(2.0*normalMapSample.x - 1.0,1.0-2.0*normalMapSample.y,2.0*normalMapSample.z - 1.0);\n	\n	// Build orthonormal basis.\n	vec3 N = normalize(unitNormal);\n	vec3 T = normalize(tangent);\n	vec3 B = normalize(binormal);\n	mat3 TBN = mat3(T, B, N);\n	\n	// Transform from tangent space to world space.\n	vec3 bumpedNormal = TBN*normalT;\n\n	return bumpedNormal;\n}\n\n\n");
		Shader3D.addInclude("ShadowHelper.glsl","uniform sampler2D u_shadowMap1;\nuniform sampler2D u_shadowMap2;\nuniform sampler2D u_shadowMap3;\nuniform vec2	  u_shadowPCFoffset;\nuniform vec3     u_shadowPSSMDistance;\nvec4 packDepth(const in float depth)\n{\n	const vec4 bitShift = vec4(256.0*256.0*256.0, 256.0*256.0, 256.0, 1.0);\n	const vec4 bitMask	= vec4(0.0, 1.0/256.0, 1.0/256.0, 1.0/256.0);\n	vec4 res = mod(depth*bitShift*vec4(255), vec4(256))/vec4(255);\n	res -= res.xxyz * bitMask;\n	return res;\n}\nfloat unpackDepth(const in vec4 rgbaDepth)\n{\n	const vec4 bitShift = vec4(1.0/(256.0*256.0*256.0), 1.0/(256.0*256.0), 1.0/256.0, 1.0);\n	float depth = dot(rgbaDepth, bitShift);\n	return depth;\n}\nfloat tex2DPCF( sampler2D shadowMap,vec2 texcoord,vec2 invsize,float zRef )\n{\n	vec2 texelpos =texcoord / invsize;\n	vec2 lerps = fract( texelpos );\n	float sourcevals[4];\n	sourcevals[0] = float( unpackDepth(texture2D(shadowMap,texcoord)) > zRef );\n	sourcevals[1] = float( unpackDepth(texture2D(shadowMap,texcoord + vec2(invsize.x,0))) > zRef );\n	sourcevals[2] = float( unpackDepth(texture2D(shadowMap,texcoord + vec2(0,invsize.y))) > zRef );\n	sourcevals[3] = float( unpackDepth(texture2D(shadowMap,texcoord + vec2(invsize.x, invsize.y) )) > zRef );\n	return mix( mix(sourcevals[0],sourcevals[2],lerps.y),mix(sourcevals[1],sourcevals[3],lerps.y),lerps.x );\n}\nfloat getShadowPSSM3( sampler2D shadowMap1,sampler2D shadowMap2,sampler2D shadowMap3,mat4 lightShadowVP[4],vec3 pssmDistance,vec2 shadowPCFOffset,vec3 worldPos,float posViewZ,float zBias )\n{\n	float value = 1.0;\n	int nPSNum = int(posViewZ>pssmDistance.x);\n	nPSNum += int(posViewZ>pssmDistance.y);\n	nPSNum += int(posViewZ>pssmDistance.z);\n	//真SB,webgl不支持在PS中直接访问数组\n	mat4 lightVP;\n	if( nPSNum == 0 )\n	{\n		lightVP = lightShadowVP[1];\n	}\n	else if( nPSNum == 1 )\n	{\n		lightVP = lightShadowVP[2];\n	}\n	else if( nPSNum == 2 )\n	{\n		lightVP = lightShadowVP[3];\n	}\n	vec4 vLightMVPPos = lightVP * vec4(worldPos,1.0);\n	//为了效率，在CPU计算/2.0 + 0.5\n	//vec3 vText = (vLightMVPPos.xyz / vLightMVPPos.w)/2.0 + 0.5;\n	vec3 vText = vLightMVPPos.xyz / vLightMVPPos.w;\n	float fMyZ = vText.z - zBias;\n	/*\n	bvec4 bInFrustumVec = bvec4 ( vText.x >= 0.0, vText.x <= 1.0, vText.y >= 0.0, vText.y <= 1.0 );\n	bool bInFrustum = all( bInFrustumVec );\n	bvec2 bFrustumTestVec = bvec2( bInFrustum, fMyZ <= 1.0 );\n	bool bFrustumTest = all( bFrustumTestVec );\n	if ( bFrustumTest ) \n	*/\n	if( fMyZ <= 1.0 )\n	{\n		float zdepth=0.0;\n#ifdef SHADOWMAP_PCF3\n		if ( nPSNum == 0 )\n		{\n			value =  tex2DPCF( shadowMap1, vText.xy,shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.xy),shadowPCFOffset,	fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.x,0),shadowPCFOffset,	fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(0,shadowPCFOffset.y),shadowPCFOffset,	fMyZ );\n			value = value/4.0;\n		} \n		else if( nPSNum == 1 )\n		{\n			value = tex2DPCF( shadowMap2,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 2 )\n		{\n			vec4 color = texture2D( shadowMap3,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n#endif\n#ifdef SHADOWMAP_PCF2\n		if ( nPSNum == 0 )\n		{\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 1 )\n		{\n			value = tex2DPCF( shadowMap2,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 2 )\n		{\n			vec4 color = texture2D( shadowMap3,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n\n#endif\n#ifdef SHADOWMAP_PCF1\n		if ( nPSNum == 0 )\n		{\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 1 )\n		{\n			vec4 color = texture2D( shadowMap2,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n		else if( nPSNum == 2 )\n		{\n			vec4 color = texture2D( shadowMap3,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n#endif\n#ifdef SHADOWMAP_PCF_NO\n		vec4 color;\n		if ( nPSNum == 0 )\n		{\n			color = texture2D( shadowMap1,vText.xy );\n		}\n		else if( nPSNum == 1 )\n		{\n			color = texture2D( shadowMap2,vText.xy );\n		}\n		else if( nPSNum == 2 )\n		{\n			color = texture2D( shadowMap3,vText.xy );\n		}\n		zdepth = unpackDepth(color);\n		value = float(fMyZ < zdepth);\n#endif\n	}\n	return value;\n}\nfloat getShadowPSSM2( sampler2D shadowMap1,sampler2D shadowMap2,mat4 lightShadowVP[4],vec3 pssmDistance,vec2 shadowPCFOffset,vec3 worldPos,float posViewZ,float zBias )\n{\n	float value = 1.0;\n	int nPSNum = int(posViewZ>pssmDistance.x);\n	nPSNum += int(posViewZ>pssmDistance.y);\n	//真SB,webgl不支持在PS中直接访问数组\n	mat4 lightVP;\n	if( nPSNum == 0 )\n	{\n		lightVP = lightShadowVP[1];\n	}\n	else if( nPSNum == 1 )\n	{\n		lightVP = lightShadowVP[2];\n	}\n	vec4 vLightMVPPos = lightVP * vec4(worldPos,1.0);\n	//为了效率，在CPU计算/2.0 + 0.5\n	//vec3 vText = (vLightMVPPos.xyz / vLightMVPPos.w)/2.0 + 0.5;\n	vec3 vText = vLightMVPPos.xyz / vLightMVPPos.w;\n	float fMyZ = vText.z - zBias;\n	/*\n	bvec4 bInFrustumVec = bvec4 ( vText.x >= 0.0, vText.x <= 1.0, vText.y >= 0.0, vText.y <= 1.0 );\n	bool bInFrustum = all( bInFrustumVec );\n	bvec2 bFrustumTestVec = bvec2( bInFrustum, fMyZ <= 1.0 );\n	bool bFrustumTest = all( bFrustumTestVec );\n	if ( bFrustumTest ) \n	*/\n	if( fMyZ <= 1.0 )\n	{\n		float zdepth=0.0;\n#ifdef SHADOWMAP_PCF3\n		if ( nPSNum == 0 )\n		{\n			value =  tex2DPCF( shadowMap1, vText.xy,shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.xy),shadowPCFOffset,	fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.x,0),shadowPCFOffset,	fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(0,shadowPCFOffset.y),shadowPCFOffset,	fMyZ );\n			value = value/4.0;\n		}\n		else if( nPSNum == 1 )\n		{\n			value = tex2DPCF( shadowMap2,vText.xy,shadowPCFOffset,fMyZ);\n		}\n#endif\n#ifdef SHADOWMAP_PCF2\n		if ( nPSNum == 0 )\n		{\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 1 )\n		{\n			value = tex2DPCF( shadowMap2,vText.xy,shadowPCFOffset,fMyZ);\n		}\n#endif\n#ifdef SHADOWMAP_PCF1\n		if ( nPSNum == 0 )\n		{\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 1 )\n		{\n			vec4 color = texture2D( shadowMap2,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n#endif\n#ifdef SHADOWMAP_PCF_NO\n		vec4 color;\n		if ( nPSNum == 0 )\n		{\n			color = texture2D( shadowMap1,vText.xy );\n		}\n		else if( nPSNum == 1 )\n		{\n			color = texture2D( shadowMap2,vText.xy );\n		}\n		zdepth = unpackDepth(color);\n		value = float(fMyZ < zdepth);\n#endif\n	}\n	return value;\n}\nfloat getShadowPSSM1( sampler2D shadowMap1,vec4 lightMVPPos,vec3 pssmDistance,vec2 shadowPCFOffset,float posViewZ,float zBias )\n{\n	float value = 1.0;\n	if( posViewZ < pssmDistance.x )\n	{\n		vec3 vText = lightMVPPos.xyz / lightMVPPos.w;\n		float fMyZ = vText.z - zBias;\n		/*\n		bvec4 bInFrustumVec = bvec4 ( vText.x >= 0.0, vText.x <= 1.0, vText.y >= 0.0, vText.y <= 1.0 );\n		bool bInFrustum = all( bInFrustumVec );\n		bvec2 bFrustumTestVec = bvec2( bInFrustum, fMyZ <= 1.0 );\n		bool bFrustumTest = all( bFrustumTestVec );\n		*/\n		if ( fMyZ <= 1.0 ) \n		{\n			float zdepth=0.0;\n#ifdef SHADOWMAP_PCF3\n			value =  tex2DPCF( shadowMap1, vText.xy,shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.xy),shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.x,0),shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(0,shadowPCFOffset.y),shadowPCFOffset,fMyZ );\n			value = value/4.0;\n#endif\n#ifdef SHADOWMAP_PCF2		\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n#endif\n#ifdef SHADOWMAP_PCF1\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n#endif\n#ifdef SHADOWMAP_PCF_NO		\n			vec4 color = texture2D( shadowMap1,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n#endif\n		}\n	}\n	return value;\n}");
		Shader3D.addInclude("WaveFunction.glsl","\nuniform vec2 u_WaveInfoD[20];\nuniform vec4 u_WaveInfo[20];\n\nuniform float TEXWAVE_UV_SCALE ;//= 20.0; //每texwidth像素代表的实际距离\n/**\n	这里的计算都是\n*/\n\n/**\n* 计算一个波形\n*  开始计算的时候都按照z向上，最后输出的时候，颠倒一下。\n* @param tm {float} 毫秒\n*/\nvoid calcGerstnerWave(float curtm, vec3 pos, float deep, vec2 uvpos, out vec3 opos, out vec3 B, out vec3 T, out vec3 N, out float foamS){\n	float tm = curtm/1000.;\n	opos = pos;\n	vec3 wpos=vec3(0.);		//累加的位置\n	N=vec3(0.,0.,0.);	//输出的法线初始化一下\n	T=vec3(0.,0.,0.);\n	B=vec3(0.,0.,0.);\n	vec2 cD ;//= D;\n	//float deepAtt = max(0.,min(deep,1.0));\n	//A*=deepAtt; //TODO\n	\n	for( int i=0; i<4; i++){\n		cD = u_WaveInfoD[i];//vec2(wi.winfo[0],wi.winfo[1]);// wi.vDir;\n		float Q = u_WaveInfo[i].x;//wi.QorK;\n		float A = u_WaveInfo[i].y;//wi.A;\n		float W = u_WaveInfo[i].z;//wi.omega;\n		float P = u_WaveInfo[i].w;//wi.phi;\n		float dop = dot(cD,uvpos);\n		float c = cos(dop*W - tm*P);//TODO 优化\n		float s = sin(dop*W - tm*P);\n		float AWs = A*W*s;\n		float AWc = A*W*c;\n		float _QxyAWs = -Q*cD.x*cD.y*AWs;\n		\n		wpos += vec3(Q*A*cD.x*c,\n					Q*A*cD.y*c,\n					A*s);\n		N += vec3(-cD.x*AWc,\n				-cD.y*AWc,\n				Q*AWs);//记得最后1-\n		T += vec3(_QxyAWs,\n				Q*cD.y*cD.y*AWs,//记得1-\n				cD.y*AWc\n			);\n		B += vec3(Q*cD.x*cD.x*AWs,//记得1-\n				_QxyAWs,\n				cD.x*AWc\n			);\n		//float v1 = exp(-tan((dop*W - tm*P)/2.+1.07));//除2，+pi/2 这样正好能对齐\n#ifdef USE_FOAM		\n		float v1 = 0.5-sin((dop*W - tm*P)/1.+2.0)/2.;\n		foamS += pow(v1,9.)/4.;\n#endif\n	}\n	T.y=1.-T.y; B.x=1.-B.x;N.z=1.-N.z;\n	opos += vec3(wpos.x,wpos.z*min(deep/10.,1.),wpos.y);\n	//y和z交换一下。现在根据uv计算的位置，所以直接交换yz就行。其他情况下有问题么\n	T.xyz=T.xzy;\n	B.xyz=B.xzy;\n	N.xyz=N.xzy;\n}\n\n\nvoid calcWave(float curtm, vec2 uv, out vec3 B, out vec3 T, out vec3 N){\n	float tm = curtm/1000.;\n	N=vec3(0.,0.,0.);	//输出的法线初始化一下\n	vec2 uvpos = uv*TEXWAVE_UV_SCALE; //TODO 这个范围是什么 就是1？\n	uvpos.y*=-1.;\n	vec2 cD;// = D;\n	const int NumWaves = 4;\n	float scale = 1./float(NumWaves);\n	for( int i=0; i<NumWaves; i++){\n		cD = u_WaveInfoD[i];//vec2(wi.winfo[0],wi.winfo[1]);// wi.vDir;\n		float k = 1.5;//u_WaveInfo[i].x;//wi.QorK; TODO  不知道为什么，这个取u_WaveInfo[i].x，在mi3w上就会闪。测试发现实际值也传过来了，就是1.5\n		float A = u_WaveInfo[i].y;//wi.A;\n		float W = u_WaveInfo[i].z;//wi.omega;\n		float P = u_WaveInfo[i].w;//wi.phi;\n		\n		float dop = dot(cD,uvpos);\n		float c = cos(dop*W - tm*P);//TODO 优化\n		float s = sin(dop*W - tm*P);\n		/*\n		float AWs = A*W*s;\n		float AWc = A*W*c;\n		float _QxyAWs = -Q*cD.x*cD.y*AWs;\n		\n		N += vec3(-cD.x*AWc,\n				-cD.y*AWc,\n				Q*AWs);//记得最后1-\n		*/\n		float kWAc = scale*c;//k*W*A*c;  为了提高精度，这里只保留sin，cos部分，实际使用的时候再乘回来。\n		//float kWAc = k*W*A*c;  \n		N += vec3(\n			-kWAc*cD.x*pow((s+1.)/2.,k-1.),\n			-kWAc*cD.y*pow((s+1.)/2.,k-1.),\n			1.\n		);\n	}\n	//N.z=1.-N.z;\n	//y和z交换一下。现在根据uv计算的位置，所以直接交换yz就行。其他情况下有问题么\n	N.xyz=N.xzy;\n}\n");
		Shader3D.addInclude("BRDF.glsl","vec4 LayaAirBRDF(in vec3 diffuseColor, in vec3 specularColor, in float oneMinusReflectivity, in float smoothness, in vec3 normal, in vec3 viewDir, in vec3 lightDir, in vec3 lightColor, in vec3 gi)\n{\n	float perceptualRoughness = SmoothnessToPerceptualRoughness(smoothness);\n	vec3 halfDir = SafeNormalize(viewDir - lightDir);\n	\n	float nv = abs(dot(normal, viewDir));\n	\n	float nl = clamp(dot(normal,   -lightDir),  0.0, 1.0);\n	float nh = clamp(dot(normal,     halfDir),  0.0, 1.0);\n	float lv = clamp(dot(lightDir,   viewDir),  0.0, 1.0);\n	float lh = clamp(dot(lightDir,  -halfDir),  0.0, 1.0);\n	\n	float diffuseTerm = DisneyDiffuse(nv, nl, lh, perceptualRoughness) * nl;\n	\n	float roughness = PerceptualRoughnessToRoughness(perceptualRoughness);\n	\n	//#if UNITY_BRDF_GGX\n	float V = SmithJointGGXVisibilityTerm(nl, nv, roughness);\n	float D = GGXTerm(nh, roughness);\n	\n	float specularTerm = V * D * PI;\n	\n	specularTerm = sqrt(max(0.0001, specularTerm));\n	specularTerm = max(0.0, specularTerm * nl);\n	\n	vec4 color;\n	color.rgb = diffuseColor * (gi + lightColor * diffuseTerm) + specularTerm * lightColor * FresnelTerm (specularColor, lh);\n	\n	color.a = 1.0;\n	return color;\n}");
		Shader3D.addInclude("PBRUtils.glsl","struct DirectionLight\n{\n	vec3 Color;\n	vec3 Direction;\n};\n\nvec3 UnpackScaleNormal(in vec2 uv0)\n{\n	#ifdef NORMALTEXTURE\n		vec3 normalT;\n		vec4 normalMapSample = texture2D(u_NormalTexture, uv0);\n		normalT.x = 2.0 * normalMapSample.x - 1.0;\n		normalT.y = 1.0 - 2.0 * normalMapSample.y;\n		normalT.xy *= u_normalScale;\n		normalT.z = sqrt(1.0 - clamp(dot(normalT.xy, normalT.xy), 0.0, 1.0));\n		\n		vec3 T = normalize(v_Tangent);\n		vec3 B = normalize(v_Binormal);\n		vec3 N = normalize(v_Normal);\n		mat3 TBN = mat3(T, B, N);\n		\n		vec3 bumpedNormal = TBN * normalize(normalT);\n		return bumpedNormal;\n	#else\n		return normalize(v_Normal);\n	#endif\n}\n\nvec4 DielectricSpecularColor = vec4(0.220916301, 0.220916301, 0.220916301, 1.0 - 0.220916301);\n\nfloat PI = 3.14159265359;\n\nvec3 FresnelTerm (in vec3 F0, in float cosA)\n{\n	return F0 + (vec3(1.0) - F0) * pow(1.0 - cosA, 5.0);\n}\n\nfloat PerceptualRoughnessToRoughness(in float perceptualRoughness)\n{\n	return perceptualRoughness * perceptualRoughness;\n}\n\nfloat PerceptualRoughnessToSpecularPower(in float perceptualRoughness)\n{\n	float m = PerceptualRoughnessToRoughness(perceptualRoughness);\n	float sq = max(0.0001, m * m);\n	float n = (2.0 / sq) - 2.0;\n	n = max(n, 0.0001);\n	return n;\n}\n\nfloat RoughnessToPerceptualRoughness(in float roughness)\n{\n	return sqrt(roughness);\n}\n\nfloat SmoothnessToRoughness(in float smoothness)\n{\n	return (1.0 - smoothness) * (1.0 - smoothness);\n}\n\nfloat SmoothnessToPerceptualRoughness(in float smoothness)\n{\n	return (1.0 - smoothness);\n}\n\nvec3 SafeNormalize(in vec3 inVec)\n{\n	float dp3 = max(0.001,dot(inVec,inVec));\n	return inVec * (1.0 / sqrt(dp3));\n}\n\nfloat DisneyDiffuse(in float NdotV, in float NdotL, in float LdotH, in float perceptualRoughness)\n{\n	float fd90 = 0.5 + 2.0 * LdotH * LdotH * perceptualRoughness;\n	float lightScatter	= (1.0 + (fd90 - 1.0) * pow(1.0 - NdotL,5.0));\n	float viewScatter	= (1.0 + (fd90 - 1.0) * pow(1.0 - NdotV,5.0));\n\n	return lightScatter * viewScatter;\n}\n\nfloat SmithJointGGXVisibilityTerm (float NdotL, float NdotV, float roughness)\n{\n	float a = roughness;\n	float lambdaV = NdotL * (NdotV * (1.0 - a) + a);\n	float lambdaL = NdotV * (NdotL * (1.0 - a) + a);\n\n	return 0.5 / (lambdaV + lambdaL + 0.00001);\n}\n\nfloat GGXTerm (float NdotH, float roughness)\n{\n	float a2 = roughness * roughness;\n	float d = (NdotH * a2 - NdotH) * NdotH + 1.0;\n	return 0.31830988618 * a2 / (d * d + 0.0000001);\n}\n\nfloat OneMinusReflectivityFromMetallic(in float metallic)\n{\n	float oneMinusDielectricSpec = DielectricSpecularColor.a;\n	return oneMinusDielectricSpec - metallic * oneMinusDielectricSpec;\n}\n\nfloat SpecularStrength(vec3 specular)\n{\n    //(SHADER_TARGET < 30)return specular.r; \n    return max (max (specular.r, specular.g), specular.b);\n}\n\nvec3 DiffuseAndSpecularFromMetallic(in vec3 diffuseColor, in float metallic, out vec3 specularColor, out float oneMinusReflectivity)\n{\n	specularColor = mix(DielectricSpecularColor.rgb, diffuseColor, metallic);\n	oneMinusReflectivity = OneMinusReflectivityFromMetallic(metallic);\n	return diffuseColor * oneMinusReflectivity;\n}\n\nvec3 EnergyConservationBetweenDiffuseAndSpecular(in vec3 diffuseColor, in vec3 specularColor, out float oneMinusReflectivity)\n{\n	oneMinusReflectivity = 1.0 - SpecularStrength(specularColor);\n	return diffuseColor * oneMinusReflectivity;\n}\n\nvec4 Occlusion(in vec2 uv0){\n	#ifdef OCCLUSIONTEXTURE\n		vec4 occlusionTextureColor = texture2D(u_OcclusionTexture, uv0);\n		float occ = occlusionTextureColor.g;\n		float oneMinusT = 1.0 - u_occlusionStrength;\n		float lerpOneTo = oneMinusT + occ * u_occlusionStrength;\n		return occlusionTextureColor * lerpOneTo;\n	#else\n		return vec4(1.0);\n	#endif\n}\n\nvec2 ParallaxOffset(in vec3 viewDir){\n	#ifdef PARALLAXTEXTURE\n		float h = texture2D(u_ParallaxTexture, v_Texcoord0).g;\n		h = h * u_parallaxScale - u_parallaxScale / 2.0;\n		vec3 v = viewDir;\n		v.z += 0.42;\n		vec2 offset = h * (v.xy / v.z);\n		return v_Texcoord0 + offset;\n	#else\n		return v_Texcoord0;\n	#endif\n}\n\n");
		Shader3D.addInclude("PBRStandardLighting.glsl","#include \"PBRUtils.glsl\"\n#include \"BRDF.glsl\"\n\nvec4 PBRStandardLight(in vec3 diffuseColor, in float metallic, in float smoothness, in vec3 normal, in vec3 viewDir, in vec3 lightDir, in vec3 lightColor, in vec3 gi)\n{\n	float oneMinusReflectivity;\n	vec3 specularColor;\n	diffuseColor = DiffuseAndSpecularFromMetallic (diffuseColor, metallic, specularColor, oneMinusReflectivity);\n	\n	vec4 color = LayaAirBRDF(diffuseColor, specularColor, oneMinusReflectivity, smoothness, normal, viewDir, lightDir, lightColor, gi);\n	return color;\n}\n\nvec4 PBRStandardDiectionLight (in vec3 diffuseColor, in float metallic, in float smoothness, in vec3 normal, in vec3 viewDir, in DirectionLight light, in vec3 gi)\n{\n	vec3 lightVec = normalize(light.Direction);\n	return PBRStandardLight(diffuseColor, metallic, smoothness, normal, viewDir, lightVec, light.Color, gi);\n}\n\nvec2 MetallicGloss(in float diffuseTextureAlpha, in vec2 uv0)\n{\n	vec2 mg;\n	\n	#ifdef METALLICGLOSSTEXTURE\n		vec4 metallicGlossTextureColor = texture2D(u_MetallicGlossTexture, uv0);\n		#ifdef SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA\n			mg.r = metallicGlossTextureColor.r;\n			mg.g = diffuseTextureAlpha;\n		#else\n		    mg = metallicGlossTextureColor.ra;\n		#endif\n		mg.g *= u_smoothnessScale;\n	#else\n		mg.r = u_metallic;\n		#ifdef SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA\n			mg.g = diffuseTextureAlpha * u_smoothnessScale;\n		#else\n			mg.g = u_smoothness;\n		#endif\n	#endif\n	\n	return mg;\n}\n\n");
		Shader3D.addInclude("PBRSpecularLighting.glsl","#include \"PBRUtils.glsl\"\n#include \"BRDF.glsl\"\n\nvec4 PBRSpecularLight(in vec3 diffuseColor, in vec3 specularColor, in float smoothness, in vec3 normal, in vec3 viewDir, in vec3 lightDir, in vec3 lightColor, in vec3 gi)\n{\n	float oneMinusReflectivity;\n	diffuseColor = EnergyConservationBetweenDiffuseAndSpecular (diffuseColor, specularColor, oneMinusReflectivity);\n	\n	vec4 color = LayaAirBRDF(diffuseColor, specularColor, oneMinusReflectivity, smoothness, normal, viewDir, lightDir, lightColor, gi);\n	return color;\n}\n\nvec4 PBRSpecularDiectionLight (in vec3 diffuseColor, in vec3 specularColor, in float smoothness, in vec3 normal, in vec3 viewDir, in DirectionLight light, in vec3 gi)\n{\n	vec3 lightVec = normalize(light.Direction);\n	return PBRSpecularLight(diffuseColor, specularColor, smoothness, normal, viewDir, lightVec, light.Color, gi);\n}\n\nvec4 SpecularGloss(float diffuseTextureAlpha, in vec2 uv0)\n{\n    vec4 sg;\n	\n	#ifdef SPECULARTEXTURE\n		vec4 specularTextureColor = texture2D(u_SpecularTexture, uv0);\n		#ifdef SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA\n			sg.rgb = specularTextureColor.rgb;\n			sg.a = diffuseTextureAlpha;\n		#else\n			sg = specularTextureColor;\n		#endif\n		sg.a *= u_smoothnessScale;\n	#else\n		sg.rgb = u_SpecularColor.rgb;\n		#ifdef SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA\n			sg.a = diffuseTextureAlpha * u_smoothnessScale;\n		#else\n			sg.a = u_smoothness;\n		#endif\n	#endif\n	\n    return sg;\n}\n\n");
		var vs,ps;
		var attributeMap={
			'a_Position':/*laya.d3.graphics.VertexElementUsage.POSITION0*/0,
			'a_Color':/*laya.d3.graphics.VertexElementUsage.COLOR0*/1,
			'a_Normal':/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3,
			'a_Texcoord0':/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2,
			'a_Texcoord1':/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15,
			'a_BoneWeights':/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7,
			'a_BoneIndices':/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6,
			'a_Tangent0':/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5};
		var uniformMap={
			'u_Bones':[ /*laya.d3.core.SkinnedMeshSprite3D.BONES*/0,/*laya.d3.shader.Shader3D.PERIOD_RENDERELEMENT*/0],
			'u_DiffuseTexture':[ /*laya.d3.core.material.BlinnPhongMaterial.ALBEDOTEXTURE*/1,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_SpecularTexture':[ /*laya.d3.core.material.BlinnPhongMaterial.SPECULARTEXTURE*/3,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_NormalTexture':[ /*laya.d3.core.material.BlinnPhongMaterial.NORMALTEXTURE*/2,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_ReflectTexture':[ /*laya.d3.core.material.BlinnPhongMaterial.REFLECTTEXTURE*/5,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_AlphaTestValue':[ /*laya.d3.core.material.BaseMaterial.ALPHATESTVALUE*/0,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseColor':[ /*laya.d3.core.material.BlinnPhongMaterial.ALBEDOCOLOR*/6,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MaterialSpecular':[ /*laya.d3.core.material.BlinnPhongMaterial.MATERIALSPECULAR*/8,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_Shininess':[ /*laya.d3.core.material.BlinnPhongMaterial.SHININESS*/9,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MaterialReflect':[ /*laya.d3.core.material.BlinnPhongMaterial.MATERIALREFLECT*/10,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_TilingOffset':[ /*laya.d3.core.material.BlinnPhongMaterial.TILINGOFFSET*/11,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_WorldMat':[ /*laya.d3.core.Sprite3D.WORLDMATRIX*/0,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_MvpMatrix':[ /*laya.d3.core.Sprite3D.MVPMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_LightmapScaleOffset':[ /*laya.d3.core.RenderableSprite3D.LIGHTMAPSCALEOFFSET*/2,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_LightMap':[ /*laya.d3.core.RenderableSprite3D.LIGHTMAP*/3,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_CameraPos':[ /*laya.d3.core.BaseCamera.CAMERAPOS*/0,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_FogStart':[ /*laya.d3.core.scene.Scene.FOGSTART*/1,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_FogRange':[ /*laya.d3.core.scene.Scene.FOGRANGE*/2,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_FogColor':[ /*laya.d3.core.scene.Scene.FOGCOLOR*/0,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_DirectionLight.Color':[ /*laya.d3.core.scene.Scene.LIGHTDIRCOLOR*/4,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_DirectionLight.Direction':[ /*laya.d3.core.scene.Scene.LIGHTDIRECTION*/3,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Position':[ /*laya.d3.core.scene.Scene.POINTLIGHTPOS*/5,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Range':[ /*laya.d3.core.scene.Scene.POINTLIGHTRANGE*/6,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Color':[ /*laya.d3.core.scene.Scene.POINTLIGHTCOLOR*/8,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Position':[ /*laya.d3.core.scene.Scene.SPOTLIGHTPOS*/9,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Direction':[ /*laya.d3.core.scene.Scene.SPOTLIGHTDIRECTION*/10,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Range':[ /*laya.d3.core.scene.Scene.SPOTLIGHTRANGE*/12,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Spot':[ /*laya.d3.core.scene.Scene.SPOTLIGHTSPOT*/11,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Color':[ /*laya.d3.core.scene.Scene.SPOTLIGHTCOLOR*/14,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_AmbientColor':[ /*laya.d3.core.scene.Scene.AMBIENTCOLOR*/21,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap1':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE1*/18,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap2':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE2*/19,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap3':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE3*/20,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowPSSMDistance':[ /*laya.d3.core.scene.Scene.SHADOWDISTANCE*/15,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_lightShadowVP':[ /*laya.d3.core.scene.Scene.SHADOWLIGHTVIEWPROJECT*/16,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowPCFoffset':[ /*laya.d3.core.scene.Scene.SHADOWMAPPCFOFFSET*/17,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4]};
		var BLINNPHONG=Shader3D.nameKey.add("BLINNPHONG");
		vs="attribute vec4 a_Position;\nuniform mat4 u_MvpMatrix;\n\n#if defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(SPECULARMAP)||defined(NORMALMAP)))||(defined(LIGHTMAP)&&defined(UV))\n	attribute vec2 a_Texcoord0;\n	varying vec2 v_Texcoord0;\n#endif\n\n#if defined(LIGHTMAP)&&defined(UV1)\n	attribute vec2 a_Texcoord1;\n#endif\n\n#ifdef LIGHTMAP\n	uniform vec4 u_LightmapScaleOffset;\n	varying vec2 v_LightMapUV;\n#endif\n\n#ifdef COLOR\n	attribute vec4 a_Color;\n	varying vec4 v_Color;\n#endif\n\n#ifdef BONE\n	const int c_MaxBoneCount = 24;\n	attribute vec4 a_BoneIndices;\n	attribute vec4 a_BoneWeights;\n	uniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n	attribute vec3 a_Normal;\n	varying vec3 v_Normal; \n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n	uniform vec3 u_CameraPos;\n	varying vec3 v_ViewDir; \n#endif\n\n#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP))&&defined(NORMALMAP)\n	attribute vec4 a_Tangent0;\n	varying vec3 v_Tangent;\n	varying vec3 v_Binormal;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)||defined(RECEIVESHADOW)\n	uniform mat4 u_WorldMat;\n	varying vec3 v_PositionWorld;\n#endif\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n  #ifdef SHADOWMAP_PSSM1 \n  varying vec4 v_lightMVPPos;\n  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\nvoid main_castShadow()\n{\n	#ifdef BONE\n		mat4 skinTransform=mat4(0.0);\n		skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		vec4 position=skinTransform*a_Position;\n		gl_Position = u_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * a_Position;\n	#endif\n	 \n	//TODO没考虑UV动画呢\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		v_Texcoord0=a_Texcoord0;\n	#endif\n		v_posViewZ = gl_Position.z;\n}\n\nvoid main_normal()\n{\n	#ifdef BONE\n		mat4 skinTransform=mat4(0.0);\n		skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		vec4 position=skinTransform*a_Position;\n		gl_Position = u_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * a_Position;\n	#endif\n\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n		mat3 worldMat;\n		#ifdef BONE\n			worldMat=mat3(u_WorldMat*skinTransform);\n		#else\n			worldMat=mat3(u_WorldMat);\n		#endif  \n		v_Normal=worldMat*a_Normal;//TODO:法线可以用\"魔法\"矩阵\n		#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\n			v_Tangent=worldMat*a_Tangent0.xyz;\n			v_Binormal=cross(v_Normal,v_Tangent)*a_Tangent0.w;\n		#endif\n	#endif\n\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)||defined(RECEIVESHADOW)\n		#ifdef BONE\n			v_PositionWorld=(u_WorldMat*position).xyz;\n		#else\n			v_PositionWorld=(u_WorldMat*a_Position).xyz;\n		#endif\n	#endif\n	\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n		v_ViewDir=u_CameraPos-v_PositionWorld;\n	#endif\n\n	#if defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(SPECULARMAP)||defined(NORMALMAP)))\n		v_Texcoord0=a_Texcoord0;\n		#ifdef TILINGOFFSET\n			v_Texcoord0=(vec2(v_Texcoord0.x,v_Texcoord0.y-1.0)*u_TilingOffset.xy)+u_TilingOffset.zw;\n			v_Texcoord0=vec2(v_Texcoord0.x,1.0+v_Texcoord0.y);\n		#endif\n	#endif\n\n	#ifdef LIGHTMAP\n		#ifdef SCALEOFFSETLIGHTINGMAPUV\n			#ifdef UV1\n				v_LightMapUV=vec2(a_Texcoord1.x*u_LightmapScaleOffset.x+u_LightmapScaleOffset.z,1.0+a_Texcoord1.y*u_LightmapScaleOffset.y+u_LightmapScaleOffset.w);\n			#else\n				v_LightMapUV=vec2(a_Texcoord0.x,a_Texcoord0.y-1.0)*u_LightmapScaleOffset.xy+u_LightmapScaleOffset.zw;\n			#endif \n		#else\n			#ifdef UV1\n				v_LightMapUV=a_Texcoord1;\n			#else\n				v_LightMapUV=a_Texcoord0;\n			#endif \n		#endif \n	#endif\n\n	#ifdef COLOR\n		v_Color=a_Color;\n	#endif\n\n	#ifdef RECEIVESHADOW\n		v_posViewZ = gl_Position.w;\n		#ifdef SHADOWMAP_PSSM1 \n			v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n		#endif\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW\n		main_castShadow();\n	#else\n		main_normal();\n	#endif\n}";
		ps="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"Lighting.glsl\";\n\nuniform vec4 u_DiffuseColor;\n\n#ifdef COLOR\n	varying vec4 v_Color;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n	varying vec3 v_ViewDir; \n#endif\n\n#ifdef ALPHATEST\n	uniform float u_AlphaTestValue;\n#endif\n\n#ifdef DIFFUSEMAP\n	uniform sampler2D u_DiffuseTexture;\n#endif\n\n#ifdef REFLECTMAP\n	uniform samplerCube u_ReflectTexture;\n	uniform vec3 u_MaterialReflect;\n#endif\n\n#if defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(SPECULARMAP)||defined(NORMALMAP)))\n	varying vec2 v_Texcoord0;\n#endif\n\n#ifdef LIGHTMAP\n	varying vec2 v_LightMapUV;\n	uniform sampler2D u_LightMap;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	uniform vec3 u_MaterialSpecular;\n	uniform float u_Shininess;\n	#ifdef SPECULARMAP \n		uniform sampler2D u_SpecularTexture;\n	#endif\n#endif\n\n#ifdef FOG\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	#ifdef ADDTIVEFOG\n	#else\n		uniform vec3 u_FogColor;\n	#endif\n#endif\n\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n	varying vec3 v_Normal;\n#endif\n\n#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\n	uniform sampler2D u_NormalTexture;\n	varying vec3 v_Tangent;\n	varying vec3 v_Binormal;\n#endif\n\n#ifdef DIRECTIONLIGHT\n	uniform DirectionLight u_DirectionLight;\n#endif\n\n#ifdef POINTLIGHT\n	uniform PointLight u_PointLight;\n#endif\n\n#ifdef SPOTLIGHT\n	uniform SpotLight u_SpotLight;\n#endif\n\nuniform vec3 u_AmbientColor;\n\n\n#if defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)||defined(RECEIVESHADOW)\n	varying vec3 v_PositionWorld;\n#endif\n\n#include \"ShadowHelper.glsl\"\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n		uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n		varying vec4 v_lightMVPPos;\n	#endif\n#endif\n\nvoid main_castShadow()\n{\n	//gl_FragColor=vec4(v_posViewZ,0.0,0.0,1.0);\n	gl_FragColor=packDepth(v_posViewZ);\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		float alpha = texture2D(u_DiffuseTexture,v_Texcoord0).w;\n		if( alpha < u_AlphaTestValue )\n		{\n			discard;\n		}\n	#endif\n}\nvoid main_normal()\n{\n	vec4 mainColor=u_DiffuseColor;\n	#ifdef DIFFUSEMAP\n		vec4 difTexColor=texture2D(u_DiffuseTexture, v_Texcoord0);\n		mainColor=mainColor*difTexColor;\n	#endif \n	#ifdef COLOR\n		mainColor=mainColor*v_Color;\n	#endif \n    \n	#ifdef ALPHATEST\n		if(mainColor.a<u_AlphaTestValue)\n			discard;\n	#endif\n  \n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n		vec3 normal;\n		#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\n			vec3 normalMapSample = texture2D(u_NormalTexture, v_Texcoord0).rgb;\n			normal = normalize(NormalSampleToWorldSpace(normalMapSample, v_Normal, v_Tangent,v_Binormal));\n		#else\n			normal = normalize(v_Normal);\n		#endif\n	#endif\n	\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		vec3 viewDir= normalize(v_ViewDir);\n		vec3 diffuse = vec3(0.0);\n		vec3 specular= vec3(0.0);\n		vec3 dif,spe;\n		#ifdef SPECULARMAP\n			vec3 gloss=texture2D(u_SpecularTexture, v_Texcoord0).rgb;\n		#else\n			#ifdef DIFFUSEMAP\n				vec3 gloss=vec3(difTexColor.a);\n			#else\n				vec3 gloss=vec3(1.0);\n			#endif\n		#endif\n	#endif\n\n	\n	#ifdef DIRECTIONLIGHT\n		LayaAirBlinnPhongDiectionLight(u_MaterialSpecular,u_Shininess,normal,gloss,viewDir,u_DirectionLight,dif,spe);\n		diffuse+=dif;\n		specular+=spe;\n	#endif\n \n	#ifdef POINTLIGHT\n		LayaAirBlinnPhongPointLight(v_PositionWorld,u_MaterialSpecular,u_Shininess,normal,gloss,viewDir,u_PointLight,dif,spe);\n		diffuse+=dif;\n		specular+=spe;\n	#endif\n\n	#ifdef SPOTLIGHT\n		LayaAirBlinnPhongSpotLight(v_PositionWorld,u_MaterialSpecular,u_Shininess,normal,gloss,viewDir,u_SpotLight,dif,spe);\n		diffuse+=dif;\n		specular+=spe;\n	#endif\n\n	\n	vec3 finalDiffuse;\n	#ifdef LIGHTMAP\n		finalDiffuse=texture2D(u_LightMap, v_LightMapUV).rgb*2.0;\n		//float exponent = texture2D(u_LightMap, v_LightMapUV).a;\n		//finalDiffuse = texture2D(u_LightMap, v_LightMapUV).rgb;\n		//float ratio = pow(2.0, exponent * 255.0 - (128.0 + 8.0));\n		//finalDiffuse = finalDiffuse * 255.0 * ratio;	\n		//finalDiffuse = sqrt(finalDiffuse);\n	#else\n		finalDiffuse=vec3(0.0);\n	#endif\n\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		finalDiffuse+=diffuse;\n	#endif\n\n	#ifdef RECEIVESHADOW\n		float shadowValue = 1.0;\n		#ifdef SHADOWMAP_PSSM3\n			shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif\n		#ifdef SHADOWMAP_PSSM2\n			shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif \n		#ifdef SHADOWMAP_PSSM1\n			shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n		#endif\n		gl_FragColor =vec4(mainColor.rgb*(u_AmbientColor + finalDiffuse)*shadowValue,mainColor.a);\n	#else\n		gl_FragColor =vec4(mainColor.rgb*(u_AmbientColor + finalDiffuse),mainColor.a);\n	#endif\n	\n\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		#ifdef RECEIVESHADOW\n			gl_FragColor.rgb+=specular*shadowValue;\n		#else\n			gl_FragColor.rgb+=specular;\n		#endif\n	#endif\n\n\n	#ifdef REFLECTMAP\n		vec3 incident = -viewDir;\n		vec3 reflectionVector = reflect(incident,normal);\n		vec3 reflectionColor  = textureCube(u_ReflectTexture,reflectionVector).rgb;\n		gl_FragColor.rgb += u_MaterialReflect*reflectionColor;\n	#endif\n	  \n	#ifdef FOG\n		float lerpFact=clamp((1.0/gl_FragCoord.w-u_FogStart)/u_FogRange,0.0,1.0);\n		#ifdef ADDTIVEFOG\n			gl_FragColor.rgb=mix(gl_FragColor.rgb,vec3(0.0,0.0,0.0),lerpFact);\n		#else\n			gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n		#endif\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW		\n		main_castShadow();\n	#else\n	  main_normal();\n	#endif  \n}\n\n";
		var shaderCompile=ShaderCompile3D.add(BLINNPHONG,vs,ps,attributeMap,uniformMap);
		BlinnPhongMaterial.SHADERDEFINE_DIFFUSEMAP=shaderCompile.registerMaterialDefine("DIFFUSEMAP");
		BlinnPhongMaterial.SHADERDEFINE_NORMALMAP=shaderCompile.registerMaterialDefine("NORMALMAP");
		BlinnPhongMaterial.SHADERDEFINE_SPECULARMAP=shaderCompile.registerMaterialDefine("SPECULARMAP");
		BlinnPhongMaterial.SHADERDEFINE_REFLECTMAP=shaderCompile.registerMaterialDefine("REFLECTMAP");
		BlinnPhongMaterial.SHADERDEFINE_TILINGOFFSET=shaderCompile.registerMaterialDefine("TILINGOFFSET");
		BlinnPhongMaterial.SHADERDEFINE_ADDTIVEFOG=shaderCompile.registerMaterialDefine("ADDTIVEFOG");
		attributeMap={
			'a_Position':/*laya.d3.graphics.VertexElementUsage.POSITION0*/0,
			'a_Color':/*laya.d3.graphics.VertexElementUsage.COLOR0*/1,
			'a_Normal':/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3,
			'a_Texcoord0':/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2,
			'a_Texcoord1':/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15,
			'a_TexcoordNext0':/*laya.d3.graphics.VertexElementUsage.NEXTTEXTURECOORDINATE0*/14,
			'a_BoneWeights':/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7,
			'a_BoneIndices':/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6,
			'a_Tangent0':/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5};
		uniformMap={
			'u_Bones':[ /*laya.d3.core.SkinnedMeshSprite3D.BONES*/0,/*laya.d3.shader.Shader3D.PERIOD_RENDERELEMENT*/0],
			'u_DiffuseTexture':[ /*laya.d3.core.material.StandardMaterial.DIFFUSETEXTURE*/1,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_SpecularTexture':[ /*laya.d3.core.material.StandardMaterial.SPECULARTEXTURE*/3,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_NormalTexture':[ /*laya.d3.core.material.StandardMaterial.NORMALTEXTURE*/2,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_AmbientTexture':[ /*laya.d3.core.material.StandardMaterial.AMBIENTTEXTURE*/5,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_ReflectTexture':[ /*laya.d3.core.material.StandardMaterial.REFLECTTEXTURE*/6,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_AlphaTestValue':[ /*laya.d3.core.material.BaseMaterial.ALPHATESTVALUE*/0,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_Albedo':[ /*laya.d3.core.material.StandardMaterial.ALBEDO*/7,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_UVMatrix':[ /*laya.d3.core.material.StandardMaterial.UVMATRIX*/13,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_UVAge':[ /*laya.d3.core.material.StandardMaterial.UVAGE*/14,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_UVAniAge':[ /*laya.d3.core.material.StandardMaterial.UVANIAGE*/8,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MaterialDiffuse':[ /*laya.d3.core.material.StandardMaterial.MATERIALDIFFUSE*/10,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MaterialAmbient':[ /*laya.d3.core.material.StandardMaterial.MATERIALAMBIENT*/9,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MaterialSpecular':[ /*laya.d3.core.material.StandardMaterial.MATERIALSPECULAR*/11,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MaterialReflect':[ /*laya.d3.core.material.StandardMaterial.MATERIALREFLECT*/12,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_TilingOffset':[ /*laya.d3.core.material.StandardMaterial.TILINGOFFSET*/15,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_WorldMat':[ /*laya.d3.core.Sprite3D.WORLDMATRIX*/0,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_MvpMatrix':[ /*laya.d3.core.Sprite3D.MVPMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_LightmapScaleOffset':[ /*laya.d3.core.RenderableSprite3D.LIGHTMAPSCALEOFFSET*/2,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_LightMap':[ /*laya.d3.core.RenderableSprite3D.LIGHTMAP*/3,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_CameraPos':[ /*laya.d3.core.BaseCamera.CAMERAPOS*/0,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_FogStart':[ /*laya.d3.core.scene.Scene.FOGSTART*/1,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_FogRange':[ /*laya.d3.core.scene.Scene.FOGRANGE*/2,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_FogColor':[ /*laya.d3.core.scene.Scene.FOGCOLOR*/0,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_DirectionLight.Direction':[ /*laya.d3.core.scene.Scene.LIGHTDIRECTION*/3,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_DirectionLight.Diffuse':[ /*laya.d3.core.scene.Scene.LIGHTDIRCOLOR*/4,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Position':[ /*laya.d3.core.scene.Scene.POINTLIGHTPOS*/5,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Range':[ /*laya.d3.core.scene.Scene.POINTLIGHTRANGE*/6,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Attenuation':[ /*laya.d3.core.scene.Scene.POINTLIGHTATTENUATION*/7,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Diffuse':[ /*laya.d3.core.scene.Scene.POINTLIGHTCOLOR*/8,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Position':[ /*laya.d3.core.scene.Scene.SPOTLIGHTPOS*/9,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Direction':[ /*laya.d3.core.scene.Scene.SPOTLIGHTDIRECTION*/10,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Range':[ /*laya.d3.core.scene.Scene.SPOTLIGHTRANGE*/12,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Spot':[ /*laya.d3.core.scene.Scene.SPOTLIGHTSPOT*/11,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Attenuation':[ /*laya.d3.core.scene.Scene.SPOTLIGHTATTENUATION*/13,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Diffuse':[ /*laya.d3.core.scene.Scene.SPOTLIGHTCOLOR*/14,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_AmbientColor':[ /*laya.d3.core.scene.Scene.AMBIENTCOLOR*/21,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap1':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE1*/18,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap2':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE2*/19,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap3':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE3*/20,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowPSSMDistance':[ /*laya.d3.core.scene.Scene.SHADOWDISTANCE*/15,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_lightShadowVP':[ /*laya.d3.core.scene.Scene.SHADOWLIGHTVIEWPROJECT*/16,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowPCFoffset':[ /*laya.d3.core.scene.Scene.SHADOWMAPPCFOFFSET*/17,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4]};
		var SIMPLE=Shader3D.nameKey.add("SIMPLE");
		vs="attribute vec4 a_Position;\nuniform mat4 u_MvpMatrix;\n\n\n\n#if defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(COLOR)&&defined(SPECULARMAP)||defined(NORMALMAP)))||(defined(LIGHTMAP)&&defined(UV))\nattribute vec2 a_Texcoord0;\nvarying vec2 v_Texcoord0;\n  #ifdef UVTRANSFORM \n  uniform mat4 u_UVMatrix;\n  #endif\n#endif\n\n#if defined(AMBIENTMAP)||(defined(LIGHTMAP)&&defined(UV1))\nattribute vec2 a_Texcoord1;\n#endif\n\n#if defined(AMBIENTMAP)||defined(LIGHTMAP)\nuniform vec4 u_LightmapScaleOffset;\nvarying vec2 v_LightMapUV;\n#endif\n\n\n#ifdef COLOR\nattribute vec4 a_Color;\nvarying vec4 v_Color;\n#endif\n\n#ifdef BONE\nattribute vec4 a_BoneIndices;\nattribute vec4 a_BoneWeights;\nconst int c_MaxBoneCount = 24;\nuniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\nattribute vec3 a_Normal;\nvarying vec3 v_Normal;\n#endif\n\n#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP))&&defined(NORMALMAP)\nattribute vec3 a_Tangent0;\nvarying vec3 v_Tangent0;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||defined(DEPTHFOG)||defined(REFLECTMAP)||defined(RECEIVESHADOW)\nuniform mat4 u_WorldMat;\nvarying vec3 v_PositionWorld;\n#endif\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n  #ifdef SHADOWMAP_PSSM1 \n  varying vec4 v_lightMVPPos;\n  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\nvoid main_castShadow()\n{\n#ifdef BONE\n	mat4 skinTransform=mat4(0.0);\n	skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n	skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n	skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n	skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n	vec4 position=skinTransform*a_Position;\n	gl_Position = u_MvpMatrix * position;\n#else\n	gl_Position = u_MvpMatrix * a_Position;\n#endif\n \n//TODO没考虑UV动画呢\n#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n	v_Texcoord0=a_Texcoord0;\n#endif\n	v_posViewZ = gl_Position.z;\n}\n\nvoid main_normal()\n{\n#ifdef BONE\n	mat4 skinTransform=mat4(0.0);\n	skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n	skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n	skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n	skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n	vec4 position=skinTransform*a_Position;\n	gl_Position = u_MvpMatrix * position;\n#else\n	gl_Position = u_MvpMatrix * a_Position;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n	mat3 worldMat;\n	#ifdef BONE\n		worldMat=mat3(u_WorldMat*skinTransform);\n	#else\n		worldMat=mat3(u_WorldMat);\n	#endif  \n	v_Normal=worldMat*a_Normal;\n	#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\n		v_Tangent0=worldMat*a_Tangent0;\n	#endif\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||defined(DEPTHFOG)||defined(REFLECTMAP)||defined(RECEIVESHADOW)\n	#ifdef BONE\n		v_PositionWorld=(u_WorldMat*position).xyz;\n	#else\n		v_PositionWorld=(u_WorldMat*a_Position).xyz;\n	#endif\n#endif\n\n#if defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(COLOR)&&defined(SPECULARMAP)||defined(NORMALMAP)))\n	v_Texcoord0=a_Texcoord0;\n	#ifdef TILINGOFFSET\n		v_Texcoord0=(vec2(v_Texcoord0.x,v_Texcoord0.y-1.0)*u_TilingOffset.xy)+u_TilingOffset.zw;\n		v_Texcoord0=vec2(v_Texcoord0.x,v_Texcoord0.y+1.0);\n	#endif\n	#ifdef UVTRANSFORM\n		v_Texcoord0=(u_UVMatrix*vec4(v_Texcoord0,0.0,1.0)).xy;\n	#endif\n#endif\n\n#if defined(AMBIENTMAP)||defined(LIGHTMAP)\n	#ifdef SCALEOFFSETLIGHTINGMAPUV\n		#ifdef UV1\n			v_LightMapUV=vec2(a_Texcoord1.x*u_LightmapScaleOffset.x+u_LightmapScaleOffset.z,1.0+a_Texcoord1.y*u_LightmapScaleOffset.y+u_LightmapScaleOffset.w);\n		#else\n			v_LightMapUV=vec2(a_Texcoord0.x,a_Texcoord0.y-1.0)*u_LightmapScaleOffset.xy+u_LightmapScaleOffset.zw;\n		#endif \n	#else\n		#ifdef UV1\n			v_LightMapUV=a_Texcoord1;\n		#else\n			v_LightMapUV=a_Texcoord0;\n		#endif \n	#endif \n#endif\n\n#ifdef COLOR\n	v_Color=a_Color;\n#endif\n\n#ifdef RECEIVESHADOW\n	v_posViewZ = gl_Position.w;\n	#ifdef SHADOWMAP_PSSM1 \n		v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n	#endif\n#endif\n}\n\nvoid main()\n{\n#ifdef CASTSHADOW\n	main_castShadow();\n#else\n	main_normal();\n#endif\n}";
		ps="#ifdef HIGHPRECISION\nprecision highp float;\n#else\nprecision mediump float;\n#endif\n\n#include \"LightHelper.glsl\";\n\nuniform vec4 u_Albedo;\n\n#ifdef ALPHATEST\nuniform float u_AlphaTestValue;\n#endif\n\n#ifdef DIFFUSEMAP\nuniform sampler2D u_DiffuseTexture;\n#endif\n\n#ifdef REFLECTMAP\nuniform samplerCube u_ReflectTexture;\nuniform vec3 u_MaterialReflect;\n#endif\n\n#if   defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(COLOR)&&defined(SPECULARMAP)||defined(NORMALMAP)))\nvarying vec2 v_Texcoord0;\n#endif\n\n#if defined(AMBIENTMAP)||defined(LIGHTMAP)\nvarying vec2 v_LightMapUV;\n#endif\n#ifdef AMBIENTMAP\nuniform sampler2D u_AmbientTexture;\n#endif\n#ifdef LIGHTMAP\nuniform sampler2D u_LightMap;\n#endif\n\n#ifdef COLOR\nvarying vec4 v_Color;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\nuniform vec3 u_MaterialDiffuse;\nuniform vec4 u_MaterialSpecular;\n  #if (defined(DIFFUSEMAP)||defined(COLOR))&&defined(SPECULARMAP) \n  uniform sampler2D u_SpecularTexture;\n  #endif\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(AMBIENTMAP)||defined(LIGHTMAP)\nuniform vec3 u_MaterialAmbient;\n#endif\n\n#if defined(FOG)||defined(DEPTHFOG)\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	#ifdef ADDTIVEFOG\n	#else\n		uniform vec3 u_FogColor;\n	#endif\n#endif\n\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\nvarying vec3 v_Normal;\n#endif\n\n#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\nuniform sampler2D u_NormalTexture;\nvarying vec3 v_Tangent0;\n#endif\n\n#ifdef DIRECTIONLIGHT\nuniform DirectionLight u_DirectionLight;\n#endif\n\n#ifdef POINTLIGHT\nuniform PointLight u_PointLight;\n#endif\n\n#ifdef SPOTLIGHT\nuniform SpotLight u_SpotLight;\n#endif\n\nuniform vec3 u_AmbientColor;\n\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||defined(DEPTHFOG)||defined(REFLECTMAP)||(defined(RECEIVESHADOW)&&(defined(SHADOWMAP_PSM2)||defined(SHADOWMAP_PSM3)))\nuniform vec3 u_CameraPos;\n#endif\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||defined(DEPTHFOG)||defined(REFLECTMAP)\nvarying vec3 v_PositionWorld;\n#endif\n\n#include \"ShadowHelper.glsl\"\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n	uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n	varying vec4 v_lightMVPPos;\n	#endif\n#endif\nvarying float v_posViewZ;\n\n\n\nvoid main_castShadow()\n{\n	//gl_FragColor=vec4(v_posViewZ,0.0,0.0,1.0);\n	gl_FragColor=packDepth(v_posViewZ);\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		float alpha = texture2D(u_DiffuseTexture,v_Texcoord0).w;\n		if( alpha < u_AlphaTestValue )\n		{\n			discard;\n		}\n	#endif\n}\nvoid main_normal()\n{\n#if defined(DIFFUSEMAP)&&!defined(COLOR)\n	gl_FragColor=texture2D(u_DiffuseTexture, v_Texcoord0);\n#endif \n  \n#if defined(COLOR)&&!defined(DIFFUSEMAP)\n	gl_FragColor=v_Color;\n#endif \n  \n#if defined(DIFFUSEMAP)&&defined(COLOR)\n	vec4 texColor=texture2D(u_DiffuseTexture, v_Texcoord0);\n	gl_FragColor=texColor*v_Color;\n#endif\n  \n#if !defined(DIFFUSEMAP)&&!defined(COLOR)\n	gl_FragColor=vec4(1.0,1.0,1.0,1.0);\n#endif \n    \n#ifdef ALPHATEST\n	if(gl_FragColor.a-u_AlphaTestValue<0.0)\n		discard;\n#endif\n  \n  \n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n	vec3 normal;\n    #if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\n		vec3 normalMapSample = texture2D(u_NormalTexture, v_Texcoord0).rgb;\n		normal = normalize(NormalSampleToWorldSpace(normalMapSample, v_Normal, v_Tangent0));\n	#else\n		normal = normalize(v_Normal);\n    #endif\n#endif\n	\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	vec3 diffuse = vec3(0.0);\n	vec3 ambient = vec3(0.0);\n	vec3 specular= vec3(0.0);\n	vec3 dif, amb, spe;\n#endif\n  \n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||defined(REFLECTMAP)\n	vec3 toEye;\n	#ifdef FOG\n		toEye=u_CameraPos-v_PositionWorld;\n		float toEyeLength=length(toEye);\n		toEye/=toEyeLength;\n	#else\n		toEye=normalize(u_CameraPos-v_PositionWorld);\n	#endif\n#endif\n	\n#ifdef DIRECTIONLIGHT\n	computeDirectionLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_DirectionLight,u_AmbientColor,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n \n#ifdef POINTLIGHT\n	computePointLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_PointLight,u_AmbientColor,v_PositionWorld,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n\n#ifdef SPOTLIGHT\n	ComputeSpotLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_SpotLight,u_AmbientColor,v_PositionWorld,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n\n#ifdef RECEIVESHADOW\n	float shadowValue = 1.0;\n	#ifdef SHADOWMAP_PSSM3\n		shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n	#endif\n	#ifdef SHADOWMAP_PSSM2\n		shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n	#endif \n	#ifdef SHADOWMAP_PSSM1\n		shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n	#endif\n#endif\n\n#ifdef AMBIENTMAP\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient+texture2D(u_AmbientTexture, v_LightMapUV).rgb); \n	#else\n		#if defined(RECEIVESHADOW)\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient+texture2D(u_AmbientTexture, v_LightMapUV).rgb * shadowValue);\n		#else\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient+texture2D(u_AmbientTexture, v_LightMapUV).rgb); \n		#endif\n	#endif\n#endif\n\n#ifdef LIGHTMAP\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient+texture2D(u_LightMap, v_LightMapUV).rgb); \n	#else\n		#if defined(RECEIVESHADOW)\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient+texture2D(u_LightMap, v_LightMapUV).rgb * shadowValue);\n		#else\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient+texture2D(u_LightMap, v_LightMapUV).rgb); \n		#endif\n	#endif\n#endif\n\ngl_FragColor=gl_FragColor*u_Albedo;\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	#if (defined(DIFFUSEMAP)||defined(COLOR))&&defined(SPECULARMAP)\n		specular =specular*texture2D(u_SpecularTexture, v_Texcoord0).rgb;\n    #endif\n	#ifdef RECEIVESHADOW\n		gl_FragColor =vec4( gl_FragColor.rgb*(ambient + diffuse*shadowValue) + specular*shadowValue,gl_FragColor.a);\n	#else\n		gl_FragColor =vec4( gl_FragColor.rgb*(ambient + diffuse) + specular,gl_FragColor.a);\n	#endif\n#endif\n  \n#ifdef REFLECTMAP\n	vec3 incident = -toEye;\n	vec3 reflectionVector = reflect(incident,normal);\n	vec3 reflectionColor  = textureCube(u_ReflectTexture,reflectionVector).rgb;\n	gl_FragColor.rgb += u_MaterialReflect*reflectionColor;\n#endif\n  \n#ifdef FOG\n	float lerpFact=clamp((toEyeLength-u_FogStart)/u_FogRange,0.0,1.0);\n	#ifdef ADDTIVEFOG\n		gl_FragColor.rgb=mix(gl_FragColor.rgb,vec3(0.0,0.0,0.0),lerpFact);\n	#else\n		gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n	#endif\n#endif\n#ifdef DEPTHFOG\n	float lerpFact = (-v_PositionWorld.y-u_FogStart)/u_FogRange;\n	gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n#endif\n}\n\nvoid main()\n{\n#ifdef CASTSHADOW		\n	main_castShadow();\n#else\n  main_normal();\n#endif  \n}\n\n";
		shaderCompile=ShaderCompile3D.add(SIMPLE,vs,ps,attributeMap,uniformMap);
		StandardMaterial.SHADERDEFINE_DIFFUSEMAP=shaderCompile.registerMaterialDefine("DIFFUSEMAP");
		StandardMaterial.SHADERDEFINE_NORMALMAP=shaderCompile.registerMaterialDefine("NORMALMAP");
		StandardMaterial.SHADERDEFINE_SPECULARMAP=shaderCompile.registerMaterialDefine("SPECULARMAP");
		StandardMaterial.SHADERDEFINE_EMISSIVEMAP=shaderCompile.registerMaterialDefine("EMISSIVEMAP");
		StandardMaterial.SHADERDEFINE_AMBIENTMAP=shaderCompile.registerMaterialDefine("AMBIENTMAP");
		StandardMaterial.SHADERDEFINE_REFLECTMAP=shaderCompile.registerMaterialDefine("REFLECTMAP");
		StandardMaterial.SHADERDEFINE_UVTRANSFORM=shaderCompile.registerMaterialDefine("UVTRANSFORM");
		StandardMaterial.SHADERDEFINE_TILINGOFFSET=shaderCompile.registerMaterialDefine("TILINGOFFSET");
		StandardMaterial.SHADERDEFINE_ADDTIVEFOG=shaderCompile.registerMaterialDefine("ADDTIVEFOG");
		attributeMap={
			'a_Position':/*laya.d3.graphics.VertexElementUsage.POSITION0*/0,
			'a_Color':/*laya.d3.graphics.VertexElementUsage.COLOR0*/1};
		uniformMap={
			'u_MvpMatrix':[ /*laya.d3.core.Sprite3D.MVPMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2]};
		var LINE=Shader3D.nameKey.add("LINE");
		vs="attribute vec4 a_Position;\nuniform mat4 u_MvpMatrix;\nattribute vec4 a_Color;\nvarying vec4 v_Color;\n\n\nvoid main()\n{\n  gl_Position = u_MvpMatrix * a_Position;\n  v_Color=a_Color;\n}";
		ps="#ifdef HIGHPRECISION\nprecision highp float;\n#else\nprecision mediump float;\n#endif\n\nvarying vec4 v_Color;\n\nvoid main()\n{\n  gl_FragColor=v_Color; \n}\n\n";
		ShaderCompile3D.add(LINE,vs,ps,attributeMap,uniformMap);
		attributeMap={
			'a_position':/*laya.d3.graphics.VertexElementUsage.POSITION0*/0,
			'a_normal':/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3,
			'tangent':/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5,
			'binormal':/*laya.d3.graphics.VertexElementUsage.BINORMAL0*/4,
			'uv':/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2,
			'a_BoneWeights':/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7,
			'a_BoneIndices':/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6,
			'a_Tangent0':/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5};
		uniformMap={
			'u_Bones':[ /*laya.d3.core.SkinnedMeshSprite3D.BONES*/0,/*laya.d3.shader.Shader3D.PERIOD_RENDERELEMENT*/0],
			'u_lodRect':[ /*laya.d3.core.BaseCamera.SIMLODINFO*/9,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'irrad_mat_red':[ /*laya.d3.core.BaseCamera.DIFFUSEIRRADMATR*/10,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'irrad_mat_green':[ /*laya.d3.core.BaseCamera.DIFFUSEIRRADMATG*/11,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'irrad_mat_blue':[ /*laya.d3.core.BaseCamera.DIFFUSEIRRADMATB*/12,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_hdrexposure':[ /*laya.d3.core.BaseCamera.HDREXPOSURE*/13,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_aoObjPos':[ /*laya.d3.core.material.PBRMaterial.AOOBJPOS*/14,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'texBaseColor':[ /*laya.d3.core.material.PBRMaterial.DIFFUSETEXTURE*/1,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'texNormal':[ /*laya.d3.core.material.PBRMaterial.NORMALTEXTURE*/2,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'texPbrInfo':[ /*laya.d3.core.material.PBRMaterial.PBRINFOTEXTURE*/3,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'texPrefilterdEnv':[ /*laya.d3.core.BaseCamera.ENVIRONMENTSPECULAR*/8,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'texHSNoise':[ /*laya.d3.core.material.PBRMaterial.HSNOISETEXTURE*/15,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'texPrefilterDiff':[ /*laya.d3.core.BaseCamera.ENVIRONMENTDIFFUSE*/7,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_AlphaTestValue':[ /*laya.d3.core.material.BaseMaterial.ALPHATESTVALUE*/0,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'texBRDFLUT':[ /*laya.d3.core.material.PBRMaterial.PBRLUTTEXTURE*/4,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_UVAniAge':[ /*laya.d3.core.material.PBRMaterial.UVANIAGE*/5,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_roughness':[ /*laya.d3.core.material.PBRMaterial.MATERIALROUGHNESS*/6,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_metaless':[ /*laya.d3.core.material.PBRMaterial.MATERIALMETALESS*/7,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_UVMatrix':[ /*laya.d3.core.material.PBRMaterial.UVMATRIX*/8,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_UVAge':[ /*laya.d3.core.material.PBRMaterial.UVAGE*/9,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'modelMatrix':[ /*laya.d3.core.Sprite3D.WORLDMATRIX*/0,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'mvp':[ /*laya.d3.core.Sprite3D.MVPMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'cameraPosition':[ /*laya.d3.core.BaseCamera.CAMERAPOS*/0,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_View':[ /*laya.d3.core.BaseCamera.VIEWMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_Project':[ /*laya.d3.core.BaseCamera.PROJECTMATRIX*/2,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_FogStart':[ /*laya.d3.core.scene.Scene.FOGSTART*/1,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_FogRange':[ /*laya.d3.core.scene.Scene.FOGRANGE*/2,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_FogColor':[ /*laya.d3.core.scene.Scene.FOGCOLOR*/0,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_DirectionLight.Direction':[ /*laya.d3.core.scene.Scene.LIGHTDIRECTION*/3,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_DirectionLight.Diffuse':[ /*laya.d3.core.scene.Scene.LIGHTDIRCOLOR*/4,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Position':[ /*laya.d3.core.scene.Scene.POINTLIGHTPOS*/5,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Range':[ /*laya.d3.core.scene.Scene.POINTLIGHTRANGE*/6,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Attenuation':[ /*laya.d3.core.scene.Scene.POINTLIGHTATTENUATION*/7,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Diffuse':[ /*laya.d3.core.scene.Scene.POINTLIGHTCOLOR*/8,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Position':[ /*laya.d3.core.scene.Scene.SPOTLIGHTPOS*/9,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Direction':[ /*laya.d3.core.scene.Scene.SPOTLIGHTDIRECTION*/10,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Range':[ /*laya.d3.core.scene.Scene.SPOTLIGHTRANGE*/12,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Spot':[ /*laya.d3.core.scene.Scene.SPOTLIGHTSPOT*/11,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Attenuation':[ /*laya.d3.core.scene.Scene.SPOTLIGHTATTENUATION*/13,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Diffuse':[ /*laya.d3.core.scene.Scene.SPOTLIGHTCOLOR*/14,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap1':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE1*/18,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap2':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE2*/19,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap3':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE3*/20,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowPSSMDistance':[ /*laya.d3.core.scene.Scene.SHADOWDISTANCE*/15,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_lightShadowVP':[ /*laya.d3.core.scene.Scene.SHADOWLIGHTVIEWPROJECT*/16,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowPCFoffset':[ /*laya.d3.core.scene.Scene.SHADOWMAPPCFOFFSET*/17,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4]};
		var PBR=Shader3D.nameKey.add("PBR");
		vs="\nuniform mat4 modelMatrix;\n//uniform mat4 modelViewMatrix;\n//uniform mat4 projectionMatrix;\nuniform mat4 u_View;\nuniform mat4 u_Project;\nuniform mat4 mvp;\n//uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n\nattribute vec3 a_position;\nattribute vec3 a_normal;\n#ifdef HAS_TANGENT\nattribute vec3 tangent;\nattribute vec3 binormal;\n#endif\nattribute vec2 uv;\n#ifdef BONE\nattribute vec4 a_BoneIndices;\nattribute vec4 a_BoneWeights;\nconst int c_MaxBoneCount = 24;\nuniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\nvarying vec2 vUv;\nvarying vec3 vWorldNorm;\nvarying vec4 vViewPos;\nvarying vec4 vWorldPos;\nvarying vec3 vLightDir;\nvarying vec3 vViewDir;\n#ifdef HAS_TANGENT\nvarying vec3 vWorldTangent;\nvarying vec3 vWorldBinormal;\n#endif\n\n#ifdef RECEIVESHADOW\nvarying float v_posViewZ;\n  #ifdef SHADOWMAP_PSSM1 \n  varying vec4 v_lightMVPPos;\n  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\nvoid main() {\n#ifdef BONE\n	mat4 skinTransform=mat4(0.0);\n	skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n	skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n	skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n	skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n	gl_Position = mvp*skinTransform*vec4(a_position,1.);\n	mat4 modelMat = modelMatrix*skinTransform;\n#else\n	gl_Position = mvp*vec4(a_position,1.);\n	mat4 modelMat = modelMatrix;\n#endif	\n	vWorldPos = modelMat*vec4(a_position,1.);\n\n#ifdef CASTSHADOW \n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		vUv = uv;\n	#endif	\n#else\n    vUv = uv;\n	vWorldNorm = normalize((modelMat*vec4(a_normal,0.0)).xyz);\n	#ifdef HAS_TANGENT\n	vWorldTangent = normalize((modelMat*vec4(tangent,0.0)).xyz);\n	vWorldBinormal = normalize((modelMat*vec4(binormal,0.0)).xyz);\n	#endif\n    \n    vViewDir = (vWorldPos.xyz-cameraPosition);//这个不能normalize。否则无法线性差值了\n#ifdef RECEIVESHADOW\n	v_posViewZ = gl_Position.z;\n	#ifdef SHADOWMAP_PSSM1 \n		v_lightMVPPos = u_lightShadowVP[0] * vWorldPos;\n	#endif\n#endif	\n#endif\n}\n";
		ps="//#version 300 es\n\nprecision highp float;\nprecision lowp int;\n\nconst float PI = 3.14159265358979323846264;\nconst float _2PI = 6.2831853071796;\nvarying vec2 vUv;\nvarying vec3 vWorldNorm;\n#ifdef HAS_TANGENT\nvarying vec3 vWorldTangent;\nvarying vec3 vWorldBinormal;\n#endif\nvarying vec3 vViewDir;\nvarying vec4 vViewPos;\nvarying vec4 vWorldPos;\n//\nuniform sampler2D texBaseColor;\nuniform sampler2D texNormal;\n//预计算的贴图\nuniform sampler2D texPrefilterdEnv;\nuniform sampler2D texBRDFLUT;\nuniform sampler2D texPrefilterDiff;\n#ifdef HAS_PBRINFO\nuniform sampler2D texPbrInfo;   //Ao, Roughness, Metallic\n#endif\nuniform float u_hdrexposure;\nuniform float u_AlphaTestValue;\n\nuniform float u_roughness;\nuniform float u_metaless;\nconst float maxlv = 7.;	//现在只支持512分辨率的环境贴图\nconst int nmaxlv = 9;//\n							\nuniform mat4 irrad_mat_red;\nuniform mat4 irrad_mat_green;\nuniform mat4 irrad_mat_blue;							\n\nvec3 speccontrib = vec3(0.);\n\nconst float _maxu8 = 255.0;\nconst float _maxu16 = 65535.0;\nconst float _shift8 = 256.0;    //平移的话是*256而不是255\nvec2 _RGBAToU16(const in vec4 rgba){\n    return vec2((rgba.r*_maxu8+rgba.g*_maxu8*_shift8)/_maxu16, (rgba.b*_maxu8+rgba.a*_maxu8*_shift8)/_maxu16);\n}\nvec3 _RGBEToRGB( const in vec4 rgba ){\n    float f = pow(2.0, rgba.w * 255.0 - (128.0 + 8.0));\n    return rgba.rgb * (255.0 * f);\n}\n\nfloat saturate(float v){\n    return min(max(v,0.),1.);\n}\n\nvec4 tex2dLod(sampler2D tex, float u, float v, float lod){\n	vec2 uv = vec2(u,v);\n	uv+=mod(gl_FragCoord.xy-vec2(0.5),2.0)*vec2(128.,0.);\n	return texture2D(tex,uv,lod-16.);\n}\n\n/*\n* 对一个全景图进行采样。假设x轴指向中心。\n*/\nvec4 texPanorama(sampler2D tex, const in vec3 dir){\n	float envu = atan(dir.z,dir.x)/_2PI+0.5; 	\n	float envv = acos(dir.y)/PI;//(1.0-dir.y)/2.0;\n	return texture2D(tex,vec2(envu,envv));\n}\n\nvec4 texPanoramaLod(sampler2D tex, const in vec3 dir, float lod){\n	float envu = atan(dir.z,dir.x)/_2PI+0.5; 	\n	float envv = acos(dir.y)/PI;//(1.0-dir.y)/2.0;\n	return tex2dLod(tex,envu,envv,lod);\n}\n\n/*\n    计算sh光照。\n    使用level=2，所以需要9个系数。\n    https://cseweb.ucsd.edu/~ravir/papers/envmap/envmap.pdf\n*/\nfloat environment_exposure = 1.0;\nvec3 diff_sh9(vec3 dir){\n	vec4 shDir = vec4(dir.x,-dir.z,dir.y,1.0);\n  return max(vec3(0.0), vec3(\n	dot(shDir, irrad_mat_red * shDir),\n	dot(shDir, irrad_mat_green * shDir),\n	dot(shDir, irrad_mat_blue * shDir)\n	)) * environment_exposure;	\n}\n\n#ifdef HAS_TANGENT\nvec3 applyNormalTex( vec3 norm, vec3 surf_norm ) {\n    vec3 mapN = norm * 2.0 - 1.0;\n    //mapN.xy = normalScale * mapN.xy;\n    mat3 tsn = mat3( vWorldTangent, vWorldBinormal, surf_norm );\n    return normalize( tsn * mapN );\n}\n#endif\n\nvec4 pbrlight(vec3 normal, float rough, float NoV, vec3 R){\n    vec4 basecolor = texture2D(texBaseColor,vUv);\n	basecolor.rgb = pow(basecolor.rgb,vec3(2.2));\n	float metaless = 1.0; 	\n	const float ismetalinfov = (128./255.);\n	if(basecolor.a>=ismetalinfov){//这时候表示金属度\n		metaless = (basecolor.a-ismetalinfov)*2.;\n		basecolor.a = 1.0;\n	}else{\n		metaless = 0.;\n		basecolor.a = basecolor.a*2.0;\n	}\n	#ifdef FIX_METALESS\n	metaless = u_metaless;\n	#endif\n	#ifdef HAS_PBRINFO	\n	vec4 pbrinfo = texture2D(texPbrInfo, vUv);\n	metaless = pbrinfo.b;\n	rough = pbrinfo.g;\n	#endif\n    const vec3 nonmetalF0 =vec3(0.02);\n    vec3 F0 =  mix(nonmetalF0, basecolor.rgb, metaless);\n	\n    vec4 PrefilteredColor = texPanoramaLod(texPrefilterdEnv, R, rough*maxlv);\n    PrefilteredColor.rgb = _RGBEToRGB(PrefilteredColor);\n    vec4 EnvBRDF = texture2D(texBRDFLUT,vec2(rough , NoV));//TODO lod\n    vec2 rg = _RGBAToU16(EnvBRDF);    \n    speccontrib = (F0* rg.x + saturate( 50.0 * PrefilteredColor.g ) * rg.y);\n	vec3 color_spec = PrefilteredColor.rgb*speccontrib;\n	\n	vec3 color_diff=diff_sh9(normal);\n	vec3 outc =  color_diff*mix(basecolor.rgb,vec3(0.),metaless)*(vec3(1.0)-speccontrib)+color_spec;\n	#ifdef HAS_PBRINFO\n	outc*=pbrinfo.r;\n	#endif\n	return vec4(outc, basecolor.a);\n}\n\nvec3 oldlight(vec4 normal, float NoV, vec3 R){\n    vec4 basecolor = texture2D(texBaseColor,vUv);\n	const vec3 lightdir=normalize(vec3(1.,1.,0.));\n	const vec3 spcecol = vec3(1.,0.8,0.8);\n	const vec3 amb = vec3(0.5);\n	vec3 diffv =  (vec3(saturate(dot(lightdir,normal.xyz)))+amb);\n	//vec3 spec = spcecol* pow(saturate(dot(R,lightdir)),(1.-pbrinfo.g)*5.);\n	return diffv*basecolor.rgb;//+spec;\n}\n\n#include \"ShadowHelper.glsl\"\n#ifdef RECEIVESHADOW\nvarying float v_posViewZ;\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n	uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n	varying vec4 v_lightMVPPos;\n	#endif\n#endif\n\nvoid main() {\n#ifdef CASTSHADOW\n	gl_FragColor=packDepth(gl_FragCoord.w);\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		float alpha = texture2D(texBaseColor,vUv).w;\n		if( alpha < u_AlphaTestValue ){\n			discard;\n		}\n	#endif\n#else\n\n	#ifdef RECEIVESHADOW\n		float shadowValue = 1.0;\n		#ifdef SHADOWMAP_PSSM3\n			shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,vWorldPos.xyz,v_posViewZ,0.0001);\n		#endif\n		#ifdef SHADOWMAP_PSSM2\n			shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,vWorldPos.xyz,v_posViewZ,0.0001);\n		#endif \n		#ifdef SHADOWMAP_PSSM1\n			shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.0001);\n		#endif\n	#endif	\n	\n    vec3 normal =  normalize(vWorldNorm);\n	vec4 normtex = texture2D( texNormal, vUv );\n	#ifdef HAS_TANGENT	\n	normal = applyNormalTex(normtex.xyz, normal);\n	#endif\n    vec3 view   = -normalize(vViewDir);\n    float NoV = saturate(dot( view, normal ));\n    vec3 R = 2. * NoV * normal - view;\n	float roughness = normtex.a;\n	#ifdef FIX_ROUGHNESS\n	roughness = u_roughness;\n	#endif\n	\n	vec4 pbrl = pbrlight(normal,roughness,NoV,R)*u_hdrexposure;\n    gl_FragColor.rgb =  pow(pbrl.rgb,vec3(0.45455));\n	//gl_FragColor.rgb = oldlight(normtex,NoV,R);\n	#ifdef RECEIVESHADOW\n	gl_FragColor.rgb *= max(shadowValue,0.7);\n	#endif\n	\n    gl_FragColor.a = pbrl.a;\n\n#endif\n}\n";
		shaderCompile=ShaderCompile3D.add(PBR,vs,ps,attributeMap,uniformMap);
		PBRMaterial.SHADERDEFINE_FIX_METALESS=shaderCompile.registerMaterialDefine("FIX_METALESS");
		PBRMaterial.SHADERDEFINE_FIX_ROUGHNESS=shaderCompile.registerMaterialDefine("FIX_ROUGHNESS");
		PBRMaterial.SHADERDEFINE_HAS_TANGENT=shaderCompile.registerMaterialDefine("HAS_TANGENT");
		PBRMaterial.SHADERDEFINE_HAS_PBRINFO=shaderCompile.registerMaterialDefine("HAS_PBRINFO");
		PBRMaterial.SHADERDEFINE_USE_GROUNDTRUTH=shaderCompile.registerMaterialDefine("USE_GROUNDTRUTH");
		PBRMaterial.SHADERDEFINE_TEST_CLIPZ=shaderCompile.registerMaterialDefine("CLIPZ");
		attributeMap={
			'a_Position':/*laya.d3.graphics.VertexElementUsage.POSITION0*/0,
			'a_Normal':/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3,
			'a_Tangent0':/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5,
			'a_Texcoord0':/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2,
			'a_BoneWeights':/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7,
			'a_BoneIndices':/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6
		};
		uniformMap={
			'u_Bones':[ /*laya.d3.core.SkinnedMeshSprite3D.BONES*/0,/*laya.d3.shader.Shader3D.PERIOD_RENDERELEMENT*/0],
			'u_MvpMatrix':[ /*laya.d3.core.Sprite3D.MVPMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_WorldMat':[ /*laya.d3.core.Sprite3D.WORLDMATRIX*/0,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_CameraPos':[ /*laya.d3.core.BaseCamera.CAMERAPOS*/0,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_AlphaTestValue':[ /*laya.d3.core.material.BaseMaterial.ALPHATESTVALUE*/0,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseColor':[ /*laya.d3.core.material.PBRStandardMaterial.DIFFUSECOLOR*/7,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_EmissionColor':[ /*laya.d3.core.material.PBRStandardMaterial.EMISSIONCOLOR*/8,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseTexture':[ /*laya.d3.core.material.PBRStandardMaterial.DIFFUSETEXTURE*/1,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_NormalTexture':[ /*laya.d3.core.material.PBRStandardMaterial.NORMALTEXTURE*/3,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_ParallaxTexture':[ /*laya.d3.core.material.PBRStandardMaterial.PARALLAXTEXTURE*/4,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MetallicGlossTexture':[ /*laya.d3.core.material.PBRStandardMaterial.METALLICGLOSSTEXTURE*/2,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_OcclusionTexture':[ /*laya.d3.core.material.PBRStandardMaterial.OCCLUSIONTEXTURE*/5,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_EmissionTexture':[ /*laya.d3.core.material.PBRStandardMaterial.EMISSIONTEXTURE*/6,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_metallic':[ /*laya.d3.core.material.PBRStandardMaterial.METALLIC*/9,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_smoothness':[ /*laya.d3.core.material.PBRStandardMaterial.SMOOTHNESS*/10,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_smoothnessScale':[ /*laya.d3.core.material.PBRStandardMaterial.SMOOTHNESSSCALE*/11,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_occlusionStrength':[ /*laya.d3.core.material.PBRStandardMaterial.OCCLUSIONSTRENGTH*/13,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_normalScale':[ /*laya.d3.core.material.PBRStandardMaterial.NORMALSCALE*/14,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_parallaxScale':[ /*laya.d3.core.material.PBRStandardMaterial.PARALLAXSCALE*/15,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_TilingOffset':[ /*laya.d3.core.material.PBRStandardMaterial.TILINGOFFSET*/17,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DirectionLight.Direction':[ /*laya.d3.core.scene.Scene.LIGHTDIRECTION*/3,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_DirectionLight.Color':[ /*laya.d3.core.scene.Scene.LIGHTDIRCOLOR*/4,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_AmbientColor':[ /*laya.d3.core.scene.Scene.AMBIENTCOLOR*/21,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap1':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE1*/18,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap2':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE2*/19,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap3':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE3*/20,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowPSSMDistance':[ /*laya.d3.core.scene.Scene.SHADOWDISTANCE*/15,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_lightShadowVP':[ /*laya.d3.core.scene.Scene.SHADOWLIGHTVIEWPROJECT*/16,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowPCFoffset':[ /*laya.d3.core.scene.Scene.SHADOWMAPPCFOFFSET*/17,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4]
		};
		var PBRStandard=Shader3D.nameKey.add("PBRStandard");
		vs="attribute vec4 a_Position;\nattribute vec3 a_Normal;\nattribute vec4 a_Tangent0;\nattribute vec2 a_Texcoord0;\n\nuniform mat4 u_MvpMatrix;\nuniform mat4 u_WorldMat;\nuniform vec3 u_CameraPos;\n\nvarying vec2 v_Texcoord0;\nvarying vec3 v_Normal;\nvarying vec3 v_Tangent;\nvarying vec3 v_Binormal;\nvarying vec3 v_ViewDir;\nvarying vec3 v_PositionWorld;\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n  #ifdef SHADOWMAP_PSSM1 \n	  varying vec4 v_lightMVPPos;\n	  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\n#ifdef BONE\n	const int c_MaxBoneCount = 24;\n	attribute vec4 a_BoneIndices;\n	attribute vec4 a_BoneWeights;\n	uniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\nvoid main_castShadow()\n{\n	#ifdef BONE\n		mat4 skinTransform=mat4(0.0);\n		skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		vec4 position = skinTransform * a_Position;\n		gl_Position = u_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * a_Position;\n	#endif\n	 \n	//TODO没考虑UV动画呢\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		v_Texcoord0 = a_Texcoord0;\n	#endif\n		v_posViewZ = gl_Position.z;\n}\n\nvoid main_normal()\n{\n	mat3 worldMat;\n	#ifdef BONE\n		mat4 skinTransform = mat4(0.0);\n		skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		vec4 position = skinTransform * a_Position;\n		gl_Position = u_MvpMatrix * position;\n		worldMat=mat3(u_WorldMat*skinTransform);\n		v_PositionWorld = (u_WorldMat * position).xyz;\n	#else\n		gl_Position = u_MvpMatrix * a_Position;\n		worldMat = mat3(u_WorldMat);\n		v_PositionWorld = (u_WorldMat * a_Position).xyz;\n	#endif\n	\n	v_Normal = worldMat * a_Normal;\n	v_Tangent = worldMat * a_Tangent0.xyz;\n	v_Binormal = cross(v_Normal, v_Tangent) * a_Tangent0.w;\n  \n	v_Texcoord0 = a_Texcoord0;\n	#ifdef TILINGOFFSET\n		v_Texcoord0=(vec2(v_Texcoord0.x,v_Texcoord0.y-1.0)*u_TilingOffset.xy)+u_TilingOffset.zw;\n	#endif\n		v_Texcoord0=vec2(v_Texcoord0.x,1.0 + v_Texcoord0.y);\n  \n	v_ViewDir = u_CameraPos - v_PositionWorld;\n  \n	#ifdef RECEIVESHADOW\n		v_posViewZ = gl_Position.w;\n		#ifdef SHADOWMAP_PSSM1 \n			v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n		#endif\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW\n		main_castShadow();\n	#else\n		main_normal();\n	#endif\n}";
		ps="#ifdef FSHIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\nvarying vec2 v_Texcoord0;\nvarying vec3 v_Normal;\nvarying vec3 v_Tangent;\nvarying vec3 v_Binormal;\nvarying vec3 v_ViewDir;\n\nuniform vec3 u_AmbientColor;\nuniform vec4 u_DiffuseColor;\n\n#ifdef DIFFUSETEXTURE\n	uniform sampler2D u_DiffuseTexture;\n#endif\n#ifdef METALLICGLOSSTEXTURE\n	uniform sampler2D u_MetallicGlossTexture;\n#endif\n#ifdef NORMALTEXTURE\n	uniform sampler2D u_NormalTexture;\n	uniform float u_normalScale;\n#endif\n#ifdef PARALLAXTEXTURE\n	uniform sampler2D u_ParallaxTexture;\n	uniform float u_parallaxScale;\n#endif\n#ifdef OCCLUSIONTEXTURE\n	uniform sampler2D u_OcclusionTexture;\n	uniform float u_occlusionStrength;\n#endif\n#ifdef EMISSION\n	#ifdef EMISSIONTEXTURE\n		uniform sampler2D u_EmissionTexture;\n	#endif\n	uniform vec4 u_EmissionColor;\n#endif\n\nuniform float u_AlphaTestValue;\nuniform float u_metallic;\nuniform float u_smoothness;\nuniform float u_smoothnessScale;\n\n#include \"PBRStandardLighting.glsl\"\n#include \"ShadowHelper.glsl\"\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n		uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n		varying vec4 v_lightMVPPos;\n	#endif\n#endif\n\nuniform DirectionLight u_DirectionLight;\n\nvoid main_castShadow()\n{\n	gl_FragColor=packDepth(v_posViewZ);\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		float alpha = texture2D(u_DiffuseTexture,v_Texcoord0).w;\n		if( alpha < u_AlphaTestValue )\n		{\n			discard;\n		}\n	#endif\n}\n\nvoid main_normal()\n{	\n	vec3 viewDir = normalize(v_ViewDir);\n	\n	vec2 uv0 = ParallaxOffset(viewDir);\n	\n	vec2 mg;\n	#ifdef DIFFUSETEXTURE\n		vec4 diffuseTextureColor = texture2D(u_DiffuseTexture, uv0);\n		vec4 diffuseColor = diffuseTextureColor * u_DiffuseColor;\n		mg = MetallicGloss(diffuseTextureColor.a, uv0);\n	#else\n		vec4 diffuseColor = u_DiffuseColor;\n		mg = MetallicGloss(1.0, uv0);\n	#endif\n	\n	#ifdef ALPHATEST\n		if(diffuseColor.a < u_AlphaTestValue)\n			discard;\n	#endif\n	\n	gl_FragColor = diffuseColor;\n	\n	vec3 normal = UnpackScaleNormal(uv0);\n  \n	vec3 gi =  u_AmbientColor * Occlusion(uv0).rgb;\n  \n	vec4 color = PBRStandardDiectionLight(diffuseColor.rgb, mg.r, mg.g, normal, viewDir, u_DirectionLight, gi);\n	\n	color.a = diffuseColor.a;\n	\n	#ifdef EMISSION\n		vec4 emissionColor = u_EmissionColor;\n		#ifdef EMISSIONTEXTURE\n			emissionColor *=  texture2D(u_EmissionTexture, uv0);\n		#endif\n		color.rgb += emissionColor.rgb;\n	#endif\n	\n	#ifdef RECEIVESHADOW\n		float shadowValue = 1.0;\n		#ifdef SHADOWMAP_PSSM3\n			shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif\n		#ifdef SHADOWMAP_PSSM2\n			shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif \n		#ifdef SHADOWMAP_PSSM1\n			shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n		#endif\n		gl_FragColor = vec4(color.rgb * shadowValue, color.a);\n	#else\n		gl_FragColor = color;\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW		\n		main_castShadow();\n	#else\n		main_normal();\n	#endif  \n}\n\n";
		shaderCompile=ShaderCompile3D.add(PBRStandard,vs,ps,attributeMap,uniformMap);
		PBRStandardMaterial.SHADERDEFINE_DIFFUSETEXTURE=shaderCompile.registerMaterialDefine("DIFFUSETEXTURE");
		PBRStandardMaterial.SHADERDEFINE_METALLICGLOSSTEXTURE=shaderCompile.registerMaterialDefine("METALLICGLOSSTEXTURE");
		PBRStandardMaterial.SHADERDEFINE_SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA=shaderCompile.registerMaterialDefine("SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA");
		PBRStandardMaterial.SHADERDEFINE_NORMALTEXTURE=shaderCompile.registerMaterialDefine("NORMALTEXTURE");
		PBRStandardMaterial.SHADERDEFINE_PARALLAXTEXTURE=shaderCompile.registerMaterialDefine("PARALLAXTEXTURE");
		PBRStandardMaterial.SHADERDEFINE_OCCLUSIONTEXTURE=shaderCompile.registerMaterialDefine("OCCLUSIONTEXTURE");
		PBRStandardMaterial.SHADERDEFINE_EMISSION=shaderCompile.registerMaterialDefine("EMISSION");
		PBRStandardMaterial.SHADERDEFINE_EMISSIONTEXTURE=shaderCompile.registerMaterialDefine("EMISSIONTEXTURE");
		PBRStandardMaterial.SHADERDEFINE_TILINGOFFSET=shaderCompile.registerMaterialDefine("TILINGOFFSET");
		attributeMap={
			'a_Position':/*laya.d3.graphics.VertexElementUsage.POSITION0*/0,
			'a_Normal':/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3,
			'a_Tangent0':/*laya.d3.graphics.VertexElementUsage.TANGENT0*/5,
			'a_Texcoord0':/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2,
			'a_BoneWeights':/*laya.d3.graphics.VertexElementUsage.BLENDWEIGHT0*/7,
			'a_BoneIndices':/*laya.d3.graphics.VertexElementUsage.BLENDINDICES0*/6
		};
		uniformMap={
			'u_Bones':[ /*laya.d3.core.SkinnedMeshSprite3D.BONES*/0,/*laya.d3.shader.Shader3D.PERIOD_RENDERELEMENT*/0],
			'u_MvpMatrix':[ /*laya.d3.core.Sprite3D.MVPMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_WorldMat':[ /*laya.d3.core.Sprite3D.WORLDMATRIX*/0,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_CameraPos':[ /*laya.d3.core.BaseCamera.CAMERAPOS*/0,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_AlphaTestValue':[ /*laya.d3.core.material.BaseMaterial.ALPHATESTVALUE*/0,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseColor':[ /*laya.d3.core.material.PBRSpecularMaterial.DIFFUSECOLOR*/7,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_SpecularColor':[ /*laya.d3.core.material.PBRSpecularMaterial.SPECULARCOLOR*/8,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_EmissionColor':[ /*laya.d3.core.material.PBRSpecularMaterial.EMISSIONCOLOR*/9,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseTexture':[ /*laya.d3.core.material.PBRSpecularMaterial.DIFFUSETEXTURE*/1,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_NormalTexture':[ /*laya.d3.core.material.PBRSpecularMaterial.NORMALTEXTURE*/3,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_ParallaxTexture':[ /*laya.d3.core.material.PBRSpecularMaterial.PARALLAXTEXTURE*/4,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_SpecularTexture':[ /*laya.d3.core.material.PBRSpecularMaterial.SPECULARTEXTURE*/2,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_OcclusionTexture':[ /*laya.d3.core.material.PBRSpecularMaterial.OCCLUSIONTEXTURE*/5,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_EmissionTexture':[ /*laya.d3.core.material.PBRSpecularMaterial.EMISSIONTEXTURE*/6,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_smoothness':[ /*laya.d3.core.material.PBRSpecularMaterial.SMOOTHNESS*/10,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_smoothnessScale':[ /*laya.d3.core.material.PBRSpecularMaterial.SMOOTHNESSSCALE*/11,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_occlusionStrength':[ /*laya.d3.core.material.PBRSpecularMaterial.OCCLUSIONSTRENGTH*/13,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_normalScale':[ /*laya.d3.core.material.PBRSpecularMaterial.NORMALSCALE*/14,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_parallaxScale':[ /*laya.d3.core.material.PBRSpecularMaterial.PARALLAXSCALE*/15,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_TilingOffset':[ /*laya.d3.core.material.PBRSpecularMaterial.TILINGOFFSET*/17,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DirectionLight.Direction':[ /*laya.d3.core.scene.Scene.LIGHTDIRECTION*/3,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_DirectionLight.Color':[ /*laya.d3.core.scene.Scene.LIGHTDIRCOLOR*/4,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_AmbientColor':[ /*laya.d3.core.scene.Scene.AMBIENTCOLOR*/21,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap1':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE1*/18,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap2':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE2*/19,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap3':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE3*/20,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowPSSMDistance':[ /*laya.d3.core.scene.Scene.SHADOWDISTANCE*/15,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_lightShadowVP':[ /*laya.d3.core.scene.Scene.SHADOWLIGHTVIEWPROJECT*/16,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowPCFoffset':[ /*laya.d3.core.scene.Scene.SHADOWMAPPCFOFFSET*/17,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4]
		};
		var PBRSpecular=Shader3D.nameKey.add("PBRSpecular");
		vs="attribute vec4 a_Position;\nattribute vec3 a_Normal;\nattribute vec4 a_Tangent0;\nattribute vec2 a_Texcoord0;\n\nuniform mat4 u_MvpMatrix;\nuniform mat4 u_WorldMat;\nuniform vec3 u_CameraPos;\n\nvarying vec2 v_Texcoord0;\nvarying vec3 v_Normal;\nvarying vec3 v_Tangent;\nvarying vec3 v_Binormal;\nvarying vec3 v_ViewDir;\nvarying vec3 v_PositionWorld;\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n  #ifdef SHADOWMAP_PSSM1 \n	  varying vec4 v_lightMVPPos;\n	  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\n#ifdef BONE\n	const int c_MaxBoneCount = 24;\n	attribute vec4 a_BoneIndices;\n	attribute vec4 a_BoneWeights;\n	uniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\nvoid main_castShadow()\n{\n	#ifdef BONE\n		mat4 skinTransform=mat4(0.0);\n		skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		vec4 position = skinTransform * a_Position;\n		gl_Position = u_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * a_Position;\n	#endif\n	 \n	//TODO没考虑UV动画呢\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		v_Texcoord0 = a_Texcoord0;\n	#endif\n		v_posViewZ = gl_Position.z;\n}\n\nvoid main_normal()\n{\n	mat3 worldMat;\n	#ifdef BONE\n		mat4 skinTransform = mat4(0.0);\n		skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		vec4 position = skinTransform * a_Position;\n		gl_Position = u_MvpMatrix * position;\n		worldMat=mat3(u_WorldMat*skinTransform);\n		v_PositionWorld = (u_WorldMat * position).xyz;\n	#else\n		gl_Position = u_MvpMatrix * a_Position;\n		worldMat = mat3(u_WorldMat);\n		v_PositionWorld = (u_WorldMat * a_Position).xyz;\n	#endif\n	\n	v_Normal = worldMat * a_Normal;\n	v_Tangent = worldMat * a_Tangent0.xyz;\n	v_Binormal = cross(v_Normal, v_Tangent) * a_Tangent0.w;\n  \n	v_Texcoord0 = a_Texcoord0;\n	#ifdef TILINGOFFSET\n		v_Texcoord0=(vec2(v_Texcoord0.x,v_Texcoord0.y-1.0)*u_TilingOffset.xy)+u_TilingOffset.zw;\n	#endif\n		v_Texcoord0=vec2(v_Texcoord0.x,1.0 + v_Texcoord0.y);\n  \n	v_ViewDir = u_CameraPos - v_PositionWorld;\n  \n	#ifdef RECEIVESHADOW\n		v_posViewZ = gl_Position.w;\n		#ifdef SHADOWMAP_PSSM1 \n			v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n		#endif\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW\n		main_castShadow();\n	#else\n		main_normal();\n	#endif\n}";
		ps="#ifdef FSHIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\nvarying vec2 v_Texcoord0;\nvarying vec3 v_Normal;\nvarying vec3 v_Tangent;\nvarying vec3 v_Binormal;\nvarying vec3 v_ViewDir;\n\nuniform vec3 u_AmbientColor;\nuniform vec4 u_DiffuseColor;\nuniform vec4 u_SpecularColor;\n\n#ifdef DIFFUSETEXTURE\n	uniform sampler2D u_DiffuseTexture;\n#endif\n#ifdef SPECULARTEXTURE\n	uniform sampler2D u_SpecularTexture;\n#endif\n#ifdef NORMALTEXTURE\n	uniform sampler2D u_NormalTexture;\n	uniform float u_normalScale;\n#endif\n#ifdef PARALLAXTEXTURE\n	uniform sampler2D u_ParallaxTexture;\n	uniform float u_parallaxScale;\n#endif\n#ifdef OCCLUSIONTEXTURE\n	uniform sampler2D u_OcclusionTexture;\n	uniform float u_occlusionStrength;\n#endif\n#ifdef EMISSION\n	#ifdef EMISSIONTEXTURE\n		uniform sampler2D u_EmissionTexture;\n	#endif\n	uniform vec4 u_EmissionColor;\n#endif\n\nuniform float u_AlphaTestValue;\nuniform float u_metallic;\nuniform float u_smoothness;\nuniform float u_smoothnessScale;\n\n#include \"PBRSpecularLighting.glsl\"\n#include \"ShadowHelper.glsl\"\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n		uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n		varying vec4 v_lightMVPPos;\n	#endif\n#endif\n\nuniform DirectionLight u_DirectionLight;\n\nvoid main_castShadow()\n{\n	gl_FragColor=packDepth(v_posViewZ);\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		float alpha = texture2D(u_DiffuseTexture,v_Texcoord0).w;\n		if( alpha < u_AlphaTestValue )\n		{\n			discard;\n		}\n	#endif\n}\n\nvoid main_normal()\n{	\n	vec3 viewDir = normalize(v_ViewDir);\n	\n	vec2 uv0 = ParallaxOffset(viewDir);\n	\n	vec4 sg;\n	#ifdef DIFFUSETEXTURE\n		vec4 diffuseTextureColor = texture2D(u_DiffuseTexture, uv0);\n		vec4 diffuseColor = diffuseTextureColor * u_DiffuseColor;\n		sg = SpecularGloss(diffuseTextureColor.a, uv0);\n	#else\n		vec4 diffuseColor = u_DiffuseColor;\n		sg = SpecularGloss(1.0, uv0);\n	#endif\n	\n	#ifdef ALPHATEST\n		if(diffuseColor.a < u_AlphaTestValue)\n			discard;\n	#endif\n  \n	vec3 normal = UnpackScaleNormal(uv0);\n	\n	vec3 gi =  u_AmbientColor * Occlusion(uv0).rgb;\n	\n	//float a = (sg.r+sg.g+sg.b) / 3.0;\n  \n	vec4 color = PBRSpecularDiectionLight(diffuseColor.rgb, sg.rgb, sg.a, normal,viewDir, u_DirectionLight, gi);\n	\n	color.a = diffuseColor.a;\n	\n	#ifdef EMISSION\n		vec4 emissionColor = u_EmissionColor;\n		#ifdef EMISSIONTEXTURE\n			emissionColor *=  texture2D(u_EmissionTexture, uv0);\n		#endif\n		color.rgb += emissionColor.rgb;\n	#endif\n	\n	#ifdef RECEIVESHADOW\n		float shadowValue = 1.0;\n		#ifdef SHADOWMAP_PSSM3\n			shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif\n		#ifdef SHADOWMAP_PSSM2\n			shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif \n		#ifdef SHADOWMAP_PSSM1\n			shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n		#endif\n		gl_FragColor = vec4(color.rgb * shadowValue, color.a);\n	#else\n		gl_FragColor = color;\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW		\n		main_castShadow();\n	#else\n		main_normal();\n	#endif  \n}\n\n";
		shaderCompile=ShaderCompile3D.add(PBRSpecular,vs,ps,attributeMap,uniformMap);
		PBRSpecularMaterial.SHADERDEFINE_DIFFUSETEXTURE=shaderCompile.registerMaterialDefine("DIFFUSETEXTURE");
		PBRSpecularMaterial.SHADERDEFINE_SPECULARTEXTURE=shaderCompile.registerMaterialDefine("SPECULARTEXTURE");
		PBRSpecularMaterial.SHADERDEFINE_SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA=shaderCompile.registerMaterialDefine("SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA");
		PBRSpecularMaterial.SHADERDEFINE_NORMALTEXTURE=shaderCompile.registerMaterialDefine("NORMALTEXTURE");
		PBRSpecularMaterial.SHADERDEFINE_PARALLAXTEXTURE=shaderCompile.registerMaterialDefine("PARALLAXTEXTURE");
		PBRSpecularMaterial.SHADERDEFINE_OCCLUSIONTEXTURE=shaderCompile.registerMaterialDefine("OCCLUSIONTEXTURE");
		PBRSpecularMaterial.SHADERDEFINE_EMISSION=shaderCompile.registerMaterialDefine("EMISSION");
		PBRSpecularMaterial.SHADERDEFINE_EMISSIONTEXTURE=shaderCompile.registerMaterialDefine("EMISSIONTEXTURE");
		PBRSpecularMaterial.SHADERDEFINE_TILINGOFFSET=shaderCompile.registerMaterialDefine("TILINGOFFSET");
		attributeMap={
			'a_position':/*laya.d3.graphics.VertexElementUsage.POSITION0*/0,
			'a_normal':/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3,
			'uv':/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2};
		uniformMap={
			'irrad_mat_red':[ /*laya.d3.core.BaseCamera.DIFFUSEIRRADMATR*/10,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'irrad_mat_green':[ /*laya.d3.core.BaseCamera.DIFFUSEIRRADMATG*/11,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'irrad_mat_blue':[ /*laya.d3.core.BaseCamera.DIFFUSEIRRADMATB*/12,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_hdrexposure':[ /*laya.d3.core.BaseCamera.HDREXPOSURE*/13,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'texBaseColor':[ /*laya.d3.core.material.WaterMaterial.DIFFUSETEXTURE*/1,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'texNormal':[ /*laya.d3.core.material.WaterMaterial.NORMALTEXTURE*/2,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'texSky':[ /*laya.d3.core.material.WaterMaterial.SKYTEXTURE*/11,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'texUnderWater':[ /*laya.d3.core.material.WaterMaterial.UNDERWATERTEXTURE*/3,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'texPrefilterdEnv':[ /*laya.d3.core.BaseCamera.ENVIRONMENTSPECULAR*/8,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'texPrefilterDiff':[ /*laya.d3.core.BaseCamera.ENVIRONMENTDIFFUSE*/7,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'texWaterDisp':[ /*laya.d3.core.material.WaterMaterial.VERTEXDISPTEXTURE*/4,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'texWaveDetail':[ /*laya.d3.core.material.WaterMaterial.DETAILTEXTURE*/9,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'texDeepColor':[ /*laya.d3.core.material.WaterMaterial.DEEPCOLORTEXTURE*/10,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'texWaterInfo':[ /*laya.d3.core.material.WaterMaterial.WATERINFO*/16,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'texFoam':[ /*laya.d3.core.material.WaterMaterial.FOAMTEXTURE*/17,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'GEOWAVE_UV_SCALE':[ /*laya.d3.core.material.WaterMaterial.GEOWAVE_UV_SCALE*/18,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'modelMatrix':[ /*laya.d3.core.Sprite3D.WORLDMATRIX*/0,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'mvp':[ /*laya.d3.core.Sprite3D.MVPMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'cameraPosition':[ /*laya.d3.core.BaseCamera.CAMERAPOS*/0,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_curTm':[ /*laya.d3.core.material.WaterMaterial.CURTM*/8,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_scrsize':[ /*laya.d3.core.material.WaterMaterial.SCRSIZE*/15,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_WaveInfoD':[ /*laya.d3.core.material.WaterMaterial.WAVEINFOD*/13,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_WaveInfo':[ /*laya.d3.core.material.WaterMaterial.WAVEINFO*/12,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_WaveMainDir':[ /*laya.d3.core.material.WaterMaterial.WAVEMAINDIR*/14,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DeepScale':[ /*laya.d3.core.material.WaterMaterial.WAVEINFODEEPSCALE*/20,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_SeaColor':[ /*laya.d3.core.material.WaterMaterial.SEA_COLOR*/19,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_View':[ /*laya.d3.core.BaseCamera.VIEWMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_Project':[ /*laya.d3.core.BaseCamera.PROJECTMATRIX*/2,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_FogStart':[ /*laya.d3.core.scene.Scene.FOGSTART*/1,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_FogRange':[ /*laya.d3.core.scene.Scene.FOGRANGE*/2,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_FogColor':[ /*laya.d3.core.scene.Scene.FOGCOLOR*/0,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_DirectionLight.Direction':[ /*laya.d3.core.scene.Scene.LIGHTDIRECTION*/3,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_DirectionLight.Diffuse':[ /*laya.d3.core.scene.Scene.LIGHTDIRCOLOR*/4,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Position':[ /*laya.d3.core.scene.Scene.POINTLIGHTPOS*/5,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Range':[ /*laya.d3.core.scene.Scene.POINTLIGHTRANGE*/6,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Attenuation':[ /*laya.d3.core.scene.Scene.POINTLIGHTATTENUATION*/7,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Diffuse':[ /*laya.d3.core.scene.Scene.POINTLIGHTCOLOR*/8,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Position':[ /*laya.d3.core.scene.Scene.SPOTLIGHTPOS*/9,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Direction':[ /*laya.d3.core.scene.Scene.SPOTLIGHTDIRECTION*/10,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Range':[ /*laya.d3.core.scene.Scene.SPOTLIGHTRANGE*/12,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Spot':[ /*laya.d3.core.scene.Scene.SPOTLIGHTSPOT*/11,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Attenuation':[ /*laya.d3.core.scene.Scene.SPOTLIGHTATTENUATION*/13,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Diffuse':[ /*laya.d3.core.scene.Scene.SPOTLIGHTCOLOR*/14,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4]};
		var Water=Shader3D.nameKey.add("Water");
		vs="\nuniform mat4 modelMatrix;\n//uniform mat4 modelViewMatrix;\n//uniform mat4 projectionMatrix;\nuniform mat4 u_View;\nuniform mat4 u_Project;\nuniform mat4 mvp;\n//uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\nuniform float u_curTm;\n\nattribute vec3 a_position;\nattribute vec3 a_normal;\nattribute vec2 uv;\n//uniform sampler2D texWaterDisp;\n#ifdef USE_VERTEX_DEEPINFO\n#else\nuniform sampler2D texWaterInfo;\nvarying vec4 vWaterInfo;\nuniform float u_DeepScale;//texWaterInfo.r*vDeepScale\n#endif\nuniform float u_WaveMainDir;	//主波方向\nuniform float GEOWAVE_UV_SCALE ;//= 100.0;\n\n\nvarying vec2 vUv;\nvarying vec3 vWorldNorm;\nvarying vec3 vWorldTan;\nvarying vec3 vWorldBin;\nvarying vec4 vViewPos;\nvarying vec4 vWorldPos;\nvarying vec3 vLightDir;\nvarying vec3 vViewDir;\nvarying vec3 vDisp;\nvarying float fDeep;\nvarying mat2 matUVTrans;\nvarying float fFoam;\n\nconst float PI = 3.14159265358979323846264;\n\n#include \"WaveFunction.glsl\"\n\nvec2 getPosFromUV(vec2 uv){\n	return uv*50.;\n}\n\nvoid main() {\n	vec3 pos = a_position;\n    vUv = uv;\n	\n	//vDisp = texture2D(texWaterDisp,uv).rgb;\n	//vec3 disp = vDisp;\n	\n	//TODO 这里有个潜规则。\n	float tt = pos.y; pos.y=pos.z; pos.z=-tt;\n	\n	#ifdef USE_VERTEX_DEEPINFO\n	fDeep = -pos.y;\n	pos.y=0.0;\n	#else\n	vWaterInfo = texture2D(texWaterInfo,uv);\n	fDeep = vWaterInfo.r*u_DeepScale;\n	#endif\n	\n	\n	//计算波形\n	mat4 modelMat = modelMatrix;\n	vec3 opos, T,B,N;\n	float foams=0.;\n	vec2 uvpos = uv*GEOWAVE_UV_SCALE+vec2(modelMat[3][0],0.);//TODO 如果有旋转缩放怎么办\n	calcGerstnerWave(u_curTm, pos,fDeep, uvpos,opos,B,T,N,foams);\n	fFoam = foams;\n	gl_Position = mvp*vec4(opos,1.);\n	vWorldPos = modelMat*vec4(opos,1.);\n\n	vWorldNorm = normalize((modelMatrix*vec4(N,0.0)).xyz);\n	vWorldTan = normalize((modelMatrix*vec4(T,0.0)).xyz);\n	vWorldBin = normalize((modelMatrix*vec4(B,0.0)).xyz);\n    vViewDir = vWorldPos.xyz-cameraPosition; //这个不能取normalize，否则会引入非线性\n	\n	float s = sin(u_WaveMainDir);\n	float c = cos(u_WaveMainDir);\n	matUVTrans = mat2(c,-s,s,c);\n}\n";
		ps="//#version 300 es\n\nprecision highp float;\nprecision lowp int;\n\nconst float PI = 3.14159265358979323846264;\nconst float _2PI = 6.2831853071796;\nvarying vec2 vUv;\nvarying vec3 vWorldNorm;\nvarying vec3 vWorldTan;\nvarying vec3 vWorldBin;\nvarying vec3 vViewDir;//入射。pos-cam\nvarying vec4 vViewPos;\nvarying vec4 vWorldPos;\nvarying float fDeep;\nvarying mat2 matUVTrans;\n#ifdef USE_VERTEX_DEEPINFO\n#else\nvarying vec4 vWaterInfo;\n#endif\nmat3 matTBNOff;//\n\n//\nuniform sampler2D texBaseColor;\nuniform sampler2D texNormal;\n#ifdef CUBE_ENV\nuniform samplerCube texSky;\n#else\nuniform sampler2D texSky;\n#endif\nuniform sampler2D texUnderWater;\nuniform sampler2D texWaveDetail;\n//uniform sampler2D texDeepColor;\nuniform sampler2D texFoam;\nvarying float fFoam;\nuniform float u_curTm;\nuniform vec2 u_scrsize;\nuniform vec3 u_SeaColor;//\n\nconst int NumTexWaves=4;\nconst float Amp_over_L = 0.01;\n//const vec3 SEA_COLOR1 = vec3(0.0292,0.672,0.7467);//大洋\n//const vec3 SEA_COLOR2 = vec3(0,0.927,0.43);//近海\n\nconst float _maxu8 = 255.0;\nconst float _maxu16 = 65535.0;\nconst float _shift8 = 256.0;    //平移的话是*256而不是255\nvec2 _RGBAToU16(const in vec4 rgba){\n    return vec2((rgba.r*_maxu8+rgba.g*_maxu8*_shift8)/_maxu16, (rgba.b*_maxu8+rgba.a*_maxu8*_shift8)/_maxu16);\n}\nvec3 _RGBEToRGB( const in vec4 rgba ){\n    float f = pow(2.0, rgba.w * 255.0 - (128.0 + 8.0));\n    return rgba.rgb * (255.0 * f);\n}\n\nfloat saturate(float v){\n    return min(max(v,0.),1.);\n}\n\n/*\n	各种 ToneMap\n*/\n//Reinhard\nvec3 ReinhardToneMapping(vec3 color, float adapted_lum) {\n    const float MIDDLE_GREY = 1.;\n    color *= MIDDLE_GREY / adapted_lum;\n    return color / (1.0 + color);\n}\n\n//CE2\nvec3 CEToneMapping(vec3 color, float adapted_lum){\n    return 1. - exp(-adapted_lum * color);\n}\n\n//UC2\nvec3 F1(vec3 x){\n	const float A = 0.22;\n	const float B = 0.30;\n	const float C = 0.10;\n	const float D = 0.20;\n	const float E = 0.01;\n	const float F = 0.30;\n \n	return ((x * (A * x + C * B) + D * E) / (x * (A * x + B) + D * F)) - E / F;\n}\n\nvec3 Uncharted2ToneMapping(vec3 color, float adapted_lum){\n	const vec3 WHITE = vec3(11.2);\n	return F1(1.6 * adapted_lum * color) / F1(WHITE);\n}\n\n//ACES\nvec3 ACESToneMapping(vec3 color, float adapted_lum){\n	const float A = 2.51;\n	const float B = 0.03;\n	const float C = 2.43;\n	const float D = 0.59;\n	const float E = 0.14;\n\n	color *= adapted_lum;\n	return (color * (A * color + B)) / (color * (C * color + D) + E);\n}\n\n/*\n* 对一个全景图进行采样。假设x轴指向中心。\n*/\nvec4 texPanorama(sampler2D tex, const in vec3 dir){\n	float envu = atan(dir.z,dir.x)/_2PI+0.5; 	\n	float envv = acos(dir.y)/PI;//(1.0-dir.y)/2.0;\n	return texture2D(tex,vec2(envu,envv));\n}\n\n/*\n	与位于0点的测试棒的相交测试交点\n	这个是瞎写的，只是为了测试\n*/\nbool hitClydiner(vec3 pos, vec3 dir, out vec3 hitpos, out vec3 hitnormal){\n	const float r = 0.5;\n	float a = dir.x*dir.x+dir.z*dir.z;\n	float b = 2.*dir.x*pos.x+2.*dir.z*pos.z;\n	float c = pos.x*pos.x+pos.z*pos.z-r*r;\n	float d = b*b-4.*a*c;\n	if(d>=0.0){\n		float t = (-b+sqrt(d))/2./a;\n		t =min(t, (-b-sqrt(d))/2./a);\n		hitpos = pos+dir*t;\n		return true;\n	}\n	/*\n	vec3 v1 = normalize(cross(dir,vec3(0.,1.,0.)));//公垂线\n	float dist = dot(pos,v1);//最短距离\n	if(abs(dist)<r){\n		return true;\n	}\n	*/\n	return false;\n}\n\n///* 根据散射公式来计算某个方向的颜色 *///\n//\nfloat phase_function(float costheta, float g, float g2){\n	return 1.5*( (1.0-g2) / (2.0+g2) ) * (1.0+costheta*costheta) / pow(1.0+g2-2.0*g*costheta, 1.5);	\n}\n\nconst float _density = .2;\nconst vec3 _vLightDir=vec3(0.,-1.,0.);//必须是规格化的\nconst int _SAMPLENUM = 20;\nconst float _K1 = 1.0;\nconst float _g = -0.93;\n//\nvec3 calcScatter(vec3 start, vec3 dir, vec3 end){\n	float len = length(end-start);\n	float costheta = dot(dir,_vLightDir);\n	float g2 = _g*_g;\n	float K = _K1*len*_density*phase_function(costheta,_g,g2);\n	//用分段的方式来积分\n	float dlen = len/float(_SAMPLENUM);//距离平分\n	float ddeep = (start.y-end.y)/float(_SAMPLENUM);//深度平分\n	float sum=0.;\n	for( int i=0; i<_SAMPLENUM; i++){\n		float fi = float(i);\n		float v1 = exp(-_density*(dlen+ddeep)*fi);//TODO 应该可以用分析法计算出来\n		sum += v1;\n	}\n	return vec3(K*sum);\n}\n///* 根据散射公式来计算某个方向的亮度  END *///\n\nconst float cDeep = -2.;	//假设水的深度\nvec3 getShuiDiColor(vec3 pos, vec3 dir, vec3 normal){\n	//一个无限大的水底，黑白格纹理。纹理长度为1米\n	float t = ( cDeep-pos.y )/dir.y;\n	if(t<0.) return vec3(1.,0.,0.);//TEST\n	bool bhit = false;\n	vec3 hitpos;\n	vec3 hitcolor;\n	vec3 hn;\n	if(hitClydiner(pos,dir,hitpos,hn) && hitpos.y>cDeep && hitpos.y<pos.y){\n		bhit=true;\n		hitcolor = vec3(.8,.8,.8);\n\n	}else\n	{\n		hitpos = pos+dir*t;\n		vec3 hp = floor(hitpos);\n		float a = mod((hp.x+hp.z),2.);\n		hitcolor = (a<.9)?vec3(0.,0.,0.):vec3(1.,1.,1.);\n		//hitcolor = texture2D(texUnderWater,hitpos.xz/10.).rgb;\n	}\n	\n	float l = length(hitpos-pos);\n	//return texture2D(texDeepColor,vec2(min(max(l/400.,0.),1.),0.5)).rgb;\n	//return SEA_COLOR1*calcScatter(pos,dir,hitpos);\n	float left = pow(0.8,l);//假设透过率为80%，则到达水底的时候的光强。\n	return mix(hitcolor,u_SeaColor,1.-left);\n}\n\n/*\n	view已经normalize了\n*/\nvec3 getRefractColor(vec3 view,vec3 normal){\n	vec3 T = refract(-view, normal, 0.7);\n	return getShuiDiColor(vWorldPos.xyz,T,normal); \n}\n\nvec4 calcWaterC(vec3 view, vec3 normal, float von, vec3 R, float rough){\n	/*\n	只有浪顶的法线向下，也就是波形形成了交叠的时候，才会这样，所以要通过参数控制避免出现这种情况，而不是在这里保护。\n	if(dot(R,vec3(0.,1.,0.))<0.){\n		R = -R;\n	}\n	*/\n	//vec3 refr = getRefractColor(-view,normal);\n#ifdef USE_REFR_TEX	\n	vec3 refr = texture2D(texUnderWater, gl_FragCoord.xy/u_scrsize+normal.xz/8.).rgb;\n#else\n	vec3 refr = u_SeaColor;\n#endif\n	float F0=0.02;\n	//菲涅尔，越大反射越强\n	float f =  F0+(1.0-F0)*exp2((-5.55473*von-6.98316)*von);\n	//float f = F0+(1.0-F0)*pow(1.-von,5.);\n	//能看到水底的程度。反射剩余的*水中的衰减\n	//float a = (1.-f)*(1.-deepk);\n#ifdef CUBE_ENV\n	vec4 reflc = textureCube(texSky,R);\n#else\n	vec4 reflc = texPanorama(texSky, R);\n#endif\n#ifdef HDR_ENV\n	vec3 refl = _RGBEToRGB(reflc)*f;\n#else\n	vec3 refl = reflc.rgb*f;\n#endif\n	//return vec4(refl*(1.-rough),1.);\n	\n	//vec3 refl = reflc.rgb*f;\n	vec3 final = mix(refr, u_SeaColor, min(fDeep/10.,1.))+refl*(max(0.,1.-rough));\n#ifdef HDR_ENV\n	final = ACESToneMapping(final,1.);//TODO 这个要uniform传入\n#endif\n	return vec4(final,f);\n}\n\nvoid main() {\n    vec3 normal =  normalize(vWorldNorm);\n	//如果uv=1为100米，希望每个细节纹理表示20米的小波形，则uv缩放是 100/20。细节纹理内部也要用这个值，即pos=uv*20\n	vec2 ruv = matUVTrans*vUv;\n	vec3 detailNorm = texture2D(texWaveDetail,fract(ruv*5.)).rgb*2.-vec3(1.);//TODO uv怎么算\n	float texNormScale = 2.*PI*float(NumTexWaves)*Amp_over_L*2.5;\n	detailNorm *= vec3(texNormScale,1.,texNormScale);\n	//旋转\n	//细节纹理来自rendertarget，因此需要颠倒z\n	\n	matTBNOff = mat3(matUVTrans[0][0],0.,matUVTrans[1][0],\n	0.,1.,0.,\n	matUVTrans[0][1],0.,matUVTrans[1][1]\n	);\n	\n	/*\n	matTBNOff = mat3(0.,0.,1.,\n	0.,1.,0.,\n	-1.,0.,0.\n	);\n	*/\n\n    mat3 tsn = mat3( vWorldBin, normal, vWorldTan);	\n    //normal = normalize(tsn * matTBNOff * detailNorm);\n	normal = normalize(tsn * detailNorm); //这个应该更正确。因为本身方向就是根据uv算的，如果是静态图片才需要转换。\n	//vec4 normtex = texture2D( texNormal, vUv );\n    vec3 view   = -normalize(vViewDir);//view 是指向camera的\n    float NoV = saturate(dot( view, normal ));\n    //vec3 R = 2. * NoV * normal - view;\n	\n#ifdef USE_FOAM	\n	vec4 foamc = (texture2D(texFoam,vUv*50.)+texture2D(texFoam,vUv*20.))/2.;\n	float nearcoast = 1.-min(fDeep/10.,1.);// 1.-vWaterInfo.r;\n	float foams = (nearcoast/4.+fFoam)*2.*nearcoast;\n#else\n	float foams =0.;\n#endif\n	\n	vec3 R = reflect(-view,normal);\n	vec4 wc = calcWaterC(view, normal,NoV,R, foams);\n\n	gl_FragColor.rgb = wc.rgb;//normalize(detailNorm).rrr;//((normal)+vec3(0.0))/1.;//normalize(normal).rgb;//texture2D(texWaveDetail,vUv).rgb;// fracColor * texture2D(texUnderWater, vUv*20.0).rgb;// vec3(1.0);//pbrl.rgb;\n    gl_FragColor.a = 1.0;//wc.a;\n#ifdef USE_FOAM\n	gl_FragColor.rgb = mix(gl_FragColor.rgb,vec3(1.),foamc.a*foams);\n	gl_FragColor.a = foamc.r;\n#endif\n	//if(mod(vUv.x*100.,1.0)<0.02 || mod(vUv.y*100.,1.0)<0.02) gl_FragColor.rgb=vec3(0.5,.5,.5);\n	//gl_FragColor.rgb = detailNorm;\n}\n";
		shaderCompile=ShaderCompile3D.add(Water,vs,ps,attributeMap,uniformMap);
		WaterMaterial.SHADERDEFINE_CUBE_ENV=shaderCompile.registerMaterialDefine("CUBE_ENV");
		WaterMaterial.SHADERDEFINE_HDR_ENV=shaderCompile.registerMaterialDefine("HDR_ENV");
		WaterMaterial.SHADERDEFINE_SHOW_NORMAL=shaderCompile.registerMaterialDefine("SHOW_NORMAL");
		WaterMaterial.SHADERDEFINE_USEVERTEXHEIGHT=shaderCompile.registerMaterialDefine("USE_VERTEX_DEEPINFO");
		WaterMaterial.SHADERDEFINE_USE_FOAM=shaderCompile.registerMaterialDefine("USE_FOAM");
		WaterMaterial.SHADERDEFINE_USE_REFRACT_TEX=shaderCompile.registerMaterialDefine("USE_REFR_TEX");
		attributeMap={
			'a_CornerTextureCoordinate':/*laya.d3.graphics.VertexElementUsage.CORNERTEXTURECOORDINATE0*/17,
			'a_MeshPosition':/*laya.d3.graphics.VertexElementUsage.POSITION0*/0,
			'a_MeshColor':/*laya.d3.graphics.VertexElementUsage.COLOR0*/1,
			'a_MeshTextureCoordinate':/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2,
			'a_ShapePositionStartLifeTime':/*laya.d3.graphics.VertexElementUsage.SHAPEPOSITIONSTARTLIFETIME*/30,
			'a_DirectionTime':/*laya.d3.graphics.VertexElementUsage.DIRECTIONTIME*/32,
			'a_StartColor':/*laya.d3.graphics.VertexElementUsage.STARTCOLOR0*/19,
			'a_EndColor':/*laya.d3.graphics.VertexElementUsage.ENDCOLOR0*/23,
			'a_StartSize':/*laya.d3.graphics.VertexElementUsage.STARTSIZE*/20,
			'a_StartRotation0':/*laya.d3.graphics.VertexElementUsage.STARTROTATION*/22,
			'a_StartSpeed':/*laya.d3.graphics.VertexElementUsage.STARTSPEED*/31,
			'a_Random0':/*laya.d3.graphics.VertexElementUsage.RANDOM0*/34,
			'a_Random1':/*laya.d3.graphics.VertexElementUsage.RANDOM1*/35,
			'a_SimulationWorldPostion':/*laya.d3.graphics.VertexElementUsage.SIMULATIONWORLDPOSTION*/36,
			'a_SimulationWorldRotation':/*laya.d3.graphics.VertexElementUsage.SIMULATIONWORLDROTATION*/37};
		uniformMap={
			'u_Tintcolor':[ /*laya.d3.core.particleShuriKen.ShurikenParticleMaterial.TINTCOLOR*/2,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_TilingOffset':[ /*laya.d3.core.particleShuriKen.ShurikenParticleMaterial.TILINGOFFSET*/3,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_texture':[ /*laya.d3.core.particleShuriKen.ShurikenParticleMaterial.DIFFUSETEXTURE*/1,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_WorldPosition':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.WORLDPOSITION*/0,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_WorldRotation':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.WORLDROTATION*/1,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_PositionScale':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.POSITIONSCALE*/4,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_SizeScale':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.SIZESCALE*/5,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ScalingMode':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.SCALINGMODE*/6,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_Gravity':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.GRAVITY*/7,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ThreeDStartRotation':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.THREEDSTARTROTATION*/8,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_StretchedBillboardLengthScale':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.STRETCHEDBILLBOARDLENGTHSCALE*/9,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_StretchedBillboardSpeedScale':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.STRETCHEDBILLBOARDSPEEDSCALE*/10,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_SimulationSpace':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.SIMULATIONSPACE*/11,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_CurrentTime':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.CURRENTTIME*/12,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ColorOverLifeGradientAlphas':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.COLOROVERLIFEGRADIENTALPHAS*/22,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ColorOverLifeGradientColors':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.COLOROVERLIFEGRADIENTCOLORS*/23,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_MaxColorOverLifeGradientAlphas':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.MAXCOLOROVERLIFEGRADIENTALPHAS*/24,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_MaxColorOverLifeGradientColors':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.MAXCOLOROVERLIFEGRADIENTCOLORS*/25,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_VOLVelocityConst':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.VOLVELOCITYCONST*/13,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_VOLVelocityGradientX':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.VOLVELOCITYGRADIENTX*/14,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_VOLVelocityGradientY':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.VOLVELOCITYGRADIENTY*/15,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_VOLVelocityGradientZ':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.VOLVELOCITYGRADIENTZ*/16,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_VOLVelocityConstMax':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.VOLVELOCITYCONSTMAX*/17,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_VOLVelocityGradientMaxX':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.VOLVELOCITYGRADIENTXMAX*/18,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_VOLVelocityGradientMaxY':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.VOLVELOCITYGRADIENTYMAX*/19,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_VOLVelocityGradientMaxZ':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.VOLVELOCITYGRADIENTZMAX*/20,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_VOLSpaceType':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.VOLSPACETYPE*/21,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_SOLSizeGradient':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.SOLSIZEGRADIENT*/26,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_SOLSizeGradientX':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.SOLSIZEGRADIENTX*/27,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_SOLSizeGradientY':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.SOLSIZEGRADIENTY*/28,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_SOLSizeGradientZ':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.SOLSizeGradientZ*/29,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_SOLSizeGradientMax':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.SOLSizeGradientMax*/30,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_SOLSizeGradientMaxX':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.SOLSIZEGRADIENTXMAX*/31,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_SOLSizeGradientMaxY':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.SOLSIZEGRADIENTYMAX*/32,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_SOLSizeGradientMaxZ':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.SOLSizeGradientZMAX*/33,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ROLAngularVelocityConst':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.ROLANGULARVELOCITYCONST*/34,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ROLAngularVelocityConstSeprarate':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.ROLANGULARVELOCITYCONSTSEPRARATE*/35,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ROLAngularVelocityGradient':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENT*/36,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ROLAngularVelocityGradientX':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTX*/37,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ROLAngularVelocityGradientY':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTY*/38,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ROLAngularVelocityGradientZ':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTZ*/39,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ROLAngularVelocityGradientW':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTW*/40,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ROLAngularVelocityConstMax':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.ROLANGULARVELOCITYCONSTMAX*/41,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ROLAngularVelocityConstMaxSeprarate':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.ROLANGULARVELOCITYCONSTMAXSEPRARATE*/42,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ROLAngularVelocityGradientMax':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTMAX*/43,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ROLAngularVelocityGradientMaxX':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTXMAX*/44,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ROLAngularVelocityGradientMaxY':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTYMAX*/45,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ROLAngularVelocityGradientMaxZ':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTZMAX*/46,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_ROLAngularVelocityGradientMaxW':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTWMAX*/47,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_TSACycles':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.TEXTURESHEETANIMATIONCYCLES*/48,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_TSASubUVLength':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.TEXTURESHEETANIMATIONSUBUVLENGTH*/49,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_TSAGradientUVs':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.TEXTURESHEETANIMATIONGRADIENTUVS*/50,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_TSAMaxGradientUVs':[ /*laya.d3.core.particleShuriKen.ShuriKenParticle3D.TEXTURESHEETANIMATIONGRADIENTMAXUVS*/51,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_CameraPosition':[ /*laya.d3.core.BaseCamera.CAMERAPOS*/0,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_CameraDirection':[ /*laya.d3.core.BaseCamera.CAMERADIRECTION*/5,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_CameraUp':[ /*laya.d3.core.BaseCamera.CAMERAUP*/6,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_View':[ /*laya.d3.core.BaseCamera.VIEWMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_Projection':[ /*laya.d3.core.BaseCamera.PROJECTMATRIX*/2,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_FogStart':[ /*laya.d3.core.scene.Scene.FOGSTART*/1,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_FogRange':[ /*laya.d3.core.scene.Scene.FOGRANGE*/2,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_FogColor':[ /*laya.d3.core.scene.Scene.FOGCOLOR*/0,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4]};
		var PARTICLESHURIKEN=Shader3D.nameKey.add("PARTICLESHURIKEN");
		vs="#ifdef HIGHPRECISION\n  precision highp float;\n#else\n  precision mediump float;\n#endif\n\n#if defined(SPHERHBILLBOARD)||defined(STRETCHEDBILLBOARD)||defined(HORIZONTALBILLBOARD)||defined(VERTICALBILLBOARD)\n	attribute vec4 a_CornerTextureCoordinate;\n#endif\n#ifdef RENDERMODE_MESH\n	attribute vec3 a_MeshPosition;\n	attribute vec4 a_MeshColor;\n	attribute vec2 a_MeshTextureCoordinate;\n	varying vec4 v_MeshColor;\n#endif\n\nattribute vec4 a_ShapePositionStartLifeTime;\nattribute vec4 a_DirectionTime;\nattribute vec4 a_StartColor;\nattribute vec3 a_StartSize;\nattribute vec3 a_StartRotation0;\nattribute float a_StartSpeed;\n#if defined(COLOROVERLIFETIME)||defined(RANDOMCOLOROVERLIFETIME)||defined(SIZEOVERLIFETIMERANDOMCURVES)||defined(SIZEOVERLIFETIMERANDOMCURVESSEPERATE)||defined(ROTATIONOVERLIFETIMERANDOMCONSTANTS)||defined(ROTATIONOVERLIFETIMERANDOMCURVES)\n  attribute vec4 a_Random0;\n#endif\n#if defined(TEXTURESHEETANIMATIONRANDOMCURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n  attribute vec4 a_Random1;\n#endif\nattribute vec3 a_SimulationWorldPostion;\nattribute vec4 a_SimulationWorldRotation;\n\nvarying float v_Discard;\nvarying vec4 v_Color;\n#ifdef DIFFUSEMAP\n	varying vec2 v_TextureCoordinate;\n#endif\n\nuniform float u_CurrentTime;\nuniform vec3 u_Gravity;\n\nuniform vec3 u_WorldPosition;\nuniform vec4 u_WorldRotation;\nuniform bool u_ThreeDStartRotation;\nuniform int u_ScalingMode;\nuniform vec3 u_PositionScale;\nuniform vec3 u_SizeScale;\nuniform mat4 u_View;\nuniform mat4 u_Projection;\n\n#ifdef STRETCHEDBILLBOARD\n	uniform vec3 u_CameraPosition;\n#endif\nuniform vec3 u_CameraDirection;//TODO:只有几种广告牌模式需要用\nuniform vec3 u_CameraUp;\n\nuniform  float u_StretchedBillboardLengthScale;\nuniform  float u_StretchedBillboardSpeedScale;\nuniform int u_SimulationSpace;\n\n#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n  uniform  int  u_VOLSpaceType;\n#endif\n#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)\n  uniform  vec3 u_VOLVelocityConst;\n#endif\n#if defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n  uniform  vec2 u_VOLVelocityGradientX[4];//x为key,y为速度\n  uniform  vec2 u_VOLVelocityGradientY[4];//x为key,y为速度\n  uniform  vec2 u_VOLVelocityGradientZ[4];//x为key,y为速度\n#endif\n#ifdef VELOCITYOVERLIFETIMERANDOMCONSTANT\n  uniform  vec3 u_VOLVelocityConstMax;\n#endif\n#ifdef VELOCITYOVERLIFETIMERANDOMCURVE\n  uniform  vec2 u_VOLVelocityGradientMaxX[4];//x为key,y为速度\n  uniform  vec2 u_VOLVelocityGradientMaxY[4];//x为key,y为速度\n  uniform  vec2 u_VOLVelocityGradientMaxZ[4];//x为key,y为速度\n#endif\n\n#ifdef COLOROVERLIFETIME\n  uniform  vec4 u_ColorOverLifeGradientColors[4];//x为key,yzw为Color\n  uniform  vec2 u_ColorOverLifeGradientAlphas[4];//x为key,y为Alpha\n#endif\n#ifdef RANDOMCOLOROVERLIFETIME\n  uniform  vec4 u_ColorOverLifeGradientColors[4];//x为key,yzw为Color\n  uniform  vec2 u_ColorOverLifeGradientAlphas[4];//x为key,y为Alpha\n  uniform  vec4 u_MaxColorOverLifeGradientColors[4];//x为key,yzw为Color\n  uniform  vec2 u_MaxColorOverLifeGradientAlphas[4];//x为key,y为Alpha\n#endif\n\n\n#if defined(SIZEOVERLIFETIMECURVE)||defined(SIZEOVERLIFETIMERANDOMCURVES)\n  uniform  vec2 u_SOLSizeGradient[4];//x为key,y为尺寸\n#endif\n#ifdef SIZEOVERLIFETIMERANDOMCURVES\n  uniform  vec2 u_SOLSizeGradientMax[4];//x为key,y为尺寸\n#endif\n#if defined(SIZEOVERLIFETIMECURVESEPERATE)||defined(SIZEOVERLIFETIMERANDOMCURVESSEPERATE)\n  uniform  vec2 u_SOLSizeGradientX[4];//x为key,y为尺寸\n  uniform  vec2 u_SOLSizeGradientY[4];//x为key,y为尺寸\n  uniform  vec2 u_SOLSizeGradientZ[4];//x为key,y为尺寸\n#endif\n#ifdef SIZEOVERLIFETIMERANDOMCURVESSEPERATE\n  uniform  vec2 u_SOLSizeGradientMaxX[4];//x为key,y为尺寸\n  uniform  vec2 u_SOLSizeGradientMaxY[4];//x为key,y为尺寸\n  uniform  vec2 u_SOLSizeGradientMaxZ[4];//x为key,y为尺寸\n#endif\n\n\n#ifdef ROTATIONOVERLIFETIME\n  #if defined(ROTATIONOVERLIFETIMECONSTANT)||defined(ROTATIONOVERLIFETIMERANDOMCONSTANTS)\n    uniform  float u_ROLAngularVelocityConst;\n  #endif\n  #ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n    uniform  float u_ROLAngularVelocityConstMax;\n  #endif\n  #if defined(ROTATIONOVERLIFETIMECURVE)||defined(ROTATIONOVERLIFETIMERANDOMCURVES)\n    uniform  vec2 u_ROLAngularVelocityGradient[4];//x为key,y为旋转\n  #endif\n  #ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n    uniform  vec2 u_ROLAngularVelocityGradientMax[4];//x为key,y为旋转\n  #endif\n#endif\n#ifdef ROTATIONOVERLIFETIMESEPERATE\n  #if defined(ROTATIONOVERLIFETIMECONSTANT)||defined(ROTATIONOVERLIFETIMERANDOMCONSTANTS)\n    uniform  vec3 u_ROLAngularVelocityConstSeprarate;\n  #endif\n  #ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n    uniform  vec3 u_ROLAngularVelocityConstMaxSeprarate;\n  #endif\n  #if defined(ROTATIONOVERLIFETIMECURVE)||defined(ROTATIONOVERLIFETIMERANDOMCURVES)\n    uniform  vec2 u_ROLAngularVelocityGradientX[4];\n    uniform  vec2 u_ROLAngularVelocityGradientY[4];\n    uniform  vec2 u_ROLAngularVelocityGradientZ[4];\n	uniform  vec2 u_ROLAngularVelocityGradientW[4];\n  #endif\n  #ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n    uniform  vec2 u_ROLAngularVelocityGradientMaxX[4];\n    uniform  vec2 u_ROLAngularVelocityGradientMaxY[4];\n    uniform  vec2 u_ROLAngularVelocityGradientMaxZ[4];\n	uniform  vec2 u_ROLAngularVelocityGradientMaxW[4];\n  #endif\n#endif\n\n#if defined(TEXTURESHEETANIMATIONCURVE)||defined(TEXTURESHEETANIMATIONRANDOMCURVE)\n  uniform  float u_TSACycles;\n  uniform  vec2 u_TSASubUVLength;\n  uniform  vec2 u_TSAGradientUVs[4];//x为key,y为frame\n#endif\n#ifdef TEXTURESHEETANIMATIONRANDOMCURVE\n  uniform  vec2 u_TSAMaxGradientUVs[4];//x为key,y为frame\n#endif\n\n#ifdef FOG\n	varying vec3 v_PositionWorld;\n#endif\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\nvec3 rotationByEuler(in vec3 vector,in vec3 rot)\n{\n	float halfRoll = rot.z * 0.5;\n    float halfPitch = rot.x * 0.5;\n	float halfYaw = rot.y * 0.5;\n\n	float sinRoll = sin(halfRoll);\n	float cosRoll = cos(halfRoll);\n	float sinPitch = sin(halfPitch);\n	float cosPitch = cos(halfPitch);\n	float sinYaw = sin(halfYaw);\n	float cosYaw = cos(halfYaw);\n\n	float quaX = (cosYaw * sinPitch * cosRoll) + (sinYaw * cosPitch * sinRoll);\n	float quaY = (sinYaw * cosPitch * cosRoll) - (cosYaw * sinPitch * sinRoll);\n	float quaZ = (cosYaw * cosPitch * sinRoll) - (sinYaw * sinPitch * cosRoll);\n	float quaW = (cosYaw * cosPitch * cosRoll) + (sinYaw * sinPitch * sinRoll);\n	\n	//vec4 q=vec4(quaX,quaY,quaZ,quaW);\n	//vec3 temp = cross(q.xyz, vector) + q.w * vector;\n	//return (cross(temp, -q.xyz) + dot(q.xyz,vector) * q.xyz + q.w * temp);\n	\n	float x = quaX + quaX;\n    float y = quaY + quaY;\n    float z = quaZ + quaZ;\n    float wx = quaW * x;\n    float wy = quaW * y;\n    float wz = quaW * z;\n	float xx = quaX * x;\n    float xy = quaX * y;\n	float xz = quaX * z;\n    float yy = quaY * y;\n    float yz = quaY * z;\n    float zz = quaZ * z;\n\n    return vec3(((vector.x * ((1.0 - yy) - zz)) + (vector.y * (xy - wz))) + (vector.z * (xz + wy)),\n                ((vector.x * (xy + wz)) + (vector.y * ((1.0 - xx) - zz))) + (vector.z * (yz - wx)),\n                ((vector.x * (xz - wy)) + (vector.y * (yz + wx))) + (vector.z * ((1.0 - xx) - yy)));\n	\n}\n\n//假定axis已经归一化\nvec3 rotationByAxis(in vec3 vector,in vec3 axis, in float angle)\n{\n	float halfAngle = angle * 0.5;\n	float sin = sin(halfAngle);\n	\n	float quaX = axis.x * sin;\n	float quaY = axis.y * sin;\n	float quaZ = axis.z * sin;\n	float quaW = cos(halfAngle);\n	\n	//vec4 q=vec4(quaX,quaY,quaZ,quaW);\n	//vec3 temp = cross(q.xyz, vector) + q.w * vector;\n	//return (cross(temp, -q.xyz) + dot(q.xyz,vector) * q.xyz + q.w * temp);\n	\n	float x = quaX + quaX;\n    float y = quaY + quaY;\n    float z = quaZ + quaZ;\n    float wx = quaW * x;\n    float wy = quaW * y;\n    float wz = quaW * z;\n	float xx = quaX * x;\n    float xy = quaX * y;\n	float xz = quaX * z;\n    float yy = quaY * y;\n    float yz = quaY * z;\n    float zz = quaZ * z;\n\n    return vec3(((vector.x * ((1.0 - yy) - zz)) + (vector.y * (xy - wz))) + (vector.z * (xz + wy)),\n                ((vector.x * (xy + wz)) + (vector.y * ((1.0 - xx) - zz))) + (vector.z * (yz - wx)),\n                ((vector.x * (xz - wy)) + (vector.y * (yz + wx))) + (vector.z * ((1.0 - xx) - yy)));\n	\n}\n\nvec3 rotationByQuaternions(in vec3 v,in vec4 q) \n{\n	return v + 2.0 * cross(q.xyz, cross(q.xyz, v) + q.w * v);\n}\n\n \n#if defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)||defined(SIZEOVERLIFETIMECURVE)||defined(SIZEOVERLIFETIMECURVESEPERATE)||defined(SIZEOVERLIFETIMERANDOMCURVES)||defined(SIZEOVERLIFETIMERANDOMCURVESSEPERATE)\nfloat getCurValueFromGradientFloat(in vec2 gradientNumbers[4],in float normalizedAge)\n{\n	float curValue;\n	for(int i=1;i<4;i++)\n	{\n		vec2 gradientNumber=gradientNumbers[i];\n		float key=gradientNumber.x;\n		if(key>=normalizedAge)\n		{\n			vec2 lastGradientNumber=gradientNumbers[i-1];\n			float lastKey=lastGradientNumber.x;\n			float age=(normalizedAge-lastKey)/(key-lastKey);\n			curValue=mix(lastGradientNumber.y,gradientNumber.y,age);\n			break;\n		}\n	}\n	return curValue;\n}\n#endif\n\n#if defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)||defined(ROTATIONOVERLIFETIMECURVE)||defined(ROTATIONOVERLIFETIMERANDOMCURVES)\nfloat getTotalValueFromGradientFloat(in vec2 gradientNumbers[4],in float normalizedAge)\n{\n	float totalValue=0.0;\n	for(int i=1;i<4;i++)\n	{\n		vec2 gradientNumber=gradientNumbers[i];\n		float key=gradientNumber.x;\n		vec2 lastGradientNumber=gradientNumbers[i-1];\n		float lastValue=lastGradientNumber.y;\n		\n		if(key>=normalizedAge){\n			float lastKey=lastGradientNumber.x;\n			float age=(normalizedAge-lastKey)/(key-lastKey);\n			totalValue+=(lastValue+mix(lastValue,gradientNumber.y,age))/2.0*a_ShapePositionStartLifeTime.w*(normalizedAge-lastKey);\n			break;\n		}\n		else{\n			totalValue+=(lastValue+gradientNumber.y)/2.0*a_ShapePositionStartLifeTime.w*(key-lastGradientNumber.x);\n		}\n	}\n	return totalValue;\n}\n#endif\n\n#if defined(COLOROVERLIFETIME)||defined(RANDOMCOLOROVERLIFETIME)\nvec4 getColorFromGradient(in vec2 gradientAlphas[4],in vec4 gradientColors[4],in float normalizedAge)\n{\n	vec4 overTimeColor;\n	for(int i=1;i<4;i++)\n	{\n		vec2 gradientAlpha=gradientAlphas[i];\n		float alphaKey=gradientAlpha.x;\n		if(alphaKey>=normalizedAge)\n		{\n			vec2 lastGradientAlpha=gradientAlphas[i-1];\n			float lastAlphaKey=lastGradientAlpha.x;\n			float age=(normalizedAge-lastAlphaKey)/(alphaKey-lastAlphaKey);\n			overTimeColor.a=mix(lastGradientAlpha.y,gradientAlpha.y,age);\n			break;\n		}\n	}\n	\n	for(int i=1;i<4;i++)\n	{\n		vec4 gradientColor=gradientColors[i];\n		float colorKey=gradientColor.x;\n		if(colorKey>=normalizedAge)\n		{\n			vec4 lastGradientColor=gradientColors[i-1];\n			float lastColorKey=lastGradientColor.x;\n			float age=(normalizedAge-lastColorKey)/(colorKey-lastColorKey);\n			overTimeColor.rgb=mix(gradientColors[i-1].yzw,gradientColor.yzw,age);\n			break;\n		}\n	}\n	return overTimeColor;\n}\n#endif\n\n\n#if defined(TEXTURESHEETANIMATIONCURVE)||defined(TEXTURESHEETANIMATIONRANDOMCURVE)\nfloat getFrameFromGradient(in vec2 gradientFrames[4],in float normalizedAge)\n{\n	float overTimeFrame;\n	for(int i=1;i<4;i++)\n	{\n		vec2 gradientFrame=gradientFrames[i];\n		float key=gradientFrame.x;\n		if(key>=normalizedAge)\n		{\n			vec2 lastGradientFrame=gradientFrames[i-1];\n			float lastKey=lastGradientFrame.x;\n			float age=(normalizedAge-lastKey)/(key-lastKey);\n			overTimeFrame=mix(lastGradientFrame.y,gradientFrame.y,age);\n			break;\n		}\n	}\n	return floor(overTimeFrame);\n}\n#endif\n\n#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\nvec3 computeParticleLifeVelocity(in float normalizedAge)\n{\n  vec3 outLifeVelocity;\n  #ifdef VELOCITYOVERLIFETIMECONSTANT\n	 outLifeVelocity=u_VOLVelocityConst; \n  #endif\n  #ifdef VELOCITYOVERLIFETIMECURVE\n     outLifeVelocity= vec3(getCurValueFromGradientFloat(u_VOLVelocityGradientX,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientY,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientZ,normalizedAge));\n  #endif\n  #ifdef VELOCITYOVERLIFETIMERANDOMCONSTANT\n	 outLifeVelocity=mix(u_VOLVelocityConst,u_VOLVelocityConstMax,vec3(a_Random1.y,a_Random1.z,a_Random1.w)); \n  #endif\n  #ifdef VELOCITYOVERLIFETIMERANDOMCURVE\n     outLifeVelocity=vec3(mix(getCurValueFromGradientFloat(u_VOLVelocityGradientX,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientMaxX,normalizedAge),a_Random1.y),\n	                 mix(getCurValueFromGradientFloat(u_VOLVelocityGradientY,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientMaxY,normalizedAge),a_Random1.z),\n					 mix(getCurValueFromGradientFloat(u_VOLVelocityGradientZ,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientMaxZ,normalizedAge),a_Random1.w));\n  #endif\n					\n  return outLifeVelocity;\n} \n#endif\n\nvec3 computeParticlePosition(in vec3 startVelocity, in vec3 lifeVelocity,in float age,in float normalizedAge,vec3 gravityVelocity,vec4 worldRotation)\n{\n   vec3 startPosition;\n   vec3 lifePosition;\n   #if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n	#ifdef VELOCITYOVERLIFETIMECONSTANT\n		  startPosition=startVelocity*age;\n		  lifePosition=lifeVelocity*age;\n	#endif\n	#ifdef VELOCITYOVERLIFETIMECURVE\n		  startPosition=startVelocity*age;\n		  lifePosition=vec3(getTotalValueFromGradientFloat(u_VOLVelocityGradientX,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientY,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientZ,normalizedAge));\n	#endif\n	#ifdef VELOCITYOVERLIFETIMERANDOMCONSTANT\n		  startPosition=startVelocity*age;\n		  lifePosition=lifeVelocity*age;\n	#endif\n	#ifdef VELOCITYOVERLIFETIMERANDOMCURVE\n		  startPosition=startVelocity*age;\n		  lifePosition=vec3(mix(getTotalValueFromGradientFloat(u_VOLVelocityGradientX,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientMaxX,normalizedAge),a_Random1.y)\n	      ,mix(getTotalValueFromGradientFloat(u_VOLVelocityGradientY,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientMaxY,normalizedAge),a_Random1.z)\n	      ,mix(getTotalValueFromGradientFloat(u_VOLVelocityGradientZ,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientMaxZ,normalizedAge),a_Random1.w));\n	#endif\n	\n	vec3 finalPosition;\n	if(u_VOLSpaceType==0){\n	  if(u_ScalingMode!=2)\n	   finalPosition =rotationByQuaternions(u_PositionScale*(a_ShapePositionStartLifeTime.xyz+startPosition+lifePosition),worldRotation);\n	  else\n	   finalPosition =rotationByQuaternions(u_PositionScale*a_ShapePositionStartLifeTime.xyz+startPosition+lifePosition,worldRotation);\n	}\n	else{\n	  if(u_ScalingMode!=2)\n	    finalPosition = rotationByQuaternions(u_PositionScale*(a_ShapePositionStartLifeTime.xyz+startPosition),worldRotation)+lifePosition;\n	  else\n	    finalPosition = rotationByQuaternions(u_PositionScale*a_ShapePositionStartLifeTime.xyz+startPosition,worldRotation)+lifePosition;\n	}\n  #else\n	 startPosition=startVelocity*age;\n	 vec3 finalPosition;\n	 if(u_ScalingMode!=2)\n	   finalPosition = rotationByQuaternions(u_PositionScale*(a_ShapePositionStartLifeTime.xyz+startPosition),worldRotation);\n	 else\n	   finalPosition = rotationByQuaternions(u_PositionScale*a_ShapePositionStartLifeTime.xyz+startPosition,worldRotation);\n  #endif\n  \n  if(u_SimulationSpace==0)\n    finalPosition=finalPosition+a_SimulationWorldPostion;\n  else if(u_SimulationSpace==1) \n    finalPosition=finalPosition+u_WorldPosition;\n  \n  finalPosition+=0.5*gravityVelocity*age;\n \n  return  finalPosition;\n}\n\n\nvec4 computeParticleColor(in vec4 color,in float normalizedAge)\n{\n	#ifdef COLOROVERLIFETIME\n	  color*=getColorFromGradient(u_ColorOverLifeGradientAlphas,u_ColorOverLifeGradientColors,normalizedAge);\n	#endif\n	\n	#ifdef RANDOMCOLOROVERLIFETIME\n	  color*=mix(getColorFromGradient(u_ColorOverLifeGradientAlphas,u_ColorOverLifeGradientColors,normalizedAge),getColorFromGradient(u_MaxColorOverLifeGradientAlphas,u_MaxColorOverLifeGradientColors,normalizedAge),a_Random0.y);\n	#endif\n\n    return color;\n}\n\nvec2 computeParticleSizeBillbard(in vec2 size,in float normalizedAge)\n{\n	#ifdef SIZEOVERLIFETIMECURVE\n		size*=getCurValueFromGradientFloat(u_SOLSizeGradient,normalizedAge);\n	#endif\n	#ifdef SIZEOVERLIFETIMERANDOMCURVES\n	    size*=mix(getCurValueFromGradientFloat(u_SOLSizeGradient,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMax,normalizedAge),a_Random0.z); \n	#endif\n	#ifdef SIZEOVERLIFETIMECURVESEPERATE\n		size*=vec2(getCurValueFromGradientFloat(u_SOLSizeGradientX,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientY,normalizedAge));\n	#endif\n	#ifdef SIZEOVERLIFETIMERANDOMCURVESSEPERATE\n	    size*=vec2(mix(getCurValueFromGradientFloat(u_SOLSizeGradientX,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxX,normalizedAge),a_Random0.z)\n	    ,mix(getCurValueFromGradientFloat(u_SOLSizeGradientY,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxY,normalizedAge),a_Random0.z));\n	#endif\n	return size;\n}\n\n#ifdef RENDERMODE_MESH\nvec3 computeParticleSizeMesh(in vec3 size,in float normalizedAge)\n{\n	#ifdef SIZEOVERLIFETIMECURVE\n		size*=getCurValueFromGradientFloat(u_SOLSizeGradient,normalizedAge);\n	#endif\n	#ifdef SIZEOVERLIFETIMERANDOMCURVES\n	    size*=mix(getCurValueFromGradientFloat(u_SOLSizeGradient,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMax,normalizedAge),a_Random0.z); \n	#endif\n	#ifdef SIZEOVERLIFETIMECURVESEPERATE\n		size*=vec3(getCurValueFromGradientFloat(u_SOLSizeGradientX,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientY,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientZ,normalizedAge));\n	#endif\n	#ifdef SIZEOVERLIFETIMERANDOMCURVESSEPERATE\n	    size*=vec3(mix(getCurValueFromGradientFloat(u_SOLSizeGradientX,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxX,normalizedAge),a_Random0.z)\n	    ,mix(getCurValueFromGradientFloat(u_SOLSizeGradientY,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxY,normalizedAge),a_Random0.z)\n		,mix(getCurValueFromGradientFloat(u_SOLSizeGradientZ,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxZ,normalizedAge),a_Random0.z));\n	#endif\n	return size;\n}\n#endif\n\nfloat computeParticleRotationFloat(in float rotation,in float age,in float normalizedAge)\n{ \n	#ifdef ROTATIONOVERLIFETIME\n		#ifdef ROTATIONOVERLIFETIMECONSTANT\n			float ageRot=u_ROLAngularVelocityConst*age;\n	        rotation+=ageRot;\n		#endif\n		#ifdef ROTATIONOVERLIFETIMECURVE\n			rotation+=getTotalValueFromGradientFloat(u_ROLAngularVelocityGradient,normalizedAge);\n		#endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n			float ageRot=mix(u_ROLAngularVelocityConst,u_ROLAngularVelocityConstMax,a_Random0.w)*age;\n	        rotation+=ageRot;\n	    #endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n			rotation+=mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradient,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMax,normalizedAge),a_Random0.w);\n		#endif\n	#endif\n	#ifdef ROTATIONOVERLIFETIMESEPERATE\n		#ifdef ROTATIONOVERLIFETIMECONSTANT\n			float ageRot=u_ROLAngularVelocityConstSeprarate.z*age;\n	        rotation+=ageRot;\n		#endif\n		#ifdef ROTATIONOVERLIFETIMECURVE\n			rotation+=getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientZ,normalizedAge);\n		#endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n			float ageRot=mix(u_ROLAngularVelocityConstSeprarate.z,u_ROLAngularVelocityConstMaxSeprarate.z,a_Random0.w)*age;\n	        rotation+=ageRot;\n	    #endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n			rotation+=mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientZ,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMaxZ,normalizedAge),a_Random0.w));\n		#endif\n	#endif\n	return rotation;\n}\n\n\n#if defined(RENDERMODE_MESH)&&(defined(ROTATIONOVERLIFETIME)||defined(ROTATIONOVERLIFETIMESEPERATE))\nvec3 computeParticleRotationVec3(in vec3 rotation,in float age,in float normalizedAge)\n{ \n	#ifdef ROTATIONOVERLIFETIME\n	#ifdef ROTATIONOVERLIFETIMECONSTANT\n			float ageRot=u_ROLAngularVelocityConst*age;\n	        rotation+=ageRot;\n		#endif\n		#ifdef ROTATIONOVERLIFETIMECURVE\n			rotation+=getTotalValueFromGradientFloat(u_ROLAngularVelocityGradient,normalizedAge);\n		#endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n			float ageRot=mix(u_ROLAngularVelocityConst,u_ROLAngularVelocityConstMax,a_Random0.w)*age;\n	        rotation+=ageRot;\n	    #endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n			rotation+=mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradient,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMax,normalizedAge),a_Random0.w);\n		#endif\n	#endif\n	#ifdef ROTATIONOVERLIFETIMESEPERATE\n	#ifdef ROTATIONOVERLIFETIMECONSTANT\n			vec3 ageRot=u_ROLAngularVelocityConstSeprarate*age;\n	        rotation+=ageRot;\n		#endif\n		#ifdef ROTATIONOVERLIFETIMECURVE\n			rotation+=vec3(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientX,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientY,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientZ,normalizedAge));\n		#endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n			vec3 ageRot=mix(u_ROLAngularVelocityConstSeprarate,u_ROLAngularVelocityConstMaxSeprarate,a_Random0.w)*age;\n	        rotation+=ageRot;\n	    #endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n			rotation+=vec3(mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientX,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMaxX,normalizedAge),a_Random0.w)\n	        ,mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientY,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMaxY,normalizedAge),a_Random0.w)\n	        ,mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientZ,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMaxZ,normalizedAge),a_Random0.w));\n		#endif\n	#endif\n	return rotation;\n}\n#endif\n\nvec2 computeParticleUV(in vec2 uv,in float normalizedAge)\n{ \n	#ifdef TEXTURESHEETANIMATIONCURVE\n		float cycleNormalizedAge=normalizedAge*u_TSACycles;\n		float frame=getFrameFromGradient(u_TSAGradientUVs,cycleNormalizedAge-floor(cycleNormalizedAge));\n		float totalULength=frame*u_TSASubUVLength.x;\n		float floorTotalULength=floor(totalULength);\n	    uv.x+=totalULength-floorTotalULength;\n		uv.y+=floorTotalULength*u_TSASubUVLength.y;\n    #endif\n	#ifdef TEXTURESHEETANIMATIONRANDOMCURVE\n		float cycleNormalizedAge=normalizedAge*u_TSACycles;\n		float uvNormalizedAge=cycleNormalizedAge-floor(cycleNormalizedAge);\n	    float frame=floor(mix(getFrameFromGradient(u_TSAGradientUVs,uvNormalizedAge),getFrameFromGradient(u_TSAMaxGradientUVs,uvNormalizedAge),a_Random1.x));\n		float totalULength=frame*u_TSASubUVLength.x;\n		float floorTotalULength=floor(totalULength);\n	    uv.x+=totalULength-floorTotalULength;\n		uv.y+=floorTotalULength*u_TSASubUVLength.y;\n    #endif\n	return uv;\n}\n\nvoid main()\n{\n	float age = u_CurrentTime - a_DirectionTime.w;\n	float normalizedAge = age/a_ShapePositionStartLifeTime.w;\n	vec3 lifeVelocity;\n	if(normalizedAge<1.0){ \n	vec3 startVelocity=a_DirectionTime.xyz*a_StartSpeed;\n	#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n		lifeVelocity= computeParticleLifeVelocity(normalizedAge);//计算粒子生命周期速度\n	#endif \n	vec3 gravityVelocity=u_Gravity*age;\n	\n	vec4 worldRotation;\n	if(u_SimulationSpace==0)\n		worldRotation=a_SimulationWorldRotation;\n	else\n		worldRotation=u_WorldRotation;\n	\n	vec3 center=computeParticlePosition(startVelocity, lifeVelocity, age, normalizedAge,gravityVelocity,worldRotation);//计算粒子位置\n   \n   \n   #ifdef SPHERHBILLBOARD\n		vec2 corner=a_CornerTextureCoordinate.xy;//Billboard模式z轴无效\n        vec3 cameraUpVector =normalize(u_CameraUp);//TODO:是否外面归一化\n        vec3 sideVector = normalize(cross(u_CameraDirection,cameraUpVector));\n        vec3 upVector = normalize(cross(sideVector,u_CameraDirection));\n	    corner*=computeParticleSizeBillbard(a_StartSize.xy,normalizedAge);\n		#if defined(ROTATIONOVERLIFETIME)||defined(ROTATIONOVERLIFETIMESEPERATE)\n			if(u_ThreeDStartRotation){\n				vec3 rotation=vec3(a_StartRotation0.xy,computeParticleRotationFloat(a_StartRotation0.z,age,normalizedAge));\n				center += u_SizeScale.xzy*rotationByEuler(corner.x*sideVector+corner.y*upVector,rotation);\n			}\n			else{\n				float rot = computeParticleRotationFloat(a_StartRotation0.x, age,normalizedAge);\n				float c = cos(rot);\n				float s = sin(rot);\n				mat2 rotation= mat2(c, -s, s, c);\n				corner=rotation*corner;\n				center += u_SizeScale.xzy*(corner.x*sideVector+corner.y*upVector);\n			}\n		#else\n			if(u_ThreeDStartRotation){\n				center += u_SizeScale.xzy*rotationByEuler(corner.x*sideVector+corner.y*upVector,a_StartRotation0);\n			}\n			else{\n				float c = cos(a_StartRotation0.x);\n				float s = sin(a_StartRotation0.x);\n				mat2 rotation= mat2(c, -s, s, c);\n				corner=rotation*corner;\n				center += u_SizeScale.xzy*(corner.x*sideVector+corner.y*upVector);\n			}\n		#endif\n   #endif\n   \n   #ifdef STRETCHEDBILLBOARD\n	vec2 corner=a_CornerTextureCoordinate.xy;//Billboard模式z轴无效\n	vec3 velocity;\n	#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n	    if(u_VOLSpaceType==0)\n		  velocity=rotationByQuaternions(u_SizeScale*(startVelocity+lifeVelocity),worldRotation)+gravityVelocity;\n	    else\n		  velocity=rotationByQuaternions(u_SizeScale*startVelocity,worldRotation)+lifeVelocity+gravityVelocity;\n    #else\n	    velocity= rotationByQuaternions(u_SizeScale*startVelocity,worldRotation)+gravityVelocity;\n    #endif	\n		vec3 cameraUpVector = normalize(velocity);\n		vec3 direction = normalize(center-u_CameraPosition);\n        vec3 sideVector = normalize(cross(direction,normalize(velocity)));\n		\n		sideVector=u_SizeScale.xzy*sideVector;\n		cameraUpVector=length(vec3(u_SizeScale.x,0.0,0.0))*cameraUpVector;\n		\n	    vec2 size=computeParticleSizeBillbard(a_StartSize.xy,normalizedAge);\n		\n	    const mat2 rotaionZHalfPI=mat2(0.0, -1.0, 1.0, 0.0);\n	    corner=rotaionZHalfPI*corner;\n	    corner.y=corner.y-abs(corner.y);\n		\n	    float speed=length(velocity);//TODO:\n	    center +=sign(u_SizeScale.x)*(sign(u_StretchedBillboardLengthScale)*size.x*corner.x*sideVector+(speed*u_StretchedBillboardSpeedScale+size.y*u_StretchedBillboardLengthScale)*corner.y*cameraUpVector);\n   #endif\n   \n   #ifdef HORIZONTALBILLBOARD\n		vec2 corner=a_CornerTextureCoordinate.xy;//Billboard模式z轴无效\n        const vec3 cameraUpVector=vec3(0.0,0.0,1.0);\n	    const vec3 sideVector = vec3(-1.0,0.0,0.0);\n		\n		float rot = computeParticleRotationFloat(a_StartRotation0.x, age,normalizedAge);\n        float c = cos(rot);\n        float s = sin(rot);\n        mat2 rotation= mat2(c, -s, s, c);\n	    corner=rotation*corner*cos(0.78539816339744830961566084581988);//TODO:临时缩小cos45,不确定U3D原因\n		corner*=computeParticleSizeBillbard(a_StartSize.xy,normalizedAge);\n        center +=u_SizeScale.xzy*(corner.x*sideVector+ corner.y*cameraUpVector);\n   #endif\n   \n   #ifdef VERTICALBILLBOARD\n		vec2 corner=a_CornerTextureCoordinate.xy;//Billboard模式z轴无效\n        const vec3 cameraUpVector =vec3(0.0,1.0,0.0);\n        vec3 sideVector = normalize(cross(u_CameraDirection,cameraUpVector));\n		\n		float rot = computeParticleRotationFloat(a_StartRotation0.x, age,normalizedAge);\n        float c = cos(rot);\n        float s = sin(rot);\n        mat2 rotation= mat2(c, -s, s, c);\n	    corner=rotation*corner*cos(0.78539816339744830961566084581988);//TODO:临时缩小cos45,不确定U3D原因\n		corner*=computeParticleSizeBillbard(a_StartSize.xy,normalizedAge);\n        center +=u_SizeScale.xzy*(corner.x*sideVector+ corner.y*cameraUpVector);\n   #endif\n   \n   #ifdef RENDERMODE_MESH\n	    vec3 size=computeParticleSizeMesh(a_StartSize,normalizedAge);\n		#if defined(ROTATIONOVERLIFETIME)||defined(ROTATIONOVERLIFETIMESEPERATE)\n			if(u_ThreeDStartRotation){\n				vec3 rotation=vec3(a_StartRotation0.xy,-computeParticleRotationFloat(a_StartRotation0.z, age,normalizedAge));\n				center+= rotationByQuaternions(u_SizeScale*rotationByEuler(a_MeshPosition*size,rotation),worldRotation);\n			}\n			else{\n				#ifdef ROTATIONOVERLIFETIME\n					float angle=computeParticleRotationFloat(a_StartRotation0.x, age,normalizedAge);\n					if(a_ShapePositionStartLifeTime.x!=0.0||a_ShapePositionStartLifeTime.y!=0.0){\n						center+= (rotationByQuaternions(rotationByAxis(u_SizeScale*a_MeshPosition*size,normalize(cross(vec3(0.0,0.0,1.0),vec3(a_ShapePositionStartLifeTime.xy,0.0))),angle),worldRotation));//已验证\n					}\n					else{\n						#ifdef SHAPE\n							center+= u_SizeScale.xzy*(rotationByQuaternions(rotationByAxis(a_MeshPosition*size,vec3(0.0,-1.0,0.0),angle),worldRotation));\n						#else\n							if(u_SimulationSpace==0)\n								center+=rotationByAxis(u_SizeScale*a_MeshPosition*size,vec3(0.0,0.0,-1.0),angle);//已验证\n							else if(u_SimulationSpace==1)\n								center+=rotationByQuaternions(u_SizeScale*rotationByAxis(a_MeshPosition*size,vec3(0.0,0.0,-1.0),angle),worldRotation);//已验证\n						#endif\n					}\n				#endif\n				#ifdef ROTATIONOVERLIFETIMESEPERATE\n					//TODO:是否应合并if(u_ThreeDStartRotation)分支代码,待测试\n					vec3 angle=computeParticleRotationVec3(vec3(0.0,0.0,a_StartRotation0.z), age,normalizedAge);\n					center+= (rotationByQuaternions(rotationByEuler(u_SizeScale*a_MeshPosition*size,vec3(angle.x,angle.y,angle.z)),worldRotation));//已验证\n				#endif	\n			}\n		#else\n			if(u_ThreeDStartRotation){\n				center+= rotationByQuaternions(u_SizeScale*rotationByEuler(a_MeshPosition*size,a_StartRotation0),worldRotation);//已验证\n			}\n			else{\n				if(a_ShapePositionStartLifeTime.x!=0.0||a_ShapePositionStartLifeTime.y!=0.0){\n					if(u_SimulationSpace==0)\n						center+= rotationByAxis(u_SizeScale*a_MeshPosition*size,normalize(cross(vec3(0.0,0.0,1.0),vec3(a_ShapePositionStartLifeTime.xy,0.0))),a_StartRotation0.x);\n					else if(u_SimulationSpace==1)\n						center+= (rotationByQuaternions(u_SizeScale*rotationByAxis(a_MeshPosition*size,normalize(cross(vec3(0.0,0.0,1.0),vec3(a_ShapePositionStartLifeTime.xy,0.0))),a_StartRotation0.x),worldRotation));//已验证\n				}\n				else{\n					#ifdef SHAPE\n						if(u_SimulationSpace==0)\n							center+= u_SizeScale*rotationByAxis(a_MeshPosition*size,vec3(0.0,-1.0,0.0),a_StartRotation0.x);\n						else if(u_SimulationSpace==1)\n							center+= rotationByQuaternions(u_SizeScale*rotationByAxis(a_MeshPosition*size,vec3(0.0,-1.0,0.0),a_StartRotation0.x),worldRotation);	\n					#else\n						if(u_SimulationSpace==0)\n							center+= rotationByAxis(u_SizeScale*a_MeshPosition*size,vec3(0.0,0.0,-1.0),a_StartRotation0.x);\n						else if(u_SimulationSpace==1)\n							center+= rotationByQuaternions(u_SizeScale*rotationByAxis(a_MeshPosition*size,vec3(0.0,0.0,-1.0),a_StartRotation0.x),worldRotation);//已验证\n					#endif\n				}\n			}\n		#endif\n		v_MeshColor=a_MeshColor;\n   #endif\n   \n    gl_Position=u_Projection*u_View*vec4(center,1.0);\n    v_Color = computeParticleColor(a_StartColor, normalizedAge);\n	#ifdef DIFFUSEMAP\n		#if defined(SPHERHBILLBOARD)||defined(STRETCHEDBILLBOARD)||defined(HORIZONTALBILLBOARD)||defined(VERTICALBILLBOARD)\n			v_TextureCoordinate =computeParticleUV(a_CornerTextureCoordinate.zw, normalizedAge);\n		#endif\n		#ifdef RENDERMODE_MESH\n			v_TextureCoordinate =computeParticleUV(a_MeshTextureCoordinate, normalizedAge);\n		#endif\n		\n		#ifdef TILINGOFFSET\n			v_TextureCoordinate=vec2(v_TextureCoordinate.x,1.0-v_TextureCoordinate.y)*u_TilingOffset.xy+vec2(u_TilingOffset.z,-u_TilingOffset.w);//需要特殊处理\n			v_TextureCoordinate=vec2(v_TextureCoordinate.x,1.0-v_TextureCoordinate.y);//需要特殊处理\n		#endif\n	#endif\n    v_Discard=0.0;\n	  \n	#ifdef FOG\n		v_PositionWorld=center;\n	#endif\n   }\n   else\n	{\n		v_Discard=1.0;\n	}\n}\n\n";
		ps="#ifdef HIGHPRECISION\n  precision highp float;\n#else\n  precision mediump float;\n#endif\n\nvarying float v_Discard;\nvarying vec4 v_Color;\nvarying vec2 v_TextureCoordinate;\nuniform sampler2D u_texture;\nuniform vec4 u_Tintcolor;\n\n#ifdef RENDERMODE_MESH\n	varying vec4 v_MeshColor;\n#endif\n\n#ifdef FOG\n	varying vec3 v_PositionWorld;\n	uniform vec3 u_CameraPosition;\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	#ifdef ADDTIVEFOG\n	#else\n		uniform vec3 u_FogColor;\n	#endif\n#endif\n\n\nvoid main()\n{	\n	#ifdef RENDERMODE_MESH\n		gl_FragColor=v_MeshColor;\n	#else\n		gl_FragColor=vec4(1.0);	\n	#endif\n		\n	#ifdef DIFFUSEMAP\n		if(v_Discard!=0.0)\n			discard;\n		#ifdef TINTCOLOR\n			gl_FragColor*=texture2D(u_texture,v_TextureCoordinate)*u_Tintcolor*2.0*v_Color;\n		#else\n			gl_FragColor*=texture2D(u_texture,v_TextureCoordinate)*v_Color;\n		#endif\n	#else\n		#ifdef TINTCOLOR\n			gl_FragColor*=u_Tintcolor*2.0*v_Color;\n		#else\n			gl_FragColor*=v_Color;\n		#endif\n	#endif\n	\n	#ifdef FOG\n		vec3 toEye=u_CameraPosition-v_PositionWorld;\n		float toEyeLength=length(toEye);\n		toEye/=toEyeLength;\n		\n		float lerpFact=clamp((toEyeLength-u_FogStart)/u_FogRange,0.0,1.0);\n		#ifdef ADDTIVEFOG\n			gl_FragColor.rgb=mix(gl_FragColor.rgb,vec3(0.0,0.0,0.0),lerpFact);\n		#else\n			gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n		#endif\n	#endif\n}";
		shaderCompile=ShaderCompile3D.add(PARTICLESHURIKEN,vs,ps,attributeMap,uniformMap);
		ShurikenParticleMaterial.SHADERDEFINE_DIFFUSEMAP=shaderCompile.registerMaterialDefine("DIFFUSEMAP");
		ShurikenParticleMaterial.SHADERDEFINE_TINTCOLOR=shaderCompile.registerMaterialDefine("TINTCOLOR");
		ShurikenParticleMaterial.SHADERDEFINE_ADDTIVEFOG=shaderCompile.registerMaterialDefine("ADDTIVEFOG");
		ShurikenParticleMaterial.SHADERDEFINE_TILINGOFFSET=shaderCompile.registerMaterialDefine("TILINGOFFSET");
		ShuriKenParticle3D.SHADERDEFINE_RENDERMODE_BILLBOARD=shaderCompile.registerSpriteDefine("SPHERHBILLBOARD");
		ShuriKenParticle3D.SHADERDEFINE_RENDERMODE_STRETCHEDBILLBOARD=shaderCompile.registerSpriteDefine("STRETCHEDBILLBOARD");
		ShuriKenParticle3D.SHADERDEFINE_RENDERMODE_HORIZONTALBILLBOARD=shaderCompile.registerSpriteDefine("HORIZONTALBILLBOARD");
		ShuriKenParticle3D.SHADERDEFINE_RENDERMODE_VERTICALBILLBOARD=shaderCompile.registerSpriteDefine("VERTICALBILLBOARD");
		ShuriKenParticle3D.SHADERDEFINE_COLOROVERLIFETIME=shaderCompile.registerSpriteDefine("COLOROVERLIFETIME");
		ShuriKenParticle3D.SHADERDEFINE_RANDOMCOLOROVERLIFETIME=shaderCompile.registerSpriteDefine("RANDOMCOLOROVERLIFETIME");
		ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMECONSTANT=shaderCompile.registerSpriteDefine("VELOCITYOVERLIFETIMECONSTANT");
		ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMECURVE=shaderCompile.registerSpriteDefine("VELOCITYOVERLIFETIMECURVE");
		ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMERANDOMCONSTANT=shaderCompile.registerSpriteDefine("VELOCITYOVERLIFETIMERANDOMCONSTANT");
		ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMERANDOMCURVE=shaderCompile.registerSpriteDefine("VELOCITYOVERLIFETIMERANDOMCURVE");
		ShuriKenParticle3D.SHADERDEFINE_TEXTURESHEETANIMATIONCURVE=shaderCompile.registerSpriteDefine("TEXTURESHEETANIMATIONCURVE");
		ShuriKenParticle3D.SHADERDEFINE_TEXTURESHEETANIMATIONRANDOMCURVE=shaderCompile.registerSpriteDefine("TEXTURESHEETANIMATIONRANDOMCURVE");
		ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIME=shaderCompile.registerSpriteDefine("ROTATIONOVERLIFETIME");
		ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMESEPERATE=shaderCompile.registerSpriteDefine("ROTATIONOVERLIFETIMESEPERATE");
		ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMECONSTANT=shaderCompile.registerSpriteDefine("ROTATIONOVERLIFETIMECONSTANT");
		ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMECURVE=shaderCompile.registerSpriteDefine("ROTATIONOVERLIFETIMECURVE");
		ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMERANDOMCONSTANTS=shaderCompile.registerSpriteDefine("ROTATIONOVERLIFETIMERANDOMCONSTANTS");
		ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMERANDOMCURVES=shaderCompile.registerSpriteDefine("ROTATIONOVERLIFETIMERANDOMCURVES");
		ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMECURVE=shaderCompile.registerSpriteDefine("SIZEOVERLIFETIMECURVE");
		ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMECURVESEPERATE=shaderCompile.registerSpriteDefine("SIZEOVERLIFETIMECURVESEPERATE");
		ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMERANDOMCURVES=shaderCompile.registerSpriteDefine("SIZEOVERLIFETIMERANDOMCURVES");
		ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMERANDOMCURVESSEPERATE=shaderCompile.registerSpriteDefine("SIZEOVERLIFETIMERANDOMCURVESSEPERATE");
		ShuriKenParticle3D.SHADERDEFINE_RENDERMODE_MESH=shaderCompile.registerSpriteDefine("RENDERMODE_MESH");
		ShuriKenParticle3D.SHADERDEFINE_SHAPE=shaderCompile.registerSpriteDefine("SHAPE");
		attributeMap={
			'a_Position':/*laya.d3.graphics.VertexElementUsage.POSITION0*/0,
			'a_Texcoord0':/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2,
			'a_Time':/*laya.d3.graphics.VertexElementUsage.TIME0*/33};
		uniformMap={
			'u_Texture':[ /*laya.d3.core.material.GlitterMaterial.DIFFUSETEXTURE*/1,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_Albedo':[ /*laya.d3.core.material.GlitterMaterial.ALBEDO*/2,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_Color':[ /*laya.d3.core.material.GlitterMaterial.UNICOLOR*/3,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_CurrentTime':[ /*laya.d3.core.glitter.Glitter.CURRENTTIME*/2,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_Duration':[ /*laya.d3.core.glitter.Glitter.DURATION*/3,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_MvpMatrix':[ /*laya.d3.core.Sprite3D.MVPMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2]};
		var GLITTER=Shader3D.nameKey.add("GLITTER");
		vs="attribute vec4 a_Position;\nattribute vec2 a_Texcoord0;\nattribute float a_Time;\n\nuniform mat4 u_MvpMatrix;\nuniform  float u_CurrentTime;\nuniform  vec4 u_Color;\nuniform float u_Duration;\n\nvarying vec2 v_Texcoord;\nvarying vec4 v_Color;\n\n\nvoid main()\n{\n  gl_Position = u_MvpMatrix * a_Position;\n  \n  float age = u_CurrentTime-a_Time;\n  float normalizedAge = clamp(age / u_Duration,0.0,1.0);\n   \n  v_Texcoord=a_Texcoord0;\n  \n  v_Color=u_Color;\n  v_Color.a*=1.0-normalizedAge;\n}\n";
		ps="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\nuniform vec4 u_Albedo;\nuniform sampler2D u_Texture;\n\nvarying vec2 v_Texcoord;\nvarying vec4 v_Color;\n\n\nvoid main()\n{	\n  gl_FragColor=texture2D(u_Texture, v_Texcoord)*v_Color;\n  gl_FragColor=gl_FragColor*u_Albedo;\n}\n\n";
		shaderCompile=ShaderCompile3D.add(GLITTER,vs,ps,attributeMap,uniformMap);
		attributeMap={
			'a_Position':/*laya.d3.graphics.VertexElementUsage.POSITION0*/0};
		uniformMap={
			'u_Intensity':[ /*laya.d3.resource.models.Sky.INTENSITY*/1,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_AlphaBlending':[ /*laya.d3.resource.models.Sky.ALPHABLENDING*/2,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_CubeTexture':[ /*laya.d3.resource.models.Sky.DIFFUSETEXTURE*/3,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MvpMatrix':[ /*laya.d3.core.BaseCamera.VPMATRIX_NO_TRANSLATE*/4,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3]};
		var skyBox=Shader3D.nameKey.add("SkyBox");
		vs="attribute vec4 a_Position;\nuniform mat4 u_MvpMatrix;\nvarying vec3 v_Texcoord;\n\n\nvoid main()\n{\n  gl_Position = (u_MvpMatrix*a_Position).xyww;\n  v_Texcoord=a_Position.xyz;\n}\n";
		ps="#ifdef HIGHPRECISION\nprecision highp float;\n#else\nprecision mediump float;\n#endif\n\nuniform float u_Intensity;\nuniform float u_AlphaBlending;\nuniform samplerCube u_CubeTexture;\n\nvarying vec3 v_Texcoord;\n\n\nvoid main()\n{	\n  gl_FragColor=vec4(textureCube(u_CubeTexture, v_Texcoord).rgb*u_Intensity,u_AlphaBlending);\n}\n\n";
		ShaderCompile3D.add(skyBox,vs,ps,attributeMap,uniformMap);
		attributeMap={
			'a_Position':/*laya.d3.graphics.VertexElementUsage.POSITION0*/0,
			'a_Texcoord0':/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2};
		uniformMap={
			'u_Intensity':[ /*laya.d3.resource.models.Sky.INTENSITY*/1,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_AlphaBlending':[ /*laya.d3.resource.models.Sky.ALPHABLENDING*/2,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_texture':[ /*laya.d3.resource.models.Sky.DIFFUSETEXTURE*/3,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MvpMatrix':[ /*laya.d3.core.BaseCamera.VPMATRIX_NO_TRANSLATE*/4,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3]};
		var skyDome=Shader3D.nameKey.add("SkyDome");
		vs="attribute vec4 a_Position;\nattribute vec2 a_Texcoord0;\nuniform mat4 u_MvpMatrix;\nvarying vec2 v_Texcoord;\n\n\nvoid main()\n{\n  gl_Position = (u_MvpMatrix*a_Position).xyww;\n  v_Texcoord = a_Texcoord0;\n}\n";
		ps="#ifdef HIGHPRECISION\nprecision highp float;\n#else\nprecision mediump float;\n#endif\n\nuniform float u_Intensity;\nuniform float u_AlphaBlending;\nuniform sampler2D u_texture;\n\nvarying vec2 v_Texcoord;\n\n\nvoid main()\n{	\n  gl_FragColor=vec4(texture2D(u_texture, v_Texcoord).rgb*u_Intensity,u_AlphaBlending);\n}\n\n";
		ShaderCompile3D.add(skyDome,vs,ps,attributeMap,uniformMap);
		attributeMap={
			'a_Position':/*laya.d3.graphics.VertexElementUsage.POSITION0*/0,
			'a_Normal':/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3,
			'a_Texcoord0':/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2,
			'a_Texcoord1':/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE1*/15};
		uniformMap={
			'u_MvpMatrix':[ /*laya.d3.core.Sprite3D.MVPMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_WorldMat':[ /*laya.d3.core.Sprite3D.WORLDMATRIX*/0,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_LightmapScaleOffset':[ /*laya.d3.core.RenderableSprite3D.LIGHTMAPSCALEOFFSET*/2,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_LightMap':[ /*laya.d3.core.RenderableSprite3D.LIGHTMAP*/3,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_SplatAlphaTexture':[ /*laya.d3.core.material.TerrainMaterial.SPLATALPHATEXTURE*/0,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_NormalTexture':[ /*laya.d3.core.material.TerrainMaterial.NORMALTEXTURE*/1,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseTexture1':[ /*laya.d3.core.material.TerrainMaterial.DIFFUSETEXTURE1*/2,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseTexture2':[ /*laya.d3.core.material.TerrainMaterial.DIFFUSETEXTURE2*/3,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseTexture3':[ /*laya.d3.core.material.TerrainMaterial.DIFFUSETEXTURE3*/4,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseTexture4':[ /*laya.d3.core.material.TerrainMaterial.DIFFUSETEXTURE4*/5,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseScale1':[ /*laya.d3.core.material.TerrainMaterial.DIFFUSESCALE1*/6,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseScale2':[ /*laya.d3.core.material.TerrainMaterial.DIFFUSESCALE2*/7,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseScale3':[ /*laya.d3.core.material.TerrainMaterial.DIFFUSESCALE3*/8,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseScale4':[ /*laya.d3.core.material.TerrainMaterial.DIFFUSESCALE4*/9,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MaterialDiffuse':[ /*laya.d3.core.material.TerrainMaterial.MATERIALDIFFUSE*/11,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MaterialAmbient':[ /*laya.d3.core.material.TerrainMaterial.MATERIALAMBIENT*/10,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MaterialSpecular':[ /*laya.d3.core.material.TerrainMaterial.MATERIALSPECULAR*/12,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_CameraPos':[ /*laya.d3.core.BaseCamera.CAMERAPOS*/0,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_FogStart':[ /*laya.d3.core.scene.Scene.FOGSTART*/1,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_FogRange':[ /*laya.d3.core.scene.Scene.FOGRANGE*/2,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_FogColor':[ /*laya.d3.core.scene.Scene.FOGCOLOR*/0,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_DirectionLight.Direction':[ /*laya.d3.core.scene.Scene.LIGHTDIRECTION*/3,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_DirectionLight.Diffuse':[ /*laya.d3.core.scene.Scene.LIGHTDIRCOLOR*/4,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Position':[ /*laya.d3.core.scene.Scene.POINTLIGHTPOS*/5,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Range':[ /*laya.d3.core.scene.Scene.POINTLIGHTRANGE*/6,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Attenuation':[ /*laya.d3.core.scene.Scene.POINTLIGHTATTENUATION*/7,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Diffuse':[ /*laya.d3.core.scene.Scene.POINTLIGHTCOLOR*/8,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Position':[ /*laya.d3.core.scene.Scene.SPOTLIGHTPOS*/9,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Direction':[ /*laya.d3.core.scene.Scene.SPOTLIGHTDIRECTION*/10,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Range':[ /*laya.d3.core.scene.Scene.SPOTLIGHTRANGE*/12,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Spot':[ /*laya.d3.core.scene.Scene.SPOTLIGHTSPOT*/11,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Attenuation':[ /*laya.d3.core.scene.Scene.SPOTLIGHTATTENUATION*/13,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Diffuse':[ /*laya.d3.core.scene.Scene.SPOTLIGHTCOLOR*/14,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_AmbientColor':[ /*laya.d3.core.scene.Scene.AMBIENTCOLOR*/21,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap1':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE1*/18,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap2':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE2*/19,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap3':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE3*/20,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowPSSMDistance':[ /*laya.d3.core.scene.Scene.SHADOWDISTANCE*/15,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_lightShadowVP':[ /*laya.d3.core.scene.Scene.SHADOWLIGHTVIEWPROJECT*/16,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowPCFoffset':[ /*laya.d3.core.scene.Scene.SHADOWMAPPCFOFFSET*/17,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4]};
		var terrain=Shader3D.nameKey.add("Terrain");
		vs="attribute vec4 a_Position;\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(LIGHTMAP)\n	attribute vec3 a_Normal;\n	varying vec3 v_Normal;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||(defined(RECEIVESHADOW)&&defined(SHADOWMAP_PSSM1))\n	uniform mat4 u_WorldMat;\n	varying vec3 v_PositionWorld;\n#endif\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n  #ifdef SHADOWMAP_PSSM1 \n  varying vec4 v_lightMVPPos;\n  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\n#ifdef LIGHTMAP\n	uniform vec4 u_LightmapScaleOffset;\n	varying vec2 v_LightMapUV;\n#endif\n\nattribute vec2 a_Texcoord0;\nattribute vec2 a_Texcoord1;\nvarying vec2 v_Texcoord0;\nvarying vec2 v_Texcoord1;\nuniform mat4 u_MvpMatrix;\n\nvoid main()\n{\n	gl_Position = u_MvpMatrix * a_Position;\n	v_Texcoord0=a_Texcoord0;\n	v_Texcoord1=a_Texcoord1;\n	\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	v_Normal=a_Normal;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||(defined(RECEIVESHADOW)&&defined(SHADOWMAP_PSSM1))\n	v_PositionWorld=(u_WorldMat*a_Position).xyz;\n#endif\n\n#ifdef LIGHTMAP\n	//这个地方使用a_Normal 并不是真的代表normal，其实凑巧法线图的uv正好是符合 light_Map的UV\n	v_LightMapUV=vec2(a_Normal.x*u_LightmapScaleOffset.x+u_LightmapScaleOffset.z,(a_Normal.y-1.0)*u_LightmapScaleOffset.y+u_LightmapScaleOffset.w);\n#endif\n\n#ifdef RECEIVESHADOW\n	v_posViewZ = gl_Position.w;\n	#ifdef SHADOWMAP_PSSM1\n		v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n	#endif\n#endif\n\n}";
		ps="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"LightHelper.glsl\";\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	uniform vec3 u_MaterialDiffuse;\n	uniform vec4 u_MaterialSpecular;\n	uniform vec3 u_CameraPos;\n	varying vec3 v_Normal;\n	varying vec3 v_PositionWorld;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(LIGHTMAP)\n	uniform vec3 u_MaterialAmbient;\n#endif\n\n#ifdef FOG\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	uniform vec3 u_FogColor;\n#endif\n\n\n#ifdef DIRECTIONLIGHT\n	uniform DirectionLight u_DirectionLight;\n#endif\n\n#ifdef POINTLIGHT\n	uniform PointLight u_PointLight;\n#endif\n\n#ifdef SPOTLIGHT\n	uniform SpotLight u_SpotLight;\n#endif\n\nuniform vec3 u_AmbientColor;\n\n#include \"ShadowHelper.glsl\"\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n	uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n	varying vec4 v_lightMVPPos;\n	#endif\n#endif\nvarying float v_posViewZ;\n\n\nuniform sampler2D u_SplatAlphaTexture;\nuniform sampler2D u_NormalTexture;\nuniform sampler2D u_DiffuseTexture1;\nuniform sampler2D u_DiffuseTexture2;\nuniform sampler2D u_DiffuseTexture3;\nuniform sampler2D u_DiffuseTexture4;\nuniform vec2 u_DiffuseScale1;\nuniform vec2 u_DiffuseScale2;\nuniform vec2 u_DiffuseScale3;\nuniform vec2 u_DiffuseScale4;\nvarying vec2 v_Texcoord0;\nvarying vec2 v_Texcoord1;\n\n#ifdef LIGHTMAP\n	uniform sampler2D u_LightMap;\n	varying vec2 v_LightMapUV;\n#endif\n\nvoid main()\n{\n#ifdef DETAIL_NUM1\n	vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord1/u_DiffuseScale1);\n	vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n	gl_FragColor.xyz = color1.xyz;\n#endif\n#ifdef DETAIL_NUM2\n	vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord1/u_DiffuseScale1);\n	vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord1/u_DiffuseScale2);\n	vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n	gl_FragColor.xyz = color1.xyz * (1.0-splatAlpha.r) + color2.xyz * splatAlpha.r;\n#endif\n#ifdef DETAIL_NUM3\n	vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord1/u_DiffuseScale1);\n	vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord1/u_DiffuseScale2);\n	vec4 color3 = texture2D(u_DiffuseTexture3, v_Texcoord1/u_DiffuseScale3);\n	vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n	gl_FragColor.xyz = color1.xyz * (1.0-(splatAlpha.r+splatAlpha.g)) + color2.xyz * splatAlpha.r + color3.xyz * splatAlpha.g;\n#endif\n#ifdef DETAIL_NUM4\n	vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord1/u_DiffuseScale1);\n	vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord1/u_DiffuseScale2);\n	vec4 color3 = texture2D(u_DiffuseTexture3, v_Texcoord1/u_DiffuseScale3);\n	vec4 color4 = texture2D(u_DiffuseTexture4, v_Texcoord1/u_DiffuseScale4);\n	vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n	gl_FragColor.xyz = color1.xyz * (1.0-(splatAlpha.r+splatAlpha.g+splatAlpha.b))+ color2.xyz * splatAlpha.r + color3.xyz * splatAlpha.g + color4.xyz * splatAlpha.b;\n#endif\n	gl_FragColor.w = splatAlpha.a;\n		\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n    vec3 normal = texture2D(u_NormalTexture,v_Normal.xy).xyz;\n	normal = normal*2.0 - vec3(1.0);\n	vec3 diffuse = vec3(0.0);\n	vec3 ambient = vec3(0.0);\n	vec3 specular= vec3(0.0);\n	vec3 dif, amb, spe;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)\n	vec3 toEye;\n	#ifdef FOG\n		toEye=u_CameraPos-v_PositionWorld;\n		float toEyeLength=length(toEye);\n		toEye/=toEyeLength;\n	#else\n		toEye=normalize(u_CameraPos-v_PositionWorld);\n	#endif\n#endif\n\n#ifdef DIRECTIONLIGHT\n	computeDirectionLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_DirectionLight,u_AmbientColor,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n \n#ifdef POINTLIGHT\n	computePointLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_PointLight,u_AmbientColor,v_PositionWorld,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n\n#ifdef SPOTLIGHT\n	ComputeSpotLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_SpotLight,u_AmbientColor,v_PositionWorld,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n\n#ifdef RECEIVESHADOW\n	float shadowValue = 1.0;\n	#ifdef SHADOWMAP_PSSM3\n		shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n	#endif\n	#ifdef SHADOWMAP_PSSM2\n		shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n	#endif \n	#ifdef SHADOWMAP_PSSM1\n		shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n	#endif\n#endif\n\n#ifdef LIGHTMAP\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient + texture2D(u_LightMap, v_LightMapUV).rgb);\n	#else\n		#if defined(RECEIVESHADOW)\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient + texture2D(u_LightMap, v_LightMapUV).rgb * shadowValue);\n		#else\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient + texture2D(u_LightMap, v_LightMapUV).rgb);\n		#endif\n	#endif\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	#ifdef RECEIVESHADOW\n		gl_FragColor =vec4( gl_FragColor.rgb*(ambient + diffuse*shadowValue) + specular * shadowValue,gl_FragColor.a);\n	#else\n		gl_FragColor =vec4( gl_FragColor.rgb*(ambient + diffuse) + specular, gl_FragColor.a);\n	#endif\n#endif\n\n#ifdef FOG\n	float lerpFact=clamp((toEyeLength-u_FogStart)/u_FogRange,0.0,1.0);\n	gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n#endif\n}\n\n";
		var terrainCompile3D=ShaderCompile3D.add(terrain,vs,ps,attributeMap,uniformMap);
		TerrainMaterial.SHADERDEFINE_DETAIL_NUM1=terrainCompile3D.registerMaterialDefine("DETAIL_NUM1");
		TerrainMaterial.SHADERDEFINE_DETAIL_NUM2=terrainCompile3D.registerMaterialDefine("DETAIL_NUM2");
		TerrainMaterial.SHADERDEFINE_DETAIL_NUM4=terrainCompile3D.registerMaterialDefine("DETAIL_NUM4");
		TerrainMaterial.SHADERDEFINE_DETAIL_NUM3=terrainCompile3D.registerMaterialDefine("DETAIL_NUM3");
		attributeMap={
			'a_Position':/*laya.d3.graphics.VertexElementUsage.POSITION0*/0,
			'a_Normal':/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3,
			'a_Texcoord0':/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2
		};
		uniformMap={
			'u_MvpMatrix':[ /*laya.d3.core.Sprite3D.MVPMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_WorldMat':[ /*laya.d3.core.Sprite3D.WORLDMATRIX*/0,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_CameraPos':[ /*laya.d3.core.BaseCamera.CAMERAPOS*/0,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_LightmapScaleOffset':[ /*laya.d3.core.RenderableSprite3D.LIGHTMAPSCALEOFFSET*/2,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_LightMap':[ /*laya.d3.core.RenderableSprite3D.LIGHTMAP*/3,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_SplatAlphaTexture':[ /*laya.d3.core.material.ExtendTerrainMaterial.SPLATALPHATEXTURE*/0,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseTexture1':[ /*laya.d3.core.material.ExtendTerrainMaterial.DIFFUSETEXTURE1*/1,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseTexture2':[ /*laya.d3.core.material.ExtendTerrainMaterial.DIFFUSETEXTURE2*/2,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseTexture3':[ /*laya.d3.core.material.ExtendTerrainMaterial.DIFFUSETEXTURE3*/3,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseTexture4':[ /*laya.d3.core.material.ExtendTerrainMaterial.DIFFUSETEXTURE4*/4,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseTexture5':[ /*laya.d3.core.material.ExtendTerrainMaterial.DIFFUSETEXTURE5*/5,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseScaleOffset1':[ /*laya.d3.core.material.ExtendTerrainMaterial.DIFFUSESCALEOFFSET1*/6,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseScaleOffset2':[ /*laya.d3.core.material.ExtendTerrainMaterial.DIFFUSESCALEOFFSET2*/7,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseScaleOffset3':[ /*laya.d3.core.material.ExtendTerrainMaterial.DIFFUSESCALEOFFSET3*/8,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseScaleOffset4':[ /*laya.d3.core.material.ExtendTerrainMaterial.DIFFUSESCALEOFFSET4*/9,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_DiffuseScaleOffset5':[ /*laya.d3.core.material.ExtendTerrainMaterial.DIFFUSESCALEOFFSET5*/10,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MaterialAlbedo':[ /*laya.d3.core.material.ExtendTerrainMaterial.MATERIALALBEDO*/14,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MaterialDiffuse':[ /*laya.d3.core.material.ExtendTerrainMaterial.MATERIALDIFFUSE*/12,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MaterialAmbient':[ /*laya.d3.core.material.ExtendTerrainMaterial.MATERIALAMBIENT*/11,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MaterialSpecular':[ /*laya.d3.core.material.ExtendTerrainMaterial.MATERIALSPECULAR*/13,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_FogStart':[ /*laya.d3.core.scene.Scene.FOGSTART*/1,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_FogRange':[ /*laya.d3.core.scene.Scene.FOGRANGE*/2,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_FogColor':[ /*laya.d3.core.scene.Scene.FOGCOLOR*/0,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_DirectionLight.Direction':[ /*laya.d3.core.scene.Scene.LIGHTDIRECTION*/3,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_DirectionLight.Diffuse':[ /*laya.d3.core.scene.Scene.LIGHTDIRCOLOR*/4,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Position':[ /*laya.d3.core.scene.Scene.POINTLIGHTPOS*/5,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Range':[ /*laya.d3.core.scene.Scene.POINTLIGHTRANGE*/6,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Attenuation':[ /*laya.d3.core.scene.Scene.POINTLIGHTATTENUATION*/7,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_PointLight.Diffuse':[ /*laya.d3.core.scene.Scene.POINTLIGHTCOLOR*/8,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Position':[ /*laya.d3.core.scene.Scene.SPOTLIGHTPOS*/9,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Direction':[ /*laya.d3.core.scene.Scene.SPOTLIGHTDIRECTION*/10,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Range':[ /*laya.d3.core.scene.Scene.SPOTLIGHTRANGE*/12,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Spot':[ /*laya.d3.core.scene.Scene.SPOTLIGHTSPOT*/11,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Attenuation':[ /*laya.d3.core.scene.Scene.SPOTLIGHTATTENUATION*/13,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_SpotLight.Diffuse':[ /*laya.d3.core.scene.Scene.SPOTLIGHTCOLOR*/14,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_AmbientColor':[ /*laya.d3.core.scene.Scene.AMBIENTCOLOR*/21,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap1':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE1*/18,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap2':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE2*/19,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowMap3':[ /*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE3*/20,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowPSSMDistance':[ /*laya.d3.core.scene.Scene.SHADOWDISTANCE*/15,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_lightShadowVP':[ /*laya.d3.core.scene.Scene.SHADOWLIGHTVIEWPROJECT*/16,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4],
			'u_shadowPCFoffset':[ /*laya.d3.core.scene.Scene.SHADOWMAPPCFOFFSET*/17,/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4]
		};
		var extendTerrainShader=Shader3D.nameKey.add("ExtendTerrain");
		vs="attribute vec4 a_Position;\nattribute vec2 a_Texcoord0;\n\nuniform mat4 u_MvpMatrix;\n\nvarying vec2 v_Texcoord0;\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(LIGHTMAP)\n	attribute vec3 a_Normal;\n	varying vec3 v_Normal;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||(defined(RECEIVESHADOW)&&defined(SHADOWMAP_PSSM1))\n	uniform mat4 u_WorldMat;\n	varying vec3 v_PositionWorld;\n#endif\n\n#ifdef LIGHTMAP\n	varying vec2 v_LightMapUV;\n	uniform vec4 u_LightmapScaleOffset;\n#endif\n\n#ifdef RECEIVESHADOW\n	varying float v_posViewZ;\n	#ifdef SHADOWMAP_PSSM1 \n		varying vec4 v_lightMVPPos;\n		uniform mat4 u_lightShadowVP[4];\n	#endif\n#endif\n\nvoid main()\n{\n	gl_Position = u_MvpMatrix * a_Position;\n  \n	v_Texcoord0 = a_Texcoord0;\n  \n	#ifdef LIGHTMAP\n		v_LightMapUV = vec2(a_Texcoord0.x*u_LightmapScaleOffset.x+u_LightmapScaleOffset.z,(a_Texcoord0.y-1.0)*u_LightmapScaleOffset.y+u_LightmapScaleOffset.w);\n	#endif\n  \n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		v_Normal = a_Normal;\n	#endif\n\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||(defined(RECEIVESHADOW)&&defined(SHADOWMAP_PSSM1))\n		v_PositionWorld=(u_WorldMat*a_Position).xyz;\n	#endif\n\n	#ifdef RECEIVESHADOW\n		v_posViewZ = gl_Position.w;\n		#ifdef SHADOWMAP_PSSM1\n			v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n		#endif\n	#endif\n}";
		ps="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"LightHelper.glsl\";\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)\n	uniform vec3 u_MaterialDiffuse;\n	uniform vec4 u_MaterialSpecular;\n	uniform vec3 u_CameraPos;\n	varying vec3 v_Normal;\n	varying vec3 v_PositionWorld;\n#endif\n\n#ifdef FOG\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	uniform vec3 u_FogColor;\n#endif\n\n\n#ifdef DIRECTIONLIGHT\n	uniform DirectionLight u_DirectionLight;\n#endif\n\n#ifdef POINTLIGHT\n	uniform PointLight u_PointLight;\n#endif\n\n#ifdef SPOTLIGHT\n	uniform SpotLight u_SpotLight;\n#endif\n\nuniform vec3 u_AmbientColor;\n\n#include \"ShadowHelper.glsl\"\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n	uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n	varying vec4 v_lightMVPPos;\n	#endif\n#endif\nvarying float v_posViewZ;\n\n\nuniform sampler2D u_SplatAlphaTexture;\n\nuniform sampler2D u_DiffuseTexture1;\nuniform sampler2D u_DiffuseTexture2;\nuniform sampler2D u_DiffuseTexture3;\nuniform sampler2D u_DiffuseTexture4;\nuniform sampler2D u_DiffuseTexture5;\n\nuniform vec4 u_DiffuseScaleOffset1;\nuniform vec4 u_DiffuseScaleOffset2;\nuniform vec4 u_DiffuseScaleOffset3;\nuniform vec4 u_DiffuseScaleOffset4;\nuniform vec4 u_DiffuseScaleOffset5;\n\nvarying vec2 v_Texcoord0;\n\nuniform vec3 u_MaterialAmbient;\nuniform vec4 u_MaterialAlbedo;\n\n#ifdef LIGHTMAP\n	uniform sampler2D u_LightMap;\n	varying vec2 v_LightMapUV;\n#endif\n\nvoid main()\n{\n	#ifdef ExtendTerrain_DETAIL_NUM1\n		vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r;\n	#endif\n	#ifdef ExtendTerrain_DETAIL_NUM2\n		vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord0 * u_DiffuseScaleOffset2.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r + color2.xyz * (1.0 - splatAlpha.r);\n	#endif\n	#ifdef ExtendTerrain_DETAIL_NUM3\n		vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord0 * u_DiffuseScaleOffset2.xy);\n		vec4 color3 = texture2D(u_DiffuseTexture3, v_Texcoord0 * u_DiffuseScaleOffset3.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r  + color2.xyz * splatAlpha.g + color3.xyz * (1.0 - splatAlpha.r - splatAlpha.g);\n	#endif\n	#ifdef ExtendTerrain_DETAIL_NUM4\n		vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord0 * u_DiffuseScaleOffset2.xy);\n		vec4 color3 = texture2D(u_DiffuseTexture3, v_Texcoord0 * u_DiffuseScaleOffset3.xy);\n		vec4 color4 = texture2D(u_DiffuseTexture4, v_Texcoord0 * u_DiffuseScaleOffset4.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r  + color2.xyz * splatAlpha.g + color3.xyz * splatAlpha.b + color4.xyz * (1.0 - splatAlpha.r - splatAlpha.g - splatAlpha.b);\n	#endif\n	#ifdef ExtendTerrain_DETAIL_NUM5\n		vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord0 * u_DiffuseScaleOffset2.xy);\n		vec4 color3 = texture2D(u_DiffuseTexture3, v_Texcoord0 * u_DiffuseScaleOffset3.xy);\n		vec4 color4 = texture2D(u_DiffuseTexture4, v_Texcoord0 * u_DiffuseScaleOffset4.xy);\n		vec4 color5 = texture2D(u_DiffuseTexture5, v_Texcoord0 * u_DiffuseScaleOffset5.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r  + color2.xyz * splatAlpha.g + color3.xyz * splatAlpha.b + color4.xyz * splatAlpha.a + color5.xyz * (1.0 - splatAlpha.r - splatAlpha.g - splatAlpha.b - splatAlpha.a);\n	#endif\n		gl_FragColor.w = splatAlpha.a;\n		\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n    vec3 normal = v_Normal;\n	vec3 diffuse = vec3(0.0);\n	vec3 ambient = vec3(0.0);\n	vec3 specular= vec3(0.0);\n	vec3 dif, amb, spe;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)\n	vec3 toEye;\n	#ifdef FOG\n		toEye=u_CameraPos-v_PositionWorld;\n		float toEyeLength=length(toEye);\n		toEye/=toEyeLength;\n	#else\n		toEye=normalize(u_CameraPos-v_PositionWorld);\n	#endif\n#endif\n\n#ifdef DIRECTIONLIGHT\n	computeDirectionLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_DirectionLight,u_AmbientColor,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n \n#ifdef POINTLIGHT\n	computePointLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_PointLight,u_AmbientColor,v_PositionWorld,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n\n#ifdef SPOTLIGHT\n	ComputeSpotLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_SpotLight,u_AmbientColor,v_PositionWorld,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n\n#ifdef RECEIVESHADOW\n	float shadowValue = 1.0;\n	#ifdef SHADOWMAP_PSSM3\n		shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n	#endif\n	#ifdef SHADOWMAP_PSSM2\n		shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n	#endif \n	#ifdef SHADOWMAP_PSSM1\n		shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n	#endif\n#endif\n\n#ifdef LIGHTMAP\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient + texture2D(u_LightMap, v_LightMapUV).rgb);\n	#else\n		#if defined(RECEIVESHADOW)		\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient+texture2D(u_LightMap, v_LightMapUV).rgb * shadowValue);\n			//vec3 tColor= u_MaterialAmbient + texture2D(u_LightMap, v_LightMapUV).rgb * shadowValue + mix(vec3(0.15,0.15,0.15),vec3(0.0),shadowValue);\n			//gl_FragColor.rgb*=tColor;\n		#else\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient + texture2D(u_LightMap, v_LightMapUV).rgb);\n		#endif\n	#endif\n#endif\n\ngl_FragColor=gl_FragColor*u_MaterialAlbedo;\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	#ifdef RECEIVESHADOW\n		gl_FragColor = vec4( gl_FragColor.rgb*(ambient + diffuse*shadowValue) + specular * shadowValue,gl_FragColor.a);\n	#else\n		gl_FragColor =vec4( gl_FragColor.rgb*(ambient + diffuse) + specular, gl_FragColor.a);\n	#endif\n#endif\n\n#ifdef FOG\n	float lerpFact=clamp((toEyeLength-u_FogStart)/u_FogRange,0.0,1.0);\n	gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n#endif\n}\n\n\n\n\n\n";
		var extendTerrainCompile3D=ShaderCompile3D.add(extendTerrainShader,vs,ps,attributeMap,uniformMap);
		extendTerrainCompile3D.addSpriteDefines(RenderableSprite3D.shaderDefines);
		extendTerrainCompile3D.addMaterialDefines(ExtendTerrainMaterial.shaderDefines);
		attributeMap={
			'a_Position' :/*laya.d3.graphics.VertexElementUsage.POSITION0*/0,
			'a_OffsetVector':/*laya.d3.graphics.VertexElementUsage.OFFSETVECTOR*/41,
			'a_Texcoord0X' :/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0X*/38,
			'a_Texcoord0Y' :/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0Y*/40,
			'a_BirthTime' :/*laya.d3.graphics.VertexElementUsage.TIME0*/33
		};
		uniformMap={
			'u_MvpMatrix':[ /*laya.d3.core.Sprite3D.MVPMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_VMatrix':[ /*laya.d3.core.BaseCamera.VIEWMATRIX*/1,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_PMatrix':[ /*laya.d3.core.BaseCamera.PROJECTMATRIX*/2,/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3],
			'u_TilingOffset':[ /*laya.d3.core.trail.TrailMaterial.TILINGOFFSET*/3,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MainTexture':[ /*laya.d3.core.trail.TrailMaterial.DIFFUSETEXTURE*/1,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_MainColor':[ /*laya.d3.core.trail.TrailMaterial.TINTCOLOR*/2,/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1],
			'u_CurTime' :[ /*laya.d3.core.trail.TrailSprite3D.CURTIME*/3,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_LifeTime' :[ /*laya.d3.core.trail.TrailSprite3D.LIFETIME*/4,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_WidthCurve' :[ /*laya.d3.core.trail.TrailSprite3D.WIDTHCURVE*/5,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_WidthCurveKeyLength' :[ /*laya.d3.core.trail.TrailSprite3D.WIDTHCURVEKEYLENGTH*/6,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_GradientColorkey' :[ /*laya.d3.core.trail.TrailSprite3D.GRADIENTCOLORKEY*/7,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2],
			'u_GradientAlphakey' :[ /*laya.d3.core.trail.TrailSprite3D.GRADIENTALPHAKEY*/8,/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2]
		};
		var trailShader=Shader3D.nameKey.add("Trail");
		vs="attribute vec3 a_Position;\nattribute vec3 a_OffsetVector;\nattribute vec4 a_Color;\nattribute float a_Texcoord0X;\nattribute float a_Texcoord0Y;\nattribute float a_BirthTime;\n\nuniform mat4 u_VMatrix;\nuniform mat4 u_PMatrix;\n\nuniform vec4 u_TilingOffset;\n\nuniform float u_CurTime;\nuniform float u_LifeTime;\nuniform vec4 u_WidthCurve[10];\nuniform int u_WidthCurveKeyLength;\n\nuniform vec4 u_GradientColorkey[10];\nuniform vec2 u_GradientAlphakey[10];\n\nvarying vec2 v_Texcoord0;\nvarying vec4 v_Color;\n\nfloat hermiteInterpolate(float t, float outTangent, float inTangent, float duration, float value1, float value2)\n{\n	float t2 = t * t;\n	float t3 = t2 * t;\n	float a = 2.0 * t3 - 3.0 * t2 + 1.0;\n	float b = t3 - 2.0 * t2 + t;\n	float c = t3 - t2;\n	float d = -2.0 * t3 + 3.0 * t2;\n	return a * value1 + b * outTangent * duration + c * inTangent * duration + d * value2;\n}\n\nfloat getCurWidth(in float normalizeTime)\n{\n	if(normalizeTime == 0.0){\n		return u_WidthCurve[0].w;\n	}\n	else if(normalizeTime >= 1.0){\n		return u_WidthCurve[u_WidthCurveKeyLength - 1].w;\n	}\n	else{\n		for(int i = 0; i < 10; i ++ )\n		{\n			if(normalizeTime == u_WidthCurve[i].x)\n			{\n				return u_WidthCurve[i].w;\n			}\n			\n			vec4 lastFrame = u_WidthCurve[i];\n			vec4 nextFrame = u_WidthCurve[i + 1];\n			if(normalizeTime > lastFrame.x && normalizeTime < nextFrame.x)\n			{\n				float duration = nextFrame.x - lastFrame.x;\n				float t = (normalizeTime - lastFrame.x) / duration;\n				float outTangent = lastFrame.z;\n				float inTangent = nextFrame.y;\n				float value1 = lastFrame.w;\n				float value2 = nextFrame.w;\n				return hermiteInterpolate(t, outTangent, inTangent, duration, value1, value2);\n			}\n		}	\n	}\n}	\n\nvec4 getColorFromGradientByBlend(in vec4 gradientColors[10], in vec2 gradientAlphas[10], in float normalizeTime)\n{\n	vec4 color;\n	for(int i = 1; i < 10; i++)\n	{\n		vec4 gradientColor = gradientColors[i];\n		float colorKey = gradientColor.w;\n		if(colorKey >= normalizeTime)\n		{\n			vec4 lastGradientColor = gradientColors[i-1];\n			float lastColorKey = lastGradientColor.w;\n			float age = (normalizeTime - lastColorKey) / (colorKey - lastColorKey);\n			color.rgb = mix(gradientColors[i-1].xyz, gradientColor.xyz, age);\n			break;\n		}\n	}\n	for(int i = 1; i < 10; i++)\n	{\n		vec2 gradientAlpha = gradientAlphas[i];\n		float alphaKey = gradientAlpha.y;\n		if(alphaKey >= normalizeTime)\n		{\n			vec2 lastGradientAlpha = gradientAlphas[i-1];\n			float lastAlphaKey = lastGradientAlpha.y;\n			float age = (normalizeTime - lastAlphaKey) / (alphaKey - lastAlphaKey);\n			color.a = mix(lastGradientAlpha.x, gradientAlpha.x, age);\n			break;\n		}\n	}\n	return color;\n}\n\nvec4 getColorFromGradientByFixed(in vec4 gradientColors[10], in vec2 gradientAlphas[10], in float normalizeTime)\n{\n	vec4 color;\n	for(int i = 1; i < 10; i++)\n	{\n		vec4 gradientColor = gradientColors[i];\n		if(gradientColor.w >= normalizeTime)\n		{\n			color.rgb = gradientColor.xyz;\n			break;\n		}\n	}\n	for(int i = 1; i < 10; i++)\n	{\n		vec2 gradientAlpha = gradientAlphas[i];\n		if(gradientAlpha.y >= normalizeTime)\n		{\n			color.a = gradientAlpha.x;\n			break;\n		}\n	}\n	return color;\n}\n\nvoid main()\n{\n	float normalizeTime = (u_CurTime - a_BirthTime) / u_LifeTime;\n	\n	gl_Position = u_PMatrix * u_VMatrix * vec4(a_Position + a_OffsetVector * getCurWidth(normalizeTime),1.0);\n	\n	#ifdef TILINGOFFSET\n		v_Texcoord0 = (vec2(a_Texcoord0X, a_Texcoord0Y) * u_TilingOffset.xy) + u_TilingOffset.zw;\n	#else\n		v_Texcoord0 = vec2(a_Texcoord0X, a_Texcoord0Y);\n	#endif\n	\n	#ifdef GRADIENTMODE_BLEND\n		v_Color = getColorFromGradientByBlend(u_GradientColorkey, u_GradientAlphakey, normalizeTime);\n	#else\n		v_Color = getColorFromGradientByFixed(u_GradientColorkey, u_GradientAlphakey, normalizeTime);\n	#endif\n}\n\n\n\n";
		ps="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\nuniform sampler2D u_MainTexture;\nuniform vec4 u_MainColor;\n\nvarying vec2 v_Texcoord0;\nvarying vec4 v_Color;\n\nvoid main()\n{	\n	vec4 color = 2.0 * u_MainColor * v_Color;\n	#ifdef DIFFUSETEXTURE\n		vec4 mainTextureColor = texture2D(u_MainTexture, v_Texcoord0);\n		color *= mainTextureColor;\n	#endif\n	gl_FragColor = color;\n}\n\n";
		var trailCompile3D=ShaderCompile3D.add(trailShader,vs,ps,attributeMap,uniformMap);
		TrailMaterial.SHADERDEFINE_DIFFUSETEXTURE=trailCompile3D.registerMaterialDefine("DIFFUSETEXTURE");
		TrailMaterial.SHADERDEFINE_TILINGOFFSET=trailCompile3D.registerSpriteDefine("TILINGOFFSET");
		TrailSprite3D.SHADERDEFINE_GRADIENTMODE_BLEND=trailCompile3D.registerSpriteDefine("GRADIENTMODE_BLEND");
	}

	return ShaderInit3D;
})()


/**
*@private
*<code>Shader3D</code> 主要用数组的方式保存shader变量定义，后期合并ShaderValue不使用for in，性能较高。
*/
//class laya.d3.shader.ValusArray
var ValusArray=(function(){
	function ValusArray(){
		this._data=null;
		this._data=[];
	}

	__class(ValusArray,'laya.d3.shader.ValusArray');
	var __proto=ValusArray.prototype;
	__proto.setValue=function(name,value){
		this._data[name]=value;
	}

	__getset(0,__proto,'data',function(){
		return this._data;
	});

	return ValusArray;
})()


/**
*...
*@author ...
*/
//class laya.d3.shadowMap.ParallelSplitShadowMap
var ParallelSplitShadowMap=(function(){
	function ParallelSplitShadowMap(){
		/**@private */
		//this.lastNearPlane=NaN;
		/**@private */
		//this.lastFieldOfView=NaN;
		/**@private */
		//this.lastAspectRatio=NaN;
		/**@private */
		this._currentPSSM=-1;
		/**@private */
		this._numberOfPSSM=3;
		/**@private */
		this._maxDistance=200.0;
		/**@private */
		this._ratioOfDistance=1.0 / this._numberOfPSSM;
		/**@private */
		this._statesDirty=true;
		/**@private */
		this._lightCulling=null;
		/**@private */
		this._renderTarget=null;
		/**@private */
		this._lightVPMatrix=null;
		/**@private */
		this._lightCameras=null;
		/**@private */
		this._shadowQuenes=null;
		/**@private */
		this._shadowMapTextureSize=1024;
		/**@private */
		this._scene=null;
		/**@private */
		this._PCFType=0;
		/**@private */
		this._shaderValueLightVP=null;
		/**@private */
		this._shaderValueVPs=null;
		this._spiltDistance=new Array(/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3+1);
		this._globalParallelLightDir=new Vector3(0,-1,0);
		this._boundingSphere=new Array(/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3+1);
		this._boundingBox=new Array(/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3+1);
		this._frustumPos=new Array((/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3+1)*4);
		this._uniformDistance=new Array(/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3+1);
		this._logDistance=new Array(/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3+1);
		this._dimension=new Array(/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3+1);
		this._tempLookAt3=new Vector3();
		this._tempLookAt4=new Vector4();
		this._tempValue=new Vector4();
		this._tempPos=new Vector3();
		this._tempLightUp=new Vector3();
		this._tempMin=new Vector4();
		this._tempMax=new Vector4();
		this._tempMatrix44=new Matrix4x4;
		this._splitFrustumCulling=new BoundFrustum(Matrix4x4.DEFAULT);
		this._tempScaleMatrix44=new Matrix4x4;
		this._shadowPCFOffset=new Vector2(1.0 / 1024.0,1.0 / 1024.0);
		this._shaderValueDistance=new Vector4();
		var i=0;
		for (i=0;i < this._spiltDistance.length;i++){
			this._spiltDistance[i]=0.0;
		}
		for (i=0;i < this._dimension.length;i++){
			this._dimension[i]=new Vector2();
		}
		for (i=0;i < this._frustumPos.length;i++){
			this._frustumPos[i]=new Vector3();
		}
		for (i=0;i < this._boundingBox.length;i++){
			this._boundingBox[i]=new BoundBox(new Vector3(),new Vector3());
		}
		for (i=0;i < this._boundingSphere.length;i++){
			this._boundingSphere[i]=new BoundSphere(new Vector3(),0.0);
		}
		Matrix4x4.createScaling(new Vector3(0.5,0.5,1.0),this._tempScaleMatrix44);
		this._tempScaleMatrix44.elements[12]=0.5;
		this._tempScaleMatrix44.elements[13]=0.5;
	}

	__class(ParallelSplitShadowMap,'laya.d3.shadowMap.ParallelSplitShadowMap');
	var __proto=ParallelSplitShadowMap.prototype;
	__proto.setInfo=function(scene,maxDistance,globalParallelDir,shadowMapTextureSize,numberOfPSSM,PCFType){
		if (numberOfPSSM > /*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3){
			this._numberOfPSSM=/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3;
		}
		this._scene=scene;
		this._maxDistance=maxDistance;
		this.PSSMNum=numberOfPSSM;
		this._globalParallelLightDir=globalParallelDir;
		this._ratioOfDistance=1.0 / this._numberOfPSSM;
		for (var i=0;i < this._spiltDistance.length;i++){
			this._spiltDistance[i]=0.0;
		}
		this._shadowMapTextureSize=shadowMapTextureSize;
		this._shadowPCFOffset.x=1.0 / this._shadowMapTextureSize;
		this._shadowPCFOffset.y=1.0 / this._shadowMapTextureSize;
		this.setPCFType(PCFType);
		this._statesDirty=true;
	}

	__proto.setPCFType=function(PCFtype){
		this._PCFType=PCFtype;
		switch (this._PCFType){
			case 0:
				this._scene.addShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF_NO);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF1);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF2);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF3);
				break ;
			case 1:
				this._scene.addShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF1);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF_NO);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF2);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF3);
				break ;
			case 2:
				this._scene.addShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF2);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF_NO);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF1);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF3);
				break ;
			case 3:
				this._scene.addShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF3);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF_NO);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF1);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF2);
				break ;
			}
	}

	__proto.getPCFType=function(){
		return this._PCFType;
	}

	__proto.setFarDistance=function(value){
		if (this._maxDistance !=value){
			this._maxDistance=value;
			this._statesDirty=true;
		}
	}

	__proto.getFarDistance=function(){
		return this._maxDistance;
	}

	__proto._setGlobalParallelLightDir=function(dir){
		this._globalParallelLightDir=dir;
	}

	__proto.getGlobalParallelLightDir=function(){
		return this._globalParallelLightDir;
	}

	__proto.getCurrentPSSM=function(){
		return this._currentPSSM;
	}

	__proto.getLightCamera=function(index){
		return this._lightCameras[index];
	}

	/**
	*@private
	*/
	__proto._beginSampler=function(index,sceneCamera){
		if (index < 0 || index > this._numberOfPSSM)
			throw new Error("ParallelSplitShadowMap: beginSample invalid index");
		this._currentPSSM=index;
		this._update(sceneCamera);
	}

	/**
	*@private
	*/
	__proto.endSampler=function(sceneCamera){
		this._currentPSSM=-1;
	}

	/**
	*@private
	*/
	__proto._calcAllLightCameraInfo=function(sceneCamera){
		if (this._numberOfPSSM===1){
			this._beginSampler(0,sceneCamera);
			this.endSampler(sceneCamera);
			}else {
			for (var i=0,n=this._numberOfPSSM+1;i < n;i++){
				this._beginSampler(i,sceneCamera);
				this.endSampler(sceneCamera);
			}
		}
	}

	/**
	*@private
	*/
	__proto._recalculate=function(nearPlane,fieldOfView,aspectRatio){
		this._calcSplitDistance(nearPlane);
		this._calcBoundingBox(fieldOfView,aspectRatio);
		this._rebuildRenderInfo();
	}

	/**
	*@private
	*/
	__proto._update=function(sceneCamera){
		var nearPlane=sceneCamera.nearPlane;
		var fieldOfView=sceneCamera.fieldOfView;
		var aspectRatio=(sceneCamera).aspectRatio;
		if (this._statesDirty || this.lastNearPlane!==nearPlane || this.lastFieldOfView!==fieldOfView || this.lastAspectRatio!==aspectRatio){
			this._recalculate(nearPlane,fieldOfView,aspectRatio);
			this._uploadShaderValue();
			this._statesDirty=false;
			this.lastNearPlane=nearPlane;
			this.lastFieldOfView=fieldOfView;
			this.lastAspectRatio=aspectRatio;
		}
		this._calcLightViewProject(sceneCamera);
	}

	/**
	*@private
	*/
	__proto._uploadShaderValue=function(){
		var scene=this._scene;
		switch (this._numberOfPSSM){
			case 1:
				scene.addShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM1);
				scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM2);
				scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM3);
				break ;
			case 2:
				scene.addShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM2);
				scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM1);
				scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM3);
				break ;
			case 3:
				scene.addShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM3);
				scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM1);
				scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM2);
				break ;
			};
		var sceneSV=scene._shaderValues;
		sceneSV.setValue(/*laya.d3.core.scene.Scene.SHADOWDISTANCE*/15,this._shaderValueDistance.elements);
		sceneSV.setValue(/*laya.d3.core.scene.Scene.SHADOWLIGHTVIEWPROJECT*/16,this._shaderValueLightVP);
		sceneSV.setValue(/*laya.d3.core.scene.Scene.SHADOWMAPPCFOFFSET*/17,this._shadowPCFOffset.elements);
		switch (this._numberOfPSSM){
			case 3:
				sceneSV.setValue(/*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE1*/18,this.getRenderTarget(1));
				sceneSV.setValue(/*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE2*/19,this.getRenderTarget(2));
				sceneSV.setValue(/*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE3*/20,this.getRenderTarget(3));
				break ;
			case 2:
				sceneSV.setValue(/*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE1*/18,this.getRenderTarget(1));
				sceneSV.setValue(/*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE2*/19,this.getRenderTarget(2));
				break ;
			case 1:
				sceneSV.setValue(/*laya.d3.core.scene.Scene.SHADOWMAPTEXTURE1*/18,this.getRenderTarget(1));
				break ;
			}
	}

	/**
	*@private
	*/
	__proto._calcSplitDistance=function(nearPlane){
		var far=this._maxDistance;
		var invNumberOfPSSM=1.0 / this._numberOfPSSM;
		var i=0;
		for (i=0;i <=this._numberOfPSSM;i++){
			this._uniformDistance[i]=nearPlane+(far-nearPlane)*i *invNumberOfPSSM;
		};
		var farDivNear=far / nearPlane;
		for (i=0;i <=this._numberOfPSSM;i++){
			var n=Math.pow(farDivNear,i *invNumberOfPSSM);
			this._logDistance[i]=nearPlane *n;
		}
		for (i=0;i <=this._numberOfPSSM;i++){
			this._spiltDistance[i]=this._uniformDistance[i] *this._ratioOfDistance+this._logDistance[i] *(1.0-this._ratioOfDistance);
		}
		this._shaderValueDistance.x=this._spiltDistance[1];
		this._shaderValueDistance.y=this._spiltDistance[2];
		this._shaderValueDistance.z=this._spiltDistance[3];
	}

	/**
	*@private
	*/
	__proto._calcBoundingBox=function(fieldOfView,aspectRatio){
		var fov=3.1415926 *fieldOfView / 180.0;
		var halfTanValue=Math.tan(fov / 2.0);
		var height=NaN;
		var width=NaN;
		var distance=NaN;
		var i=0;
		for (i=0;i <=this._numberOfPSSM;i++){
			distance=this._spiltDistance[i];
			height=distance *halfTanValue;
			width=height *aspectRatio;
			var temp=this._frustumPos[i *4+0].elements;
			temp[0]=-width;
			temp[1]=-height;
			temp[2]=-distance;
			temp=this._frustumPos[i *4+1].elements;
			temp[0]=width;
			temp[1]=-height;
			temp[2]=-distance;
			temp=this._frustumPos[i *4+2].elements;
			temp[0]=-width;
			temp[1]=height;
			temp[2]=-distance;
			temp=this._frustumPos[i *4+3].elements;
			temp[0]=width;
			temp[1]=height;
			temp[2]=-distance;
			temp=this._dimension[i].elements;
			temp[0]=width;
			temp[1]=height;
		};
		var d;
		var min;
		var max;
		var center;
		for (i=1;i <=this._numberOfPSSM;i++){
			d=this._dimension[i].elements;
			min=this._boundingBox[i].min.elements;
			min[0]=-d[0];
			min[1]=-d[1];
			min[2]=-this._spiltDistance[i];
			max=this._boundingBox[i].max.elements;
			max[0]=d[0];
			max[1]=d[1];
			max[2]=-this._spiltDistance[i-1];
			center=this._boundingSphere[i].center.elements;
			center[0]=(min[0]+max[0])*0.5;
			center[1]=(min[1]+max[1])*0.5;
			center[2]=(min[2]+max[2])*0.5;
			this._boundingSphere[i].radius=Math.sqrt(Math.pow(max[0]-min[0],2)+Math.pow(max[1]-min[1],2)+Math.pow(max[2]-min[2],2))*0.5;
		}
		min=this._boundingBox[0].min.elements;
		d=this._dimension[this._numberOfPSSM].elements;
		min[0]=-d[0];
		min[1]=-d[1];
		min[2]=-this._spiltDistance[this._numberOfPSSM];
		max=this._boundingBox[0].max.elements;
		max[0]=d[0];
		max[1]=d[1];
		max[2]=-this._spiltDistance[0];
		center=this._boundingSphere[0].center.elements;
		center[0]=(min[0]+max[0])*0.5;
		center[1]=(min[1]+max[1])*0.5;
		center[2]=(min[2]+max[2])*0.5;
		this._boundingSphere[0].radius=Math.sqrt(Math.pow(max[0]-min[0],2)+Math.pow(max[1]-min[1],2)+Math.pow(max[2]-min[2],2))*0.5;
	}

	__proto.calcSplitFrustum=function(sceneCamera){
		if (this._currentPSSM > 0){
			Matrix4x4.createPerspective(3.1416 *sceneCamera.fieldOfView / 180.0,(sceneCamera).aspectRatio,this._spiltDistance[this._currentPSSM-1],this._spiltDistance[this._currentPSSM],this._tempMatrix44);
			}else {
			Matrix4x4.createPerspective(3.1416 *sceneCamera.fieldOfView / 180.0,(sceneCamera).aspectRatio,this._spiltDistance[0],this._spiltDistance[this._numberOfPSSM],this._tempMatrix44);
		}
		Matrix4x4.multiply(this._tempMatrix44,(sceneCamera).viewMatrix,this._tempMatrix44);
		this._splitFrustumCulling.matrix=this._tempMatrix44;
	}

	/**
	*@private
	*/
	__proto._rebuildRenderInfo=function(){
		var nNum=this._numberOfPSSM+1;
		var i=0;
		if (this._renderTarget==null){
			this._renderTarget=__newvec(nNum);
			this._renderTarget[0]=null;
			for (i=1;i < nNum;i++){
				this._renderTarget[i]=new RenderTexture(this._shadowMapTextureSize,this._shadowMapTextureSize,/*laya.webgl.WebGLContext.RGBA*/0x1908,/*laya.webgl.WebGLContext.UNSIGNED_BYTE*/0x1401,/*laya.webgl.WebGLContext.DEPTH_COMPONENT16*/0x81A5,false,false,/*laya.webgl.WebGLContext.NEAREST*/0x2600,/*laya.webgl.WebGLContext.NEAREST*/0x2600);
			}
			}else if (this._renderTarget.length !=nNum){
			this.disposeAllRenderTarget();
			this._renderTarget.length=nNum;
			this._renderTarget[0]=null;
			for (i=1;i < nNum;i++){
				this._renderTarget[i]=new RenderTexture(this._shadowMapTextureSize,this._shadowMapTextureSize,/*laya.webgl.WebGLContext.RGBA*/0x1908,/*laya.webgl.WebGLContext.UNSIGNED_BYTE*/0x1401,/*laya.webgl.WebGLContext.DEPTH_COMPONENT16*/0x81A5,false,false,/*laya.webgl.WebGLContext.NEAREST*/0x2600,/*laya.webgl.WebGLContext.NEAREST*/0x2600);
			}
			}else {
			for (i=1;i < nNum;i++){
				if (this._renderTarget[i]==null || this._renderTarget[i].width !=this._shadowMapTextureSize || this._renderTarget[i].height !=this._shadowMapTextureSize){
					if (this._renderTarget[i] !=null){
						this._renderTarget[i].destroy();
					}
					this._renderTarget[i]=new RenderTexture(this._shadowMapTextureSize,this._shadowMapTextureSize,/*laya.webgl.WebGLContext.RGBA*/0x1908,/*laya.webgl.WebGLContext.UNSIGNED_BYTE*/0x1401,/*laya.webgl.WebGLContext.DEPTH_COMPONENT16*/0x81A5,false,false,/*laya.webgl.WebGLContext.NEAREST*/0x2600,/*laya.webgl.WebGLContext.NEAREST*/0x2600);
				}
			}
		}
		if (this._lightCulling==null || this._lightCulling.length !=nNum){
			if (this._lightCulling){
				this._lightCulling.length=nNum;
				}else {
				this._lightCulling=__newvec(nNum);
			}
			for (i=0;i < this._lightCulling.length;i++){
				this._lightCulling[i]=new BoundFrustum(Matrix4x4.DEFAULT);
			}
		}
		if (this._lightVPMatrix==null || this._lightVPMatrix.length !=nNum){
			if (this._lightVPMatrix){
				this._lightVPMatrix.length=nNum;
				}else {
				this._lightVPMatrix=__newvec(nNum);
			}
			for (i=0;i < this._lightVPMatrix.length;i++){
				this._lightVPMatrix[i]=new Matrix4x4();
			}
		}
		if (this._lightCameras==null || this._lightCameras.length !=nNum){
			if (this._lightCameras){
				this._lightCameras.length=nNum;
				}else {
				this._lightCameras=__newvec(nNum);
			}
			for (i=0;i < this._lightCameras.length;i++){
				this._lightCameras[i]=new Camera();
				this._lightCameras[i].name="lightCamera"+i;
			}
		}
		if (this._shadowQuenes==null || this._shadowQuenes.length !=this._numberOfPSSM){
			if (this._shadowQuenes){
				this._shadowQuenes.length=this._numberOfPSSM;
				}else {
				this._shadowQuenes=__newvec(this._numberOfPSSM);
			}
			for (i=0;i < this._shadowQuenes.length;i++){
				this._shadowQuenes[i]=new RenderQueue(this._scene);
			}
		}
		if (this._shaderValueVPs==null || this._shaderValueVPs.length !=nNum){
			if (this._shaderValueVPs){
				this._shaderValueVPs.length=nNum;
				}else {
				this._shaderValueVPs=__newvec(nNum);
			}
			this._shaderValueLightVP=new Float32Array(nNum *16);
			for (i=0;i < nNum;i++){
				this._shaderValueVPs[i]=new Float32Array(this._shaderValueLightVP.buffer,i *64);
			}
		}
	}

	/**
	*@private
	*/
	__proto._calcLightViewProject=function(sceneCamera){
		var boundSphere=this._boundingSphere[this._currentPSSM];
		var cameraMatViewInv=sceneCamera.transform.worldMatrix;
		var radius=boundSphere.radius;
		boundSphere.center.cloneTo(this._tempLookAt3);
		Vector3.transformV3ToV4(this._tempLookAt3,cameraMatViewInv,this._tempLookAt4);
		var lookAt3Element=this._tempLookAt3.elements;
		var lookAt4Element=this._tempLookAt4.elements;
		lookAt3Element[0]=lookAt4Element[0];
		lookAt3Element[1]=lookAt4Element[1];
		lookAt3Element[2]=lookAt4Element[2];
		var lightUpElement=this._tempLightUp.elements;
		var sceneCameraDir=sceneCamera.forward.elements;
		lightUpElement[0]=sceneCameraDir[0];
		lightUpElement[1]=1.0;
		lightUpElement[2]=sceneCameraDir[2];
		Vector3.normalize(this._tempLightUp,this._tempLightUp);
		Vector3.scale(this._globalParallelLightDir,boundSphere.radius *4,this._tempPos);
		Vector3.subtract(this._tempLookAt3,this._tempPos,this._tempPos);
		var curLightCamera=this._lightCameras[this._currentPSSM];
		curLightCamera.transform.position=this._tempPos;
		curLightCamera.transform.lookAt(this._tempLookAt3,this._tempLightUp,false);
		var tempMaxElements=this._tempMax.elements;
		var tempMinElements=this._tempMin.elements;
		tempMaxElements[0]=tempMaxElements[1]=tempMaxElements[2]=-100000.0;
		tempMaxElements[3]=1.0;
		tempMinElements[0]=tempMinElements[1]=tempMinElements[2]=100000.0;
		tempMinElements[3]=1.0;
		Matrix4x4.multiply(curLightCamera.viewMatrix,cameraMatViewInv,this._tempMatrix44);
		var tempValueElement=this._tempValue.elements;
		var corners=[];
		corners.length=8;
		this._boundingBox[this._currentPSSM].getCorners(corners);
		for (var i=0;i < 8;i++){
			var frustumPosElements=corners[i].elements;
			tempValueElement[0]=frustumPosElements[0];
			tempValueElement[1]=frustumPosElements[1];
			tempValueElement[2]=frustumPosElements[2];
			tempValueElement[3]=1.0;
			Vector4.transformByM4x4(this._tempValue,this._tempMatrix44,this._tempValue);
			tempMinElements[0]=(tempValueElement[0] < tempMinElements[0])? tempValueElement[0] :tempMinElements[0];
			tempMinElements[1]=(tempValueElement[1] < tempMinElements[1])? tempValueElement[1] :tempMinElements[1];
			tempMinElements[2]=(tempValueElement[2] < tempMinElements[2])? tempValueElement[2] :tempMinElements[2];
			tempMaxElements[0]=(tempValueElement[0] > tempMaxElements[0])? tempValueElement[0] :tempMaxElements[0];
			tempMaxElements[1]=(tempValueElement[1] > tempMaxElements[1])? tempValueElement[1] :tempMaxElements[1];
			tempMaxElements[2]=(tempValueElement[2] > tempMaxElements[2])? tempValueElement[2] :tempMaxElements[2];
		}
		Vector4.add(this._tempMax,this._tempMin,this._tempValue);
		tempValueElement[0] *=0.5;
		tempValueElement[1] *=0.5;
		tempValueElement[2] *=0.5;
		tempValueElement[3]=1;
		Vector4.transformByM4x4(this._tempValue,curLightCamera.transform.worldMatrix,this._tempValue);
		var distance=Math.abs(-this._tempMax.z);
		var farPlane=distance > this._maxDistance ? distance :this._maxDistance;
		Vector3.scale(this._globalParallelLightDir,farPlane,this._tempPos);
		var tempPosElement=this._tempPos.elements;
		tempPosElement[0]=tempValueElement[0]-tempPosElement[0];
		tempPosElement[1]=tempValueElement[1]-tempPosElement[1];
		tempPosElement[2]=tempValueElement[2]-tempPosElement[2];
		curLightCamera.transform.position=this._tempPos;
		curLightCamera.transform.lookAt(this._tempLookAt3,this._tempLightUp,false);
		Matrix4x4.createOrthoOffCenterRH(tempMinElements[0],tempMaxElements[0],tempMinElements[1],tempMaxElements[1],1.0,farPlane+0.5 *(tempMaxElements[2]-tempMinElements[2]),curLightCamera.projectionMatrix);
		curLightCamera.projectionViewMatrix.cloneTo(this._lightVPMatrix[this._currentPSSM]);
		this._lightCulling[this._currentPSSM].matrix=this._lightVPMatrix[this._currentPSSM];
		ParallelSplitShadowMap.multiplyMatrixOutFloat32Array(this._tempScaleMatrix44,this._lightVPMatrix[this._currentPSSM],this._shaderValueVPs[this._currentPSSM]);
	}

	__proto.getLightFrustumCulling=function(currentPSSM){
		return this._lightCulling[currentPSSM];
	}

	__proto.getSplitFrustumCulling=function(){
		return this._splitFrustumCulling;
	}

	__proto.getSplitDistance=function(index){
		return this._spiltDistance[index];
	}

	__proto.setShadowMapTextureSize=function(size){
		if (size!==this._shadowMapTextureSize){
			this._shadowMapTextureSize=size;
			this._shadowPCFOffset.x=1 / this._shadowMapTextureSize;
			this._shadowPCFOffset.y=1 / this._shadowMapTextureSize;
			this._statesDirty=true;
		}
	}

	__proto.getShadowMapTextureSize=function(){
		return this._shadowMapTextureSize;
	}

	__proto.beginRenderTarget=function(index){
		this._renderTarget[index].start();
	}

	__proto.endRenderTarget=function(index){
		this._renderTarget[index].end();
	}

	__proto.getRenderTarget=function(index){
		return this._renderTarget[index];
	}

	__proto.disposeAllRenderTarget=function(){
		for (var i=0,n=this._numberOfPSSM+1;i < n;i++){
			if (this._renderTarget[i]){
				this._renderTarget[i].destroy();
				this._renderTarget[i]=null;
			}
		}
	}

	__getset(0,__proto,'PSSMNum',function(){
		return this._numberOfPSSM;
		},function(value){
		value=value > 0 ? value :1;
		value=value <=3 ? value :3;
		if (this._numberOfPSSM !=value){
			this._numberOfPSSM=value;
			this._ratioOfDistance=1.0 / this._numberOfPSSM;
			this._statesDirty=true;
		}
	});

	ParallelSplitShadowMap.multiplyMatrixOutFloat32Array=function(left,right,out){
		var i,a,b,ai0,ai1,ai2,ai3;
		a=left.elements;
		b=right.elements;
		for (i=0;i < 4;i++){
			ai0=a[i];
			ai1=a[i+4];
			ai2=a[i+8];
			ai3=a[i+12];
			out[i]=ai0 *b[0]+ai1 *b[1]+ai2 *b[2]+ai3 *b[3];
			out[i+4]=ai0 *b[4]+ai1 *b[5]+ai2 *b[6]+ai3 *b[7];
			out[i+8]=ai0 *b[8]+ai1 *b[9]+ai2 *b[10]+ai3 *b[11];
			out[i+12]=ai0 *b[12]+ai1 *b[13]+ai2 *b[14]+ai3 *b[15];
		}
	}

	ParallelSplitShadowMap.SHADERDEFINE_RECEIVE_SHADOW=0x1;
	ParallelSplitShadowMap.SHADERDEFINE_CAST_SHADOW=0x200;
	ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM1=0x400;
	ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM2=0x800;
	ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM3=0x1000;
	ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF_NO=0x2000;
	ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF1=0x4000;
	ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF2=0x8000;
	ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF3=0x10000;
	ParallelSplitShadowMap.MAX_PSSM_COUNT=3;
	return ParallelSplitShadowMap;
})()


/**
*<code>TerrainLeaf</code> Terrain的叶子节点
*/
//class laya.d3.terrain.TerrainLeaf
var TerrainLeaf=(function(){
	function TerrainLeaf(){
		this._boundingSphere=null;
		this._boundingBox=null;
		this._sizeOfY=null;
		this._currentLODLevel=0;
		this._lastDistanceToEye=NaN;
		this._originalBoundingSphere=null;
		this._originalBoundingBox=null;
		this._originalBoundingBoxCorners=null;
		this._bUseStrip=false;
		this._gridSize=NaN;
		this._beginGridX=0;
		//针对整个大地形的偏移
		this._beginGridZ=0;
		//针对整个大地形的偏移
		this._LODError=null;
		TerrainLeaf.__init__();
		this._currentLODLevel=0;
	}

	__class(TerrainLeaf,'laya.d3.terrain.TerrainLeaf');
	var __proto=TerrainLeaf.prototype;
	__proto.calcVertextNorml=function(x,z,terrainHeightData,heighDataWidth,heightDataHeight,normal){
		var dZ=0,dX=0;
		dX=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dZ=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		normal.x=-dX;
		normal.y=6;
		normal.z=-dZ;
		Vector3.normalize(normal,normal);
	}

	__proto.calcVertextNormlUV=function(x,z,terrainWidth,terrainHeight,normal){
		normal.x=x / terrainWidth;
		normal.y=z / terrainHeight;
		normal.z=z / terrainHeight;
	}

	__proto.calcVertextBuffer=function(offsetChunkX,offsetChunkZ,beginX,beginZ,girdSize,vertextBuffer,offset,strideSize,terrainHeightData,heighDataWidth,heightDataHeight,cameraCoordinateInverse){
		if (cameraCoordinateInverse==true && !TerrainLeaf.__ADAPT_MATRIX__){
			TerrainLeaf.__ADAPT_MATRIX__=new Matrix4x4();
			var mat=new Matrix4x4();
			Matrix4x4.createRotationY(Math.PI,TerrainLeaf.__ADAPT_MATRIX__);
			Matrix4x4.createTranslate(new Vector3(0,0,(heightDataHeight-1)*girdSize),mat);
			Matrix4x4.multiply(mat,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__ADAPT_MATRIX__);
			TerrainLeaf.__ADAPT_MATRIX_INV__=new Matrix4x4();
			TerrainLeaf.__ADAPT_MATRIX__.invert(TerrainLeaf.__ADAPT_MATRIX_INV__);
		}
		this._gridSize=girdSize;
		this._beginGridX=offsetChunkX *TerrainLeaf.CHUNK_GRID_NUM+beginX;
		this._beginGridZ=offsetChunkZ *TerrainLeaf.CHUNK_GRID_NUM+beginZ;
		var nNum=offset *strideSize;
		var minY=2147483647;
		var maxY=-2147483648;
		var normal=new Vector3();
		for (var i=0,s=TerrainLeaf.LEAF_GRID_NUM+1;i < s;i++){
			for (var j=0,s1=TerrainLeaf.LEAF_GRID_NUM+1;j < s1;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+j)*this._gridSize;
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+i)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=terrainHeightData[(this._beginGridZ+i)*(heighDataWidth)+(this._beginGridX+j)];
				minY=TerrainLeaf.__VECTOR3__.y < minY ? TerrainLeaf.__VECTOR3__.y :minY;
				maxY=TerrainLeaf.__VECTOR3__.y > maxY ? TerrainLeaf.__VECTOR3__.y :maxY;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				this.calcVertextNormlUV(this._beginGridX+j,this._beginGridZ+i,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+i)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=this._beginGridX+j;
				nNum++;
				vertextBuffer[nNum]=this._beginGridZ+i;
				nNum++;
			}
		}
		this._sizeOfY=new Vector2(minY-1,maxY+1);
		this.calcLODErrors(terrainHeightData,heighDataWidth,heightDataHeight);
		this.calcOriginalBoudingBoxAndSphere();
	}

	__proto.calcSkirtVertextBuffer=function(offsetChunkX,offsetChunkZ,beginX,beginZ,girdSize,vertextBuffer,offset,strideSize,terrainHeightData,heighDataWidth,heightDataHeight){
		this._gridSize=girdSize;
		this._beginGridX=offsetChunkX *TerrainLeaf.CHUNK_GRID_NUM+beginX;
		this._beginGridZ=offsetChunkZ *TerrainLeaf.CHUNK_GRID_NUM+beginZ;
		var nNum=offset *strideSize;
		var i=0,j=0,s=TerrainLeaf.LEAF_GRID_NUM+1;
		var normal=new Vector3();
		var hZIndex=0;
		var hXIndex=0;
		var h=0;
		var zh=0;
		var xh=0;
		for (i=0;i < 2;i++){
			for (j=0;j < s;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+j)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=(i==1 ? terrainHeightData[this._beginGridZ *heighDataWidth+(this._beginGridX+j)] :-this._gridSize);
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+0)*this._gridSize;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				if (i==0){
					hZIndex=(this._beginGridZ-1);
					}else {
					hZIndex=this._beginGridZ;
				}
				this.calcVertextNormlUV(this._beginGridX+j,hZIndex,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+0)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=this._beginGridX+j;
				nNum++;
				vertextBuffer[nNum]=hZIndex;
				nNum++;
			}
		}
		for (i=0;i < 2;i++){
			for (j=0;j < s;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+j)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=(i==0 ? terrainHeightData[(this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM)*(heighDataWidth)+(this._beginGridX+j)] :-this._gridSize);
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM)*this._gridSize;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				if (i==0){
					hZIndex=this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM;
					}else {
					hZIndex=(this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM+1);
				}
				this.calcVertextNormlUV(this._beginGridX+j,hZIndex,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+TerrainLeaf.LEAF_GRID_NUM)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=this._beginGridX+j;
				nNum++;
				vertextBuffer[nNum]=hZIndex;
				nNum++;
			}
		}
		for (i=0;i < 2;i++){
			for (j=0;j < s;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+0)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=(i==0 ? terrainHeightData[(this._beginGridZ+j)*(heighDataWidth)+(this._beginGridX+0)] :-this._gridSize);
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+j)*this._gridSize;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				if (i==0){
					hXIndex=this._beginGridX;
					}else {
					hXIndex=(this._beginGridX-1);
				}
				this.calcVertextNormlUV(hXIndex,this._beginGridZ+j,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+0)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=hXIndex;
				nNum++;
				vertextBuffer[nNum]=this._beginGridZ+j;
				nNum++;
			}
		}
		for (i=0;i < 2;i++){
			for (j=0;j < s;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+TerrainLeaf.LEAF_GRID_NUM)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=(i==1 ? terrainHeightData[(this._beginGridZ+j)*(heighDataWidth)+(this._beginGridX+TerrainLeaf.LEAF_GRID_NUM)] :-this._gridSize);
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+j)*this._gridSize;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				if (i==0){
					hXIndex=this._beginGridX+TerrainLeaf.LEAF_GRID_NUM+1;
					}else {
					hXIndex=this._beginGridX+TerrainLeaf.LEAF_GRID_NUM;
				}
				this.calcVertextNormlUV(hXIndex,this._beginGridZ+j,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+TerrainLeaf.LEAF_GRID_NUM)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=hXIndex;
				nNum++;
				vertextBuffer[nNum]=this._beginGridZ+j;
				nNum++;
			}
		}
	}

	__proto.calcOriginalBoudingBoxAndSphere=function(){
		var min=new Vector3(this._beginGridX *this._gridSize,this._sizeOfY.x,this._beginGridZ *this._gridSize);
		var max=new Vector3((this._beginGridX+TerrainLeaf.LEAF_GRID_NUM)*this._gridSize,this._sizeOfY.y,(this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM)*this._gridSize);
		if (TerrainLeaf.__ADAPT_MATRIX__){
			Vector3.transformV3ToV3(min,TerrainLeaf.__ADAPT_MATRIX__,min);
			Vector3.transformV3ToV3(max,TerrainLeaf.__ADAPT_MATRIX__,max);
		}
		this._originalBoundingBox=new BoundBox(min,max);
		var size=new Vector3();
		Vector3.subtract(max,min,size);
		Vector3.scale(size,0.5,size);
		var center=new Vector3();
		Vector3.add(min,size,center);
		this._originalBoundingSphere=new BoundSphere(center,Vector3.scalarLength(size));
		this._originalBoundingBoxCorners=__newvec(8,null);
		this._originalBoundingBox.getCorners(this._originalBoundingBoxCorners);
		this._boundingBox=new BoundBox(new Vector3(-0.5,-0.5,-0.5),new Vector3(0.5,0.5,0.5));
		this._boundingSphere=new BoundSphere(new Vector3(0,0,0),1);
	}

	__proto.calcLeafBoudingBox=function(worldMatrix){
		for (var i=0;i < 8;i++){
			Vector3.transformCoordinate(this._originalBoundingBoxCorners[i],worldMatrix,BaseRender._tempBoundBoxCorners[i]);
		}
		BoundBox.createfromPoints(BaseRender._tempBoundBoxCorners,this._boundingBox);
	}

	__proto.calcLeafBoudingSphere=function(worldMatrix,maxScale){
		Vector3.transformCoordinate(this._originalBoundingSphere.center,worldMatrix,this._boundingSphere.center);
		this._boundingSphere.radius=this._originalBoundingSphere.radius *maxScale;
	}

	__proto.calcLODErrors=function(terrainHeightData,heighDataWidth,heightDataHeight){
		this._LODError=new Float32Array(TerrainLeaf._maxLODLevel+1);
		var step=1;
		for (var i=0,n=TerrainLeaf._maxLODLevel+1;i < n;i++){
			var maxError=0;
			for (var y=0,n1=TerrainLeaf.LEAF_GRID_NUM;y < n1;y+=step){
				for (var x=0,n2=TerrainLeaf.LEAF_GRID_NUM;x < n2;x+=step){
					var z00=terrainHeightData[(this._beginGridZ+y)*heighDataWidth+(this._beginGridX+x)];
					var z10=terrainHeightData[(this._beginGridZ+y)*heighDataWidth+(this._beginGridX+x)+step];
					var z01=terrainHeightData[(this._beginGridZ+y+step)*heighDataWidth+(this._beginGridX+x)];
					var z11=terrainHeightData[(this._beginGridZ+y+step)*heighDataWidth+(this._beginGridX+x)+step];
					for (var j=0;j < step;j++){
						var ys=j / step;
						for (var k=0;k < step;k++){
							var xs=k / step;
							var z=terrainHeightData[(this._beginGridZ+y+j)*heighDataWidth+(this._beginGridX+x)+k];
							var iz=(xs+ys <=1)? (z00+(z10-z00)*xs+(z01-z00)*ys):(z11+(z01-z11)*(1-xs)+(z10-z11)*(1-ys));
							var error=Math.abs(iz-z);
							maxError=Math.max(maxError,error);
						}
					}
				}
			}
			step *=2;
			this._LODError[i]=maxError;
		}
	}

	__proto.determineLod=function(eyePos,perspectiveFactor,tolerance,tolerAndPerspectiveChanged){
		var nDistanceToEye=Vector3.distance(eyePos,this._boundingSphere.center);
		var n=TerrainLeaf._maxLODLevel;
		if (!tolerAndPerspectiveChanged){
			if (this._lastDistanceToEye==nDistanceToEye){
				return this._currentLODLevel;
				}else if (this._lastDistanceToEye > nDistanceToEye){
				n=this._currentLODLevel;
			}
		}
		for (var i=n;i >=1;i--){
			if (Terrain.LOD_DISTANCE_FACTOR *this._LODError[i] / nDistanceToEye *perspectiveFactor < tolerance){
				this._currentLODLevel=i;
				break ;
			}
		}
		this._lastDistanceToEye=nDistanceToEye;
		return this._currentLODLevel;
	}

	TerrainLeaf.__init__=function(){
		if (!TerrainLeaf._bInit){
			var nLeafNum=(TerrainLeaf.CHUNK_GRID_NUM / TerrainLeaf.LEAF_GRID_NUM)*(TerrainLeaf.CHUNK_GRID_NUM / TerrainLeaf.LEAF_GRID_NUM);
			TerrainLeaf._planeLODIndex=__newvec(nLeafNum);
			var i=0,j=0,k=0,n=0,n1=0,nOffset=0;
			var nOriginIndexArray=null,nTempIndex=null;
			for (i=0;i < nLeafNum;i++){
				TerrainLeaf._planeLODIndex[i]=new Array(TerrainLeaf._maxLODLevel+1);
			}
			for (i=0,n=TerrainLeaf._maxLODLevel+1;i < n;i++){
				TerrainLeaf._planeLODIndex[0][i]=TerrainLeaf.calcPlaneLODIndex(i);
			}
			for (i=1;i < nLeafNum;i++){
				nOffset=i *TerrainLeaf.LEAF_PLANE_VERTEXT_COUNT;
				for (j=0,n1=TerrainLeaf._maxLODLevel+1;j < n1;j++){
					nOriginIndexArray=TerrainLeaf._planeLODIndex[0][j];
					nTempIndex=new Uint16Array(nOriginIndexArray.length);
					for (k=0;k < nOriginIndexArray.length;k++){
						nTempIndex[k]=nOriginIndexArray[k]+nOffset;
					}
					TerrainLeaf._planeLODIndex[i][j]=nTempIndex;
				}
			}
			TerrainLeaf._skirtLODIndex=__newvec(nLeafNum);
			for (i=0;i < nLeafNum;i++){
				TerrainLeaf._skirtLODIndex[i]=new Array(TerrainLeaf._maxLODLevel+1);
			}
			for (i=0,n=TerrainLeaf._maxLODLevel+1;i < n;i++){
				TerrainLeaf._skirtLODIndex[0][i]=TerrainLeaf.calcSkirtLODIndex(i);
			}
			for (i=1;i < nLeafNum;i++){
				nOffset=i *TerrainLeaf.LEAF_SKIRT_VERTEXT_COUNT;
				for (j=0,n1=TerrainLeaf._maxLODLevel+1;j < n1;j++){
					nOriginIndexArray=TerrainLeaf._skirtLODIndex[0][j];
					nTempIndex=new Uint16Array(nOriginIndexArray.length);
					for (k=0;k < nOriginIndexArray.length;k++){
						nTempIndex[k]=nOriginIndexArray[k]+nOffset;
					}
					TerrainLeaf._skirtLODIndex[i][j]=nTempIndex;
				}
			}
			TerrainLeaf._bInit=true;
		}
	}

	TerrainLeaf.getPlaneLODIndex=function(leafIndex,LODLevel){
		return TerrainLeaf._planeLODIndex[leafIndex][LODLevel];
	}

	TerrainLeaf.getSkirtLODIndex=function(leafIndex,LODLevel){
		return TerrainLeaf._skirtLODIndex[leafIndex][LODLevel];
	}

	TerrainLeaf.calcPlaneLODIndex=function(level){
		if (level > TerrainLeaf._maxLODLevel)level=TerrainLeaf._maxLODLevel;
		var nGridNumAddOne=TerrainLeaf.LEAF_GRID_NUM+1;
		var nNum=0;
		var indexBuffer=null;
		var nLODGridNum=laya.d3.terrain.TerrainLeaf.LEAF_GRID_NUM / Math.pow(2,level);
		indexBuffer=new Uint16Array(nLODGridNum *nLODGridNum *6);
		var nGridSpace=laya.d3.terrain.TerrainLeaf.LEAF_GRID_NUM / nLODGridNum;
		for (var i=0;i < TerrainLeaf.LEAF_GRID_NUM;i+=nGridSpace){
			for (var j=0;j < TerrainLeaf.LEAF_GRID_NUM;j+=nGridSpace){
				indexBuffer[nNum]=(i+nGridSpace)*nGridNumAddOne+j;
				nNum++;
				indexBuffer[nNum]=i *nGridNumAddOne+j;
				nNum++;
				indexBuffer[nNum]=i *nGridNumAddOne+j+nGridSpace;
				nNum++;
				indexBuffer[nNum]=i *nGridNumAddOne+j+nGridSpace;
				nNum++;
				indexBuffer[nNum]=(i+nGridSpace)*nGridNumAddOne+j+nGridSpace;
				nNum++;
				indexBuffer[nNum]=(i+nGridSpace)*nGridNumAddOne+j;
				nNum++;
			}
		}
		return indexBuffer;
	}

	TerrainLeaf.calcSkirtLODIndex=function(level){
		if (level > TerrainLeaf._maxLODLevel)level=TerrainLeaf._maxLODLevel;
		var nSkirtIndexOffset=(TerrainLeaf.CHUNK_GRID_NUM / TerrainLeaf.LEAF_GRID_NUM)*(TerrainLeaf.CHUNK_GRID_NUM / TerrainLeaf.LEAF_GRID_NUM)*TerrainLeaf.LEAF_PLANE_VERTEXT_COUNT;
		var nGridNumAddOne=TerrainLeaf.LEAF_GRID_NUM+1;
		var nNum=0;
		var indexBuffer=null;
		var nLODGridNum=laya.d3.terrain.TerrainLeaf.LEAF_GRID_NUM / Math.pow(2,level);
		indexBuffer=new Uint16Array(nLODGridNum *4 *6);
		var nGridSpace=laya.d3.terrain.TerrainLeaf.LEAF_GRID_NUM / nLODGridNum;
		for (var j=0;j < 4;j++){
			for (var i=0;i < TerrainLeaf.LEAF_GRID_NUM;i+=nGridSpace){
				indexBuffer[nNum]=nSkirtIndexOffset+nGridNumAddOne+i;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+i;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+i+nGridSpace;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+i+nGridSpace;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+nGridNumAddOne+i+nGridSpace;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+nGridNumAddOne+i;
				nNum++;
			}
			nSkirtIndexOffset+=nGridNumAddOne *2;
		}
		return indexBuffer;
	}

	TerrainLeaf.getHeightFromTerrainHeightData=function(x,z,terrainHeightData,heighDataWidth,heightDataHeight){
		x=x < 0 ? 0 :x;
		x=(x >=heighDataWidth)? heighDataWidth-1 :x;
		z=z < 0 ? 0 :z;
		z=(z >=heightDataHeight)? heightDataHeight-1 :z;
		return terrainHeightData[z *heighDataWidth+x];
	}

	TerrainLeaf.CHUNK_GRID_NUM=64;
	TerrainLeaf.LEAF_GRID_NUM=32;
	TerrainLeaf.__ADAPT_MATRIX__=null;
	TerrainLeaf.__ADAPT_MATRIX_INV__=null;
	TerrainLeaf._planeLODIndex=null;
	TerrainLeaf._skirtLODIndex=null;
	TerrainLeaf._bInit=false;
	__static(TerrainLeaf,
	['LEAF_PLANE_VERTEXT_COUNT',function(){return this.LEAF_PLANE_VERTEXT_COUNT=(TerrainLeaf.LEAF_GRID_NUM+1)*(TerrainLeaf.LEAF_GRID_NUM+1);},'LEAF_SKIRT_VERTEXT_COUNT',function(){return this.LEAF_SKIRT_VERTEXT_COUNT=(TerrainLeaf.LEAF_GRID_NUM+1)*2 *4;},'LEAF_VERTEXT_COUNT',function(){return this.LEAF_VERTEXT_COUNT=TerrainLeaf.LEAF_PLANE_VERTEXT_COUNT+TerrainLeaf.LEAF_SKIRT_VERTEXT_COUNT;},'LEAF_PLANE_MAX_INDEX_COUNT',function(){return this.LEAF_PLANE_MAX_INDEX_COUNT=TerrainLeaf.LEAF_GRID_NUM *TerrainLeaf.LEAF_GRID_NUM *6;},'LEAF_SKIRT_MAX_INDEX_COUNT',function(){return this.LEAF_SKIRT_MAX_INDEX_COUNT=TerrainLeaf.LEAF_GRID_NUM *4 *6;},'LEAF_MAX_INDEX_COUNT',function(){return this.LEAF_MAX_INDEX_COUNT=TerrainLeaf.LEAF_PLANE_MAX_INDEX_COUNT+TerrainLeaf.LEAF_SKIRT_MAX_INDEX_COUNT;},'__VECTOR3__',function(){return this.__VECTOR3__=new Vector3();},'_maxLODLevel',function(){return this._maxLODLevel=/*__JS__ */Math.log2(TerrainLeaf.LEAF_GRID_NUM);}
	]);
	return TerrainLeaf;
})()


/**
*<code>DetailTextureInfo</code> 类用于描述地形细节纹理。
*/
//class laya.d3.terrain.unit.ChunkInfo
var ChunkInfo=(function(){
	function ChunkInfo(){
		this.alphaMap=null;
		this.detailID=null;
		this.normalMap=null;
		;
	}

	__class(ChunkInfo,'laya.d3.terrain.unit.ChunkInfo');
	return ChunkInfo;
})()


/**
*<code>DetailTextureInfo</code> 类用于描述地形细节纹理。
*/
//class laya.d3.terrain.unit.DetailTextureInfo
var DetailTextureInfo=(function(){
	function DetailTextureInfo(){
		this.diffuseTexture=null;
		this.normalTexture=null;
		this.scale=null;
		this.offset=null;
		;
	}

	__class(DetailTextureInfo,'laya.d3.terrain.unit.DetailTextureInfo');
	return DetailTextureInfo;
})()


/**
*<code>MaterialInfo</code> 类用于描述地形材质信息。
*/
//class laya.d3.terrain.unit.MaterialInfo
var MaterialInfo=(function(){
	function MaterialInfo(){
		this.ambientColor=null;
		this.diffuseColor=null;
		this.specularColor=null;
		;
	}

	__class(MaterialInfo,'laya.d3.terrain.unit.MaterialInfo');
	return MaterialInfo;
})()


/**
*<code>Physics</code> 类用于简单物理检测。
*/
//class laya.d3.utils.Physics
var Physics=(function(){
	/**
	*创建一个 <code>Physics</code> 实例。
	*/
	function Physics(){}
	__class(Physics,'laya.d3.utils.Physics');
	Physics.__init__=function(){
		var maxCount=/*laya.d3.core.Layer.maxCount*/31;
		Physics._layerCollsionMatrix.length=maxCount;
		for (var i=0;i < maxCount;i++){
			var collArray=[];
			var count=maxCount-i;
			collArray.length=count;
			for (var j=0;j < count;j++)
			if (j===count-1)
				collArray[j]=true;
			else
			collArray[j]=false;
			Physics._layerCollsionMatrix[i]=collArray;
		}
	}

	Physics.setLayerCollision=function(layer1,layer2,collison){
		Physics._layerCollsionMatrix[layer1.number][(/*laya.d3.core.Layer.maxCount*/31-1)-layer2.number]=collison;
	}

	Physics.getLayerCollision=function(layer1,layer2){
		return Physics._layerCollsionMatrix[layer1.number][(/*laya.d3.core.Layer.maxCount*/31-1)-layer2.number];
	}

	Physics.setColliderCollision=function(collider1,collider2,collsion){
		if (collsion){
			delete collider1._ignoreCollisonMap[collider2.id];
			delete collider2._ignoreCollisonMap[collider1.id];
			}else {
			collider1._ignoreCollisonMap[collider2.id]=collider2;
			collider2._ignoreCollisonMap[collider1.id]=collider1;
		}
	}

	Physics.getIColliderCollision=function(collider1,collider2){
		return collider1._ignoreCollisonMap[collider2.id] ? true :false;
	}

	Physics.rayCast=function(ray,outHitInfo,distance,layer){
		(distance===void 0)&& (distance=1.79e+308);
		(layer===void 0)&& (layer=0);
		Physics._outHitAllInfo.length=0;
		var colliders=Layer.getLayerByNumber(layer)._colliders;
		for (var i=0,n=colliders.length;i < n;i++){
			var collider=colliders[i];
			if (collider.enable){
				collider.raycast(ray,Physics._outHitInfo,distance);
				if (Physics._outHitInfo.distance!==-1 && Physics._outHitInfo.distance <=distance){
					var outHit=new RaycastHit();
					Physics._outHitInfo.cloneTo(outHit);
					Physics._outHitAllInfo.push(outHit);
				}
			}
		}
		if (Physics._outHitAllInfo.length==0){
			outHitInfo.sprite3D=null;
			outHitInfo.distance=-1;
			return;
		};
		var minDistance=Number.MAX_VALUE;
		var minIndex=0;
		for (var j=0;j < Physics._outHitAllInfo.length;j++){
			if (Physics._outHitAllInfo[j].distance < minDistance){
				minDistance=Physics._outHitAllInfo[j].distance;
				minIndex=j;
			}
		}
		Physics._outHitAllInfo[minIndex].cloneTo(outHitInfo);
	}

	Physics.rayCastAll=function(ray,outHitAllInfo,distance,layer){
		(distance===void 0)&& (distance=1.79e+308);
		(layer===void 0)&& (layer=0);
		outHitAllInfo.length=0;
		var colliders=Layer.getLayerByNumber(layer)._colliders;
		for (var i=0,n=colliders.length;i < n;i++){
			var collider=colliders[i];
			if (collider.enable){
				Physics._outHitInfo.distance=-1;
				Physics._outHitInfo.sprite3D=null;
				collider.raycast(ray,Physics._outHitInfo,distance);
				if (Physics._outHitInfo.distance!==-1 && Physics._outHitInfo.distance <=distance){
					var outHit=new RaycastHit();
					Physics._outHitInfo.cloneTo(outHit);
					outHitAllInfo.push(outHit);
				}
			}
		}
	}

	Physics._outHitAllInfo=[];
	Physics._layerCollsionMatrix=[];
	__static(Physics,
	['_outHitInfo',function(){return this._outHitInfo=new RaycastHit();},'collisionManager',function(){return this.collisionManager=new CollisionManager();},'gravity',function(){return this.gravity=new Vector3(0,-9.81,0);}
	]);
	return Physics;
})()


/**
*<code>Picker</code> 类用于创建拾取。
*/
//class laya.d3.utils.Picker
var Picker=(function(){
	/**
	*创建一个 <code>Picker</code> 实例。
	*/
	function Picker(){}
	__class(Picker,'laya.d3.utils.Picker');
	Picker.calculateCursorRay=function(point,viewPort,projectionMatrix,viewMatrix,world,out){
		var x=point.elements[0];
		var y=point.elements[1];
		var nearSource=Picker._tempVector30;
		var nerSourceE=nearSource.elements;
		nerSourceE[0]=x;
		nerSourceE[1]=y;
		nerSourceE[2]=viewPort.minDepth;
		var farSource=Picker._tempVector31;
		var farSourceE=farSource.elements;
		farSourceE[0]=x;
		farSourceE[1]=y;
		farSourceE[2]=viewPort.maxDepth;
		var nearPoint=out.origin;
		var farPoint=Picker._tempVector32;
		viewPort.unprojectFromWVP(nearSource,projectionMatrix,viewMatrix,world,nearPoint);
		viewPort.unprojectFromWVP(farSource,projectionMatrix,viewMatrix,world,farPoint);
		var outDire=out.direction.elements;
		outDire[0]=farPoint.x-nearPoint.x;
		outDire[1]=farPoint.y-nearPoint.y;
		outDire[2]=farPoint.z-nearPoint.z;
		Vector3.normalize(out.direction,out.direction);
	}

	Picker.rayIntersectsPositionsAndIndices=function(ray,vertexDatas,vertexDeclaration,indices,outHitInfo){
		var vertexStrideFloatCount=vertexDeclaration.vertexStride / 4;
		var positionVertexElementOffset=vertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.VertexElementUsage.POSITION0*/0).offset / 4;
		var closestIntersection=Number.MAX_VALUE;
		var closestTriangleVertexIndex1=-1;
		var closestTriangleVertexIndex2=-1;
		var closestTriangleVertexIndex3=-1;
		for (var j=0;j < indices.length;j+=3){
			var vertex1=Picker._tempVector35;
			var vertex1E=vertex1.elements;
			var vertex1Index=indices[j] *vertexStrideFloatCount;
			var vertex1PositionIndex=vertex1Index+positionVertexElementOffset;
			vertex1E[0]=vertexDatas[vertex1PositionIndex];
			vertex1E[1]=vertexDatas[vertex1PositionIndex+1];
			vertex1E[2]=vertexDatas[vertex1PositionIndex+2];
			var vertex2=Picker._tempVector36;
			var vertex2E=vertex2.elements;
			var vertex2Index=indices[j+1] *vertexStrideFloatCount;
			var vertex2PositionIndex=vertex2Index+positionVertexElementOffset;
			vertex2E[0]=vertexDatas[vertex2PositionIndex];
			vertex2E[1]=vertexDatas[vertex2PositionIndex+1];
			vertex2E[2]=vertexDatas[vertex2PositionIndex+2];
			var vertex3=Picker._tempVector37;
			var vertex3E=vertex3.elements;
			var vertex3Index=indices[j+2] *vertexStrideFloatCount;
			var vertex3PositionIndex=vertex3Index+positionVertexElementOffset;
			vertex3E[0]=vertexDatas[vertex3PositionIndex];
			vertex3E[1]=vertexDatas[vertex3PositionIndex+1];
			vertex3E[2]=vertexDatas[vertex3PositionIndex+2];
			var intersection=laya.d3.utils.Picker.rayIntersectsTriangle(ray,vertex1,vertex2,vertex3);
			if (!isNaN(intersection)&& intersection < closestIntersection){
				closestIntersection=intersection;
				closestTriangleVertexIndex1=vertex1Index;
				closestTriangleVertexIndex2=vertex2Index;
				closestTriangleVertexIndex3=vertex3Index;
			}
		}
		if (closestIntersection!==Number.MAX_VALUE){
			outHitInfo.distance=closestIntersection;
			Vector3.scale(ray.direction,closestIntersection,outHitInfo.position);
			Vector3.add(ray.origin,outHitInfo.position,outHitInfo.position);
			var trianglePositions=outHitInfo.trianglePositions;
			var position0=trianglePositions[0];
			var position1=trianglePositions[1];
			var position2=trianglePositions[2];
			var position0E=position0.elements;
			var position1E=position1.elements;
			var position2E=position2.elements;
			var closestVertex1PositionIndex=closestTriangleVertexIndex1+positionVertexElementOffset;
			position0E[0]=vertexDatas[closestVertex1PositionIndex];
			position0E[1]=vertexDatas[closestVertex1PositionIndex+1];
			position0E[2]=vertexDatas[closestVertex1PositionIndex+2];
			var closestVertex2PositionIndex=closestTriangleVertexIndex2+positionVertexElementOffset;
			position1E[0]=vertexDatas[closestVertex2PositionIndex];
			position1E[1]=vertexDatas[closestVertex2PositionIndex+1];
			position1E[2]=vertexDatas[closestVertex2PositionIndex+2];
			var closestVertex3PositionIndex=closestTriangleVertexIndex3+positionVertexElementOffset;
			position2E[0]=vertexDatas[closestVertex3PositionIndex];
			position2E[1]=vertexDatas[closestVertex3PositionIndex+1];
			position2E[2]=vertexDatas[closestVertex3PositionIndex+2];
			var normalVertexElement=vertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.VertexElementUsage.NORMAL0*/3);
			if (normalVertexElement){
				var normalVertexElementOffset=normalVertexElement.offset / 4;
				var triangleNormals=outHitInfo.triangleNormals;
				var normal0=triangleNormals[0];
				var normal1=triangleNormals[1];
				var normal2=triangleNormals[2];
				var normal0E=normal0.elements;
				var normal1E=normal1.elements;
				var normal2E=normal2.elements;
				var closestVertex1NormalIndex=closestTriangleVertexIndex1+normalVertexElementOffset;
				normal0E[0]=vertexDatas[closestVertex1NormalIndex];
				normal0E[1]=vertexDatas[closestVertex1NormalIndex+1];
				normal0E[2]=vertexDatas[closestVertex1NormalIndex+2];
				var closestVertex2NormalIndex=closestTriangleVertexIndex2+normalVertexElementOffset;
				normal1E[0]=vertexDatas[closestVertex2NormalIndex];
				normal1E[1]=vertexDatas[closestVertex2NormalIndex+1];
				normal1E[2]=vertexDatas[closestVertex2NormalIndex+2];
				var closestVertex3NormalIndex=closestTriangleVertexIndex3+normalVertexElementOffset;
				normal2E[0]=vertexDatas[closestVertex3NormalIndex];
				normal2E[1]=vertexDatas[closestVertex3NormalIndex+1];
				normal2E[2]=vertexDatas[closestVertex3NormalIndex+2];
			}
			return true;
			}else {
			outHitInfo.position.toDefault();
			outHitInfo.distance=Number.MAX_VALUE;
			outHitInfo.trianglePositions[0].toDefault();
			outHitInfo.trianglePositions[1].toDefault();
			outHitInfo.trianglePositions[2].toDefault();
			outHitInfo.triangleNormals[0].toDefault();
			outHitInfo.triangleNormals[1].toDefault();
			outHitInfo.triangleNormals[2].toDefault();
			return false;
		}
	}

	Picker.rayIntersectsTriangle=function(ray,vertex1,vertex2,vertex3){
		var result;
		var edge1=Picker._tempVector30,edge2=Picker._tempVector31;
		Vector3.subtract(vertex2,vertex1,edge1);
		Vector3.subtract(vertex3,vertex1,edge2);
		var directionCrossEdge2=Picker._tempVector32;
		Vector3.cross(ray.direction,edge2,directionCrossEdge2);
		var determinant;
		determinant=Vector3.dot(edge1,directionCrossEdge2);
		if (determinant >-Number.MIN_VALUE && determinant < Number.MIN_VALUE){
			result=Number.NaN;
			return result;
		};
		var inverseDeterminant=1.0 / determinant;
		var distanceVector=Picker._tempVector33;
		Vector3.subtract(ray.origin,vertex1,distanceVector);
		var triangleU;
		triangleU=Vector3.dot(distanceVector,directionCrossEdge2);
		triangleU *=inverseDeterminant;
		if (triangleU < 0 || triangleU > 1){
			result=Number.NaN;
			return result;
		};
		var distanceCrossEdge1=Picker._tempVector34;
		Vector3.cross(distanceVector,edge1,distanceCrossEdge1);
		var triangleV;
		triangleV=Vector3.dot(ray.direction,distanceCrossEdge1);
		triangleV *=inverseDeterminant;
		if (triangleV < 0 || triangleU+triangleV > 1){
			result=Number.NaN;
			return result;
		};
		var rayDistance;
		rayDistance=Vector3.dot(edge2,distanceCrossEdge1);
		rayDistance *=inverseDeterminant;
		if (rayDistance < 0){
			result=Number.NaN;
			return result;
		}
		result=rayDistance;
		return result;
	}

	__static(Picker,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempVector31',function(){return this._tempVector31=new Vector3();},'_tempVector32',function(){return this._tempVector32=new Vector3();},'_tempVector33',function(){return this._tempVector33=new Vector3();},'_tempVector34',function(){return this._tempVector34=new Vector3();},'_tempVector35',function(){return this._tempVector35=new Vector3();},'_tempVector36',function(){return this._tempVector36=new Vector3();},'_tempVector37',function(){return this._tempVector37=new Vector3();}
	]);
	return Picker;
})()


/**
*...
*@author ...
*/
//class laya.d3.utils.RaycastHit
var RaycastHit=(function(){
	function RaycastHit(){
		this.distance=NaN;
		this.trianglePositions=null;
		this.triangleNormals=null;
		this.position=null;
		this.sprite3D=null;
		this.distance=-1;
		this.trianglePositions=[new Vector3(),new Vector3(),new Vector3()];
		this.trianglePositions.length=3;
		this.triangleNormals=[new Vector3(),new Vector3(),new Vector3()];
		this.triangleNormals.length=3;
		this.position=new Vector3();
	}

	__class(RaycastHit,'laya.d3.utils.RaycastHit');
	var __proto=RaycastHit.prototype;
	__proto.cloneTo=function(dec){
		dec.distance=this.distance;
		this.trianglePositions[0].cloneTo(dec.trianglePositions[0]);
		this.trianglePositions[1].cloneTo(dec.trianglePositions[1]);
		this.trianglePositions[2].cloneTo(dec.trianglePositions[2]);
		this.triangleNormals[0].cloneTo(dec.triangleNormals[0]);
		this.triangleNormals[1].cloneTo(dec.triangleNormals[1]);
		this.triangleNormals[2].cloneTo(dec.triangleNormals[2]);
		this.position.cloneTo(dec.position);
		dec.sprite3D=this.sprite3D;
	}

	return RaycastHit;
})()


//class laya.d3.utils.Size
var Size=(function(){
	function Size(width,height){
		this._width=0;
		this._height=0;
		this._width=width;
		this._height=height;
	}

	__class(Size,'laya.d3.utils.Size');
	var __proto=Size.prototype;
	__getset(0,__proto,'width',function(){
		if (this._width===-1)
			return RenderState.clientWidth;
		return this._width;
	});

	__getset(0,__proto,'height',function(){
		if (this._height===-1)
			return RenderState.clientHeight;
		return this._height;
	});

	__getset(1,Size,'fullScreen',function(){
		return new Size(-1,-1);
	});

	return Size;
})()


/**
*<code>Utils3D</code> 类用于创建3D工具。
*/
//class laya.d3.utils.Utils3D
var Utils3D=(function(){
	function Utils3D(){}
	__class(Utils3D,'laya.d3.utils.Utils3D');
	Utils3D._rotationTransformScaleSkinAnimation=function(tx,ty,tz,qx,qy,qz,qw,sx,sy,sz,outArray,outOffset){
		var re=Utils3D._tempArray16_0;
		var se=Utils3D._tempArray16_1;
		var tse=Utils3D._tempArray16_2;
		var x2=qx+qx;
		var y2=qy+qy;
		var z2=qz+qz;
		var xx=qx *x2;
		var yx=qy *x2;
		var yy=qy *y2;
		var zx=qz *x2;
		var zy=qz *y2;
		var zz=qz *z2;
		var wx=qw *x2;
		var wy=qw *y2;
		var wz=qw *z2;
		re[15]=1;
		re[0]=1-yy-zz;
		re[1]=yx+wz;
		re[2]=zx-wy;
		re[4]=yx-wz;
		re[5]=1-xx-zz;
		re[6]=zy+wx;
		re[8]=zx+wy;
		re[9]=zy-wx;
		re[10]=1-xx-yy;
		se[15]=1;
		se[0]=sx;
		se[5]=sy;
		se[10]=sz;
		var i,a,b,e,ai0,ai1,ai2,ai3;
		for (i=0;i < 4;i++){
			ai0=re[i];
			ai1=re[i+4];
			ai2=re[i+8];
			ai3=re[i+12];
			tse[i]=ai0;
			tse[i+4]=ai1;
			tse[i+8]=ai2;
			tse[i+12]=ai0 *tx+ai1 *ty+ai2 *tz+ai3;
		}
		for (i=0;i < 4;i++){
			ai0=tse[i];
			ai1=tse[i+4];
			ai2=tse[i+8];
			ai3=tse[i+12];
			outArray[i+outOffset]=ai0 *se[0]+ai1 *se[1]+ai2 *se[2]+ai3 *se[3];
			outArray[i+outOffset+4]=ai0 *se[4]+ai1 *se[5]+ai2 *se[6]+ai3 *se[7];
			outArray[i+outOffset+8]=ai0 *se[8]+ai1 *se[9]+ai2 *se[10]+ai3 *se[11];
			outArray[i+outOffset+12]=ai0 *se[12]+ai1 *se[13]+ai2 *se[14]+ai3 *se[15];
		}
	}

	Utils3D._createNodeByJson=function(rootNode,nodeData,node,innerResouMap){
		if (!node){
			switch (nodeData.type){
				case "Sprite3D":
					node=new Sprite3D();
					break ;
				case "MeshSprite3D":
					node=new MeshSprite3D();
					break ;
				case "SkinnedMeshSprite3D":
					node=new SkinnedMeshSprite3D();
					break ;
				case "ShuriKenParticle3D":
					node=new ShuriKenParticle3D();
					break ;
				case "TrailSprite3D":
					node=new TrailSprite3D();
					break ;
					break ;
				case "Terrain":
					node=new Terrain();
					break ;
				case "Camera":
					node=new Camera();
					break ;
				case "DirectionLight":
					node=new DirectionLight();
					break ;
				default :
					throw new Error("Utils3D:unidentified class type in (.lh) file.");
				}
		};
		var props=nodeData.props;
		if (props)
			for (var key in props)
		node[key]=props[key];
		var customProps=nodeData.customProps;
		if (customProps){
			if ((node instanceof laya.d3.core.Sprite3D )){
				node._parseBaseCustomProps(customProps);
				node._parseCustomProps(rootNode,innerResouMap,customProps,nodeData);
				node._parseCustomComponent(rootNode,innerResouMap,nodeData.components);
				}else {
				node._parseCustomProps(rootNode,innerResouMap,customProps,nodeData);
			}
		};
		var childData=nodeData.child;
		if (childData){
			for (var i=0,n=childData.length;i < n;i++){
				var child=Utils3D._createNodeByJson(rootNode,childData[i],null,innerResouMap)
				node.addChild(child);
			}
		}
		return node;
	}

	Utils3D._computeBoneAndAnimationDatasByBindPoseMatrxix=function(bones,curData,inverGlobalBindPose,outBonesDatas,outAnimationDatas,boneIndexToMesh){
		var offset=0;
		var matOffset=0;
		var i;
		var parentOffset;
		var boneLength=bones.length;
		for (i=0;i < boneLength;offset+=bones[i].keyframeWidth,matOffset+=16,i++){
			laya.d3.utils.Utils3D._rotationTransformScaleSkinAnimation(curData[offset+0],curData[offset+1],curData[offset+2],curData[offset+3],curData[offset+4],curData[offset+5],curData[offset+6],curData[offset+7],curData[offset+8],curData[offset+9],outBonesDatas,matOffset);
			if (i !=0){
				parentOffset=bones[i].parentIndex *16;
				laya.d3.utils.Utils3D.mulMatrixByArray(outBonesDatas,parentOffset,outBonesDatas,matOffset,outBonesDatas,matOffset);
			}
		};
		var n=inverGlobalBindPose.length;
		for (i=0;i < n;i++){
			laya.d3.utils.Utils3D.mulMatrixByArrayAndMatrixFast(outBonesDatas,boneIndexToMesh[i] *16,inverGlobalBindPose[i],outAnimationDatas,i *16);
		}
	}

	Utils3D._computeAnimationDatasByArrayAndMatrixFast=function(inverGlobalBindPose,bonesDatas,outAnimationDatas,boneIndexToMesh){
		for (var i=0,n=inverGlobalBindPose.length;i < n;i++)
		laya.d3.utils.Utils3D.mulMatrixByArrayAndMatrixFast(bonesDatas,boneIndexToMesh[i] *16,inverGlobalBindPose[i],outAnimationDatas,i *16);
	}

	Utils3D._computeBoneAndAnimationDatasByBindPoseMatrxixOld=function(bones,curData,inverGlobalBindPose,outBonesDatas,outAnimationDatas){
		var offset=0;
		var matOffset=0;
		var i;
		var parentOffset;
		var boneLength=bones.length;
		for (i=0;i < boneLength;offset+=bones[i].keyframeWidth,matOffset+=16,i++){
			laya.d3.utils.Utils3D._rotationTransformScaleSkinAnimation(curData[offset+7],curData[offset+8],curData[offset+9],curData[offset+3],curData[offset+4],curData[offset+5],curData[offset+6],curData[offset+0],curData[offset+1],curData[offset+2],outBonesDatas,matOffset);
			if (i !=0){
				parentOffset=bones[i].parentIndex *16;
				laya.d3.utils.Utils3D.mulMatrixByArray(outBonesDatas,parentOffset,outBonesDatas,matOffset,outBonesDatas,matOffset);
			}
		};
		var n=inverGlobalBindPose.length;
		for (i=0;i < n;i++){
			var arrayOffset=i *16;
			laya.d3.utils.Utils3D.mulMatrixByArrayAndMatrixFast(outBonesDatas,arrayOffset,inverGlobalBindPose[i],outAnimationDatas,arrayOffset);
		}
	}

	Utils3D._computeAnimationDatasByArrayAndMatrixFastOld=function(inverGlobalBindPose,bonesDatas,outAnimationDatas){
		var n=inverGlobalBindPose.length;
		for (var i=0;i < n;i++){
			var arrayOffset=i *16;
			laya.d3.utils.Utils3D.mulMatrixByArrayAndMatrixFast(bonesDatas,arrayOffset,inverGlobalBindPose[i],outAnimationDatas,arrayOffset);
		}
	}

	Utils3D._computeRootAnimationData=function(bones,curData,animationDatas){
		for (var i=0,offset=0,matOffset=0,boneLength=bones.length;i < boneLength;offset+=bones[i].keyframeWidth,matOffset+=16,i++)
		laya.d3.utils.Utils3D.createAffineTransformationArray(curData[offset+0],curData[offset+1],curData[offset+2],curData[offset+3],curData[offset+4],curData[offset+5],curData[offset+6],curData[offset+7],curData[offset+8],curData[offset+9],animationDatas,matOffset);
	}

	Utils3D.transformVector3ArrayByQuat=function(sourceArray,sourceOffset,rotation,outArray,outOffset){
		var re=rotation.elements;
		var x=sourceArray[sourceOffset],y=sourceArray[sourceOffset+1],z=sourceArray[sourceOffset+2],qx=re[0],qy=re[1],qz=re[2],qw=re[3],ix=qw *x+qy *z-qz *y,iy=qw *y+qz *x-qx *z,iz=qw *z+qx *y-qy *x,iw=-qx *x-qy *y-qz *z;
		outArray[outOffset]=ix *qw+iw *-qx+iy *-qz-iz *-qy;
		outArray[outOffset+1]=iy *qw+iw *-qy+iz *-qx-ix *-qz;
		outArray[outOffset+2]=iz *qw+iw *-qz+ix *-qy-iy *-qx;
	}

	Utils3D.mulMatrixByArray=function(leftArray,leftOffset,rightArray,rightOffset,outArray,outOffset){
		var i,ai0,ai1,ai2,ai3;
		if (outArray===rightArray){
			rightArray=Utils3D._tempArray16_3;
			for (i=0;i < 16;++i){
				rightArray[i]=outArray[outOffset+i];
			}
			rightOffset=0;
		}
		for (i=0;i < 4;i++){
			ai0=leftArray[leftOffset+i];
			ai1=leftArray[leftOffset+i+4];
			ai2=leftArray[leftOffset+i+8];
			ai3=leftArray[leftOffset+i+12];
			outArray[outOffset+i]=ai0 *rightArray[rightOffset+0]+ai1 *rightArray[rightOffset+1]+ai2 *rightArray[rightOffset+2]+ai3 *rightArray[rightOffset+3];
			outArray[outOffset+i+4]=ai0 *rightArray[rightOffset+4]+ai1 *rightArray[rightOffset+5]+ai2 *rightArray[rightOffset+6]+ai3 *rightArray[rightOffset+7];
			outArray[outOffset+i+8]=ai0 *rightArray[rightOffset+8]+ai1 *rightArray[rightOffset+9]+ai2 *rightArray[rightOffset+10]+ai3 *rightArray[rightOffset+11];
			outArray[outOffset+i+12]=ai0 *rightArray[rightOffset+12]+ai1 *rightArray[rightOffset+13]+ai2 *rightArray[rightOffset+14]+ai3 *rightArray[rightOffset+15];
		}
	}

	Utils3D.mulMatrixByArrayFast=function(leftArray,leftOffset,rightArray,rightOffset,outArray,outOffset){
		var i,ai0,ai1,ai2,ai3;
		for (i=0;i < 4;i++){
			ai0=leftArray[leftOffset+i];
			ai1=leftArray[leftOffset+i+4];
			ai2=leftArray[leftOffset+i+8];
			ai3=leftArray[leftOffset+i+12];
			outArray[outOffset+i]=ai0 *rightArray[rightOffset+0]+ai1 *rightArray[rightOffset+1]+ai2 *rightArray[rightOffset+2]+ai3 *rightArray[rightOffset+3];
			outArray[outOffset+i+4]=ai0 *rightArray[rightOffset+4]+ai1 *rightArray[rightOffset+5]+ai2 *rightArray[rightOffset+6]+ai3 *rightArray[rightOffset+7];
			outArray[outOffset+i+8]=ai0 *rightArray[rightOffset+8]+ai1 *rightArray[rightOffset+9]+ai2 *rightArray[rightOffset+10]+ai3 *rightArray[rightOffset+11];
			outArray[outOffset+i+12]=ai0 *rightArray[rightOffset+12]+ai1 *rightArray[rightOffset+13]+ai2 *rightArray[rightOffset+14]+ai3 *rightArray[rightOffset+15];
		}
	}

	Utils3D.mulMatrixByArrayAndMatrixFast=function(leftArray,leftOffset,rightMatrix,outArray,outOffset){
		var i,ai0,ai1,ai2,ai3;
		var rightMatrixE=rightMatrix.elements;
		var m11=rightMatrixE[0],m12=rightMatrixE[1],m13=rightMatrixE[2],m14=rightMatrixE[3];
		var m21=rightMatrixE[4],m22=rightMatrixE[5],m23=rightMatrixE[6],m24=rightMatrixE[7];
		var m31=rightMatrixE[8],m32=rightMatrixE[9],m33=rightMatrixE[10],m34=rightMatrixE[11];
		var m41=rightMatrixE[12],m42=rightMatrixE[13],m43=rightMatrixE[14],m44=rightMatrixE[15];
		var ai0LeftOffset=leftOffset;
		var ai1LeftOffset=leftOffset+4;
		var ai2LeftOffset=leftOffset+8;
		var ai3LeftOffset=leftOffset+12;
		var ai0OutOffset=outOffset;
		var ai1OutOffset=outOffset+4;
		var ai2OutOffset=outOffset+8;
		var ai3OutOffset=outOffset+12;
		for (i=0;i < 4;i++){
			ai0=leftArray[ai0LeftOffset+i];
			ai1=leftArray[ai1LeftOffset+i];
			ai2=leftArray[ai2LeftOffset+i];
			ai3=leftArray[ai3LeftOffset+i];
			outArray[ai0OutOffset+i]=ai0 *m11+ai1 *m12+ai2 *m13+ai3 *m14;
			outArray[ai1OutOffset+i]=ai0 *m21+ai1 *m22+ai2 *m23+ai3 *m24;
			outArray[ai2OutOffset+i]=ai0 *m31+ai1 *m32+ai2 *m33+ai3 *m34;
			outArray[ai3OutOffset+i]=ai0 *m41+ai1 *m42+ai2 *m43+ai3 *m44;
		}
	}

	Utils3D.createAffineTransformationArray=function(tX,tY,tZ,rX,rY,rZ,rW,sX,sY,sZ,outArray,outOffset){
		var x2=rX+rX,y2=rY+rY,z2=rZ+rZ;
		var xx=rX *x2,xy=rX *y2,xz=rX *z2,yy=rY *y2,yz=rY *z2,zz=rZ *z2;
		var wx=rW *x2,wy=rW *y2,wz=rW *z2;
		outArray[outOffset+0]=(1-(yy+zz))*sX;
		outArray[outOffset+1]=(xy+wz)*sX;
		outArray[outOffset+2]=(xz-wy)*sX;
		outArray[outOffset+3]=0;
		outArray[outOffset+4]=(xy-wz)*sY;
		outArray[outOffset+5]=(1-(xx+zz))*sY;
		outArray[outOffset+6]=(yz+wx)*sY;
		outArray[outOffset+7]=0;
		outArray[outOffset+8]=(xz+wy)*sZ;
		outArray[outOffset+9]=(yz-wx)*sZ;
		outArray[outOffset+10]=(1-(xx+yy))*sZ;
		outArray[outOffset+11]=0;
		outArray[outOffset+12]=tX;
		outArray[outOffset+13]=tY;
		outArray[outOffset+14]=tZ;
		outArray[outOffset+15]=1;
	}

	Utils3D.transformVector3ArrayToVector3ArrayCoordinate=function(source,sourceOffset,transform,result,resultOffset){
		var vectorElem=Utils3D._tempArray4_0;
		var coordinateX=source[sourceOffset+0];
		var coordinateY=source[sourceOffset+1];
		var coordinateZ=source[sourceOffset+2];
		var transformElem=transform.elements;
		vectorElem[0]=(coordinateX *transformElem[0])+(coordinateY *transformElem[4])+(coordinateZ *transformElem[8])+transformElem[12];
		vectorElem[1]=(coordinateX *transformElem[1])+(coordinateY *transformElem[5])+(coordinateZ *transformElem[9])+transformElem[13];
		vectorElem[2]=(coordinateX *transformElem[2])+(coordinateY *transformElem[6])+(coordinateZ *transformElem[10])+transformElem[14];
		vectorElem[3]=1.0 / ((coordinateX *transformElem[3])+(coordinateY *transformElem[7])+(coordinateZ *transformElem[11])+transformElem[15]);
		result[resultOffset+0]=vectorElem[0] *vectorElem[3];
		result[resultOffset+1]=vectorElem[1] *vectorElem[3];
		result[resultOffset+2]=vectorElem[2] *vectorElem[3];
	}

	Utils3D.transformLightingMapTexcoordByUV0Array=function(source,sourceOffset,lightingMapScaleOffset,result,resultOffset){
		var lightingMapScaleOffsetE=lightingMapScaleOffset.elements;
		result[resultOffset+0]=source[sourceOffset+0] *lightingMapScaleOffsetE[0]+lightingMapScaleOffsetE[2];
		result[resultOffset+1]=(source[sourceOffset+1]-1.0)*lightingMapScaleOffsetE[1]+lightingMapScaleOffsetE[3];
	}

	Utils3D.transformLightingMapTexcoordByUV1Array=function(source,sourceOffset,lightingMapScaleOffset,result,resultOffset){
		var lightingMapScaleOffsetE=lightingMapScaleOffset.elements;
		result[resultOffset+0]=source[sourceOffset+0] *lightingMapScaleOffsetE[0]+lightingMapScaleOffsetE[2];
		result[resultOffset+1]=1.0+source[sourceOffset+1] *lightingMapScaleOffsetE[1]+lightingMapScaleOffsetE[3];
	}

	Utils3D.getURLVerion=function(url){
		var index=url.indexOf("?");
		return index >=0 ? url.substr(index):null;
	}

	Utils3D._quaternionCreateFromYawPitchRollArray=function(yaw,pitch,roll,out){
		var halfRoll=roll *0.5;
		var halfPitch=pitch *0.5;
		var halfYaw=yaw *0.5;
		var sinRoll=Math.sin(halfRoll);
		var cosRoll=Math.cos(halfRoll);
		var sinPitch=Math.sin(halfPitch);
		var cosPitch=Math.cos(halfPitch);
		var sinYaw=Math.sin(halfYaw);
		var cosYaw=Math.cos(halfYaw);
		out[0]=(cosYaw *sinPitch *cosRoll)+(sinYaw *cosPitch *sinRoll);
		out[1]=(sinYaw *cosPitch *cosRoll)-(cosYaw *sinPitch *sinRoll);
		out[2]=(cosYaw *cosPitch *sinRoll)-(sinYaw *sinPitch *cosRoll);
		out[3]=(cosYaw *cosPitch *cosRoll)+(sinYaw *sinPitch *sinRoll);
	}

	Utils3D._createAffineTransformationArray=function(trans,rot,scale,outE){
		var x=rot[0],y=rot[1],z=rot[2],w=rot[3],x2=x+x,y2=y+y,z2=z+z;
		var xx=x *x2,xy=x *y2,xz=x *z2,yy=y *y2,yz=y *z2,zz=z *z2;
		var wx=w *x2,wy=w *y2,wz=w *z2,sx=scale[0],sy=scale[1],sz=scale[2];
		outE[0]=(1-(yy+zz))*sx;
		outE[1]=(xy+wz)*sx;
		outE[2]=(xz-wy)*sx;
		outE[3]=0;
		outE[4]=(xy-wz)*sy;
		outE[5]=(1-(xx+zz))*sy;
		outE[6]=(yz+wx)*sy;
		outE[7]=0;
		outE[8]=(xz+wy)*sz;
		outE[9]=(yz-wx)*sz;
		outE[10]=(1-(xx+yy))*sz;
		outE[11]=0;
		outE[12]=trans[0];
		outE[13]=trans[1];
		outE[14]=trans[2];
		outE[15]=1;
	}

	Utils3D._mulMatrixArray=function(leftMatrixE,rightMatrix,outArray,outOffset){
		var i,ai0,ai1,ai2,ai3;
		var rightMatrixE=rightMatrix.elements;
		var m11=rightMatrixE[0],m12=rightMatrixE[1],m13=rightMatrixE[2],m14=rightMatrixE[3];
		var m21=rightMatrixE[4],m22=rightMatrixE[5],m23=rightMatrixE[6],m24=rightMatrixE[7];
		var m31=rightMatrixE[8],m32=rightMatrixE[9],m33=rightMatrixE[10],m34=rightMatrixE[11];
		var m41=rightMatrixE[12],m42=rightMatrixE[13],m43=rightMatrixE[14],m44=rightMatrixE[15];
		var ai0OutOffset=outOffset;
		var ai1OutOffset=outOffset+4;
		var ai2OutOffset=outOffset+8;
		var ai3OutOffset=outOffset+12;
		for (i=0;i < 4;i++){
			ai0=leftMatrixE[i];
			ai1=leftMatrixE[i+4];
			ai2=leftMatrixE[i+8];
			ai3=leftMatrixE[i+12];
			outArray[ai0OutOffset+i]=ai0 *m11+ai1 *m12+ai2 *m13+ai3 *m14;
			outArray[ai1OutOffset+i]=ai0 *m21+ai1 *m22+ai2 *m23+ai3 *m24;
			outArray[ai2OutOffset+i]=ai0 *m31+ai1 *m32+ai2 *m33+ai3 *m34;
			outArray[ai3OutOffset+i]=ai0 *m41+ai1 *m42+ai2 *m43+ai3 *m44;
		}
	}

	Utils3D.getYawPitchRoll=function(quaternion,out){
		Utils3D.transformQuat(Vector3.ForwardRH,quaternion,Quaternion.TEMPVector31);
		Utils3D.transformQuat(Vector3.Up,quaternion,Quaternion.TEMPVector32);
		var upe=Quaternion.TEMPVector32.elements;
		Utils3D.angleTo(Vector3.ZERO,Quaternion.TEMPVector31,Quaternion.TEMPVector33);
		var anglee=Quaternion.TEMPVector33.elements;
		if (anglee[0]==Math.PI / 2){
			anglee[1]=Utils3D.arcTanAngle(upe[2],upe[0]);
			anglee[2]=0;
			}else if (anglee[0]==-Math.PI / 2){
			anglee[1]=Utils3D.arcTanAngle(-upe[2],-upe[0]);
			anglee[2]=0;
			}else {
			Matrix4x4.createRotationY(-anglee[1],Quaternion.TEMPMatrix0);
			Matrix4x4.createRotationX(-anglee[0],Quaternion.TEMPMatrix1);
			Vector3.transformCoordinate(Quaternion.TEMPVector32,Quaternion.TEMPMatrix0,Quaternion.TEMPVector32);
			Vector3.transformCoordinate(Quaternion.TEMPVector32,Quaternion.TEMPMatrix1,Quaternion.TEMPVector32);
			anglee[2]=Utils3D.arcTanAngle(upe[1],-upe[0]);
		}
		if (anglee[1] <=-Math.PI)
			anglee[1]=Math.PI;
		if (anglee[2] <=-Math.PI)
			anglee[2]=Math.PI;
		if (anglee[1] >=Math.PI && anglee[2] >=Math.PI){
			anglee[1]=0;
			anglee[2]=0;
			anglee[0]=Math.PI-anglee[0];
		}
		out[0]=anglee[1];
		out[1]=anglee[0];
		out[2]=anglee[2];
	}

	Utils3D.arcTanAngle=function(x,y){
		if (x==0){
			if (y==1)
				return Math.PI / 2;
			return-Math.PI / 2;
		}
		if (x > 0)
			return Math.atan(y / x);
		if (x < 0){
			if (y > 0)
				return Math.atan(y / x)+Math.PI;
			return Math.atan(y / x)-Math.PI;
		}
		return 0;
	}

	Utils3D.angleTo=function(from,location,angle){
		Vector3.subtract(location,from,Quaternion.TEMPVector30);
		Vector3.normalize(Quaternion.TEMPVector30,Quaternion.TEMPVector30);
		angle.elements[0]=Math.asin(Quaternion.TEMPVector30.y);
		angle.elements[1]=Utils3D.arcTanAngle(-Quaternion.TEMPVector30.z,-Quaternion.TEMPVector30.x);
	}

	Utils3D.transformQuat=function(source,rotation,out){
		var destination=out.elements;
		var se=source.elements;
		var re=rotation;
		var x=se[0],y=se[1],z=se[2],qx=re[0],qy=re[1],qz=re[2],qw=re[3],
		ix=qw *x+qy *z-qz *y,iy=qw *y+qz *x-qx *z,iz=qw *z+qx *y-qy *x,iw=-qx *x-qy *y-qz *z;
		destination[0]=ix *qw+iw *-qx+iy *-qz-iz *-qy;
		destination[1]=iy *qw+iw *-qy+iz *-qx-ix *-qz;
		destination[2]=iz *qw+iw *-qz+ix *-qy-iy *-qx;
	}

	Utils3D.quaterionNormalize=function(f,e){
		var x=f[0],y=f[1],z=f[2],w=f[3];
		var len=x *x+y *y+z *z+w *w;
		if (len > 0){
			len=1 / Math.sqrt(len);
			e[0]=x *len;
			e[1]=y *len;
			e[2]=z *len;
			e[3]=w *len;
		}
	}

	Utils3D.matrix4x4MultiplyFFF=function(a,b,e){
		var i,ai0,ai1,ai2,ai3;
		if (e===b){
			b=new Float32Array(16);
			for (i=0;i < 16;++i){
				b[i]=e[i];
			}
		}
		for (i=0;i < 4;i++){
			ai0=a[i];
			ai1=a[i+4];
			ai2=a[i+8];
			ai3=a[i+12];
			e[i]=ai0 *b[0]+ai1 *b[1]+ai2 *b[2]+ai3 *b[3];
			e[i+4]=ai0 *b[4]+ai1 *b[5]+ai2 *b[6]+ai3 *b[7];
			e[i+8]=ai0 *b[8]+ai1 *b[9]+ai2 *b[10]+ai3 *b[11];
			e[i+12]=ai0 *b[12]+ai1 *b[13]+ai2 *b[14]+ai3 *b[15];
		}
	}

	Utils3D.matrix4x4MultiplyMFM=function(left,right,out){
		Utils3D.matrix4x4MultiplyFFF(left.elements,right,out.elements);
	}

	__static(Utils3D,
	['_typeToFunO',function(){return this._typeToFunO={"INT16":"writeInt16","SHORT":"writeInt16","UINT16":"writeUint16","UINT32":"writeUint32","FLOAT32":"writeFloat32","INT":"writeInt32","UINT":"writeUint32","BYTE":"writeByte","STRING":"writeUTFString"};},'_tempVector3_0',function(){return this._tempVector3_0=new Vector3();},'_tempVector3_1',function(){return this._tempVector3_1=new Vector3();},'_tempVector3_2',function(){return this._tempVector3_2=new Vector3();},'_tempVector3_3',function(){return this._tempVector3_3=new Vector3();},'_tempVector3_4',function(){return this._tempVector3_4=new Vector3();},'_tempVector3_5',function(){return this._tempVector3_5=new Vector3();},'_tempVector3_6',function(){return this._tempVector3_6=new Vector3();},'_tempArray4_0',function(){return this._tempArray4_0=new Float32Array(4);},'_tempArray16_0',function(){return this._tempArray16_0=new Float32Array(16);},'_tempArray16_1',function(){return this._tempArray16_1=new Float32Array(16);},'_tempArray16_2',function(){return this._tempArray16_2=new Float32Array(16);},'_tempArray16_3',function(){return this._tempArray16_3=new Float32Array(16);}
	]);
	return Utils3D;
})()


/**
*<code>Laya3D</code> 类用于初始化3D设置。
*/
//class Laya3D
var Laya3D=(function(){
	/**
	*创建一个 <code>Laya3D</code> 实例。
	*/
	function Laya3D(){}
	__class(Laya3D,'Laya3D');
	Laya3D._cancelLoadByUrl=function(url){
		Laya.loader.cancelLoadByUrl(url);
		Laya3D._innerFirstLevelLoaderManager.cancelLoadByUrl(url);
		Laya3D._innerSecondLevelLoaderManager.cancelLoadByUrl(url);
		Laya3D._innerThirdLevelLoaderManager.cancelLoadByUrl(url);
		Laya3D._innerFourthLevelLoaderManager.cancelLoadByUrl(url);
	}

	Laya3D._changeWebGLSize=function(width,height){
		WebGL.onStageResize(width,height);
		RenderState.clientWidth=width;
		RenderState.clientHeight=height;
	}

	Laya3D.__init__=function(){
		var createMap=LoaderManager.createMap;
		createMap["lh"]=[Sprite3D,/*CLASS CONST:Laya3D.HIERARCHY*/"SPRITE3DHIERARCHY"];
		createMap["ls"]=[Scene,/*CLASS CONST:Laya3D.HIERARCHY*/"SPRITE3DHIERARCHY"];
		createMap["lm"]=[Mesh,/*CLASS CONST:Laya3D.MESH*/"MESH"];
		createMap["lmat"]=[StandardMaterial,/*CLASS CONST:Laya3D.MATERIAL*/"MATERIAL"];
		createMap["lpbr"]=[PBRMaterial,/*CLASS CONST:Laya3D.MATERIAL*/"MATERIAL"];
		createMap["ltc"]=[TextureCube,/*CLASS CONST:Laya3D.TEXTURECUBE*/"TEXTURECUBE"];
		createMap["jpg"]=[Texture2D,"nativeimage"];
		createMap["jpeg"]=[Texture2D,"nativeimage"];
		createMap["png"]=[Texture2D,"nativeimage"];
		createMap["pkm"]=[Texture2D,/*laya.net.Loader.BUFFER*/"arraybuffer"];
		createMap["lsani"]=[AnimationTemplet,/*laya.net.Loader.BUFFER*/"arraybuffer"];
		createMap["lrani"]=[AnimationTemplet,/*laya.net.Loader.BUFFER*/"arraybuffer"];
		createMap["raw"]=[DataTexture2D,/*laya.net.Loader.BUFFER*/"arraybuffer"];
		createMap["mipmaps"]=[DataTexture2D,/*laya.net.Loader.BUFFER*/"arraybuffer"];
		createMap["thdata"]=[TerrainHeightData,/*laya.net.Loader.BUFFER*/"arraybuffer"];
		createMap["lt"]=[TerrainRes,/*CLASS CONST:Laya3D.TERRAIN*/"TERRAIN"];
		createMap["lani"]=[AnimationClip,/*laya.net.Loader.BUFFER*/"arraybuffer"];
		createMap["lav"]=[Avatar,/*laya.net.Loader.JSON*/"json"];
		createMap["ani"]=[AnimationTemplet,/*laya.net.Loader.BUFFER*/"arraybuffer"];
		Loader.parserMap[ /*CLASS CONST:Laya3D.HIERARCHY*/"SPRITE3DHIERARCHY"]=Laya3D._loadHierarchy;
		Loader.parserMap[ /*CLASS CONST:Laya3D.MESH*/"MESH"]=Laya3D._loadMesh;
		Loader.parserMap[ /*CLASS CONST:Laya3D.MATERIAL*/"MATERIAL"]=Laya3D._loadMaterial;
		Loader.parserMap[ /*CLASS CONST:Laya3D.TEXTURECUBE*/"TEXTURECUBE"]=Laya3D._loadTextureCube;
		Loader.parserMap[ /*CLASS CONST:Laya3D.TERRAIN*/"TERRAIN"]=Laya3D._loadTerrain;
		Laya3D._innerFirstLevelLoaderManager.on(/*laya.events.Event.ERROR*/"error",null,Laya3D._eventLoadManagerError);
		Laya3D._innerSecondLevelLoaderManager.on(/*laya.events.Event.ERROR*/"error",null,Laya3D._eventLoadManagerError);
		Laya3D._innerThirdLevelLoaderManager.on(/*laya.events.Event.ERROR*/"error",null,Laya3D._eventLoadManagerError);
		Laya3D._innerFourthLevelLoaderManager.on(/*laya.events.Event.ERROR*/"error",null,Laya3D._eventLoadManagerError);
	}

	Laya3D.READ_BLOCK=function(){
		Laya3D._readData.pos+=4;
		return true;
	}

	Laya3D.READ_DATA=function(){
		Laya3D._DATA.offset=Laya3D._readData.getUint32();
		Laya3D._DATA.size=Laya3D._readData.getUint32();
		return true;
	}

	Laya3D.READ_STRINGS=function(){
		var materialUrls=[];
		var _STRINGS={offset:0,size:0};
		_STRINGS.offset=Laya3D._readData.getUint16();
		_STRINGS.size=Laya3D._readData.getUint16();
		var ofs=Laya3D._readData.pos;
		Laya3D._readData.pos=_STRINGS.offset+Laya3D._DATA.offset;
		for (var i=0;i < _STRINGS.size;i++){
			var string=Laya3D._readData.readUTFString();
			if (string.lastIndexOf(".lmat")!==-1 || string.lastIndexOf(".lpbr")!==-1)
				materialUrls.push(string);
		}
		return materialUrls;
	}

	Laya3D.formatRelativePath=function(base,value){
		var path;
		var char1=value.charAt(0);
		if (char1==="."){
			var parts=(base+value).split("/");
			for (var i=0,len=parts.length;i < len;i++){
				if (parts[i]=='..'){
					var index=i-1;
					if (index > 0 && parts[index]!=='..'){
						parts.splice(index,2);
						i-=2;
					}
				}
			}
			path=parts.join('/');
			}else {
			path=base+value;
		}
		(URL.customFormat !=null)&&(path=URL.customFormat(path,null));
		return path;
	}

	Laya3D._eventLoadManagerError=function(msg){
		Laya.loader.event(/*laya.events.Event.ERROR*/"error",msg);
	}

	Laya3D._addHierarchyInnerUrls=function(urls,urlMap,urlVersion,hierarchyBasePath,path,clas){
		var formatSubUrl=Laya3D.formatRelativePath(hierarchyBasePath,path);
		(urlVersion)&& (formatSubUrl=formatSubUrl+urlVersion);
		urls.push({url:formatSubUrl,clas:clas});
		urlMap[path]=formatSubUrl;
	}

	Laya3D._getSprite3DHierarchyInnerUrls=function(node,firstLevelUrls,secondLevelUrls,fourthLelUrls,urlMap,urlVersion,hierarchyBasePath){
		var i=0,n=0;
		var customProps;
		switch (node.type){
			case "Scene":;
				var lightmaps=node.customProps.lightmaps;
				for (i=0,n=lightmaps.length;i < n;i++){
					var lightMap=lightmaps[i].replace(".exr",".png");
					Laya3D._addHierarchyInnerUrls(fourthLelUrls,urlMap,urlVersion,hierarchyBasePath,lightMap,Texture2D);
				}
				break ;
			case "MeshSprite3D":
			case "TrailSprite3D":
			case "LineSprite3D":
			case "SkinnedMeshSprite3D":;
				var meshPath;
				if (node.instanceParams){
					meshPath=node.instanceParams.loadPath;
					(meshPath)&& (Laya3D._addHierarchyInnerUrls(firstLevelUrls,urlMap,urlVersion,hierarchyBasePath,meshPath,Mesh));
					}else {
					customProps=node.customProps;
					meshPath=customProps.meshPath;
					(meshPath)&& (Laya3D._addHierarchyInnerUrls(firstLevelUrls,urlMap,urlVersion,hierarchyBasePath,meshPath,Mesh));
					var materials=customProps.materials;
					if (materials)
						for (i=0,n=materials.length;i < n;i++){
						var mat=materials[i];
						var clasPaths=mat.type.split('.');
						var clas=Browser.window;
						clasPaths.forEach(function(cls){
							clas=clas[cls];
						});
						if (typeof(clas)=='function')Laya3D._addHierarchyInnerUrls(secondLevelUrls,urlMap,urlVersion,hierarchyBasePath,mat.path,clas);
						else {
							throw('_getSprite3DHierarchyInnerUrls 错误: '+mat.type+' 不是类');
						}
					}
				}
				break ;
			case "ShuriKenParticle3D":
				customProps=node.customProps;
				var parMeshPath=customProps.meshPath;
				(parMeshPath)&& (Laya3D._addHierarchyInnerUrls(firstLevelUrls,urlMap,urlVersion,hierarchyBasePath,parMeshPath,Mesh));
				var materialData=customProps.material;
				if (materialData){
					clasPaths=materialData.type.split('.');
					clas=Browser.window;
					clasPaths.forEach(function(cls){
						clas=clas[cls];
					});
					Laya3D._addHierarchyInnerUrls(secondLevelUrls,urlMap,urlVersion,hierarchyBasePath,materialData.path,clas);
					}else {
					var materialPath=customProps.materialPath;
					if (materialPath){
						Laya3D._addHierarchyInnerUrls(secondLevelUrls,urlMap,urlVersion,hierarchyBasePath,materialPath,ShurikenParticleMaterial);
						}else {
						var texturePath=customProps.texturePath;
						if (texturePath)
							Laya3D._addHierarchyInnerUrls(fourthLelUrls,urlMap,urlVersion,hierarchyBasePath,texturePath,Texture2D);
					}
				}
				break ;
			case "Terrain":
				Laya3D._addHierarchyInnerUrls(fourthLelUrls,urlMap,urlVersion,hierarchyBasePath,node.customProps.dataPath,TerrainRes);
				break ;
			};
		var components=node.components;
		for (var k in components){
			var component=components[k];
			switch (k){
				case "Animator":;
					var avatarPath=component.avatarPath;
					if (avatarPath){
						Laya3D._addHierarchyInnerUrls(fourthLelUrls,urlMap,urlVersion,hierarchyBasePath,avatarPath,Avatar);
						}else {
						var avatarData=component.avatar;
						(avatarData)&& (Laya3D._addHierarchyInnerUrls(fourthLelUrls,urlMap,urlVersion,hierarchyBasePath,avatarData.path,Avatar));
					};
					var clipPaths=component.clipPaths;
					for (i=0,n=clipPaths.length;i < n;i++)
					Laya3D._addHierarchyInnerUrls(fourthLelUrls,urlMap,urlVersion,hierarchyBasePath,clipPaths[i],AnimationClip);
					break ;
				}
		};
		var children=node.child;
		for (i=0,n=children.length;i < n;i++)
		Laya3D._getSprite3DHierarchyInnerUrls(children[i],firstLevelUrls,secondLevelUrls,fourthLelUrls,urlMap,urlVersion,hierarchyBasePath);
	}

	Laya3D._loadHierarchy=function(loader){
		loader.on(/*laya.events.Event.LOADED*/"loaded",null,Laya3D._onHierarchylhLoaded,[loader,loader._class._getGroup()]);
		loader.load(loader.url,/*laya.net.Loader.JSON*/"json",false,null,true);
	}

	Laya3D._onHierarchylhLoaded=function(loader,group,lhData){
		if (loader._class.destroyed){
			loader.endLoad();
			}else {
			var url=loader.url;
			var urlVersion=Utils3D.getURLVerion(url);
			var hierarchyBasePath=URL.getPath(url);
			var firstLevUrls=[];
			var secondLevUrls=[];
			var forthLevUrls=[];
			var urlMap={};
			Laya3D._getSprite3DHierarchyInnerUrls(lhData,firstLevUrls,secondLevUrls,forthLevUrls,urlMap,urlVersion,hierarchyBasePath);
			var urlCount=firstLevUrls.length+secondLevUrls.length+forthLevUrls.length;
			var totalProcessCount=urlCount+1;
			var weight=1 / totalProcessCount;
			Laya3D._onProcessChange(loader,0,weight,1.0);
			if (forthLevUrls.length > 0){
				var processCeil=urlCount / totalProcessCount;
				var processHandler=Handler.create(null,Laya3D._onProcessChange,[loader,weight,processCeil],false);
				Laya3D._innerFourthLevelLoaderManager.create(forthLevUrls,Handler.create(null,Laya3D._onHierarchyInnerForthLevResouLoaded,[loader,group,processHandler,lhData,urlMap,firstLevUrls,secondLevUrls,weight+processCeil *forthLevUrls.length,processCeil]),processHandler,null,null,1,true,group);
				}else {
				Laya3D._onHierarchyInnerForthLevResouLoaded(loader,group,null,lhData,urlMap,firstLevUrls,secondLevUrls,weight,processCeil);
			}
		}
	}

	Laya3D._onHierarchyInnerForthLevResouLoaded=function(loader,group,processHandler,lhData,urlMap,firstLevUrls,secondLevUrls,processOffset,processCeil){
		if (loader._class.destroyed){
			loader.endLoad();
			}else {
			(processHandler)&& (processHandler.recover());
			if (secondLevUrls.length > 0){
				var process=Handler.create(null,Laya3D._onProcessChange,[loader,processOffset,processCeil],false);
				Laya3D._innerSecondLevelLoaderManager.create(secondLevUrls,Handler.create(null,Laya3D._onHierarchyInnerSecondLevResouLoaded,[loader,group,process,lhData,urlMap,firstLevUrls,processOffset+processCeil *secondLevUrls.length,processCeil]),processHandler,null,null,1,true,group);
				}else {
				Laya3D._onHierarchyInnerSecondLevResouLoaded(loader,group,null,lhData,urlMap,firstLevUrls,processOffset,processCeil);
			}
		}
	}

	Laya3D._onHierarchyInnerSecondLevResouLoaded=function(loader,group,processHandler,lhData,urlMap,firstLevUrls,processOffset,processCeil){
		if (loader._class.destroyed){
			loader.endLoad();
			}else {
			(processHandler)&& (processHandler.recover());
			if (firstLevUrls.length > 0){
				var process=Handler.create(null,Laya3D._onProcessChange,[loader,processOffset,processCeil],false);
				Laya3D._innerFirstLevelLoaderManager.create(firstLevUrls,Handler.create(null,Laya3D._onHierarchyInnerFirstLevResouLoaded,[loader,process,lhData,urlMap,]),processHandler,null,null,1,true,group);
				}else {
				Laya3D._onHierarchyInnerFirstLevResouLoaded(loader,null,lhData,urlMap);
			}
		}
	}

	Laya3D._onHierarchyInnerFirstLevResouLoaded=function(loader,processHandler,lhData,urlMap){
		(processHandler)&& (processHandler.recover());
		loader.endLoad([lhData,urlMap]);
	}

	Laya3D._loadTerrain=function(loader){
		loader.on(/*laya.events.Event.LOADED*/"loaded",null,Laya3D._onTerrainLtLoaded,[loader,loader._class._getGroup()]);
		loader.load(loader.url,/*laya.net.Loader.JSON*/"json",false,null,true);
	}

	Laya3D._onTerrainLtLoaded=function(loader,group,ltData){
		if (loader._class.destroyed){
			loader.endLoad();
			}else {
			var url=loader.url;
			var urlVersion=Utils3D.getURLVerion(url);
			var terrainBasePath=URL.getPath(url);
			var heightMapURL,textureURLs=[];
			var urlMap={};
			var formatUrl;
			var i=0,n=0,count=0;
			var heightData=ltData.heightData;
			heightMapURL=heightData.url;
			formatUrl=Laya3D.formatRelativePath(terrainBasePath,heightMapURL);
			(urlVersion)&& (formatUrl=formatUrl+urlVersion);
			urlMap[heightMapURL]=formatUrl;
			heightMapURL=formatUrl;
			var detailTextures=ltData.detailTexture;
			for (i=0,n=detailTextures.length;i < n;i++)
			textureURLs.push({url:detailTextures[i].diffuse});
			var normalMaps=ltData.normalMap;
			for (i=0,n=normalMaps.length;i < n;i++)
			textureURLs.push({url:normalMaps[i]});
			var alphaMaps=ltData.alphaMap;
			for (i=0,n=alphaMaps.length;i < n;i++)
			textureURLs.push({url:alphaMaps[i],params:[false,false,/*laya.webgl.WebGLContext.RGBA*/0x1908,true]});
			for (i=0,n=textureURLs.length;i < n;i++){
				var subUrl=textureURLs[i].url;
				formatUrl=Laya3D.formatRelativePath(terrainBasePath,subUrl);
				(urlVersion)&& (formatUrl=formatUrl+urlVersion);
				textureURLs[i].url=formatUrl;
				urlMap[subUrl]=formatUrl;
			};
			var texsUrlCount=textureURLs.length;
			var totalProcessCount=texsUrlCount+2;
			var weight=1 / totalProcessCount;
			Laya3D._onProcessChange(loader,0,weight,1.0);
			var loadInfo={heightMapLoaded:false,texturesLoaded:false};
			var hmProcessHandler=Handler.create(null,Laya3D._onProcessChange,[loader,weight,weight],false);
			Laya3D._innerFourthLevelLoaderManager.create(heightMapURL,Handler.create(null,Laya3D._onTerrainHeightMapLoaded,[loader,hmProcessHandler,ltData,urlMap,loadInfo]),hmProcessHandler,null,[heightData.numX,heightData.numZ,heightData.bitType,heightData.value],1,true,group);
			var texsProcessHandler=Handler.create(null,Laya3D._onProcessChange,[loader,weight *2,texsUrlCount / totalProcessCount],false);
			Laya3D._innerFourthLevelLoaderManager.create(textureURLs,Handler.create(null,Laya3D._onTerrainTexturesLoaded,[loader,texsProcessHandler,ltData,urlMap,loadInfo]),texsProcessHandler,null,null,1,true,group);
		}
	}

	Laya3D._onTerrainHeightMapLoaded=function(loader,processHandler,ltData,urlMap,loadInfo){
		loadInfo.heightMapLoaded=true;
		if (loadInfo.texturesLoaded){
			loader.endLoad([ltData,urlMap]);
			processHandler.recover();
		}
	}

	Laya3D._onTerrainTexturesLoaded=function(loader,processHandler,ltData,urlMap,loadInfo){
		loadInfo.texturesLoaded=true;
		if (loadInfo.heightMapLoaded){
			loader.endLoad([ltData,urlMap]);
			processHandler.recover();
		}
	}

	Laya3D._loadMesh=function(loader){
		loader.on(/*laya.events.Event.LOADED*/"loaded",null,Laya3D._onMeshLmLoaded,[loader,loader._class._getGroup()]);
		loader.load(loader.url,/*laya.net.Loader.BUFFER*/"arraybuffer",false,null,true);
	}

	Laya3D._onMeshLmLoaded=function(loader,group,lmData){
		if (loader._class.destroyed){
			loader.endLoad();
			}else {
			var url=loader.url;
			var urlVersion=Utils3D.getURLVerion(url);
			var meshBasePath=URL.getPath(url);
			var urls;
			var urlMap={};
			var formatSubUrl;
			var i=0,n=0,count=0;
			Laya3D._readData=new Byte(lmData);
			Laya3D._readData.pos=0;
			var version=Laya3D._readData.readUTFString();
			switch (version){
				case "LAYAMODEL:02":
				case "LAYAMODEL:03":
				case "LAYAMODEL:0301":;
					var dataOffset=Laya3D._readData.getUint32();
					Laya3D._readData.pos=Laya3D._readData.pos+4;
					count=Laya3D._readData.getUint16();
					Laya3D._readData.pos=Laya3D._readData.pos+count *8;
					var offset=Laya3D._readData.getUint32();
					count=Laya3D._readData.getUint16();
					Laya3D._readData.pos=dataOffset+offset;
					urls=[];
					for (i=0;i < count;i++){
						var string=Laya3D._readData.readUTFString();
						if (string.lastIndexOf(".lmat")!==-1)
							urls.push(string);
					}
					break ;
				default :
					Laya3D.READ_BLOCK();
					for (i=0;i < 2;i++){
						var index=Laya3D._readData.getUint16();
						var blockName=Laya3D._strings[index];
						var fn=Laya3D["READ_"+blockName];
						if (fn==null)throw new Error("model file err,no this function:"+index+" "+blockName);
						if (i===1)
							urls=fn.call();
						else
						fn.call()
					}
				}
			for (i=0,n=urls.length;i < n;i++){
				var subUrl=urls[i];
				formatSubUrl=Laya3D.formatRelativePath(meshBasePath,subUrl);
				(urlVersion)&& (formatSubUrl=formatSubUrl+urlVersion);
				urls[i]=formatSubUrl;
				urlMap[subUrl]=formatSubUrl;
			}
			if (urls.length > 0){
				var urlCount=1;
				var totalProcessCount=urlCount+1;
				var lmatWeight=1 / totalProcessCount;
				Laya3D._onProcessChange(loader,0,lmatWeight,1.0);
				var processHandler=Handler.create(null,Laya3D._onProcessChange,[loader,lmatWeight,urlCount / totalProcessCount],false);
				Laya3D._innerSecondLevelLoaderManager.create(urls,Handler.create(null,Laya3D._onMeshMateialLoaded,[loader,processHandler,lmData,urlMap]),processHandler,null,null,1,true,group);
				}else {
				loader.endLoad([lmData,urlMap]);
			}
		}
	}

	Laya3D._onMeshMateialLoaded=function(loader,processHandler,lmData,urlMap){
		loader.endLoad([lmData,urlMap]);
		processHandler.recover();
	}

	Laya3D._getMaterialTexturePath=function(path,urlVersion,materialBath){
		var extenIndex=path.length-4;
		if (path.indexOf(".dds")==extenIndex || path.indexOf(".tga")==extenIndex || path.indexOf(".exr")==extenIndex || path.indexOf(".DDS")==extenIndex || path.indexOf(".TGA")==extenIndex || path.indexOf(".EXR")==extenIndex)
			path=path.substr(0,extenIndex)+".png";
		path=Laya3D.formatRelativePath(materialBath,path);
		(urlVersion)&& (path=path+urlVersion);
		return path;
	}

	Laya3D._loadMaterial=function(loader){
		loader.on(/*laya.events.Event.LOADED*/"loaded",null,Laya3D._onMaterilLmatLoaded,[loader,loader._class._getGroup()]);
		loader.load(loader.url,/*laya.net.Loader.JSON*/"json",false,null,true);
	}

	Laya3D._onMaterilLmatLoaded=function(loader,group,lmatData){
		if (loader._class.destroyed){
			loader.endLoad();
			}else {
			var url=loader.url;
			var urlVersion=Utils3D.getURLVerion(url);
			var materialBasePath=URL.getPath(url);
			var urls=[];
			var urlMap={};
			var customProps=lmatData.customProps;
			var formatSubUrl;
			var version=lmatData.version;
			if (version){
				switch (version){
					case "LAYAMATERIAL:01":
					case "LAYAMATERIAL:02":;
						var textures=lmatData.props.textures;
						for (var i=0,n=textures.length;i < n;i++){
							var tex=textures[i];
							var path=tex.path;
							if (path){
								var extenIndex=path.length-4;
								if (path.indexOf(".exr")==extenIndex || path.indexOf(".EXR")==extenIndex)
									path=path.substr(0,extenIndex)+".png";
								formatSubUrl=Laya3D.formatRelativePath(materialBasePath,path);
								(urlVersion)&& (formatSubUrl=formatSubUrl+urlVersion);
								urls.push({url:formatSubUrl,params:tex.params});
								urlMap[path]=formatSubUrl;
							}
						}
						break ;
					default :
						throw new Error("Laya3D:unkonwn version.");
					}
				}else {
				var diffuseTexture=customProps.diffuseTexture.texture2D;
				if (diffuseTexture){
					formatSubUrl=Laya3D._getMaterialTexturePath(diffuseTexture,urlVersion,materialBasePath);
					urls.push(formatSubUrl);
					urlMap[diffuseTexture]=formatSubUrl;
				}
				if (customProps.normalTexture){
					var normalTexture=customProps.normalTexture.texture2D;
					if (normalTexture){
						formatSubUrl=Laya3D._getMaterialTexturePath(normalTexture,urlVersion,materialBasePath);
						urls.push(formatSubUrl);
						urlMap[normalTexture]=formatSubUrl;
					}
				}
				if (customProps.specularTexture){
					var specularTexture=customProps.specularTexture.texture2D;
					if (specularTexture){
						formatSubUrl=Laya3D._getMaterialTexturePath(specularTexture,urlVersion,materialBasePath);
						urls.push(formatSubUrl);
						urlMap[specularTexture]=formatSubUrl;
					}
				}
				if (customProps.emissiveTexture){
					var emissiveTexture=customProps.emissiveTexture.texture2D;
					if (emissiveTexture){
						formatSubUrl=Laya3D._getMaterialTexturePath(emissiveTexture,urlVersion,materialBasePath);
						urls.push(formatSubUrl);
						urlMap[emissiveTexture]=formatSubUrl;
					}
				}
				if (customProps.ambientTexture){
					var ambientTexture=customProps.ambientTexture.texture2D;
					if (ambientTexture){
						formatSubUrl=Laya3D._getMaterialTexturePath(ambientTexture,urlVersion,materialBasePath);
						urls.push(formatSubUrl);
						urlMap[ambientTexture]=formatSubUrl;
					}
				}
				if (customProps.reflectTexture){
					var reflectTexture=customProps.reflectTexture.texture2D;
					if (reflectTexture){
						formatSubUrl=Laya3D._getMaterialTexturePath(reflectTexture,urlVersion,materialBasePath);
						urls.push(formatSubUrl);
						urlMap[reflectTexture]=formatSubUrl;
					}
				}
			};
			var urlCount=urls.length;
			var totalProcessCount=urlCount+1;
			var lmatWeight=1 / totalProcessCount;
			Laya3D._onProcessChange(loader,0,lmatWeight,1.0);
			if (urlCount > 0){
				var processHandler=Handler.create(null,Laya3D._onProcessChange,[loader,lmatWeight,urlCount / totalProcessCount],false);
				Laya3D._innerFourthLevelLoaderManager.create(urls,Handler.create(null,Laya3D._onMateialTexturesLoaded,[loader,processHandler,lmatData,urlMap]),processHandler,Texture2D,null,1,true,group);
				}else {
				Laya3D._onMateialTexturesLoaded(loader,null,lmatData,null);
			}
		}
	}

	Laya3D._onMateialTexturesLoaded=function(loader,processHandler,lmatData,urlMap){
		loader.endLoad([lmatData,urlMap]);
		(processHandler)&& (processHandler.recover());
	}

	Laya3D._loadTextureCube=function(loader){
		loader.on(/*laya.events.Event.LOADED*/"loaded",null,Laya3D._onTextureCubeLtcLoaded,[loader]);
		loader.load(loader.url,/*laya.net.Loader.JSON*/"json",false,null,true);
	}

	Laya3D._onTextureCubeLtcLoaded=function(loader,ltcData){
		if (loader._class.destroyed){
			loader.endLoad();
			}else {
			var ltcBasePath=URL.getPath(loader.url);
			var urls=[Laya3D.formatRelativePath(ltcBasePath,ltcData.px),Laya3D.formatRelativePath(ltcBasePath,ltcData.nx),Laya3D.formatRelativePath(ltcBasePath,ltcData.py),Laya3D.formatRelativePath(ltcBasePath,ltcData.ny),Laya3D.formatRelativePath(ltcBasePath,ltcData.pz),Laya3D.formatRelativePath(ltcBasePath,ltcData.nz)];
			var ltcWeight=1.0 / 7.0;
			Laya3D._onProcessChange(loader,0,ltcWeight,1.0);
			var processHandler=Handler.create(null,Laya3D._onProcessChange,[loader,ltcWeight,6 / 7],false);
			Laya3D._innerFourthLevelLoaderManager.load(urls,Handler.create(null,Laya3D._onTextureCubeImagesLoaded,[loader,urls,processHandler]),processHandler,"nativeimage");
		}
	}

	Laya3D._onTextureCubeImagesLoaded=function(loader,urls,processHandler){
		var images=[];
		images.length=6;
		for (var i=0;i < 6;i++){
			var url=urls[i];
			images[i]=Loader.getRes(url);
			Loader.clearRes(url);
		}
		loader.endLoad(images);
		processHandler.recover();
	}

	Laya3D._onProcessChange=function(loader,offset,weight,process){
		process=offset+process *weight;
		(process < 1.0)&& (loader.event(/*laya.events.Event.PROGRESS*/"progress",process));
	}

	Laya3D.init=function(width,height,antialias,alpha,premultipliedAlpha,stencil){
		(antialias===void 0)&& (antialias=false);
		(alpha===void 0)&& (alpha=false);
		(premultipliedAlpha===void 0)&& (premultipliedAlpha=true);
		(stencil===void 0)&& (stencil=true);
		if (Laya3D._isinit)return;
		Laya3D._isinit=true;
		RunDriver.update3DLoop=function (){
			CollisionManager._triggerCollision();
		}
		RunDriver.cancelLoadByUrl=function (url){
			Laya3D._cancelLoadByUrl(url);
		}
		Config.isAntialias=antialias;
		Config.isAlpha=alpha;
		Config.premultipliedAlpha=premultipliedAlpha;
		Config.isStencil=stencil;
		if (!WebGL.enable()){
			alert("Laya3D init error,must support webGL!");
			return;
		}
		RunDriver.changeWebGLSize=Laya3D._changeWebGLSize;
		Render.is3DMode=true;
		Laya.init(width,height);
		Layer.__init__();
		Physics.__init__();
		ExtendTerrainMaterial.__init__();
		ShaderInit3D.__init__();
		MeshSprite3D.__init__();
		AnimationNode.__init__();
		Laya3D.__init__();
		AtlasResourceManager.maxTextureCount=2;
		if (Laya3D.debugMode || OctreeNode.debugMode)
			Laya3D._debugPhasorSprite=new PhasorSpriter3D();
	}

	Laya3D.HIERARCHY="SPRITE3DHIERARCHY";
	Laya3D.MESH="MESH";
	Laya3D.MATERIAL="MATERIAL";
	Laya3D.PBRMATERIAL="PBRMTL";
	Laya3D.TEXTURECUBE="TEXTURECUBE";
	Laya3D.TERRAIN="TERRAIN";
	Laya3D._readData=null;
	Laya3D._debugPhasorSprite=null;
	Laya3D.debugMode=false;
	Laya3D._isinit=false;
	__static(Laya3D,
	['_DATA',function(){return this._DATA={offset:0,size:0};},'_strings',function(){return this._strings=['BLOCK','DATA',"STRINGS"];},'_innerFirstLevelLoaderManager',function(){return this._innerFirstLevelLoaderManager=new LoaderManager();},'_innerSecondLevelLoaderManager',function(){return this._innerSecondLevelLoaderManager=new LoaderManager();},'_innerThirdLevelLoaderManager',function(){return this._innerThirdLevelLoaderManager=new LoaderManager();},'_innerFourthLevelLoaderManager',function(){return this._innerFourthLevelLoaderManager=new LoaderManager();}
	]);
	return Laya3D;
})()


/**
*<code>Transform3D</code> 类用于实现3D变换。
*/
//class laya.d3.animation.AnimationTransform3D extends laya.events.EventDispatcher
var AnimationTransform3D=(function(_super){
	function AnimationTransform3D(owner){
		/**@private */
		//this._localMatrix=null;
		/**@private */
		//this._worldMatrix=null;
		/**@private */
		//this._localPosition=null;
		/**@private */
		//this._localRotation=null;
		/**@private */
		//this._localScale=null;
		/**@private */
		//this._localQuaternionUpdate=false;
		/**@private */
		//this._locaEulerlUpdate=false;
		/**@private */
		//this._localUpdate=false;
		/**@private */
		//this._parent=null;
		/**@private */
		//this._childs=null;
		/**@private */
		//this._localRotationEuler=null;
		/**@private */
		//this._owner=null;
		/**@private */
		//this._worldUpdate=false;
		/**@private */
		//this._entity=null;
		AnimationTransform3D.__super.call(this);
		this._owner=owner;
		this._childs=[];
		this._localMatrix=new Float32Array(16);
		this._localQuaternionUpdate=false;
		this._locaEulerlUpdate=false;
		this._localUpdate=false;
		this._worldUpdate=true;
	}

	__class(AnimationTransform3D,'laya.d3.animation.AnimationTransform3D',_super);
	var __proto=AnimationTransform3D.prototype;
	/**
	*@private
	*/
	__proto._getlocalMatrix=function(){
		if (this._localUpdate){
			Utils3D._createAffineTransformationArray(this._localPosition,this._localRotation,this._localScale,this._localMatrix);
			this._localUpdate=false;
		}
		return this._localMatrix;
	}

	/**
	*@private
	*/
	__proto._onWorldTransform=function(){
		if (!this._worldUpdate){
			this._worldUpdate=true;
			for (var i=0,n=this._childs.length;i < n;i++)
			this._childs[i]._onWorldTransform();
		}
	}

	/**
	*@private
	*/
	__proto._setWorldMatrixAndUpdate=function(matrix){
		this._worldMatrix=matrix;
		if (this._parent==null){
			throw new Error("don't need to set worldMatrix to root Node.");
			}else {
			if (this._parent._parent==null){
				var locMat=this._getlocalMatrix();
				for (var i=0;i < 16;++i)
				this._worldMatrix[i]=locMat[i];
				}else {
				Utils3D.matrix4x4MultiplyFFF(this._parent.getWorldMatrix(),this._getlocalMatrix(),this._worldMatrix);
			}
		}
		this._worldUpdate=false;
	}

	/**
	*@private
	*/
	__proto._setWorldMatrixNoUpdate=function(matrix){
		this._worldMatrix=matrix;
	}

	/**
	*@private
	*/
	__proto._setWorldMatrixIgnoreUpdate=function(matrix){
		this._worldMatrix=matrix;
		this._worldUpdate=false;
	}

	/**
	*获取局部位置。
	*@return 局部位置。
	*/
	__proto.getLocalPosition=function(){
		return this._localPosition;
	}

	/**
	*设置局部位置。
	*@param value 局部位置。
	*/
	__proto.setLocalPosition=function(value){
		if (this._parent){
			this._localPosition=value;
			this._localUpdate=true;
			this._onWorldTransform();
			}else {
			var entityTransform=this._entity.owner._transform;
			var entityPosition=this._entity.localPosition;
			var entityPositionE=entityPosition.elements;
			entityPositionE[0]=value[0];
			entityPositionE[1]=value[1];
			entityPositionE[2]=value[2];
			entityTransform.localPosition=entityPosition;
		}
	}

	/**
	*获取局部旋转。
	*@return 局部旋转。
	*/
	__proto.getLocalRotation=function(){
		if (this._localQuaternionUpdate){
			var eulerE=this._localRotationEuler;
			Utils3D._quaternionCreateFromYawPitchRollArray(eulerE[1] / AnimationTransform3D._angleToRandin,eulerE[0] / AnimationTransform3D._angleToRandin,eulerE[2] / AnimationTransform3D._angleToRandin,this._localRotation);
			this._localQuaternionUpdate=false;
		}
		return this._localRotation;
	}

	/**
	*设置局部旋转。
	*@param value 局部旋转。
	*/
	__proto.setLocalRotation=function(value){
		if (this._parent){
			this._localRotation=value;
			Utils3D.quaterionNormalize(this._localRotation,this._localRotation);
			this._locaEulerlUpdate=true;
			this._localQuaternionUpdate=false;
			this._localUpdate=true;
			this._onWorldTransform();
			}else {
			var entityTransform=this._entity.owner._transform;
			var entityRotation=this._entity.localRotation;
			var entityRotationE=entityRotation.elements;
			entityRotationE[0]=value[0];
			entityRotationE[1]=value[1];
			entityRotationE[2]=value[2];
			entityRotationE[3]=value[3];
			entityTransform.localRotation=entityRotation;
		}
	}

	/**
	*获取局部缩放。
	*@return 局部缩放。
	*/
	__proto.getLocalScale=function(){
		return this._localScale;
	}

	/**
	*设置局部缩放。
	*@param value 局部缩放。
	*/
	__proto.setLocalScale=function(value){
		if (this._parent){
			this._localScale=value;
			this._localUpdate=true;
			this._onWorldTransform();
			}else {
			var entityTransform=this._entity.owner._transform;
			var entityScale=this._entity.localScale;
			var entityScaleE=entityScale.elements;
			entityScaleE[0]=value[0];
			entityScaleE[1]=value[1];
			entityScaleE[2]=value[2];
			entityTransform.localScale=entityScale;
		}
	}

	/**
	*获取局部空间的旋转角度。
	*@return 欧拉角的旋转值，顺序为x、y、z。
	*/
	__proto.getLocalRotationEuler=function(){
		if (this._locaEulerlUpdate){
			Utils3D.getYawPitchRoll(this._localRotation,AnimationTransform3D._tempVector3);
			var eulerE=AnimationTransform3D._tempVector3;
			var localRotationEulerE=this._localRotationEuler;
			localRotationEulerE[0]=eulerE[1] *AnimationTransform3D._angleToRandin;
			localRotationEulerE[1]=eulerE[0] *AnimationTransform3D._angleToRandin;
			localRotationEulerE[2]=eulerE[2] *AnimationTransform3D._angleToRandin;
			this._locaEulerlUpdate=false;
		}
		return this._localRotationEuler;
	}

	/**
	*设置局部空间的旋转角度。
	*@param value 欧拉角的旋转值，顺序为x、y、z。
	*/
	__proto.setLocalRotationEuler=function(value){
		if (this._parent){
			Utils3D._quaternionCreateFromYawPitchRollArray(value[1] / AnimationTransform3D._angleToRandin,value[0] / AnimationTransform3D._angleToRandin,value[2] / AnimationTransform3D._angleToRandin,this._localRotation);
			this._localRotationEuler=value;
			this._locaEulerlUpdate=false;
			this._localQuaternionUpdate=false;
			this._localUpdate=true;
			this._onWorldTransform();
			}else {
			var entityTransform=this._entity.owner._transform;
			var entityLocalRotationEuler=this._entity.localRotationEuler;
			var elements=entityLocalRotationEuler.elements;
			elements[0]=value[0];
			elements[1]=value[1];
			elements[2]=value[2];
			entityTransform.localRotationEuler=entityLocalRotationEuler;
		}
	}

	/**
	*获取世界矩阵。
	*@return 世界矩阵。
	*/
	__proto.getWorldMatrix=function(){
		if (this._worldUpdate){
			if (this._parent._parent !=null){
				Utils3D.matrix4x4MultiplyFFF(this._parent.getWorldMatrix(),this._getlocalMatrix(),this._worldMatrix);
				}else {
				var locMat=this._getlocalMatrix();
				for (var i=0;i < 16;++i)
				this._worldMatrix[i]=locMat[i];
			}
			this._worldUpdate=false;
		}
		return this._worldMatrix;
	}

	/**
	*设置父3D变换。
	*@param value 父3D变换。
	*/
	__proto.setParent=function(value){
		if (this._parent!==value){
			if (this._parent){
				var parentChilds=this._parent._childs;
				var index=parentChilds.indexOf(this);
				parentChilds.splice(index,1);
			}
			if (value){
				value._childs.push(this);
				(value)&& (this._onWorldTransform());
			}
			this._parent=value;
		}
	}

	__static(AnimationTransform3D,
	['_tempVector3',function(){return this._tempVector3=new Float32Array(3);},'_angleToRandin',function(){return this._angleToRandin=180 / Math.PI;}
	]);
	return AnimationTransform3D;
})(EventDispatcher)


/**
*<code>Component3D</code> 类用于创建组件的父类。
*/
//class laya.d3.component.Component3D extends laya.events.EventDispatcher
var Component3D=(function(_super){
	function Component3D(){
		/**@private */
		this._destroyed=false;
		/**@private 唯一标识ID。*/
		this._id=0;
		/**@private 是否启动。*/
		this._enable=false;
		/**@private 所属Sprite3D节点。*/
		this._owner=null;
		/**是否已执行start函数。*/
		this.started=false;
		Component3D.__super.call(this);
		this._destroyed=false;
		this._id=Component3D._uniqueIDCounter;
		Component3D._uniqueIDCounter++;
	}

	__class(Component3D,'laya.d3.component.Component3D',_super);
	var __proto=Component3D.prototype;
	Laya.imps(__proto,{"laya.d3.core.render.IUpdate":true,"laya.resource.IDestroy":true})
	/**
	*@private
	*初始化组件。
	*@param owner 所属Sprite3D节点。
	*/
	__proto._initialize=function(owner){
		this._owner=owner;
		this._enable=true;
		this.started=false;
		this._load(owner);
	}

	/**
	*@private
	*销毁组件。
	*/
	__proto._destroy=function(){
		this._unload(this._owner);
		this._owner=null;
		this._destroyed=true;
	}

	/**
	*@private
	*载入组件时执行,可重写此函数。
	*/
	__proto._load=function(owner){}
	/**
	*@private
	*在任意第一次更新时执行,可重写此函数。
	*/
	__proto._start=function(state){}
	/**
	*@private
	*更新组件,可重写此函数。
	*@param state 渲染状态参数。
	*/
	__proto._update=function(state){}
	/**
	*@private
	*更新的最后阶段执行,可重写此函数。
	*@param state 渲染状态参数。
	*/
	__proto._lateUpdate=function(state){}
	/**
	*@private
	*渲染前设置组件相关参数,可重写此函数。
	*@param state 渲染状态参数。
	*/
	__proto._preRenderUpdate=function(state){}
	/**
	*@private
	*渲染的最后阶段执行,可重写此函数。
	*@param state 渲染状态参数。
	*/
	__proto._postRenderUpdate=function(state){}
	/**
	*@private
	*卸载组件时执行,可重写此函数。
	*/
	__proto._unload=function(owner){
		this.offAll();
	}

	/**
	*@private
	*/
	__proto._cloneTo=function(dest){}
	/**
	*获取唯一标识ID。
	*@return 唯一标识ID。
	*/
	__getset(0,__proto,'id',function(){
		return this._id;
	});

	/**
	*获取是否已销毁。
	*@return 是否已销毁。
	*/
	__getset(0,__proto,'destroyed',function(){
		return this._destroyed;
	});

	/**
	*获取所属Sprite3D节点。
	*@return 所属Sprite3D节点。
	*/
	__getset(0,__proto,'owner',function(){
		return this._owner;
	});

	/**
	*设置是否启用。
	*@param value 是否启动
	*/
	/**
	*获取是否启用。
	*@return 是否启动。
	*/
	__getset(0,__proto,'enable',function(){
		return this._enable;
		},function(value){
		if (this._enable!==value){
			this._enable=value;
			this.event(/*laya.events.Event.ENABLE_CHANGED*/"enablechanged",this._enable);
		}
	});

	/**
	*获取是否为单实例组件。
	*@return 是否为单实例组件。
	*/
	__getset(0,__proto,'isSingleton',function(){
		return Component3D._isSingleton;
	});

	Component3D._isSingleton=true;
	Component3D._uniqueIDCounter=1;
	return Component3D;
})(EventDispatcher)


/**
*<code>GeometryFilter</code> 类用于创建集合体过滤器,抽象类不允许实例。
*/
//class laya.d3.core.GeometryFilter extends laya.events.EventDispatcher
var GeometryFilter=(function(_super){
	function GeometryFilter(){
		/**@private */
		this._destroyed=false;
		GeometryFilter.__super.call(this);
		this._destroyed=false;
	}

	__class(GeometryFilter,'laya.d3.core.GeometryFilter',_super);
	var __proto=GeometryFilter.prototype;
	Laya.imps(__proto,{"laya.resource.IDestroy":true})
	/**
	*@private
	*/
	__proto._destroy=function(){
		this.offAll();
		this._destroyed=true;
	}

	/**@private */
	__getset(0,__proto,'_isAsyncLoaded',function(){
		return true;
	});

	/**
	*@private
	*/
	__getset(0,__proto,'_originalBoundingBoxCorners',function(){
		throw new Error("BaseRender: must override it.");
	});

	/**
	*@private
	*/
	__getset(0,__proto,'_originalBoundingSphere',function(){
		throw new Error("BaseRender: must override it.");
	});

	/**
	*@private
	*/
	__getset(0,__proto,'_originalBoundingBox',function(){
		throw new Error("BaseRender: must override it.");
	});

	/**
	*获取是否已销毁。
	*@return 是否已销毁。
	*/
	__getset(0,__proto,'destroyed',function(){
		return this._destroyed;
	});

	return GeometryFilter;
})(EventDispatcher)


/**
*<code>Render</code> 类用于渲染器的父类，抽象类不允许实例。
*/
//class laya.d3.core.render.BaseRender extends laya.events.EventDispatcher
var BaseRender=(function(_super){
	function BaseRender(owner){
		/**@private */
		//this._id=0;
		/**@private */
		//this._destroyed=false;
		/**@private */
		//this._lightmapScaleOffset=null;
		/**@private */
		//this._lightmapIndex=0;
		/**@private */
		//this._enable=false;
		/**@private */
		//this._receiveShadow=false;
		/**@private */
		//this._materialsInstance=null;
		/**@private */
		//this._boundingSphere=null;
		/**@private */
		//this._boundingBox=null;
		/**@private */
		//this._boundingBoxCenter=null;
		/**@private */
		//this._boundingSphereNeedChange=false;
		/**@private */
		//this._boundingBoxNeedChange=false;
		/**@private */
		//this._boundingBoxCenterNeedChange=false;
		/**@private */
		//this._octreeNodeNeedChange=false;
		/**@private */
		//this._indexInSceneFrustumCullingObjects=0;
		/**@private */
		//this._materials=null;
		/**@private */
		//this._owner=null;
		/**@private */
		//this._renderElements=null;
		/**@private */
		//this._distanceForSort=NaN;
		/**@private */
		//this._treeNode=null;
		/**@private */
		//this._isPartOfStaticBatch=false;
		/**@private */
		//this._staticBatchRootSprite3D=null;
		/**@private */
		//this._staticBatchRenderElements=null;
		/**排序矫正值。*/
		//this.sortingFudge=NaN;
		/**是否产生阴影。 */
		//this.castShadow=false;
		BaseRender.__super.call(this);
		this._id=++BaseRender._uniqueIDCounter;
		this._indexInSceneFrustumCullingObjects=-1;
		this._boundingBox=new BoundBox(new Vector3(),new Vector3());
		this._boundingBoxCenter=new Vector3();
		this._boundingSphere=new BoundSphere(new Vector3(),0);
		this._boundingSphereNeedChange=true;
		this._boundingBoxNeedChange=true;
		this._boundingBoxCenterNeedChange=true;
		this._octreeNodeNeedChange=true;
		this._materials=[];
		this._renderElements=[];
		this._isPartOfStaticBatch=false;
		this._destroyed=false;
		this._owner=owner;
		this._enable=true;
		this._materialsInstance=[];
		this.lightmapIndex=-1;
		this.castShadow=false;
		this.receiveShadow=false;
		this.sortingFudge=0.0;
		this._owner.transform.on(/*laya.events.Event.WORLDMATRIX_NEEDCHANGE*/"worldmatrixneedchanged",this,this._onWorldMatNeedChange);
	}

	__class(BaseRender,'laya.d3.core.render.BaseRender',_super);
	var __proto=BaseRender.prototype;
	Laya.imps(__proto,{"laya.resource.IDestroy":true})
	/**
	*@private
	*/
	__proto._changeMaterialReference=function(lastValue,value){
		(lastValue)&& (lastValue._removeReference());
		value._addReference();
	}

	/**
	*@private
	*/
	__proto._getInstanceMaterial=function(material,index){
		var insMat=/*__JS__ */new material.constructor();
		material.cloneTo(insMat);
		insMat.name=insMat.name+"(Instance)";
		this._materialsInstance[index]=true;
		this._changeMaterialReference(this._materials[index],insMat);
		this._materials[index]=insMat;
		return insMat;
	}

	/**
	*@private
	*/
	__proto._setShaderValuelightMap=function(lightMap){
		this._setShaderValueTexture(/*laya.d3.core.RenderableSprite3D.LIGHTMAP*/3,lightMap);
	}

	/**
	*@private
	*/
	__proto._onWorldMatNeedChange=function(){
		this._boundingSphereNeedChange=true;
		this._boundingBoxNeedChange=true;
		this._boundingBoxCenterNeedChange=true;
		this._octreeNodeNeedChange=true;
	}

	/**
	*@private
	*/
	__proto._renderRenderableBoundBox=function(){
		var linePhasor=Laya3D._debugPhasorSprite;
		var boundBox=this.boundingBox;
		var corners=BaseRender._tempBoundBoxCorners;
		boundBox.getCorners(corners);
		linePhasor.line(corners[0],BaseRender._greenColor,corners[1],BaseRender._greenColor);
		linePhasor.line(corners[2],BaseRender._greenColor,corners[3],BaseRender._greenColor);
		linePhasor.line(corners[4],BaseRender._greenColor,corners[5],BaseRender._greenColor);
		linePhasor.line(corners[6],BaseRender._greenColor,corners[7],BaseRender._greenColor);
		linePhasor.line(corners[0],BaseRender._greenColor,corners[3],BaseRender._greenColor);
		linePhasor.line(corners[1],BaseRender._greenColor,corners[2],BaseRender._greenColor);
		linePhasor.line(corners[2],BaseRender._greenColor,corners[6],BaseRender._greenColor);
		linePhasor.line(corners[3],BaseRender._greenColor,corners[7],BaseRender._greenColor);
		linePhasor.line(corners[0],BaseRender._greenColor,corners[4],BaseRender._greenColor);
		linePhasor.line(corners[1],BaseRender._greenColor,corners[5],BaseRender._greenColor);
		linePhasor.line(corners[4],BaseRender._greenColor,corners[7],BaseRender._greenColor);
		linePhasor.line(corners[5],BaseRender._greenColor,corners[6],BaseRender._greenColor);
	}

	/**
	*@private
	*/
	__proto._calculateBoundingSphere=function(){
		throw("BaseRender: must override it.");
	}

	/**
	*@private
	*/
	__proto._calculateBoundingBox=function(){
		throw("BaseRender: must override it.");
	}

	/**
	*@private
	*/
	__proto._setShaderValueTexture=function(shaderName,texture){
		this._owner._shaderValues.setValue(shaderName,texture);
	}

	/**
	*@private
	*/
	__proto._setShaderValueMatrix4x4=function(shaderName,matrix4x4){
		this._owner._shaderValues.setValue(shaderName,matrix4x4 ? matrix4x4.elements :null);
	}

	/**
	*设置颜色。
	*@param shaderIndex shader索引。
	*@param color 颜色向量。
	*/
	__proto._setShaderValueColor=function(shaderIndex,color){
		this._owner._shaderValues.setValue(shaderIndex,color ? color.elements :null);
	}

	/**
	*设置Buffer。
	*@param shaderIndex shader索引。
	*@param buffer buffer数据。
	*/
	__proto._setShaderValueBuffer=function(shaderIndex,buffer){
		this._owner._shaderValues.setValue(shaderIndex,buffer);
	}

	/**
	*设置整型。
	*@param shaderIndex shader索引。
	*@param i 整形。
	*/
	__proto._setShaderValueInt=function(shaderIndex,i){
		this._owner._shaderValues.setValue(shaderIndex,i);
	}

	/**
	*设置布尔。
	*@param shaderIndex shader索引。
	*@param b 布尔。
	*/
	__proto._setShaderValueBool=function(shaderIndex,b){
		this._owner._shaderValues.setValue(shaderIndex,b);
	}

	/**
	*设置浮点。
	*@param shaderIndex shader索引。
	*@param i 浮点。
	*/
	__proto._setShaderValueNumber=function(shaderIndex,number){
		this._owner._shaderValues.setValue(shaderIndex,number);
	}

	/**
	*设置二维向量。
	*@param shaderIndex shader索引。
	*@param vector2 二维向量。
	*/
	__proto._setShaderValueVector2=function(shaderIndex,vector2){
		this._owner._shaderValues.setValue(shaderIndex,vector2 ? vector2.elements :null);
	}

	/**
	*增加Shader宏定义。
	*@param value 宏定义。
	*/
	__proto._addShaderDefine=function(value){
		this._owner._shaderDefineValue |=value;
	}

	/**
	*移除Shader宏定义。
	*@param value 宏定义。
	*/
	__proto._removeShaderDefine=function(value){
		this._owner._shaderDefineValue &=~value;
	}

	/**
	*@private
	*/
	__proto._renderUpdate=function(projectionView){
		return true;
	}

	/**
	*@private
	*/
	__proto._applyLightMapParams=function(){
		if (this._lightmapIndex >=0){
			var scene=this._owner.scene;
			if (scene){
				var lightMaps=scene.getlightmaps();
				var lightMap=lightMaps[this._lightmapIndex];
				if (lightMap){
					this._addShaderDefine(RenderableSprite3D.SAHDERDEFINE_LIGHTMAP);
					if (lightMap.loaded)
						this._setShaderValuelightMap(lightMap);
					else
					lightMap.once(/*laya.events.Event.LOADED*/"loaded",this,this._setShaderValuelightMap);
					}else {
					this._removeShaderDefine(RenderableSprite3D.SAHDERDEFINE_LIGHTMAP);
				}
				}else {
				this._removeShaderDefine(RenderableSprite3D.SAHDERDEFINE_LIGHTMAP);
			}
			}else {
			this._removeShaderDefine(RenderableSprite3D.SAHDERDEFINE_LIGHTMAP);
		}
	}

	/**
	*@private
	*/
	__proto._updateOctreeNode=function(){
		var treeNode=this._treeNode;
		if (treeNode && this._octreeNodeNeedChange){
			treeNode.updateObject(this);
			this._octreeNodeNeedChange=false;
		}
	}

	/**
	*@private
	*/
	__proto._destroy=function(){
		this.offAll();
		var i=0,n=0;
		for (i=0,n=this._renderElements.length;i < n;i++)
		this._renderElements[i]._destroy();
		for (i=0,n=this._materials.length;i < n;i++)
		this._materials[i]._removeReference();
		this._renderElements=null;
		this._owner=null;
		this._materials=null;
		this._boundingBox=null;
		this._boundingBoxCenter=null;
		this._boundingSphere=null;
		this._lightmapScaleOffset=null;
		this._destroyed=true;
	}

	/**
	*获取包围球,只读,不允许修改其值。
	*@return 包围球。
	*/
	__getset(0,__proto,'boundingSphere',function(){
		if (this._boundingSphereNeedChange){
			this._calculateBoundingSphere();
			this._boundingSphereNeedChange=false;
		}
		return this._boundingSphere;
	});

	/**
	*获取唯一标识ID,通常用于识别。
	*/
	__getset(0,__proto,'id',function(){
		return this._id;
	});

	/**
	*设置第一个实例材质。
	*@param value 第一个实例材质。
	*/
	/**
	*返回第一个实例材质,第一次使用会拷贝实例对象。
	*@return 第一个实例材质。
	*/
	__getset(0,__proto,'material',function(){
		var material=this._materials[0];
		if (material && !this._materialsInstance[0]){
			var insMat=this._getInstanceMaterial(material,0);
			this.event(/*laya.events.Event.MATERIAL_CHANGED*/"materialchanged",[this,0,insMat]);
		}
		return this._materials[0];
		},function(value){
		this.sharedMaterial=value;
	});

	/**
	*设置第一个材质。
	*@param value 第一个材质。
	*/
	/**
	*返回第一个材质。
	*@return 第一个材质。
	*/
	__getset(0,__proto,'sharedMaterial',function(){
		return this._materials[0];
		},function(value){
		var lastValue=this._materials[0];
		if (lastValue!==value){
			this._materials[0]=value;
			this._materialsInstance[0]=false;
			this._changeMaterialReference(lastValue,value);
			this.event(/*laya.events.Event.MATERIAL_CHANGED*/"materialchanged",[this,0,value]);
		}
	});

	/**
	*设置光照贴图的索引。
	*@param value 光照贴图的索引。
	*/
	/**
	*获取光照贴图的索引。
	*@return 光照贴图的索引。
	*/
	__getset(0,__proto,'lightmapIndex',function(){
		return this._lightmapIndex;
		},function(value){
		this._lightmapIndex=value;
		this._applyLightMapParams();
	});

	/**
	*设置光照贴图的缩放和偏移。
	*@param 光照贴图的缩放和偏移。
	*/
	/**
	*获取光照贴图的缩放和偏移。
	*@return 光照贴图的缩放和偏移。
	*/
	__getset(0,__proto,'lightmapScaleOffset',function(){
		return this._lightmapScaleOffset;
		},function(value){
		this._lightmapScaleOffset=value;
		this._setShaderValueColor(/*laya.d3.core.RenderableSprite3D.LIGHTMAPSCALEOFFSET*/2,value);
		this._addShaderDefine(RenderableSprite3D.SHADERDEFINE_SCALEOFFSETLIGHTINGMAPUV);
	});

	/**
	*设置是否可用。
	*@param value 是否可用。
	*/
	/**
	*获取是否可用。
	*@return 是否可用。
	*/
	__getset(0,__proto,'enable',function(){
		return this._enable;
		},function(value){
		this._enable=value;
		this.event(/*laya.events.Event.ENABLE_CHANGED*/"enablechanged",[this,value]);
	});

	/**
	*设置实例材质列表。
	*@param value 实例材质列表。
	*/
	/**
	*获取潜拷贝实例材质列表,第一次使用会拷贝实例对象。
	*@return 浅拷贝实例材质列表。
	*/
	__getset(0,__proto,'materials',function(){
		for (var i=0,n=this._materials.length;i < n;i++){
			if (!this._materialsInstance[i]){
				var insMat=this._getInstanceMaterial(this._materials[i],i);
				this.event(/*laya.events.Event.MATERIAL_CHANGED*/"materialchanged",[this,i,insMat]);
			}
		}
		return this._materials.slice();
		},function(value){
		this.sharedMaterials=value;
	});

	/**
	*设置材质列表。
	*@param value 材质列表。
	*/
	/**
	*获取浅拷贝材质列表。
	*@return 浅拷贝材质列表。
	*/
	__getset(0,__proto,'sharedMaterials',function(){
		var materials=this._materials.slice();
		return materials;
		},function(value){
		if (!value)
			throw new Error("MeshRender: shadredMaterials value can't be null.");
		var len=value.length;
		this._materialsInstance.length=len;
		for (var i=0;i < len;i++){
			var lastValue=this._materials[i];
			if (lastValue!==value[i]){
				this._materialsInstance[i]=false;
				this._changeMaterialReference(lastValue,value[i]);
				this.event(/*laya.events.Event.MATERIAL_CHANGED*/"materialchanged",[this,i,value[i]]);
			}
		}
		this._materials=value;
	});

	/**
	*获取包围盒,只读,不允许修改其值。
	*@return 包围盒。
	*/
	__getset(0,__proto,'boundingBox',function(){
		if (this._boundingBoxNeedChange){
			this._calculateBoundingBox();
			this._boundingBoxNeedChange=false;
		}
		return this._boundingBox;
	});

	/**
	*获取包围盒中心,不允许修改其值。
	*@return 包围盒中心。
	*/
	__getset(0,__proto,'boundingBoxCenter',function(){
		if (this._boundingBoxCenterNeedChange){
			var boundBox=this.boundingBox;
			Vector3.add(boundBox.min,boundBox.max,this._boundingBoxCenter);
			Vector3.scale(this._boundingBoxCenter,0.5,this._boundingBoxCenter);
			this._boundingBoxCenterNeedChange=false;
		}
		return this._boundingBoxCenter;
	});

	/**
	*设置是否接收阴影属性
	*/
	/**
	*获得是否接收阴影属性
	*/
	__getset(0,__proto,'receiveShadow',function(){
		return this._receiveShadow;
		},function(value){
		if (this._receiveShadow!==value){
			this._receiveShadow=value;
			if (value)
				this._addShaderDefine(ParallelSplitShadowMap.SHADERDEFINE_RECEIVE_SHADOW);
			else
			this._removeShaderDefine(ParallelSplitShadowMap.SHADERDEFINE_RECEIVE_SHADOW);
		}
	});

	/**
	*获取是否已销毁。
	*@return 是否已销毁。
	*/
	__getset(0,__proto,'destroyed',function(){
		return this._destroyed;
	});

	BaseRender._uniqueIDCounter=0;
	__static(BaseRender,
	['_tempBoundBoxCorners',function(){return this._tempBoundBoxCorners=/*new vector.<>*/[new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3()];},'_greenColor',function(){return this._greenColor=new Vector4(0.0,1.0,0.0,1.0);}
	]);
	return BaseRender;
})(EventDispatcher)


/**
*<code>Transform3D</code> 类用于实现3D变换。
*/
//class laya.d3.core.Transform3D extends laya.events.EventDispatcher
var Transform3D=(function(_super){
	function Transform3D(owner){
		/**@private */
		this._owner=null;
		/**@private */
		this._localQuaternionUpdate=false;
		/**@private */
		this._locaEulerlUpdate=false;
		/**@private */
		this._localUpdate=false;
		/**@private */
		this._worldUpdate=true;
		/**@private */
		this._positionUpdate=true;
		/**@private */
		this._rotationUpdate=true;
		/**@private */
		this._scaleUpdate=true;
		/**@private */
		this._parent=null;
		/**@private */
		this._childs=null;
		/**@private */
		this._dummy=null;
		/**变换中心点,注意:该中心点不受变换的影响。*/
		this.pivot=null;
		Transform3D.__super.call(this);
		this._localPosition=new Vector3();
		this._localRotation=new Quaternion(0,0,0,1);
		this._localScale=new Vector3(1,1,1);
		this._localRotationEuler=new Vector3();
		this._localMatrix=new Matrix4x4();
		this._position=new Vector3();
		this._rotation=new Quaternion(0,0,0,1);
		this._scale=new Vector3(1,1,1);
		this._worldMatrix=new Matrix4x4();
		this._forward=new Vector3();
		this._up=new Vector3();
		this._right=new Vector3();
		this._owner=owner;
		this._childs=[];
	}

	__class(Transform3D,'laya.d3.core.Transform3D',_super);
	var __proto=Transform3D.prototype;
	/**
	*@private
	*/
	__proto._updateLocalMatrix=function(){
		if (this.pivot && (this.pivot.x!==0 || this.pivot.y!==0 || this.pivot.z!==0)){
			var scalePivot=Transform3D._tempVector30;
			Vector3.multiply(this.pivot,this._localScale,scalePivot);
			var scaleOffsetPosition=Transform3D._tempVector31;
			Vector3.subtract(scalePivot,this.pivot,scaleOffsetPosition);
			var rotationOffsetPosition=Transform3D._tempVector32;
			var localRot=this.localRotation;
			Vector3.transformQuat(scalePivot,localRot,rotationOffsetPosition);
			Vector3.subtract(rotationOffsetPosition,scalePivot,rotationOffsetPosition);
			var resultLocalPosition=Transform3D._tempVector33;
			Vector3.subtract(this._localPosition,scaleOffsetPosition,resultLocalPosition);
			Vector3.subtract(resultLocalPosition,rotationOffsetPosition,resultLocalPosition);
			Matrix4x4.createAffineTransformation(resultLocalPosition,localRot,this._localScale,this._localMatrix);
			}else {
			Matrix4x4.createAffineTransformation(this._localPosition,this.localRotation,this._localScale,this._localMatrix);
		}
	}

	/**
	*@private
	*/
	__proto._onWorldPositionRotationTransform=function(){
		if (!this._worldUpdate || !this._positionUpdate || !this._rotationUpdate){
			this._worldUpdate=this._positionUpdate=this._rotationUpdate=true;
			this.event(/*laya.events.Event.WORLDMATRIX_NEEDCHANGE*/"worldmatrixneedchanged");
			for (var i=0,n=this._childs.length;i < n;i++)
			this._childs[i]._onWorldPositionRotationTransform();
		}
	}

	/**
	*@private
	*/
	__proto._onWorldPositionScaleTransform=function(){
		if (!this._worldUpdate || !this._positionUpdate || !this._scaleUpdate){
			this._worldUpdate=this._positionUpdate=this._scaleUpdate=true;
			this.event(/*laya.events.Event.WORLDMATRIX_NEEDCHANGE*/"worldmatrixneedchanged");
			for (var i=0,n=this._childs.length;i < n;i++)
			this._childs[i]._onWorldPositionScaleTransform();
		}
	}

	/**
	*@private
	*/
	__proto._onWorldPositionTransform=function(){
		if (!this._worldUpdate || !this._positionUpdate){
			this._worldUpdate=this._positionUpdate=true;
			this.event(/*laya.events.Event.WORLDMATRIX_NEEDCHANGE*/"worldmatrixneedchanged");
			for (var i=0,n=this._childs.length;i < n;i++)
			this._childs[i]._onWorldPositionTransform();
		}
	}

	/**
	*@private
	*/
	__proto._onWorldRotationTransform=function(){
		if (!this._worldUpdate || !this._rotationUpdate){
			this._worldUpdate=this._rotationUpdate=true;
			this.event(/*laya.events.Event.WORLDMATRIX_NEEDCHANGE*/"worldmatrixneedchanged");
			for (var i=0,n=this._childs.length;i < n;i++)
			this._childs[i]._onWorldPositionRotationTransform();
		}
	}

	/**
	*@private
	*/
	__proto._onWorldScaleTransform=function(){
		if (!this._worldUpdate || !this._scaleUpdate){
			this._worldUpdate=this._scaleUpdate=true;
			this.event(/*laya.events.Event.WORLDMATRIX_NEEDCHANGE*/"worldmatrixneedchanged");
			for (var i=0,n=this._childs.length;i < n;i++)
			this._childs[i]._onWorldPositionScaleTransform();
		}
	}

	/**
	*@private
	*/
	__proto._onWorldTransform=function(){
		if (!this._worldUpdate || !this._positionUpdate || !this._rotationUpdate || !this._scaleUpdate){
			this._worldUpdate=this._positionUpdate=this._rotationUpdate=this._scaleUpdate=true;
			this.event(/*laya.events.Event.WORLDMATRIX_NEEDCHANGE*/"worldmatrixneedchanged");
			for (var i=0,n=this._childs.length;i < n;i++)
			this._childs[i]._onWorldTransform();
		}
	}

	/**
	*平移变换。
	*@param translation 移动距离。
	*@param isLocal 是否局部空间。
	*/
	__proto.translate=function(translation,isLocal){
		(isLocal===void 0)&& (isLocal=true);
		if (isLocal){
			Matrix4x4.createFromQuaternion(this.localRotation,Transform3D._tempMatrix0);
			Vector3.transformCoordinate(translation,Transform3D._tempMatrix0,Transform3D._tempVector30);
			Vector3.add(this.localPosition,Transform3D._tempVector30,this._localPosition);
			this.localPosition=this._localPosition;
			}else {
			Vector3.add(this.position,translation,this._position);
			this.position=this._position;
		}
	}

	/**
	*旋转变换。
	*@param rotations 旋转幅度。
	*@param isLocal 是否局部空间。
	*@param isRadian 是否弧度制。
	*/
	__proto.rotate=function(rotation,isLocal,isRadian){
		(isLocal===void 0)&& (isLocal=true);
		(isRadian===void 0)&& (isRadian=true);
		var rot;
		if (isRadian){
			rot=rotation;
			}else {
			Vector3.scale(rotation,Math.PI / 180.0,Transform3D._tempVector30);
			rot=Transform3D._tempVector30;
		}
		Quaternion.createFromYawPitchRoll(rot.y,rot.x,rot.z,Transform3D._tempQuaternion0);
		if (isLocal){
			Quaternion.multiply(this._localRotation,Transform3D._tempQuaternion0,this._localRotation);
			this.localRotation=this._localRotation;
			}else {
			Quaternion.multiply(Transform3D._tempQuaternion0,this.rotation,this._rotation);
			this.rotation=this._rotation;
		}
	}

	/**
	*观察目标位置。
	*@param target 观察目标。
	*@param up 向上向量。
	*@param isLocal 是否局部空间。
	*/
	__proto.lookAt=function(target,up,isLocal){
		(isLocal===void 0)&& (isLocal=false);
		var targetE=target.elements;
		var eyeE;
		if (isLocal){
			eyeE=this._localPosition.elements;
			if (Math.abs(eyeE[0]-targetE[0])< MathUtils3D.zeroTolerance && Math.abs(eyeE[1]-targetE[1])< MathUtils3D.zeroTolerance && Math.abs(eyeE[2]-targetE[2])< MathUtils3D.zeroTolerance)
				return;
			Quaternion.lookAt(this._localPosition,target,up,this._localRotation);
			this._localRotation.invert(this._localRotation);
			this.localRotation=this._localRotation;
			}else {
			var worldPosition=this.position;
			eyeE=worldPosition.elements;
			if (Math.abs(eyeE[0]-targetE[0])< MathUtils3D.zeroTolerance && Math.abs(eyeE[1]-targetE[1])< MathUtils3D.zeroTolerance && Math.abs(eyeE[2]-targetE[2])< MathUtils3D.zeroTolerance)
				return;
			Quaternion.lookAt(worldPosition,target,up,this._rotation);
			this._rotation.invert(this._rotation);
			this.rotation=this._rotation;
		}
	}

	/**
	*@private
	*/
	__getset(0,__proto,'_isFrontFaceInvert',function(){
		var scale=this.scale;
		var isInvert=scale.x < 0;
		(scale.y < 0)&& (isInvert=!isInvert);
		(scale.z < 0)&& (isInvert=!isInvert);
		return isInvert;
	});

	/**
	*获取所属精灵。
	*/
	__getset(0,__proto,'owner',function(){
		return this._owner;
	});

	/**
	*设置局部旋转。
	*@param value 局部旋转。
	*/
	/**
	*获取局部旋转。
	*@return 局部旋转。
	*/
	__getset(0,__proto,'localRotation',function(){
		if (this._localQuaternionUpdate){
			var eulerE=this._localRotationEuler.elements;
			Quaternion.createFromYawPitchRoll(eulerE[1] / Transform3D._angleToRandin,eulerE[0] / Transform3D._angleToRandin,eulerE[2] / Transform3D._angleToRandin,this._localRotation);
		}
		return this._localRotation;
		},function(value){
		this._localRotation=value;
		this._localRotation.normalize(this._localRotation);
		this._locaEulerlUpdate=true;
		this._localQuaternionUpdate=false;
		this._localUpdate=true;
		if (this.pivot && (this.pivot.x!==0 || this.pivot.y!==0 || this.pivot.z!==0))
			this._onWorldPositionRotationTransform();
		else
		this._onWorldRotationTransform();
	});

	/**
	*设置世界矩阵。
	*@param value 世界矩阵。
	*/
	/**
	*获取世界矩阵。
	*@return 世界矩阵。
	*/
	__getset(0,__proto,'worldMatrix',function(){
		if (this._worldUpdate){
			if (this._parent !=null)
				Matrix4x4.multiply(this._parent.worldMatrix,this.localMatrix,this._worldMatrix);
			else
			this.localMatrix.cloneTo(this._worldMatrix);
			this._worldUpdate=false;
		}
		return this._worldMatrix;
		},function(value){
		if (this._parent===null){
			value.cloneTo(this._localMatrix);
			}else {
			this._parent.worldMatrix.invert(this._localMatrix);
			Matrix4x4.multiply(this._localMatrix,value,this._localMatrix);
		}
		this.localMatrix=this._localMatrix;
		this._worldMatrix=value;
		this._worldUpdate=false;
	});

	/**
	*获取世界矩阵是否需要更新。
	*@return 世界矩阵是否需要更新。
	*/
	__getset(0,__proto,'worldNeedUpdate',function(){
		return this._worldUpdate;
	});

	/**
	*设置局部矩阵。
	*@param value 局部矩阵。
	*/
	/**
	*获取局部矩阵。
	*@return 局部矩阵。
	*/
	__getset(0,__proto,'localMatrix',function(){
		if (this._localUpdate){
			this._updateLocalMatrix();
			this._localUpdate=false;
		}
		return this._localMatrix;
		},function(value){
		this._localMatrix=value;
		this._localMatrix.decomposeTransRotScale(this._localPosition,this._localRotation,this._localScale);
		this._localUpdate=false;
		this._onWorldTransform();
	});

	/**
	*设置关联虚拟变换。
	*@param value 虚拟变换。
	*/
	/**
	*获取关联虚拟变换。
	*@return 虚拟变换。
	*/
	__getset(0,__proto,'dummy',function(){
		return this._dummy;
		},function(value){
		if (this._dummy!==value){
			(this._dummy)&& (this._dummy._entity=null);
			(value)&& (value._entity=this);
			this._dummy=value;
		}
	});

	/**
	*设置局部位置。
	*@param value 局部位置。
	*/
	/**
	*获取局部位置。
	*@return 局部位置。
	*/
	__getset(0,__proto,'localPosition',function(){
		return this._localPosition;
		},function(value){
		this._localPosition=value;
		this._localUpdate=true;
		this._onWorldPositionTransform();
	});

	/**
	*设置世界位置。
	*@param value 世界位置。
	*/
	/**
	*获取世界位置。
	*@return 世界位置。
	*/
	__getset(0,__proto,'position',function(){
		if (this._positionUpdate){
			if (this._parent !=null){
				var parentPosition=this._parent.position;
				Vector3.multiply(this._localPosition,this._parent.scale,Transform3D._tempVector30);
				Vector3.transformQuat(Transform3D._tempVector30,this._parent.rotation,Transform3D._tempVector30);
				Vector3.add(parentPosition,Transform3D._tempVector30,this._position);
				}else {
				this._localPosition.cloneTo(this._position);
			}
			this._positionUpdate=false;
		}
		return this._position;
		},function(value){
		if (this._parent !=null){
			Vector3.subtract(value,this._parent.position,this._localPosition);
			var parentScaleE=this._parent.scale.elements;
			var psX=parentScaleE[0],psY=parentScaleE[1],psZ=parentScaleE[2];
			if (psX!==1.0 || psY!==1.0 || psZ!==1.0){
				var invertScale=Transform3D._tempVector30;
				var invertScaleE=invertScale.elements;
				invertScaleE[0]=1.0 / psX;
				invertScaleE[1]=1.0 / psY;
				invertScaleE[2]=1.0 / psZ;
				Vector3.multiply(this._localPosition,invertScale,this._localPosition);
			};
			var parentRotation=this._parent.rotation;
			parentRotation.invert(Transform3D._tempQuaternion0);
			Vector3.transformQuat(this._localPosition,Transform3D._tempQuaternion0,this._localPosition);
			}else {
			value.cloneTo(this._localPosition);
		}
		this.localPosition=this._localPosition;
		this._position=value;
		this._positionUpdate=false;
	});

	/**
	*设置局部缩放。
	*@param value 局部缩放。
	*/
	/**
	*获取局部缩放。
	*@return 局部缩放。
	*/
	__getset(0,__proto,'localScale',function(){
		return this._localScale;
		},function(value){
		this._localScale=value;
		this._localUpdate=true;
		if (this.pivot && (this.pivot.x!==0 || this.pivot.y!==0 || this.pivot.z!==0))
			this._onWorldPositionScaleTransform();
		else
		this._onWorldScaleTransform();
	});

	/**
	*设置局部空间的旋转角度。
	*@param value 欧拉角的旋转值，顺序为x、y、z。
	*/
	/**
	*获取局部空间的旋转角度。
	*@return 欧拉角的旋转值，顺序为x、y、z。
	*/
	__getset(0,__proto,'localRotationEuler',function(){
		if (this._locaEulerlUpdate){
			this._localRotation.getYawPitchRoll(Transform3D._tempVector30);
			var eulerE=Transform3D._tempVector30.elements;
			var localRotationEulerE=this._localRotationEuler.elements;
			localRotationEulerE[0]=eulerE[1] *Transform3D._angleToRandin;
			localRotationEulerE[1]=eulerE[0] *Transform3D._angleToRandin;
			localRotationEulerE[2]=eulerE[2] *Transform3D._angleToRandin;
		}
		return this._localRotationEuler;
		},function(value){
		this._localRotationEuler=value;
		this._locaEulerlUpdate=false;
		this._localQuaternionUpdate=true;
		this._localUpdate=true;
		if (this.pivot && (this.pivot.x!==0 || this.pivot.y!==0 || this.pivot.z!==0))
			this._onWorldPositionRotationTransform();
		else
		this._onWorldRotationTransform();
	});

	/**
	*设置世界旋转。
	*@param value 世界旋转。
	*/
	/**
	*获取世界旋转。
	*@return 世界旋转。
	*/
	__getset(0,__proto,'rotation',function(){
		if (this._rotationUpdate){
			if (this._parent !=null)
				Quaternion.multiply(this._parent.rotation,this.localRotation,this._rotation);
			else
			this.localRotation.cloneTo(this._rotation);
			this._rotationUpdate=false;
		}
		return this._rotation;
		},function(value){
		if (this._parent !=null){
			this._parent.rotation.invert(Transform3D._tempQuaternion0);
			Quaternion.multiply(value,Transform3D._tempQuaternion0,this._localRotation);
			}else {
			value.cloneTo(this._localRotation);
		}
		this.localRotation=this._localRotation;
		this._rotation=value;
		this._rotationUpdate=false;
	});

	/**
	*设置世界缩放。
	*@param value 世界缩放。
	*/
	/**
	*获取世界缩放。
	*@return 世界缩放。
	*/
	__getset(0,__proto,'scale',function(){
		if (!this._scaleUpdate)
			return this._scale;
		if (this._parent!==null)
			Vector3.multiply(this._parent.scale,this._localScale,this._scale);
		else
		this._localScale.cloneTo(this._scale);
		this._scaleUpdate=false;
		return this._scale;
		},function(value){
		if (this._parent!==null){
			var pScaleE=this._parent.scale.elements;
			var invPScaleE=Transform3D._tempVector30.elements;
			invPScaleE[0]=1.0 / pScaleE[0];
			invPScaleE[1]=1.0 / pScaleE[1];
			invPScaleE[2]=1.0 / pScaleE[2];
			Vector3.multiply(value,Transform3D._tempVector30,this._localScale);
			}else {
			value.cloneTo(this._localScale);
		}
		this.localScale=this._localScale;
		this._scale=value;
		this._scaleUpdate=false;
	});

	/**
	*设置局部空间的旋转角度。
	*@param 欧拉角的旋转值，顺序为x、y、z。
	*/
	__getset(0,__proto,'rotationEuler',null,function(value){
		Quaternion.createFromYawPitchRoll(value.y,value.x,value.z,this._rotation);
		this.rotation=this._rotation;
	});

	/**
	*获取向前方向。
	*@return 向前方向。
	*/
	__getset(0,__proto,'forward',function(){
		var worldMatElem=this.worldMatrix.elements;
		this._forward.elements[0]=-worldMatElem[8];
		this._forward.elements[1]=-worldMatElem[9];
		this._forward.elements[2]=-worldMatElem[10];
		return this._forward;
	});

	/**
	*获取向上方向。
	*@return 向上方向。
	*/
	__getset(0,__proto,'up',function(){
		var worldMatElem=this.worldMatrix.elements;
		this._up.elements[0]=worldMatElem[4];
		this._up.elements[1]=worldMatElem[5];
		this._up.elements[2]=worldMatElem[6];
		return this._up;
	});

	/**
	*获取向右方向。
	*@return 向右方向。
	*/
	__getset(0,__proto,'right',function(){
		var worldMatElem=this.worldMatrix.elements;
		this._right.elements[0]=worldMatElem[0];
		this._right.elements[1]=worldMatElem[1];
		this._right.elements[2]=worldMatElem[2];
		return this._right;
	});

	/**
	*设置父3D变换。
	*@param value 父3D变换。
	*/
	/**
	*获取父3D变换。
	*@return 父3D变换。
	*/
	__getset(0,__proto,'parent',function(){
		return this._parent;
		},function(value){
		if (this._parent!==value){
			if (this._parent){
				var parentChilds=this._parent._childs;
				var index=parentChilds.indexOf(this);
				parentChilds.splice(index,1);
			}
			if (value){
				value._childs.push(this);
				(value)&& (this._onWorldTransform());
			}
			this._parent=value;
		}
	});

	__static(Transform3D,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempVector31',function(){return this._tempVector31=new Vector3();},'_tempVector32',function(){return this._tempVector32=new Vector3();},'_tempVector33',function(){return this._tempVector33=new Vector3();},'_tempQuaternion0',function(){return this._tempQuaternion0=new Quaternion();},'_tempMatrix0',function(){return this._tempMatrix0=new Matrix4x4();},'_angleToRandin',function(){return this._angleToRandin=180 / Math.PI;}
	]);
	return Transform3D;
})(EventDispatcher)


/**
*<code>TransformUV</code> 类用于实现UV变换。
*/
//class laya.d3.core.TransformUV extends laya.events.EventDispatcher
var TransformUV=(function(_super){
	function TransformUV(){
		/**@private */
		this._rotation=0;
		/**@private */
		//this._tiling=null;
		/**@private */
		this._matNeedUpdte=false;
		TransformUV.__super.call(this);
		this._matrix=new Matrix4x4();
		this._offset=new Vector2();
		this._tiling=new Vector2(1.0,1.0);
	}

	__class(TransformUV,'laya.d3.core.TransformUV',_super);
	var __proto=TransformUV.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*@private
	*/
	__proto._updateMatrix=function(){
		TransformUV._tempOffsetV3.elements[0]=this._offset.x;
		TransformUV._tempOffsetV3.elements[1]=this._offset.y;
		Quaternion.createFromYawPitchRoll(0,0,this._rotation,TransformUV._tempRotationQua);
		TransformUV._tempTitlingV3.elements[0]=this._tiling.x;
		TransformUV._tempTitlingV3.elements[1]=this._tiling.y;
		Matrix4x4.createAffineTransformation(TransformUV._tempOffsetV3,TransformUV._tempRotationQua,TransformUV._tempTitlingV3,this._matrix);
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		destObject._matrix=this._matrix.clone();
		destObject._offset=this._offset.clone();
		destObject._rotation=this._rotation;
		destObject._tiling=this._tiling.clone();
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	/**
	*获取变换矩阵。
	*@return 变换矩阵。
	*/
	__getset(0,__proto,'matrix',function(){
		if (this._matNeedUpdte){
			this._updateMatrix();
			this._matNeedUpdte=false;
		}
		return this._matrix;
	});

	/**
	*设置平铺次数。
	*@param value 平铺次数。
	*/
	/**
	*获取平铺次数。
	*@return 平铺次数。
	*/
	__getset(0,__proto,'tiling',function(){
		return this._tiling;
		},function(value){
		this._tiling=value;
		this._matNeedUpdte=true;
	});

	/**
	*设置偏移。
	*@param value 偏移。
	*/
	/**
	*获取偏移。
	*@return 偏移。
	*/
	__getset(0,__proto,'offset',function(){
		return this._offset;
		},function(value){
		this._offset=value;
		this._matNeedUpdte=true;
	});

	/**
	*设置旋转。
	*@param value 旋转。
	*/
	/**
	*获取旋转。
	*@return 旋转。
	*/
	__getset(0,__proto,'rotation',function(){
		return this._rotation;
		},function(value){
		this._rotation=value;
		this._matNeedUpdte=true;
	});

	__static(TransformUV,
	['_tempOffsetV3',function(){return this._tempOffsetV3=new Vector3(0,0,0);},'_tempRotationQua',function(){return this._tempRotationQua=new Quaternion();},'_tempTitlingV3',function(){return this._tempTitlingV3=new Vector3(1,1,1);}
	]);
	return TransformUV;
})(EventDispatcher)


/**
*<code>CollsionManager</code> 类用于碰撞管理器。
*/
//class laya.d3.utils.CollisionManager extends laya.events.EventDispatcher
var CollisionManager=(function(_super){
	/**
	*创建一个新的 <code>CollsionManager</code> 实例。
	*/
	function CollisionManager(){
		CollisionManager.__super.call(this);
	}

	__class(CollisionManager,'laya.d3.utils.CollisionManager',_super);
	CollisionManager._onTrigger=function(rigidCol,receiveCol,rigidScripts,receiveScripts,bothRigid){
		var i=0,n=0;
		var rigidID=rigidCol.id;
		var receiveID=receiveCol.id;
		if (!rigidCol._ignoreCollisonMap[receiveID]){
			var colMan=Physics.collisionManager;
			var needTest=rigidCol._runtimeCollisonTestMap[receiveID];
			if (needTest !=null){
				if (needTest){
					if (rigidCol._collisonTo(receiveCol)){
						if (rigidCol._runtimeCollisonMap[receiveID]){
							for (i=0,n=rigidScripts.length;i < n;i++)
							rigidScripts[i].onTriggerStay(receiveCol);
							for (i=0,n=receiveScripts.length;i < n;i++)
							receiveScripts[i].onTriggerStay(rigidCol);
							colMan.event(/*laya.events.Event.TRIGGER_STAY*/"triggerstay",[rigidCol,receiveCol]);
							}else {
							rigidCol._runtimeCollisonMap[receiveID]=receiveCol;
							rigidCol._runtimeCollisonTestMap[receiveID]=false;
							receiveCol._runtimeCollisonMap[rigidID]=rigidCol;
							if (bothRigid)
								receiveCol._runtimeCollisonTestMap[rigidID]=false;
							for (i=0,n=rigidScripts.length;i < n;i++)
							rigidScripts[i].onTriggerEnter(receiveCol);
							for (i=0,n=receiveScripts.length;i < n;i++)
							receiveScripts[i].onTriggerEnter(rigidCol);
							colMan.event(/*laya.events.Event.TRIGGER_ENTER*/"triggerenter",[rigidCol,receiveCol]);
						}
						}else {
						var rigidMap=rigidCol._runtimeCollisonMap;
						if (rigidMap[receiveID]){
							delete rigidMap[receiveID];
							delete rigidCol._runtimeCollisonTestMap[receiveID];
							delete receiveCol._runtimeCollisonMap[rigidID];
							if (bothRigid)
								delete receiveCol._runtimeCollisonTestMap[rigidID];
							for (i=0,n=rigidScripts.length;i < n;i++)
							rigidScripts[i].onTriggerExit(receiveCol);
							for (i=0,n=receiveScripts.length;i < n;i++)
							receiveScripts[i].onTriggerExit(rigidCol);
							colMan.event(/*laya.events.Event.TRIGGER_EXIT*/"triggerexit",[rigidCol,receiveCol]);
						}
					}
					}else {
					for (i=0,n=rigidScripts.length;i < n;i++)
					rigidScripts[i].onTriggerStay(receiveCol);
					for (i=0,n=receiveScripts.length;i < n;i++)
					receiveScripts[i].onTriggerStay(rigidCol);
					colMan.event(/*laya.events.Event.TRIGGER_STAY*/"triggerstay",[rigidCol,receiveCol]);
				}
				}else {
				if (rigidCol._collisonTo(receiveCol)){
					rigidCol._runtimeCollisonMap[receiveID]=receiveCol;
					rigidCol._runtimeCollisonTestMap[receiveID]=false;
					receiveCol._runtimeCollisonMap[rigidID]=rigidCol;
					if (bothRigid)
						receiveCol._runtimeCollisonTestMap[rigidID]=false;
					for (i=0,n=rigidScripts.length;i < n;i++)
					rigidScripts[i].onTriggerEnter(receiveCol);
					for (i=0,n=receiveScripts.length;i < n;i++)
					receiveScripts[i].onTriggerEnter(rigidCol);
					colMan.event(/*laya.events.Event.TRIGGER_ENTER*/"triggerenter",[rigidCol,receiveCol]);
				}
			}
		}
	}

	CollisionManager._triggerCollision=function(){
		var colList=Layer._collsionTestList;
		var colCount=colList.length;
		var colMat=Physics._layerCollsionMatrix;
		for (var i=0;i < colCount;i++){
			var row=colList[i];
			var rowLayer=Layer.getLayerByNumber(row);
			var rowColliders=rowLayer._colliders;
			var rowRigOffset=rowLayer._nonRigidbodyOffset;
			for (var j=colCount-1;j >=i;j--){
				var col=colList[j];
				var test=colMat[row][(/*laya.d3.core.Layer.maxCount*/31-1)-col];
				if (test){
					var k=0,c=0,x=0,z=0;
					var rowCol,colCol,rowScripts;
					var colLayer=Layer.getLayerByNumber(col);
					var colColliders=colLayer._colliders;
					var colRigOffset=colLayer._nonRigidbodyOffset;
					if (rowLayer!==colLayer){
						for (k=0;k < rowRigOffset;k++){
							rowCol=rowColliders[k];
							if (rowCol.enable){
								rowScripts=rowCol.owner._scripts;
								for (x=0,z=colRigOffset;x < z;x++){
									colCol=colColliders[x];
									(colCol.enable)&& (CollisionManager._onTrigger(rowCol,colCol,rowScripts,colCol.owner._scripts,true));
								}
								for (x=colRigOffset,z=colColliders.length;x < z;x++){
									colCol=colColliders[x];
									(colCol.enable)&& (CollisionManager._onTrigger(rowCol,colCol,rowScripts,colCol.owner._scripts,false));
								}
							}
						}
						for (k=rowRigOffset,c=rowColliders.length;k < c;k++){
							rowCol=rowColliders[k];
							if (rowCol.enable){
								rowScripts=rowCol.owner._scripts;
								for (x=0,z=colLayer._nonRigidbodyOffset;x < z;x++){
									colCol=colColliders[x];
									(colCol.enable)&& (CollisionManager._onTrigger(colCol,rowCol,rowScripts,colCol.owner._scripts,false));
								}
							}
						}
						}else {
						for (k=0;k < rowRigOffset;k++){
							rowCol=rowColliders[k];
							if (rowCol.enable){
								rowScripts=rowCol.owner._scripts;
								for (x=k+1,z=rowRigOffset;x < z;x++){
									colCol=colColliders[x];
									(colCol.enable)&& (CollisionManager._onTrigger(rowCol,colCol,rowScripts,colCol.owner._scripts,true));
								}
								for (x=rowRigOffset,z=rowColliders.length;x < z;x++){
									colCol=colColliders[x];
									(colCol.enable)&& (CollisionManager._onTrigger(rowCol,colCol,rowScripts,colCol.owner._scripts,false));
								}
							}
						}
					}
				}
			}
		}
	}

	return CollisionManager;
})(EventDispatcher)


/**
*<code>SplineCurvePosition</code> 类用于通过顶点创建闪光插值。
*/
//class laya.d3.core.glitter.SplineCurvePosition extends laya.d3.core.glitter.SplineCurvePositionVelocity
var SplineCurvePosition=(function(_super){
	/**
	*创建一个 <code>SplineCurvePosition</code> 实例。
	*/
	function SplineCurvePosition(){
		SplineCurvePosition.__super.call(this);
	}

	__class(SplineCurvePosition,'laya.d3.core.glitter.SplineCurvePosition',_super);
	var __proto=SplineCurvePosition.prototype;
	/**
	*@private
	*计算速度。
	*/
	__proto._CalcVelocity=function(left,right,out){
		Vector3.subtract(left,right,out);
		Vector3.scale(out,0.5,out);
	}

	/**
	*初始化插值所需信息。
	*@param lastPosition0 顶点0的上次位置。
	*@param position0 顶点0的位置。
	*@param lastPosition1 顶点1的上次位置。
	*@param position1 顶点1的位置。
	*/
	__proto.Init=function(lastPosition0,position0,lastPosition1,position1){
		this._CalcVelocity(position0,lastPosition0,this._tempVector30);
		this._CalcVelocity(position1,lastPosition1,this._tempVector31);
		_super.prototype.Init.call(this,position0,this._tempVector30,position1,this._tempVector31);
	}

	return SplineCurvePosition;
})(SplineCurvePositionVelocity)


/**
*<code>BoxShape</code> 类用于创建球形粒子形状。
*/
//class laya.d3.core.particleShuriKen.module.shape.BoxShape extends laya.d3.core.particleShuriKen.module.shape.BaseShape
var BoxShape=(function(_super){
	function BoxShape(){
		/**发射器X轴长度。*/
		this.x=NaN;
		/**发射器Y轴长度。*/
		this.y=NaN;
		/**发射器Z轴长度。*/
		this.z=NaN;
		BoxShape.__super.call(this);
		this.x=1.0;
		this.y=1.0;
		this.z=1.0;
		this.randomDirection=false;
	}

	__class(BoxShape,'laya.d3.core.particleShuriKen.module.shape.BoxShape',_super);
	var __proto=BoxShape.prototype;
	/**
	*@inheritDoc
	*/
	__proto._getShapeBoundBox=function(boundBox){
		var minE=boundBox.min.elements;
		minE[0]=-this.x *0.5;
		minE[1]=-this.y *0.5;
		minE[2]=-this.z *0.5;
		var maxE=boundBox.max.elements;
		maxE[0]=this.x *0.5;
		maxE[1]=this.y *0.5;
		maxE[2]=this.z *0.5;
	}

	/**
	*@inheritDoc
	*/
	__proto._getSpeedBoundBox=function(boundBox){
		var minE=boundBox.min.elements;
		minE[0]=0.0;
		minE[1]=0.0;
		minE[2]=0.0;
		var maxE=boundBox.max.elements;
		maxE[0]=0.0;
		maxE[1]=1.0;
		maxE[2]=0.0;
	}

	/**
	*用于生成粒子初始位置和方向。
	*@param position 粒子位置。
	*@param direction 粒子方向。
	*/
	__proto.generatePositionAndDirection=function(position,direction,rand,randomSeeds){
		var rpE=position.elements;
		var rdE=direction.elements;
		if (rand){
			rand.seed=randomSeeds[16];
			ShapeUtils._randomPointInsideHalfUnitBox(position,rand);
			randomSeeds[16]=rand.seed;
			}else {
			ShapeUtils._randomPointInsideHalfUnitBox(position);
		}
		rpE[0]=this.x *rpE[0];
		rpE[1]=this.y *rpE[1];
		rpE[2]=this.z *rpE[2];
		if (this.randomDirection){
			if (rand){
				rand.seed=randomSeeds[17];
				ShapeUtils._randomPointUnitSphere(direction,rand);
				randomSeeds[17]=rand.seed;
				}else {
				ShapeUtils._randomPointUnitSphere(direction);
			}
			}else {
			rdE[0]=0.0;
			rdE[1]=0.0;
			rdE[2]=1.0;
		}
	}

	__proto.cloneTo=function(destObject){
		_super.prototype.cloneTo.call(this,destObject);
		var destShape=destObject;
		destShape.x=this.x;
		destShape.y=this.y;
		destShape.z=this.z;
		destShape.randomDirection=this.randomDirection;
	}

	return BoxShape;
})(BaseShape)


/**
*<code>CircleShape</code> 类用于创建环形粒子形状。
*/
//class laya.d3.core.particleShuriKen.module.shape.CircleShape extends laya.d3.core.particleShuriKen.module.shape.BaseShape
var CircleShape=(function(_super){
	function CircleShape(){
		/**发射器半径。*/
		this.radius=NaN;
		/**环形弧度。*/
		this.arc=NaN;
		/**从边缘发射。*/
		this.emitFromEdge=false;
		CircleShape.__super.call(this);
		this.radius=1.0;
		this.arc=360.0 / 180.0 *Math.PI;
		this.emitFromEdge=false;
		this.randomDirection=false;
	}

	__class(CircleShape,'laya.d3.core.particleShuriKen.module.shape.CircleShape',_super);
	var __proto=CircleShape.prototype;
	/**
	*@inheritDoc
	*/
	__proto._getShapeBoundBox=function(boundBox){
		var minE=boundBox.min.elements;
		minE[0]=minE[2]=-this.radius;
		minE[1]=0;
		var maxE=boundBox.max.elements;
		maxE[0]=maxE[2]=this.radius;
		maxE[1]=0;
	}

	/**
	*@inheritDoc
	*/
	__proto._getSpeedBoundBox=function(boundBox){
		var minE=boundBox.min.elements;
		minE[0]=minE[1]=-1;
		minE[2]=0;
		var maxE=boundBox.max.elements;
		maxE[0]=maxE[1]=1;
		maxE[2]=0;
	}

	/**
	*用于生成粒子初始位置和方向。
	*@param position 粒子位置。
	*@param direction 粒子方向。
	*/
	__proto.generatePositionAndDirection=function(position,direction,rand,randomSeeds){
		var rpE=position.elements;
		var positionPointE=CircleShape._tempPositionPoint.elements;
		if (rand){
			rand.seed=randomSeeds[16];
			if (this.emitFromEdge)
				ShapeUtils._randomPointUnitArcCircle(this.arc,CircleShape._tempPositionPoint,rand);
			else
			ShapeUtils._randomPointInsideUnitArcCircle(this.arc,CircleShape._tempPositionPoint,rand);
			randomSeeds[16]=rand.seed;
			}else {
			if (this.emitFromEdge)
				ShapeUtils._randomPointUnitArcCircle(this.arc,CircleShape._tempPositionPoint);
			else
			ShapeUtils._randomPointInsideUnitArcCircle(this.arc,CircleShape._tempPositionPoint);
		}
		rpE[0]=-positionPointE[0];
		rpE[1]=positionPointE[1];
		rpE[2]=0;
		Vector3.scale(position,this.radius,position);
		if (this.randomDirection){
			if (rand){
				rand.seed=randomSeeds[17];
				ShapeUtils._randomPointUnitSphere(direction,rand);
				randomSeeds[17]=rand.seed;
				}else {
				ShapeUtils._randomPointUnitSphere(direction);
			}
			}else {
			position.cloneTo(direction);
		}
	}

	__proto.cloneTo=function(destObject){
		_super.prototype.cloneTo.call(this,destObject);
		var destShape=destObject;
		destShape.radius=this.radius;
		destShape.arc=this.arc;
		destShape.emitFromEdge=this.emitFromEdge;
		destShape.randomDirection=this.randomDirection;
	}

	__static(CircleShape,
	['_tempPositionPoint',function(){return this._tempPositionPoint=new Vector2();}
	]);
	return CircleShape;
})(BaseShape)


/**
*<code>ConeShape</code> 类用于创建锥形粒子形状。
*/
//class laya.d3.core.particleShuriKen.module.shape.ConeShape extends laya.d3.core.particleShuriKen.module.shape.BaseShape
var ConeShape=(function(_super){
	function ConeShape(){
		/**发射角度。*/
		this.angle=NaN;
		/**发射器半径。*/
		this.radius=NaN;
		/**椎体长度。*/
		this.length=NaN;
		/**发射类型,0为Base,1为BaseShell,2为Volume,3为VolumeShell。*/
		this.emitType=0;
		ConeShape.__super.call(this);
		this.angle=25.0 / 180.0 *Math.PI;
		this.radius=1.0;
		this.length=5.0;
		this.emitType=0;
		this.randomDirection=false;
	}

	__class(ConeShape,'laya.d3.core.particleShuriKen.module.shape.ConeShape',_super);
	var __proto=ConeShape.prototype;
	/**
	*@inheritDoc
	*/
	__proto._getShapeBoundBox=function(boundBox){
		var coneRadius2=this.radius+this.length *Math.sin(this.angle);
		var coneLength=this.length *Math.cos(this.angle);
		var minE=boundBox.min.elements;
		minE[0]=minE[1]=-coneRadius2;
		minE[2]=0;
		var maxE=boundBox.max.elements;
		maxE[0]=maxE[1]=coneRadius2;
		maxE[2]=coneLength;
	}

	/**
	*@inheritDoc
	*/
	__proto._getSpeedBoundBox=function(boundBox){
		var sinA=Math.sin(this.angle);
		var minE=boundBox.min.elements;
		minE[0]=minE[1]=-sinA;
		minE[2]=0;
		var maxE=boundBox.max.elements;
		maxE[0]=minE[1]=sinA;
		maxE[2]=1;
	}

	/**
	*用于生成粒子初始位置和方向。
	*@param position 粒子位置。
	*@param direction 粒子方向。
	*/
	__proto.generatePositionAndDirection=function(position,direction,rand,randomSeeds){
		var rpE=position.elements;
		var rdE=direction.elements;
		var positionPointE=ConeShape._tempPositionPoint.elements;
		var positionX=NaN;
		var positionY=NaN;
		var directionPointE;
		var dirCosA=Math.cos(this.angle);
		var dirSinA=Math.sin(this.angle);
		switch (this.emitType){
			case 0:
				if (rand){
					rand.seed=randomSeeds[16];
					ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempPositionPoint,rand);
					randomSeeds[16]=rand.seed;
					}else {
					ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempPositionPoint);
				}
				positionX=positionPointE[0];
				positionY=positionPointE[1];
				rpE[0]=positionX *this.radius;
				rpE[1]=positionY *this.radius;
				rpE[2]=0;
				if (this.randomDirection){
					if (rand){
						rand.seed=randomSeeds[17];
						ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempDirectionPoint,rand);
						randomSeeds[17]=rand.seed;
						}else {
						ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempDirectionPoint);
					}
					directionPointE=ConeShape._tempDirectionPoint.elements;
					rdE[0]=directionPointE[0] *dirSinA;
					rdE[1]=directionPointE[1] *dirSinA;
					}else {
					rdE[0]=positionX *dirSinA;
					rdE[1]=positionY *dirSinA;
				}
				rdE[2]=dirCosA;
				break ;
			case 1:
				if (rand){
					rand.seed=randomSeeds[16];
					ShapeUtils._randomPointUnitCircle(ConeShape._tempPositionPoint,rand);
					randomSeeds[16]=rand.seed;
					}else {
					ShapeUtils._randomPointUnitCircle(ConeShape._tempPositionPoint);
				}
				positionX=positionPointE[0];
				positionY=positionPointE[1];
				rpE[0]=positionX *this.radius;
				rpE[1]=positionY *this.radius;
				rpE[2]=0;
				if (this.randomDirection){
					if (rand){
						rand.seed=randomSeeds[17];
						ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempDirectionPoint,rand);
						randomSeeds[17]=rand.seed;
						}else {
						ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempDirectionPoint);
					}
					directionPointE=ConeShape._tempDirectionPoint.elements;
					rdE[0]=directionPointE[0] *dirSinA;
					rdE[1]=directionPointE[1] *dirSinA;
					}else {
					rdE[0]=positionX *dirSinA;
					rdE[1]=positionY *dirSinA;
				}
				rdE[2]=dirCosA;
				break ;
			case 2:
				if (rand){
					rand.seed=randomSeeds[16];
					ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempPositionPoint,rand);
					}else {
					ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempPositionPoint);
				}
				positionX=positionPointE[0];
				positionY=positionPointE[1];
				rpE[0]=positionX *this.radius;
				rpE[1]=positionY *this.radius;
				rpE[2]=0;
				rdE[0]=positionX *dirSinA;
				rdE[1]=positionY *dirSinA;
				rdE[2]=dirCosA;
				Vector3.normalize(direction,direction);
				if (rand){
					Vector3.scale(direction,this.length *rand.getFloat(),direction);
					randomSeeds[16]=rand.seed;
					}else {
					Vector3.scale(direction,this.length *Math.random(),direction);
				}
				Vector3.add(position,direction,position);
				if (this.randomDirection){
					if (rand){
						rand.seed=randomSeeds[17];
						ShapeUtils._randomPointUnitSphere(direction,rand);
						randomSeeds[17]=rand.seed;
						}else {
						ShapeUtils._randomPointUnitSphere(direction);
					}
				}
				break ;
			case 3:
				if (rand){
					rand.seed=randomSeeds[16];
					ShapeUtils._randomPointUnitCircle(ConeShape._tempPositionPoint,rand);
					}else {
					ShapeUtils._randomPointUnitCircle(ConeShape._tempPositionPoint);
				}
				positionX=positionPointE[0];
				positionY=positionPointE[1];
				rpE[0]=positionX *this.radius;
				rpE[1]=positionY *this.radius;
				rpE[2]=0;
				rdE[0]=positionX *dirSinA;
				rdE[1]=positionY *dirSinA;
				rdE[2]=dirCosA;
				Vector3.normalize(direction,direction);
				if (rand){
					Vector3.scale(direction,this.length *rand.getFloat(),direction);
					randomSeeds[16]=rand.seed;
					}else {
					Vector3.scale(direction,this.length *Math.random(),direction);
				}
				Vector3.add(position,direction,position);
				if (this.randomDirection){
					if (rand){
						rand.seed=randomSeeds[17];
						ShapeUtils._randomPointUnitSphere(direction,rand);
						randomSeeds[17]=rand.seed;
						}else {
						ShapeUtils._randomPointUnitSphere(direction);
					}
				}
				break ;
			default :
				throw new Error("ConeShape:emitType is invalid.");
			}
	}

	__proto.cloneTo=function(destObject){
		_super.prototype.cloneTo.call(this,destObject);
		var destShape=destObject;
		destShape.angle=this.angle;
		destShape.radius=this.radius;
		destShape.length=this.length;
		destShape.emitType=this.emitType;
		destShape.randomDirection=this.randomDirection;
	}

	__static(ConeShape,
	['_tempPositionPoint',function(){return this._tempPositionPoint=new Vector2();},'_tempDirectionPoint',function(){return this._tempDirectionPoint=new Vector2();}
	]);
	return ConeShape;
})(BaseShape)


/**
*<code>HemisphereShape</code> 类用于创建半球形粒子形状。
*/
//class laya.d3.core.particleShuriKen.module.shape.HemisphereShape extends laya.d3.core.particleShuriKen.module.shape.BaseShape
var HemisphereShape=(function(_super){
	function HemisphereShape(){
		/**发射器半径。*/
		this.radius=NaN;
		/**从外壳发射。*/
		this.emitFromShell=false;
		HemisphereShape.__super.call(this);
		this.radius=1.0;
		this.emitFromShell=false;
		this.randomDirection=false;
	}

	__class(HemisphereShape,'laya.d3.core.particleShuriKen.module.shape.HemisphereShape',_super);
	var __proto=HemisphereShape.prototype;
	/**
	*@inheritDoc
	*/
	__proto._getShapeBoundBox=function(boundBox){
		var minE=boundBox.min.elements;
		minE[0]=minE[1]=minE[2]=-this.radius;
		var maxE=boundBox.max.elements;
		maxE[0]=maxE[1]=this.radius;
		maxE[2]=0;
	}

	/**
	*@inheritDoc
	*/
	__proto._getSpeedBoundBox=function(boundBox){
		var minE=boundBox.min.elements;
		minE[0]=minE[1]=-1;
		minE[2]=0;
		var maxE=boundBox.max.elements;
		maxE[0]=maxE[1]=maxE[2]=1;
	}

	/**
	*用于生成粒子初始位置和方向。
	*@param position 粒子位置。
	*@param direction 粒子方向。
	*/
	__proto.generatePositionAndDirection=function(position,direction,rand,randomSeeds){
		var rpE=position.elements;
		if (rand){
			rand.seed=randomSeeds[16];
			if (this.emitFromShell)
				ShapeUtils._randomPointUnitSphere(position,rand);
			else
			ShapeUtils._randomPointInsideUnitSphere(position,rand);
			randomSeeds[16]=rand.seed;
			}else {
			if (this.emitFromShell)
				ShapeUtils._randomPointUnitSphere(position);
			else
			ShapeUtils._randomPointInsideUnitSphere(position);
		}
		Vector3.scale(position,this.radius,position);
		var z=rpE[2];
		(z < 0.0)&& (rpE[2]=z *-1.0);
		if (this.randomDirection){
			if (rand){
				rand.seed=randomSeeds[17];
				ShapeUtils._randomPointUnitSphere(direction,rand);
				randomSeeds[17]=rand.seed;
				}else {
				ShapeUtils._randomPointUnitSphere(direction);
			}
			}else {
			position.cloneTo(direction);
		}
	}

	__proto.cloneTo=function(destObject){
		_super.prototype.cloneTo.call(this,destObject);
		var destShape=destObject;
		destShape.radius=this.radius;
		destShape.emitFromShell=this.emitFromShell;
		destShape.randomDirection=this.randomDirection;
	}

	return HemisphereShape;
})(BaseShape)


/**
*<code>SphereShape</code> 类用于创建球形粒子形状。
*/
//class laya.d3.core.particleShuriKen.module.shape.SphereShape extends laya.d3.core.particleShuriKen.module.shape.BaseShape
var SphereShape=(function(_super){
	function SphereShape(){
		/**发射器半径。*/
		this.radius=NaN;
		/**从外壳发射。*/
		this.emitFromShell=false;
		SphereShape.__super.call(this);
		this.radius=1.0;
		this.emitFromShell=false;
		this.randomDirection=false;
	}

	__class(SphereShape,'laya.d3.core.particleShuriKen.module.shape.SphereShape',_super);
	var __proto=SphereShape.prototype;
	/**
	*@inheritDoc
	*/
	__proto._getShapeBoundBox=function(boundBox){
		var minE=boundBox.min.elements;
		minE[0]=minE[1]=minE[2]=-this.radius;
		var maxE=boundBox.max.elements;
		maxE[0]=maxE[1]=maxE[2]=this.radius;
	}

	/**
	*@inheritDoc
	*/
	__proto._getSpeedBoundBox=function(boundBox){
		var minE=boundBox.min.elements;
		minE[0]=minE[1]=minE[2]=-1;
		var maxE=boundBox.max.elements;
		maxE[0]=maxE[1]=maxE[2]=1;
	}

	/**
	*用于生成粒子初始位置和方向。
	*@param position 粒子位置。
	*@param direction 粒子方向。
	*/
	__proto.generatePositionAndDirection=function(position,direction,rand,randomSeeds){
		if (rand){
			rand.seed=randomSeeds[16];
			if (this.emitFromShell)
				ShapeUtils._randomPointUnitSphere(position,rand);
			else
			ShapeUtils._randomPointInsideUnitSphere(position,rand);
			randomSeeds[16]=rand.seed;
			}else {
			if (this.emitFromShell)
				ShapeUtils._randomPointUnitSphere(position);
			else
			ShapeUtils._randomPointInsideUnitSphere(position);
		}
		Vector3.scale(position,this.radius,position);
		if (this.randomDirection){
			if (rand){
				rand.seed=randomSeeds[17];
				ShapeUtils._randomPointUnitSphere(direction,rand);
				randomSeeds[17]=rand.seed;
				}else {
				ShapeUtils._randomPointUnitSphere(direction);
			}
			}else {
			position.cloneTo(direction);
		}
	}

	__proto.cloneTo=function(destObject){
		_super.prototype.cloneTo.call(this,destObject);
		var destShape=destObject;
		destShape.radius=this.radius;
		destShape.emitFromShell=this.emitFromShell;
		destShape.randomDirection=this.randomDirection;
	}

	return SphereShape;
})(BaseShape)


/**
*@private
*/
//class laya.d3.core.render.SubMeshRenderElement extends laya.d3.core.render.RenderElement
var SubMeshRenderElement=(function(_super){
	function SubMeshRenderElement(){
		/**@private */
		this._batchIndexStart=0;
		/**@private */
		this._batchIndexEnd=0;
		/**@private */
		this._skinAnimationDatas=null;
		SubMeshRenderElement.__super.call(this);
	}

	__class(SubMeshRenderElement,'laya.d3.core.render.SubMeshRenderElement',_super);
	return SubMeshRenderElement;
})(RenderElement)


/**
*@private
*<code>ShaderCompile</code> 类用于创建Shader编译类型。
*/
//class laya.d3.shader.ShaderCompile3D extends laya.webgl.utils.ShaderCompile
var ShaderCompile3D=(function(_super){
	function ShaderCompile3D(name,vs,ps,attributeMap,uniformMap,includeFiles){
		/**@private */
		this._name=NaN;
		/**@private */
		this._attributeMap=null;
		/**@private */
		this._renderElementUniformMap=null;
		/**@private */
		this._materialUniformMap=null;
		/**@private */
		this._spriteUniformMap=null;
		/**@private */
		this._cameraUniformMap=null;
		/**@private */
		this._sceneUniformMap=null;
		this.sharders=null;
		/**@private */
		this._spriteDefineCounter=3;
		/**@private */
		this._spriteInt2name=[];
		/**@private */
		this._spriteName2Int={};
		/**@private */
		this._materialDefineCounter=1;
		/**@private */
		this._materialInt2name=[];
		/**@private */
		this._materialName2Int={};
		this._conchShader=null;
		this._name=name;
		this._renderElementUniformMap={};
		this._materialUniformMap={};
		this._spriteUniformMap={};
		this._cameraUniformMap={};
		this._sceneUniformMap={};
		this.sharders=[];
		this._spriteInt2name[ParallelSplitShadowMap.SHADERDEFINE_RECEIVE_SHADOW]="RECEIVESHADOW";
		this._spriteInt2name[RenderableSprite3D.SHADERDEFINE_SCALEOFFSETLIGHTINGMAPUV]="SCALEOFFSETLIGHTINGMAPUV";
		this._spriteInt2name[RenderableSprite3D.SAHDERDEFINE_LIGHTMAP]="LIGHTMAP";
		this._spriteInt2name[SkinnedMeshSprite3D.SHADERDEFINE_BONE]="BONE";
		this._materialInt2name[BaseMaterial.SHADERDEFINE_ALPHATEST]="ALPHATEST";
		var defineMap={};
		ShaderCompile3D.__super.call(this,name,vs,ps,null,defineMap);
		this._attributeMap=attributeMap;
		var renderElementUnifCount=0,materialUnifCount=0,spriteUnifCount=0;
		var key;
		for (key in uniformMap){
			var uniformParam=uniformMap[key];
			switch (uniformParam[1]){
				case /*laya.d3.shader.Shader3D.PERIOD_RENDERELEMENT*/0:
					this._renderElementUniformMap[key]=uniformParam[0];
					break ;
				case /*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1:
					this._materialUniformMap[key]=uniformParam[0];
					break ;
				case /*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2:
					this._spriteUniformMap[key]=uniformParam[0];
					break ;
				case /*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3:
					this._cameraUniformMap[key]=uniformParam[0];
					break ;
				case /*laya.d3.shader.Shader3D.PERIOD_SCENE*/4:
					this._sceneUniformMap[key]=uniformParam[0];
					break ;
				default :
					throw new Error("ShaderCompile3D: period is unkonw.");
				}
		}
	}

	__class(ShaderCompile3D,'laya.d3.shader.ShaderCompile3D',_super);
	var __proto=ShaderCompile3D.prototype;
	/**
	*@private
	*/
	__proto._definesToNameDic=function(value,int2Name){
		var o={};
		var d=1;
		for (var i=0;i < 32;i++){
			d=1 << i;
			if (d > value)break ;
			if (value & d){
				var name=int2Name[d];
				name && (o[name]="");
			}
		}
		return o;
	}

	/**
	*根据宏动态生成shader文件，支持#include?COLOR_FILTER "parts/ColorFilter_ps_logic.glsl";条件嵌入文件
	*@param name
	*@param vs
	*@param ps
	*@param define 宏定义，格式:{name:value...}
	*@return
	*/
	__proto.withCompile=function(publicDefine,spriteDefine,materialDefine){
		var shader;
		var spriteDefShaders,materialDefShaders;
		spriteDefShaders=this.sharders[publicDefine];
		if (spriteDefShaders){
			materialDefShaders=spriteDefShaders[spriteDefine];
			if (materialDefShaders){
				shader=materialDefShaders[materialDefine];
				if (shader)
					return shader;
				}else {
				materialDefShaders=spriteDefShaders[spriteDefine]=[];
			}
			}else {
			spriteDefShaders=this.sharders[publicDefine]=[];
			materialDefShaders=spriteDefShaders[spriteDefine]=[];
		};
		var publicDefGroup=this._definesToNameDic(publicDefine,ShaderCompile3D._globalInt2name);
		var spriteDefGroup=this._definesToNameDic(spriteDefine,this._spriteInt2name);
		var materialDefGroup=this._definesToNameDic(materialDefine,this._materialInt2name);
		var key;
		if (laya.d3.shader.ShaderCompile3D.debugMode){
			var publicDefGroupStr="";
			for (key in publicDefGroup)
			publicDefGroupStr+=key+" ";
			var spriteDefGroupStr="";
			for (key in spriteDefGroup)
			spriteDefGroupStr+=key+" ";
			var materialDefGroupStr="";
			for (key in materialDefGroup)
			materialDefGroupStr+=key+" ";
			console.log("ShaderCompile3DDebugMode---(Name:"+Shader3D.nameKey.getName(this._name)+" PublicDefine:"+publicDefine+" SpriteDefine:"+spriteDefine+" MaterialDefine:"+materialDefine+" PublicDefineGroup:"+publicDefGroupStr+" SpriteDefineGroup:"+spriteDefGroupStr+"MaterialDefineGroup: "+materialDefGroupStr+")---ShaderCompile3DDebugMode");
		};
		var defMap={};
		var defineStr="";
		if (publicDefGroup){
			for (key in publicDefGroup){
				defineStr+="#define "+key+"\n";
				defMap[key]=true;
			}
		}
		if (spriteDefGroup){
			for (key in spriteDefGroup){
				defineStr+="#define "+key+"\n";
				defMap[key]=true;
			}
		}
		if (materialDefGroup){
			for (key in materialDefGroup){
				defineStr+="#define "+key+"\n";
				defMap[key]=true;
			}
		};
		var vs=this._VS.toscript(defMap,[]);
		var ps=this._PS.toscript(defMap,[]);
		shader=Shader3D.create(defineStr+vs.join('\n'),defineStr+ps.join('\n'),this._attributeMap,this._sceneUniformMap,this._cameraUniformMap,this._spriteUniformMap,this._materialUniformMap,this._renderElementUniformMap);
		materialDefShaders[materialDefine]=shader;
		return shader;
	}

	/**
	*通过宏定义预编译shader。
	*@param spriteIntToNameDic 精灵宏定义数组。
	*@param publicDefine 公共宏定义值。
	*@param spriteDefine 精灵宏定义值。
	*@param materialDefine 材质宏定义值。
	*/
	__proto.precompileShaderWithShaderDefine=function(publicDefine,spriteDefine,materialDefine){
		this.withCompile(publicDefine,spriteDefine,materialDefine);
	}

	/**
	*注册材质宏定义。
	*@param name 宏定义名称。
	*@return
	*/
	__proto.addMaterialDefines=function(shaderdefines){
		var defines=shaderdefines.defines;
		for (var k in defines){
			var name=defines[k];
			var i=parseInt(k);
			this._materialInt2name[i]=name;
			this._materialName2Int[name]=i;
		}
	}

	/**
	*注册精灵宏定义。
	*@param name 宏定义名称。
	*@return
	*/
	__proto.addSpriteDefines=function(shaderdefines){
		var defines=shaderdefines.defines;
		for (var k in defines){
			var name=defines[k];
			var i=parseInt(k);
			this._spriteInt2name[i]=name;
			this._spriteName2Int[name]=i;
		}
	}

	/**
	*通过名称获取宏定义值。
	*@param name 名称。
	*@return 宏定义值。
	*/
	__proto.getMaterialDefineByName=function(name){
		return this._materialName2Int[name];
	}

	/**
	*注册材质宏定义。
	*@param name 宏定义名称。
	*@return
	*/
	__proto.registerMaterialDefine=function(name){
		var value=Math.pow(2,this._materialDefineCounter++);
		this._materialInt2name[value]=name;
		this._materialName2Int[name]=value;
		return value;
	}

	/**
	*注册精灵宏定义。
	*@param name 宏定义名称。
	*@return
	*/
	__proto.registerSpriteDefine=function(name){
		var value=Math.pow(2,this._spriteDefineCounter++);
		this._spriteInt2name[value]=name;
		this._spriteName2Int[name]=value;
		return value;
	}

	ShaderCompile3D._globalRegDefine=function(name,value){
		ShaderCompile3D._globalInt2name[value]=name;
	}

	ShaderCompile3D.add=function(nameID,vs,ps,attributeMap,uniformMap){
		return laya.d3.shader.ShaderCompile3D._preCompileShader[nameID]=new ShaderCompile3D(nameID,vs,ps,attributeMap,uniformMap,ShaderCompile.includes);
	}

	ShaderCompile3D.get=function(name){
		return laya.d3.shader.ShaderCompile3D._preCompileShader[Shader3D.nameKey.getID(name)];
	}

	ShaderCompile3D._preCompileShader={};
	ShaderCompile3D._globalInt2name=[];
	ShaderCompile3D.debugMode=false;
	ShaderCompile3D.SHADERDEFINE_HIGHPRECISION=0x1;
	ShaderCompile3D.SHADERDEFINE_FOG=0x4;
	ShaderCompile3D.SHADERDEFINE_DIRECTIONLIGHT=0x8;
	ShaderCompile3D.SHADERDEFINE_POINTLIGHT=0x10;
	ShaderCompile3D.SHADERDEFINE_SPOTLIGHT=0x20;
	ShaderCompile3D.SHADERDEFINE_UV0=0x40;
	ShaderCompile3D.SHADERDEFINE_COLOR=0x80;
	ShaderCompile3D.SHADERDEFINE_UV1=0x100;
	ShaderCompile3D.SAHDERDEFINE_DEPTHFOG=0x20000;
	return ShaderCompile3D;
})(ShaderCompile)


/**
*@private
*<code>MeshSprite3DStaticBatchManager</code> 类用于网格精灵静态批处理管理。
*/
//class laya.d3.graphics.MeshSprite3DStaticBatchManager extends laya.d3.graphics.StaticBatchManager
var MeshSprite3DStaticBatchManager=(function(_super){
	/**i
	*创建一个 <code>MeshSprite3DStaticBatchManager</code> 实例。
	*/
	function MeshSprite3DStaticBatchManager(){
		MeshSprite3DStaticBatchManager.__super.call(this);
	}

	__class(MeshSprite3DStaticBatchManager,'laya.d3.graphics.MeshSprite3DStaticBatchManager',_super);
	var __proto=MeshSprite3DStaticBatchManager.prototype;
	/**
	*@private
	*/
	__proto._getStaticBatch=function(rootOwner,vertexDeclaration,material,number){
		var staticBatch;
		var key;
		if (rootOwner)
			key=rootOwner.id.toString()+material.id.toString()+vertexDeclaration.id.toString()+number.toString();
		else
		key=material.id.toString()+vertexDeclaration.id.toString()+number.toString();
		if (!this._staticBatches[key])
			this._staticBatches[key]=staticBatch=new SubMeshStaticBatch(key,this,rootOwner,vertexDeclaration,material);
		else
		staticBatch=this._staticBatches[key];
		return staticBatch;
	}

	/**
	*@inheritDoc
	*/
	__proto._initStaticBatchs=function(rootOwner){
		this._initBatchRenderElements.sort(MeshSprite3DStaticBatchManager._sortPrepareStaticBatch);
		var lastMaterial;
		var lastVertexDeclaration;
		var lastCanMerage=false;
		var curStaticBatch;
		var batchNumber=0;
		for (var i=0,n=this._initBatchRenderElements.length;i < n;i++){
			var renderElement=this._initBatchRenderElements[i];
			var vb=renderElement.renderObj._getVertexBuffer(0);
			var originalOwner=renderElement._sprite3D;
			if ((lastVertexDeclaration===vb.vertexDeclaration)&& (lastMaterial===renderElement._material)){
				var oldStaticBatch;
				if (!lastCanMerage){
					var lastRenderObj=this._initBatchRenderElements[i-1];
					var lastRenderElement=lastRenderObj.renderObj;
					var curRenderElement=renderElement.renderObj;
					if (((lastRenderElement._getVertexBuffer().vertexCount+curRenderElement._getVertexBuffer().vertexCount)> /*laya.d3.graphics.StaticBatch.maxBatchVertexCount*/65535)){
						lastCanMerage=false;
						}else {
						curStaticBatch=this._getStaticBatch(rootOwner,lastVertexDeclaration,lastMaterial,batchNumber);
						oldStaticBatch=lastRenderObj._staticBatch;
						if (oldStaticBatch!==curStaticBatch){
							(oldStaticBatch)&& (oldStaticBatch._deleteCombineBatchRenderObj(lastRenderObj));
							curStaticBatch._addCombineBatchRenderObj(lastRenderObj);
						}
						oldStaticBatch=renderElement._staticBatch;
						if (oldStaticBatch!==curStaticBatch){
							(oldStaticBatch)&& (oldStaticBatch._deleteCombineBatchRenderObj(renderElement));
							curStaticBatch._addCombineBatchRenderObj(renderElement);
						}
						lastCanMerage=true;
					}
					}else {
					if (!curStaticBatch._addCombineBatchRenderObjTest(renderElement)){
						lastCanMerage=false;
						batchNumber++;
						}else {
						oldStaticBatch=renderElement._staticBatch;
						if (oldStaticBatch!==curStaticBatch){
							(oldStaticBatch)&& (oldStaticBatch._deleteCombineBatchRenderObj(renderElement));
							curStaticBatch._addCombineBatchRenderObj(renderElement)
						}
					}
				}
				}else {
				lastCanMerage=false;
				batchNumber=0;
			}
			lastMaterial=renderElement._material;
			lastVertexDeclaration=vb.vertexDeclaration;
		}
	}

	MeshSprite3DStaticBatchManager._sortPrepareStaticBatch=function(a,b){
		var aRender=a._render,bRender=b._render;
		var lightMapIndexOffset=aRender.lightmapIndex-bRender.lightmapIndex;
		if (lightMapIndexOffset===0){
			var receiveShadowValue=/*__JS__ */aRender.receiveShadow-bRender.receiveShadow;
			if (receiveShadowValue===0){
				var mainID=a._mainSortID-b._mainSortID;
				if (mainID===0){
					return a.renderObj.triangleCount-b.renderObj.triangleCount;
					}else {
					return mainID;
				}
				}else {
				return receiveShadowValue;
			}
			}else {
			return lightMapIndexOffset;
		}
	}

	return MeshSprite3DStaticBatchManager;
})(StaticBatchManager)


/**
*<code>SubMeshStaticBatch</code> 类用于网格静态合并。
*/
//class laya.d3.graphics.SubMeshStaticBatch extends laya.d3.graphics.StaticBatch
var SubMeshStaticBatch=(function(_super){
	function SubMeshStaticBatch(key,manager,rootOwner,vertexDeclaration,material){
		/**@private */
		this._batchOwnerIndices=null;
		/**@private */
		this._batchOwners=null;
		/**@private */
		this._needFinishCombine=false;
		/**@private */
		this._currentCombineVertexCount=0;
		/**@private */
		this._currentCombineIndexCount=0;
		/**@private */
		this._vertexDeclaration=null;
		/**@private */
		this._vertexBuffer=null;
		/**@private */
		this._indexBuffer=null;
		SubMeshStaticBatch.__super.call(this,key,manager,rootOwner);
		this._batchOwnerIndices=[];
		this._batchOwners=[];
		this._needFinishCombine=false;
		this._currentCombineVertexCount=0;
		this._currentCombineIndexCount=0;
		this._vertexDeclaration=vertexDeclaration;
		this._material=material;
	}

	__class(SubMeshStaticBatch,'laya.d3.graphics.SubMeshStaticBatch',_super);
	var __proto=SubMeshStaticBatch.prototype;
	/**
	*@inheritDoc
	*/
	__proto._compareBatchRenderElement=function(a,b){
		return (a)._batchIndexStart > (b)._batchIndexStart;
	}

	/**
	*@private
	*/
	__proto._addCombineBatchRenderObjTest=function(renderElement){
		var vertexCount=0;
		var subMeshVertexCount=(renderElement.renderObj)._vertexCount;
		if (subMeshVertexCount > 0)
			vertexCount=this._currentCombineVertexCount+subMeshVertexCount;
		else
		vertexCount=this._currentCombineVertexCount+renderElement.renderObj._getVertexBuffer().vertexCount;
		if (vertexCount > 65535)
			return false;
		return true;
	}

	/**
	*@private
	*/
	__proto._addCombineBatchRenderObj=function(renderElement){
		var subMesh=renderElement.renderObj;
		var subMeshVertexCount=subMesh._vertexCount;
		this._initBatchRenderElements.push(renderElement);
		renderElement._staticBatch=this;
		if (subMeshVertexCount > 0){
			this._currentCombineIndexCount+=subMesh._indexCount;
			this._currentCombineVertexCount+=subMeshVertexCount;
			}else {
			this._currentCombineIndexCount=this._currentCombineIndexCount+subMesh._getIndexBuffer().indexCount;
			this._currentCombineVertexCount=this._currentCombineVertexCount+subMesh._getVertexBuffer().vertexCount;
		}
		this._needFinishCombine=true;
	}

	/**
	*@private
	*/
	__proto._deleteCombineBatchRenderObj=function(renderElement){
		var subMesh=renderElement.renderObj;
		var index=this._initBatchRenderElements.indexOf(renderElement);
		if (index!==-1){
			this._initBatchRenderElements.splice(index,1);
			renderElement._staticBatch=null;
			var subMeshVertexCount=subMesh._vertexCount;
			if (subMeshVertexCount > 0){
				this._currentCombineIndexCount=this._currentCombineIndexCount-subMesh._indexCount;
				this._currentCombineVertexCount=this._currentCombineVertexCount-subMeshVertexCount;
				}else {
				this._currentCombineIndexCount=this._currentCombineIndexCount-subMesh._getIndexBuffer().indexCount;
				this._currentCombineVertexCount=this._currentCombineVertexCount-subMesh._getVertexBuffer().vertexCount;
			}
			this._needFinishCombine=true;
		}
	}

	/**
	*@inheritDoc
	*/
	__proto._finishInit=function(){
		if (this._needFinishCombine){
			var curMerVerCount=0;
			var curIndexCount=0;
			if (this._initBatchRenderElements[0]._sprite3D._render.lightmapIndex >=0){
				this._vertexDeclaration=this._getVertexDecLightMap(this._vertexDeclaration);
				}else {
				if ((this._material instanceof laya.d3.core.material.StandardMaterial )){
					if ((this._material).ambientTexture)
						this._vertexDeclaration=this._getVertexDecLightMap(this._vertexDeclaration);
				}
			};
			var vertexDatas=new Float32Array(this._vertexDeclaration.vertexStride / 4 *this._currentCombineVertexCount);
			var indexDatas=new Uint16Array(this._currentCombineIndexCount);
			if (this._vertexBuffer){
				this._vertexBuffer.destroy();
				this._indexBuffer.destroy();
			}
			this._vertexBuffer=VertexBuffer3D.create(this._vertexDeclaration,this._currentCombineVertexCount,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4);
			this._indexBuffer=IndexBuffer3D.create(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",this._currentCombineIndexCount,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4);
			for (var i=0,n=this._initBatchRenderElements.length;i < n;i++){
				var renderElement=this._initBatchRenderElements [i];
				var subMesh=renderElement.renderObj;
				var subVertexDatas=subMesh._getStaticBatchBakedVertexs(this._rootOwner ? this._rootOwner._transform :null,renderElement._sprite3D);
				var subIndexDatas=subMesh.getIndices();
				var isInvert=renderElement._sprite3D.transform._isFrontFaceInvert;
				var indexOffset=curMerVerCount / (this._vertexDeclaration.vertexStride / 4)-subMesh._vertexStart;
				var indexStart=curIndexCount;
				var indexEnd=indexStart+subIndexDatas.length;
				renderElement._batchIndexStart=indexStart;
				renderElement._batchIndexEnd=indexEnd;
				indexDatas.set(subIndexDatas,curIndexCount);
				var k=0;
				if (isInvert){
					for (k=indexStart;k < indexEnd;k+=3){
						indexDatas[k]=indexOffset+indexDatas[k];
						var index1=indexDatas[k+1];
						var index2=indexDatas[k+2];
						indexDatas[k+1]=indexOffset+index2;
						indexDatas[k+2]=indexOffset+index1;
					}
					}else {
					for (k=indexStart;k < indexEnd;k+=3){
						indexDatas[k]=indexOffset+indexDatas[k];
						indexDatas[k+1]=indexOffset+indexDatas[k+1];
						indexDatas[k+2]=indexOffset+indexDatas[k+2];
					}
				}
				curIndexCount+=subIndexDatas.length;
				vertexDatas.set(subVertexDatas,curMerVerCount);
				curMerVerCount+=subVertexDatas.length;
			}
			this._vertexBuffer.setData(vertexDatas);
			this._indexBuffer.setData(indexDatas);
			this._needFinishCombine=false;
		}
	}

	/**
	*@inheritDoc
	*/
	__proto._getCombineRenderElementFromPool=function(){
		var renderElement=this._combineRenderElementPool[this._combineRenderElementPoolIndex++];
		return renderElement || (this._combineRenderElementPool[this._combineRenderElementPoolIndex-1]=new SubMeshRenderElement());
	}

	/**
	*@inheritDoc
	*/
	__proto._getRenderElement=function(renderQueueElements,scene,projectionView){
		var lastRenderElement,renderElement;
		var count=this._batchRenderElements.length;
		var canMerge=true;
		for (var i=0;i < count;i++){
			renderElement=this._batchRenderElements [i];
			var render=renderElement._sprite3D._render;
			var lastRender;
			if (i!==0){
				lastRenderElement=this._batchRenderElements [i-1];
				lastRender=lastRenderElement._sprite3D._render;
				canMerge=(lastRender.lightmapIndex!==render.lightmapIndex || lastRender.receiveShadow!==render.receiveShadow || lastRenderElement._batchIndexEnd!==renderElement._batchIndexStart);
			};
			var merageElement;
			if (canMerge){
				merageElement=this._getCombineRenderElementFromPool();
				merageElement.renderObj=this;
				merageElement._material=this._material;
				merageElement._batchIndexStart=(renderElement)._batchIndexStart;
				merageElement._batchIndexEnd=(renderElement)._batchIndexEnd;
				var lightMapIndex=render.lightmapIndex;
				var cacheLightMapIndex=lightMapIndex+1;
				var lightMapBatchOwnerIndices=this._batchOwnerIndices[cacheLightMapIndex];
				(lightMapBatchOwnerIndices)|| (lightMapBatchOwnerIndices=this._batchOwnerIndices[cacheLightMapIndex]=[]);
				var batchOwnerIndex=lightMapBatchOwnerIndices[renderElement._render.receiveShadow ? 1 :0];
				var batchOwner;
				if (batchOwnerIndex===undefined){
					lightMapBatchOwnerIndices[render.receiveShadow ? 1 :0]=this._batchOwners.length;
					batchOwner=new MeshSprite3D(null,"StaticBatchMeshSprite3D");
					batchOwner._scene=scene;
					batchOwner._transform=this._rootOwner ? this._rootOwner._transform :null;
					batchOwner._render.lightmapIndex=lightMapIndex;
					batchOwner._render.receiveShadow=renderElement._render.receiveShadow;
					this._batchOwners.push(batchOwner);
					}else {
					batchOwner=this._batchOwners[batchOwnerIndex];
				}
				batchOwner._render._renderUpdate(projectionView);
				merageElement._sprite3D=batchOwner;
				renderQueueElements.push(merageElement);
				}else {
				merageElement._batchIndexEnd=(renderElement)._batchIndexEnd;
			}
		}
	}

	/**
	*@inheritDoc
	*/
	__proto._beforeRender=function(state){
		this._vertexBuffer._bind();
		this._indexBuffer._bind();
		return true;
	}

	/**
	*@inheritDoc
	*/
	__proto._render=function(state){
		var renderElement=state.renderElement;
		var batchIndexStart=renderElement._batchIndexStart;
		var indexCount=renderElement._batchIndexEnd-batchIndexStart;
		WebGL.mainContext.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,indexCount,/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,batchIndexStart *2);
		Stat.drawCall++;
		Stat.trianglesFaces+=indexCount / 3;
	}

	/**
	*@inheritDoc
	*/
	__proto.dispose=function(){
		this._batchOwnerIndices=null;
		this._batchOwners=null;
		this._vertexDeclaration=null;
		this._vertexBuffer.destroy();
		this._indexBuffer.destroy();
	}

	//..................临时.................................
	__proto._getVertexBuffer=function(index){
		(index===void 0)&& (index=0);
		return this._vertexBuffer;
	}

	return SubMeshStaticBatch;
})(StaticBatch)


/**
*<code>Sky</code> 类用于创建天空盒。
*/
//class laya.d3.resource.models.SkyBox extends laya.d3.resource.models.Sky
var SkyBox=(function(_super){
	function SkyBox(){
		/**@private */
		//this._numberVertices=0;
		/**@private */
		//this._numberIndices=0;
		/**@private 天空立方体纹理。 */
		//this._textureCube=null;
		SkyBox.__super.call(this);
		SkyBox._nameNumber++;
		this.loadShaderParams();
		this.createResource();
		this.alphaBlending=1;
		this.colorIntensity=1;
	}

	__class(SkyBox,'laya.d3.resource.models.SkyBox',_super);
	var __proto=SkyBox.prototype;
	/**
	*@private
	*/
	__proto._getShader=function(state){
		var shaderDefineValue=state.scene._shaderDefineValue;
		this._shader=this._shaderCompile.withCompile(shaderDefineValue,0,0);
		return this._shader;
	}

	/**
	*@private
	*/
	__proto.createResource=function(){
		this._numberVertices=36;
		this._numberIndices=36;
		var indices=new Uint16Array(this._numberIndices);
		var vertexFloatStride=SkyBox._vertexDeclaration.vertexStride / 4;
		var vertices=new Float32Array(this._numberVertices *vertexFloatStride);
		var width=1.0;
		var height=1.0;
		var depth=1.0;
		var halfWidth=width / 2.0;
		var halfHeight=height / 2.0;
		var halfDepth=depth / 2.0;
		var topLeftFront=new Vector3(-halfWidth,halfHeight,halfDepth);
		var bottomLeftFront=new Vector3(-halfWidth,-halfHeight,halfDepth);
		var topRightFront=new Vector3(halfWidth,halfHeight,halfDepth);
		var bottomRightFront=new Vector3(halfWidth,-halfHeight,halfDepth);
		var topLeftBack=new Vector3(-halfWidth,halfHeight,-halfDepth);
		var topRightBack=new Vector3(halfWidth,halfHeight,-halfDepth);
		var bottomLeftBack=new Vector3(-halfWidth,-halfHeight,-halfDepth);
		var bottomRightBack=new Vector3(halfWidth,-halfHeight,-halfDepth);
		var vertexCount=0;
		vertexCount=this._addVertex(vertices,vertexCount,topLeftFront);
		vertexCount=this._addVertex(vertices,vertexCount,bottomLeftFront);
		vertexCount=this._addVertex(vertices,vertexCount,topRightFront);
		vertexCount=this._addVertex(vertices,vertexCount,bottomLeftFront);
		vertexCount=this._addVertex(vertices,vertexCount,bottomRightFront);
		vertexCount=this._addVertex(vertices,vertexCount,topRightFront);
		vertexCount=this._addVertex(vertices,vertexCount,topLeftBack);
		vertexCount=this._addVertex(vertices,vertexCount,topRightBack);
		vertexCount=this._addVertex(vertices,vertexCount,bottomLeftBack);
		vertexCount=this._addVertex(vertices,vertexCount,bottomLeftBack);
		vertexCount=this._addVertex(vertices,vertexCount,topRightBack);
		vertexCount=this._addVertex(vertices,vertexCount,bottomRightBack);
		vertexCount=this._addVertex(vertices,vertexCount,topLeftFront);
		vertexCount=this._addVertex(vertices,vertexCount,topRightBack);
		vertexCount=this._addVertex(vertices,vertexCount,topLeftBack);
		vertexCount=this._addVertex(vertices,vertexCount,topLeftFront);
		vertexCount=this._addVertex(vertices,vertexCount,topRightFront);
		vertexCount=this._addVertex(vertices,vertexCount,topRightBack);
		vertexCount=this._addVertex(vertices,vertexCount,bottomLeftFront);
		vertexCount=this._addVertex(vertices,vertexCount,bottomLeftBack);
		vertexCount=this._addVertex(vertices,vertexCount,bottomRightBack);
		vertexCount=this._addVertex(vertices,vertexCount,bottomLeftFront);
		vertexCount=this._addVertex(vertices,vertexCount,bottomRightBack);
		vertexCount=this._addVertex(vertices,vertexCount,bottomRightFront);
		vertexCount=this._addVertex(vertices,vertexCount,topLeftFront);
		vertexCount=this._addVertex(vertices,vertexCount,bottomLeftBack);
		vertexCount=this._addVertex(vertices,vertexCount,bottomLeftFront);
		vertexCount=this._addVertex(vertices,vertexCount,topLeftBack);
		vertexCount=this._addVertex(vertices,vertexCount,bottomLeftBack);
		vertexCount=this._addVertex(vertices,vertexCount,topLeftFront);
		vertexCount=this._addVertex(vertices,vertexCount,topRightFront);
		vertexCount=this._addVertex(vertices,vertexCount,bottomRightFront);
		vertexCount=this._addVertex(vertices,vertexCount,bottomRightBack);
		vertexCount=this._addVertex(vertices,vertexCount,topRightBack);
		vertexCount=this._addVertex(vertices,vertexCount,topRightFront);
		vertexCount=this._addVertex(vertices,vertexCount,bottomRightBack);
		for (var i=0;i < 36;i++)
		indices[i]=i;
		this._vertexBuffer=new VertexBuffer3D(SkyBox._vertexDeclaration,this._numberVertices,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
		this._indexBuffer=new IndexBuffer3D(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",this._numberIndices,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
		this._vertexBuffer.setData(vertices);
		this._indexBuffer.setData(indices);
	}

	/**
	*@private
	*/
	__proto._addVertex=function(vertices,index,position){
		var posE=position.elements;
		vertices[index+0]=posE[0];
		vertices[index+1]=posE[1];
		vertices[index+2]=posE[2];
		return index+3;
	}

	/**
	*@private
	*/
	__proto.loadShaderParams=function(){
		this._sharderNameID=Shader3D.nameKey.getID("SkyBox");
		this._shaderCompile=ShaderCompile3D._preCompileShader[this._sharderNameID];
	}

	__proto._render=function(state){
		if (this._textureCube && this._textureCube.loaded){
			this._vertexBuffer._bind();
			this._indexBuffer._bind();
			this._shader=this._getShader(state);
			this._shader.bind();
			state.camera.transform.worldMatrix.cloneTo(SkyBox._tempMatrix4x40);
			SkyBox._tempMatrix4x40.transpose();
			Matrix4x4.multiply(state._projectionMatrix,SkyBox._tempMatrix4x40,SkyBox._tempMatrix4x41);
			state.camera._shaderValues.setValue(/*laya.d3.core.BaseCamera.VPMATRIX_NO_TRANSLATE*/4,SkyBox._tempMatrix4x41.elements);
			this._shader.uploadCameraUniforms(state.camera._shaderValues.data);
			this._shaderValue.setValue(1,this._colorIntensity);
			this._shaderValue.setValue(2,this._alphaBlending);
			this._shaderValue.setValue(3,this.textureCube);
			this._shader.uploadAttributes(SkyBox._vertexDeclaration.shaderValues.data,null);
			this._shader.uploadMaterialUniforms(this._shaderValue.data);
			WebGL.mainContext.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,36,/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,0);
			Stat.trianglesFaces+=12;
			Stat.drawCall++;
		}
	}

	/**
	*@inheritDoc
	*/
	__proto.destroy=function(){
		_super.prototype.destroy.call(this);
		(this._textureCube)&& (this._textureCube._removeReference(),this._textureCube=null);
	}

	/**
	*设置天空立方体纹理。
	*@param value 天空立方体纹理。
	*/
	/**
	*获取天空立方体纹理。
	*@return 天空立方体纹理。
	*/
	__getset(0,__proto,'textureCube',function(){
		return this._textureCube;
		},function(value){
		if (this._textureCube!==value){
			(this._textureCube)&& (this._textureCube._removeReference());
			this._textureCube=value;
			(value)&& (value._addReference());
		}
	});

	SkyBox._nameNumber=1;
	__static(SkyBox,
	['_tempMatrix4x40',function(){return this._tempMatrix4x40=new Matrix4x4();},'_tempMatrix4x41',function(){return this._tempMatrix4x41=new Matrix4x4();},'_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(12,[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0)]);}
	]);
	return SkyBox;
})(Sky)


/**
*<code>Sky</code> 类用于创建天空盒。
*/
//class laya.d3.resource.models.SkyDome extends laya.d3.resource.models.Sky
var SkyDome=(function(_super){
	function SkyDome(){
		/**@private */
		//this._numberVertices=0;
		/**@private */
		//this._numberIndices=0;
		/**@private 天空立方体纹理。 */
		//this._texture=null;
		this._stacks=16;
		this._slices=16;
		this._radius=1;
		SkyDome.__super.call(this);
		SkyDome._nameNumber++;
		this.loadShaderParams();
		this.recreateResource();
		this.alphaBlending=1;
		this.colorIntensity=1;
	}

	__class(SkyDome,'laya.d3.resource.models.SkyDome',_super);
	var __proto=SkyDome.prototype;
	/**
	*@private
	*/
	__proto._getShader=function(state){
		var shaderDefineValue=state.scene._shaderDefineValue;
		this._shader=this._shaderCompile.withCompile(shaderDefineValue,0,0);
		return this._shader;
	}

	/**
	*@private
	*/
	__proto.recreateResource=function(){
		this._numberVertices=(this._stacks+1)*(this._slices+1);
		this._numberIndices=(3 *this._stacks *(this._slices+1))*2;
		var indices=new Uint16Array(this._numberIndices);
		var vertexFloatStride=SkyDome._vertexDeclaration.vertexStride / 4;
		var vertices=new Float32Array(this._numberVertices *vertexFloatStride);
		var stackAngle=Math.PI / this._stacks;
		var sliceAngle=(Math.PI *2.0)/ this._slices;
		var vertexIndex=0;
		var vertexCount=0;
		var indexCount=0;
		for (var stack=0;stack < (this._stacks+1);stack++){
			var r=Math.sin(stack *stackAngle);
			var y=Math.cos(stack *stackAngle);
			for (var slice=0;slice < (this._slices+1);slice++){
				var x=r *Math.sin(slice *sliceAngle);
				var z=r *Math.cos(slice *sliceAngle);
				vertices[vertexCount+0]=x *this._radius;
				vertices[vertexCount+1]=y *this._radius;
				vertices[vertexCount+2]=z *this._radius;
				vertices[vertexCount+3]=-(slice / this._slices)+0.75;
				vertices[vertexCount+4]=stack / this._stacks;
				vertexCount+=vertexFloatStride;
				if (stack !=(this._stacks-1)){
					indices[indexCount++]=vertexIndex+1;
					indices[indexCount++]=vertexIndex;
					indices[indexCount++]=vertexIndex+(this._slices+1);
					indices[indexCount++]=vertexIndex+(this._slices+1);
					indices[indexCount++]=vertexIndex;
					indices[indexCount++]=vertexIndex+(this._slices);
					vertexIndex++;
				}
			}
		}
		this._vertexBuffer=new VertexBuffer3D(SkyDome._vertexDeclaration,this._numberVertices,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4);
		this._indexBuffer=new IndexBuffer3D(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",this._numberIndices,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4);
		this._vertexBuffer.setData(vertices);
		this._indexBuffer.setData(indices);
	}

	/**
	*@private
	*/
	__proto.loadShaderParams=function(){
		this._sharderNameID=Shader3D.nameKey.getID("SkyDome");
		this._shaderCompile=ShaderCompile3D._preCompileShader[this._sharderNameID];
	}

	__proto._render=function(state){
		if (this._texture && this._texture.loaded){
			this._vertexBuffer._bind();
			this._indexBuffer._bind();
			this._shader=this._getShader(state);
			this._shader.bind();
			state.camera.transform.worldMatrix.cloneTo(SkyDome._tempMatrix4x40);
			SkyDome._tempMatrix4x40.transpose();
			Matrix4x4.multiply(state._projectionMatrix,SkyDome._tempMatrix4x40,SkyDome._tempMatrix4x41);
			state.camera._shaderValues.setValue(/*laya.d3.core.BaseCamera.VPMATRIX_NO_TRANSLATE*/4,SkyDome._tempMatrix4x41.elements);
			this._shader.uploadCameraUniforms(state.camera._shaderValues.data);
			this._shaderValue.setValue(1,this._colorIntensity);
			this._shaderValue.setValue(2,this._alphaBlending);
			this._shaderValue.setValue(3,this.texture);
			this._shader.uploadAttributes(SkyDome._vertexDeclaration.shaderValues.data,null);
			this._shader.uploadMaterialUniforms(this._shaderValue.data);
			WebGL.mainContext.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,this._indexBuffer.indexCount,/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,0);
			Stat.trianglesFaces+=this._numberIndices / 3;
			Stat.drawCall++;
		}
	}

	__proto.onEnvDescLoaded=function(envInfoFile){
		var envPath='';
		var ppos=Math.max(envInfoFile.lastIndexOf('/'),envInfoFile.lastIndexOf('\\'));
		if (ppos > 0){
			envPath=envInfoFile.substr(0,ppos+1);
		};
		var envinfoobj=Laya.loader.getRes(envInfoFile);
		if (envinfoobj.ev !=undefined && this.__ownerCamera)
			this.__ownerCamera._shaderValues.setValue(/*laya.d3.core.BaseCamera.HDREXPOSURE*/13,Math.pow(2,envinfoobj.ev));
		else
		this.__ownerCamera._shaderValues.setValue(/*laya.d3.core.BaseCamera.HDREXPOSURE*/13,Math.pow(2,0.0));
		this.texture=Texture2D.load(envPath+envinfoobj.skytex);
		this.environmentSpecular=DataTexture2D.load(envPath+envinfoobj.prefiltedEnv);
		var irrdMat=new Float32Array(envinfoobj.IrradianceMat);
		this.envDiffuseSHRed=irrdMat.slice(0,16);
		this.envDiffuseSHGreen=irrdMat.slice(16,32);
		this.envDiffuseSHBlue=irrdMat.slice(32,48);
	}

	__proto.loadEnvInfo=function(envInfo){
		Laya.loader.load(envInfo,Handler.create(this,this.onEnvDescLoaded,[envInfo]));
	}

	/**
	*@inheritDoc
	*/
	__proto.destroy=function(){
		_super.prototype.destroy.call(this);
		(this._texture)&& (this._texture._removeReference(),this._texture=null);
	}

	/**
	*设置天空纹理。
	*@param value 天空纹理。
	*/
	/**
	*获取天空立方体纹理。
	*@return 天空立方体纹理。
	*/
	__getset(0,__proto,'texture',function(){
		return this._texture;
		},function(value){
		if (this._texture!==value){
			(this._texture)&& (this._texture._removeReference());
			this._texture=value;
			(value)&& (value._addReference());
		}
	});

	SkyDome._nameNumber=1;
	__static(SkyDome,
	['_tempMatrix4x40',function(){return this._tempMatrix4x40=new Matrix4x4();},'_tempMatrix4x41',function(){return this._tempMatrix4x41=new Matrix4x4();},'_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(20,[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.VertexElementUsage.POSITION0*/0),new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.VertexElementUsage.TEXTURECOORDINATE0*/2)]);}
	]);
	return SkyDome;
})(Sky)


/**
*@private
*<code>ComponentNode</code> 类用于实现组件精灵,该类为抽象类。
*/
//class laya.d3.core.ComponentNode extends laya.display.Node
var ComponentNode=(function(_super){
	function ComponentNode(){
		/**@private */
		this._componentsMap=null;
		/**@private */
		this._typeComponentsIndices=null;
		/**@private */
		this._components=null;
		/**@private */
		this._scripts=null;
		ComponentNode.__super.call(this);
		this._componentsMap=[];
		this._typeComponentsIndices=[];
		this._components=[];
		this._scripts=[];
	}

	__class(ComponentNode,'laya.d3.core.ComponentNode',_super);
	var __proto=ComponentNode.prototype;
	/**
	*添加指定类型组件。
	*@param type 组件类型。
	*@return 组件。
	*/
	__proto.addComponent=function(type){
		var typeComponentIndex;
		var index=this._componentsMap.indexOf(type);
		if (index===-1){
			typeComponentIndex=[];
			this._componentsMap.push(type);
			this._typeComponentsIndices.push(typeComponentIndex);
			}else {
			typeComponentIndex=this._typeComponentsIndices[index];
			if (this._components[typeComponentIndex[0]].isSingleton)
				throw new Error("无法单实例创建"+type+"组件"+"，"+type+"组件已存在！");
		};
		var component=ClassUtils.getInstance(type);
		typeComponentIndex.push(this._components.length);
		this._components.push(component);
		if ((component instanceof laya.d3.component.Script ))
			this._scripts.push(component);
		component._initialize(this);
		return component;
	}

	/**
	*@private
	*/
	__proto._removeComponent=function(mapIndex,index){
		var componentIndices=this._typeComponentsIndices[mapIndex];
		var componentIndex=componentIndices[index];
		var component=this._components[componentIndex];
		this._components.splice(componentIndex,1);
		if ((component instanceof laya.d3.component.Script ))
			this._scripts.splice(this._scripts.indexOf(component),1);
		componentIndices.splice(index,1);
		(componentIndices.length===0)&& (this._typeComponentsIndices.splice(mapIndex,1),this._componentsMap.splice(mapIndex,1));
		for (var i=0,n=this._componentsMap.length;i < n;i++){
			componentIndices=this._typeComponentsIndices[i];
			for (var j=componentIndices.length-1;j >=0;j--){
				var oldComponentIndex=componentIndices[j];
				if (oldComponentIndex > componentIndex)
					componentIndices[j]=--oldComponentIndex;
				else
				break ;
			}
		}
		component._destroy();
	}

	/**
	*通过指定类型和类型索引获得组件。
	*@param type 组件类型。
	*@param typeIndex 类型索引。
	*@return 组件。
	*/
	__proto.getComponentByType=function(type,typeIndex){
		(typeIndex===void 0)&& (typeIndex=0);
		var mapIndex=this._componentsMap.indexOf(type);
		if (mapIndex===-1)
			return null;
		return this._components[this._typeComponentsIndices[mapIndex][typeIndex]];
	}

	/**
	*通过指定类型获得所有组件。
	*@param type 组件类型。
	*@param components 组件输出队列。
	*/
	__proto.getComponentsByType=function(type,components){
		var index=this._componentsMap.indexOf(type);
		if (index===-1){
			components.length=0;
			return;
		};
		var typeComponents=this._typeComponentsIndices[index];
		var count=typeComponents.length;
		components.length=count;
		for (var i=0;i < count;i++)
		components[i]=this._components[typeComponents[i]];
	}

	/**
	*通过指定索引获得组件。
	*@param index 索引。
	*@return 组件。
	*/
	__proto.getComponentByIndex=function(index){
		return this._components[index];
	}

	/**
	*通过指定类型和类型索引移除组件。
	*@param type 组件类型。
	*@param typeIndex 类型索引。
	*/
	__proto.removeComponentByType=function(type,typeIndex){
		(typeIndex===void 0)&& (typeIndex=0);
		var mapIndex=this._componentsMap.indexOf(type);
		if (mapIndex===-1)
			return;
		this._removeComponent(mapIndex,typeIndex);
	}

	/**
	*通过指定类型移除所有组件。
	*@param type 组件类型。
	*/
	__proto.removeComponentsByType=function(type){
		var mapIndex=this._componentsMap.indexOf(type);
		if (mapIndex===-1)
			return;
		var componentIndices=this._typeComponentsIndices[mapIndex];
		for (var i=0,n=componentIndices.length;i < n;componentIndices.length < n ? n--:i++)
		this._removeComponent(mapIndex,i);
	}

	/**
	*移除全部组件。
	*/
	__proto.removeAllComponent=function(){
		for (var i=0,n=this._componentsMap.length;i < n;this._componentsMap.length < n ? n--:i++)
		this.removeComponentsByType(this._componentsMap[i]);
	}

	/**
	*@private
	*/
	__proto._updateComponents=function(state){
		for (var i=0,n=this._components.length;i < n;i++){
			var component=this._components[i];
			(!component.started)&& (component._start(state),component.started=true);
			(component.enable)&& (component._update(state));
		}
	}

	/**
	*@private
	*/
	__proto._lateUpdateComponents=function(state){
		for (var i=0;i < this._components.length;i++){
			var component=this._components[i];
			(!component.started)&& (component._start(state),component.started=true);
			(component.enable)&& (component._lateUpdate(state));
		}
	}

	/**
	*@private
	*/
	__proto._preRenderUpdateComponents=function(state){
		for (var i=0;i < this._components.length;i++){
			var component=this._components[i];
			(!component.started)&& (component._start(state),component.started=true);
			(component.enable)&& (component._preRenderUpdate(state));
		}
	}

	/**
	*@private
	*/
	__proto._postRenderUpdateComponents=function(state){
		for (var i=0;i < this._components.length;i++){
			var component=this._components[i];
			(!component.started)&& (component._start(state),component.started=true);
			(component.enable)&& (component._postRenderUpdate(state));
		}
	}

	return ComponentNode;
})(Node)


/**
*<code>AnimationClip</code> 类用于动画片段资源。
*/
//class laya.d3.animation.AnimationClip extends laya.resource.Resource
var AnimationClip=(function(_super){
	function AnimationClip(){
		/**@private */
		this._realTimeCurrentFrameIndexes=null;
		/**@private */
		this._realTimeCurrentTimes=null;
		/**@private */
		this._fullKeyframeIndicesCache=null;
		/**@private */
		this._animationDatasCache=null;
		/**@private */
		this._avatarDatasCache=null;
		/**@private */
		this._skinnedDatasCache=null;
		/**@private */
		this._version=null;
		/**@private */
		this._nodes=null;
		/**@private */
		this._nodesMap=null;
		/**@private */
		this._cachePropertyMap=null;
		/**@private */
		this._nodeToCachePropertyMap=null;
		/**@private */
		this._unCachePropertyMap=null;
		/**@private */
		this._duration=NaN;
		/**@private */
		this._frameRate=0;
		/**@private */
		this._animationEvents=null;
		/**@private */
		this._publicClipDatas=null;
		/**是否循环。*/
		this.islooping=false;
		AnimationClip.__super.call(this);
		this._fullKeyframeIndicesCache={};
		this._animationDatasCache=[];
		this._avatarDatasCache=[];
		this._skinnedDatasCache=[];
		this._animationEvents=[];
	}

	__class(AnimationClip,'laya.d3.animation.AnimationClip',_super);
	var __proto=AnimationClip.prototype;
	/**
	*获取动画片段时长。
	*/
	__proto.duration=function(){
		return this._duration;
	}

	/**
	*@private
	*/
	__proto._hermiteInterpolate=function(frame,t,dur,out){
		var p0=frame.data;
		var tan0=frame.outTangent;
		var nextFrame=frame.next;
		var p1=nextFrame.data;
		var tan1=nextFrame.inTangent;
		var isComputeParams=false;
		var a=NaN,b=NaN,c=NaN,d=NaN;
		for (var i=0,n=out.length;i < n;i++){
			var t0=tan0[i],t1=tan1[i];
			if (/*__JS__ */Number.isFinite(t0)&& Number.isFinite(t1)){
				if (!isComputeParams){
					var t2=t *t;
					var t3=t2 *t;
					a=2.0 *t3-3.0 *t2+1.0;
					b=t3-2.0 *t2+t;
					c=t3-t2;
					d=-2.0 *t3+3.0 *t2;
					isComputeParams=true;
				}
				out[i]=a *p0[i]+b *t0 *dur+c *t1 *dur+d *p1[i];
			}else
			out[i]=p0[i];
		}
	}

	/**
	*@private
	*/
	__proto._getFullKeyframeIndicesWithCache=function(cacheInterval){
		return this._fullKeyframeIndicesCache[cacheInterval];
	}

	/**
	*@private
	*/
	__proto._cacheFullKeyframeIndices=function(cacheInterval,datas){
		this._fullKeyframeIndicesCache[cacheInterval]=datas;
	}

	/**
	*@private
	*/
	__proto._getAnimationDataWithCache=function(cacheRate,frameIndex){
		var cacheDatas=this._animationDatasCache[cacheRate];
		if (!cacheDatas)
			return null;
		else {
			return cacheDatas[frameIndex];
		}
	}

	/**
	*@private
	*/
	__proto._cacheAnimationData=function(cacheRate,frameIndex,datas){
		var aniDatasCache=(this._animationDatasCache[cacheRate])|| (this._animationDatasCache[cacheRate]=[]);
		aniDatasCache[frameIndex]=datas;
	}

	/**
	*@private
	*/
	__proto._getAvatarDataWithCache=function(avatar,cacheRate,frameIndex){
		var clipCache=this._avatarDatasCache[avatar.id];
		if (!clipCache){
			return null;
			}else {
			var rateCache=clipCache[cacheRate];
			if (!rateCache)
				return null;
			else {
				return rateCache[frameIndex];
			}
		}
	}

	/**
	*@private
	*/
	__proto._cacheAvatarData=function(avatar,cacheRate,frameIndex,datas){
		var clipCache=(this._avatarDatasCache[avatar.id])|| (this._avatarDatasCache[avatar.id]=[]);
		var rateCache=(clipCache[cacheRate])|| (clipCache[cacheRate]=[]);
		rateCache[frameIndex]=datas;
	}

	/**
	*@private
	*/
	__proto._evaluateAnimationlDatasCacheMode=function(nodeOwners,nodesFrameIndices,animator,clipDatas,propertyMap){
		var j=0,m=0;
		for (var i=0,n=propertyMap ? propertyMap.length :this._nodes.length;i < n;i++){
			var nodeIndex=propertyMap ? propertyMap[i] :i;
			var node=this._nodes[nodeIndex];
			var cacheProperty=node._cacheProperty;
			if (!nodeOwners[nodeIndex])
				continue ;
			var frameIndices=nodesFrameIndices[nodeIndex];
			var realFrameIndex=frameIndices[animator.currentFrameIndex];
			var outDatas;
			var lastFrameIndex=0;
			if (realFrameIndex!==-1){
				var frame=node.keyFrames[realFrameIndex];
				var nextKeyFrame=frame.next;
				if (nextKeyFrame){
					if (propertyMap && !cacheProperty){
						outDatas=clipDatas[nodeIndex];
						(outDatas)|| (outDatas=clipDatas[nodeIndex]=new Float32Array(node.keyFrameWidth));
						}else {
						outDatas=new Float32Array(node.keyFrameWidth);
						clipDatas[i]=outDatas;
					};
					var t=NaN;
					var d=frame.duration;
					if (d!==0)
						t=(animator.currentFrameTime-frame.startTime)/ d;
					else
					t=0;
					this._hermiteInterpolate(frame,t,d,outDatas);
					}else {
					if (propertyMap && !cacheProperty){
						outDatas=clipDatas[nodeIndex];
						(outDatas)|| (outDatas=clipDatas[nodeIndex]=new Float32Array(node.keyFrameWidth));
						}else {
						lastFrameIndex=animator._lastFrameIndex;
						if (lastFrameIndex!==-1 && frameIndices[lastFrameIndex]===realFrameIndex)
							continue ;
						outDatas=new Float32Array(node.keyFrameWidth);
						clipDatas[i]=outDatas;
					};
					var frameData=frame.data;
					for (j=0,m=outDatas.length;j < m;j++)
					outDatas[j]=frameData[j];
				}
				}else {
				if (propertyMap && !cacheProperty){
					outDatas=clipDatas[nodeIndex];
					(outDatas)|| (outDatas=clipDatas[nodeIndex]=new Float32Array(node.keyFrameWidth));
					}else {
					lastFrameIndex=animator._lastFrameIndex;
					if (lastFrameIndex!==-1 && frameIndices[lastFrameIndex]===realFrameIndex)
						continue ;
					outDatas=new Float32Array(node.keyFrameWidth);
					clipDatas[i]=outDatas;
				};
				var firstFrameDatas=node.keyFrames[0].data;
				for (j=0,m=outDatas.length;j < m;j++)
				outDatas[j]=firstFrameDatas[j];
			}
		}
	}

	/**
	*@private
	*/
	__proto._evaluateAnimationlDatasRealTime=function(nodeOwners,playCurTime,outAnimationDatas,propertyMap){
		var i=0,n=0;
		var nodes=this._nodes;
		if (!this._realTimeCurrentFrameIndexes){
			this._realTimeCurrentFrameIndexes=new Int32Array(nodes.length);
			for (i=0,n=nodes.length;i < n;i++)
			this._realTimeCurrentFrameIndexes[i]=-1;
			this._realTimeCurrentTimes=new Float32Array(nodes.length);
		}
		for (i=0,n=propertyMap ? propertyMap.length :this._nodes.length;i < n;i++){
			var index=propertyMap ? propertyMap[i] :i;
			var node=nodes[index];
			if (playCurTime < this._realTimeCurrentTimes[index])
				this._realTimeCurrentFrameIndexes[index]=-1;
			this._realTimeCurrentTimes[index]=playCurTime;
			var nextFrameIndex=this._realTimeCurrentFrameIndexes[index]+1;
			var keyFrames=node.keyFrames;
			var keyFramesCount=keyFrames.length;
			while (nextFrameIndex < keyFramesCount){
				if (keyFrames[nextFrameIndex].startTime > playCurTime){
					this._realTimeCurrentFrameIndexes[index]=nextFrameIndex-1;
					break ;
				}
				nextFrameIndex++;
			}
			(nextFrameIndex===keyFramesCount)&& (this._realTimeCurrentFrameIndexes[index]=keyFramesCount-1);
			var j=0,m=0;
			var outDatas=outAnimationDatas[index];
			(outDatas)|| (outDatas=outAnimationDatas[index]=new Float32Array(node.keyFrameWidth));
			var frame=keyFrames[this._realTimeCurrentFrameIndexes[index]];
			if (frame){
				var nextFarme=frame.next;
				if (nextFarme){
					var d=frame.duration;
					var t=NaN;
					if (d!==0)
						t=(playCurTime-frame.startTime)/ d;
					else
					t=0;
					this._hermiteInterpolate(frame,t,d,outDatas);
					}else {
					var frameData=frame.data;
					for (j=0,m=outDatas.length;j < m;j++)
					outDatas[j]=frameData[j];
				}
				}else {
				var firstFrameDatas=node.keyFrames[0].data;
				for (j=0,m=outDatas.length;j < m;j++)
				outDatas[j]=firstFrameDatas[j];
			};
			var owner=nodeOwners[index];
			if (owner){
				if (propertyMap)
					AnimationNode._propertySetFuncs[node.propertyNameID](owner,null,outDatas);
				else
				AnimationNode._propertySetFuncs[node.propertyNameID](null,owner,outDatas);
			}
		}
	}

	/**
	*@private
	*/
	__proto._binarySearchEventIndex=function(time){
		var start=0;
		var end=this._animationEvents.length-1;
		var mid=0;
		while (start <=end){
			mid=Math.floor((start+end)/ 2);
			var midValue=this._animationEvents[mid].time;
			if (midValue==time)
				return mid;
			else if (midValue > time)
			end=mid-1;
			else
			start=mid+1;
		}
		return start;
	}

	/**
	*添加动画事件。
	*/
	__proto.addEvent=function(event){
		var index=this._binarySearchEventIndex(event.time);
		this._animationEvents.splice(index,0,event);
	}

	/**
	*@inheritDoc
	*/
	__proto.onAsynLoaded=function(url,data,params){
		var reader=new Byte(data);
		this._version=reader.readUTFString();
		switch (this._version){
			case "LAYAANIMATION:01":
				AnimationClipParser01.parse(this,reader);
				break ;
			case "LAYAANIMATION:02":
				AnimationClipParser02.parse(this,reader);
				break ;
			}
		this.completeCreate();
		this._endLoaded();
	}

	/**
	*@inheritDoc
	*/
	__proto.disposeResource=function(){
		this._realTimeCurrentFrameIndexes=null;
		this._realTimeCurrentTimes=null;
		this._fullKeyframeIndicesCache=null;
		this._animationDatasCache=null;
		this._avatarDatasCache=null;
		this._skinnedDatasCache=null;
		this._version=null;
		this._nodes=null;
		this._nodesMap=null;
		this._cachePropertyMap=null;
		this._nodeToCachePropertyMap=null;
		this._unCachePropertyMap=null;
		this._publicClipDatas=null;
	}

	AnimationClip.load=function(url){
		return Laya.loader.create(url,null,null,AnimationClip);
	}

	return AnimationClip;
})(Resource)


/**
*<code>Avatar</code> 类用于创建Avatar。
*/
//class laya.d3.core.Avatar extends laya.resource.Resource
var Avatar=(function(_super){
	function Avatar(){
		/**@private */
		//this._version=null;
		/**@private */
		//this._rootNode=null;
		Avatar.__super.call(this);
	}

	__class(Avatar,'laya.d3.core.Avatar',_super);
	var __proto=Avatar.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*@private
	*/
	__proto._initCloneToAnimator=function(destNode,destAnimator){
		destAnimator._avatarNodeMap[destNode.name]=destNode;
		destAnimator._avatarNodes.push(destNode);
		for (var i=0,n=destNode.getChildCount();i < n;i++)
		this._initCloneToAnimator(destNode.getChildByIndex(i),destAnimator);
	}

	/**
	*@private
	*/
	__proto._parseNode=function(nodaData,node){
		var name=nodaData.props.name;
		node.name=name;
		if (node._parent){
			var customProps=nodaData.customProps;
			var transform=node.transform;
			transform._localRotationEuler=new Float32Array(3);
			transform.setLocalPosition(new Float32Array(customProps.translate));
			transform.setLocalRotation(new Float32Array(customProps.rotation));
			transform.setLocalScale(new Float32Array(customProps.scale));
			transform._setWorldMatrixAndUpdate(new Float32Array(16));
		};
		var childrenData=nodaData.child;
		for (var i=0,n=childrenData.length;i < n;i++){
			var childData=childrenData[i];
			var childBone=new AnimationNode();
			node.addChild(childBone);
			this._parseNode(childData,childBone);
		}
	}

	/**
	*@inheritDoc
	*/
	__proto.onAsynLoaded=function(url,data,params){
		this._rootNode=new AnimationNode();
		if (data.version){
			this._version=data.version;
			var rootNode=data.rootNode;
			(rootNode)&& (this._parseNode(rootNode,this._rootNode));
			}else {
			this._parseNode(data,this._rootNode);
		}
		this._endLoaded();
	}

	/**
	*克隆数据到Avatr。
	*@param destObject 克隆源。
	*/
	__proto._cloneDatasToAnimator=function(destAnimator){
		var destRoot=this._rootNode.clone();
		destRoot.transform._setWorldMatrixIgnoreUpdate(null);
		var avatarNodes=[];
		destAnimator._avatarNodeMap={};
		destAnimator._avatarNodes=avatarNodes;
		this._initCloneToAnimator(destRoot,destAnimator);
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destAvatar=destObject;
		var destRoot=this._rootNode.clone();
		destAvatar._rootNode=destRoot;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	Avatar.load=function(url){
		return Laya.loader.create(url,null,null,Avatar);
	}

	return Avatar;
})(Resource)


/**
*<code>BaseMaterial</code> 类用于创建材质,抽象类,不允许实例。
*/
//class laya.d3.core.material.BaseMaterial extends laya.resource.Resource
var BaseMaterial=(function(_super){
	function BaseMaterial(){
		/**@private */
		//this._shader=null;
		/**@private */
		//this._shaderCompile=null;
		/**@private */
		//this._shaderDefineValue=0;
		/**@private */
		//this._disablePublicShaderDefine=0;
		/**@private */
		//this._alphaTest=false;
		/**@private */
		//this._shaderValues=null;
		/**@private */
		//this._values=null;
		/**渲染剔除状态。*/
		//this.cull=0;
		/**透明混合。*/
		//this.blend=0;
		/**源混合参数,在blend为BLEND_ENABLE_ALL时生效。*/
		//this.srcBlend=0;
		/**目标混合参数,在blend为BLEND_ENABLE_ALL时生效。*/
		//this.dstBlend=0;
		/**RGB源混合参数,在blend为BLEND_ENABLE_SEPERATE时生效。*/
		//this.srcBlendRGB=0;
		/**RGB目标混合参数,在blend为BLEND_ENABLE_SEPERATE时生效。*/
		//this.dstBlendRGB=0;
		/**Alpha源混合参数,在blend为BLEND_ENABLE_SEPERATE时生效。*/
		//this.srcBlendAlpha=0;
		/**Alpha目标混合参数,在blend为BLEND_ENABLE_SEPERATE时生效。*/
		//this.dstBlendAlpha=0;
		/**混合常量颜色。*/
		//this.blendConstColor=null;
		/**混合方程。*/
		//this.blendEquation=0;
		/**RGB混合方程。*/
		//this.blendEquationRGB=0;
		/**Alpha混合方程。*/
		//this.blendEquationAlpha=0;
		/**深度测试函数。*/
		//this.depthTest=0;
		/**是否深度写入。*/
		//this.depthWrite=false;
		/**所属渲染队列. */
		//this.renderQueue=0;
		/**@private */
		//this._conchMaterial=null;
		BaseMaterial.__super.call(this);
		this._shaderDefineValue=0;
		this._disablePublicShaderDefine=0;
		this._shaderValues=new ValusArray();
		this._values=[];
		this.renderQueue=/*CLASS CONST:laya.d3.core.material.BaseMaterial.RENDERQUEUE_OPAQUE*/2000;
		this._alphaTest=false;
		this.cull=2;
		this.blend=0;
		this.srcBlend=1;
		this.dstBlend=0;
		this.srcBlendRGB=1;
		this.dstBlendRGB=0;
		this.srcBlendAlpha=1;
		this.dstBlendAlpha=0;
		this.blendConstColor=new Vector4(1,1,1,1);
		this.blendEquation=0;
		this.blendEquationRGB=0;
		this.blendEquationAlpha=0;
		this.depthTest=0x0201;
		this.depthWrite=true;
	}

	__class(BaseMaterial,'laya.d3.core.material.BaseMaterial',_super);
	var __proto=BaseMaterial.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*增加Shader宏定义。
	*@param value 宏定义。
	*/
	__proto._addShaderDefine=function(value){
		this._shaderDefineValue |=value;
	}

	/**
	*移除Shader宏定义。
	*@param value 宏定义。
	*/
	__proto._removeShaderDefine=function(value){
		this._shaderDefineValue &=~value;
	}

	/**
	*增加禁用宏定义。
	*@param value 宏定义。
	*/
	__proto._addDisablePublicShaderDefine=function(value){
		this._disablePublicShaderDefine |=value;
	}

	/**
	*移除禁用宏定义。
	*@param value 宏定义。
	*/
	__proto._removeDisablePublicShaderDefine=function(value){
		this._disablePublicShaderDefine &=~value;
	}

	/**
	*设置Buffer。
	*@param shaderIndex shader索引。
	*@param buffer buffer数据。
	*/
	__proto._setBuffer=function(shaderIndex,buffer){
		var shaderValue=this._shaderValues;
		shaderValue.setValue(shaderIndex,buffer);
		this._values[shaderIndex]=buffer;
	}

	/**
	*获取Buffer。
	*@param shaderIndex shader索引。
	*@return
	*/
	__proto._getBuffer=function(shaderIndex){
		return this._values[shaderIndex];
	}

	/**
	*设置矩阵。
	*@param shaderIndex shader索引。
	*@param matrix4x4 矩阵。
	*/
	__proto._setMatrix4x4=function(shaderIndex,matrix4x4){
		this._shaderValues.setValue(shaderIndex,matrix4x4 ? matrix4x4.elements :null);
		this._values[shaderIndex]=matrix4x4;
	}

	/**
	*获取矩阵。
	*@param shaderIndex shader索引。
	*@return 矩阵。
	*/
	__proto._getMatrix4x4=function(shaderIndex){
		return this._values[shaderIndex];
	}

	/**
	*设置整型。
	*@param shaderIndex shader索引。
	*@param i 整形。
	*/
	__proto._setInt=function(shaderIndex,i){
		var shaderValue=this._shaderValues;
		shaderValue.setValue(shaderIndex,i);
		this._values[shaderIndex]=i;
	}

	/**
	*获取整形。
	*@param shaderIndex shader索引。
	*@return 整形。
	*/
	__proto._getInt=function(shaderIndex){
		return this._values[shaderIndex];
	}

	/**
	*设置浮点。
	*@param shaderIndex shader索引。
	*@param i 浮点。
	*/
	__proto._setNumber=function(shaderIndex,number){
		var shaderValue=this._shaderValues;
		shaderValue.setValue(shaderIndex,number);
		this._values[shaderIndex]=number;
	}

	/**
	*获取浮点。
	*@param shaderIndex shader索引。
	*@return 浮点。
	*/
	__proto._getNumber=function(shaderIndex){
		return this._values[shaderIndex];
	}

	/**
	*设置布尔。
	*@param shaderIndex shader索引。
	*@param b 布尔。
	*/
	__proto._setBool=function(shaderIndex,b){
		var shaderValue=this._shaderValues;
		shaderValue.setValue(shaderIndex,b);
		this._values[shaderIndex]=b;
	}

	/**
	*获取布尔。
	*@param shaderIndex shader索引。
	*@return 布尔。
	*/
	__proto._getBool=function(shaderIndex){
		return this._values[shaderIndex];
	}

	/**
	*设置二维向量。
	*@param shaderIndex shader索引。
	*@param vector2 二维向量。
	*/
	__proto._setVector2=function(shaderIndex,vector2){
		var shaderValue=this._shaderValues;
		shaderValue.setValue(shaderIndex,vector2 ? vector2.elements :null);
		this._values[shaderIndex]=vector2;
	}

	/**
	*获取二维向量。
	*@param shaderIndex shader索引。
	*@return 二维向量。
	*/
	__proto._getVector2=function(shaderIndex){
		return this._values[shaderIndex];
	}

	/**
	*设置颜色。
	*@param shaderIndex shader索引。
	*@param color 颜色向量。
	*/
	__proto._setColor=function(shaderIndex,color){
		var shaderValue=this._shaderValues;
		shaderValue.setValue(shaderIndex,color ? color.elements :null);
		this._values[shaderIndex]=color;
	}

	/**
	*获取颜色。
	*@param shaderIndex shader索引。
	*@return 颜色向量。
	*/
	__proto._getColor=function(shaderIndex){
		return this._values[shaderIndex];
	}

	/**
	*设置纹理。
	*@param shaderIndex shader索引。
	*@param texture 纹理。
	*/
	__proto._setTexture=function(shaderIndex,texture){
		var lastValue=this._values[shaderIndex];
		this._values[shaderIndex]=texture;
		this._shaderValues.setValue(shaderIndex,texture);
		if (this.referenceCount > 0){
			(lastValue)&& (lastValue._removeReference());
			(texture)&& (texture._addReference());
		}
	}

	/**
	*获取纹理。
	*@param shaderIndex shader索引。
	*@return 纹理。
	*/
	__proto._getTexture=function(shaderIndex){
		return this._values[shaderIndex];
	}

	/**
	*上传材质。
	*@param state 相关渲染状态。
	*@param bufferUsageShader Buffer相关绑定。
	*@param shader 着色器。
	*@return 是否成功。
	*/
	__proto._upload=function(){
		this._shader.uploadMaterialUniforms(this._shaderValues.data);
	}

	/**
	*@private
	*/
	__proto._getShader=function(sceneDefineValue,vertexDefineValue,spriteDefineValue){
		var publicDefineValue=(sceneDefineValue | vertexDefineValue)& (~this._disablePublicShaderDefine);
		this._shader=this._shaderCompile.withCompile(publicDefineValue,spriteDefineValue,this._shaderDefineValue);
		return this._shader;
	}

	/**
	*设置渲染相关状态。
	*/
	__proto._setRenderStateBlendDepth=function(){
		var gl=WebGL.mainContext;
		WebGLContext.setDepthMask(gl,this.depthWrite);
		if (this.depthTest===0)
			WebGLContext.setDepthTest(gl,false);
		else {
			WebGLContext.setDepthTest(gl,true);
			WebGLContext.setDepthFunc(gl,this.depthTest);
		}
		switch (this.blend){
			case 0:
				WebGLContext.setBlend(gl,false);
				break ;
			case 1:
				WebGLContext.setBlend(gl,true);
				WebGLContext.setBlendFunc(gl,this.srcBlend,this.dstBlend);
				break ;
			case 2:
				WebGLContext.setBlend(gl,true);
				break ;
			}
	}

	/**
	*设置渲染相关状态。
	*/
	__proto._setRenderStateFrontFace=function(isTarget,transform){
		var gl=WebGL.mainContext;
		var forntFace=0;
		switch (this.cull){
			case 0:
				WebGLContext.setCullFace(gl,false);
				break ;
			case 1:
				WebGLContext.setCullFace(gl,true);
				if (isTarget){
					if (transform && transform._isFrontFaceInvert)
						forntFace=/*laya.webgl.WebGLContext.CCW*/0x0901;
					else
					forntFace=/*laya.webgl.WebGLContext.CW*/0x0900;
					}else {
					if (transform && transform._isFrontFaceInvert)
						forntFace=/*laya.webgl.WebGLContext.CW*/0x0900;
					else
					forntFace=/*laya.webgl.WebGLContext.CCW*/0x0901;
				}
				WebGLContext.setFrontFace(gl,forntFace);
				break ;
			case 2:
				WebGLContext.setCullFace(gl,true);
				if (isTarget){
					if (transform && transform._isFrontFaceInvert)
						forntFace=/*laya.webgl.WebGLContext.CW*/0x0900;
					else
					forntFace=/*laya.webgl.WebGLContext.CCW*/0x0901;
					}else {
					if (transform && transform._isFrontFaceInvert)
						forntFace=/*laya.webgl.WebGLContext.CCW*/0x0901;
					else
					forntFace=/*laya.webgl.WebGLContext.CW*/0x0900;
				}
				WebGLContext.setFrontFace(gl,forntFace);
				break ;
			}
	}

	/**
	*@inheritDoc
	*/
	__proto.onAsynLoaded=function(url,data,params){
		var jsonData=data[0];
		var textureMap=data[1];
		switch (jsonData.version){
			case "LAYAMATERIAL:01":;
				var i=0,n=0;
				var props=jsonData.props;
				for (var key in props){
				switch (key){
					case "vectors":;
						var vectors=props[key];
						for (i=0,n=vectors.length;i < n;i++){
							var vector=vectors[i];
							var vectorValue=vector.value;
						switch (vectorValue.length){
							case 2:
								this[vector.name]=new Vector2(vectorValue[0],vectorValue[1]);
								break ;
							case 3:
								this[vector.name]=new Vector3(vectorValue[0],vectorValue[1],vectorValue[2]);
								break ;
							case 4:
								this[vector.name]=new Vector4(vectorValue[0],vectorValue[1],vectorValue[2],vectorValue[3]);
								break ;
							default :
								throw new Error("BaseMaterial:unkonwn color length.");
							}
					}
					break ;
					case "textures":;
					var textures=props[key];
					for (i=0,n=textures.length;i < n;i++){
						var texture=textures[i];
						var path=texture.path;
						(path)&& (this[texture.name]=Loader.getRes(textureMap[path]));
					}
					break ;
					case "defines":;
					var defineNames=props[key];
					for (i=0,n=defineNames.length;i < n;i++){
						var define=this._shaderCompile.getMaterialDefineByName(defineNames[i]);
						this._addShaderDefine(define);
					}
					break ;
					case "cull":
					case "blend":
					case "srcBlend":
					case "dstBlend":
					case "depthWrite":
					this[key]=props[key];
					break ;
					case "renderQueue":;
					var queue=props[key];
					switch (queue){
						case 1:
							this.renderQueue=2000;
							break ;
						case 2:
							this.renderQueue=3000;
							break ;
						default :
						}
					break ;
					default :
					this[key]=props[key];
				}
			}
			break ;
			case "LAYAMATERIAL:02":
			props=jsonData.props;
			for (key in props){
				switch (key){
					case "vectors":
						vectors=props[key];
						for (i=0,n=vectors.length;i < n;i++){
							vector=vectors[i];
							vectorValue=vector.value;
						switch (vectorValue.length){
							case 2:
								this[vector.name]=new Vector2(vectorValue[0],vectorValue[1]);
								break ;
							case 3:
								this[vector.name]=new Vector3(vectorValue[0],vectorValue[1],vectorValue[2]);
								break ;
							case 4:
								this[vector.name]=new Vector4(vectorValue[0],vectorValue[1],vectorValue[2],vectorValue[3]);
								break ;
							default :
								throw new Error("BaseMaterial:unkonwn color length.");
							}
					}
					break ;
					case "textures":
					textures=props[key];
					for (i=0,n=textures.length;i < n;i++){
						texture=textures[i];
						path=texture.path;
						(path)&& (this[texture.name]=Loader.getRes(textureMap[path]));
					}
					break ;
					case "defines":
					defineNames=props[key];
					for (i=0,n=defineNames.length;i < n;i++){
						define=this._shaderCompile.getMaterialDefineByName(defineNames[i]);
						this._addShaderDefine(define);
					}
					break ;
					default :
					this[key]=props[key];
				}
			}
			break ;
			default :
			throw new Error("BaseMaterial:unkonwn version.");
		}
		this._endLoaded();
	}

	/**
	*@inheritDoc
	*/
	__proto._addReference=function(){
		_super.prototype._addReference.call(this);
		var valueCount=this._values.length;
		for (var i=0,n=valueCount;i < n;i++){
			var value=this._values[i];
			if (value && (value instanceof laya.d3.resource.BaseTexture ))
				(value)._addReference();
		}
	}

	/**
	*@inheritDoc
	*/
	__proto._removeReference=function(){
		_super.prototype._removeReference.call(this);
		var valueCount=this._values.length;
		for (var i=0,n=valueCount;i < n;i++){
			var value=this._values[i];
			if (value && (value instanceof laya.d3.resource.BaseTexture ))
				(value)._removeReference();
		}
	}

	/**
	*@inheritDoc
	*/
	__proto.disposeResource=function(){
		this.blendConstColor=null;
		this._shader=null;
		this._shaderValues=null;
		var valueCount=this._values.length;
		for (var i=0,n=valueCount;i < n;i++){
			var value=this._values[i];
			if (value && (value instanceof laya.d3.resource.BaseTexture ))
				(value)._removeReference();
		}
		this._values=null;
	}

	/**
	*设置使用Shader名字。
	*@param name 名称。
	*/
	__proto.setShaderName=function(name){
		var nameID=Shader3D.nameKey.getID(name);
		if (nameID===-1)
			throw new Error("BaseMaterial: unknown shader name.");
		this._shaderCompile=ShaderCompile3D._preCompileShader[nameID];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destBaseMaterial=destObject;
		destBaseMaterial.name=this.name;
		destBaseMaterial.cull=this.cull;
		destBaseMaterial.blend=this.blend;
		destBaseMaterial.srcBlend=this.srcBlend;
		destBaseMaterial.dstBlend=this.dstBlend;
		destBaseMaterial.srcBlendRGB=this.srcBlendRGB;
		destBaseMaterial.dstBlendRGB=this.dstBlendRGB;
		destBaseMaterial.srcBlendAlpha=this.srcBlendAlpha;
		destBaseMaterial.dstBlendAlpha=this.dstBlendAlpha;
		this.blendConstColor.cloneTo(destBaseMaterial.blendConstColor);
		destBaseMaterial.blendEquation=this.blendEquation;
		destBaseMaterial.blendEquationRGB=this.blendEquationRGB;
		destBaseMaterial.blendEquationAlpha=this.blendEquationAlpha;
		destBaseMaterial.depthTest=this.depthTest;
		destBaseMaterial.depthWrite=this.depthWrite;
		destBaseMaterial.renderQueue=this.renderQueue;
		destBaseMaterial._shader=this._shader;
		destBaseMaterial._disablePublicShaderDefine=this._disablePublicShaderDefine;
		destBaseMaterial._shaderDefineValue=this._shaderDefineValue;
		var i=0,n=0;
		var destShaderValues=destBaseMaterial._shaderValues;
		destBaseMaterial._shaderValues.data.length=this._shaderValues.data.length;
		var valueCount=this._values.length;
		var destValues=destBaseMaterial._values;
		destValues.length=valueCount;
		for (i=0,n=valueCount;i < n;i++){
			var value=this._values[i];
			if (value){
				if ((typeof value=='number')){
					destValues[i]=value;
					destShaderValues.data[i]=value;
					}else if (((typeof value=='number')&& Math.floor(value)==value)){
					destValues[i]=value;
					destShaderValues.data[i]=value;
					}else if ((typeof value=='boolean')){
					destValues[i]=value;
					destShaderValues.data[i]=value;
					}else if ((value instanceof laya.d3.math.Vector2 )){
					var v2=(destValues[i])|| (destValues[i]=new Vector2());
					(value).cloneTo(v2);
					destShaderValues.data[i]=v2.elements;
					}else if ((value instanceof laya.d3.math.Vector3 )){
					var v3=(destValues[i])|| (destValues[i]=new Vector3());
					(value).cloneTo(v3);
					destShaderValues.data[i]=v3.elements;
					}else if ((value instanceof laya.d3.math.Vector4 )){
					var v4=(destValues[i])|| (destValues[i]=new Vector4());
					(value).cloneTo(v4);
					destShaderValues.data[i]=v4.elements;
					}else if ((value instanceof laya.d3.math.Matrix4x4 )){
					var mat=(destValues[i])|| (destValues[i]=new Matrix4x4());
					(value).cloneTo(mat);
					destShaderValues.data[i]=mat.elements;
					}else if ((value instanceof laya.d3.resource.BaseTexture )){
					destValues[i]=value;
					destShaderValues.data[i]=value;
				}
			}
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destBaseMaterial=/*__JS__ */new this.constructor();
		this.cloneTo(destBaseMaterial);
		return destBaseMaterial;
	}

	/**
	*设置透明测试模式裁剪值。
	*@param value 透明测试模式裁剪值。
	*/
	/**
	*获取透明测试模式裁剪值。
	*@return 透明测试模式裁剪值。
	*/
	__getset(0,__proto,'alphaTestValue',function(){
		return this._getNumber(0);
		},function(value){
		this._setNumber(0,value);
	});

	/**
	*设置是否透明裁剪。
	*@param value 是否透明裁剪。
	*/
	/**
	*获取是否透明裁剪。
	*@return 是否透明裁剪。
	*/
	__getset(0,__proto,'alphaTest',function(){
		return this._alphaTest;
		},function(value){
		this._alphaTest=value;
		if (value)
			this._addShaderDefine(laya.d3.core.material.BaseMaterial.SHADERDEFINE_ALPHATEST);
		else
		this._removeShaderDefine(laya.d3.core.material.BaseMaterial.SHADERDEFINE_ALPHATEST);
	});

	BaseMaterial.__init__=function(){
		BaseMaterial.SHADERDEFINE_ALPHATEST=BaseMaterial.shaderDefines.registerDefine("ALPHATEST");
	}

	BaseMaterial.RENDERQUEUE_OPAQUE=2000;
	BaseMaterial.RENDERQUEUE_ALPHATEST=2450;
	BaseMaterial.RENDERQUEUE_TRANSPARENT=3000;
	BaseMaterial.CULL_NONE=0;
	BaseMaterial.CULL_FRONT=1;
	BaseMaterial.CULL_BACK=2;
	BaseMaterial.BLEND_DISABLE=0;
	BaseMaterial.BLEND_ENABLE_ALL=1;
	BaseMaterial.BLEND_ENABLE_SEPERATE=2;
	BaseMaterial.BLENDPARAM_ZERO=0;
	BaseMaterial.BLENDPARAM_ONE=1;
	BaseMaterial.BLENDPARAM_SRC_COLOR=0x0300;
	BaseMaterial.BLENDPARAM_ONE_MINUS_SRC_COLOR=0x0301;
	BaseMaterial.BLENDPARAM_DST_COLOR=0x0306;
	BaseMaterial.BLENDPARAM_ONE_MINUS_DST_COLOR=0x0307;
	BaseMaterial.BLENDPARAM_SRC_ALPHA=0x0302;
	BaseMaterial.BLENDPARAM_ONE_MINUS_SRC_ALPHA=0x0303;
	BaseMaterial.BLENDPARAM_DST_ALPHA=0x0304;
	BaseMaterial.BLENDPARAM_ONE_MINUS_DST_ALPHA=0x0305;
	BaseMaterial.BLENDPARAM_SRC_ALPHA_SATURATE=0x0308;
	BaseMaterial.BLENDEQUATION_ADD=0;
	BaseMaterial.BLENDEQUATION_SUBTRACT=1;
	BaseMaterial.BLENDEQUATION_REVERSE_SUBTRACT=2;
	BaseMaterial.DEPTHTEST_OFF=0;
	BaseMaterial.DEPTHTEST_NEVER=0x0200;
	BaseMaterial.DEPTHTEST_LESS=0x0201;
	BaseMaterial.DEPTHTEST_EQUAL=0x0202;
	BaseMaterial.DEPTHTEST_LEQUAL=0x0203;
	BaseMaterial.DEPTHTEST_GREATER=0x0204;
	BaseMaterial.DEPTHTEST_NOTEQUAL=0x0205;
	BaseMaterial.DEPTHTEST_GEQUAL=0x0206;
	BaseMaterial.DEPTHTEST_ALWAYS=0x0207;
	BaseMaterial.SHADERDEFINE_ALPHATEST=0x1;
	BaseMaterial.ALPHATESTVALUE=0;
	__static(BaseMaterial,
	['shaderDefines',function(){return this.shaderDefines=new ShaderDefines$1();}
	]);
	return BaseMaterial;
})(Resource)


/**
*<code>BaseTexture</code> 纹理的父类，抽象类，不允许实例。
*/
//class laya.d3.resource.BaseTexture extends laya.resource.Resource
var BaseTexture=(function(_super){
	function BaseTexture(){
		/**@private */
		this._type=0;
		/**@private */
		this._width=0;
		/**@private */
		this._height=0;
		/**@private */
		this._size=null;
		/**@private */
		this._repeat=false;
		/**@private */
		this._mipmap=false;
		/**@private */
		this._minFifter=0;
		/**@private */
		this._magFifter=0;
		/**@private */
		this._format=0;
		/**@private */
		this._source=null;
		/**@private */
		this._conchTexture=null;
		/**@private */
		this._wrapModeU=0;
		/**@private */
		this._wrapModeV=0;
		BaseTexture.__super.call(this);
		this._repeat=true;
		this.mipmap=true;
		this.minFifter=-1;
		this.magFifter=-1;
	}

	__class(BaseTexture,'laya.d3.resource.BaseTexture',_super);
	var __proto=BaseTexture.prototype;
	/**
	*获取宽度。
	*/
	__getset(0,__proto,'width',function(){
		return this._width;
	});

	/**
	*是否使用重复模式纹理寻址
	*/
	/**
	*是否使用重复模式纹理寻址
	*/
	__getset(0,__proto,'repeat',function(){
		return this._repeat;
		},function(value){
		if (this._repeat!==value){
			this._repeat=value;
			if (this._source){
				var gl=WebGL.mainContext;
				WebGLContext.bindTexture(gl,this._type,this._source);
				var isPot=Arith.isPOT(this._width,this._height);
				if (isPot && this._repeat){
					gl.texParameteri(this._type,/*laya.webgl.WebGLContext.TEXTURE_WRAP_S*/0x2802,/*laya.webgl.WebGLContext.REPEAT*/0x2901);
					gl.texParameteri(this._type,/*laya.webgl.WebGLContext.TEXTURE_WRAP_T*/0x2803,/*laya.webgl.WebGLContext.REPEAT*/0x2901);
					}else {
					gl.texParameteri(this._type,/*laya.webgl.WebGLContext.TEXTURE_WRAP_S*/0x2802,/*laya.webgl.WebGLContext.CLAMP_TO_EDGE*/0x812F);
					gl.texParameteri(this._type,/*laya.webgl.WebGLContext.TEXTURE_WRAP_T*/0x2803,/*laya.webgl.WebGLContext.CLAMP_TO_EDGE*/0x812F);
				}
			}
		}
	});

	/**
	*获取高度。
	*/
	__getset(0,__proto,'height',function(){
		return this._height;
	});

	/**
	*放大过滤器
	*/
	/**
	*放大过滤器
	*/
	__getset(0,__proto,'magFifter',function(){
		return this._magFifter;
		},function(value){
		this._magFifter=value;
		if (value !=this._magFifter){
			this._conchTexture && this._conchTexture.setMaxFifter(value);
		}
	});

	/**
	*获取纹理纵向循环模式。
	*/
	__getset(0,__proto,'wrapModeV',function(){
		return this._wrapModeV;
	});

	/**
	*获取尺寸。
	*/
	__getset(0,__proto,'size',function(){
		return this._size;
	});

	/**
	*获取纹理横向循环模式。
	*/
	__getset(0,__proto,'wrapModeU',function(){
		return this._wrapModeU;
	});

	/**
	*是否使用mipLevel
	*/
	/**
	*是否使用mipLevel
	*/
	__getset(0,__proto,'mipmap',function(){
		return this._mipmap;
		},function(value){
		this._mipmap=value;
		if (this._mipmap !=value){
			this._conchTexture && this._conchTexture.setMipMap(value);
		}
	});

	/**
	*缩小过滤器
	*/
	/**
	*缩小过滤器
	*/
	__getset(0,__proto,'minFifter',function(){
		return this._minFifter;
		},function(value){
		this._minFifter=value;
		if (this._minFifter !=value){
			this._conchTexture && this._conchTexture.setMinFifter(value);
		}
	});

	/**
	*纹理格式
	*/
	__getset(0,__proto,'format',function(){
		return this._format;
	});

	/**
	*获取纹理资源。
	*/
	__getset(0,__proto,'source',function(){
		this.activeResource();
		return this._source;
	});

	/**
	*获取纹理资源。
	*/
	__getset(0,__proto,'defaulteTexture',function(){
		return SolidColorTexture2D.grayTexture;
	});

	BaseTexture.WARPMODE_REPEAT=0;
	BaseTexture.WARPMODE_CLAMP=1;
	return BaseTexture;
})(Resource)


/**
*<code>BaseMesh</code> 类用于创建网格,抽象类,不允许实例。
*/
//class laya.d3.resource.models.BaseMesh extends laya.resource.Resource
var BaseMesh=(function(_super){
	function BaseMesh(){
		/**@private */
		this._subMeshCount=0;
		/**@private */
		this._boundingBox=null;
		/**@private */
		this._boundingSphere=null;
		/**@private */
		this._boundingBoxCorners=null;
		/**@private 只读,不允许修改。*/
		this._positions=null;
		BaseMesh.__super.call(this);
		this._boundingBoxCorners=__newvec(8,null);
	}

	__class(BaseMesh,'laya.d3.resource.models.BaseMesh',_super);
	var __proto=BaseMesh.prototype;
	/**
	*获取网格顶点,请重载此方法。
	*@return 网格顶点。
	*/
	__proto._getPositions=function(){
		throw new Error("未Override,请重载该属性！");
	}

	/**
	*@private
	*/
	__proto._generateBoundingObject=function(){
		this._boundingSphere=new BoundSphere(new Vector3(),0);
		BoundSphere.createfromPoints(this._positions,this._boundingSphere);
		this._boundingBox=new BoundBox(new Vector3(),new Vector3());
		BoundBox.createfromPoints(this._positions,this._boundingBox);
		this._boundingBox.getCorners(this._boundingBoxCorners);
	}

	/**
	*获取渲染单元数量,请重载此方法。
	*@return 渲染单元数量。
	*/
	__proto.getRenderElementsCount=function(){
		throw new Error("未Override,请重载该属性！");
	}

	/**
	*获取渲染单元,请重载此方法。
	*@param index 索引。
	*@return 渲染单元。
	*/
	__proto.getRenderElement=function(index){
		throw new Error("未Override,请重载该属性！");
	}

	/**
	*获取SubMesh的个数。
	*@return SubMesh的个数。
	*/
	__getset(0,__proto,'subMeshCount',function(){
		return this._subMeshCount;
	});

	/**
	*获取AABB包围盒,禁止修改其数据。
	*@return AABB包围盒。
	*/
	__getset(0,__proto,'boundingBox',function(){
		return this._boundingBox;
	});

	/**
	*获取包围球顶点,禁止修改其数据。
	*@return 包围球。
	*/
	__getset(0,__proto,'boundingBoxCorners',function(){
		return this._boundingBoxCorners;
	});

	/**
	*获取包围球,禁止修改其数据。
	*@return 包围球。
	*/
	__getset(0,__proto,'boundingSphere',function(){
		return this._boundingSphere;
	});

	return BaseMesh;
})(Resource)


/**
*<code>TerrainHeightData</code> 类用于描述地形高度信息。
*/
//class laya.d3.terrain.TerrainHeightData extends laya.resource.Resource
var TerrainHeightData=(function(_super){
	function TerrainHeightData(){
		this._terrainHeightData=null;
		this._width=0;
		this._height=0;
		this._bitType=0;
		this._value=NaN;
		TerrainHeightData.__super.call(this);
	}

	__class(TerrainHeightData,'laya.d3.terrain.TerrainHeightData',_super);
	var __proto=TerrainHeightData.prototype;
	/**
	*异步回调
	*/
	__proto.onAsynLoaded=function(url,data,params){
		this._width=params[0];
		this._height=params[1];
		this._bitType=params[2];
		this._value=params[3];
		var buffer;
		var ratio=NaN;
		if (this._bitType==8){
			buffer=new Uint8Array(data);
			ratio=1.0 / 255.0;
		}
		else if (this._bitType==16){
			buffer=new Int16Array(data);
			ratio=1.0 / 32766.0;
		}
		this._terrainHeightData=new Float32Array(this._height *this._width);
		for (var i=0,n=this._height *this._width;i < n;i++){
			this._terrainHeightData[i]=(buffer[i] *ratio *this._value)/2;
		}
		this._endLoaded();
	}

	TerrainHeightData.load=function(url,widht,height,bitType,value){
		return Laya.loader.create(url,null,null,TerrainHeightData,[widht,height,bitType,value],1,false);
	}

	return TerrainHeightData;
})(Resource)


/**
*<code>TerrainRes</code> 类用于描述地形信息。
*/
//class laya.d3.terrain.TerrainRes extends laya.resource.Resource
var TerrainRes=(function(_super){
	function TerrainRes(){
		this._version=NaN;
		this._cameraCoordinateInverse=false;
		this._gridSize=NaN;
		this._chunkNumX=0;
		this._chunkNumZ=0;
		this._heightDataX=0;
		this._heightDataZ=0;
		this._heightDataBitType=0;
		this._heightDataValue=NaN;
		this._heightDataUrl=null;
		this._detailTextureInfos=null;
		this._chunkInfos=null;
		this._heightData=null;
		this._materialInfo=null;
		this._alphaMaps=null;
		this._normalMaps=null;
		TerrainRes.__super.call(this);
	}

	__class(TerrainRes,'laya.d3.terrain.TerrainRes',_super);
	var __proto=TerrainRes.prototype;
	__proto.parseData=function(data){
		var json=data[0];
		var resouMap=data[1];
		this._version=json.version;
		if (this._version==1.0){
			this._cameraCoordinateInverse=json.cameraCoordinateInverse;
			this._gridSize=json.gridSize;
			this._chunkNumX=json.chunkNumX;
			this._chunkNumZ=json.chunkNumZ;
			var heightData=json.heightData;
			this._heightDataX=heightData.numX;
			this._heightDataZ=heightData.numZ;
			this._heightDataBitType=heightData.bitType;
			this._heightDataValue=heightData.value;
			this._heightDataUrl=resouMap[heightData.url];
			this._materialInfo=new MaterialInfo();
			if (json.material){
				var ambient=json.material.ambient;
				var diffuse=json.material.diffuse;
				var specular=json.material.specular;
				this._materialInfo.ambientColor=new Vector3(ambient[0],ambient[1],ambient[2]);
				this._materialInfo.diffuseColor=new Vector3(diffuse[0],diffuse[1],diffuse[2]);
				this._materialInfo.specularColor=new Vector4(specular[0],specular[1],specular[2],specular[3]);
			};
			var detailTextures=json.detailTexture;
			this._detailTextureInfos=__newvec(detailTextures.length);
			for (var i=0;i < detailTextures.length;i++){
				var detail=detailTextures[i];
				var info=new DetailTextureInfo();
				info.diffuseTexture=resouMap[detail.diffuse];
				info.normalTexture=detail.normal ? resouMap[detail.normal] :null;
				if (detail.scale){
					info.scale=new Vector2(detail.scale[0],detail.scale[1]);
					}else {
					info.scale=new Vector2(1,1);
				}
				if (detail.offset){
					info.offset=new Vector2(detail.offset[0],detail.offset[1]);
					}else {
					info.offset=new Vector2(0,0);
				}
				this._detailTextureInfos[i]=info;
			};
			var alphaMaps=json.alphaMap;
			this._alphaMaps=__newvec(alphaMaps.length);
			for (i=0;i < this._alphaMaps.length;i++){
				this._alphaMaps[i]=json.alphaMap[i];
			};
			var normalMaps=json.normalMap;
			this._normalMaps=__newvec(normalMaps.length);
			for (i=0;i < this._normalMaps.length;i++){
				this._normalMaps[i]=json.normalMap[i];
			};
			var jchunks=json.chunkInfo;
			if (this._chunkNumX *this._chunkNumZ !=jchunks.length){
				alert("terrain data error");
				return false;
			}
			this._chunkInfos=__newvec(jchunks.length);
			for (i=0;i < jchunks.length;i++){
				var jchunk=jchunks[i];
				var chunkinfo=new ChunkInfo();
				var nAlphaMapNum=jchunk.alphaMap.length;
				var nDetailIDNum=jchunk.detailID.length;
				if (nAlphaMapNum !=nDetailIDNum){
					alert("terrain chunk data error");
					return false;
				}
				chunkinfo.alphaMap=__newvec(nAlphaMapNum);
				chunkinfo.detailID=__newvec(nDetailIDNum);
				chunkinfo.normalMap=resouMap[this._normalMaps[jchunk.normalMap]];
				for (var j=0;j < nAlphaMapNum;j++){
					chunkinfo.alphaMap[j]=resouMap[this._alphaMaps[jchunk.alphaMap[j]]];
					var jid=jchunk.detailID[j];
					var nIDNum=jid.length;
					chunkinfo.detailID[j]=new Uint8Array(nIDNum);
					for (var k=0;k < nIDNum;k++){
						chunkinfo.detailID[j][k]=jid[k];
					}
				}
				this._chunkInfos[i]=chunkinfo;
			}
			this._heightData=Loader.getRes(this._heightDataUrl);
			this.onLoadTerrainComplete(this._heightData);
		}
		return true;
	}

	__proto.onLoadTerrainComplete=function(heightData){
		this._endLoaded();
	}

	/**
	*异步回调
	*/
	__proto.onAsynLoaded=function(url,data,params){
		this.parseData(data);
	}

	TerrainRes.load=function(url){
		return Laya.loader.create(url,null,null,TerrainRes,null,1,false);
	}

	return TerrainRes;
})(Resource)


/**
*<code>KeyframeAnimation</code> 类用于帧动画组件的父类。
*/
//class laya.d3.component.animation.KeyframeAnimations extends laya.d3.component.Component3D
var KeyframeAnimations=(function(_super){
	function KeyframeAnimations(){
		/**动画播放器。*/
		this._player=null;
		/**@private */
		this._templet=null;
		KeyframeAnimations.__super.call(this);
		this._player=new AnimationPlayer();
	}

	__class(KeyframeAnimations,'laya.d3.component.animation.KeyframeAnimations',_super);
	var __proto=KeyframeAnimations.prototype;
	/**
	*@private
	*/
	__proto._updateAnimtionPlayer=function(){
		this._player._update(Laya.timer.delta);
	}

	/**
	*@private
	*/
	__proto._addUpdatePlayerToTimer=function(){
		Laya.timer.frameLoop(1,this,this._updateAnimtionPlayer);
	}

	/**
	*@private
	*/
	__proto._removeUpdatePlayerToTimer=function(){
		Laya.timer.clear(this,this._updateAnimtionPlayer);
	}

	/**
	*@private
	*/
	__proto._onOwnerActiveHierarchyChanged=function(active){
		if ((this._owner).displayedInStage){
			if (active)
				this._addUpdatePlayerToTimer();
			else
			this._removeUpdatePlayerToTimer();
		}
	}

	/**
	*@private
	*载入组件时执行
	*/
	__proto._load=function(owner){
		((owner).activeInHierarchy)&& (this._addUpdatePlayerToTimer());
		owner.on(/*laya.events.Event.ACTIVE_IN_HIERARCHY_CHANGED*/"activeinhierarchychanged",this,this._onOwnerActiveHierarchyChanged);
	}

	/**
	*@private
	*卸载组件时执行
	*/
	__proto._unload=function(owner){
		_super.prototype._unload.call(this,owner);
		((owner).activeInHierarchy)&& (this._removeUpdatePlayerToTimer());
		owner.off(/*laya.events.Event.ACTIVE_IN_HIERARCHY_CHANGED*/"activeinhierarchychanged",this,this._onOwnerActiveHierarchyChanged);
		this._player._destroy();
		this._player=null;
		this._templet=null;
	}

	/**
	*设置url地址。
	*@param value 地址。
	*/
	__getset(0,__proto,'url',null,function(value){
		console.log("Warning: discard property,please use templet property instead.");
		var templet=Laya.loader.create(value,null,null,AnimationTemplet);
		if (this._templet!==templet){
			if (this._player.state!==/*laya.ani.AnimationState.stopped*/0)
				this._player.stop(true);
			this._templet=templet;
			this._player.templet=templet;
			this.event(/*laya.events.Event.ANIMATION_CHANGED*/"animationchanged",this);
		}
	});

	/**
	*获取动画播放器。
	*@return 动画播放器。
	*/
	__getset(0,__proto,'player',function(){
		return this._player;
	});

	/**
	*设置动画模板。
	*@param value 设置动画模板。
	*/
	/**
	*获取动画模板。
	*@return value 动画模板。
	*/
	__getset(0,__proto,'templet',function(){
		return this._templet;
		},function(value){
		if (this._templet!==value){
			if (this._player.state!==/*laya.ani.AnimationState.stopped*/0)
				this._player.stop(true);
			this._templet=value;
			this._player.templet=value;
			this.event(/*laya.events.Event.ANIMATION_CHANGED*/"animationchanged",this);
		}
	});

	/**
	*获取播放器帧数。
	*@return 播放器帧数。
	*/
	__getset(0,__proto,'currentFrameIndex',function(){
		return this._player.currentKeyframeIndex;
	});

	/**
	*获取播放器的动画索引。
	*@return 动画索引。
	*/
	__getset(0,__proto,'currentAnimationClipIndex',function(){
		return this._player.currentAnimationClipIndex;
	});

	/**
	*获取播放器当前动画的节点数量。
	*@return 节点数量。
	*/
	__getset(0,__proto,'nodeCount',function(){
		return this._templet.getNodeCount(this._player.currentAnimationClipIndex);
	});

	return KeyframeAnimations;
})(Component3D)


/**
*<code>Animations</code> 类用于创建动画组件。
*/
//class laya.d3.component.Animator extends laya.d3.component.Component3D
var Animator=(function(_super){
	function Animator(){
		/**@private */
		//this._updateTransformPropertyLoopCount=0;
		/**@private */
		//this._cacheFrameRateInterval=NaN;
		/**@private */
		//this._cacheFrameRate=0;
		/**@private */
		//this._cachePlayRate=NaN;
		/**@private */
		//this._currentPlayClip=null;
		/**@private */
		//this._currentPlayClipIndex=0;
		/**@private */
		//this._stoped=false;
		/**@private */
		//this._currentTime=NaN;
		/**@private */
		//this._currentFrameTime=NaN;
		/**@private */
		//this._currentFrameIndex=0;
		/**@private */
		//this._elapsedPlaybackTime=NaN;
		/**@private */
		//this._startUpdateLoopCount=NaN;
		/**@private */
		//this._clipNames=null;
		/**@private */
		//this._clips=null;
		/**@private */
		//this._playStartFrames=null;
		/**@private */
		//this._playEndFrames=null;
		/**@private */
		//this._playEventIndex=0;
		/**@private */
		//this._defaultClipIndex=0;
		/**@private */
		//this._avatar=null;
		/**@private */
		//this._cacheNodesDefaultlValues=null;
		/**@private 无Avatar时缓存场景树中的精灵节点。*/
		//this._cacheNodesSpriteOwners=null;
		/**@private 有Avatar时缓存Avatar树中的AnimationNode节点。*/
		//this._cacheNodesAvatarOwners=null;
		/**@private */
		//this._lastPlayAnimationClip=null;
		/**@private */
		//this._lastPlayAnimationClipIndex=0;
		/**@private */
		//this._publicClipsDatas=null;
		/**@private */
		//this._publicAvatarNodeDatas=null;
		/**@private */
		//this._curAvatarNodeDatas=null;
		/**@private */
		//this._cacheNodesToSpriteMap=null;
		/**@private */
		//this._cacheSpriteToNodesMap=null;
		/**@private */
		//this._cacheFullFrames=null;
		/**@private */
		//this._linkSpritesData=null;
		/**@private */
		//this._avatarNodeMap=null;
		/**@private */
		//this._avatarNodes=null;
		/**@private */
		//this._canCache=false;
		/**@private */
		//this._lastFrameIndex=0;
		/**是否为缓存模式*/
		//this.isCache=false;
		/**播放速率*/
		//this.playbackRate=NaN;
		/**激活时是否自动播放*/
		//this.playOnWake=false;
		Animator.__super.call(this);
		this._clipNames=[];
		this._clips=[];
		this._playStartFrames=[];
		this._playEndFrames=[];
		this._cacheNodesSpriteOwners=[];
		this._cacheNodesAvatarOwners=[];
		this._cacheNodesDefaultlValues=[];
		this._cacheNodesToSpriteMap=[];
		this._cacheSpriteToNodesMap=[];
		this._cacheFullFrames=[];
		this._publicClipsDatas=[];
		this._playEventIndex=-1;
		this._updateTransformPropertyLoopCount=-1;
		this._lastFrameIndex=-1;
		this._defaultClipIndex=-1;
		this._cachePlayRate=1.0;
		this._currentPlayClip=null;
		this._currentFrameIndex=-1;
		this._currentTime=0.0;
		this._elapsedPlaybackTime=0;
		this._startUpdateLoopCount=-1;
		this.isCache=true;
		this.cacheFrameRate=60;
		this.playbackRate=1.0;
		this.playOnWake=true;
	}

	__class(Animator,'laya.d3.component.Animator',_super);
	var __proto=Animator.prototype;
	Laya.imps(__proto,{"laya.resource.IDestroy":true})
	/**
	*@private
	*/
	__proto._getAvatarOwnersByClip=function(clipIndex){
		var frameNodes=this._clips[clipIndex]._nodes;
		var frameNodesCount=frameNodes.length;
		var owners=this._cacheNodesAvatarOwners[clipIndex];
		owners.length=frameNodesCount;
		var defaultValues=this._cacheNodesDefaultlValues[clipIndex];
		defaultValues.length=frameNodesCount;
		for (var i=0;i < frameNodesCount;i++){
			var nodeOwner=this._avatarNodes[0];
			var node=frameNodes[i];
			var path=node.path;
			for (var j=0,m=path.length;j < m;j++){
				var p=path[j];
				if (p===""){
					break ;
					}else {
					nodeOwner=nodeOwner.getChildByName(p);
					if (!nodeOwner)
						break ;
				}
			}
			if (!nodeOwner)
				continue ;
			owners[i]=nodeOwner;
			var datas=AnimationNode._propertyGetFuncs[node.propertyNameID](nodeOwner);
			if (datas){
				var cacheDatas=new Float32Array(node.keyFrameWidth);
				defaultValues[i]=cacheDatas;
				for (j=0,m=datas.length;j < m;j++)
				cacheDatas[j]=datas[j];
			}
		}
	}

	/**
	*@private
	*/
	__proto._handleSpriteOwnersByClip=function(clipIndex){
		var frameNodes=this._clips[clipIndex]._nodes;
		var frameNodesCount=frameNodes.length;
		var owners=this._cacheNodesSpriteOwners[clipIndex];
		owners.length=frameNodesCount;
		var defaultValues=this._cacheNodesDefaultlValues[clipIndex];
		defaultValues.length=frameNodesCount;
		for (var i=0;i < frameNodesCount;i++){
			var nodeOwner=this._owner;
			var node=frameNodes[i];
			var path=node.path;
			var j=0,m=0;
			for (j=0,m=path.length;j < m;j++){
				var p=path[j];
				if (p===""){
					break ;
					}else {
					nodeOwner=nodeOwner.getChildByName(p);
					if (!nodeOwner)
						break ;
				}
			}
			if (nodeOwner){
				owners[i]=nodeOwner;
				var datas=AnimationNode._propertyGetFuncs[node.propertyNameID](null,nodeOwner);
				if (datas){
					var cacheDatas=new Float32Array(node.keyFrameWidth);
					defaultValues[i]=cacheDatas;
					for (j=0,m=datas.length;j < m;j++)
					cacheDatas[j]=datas[j];
				}
			}
		}
	}

	/**
	*@private
	*/
	__proto._offClipAndAvatarRelateEvent=function(avatar,clip){
		if (avatar.loaded){
			if (!clip.loaded)
				clip.off(/*laya.events.Event.LOADED*/"loaded",this,this._getAvatarOwnersByClip);
			}else {
			avatar.off(/*laya.events.Event.LOADED*/"loaded",this,this._getAvatarOwnersAndInitDatasAsync);
		}
	}

	/**
	*@private
	*/
	__proto._getAvatarOwnersByClipAsync=function(clipIndex,clip){
		if (clip.loaded)
			this._getAvatarOwnersByClip(clipIndex);
		else
		clip.once(/*laya.events.Event.LOADED*/"loaded",this,this._getAvatarOwnersByClip,[clipIndex]);
	}

	/**
	*@private
	*/
	__proto._offGetSpriteOwnersByClipAsyncEvent=function(clip){
		if (!clip.loaded)
			clip.off(/*laya.events.Event.LOADED*/"loaded",this,this._getSpriteOwnersByClipAsync);
	}

	/**
	*@private
	*/
	__proto._getSpriteOwnersByClipAsync=function(clipIndex,clip){
		if (clip.loaded)
			this._handleSpriteOwnersByClip(clipIndex);
		else
		clip.once(/*laya.events.Event.LOADED*/"loaded",this,this._handleSpriteOwnersByClip,[clipIndex]);
	}

	/**
	*@private
	*/
	__proto._getAvatarOwnersAndInitDatasAsync=function(){
		for (var i=0,n=this._clips.length;i < n;i++)
		this._getAvatarOwnersByClipAsync(i,this._clips[i]);
		this._avatar._cloneDatasToAnimator(this);
		for (i=0,n=this._avatarNodes.length;i < n;i++)
		this._checkAnimationNode(this._avatarNodes[i],this._owner);
	}

	/**
	*@private
	*/
	__proto._offGetClipCacheFullKeyframeIndicesEvent=function(clip){
		(clip.loaded)|| (clip.off(/*laya.events.Event.LOADED*/"loaded",this,this._computeCacheFullKeyframeIndices));
	}

	/**
	*@private
	*/
	__proto._computeCacheFullKeyframeIndices=function(clipIndex){
		var clip=this._clips[clipIndex];
		var cacheInterval=this._cacheFrameRateInterval *this._cachePlayRate;
		var clipCacheFullFrames=clip._getFullKeyframeIndicesWithCache(cacheInterval);
		if (clipCacheFullFrames){
			this._cacheFullFrames[clipIndex]=clipCacheFullFrames;
			return;
			}else {
			clipCacheFullFrames=this._cacheFullFrames[clipIndex]=[];
			var nodes=clip._nodes;
			var nodeCount=nodes.length;
			clipCacheFullFrames.length=nodeCount;
			var frameCount=Math.ceil(clip._duration / cacheInterval-0.00001)+1;
			for (var i=0;i < nodeCount;i++){
				var node=nodes[i];
				var nodeFullFrames=new Int32Array(frameCount);
				(nodeFullFrames).fill(-1);
				var keyFrames=node.keyFrames;
				for (var j=0,n=keyFrames.length;j < n;j++){
					var keyFrame=keyFrames[j];
					var startTime=keyFrame.startTime;
					var endTime=startTime+keyFrame.duration;
					while (startTime <=endTime){
						var frameIndex=Math.ceil(startTime / cacheInterval-0.00001);
						nodeFullFrames[frameIndex]=j;
						startTime+=cacheInterval;
					}
				}
				clipCacheFullFrames[i]=nodeFullFrames;
			}
			clip._cacheFullKeyframeIndices(cacheInterval,clipCacheFullFrames);
		}
	}

	/**
	*@private
	*/
	__proto._updateAnimtionPlayer=function(){
		this._updatePlayer(Laya.timer.delta / 1000.0);
	}

	/**
	*@private
	*/
	__proto._onOwnerActiveHierarchyChanged=function(){
		var owner=this._owner;
		if (owner.activeInHierarchy){
			Laya.timer.frameLoop(1,this,this._updateAnimtionPlayer);
			(this.playOnWake && this.clip)&& (this.play());
			}else {
			(this.playState!==/*laya.ani.AnimationState.stopped*/0)&& (this._stoped=true);
			Laya.timer.clear(this,this._updateAnimtionPlayer);
		}
	}

	/**
	*@private
	*/
	__proto._eventScript=function(from,to){
		var events=this._currentPlayClip._animationEvents;
		for (var n=events.length;this._playEventIndex < n;this._playEventIndex++){
			var eve=events[this._playEventIndex];
			var eventTime=eve.time;
			if (from <=eventTime && eventTime < to){
				var scripts=this._owner._scripts;
				for (var j=0,m=scripts.length;j < m;j++){
					var script=scripts[j];
					var fun=script[eve.eventName];
					(fun)&& (fun.apply(script,eve.params));
				}
				}else {
				break ;
			}
		}
	}

	/**
	*@private
	*/
	__proto._setPlayParams=function(time,cacheFrameInterval){
		var lastTime=this._currentTime;
		this._currentTime=time;
		this._currentFrameIndex=Math.max(Math.floor(this.currentPlayTime / cacheFrameInterval-0.00001),0);
		this._currentFrameTime=this._currentFrameIndex *cacheFrameInterval;
		this._eventScript(lastTime,time);
	}

	/**
	*@private
	*/
	__proto._setPlayParamsWhenStop=function(aniClipPlayDuration,cacheFrameInterval){
		var lastTime=this._currentTime;
		this._currentTime=aniClipPlayDuration;
		this._currentFrameIndex=Math.max(Math.floor(aniClipPlayDuration / cacheFrameInterval-0.00001),0);
		this._currentFrameTime=this._currentFrameIndex *cacheFrameInterval;
		this._eventScript(lastTime,aniClipPlayDuration);
		this._currentPlayClip=null;
	}

	/**
	*@private
	*/
	__proto._revertKeyframeNodes=function(clip,clipIndex){
		var originalValues=this._cacheNodesDefaultlValues[clipIndex];
		var frameNodes=clip._nodes;
		if (this._avatar){
			var avatarOwners=this._cacheNodesAvatarOwners[clipIndex];
			for (var i=0,n=avatarOwners.length;i < n;i++){
				var avatarOwner=avatarOwners[i];
				(avatarOwner)&& (AnimationNode._propertySetFuncs[frameNodes[i].propertyNameID](avatarOwner,null,originalValues[i]));
			}
			}else {
			var spriteOwners=this._cacheNodesSpriteOwners[clipIndex];
			for (i=0,n=spriteOwners.length;i < n;i++){
				var spriteOwner=spriteOwners[i];
				(spriteOwner)&& (AnimationNode._propertySetFuncs[frameNodes[i].propertyNameID](null,spriteOwner,originalValues[i]));
			}
		}
	}

	/**
	*@private
	*/
	__proto._onAnimationStop=function(){
		var i=0,n=0;
		var frameNode,keyFrames,endKeyframeData;
		this._lastFrameIndex=-1;
		var frameNodes=this._currentPlayClip._nodes;
		if (this._avatar){
			var avatarOwners=this._cacheNodesAvatarOwners[this._currentPlayClipIndex];
			for (i=0,n=avatarOwners.length;i < n;i++){
				var nodeOwner=avatarOwners[i];
				frameNode=frameNodes[i];
				keyFrames=frameNode.keyFrames;
				endKeyframeData=keyFrames[keyFrames.length-1].data;
				(nodeOwner)&& (AnimationNode._propertySetFuncs[frameNode.propertyNameID](nodeOwner,null,endKeyframeData));
			}
			}else {
			var spriteOwners=this._cacheNodesSpriteOwners[this._currentPlayClipIndex];
			for (i=0,n=spriteOwners.length;i < n;i++){
				var spriteOwner=spriteOwners[i];
				frameNode=frameNodes[i];
				keyFrames=frameNode.keyFrames;
				endKeyframeData=keyFrames[keyFrames.length-1].data;
				(spriteOwner)&& (AnimationNode._propertySetFuncs[frameNode.propertyNameID](null,spriteOwner,endKeyframeData));
			}
		}
	}

	/**
	*@private
	*/
	__proto._setAnimationClipPropertyToAnimationNode=function(nodeOwners,propertyMap,clipDatas){
		for (var i=0,n=propertyMap.length;i < n;i++){
			var nodexIndex=propertyMap[i];
			var owner=nodeOwners[nodexIndex];
			if (owner){
				var ketframeNode=this._currentPlayClip._nodes[nodexIndex];
				var datas=clipDatas[nodexIndex];
				(datas)&& (AnimationNode._propertySetFuncs[ketframeNode.propertyNameID](owner,null,datas));
			}
		}
	}

	/**
	*@private
	*/
	__proto._setAnimationClipPropertyToSprite3D=function(nodeOwners,curClipAnimationDatas){
		for (var i=0,n=nodeOwners.length;i < n;i++){
			var owner=nodeOwners[i];
			if (owner){
				var ketframeNode=this._currentPlayClip._nodes[i];
				var datas=curClipAnimationDatas[i];
				(datas)&& (AnimationNode._propertySetFuncs[ketframeNode.propertyNameID](null,owner,datas));
			}
		}
	}

	/**
	*@private
	*/
	__proto._handleSpriteOwnersBySprite=function(clipIndex,isLink,path,sprite){
		var clip=this._clips[clipIndex];
		var nodePath=path.join("/");
		var ownersNodes=clip._nodesMap[nodePath];
		if (ownersNodes){
			var owners=this._cacheNodesSpriteOwners[clipIndex];
			var nodes=clip._nodes;
			var defaultValues=this._cacheNodesDefaultlValues[clipIndex];
			for (var i=0,n=ownersNodes.length;i < n;i++){
				var node=ownersNodes[i];
				var index=nodes.indexOf(node);
				if (isLink){
					owners[index]=sprite;
					var datas=AnimationNode._propertyGetFuncs[node.propertyNameID](null,sprite);
					if (datas){
						var cacheDatas=defaultValues[index];
						(cacheDatas)|| (defaultValues[index]=cacheDatas=new Float32Array(node.keyFrameWidth));
						for (var j=0,m=datas.length;j < m;j++)
						cacheDatas[j]=datas[j];
					}
					}else {
					owners[index]=null;
				}
			}
		}
	}

	/**
	*@private
	*/
	__proto._evaluateAvatarNodesCacheMode=function(avatarOwners,clip,publicClipDatas,avatarNodeDatas,unCacheMap){
		clip._evaluateAnimationlDatasCacheMode(avatarOwners,this._cacheFullFrames[this._currentPlayClipIndex],this,publicClipDatas,unCacheMap);
		this._setAnimationClipPropertyToAnimationNode(avatarOwners,unCacheMap,publicClipDatas);
		for (var i=0,n=this._avatarNodes.length;i < n;i++){
			var node=this._avatarNodes[i];
			var nodeTransform=node.transform;
			if (nodeTransform._worldUpdate){
				var nodeMatrix=new Float32Array(16);
				avatarNodeDatas[i]=nodeMatrix;
				nodeTransform._setWorldMatrixAndUpdate(nodeMatrix);
				}else {
				var mat=nodeTransform.getWorldMatrix();
				avatarNodeDatas[i]=mat ? mat :Animator.deafaultMatrix;
			}
		}
	}

	/**
	*@private
	*/
	__proto._evaluateAvatarNodesRealTime=function(avatarOwners,clip,publicClipDatas,avatarNodeDatas,unCacheMap){
		clip._evaluateAnimationlDatasRealTime(avatarOwners,this.currentPlayTime,publicClipDatas,unCacheMap);
		this._setAnimationClipPropertyToAnimationNode(avatarOwners,unCacheMap,publicClipDatas);
		for (var i=0,n=this._avatarNodes.length;i < n;i++){
			var transform=this._avatarNodes[i].transform;
			if (transform._worldUpdate)
				transform._setWorldMatrixNoUpdate(avatarNodeDatas[i]);
			else
			avatarNodeDatas[i]=Animator.deafaultMatrix;
		}
	}

	/**
	*@private
	*/
	__proto._updateAvatarNodesToSpriteCacheMode=function(clip,avatarNodeDatas){
		for (var i=0,n=this._cacheSpriteToNodesMap.length;i < n;i++){
			var nodeIndex=this._cacheSpriteToNodesMap[i];
			var nodeMatrix=avatarNodeDatas[nodeIndex];
			if (nodeMatrix!==Animator.deafaultMatrix){
				var spriteTransform=this._avatarNodes[nodeIndex].transform._entity;
				var spriteWorldMatrix=spriteTransform.worldMatrix;
				Utils3D.matrix4x4MultiplyMFM((this._owner)._transform.worldMatrix,nodeMatrix,spriteWorldMatrix);
				spriteTransform.worldMatrix=spriteWorldMatrix;
			}
		}
	}

	/**
	*@private
	*/
	__proto._updateAvatarNodesToSpriteRealTime=function(){
		for (var i=0,n=this._cacheSpriteToNodesMap.length;i < n;i++){
			var node=this._avatarNodes[this._cacheSpriteToNodesMap[i]];
			var spriteTransform=node.transform._entity;
			var nodeTransform=node.transform;
			if (nodeTransform._worldUpdate){
				var nodeMatrix=Animator._tempMatrix4x40;
				nodeTransform._setWorldMatrixAndUpdate(nodeMatrix);
				var spriteWorldMatrix=spriteTransform.worldMatrix;
				Utils3D.matrix4x4MultiplyMFM((this._owner)._transform.worldMatrix,nodeMatrix,spriteWorldMatrix);
				spriteTransform.worldMatrix=spriteWorldMatrix;
			}
		}
	}

	/**
	*@private
	*/
	__proto._updatePlayer=function(elapsedTime){
		if (this._currentPlayClip==null || this._stoped || !this._currentPlayClip.loaded)
			return;
		var cacheFrameInterval=this._cacheFrameRateInterval *this._cachePlayRate;
		var time=0;
		(this._startUpdateLoopCount!==Stat.loopCount)&& (time=elapsedTime *this.playbackRate,this._elapsedPlaybackTime+=time);
		var frameRate=this._currentPlayClip._frameRate;
		var playStart=this._playStartFrames[this._currentPlayClipIndex] / frameRate;
		var playEnd=Math.min(this._playEndFrames[this._currentPlayClipIndex] / frameRate,this._currentPlayClip._duration);
		var aniClipPlayDuration=playEnd-playStart;
		if ((!this._currentPlayClip.islooping && this._elapsedPlaybackTime >=aniClipPlayDuration)){
			this._onAnimationStop();
			this._setPlayParamsWhenStop(aniClipPlayDuration,cacheFrameInterval);
			this.event(/*laya.events.Event.STOPPED*/"stopped");
			return;
		}
		time+=this._currentTime;
		if (aniClipPlayDuration > 0){
			if (time >=aniClipPlayDuration){
				do {
					time-=aniClipPlayDuration;
					if (time < aniClipPlayDuration){
						this._setPlayParams(time,cacheFrameInterval);
						this.event(/*laya.events.Event.COMPLETE*/"complete");
					}
					this._playEventIndex=0;
					this._eventScript(0,time);
				}while (time >=aniClipPlayDuration)
				}else {
				this._setPlayParams(time,cacheFrameInterval);
			}
			}else {
			this._currentTime=this._currentFrameTime=this._currentFrameIndex=this._playEventIndex=0;
			this.event(/*laya.events.Event.COMPLETE*/"complete");
		}
	}

	/**
	*@private
	*更新蒙皮动画组件。
	*@param state 渲染状态参数。
	*/
	__proto._update=function(state){
		var clip=this._currentPlayClip;
		if (this.playState!==/*laya.ani.AnimationState.playing*/2 || !clip || !clip.loaded)
			return;
		var rate=this.playbackRate *Laya.timer.scale;
		var cacheRate=this._cachePlayRate;
		this._canCache=this.isCache && rate >=cacheRate;
		var frameIndex=-1;
		var clipDatas;
		if (this._canCache){
			frameIndex=this._currentFrameIndex;
			if (this._lastFrameIndex===frameIndex)
				return;
			clipDatas=clip._getAnimationDataWithCache(cacheRate,frameIndex);
			if (this._avatar){
				var avatarOwners=this._cacheNodesAvatarOwners[this._currentPlayClipIndex];
				var cacheMap=clip._cachePropertyMap;
				var cacheMapCount=cacheMap.length;
				if (cacheMapCount > 0){
					if (!clipDatas){
						clipDatas=[];
						clipDatas.length=cacheMapCount;
						clip._cacheAnimationData(cacheRate,frameIndex,clipDatas);
						clip._evaluateAnimationlDatasCacheMode(avatarOwners,this._cacheFullFrames[this._currentPlayClipIndex],this,clipDatas,cacheMap);
					}
					this._setAnimationClipPropertyToAnimationNode(avatarOwners,cacheMap,clipDatas);
				}
				this._curAvatarNodeDatas=clip._getAvatarDataWithCache(this._avatar,this._cachePlayRate,frameIndex);
				if (!this._curAvatarNodeDatas){
					this._curAvatarNodeDatas=[];
					this._curAvatarNodeDatas.length=this._avatarNodes.length;
					clip._cacheAvatarData(this._avatar,this._cachePlayRate,frameIndex,this._curAvatarNodeDatas);
					this._evaluateAvatarNodesCacheMode(avatarOwners,clip,clip._publicClipDatas,this._curAvatarNodeDatas,clip._unCachePropertyMap);
				}
				this._updateAvatarNodesToSpriteCacheMode(clip,this._curAvatarNodeDatas);
				}else {
				var spriteOwners=this._cacheNodesSpriteOwners[this._currentPlayClipIndex];
				if (!clipDatas){
					clipDatas=[];
					clipDatas.length=this._currentPlayClip._nodes.length;
					clip._evaluateAnimationlDatasCacheMode(spriteOwners,this._cacheFullFrames[this._currentPlayClipIndex],this,clipDatas,null);
					clip._cacheAnimationData(cacheRate,frameIndex,clipDatas);
				}
				this._setAnimationClipPropertyToSprite3D(spriteOwners,clipDatas);
			}
			}else {
			clipDatas=clip._publicClipDatas;
			if (this._avatar){
				clip._evaluateAnimationlDatasRealTime(this._cacheNodesAvatarOwners[this._currentPlayClipIndex],this.currentPlayTime,clipDatas,clip._cachePropertyMap);
				if (!this._publicAvatarNodeDatas){
					this._publicAvatarNodeDatas=[];
					var nodeCount=this._avatarNodes.length;
					this._publicAvatarNodeDatas.length=nodeCount;
					for (var i=1;i < nodeCount;i++)
					this._publicAvatarNodeDatas[i]=new Float32Array(16);
				}
				this._curAvatarNodeDatas=this._publicAvatarNodeDatas;
				this._evaluateAvatarNodesRealTime(this._cacheNodesAvatarOwners[this._currentPlayClipIndex],clip,clipDatas,this._curAvatarNodeDatas,clip._unCachePropertyMap);
				this._updateAvatarNodesToSpriteRealTime();
				}else {
				clip._evaluateAnimationlDatasRealTime(this._cacheNodesSpriteOwners[this._currentPlayClipIndex],this.currentPlayTime,clipDatas,null);
			}
		}
		this._lastFrameIndex=frameIndex;
	}

	/**
	*@private
	*/
	__proto._checkAnimationNode=function(node,sprite){
		if (node.name===sprite.name && !sprite._transform.dummy)
			sprite._isLinkSpriteToAnimationNode(this,node,true);
		for (var i=0,n=sprite._childs.length;i < n;i++)
		this._checkAnimationNode(node,sprite.getChildAt(i));
	}

	/**
	*@inheritDoc
	*/
	__proto._load=function(owner){
		((owner).activeInHierarchy)&& (Laya.timer.frameLoop(1,this,this._updateAnimtionPlayer));
		this._owner.on(/*laya.events.Event.ACTIVE_IN_HIERARCHY_CHANGED*/"activeinhierarchychanged",this,this._onOwnerActiveHierarchyChanged);
	}

	/**
	*@inheritDoc
	*/
	__proto._unload=function(owner){
		_super.prototype._unload.call(this,owner);
		((owner).activeInHierarchy)&& (Laya.timer.clear(this,this._updateAnimtionPlayer));
		this._owner.off(/*laya.events.Event.ACTIVE_IN_HIERARCHY_CHANGED*/"activeinhierarchychanged",this,this._onOwnerActiveHierarchyChanged);
		this._curAvatarNodeDatas=null;
	}

	/**
	*@private
	*/
	__proto._destroy=function(){
		_super.prototype._destroy.call(this);
		for (var i=0,n=this._clips.length;i < n;i++)
		this._clips[i]._removeReference();
		this._currentPlayClip=null;
		this._clipNames=null;
		this._cacheNodesSpriteOwners=null;
		this._cacheNodesAvatarOwners=null;
		this._cacheNodesDefaultlValues=null;
		this._clips=null;
		this._cacheFullFrames=null;
	}

	/**
	*@private
	*/
	__proto._cloneTo=function(dest){
		var animator=dest;
		animator.avatar=this.avatar;
		var clipCount=this._clips.length;
		for (var i=0,n=this._clips.length;i < n;i++)
		animator.addClip(this._clips[i]);
		if (this.clip){
			animator.clip=this.clip;
		}
		if (this._linkSpritesData){
			animator._linkSpritesData={};
			for (var k in this._linkSpritesData)
			animator._linkSpritesData[k]=this._linkSpritesData[k].slice();
		}
	}

	/**
	*添加动画片段。
	*@param clip 动画片段。
	*@param playName 动画片段播放名称，如果为null,则使用clip.name作为播放名称。
	*@param 开始帧率。
	*@param 结束帧率。
	*/
	__proto.addClip=function(clip,playName,startFrame,endFrame){
		(startFrame===void 0)&& (startFrame=0);
		(endFrame===void 0)&& (endFrame=4294967295);
		playName=playName || clip.name;
		var index=this._clipNames.indexOf(playName);
		if (index!==-1){
			if (this._clips[index]!==clip)
				throw new Error("Animation:this playName has exist with another clip.");
			}else {
			var clipIndex=this._clips.indexOf(clip);
			if (startFrame < 0 || endFrame < 0)
				throw new Error("Animator:startFrame and endFrame must large than zero.");
			if (startFrame > endFrame)
				thr