package laya.tbplugin.mini
{
	import laya.display.Input;
	import laya.net.Loader;
	import laya.net.LocalStorage;
	import laya.net.URL;
	import laya.utils.Browser;
	import laya.utils.Handler;
	import laya.utils.RunDriver;
	import laya.utils.Utils;
	
	public class TBPluginAdapter {
		/**@private  包装对象**/
		public static var EnvConfig:Object;
		/**@private **/
		/**全局window对象**/
		public static var window:Object;
		/**@private **/
		private static var _preCreateElement:Function;
		/**@private 适配库是否初始化**/
		private static var _inited:Boolean = false;
		/**@private 获取手机系统信息**/
		public static var systemInfo:Object;
		/**@private 是否需要在主域中自动将加载的文本数据自动传递到子域，默认 false**/
		public static var isPosMsgYu:Boolean;
		/**是否自动缓存下载的图片跟声音文件，默认为true**/
		public static var autoCacheFile:Boolean = false;
		/**50M缓存容量满时每次清理容量值,默认每次清理5M**/
		public static var minClearSize:int = (5 * 1024 * 1024); 
		/**本地资源列表**/
		public static var nativefiles:Array = ["layaNativeDir"];
		/**@private 是否自动缓存非图片声音文件(这里要确保文件编码最好一致)**/
		public static var AutoCacheDownFile:Boolean = false;
		/**默认的目录层级*/
		public static var baseDir:String = "component/";
		/**@private **/
		public static function getJson(data:String):Object {
			return JSON.parse(data);
		}
		
		/**
		 * 初始化回调
		 */
		public static function init():void {
			if (_inited) return;
			_inited = true;
			window = __JS__('window');
			var u:* = window.navigator.userAgent;
			if(!(u.indexOf('TB') > -1 || u.indexOf('Taobao') > -1 || u.indexOf('TM/') >-1))
				return;
			EnvConfig = {};
			//设置资源存储目录
			MiniFileMgr.setNativeFileDir("/layaairGame");
			MiniFileMgr.existDir(MiniFileMgr.fileNativeDir, Handler.create(TBPluginAdapter, onMkdirCallBack));
			systemInfo = window.my.getSystemInfoSync();
			
			window.focus = function():void {
			};
			//清空路径设定
			Laya['_getUrlPath'] = function():void {
			};
			Laya['getUrlPath'] = function():void {
			};
			window.logtime = function(str:String):void {
			};
			window.alertTimeLog = function(str:String):void {
			};
			window.resetShareInfo = function():void {
			};
			
			//获取手机的设备像素比
			//EnvConfig.pixelRatioInt = 0;
			//RunDriver.getPixelRatio = pixelRatio;
			//适配HTMLCanvas中的Browser.createElement("canvas")
			_preCreateElement = Browser.createElement;
			//获取小程序pixel值
			Browser["createElement"] = createElement;
			
			//适配Context中的to对象
			window.CanvasRenderingContext2D = function():void {};
			window.CanvasRenderingContext2D.prototype = _preCreateElement('canvas').getContext('2d').__proto__;
			//重写body的appendChild方法
			window.document.body.appendChild = function():void {
			};
			
			//适配RunDriver.createShaderCondition
			RunDriver.createShaderCondition = createShaderCondition;
			//适配XmlDom
			Utils['parseXMLFromString'] = parseXMLFromString;
			//文本输入框
			Input['_createInputElement'] = MiniInput['_createInputElement'];
			
			//修改文件加载
			EnvConfig.load = Loader.prototype.load;
			//文件加载处理
			Loader.prototype.load = MiniLoader.prototype.load;
			//修改图片加载
			Loader.prototype._loadImage = MiniImage.prototype._loadImage;
			//本地缓存类
			LocalStorage._baseClass = MiniLocalStorage;
			MiniLocalStorage.__init__();
			Config.useRetinalCanvas = true;
		}
		
		private static var _measureText:Function;
		public static function measureText(str:String):Object
		{
			var tempObj:Object = _measureText(str);
			if(!tempObj)
			{
				tempObj ={width:16};
				console.warn("-------微信获取文字宽度失败----等待修复---------");
			}
			return tempObj;
		}
		
		/**
		 * 获取url对应的encoding值 
		 * @param url 文件路径
		 * @param type 文件类型
		 * @return 
		 */		
		public static  function getUrlEncode(url:String,type:String):String
		{
			if(type == "arraybuffer")
				return "";
			return "utf8";
		}
			
		/**
		 * 下载文件 
		 * @param fileUrl 文件地址(全路径)
		 * @param fileType 文件类型(image、text、json、xml、arraybuffer、sound、atlas、font)
		 * @param callBack 文件加载回调,回调内容[errorCode码(0成功,1失败,2加载进度)
		 * @param encoding 文件编码默认 ascill，非图片文件加载需要设置相应的编码，二进制编码为空字符串
		 */				
		public static function downLoadFile(fileUrl:String, fileType:String = "",callBack:Handler = null,encoding:String = "utf8"):void
		{
			var fileObj:Object = MiniFileMgr.getFileInfo(fileUrl);
			if(!fileObj)
				MiniFileMgr.downLoadFile(fileUrl,fileType,callBack,encoding);
			else
			{
				callBack != null && callBack.runWith([0]);
			}
		}
		
		/**
		 * 从本地删除文件
		 * @param fileUrl 文件地址(全路径)
		 * @param callBack 回调处理，在存储图片时用到
		 */
		public static function remove(fileUrl:String, callBack:Handler = null):void {
			MiniFileMgr.deleteFile("",fileUrl,callBack,"",0);
		}
		
		/**
		 * 清空缓存空间文件内容 
		 */		
		public static function removeAll():void
		{
			MiniFileMgr.deleteAll();
		}
		
		/**
		 * 判断是否是4M包文件
		 * @param fileUrl 文件地址(全路径)
		 * @return 
		 */		
		public static function  hasNativeFile(fileUrl:String):Boolean
		{
			return MiniFileMgr.isLocalNativeFile(fileUrl);
		}
		
		/**
		 * 判断缓存里是否存在文件
		 * @param fileUrl 文件地址(全路径)
		 * @return
		 */
		public static function getFileInfo(fileUrl:String):Object {
			return MiniFileMgr.getFileInfo(fileUrl);
		}
		
		/**
		 * 获取缓存文件列表
		 * @return
		 */
		public static function getFileList():Object
		{
			return MiniFileMgr.filesListObj;
		}
		
		/**@private 退出小游戏**/
		public static function exitMiniProgram():void
		{
			window.my.exitMiniProgram();
		}
		
		/**@private **/
		private static function onMkdirCallBack(errorCode:int, data:*):void {
			if (!errorCode){
				MiniFileMgr.filesListObj = JSON.parse(data.data);
				MiniFileMgr.fakeObj = JSON.parse(data.data);
			}
		}
		
		/**@private 设备像素比。*/
		public static function pixelRatio():Number {
			if (!EnvConfig.pixelRatioInt) {
				try {
					EnvConfig.pixelRatioInt = systemInfo.pixelRatio;
					return systemInfo.pixelRatio;
				} catch (error:Error) {
				}
			}
			return EnvConfig.pixelRatioInt;
		}
		/**
		 * @private 
		 * 将字符串解析成 XML 对象。
		 * @param value 需要解析的字符串。
		 * @return js原生的XML对象。
		 */
		private static var parseXMLFromString:Function = function(value:String):XmlDom {
			var rst:*;
			var Parser:*;
			value = value.replace(/>\s+</g, '><');
			try {
				__JS__("rst=(new window.Parser.DOMParser()).parseFromString(value,'text/xml')");
			} catch (error:Error) {
				throw "需要引入xml解析库文件";
			}
			return rst;
		}
		/**@private **/
		private static var idx:int = 1;
		/**@private **/
		public static function createElement(type:String):* {
			if (type == "canvas") {
				var _source:*;
				if (idx == 1) {
					_source = window.canvas.getRealCanvas();
					if(!window.my.isIDE){
						var originfun:Function = _source.getContext;
						_source.getContext = function(type):void{
						  var gl:* = originfun.apply(_source,[type]);
						  gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, false);
						  return gl;
						}
					}
				}else {
					_source = _preCreateElement(type);
				}
				(!_source.style) && (_source.style = {});
				idx++;
				return _source;
			} else if (type == "textarea" || type == "input") {
				return onCreateInput(type);
			} else if (type == "div") {
				var node:* = _preCreateElement(type);
				node.contains = function(value:String):* {
					return null
				};
				node.removeChild = function(value:String):void {
				};
				return node;
			}
			else {
				return _preCreateElement(type);
			}
		}
		/**@private **/
		private static function onCreateInput(type:*):Object {
			var node:* = _preCreateElement(type);
			node.focus = MiniInput.wxinputFocus;
			node.blur = MiniInput.wxinputblur;
			//node.style = {};
			node.value = 0;//文本内容
			//node.parentElement = {};
			node.placeholder = {};
			node.type = {};
			node.setColor = function(value:String):void {
			};
			node.setType = function(value:String):void {
			};
			node.setFontFace = function(value:String):void {
			};
			//node.addEventListener = function(value:String):void {
			//};
			node.contains = function(value:String):* {
				return null
			};
			//node.removeChild = function(value:String):void {
			//};
			return node;
		}
		
		/**@private **/
		public static function createShaderCondition(conditionScript:String):Function {
			var func:Function = function():* {
				var abc:String = conditionScript;
				return this[conditionScript.replace("this.", "")];
			}
			return func;
		}
	}
}