
(function() {
	var pluginName = '插入公式';
	var baseURL = tinymce.baseURL;
	if(window.STATIC_PATH_ALL){
		baseURL = window.STATIC_PATH_ALL+'app/vender/tinymce';
	}
	var link = baseURL+'/plugins/kitymath/index.html';
    //公式编辑; http://www.wiris.com/editor/demo/en/developers 
    var open = function(editor){
        var dialog = editor.kitymathForm;
        if( dialog && dialog.$main){ //性能优化;再次打开不再从头初始化;
            var windowFrame = dialog.$main.find('iframe').get(0).contentWindow;
            dialog.display(true);
            if(editor.pluginMathValue){
                windowFrame.setValueMath(editor.pluginMathValue);
                editor.pluginMathValue  = false;
            }
            return;
        }
        
        var dialog = $.dialog.open(link, {
            title:pluginName,
            fixed: true,
            resize: true,
            ico:'<i></i>',
            lock: true,opacity:0.2,
            width: 800,height: 500,padding:0,
            ok: function () {
                windowFrame.getData(function(base64,math){
                    var html  = '<img src="' + base64 + '" data-latex="' + math + '"/>';
                    requireAsync([STATIC_PATH+'app/vender/markdown/katex/katex.min.js'],function(){
                        html = katex.renderToString(math,{throwOnError:false});
                        html = html.replace('<span class="katex">','<span class="katex" contenteditable="false" data-exp="'+math+'">');
                        html = '<span class="katex-box">'+html+"</span>";// 包裹一层,允许设置字体大小;
                        
                        dialog.display(false);
                        if(editor.pluginMathTarget){
                            $(html).insertBefore(editor.pluginMathTarget);
                            editor.pluginMathTarget.remove();
                            editor.pluginMathTarget = false;
                        }else{
                            editor.insertContent(html);
                        }
                    });
                });
                return false;
            },
            cancel: function(){
                dialog.display(false);
                return false;
            }
        });
        dialog.$main.css({'min-height':'560px','min-width':'800px'});
        
        editor.kitymathForm = dialog;
        var windowFrame = dialog.$main.find('iframe').get(0).contentWindow;
        windowFrame.defaultMath = editor.pluginMathValue;
        editor.pluginMathValue  = false;
    }

    var register = function(editor) {
        editor.addCommand('mceKitymath',function(){
            open(editor);
        });
        editor.ui.registry.addButton("kitymath", {
            icon:"math",
            tooltip:pluginName,
            onAction: function(){return open(editor);}
        }), 
        editor.ui.registry.addMenuItem("kitymath", {
            icon:"math",
            text:pluginName,
            onAction: function(){return open(editor);}
        });
        editor.on('DblClick',function(e){
            var $text = $(e.target).parentNode('.katex');
            if(!$text) return;
            editor.pluginMathTarget = $text;
            editor.pluginMathValue  = $text.attr('data-exp');
            open(editor);
        });
    };

    tinymce.util.Tools.resolve('tinymce.PluginManager').add('kitymath',function(editor) {
        register(editor);
        return {};
    });
}());