﻿// https://docs.qq.com/doc/DUFlaallKaEduYmFK
// 要注意一下事情："bin_"字样必须小写，且日期格式要正确
// 下载目录是否有中文名、空格；url是否有中文
const kUpdataJsonUrl = "https://miniblink.net/minichrome-release/upgrade2/updata.json";

const fetch = require("node-fetch");
var fs = require('fs');
const pathModule = require('path');

function forwardSlashToBackSlash(path) { // '/' -> '\\'
    path = path.replace(/\//g, '\\');
    return path;
}

function backSlashToForwardSlash(path) { // '\\' -> '/'
    path = path.replace(/\\/g, '/');
    return path;
}

let dirname = __dirname;
dirname = backSlashToForwardSlash(dirname);
dirname = dirname.toLowerCase();

dirname = process.binding('fs').getLongPathSync(dirname);
//dirname = pathModule._makeLong(dirname);
console.log("dirname:" + dirname); // updata_proj\bin_2020.12.3_1\updata

let g_newChromeDirname = "";

let pathInfos = (function () {
    var ret = {"chromeDir" : dirname, "rootDir" : ""};
    ret.chromeDir = ret.chromeDir.split('/').join('\\');
    var names = ret.chromeDir.split('\\');
    console.log("names.length:" + names.length);
    
    let findBinStr = false;
    for (let i = 0; i < names.length; ++i) {
        var lastDir = names.pop();
        if (lastDir.startsWith("bin")) {
            console.log("lastDir true:" + lastDir);
            findBinStr = true;
            names.push(lastDir);
            break;
        } else
            console.log("lastDir false:" + lastDir);
    }
    if (!findBinStr) {
        require('electron').app.quit();
        return null;
    }
    
    ret.chromeDir = "";
    for (let i = 0; i < names.length; ++i) {
        ret.chromeDir += names[i] + "\\";
        if (i < names.length - 1)
           ret.rootDir += names[i] + "\\";
    }

    return ret;
})();
const kChromeDir = pathInfos.chromeDir; // c:\chromemini\bin_2020.12.3_1\
const kRootDir = pathInfos.rootDir; // c:\chromemini\

console.log("kChromeDir:" + kChromeDir);
console.log("kRootDir:" + kRootDir);

const kLogPath = kChromeDir + "updata\\log.txt";
if (fs.existsSync(kLogPath)) {
    var states = fs.statSync(kLogPath);
    if (states.size > 5 * 24) {
        fs.unlinkSync(kLogPath);
    }
}

function writeLog(str) {
    console.log(str);
    
    var d = new Date();
    var line = "[" + d.toString();
    line += "] " + str + "\n";
    fs.appendFileSync(kLogPath, line);
}

function calcFileHash(fileName) {
    const crypto = require('crypto');
    let md5 = null;
    
    if (!(fs.existsSync(fileName))) {
        console.log("calcFileHash file is not exist: " + fileName);
        return null;
    }
    
    try {
        const buffer = fs.readFileSync(fileName);
        const fsHash = crypto.createHash("md5"); // sha256
        
        fsHash.update(buffer);
        md5 = fsHash.digest("hex");
    } catch(err) {
        console.log("calcFileHash fail: " + fileName);
        return null;
    }
    return md5;
}

//let testHash = calcFileHash("G:\\test\\pakage\\m84\\bin\\chrome.dll");
//console.log("testHash:" + testHash);

if (0 == kChromeDir.length)
    return writeLog("kChromeDir length is zero");

// 切割大小
function cutSize(contentLength, blockSize) {
    // 向后取整
    let blockLen = Math.ceil(contentLength / blockSize);
    let blist = [];
    for (let i = 0, strat, end; i < blockLen; i++) {
        strat = i * blockSize;
        end = (i + 1) * blockSize - 1;
        end = end > contentLength ? contentLength - 1 : end;
        blist.push({ strat: strat, end: end });
    }
    return blist;
}

// 获取响应头信息
function getResHeaders(u) {
    return new Promise(function (resolve, reject) {
        fetch(u, {
            method: "GET", // 请求方式
            // mode: 'cors',
            headers: { // 请求头
                "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 Safari/537.36",
                "Cache-Control": "no-cache",
                Connection: "keep-alive",
                Pragma: "no-cache",
                Range: "bytes=0-1"
            }
        }).then(r => {
            let h = {};
            r.headers.forEach(function (v, i, a) {
                h[i.toLowerCase()] = v;
            });
            return resolve(h);
        }).catch(function(error) {
            writeLog("getResHeaders, error:" + error);
            return rejected(null);
        });
    });
}

function downloadBlock(url, o) {
    let option = {
        "Content-Type": "application/octet-stream",
        "Cache-Control": "no-cache",
        "Connection": "keep-alive",
        "Pragma": "no-cache"
    };
    if (typeof o == "string") {
        option["Range"] = "bytes=" + o;
    } else if (typeof o == "object") {
        option = Object.assign(option, o);
    }
    
    console.log("downloadBlock:" + url);
    return fetch(url, {
        method: 'GET',
        headers: option,
    //}).then(res => res.buffer()).catch(function(error) {
    }).then(function(res) { 
        console.log("downloadBlock recv");
        return res.buffer();
    }).catch(function(error) {
        writeLog("downloadBlock, error:" + error);
    });
}

async function downloadOneFileImpl(url, fileSavePath, retval) {
    if (fs.existsSync(fileSavePath)) {
        fs.unlinkSync(fileSavePath);
        if (fs.existsSync(fileSavePath)) {
            writeLog("downloadOneFileImpl error, file is exist:" + fileSavePath);
            retval.ok = false;
            return new Promise(function (resolve) {resolve(false);});
        }
    }
    
    let blockSize = 1024 * 1024 * 4;
    let header = await getResHeaders(url);
    if (!header || !("content-range" in header)) {
        writeLog("downloadOneFileImpl fail, header is null:" + url + ", " + header);
        retval.ok = false;
        return new Promise(function (resolve) {resolve(false);});
    }
    let contentRange = header["content-range"];
    console.log("downloadOneFileImpl:::::" + contentRange);
    if (!contentRange) {
        writeLog("downloadOneFileImpl fail, contentRange is null");
        retval.ok = false;
        return new Promise(function (resolve) {resolve(false);});
    }
    
    let contentLength = Number(contentRange.split("/").reverse()[0]);
    if (!contentLength) {
        writeLog("downloadOneFileImpl fail, contentLength is null");
        retval.ok = false;
        return new Promise(function (resolve) {resolve(false);});
    }
    let blocks = cutSize(contentLength, blockSize);
    console.log("downloadOneFileImpl, blocks.length:" + blocks.length);
    
    for (let i = 0; i < blocks.length; i++) {
        let block = blocks[i];
        let blob = null;
        let loopCount = 0;
        
        while (loopCount < 1) {
            ++loopCount;
            console.log("downloadOneFileImpl, blocks---(" + block.strat + ")-(" + block.end + ")");
            let opt = { "Content-Type": "application/octet-stream" };
            //if (1 < blocks.length)
                opt.Range = "bytes=" + block.strat + "-" + block.end;
            blob = await downloadBlock(url, opt);
            console.log("downloadOneFileImpl, blocks---end: " + i);
            
            if (!blob) {
                writeLog("downloadOneFileImpl fail, blob is null");
                retval.ok = false;
                return new Promise(function (resolve) {resolve(false);});
            }
        }

        // 追加内容
        fs.appendFileSync(fileSavePath, blob);
        console.log("downloadOneFile, appendFileSync:" + block.strat + "-" + block.end + ", " + fileSavePath);
    }
    
    retval.ok = true;
    return new Promise(function (resolve) {resolve(true);});
}

async function downloadOneFile(url, fileSavePath) {
    let i = 0;
    let retval = {"ok": false};
    let isOk = false;
    while (i < 5) {
        ++i;
        isOk = await downloadOneFileImpl(url, fileSavePath, retval);
        if (!isOk)
            continue;
        break;
    }
    return new Promise(resolve => {resolve(isOk)});
}

function downloadJson(url) {
    return fetch(url, {
        method: 'GET'
    }).then(res => res.json());
}

function parseInfoFromDirname(dirname) {
    var names = kChromeDir.split('\\');
    var name = names.pop();
    if (0 == name.length)
        name = names.pop();
    
    var ret = {"year":0, "month": 0, "day": 0, "ver": 0};
    console.log("parseInfoFromDirname 1, name:" + name);
    if (name == ("bin")) {
        return ret;
    }
    if (!name.startsWith("bin_")) {
        return null;
    }
    name = name.substring(4); // 2020.12.3_1
    console.log("parseInfoFromDirname 2, name:" + name);
    
    names = name.split('_');
    if (2 != names.length)
        return null;
    
    var dataStrings = names[0].split('.');
     if (3 != dataStrings.length)
        return null;
     var ver = names[1];
     
     
     ret.year = parseInt(dataStrings[0]);
     ret.month = parseInt(dataStrings[1]);
     ret.day = parseInt(dataStrings[2]);
     ret.ver = parseInt(ver);
     
     console.log("parseInfoFromDirname, data:" + ret.year + ", " + ret.month + ", " + ret.day + ", " + ret.ver);
     return ret;
}

function mkdirsSync(dirname) {
    if (fs.existsSync(dirname))
        return true;
    if (mkdirsSync(pathModule.dirname(dirname))) {
        fs.mkdirSync(dirname);
        return true;
    }
    return false;
}

//{
//    "file": [
//        {
//            "name": "chrome.dll",
//            "url": "http://xxxx.com/chrome.dll",
//            "hash": "121321312312", 
//            "size": 1234,
//            "date": "2020.1.1",
//            "isCompress": false,
//            "needFetch": true
//        }, 
//        {
//            "name": "libEGL.dll",
//            "url": "http://xxxx.com/libEGL.dll",
//            "hash": "121321312312", 
//            "size": 1234,
//            "date": "2020.1.1",
//            "needFetch": true，
//            "path": "swiftshader"
//        }
//    ], 
//    "launchFile": "launch.exe"
//}

async function mainRun() {
    let needFetchFilesCount = 0;
    let jsonStr = await downloadBlock(kUpdataJsonUrl, {
        'Content-Type': 'application/octet-stream',
        "Cache-Control": "no-cache",
        "Connection": "keep-alive",
        "Pragma": "no-cache",
    });
    console.log("mainRun, begin downloadBlock");
    var writeLogAndReturnFalse = function(str) {
        writeLog(str);
        return false;
    }
    if (!jsonStr)
        return writeLogAndReturnFalse("json file fetch error:" + jsonStr);
    let json = null;
    try {
        //console.log("json file parse:" + jsonStr);
        json = JSON.parse(jsonStr);
    } catch(e) {
        console.log("json file parse fail:" + e);
        return writeLogAndReturnFalse("json file parse error:" + json);
    }
    if (!json.file)
        return writeLogAndReturnFalse("json file parse error, no file field");
    
    for (let i = 0; i < json.file.length; ++i) {
        let fileItem = json.file[i];
        let path = fileItem.isLaunchFile ? (kRootDir) : (kChromeDir + fileItem.path);
        let fileHash = calcFileHash(path + fileItem.name);
        
        fileItem.needFetch = false;
        if (!fileHash || fileHash != fileItem.hash) {
            fileItem.needFetch = true;
            needFetchFilesCount++;
        } else {
            console.log("fileHash:" + fileHash + ", fileItem.hash:" + fileItem.hash);
        }
    }
    
    console.log("needFetchFilesCount:" + needFetchFilesCount);
    if (0 == needFetchFilesCount)
        return;
    
    let dirinfo = parseInfoFromDirname(kChromeDir);
    if (!dirinfo)
        return writeLogAndReturnFalse("parseInfoFromDirname fail:" + kChromeDir);
    
    let date = new Date();
    
    // 创建"c:\chromemini\bin_2020.12.3_2\"文件夹
    let newChromeDirname = "bin_" + date.getFullYear() + "." + (date.getMonth() + 1) + "." + date.getDate() + "_" + (dirinfo.ver + 1);
    let newDirname = kRootDir + newChromeDirname + "\\";
    g_newChromeDirname = newChromeDirname; // bin_2020.12.3_2
    
    if (!fs.existsSync(newDirname)) {
        fs.mkdirSync(newDirname)
        if (!fs.existsSync(newDirname)) {
            return writeLogAndReturnFalse("mkdirSync fail:" + newDirname);
        }
    }
    for (let i = 0; i < json.file.length; ++i) {
        let fileItem = json.file[i];
        let newFileFullpath = newDirname + fileItem.path + fileItem.name;
        if (fileItem.isLaunchFile) {
            newFileFullpath = kRootDir + fileItem.name;
        } else {
            if (!fs.existsSync(newDirname + fileItem.path)) {
                mkdirsSync(newDirname + fileItem.path);
            }
            if (!fs.existsSync(newDirname + fileItem.path))
                return writeLogAndReturnFalse("create dir fail:" + newDirname + fileItem.path);
        }

        if (fs.existsSync(newFileFullpath)) {
            let hash = calcFileHash(newFileFullpath);
            if (hash != fileItem.hash) { // 如果文件存在新目录，则检查哈希是否相同。相同的就不做处理了
                fs.unlinkSync(newFileFullpath)
                if (fs.existsSync(newFileFullpath))
                    return writeLogAndReturnFalse("delele file fail:" + newFileFullpath);
            } else {
                console.log("file has exists:" + newFileFullpath);
                continue;
            }
        }
        
        let isOk = false;
        console.log("downloadOneFile, fileItem.needFetch:" + fileItem.needFetch);
        console.log("downloadOneFile, fileItem.url.length:" + fileItem.url.length);
        if (fileItem.needFetch && fileItem.url.length > 0) { // 需要从网络下载
            isOk = await downloadOneFile(fileItem.url[0], newFileFullpath);
            console.log("downloadOneFile:" + isOk);
            if (!isOk)
                return writeLogAndReturnFalse("downloadOneFile fail:" + newFileFullpath);
        } else { // 如果原目录的文件和服务器的一样，就不下载了，直接从原目录拷贝
            console.log("copyFileSync:" + newFileFullpath);
            if (!(fileItem.isLaunchFile))
                fs.copyFileSync(kChromeDir + fileItem.path + fileItem.name, newFileFullpath);
            
            isOk = fs.existsSync(newFileFullpath);
            if (!isOk)
                return writeLogAndReturnFalse("copyFileSync fail:" + newFileFullpath);
        }
        
        // 验证下载的文件是否成功
        let hash = calcFileHash(newFileFullpath);
        if (hash != fileItem.hash) {
            console.log("download finish, but hash is error: hash:" + hash);
            return writeLogAndReturnFalse("download finish, but hash is error:" + newFileFullpath);
        } else
            console.log("download finish:" + newFileFullpath);
    }
    console.log("download ok");
    
    return true;
};

function writeRunLauncher() {
    if (fs.existsSync(kRootDir + "launcher.json"))
        fs.unlinkSync(kRootDir + "launcher.json");
    
    fs.appendFileSync(kRootDir + "launcher.json", "{ \"launcher\":\"" + g_newChromeDirname + "\" }");
}

(async function() {
    var isOk = "false";
    writeLog("begin updata....");
    try {
        isOk = await mainRun();
    } catch(e) {
        writeLog("mainRun fail:" + e + "\n");
        isOk = "excp!";
    }
    writeLog("end updata:" + isOk + "!!!!\n");
    
    if (isOk == true)
        writeRunLauncher();

    require('electron').app.quit();
})();