tinymce.PluginManager.add('lineheight', function(editor, url) {
    var pluginName='设置行高';
    var global$1 = tinymce.util.Tools.resolve('tinymce.util.Tools');
    var lineheight_val = editor.getParam('lineheight_val', '1em 1.2em 1.5em 1.6em 1.8em 2em 3em');

    editor.on('init', function() {
        editor.formatter.register({
            lineheight: {
                selector: 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,table',
                styles: { 'line-height': '%value' }
            }
        });
    });

    var doAct = function (value) {
        editor.formatter.apply('lineheight', { value: value });
        editor.fire('change', {});
    };
    editor.ui.registry.addIcon('lineheight','<i class="font-icon icon-text-height"></i>');
    editor.ui.registry.addMenuButton('lineheight', {
        icon: 'lineheight',
        tooltip: pluginName,
        fetch: function(callback) {
            var dom = editor.dom;
            var blocks = editor.selection.getSelectedBlocks();
            var lhv = 0;
            global$1.each(blocks, function(block) {
                if(lhv==0){
                    lhv = dom.getStyle(block,'line-height') ? dom.getStyle(block,'line-height') : 0;
                }
            });

            var items = lineheight_val.split(' ').map(function(item){
                var text = item;
                var value = item;
                return {
                    type: 'togglemenuitem',
                    text: text,
                    active : lhv==value ? true :false,
                    onAction: function() {
                        doAct(value);
                    }
                };
            });
            callback(items);
        }
    });

    return {
        getMetadata: function () {
            return  {
                name: pluginName,
                url: "http://tinymce.ax-z.cn/more-plugins/lineheight.php",
            };
        }
    };
});
