tinymce.PluginManager.add('bdmap', function(editor, url) {
    var pluginName='插入百度地图';
	var baseURL = tinymce.baseURL;
	if(window.STATIC_PATH_ALL){
		baseURL = window.STATIC_PATH_ALL+'app/vender/tinymce';
	}
    var bdmap_width = function (editor) {
        return editor.getParam('bdmap_width', 560);
    };
    var bdmap_height = function (editor) {
        return editor.getParam('bdmap_height', 362);
    };
    window.tinymceLng='';
    window.tinymceLat='';
    var openDialog = function() {
        return editor.windowManager.openUrl({
            title: pluginName,
            size: 'large',
            //width: 800,
            //height: 500,
            url:baseURL+'/plugins/bdmap/map.html',
            buttons: [
                {
                    type: 'cancel',
                    text: 'Close'
                },
                {
                    type: 'custom',
                    text: 'Save',
                    name: 'save',
                    primary: true
                },
            ],
            onAction: function (api, details) {
                switch (details.name) {
                    case 'save':
                        html='<iframe src="'+baseURL+'/plugins/bdmap/bd.html?center='+tinymceLng+'%2C'+tinymceLat+'&zoom=14&width='+(bdmap_width(editor)-2)+'&height='+(bdmap_height(editor)-2)+'" frameborder="0" style="width:'+bdmap_width(editor)+'px;height:'+bdmap_height(editor)+'px;">';
                        editor.insertContent(html);
                        api.close();
                        break;
                    default:
                        break;
                }
                
            }
        });
    };

    editor.ui.registry.addButton('bdmap', {
        icon: 'bdmap',
        tooltip: pluginName,
        onAction: function() {
            openDialog();
        }
    });
    editor.ui.registry.addMenuItem('bdmap', {
        text: pluginName,
        icon: 'bdmap',
        onAction: function() {
            openDialog();
        }
    });
    return {};
});
