//---------------------------------------------------------------------------
#pragma option push -w-
#pragma option push -Vx
#ifndef ujydiskH
#define ujydiskH
//---------------------------------------------------------------------------
#endif
//#include <JyDiskInfo.hpp>
#include <windows.h>
#pragma option push -b
enum HOST_READS_WRITES_UNIT { HOST_READS_WRITES_UNKNOWN, HOST_READS_WRITES_512B, HOST_READS_WRITES_32MB, HOST_READS_WRITES_GB };
#pragma option pop
#pragma option push -b
enum INTERFACE_TYPE { INTERFACE_TYPE_UNKNOWN, INTERFACE_TYPE_PATA, INTERFACE_TYPE_SATA, INTERFACE_TYPE_USB, INTERFACE_TYPE_IEEE1394, INTERFACE_TYPE_UASP, INTERFACE_TYPE_SCSI, INTERFACE_TYPE_NVME };
#pragma option pop
#pragma option push -b
enum VENDOR_ID { HDD_GENERAL, SSD_GENERAL, SSD_VENDOR_MTRON, SSD_VENDOR_INDILINX, SSD_VENDOR_JMICRON, SSD_VENDOR_INTEL, SSD_VENDOR_SAMSUNG, SSD_VENDOR_SANDFORCE, SSD_VENDOR_MICRON, SSD_VENDOR_OCZ, HDD_SSD_VENDOR_SEAGATE, HDD_VENDOR_WESTERN_DIGITAL, SSD_VENDOR_PLEXTOR, SSD_VENDOR_SANDISK, SSD_VENDOR_OCZ_VECTOR, HDD_SSD_VENDOR_TOSHIBA, SSD_VENDOR_CORSAIR, SSD_VENDOR_KINGSTON, SSD_VENDOR_MICRON_MU02, SSD_VENDOR_NVME };
#pragma option pop
//typedef unsigned short       Word;
//typedef unsigned char        Byte;       
struct JyHDiskInfo
{
	bool IsSmartSupported;
	bool IsApmSupported;
	bool IsApmEnabled;
	bool IsAamSupported;
	bool IsAamEnabled;
	bool IsLba48Supported;
	bool IsNcqSupported;
	bool IsNvCacheSupported;
	bool IsTrimSupported;
	bool IsSsd;
	bool IsDeviceSleepSupported;
	bool IsMaxtorMinute;
	bool IsRawValues8;
	bool IsRawValues7;
	unsigned DetectedTimeUnitType;
	char ModelNumber[40];
	char FirmwareRev[8];
	char SerialNumber[20];
	__int64 Cylinders;
	unsigned Heads;
	unsigned BytesPerSector;
	unsigned SectorsPerTrack;
	unsigned TracksPerCylinder;
	__int64 disksize;
	int Temperature;
	int PowerOnTime;
	int PowerOnCount;
	WORD RotationRate;
	unsigned BufferSize;
	__int64 HostWrites;
	__int64 HostReads;
	char CurrentTransferMode[256];
	char MaxTransferMode[256];
	char Interface_[256];
	unsigned TransferModeType;
	unsigned Major;
	__int64 Life;
	char MajorVersion[256];
	char MinorVersion[256];
	char SmartKeyName[256];
	char SsdVendorString[256];
	int SmartCount;
	BYTE ItemId[30];
	BYTE CurrentValue[30];
	BYTE WorstValue[30];
	BYTE ThresholdValue[30];
	__int64 DataValue[30];
	BYTE DataValueArr[30][6];
	BYTE State[30];
	BYTE StatusFlags[30];
	INTERFACE_TYPE InterfaceType;
	HOST_READS_WRITES_UNIT HostReadsWritesUnit;
	VENDOR_ID DiskVendorId;
} ;
void __fastcall  DoReg(char * fuser, int usersize, char * fregid, int regidsize); //

 BOOL __fastcall IsRegisted(void); //

 void __fastcall GetDiskSerialNumber1(char drive, char * pout, int &poutsize); //

 void __fastcall GetDiskSerialNumber2(int index, char * pout, int &poutsize) ;//
 void __fastcall GetDiskSerialNumber2_(int index, char * pout, int &poutsize) ;
 void __fastcall GetDiskTypeStr(int itype, wchar_t * pout, int &poutsize); //

 int __fastcall GetDiskType1(char drive); //

 int __fastcall GetDiskType2(int index); //

 int __fastcall GetDiskIndex(char drive); //

 int __fastcall GetPhysicalDriveCount(char * pout, int &poutsize);//

 void __fastcall GetDriverList(char * pout, int &poutsize);//

 int __fastcall GetPhysicalDrivePartitionCount(int PhysicalDriveId);//

 void __fastcall GetDiskDrive(int PhysicalDriveId, char * pout, int &poutsize);//

 BOOL __fastcall RunAsAdmin(void);//

 BOOL __fastcall GetHardDiskPartitionInfo(const char DriveLetter, char * pVolumeName, int &pVolumeNameSize, char * pVolumeSerialNumber, int &pVolumeSerialNumberSize, char * pPartitionType, int &pPartitionTypeSize, __int64 &TotalSpace, __int64 &TotalFreeSpace);//

 BOOL __fastcall GetDiskInfo(int index, JyHDiskInfo &ainfo);//

 int __fastcall GetDiskPartitionIndex(char drive);//

 void __fastcall GetMd5String(const char * pin, const int pinsize, char * pout, int &poutsize);//

 void __fastcall GetCpuID(char * pout, int &poutsize);//

 void __fastcall GetDisplayDeviceID(char * pout, int &poutsize);//

 void __fastcall GetBiosID(char * pout, int &poutsize);//

 void __fastcall GetIP(char * pout, int &poutsize);//

 void __fastcall GetMacAddr(char * pout, int &poutsize);//
 
 BOOL __fastcall  IsWin64(void); //
 void __fastcall  Init(); //

 #pragma option pop	// -w-
#pragma option pop	// -Vx
