/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */


/*! *****************************************************************************
Copyright (c) 2018 - 2020 Zhou Dengxiang. All rights reserved.
***************************************************************************** */



/// <reference no-default-lib="true"/>


interface Map/*;映*/<K, V> {
    clear/*;清*/(): void;
    delete/*;删*/(key: K): boolean;
    forEach/*;每*/(callbackfn: (value: V, key: K, map: Map<K, V>) => void, thisArg?: any): void;
    get/*;读*/(key: K): V | undefined;
    has/*;有*/(key: K): boolean;
    set/*;置*/(key: K, value: V): this;
    readonly size/*;量*/: number;
}

interface MapConstructor {
    new(): Map<any, any>;
    new<K, V>(entries?: readonly (readonly [K, V])[] | null): Map<K, V>;
    readonly prototype: Map<any, any>;
}
declare var Map/*;映*/: MapConstructor;

interface ReadonlyMap<K, V> {
    forEach/*;每*/(callbackfn: (value: V, key: K, map: ReadonlyMap<K, V>) => void, thisArg?: any): void;
    get/*;读*/(key: K): V | undefined;
    has/*;有*/(key: K): boolean;
    readonly size/*;量*/: number;
}

interface WeakMap/*;弱映*/<K extends object, V> {
    delete/*;删*/(key: K): boolean;
    get/*;读*/(key: K): V | undefined;
    has/*;有*/(key: K): boolean;
    set/*;置*/(key: K, value: V): this;
}

interface WeakMapConstructor {
    new <K extends object = object, V = any>(entries?: readonly [K, V][] | null): WeakMap<K, V>;
    readonly prototype: WeakMap<object, any>;
}
declare var WeakMap/*;弱映*/: WeakMapConstructor;

interface Set/*;集*/<T> {
    add/*;加*/(value: T): this;
    clear/*;清*/(): void;
    delete/*;删*/(value: T): boolean;
    forEach/*;每*/(callbackfn: (value: T, value2: T, set: Set<T>) => void, thisArg?: any): void;
    has/*;有*/(value: T): boolean;
    readonly size/*;量*/: number;
}

interface SetConstructor {
    new <T = any>(values?: readonly T[] | null): Set<T>;
    readonly prototype: Set<any>;
}
declare var Set/*;集*/: SetConstructor;

interface ReadonlySet<T> {
    forEach/*;每*/(callbackfn: (value: T, value2: T, set: ReadonlySet<T>) => void, thisArg?: any): void;
    has/*;有*/(value: T): boolean;
    readonly size/*;量*/: number;
}

interface WeakSet/*;弱集*/<T extends object> {
    add/*;加*/(value: T): this;
    delete/*;删*/(value: T): boolean;
    has/*;有*/(value: T): boolean;
}

interface WeakSetConstructor {
    new <T extends object = object>(values?: readonly T[] | null): WeakSet<T>;
    readonly prototype: WeakSet<object>;
}
declare var WeakSet/*;弱集*/: WeakSetConstructor;
