var cs = new CSInterface();

const kCEE_FailedToReadResultFile = 4001;
const kCEE_FailedToRunExecutable = 4002;
const errorTable = {
	0:"No error",
	1:"No license",
	2:"Bad Parameters",
	3:"Library initialization failed",
	6:"Incompatible .Net version",
	7:"Can't run dot net subprocess",
	100:"Bad license key",
	101:"No connection",
	102:"Server error",
	103:"Invalid license",
	104:"License expired",
	105:"License update period expired",
	106:"The license is already activated on a different computer",
	107:"The license doesn't apply to this product",
	108:"General Error",
	1001:"Failed to load image data",
	1002:"Failed to init image",
	1003:"Failed to get image info",
	1004:"Failed to optimize image",
	1005:"No further optimization is possible",
	1006:"Image already optimized",
	1007:"Image exceed size (MP) limit",
	1008:"Image file is locked",
	1009:"Failed to create destination directory",
	1010:"Image file write failed",
	1011:"Out of memory",
	1012:"File is hard-link",
	1013:"Image is hightly compressed",
	1014:"Image format not supported",
	1015:"Image format not supported for in-place recompression",
	1016:"Failed to initialize HEIC extract library",
	1017:"Failed to initialize HEIC image",
	1018:"Failed to extract HEIC image",
	1019:"Failed to initialize raw image",
	1020:"Failed to set metadata",
	1021:"Failed to delete original",
	1022:"Failed to initialize JPEGmini library",
	1023:"Failed to get HEIC image info",
	3009:"License not bound",
	3011:"License payload invalid",
	3012:"License binding failed",
	3013:"Post modification re-fetch failed",
	3014:"Unbinding failed",
	3015:"Invalid Machine ID",
	3016:"Yarls internal error",
	4001:"Failed to read results file",
	4002:"Failed to run executable"};

function errorCodeToString(code)
{
	if (code in errorTable) {
		return errorTable[code];
	}
	else {
		return "Unknown error: " + code.toString();
	}
}

function getToolPath()
{
	var path = require('path');
	var extPath = cs.getSystemPath(SystemPath.EXTENSION);

	return path.join(extPath,"/binary/JPEGminiTool");
}

function unescape_string(escaped_string)
{
	var length = escaped_string.length;
	var result = "";
	var status = 1;
	var i;

	for (i = 0; i < length; i ++)
	{
		var c = escaped_string.charAt(i);
		switch (status)
		{
			case 1:
				switch (c)
				{
					case '\\':
						status = 2;
						break;
					default:
						result += c;
				}
				break;
			case 2:
				switch (c)
				{
					case '\\':
						result += '\\';
						status = 1;
						break;
					case '3':
						status = 3;
						break;
					default:
						status = 1;
						break;
				}
				break;
			case 3:
				switch (c)
				{
					case 'A':
						result += ':';
						break;
					case 'B':
						result += ';';
						break;
					default:
						break;
				}
				status = 1;
				break;
		}
	}
	return result;
}

function toolResultDictionaryWithString(s)
{
	var rd = {};	// result dictionary
	var ls; 			// lines

	ls = s.split(";");
	for (var i = 0; i < ls.length; i++)
	{
		var cl = ls[i];
		if (cl.length > 0)
		{
			var clc = cl.split(":");
			rd[clc[0]] = [unescape_string(clc[1])];
		}
	}
	return rd;
}

function magnitudeSuffixWithMagnitude(magnitude)
{
	var ss = ["B","KB","MB","GB","TB","PB","EB","ZB"];

	if (magnitude < ss.length)
	{
		return ss[magnitude];
	}

	return "??"
}

function qualifiedSizeStringWithBytes(size)
{
	var m;	// magnitude

	m = 0;

	while (size >= 1000)
	{
		size = size/1000;
		m ++;
	}

	return size.toFixed(1) + " " + magnitudeSuffixWithMagnitude(m);
}

function showAlert(message)
{
	cs.evalScript("alert(\""+ message + "\");");
}


function showConfirmDialog(message, completion)
{
	cs.evalScript("confirm(\""+ message + "\");", function(result){
		if (result == "true")
		{
			result = true;
		}
		else
		{
			result = false;
		}
		completion(result);
	});
}


function updateStats(infoDict)
{
	var ts;
	var ls;
	var lp;

	if (parseInt(infoDict["total-output"]) > 0)
	{
		ts = parseInt(infoDict["total-input"]) - parseInt(infoDict["total-output"]);
		ls = parseInt(infoDict["last-operation-input"]) - parseInt(infoDict["last-operation-output"]);
		lp = (ls/parseInt(infoDict["last-operation-input"]))*100;

		ls = qualifiedSizeStringWithBytes(ls);
		ts = qualifiedSizeStringWithBytes(ts);
		lp = lp.toFixed(1) + "%";
	}
	else
	{
		ts = "0";
		ls = "0";
		lp = "0";
	}

	window.document.getElementById("last-savings-box").innerHTML = ls;
	window.document.getElementById("last-percentage-box").innerHTML = lp;
	window.document.getElementById("total-savings-box").innerHTML = ts;
}

function runToolWithParameters(parameters, completion)
{
	cs.evalScript("tempFolderPath();",function(tempFolderPath)
	{
		var path = require('path');
		var tp = getToolPath();
		var rfp = path.join(tempFolderPath,"/" + ((Math.random()*1000).toString()) + ".txt");
		parameters = parameters.concat(["-result",rfp]);
		parameters = parameters.concat(["-full-info","YES"]);

		var spawn = require('child_process').spawn,
		child = spawn(tp, parameters);
		child.on('close',function(code){
			if (code == 0)
			{
				fs = require('fs')
				fs.readFile(rfp, 'utf8', function (err,data) {
					fs.unlinkSync(rfp);
					if (err)
					{
						completion({"result":kCEE_FailedToReadResultFile.toString()});
					}
					else
					{
						completion(toolResultDictionaryWithString(data));
					}
				});
			}
			else
			{
				completion({"result":kCEE_FailedToRunExecutable.toString()});
			}
		});
	});
}

function copyFile(source, target, completion)
{
  var cbCalled = false;
  var fs = require('fs');

  var rd = fs.createReadStream(source);
  rd.on("error", function(err) {
    done(err);
  });
  var wr = fs.createWriteStream(target);
  wr.on("error", function(err) {
    done(err);
  });
  wr.on("close", function(ex) {
    done(null);
  });
  rd.pipe(wr);

  function done(err) {
    if (!cbCalled) {
      completion(err);
      cbCalled = true;
    }
  }
}

function reCompressJPEG(path, callback)
{
	runToolWithParameters([
	"-action","process",
	"-path",path,
	"-remove-metadata","YES"
	],function(resultDict)
	{
		var resultCode;

		resultCode = parseInt(resultDict["result"]);

		if (resultCode == 0)
		{
			updateStats(resultDict);
		}

		callback(resultCode);
	});
}


function checkActivation(completion)
{
	runToolWithParameters(["-action","check"],function(resultDict)
	{
		var resultCode;

		resultCode = parseInt(resultDict["result"]);
		if (resultCode == 0)
		{
			updateStats(resultDict);
		}

		completion(resultCode);
	});
}

function showMainScreen()
{
	window.document.getElementById("main-screen").classList.remove("hidden");
}

function initialSetup()
{
	window.document.getElementById("activation-screen").classList.add("hidden");
	window.document.getElementById("rebind-screen").classList.add("hidden");
	window.document.getElementById("rebind-error").classList.add("hidden");
	window.document.getElementById("limbo-screen").classList.add("hidden");
	window.document.getElementById("refetch-error").classList.add("hidden");
	window.document.getElementById("main-screen").classList.add("hidden");
	window.document.getElementById("activation-error").classList.add("hidden");

	window.document.getElementById("export-button").onclick = function()
	{
		exportFrontDocument();
	};
	$(document).ready(function()
	{
	    $('.code').bind("input", function() {
			adjustActivateButton();
	    });

		$(".code").keyup(function (event)
		{
			adjustActivateButton();
			if ((event.keyCode == 13) && ((activationCodeCount() == 23) || (activationCodeCount() == 26)))
			{
				activateExtention();
			}
		});
	});
}

function extensionVersion()
{
    return "3.0.0.3";
}

function ignoreUpdate()
{
	runToolWithParameters(["-action","ignore-update",],function(resultDict) {
	});
}

function checkForUpdates()
{
	runToolWithParameters(["-action","check-for-updates",],function(resultDict) {

		if ("update-url" in resultDict)
		{
			var updateUrl;

			updateUrl = resultDict["update-url"];

			cs.evalScript("showUpdateWindow(\""+resultDict["update-version"].toString()+"\",\""+extensionVersion()+"\");",function(result){
				switch (parseInt(result))
				{
					case 1:
						cs.openURLInDefaultBrowser(resultDict["update-url"].toString());
						break;
					case 2:
						ignoreUpdate();
						break;
				}

			});
		}
	});
}

function setupActivation()
{
	checkActivation(function(result)
	{
		window.document.getElementById("load-screen").classList.add("hidden");

		if (result == 0)
		{
			showMainScreen();
			checkForUpdates();
		}
		else if (result == 1)
		{
			window.document.getElementById("activation-screen").classList.remove("hidden");
		}
		else if (result == 106)
		{
			$('#rebind-button').removeClass('disabled');
			$('#rebind-button').on('click', function()
			{
				rebind("");
			});

			window.document.getElementById("rebind-screen").classList.remove("hidden");
		}
		else
		{
			$('#refetch-button').removeClass('disabled');
			$('#refetch-button').on('click', function()
			{
				refetch();
			});
			window.document.getElementById("limbo-screen").classList.remove("hidden");
			window.document.getElementById("limbo-reason").innerHTML = errorCodeToString(result);
		}
	});
}

var isBusy = false;
function rebind(activationCode) {
	if ( ! isBusy)
	{
		isBusy = true;
		if (activationCode.length > 0)
		{
			screen_id = "activation-screen";
			spinner_id = "activation-loader";
			error_id = "activation-error";
			tool_params = ["-action","rebind","-code",activationCode];
		}
		else
		{
			screen_id = "rebind-screen";
			spinner_id = "rebind-loader";
			error_id = "rebind-error";
			tool_params = ["-action","rebind"];
		}
		window.document.getElementById(spinner_id).classList.remove("hidden");
		window.document.getElementById(error_id).classList.add("hidden");

		runToolWithParameters(tool_params,function(resultDict)
		{
			var resultCode = parseInt(resultDict["result"]);
			isBusy = false;
			window.document.getElementById(spinner_id).classList.add("hidden");

			switch (resultCode)
			{
				case 0:
					window.document.getElementById(screen_id).classList.add("hidden");
					showMainScreen();
					break;
				default:
					window.document.getElementById(error_id).innerHTML = "Activation failed: " +  errorCodeToString(resultCode) + ".";
					window.document.getElementById(error_id).classList.remove("hidden");
					break;
			}
		});
	}
}
function refetch() {
	if ( ! isBusy)
	{
		isBusy = true;
		base_screen_id = "limbo-screen";
		spinner_id = "refetch-loader";
		error_id = "refetch-error";

		window.document.getElementById(spinner_id).classList.remove("hidden");

		window.document.getElementById(error_id).classList.add("hidden");

		runToolWithParameters(["-action","refetch"],function(resultDict)
		{
            var resultCode = parseInt(resultDict["result"]);
			isBusy = false;
			window.document.getElementById(spinner_id).classList.add("hidden");

			switch (resultCode)
			{
				case 0:
					window.document.getElementById(base_screen_id).classList.add("hidden");
					showMainScreen();
					break;
				default:
					window.document.getElementById(error_id).innerHTML = "Check failed: " +  errorCodeToString(resultCode) + ".";
					window.document.getElementById(error_id).classList.remove("hidden");
					break;
			}
		});
	}
}



function activateExtention() {
	if ( ! isBusy)
	{
		isBusy = true;
		window.document.getElementById("activation-loader").classList.remove("hidden");
		var ac = window.document.getElementById("activation-code-field").value;
		runToolWithParameters(["-action","activate","-code",ac],function(resultDict)
		{
			var resultCode = parseInt(resultDict["result"]);
			isBusy = false;
			switch (resultCode)
			{
				case 0:
					window.document.getElementById("activation-loader").classList.add("hidden");
					window.document.getElementById("activation-screen").classList.add("hidden");
					window.document.getElementById("main-screen").classList.remove("hidden");
					break;
				case 106:
					showConfirmDialog("Your license has been activated on the maximum allowed number of computers. Would you like to de-activate it on one of the other other computers and activate it on this computer?", function(answer)
					{
						if (answer)
						{
							rebind(ac);
						}
						else
						{
							window.document.getElementById("activation-loader").classList.add("hidden");
						}
					});
					break;
				default:
					window.document.getElementById("activation-loader").classList.add("hidden");
					window.document.getElementById("activation-error").innerHTML = "Activation failed: " +  errorCodeToString(resultCode) + ".";
					window.document.getElementById("activation-error").classList.remove("hidden");
					break;
			}
		});
	}

}

var isProcessing = false;
function setIsProcessing(newValue)
{
	if (newValue != isProcessing)
	{
		isProcessing = newValue;
		if (isProcessing)
		{
			window.document.getElementById("small-loader").classList.remove('hidden');
			window.document.getElementById("last-savings-box").classList.add('hidden');
			window.document.getElementById("last-percentage-box").classList.add('hidden');
			window.document.getElementById("export-button").classList.add('disabled');
		}
		else
		{
			window.document.getElementById("small-loader").classList.add('hidden');
			window.document.getElementById("last-savings-box").classList.remove('hidden');
			window.document.getElementById("last-percentage-box").classList.remove('hidden');
			window.document.getElementById("export-button").classList.remove('disabled');
		}
	}
}

function exportFrontDocument()
{
	cs.evalScript("hasDocument();",function(hasDoc)
	{
		if (hasDoc == "true")
		{
			cs.evalScript("colorModeSupported();",function(colorMode)
			{
				if (colorMode.length == 0)
				{
					var lastPath;

					lastPath = localStorage.getItem("last-path");

					cs.evalScript("promptSavePath(\""+ lastPath + "\");",function(savePath)
					{
						if (savePath != "null")
						{
							localStorage.setItem("last-path", savePath.substring(0, savePath.lastIndexOf("/")));

							setIsProcessing(true);

							cs.evalScript("saveToTempAndConvertIfNeeded();",function(tempPath)
							{
								if (tempPath != "null")
								{
									reCompressJPEG(tempPath,function(recompressResult)
									{
										if (recompressResult == 0)
										{
											copyFile(tempPath, savePath,function(copyError)
											{
												var fs = require('fs');
												fs.unlinkSync(tempPath);

												if (copyError == null)
												{
													setIsProcessing(false);
												}
												else
												{
													setIsProcessing(false);
													showAlert("JPEG was not exported because copy to destination failed ("+copyError+").");
												}
											});
										}
										else
										{
											var fs = require('fs');
											fs.unlinkSync(tempPath);
											setIsProcessing(false);
											showAlert("JPEG export failed: " + errorCodeToString(recompressResult) + ".");
										}
									});
								}
								else
								{
									setIsProcessing(false);
									showAlert("JPEG was not exported because the document failed to convert to JPEG.");
								}
							});
						}
					});
				}
				else
				{
					setIsProcessing(false);
					showAlert("JPEGmini cannot export documents using the " + colorMode + " color mode.");
				}
			});
		}
	});
}


function activationCodeCount()
{
	var lc = $('#activation-code-field').val();
	return lc.length;
}

function adjustActivateButton()
{
	if ((activationCodeCount() == 23) || (activationCodeCount() == 26))
	{
		$('#activation-button').removeClass('disabled');
		$('#activation-button').on('click', function() {
			activateExtention();
		});
	}
	else
	{
		$('#activation-button').addClass('disabled');
	}
}
function dictionaryDescription(dictionary)
{
	var result = "";

	for (var key in dictionary)
	{
		if (result.length > 0)
		{
			result += ", ";
		}
 		result += key + ": " + dictionary[key];
	}
	return result;
}

cs.evalScript("setExtensionPath(\"" + cs.getSystemPath(SystemPath.EXTENSION) + "\");");
initialSetup();

setupActivation();
