function exportDocToJPEG(document, file)
{
	jpgSaveOptions = new JPEGSaveOptions();
	jpgSaveOptions.embedColorProfile = true;
	jpgSaveOptions.formatOptions = FormatOptions.STANDARDBASELINE;
	jpgSaveOptions.matte = MatteType.NONE;
	jpgSaveOptions.quality = 11;
	document.saveAs(	file, 
						jpgSaveOptions,
						true,
						Extension.LOWERCASE);
}

function tempFolderPath()
{
	var tfp = new File(Folder.temp.toString());
	
	return tfp.fsName;
}

function saveToTempAndConvertIfNeeded()
{
	var tf = new File(Folder.temp.toString() + "/jpegmini_temp.jpg");
	var document;
	var closeDocument = false;
			
	if (canExportFrontDocument() != 0)
	{
		document = app.activeDocument;
		document = document.duplicate();
		document.changeMode(ChangeMode.RGB);
		closeDocument = true;
	}
	else
	{
		document = app.activeDocument;
	}
	exportDocToJPEG(document, tf);
	if (closeDocument)
	{
		document.close(SaveOptions.DONOTSAVECHANGES)
	}

	return tf.fsName;
}

function hasDocument()
{
	return app.documents.length > 0;	
}

function colorModeSupported()
{
	if (app.activeDocument.mode == DocumentMode.BITMAP)
	{
		return "Bitmap";
	}
	return "";
}
function canExportFrontDocument()
{
	if (app.documents.length > 0)
	{
		var idoc = app.activeDocument;
		if (idoc.mode == DocumentMode.RGB)
		{
			return 0;
		}
		return 2;	// unsupported mode document
	}
	return 1;	// no front document
}

function promptSavePath(lastPath)
{
	if (app.documents.length > 0)
	{
		var idoc = app.activeDocument;
		var fileName;
		try {
			// fullName may not be set if the document has neven been saved
			fileName = idoc.fullName.toString();
			fileName = fileName.substr(0, fileName.lastIndexOf(".")) + ".jpg";
			if (lastPath.length > 0)
			{
				fileName = lastPath + "/" + fileName.substr(fileName.lastIndexOf("/")+1);
			}
		}
		catch (err)
		{
			fileName = "~/Desktop/untitled.jpg";
		}
		var thisFile = new File(fileName);  

		var ffp = thisFile.saveDlg("Export file to:");
		if (ffp)
		{
			return ffp.fsName;
		}
	}
	return null;
}

var extensionPath = "original value";
function setExtensionPath(value)
{
	extensionPath = value;
}

function show_update_window(title, heading, message)
{
	var result = 0;
	// DIALOG
	// ======
	var dialog = new Window("dialog"); 
		dialog.text = title; 
		dialog.orientation = "column"; 
		dialog.alignChildren = ["center","top"]; 
		dialog.spacing = 10; 
		dialog.margins = 16; 
		dialog.location = [250,150];
	// GROUP1
	// ======
	var group1 = dialog.add("group", undefined, {name: "group1"}); 
		group1.orientation = "row"; 
		group1.alignChildren = ["left","center"]; 
		group1.spacing = 10; 
		group1.margins = 0; 

		imagePath = extensionPath + "/images/icon_64x64.png";
		var image1 = group1.add("image", undefined, ScriptUI.newImage(imagePath,imagePath,imagePath,imagePath)); 
			image1.alignment = ["center","top"];
	// GROUP2
	// ======
	var group2 = group1.add("group", undefined, {name: "group2"}); 
		group2.preferredSize.width = 402; 
		group2.orientation = "column"; 
		group2.alignChildren = ["left","center"]; 
		group2.spacing = 10; 
		group2.margins = 0; 
 
	var statictext1 = group2.add("statictext", undefined, undefined, {name: "statictext1"}); 
		statictext1.text = heading; 

		statictext1.graphics.font = ScriptUI.newFont(statictext1.graphics.font.name,ScriptUI.FontStyle.BOLD,statictext1.graphics.font.size);

	var statictext2 = group2.add("statictext", undefined, undefined, {name: "statictext2", multiline: true}); 
		statictext2.text = message; 
		statictext2.preferredSize.width = 400; 
		statictext2.preferredSize.height = 60; 
 
	// GROUP3
	// ======
	var group3 = dialog.add("group", undefined, {name: "group3"}); 
		group3.orientation = "stack"; 
		group3.alignChildren = ["left","top"]; 
		group3.spacing = 0; 
		group3.margins = 0; 
		group3.alignment = ["fill","top"]; 
 
		var skipButton = group3.add("button", undefined, undefined, {name: "skipButton"}); 
			skipButton.text = "Skip This Version"; 
			skipButton.onClick = function(){
				result = 2;
				dialog.close();
			}

	// GROUP4
	// ======
	var group4 = group3.add("group", undefined, {name: "group4"}); 
		group4.orientation = "row"; 
		group4.alignChildren = ["left","center"]; 
		group4.spacing = 10; 
		group4.margins = 0; 
		group4.alignment = ["right","top"]; 

		var notNowButton = group4.add("button", undefined, undefined, {name: "notNowButton"}); 
			notNowButton.text = "Not Now";
			notNowButton.onClick = function(){
				result = 0;
				dialog.close();
			}


		var downloadButton = group4.add("button", undefined, undefined, {name: "downloadButton"}); 
			downloadButton.text = "Download Update"; 
			downloadButton.onClick = function(){
				result = 1;
				dialog.close();
			}
	dialog.show();
	
	return result;
}

function showUpdateWindow(newVersion, currentVersion)
{
	return show_update_window("Update Available","A New Version of JPEGmini for Photoshop is available", "Version "+newVersion+" of JPEGmini for Photoshop is now available. You are currently using version "+currentVersion+". Click \"Download Update\" to download the update");
}