--[[----------------------------------------------------------------------------
JPEGminiPlugInInit.lua
Copyright 2009-2013 ICVT Ltd. All rights reserved
------------------------------------------------------------------------------]]
require 'JPEGminiPluginManager'

local LrLogger = import 'LrLogger'
local LrHttp = import 'LrHttp'
local myLogger = LrLogger( 'libraryLogger' )
local LrDialogs = import 'LrDialogs'
local LrFunctionContext = import 'LrFunctionContext'
local LrView = import 'LrView'
local LrBinding = import 'LrBinding'
local Info = require 'Info.lua'


local function showUpdateAvailableDialog(dialog_title, dialog_message)
	local dialog_result = {}
	LrFunctionContext.callWithContext( "showUpdateAvailableDialog", function( context )
	    local f = LrView.osFactory()
	    local props = LrBinding.makePropertyTable( context )

		local c = f:column{
			bind_to_object = props,
			spacing = 0,
			f:row {
				f:column {
						f:picture {
							height = 80,
							width = 80,
							value = _PLUGIN.path .. "/can_big.png",
						}
				},
				f:column {
					f:row {
						height = 5
					},
					f:row {
						f:static_text {
							font = "<system/bold>",
							title = dialog_title
						},
					},
					f:row {

						f:static_text {
							width_in_chars = 35,
							height_in_lines = 4,
							font = "<system>",
							title = dialog_message
						}
					},
				}

			},
		}
		local modal_result;
		modal_result = LrDialogs.presentModalDialog {
			title = "Update Available",
			contents = c,
			actionVerb = "Download Update",
			cancelVerb = "Not Now",
			otherVerb = "Skip This Version",
		}
		if modal_result == "ok" then
			dialog_result = "download"
		elseif modal_result == "cancel" then
			dialog_result = "cancel"
		else
			dialog_result = "skip"
		end
	end) -- end main function
	return dialog_result;
end


myLogger:enable( "print" ) -- or "logfile"
_G.activationStatus = 0
import "LrTasks".startAsyncTask(function()
	if PluginManager.executeCommand({action="check"},false) == 0 then
		_G.activationStatus = 1
	else
		_G.activationStatus = -1
	end
	
	local update_info = PluginManager.executeCommand({action="check-for-updates"},true);
	if update_info["update-url"] ~= nil then
		local current_version = Info["VERSION"]["major"] .. "." .. Info["VERSION"]["minor"] .. "." .. Info["VERSION"]["revision"] 
		local dialog_result = showUpdateAvailableDialog("A New Version of JPEGmini for Lightroom is available", "Version " .. update_info["update-version"] .. " of JPEGmini for Lightroom is now available. You are currently using version " .. current_version .. ". Click \"Download Update\" to download the update")
		if dialog_result == "download" then
			LrHttp.openUrlInBrowser(update_info["update-url"])
		elseif dialog_result == "skip" then
			PluginManager.executeCommand({action="ignore-update"},false)
		end
	end
	
	
end)
