/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.xmlParser;

import java.util.ArrayList;
import net.sourceforge.jocular.objects.OpticsID;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.positioners.ObjectPositionerKey;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.xmlParser.AbstractJclXMLParentElement;
import net.sourceforge.jocular.xmlParser.JclXMLElement;
import net.sourceforge.jocular.xmlParser.JclXmlPropertyElement;
import org.xml.sax.Attributes;

public class PositionerElement
extends AbstractJclXMLParentElement {
    protected final OpticsID id;
    protected final String type;
    protected ArrayList<JclXmlPropertyElement> m_basicElements = new ArrayList();

    public PositionerElement(String tag, Attributes attr) {
        super(tag, attr);
        this.id = new OpticsID(attr);
        this.type = attr.getValue(1);
    }

    public OpticsID getID() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public JclXMLElement getChildElement(String qName, Attributes attr) {
        if (qName.equalsIgnoreCase("property")) {
            JclXmlPropertyElement element = new JclXmlPropertyElement(attr.getValue(0));
            this.m_basicElements.add(element);
            return element;
        }
        return null;
    }

    public JclXmlPropertyElement getElement(String key) {
        for (JclXmlPropertyElement element : this.m_basicElements) {
            if (!element.getTag().equals(key)) continue;
            return element;
        }
        return null;
    }

    public ArrayList<JclXmlPropertyElement> getElements() {
        return this.m_basicElements;
    }

    public ObjectPositioner getPositioner() {
        ObjectPositionerKey positionerKey = ObjectPositionerKey.getKey(this.type);
        if (positionerKey != null) {
            ObjectPositioner positioner = positionerKey.getNewPositioner();
            positioner.setID(this.id);
            for (JclXmlPropertyElement element : this.getElements()) {
                PropertyKey key = PropertyKey.getKey(element.getTag());
                if (key == null) continue;
                positioner.setProperty(key, element.getValue());
            }
            return positioner;
        }
        return null;
    }
}

