/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.xmlParser;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.jocular.JocularFileParsingException;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.xmlParser.OpticsProjectXmlHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class OpticsProjectXmlParser {
    private static String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String SCHEMA = "/net/sourceforge/jocular/Jocular.xsd";

    public static OpticsProject parseProjectFile(String fileName) throws IOException, JocularFileParsingException {
        XMLReader xmlReader;
        OpticsProjectXmlHandler handler = new OpticsProjectXmlHandler();
        try {
            xmlReader = OpticsProjectXmlParser.getXMLReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            String message = "Failed to configure file parser";
            throw new JocularFileParsingException(message);
        }
        catch (URISyntaxException e) {
            String message = "Failed to find schema";
            throw new JocularFileParsingException(message);
        }
        xmlReader.setContentHandler(handler);
        xmlReader.setErrorHandler(new MyErrorHandler(System.err));
        try {
            xmlReader.parse(fileName);
        }
        catch (SAXException e) {
            String message = "XML Parser exception!\n";
            message = message.concat(e.getMessage());
            throw new JocularFileParsingException(message);
        }
        OpticsProject project = handler.getProject();
        project.setFileName(fileName);
        return project;
    }

    private static XMLReader getXMLReader() throws URISyntaxException, ParserConfigurationException, SAXException {
        InputStream schemaIS = OpticsProjectXmlParser.class.getResourceAsStream(SCHEMA);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.setProperty(SCHEMA_LANGUAGE, XML_SCHEMA);
        saxParser.setProperty(SCHEMA_SOURCE, schemaIS);
        XMLReader xmlReader = saxParser.getXMLReader();
        return xmlReader;
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private PrintStream out;

        MyErrorHandler(PrintStream out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "\tURI=" + systemId + "\n\tLine=" + spe.getLineNumber() + "\n\t" + spe.getMessage();
            return info;
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("\tWarning\n" + this.getParseExceptionInfo(spe));
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "\tError\n" + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "\tFatal Error\n" + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

