/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.xmlParser;

import net.sourceforge.jocular.objects.ProjectRootGroup;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.xmlParser.AbstractJclXMLParentElement;
import net.sourceforge.jocular.xmlParser.JclXMLElement;
import net.sourceforge.jocular.xmlParser.OpticsObjectElement;
import org.xml.sax.Attributes;

public class OpticsProjectElement
extends AbstractJclXMLParentElement {
    private static String FILE_VERSION_STRING = "version";
    private String parsedVersion;
    private OpticsProject project;
    private OpticsObjectElement m_groupElement;

    public OpticsProjectElement(Attributes attr) {
        super("opticsProject", attr);
        this.parsedVersion = this.parseFileVersion(attr);
    }

    @Override
    public JclXMLElement getChildElement(String qName, Attributes attr) {
        if (this.handler != null) {
            return this.handler.getChildElement(qName, attr);
        }
        if (qName.equalsIgnoreCase("ROOT_GROUP")) {
            this.m_groupElement = new OpticsObjectElement(qName, attr);
            return this.m_groupElement;
        }
        return null;
    }

    @Override
    public boolean endElement(String qName) {
        if (!super.endElement(qName)) {
            return false;
        }
        this.buildOpticsProjectObject();
        return true;
    }

    public OpticsProject getProject() {
        if (this.project == null) {
            throw new NullPointerException("Project was not created yet");
        }
        return this.project;
    }

    private void buildOpticsProjectObject() {
        this.project = new OpticsProject();
        this.checkFileVersion(this.project);
        ProjectRootGroup g = (ProjectRootGroup)this.m_groupElement.getOpticsObject();
        this.project.addRootGroup(g);
    }

    private String parseFileVersion(Attributes attr) {
        int attrLength = attr.getLength();
        for (int i = 0; i < attrLength; ++i) {
            if (attr.getQName(i) != FILE_VERSION_STRING) continue;
            return attr.getValue(i);
        }
        return "";
    }

    private void checkFileVersion(OpticsProject project) {
        if (!this.parsedVersion.equals(project.getVersion())) {
            System.out.println("Parsed project does not match current version!");
            System.out.println("Parsed project version: " + this.parsedVersion);
            System.out.println("Current project version: " + project.getVersion());
        } else {
            System.out.println("Project version matches at: " + this.parsedVersion);
        }
    }
}

