/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.xmlParser;

import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.objects.OpticsObjectKey;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.xmlParser.AbstractJclXmlObjectElement;
import net.sourceforge.jocular.xmlParser.JclXMLElement;
import net.sourceforge.jocular.xmlParser.JclXmlPropertyElement;
import org.xml.sax.Attributes;

public class OpticsObjectElement
extends AbstractJclXmlObjectElement {
    private Collection<OpticsObjectElement> m_objectElements = new ArrayList<OpticsObjectElement>();

    public OpticsObjectElement(String tag, Attributes attr) {
        super(tag, attr);
    }

    @Override
    public JclXMLElement getChildElement(String qName, Attributes attr) {
        JclXMLElement child = super.getChildElement(qName, attr);
        if (child == null) {
            OpticsObjectElement element = new OpticsObjectElement(qName, attr);
            this.m_objectElements.add(element);
            return element;
        }
        return child;
    }

    @Override
    public OpticsObject getOpticsObject() {
        OpticsObjectKey objectKey = OpticsObjectKey.getKey(this.m_tag);
        if (objectKey != null) {
            OpticsObject object = objectKey.getNewObject();
            object.setID(this.id);
            object.setPositioner(this.m_positionerElement.getPositioner());
            for (OpticsObjectElement objectElement : this.m_objectElements) {
                ((OpticsObjectGroup)object).addToEnd(objectElement.getOpticsObject());
            }
            for (JclXmlPropertyElement element : this.getElements()) {
                PropertyKey key = PropertyKey.getKey(element.getTag());
                if (key == null) continue;
                object.setProperty(key, element.getValue());
            }
            return object;
        }
        return null;
    }
}

