/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.xmlParser;

import java.io.IOException;
import java.io.PrintStream;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.objects.OpticsObjectKey;
import net.sourceforge.jocular.objects.OpticsPart;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.positioners.ObjectPositionerKey;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.xmlParser.JclXmlPropertyElement;

public class JclXmlWriter {
    private final String XML_STANDARD_HEADING = "<?xml version=\"1.0\"?>";
    private int tabLevel = 0;
    String fileName;
    private PrintStream m_output;

    public JclXmlWriter() {
        this.m_output = System.out;
    }

    public JclXmlWriter(String fileName) {
        this.fileName = fileName;
    }

    public void visit(OpticsProject project) {
        this.tabLevel = 0;
        try {
            this.m_output = new PrintStream(this.fileName);
        }
        catch (IOException e) {
            System.out.println("Failed to open file " + this.fileName);
            this.m_output = null;
        }
        this.writeLine("<?xml version=\"1.0\"?>");
        this.writeLine("<opticsProject version=\"" + project.getVersion() + "\">");
        ++this.tabLevel;
        this.writeOpticsObject(project.getOpticsObject());
        --this.tabLevel;
        this.writeLine("</opticsProject>");
        this.m_output.close();
    }

    private void writeOpticsObject(OpticsObject optics) {
        String tag = OpticsObjectKey.getKeyName(optics);
        this.writeLine("<" + tag + " id=\"" + optics.getID().toString() + "\">");
        ++this.tabLevel;
        for (PropertyKey key : optics.getPropertyKeys()) {
            this.writeLine(JclXmlPropertyElement.getXmlElement(key.name(), optics.getProperty(key).getDefiningString()));
        }
        if (optics instanceof OpticsObjectGroup && !(optics instanceof OpticsPart)) {
            for (OpticsObject oo : ((OpticsObjectGroup)optics).getObjects()) {
                this.writeOpticsObject(oo);
            }
        }
        this.writePositioner(optics.getPositioner());
        --this.tabLevel;
        this.writeLine("</" + tag + ">");
    }

    private void writePositioner(ObjectPositioner pos) {
        String type = ObjectPositionerKey.getKeyName(pos);
        this.writeLine("<positioner id=\"" + pos.getID().toString() + "\" type=\"" + type + "\">");
        ++this.tabLevel;
        for (PropertyKey key : pos.getPropertyKeys()) {
            this.writeLine(JclXmlPropertyElement.getXmlElement(key.name(), pos.getProperty(key).getDefiningString()));
        }
        --this.tabLevel;
        this.writeLine("</positioner>");
    }

    private void writeLine(String s) {
        this.insertTabs();
        this.m_output.println(s);
    }

    private void insertTabs() {
        int i = 0;
        while (i < this.tabLevel) {
            this.m_output.print("\t");
            ++i;
        }
    }
}

