/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Utils {
    public static BufferedImage getImage(Component c) {
        Dimension d = c.getSize();
        BufferedImage result = new BufferedImage(d.width, d.height, 1);
        Graphics2D g = result.createGraphics();
        c.paint(g);
        return result;
    }

    public static String getExtension(String filename) {
        int index;
        int lastWindowsPos;
        if (filename == null) {
            return null;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastUnixPos = filename.lastIndexOf(47);
        int lastSeparator = Math.max(lastUnixPos, lastWindowsPos = filename.lastIndexOf(92));
        int n = index = lastSeparator > extensionPos ? -1 : extensionPos;
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static File addExtensionIfNecesary(File f, String extension) {
        File result = f;
        if (Utils.getExtension(f.getAbsolutePath()).equals("")) {
            result = new File(f.getAbsolutePath() + "." + extension);
        }
        return result;
    }

    public static File chooseFile(Component owner, String extension, String title, String approveButtonText, boolean checkIfExists, File directory) {
        File result = null;
        boolean done = false;
        FileNameExtensionFilter ff = new FileNameExtensionFilter(extension + " File", extension);
        JFileChooser jfc = Utils.getFileChooser(ff, "Select File to save data to");
        if (directory != null) {
            jfc.setCurrentDirectory(directory);
        }
        jfc.setDialogTitle(title);
        while (!done) {
            if (jfc.showDialog(owner, approveButtonText) == 0) {
                result = jfc.getSelectedFile();
                if (result != null && !ff.accept(result)) {
                    result = new File(result.getAbsolutePath() + "." + extension);
                }
            } else {
                done = true;
            }
            if (result != null && checkIfExists && result.exists()) {
                int choice = JOptionPane.showConfirmDialog(owner, "File with name \"" + result.getName() + "\" exists.\n Overwrite?");
                switch (choice) {
                    case 0: {
                        done = true;
                        break;
                    }
                    case 2: {
                        done = true;
                        result = null;
                        break;
                    }
                }
                continue;
            }
            done = true;
        }
        return result;
    }

    private static JFileChooser getFileChooser(FileFilter filt, String title) {
        JFileChooser jfc = new JFileChooser();
        jfc.resetChoosableFileFilters();
        File f = jfc.getCurrentDirectory();
        jfc.setCurrentDirectory(f);
        jfc.setSelectedFile(new File(""));
        Dimension d = new Dimension(460, 600);
        jfc.setPreferredSize(d);
        jfc.setFileFilter(filt);
        jfc.setDialogTitle(title);
        return jfc;
    }
}

